<?php
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: toprated.inc
 *    Description:  Gets data for toprated.module - displays highest rated media on 'Top Rated' page
 *    $Date: 2010-03-08 00:21:13 +0000 (Mon, 08 Mar 2010) $
 *    $Revision: 45 $
 */
function topRatedmedia() {
	global $db,$templateimagepath,$sitepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/toprated_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = topRatedmedia_new() ;
	}
	else {
		if (checkHideMedia() == 1) {
			$hide = " AND (`requires_agreement` = 0)" ;
		}
		else {
			$hide = "" ;
		}
		$db->query("SELECT v.*, g.*, (r.total_value/r.total_votes) as rating FROM media v LEFT JOIN rating r ON r.id = v.id LEFT JOIN `group` g ON g.group_id = v.groupid WHERE v.status = 'true' AND (`suspended`!=1 OR `suspended` IS NULL)".$hide." ORDER BY (r.total_value/r.total_votes) DESC LIMIT 100") ;
		$resTR = $db->fetchAll() ;
		if (getSetting("toprated_page_table_layout", $db) == 1) {
			if (isset($_GET['page']))
				$output = displayTopRatedInTable($resTR, $_GET['page'], $sitepath."top_rated", true) ;
			else
				$output = displayTopRatedInTable($resTR, 1, $sitepath."top_rated", true) ;
		}
		else {
			if (isset($_GET['page']))
				$output = displayTopRated($resTR, $_GET['page'], $sitepath."top_rated", true) ;
			else
				$output = displayTopRated($resTR, 1, $sitepath."top_rated", true) ;
		}
	}
	return $output ;
}
function displayTopRated($res, $page = 1, $url = "", $showad = false) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	if ($loggedIn) {
		$db->query("SELECT id FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$ures = $db->fetch() ;
		$memberid = $ures['id'] ;
		$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
		$groupmembership = $db->fetchAll() ;
	}
	$vidcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$vidcount++ ;
			}
		}
	}
	if ($showad) {
		$db->query("SELECT * FROM sitead WHERE adname='ad2'") ;
		if ($db->numRows() > 0) {
			$ares = $db->fetch() ;
			$adtext = $ares['adtext'] ;
		}
	}
	if ($adtext != '') {
		$adtext = '<div id="horizbanner">'.$adtext.'</div>' ;
	}
	$perpage = getSetting("topratedpp", $db) ;
	$pages = ceil($vidcount / $perpage) ;
	$path = getSetting("sitefolder", $db) ;
	$pageLinks = "" ;
	//Page formatting
	if ($pages > 0) {
		$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
	}
	else {
		$pageLinks = "<div><div><div><div>" ;
	}
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
		else {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
		else {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
	}
	$pageLinks .= "</div></div></div></div>" ;
	$output = '<ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$count++ ;
				$thumbpath = 'uploads/thumbs/' ;
				$thumb = '' ;
				$anim = '' ;
				if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (file_exists($thumbpath.$value['thumb'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
						if (file_exists($thumbpath.$value['thumb'].".prv")) {
							$anim = $sitepath."uploads/thumbs/".$value['thumb'] ;
						}
					}
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
						$anim = $sitepath."uploads/thumbs/".$value['mediaurl'] ;
					}
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
						$anim = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					if ($thumb == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
				}
				$kat = getCategoryPath($value['category']) ;
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$title = url_encode($value['title']) ;
				$short_title = force_length($value['title'], 55) ;
				$output .= "<li>" ;
				//thumbnail
				if ($anim != "" && checkfeature('Video Preview Thumbnails', 18)) {
					$output .= "<div class=\"thumbholder\" id='thumb".$count."' onmouseover='replace_thumb(".$count.", \"<a href=&#39;play".$kat."/".$title."&#39;><img src=&#39;".$thumb."&#39;></a>\");'>" ;
					$output .= "<a href='play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
					$output .= "<h3>" ;
					$output .= "<img class=\"preview\" onmouseover='start_thumb(".$count." ,\"".$anim."\")' src=\"".$templateimagepath."preview_box.png\">" ;
				}
				else {
					$output .= "<div class=\"thumbholder\" id='thumb".$count."'>" ;
					$output .= "<a href='play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
					$output .= "<h3>" ;
				}
				$output .= "&nbsp;&nbsp;<b><a href=\"play$kat/$title\">".str_replace("_", " ", $short_title)."</a></b></h3>" ;
				
				$value['description'] = force_length($value['description'], 130) ;
				$output .= "<h4><b>&nbsp;&nbsp;&nbsp;".$value['description']."</b></h4>" ;
				$tags = strtolower($value['tags']) ;
				$taglinks = getTagLinks($tags) ;
				if (str_replace(" ", "", $tags) != '') {
					$output .= "<p>&nbsp;&nbsp;&nbsp;tags: $taglinks</p>" ;
				}
				else {
					$output .= "<p>&nbsp;</p>" ;
				}
				$output .= "<div class=\"inf\"><div class=\"inf-right\"><b>From <a href=\"".$sitepath."profile/".$value['poster']."\">".$value['poster']."</a> on:</b> ".date("m.d.y", $value['added'])." <b> Rating: </b><span class=\"rating\">".show_rating($value['id'])."</span><span class=\"views\"><b>views:</b> ".$value['allviews'] ;
				$output .= "</span></div></div>" ;
				$output .= "</li>\n" ;
				if (($count == 3) && ($showad) && (str_replace(" ", "", $adtext) != '')) {
					$output .= '<li class="alt"><div align=center>'.$adtext.'</div></li><br><br>' ;
				}
				if ($count == $perpage)
					break ;
			}
		}
	}
	$output .= "</ul>" ;
	if ($pages != 1)
		$output .= $pageLinks ;
	return $output ;
}
function displayTopRatedInTable($res, $page = 1, $url = "", $showad = false) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	if ($loggedIn) {
		$db->query("SELECT id FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$ures = $db->fetch() ;
		$memberid = $ures['id'] ;
		$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
		$groupmembership = $db->fetchAll() ;
	}
	$vidcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$vidcount++ ;
			}
		}
	}
	if ($showad) {
		$db->query("SELECT * FROM sitead WHERE adname='ad2'") ;
		if ($db->numRows() > 0) {
			$ares = $db->fetch() ;
			$adtext = $ares['adtext'] ;
		}
	}
	if ($adtext != '') {
		$adtext = '<div id="horizbanner">'.$adtext.'</div>' ;
	}
	$perpage = getSetting("topratedpp", $db) ;
	$pages = ceil($vidcount / $perpage) ;
	$path = getSetting("sitefolder", $db) ;
	$pageLinks = "" ;
	//Page formatting
	if ($pages > 0) {
		$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
	}
	else {
		$pageLinks = "<div><div><div><div>" ;
	}
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
		else {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
		else {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
	}
	$pageLinks .= "</div></div></div></div>" ;
	$output = '<ul class="no-format horiz2-thumbs-list">' ;
	$count = 0 ;
	$colcount = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$count++ ;
				$colcount++ ;
				if ($colcount > 4) {
					$colcount = 0 ;
					$output .= '</ul><ul class="no-format horiz2-thumbs-list">' ;
				}
				$thumb = '' ;
				$anim = '' ;
				$thumbpath = 'uploads/thumbs/' ;
				if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (file_exists($thumbpath.$value['thumb'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
						if (file_exists($thumbpath.$value['thumb'].".prv")) {
							$anim = $sitepath."uploads/thumbs/".$value['thumb'] ;
						}
					}
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
						$anim = $sitepath."uploads/thumbs/".$value['mediaurl'] ;
					}
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					if ($thumb == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
				}
				$kat = getCategoryPath($value['category']) ;
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$title = url_encode($value['title']) ;
				$output .= "<li>" ;
				//thumbnail
				if ($anim != "" && checkfeature('Video Preview Thumbnails', 18)) {
					$output .= "<div class=\"thumbholder\" id='thumb".$count."' onmouseover='replace_thumb(".$count.", \"<a href=&#39;".$sitepath."play".$kat."/".$title."&#39;><img src=&#39;".$thumb."&#39;></a>\");'>" ;
					$output .= "<a href='".$sitepath."play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
					$output .= "<img class=\"preview\" onmouseover='start_thumb(".$count." ,\"".$anim."\")' src=\"".$templateimagepath."preview_box.png\">" ;
				}
				else {
					$output .= "<div class=\"thumbholder\" id='thumb".$count."'>" ;
					$output .= "<a href='".$sitepath."play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
				}
				$short_title = force_length($value['title'], 55) ;
				$value['description'] = force_length($value['description'], 130) ;
				$output .= "<h4><b><a href='".$sitepath."play".$kat."/".$title."'>".str_replace("_", " ", $short_title)."</a></b></h4><h4>".$value['description']."</h4><div><p><span class=\"rating\">".show_rating($value['id'])."</span></p></div>" ;
				$output .= "</li>\n" ;
				if (($count == 4) && ($showad) && (str_replace(" ", "", $adtext) != '')) {
					$output .= '</ul><ul class="no-format horiz3-thumbs-list"><li class="alt"><div align=center>'.$adtext.'</div></li>' ;
					$colcount = 4 ;
				}
				if ($count == $perpage)
					break ;
			}
		}
	}
	$output .= "<li class=\"clear\">&nbsp;</li>" ;
	$output .= "</ul>" ;
	if ($pages != 1)
		$output .= $pageLinks ;
	return $output ;
}
?>