<?php 
/*
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: register.inc
 *    Description:  Member registration
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
global $sitepath ;
//Check if we are receiving form data
//Start with no problems
$validated = True ;
if (isset($_POST['userr'])) {
	if ( empty($_POST['userr']))
		$validated = False ;
	else
		$username = $_POST['userr'] ;
	/* Check for values in all fields */
	if (!isset($_POST['pass']) || empty($_POST['pass']))
		$validated = False ;
	else
		$pass = $_POST['pass'] ;
	if (!isset($_POST['passconfirm']) || empty($_POST['passconfirm']))
		$validated = False ;
	else
		$passconfirm = $_POST['passconfirm'] ;
	if (!isset($_POST['email']) || empty($_POST['email']))
		$validated = False ;
	else
		$email = $_POST['email'] ;
	if (!isset($_POST['emailconfirm']) || empty($_POST['emailconfirm']))
		$validated = False ;
	else
		$emailconfirm = $_POST['emailconfirm'] ;
	$age = quote_smart($_POST['age']) ;
	$location = quote_smart($_POST['location']) ;
	$gender = quote_smart($_POST['gender']) ;
	if ($gender == '') {
		$gender = 0 ;
	}
	if (!$validated)
		$errorMsg = "You must fill in all fields!" ;
	/* Check the passwords and emails match */
	if ($validated) {
		if (strcmp($pass, $passconfirm) != 0 && $validated) {
			$validated = False ;
			$errorMsg = "The passwords you entered did not match!" ;
		}
		if (strcmp($email, $emailconfirm) != 0 && $validated) {
			$validated = False ;
			$errorMsg = "The E-Mail addresses you entered did not match!" ;
		}
	}
	/* If we are still validated up to here we can check the username isnt taken */
	if ($validated) {
		$usernamedb = $username ;
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($usernamedb)."'") ;
		$memcheck = $db->fetch() ;
		if (isset($memcheck['id'])) {
			$validated = False ;
			$errorMsg = "This username has already been taken" ;
		}
	}
	//Check for dupilcate email address
	if ($validated) {
		$db->query("SELECT * FROM `member` WHERE `email` = '".quote_smart($email)."';") ;
		if ($db->numrows() > 0) {
			$validated = false ;
			$errorMsg = "Email address has already been registerd" ;
		}
	}
	/* Check for special chars */
	if ($validated) {
		$checkname = preg_replace('/[^a-zA-Z0-9\-]/', '', $usernamedb) ;
		if ($checkname != $usernamedb) {
			$validated = False ;
			$errorMsg = "Your username may only contain the letters a-z, A-Z, numbers, and the hyphen symbol \"-\"" ;
		}
		if ($validated && strlen($usernamedb) > 32) {
			$validated = False ;
			$errorMsg = "Your username must be a maximum of 32 characters long!" ;
		}
	}
	/* If we have reached here and have had no validation errors add the new user in */
	if ($validated) {
		$password = md5($pass) ;
		$email = $email ;
		$privs = 1 ;
		$optin = isset($_POST['optin']) ? 1 : 0 ;
		//Activation?
		$activation = getSetting("activation", $db) ;
		if ($activation == "1") {
			$actkey = md5(uniqid(rand())) ;
			$db->query("INSERT INTO member (username,password,email,activationkey,privs, `opt`,created,location,age,gender) VALUES ('".quote_smart($usernamedb)."','".quote_smart($password)."','".quote_smart($email)."','$actkey',$privs, ".$optin.",'".time()."','".$location."','".$age."',".$gender.")") ;
			$message = getEmail("email_activate") ;
			$message = str_replace("[SITEURL]", "http://".$_SERVER['SERVER_NAME'], $message) ;
			$message = str_replace("[ACTLINK]", $sitepath."?id=10&u=".$db->getLastId()."&key=".$actkey, $message) ;
			$message = str_replace("[SITENAME]", getSetting("sitename", $db), $message) ;
			$headers = "From: \"".getSetting("default_from", $db)."\" <".getSetting("contact_email", $db).">>\r\n"."Reply-To: ".getSetting("contact_email", $db)."\r\n"."X-Mailer: PHP/".phpversion() ;
			$ans = mymail(array(array("email"=>$email, "name"=>$usernamedb)), 'Activation required', $message, $headers) ;
			echo $ans."<br>" ;
			echo "<div id=\"newRegistration\"><p class=\"phrase\">An e-mail has been sent to the address you supplied with instructions on how to complete the registration process.<br/>Thankyou for registering.</p></div>" ;
			$halt = true ;
		}
		else {
			$db->query("INSERT INTO member (username,password,email,activationkey,privs,created, opt,location,age,gender) VALUES ('$usernamedb','$password','$email','0',$privs, ".$optin.",'".time()."','".$location."','".$age."',".$gender.")") ;
			$isLogged = $user->_checkLogin($username, $pass, False) ;
			if ($isLogged == 0) {
				echo "<meta http-equiv=\"refresh\" content=\"0; URL='index.php'\">" ;
			}
		}
	}
}
?>