<?php
/*
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: profile.inc
 *    Description:  Display a member's profile
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
global $db,$sitepath,$loggedIn,$templateimagepath ;
if (isset($_GET['user'])) {
	$db->query("SELECT * FROM member WHERE username = '".$_GET['user']."'") ;
	$idres = $db->fetch() ;
	$profileid = $idres['id'] ;
	$avatarname = $idres['avatar'] ;
	$avatargender = $idres['gender'] > 0 ? 'female' : 'male' ;
}
$db->query("SELECT * FROM member WHERE username = '".$_SESSION['username']."'") ;
$userres = $db->fetch() ;
$userid = $userres['id'] ;
$fromID = $userid ;
$toID = $profileid ;
$avatarpath = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
if (@file_exists("uploads/avatars/".$avatarname) && ($avatarname != "")) {
	$avatarpath = "uploads/avatars/".$avatarname ;
	$avatarpath = $sitepath.str_replace(" ", "%20", $avatarpath) ;
}
$userandavatar = '<a href="'.$sitepath.'profile/'.$_GET['user'].'"><img src="'.$avatarpath.'" border=0 height=22px width=22px>'.$_GET['user'].'&nbsp;</a>' ;
//send message
if (isset($_POST['submit']) && ($_POST['type'] == 'sendmessage') && (canMessage() == '') && ($loggedIn)) {
	$messagebody = quote_smart($_POST['msgbody']) ;
	$messagebody = apply_word_censor($messagebody) ;
	$db->query("INSERT INTO message (fromid, toid, body, sentdate, msgread) VALUES (".quote_smart($_POST['from']).",".quote_smart($_POST['to']).",'".$messagebody."',".time().",0)") ;
	$message = "Thank you, your message has been sent to <a href=\"".$sitepath."profile/".$_GET['user']."\">".$_GET['user']."</a>" ;
}
if (($loggedIn) && ($profileid != 0) && ($userid != 0)) {
	$action = $_GET['act'] ;
	//arr - Accept request from profile member
	if ($action == 'arr') {
		//update friend record where userid = loggedinuser and friendid = profileuser to approved = 0, removed = 0
		$db->query('UPDATE friend SET friend_approved = 1 WHERE userid='.$userid.' AND friendid='.$profileid) ;
		$db->query('UPDATE friend SET friend_removed = 0 WHERE userid='.$userid.' AND friendid='.$profileid) ;
	}
	//rfa - Profile member removed you - click here to ask again
	if ($action == 'rfa') {
		//delete old friend record where userid = loggedinuser and friendid = profileuser
		$db->query('DELETE FROM friend WHERE userid='.$userid.' AND friendid='.$profileid) ;
		//insert new friend record with userid = profileuser, friendid = loggedinuser, approved = 0, removed = 0
		$db->query('INSERT INTO friend (userid,friendid,friend_approved,friend_removed) VALUES ('.$profileid.','.$userid.',0,0)') ;
	}
	//csr - Your sent request is pending - cancel the request
	if ($action == 'csr') {
		//delete friend record where userid = profileuser and friendid = loggedinuser
		$db->query('DELETE FROM friend WHERE userid='.$profileid.' AND friendid='.$userid) ;
	}
	//rmaf - You have removed this friend request - this just removes the remove! Makes it a live request again
	if ($action == 'rmaf') {
		//update where userid = profileuser and friendid = loggedinuser set removed = 0
		$db->query('UPDATE friend SET friend_removed = 0 WHERE userid='.$profileid.' AND friendid='.$userid) ;
	}
	//af - Send a request to profile user
	if ($action == 'af') {
		//check there isn't already a record
		$db->query('SELECT * FROM friend WHERE userid='.$profileid.' AND friendid='.$userid) ;
		if ($db->numRows() < 1) {
			$db->query('INSERT INTO friend (userid,friendid,friend_approved,friend_removed) VALUES ('.$profileid.','.$userid.',0,0)') ;
		}
		else {
			//if already sent, just update it
			$db->query('UPDATE friend SET friend_removed = 0 WHERE userid='.$profileid.' AND friendid='.$userid) ;
		}
	}
	//afr - Remove approved friend
	if ($action == 'afr') {
		//Remove: check if i am the original requester
		$db->query('SELECT * FROM friend WHERE userid='.$profileid.' AND friendid='.$userid) ;
		if ($db->numRows() > 0) {
			//if i am, just make it 'removed = 1 approved = 0' goes back to a request, but removed
			$db->query('UPDATE friend SET friend_removed = 1 WHERE userid='.$profileid.' AND friendid='.$userid) ;
			$db->query('UPDATE friend SET friend_approved = 0 WHERE userid='.$profileid.' AND friendid='.$userid) ;
		}
		else {
			//if i'm not, need to reverse (delete and insert) the request, removed =1 approved = 0
			$db->query('DELETE FROM friend WHERE userid='.$userid.' AND friendid='.$profileid) ;
			$db->query('INSERT INTO friend (userid,friendid,friend_approved,friend_removed) VALUES ('.$profileid.','.$userid.',0,1)') ;
		}
	}

	if ($action == 'bl') {
		$db->query('SELECT * FROM blocked WHERE blocker_id='.$userid.' AND blockee_id='.$profileid) ;
		if ($db->numRows() < 1) {
			$db->query('INSERT INTO blocked (blocker_id,blockee_id) VALUES ('.$userid.','.$profileid.')') ;
		}
	}
	if ($action == 'sb') {
		$db->query('SELECT * FROM subscription WHERE userid='.$userid.' AND subscribedtoid='.$profileid) ;
		if ($db->numRows() < 1) {
			$db->query('INSERT INTO subscription (userid,subscribedtoid) VALUES ('.$userid.','.$profileid.')') ;
		}
	}
	if ($action == 'ub') {
		$db->query('DELETE FROM blocked WHERE blocker_id='.$userid.' AND blockee_id='.$profileid) ;
	}
	if ($action == 'us') {
		$db->query('DELETE FROM subscription WHERE userid='.$userid.' AND subscribedtoid='.$profileid) ;
	}
}
function subscriptionsList($res, $page, $url) {
	global $db,$sitepath,$templateimagepath ;
	$perpage = getSetting("profsubspp", $db) ;
	$size = sizeof($res) ;
	$pages = ceil(sizeof($res) / $perpage) ;
	$pageLinks = "<div align=right>Pages: " ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= '<a class="prevp" style="cursor: hand; cursor: pointer;" onClick="doSub(\''.$_GET['user'].'\',\''.$pp.'\');">Previous Page </a>' ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= '<a title="1" style="cursor: hand; cursor: pointer;" onClick="doSub(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
		else {
			$pageLinks .= '<a title="1" style="cursor: hand; cursor: pointer;" onClick="doSub(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doSub(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doSub(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doSub(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
		else {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doSub(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= '<a class="nextp" style="cursor: hand; cursor: pointer;" title="'.$np.'" onClick="doSub(\''.$_GET['user'].'\',\''.$np.'\');"> Next Page</a>' ;
	}
	$pageLinks .= "</div>" ;
	$output = '<div class="tab-cont"><ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	$colcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['activationkey'] == 0) {
			$count++ ;
			$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
			$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
			if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
				$avatar = $sitepath."uploads/avatars/".$value['avatar'] ;
			}
			$avatar = str_replace(" ", "%20", $avatar) ;
			$id = $value['id'] ;
			$username = $value['username'] ;
			$db->query("SELECT id FROM media WHERE status='true' AND poster ='".$username."'".$hide." ORDER BY allviews DESC") ;
			$mediacount = $db->numRows() ;
			$rres = $db->fetch() ;
			$db->query("SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$id." OR friend.friendid =".$id.") AND (username!='".$username."') AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id") ;
			$friendcount = $db->numRows() ;
			$output .= "<li>" ;
			$output .= "<a href=\"".$sitepath."profile/$username\"><img class='thumb' width=".getSetting("avatar_w", $db)."px height=".getSetting("avatar_h", $db)."px class='thumb' src='".$avatar."' /></a>\n" ;
			$value['username'] = force_length($value['username'], 25) ;
			$output .= "<h3>&nbsp;&nbsp;<b><a href=\"".$sitepath."profile/$username\">".$value['username']."</a></b></h3>\n" ;
			$output .= "<h4><b>" ;
			if ($value['location'] != '') {
				$output .= "&nbsp;&nbsp;location: ".$value['location']."<br>" ;
			}
			$output .= "&nbsp;&nbsp;friends: ".$friendcount."<br>&nbsp;&nbsp;media: ".$mediacount."</b></h4>" ;
			$output .= "</li>\n" ;
			$colcount++ ;
			if ($count == $perpage)
				break ;
		}
	}
	$output .= "</ul></div>" ;
	if ($pages > 0)
		$output .= $pageLinks ;
	return $output ;
}
function favoritesList($res, $page, $url) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	if ($loggedIn) {
		$db->query("SELECT id FROM member WHERE username = '".$_SESSION['username']."'") ;
		$ures = $db->fetch() ;
		$memberid = $ures['id'] ;
		$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
		$groupmembership = $db->fetchAll() ;
	}
	$vidcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$vidcount++ ;
			}
		}
	}
	$perpage = getSetting("proffavpp", $db) ;
	$size = sizeof($res) ;
	$pages = ceil($vidcount / $perpage) ;
	$pageLinks = "<div align=right>Pages: " ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= '<a class="prevp" style="cursor: hand; cursor: pointer;" onClick="doFav(\''.$_GET['user'].'\',\''.$pp.'\');">Previous Page </a>' ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= '<a title="1" style="cursor: hand; cursor: pointer;" onClick="doFav(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
		else {
			$pageLinks .= '<a title="1" style="cursor: hand; cursor: pointer;" onClick="doFav(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doFav(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doFav(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doFav(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
		else {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doFav(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= '<a class="nextp" style="cursor: hand; cursor: pointer;" title="'.$np.'" onClick="doFav(\''.$_GET['user'].'\',\''.$np.'\');"> Next Page</a>' ;
	}
	$pageLinks .= "</div>" ;
	$output = '<div class="tab-cont"><ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$count++ ;
				if ($count == getSetting("adsense_pos1", $db) || $count == getSetting("adsense_pos2", $db))
					$output .= getAdmedia() ;
				$thumbpath = $sitepath.'uploads/thumbs/' ;
				if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
						$thumb = $thumbpath.$value['thumb'].".small.jpg" ;
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
						$thumb = $thumbpath.$value['mediaurl'].".small.jpg" ;
					elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
						$thumb = str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $thumbpath.$thumb[0] ;
					}
					else
						$thumb = $sitepath."images/default_small_thumb.jpg" ;
					if ($value['thumb'] == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
				}
				$cat = getCategoryPath($value['category']) ;
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$title = url_encode($value['title']) ;
				$output .= "<li>" ;
				$output .= "<a href=\"".$sitepath."play$cat/$title\"><img class='thumb' src='$thumb' /></a>\n" ;
				$value['title'] = force_length($value['title'], 55) ;
				$output .= "<h4><b>&nbsp;&nbsp;<a href=\"".$sitepath."play$cat/$title\">".str_replace("_", " ", $title)."</a></b></h4>\n" ;
				$value['description'] = force_length($value['description'], 130) ;
				$output .= "<p><b>".$value['description']."</b></p>" ;
				$output .= "<p><b>Views: ".$value['allviews']."&nbsp;<br><span class=\"rating\">".show_rating($value['id'])."</span></b></p>" ;
				$output .= "</li>\n" ;
				if ($count == $perpage)
					break ;
			}
		}
	}
	$output .= "</ul></div>" ;
	if ($pages != 0)
		$output .= $pageLinks ;
	return $output ;
}
function mediaList($res, $page, $url) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	if ($loggedIn) {
		$db->query("SELECT id FROM member WHERE username = '".$_SESSION['username']."'") ;
		$ures = $db->fetch() ;
		$memberid = $ures['id'] ;
		$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
		$groupmembership = $db->fetchAll() ;
	}
	$vidcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$vidcount++ ;
			}
		}
	}
	$perpage = getSetting("profmedpp", $db) ;
	$size = sizeof($res) ;
	$pages = ceil($vidcount / $perpage) ;
	$pageLinks = "<div align=right>Pages: " ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= '<a class="prevp" style="cursor: hand; cursor: pointer;" onClick="doMedia(\''.$_GET['user'].'\',\''.$pp.'\');">Previous Page </a>' ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= '<a title="1" style="cursor: hand; cursor: pointer;" onClick="doMedia(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
		else {
			$pageLinks .= '<a title="1" style="cursor: hand; cursor: pointer;" onClick="doMedia(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doMedia(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doMedia(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doMedia(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
		else {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doMedia(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= '<a class="nextp" style="cursor: hand; cursor: pointer;" title="'.$np.'" onClick="doMedia(\''.$_GET['user'].'\',\''.$np.'\');"> Next Page</a>' ;
	}
	$pageLinks .= "</div>" ;
	$output = '<div class="tab-cont"><ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$count++ ;
				if ($count == getSetting("adsense_pos1", $db) || $count == getSetting("adsense_pos2", $db))
					$output .= getAdmedia() ;
				$thumbpath = $sitepath.'uploads/thumbs/' ;
				if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
						$thumb = $thumbpath.$value['thumb'].".small.jpg" ;
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
						$thumb = $thumbpath.$value['mediaurl'].".small.jpg" ;
					elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
						$thumb = str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $thumbpath.$thumb[0] ;
					}
					else
						$thumb = $sitepath."images/default_small_thumb.jpg" ;
					if ($value['thumb'] == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
				}
				$cat = getCategoryPath($value['category']) ;
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$title = url_encode($value['title']) ;
				$output .= "<li>" ;
				$output .= "<a href=\"".$sitepath."play$cat/$title\"><img class='thumb' src='$thumb' /></a>\n" ;
				$value['title'] = force_length($value['title'], 55) ;
				$output .= "<h4><b>&nbsp;&nbsp;<a href=\"".$sitepath."play$cat/$title\">".str_replace("_", " ", $title)."</a></b></h4>\n" ;
				$value['description'] = force_length($value['description'], 130) ;
				$output .= "<p><b>".$value['description']."</b></p>" ;
				$output .= "<p><b>Views: ".$value['allviews']."&nbsp;<br><span class=\"rating\">".show_rating($value['id'])."</span></b></p>" ;
				$output .= "</li>\n" ;
				if ($count == $perpage)
					break ;
			}
		}
	}
	$output .= "</ul></div>" ;
	if ($pages > 0)
		$output .= $pageLinks ;
	return $output ;
}
function groupList($res, $page, $url, $type) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	$perpage = getSetting("profgrppp", $db) ;
	$size = sizeof($res) ;
	$pages = ceil($size / $perpage) ;
	$pageLinks = "<div align=right>Pages: " ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= '<a class="prevp" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\''.$pp.'\');">Previous Page </a>' ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= '<a title="1" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
		else {
			$pageLinks .= '<a title="1" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
		else {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= '<a class="nextp" style="cursor: hand; cursor: pointer;" title="'.$np.'" onClick="doGroup(\''.$_GET['user'].'\',\''.$np.'\');"> Next Page</a>' ;
	}
	$pageLinks .= "</div>" ;
	$output = '<div class="tab-cont"><ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	foreach ($res as $key=>$value) {
		$count++ ;
		$iconfile = "" ;
		if (@file_exists("uploads/groupicons/".$value['icon']) && ($value['icon'] != "")) {
			$iconfile = $sitepath."uploads/groupicons/".$value['icon'] ;
		}
		else {
			$iconfile = $templateimagepath."default_group_thumb.jpg" ;
		}
		$groupid = $value['group_id'] ;
		$groupname = force_length(stripslashes($value['name']), 64) ;
		$groupdesc = force_length(stripslashes($value['group_description']), 100) ;
		$grouppriv = $value['privacy'] ;
		$groupowner = $value['owner_id'] ;
		$db->query("SELECT username FROM member WHERE id = ".$groupowner) ;
		$userres = $db->fetch() ;
		$ownername = $userres['username'] ;
		$ownerlink = $sitepath.'profile/'.$ownername ;
		$privacy = '(public group)' ;
		if ($grouppriv == 1) {
			$privacy = '(private group)' ;
		}
		if ($loggedIn) {
			$db->query("SELECT id FROM member WHERE username = '".$_SESSION['username']."'") ;
			$ures = $db->fetch() ;
			$memberid = $ures['id'] ;
			$db->query("SELECT * FROM group_member WHERE group_id_g=".$groupid." AND member_id=".$memberid." AND approved=1") ;
			$isMember = $db->numRows() > 0 ;
		}
		else {
			$isMember = false ;
		}
		$db->query("SELECT * FROM group_member WHERE group_id_g=".$groupid." AND approved=1") ;
		$members = $db->numRows() ;
		if ($members != 1) {
			$s = 's' ;
		}
		else {
			$s = '' ;
		}
		$viewlink = $sitepath.'showgroup/'.url_encode($groupname) ;
		if ($iconfile != "") {
			$iconurl = '<img class="thumb" src="'.$iconfile.'">' ;
		}
		else {
			$iconurl = '' ;
		}
		$memStatus = '' ;
		if ($loggedIn) {
			if ($groupowner == $loggedInid) {
				$memStatus = '<h4><b> - you own this group</b></h4>' ;
			}
			else {
				if ($isMember) {
					$memStatus = '<h4><b> - you are a member&nbsp;<a href="'.$viewlink.'/leave">click here to leave</a></b></h4>' ;
				}
				else {
					$memStatus = '<h4><b><a href="'.$viewlink.'/join">click here to join</a></b></h4>' ;
				}
			}
		}
		if ($type == 'joined') {
			$ownermembers = '<h4>&nbsp;&nbsp;<b>('.$members.' member'.$s.') created by&nbsp;<a href="'.$ownerlink.'">'.$ownername.'</a></b></h4>' ;
		}
		else {
			$ownermembers = '<h4>&nbsp;&nbsp;<b>('.$members.' member'.$s.') </b></h4>' ;
		}
		$output .= '<li><a href="'.$viewlink.'">'.$iconurl.'</a>
				<h3><b>&nbsp;&nbsp;<a href="'.$viewlink.'">'.$groupname.'</a></b></h3><h4>&nbsp;&nbsp;'.$privacy.'</h4>
				<h4>&nbsp;&nbsp;<b>'.$groupdesc.'</b></h4><h4>'.$ownermembers.'</h4></li>' ;
		$colcount++ ;
		if ($count == $perpage)
			break ;
	}
	$output .= "</ul></div>" ;
	if ($pages > 0)
		$output .= $pageLinks ;
	return $output ;
}
function friendsList($res, $page, $url) {
	global $db,$sitepath,$templateimagepath ;
	$perpage = getSetting("proffrdpp", $db) ;
	$size = sizeof($res) ;
	$pages = ceil(sizeof($res) / $perpage) ;
	$pageLinks = "<div align=right>Pages: " ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= '<a class=\"prevp\" style="cursor: hand; cursor: pointer;" onClick="doFriend(\''.$_GET['user'].'\',\''.$pp.'\');">Previous Page</a>' ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= '<a style="cursor: hand; cursor: pointer;" onClick="doFriend(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
		else {
			$pageLinks .= '<a style="cursor: hand; cursor: pointer;" onClick="doFriend(\''.$_GET['user'].'\',\'1\');">1</a> ... ' ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doFriend(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="doFriend(\''.$_GET['user'].'\',\''.$p.'\');">'.$p.'</a> ' ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doFriend(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
		else {
			$pageLinks .= '... <a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="doFriend(\''.$_GET['user'].'\',\''.$pages.'\');">'.$pages.'</a>' ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= '<a class="nextp" style="cursor: hand; cursor: pointer;" title="'.$np.'" onClick="doFriend(\''.$_GET['user'].'\',\''.$np.'\');"> Next Page</a>' ;
	}
	$pageLinks .= "</div>" ;
	$output = '<div class="tab-cont"><ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	$colcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['activationkey'] == 0) {
			$count++ ;
			$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
			$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
			if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
				$avatar = $sitepath."uploads/avatars/".$value['avatar'] ;
			}
			$avatar = str_replace(" ", "%20", $avatar) ;
			$id = $value['id'] ;
			$username = $value['username'] ;
			$db->query("SELECT id FROM media WHERE status='true' AND poster ='".$username."'".$hide." ORDER BY allviews DESC") ;
			$mediacount = $db->numRows() ;
			$rres = $db->fetch() ;
			$db->query("SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$id." OR friend.friendid =".$id.") AND (username!='".$username."') AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id") ;
			$friendcount = $db->numRows() ;
			$output .= "<li>" ;
			$output .= "<a href=\"".$sitepath."profile/$username\"><img class='thumb' width=".getSetting("avatar_w", $db)."px height=".getSetting("avatar_h", $db)."px class='thumb' src='".$avatar."' /></a>\n" ;
			$value['username'] = force_length($value['username'], 25) ;
			$output .= "<h3><b>&nbsp;&nbsp;<a href=\"".$sitepath."profile/$username\">".$value['username']."</a></b></h3>\n" ;
			$output .= "<h4>&nbsp;&nbsp;<b>friends: ".$friendcount."<br>&nbsp;&nbsp;media: ".$mediacount."</b></h4>" ;
			$output .= "</li>\n" ;
			$colcount++ ;
			if ($count == $perpage)
				break ;
		}
	}
	$output .= "</ul></div>" ;
	if ($pages > 0)
		$output .= $pageLinks ;
	return $output ;
}
function getFriends($page) {
	global $db ;
	$sitefolder = getSetting("sitefolder", $db) ;
	$path = "http://".$_SERVER['SERVER_NAME'].$sitefolder."profile/".$_GET['user']."/frd" ;
	$db->query("SELECT * FROM member WHERE username = '".$_GET['user']."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$db->query("SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$userid." OR friend.friendid =".$userid.") AND (username!='".$_GET['user']."') AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id") ;
	$resLV = $db->fetchAll() ;
	if (sizeof($resLV) > 0) {
		$output = "<div align=center><h5>".$_GET['user']."'s friends</h5></div>" ;
		if (isset($page))
			$output .= friendsList($resLV, $page, $path) ;
		else
			$output .= friendsList($resLV, $page, $path) ;
	}
	else {
		$output .= "<div align=center><h5>".$_GET['user']." has no friends</h5></div>" ;
	}
	return $output ;
}
function getFavorites($page) {
	global $db,$sitepath ;
	if (checkHideMedia() == 1) {
		$hide = " AND (`requires_agreement` = 0)" ;
	}
	else {
		$hide = "" ;
	}
	$db->query("SELECT * FROM member WHERE username = '".$_GET['user']."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$query = "SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`)  LEFT JOIN favorite ON favorite.vidid = media.id WHERE (`status` ='true') 

	AND (favorite.userid = ".$userid.")".$hide."AND (`suspended`!=1 OR `suspended` IS NULL) ORDER BY `added` DESC" ;
	$db->query($query) ;
	$resLV = $db->fetchAll() ;
	if (sizeof($resLV) > 0) {
		$output = "<div align=center><h5>".$_GET['user']."'s favorite media</h5></div>" ;
		if (isset($page))
			$output .= favoritesList($resLV, $page, $sitepath) ;
		else
			$output .= favoritesList($resLV, $page, $path) ;
	}
	else {
		$output = "<div align=center><h5>".$_GET['user']." has no favorites</h5></div>" ;
	}
	return $output ;
}
function getMedia($page) {
	global $db,$sitepath ;
	if (checkHideMedia() == 1) {
		$hide = " AND (`requires_agreement` = 0)" ;
	}
	else {
		$hide = "" ;
	}
	$path = $sitepath."profile/".$_GET['user']."/med" ;
	$query = "SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status` ='true') AND (poster ='".$_GET['user']."')".$hide."AND (`suspended`!=1 OR `suspended` IS NULL) ORDER BY `added` DESC" ;
	$db->query($query) ;
	$resLV = $db->fetchAll() ;
	if (sizeof($resLV) > 0) {
		$output = "<div align=center><h5>".$_GET['user']."'s uploaded media</h5></div>" ;
		if (isset($page) && ($_GET['act'] == 'med'))
			$output .= mediaList($resLV, $page, $path) ;
		else
			$output .= mediaList($resLV, $page, $path) ;
	}
	else {
		$output = "<div align=center><h5>".$_GET['user']." has not uploaded any media yet</h5></div>" ;
	}
	return $output ;
}
function getGroups($page, $joinedcreated) {
	global $db,$sitepath ;
	if (($joinedcreated != "joined") && ($joinedcreated != "created")) {
		$joinedcreated = "joined" ;
	}
	$path = $sitepath."profile/".$_GET['user']."/grp/_".$joinedcreated ;
	$db->query("SELECT * FROM member WHERE username = '".$_GET['user']."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	if ($joinedcreated == "created") {
		$db->query("SELECT * FROM `group` WHERE `owner_id`=".$userid." ORDER BY created DESC") ;
		$tabtitle = "<div align=center><h5>".$_GET['user']."'s groups</h5></div>" ;
		$action = "created" ;
		$links = '<a title="Joined" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\'1\',\'joined\');">joined</a> | <b>created</b>' ;
		$type = "created" ;
	}
	else if ($joinedcreated == "joined") {
		$db->query("SELECT * FROM `group` LEFT JOIN `group_member` ON group_id=`group_id_g` WHERE (`member_id`=".$userid.") AND (approved=1) ORDER BY joined DESC") ;
		$tabtitle = "<div align=center><h5>groups ".$_GET['user']." has joined</h5></div>" ;
		$action = "joined" ;
		$links = ' <b>joined</b> | <a title="Created" style="cursor: hand; cursor: pointer;" onClick="doGroup(\''.$_GET['user'].'\',\'1\',\'created\');">created</a>' ;
		$type = "joined" ;
	}
	$resLV = $db->fetchAll() ;
	$output = "<div align=center>".$links."</div><br>" ;
	if (sizeof($resLV) > 0) {
		$output .= $tabtitle ;
		if (isset($page))
			$output .= groupList($resLV, $page, $path, $type) ;
		else
			$output .= groupList($resLV, $page, $path, $type) ;
	}
	else {
		$output .= "<div align=center><h2>".$_GET['user']." has not ".$action." any groups yet</h2></div>" ;
	}
	return $output ;
}
function getSubscriptions($page) {
	global $db,$sitepath ;
	$path = $sitepath."profile/".$_GET['user']."/sub" ;
	$db->query("SELECT * FROM member WHERE username = '".$_GET['user']."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$db->query("SELECT * FROM member LEFT JOIN subscription ON member.id = subscription.subscribedtoid WHERE subscription.userid = ".$userid) ;
	$resLV = $db->fetchAll() ;
	if (sizeof($resLV) > 0) {
		$output = "<div align=center><h5>".$_GET['user']."'s subscriptions</h5></div>" ;
		if (isset($page))
			$output .= subscriptionsList($resLV, $page, $path) ;
		else
			$output .= subscriptionsList($resLV, $page, $path) ;
	}
	else {
		$output = "<div align=center><h5>".$_GET['user']." has no subscriptions</h5></div>" ;
	}
	return $output ;
}
function addCommentLink() {
	global $db ;
	$sitefolder = getSetting("sitefolder", $db) ;
	$sitetemplate = getSetting("sitetemplate", $db) ;
	$rootpath = $_SERVER['DOCUMENT_ROOT'].$sitefolder ;
	$path = "http://".$_SERVER['SERVER_NAME'].$sitefolder ;
	$link = $path."profile/".$_GET['user'].'?action=addcomment' ;
	return $link ;
}
function commentCount() {
	global $db ;
	$username = mysql_real_escape_string($_GET['user']) ;
	$db->query("SELECT * FROM member WHERE username = '".$_SESSION['username']."'") ;
	$res = $db->fetch() ;
	$loggedInid = $res['id'] ;
	$db->query("SELECT * FROM profile_comment WHERE userid = ".$loggedInid) ;
	$count = $db->numRows() ;
	return $count ;
}
function profileComments($userIDz, $prouser, $page, $loggedInz, $show) {
	global $db,$loggedIn,$sitepath,$templateimagepath ;
	$sitefolder = getSetting("sitefolder", $db) ;
	$sitepath = "http://".$_SERVER['SERVER_NAME'].$sitefolder ;
	$comments = "" ;
	$username = $prouser ;
	$db->query("SELECT * FROM member WHERE username = '".$prouser."'") ;
	$res = $db->fetch() ;
	$userID = $res['id'] ;
	/*   Comments    */
	$db->query("SELECT * FROM profile_comment WHERE userid = ".$userIDz." ORDER BY date DESC") ;
	$result = $db->fetchAll() ;
	$comments = "" ;
	$perpage = 4 ;
	$size = sizeof($result) ;
	$pages = ceil(sizeof($result) / $perpage) ;
	$url = $sitepath.'profile/'.$prouser ;
	if ((isset($_GET['page'])) && (!isset($_GET['act'])))
		$page = $_GET['page'] ;
	else
		$page = 1 ;
	if ($page < 1)
		$page = 1 ;
	$pageLinks = "<div align=right>" ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= '<a class=\"prevp\" style="cursor: hand; cursor: pointer;" onClick="refComments(\''.$userIDz.'\',\''.$prouser.'\',\''.$pp.'\',\''.$loggedInz.'\',1);">Previous Page</a>' ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= '<a style="cursor: hand; cursor: pointer;" onClick="refComments(\''.$userIDz.'\',\''.$prouser.'\',\'1\',\''.$loggedInz.'\',1);">1</a> ... ' ;
		}
		else {
			$pageLinks .= '<a style="cursor: hand; cursor: pointer;" onClick="refComments(\''.$userIDz.'\',\''.$prouser.'\',\'1\',\''.$loggedInz.'\',1);">1</a> ... ' ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="refComments(\''.$userIDz.'\',\''.$prouser.'\',\''.$p.'\',\''.$loggedInz.'\',1);">'.$p.'</a>' ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= '<a title="'.$p.'" style="cursor: hand; cursor: pointer;" onClick="refComments(\''.$userIDz.'\',\''.$prouser.'\',\''.$p.'\',\''.$loggedInz.'\',1);">'.$p.'</a>' ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= '<a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="refComments(\''.$userIDz.'\',\''.$prouser.'\',\''.$pages.'\',\''.$loggedInz.'\',1);">'.$pages.'</a>' ;
		}
		else {
			$pageLinks .= '<a title="'.$pages.'" style="cursor: hand; cursor: pointer;" onClick="refComments(\''.$userIDz.'\',\''.$prouser.'\',\''.$pages.'\',\''.$loggedInz.'\',1);">'.$pages.'</a>' ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= '<a class="nextp" style="cursor: hand; cursor: pointer;" title="'.$np.'" onClick="refComments(\''.$userIDz.'\',\''.$prouser.'\',\''.$np.'\',\''.$loggedInz.'\',1);"> Next Page</a>' ;
	}
	$pageLinks .= "</div>" ;
	$count = 0 ;
	$comments .= '<h2>Comments</h2>' ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($result[$i]) ;
	$colcount = 0 ;
	foreach ($result as $key=>$row) {
		if ($row['regdposter'] == 1) {
			$posterString = '<a href="'.$sitepath.'profile/'.htmlentities($row['leftbyname']).'">'.htmlentities($row['leftbyname']).'</a>' ;
			$db->query("SELECT * FROM `member` WHERE `username` = '".quote_smart($row['leftbyname'])."'") ;
			$user = $db->fetch() ;
			if (($user['avatar'] == '') || ($db->numRows() < 1)) {
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar_tag = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
			}
			else {
				$avatar_tag = $sitepath.'uploads/avatars/'.$user['avatar'] ;
			}
		}
		else {
			$posterString = htmlentities($row['leftbyname'])." (visitor)" ;
			$avatar_tag = $templateimagepath."default_male_avatar.jpg" ;
		}
		if (($loggedInz) && (isset($_SESSION['privs']) && $_SESSION['privs'] == 7) || ($username == $_SESSION['username'])) {
			$del = '<div align=right><a title="delete comment" style="cusor: hand; cursor: pointer;" onclick="deleteComments(\''.$row['id'].'\',\''.$prouser.'\',\''.$loggedInz.'\');"> Delete This Comment </a></div>' ;
		}
		else {
			$del = '' ;
		}
		$str_today = date("Y-m-d H:i:s") ;
		$comments .= '<dl class="no-format full-com2"><dt><a href="'.$sitepath.'profile/'.htmlentities($row['leftbyname']).'"><img width=30px height=30px class="thumb" src="'.$avatar_tag.'" alt="" /></a><b>'.$posterString.' </b></dt>' ;
		$comments .= '<dd><p><h3 class="message">'.nl2br(($row['comment'])).$del.'</h3></p></dd><h4>'.date_diff(date("Y-m-d H:i:s", $row["date"]), $str_today).'</h4></dl><br>' ;
		$count++ ;
		if ($count == $perpage)
			break ;
	}
	if ($pages > 1) {
		$comments .= $pageLinks ;
	}
	$privacy = $res['privacy'] ;
	$postmessage = canComment() ;
	if (($postmessage == "") && ($show == 1)) {
		$comments .= '' ;
		if ((getSetting("restrictpc", $db) == 1) && (!$loggedInz)) {
			$comments .= '<h2>Please log in to comment</h2>' ;
		}
		else {
			//***CHECK PRIVACY LEVEL OF PROFILE HERE AND DECIDE IF COMMENT POSTING IS ALLOWED***
			$comments .= '<h2>Add comment</h2><input type="hidden" name="type" value="addcomment">' ;
			if ($loggedInz == 1) {
				$comments .= '<input type="hidden" id="guest" name="guest" value="'.$_SESSION['username'].'"/>' ;
			}
			else {
				$comments .= '<li>
					<label for="name" class="comment">name</label>
					<input type="hidden" id="visitor" name="visitor" value="visitorposting">
					<input id="guest" name="guest"  />
					</li>' ;
			}
			$comments .= '<div id="message">

				<textarea id="textz"></textarea></div>' ;
			if ((!$loggedInz) || (getSetting("captchaformembers", $db) == 1)) {
				$comments .= '<p><img src="'.$sitepath.'includes/CaptchaSecurityImages.php" /><br>Enter code above<br>
<input id="security_code" name="security_code" type="text" size="6"/></p>' ;
			}
			$comments .= '<p><input class="biggerbutton" type="button" name="submit" onClick="submitComments(\''.$prouser.'\',\''.$loggedInz.'\');" value="Post comment" style="margin-right: 30px;"/></p></form>' ;
			$comments .= '<br />'.$message ;
		}
		$comments .= '' ;
	}
	else {
		$comments .= $postmessage ;
	}
	return $comments ;
}
function profileTabs() {
	global $db ;
	$sitefolder = getSetting("sitefolder", $db) ;
	$sitetemplate = getSetting("sitetemplate", $db) ;
	$rootpath = $_SERVER['DOCUMENT_ROOT'].$sitefolder ;
	$path = "http://".$_SERVER['SERVER_NAME'].$sitefolder ;
	$link = $path.'profile/'.$_GET['user'].'/' ;
	$activetab = $_GET['act'] ;
	$medtab = "" ;
	$favtab = "" ;
	$subtab = "" ;
	$frdtab = "" ;
	$grptab = "" ;
	$tabs = '<!-- s:TABS -->

			<ul class="no-format c-tabs">

				<li'.$medtab.'><span><a style="cursor: hand; cursor: pointer;" title="Media" onClick="doMedia(\''.$_GET['user'].'\',\'1\');" >Media</a></span></li>

				<li'.$favtab.'><span><a style="cursor: hand; cursor: pointer;" title="Favorites" onClick="doFav(\''.$_GET['user'].'\',\'1\');">Favorites</a></span></li>

				<li'.$subtab.'><span><a style="cursor: hand; cursor: pointer;" title="Subscriptions" onClick="doSub(\''.$_GET['user'].'\',\'1\');">Subscriptions</a></span></li>

				<li'.$frdtab.'><span><a style="cursor: hand; cursor: pointer;" title="Friends" onClick="doFriend(\''.$_GET['user'].'\',\'1\');">Friends</a></span></li>

				<li'.$grptab.'><span><a style="cursor: hand; cursor: pointer;" title="Groups" onClick="doGroup(\''.$_GET['user'].'\',\'1\',\'joined\');">Groups</a></span></li>

			</ul>

			<!-- e:TABS -->' ;
	return $tabs ;
}
function tabContent() {
	$content = '' ;
	$activetab = $_GET['act'] ;
	if (!isset($_GET['act'])) {
		$activetab = 'med' ;
	}
	if (($activetab != "med") && ($activetab != "fav") && ($activetab != "sub") && ($activetab != "frd") && ($activetab != "grp")) {
		$activetab = 'med' ;
	}
	if ($activetab == "med") {
		$content .= getMedia() ;
	}
	elseif ($activetab == "fav") {
		$content .= getFavorites() ;
	}
	elseif ($activetab == "sub") {
		$content .= getSubscriptions() ;
	}
	elseif ($activetab == "frd") {
		$content .= getFriends() ;
	}
	elseif ($activetab == "grp") {
		$content .= getGroups() ;
	}
	$content .= '' ;
	echo $content ;
}
function checkMemberExists() {
	global $db,$loggedIn ;
	$path = getSetting('sitefolder', $db) ;
	$sitepath = 'http://'.$_SERVER['SERVER_NAME'].$path ;
	$message = "" ;
	if (!isset($_GET['user'])) {
		// NO USER IN URL
		$message = "Sorry - this user does not exist or is no longer registered" ;
	}
	else {
		$username = mysql_real_escape_string($_GET['user']) ;
		$db->query("SELECT * FROM member WHERE username = '".$username."'") ;
		$registeredUser = false ;
		if ($db->numRows() < 1) {
			$message = "Sorry - this user does not exist or is no longer registered" ;
		}
	}
	return $message ;
}
function canMessage() {
	global $db,$loggedIn ;
	$path = getSetting('sitefolder', $db) ;
	$sitepath = 'http://'.$_SERVER['SERVER_NAME'].$path ;
	$message = "" ;
	if (!isset($_GET['user'])) {
		// NO USER IN URL
		$message = "Sorry - this user does not exist or is no longer registered" ;
	}
	else {
		$username = mysql_real_escape_string($_GET['user']) ;
		//Check it's a registered user
		$db->query("SELECT * FROM member WHERE username = '".$username."'") ;
		$registeredUser = false ;
		if ($db->numRows() >= 1) {
			$registeredUser = true ;
			$res = $db->fetch() ;
			$profileid = $res['id'] ;
			$profileprivacylevel = $res['profile_privacy'] ;
			// NOW CHECK THAT THIS USER IS ALLOWED TO VIEW THE PROFILE

			
			// IF USER IS LOGGED IN CHECK IF USER IS BLOCKED
			$blocked = false ;
			$userisfriend = false ;
			$userisowner = false ;
			$useridadmin = false ;
			if ($loggedIn) {
				$db->query("SELECT * FROM member WHERE username = '".$_SESSION['username']."'") ;
				$res = $db->fetch() ;
				$loggedInid = $res['id'] ;
				$privs = $res['privs'] ;
				$db->query("SELECT * FROM blocked WHERE blocker_id = ".$profileid." AND blockee_id = ".$loggedInid) ;
				$blocked = ($db->numRows() >= 1) ;
				// CHECK IF USER IS THE OWNER OF THIS PROFILE
				$userisowner = ($profileid == $loggedInid) ;
				// CHECK IF USER IS ON THE OWNER'S FRIENDS LIST AND IS APPROVED
				$db->query("SELECT * from friend WHERE ((userid = ".$profileid." AND friendid = ".$loggedInid.") OR  (friendid = ".$profileid." AND userid = ".$loggedInid.")) AND friend_approved = 1") ;
				$userisfriend = ($db->numRows() > 0) ;
				$userisadmin = ($privs > 6) ;
			}
			if (!$userisadmin)
			// IF USER IS ADMIN THEN NO NEED T0 CHECK FRIENDS/BLOCKED ETC.
			{
				if ($blocked) {
					//USER IS BLOCKED
					$message = "<h3>Sorry, this member has chosen not to let you see their profile</h3>" ;
				}
				else
				// USER IS NOT BLOCKED
				{
					// NOW CHECK IF THE PROFILE IS VISIBLE - IT WILL BE SHOWN IN ANY OF THESE 3 CASES:
					
					// 1 - PROFILE IS PUBLIC
					
					// 2 - PROFILE IS REGISTERED ONLY AND USER IS LOGGED IN
					
					// 3 - PROFILE IS PRIVATE AND USER IS LOGGED IN AND (USER IS A FRIEND OR THE OWNER OF THIS PROFILE)
					$profileispublic = ($profileprivacylevel == 0) ;
					$registeredonlyandloggedin = (($profileprivacylevel == 1) && ($loggedIn)) ;
					$privateandloggedinandfriendorowner = (($profileprivacylevel == 2) && ($loggedIn) && (($userisfriend) OR ($userisowner))) ;
					$showprofile = $profileispublic || $registeredonlyandloggedin || $privateandloggedinandfriendorowner ;
					if (!$showprofile) {
						if (!$loggedIn) {
							$message = "<h3>You must log in to send messages to ".$username."</h3>" ;
						}
						else {
							if ($_GET['act'] == 'af') {
								$message = "<h3>Thank you! Your request to be added to ".$_GET['user']."'s friends list has been submitted</h3>" ;
							}
							else {
								$message = '<h3>You must be on '.$_GET['user'].'\'s friends list to send messages - <a href="'.$sitepath.'profile/'.$_GET['user'].'/af">ask '.$_GET['user'].' to add you here</a></h3>' ;
							}
						}
					}
				}
			}
		}
		else {
			// USER NAME IS NOT IN THE DATABASE
			if (!$registeredUser) {
				$message = "Sorry - this user does not exist or is no longer registered" ;
			}
		}
	}
	return $message ;
}
function canMessageForMenu() {
	global $db,$loggedIn ;
	$path = getSetting('sitefolder', $db) ;
	$sitepath = 'http://'.$_SERVER['SERVER_NAME'].$path ;
	$message = "" ;
	if (!isset($_GET['user'])) {
		// NO USER IN URL
		$message = "Sorry - this user does not exist or is no longer registered" ;
	}
	else {
		$username = mysql_real_escape_string($_GET['user']) ;
		//Check it's a registered user
		$db->query("SELECT * FROM member WHERE username = '".$username."'") ;
		$registeredUser = false ;
		if ($db->numRows() >= 1) {
			$registeredUser = true ;
			$res = $db->fetch() ;
			$profileid = $res['id'] ;
			$profileprivacylevel = $res['profile_privacy'] ;
			// NOW CHECK THAT THIS USER IS ALLOWED TO VIEW THE PROFILE

			
			// IF USER IS LOGGED IN CHECK IF USER IS BLOCKED
			$blocked = false ;
			$userisfriend = false ;
			$userisowner = false ;
			$useridadmin = false ;
			if ($loggedIn) {
				$db->query("SELECT * FROM member WHERE username = '".$_SESSION['username']."'") ;
				$res = $db->fetch() ;
				$loggedInid = $res['id'] ;
				$privs = $res['privs'] ;
				$db->query("SELECT * FROM blocked WHERE blocker_id = ".$profileid." AND blockee_id = ".$loggedInid) ;
				$blocked = ($db->numRows() >= 1) ;
				// CHECK IF USER IS THE OWNER OF THIS PROFILE
				$userisowner = ($profileid == $loggedInid) ;
				// CHECK IF USER IS ON THE OWNER'S FRIENDS LIST AND IS APPROVED
				$db->query("SELECT * from friend WHERE ((userid = ".$profileid." AND friendid = ".$loggedInid.") OR  (friendid = ".$profileid." AND userid = ".$loggedInid.")) AND friend_approved = 1") ;
				$userisfriend = ($db->numRows() > 0) ;
				$userisadmin = ($privs > 6) ;
			}
			if (!$userisadmin)
			// IF USER IS ADMIN THEN NO NEED T0 CHECK FRIENDS/BLOCKED ETC.
			{
				if ($blocked) {
					//USER IS BLOCKED
					$message = "<h4>$username has chosen not to let you send messages</h4>" ;
				}
				else
				// USER IS NOT BLOCKED
				{
					// NOW CHECK IF THE PROFILE IS VISIBLE - IT WILL BE SHOWN IN ANY OF THESE 3 CASES:
					
					// 1 - PROFILE IS PUBLIC
					
					// 2 - PROFILE IS REGISTERED ONLY AND USER IS LOGGED IN
					
					// 3 - PROFILE IS PRIVATE AND USER IS LOGGED IN AND (USER IS A FRIEND OR THE OWNER OF THIS PROFILE)
					$profileispublic = ($profileprivacylevel == 0) ;
					$registeredonlyandloggedin = (($profileprivacylevel == 1) && ($loggedIn)) ;
					$privateandloggedinandfriendorowner = (($profileprivacylevel == 2) && ($loggedIn) && (($userisfriend) OR ($userisowner))) ;
					$showprofile = $profileispublic || $registeredonlyandloggedin || $privateandloggedinandfriendorowner ;
					if (!$showprofile) {
						if (!$loggedIn) {
							$message = "Log in to send a message to ".$username ;
						}
						else {
							if ($_GET['act'] == 'af') {
								$message = "You will be able to send a message to ".$username." when your friend request is approved" ;
							}
							else {
								$message = '<a href="'.$sitepath.'profile/'.$_GET['user'].'/af">Become '.$username.'\'s friend</a> to send a message' ;
							}
						}
					}
				}
			}
		}
		else {
			// USER NAME IS NOT IN THE DATABASE
			if (!$registeredUser) {
				$message = "Sorry - this user does not exist or is no longer registered" ;
			}
		}
	}
	return $message ;
}
function canComment() {
	global $db,$loggedIn ;
	$path = getSetting('sitefolder', $db) ;
	$sitepath = 'http://'.$_SERVER['SERVER_NAME'].$path ;
	$message = "" ;
	if (!isset($_GET['user'])) {
		// NO USER IN URL
		$message = "Sorry - this user does not exist or is no longer registered" ;
	}
	else {
		$username = mysql_real_escape_string($_GET['user']) ;
		//Check it's a registered user
		$db->query("SELECT * FROM member WHERE username = '".$username."'") ;
		$registeredUser = false ;
		if ($db->numRows() >= 1) {
			$registeredUser = true ;
			$res = $db->fetch() ;
			$profileid = $res['id'] ;
			$profileprivacylevel = $res['profile_privacy'] ;
			// NOW CHECK THAT THIS USER IS ALLOWED TO VIEW THE PROFILE

			
			// IF USER IS LOGGED IN CHECK IF USER IS BLOCKED
			$blocked = false ;
			$userisfriend = false ;
			$userisowner = false ;
			$useridadmin = false ;
			if ($loggedIn) {
				$db->query("SELECT * FROM member WHERE username = '".$_SESSION['username']."'") ;
				$res = $db->fetch() ;
				$loggedInid = $res['id'] ;
				$privs = $res['privs'] ;
				$db->query("SELECT * FROM blocked WHERE blocker_id = ".$profileid." AND blockee_id = ".$loggedInid) ;
				$blocked = ($db->numRows() >= 1) ;
				// CHECK IF USER IS THE OWNER OF THIS PROFILE
				$userisowner = ($profileid == $loggedInid) ;
				// CHECK IF USER IS ON THE OWNER'S FRIENDS LIST AND IS APPROVED
				$db->query("SELECT * from friend WHERE ((userid = ".$profileid." AND friendid = ".$loggedInid.") OR  (friendid = ".$profileid." AND userid = ".$loggedInid.")) AND friend_approved = 1") ;
				$userisfriend = ($db->numRows() > 0) ;
				$userisadmin = ($privs > 6) ;
			}
			if (!$userisadmin)
			// IF USER IS ADMIN THEN NO NEED T0 CHECK FRIENDS/BLOCKED ETC.
			{
				if ($blocked) {
					//USER IS BLOCKED
					$message = "<h3>Sorry, this member has chosen not to let you see their profile</h3>" ;
				}
				else
				// USER IS NOT BLOCKED
				{
					// NOW CHECK IF THE PROFILE IS VISIBLE - IT WILL BE SHOWN IN ANY OF THESE 3 CASES:
					
					// 1 - PROFILE IS PUBLIC
					
					// 2 - PROFILE IS REGISTERED ONLY AND USER IS LOGGED IN
					
					// 3 - PROFILE IS PRIVATE AND USER IS LOGGED IN AND (USER IS A FRIEND OR THE OWNER OF THIS PROFILE)
					$profileispublic = ($profileprivacylevel == 0) ;
					$registeredonlyandloggedin = (($profileprivacylevel == 1) && ($loggedIn)) ;
					$privateandloggedinandfriendorowner = (($profileprivacylevel == 2) && ($loggedIn) && (($userisfriend) OR ($userisowner))) ;
					$showprofile = $profileispublic || $registeredonlyandloggedin || $privateandloggedinandfriendorowner ;
					if (!$showprofile) {
						if ((!$loggedIn) && (!$profileispublic)) {
							$message = "<h3>You must log in to post comments on ".$username."'s profile</h3>" ;
						}
						else {
							if ($_GET['act'] == 'af') {
								$message = "<h3>Thank you! Your request to be added to ".$_GET['user']."'s friends list has been submitted</h3>" ;
							}
							else {
								$message = '<h3>You must be on '.$_GET['user'].'\'s friends list to post comments on '.$username.'\'s profile - <a href="'.$sitepath.'profile/'.$_GET['user'].'/af">ask '.$_GET['user'].' to add you here</a></h3>' ;
							}
						}
					}
				}
			}
		}
		else {
			// USER NAME IS NOT IN THE DATABASE
			if (!$registeredUser) {
				$message = "Sorry - this user does not exist or is no longer registered" ;
			}
		}
	}
	return $message ;
}
function remove_bad_words($text) {
	$content = GetResponseString("includes/badwords.inc") ;
	$badwords = explode("\n", $content) ;
	foreach ($badwords as $block) {
		$block = strtolower($block) ;
		$block = str_replace("\r", "", $block) ;
		$block = str_replace("\n", "", $block) ;
		$badSearch = "" ;
		for ($i = 0; $i < strlen($block); $i++) {
			$letter = substr($block, $i, 1) ;
			if (strlen($letter) != 0 && $letter != " ") {
				$badSearch .= $letter ;
				if (strlen($block) > $i)
					$badSearch .= "[^A-z]*" ;
			}
		}
		if (strlen($badSearch) != 0) {
			$strReplace = substr($block, 0, 1) ;
			for ($i = 1; $i < strlen($block); $i++)
				$strReplace .= "*" ;
			$text = eregi_replace($badSearch, $strReplace, $text) ;
		}
	}
	return $text ;
}
$str_today = date("Y-m-d H:i:s") ;
function date_diff($str_start, $str_end) {
	$defdate = $str_start ;
	$str_start = strtotime($str_start) ;
	$str_end = strtotime($str_end) ;
	$nseconds = $str_end - $str_start ;
	$ndays = floor($nseconds / 86400) ;
	$nseconds = $nseconds % 86400 ;
	$nhours = floor($nseconds / 3600) ;
	$nseconds = $nseconds % 3600 ;
	$nminutes = floor($nseconds / 60) ;
	$nseconds = $nseconds % 60 ;
	$retString = "" ;
	if ($ndays > 0) {
		$retString .= $defdate ;
		return "at  ".$retString ;
	}
	if ($nhours > 0) {
		$retString .= " ".$nhours." hour" ;
		if ($nhours > 1)
			$retString .= "s" ;
	}
	if ($nminutes > 0) {
		$retString .= " ".$nminutes." minute" ;
		if ($nminutes > 1)
			$retString .= "s" ;
	}
	if (strcmp($retString, "") == 0)
		$retString = "< 1 minute" ;
	return $retString." ago" ;
}
function profileBox() {
	global $db,$loggedIn,$sitepath,$templateimagepath ;
	$sitefolder = getSetting("sitefolder", $db) ;
	$sitetemplate = getSetting("sitetemplate", $db) ;
	$rootpath = $_SERVER['DOCUMENT_ROOT'].$sitefolder ;
	$path = "http://".$_SERVER['SERVER_NAME'].$sitefolder ;
	// GET LOGGED IN USER'S ID
	$db->query("SELECT * FROM member WHERE username = '".$_SESSION['username']."'") ;
	$res = $db->fetch() ;
	$loggedInid = $res['id'] ;
	// GET PROFILE DETAILS
	$username = mysql_real_escape_string($_GET['user']) ;
	$db->query("SELECT * FROM member WHERE username = '".$username."'") ;
	$userrow = $db->fetch() ;
	$aboutme = $userrow['aboutme'] ;
	$age = $userrow['age'] ;
	$gender = $userrow['gender'] ;
	$location = $userrow['location'] ;
	$profileid = $userrow['id'] ;
	if (($loggedInid != $profileid) && ($loggedIn)) {
		$db->query("UPDATE member SET profileviews=profileviews+1 WHERE id=".$profileid) ;
		$db->query("SELECT viewerhistory FROM member WHERE id=".$profileid) ;
		$hres = $db->fetch() ;
		$viewerhistory = $hres['viewerhistory'] ;
		$media = array() ;
		$count = 0 ;
		if (strlen($viewerhistory) != 0) {
			$pastviewers = split(":", $viewerhistory) ;
			if ($pastviewers[count($pastviewers) - 2] != "") {
				$lastviewer = $pastviewers[count($pastviewers) - 2] ;
			}
			else {
				$lastviewer = -1 ;
			}
		}
		if ($loggedInid != $lastviewer) {
			$viewerhistory .= $loggedInid.":" ;
			$db->query("UPDATE member SET viewerhistory = '".$viewerhistory."' WHERE id=".$profileid) ;
		}
	}
	$avatargender = $userrow['gender'] > 0 ? 'female' : 'male' ;
	$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
	if (@file_exists("uploads/avatars/".$userrow['avatar']) && ($userrow['avatar'] != "")) {
		$avatar = $sitepath."uploads/avatars/".$userrow['avatar'] ;
	}
	$avatar = str_replace(" ", "%20", $avatar) ;
	$profileoutput = '	<div id="profile"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" />

				<h3>About '.$username.'</h3>

				<p>'.$aboutme.'</p>' ;
	if (($age != "") || ($gender != "")) {
		$profileoutput .= '<p>' ;
		if ($age != "") {
			$profileoutput .= 'age '.$age.' ' ;
		}
		if ($gender != "") {
			$profileoutput .= ' - ' ;
			if ($gender == 1) {
				$profileoutput .= "female" ;
			}
			else {
				$profileoutput .= "male" ;
			}
		}
		$username = mysql_real_escape_string($_GET['user']) ;
	}
	if ($location != '') {
		$profileoutput .= '<p>location: '.$location.'</p>' ;
	}
	$iconpath = $path.'templates/'.$sitetemplate.'/layout/skin1/' ;
	$userisfriend = false ;
	$userisblocked = false ;
	$userisapproved = false ;
	$requestreceived = false ;
	$requestsent = false ;
	$receivedicanaccept = false ;
	$receivedremovedme = false ;
	$pendingcancancel = false ;
	$iremovedmakerequest = false ;
	$userisfriend = false ;
	$notonlistcanrequest = false ;
	if ($loggedIn) {
		$db->query("SELECT * from friend WHERE (userid = ".$profileid." AND friendid = ".$loggedInid.") OR (userid = ".$loggedInid." AND friendid = ".$profileid.")") ;
		$friendres = $db->fetch() ;
		$useronfriendslist = ($db->numRows() > 0) ;
		if (($useronfriendslist) && ($profileid != $loggedInid)) //don't check friends if user owns profile 
		{
			$requestapproved = ($friendres['friend_approved']) > 0 ;
			$requestremoved = ($friendres['friend_removed']) > 0 ;
			if (!$requestapproved) // user is not friend 
			{
				//now check if the request was sent or received
				if ($friendres['userid'] == $loggedInid) // Received request 
				{
					$requestreceived = true ;
					if (!$requestremoved) 
					{
						$receivedicanaccept = true ;//arr
					}
					else {
						$receivedremovedme = true ;//rfa
					}
				}
				else // It's a sent request 
				{
					$requestsent = true ;
					if (!$requestremoved) 
					{
						$pendingcancancel = true ; //csr
					}
					else {
						$iremovedmakerequest = true ; //rmaf
					}
				}
			}
			else //no friend record 
			{
				$userisfriend = true ; //afr
			}
		}
		else {
			$notonlistcanrequest = true ; //af
		}
		$db->query("SELECT * from blocked WHERE blockee_id = ".$profileid." AND blocker_id = ".$loggedInid) ;
		$userisblocked = ($db->numRows() > 0) ;
		$db->query("SELECT * from subscription WHERE userid=".$loggedInid." AND subscribedtoid=".$profileid) ;
		$userissubscribed = ($db->numRows() > 0) ;
	}
	$proflink = $path.'profile/'.$_GET['user'] ;
	$friendaddlink = $proflink.'/af' ;
	$receivedicanacceptlink = $proflink.'/arr' ;
	$receivedremovedmelink = $proflink.'/rfa' ;
	$pendingcancancellink = $proflink.'/csr' ;
	$iremovedmakerequestlink = $proflink.'/rmaf' ;
	$userisfriendlink = $proflink.'/afr' ;
	$notonlistlink = $proflink.'/af' ;
	$blocklink = $path.'profile/'.$_GET['user'].'/bl' ;
	$sublink = $path.'profile/'.$_GET['user'].'/sb' ;
	$unblocklink = $path.'profile/'.$_GET['user'].'/ub' ;
	$unsublink = $path.'profile/'.$_GET['user'].'/us' ;
	$sendmessagelink = $path.'profile/'.$_GET['user'].'/sm' ;
	if ($loggedIn) {
		if ($profileid != $loggedInid) //don't show the links if the user owns the profile 
		{
			if ($receivedicanaccept) {
				$profileoutput .= '<p><b>'.$username.' has sent you a friend request: <a href="'.$receivedicanacceptlink.'">accept the request</a></b></p>' ;
			}
			if ($receivedremovedme) {
				$profileoutput .= '<p><b>'.$username.' removed you from friends list: <a href="'.$receivedremovedmelink.'">request again</a></b></p>' ;
			}
			if ($pendingcancancel) {
				$profileoutput .= '<p><b>'.$username.' has not accepted your request yet: <a href="'.$pendingcancancellink.'">cancel request</a></b></p>' ;
			}
			if ($iremovedmakerequest) {
				$profileoutput .= '<p><b><a href="'.$iremovedmakerequestlink.'">send '.$username.' a friend request</a></b></p>' ;
			}
			if ($userisfriend) {
				$profileoutput .= '<p><b>you are '.$username.'\'s friend <a href="'.$userisfriendlink.'">remove '.$username.' from your friends list</a></b></p>' ;
			}
			if ($notonlistcanrequest) {
				$profileoutput .= '<p><b><a href="'.$notonlistlink.'">send '.$username.' a friend request</a></b></p>' ;
			}
			if (canMessageForMenu() == '') {
				$profileoutput .= '<div class="lnk"><a href="'.$sendmessagelink.'"><img src="'.$iconpath.'icn_send_message.jpg" alt="" border=0/>send '.$username.' a message</a></div>' ;
			}
			else {
				$profileoutput .= '<div class="lnk"><img src="'.$iconpath.'icn_send_message.jpg" alt="" border=0/>'.canMessageForMenu().'</div>' ;
			}
			if (!$userisblocked) {
				$profileoutput .= '<div class="lnk"><a href="'.$blocklink.'"><img src="'.$iconpath.'icn_send_message.jpg"	alt="" border=0/>block '.$username.' from commenting on my profile or sending 	messages</a></div>' ;
			}
			else {
				$profileoutput .= '<div class="lnk"><a href="'.$unblocklink.'"><img src="'.$iconpath.'icn_send_message.jpg"	alt="" border=0/>Remove block for '.$username.'</a></div>' ;
			}
			if (!$userissubscribed) {
				$profileoutput .= '<div class="lnk"><a href="'.$sublink.'"><img src="'.$iconpath.'icn_send_message.jpg"	alt="" border=0/>subscribe (receive emails when '.$username.' uploads new media)</a></div>' ;
			}
			else {
				$profileoutput .= '<div class="lnk"><a href="'.$unsublink.'"><img src="'.$iconpath.'icn_send_message.jpg"	alt="" border=0/>Unsubscribe from '.$username.'</a></div>' ;
			}
		}
	}
	else {
		$profileoutput .= '<p><div class="lnk"><img src="'.$iconpath.'icn_send_message.jpg" alt="" border=0/>log in to send '.$username.' a message</div></p>' ;
	}
	$profileoutput .= "</div>" ;
	return $profileoutput ;
}
function SubmitComment($username, $loggedIn, $textz, $seccode, $name) {
	global $db,$sitepath ;
	if ($loggedIn == "")
		$loggedIn = 0 ;
	if (!$loggedIn)
		$loggedIn = 0 ;
	$db->query("SELECT * FROM member WHERE username = '".$username."'") ;
	$res = $db->fetch() ;
	$userID = $res['id'] ;
	$message = "" ;
	if (canComment() == '') {
		if ((($_SESSION['security_code'] == $seccode) && (! empty($_SESSION['security_code']))) || ((getSetting("captchaformembers", $db) == 0) && ($loggedIn == 1))) {
			if (! empty($name)) {
				if (! empty($textz)) {
					if (strlen($textz) <= getSetting('comment_length', $db)) {
						$commenttext = quote_smart($textz) ;
						$commenttext = apply_word_censor($commenttext) ;
						if ($loggedIn == 0) {
							if ((getSetting("restrictpc", $db) == "0") || ($loggedIn))
								$db->query("INSERT INTO `profile_comment` (userid, leftbyname, date, comment,regdposter) VALUES ('".$userID."', '".$name."', '".time()."', '".$commenttext."',0);") ;
						}
						else {
							$db->query("INSERT INTO `profile_comment` (userid, leftbyname, date, comment,regdposter) VALUES ('".$userID."', '".$_SESSION['username']."', '".time()."', '".$commenttext."',1);") ;
						}
						$check = getSetting("Ronoroff", $db) ;
						if ($check == 1) {
							$PointAmount = getSetting("PRcommentP", $db) ;
							$db->query("UPDATE member SET points = points + $PointAmount WHERE username = '".$_SESSION['username']."'") ;
						}
						$message = '<b>Your comment was added successfully. Thank you.</b>' ;
?>
<input type="hidden" name="ajax" id="ajax" value="<?=$sitepath?>">
<script type="text/javascript" src="<?=$sitepath?>ajax/profile.js">
</script>
<script type="text/javascript">
    
    refComments('<?=$userID?>', '<?=$username?>', 1, '<?=$loggedIn?>', 0);
    
</script>
<? 
						
					}
					else {
						$message = '<blink><b>Your comment is too long, please make it less then '.getSetting('comment_length', $db).' characters.</b></blink>' ;
					}
				}
				else {
					$message = '<blink><b>You have to fill in something in the text box.</b></blink>' ;
				}
			}
			else {
				$message = '<blink><b>You have to fill in your name.</b></blink>' ;
			}
		}
		else {
			$message = '<blink><b>Please enter the security code on the form Code is '.$_SESSION['security_code'].' : '.$seccode.'</b></blink>' ;
		}
	}
	return $message ;
}
function deleteComment($page, $userid, $loggedInz) {
	global $db,$sitepath ;
	$rowid = $page ;
	if ($rowid > 0) {
		$check = getSetting("Ronoroff", $db) ;
		if ($check == 1) {
			$PointAmount = getSetting("PRcommentP", $db) ;
			$db->query("SELECT leftbyname FROM profile_comment WHERE id='".$rowid."'") ;
			$res = $db->fetch() ;
			$db->query("UPDATE member SET points = points - $PointAmount WHERE username = '".$res['leftbyname']."'") ;
		}
		$db->query('SELECT userid FROM profile_comment WHERE id='.$rowid) ;
		$rew = $db->fetch() ;
		$uID = $rew['userid'] ;
		$db->query('DELETE FROM profile_comment WHERE id='.$rowid) ;
	}
	$uName = $_SESSION['username'] ;
	


?>
<input type="hidden" name="ajax" id="ajax" value="<?=$sitepath?>">
<script type="text/javascript" src="<?=$sitepath?>ajax/profile.js">
</script>
<script type="text/javascript">    
    refComments('<?=$uID?>', '<?=$userid?>', 1, '<?=$loggedInz?>', 1);
</script>
<? 
}
?>