<?php 
/*
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: members.inc
 *    Description: Functions for members page
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
function memberList() {
	global $db,$template,$sitepath,$loggedIn ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/members_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = memberList_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$filter = 'all' ;
		if ($_GET['filter'] != "") {
			$filter = $_GET['filter'] ;
		}
		$search = '' ;
		$nsearchvar = '' ;
		$lsearchvar = '' ;
		$searchurl = '' ;
		$sort = " ORDER BY `created` DESC" ;
		$newsel = " SELECTED" ;
		if ($_GET['lsearch'] != "") {
			$lsearchvar = $_GET['lsearch'] ;
		}
		if ($_GET['nsearch'] != "") {
			$nsearchvar = $_GET['nsearch'] ;
		}
		if ($_POST['namesearch'] != "") {
			$nsearchvar = quote_smart($_POST['namesearch']) ;
		}
		if ($_POST['locationsearch'] != "") {
			$lsearchvar = quote_smart($_POST['locationsearch']) ;
		}
		$newsel = "" ;
		$logsel = "" ;
		if (isset($_POST['namesearch'])) {
			$nsearchvar = quote_smart($_POST['namesearch']) ;
		}
		if (isset($_POST['locationsearch'])) {
			$lsearchvar = quote_smart($_POST['locationsearch']) ;
		}
		if ($_POST['membersort'] == 'newest') {
			$sort = " ORDER BY `created` DESC" ;
			$newsel = " SELECTED" ;
		}
		if ($_POST['membersort'] == 'login') {
			$sort = " ORDER BY `lastlogin` DESC" ;
			$logsel = " SELECTED" ;
		}
		$searchurl = $sitepath."members/_".$filter ;
		if ($nsearchvar != '') {
			$search .= " AND (username LIKE '%".$nsearchvar."%')" ;
			$searchurl .= "/__".urlencode($nsearchvar) ;
		}
		if ($lsearchvar != '') {
			$search .= " AND (location LIKE '%".$lsearchvar."%')" ;
			$searchurl .= "/___".urlencode($lsearchvar) ;
		}
		$query = "SELECT * FROM member WHERE (activationkey=0)" ;
		if ($_POST['agefilter'] == "") {
			$agefilter = "all" ;
			$sellall = " SELECTED" ;
		}
		else {
			$agefilter = quote_smart($_POST['agefilter']) ;
		}
		switch ($agefilter) {
			case "u18":
				$query .= " AND (age<18)" ;
				$sel_u18 = " SELECTED" ;
				break ;
			case "1825":
				$query .= " AND (age>=18 AND age<=25)" ;
				$sel_1825 = " SELECTED" ;
				break ;
			case "2635":
				$query .= " AND (age>=26 AND age<=35)" ;
				$sel_2635 = " SELECTED" ;
				break ;
			case "3650":
				$query .= " AND (age>=36 AND age<=50)" ;
				$sel_3650 = " SELECTED" ;
				break ;
			case "5165":
				$query .= " AND (age>=51 AND age<=65)" ;
				$sel_5165 = " SELECTED" ;
				break ;
			case "o65":
				$query .= " AND (age>65)" ;
				$sel_o65 = " SELECTED" ;
				break ;
		}
		if ($_POST['genderfilter'] == "") {
			$genderfilter = "all" ;
			$sel_either = " SELECTED" ;
		}
		else {
			$genderfilter = quote_smart($_POST['genderfilter']) ;
		}
		switch ($genderfilter) {
			case "male":
				$query .= " AND (gender=0)" ;
				$sel_male = " SELECTED" ;
				break ;
			case "female":
				$query .= " AND (gender=1)" ;
				$sel_female = " SELECTED" ;
				break ;
		}
		$query .= $search.$sort ;;
		$output = "<form action=\"".$searchurl."\" method=\"POST\" name=\"memberform\">		
	<div align=right>
	age filter&nbsp;
	<select name=\"agefilter\" onChange='document.forms[\"memberform\"].submit();'>
	<option value=\"all\"".$sel_all.">any age</option>
	<option value=\"u18\"".$sel_u18.">under 18</option>
	<option value=\"1825\"".$sel_1825.">18-25</option>
	<option value=\"2635\"".$sel_2635.">26-35</option>
	<option value=\"3650\"".$sel_3650.">36-50</option>
	<option value=\"5165\"".$sel_5165.">51-65</option>
	<option value=\"o65\"".$sel_o65.">over 65</option>
	</select>
	gender filter&nbsp;
	<select name=\"genderfilter\" onChange='document.forms[\"memberform\"].submit();'>
	<option value=\"either\"".$sel_either.">either gender</option>
	<option value=\"male\"".$sel_male.">male</option>
	<option value=\"female\"".$sel_female.">female</option>
	</select>
	sort by&nbsp;
	<select name=\"membersort\" onChange='document.forms[\"memberform\"].submit();'>
	<option value=\"newest\"".$newsel.">newest members</option>
	<option value=\"login\"".$logsel.">last login</option>
	</select>
	</div><br>search username <input type=\"text\" size=\"30\" name=\"namesearch\" value=\"".$nsearchvar."\"> search location <input type=\"text\" size=\"30\" name=\"locationsearch\" value=\"".$lsearchvar."\"><input type=\"submit\" class=\"biggerbutton\" name=\"formsubmit\" value=\"search\">
		</form><br>".$filterlink."<br><br>" ;
		$db->query($query) ;
		$resLV = $db->fetchAll() ;
		//Create output for member list results
		if (isset($_GET['page']))
			$output .= displayMemberList($resLV, $_GET['page'], $searchurl) ;
		else {
			$output .= displayMemberList($resLV, 1, $searchurl) ;
		}
		return $output ;
	}
}
function displayMemberList($res, $page = 1, $url = "", $nomr = false) {
	global $db,$sitepath,$templateimagepath ;
	$perpage = getSetting("membersperpage", $db) ;
	$pages = ceil(sizeof($res) / $perpage) ;
	$path = getSetting("sitefolder", $db) ;
	$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= "<a class=\"prevp\" href='".$url."?mp=".$pp."'>Previous Page</a>" ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
		else {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "<em>$p</em> " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "<em>$p</em> " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
		else {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
	}
	$pageLinks .= "</div></div></div></div>" ;
	$output = '<ul class="no-format horiz-thumbs-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++) {
		unset($res[$i]) ;
	}
	$colcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['activationkey'] == 0) {
			$count++ ;
			$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
			$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
			if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
				$avatar = $sitepath."uploads/avatars/".$value['avatar'] ;
			}
			$avatar = str_replace(" ", "%20", $avatar) ;
			$id = $value['id'] ;
			$username = $value['username'] ;
			$db->query("SELECT id FROM media WHERE status='true' AND poster ='".$username."'".$hide." ORDER BY allviews DESC") ;
			$mediacount = $db->numRows() ;
			$rres = $db->fetch() ;
			$db->query("SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$id." OR friend.friendid =".$id.") AND (username!='".$username."') AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id") ;
			$friendcount = $db->numRows() ;
			$output .= "<li><a href=\"".$sitepath."profile/$username\"><img class=\"thumb\" src='".$avatar."' /></a>\n" ;
			$value['username'] = force_length($value['username'], 25) ;
			$output .= "<p><a href=\"".$sitepath."profile/$username\">".$value['username']."</a></p><h4>friends: $friendcount</h4><h4>media: $mediacount</h4><h4>profile views: ".$value['profileviews']."</h4>" ;
			$output .= "</li>\n" ;
			if ($count == $perpage)
				break ;
		}
	}
	$output .= "<li class=\"clear\">&nbsp;</li>\n" ;
	$output .= "</ul>" ;
	if ($pages != 1)
		$output .= $pageLinks ;
	return $output ;
}
?>