<?php 
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: groups.inc
 *    Description: Functions for managing groups
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
function allGroups() {
	global $db,$loggedIn,$sitepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/groups_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = allGroups_new() ;
		return $output ;
	}
	else {
		$filter = '' ;
		if ($_GET['filter'] != "") {
			$filter = $_GET['filter'] ;
		}
		$search = '' ;
		$searchvar = '' ;
		$searchurl = '' ;
		$sort = '' ;
		if ($_GET['search'] != "") {
			$searchvar = "__".$_GET['search'] ;
			$searchformvar = $_GET['search'] ;
		}
		if ($_POST['groupsearch'] != "") {
			$searchvar = "__".$_POST['groupsearch'] ;
			$searchformvar = $_POST['groupsearch'] ;
		}
		$nasel = "" ;
		$ndsel = "" ;
		$gasel = "" ;
		$gdsel = "" ;
		if ($searchvar != '') {
			$search = " AND ((name LIKE '%".$searchformvar."%') OR (`group_description` LIKE '%".$searchformvar."%'))" ;
			$searchurl = $sitepath."groups/_".$filter."/".urlencode($searchvar) ;
		}
		$joinedonlyurl = $sitepath."groups/_joined/".$searchvar ;
		$notjoinedonlyurl = $sitepath."groups/_notjoined/".$searchvar ;
		$allurl = $sitepath."groups/_all/".$searchvar ;
		$filterlink = "show: <b>all groups</b> | <a href='".$joinedonlyurl."'>only groups I have joined</a> | <a href='".$notjoinedonlyurl."'>only groups I have not joined</a>" ;
		$newsel = "SELECTED" ;
		//ALL GROUPS (EXCLUDING SUSPENDED) ORDERED BY CREATED DATE
		$query = "select * from `group` WHERE (`suspended`=0)".$search." ORDER BY created DESC" ;
		if ($filter == "joined") {
			$filterlink = "show: <a href='".$allurl."'>all groups</a> | <b>only groups I have joined</b> |<a href='".$notjoinedonlyurl."'>only groups I have not joined</a>" ;
			if ($loggedIn) {
				$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'").$sort ;
				$res = $db->fetch() ;
				$memberid = $res['id'] ;
				//GROUPS I HAVE JOINED OR OWN (INCLUDING SUSPENDED)
				$query = "SELECT * FROM `group` WHERE (`group_id`  IN (select `group_id` from `group_member` RIGHT JOIN `group` ON `group_member`.`group_id_g`=`group`.`group_id` WHERE (`member_id`=".$memberid.") OR (`owner_id`=".$memberid.")))".$search." ORDER BY created DESC" ;
			}
		}
		if ($filter == "notjoined") {
			$filterlink = "show: <a href='".$allurl."'>all groups</a> | <a href='".$joinedonlyurl."'>only groups I have joined</a> | <b>only groups I have not joined</b>" ;
			if ($loggedIn) {
				$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
				$res = $db->fetch() ;
				$memberid = $res['id'] ;
				//GROUPS I HAVE NOT JOINED AND DO NOT OWN (EXCLUDING SUSPENDED)
				$query = "SELECT * FROM `group` WHERE (`group_id` NOT IN (select `group_id` from `group_member` RIGHT JOIN `group` ON `group_member`.`group_id_g`=`group`.`group_id` WHERE (`member_id`=".$memberid.") OR (`owner_id`=".$memberid."))) AND (`suspended`=0 )".$search." ORDER BY created DESC" ;
			}
		}
		if ($_POST['groupsort'] == 'mostpopular') {
			$popsel = "SELECTED" ;
			//ALL GROUPS (EXCEPT SUSPENDED) ORDERED BY NUMBER OF MEMBERS
			$query = "select * from `group` AS `grp` LEFT JOIN (select `group_id_g`,count(`group_id_g`) as count from `group_member` WHERE `approved`=1 GROUP BY `group_id_g`) AS `cnt` ON `grp`.`group_id`=`cnt`.`group_id_g` WHERE (`suspended`=0)".$search." ORDER BY cnt.count DESC" ;
			if ($filter == "joined") {
				$filterlink = "show: <a href='".$allurl."'>all groups</a> | <b>only groups I have joined</b> |<a href='".$notjoinedonlyurl."'>only groups I have not joined</a>" ;
				if ($loggedIn) {
					$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'").$sort ;
					$res = $db->fetch() ;
					$memberid = $res['id'] ;
					//GROUPS I HAVE JOINED OR OWN (INCLUDING SUSPENDED)
					$query = "select * from `group` AS `grp` LEFT JOIN	 (select `group_id_g`,count(`group_id_g`) as count from `group_member` WHERE `approved`=1 GROUP BY `group_id_g`) AS `cnt` ON `grp`.`group_id`=`cnt`.`group_id_g` WHERE (`grp`.`group_id`  IN (select `group_id` from `group_member` RIGHT JOIN `group` ON group_member`.`group_id_g`=`group`.`group_id` WHERE (`member_id`=".$memberid.") OR (`owner_id`=".$memberid.")))".$search." ORDER BY cnt.count DESC" ;
				}
			}
			if ($filter == "notjoined") {
				$filterlink = "show: <a href='".$allurl."'>all groups</a> | <a href='".$joinedonlyurl."'>only groups I have joined</a> | <b>only groups I have not joined</b>" ;
				if ($loggedIn) {
					$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
					$res = $db->fetch() ;
					$memberid = $res['id'] ;
					//GROUPS I HAVE NOT JOINED AND DO NOT OWN (EXCLUDING SUSPENDED)
					$query = "select * from `group` AS `grp` LEFT JOIN	 (select `group_id_g`,count(`group_id_g`) as count from `group_member` WHERE `approved`=1 GROUP BY `group_id_g`) AS `cnt` ON `grp`.`group_id`=`cnt`.`group_id_g` WHERE (`suspended`=0) AND (`grp`.`group_id`  NOT IN (select `group_id` from `group_member` RIGHT JOIN `group` ON  `group_member`.`group_id_g`=`group`.`group_id` WHERE (`member_id`=".$memberid.") OR (`owner_id`=".$memberid.")))".$search." ORDER BY cnt.count DESC" ;
				}
			}
		}
		$db->query($query) ;
		$resTR = $db->fetchAll() ;
		$sitefolder = getSetting("sitefolder", $db) ;
		$path = 'http://'.$_SERVER['SERVER_NAME'].$sitefolder.'groups' ;
		if (!$loggedIn) {
			$filterlink = '' ;
		}
		$output = "<form action=\"".$searchurl."\" method=\"POST\" name=\"groupform\"><input type=\"text\" size=\"30\" name=\"groupsearch\" value=\"".$searchformvar."\">&nbsp;<input type=\"submit\" class=\"biggerbutton\" name=\"formsubmit\" value=\"search\">&nbsp;sort by&nbsp;
		
	<select name=\"groupsort\" onChange='document.forms[\"groupform\"].submit();'>
	<option value=\"newest\"".$newsel.">newest groups</option>
	<option value=\"mostpopular\"".$popsel.">most popular</option>
	</select>
		
		</form><br>".$filterlink."<br><br>" ;
		if ($db->numRows() > 0) {
			if (isset($_GET['page']))
				$output .= displayAllGroups($resTR, $_GET['page'], $path) ;
			else
				$output .= displayAllGroups($resTR, 1, $path) ;
		}
		else {
			$output .= "<h2>There are no groups to display</h2>" ;
		}
		return $output ;
	}
}

function displayAllGroups($res, $page = 1, $url) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	$perpage = getsetting("allgroupspp", $db) ;
	$size = sizeof($res) ;
	$pages = ceil($size / $perpage) ;
	$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
		else {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
		else {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
	}
	$pageLinks .= "</div></div></div>" ;
	$output = '<ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$loggedInid = $idres['id'] ;
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	$colcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['activationkey'] == 0) {
			$count++ ;
			$iconfile = "" ;
			if (@file_exists("uploads/groupicons/".$value['icon']) && ($value['icon'] != "")) {
				$iconfile = $sitepath."uploads/groupicons/".$value['icon'] ;
			}
			else {
				$iconfile = $templateimagepath."default_group_thumb.jpg" ;
			}
			$groupid = $value['group_id'] ;
			$groupname = force_length(stripslashes($value['name']), 64) ;
			$groupdesc = force_length(stripslashes($value['group_description']), 150) ;
			$grouppriv = $value['privacy'] ;
			$groupowner = $value['owner_id'] ;
			$db->query("SELECT username FROM member WHERE id = ".$groupowner) ;
			$userres = $db->fetch() ;
			$ownername = $userres['username'] ;
			$ownerlink = $sitepath.'profile/'.$ownername ;
			$privacy = ' (public)' ;
			if ($grouppriv == 1) {
				$privacy = ' (private)' ;
			}
			if ($loggedIn) {
				$db->query("SELECT * FROM group_member WHERE group_id_g=".$groupid." AND member_id=".$loggedInid." AND approved=1") ;
				$isMember = $db->numRows() > 0 ;
			}
			else {
				$isMember = false ;
			}
			$db->query("SELECT * FROM group_member WHERE group_id_g=".$groupid." AND approved=1") ;
			$members = $db->numRows() ;
			if ($members != 1) {
				$s = 's' ;
			}
			else {
				$s = '' ;
			}
			$viewlink = $sitepath.'showgroup/'.url_encode($groupname) ;
			if ($iconfile != "") {
				$iconurl = '<img class="thumb" src="'.$iconfile.'">' ;
			}
			else {
				$iconurl = '' ;
			}
			$memStatus = '' ;
			if ($loggedIn) {
				if ($groupowner == $loggedInid) {
					$memStatus = '<a href="'.$viewlink.'">you own this group</a>' ;
				}
				else {
					if ($isMember) {
						$memStatus = '<a href="'.$viewlink.'/leave">click here to leave</a>' ;
					}
					else {
						$memStatus = '<a href="'.$viewlink.'/join">click here to join</a>' ;
					}
				}
			}
			$output .= '<li><a href="'.$viewlink.'">'.$iconurl.'</a>
				<h3><b><a href="'.$viewlink.'">&nbsp;&nbsp;'.$groupname.'</a></b></h3>
				<p><b>&nbsp;&nbsp;'.$groupdesc.'</b></p><div class="inf"><div class="inf-right"><b>created by&nbsp;<a href="'.$ownerlink.'">'.$ownername.'</a>'.$privacy.' '.$memStatus.'</b> <span class="views"><b>members:</b>'.$members.'</span></div></div></li>' ;
			$colcount++ ;
			if ($count == $perpage)
				break ;
		}
	}
	if ($pages > 0)
		$output .= $pageLinks ;
	$output .= "</ul>" ;
	return $output ;
}

?>
