<?php 
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: show_media.inc
 *    Description: Admin options for managing media
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
require_once "includes/imagefunctions.inc" ;
$path = getSetting("sitefolder", $db) ;
$sitefolder = "http://".$_SERVER['SERVER_NAME'].$path ;
$search = $_POST['search'] ;
$pageLinks = "" ;
$db->query("SELECT mediaAD FROM media WHERE id = '".$_GET['edit']."'") ;
$res = $db->fetch() ;
$db->query("SELECT embed FROM media WHERE id = '".$_GET['edit']."'") ;
$res1 = $db->fetch() ;
function genmediaList() {
	global $db,$pageLinks,$sitepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/admin/show_media_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = genmediaList_new() ;
		return $output ;
	}
	else {
		$search = $_POST['search'] ;
		$ret = "" ;
		$searchstring = '' ;
		if ($search != '') {
			$searchstring = " AND `title` LIKE '%".$search."%'" ;
		}
		$db->query("SELECT * FROM `media` WHERE `status` = 'true'".$searchstring) ;
		$totalvids = $db->numRows() ;
		if (isset($_GET['p']))
			$page = intval($_GET['p']) ;
		else
			$page = 1 ;
		$perpage = getSetting("admin_perpage", $db) ;
		$pages = ceil($totalvids / $perpage) ;
		$pageLinks = "" ;
		//Page formatting
		$pageLinks = "<div id='pageLinks'>Pages: " ;
		if ($pages > 10 && $page > 6)
			$pageLinks .= "<a href='".$sitepath."?id=103'>1</a> ... " ;
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if ($p == $page)
				$pageLinks .= "<em>$p</em> " ;
			else
				$pageLinks .= "<a href='".$sitepath."?id=103&p=$p'>$p</a> " ;
		}
		if ($pages > 10)
			$pageLinks .= "... <a href='".$sitepath."?id=103&p=$pages'>$pages</a>" ;
		$pageLinks .= "</div>" ;
		$limitstart = ($page - 1) * $perpage ;
		$db->query("SELECT * FROM `media` WHERE `status` = 'true'".$searchstring." ORDER BY `id` DESC LIMIT $limitstart, $perpage ") ;
		$res = $db->fetchAll() ;
		$countr = $db->numRows() ;
		if ($countr > 0) {
			$count = $limitstart + 1 ;
			foreach ($res as $row) {
				$db->query("SELECT * FROM `category` WHERE id = '".$row['category']."'") ;
				$_cat = $db->fetch() ;
				$encat = url_encode($_cat['name']) ;
				$entit = url_encode($row['title']) ;
				$kat = getCategoryPath($row['category']) ;
				$matureyesno = $row['requires_agreement'] > 0 ? '<b><font color=red>yes</font></b>' : '<b>no</b>' ;
				$flaggedyesno = $row['flagged'] > 0 ? '<b><font color=red>yes</font></b>' : '<b>no</b>' ;
				$featuredyesno = $row['featured'] > 0 ? '<b><font color=red>yes</font></b>' : '<b>no</b>' ;
				if (strlen($row['title']) > 30)
					$row['title'] = substr($row['title'], 0, 20)."..." ;
				$ret .= "<tr><th>$count</th><td><a href='".$sitepath."play$kat/$entit' target=\"_blank\" alt=\"Play\">".force_length($row['title'], 18)."</a></td><td align=center>".$row['mediatype']."</td><td>".force_length($_cat['name'], 18)."</td><td>".date("d.m.Y", $row['added'])."</td><td align=center>".$flaggedyesno."</td><td align=center>".$matureyesno."</td><td align=center>".$featuredyesno."</td><td><a href='".$sitepath."index.php?id=103&amp;edit=".$row['id']."'>[edit]</a></td><td class='td_select'><input class='checkbox' name='vid".$row['id']."' type='checkbox' /></td></tr>" ;
				$count++ ;
			}
		}
		else {
			return false ;
		}
		return $ret ;
	}
}
if (isset($_POST['submit'])) {
	if (isset($_POST['day']) && isset($_POST['month']) && isset($_POST['year']) && isset($_POST['hour']) && isset($_POST['minute']) && isset($_POST['second'])) {
		$added = mktime(intval($_POST['hour']), intval($_POST['minute']), intval($_POST['second']), intval($_POST['month']), intval($_POST['day']), intval($_POST['year'])) ;
		$db->query("UPDATE media SET `added` = '$added' WHERE id = '".quote_smart($_GET['edit'])."'") ;
	}
	$db->query("UPDATE media SET `category` = '".quote_smart($_POST['cat'])."' WHERE id = '".quote_smart($_GET['edit'])."'") ;
	//Strip special chars
	$_POST['dis'] = block_tags($_POST['dis']) ;
	$db->query("UPDATE media SET `title` = '".quote_smart($_POST['title'])."' WHERE id = '".quote_smart($_GET['edit'])."'") ;
	$db->query("UPDATE media SET `tags` = '".quote_smart($_POST['tags'])."' WHERE id = '".quote_smart($_GET['edit'])."'") ;
	$db->query("UPDATE media SET `description` = '".quote_smart($_POST['dis'])."' WHERE id = '".quote_smart($_GET['edit'])."'") ;
	$db->query("UPDATE media SET `category` = '".quote_smart($_POST['kat'])."' WHERE id = '".quote_smart($_GET['edit'])."'") ;
	$db->query("UPDATE `media` SET `url` = '".quote_smart(url_clean($_POST['title']))."' WHERE `id` = '".quote_smart($_GET['edit'])."'") ;
	$db->query("UPDATE media SET mediaAD = '".$_POST['ads']."' WHERE id = '".$_GET['edit']."'") ;
	$db->query("UPDATE media SET embed = '".$_POST['embed']."' WHERE id = '".$_GET['edit']."'") ;
	$db->query("SELECT * FROM media WHERE id = '".quote_smart($_GET['edit'])."'") ;
	$resE = $db->fetch() ;
	//Upload new thumb
	if (file_exists($_FILES['thumbnail']['tmp_name'])) {
		$filename = $resE['thumb'] ;
		$ext = substr($_FILES['thumbnail']['name'], strrpos($_FILES['thumbnail']['name'], ".") + 1) ;
		$thumbfile = findThumb($filename) ;
		$thumbname = md5(uniqid(rand())).'_'.preg_replace("/([^a-zA-Z0-9\.]+)/", '', $_FILES['thumbnail']['name']) ;
		if (move_uploaded_file($_FILES['thumbnail']['tmp_name'], './uploads/thumbs/'.$_FILES['thumbnail']['name'])) {
			if (!createThumb($_FILES['thumbnail']['name'], getSetting("thumb_w1", $db), getSetting("thumb_h1", $db), './uploads/thumbs/', './uploads/thumbs/', $thumbname.".large.".$ext))
				$message = "Error creating large thumbnail. Other values saved ok." ;
			if (!createThumb($_FILES['thumbnail']['name'], getSetting("thumb_w2", $db), getSetting("thumb_h2", $db), './uploads/thumbs/', './uploads/thumbs/', $thumbname.".small.".$ext))
				$message .= "<br/>Error creating small thumbnail. Other values saved ok." ;
			if (file_exists($thumbfile[0]) && $thumbfile[0] != "uploads/thumbs/".$thumbname.".small.".$ext && !isset($message))
				unlink($thumbfile[0]) ;
			if (file_exists($thumbfile[1]) && $thumbfile[1] != "uploads/thumbs/".$thumbname.".large.".$ext && !isset($message))
				unlink($thumbfile[1]) ;
			$db->query("UPDATE `media` SET `thumb` = '".$thumbname."' WHERE `id` = '".$_GET['edit']."'") ;
		}
		else {
			$message = "Error moving uploaded thumbnail." ;
		}
	}
	else {
	}
	if (!isset($message)) {
		$message = "Changes saved succesfully." ;
		unset($_GET['edit']) ;
	}
}
if (!isset($_POST['func'])) {
	if (!isset($_GET['edit'])) {
		$mediaList = genmediaList() ;
		if (!$mediaList)
			$message = "There are no media." ;
	}
	else {
		$db->query("SELECT * FROM media WHERE id = '".quote_smart($_GET['edit'])."'") ;
		$resVid = $db->fetch() ;
		if ($resVid['embed'] != '')
			$embedcode = $resVid['embed'] ;
		$editmedia = true ;
		$db->query("SELECT * FROM `category` WHERE `ptr` = 0 AND `parent` = '0' ORDER BY `name`") ;
		$resCO = $db->fetchAll() ;
		$catOptions = "" ;
		$sql = "SELECT * FROM `category` WHERE level=1 ORDER BY name DESC" ;
		$result = mysql_query($sql) or die(mysql_error()) ;
		if ($result) {
			$tmp = '' ;
			while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
				$sel = "" ;
				if (isset($selected))
					if ($selected == $row['id'])
						$sel = " selected" ;
				$catOptions .= "<option$sel value=\"".$row['id']."\">".$row['name']."</option>" ;
				//Subcats
				$db->query("SELECT * FROM category WHERE parent = '".$row['id']."' ORDER BY name") ;
				if ($db->numRows() > 0) {
					$subCats = $db->fetchAll() ;
					foreach ($subCats as $sub) {
						$sel = "" ;
						if (isset($selected))
							if ($selected == $sub['id'])
								$sel = " selected" ;
						$catOptions .= "<option$sel value=\"".$sub['id']."\">--->".$sub['name']."</option>" ;
						//Subsubcats
						$db->query("SELECT * FROM category WHERE parent = '".$sub['id']."' ORDER BY name") ;
						if ($db->numRows() > 0) {
							$subsubCats = $db->fetchAll() ;
							foreach ($subsubCats as $subsub) {
								$sel = "" ;
								if (isset($selected))
									if ($selected == $subsub['id'])
										$sel = " selected" ;
								$catOptions .= "<option$sel value=\"".$subsub['id']."\">------->".$subsub['name']."</option>" ;
							}
						}
					}
				}
			}
		}
	}
}
else {
	if ($_POST['func'] == "Delete Selected") {
		$db->query("SELECT * FROM media WHERE status = 'true'") ;
		$resv = $db->fetchAll() ;
		foreach ($resv as $resCheck) {
			if (isset($_POST['vid'.$resCheck['id']])) {
				if ($resCheck['thumb'] != 'usr_upload.jpg') {
					if (file_exists('uploads/thumbs/'.$resCheck['thumb'].'.small.jpg') && file_exists('uploads/thumbs/'.$resCheck['thumb'].'.large.jpg')) {
						@unlink('uploads/thumbs/'.$resCheck['thumb'].'.small.jpg') ;
						@unlink('uploads/thumbs/'.$resCheck['thumb'].'.large.jpg') ;
					}
					if (file_exists('uploads/thumbs/'.$resCheck['thumb'].'.prv')) {
						@unlink('uploads/thumbs/'.$resCheck['thumb'].'.prv') ;
					}
				}
				if ($resCheck['mediatype'] != 'embed') {
					@unlink('uploads/'.$resCheck['mediaurl']) ;
				}
				$db->query("DELETE FROM `media` WHERE id = '".$resCheck['id']."'") ;
				$db->query("DELETE FROM `favorite` WHERE `vidid` = '".$resCheck['id']."'") ;
			}
		}
		$message = "Media was deleted successfully<br><br>" ;
	}
	elseif ($_POST['func'] == "Generate Thumbnails") {
		$db->query("SELECT * FROM media WHERE status = 'true'") ;
		$resv = $db->fetchAll() ;
		foreach ($resv as $resCheck) {
			if (isset($_POST['vid'.$resCheck['id']])) {
				$filename = $resCheck['mediaurl'] ;
				$upload_path = $_SERVER['DOCUMENT_ROOT'].$path.'uploads/' ;
				if ($resCheck['mediatype'] == "video") {
					$sw = getSetting("thumb_w2", $db) ;
					$lw = getSetting("thumb_w1", $db) ;
					$sh = getSetting("thumb_h2", $db) ;
					$lh = getSetting("thumb_h1", $db) ;
					$ffmpegpath = getSetting("ffmpegpath", $db) ;
					$ext = strtolower(substr($filename, strrpos($filename, '.') + 1)) ;
					$filename_without_ext = $filename ;
					$ext_pos = strrchr($filename, '.') ;
					if ($ext_pos !== false) {
						$filename_without_ext = substr($filename, 0, -strlen($ext_pos)) ;
					}
					exec($ffmpegpath." -y -i ".$upload_path.$filename_without_ext.".flv -f mjpeg -s ".$sw."x".$sh." -vframes 1 -ss ".getSetting("default_thumbtime", $db)." -an ".$upload_path."thumbs/".$filename_without_ext.".small.jpg") ;
					exec($ffmpegpath." -y -i ".$upload_path.$filename_without_ext.".flv -f mjpeg -s ".$lw."x".$lh." -vframes 1 -ss ".getSetting("default_thumbtime", $db)." -an ".$upload_path."thumbs/".$filename_without_ext.".large.jpg") ;
					createVideoPreview($filename_without_ext,400) ;
					$db->query("UPDATE media SET thumb='".$filename_without_ext."' WHERE id=".$resCheck['id']) ;
				}
				else if ($resCheck['mediatype'] == "image") {
					$sw = getSetting("thumb_w2", $db) ;
					$lw = getSetting("thumb_w1", $db) ;
					$sh = getSetting("thumb_h2", $db) ;
					$lh = getSetting("thumb_h1", $db) ;
					$ext = strtolower(substr($filename, strrpos($filename, '.') + 1)) ;
					$filename_without_ext = $filename ;
					$ext_pos = strrchr($filename, '.') ;
					if ($ext_pos !== false) {
						$filename_without_ext = substr($filename, 0, -strlen($ext_pos)) ;
					}
					$thumbspath = $_SERVER['DOCUMENT_ROOT'].$path."uploads/thumbs/" ;
					resizeImage($upload_path.$filename_without_ext, $ext, $sw, $sh, $thumbspath.$filename_without_ext.".small.jpg", true) ;
					resizeImage($upload_path.$filename_without_ext, $ext, $lw, $lh, $thumbspath.$filename_without_ext.".large.jpg", true) ;
					$db->query("UPDATE media SET thumb='".$filename_without_ext."' WHERE id=".$resCheck['id']) ;
				}
			}
		}
		$message = "Thumbnails generated" ;
	}
	else if ($_POST['func'] == "Set as Mature Content") {
		$db->query("SELECT * FROM media WHERE status = 'true'") ;
		$resv = $db->fetchAll() ;
		foreach ($resv as $resCheck) {
			if (isset($_POST['vid'.$resCheck['id']])) {
				$db->query("UPDATE `media` SET `requires_agreement`=1  WHERE id = '".$resCheck['id']."'") ;
				$db->query("UPDATE `media` SET `flagged`=0  WHERE id = '".$resCheck['id']."'") ;
			}
		}
		$message = "Media set as mature content" ;
	}
	else if ($_POST['func'] == "Set as NOT Mature Content") {
		$db->query("SELECT * FROM media WHERE status = 'true'") ;
		$resv = $db->fetchAll() ;
		foreach ($resv as $resCheck) {
			if (isset($_POST['vid'.$resCheck['id']])) {
				$db->query("UPDATE `media` SET `requires_agreement`=0  WHERE id = '".$resCheck['id']."'") ;
			}
		}
		$message = "Media set as NOT mature content" ;
	}
	else if ($_POST['func'] == "Remove Flag") {
		$db->query("SELECT * FROM media WHERE status = 'true'") ;
		$resv = $db->fetchAll() ;
		foreach ($resv as $resCheck) {
			if (isset($_POST['vid'.$resCheck['id']])) {
				$db->query("UPDATE `media` SET `flagged`=0  WHERE id = '".$resCheck['id']."'") ;
			}
		}
		$message = "Member flag removed" ;
	}
	else if ($_POST['func'] == "Set as Featured Content") {
		$db->query("SELECT * FROM media WHERE status = 'true'") ;
		$resv = $db->fetchAll() ;
		foreach ($resv as $resCheck) {
			if (isset($_POST['vid'.$resCheck['id']])) {
				$db->query("UPDATE `media` SET `featured`=1  WHERE id = '".$resCheck['id']."'") ;
			}
		}
		$message = "Content set as Featured" ;
	}
	else if ($_POST['func'] == "Set as NOT Featured Content") {
		$db->query("SELECT * FROM media WHERE status = 'true'") ;
		$resv = $db->fetchAll() ;
		foreach ($resv as $resCheck) {
			if (isset($_POST['vid'.$resCheck['id']])) {
				$db->query("UPDATE `media` SET `featured`=0  WHERE id = '".$resCheck['id']."'") ;
			}
		}
		$message = "Content set as NOT Featured" ;
	}
	$mediaList = genmediaList() ;
	if (!$mediaList)
		$message = "There are no media." ;
}
?>