/*
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: Animated.js
 *    Description: Plays animated thumbnail swf files
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
var loaded = new Array(-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1);
var contents = new Array('', '', '', '', '', '', '', '', '');
var played = new Array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
loadedcount = 0;
maxload = 5; //maximum number of flash thumbnails on the page at any time; warning! not all browsers will load more than 5 simultaneously
function replace_thumb(index, html){
    if (played[index] < 1) {
        document.getElementById("thumb" + index).innerHTML = html;
        played[index]++;
    }
}
//this function keeps a list of loaded video thumbnails and never lets the number currently loaded above 'maxload'
function start_thumb(index, thumbname){
    //increase count of loaded swfs
    loadedcount++;
    //store the contents of this div for later
    this_contents = document.getElementById("thumb" + index).innerHTML;
    //start the video thumbnail
    var so = new SWFObject(thumbname + ".prv", "sotester", "96", "96", "9", "#8080a0");
    so.addParam("loop", "false");
    so.addParam("wmode", "transparent");
    so.addParam("allowScriptAccess", "true");
    so.addParam("cursor", "hand");
    so.write("thumb" + index);
    played[index] = 0;
    //check if we reached the max limit
    if (loadedcount > maxload) {
        //check the one we are about to put back as it was, is not the same one we just clicked       
        if (index != loaded[maxload - 1]) {
            //put the contents of the oldest div back as it was
            document.getElementById("thumb" + loaded[maxload - 1]).innerHTML = contents[maxload - 1];
        }
        //don't let the count go over the limit 
        loadedcount = maxload;
    }
    //shift all the indices and div contents up one
    for (x = loadedcount - 1; x >= 0; x--) {
        loaded[x + 1] = loaded[x];
        contents[x + 1] = contents[x];
    }
    //put this div in the 0 position
    loaded[0] = index;
    //now check this div has not already has it's original contents stored (or we might store a playing video which would be bad)
    found = -1;
    for (x = 1; x < loadedcount; x++) {
        if (loaded[x] == index) {
            found = x;
        }
    }
    if (found < 0) {
        contents[0] = this_contents;
    }
    else {
        contents[0] = contents[found];
    }
    
}