<?php
/*
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: usercp.inc
 *    Description: User control panel
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
include_once "includes/imagefunctions.inc" ;
include_once "includes/groupsavailable.inc" ;
global $db,$exists,$privacyOption,$rootpath ;
$exists = false ;
function delfile($str) {
	foreach (glob($str) as $fn) {
		unlink($fn) ;
	}
}
function catOptions($selected) {
	global $sitepath,$db ;
	$result = '' ;
	$sql = "SELECT * FROM `category` WHERE parent = '0' ORDER BY name DESC" ;
	$db->query($sql) ;
	if ($db->numRows() > 0) {
		$tmp = '' ;
		$cats = $db->fetchAll() ;
		foreach ($cats as $cat) {
			$sel = "" ;
			if ($selected == $cat['id'])
				$sel = " selected" ;
			$result .= "<option$sel value=\"".$cat['id']."\">".$cat['name']."</option>" ;
			//Subcats
			$db->query("SELECT * FROM category WHERE parent = '".$cat['id']."' ORDER BY name") ;
			if ($db->numRows() > 0) {
				$subCats = $db->fetchAll() ;
				foreach ($subCats as $sub) {
					$sel = "" ;
					if ($selected == $sub['id'])
						$sel = " selected" ;
					$result .= "<option$sel value=\"".$sub['id']."\">--->".$sub['name']."</option>" ;
					//Subsubcats
					$db->query("SELECT * FROM category WHERE parent = '".$sub['id']."' ORDER BY name") ;
					if ($db->numRows() > 0) {
						$subsubCats = $db->fetchAll() ;
						foreach ($subsubCats as $subsub) {
							$sel = "" ;
							if ($selected == $subsub['id'])
								$sel = " selected" ;
							$result .= "<option$sel value=\"".$subsub['id']."\">------->".$subsub['name']."</option>" ;
						}
					}
				}
			}
		}
	}
	return $result ;
}
if (!$loggedIn) {
	$haltMessage = "<h2>You must log in to use Control Panel features</h2>" ;
}
else {
	if ($_GET['action'] == 'dm')
	// Delete a message
	{
		if ($_GET['page'] > 0) {
			$db->query("DELETE FROM message WHERE messageid = ".quote_smart($_GET['page'])) ;
		}
	}
	if ($_GET['action'] == 'ds')
	// Delete a sent message
	{
		if ($_GET['page'] > 0) {
			$db->query("DELETE FROM message WHERE messageid = ".quote_smart($_GET['page'])) ;
		}
	}
	if (isset($_POST['groupsubmit'])) {
		$db->query("UPDATE `media` SET `groupid`=".quote_smart($_POST['groups'])." WHERE `id`=".quote_smart($_POST['mediaid'])) ;
	}
	if (isset($_POST['catsubmit'])) {
		$db->query("UPDATE `media` SET `category`=".quote_smart($_POST['categories'])." WHERE `id`=".quote_smart($_POST['mediaid'])) ;
	}
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$res = $db->fetch() ;
	$curEmail = $res['email'] ;
	$curAvatar = $res['avatar'] ;
	$curAge = $res['age'] ;
	$curGender = $res['gender'] ;
	$curLocation = $res['location'] ;
	$curAboutme = $res['aboutme'] ;
	$curPassword = $res['password'] ;
	$username = $res['username'] ;
	$curHide = $res['hidemature'] ;
	$curOptout = $res['optoutofviewerlist'] ;
	$profileViews = $res['profileviews'] ;
	$opt = $res['opt'] ;
	$privacy = $res['profile_privacy'] ;
	$profileid = $res['id'] ;
	$history = $res['history'] ;
	$deletemedia = $_POST['deletemediaid'] ;
	if ($deletemedia > 0) {
		$db->query("DELETE FROM favorite WHERE vidid = ".$deletemedia) ;
		$db->query("DELETE FROM `media_comment` WHERE vid_id = ".$deletemedia) ;
		$db->query("DELETE FROM `rating` WHERE id = ".$deletemedia) ;
		$vidstring = $deletemedia.':' ;
		$history = str_replace($vidstring, '', $history) ;
		$db->query("UPDATE member SET history = '".$history."' WHERE id=".$profileid) ;
		$db->query("SELECT thumb,mediaurl FROM media WHERE id=".$deletemedia) ;
		$dres = $db->fetch() ;
		if (($dres['mediaurl'] != "") && ($dres['mediatype'] != 'embed'))
			unlink($rootpath.'uploads/'.$dres['mediaurl']) ;
		if ($dres['thumb'] != "") {
			unlink($rootpath.'uploads/thumbs/'.$dres['thumb'].'.large.jpg') ;
			unlink($rootpath.'uploads/thumbs/'.$dres['thumb'].'.small.jpg') ;
		}
		$db->query("DELETE FROM media WHERE id=".$deletemedia) ;
	}
	if ($_GET['action'] == 'dai')
	// Delete a message
	{
		$db->query("DELETE FROM message WHERE toid = ".$profileid) ;
	}
	if ($_GET['action'] == 'darq')
	// Delete a message
	{
		$db->query("DELETE FROM friend WHERE userid = ".$profileid) ;
	}
	if ($_GET['action'] == 'dasq')
	// Delete a message
	{
		$db->query("DELETE FROM friend WHERE friendid = ".$profileid) ;
	}
	if ($_GET['action'] == 'dao')
	// Delete a message
	{
		$db->query("DELETE FROM message WHERE fromid = ".$profileid) ;
	}
	if ($_GET['action'] == 'db')
	// Delete a message and block the member
	{
		if ($_GET['page'] > 0) {
			$db->query("SELECT * FROM message WHERE messageid = ".quote_smart($_GET['page'])) ;
			$mesRes = $db->fetch() ;
			$fromid = $mesRes['fromid'] ;
			$db->query("SELECT blocker_id FROM blocked WHERE blocker_id=".$profileid." AND blockee_id=".$fromid) ;
			if ($db->numRows < 1) {
				$db->query("INSERT INTO blocked (blocker_id,blockee_id) VALUES (".$profileid.",".$fromid.")") ;
			}
			$db->query("DELETE FROM friend WHERE userid=".$profileid." AND friendid=".$fromid) ;
			$db->query("DELETE FROM message WHERE messageid = ".quote_smart($_GET['page'])) ;
		}
	}
	//afr - Remove approved friend
	if ($_GET['action'] == 'rf') {
		if ($_GET['page'] > 0) {
			//Remove: check if i am the original requester
			$db->query('SELECT * FROM friend WHERE friendid='.$profileid.' AND userid='.quote_smart($_GET['page'])) ;
			if ($db->numRows() > 0) {
				//if i am, just make it 'removed = 1 approved = 0' goes back to a request, but removed
				$db->query('UPDATE friend SET friend_removed = 1 WHERE friendid='.$profileid.' AND userid='.quote_smart($_GET['page'])) ;
				$db->query('UPDATE friend SET friend_approved = 0 WHERE friendid='.$profileid.' AND userid='.quote_smart($_GET['page'])) ;
			}
			else {
				//if i'm not, need to reverse (delete and insert) the request, removed =1 approved = 0
				$db->query('DELETE FROM friend WHERE userid='.$profileid.' AND friendid='.quote_smart($_GET['page'])) ;
				$db->query('INSERT INTO friend (userid,friendid,friend_approved,friend_removed) VALUES ('.quote_smart($_GET['page']).','.$profileid.',0,1)') ;
			}
		}
	}
	$deletelink = $sitepath."usermenu/dl".$friendid ;
	if ($_GET['action'] == 'af')
	// Approve a friend - flag the record as approved
	{
		if ($_GET['page'] > 0) {
			$db->query("UPDATE friend SET friend_approved = 1 WHERE userid=".$profileid." AND friendid=".quote_smart($_GET['page'])) ;
			$db->query("UPDATE friend SET friend_removed = 0 WHERE userid=".$profileid." AND friendid=".quote_smart($_GET['page'])) ;
		}
	}
	if ($_GET['action'] == 'dr')
	// Decline a friend request - reverse the record and set removed
	{
		if ($_GET['page'] > 0) {
			$db->query('DELETE FROM friend WHERE userid='.$profileid.' AND friendid='.quote_smart($_GET['page'])) ;
			$db->query('INSERT INTO friend (userid,friendid,friend_approved,friend_removed) VALUES ('.quote_smart($_GET['page']).','.$profileid.',0,1)') ;
		}
	}
	if ($_GET['action'] == 'dcb')
	// Decline a friend request and block the member - deletes the record and adds a block record
	{
		if ($_GET['page'] > 0) {
			$db->query('DELETE FROM friend WHERE userid='.$profileid.' AND friendid='.quote_smart($_GET['page'])) ;
			$db->query("SELECT blocker_id FROM blocked WHERE blocker_id=".$profileid." AND blockee_id=".quote_smart($_GET['page'])) ;
			if ($db->numRows < 1) {
				$db->query("INSERT INTO blocked (blocker_id,blockee_id) VALUES (".$profileid.",".quote_smart($_GET['page']).")") ;
			}
		}
	}
	if ($_GET['action'] == 'dl')
	// Delete a declined friend request message record
	{
		if ($_GET['page'] > 0) {
			$db->query('DELETE FROM friend WHERE userid='.$profileid.' AND friendid='.quote_smart($_GET['page'])) ;
		}
	}
	if ($_GET['action'] == 'ra')
	// Send another friend request - reverse the record and set removed
	{
		if ($_GET['page'] > 0) {
			$db->query('DELETE FROM friend WHERE userid='.$profileid.' AND friendid='.quote_smart($_GET['page'])) ;
			$db->query('INSERT INTO friend (userid,friendid,friend_approved,friend_removed) VALUES ('.quote_smart($_GET['page']).','.$profileid.',0,0)') ;
		}
	}
	if ($_GET['action'] == 'rb')
	// Remove friend and block - unlike remove above, this deletes the record and then adds a block record if required
	{
		if ($_GET['page'] > 0) {
			$db->query("DELETE FROM friend WHERE (userid=".$profileid." AND friendid=".quote_smart($_GET['page']).") OR (friendid=".$profileid." AND userid=".quote_smart($_GET['page']).")") ;
			$db->query("SELECT blocker_id FROM blocked WHERE blocker_id=".$profileid." AND blockee_id=".quote_smart($_GET['page'])) ;
			if ($db->numRows < 1) {
				$db->query("INSERT INTO blocked (blocker_id,blockee_id) VALUES (".$profileid.",".quote_smart($_GET['page']).")") ;
			}
		}
	}
	if ($_GET['action'] == 'rcq')
	// Cancel request - removes the record
	{
		if ($_GET['page'] > 0) {
			$db->query("DELETE FROM friend WHERE  friendid=".$profileid." AND userid=".quote_smart($_GET['page'])) ;
		}
	}
	if ($_GET['action'] == 'rqr')
	// Remove request - also removes the record
	{
		if ($_GET['page'] > 0) {
			$db->query("DELETE FROM friend WHERE  friendid=".$profileid." AND userid=".quote_smart($_GET['page'])) ;
		}
	}
	if ($_GET['action'] == 'brm')
	// Remove block - deletes the record
	{
		if ($_GET['page'] > 0) {
			$db->query("DELETE FROM blocked WHERE  blocker_id=".$profileid." AND blockee_id=".quote_smart($_GET['page'])) ;
		}
	}
	if ($_GET['action'] == 'srm')
	// Remove subscription - deletes the record
	{
		if ($_GET['page'] > 0) {
			$db->query("DELETE FROM subscription WHERE  userid=".$profileid." AND subscribedtoid=".quote_smart($_GET['page'])) ;
		}
	}
	if ($_GET['action'] == 'rfav')
	// Remove favorite - deletes the record
	{
		if ($_GET['page'] > 0) {
			$db->query("DELETE FROM favorite WHERE userid=".$profileid." AND vidid=".quote_smart($_GET['page'])) ;
		}
	}
	if ($_GET['action'] == 'dh')
	// Remove history - clears the history field in the member record
	{
		$db->query("UPDATE member SET history=\"\" WHERE id=".$profileid) ;
	}
	if ($_GET['action'] == 'dw')
	// Remove history - clears the history field in the member record
	{
		$db->query("UPDATE member SET viewerhistory=\"\" WHERE id=".$profileid) ;
	}
	if ($_GET['action'] == 'rgm')
	// Remove an approved member from the group
	{
		if (($_GET['page'] > 0) && ($_GET['page2'] > 0)) {
			//Check the logged in user is the owner
			$groupid = quote_smart($_GET['page']) ;
			$memberid = quote_smart($_GET['page2']) ;
			$db->query("SELECT * FROM `group` WHERE `group_id` = ".$groupid." AND `owner_id` = ".$profileid) ;
			if ($db->numRows() > 0) {
				$db->query("DELETE FROM `group_member` WHERE  `group_id_g`=".$groupid." AND `member_id`=".$memberid) ;
			}
		}
	}
	if ($_GET['action'] == 'dgm')
	// Delete an unapproved member from the group
	{
		if (($_GET['page'] > 0) && ($_GET['page2'] > 0)) {
			//Check the logged in user is the owner
			$groupid = quote_smart($_GET['page']) ;
			$memberid = quote_smart($_GET['page2']) ;
			$db->query("SELECT * FROM `group` WHERE `group_id` = ".$groupid." AND `owner_id` = ".$profileid) ;
			if ($db->numRows() > 0) {
				$db->query("DELETE FROM `group_member` WHERE  `group_id_g`=".$groupid." AND `member_id`=".$memberid) ;
			}
		}
	}
	if ($_GET['action'] == 'agm')
	// Approve a friend - flag the record as approved
	{
		if (($_GET['page'] > 0) && ($_GET['page2'] > 0)) {
			//Check the logged in user is the owner
			$groupid = quote_smart($_GET['page']) ;
			$memberid = quote_smart($_GET['page2']) ;
			$db->query("SELECT * FROM `group` WHERE `group_id` = ".$groupid." AND `owner_id` = ".$profileid) ;
			if ($db->numRows() > 0) {
				$db->query("UPDATE `group_member` SET `approved` = 1 WHERE `group_id_g`=".$groupid." AND `member_id`=".$memberid) ;
			}
		}
	}
    $removelink = $sitepath."usermenu/rf/".$friendid ;
if ($privacy == 0) {
	$publicOn = " CHECKED" ;
}
if ($privacy == 1) {
	$registeredOn = " CHECKED" ;
}
if ($privacy == 2) {
	$privateOn = " CHECKED" ;
}
$privacyOption = '<li><label for="privacy">Profile privacy - who can send you messages and leave comments on your profile</label><fieldset><ol><li><b><INPUT TYPE=RADIO NAME="privacy" VALUE="0"'.$publicOn.'>&nbsp;Public - All visitors to the site</b></li><li><b><INPUT TYPE=RADIO NAME="privacy" VALUE="1"'.$registeredOn.'>&nbsp;Registered - Only registered, logged in members</b></li><li><b><INPUT TYPE=RADIO NAME="privacy" VALUE="2"'.$privateOn.'>&nbsp;Private - Only approved friends</b></li></ol></fieldset></li>' ;
// If password has not changed, ignore it
if ($curPassword == md5($_POST['password'])) {
	$_POST['password'] = "" ;
	$_POST['password2'] = "" ;
}
if (isset($_POST['newgroupsubmit'])) {
	//validate post variables
	$name = str_replace('"', '\'', $_POST['groupname']) ;
	$description = str_replace('"', '\'', $_POST['groupdesc']) ;
	if (($name == '') || ($description == '')) {
		echo "<h2>You must enter a name and a description</h2>" ;
	}
	else {
		$name = apply_word_censor($name) ;
		$description = apply_word_censor($description) ;
		if ($_POST['grouppriv'] == 'public') {
			$privacy = 0 ;
		}
		else {
			$privacy = 1 ;
		}
		$db->query("SELECT `name` FROM `group` WHERE `name`='".$name."'") ;
		if ($db->numRows() < 1) {
			$db->query("INSERT INTO `group` (`owner_id`,`name`,`group_description`,`privacy`,`created`) VALUES (".$profileid.",'".$name."','".$description."','".$privacy."',".time().")") ;
			echo "<h2>Thank you - your group has been created</h2>" ;
		}
		else {
			echo "<h2>A group already exists with this name, please try a different name</h2>" ;
			$exists = true ;
		}
	}
}
if (isset($_POST['editgroupsubmit'])) {
	//validate post variables
	$name = alphanum($_POST['groupname']) ;
	$description = alphanum($_POST['groupdesc']) ;
	$groupid = $_POST['groupid'] ;
	$db->query("SELECT * FROM `group` WHERE `group_id` =".$groupid) ;
	$gres = $db->fetch() ;
	$icon = $gres['icon'] ;
	$ownerid = $gres['owner_id'] ;
	$db->query("SELECT * FROM `member` WHERE `id`=".$ownerid) ;
	$ores = $db->fetch() ;
	$ownername = $ores['username'] ;
	if ($_POST['grouppriv'] == 'public') {
		$privacy = 0 ;
	}
	else {
		$privacy = 1 ;
	}
	$groupname = apply_word_censor($name) ;
	$groupdescription = apply_word_censor($description) ;
	$db->query("UPDATE `group` SET `name`='".$groupname."',`group_description`='".$groupdescription."',`privacy`='".$privacy."' WHERE `group_id`=".$groupid) ;
	if (($_POST['removeicon'] == 'on') && ($icon != "")) {
		unlink('uploads/groupicons/'.$icon) ;
		unlink('uploads/groupicons/small_'.$icon) ;
		$db->query("UPDATE `group` SET icon = '' WHERE `group_id`=".$groupid) ;
	}
	if ($_POST['suspendgroup'] == 'on') {
		$db->query("UPDATE `group` SET `suspended`=TRUE WHERE `group_id`=".$groupid) ;
		//Query to get all members of the group
		$db->query("SELECT * FROM `group_member` WHERE `group_id_g` =".$groupid) ;
		$sres = $db->fetchAll() ;
		$sendlink = $sitepath.'profile/'.$ownername.'/sm' ;
		$message = $ownername.", the owner of the group \"".$name."\" has suspended the group. This means the group and its media will be invisible to all members. Any media you have added to \"".$name."\" can be moved out of the group in \"My Media\" on the menu. If you want to send ".$ownername." a message <a href=\"".$sendlink."\">click here</a>" ;
		//For each member
		foreach ($sres as $skey=>$svalue) {
			//Insert a message to tell them about the suspension
			$toid = $svalue['member_id'] ;
			$db->query("INSERT INTO message (fromid, toid,body,sentdate,msgread,auto) VALUES (1,".$toid.",'".$message."',".time().",0,1)") ;
		}
	}
	if ($_POST['unsuspendgroup'] == 'on') {
		$db->query("UPDATE `group` SET `suspended`=FALSE WHERE `group_id`=".$groupid) ;
	}
	if (! empty($_FILES['groupiconfile']['tmp_name'])) {
		$maxsize = getSetting("maxgroupiconsize", $db) ;
		if ($_FILES['groupiconfile']['size'] > $maxsize * 1024) {
			echo "Group icons must be less than ".$maxsize."Kb - please try a smaller file<br><br>" ;
		}
		else {
			$filename = str_replace(" ", "_", $name.'_'.$_FILES['groupiconfile']['name']) ;
			$filename_without_ext = $filename ;
			$ext_pos = strrchr($filename, '.') ;
			if ($ext_pos !== false) {
				$filename_without_ext = substr($filename, 0, -strlen($ext_pos)) ;
			}
			$ext = strtolower(substr($filename, strrpos($filename, '.') + 1)) ;
			$img_exts = array('jpg', 'gif', 'bmp', 'png') ;
			if (array_search($ext, $img_exts) !== FALSE) {
				if (move_uploaded_file($_FILES['groupiconfile']['tmp_name'], 'uploads/groupicons/'.$filename)) {
					createThumb($filename, getSetting("avatar_h", $db), getSetting("avatar_w", $db), 'uploads/groupicons/', 'uploads/groupicons/', $filename) ;
					createThumb($filename, getSetting("savatar_h", $db), getSetting("savatar_w", $db), 'uploads/groupicons/', 'uploads/groupicons/', 'small_'.$filename) ;
					$db->query("UPDATE `group` SET icon = '".$filename."' WHERE `group_id`=".$groupid) ;
				}
			}
			else {
				echo "Group icons must be an image (jpg, bmp, png or gif) - your icon was not uploaded<br><br>" ;
			}
		}
	}
}
if (isset($_POST['submit'])) {
	{
		if (isset($_POST['profilepage'])) {
			if (($_POST['password'] != $_POST['password2']) && ($_POST['password2'] != ''))
				$errorMsg = "Passwords did not match!" ;
			if ($_POST['email'] != $_POST['email2'])
				$errorMsg = "Email address did not match!" ;
			if (!isset($errorMsg)) {
				if (! empty($_FILES['avfile']['tmp_name'])) {
					$filename = md5($_SESSION['username']).'_'.$_FILES['avfile']['name'] ;
					$filename = str_replace(" ", "_", $name.'_'.$_FILES['avfile']['name']) ;
					$filename_without_ext = $filename ;
					$ext_pos = strrchr($filename, '.') ;
					if ($ext_pos !== false) {
						$filename_without_ext = substr($filename, 0, -strlen($ext_pos)) ;
					}
					$ext = strtolower(substr($filename, strrpos($filename, '.') + 1)) ;
					$img_exts = array('jpg', 'gif', 'bmp', 'png') ;
					if (array_search($ext, $img_exts) !== FALSE) {
						if (move_uploaded_file($_FILES['avfile']['tmp_name'], 'uploads/avatars/'.$filename)) {
							createThumb($filename, getSetting("avatar_h", $db), getSetting("avatar_w", $db), 'uploads/avatars/', 'uploads/avatars/', $filename) ;
							createThumb($filename, getSetting("savatar_h", $db), getSetting("savatar_w", $db), 'uploads/avatars/', 'uploads/avatars/', 'small_'.$filename) ;
						}
					}
					else {
						echo "Avatars must be an image (jpg, bmp, png or gif) - your avatar was not uploaded<br><br>" ;
					}
				}
				$optin = isset($_POST['optin']) ? 1 : 0 ;
				$db->query("UPDATE `member` SET `opt` =  '".$optin."' WHERE `id` = '".$res['id']."';") ;
				if (strlen($_POST['email']) > 0)
					$db->query("UPDATE member SET email = '".quote_smart($_POST['email'])."' WHERE id = ".$res['id']) ;
				if (strlen($_POST['password']) > 3)
					$db->query("UPDATE member SET password = '".md5(quote_smart($_POST['password']))."' WHERE id = ".$res['id']) ;
				$db->query("UPDATE member SET age = '".quote_smart($_POST['age'])."' WHERE id = ".$res['id']) ;
				if ($_POST['gender'] == 0) {
					$db->query("UPDATE member SET gender = 0 WHERE id = ".$res['id']) ;
				}
				else {
					$db->query("UPDATE member SET gender = 1 WHERE id = ".$res['id']) ;
				}
				if ($_POST['hide'] != 'on') {
					$db->query("UPDATE member SET hidemature = 0 WHERE id = ".$res['id']) ;
				}
				else {
					$db->query("UPDATE member SET hidemature = 1 WHERE id = ".$res['id']) ;
				}
				if ($_POST['unagree'] == 'on') {
					$db->query("UPDATE member SET agreed = 0 WHERE id = ".$res['id']) ;
				}
				if ($_POST['optout'] != 'on') {
					$db->query("UPDATE member SET optoutofviewerlist = 0 WHERE id = ".$res['id']) ;
				}
				else {
					$db->query("UPDATE member SET optoutofviewerlist = 1 WHERE id = ".$res['id']) ;
				}
				$db->query("UPDATE member SET location = '".quote_smart($_POST['location'])."' WHERE id = ".$res['id']) ;
				if (strlen($_POST['avatar']) > 0)
					$newav = $_POST['avatar'] ;
				$db->query("UPDATE member SET profile_privacy = ".quote_smart($_POST['privacy'])." WHERE id = ".$res['id']) ;
				if (strlen($_POST['aboutme']) > 0)
					$db->query("UPDATE member SET aboutme = '".quote_smart($_POST['aboutme'])."' WHERE id = ".$res['id']) ;
				if (isset($filename))
					$newav = $filename ;
				if (isset($newav))
					$db->query("UPDATE member SET avatar = '".$newav."' WHERE id = ".$res['id']) ;
				$haltMessage = "Profile updated." ;
			}
		}
	}
}
}
function displayGroupMembers($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayGroupMembers_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("groupmempp", $db) ;
		$size = sizeof($res) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$pageLinks = "<div class=\"paging\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "<em>$p</em> " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "<em>$p</em> " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = $sitepath."uploads/avatars/".$value['avatar'] ;
					$avatar = str_replace(" ", "%20", $avatar) ;
				}
				$memberid = $value['id'] ;
				$username = $value['username'] ;
				$approved = $value['approved'] ;
				$groupid = $value['group_id_g'] ;
				$approvelink = $sitepath."usermenu/agm/".$groupid."/".$memberid ;
				$declinelink = $sitepath."usermenu/dgm/".$groupid."/".$memberid ;
				$removelink = $sitepath."usermenu/rgm/".$groupid."/".$memberid ;
				$sendMessageLink = $sitepath."profile/".$value['username']."/sm/" ;
				if ($approved) {
					$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" /><div class="top"><h3>'.$username.'</a> is approved<b></b></h3><br><h4><a href="'.$removelink.'">remove '.$username.'</a>&nbsp;|&nbsp;<a href="'.$sendMessageLink.'">send '.$username.' a message</a></h4></div></li>' ;
				}
				else {
					$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" /><div class="top"><h3>'.$username.'</a> is waiting to be approved<b></b></h3><br><h4><a href="'.$approvelink.'">approve '.$username.'</a>&nbsp;|&nbsp;<a href="'.$declinelink.'">decline '.$username.'</a>&nbsp;|&nbsp;<a href="'.$sendMessageLink.'">send '.$username.' a message</a></h4></div></li>' ;
				}
				$colcount++ ;
				if ($colcount > 5) {
					$colcount = 0 ;
					$output .= "<li class=\"clear\">&nbsp;</li></ul><ul class=\"no-format horiz-thumbs-list\">" ;
				}
				if ($count == $perpage)
					break ;
			}
		}
		$output .= "<li class=\"clear\">&nbsp;</li>\n" ;
		$output .= "</ul>" ;
		if ($pages > 0)
			$output .= $pageLinks ;
		return $output ;
	}
}
function displayBlocked($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayBlocked_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("blockedpp", $db) ;
		$size = sizeof($res) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = "uploads/avatars/".$value['avatar'] ;
					$avatar = $sitepath.str_replace(" ", "%20", $avatar) ;
				}
				$id = $value['id'] ;
				$username = $value['username'] ;
				$blockee_id = $value['blockee_id'] ;
				$removeblocklink = $sitepath."usermenu/brm/".$blockee_id ;
				$sendMessageLink = $sitepath."profile/".$value['username']."/sm" ;
				$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" /><div class="top"><h3>'.$username.'</a> <b></b></h3><br><h4>(<a href="'.$removeblocklink.'">unblock '.$username.'</a>)&nbsp; (<a href="'.$sendMessageLink.'">send '.$username.' a message</a>)</h4></div></li>' ;
				$colcount++ ;
				if ($count == $perpage)
					break ;
			}
		}
		if ($pages > 0)
			$output .= $pageLinks ;
		$output .= "</ul>" ;
		return $output ;
	}
}
function displayMySubscriptions($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMySubscriptions_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("subscriptionspp", $db) ;
		$size = sizeof($res) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = "uploads/avatars/".$value['avatar'] ;
					$avatar = $sitepath.str_replace(" ", "%20", $avatar) ;
				}
				$id = $value['id'] ;
				$username = $value['username'] ;
				$sub_id = $value['subscribedtoid'] ;
				$removesublink = $sitepath."usermenu/srm/".$sub_id ;
				$sendMessageLink = $sitepath."profile/".$value['username']."/sm" ;
				$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" /><div class="top"><h3>'.$username.'</a> <b></b></h3><br><h4>(<a href="'.$removesublink.'">unsubscribe from '.$username.'</a>)&nbsp; (<a href="'.$sendMessageLink.'">send '.$username.' a message</a>)</h4></div></li>' ;
				$colcount++ ;
				if ($count == $perpage)
					break ;
			}
		}
		if ($pages > 0)
			$output .= $pageLinks ;
		$output .= "</ul>" ;
		return $output ;
	}
}
function displayMyFavorites($res, $page = 1, $url = "", $nomr = false) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMyFavorites_new($res, $page, $url, $nomr) ;
		return $output ;
	}
	else {
		if ($loggedIn) {
			$db->query("SELECT id FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$ures = $db->fetch() ;
			$memberid = $ures['id'] ;
			$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
			$groupmembership = $db->fetchAll() ;
		}
		$vidcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['added'] < time()) {
				$groupid = $value['groupid'] ;
				$groupprivate = $value['privacy'] ;
				$visible = true ;
				if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
					if ($loggedIn) {
						$approvedmember = false ;
						foreach ($groupmembership as $gmkey=>$groupmember) {
							if ($groupmember['group_id_g'] == $groupid) {
								$approvedmember = true ;
								break ;
							}
						}
						if (!$approvedmember) {
							$visible = false ;
						}
					}
					else {
						$visible = false ;
					}
				}
				if ($visible) {
					$vidcount++ ;
				}
			}
		}
		$perpage = getSetting("favoritespp", $db) ;
		$pages = ceil($vidcount / $perpage) ;
		$path = getSetting("sitefolder", $db) ;
		$pageLinks = "" ;
		//Page formatting
		$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		foreach ($res as $key=>$value) {
			if ($value['added'] < time()) {
				$groupid = $value['groupid'] ;
				$groupprivate = $value['privacy'] ;
				$visible = true ;
				if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
					if ($loggedIn) {
						$approvedmember = false ;
						foreach ($groupmembership as $gmkey=>$groupmember) {
							if ($groupmember['group_id_g'] == $groupid) {
								$approvedmember = true ;
								break ;
							}
						}
						if (!$approvedmember) {
							$visible = false ;
						}
					}
					else {
						$visible = false ;
					}
				}
				if ($visible) {
					$count++ ;
					if ($count == getSetting("adsense_pos1", $db) || $count == getSetting("adsense_pos2", $db))
						$output .= getAdmedia() ;
					$thumbpath = $sitepath.'uploads/thumbs/' ;
					if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
					elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
						$thumb = str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
					if ($value['thumb'] == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
					$resKat = $db->fetch() ;
					$cat = getCategoryPath($resKat['name']) ;
					$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
					$resR = $db->fetch() ;
					$title = url_encode($value['title']) ;
					$vidid = $value['vidid'] ;
					$removelink = $sitepath."usermenu/rfav/".$vidid ;
					$output .= "<li><a href=\"".$sitepath."play$cat/$title\"><img class='thumb' src='$thumb' /></a>\n" ;
					$value['title'] = force_length($value['title'], 55) ;
					$output .= "<div class=\"top\"><h3><a href=\"".$sitepath."play$cat/$title\">".str_replace("_", " ", $title)."</a></h3>\n" ;
					$value['description'] = force_length($value['description'], 130) ;
					$output .= "<h4 class=\"message\">".$value['description']."</h4>\n" ;
					$tags = strtolower($value['tags']) ;
					$taglinks = getTagLinks($tags) ;
					if (str_replace(" ", "", $tags) != '') {
						$output .= "<h4>&nbsp;&nbsp;tags: $taglinks</h4>" ;
					}
					else {
						$output .= "<h4>&nbsp;</h4>" ;
					}
					$output .= "</div><div class=\"inf\"><div class=\"inf-right\"><b>Uploaded by <a href=\"".$sitepath."profile/".$value['poster']."\">".$value['poster']."</a> on:</b> ".date("m.d.y", $value['added'])."<h4><a href=\"".$removelink."\">remove this from my favorites</a></h4><span class=\"views\"><b>views:</b> ".$value['allviews'] ;
					$output .= "</span></div></div>" ;
					$output .= "</li>\n" ;
					if ($count == $perpage)
						break ;
				}
			}
		}
		$output .= "</ul>" ;
		if ($pages != 1)
			$output .= $pageLinks ;
		return $output ;
	}
}
function displayMyMedia($res, $page = 1, $url = "", $nomr = false) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMyMedia_new($res, $page, $url, $nomr) ;
		return $output ;
	}
	else {
		$perpage = getSetting("mediapp", $db) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$path = getSetting("sitefolder", $db) ;
		$pageLinks = "" ;
		//Page formatting
		$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		foreach ($res as $key=>$value) {
			if ($value['added'] < time()) {
				$count++ ;
				if ($count == getSetting("adsense_pos1", $db) || $count == getSetting("adsense_pos2", $db))
					$output .= getAdmedia() ;
				$thumbpath = $sitepath.'uploads/thumbs/' ;
				if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
					$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
				elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
					$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
				elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
					$thumb = str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
				elseif (findThumb($value['thumb'], true)) {
					$thumb = findThumb($value['thumb'], true) ;
					$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
				}
				$thumb = str_replace(" ", "%20", $thumb) ;
				if ($value['thumb'] == '') {
					$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
				}
				if ($value['category'] > 0) {
					$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
					$resKat = $db->fetch() ;
					$cat = url_encode($resKat['name']) ;
					if ($resKat['parent'] != 0) {
						$db->query("SELECT `name`, `url` from `category` WHERE id = '".$resKat['parent']."';") ;
						$parKat = $db->fetch() ;
						$cat = url_encode($parKat['name'])."/_".$cat ;
					}
				}
				else {
					$cat = '' ;
				}
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$title = url_encode($value['title']) ;
				$vidid = $value['vidid'] ;
				$groupid = $value['groupid'] ;
				$catid = $value['category'] ;
				$removelink = $sitepath."usermenu/rfav/".$vidid ;
				//decide to make thumbnails link to media or not
				$output .= "<li><a href=\"".$sitepath."play/$cat/$title\"><img class='thumb' src='$thumb' /></a>\n" ;
				$value['title'] = force_length($value['title'], 55) ;
				$output .= "<div class=\"top\"><form action=\"".$url."\" method=\"POST\"><h3><a href=\"".$sitepath."play/$cat/$title\">".str_replace("_", " ", $title)."</a>&nbsp;&nbsp;<input type=\"submit\" class=\"biggerbutton\" name=\"deletemedia\" value=\"delete this media item\"><input type=\"hidden\" name=\"deletemediaid\" value=\"".$value['id']."\"></h3></form>\n" ;
				$value['description'] = force_length($value['description'], 130) ;
				$output .= "<h4 class=\"message\">".$value['description']."</h4>" ;
				$tags = strtolower($value['tags']) ;
				$taglinks = getTagLinks($tags) ;
				if (str_replace(" ", "", $tags) != '') {
					$output .= "<h4>&nbsp;&nbsp;tags: $taglinks</h4>" ;
				}
				else {
					$output .= "<h4>&nbsp;</h4>" ;
				}
				@session_start() ;
				$_SESSION['poster'] = $_SESSION['username'] ;
				$output .= "</div><div class=\"inf\"><div class=\"inf-right\"><b>Uploaded by <a href=\"".$sitepath."profile/".$value['poster']."\">".$value['poster']."</a> on:</b> ".date("m.d.y", $value['added'])."<a href=\"".$sitepath."index.php?id=31&edit=".$value['id']."\"> [Edit Media] </a><span class=\"views\"><b>views:</b> ".$value['allviews'] ;
				$output .= "</span><form class=\"smalltext\"action=\"".$url."\" method=\"POST\"><input type=\"hidden\" name=\"mediaid\" value=\"".$value['id']."\">move to group&nbsp;<select name=\"groups\" width=80px>".groupOptions($groupid)."</select>&nbsp;<input type=\"submit\" class=\"biggerbutton\" name=\"groupsubmit\" value=\"go\">&nbsp;change category&nbsp;<select name=\"categories\">".catOptions($catid)."</select>&nbsp;<input type=\"submit\" class=\"biggerbutton\" name=\"catsubmit\" value=\"go\"></form></div></div>" ;
				$output .= "</li>\n" ;
				if ($count == $perpage)
					break ;
			}
		}
		$output .= "</ul>" ;
		if ($pages != 1)
			$output .= $pageLinks ;
		return $output ;
	}
}
function displayMyHistory($res, $page = 1, $url = "") {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMyHistory_new($res, $page, $url) ;
		return $output ;
	}
	else {
		if ($loggedIn) {
			$db->query("SELECT id FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$ures = $db->fetch() ;
			$memberid = $ures['id'] ;
			$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
			$groupmembership = $db->fetchAll() ;
		}
		$vidcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['added'] < time()) {
				$groupid = $value['groupid'] ;
				$groupprivate = $value['privacy'] ;
				$visible = true ;
				if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
					if ($loggedIn) {
						$approvedmember = false ;
						foreach ($groupmembership as $gmkey=>$groupmember) {
							if ($groupmember['group_id_g'] == $groupid) {
								$approvedmember = true ;
								break ;
							}
						}
						if (!$approvedmember) {
							$visible = false ;
						}
					}
					else {
						$visible = false ;
					}
				}
				if ($visible) {
					$vidcount++ ;
				}
			}
		}
		$perpage = getSetting("historypp", $db) ;
		$pages = ceil($vidcount / $perpage) ;
		$path = getSetting("sitefolder", $db) ;
		$pageLinks = "" ;
		//Page formatting
		$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		foreach ($res as $key=>$value) {
			if ($value['added'] < time()) {
				$groupid = $value['groupid'] ;
				$groupprivate = $value['privacy'] ;
				$visible = true ;
				if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
					if ($loggedIn) {
						$approvedmember = false ;
						foreach ($groupmembership as $gmkey=>$groupmember) {
							if ($groupmember['group_id_g'] == $groupid) {
								$approvedmember = true ;
								break ;
							}
						}
						if (!$approvedmember) {
							$visible = false ;
						}
					}
					else {
						$visible = false ;
					}
				}
				if ($visible) {
					$count++ ;
					if ($count == getSetting("adsense_pos1", $db) || $count == getSetting("adsense_pos2", $db))
						$output .= getAdmedia() ;
					$thumbpath = $sitepath.'uploads/thumbs/' ;
					if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
					elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
						$thumb = str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
					if ($value['thumb'] == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					if ($value['category'] > 0) {
						$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
						$resKat = $db->fetch() ;
						$cat = url_encode($resKat['name']) ;
						if ($resKat['parent'] != 0) {
							$db->query("SELECT `name`, `url` from `category` WHERE id = '".$resKat['parent']."';") ;
							$parKat = $db->fetch() ;
							$cat = url_encode($parKat['name'])."/_".$cat ;
						}
					}
					else {
						$cat = '' ;
					}
					$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
					$resR = $db->fetch() ;
					$title = url_encode($value['title']) ;
					$vidid = $value['vidid'] ;
					$removelink = $sitepath."usermenu/dh/".$vidid ;
					//decide to make thumbnails link to media or not
					$output .= "<li><a href=\"".$sitepath."play/$cat/$title\"><img class='thumb' src='$thumb' /></a>\n" ;
					$value['title'] = force_length($value['title'], 55) ;
					$output .= "<div class=\"top\"><h3><a href=\"".$sitepath."play/$cat/$title\">".str_replace("_", " ", $title)."</a></h3>\n" ;
					$value['description'] = force_length($value['description'], 130) ;
					$output .= "<h4 class=\"message\">".$value['description']."</h4>" ;
					$tags = strtolower($value['tags']) ;
					$taglinks = getTagLinks($tags) ;
					if (str_replace(" ", "", $tags) != '') {
						$output .= "<h4>&nbsp;&nbsp;tags: $taglinks</h4>" ;
					}
					else {
						$output .= "<h4>&nbsp;</h4>" ;
					}
					$output .= "</div><div class=\"inf\"><div class=\"inf-right\"><b>Uploaded by <a href=\"".$sitepath."profile/".$value['poster']."\">".$value['poster']."</a> on:</b> ".date("m.d.y", $value['added'])."<span class=\"views\"><b>views:</b> ".$value['visits'] ;
					$output .= "</span></div></div>" ;
					$output .= "</li>\n" ;
					if ($count == $perpage)
						break ;
				}
			}
		}
		$output .= "</ul>" ;
		if ($pages != 1)
			$output .= $pageLinks ;
		return $output ;
	}
}
function displayMyProfileHistory($res, $page = 1, $url = "") {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMyProfileHistory_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getSetting("profilehistorypp", $db) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$path = getSetting("sitefolder", $db) ;
		$pageLinks = "" ;
		//Page formatting
		$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div></div>" ;
		$output = '<ul class="no-format horiz-thumbs-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = $sitepath."uploads/avatars/".$value['avatar'] ;
				}
				$avatar = str_replace(" ", "%20", $avatar) ;
				$id = $value['id'] ;
				$username = $value['username'] ;
				$db->query("SELECT id FROM media WHERE status='true' AND poster ='".$username."'".$hide." ORDER BY allviews DESC") ;
				$mediacount = $db->numRows() ;
				$rres = $db->fetch() ;
				$db->query("SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$id." OR friend.friendid =".$id.") AND (username!='".$username."') AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id") ;
				$friendcount = $db->numRows() ;
				$output .= "<li><a href=\"".$sitepath."profile/$username\"><img class='thumb' width=".getSetting("avatar_w", $db)."px height=".getSetting("avatar_h", $db)."px class='thumb' src='".$avatar."' /></a>\n" ;
				$value['username'] = force_length($value['username'], 25) ;
				$output .= "<p><a href=\"".$sitepath."profile/$username\">".$value['username']."</a></p><h4>friends: $friendcount</h4><h4>media: $mediacount</h4><h4>profile views: ".$value['profileviews']."</h4>" ;
				$output .= "</li>\n" ;
				if ($count == $perpage)
					break ;
			}
		}
		$output .= "<li class=\"clear\">&nbsp;</li>\n" ;
		$output .= "</ul>" ;
		if ($pages != 1)
			$output .= $pageLinks ;
		return $output ;
	}
}
function displayGroupsList($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayGroupsList_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("groupslistpp", $db) ;
		$size = sizeof($res) ;
		$pages = ceil($size / $perpage) ;
		$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$idres = $db->fetch() ;
		$loggedInid = $idres['id'] ;
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$iconfile = "" ;
				if (@file_exists("uploads/groupicons/".$value['icon']) && ($value['icon'] != "")) {
					$iconfile = $sitepath."uploads/groupicons/".$value['icon'] ;
				}
				else {
					$iconfile = $templateimagepath."default_group_thumb.jpg" ;
				}
				if ($iconfile != "") {
					$iconurl = '<img class="thumb" src="'.$iconfile.'">' ;
				}
				else {
					$iconurl = '' ;
				}
				$groupid = $value['group_id'] ;
				$groupname = force_length(stripslashes($value['name']), 64) ;
				$groupdesc = force_length(stripslashes($value['group_description']), 150) ;
				$grouppriv = $value['privacy'] ;
				$privacy = 'public' ;
				if ($grouppriv == 1) {
					$privacy = 'private' ;
				}
				$db->query("SELECT * FROM group_member WHERE group_id_g=".$groupid." AND approved=1") ;
				$members = $db->numRows() ;
				if ($members != 1) {
					$s = 's' ;
				}
				else {
					$s = '' ;
				}
				$db->query("SELECT * FROM group_member WHERE group_id_g=".$groupid." AND approved=0") ;
				$requests = $db->numRows() ;
				if ($requests != 1) {
					$rs = 's' ;
				}
				else {
					$rs = '' ;
				}
				if ($requests > 0) {
					$requestview = '<blink> ('.$requests.' request'.$rs.')</blink>' ;
				}
				else {
					$requestview = '' ;
				}
				$managelink = $sitepath.'usermenu/managegroup/'.$groupid ;
				$viewlink = $sitepath.'showgroup/'.url_encode($groupname) ;
				$output .= '<li><a href="'.$viewlink.'">'.$iconurl.'</a><h3><a href="'.$viewlink.'">'.$groupname.'&nbsp;&nbsp;('.$privacy.' group with '.$members.' member'.$s.')</a>'.$requestview.'</h3>
				<p>'.$groupdesc.'</p>
				<div class="inf"><div class="inf-right"><a href="'.$managelink.'">manage this group</a> | <a href="'.$viewlink.'">go to this group\'s page</a></div></div></li>' ;
				$colcount++ ;
				if ($count == $perpage)
					break ;
			}
		}
		if ($pages > 0)
			$output .= $pageLinks ;
		$output .= "</ul>" ;
		return $output ;
	}
}
function displayMyFriends($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMyFriends_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("friendspp", $db) ;
		$size = sizeof($res) ;
		if ($size > 0) {
			$size-- ;
		} // If we don't do this it can show a final page with nothing in it!
		$pages = ceil($size / $perpage) ;
		$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$idres = $db->fetch() ;
		$loggedInid = $idres['id'] ;
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = "uploads/avatars/".$value['avatar'] ;
					$avatar = $sitepath.str_replace(" ", "%20", $avatar) ;
				}
				$id = $value['id'] ;
				$username = $value['username'] ;
				$approved = $value['friend_approved'] ;
				$friendid = $value['friendid'] ;
				if ($friendid == $loggedInid) {
					$friendid = $value['userid'] ;
				}
				$removelink = $sitepath."usermenu/rf/".$friendid ;
				$removeandblocklink = $sitepath."usermenu/rb/".$friendid ;
				$sendMessageLink = $sitepath."profile/".$value['username']."/sm" ;
				if ($username != $_SESSION['username']) {
					$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" />
	<div class="top"><h3>'.$username.'</a> <b></b></h3><br><h4>(<a href="'.$removelink.'">remove '.$username.'</a>)&nbsp;(<a href="'.$removeandblocklink.'">remove and block '.$username.'</a>)&nbsp; (<a href="'.$sendMessageLink.'">send '.$username.' a message</a>)</h4></div></li>' ;
				}
				$colcount++ ;
				if ($count == $perpage)
					break ;
			}
		}
		if ($pages > 0)
			$output .= $pageLinks ;
		$output .= "</ul>" ;
		return $output ;
	}
}
function displayMyReceivedRequests($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMyReceivedRequests_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("recfriendpp", $db) ;
		$size = sizeof($res) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = "uploads/avatars/".$value['avatar'] ;
					$avatar = $sitepath.str_replace(" ", "%20", $avatar) ;
				}
				$id = $value['id'] ;
				$username = $value['username'] ;
				$approved = $value['friend_approved'] ;
				$friendid = $value['friendid'] ;
				$removed = $value['friend_removed'] ;
				$approvelink = $sitepath."usermenu/af/".$friendid ;
				$declinelink = $sitepath."usermenu/dr/".$friendid ;
				$askagainlink = $sitepath."usermenu/ra/".$friendid ;
				$removeandblocklink = $sitepath."usermenu/dcb/".$friendid ;
				$deletelink = $sitepath."usermenu/dl/".$friendid ;
				$sendMessageLink = $sitepath."profile/".$value['username']."/sm/" ;
				if (!$removed) {
					$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" />
<	div class="top"><h3>'.$username.'</a> <b></b></h3><br><h4>(<a href="'.$approvelink.'">accept '.$username.'</a>)&nbsp;(<a href="'.$declinelink.'">decline '.$username.'</a>)&nbsp;(<a href="'.$removeandblocklink.'">decline and block '.$username.'</a>)&nbsp; (<a href="'.$sendMessageLink.'">send '.$username.' a message</a>)</h4></div></li>' ;
				}
				else {
					$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" />
<	div class="top"><h3>'.$username.'</a> <b> either declined your request or removed your from their friends list</b></h3><br><h4>(<a href="'.$askagainlink.'">send another friend request to '.$username.'</a>)&nbsp;(<a href="'.$deletelink.'">remove this reminder</a>)&nbsp;(<a href="'.$removeandblocklink.'">remove and block '.$username.'</a>)&nbsp; (<a href="'.$sendMessageLink.'">send '.$username.' a message</a>)</h4></div></li>' ;
				}
				$colcount++ ;
				if ($count == $perpage)
					break ;
			}
		}
		if ($pages > 0)
			$output .= $pageLinks ;
		$output .= "</ul>" ;
		return $output ;
	}
}
function displayMySentRequests($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMySentRequests_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("sentfriendpp", $db) ;
		$size = sizeof($res) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = "uploads/avatars/".$value['avatar'] ;
					$avatar = $sitepath.str_replace(" ", "%20", $avatar) ;
				}
				$id = $value['id'] ;
				$username = $value['username'] ;
				$approved = $value['friend_approved'] ;
				$removed = $value['friend_removed'] ;
				$friendid = $value['userid'] ;
				$cancellink = $sitepath."usermenu/rcq/".$friendid ;
				$sendMessageLink = $sitepath."profile/".$value['username']."/sm" ;
				$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" />
	<div class="top"><h3>'.$username.'</a><b> has not accepted your request yet</b></h3><br><h4>(<a href="'.$cancellink.'">cancel this request</a>)&nbsp; (<a href="'.$sendMessageLink.'">send '.$username.' a message</a>)</h4></div></li>' ;
				$colcount++ ;
				if ($count == $perpage)
					break ;
			}
		}
		if ($pages > 0)
			$output .= $pageLinks ;
		$output .= "</ul>" ;
		return $output ;
	}
}
function date_diff($str_start, $str_end) {
	$defdate = $str_start ;
	$str_start = strtotime($str_start) ;
	$str_end = strtotime($str_end) ;
	$nseconds = $str_end - $str_start ;
	$ndays = floor($nseconds / 86400) ;
	$nseconds = $nseconds % 86400 ;
	$nhours = floor($nseconds / 3600) ;
	$nseconds = $nseconds % 3600 ;
	$nminutes = floor($nseconds / 60) ;
	$nseconds = $nseconds % 60 ;
	$retString = "" ;
	if ($ndays > 0) {
		$retString .= $defdate ;
		return "at  ".$retString ;
	}
	if ($nhours > 0) {
		$retString .= " ".$nhours." hour" ;
		if ($nhours > 1)
			$retString .= "s" ;
	}
	if ($nminutes > 0) {
		$retString .= " ".$nminutes." minute" ;
		if ($nminutes > 1)
			$retString .= "s" ;
	}
	if (strcmp($retString, "") == 0)
		$retString = "< 1 minute" ;
	return $retString." ago" ;
}
function displayMessages($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displayMessages_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("messagepp", $db) ;
		$size = sizeof($res) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = "uploads/avatars/".$value['avatar'] ;
					$avatar = $sitepath.str_replace(" ", "%20", $avatar) ;
				}
				$id = $value['id'] ;
				$username = $value['username'] ;
				$body = $value['body'] ;
				$date = $value['sentdate'] ;
				$str_today = date("Y-m-d H:i:s") ;
				$value['username'] = force_length($value['username'], 25) ;
				$messageid = $value['messageid'] ;
				$msgread = $value['msgread'] ;
				if ($msgread > 0) {
					$newtext = '' ;
				}
				else {
					$newtext = '<blink><< new</blink>' ;
				}
				$delMessageLink = $sitepath."usermenu/dm/".$messageid ;
				$delAndBlockLink = $sitepath."usermenu/db/".$messageid ;
				$sendMessageLink = $sitepath."profile/".$value['username']."/sm" ;
				$db->query("UPDATE message SET msgread=1 WHERE messageid=".$messageid) ;
				$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" />
	</a><div class="top">
	<h3 class="message">'.$body.'</h3></div>' ;
				$output .= '<div class="inf"><div class="inf-right"><b>from <a href="'.$sitepath.'profile/'.$username.'">'.$username.'</a> </b>'.date_diff(date("Y-m-d H:i:s", $date), $str_today).'&nbsp;'.$newtext.'<span class="views"></span></div></div><div align=right><h4>(<a href="'.$delMessageLink.'">delete this message</a>)&nbsp;(<a href="'.$delAndBlockLink.'">delete this message and block '.$username.'</a>)&nbsp; (<a href="'.$sendMessageLink.'">send a message to '.$username.'</a>)</h4></div></li>' ;
				$colcount++ ;
				if ($count == $perpage)
					break ;
			}
		}
		if ($pages > 0)
			$output .= $pageLinks ;
		$output .= "</ul>" ;
		return $output ;
	}
}
function displaySentMessages($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = displaySentMessages_new($res, $page, $url) ;
		return $output ;
	}
	else {
		$perpage = getsetting("sentmesspp", $db) ;
		$size = sizeof($res) ;
		$pages = ceil(sizeof($res) / $perpage) ;
		$pageLinks = '<div class="paging"><div class="paging-right"><div class="paging-mid"><div class="pages">' ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div></div></div>" ;
		$output = '<ul class="no-format vert-list">' ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($res[$i]) ;
		$colcount = 0 ;
		foreach ($res as $key=>$value) {
			if ($value['activationkey'] == 0) {
				$count++ ;
				$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
				$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
					$avatar = "uploads/avatars/".$value['avatar'] ;
					$avatar = $sitepath.str_replace(" ", "%20", $avatar) ;
				}
				$id = $value['id'] ;
				$username = $value['username'] ;
				$body = $value['body'] ;
				$date = $value['sentdate'] ;
				$str_today = date("Y-m-d H:i:s") ;
				$value['username'] = force_length($value['username'], 25) ;
				$messageid = $value['messageid'] ;
				$msgread = $value['msgread'] ;
				if ($msgread > 0) {
					$newtext = '(read)' ;
				}
				else {
					$newtext = '(unread)' ;
				}
				$delMessageLink = $sitepath."usermenu/ds/".$messageid ;
				$delAndBlockLink = $sitepath."usermenu/db/".$messageid ;
				$sendMessageLink = $sitepath."profile/".$value['username']."/sm" ;
				$output .= '<li><a href="'.$sitepath.'profile/'.$username.'"><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatar.'" />
	</a><div class="top">
	<h3 class="message">'.$body.'</h3></div>' ;
				$output .= '<div class="inf"><div class="inf-right"><b>sent to <a href="'.$sitepath.'profile/'.$username.'">'.$username.'</a> </b>'.date_diff(date("Y-m-d H:i:s", $date), $str_today).'&nbsp;'.$newtext.'<span class="views"></span></div></div><div align=right><h4>(<a href="'.$delMessageLink.'">delete this message</a>)&nbsp;(<a href="'.$sendMessageLink.'">send another message to '.$username.'</a>)</h4></div></li>' ;
				$colcount++ ;
				if ($count == $perpage)
					break ;
			}
		}
		if ($pages > 0)
			$output .= $pageLinks ;
		$output .= "</ul>" ;
		return $output ;
	}
}
function getFriends() {
	global $db,$sitepath,$template,$templateimagepath ;
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>My</b>&nbsp;Friends</h1><h3>Your friends are listed below</h3>' ;
	$query = "SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$userid." OR friend.friendid =".$userid.") AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id" ;
	$db->query($query) ;
	if ($db->numRows() > 0) {
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "rf") && ($_GET['action'] != "rb") && ($_GET['action'] != "ra"))
			$messages .= displayMyFriends($resLV, quote_smart($_GET['page']), $sitepath."usermenu/myfriends") ;
		else
			$messages .= displayMyFriends($resLV, 1, $sitepath."usermenu/myfriends") ;
	}
	else {
		$messages .= "<h2><b>You have no friends</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getReceivedRequests() {
	global $db,$sitepath,$template,$templateimagepath ;
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>Friend requests</b>&nbsp;from members</h1>' ;
	$db->query("SELECT * FROM member LEFT JOIN friend ON member.id = friend.friendid WHERE friend.userid =".$userid." AND friend.friend_approved = 0") ;
	if ($db->numRows() > 0) {
		if ($_GET['action'] != "darqc") {
			$messages .= '<h3><a href="'.$sitepath.'usermenu/darqc">Delete All Received Friend Requests</a></h3>' ;
		}
		else {
			$messages .= '<h3><a href="'.$sitepath.'usermenu/darq">>Confirm Delete Friend Requests</a></h3>' ;
		}
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "af") && ($_GET['action'] != "dr") && ($_GET['action'] != "ra") && ($_GET['action'] != "dcb") && ($_GET['action'] != "dl") && ($_GET['action'] != "darqc") && ($_GET['action'] != "darq"))
			$messages .= displayMyReceivedRequests($resLV, quote_smart($_GET['page']), $sitepath."usermenu/myreceivedrequests") ;
		else
			$messages .= displayMyReceivedRequests($resLV, 1, $sitepath."usermenu/myreceivedrequests") ;
	}
	else {
		$messages .= "<h2><b>No Requests</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getSentRequests() {
	global $db,$sitepath,$template,$templateimagepath ;
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>Friend requests</b>&nbsp;you have sent</h1>' ;
	$db->query("SELECT * FROM member LEFT JOIN friend ON member.id = friend.userid WHERE friend.friendid =".$userid." AND friend.friend_approved = 0 AND friend.friend_removed = 0") ;
	if ($db->numRows() > 0) {
		if ($_GET['action'] != "dasqc") {
			$messages .= '<h2><a href="'.$sitepath.'usermenu/dasqc">Delete All Sent Requests</a></h2>' ;
		}
		else {
			$messages .= '<h3><a href="'.$sitepath.'usermenu/dasq"></a></h3>' ;
		}
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "rcq") && ($_GET['action'] != "dasqc") && ($_GET['action'] != "dasq"))
			$messages .= displayMySentRequests($resLV, quote_smart($_GET['page']), $sitepath."usermenu/mysentrequests") ;
		else
			$messages .= displayMySentRequests($resLV, 1, $sitepath."usermenu/mysentrequests") ;
	}
	else {
		$messages .= "<h2><b>No Requests</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getMedia() {
	global $db,$sitepath,$template,$templateimagepath ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>My</b> uploaded media</h1>' ;
	$db->query("SELECT * FROM media WHERE poster =\"".quote_smart($_SESSION['username'])."\"") ;
	if ($db->numRows() > 0) {
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "rfav"))
			$messages .= displayMyMedia($resLV, quote_smart($_GET['page']), $sitepath."usermenu/media") ;
		else
			$messages .= displayMyMedia($resLV, 1, $sitepath."usermenu/media") ;
	}
	else {
		$messages .= "<h2><b>You have not uploaded any media yet</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getProfile() {
	global $templateimagepath,$db,$privacyOption,$sitepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = getProfile_new() ;
		return $output ;
	}
	else {
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$res = $db->fetch() ;
		$curEmail = $res['email'] ;
		$curAvatar = $res['avatar'] ;
		$curAge = $res['age'] ;
		$curGender = $res['gender'] ;
		$curLocation = $res['location'] ;
		$curAboutme = $res['aboutme'] ;
		$curPassword = $res['password'] ;
		$username = $res['username'] ;
		$curHide = $res['hidemature'] ;
		$curOptout = $res['optoutofviewerlist'] ;
		$profileviews = $res['profileviews'] ;
		$agreed = $res['agreed'] ;
		if ($profileviews == 1) {
			$times = ' time' ;
		}
		else {
			$times = ' times' ;
		}
		if ($curHide < 1) {
			$hideChecked = '' ;
		}
		else {
			$hideChecked = ' CHECKED' ;
		}
		if ($curOptout < 1) {
			$optoutChecked = '' ;
		}
		else {
			$optoutChecked = ' CHECKED' ;
		}
		$opt = $res['opt'] ;
		$privacy = $res['profile_privacy'] ;
		$profileid = $res['id'] ;
		$profile = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>My</b> Profile - '.$_SESSION['username'].'</h1>' ;
		$profile .= '<br><h3><b><div align=right><a href="'.$sitepath.'profile/'.$_SESSION['username'].'">Click Here To See Your Profile Page</a></div></b></h3><br>' ;
		$profile .= 'Your profile has been viewed '.$profileviews.$times.' by other members<br><br>' ;
		$profile .= '<fieldset><ol><form method="post" action="" enctype="multipart/form-data">' ;
		$profile .= '<input type="hidden" name="profilepage" value="true">' ;
		$profile .= $privacyOption ;
		$profile .= '<li><label for="password">New <span>P</span>assword</label><input class="textbox" type="password" name="password"></li>
						<li><label for="password2">Verify Password</label><input class="textbox" type="password" name="password2"></li>
						<li><h4>Current e-mail address is '.$curEmail.'</h4></li>
						<li><label for="email">New Email</label><input class="textbox" type="text" name="email"></li>
						<li><label for="email2">Verify Email</label><input class="textbox" type="text" name="email2"></li>
						<li><label for="aboutme">About Me:</label><div id="message"><textarea class="code" rows=5 cols=35 name="aboutme">'.$curAboutme.'</textarea></div></li>
						<li><label for="age">Age</label><input class="textbox" type="text" name="age" value="'.$curAge.'"></li>' ;
		$profile .= '<li><label for="gender">Gender</label><INPUT TYPE=RADIO NAME="gender" VALUE="0"' ;
		if ($curGender < 1) {
			$profile .= ' CHECKED' ;
		}
		$profile .= '>male <INPUT TYPE=RADIO NAME="gender" VALUE="1"' ;
		if ($curGender > 0) {
			$profile .= ' CHECKED' ;
		}
		$profile .= '>female</li>	
			<li><label for="hide">Hide all mature content</label><input type="checkbox" name="hide"'.$hideChecked.'"></li>' ;
		if ($agreed == 1) {
			$profile .= '<li><label for="unagree">You have agreed to view mature content - check this box if you no longer want to be able to view it</label><input type="checkbox" name="unagree"></li>' ;
		}
		$profile .= '<li><label for="optout">Don\'t let other members see when I have viewed their profile</label><input type="checkbox" name="optout"'.$optoutChecked.'"></li>' ;
		$profile .= '<li><label for="location">Location</label><input class="textbox" type="text" name="location" value="'.$curLocation.'"></li>
			<li><label for="optin">Opt In for e-mails</label><input type="checkbox" name="optin" ' ;
		if ($opt == 1)
			$profile .= " checked" ;
		$profile .= '/></li>' ;
		$profile .= '<li><label for="avfile">Avatar File</label><input class="filebox" size="20" name="avfile" type="file" /></li>' ;
		if (strlen($curAvatar) > 0) {
			$avatarpath = $curAvatar ;
			if (@file_exists("uploads/avatars/".$curAvatar) && ($curAvatar != "")) {
				$avatarpath = $sitepath."uploads/avatars/".$curAvatar ;
			}
			$avatarpath = str_replace(" ", "%20", $avatarpath) ;
			$profile .= '<li><label for="curavatar">Current avatar</label><img class="thumb" width='.getSetting("avatar_w", $db).'px height='.getSetting("avatar_h", $db).'px class="thumb" src="'.$avatarpath.'" />
	</li>' ;
		}
		$profile .= '<li><label for="submit">&nbsp;</label><input class="biggerbutton" type="submit" name="submit" value=" Save "></li></form></ol></fieldset>' ;
		return $profile ;
	}
}
function getGroups() {
	$groups = "<h1>Not yet.. coming soon :)</h1>" ;
	return $groups ;
}
function getHistory() {
	global $db,$sitepath,$template,$templateimagepath ;
	if (checkHideMedia() == 1) {
		$hide = " AND (`requires_agreement` = 0)" ;
	}
	else {
		$hide = "" ;
	}
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>Media</b> viewing history</h1>' ;
	$db->query("SELECT history FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userHistory = $idres['history'] ;
	$media = array() ;
	$count = 0 ;
	if (strlen($userHistory) != 0) {
		$pastmedia = split(":", $userHistory) ;
		foreach ($pastmedia as $pv) {
			$db->query("SELECT * FROM media WHERE `status`='true' AND id = '$pv'".$hide) ;
			$mres = $db->fetch() ;
			if (isset($mres['id'])) {
				if ($mres['id'] != '') {
					array_push($media, $mres) ;
					$count++ ;
				}
			}
		}
	}
	if ($count > 0) {
		$messages .= '<h2><b><a href='.$sitepath.'usermenu/dh/>Clear History</a></b></h2>' ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "dh"))
			$messages .= displayMyHistory($media, quote_smart($_GET['page']), $sitepath."usermenu/history") ;
		else
			$messages .= displayMyHistory($media, 1, $sitepath."usermenu/history") ;
	}
	else {
		$messages .= "<h2><b>Your history is empty</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getInbox() {
	global $db,$sitepath,$template,$templateimagepath ;
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>&nbsp;My</b>&nbsp;Message Inbox</h1>' ;
	$db->query("SELECT * FROM message LEFT JOIN member ON message.fromid = member.id WHERE message.toid = ".$userid." ORDER BY sentdate DESC") ;
	if ($db->numRows() > 0) {
		if ($_GET['action'] != "daic") {
			$messages .= '<h2><a href="'.$sitepath.'usermenu/daic">&nbsp;Delete All Messages</a></h2>' ;
		}
		else {
			$messages .= '<h3><a href="'.$sitepath.'usermenu/daia></h3>' ;
		}
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "dm") && ($_GET['action'] != "db") && ($_GET['action'] != "dai") && ($_GET['action'] != "daic"))
			$messages .= displayMessages($resLV, quote_smart($_GET['page']), $sitepath."usermenu/inbox") ;
		else
			$messages .= displayMessages($resLV, 1, $sitepath."usermenu/inbox") ;
	}
	else {
		$messages .= "<h2><b> You have no messages in your inbox</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getOutbox() {
	global $db,$sitepath,$template,$templateimagepath ;
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$isAdmin = isset($_SESSION['privs']) && ($_SESSION['privs'] == 7) ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>My</b>&nbsp;Message Outbox</h1>' ;
	if (!$isAdmin) {
		$db->query("SELECT * FROM message LEFT JOIN member ON message.toid = member.id WHERE message.fromid = ".$userid." ORDER BY sentdate DESC") ;
	}
	else {
		$db->query("SELECT * FROM message LEFT JOIN member ON message.toid = member.id WHERE message.fromid = ".$userid." AND message.auto=0 ORDER BY sentdate DESC") ;
	}
	if ($db->numRows() > 0) {
		if ($_GET['action'] != "daoc") {
			$messages .= '<h2><a href="'.$sitepath.'usermenu/daoc">Delete All Sent Messages</a></h2>' ;
		}
		else {
			$messages .= '<h2><a href="'.$sitepath.'usermenu/dao"></a></h2>' ;
		}
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "ds") && ($_GET['action'] != "dao") && ($_GET['action'] != "daoc"))
			$messages .= displaySentMessages($resLV, quote_smart($_GET['page']), $sitepath."usermenu/outbox") ;
		else
			$messages .= displaySentMessages($resLV, 1, $sitepath."usermenu/outbox") ;
	}
	else {
		$messages .= "<h2><b>You have no sent messages in your outbox</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getBlocked() {
	global $db,$sitepath,$template,$templateimagepath ;
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>Blocked</b>&nbsp;Members</h1>' ;
	$db->query("SELECT * FROM member LEFT JOIN blocked ON member.id = blocked.blockee_id WHERE blocked.blocker_id =".$userid) ;
	if ($db->numRows() > 0) {
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "brm"))
			$messages .= displayBlocked($resLV, quote_smart($_GET['page']), $sitepath."usermenu/blocked") ;
		else
			$messages .= displayBlocked($resLV, 1, $sitepath."usermenu/blocked") ;
	}
	else {
		$messages .= "<h2><b>You have not blocked any members</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getSubscriptions() {
	global $db,$sitepath,$template,$templateimagepath ;
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>Members</b>&nbsp;you have subscribed to</h1>' ;
	$db->query("SELECT * FROM member LEFT JOIN subscription ON member.id = subscription.subscribedtoid WHERE subscription.userid =".$userid) ;
	if ($db->numRows() > 0) {
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "srm"))
			$messages .= displayMySubscriptions($resLV, quote_smart($_GET['page']), $sitepath."usermenu/subscriptions") ;
		else
			$messages .= displayMySubscriptions($resLV, 1, $sitepath."usermenu/subscriptions") ;
	}
	else {
		$messages .= "<h2><b>You have not subscribed to any members</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getProfileHistory() {
	global $db,$sitepath,$template,$templateimagepath ;
	if (checkHideMedia() == 1) {
		$hide = " AND (`requires_agreement` = 0)" ;
	}
	else {
		$hide = "" ;
	}
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>Profile</b> viewing history</h1><h2>These members have viewed your profile (most recent first)</h2>' ;
	$db->query("SELECT viewerhistory FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$viewerhistory = $idres['viewerhistory'] ;
	$members = array() ;
	$count = 0 ;
	if (strlen($viewerhistory) != 0) {
		$pastviewers = split(":", $viewerhistory) ;
		foreach ($pastviewers as $pv) {
			$db->query("SELECT * FROM member WHERE `activationkey`=0 AND id = '$pv'".$hide) ;
			$mres = $db->fetch() ;
			if (isset($mres['id'])) {
				if ($mres['id'] != '') {
					if ($mres['optoutofviewerlist'] < 1) {
						array_push($members, $mres) ;
						$count++ ;
					}
				}
			}
		}
	}
	if ($count > 0) {
		$messages .= '<h2><a href='.$sitepath.'usermenu/dw/>Clear Profile Views</a></h2>' ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "dh"))
			$messages .= displayMyProfileHistory($members, quote_smart($_GET['page']), $sitepath."usermenu/profilehistory") ;
		else
			$messages .= displayMyProfileHistory($members, 1, $sitepath."usermenu/profilehistory") ;
	}
	else {
		$messages .= "<h2><b>Your history is empty</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getFavorites() {
	global $db,$sitepath,$template,$templateimagepath ;
	if (checkHideMedia() == 1) {
		$hide = " AND (`requires_agreement` = 0)" ;
	}
	else {
		$hide = "" ;
	}
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$idres = $db->fetch() ;
	$userid = $idres['id'] ;
	$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>My</b> favorite media</h1>' ;
	$db->query("SELECT * FROM media LEFT JOIN favorite ON media.id = favorite.vidid WHERE favorite.userid =".$userid.$hide) ;
	if ($db->numRows() > 0) {
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['action'] != "rfav"))
			$messages .= displayMyFavorites($resLV, quote_smart($_GET['page']), $sitepath."usermenu/favorites") ;
		else
			$messages .= displayMyFavorites($resLV, 1, $sitepath."usermenu/favorites") ;
	}
	else {
		$messages .= "<h2><b>Your favorites list is empty</b></h2>" ;
	}
	$messages .= '' ;
	return $messages ;
}
function getManageGroups() {
	global $db,$sitepath,$template,$templateimagepath,$exists ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = groupform_new() ;
		return $output ;
	}
	else {
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$idres = $db->fetch() ;
		$userid = $idres['id'] ;
		$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>Manage</b> Groups</h1>' ;
		$messages .= '<form enctype="multipart/form-data" name="groupform" action="'.$sitepath.'usermenu/managegroups" method="POST">
		<input type="hidden" name="grouppage" value="newgroup">
		<fieldset><legend>create a group</legend>
		<ol>
		<li>
		<label for="groupname">name</label>
		<input type="text" name="groupname">
		</li>
		<li>
		<label for="groupdesc">description</label>
		<input type="text" name="groupdesc" size=45 value="' ;
		if ($exists) {
			$messages .= stripslashes($_POST['groupdesc']) ;
		}
		$messages .= '"></li><li>
		<label for="grouppriv">group privacy</label>
		<input type="radio" name="grouppriv" value="public" checked> public <input type="radio" name="grouppriv" value="private"> private 
		</li>
		<label for="newgroupsubmit">&nbsp;</label><input class="biggerbutton" type="submit" name="newgroupsubmit" value="create your new group" />  
		</ol>	</fieldset> 
		</form>' ;
		$messages .= '<br><h1><b>Groups</b> I have created</h1>' ;
		$db->query("SELECT * FROM `group` WHERE `owner_id` =".$userid." ORDER BY group_id DESC") ;
		return $messages ;
	}
}
function getmanageGroup() {
	global $db,$sitepath,$template,$templateimagepath ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/usercp_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = managegroup_new() ;
		return $output ;
	}
	else {
		$messages = '' ;
		if ($_GET['page'] > 0) {
			$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$idres = $db->fetch() ;
			$userid = $idres['id'] ;
			$groupid = quote_smart($_GET['page']) ;
			$db->query("SELECT * FROM `group` WHERE `group_id` =".$groupid) ;
			$grpres = $db->fetch() ;
			if ($grpres['name'] != '') {
				$ownerid = $grpres['owner_id'] ;
				if ($ownerid != $userid) {
					$messages = '<h2>You do not own this group!</h2>' ;
				}
				else {
					$groupname = $grpres['name'] ;
					$groupdesc = $grpres['group_description'] ;
					$grouppriv = $grpres['privacy'] ;
					if ($grpres['suspended'] == 1) {
						$groupactive = false ;
					}
					else {
						$groupactive = true ;
					}
					$icon = $grpres['icon'] ;
					$privatechecked = "" ;
					$publicchecked = "" ;
					if ($grouppriv == 1) {
						$privatechecked = " CHECKED" ;
					}
					else {
						$publicchecked = " CHECKED" ;
					}
					$messages = '<h1><img src="'.$templateimagepath.'icn_newest_members.jpg"><b>manage</b> Group "'.stripslashes($groupname).'"</h1>' ;
					if ($_POST['grouppage'] == 'managegroup') {
						$messages .= '<h3>Your changes have been submitted</h3>' ;
					}
					$messages .= '<h4><a href="'.$sitepath.'usermenu/managegroups"><< back to groups control panel</a></h4>' ;
					$messages .= '<form name="groupform" action="'.$sitepath.'usermenu/managegroup/'.$groupid.'" method="POST" enctype="multipart/form-data">
					<input type="hidden" name="grouppage" value="managegroup">
					<input type="hidden" name="groupid" value="'.$groupid.'">
					<fieldset><legend>edit your group and click \'submit changes\'</legend>
					<ol>
					<li>
					<label for="groupname">name</label>
					<input type="text" name="groupname" value="'.stripslashes($groupname).'">
					</li>
					<li>
					<label for="groupdesc">description</label>
					<input type="text" name="groupdesc" size=45 value="'.stripslashes($groupdesc).'">
					</li>
					<li>
					<label for="grouppriv">group privacy</label>
					<input type="radio" name="grouppriv" value="public"'.$publicchecked.'> public <input type="radio" name="grouppriv" value="private"'.$privatechecked.'> private 
					</li>
					<li>
					<label for="groupiconfile">group icon (max file size '.getSetting("maxgroupiconsize", $db).'Kb)</label>
					<input size="45" name="groupiconfile" class="filebox" type="file" />
					</li>' ;
					if ($icon <> '') {
						$messages .= '<li><label for="removeicon"><img src="'.$sitepath.'uploads/groupicons/'.$icon.'">&nbsp;</label><INPUT TYPE=CHECKBOX NAME="removeicon">delete this icon</input></li>' ;
					}
					if ($groupactive) {
						$messages .= '<h2>This group is active</h2><li><input type="checkbox" name="suspendgroup"> suspend group (group and media will only be visible to you while suspended)</input></li>' ;
					}
					else {
						$messages .= '<h2>This group is suspended</h2><li><input type="checkbox" name="unsuspendgroup"> make group active (group and media will be visible to members again)</input></li>' ;
					}
					$messages .= '
					<li>
					<label for="editgroupsubmit">&nbsp;</label>
					<input class="biggerbutton" type="submit" name="editgroupsubmit" value="submit changes" />  
					</li>
									</ol>
					</fieldset> 	
					</form>' ;
					$memberquery = "SELECT * FROM `member` LEFT JOIN `group_member` ON `group_member`.`member_id` = `member`.`id` WHERE `group_member`.`group_id_g` = ".$groupid." ORDER BY `approved` ASC" ;
					$db->query($memberquery) ;
					if ($db->numRows() > 0) {
						$messages .= '<br><h1><b>Group</b> Members</h1>' ;
						$resLV = $db->fetchAll() ;
						if ((isset($_GET['page2'])) && ($_GET['action'] != "agm") && ($_GET['action'] != "dgm") && ($_GET['action'] != "rgm"))
							$messages .= displayGroupMembers($resLV, $_GET['page2'], $sitepath."usermenu/managegroup/".$groupid) ;
						else
							$messages .= displayGroupMembers($resLV, 1, $sitepath."usermenu/managegroup/".$groupid) ;
					}
					else {
						$messages .= "<br><h1><b>Group</b> Members</h1><h2><b>Your group doesn't have any members yet</b></h2>" ;
					}
				}
			}
		}
		else {
			$messages = "<h2>This group does not exist</h2>" ;
		}
		return $messages ;
	}
}
function usermenuContent() {
	$content = '' ;
	$command = $_GET['action'] ;
	if (!isset($_GET['action'])) {
		$command = 'profile' ;
	}
	if (($command != "myreceivedrequests") && ($command != "agm") && ($command != "darq") && ($command != "darqc") && ($command != "dasq") && ($command != "dasqc") && ($command != "dgm") && ($command != "dai") && ($command != "dao") && ($command != "daic") && ($command != "daoc") && ($command != "rgm") && ($command != "managegroups") && ($command != "managegroup") && ($command != "mysentrequests") && ($command != "rf") && ($command != "rb") && ($command != "ra") && ($command != "af") && ($command != "dr") && ($command != "ra") && ($command != "dh") && ($command != "dcb") && ($command != "rfav") && ($command != "dl") && ($command != "rcq") && ($command != "dm") && ($command != "db") && ($command != "ds") && ($command != "brm") && ($command != "srm") && ($command != "media") && ($command != "myfriends") && ($command != "inbox") && ($command != "outbox") && ($command != "blocked") && ($command != "groups") && ($command != "favorites") && ($command != "dw") && ($command != "history") && ($command != "profilehistory") && ($command != "subscriptions")) {
		$command = 'profile' ;
	}
	if ($command == "media") {
		$content .= getMedia() ;
	}
	elseif (($command == "myfriends") || ($command == "rf") || ($command == "rb") || ($command == "ra")) {
		$content .= getFriends() ;
	}
	elseif (($command == "myreceivedrequests") || ($command == "af") || ($command == "dr") || ($command == "ra") || ($command == "dcb") || ($command == "dl") || ($command == "darq") || ($command == "darqc")) {
		$content .= getReceivedRequests() ;
	}
	elseif (($command == "mysentrequests") || ($command == "rcq") || ($command == "dasq") || ($command == "dasqc")) {
		$content .= getSentRequests() ;
	}
	elseif (($command == "inbox") || ($command == "dm") || ($command == "db") || ($command == "dai") || ($command == "daic")) {
		$content .= getInbox() ;
	}
	elseif ($command == "managegroups") {
		$content .= getManageGroups() ;
	}
	elseif (($command == "managegroup") || ($command == "agm") || ($command == "dgm") || ($command == "rgm")) {
		$content .= getmanageGroup() ;
	}
	elseif (($command == "outbox") || ($command == "ds") || ($command == "dao") || ($command == "daoc")) {
		$content .= getOutbox() ;
	}
	elseif (($command == "blocked") || ($command == "brm")) {
		$content .= getBlocked() ;
	}
	elseif (($command == "favorites") || ($command == "rfav")) {
		$content .= getFavorites() ;
	}
	elseif (($command == "history") || ($command == "dh")) {
		$content .= getHistory() ;
	}
	elseif (($command == "profilehistory") || ($command == "dw")) {
		$content .= getProfileHistory() ;
	}
	elseif (($command == "subscriptions") || ($command == "srm")) {
		$content .= getSubscriptions() ;
	}
	elseif ($command == "groups") {
		$content .= getGroups() ;
	}
	elseif ($command == "profile") {
		$content .= getProfile() ;
	}
	$content .= '' ;
	return $content ;
}
function userCPTabs() {
	global $db ;
	$link = $sitepath.'usermenu/' ;
	$command = $_GET['action'] ;
	$msgtab = "" ;
	$blktab = "" ;
	$frdtab = "" ;
	$medtab = "" ;
	if ($command == "msg") {
		$msgtab = ' class="crt"' ;
	}
	if ($command == "dm") {
		$msgtab = ' class="crt"' ;
	}
	if ($command == "blk") {
		$blktab = ' class="crt"' ;
	}
	if ($command == "frd") {
		$frdtab = ' class="crt"' ;
	}
	if ($command == "med") {
		$medtab = ' class="crt"' ;
	}
	if (!isset($_GET['action'])) {
		$msgtab = ' class="crt"' ;
	}
	if (($msgtab == "") && ($blktab == "") && ($frdtab == "") && ($medtab == "")) {
		$msgtab = ' class="crt"' ;
	}
	$tabs = '<!-- s:TABS -->
			<ul class="no-format c-tabs">
				<li'.$msgtab.'><span><a href="'.$link.'msg" title="Messages">Messages</a></span></li>
				<li'.$frdtab.'><span><a href="'.$link.'frd" title="Friends">Friends</a></span></li>
				<li'.$blktab.'><span><a href="'.$link.'blk" title="Blocked">Blocked</a></span></li>
				<li'.$medtab.'><span><a href="'.$link.'med" title="My Media">My Media</a></span></li>
			</ul>
			<!-- e:TABS -->' ;
	return $tabs ;
}


?>