<?php 
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: tags.inc
 *    Description:  Tag cloud functions
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
global $sitepath ;
function show_tags() {
	global $db ;
	$amu = getSetting("tags", $db) ;
	if (!$amu)
		$amu = 5 ;
	$query = "SELECT tags AS tag, COUNT(id) AS quantity, category AS category FROM media GROUP BY tag LIMIT 0, $amu" ;
	$db->query($query) ;
	while ($row = $db->fetch()) {
		$temp_tags = explode(',', $row['tag']) ;
		foreach ($temp_tags as $tag) {
			// normalize to lower case
			$tag = strtolower($tag) ;
			$tag = str_replace(",", "", $tag) ;// my fixes, just in case some comma keeps with the word
			$tag = trim($tag) ; // my fixes to del white space, preventing repeat words in the result.
			if (isset($tags[$tag])) {
				$tags[$tag]++ ;
			}
			else {
				$tags[$tag] = 1 ;
			}
		}
	}
	if (isset($tags)) {
	ksort($tags) ;
		$max_size = 300 ; // max font size in %
		$min_size = 100 ; // min font size in %
		$max_qty = max(array_values($tags)) ;
		$min_qty = min(array_values($tags)) ;
		$spread = $max_qty - $min_qty ;
		if (0 == $spread) { // we don't want to divide by zero
			$spread = 1 ;
		}
		$step = ($max_size - $min_size) / ($spread) ;
		$sitefolder = getSetting("sitefolder", $db) ;
		$path = "http://".$_SERVER['SERVER_NAME'].$sitefolder ;
		foreach ($tags as $key=>$value) {
			$size = $min_size + (($value - $min_qty) * $step) ;
			echo '<a href="'.$path."search/".$key.'" style="font-size: '.$size.'%"' ;
			echo ' title="'.$value.' Noticias tagged con la palabra '.$key.'"' ;
			echo '>'.$key.'</a> ' ;
		}
	}
}
?>