<? 
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: category.inc
 *    Description: Gets all data for category.module - displays media in a category 
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
global $db,$categoryName ;
//Remove underscores from category name
$maincategory = str_replace("_", " ", $_GET['crw']) ;
$subcategory = str_replace("_", " ", $_GET['scrw']) ;
$subsubcategory = str_replace("_", " ", $_GET['sscrw']) ;
if ($subsubcategory != '') {
      $catlevel = 3 ;
      $db->query("SELECT id from category WHERE name='".quote_smart($maincategory)."' AND (level=1)") ;
      $cres = $db->fetch() ;
      $mainid = $cres['id'] ;
      $db->query("SELECT id from category WHERE (name='".quote_smart($subcategory)."') AND (parent=".$mainid.") AND (level=2)") ;
      $cres = $db->fetch() ;
      $subid = $cres['id'] ;
      $db->query("SELECT id from category WHERE (name='".quote_smart($subsubcategory)."') AND (parent=".$subid.") AND (level=3)") ;
      $cres = $db->fetch() ;
      $catid = $cres['id'] ;
      $categoryName = $subsubcategory ;
}
else if ($subcategory != '') {
      $catlevel = 2 ;
      $db->query("SELECT id from category WHERE name='".quote_smart($maincategory)."' AND (level=1)") ;
      $cres = $db->fetch() ;
      $mainid = $cres['id'] ;
      $db->query("SELECT id from category WHERE (name='".quote_smart($subcategory)."') AND (parent=".$mainid.") AND (level=2)") ;
      $cres = $db->fetch() ;
      $catid = $cres['id'] ;
      $categoryName = $subcategory ;
}
else if ($maincategory != '') {
      $catlevel = 1 ;
      $db->query("SELECT id from category WHERE name='".quote_smart($maincategory)."' AND (level=1)") ;
      $cres = $db->fetch() ;
      $catid = $cres['id'] ;
      $categoryName = $maincategory ;
}
//categoryMedia function - gets media data from db based on POST variables

function categoryMedia() {
      global $db,$categoryName,$sitepath ;
      //Check if mature content should be hidded - only active when mature content
      $hide = (checkHideMedia() == 1) ? " AND (`requires_agreement` = 0)" : "" ;
      //Get dates used for filtering results
      $today = mktime(0, 0, 0, date("m"), date("d"), date("Y")) ;
      $startofyear = mktime(0, 0, 0, 1, 0, date("Y")) ;
      $aweek = 60 * 60 * 24 * 7 ;
      $startofweek = $startofyear + ($aweek * (intval(date("W") - 1))) ;
      $startofmonth = mktime(0, 0, 0, date("m"), 1, date("Y")) ;
      $mostviewed = false ;
      $toprated = false ;
      $recent = false ;
      //Prepare strings used in MySQL query
      if (isset($_POST['mostviewedsubmit'])) {
            $mostviewed = true ;
            if ($_POST['mostviewed'] == "alltime") {
                  $mvalltimesel = "SELECTED" ;
                  $filterstring = "ORDER BY allviews DESC" ;
                  $filter = "all" ;
            }
            if ($_POST['mostviewed'] == "today") {
                  $mvtodaysel = "SELECTED" ;
                  $filterstring = "ORDER BY dayviews DESC" ;
                  $filter = "today" ;
            }
            if ($_POST['mostviewed'] == "thisweek") {
                  $mvweeksel = "SELECTED" ;
                  $filterstring = "ORDER BY weekviews DESC" ;
                  $filter = "week" ;
            }
            if ($_POST['mostviewed'] == "thismonth") {
                  $mvmonthsel = "SELECTED" ;
                  $filterstring = "ORDER BY monthviews DESC" ;
                  $filter = "month" ;
            }
      }
      if (isset($_POST['recentsubmit'])) {
            $recent = true ;
            if ($_POST['recent'] == "today") {
                  $rctodaysel = "SELECTED" ;
                  $filterstring = "AND (added>".$today.") ORDER BY added DESC" ;
            }
            if ($_POST['recent'] == "thisweek") {
                  $rcweeksel = "SELECTED" ;
                  $filterstring = "AND (added>".$startofweek.") ORDER BY added DESC" ;
            }
            if ($_POST['recent'] == "thismonth") {
                  $rcmonthsel = "SELECTED" ;
                  $filterstring = "AND (added>".$startofmonth.") ORDER BY added DESC" ;
            }
      }
      if (isset($_POST['topratedsubmit'])) {
            $toprated = true ;
      }
      //Links displayed on page
      $filterlink = "<div align=right><form action=\"\" method=\"POST\" name=\"orderform\">most viewed&nbsp;<select name=\"mostviewed\">
	<option value=\"alltime\" ".$mvalltimesel.">all time</option>
	<option value=\"today\" ".$mvtodaysel.">today</option>
	<option value=\"thisweek\" ".$mvweeksel.">this week</option>
	<option value=\"thismonth\" ".$mvmonthsel.">this month</option>
	</select>&nbsp;<input class=\"biggerbutton\" type=\"submit\" name=\"mostviewedsubmit\" value=\"go\">&nbsp;&nbsp;&nbsp;&nbsp;" ;
      $filterlink .= "&nbsp;recently uploaded&nbsp;<select name=\"recent\" >
	<option value=\"today\" ".$rctodaysel.">today</option>
	<option value=\"thisweek\" ".$rcweeksel.">this week</option>
	<option value=\"thismonth\" ".$rcmonthsel.">this month</option>
	</select>&nbsp;<input class=\"biggerbutton\" type=\"submit\" name=\"recentsubmit\" value=\"go\">&nbsp;&nbsp;&nbsp;&nbsp;top rated&nbsp;<input class=\"biggerbutton\" type=\"submit\" name=\"topratedsubmit\" value=\"go\"></form></div>" ;
      // SQL for category and sub-category content
      $maincategory = str_replace("_", " ", $_GET['crw']) ;
      $subcategory = str_replace("_", " ", $_GET['scrw']) ;
      $subsubcategory = str_replace("_", " ", $_GET['sscrw']) ;
      if ($subsubcategory != '') {
            $catlevel = 3 ;
            $db->query("SELECT id from category WHERE name='".quote_smart($maincategory)."' AND (level=1)") ;
            $cres = $db->fetch() ;
            $mainid = $cres['id'] ;
            $db->query("SELECT id from category WHERE (name='".quote_smart($subcategory)."') AND (parent=".$mainid.") AND (level=2)") ;
            $cres = $db->fetch() ;
            $subid = $cres['id'] ;
            $db->query("SELECT id from category WHERE (name='".quote_smart($subsubcategory)."') AND (parent=".$subid.") AND (level=3)") ;
            $cres = $db->fetch() ;
            $catid = $cres['id'] ;
      }
      else if ($subcategory != '') {
            $catlevel = 2 ;
            $db->query("SELECT id from category WHERE name='".quote_smart($maincategory)."' AND (level=1)") ;
            $cres = $db->fetch() ;
            $mainid = $cres['id'] ;
            $db->query("SELECT id from category WHERE (name='".quote_smart($subcategory)."') AND (parent=".$mainid.") AND (level=2)") ;
            $cres = $db->fetch() ;
            $catid = $cres['id'] ;
      }
      else if ($maincategory != '') {
            $catlevel = 1 ;
            $db->query("SELECT id from category WHERE name='".quote_smart($maincategory)."' AND (level=1)") ;
            $cres = $db->fetch() ;
            $catid = $cres['id'] ;
      }
      if ($catid > - 1) {
            $db->query("SELECT id,level FROM category WHERE id=".$catid) ;
            if ($db->numRows() > 0) {
                  $catres = $db->fetch() ;
                  $catid = $catres['id'] ;
                  $level = $catres['level'] ;
                  //Top level category
                  if ($level == 1) {
                        $catQuery = "SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status` ='true')  AND (`suspended`!=1 OR `suspended` IS NULL) AND ((category=".$catid.") OR category IN 
(SELECT 
c.id top_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid.") 
OR category IN
 (SELECT 
sc.id subcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid.")
OR category IN (SELECT 
ssc.id subsubcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid."))".$hide." ORDER BY allviews DESC" ;
                        if (($mostviewed) || ($recent)) {
                              $catQuery = "SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status` ='true')  AND (`suspended`!=1 OR `suspended` IS NULL) AND ((category =".$catid.") OR category IN 
(SELECT 
c.id top_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid.") 
OR category IN
 (SELECT 
sc.id subcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid.")
OR category IN (SELECT 
ssc.id subsubcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid."))".$hide." ".$filterstring ;
                        }
                        else if ($toprated) {
                              $catQuery = "SELECT v.*, g.*, (r.total_value/r.total_votes) as rating FROM media v LEFT JOIN rating r ON r.id = v.id LEFT JOIN `group` g ON g.group_id = v.groupid WHERE v.status = 'true' AND (`suspended`!=1 OR `suspended` IS NULL) AND (v.category IN (SELECT id FROM category WHERE id=".$catid.")
				 OR v.category IN 
(SELECT 
c.id top_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid.") 
OR v.category IN
 (SELECT 
sc.id subcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid.")
OR v.category IN (SELECT 
ssc.id subsubcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE c.id=".$catid.")) ".$hide." ORDER BY (r.total_value/r.total_votes) DESC" ;
                        }
                  }
                  //Second level category
                  else if ($level == 2) {
                        $catQuery = "SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status` ='true')  AND (`suspended`!=1 OR `suspended` IS NULL) AND ((category =".$catid.")  OR category IN
 (SELECT 
sc.id subcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE sc.id=".$catid.")
OR category IN (SELECT 
ssc.id subsubcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE sc.id=".$catid."))".$hide." ORDER BY allviews DESC" ;
                        if (($mostviewed) || ($recent)) {
                              $catQuery = "SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status` ='true')  AND (`suspended`!=1 OR `suspended` IS NULL) AND ((category =".$catid.")  OR category IN
 (SELECT 
sc.id subcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE sc.id=".$catid.")
OR category IN (SELECT 
ssc.id subsubcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE sc.id=".$catid."))".$hide." ".$filterstring ;
                        }
                        else if ($toprated) {
                              $catQuery = "SELECT v.*, g.*, (r.total_value/r.total_votes) as rating FROM media v LEFT JOIN rating r ON r.id = v.id LEFT JOIN `group` g ON g.group_id = v.groupid WHERE v.status = 'true' AND (`suspended`!=1 OR `suspended` IS NULL) AND ((v.category =".$catid.")  OR v.category IN
 (SELECT 
sc.id subcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE sc.id=".$catid.")
OR v.category IN (SELECT 
ssc.id subsubcat_id
FROM category c
INNER JOIN category sc ON sc.parent = c.id
INNER JOIN category ssc ON ssc.parent = sc.id WHERE sc.id=".$catid.")) ".$hide." ORDER BY (r.total_value/r.total_votes) DESC" ;
                        }
                  }
                  //Third level category
                  else if ($level == 3) {
                        $catQuery = "SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status` ='true')  AND (`suspended`!=1 OR `suspended` IS NULL) AND (`category`=".$catid.")".$hide." ORDER BY allviews DESC" ;
                        if (($mostviewed) || ($recent)) {
                              $catQuery = "SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE (`status` ='true')  AND (`suspended`!=1 OR `suspended` IS NULL) AND (`category`=".$catid.")".$hide." ".$filterstring ;
                        }
                        else if ($toprated) {
                              $catQuery = "SELECT v.*, g.*, (r.total_value/r.total_votes) as rating FROM media v LEFT JOIN rating r ON r.id = v.id LEFT JOIN `group` g ON g.group_id = v.groupid WHERE v.status = 'true' AND (`suspended`!=1 OR `suspended` IS NULL) AND (v.category=".$catid.") ".$hide." ORDER BY (r.total_value/r.total_votes) DESC" ;
                        }
                  }
                  $db->query($catQuery) ;
                  $output = $filterlink."<br><br>" ;
                  if ($db->numRows() > 0) {
                        $resTR = $db->fetchAll() ;
                        $sitefolder = getSetting("sitefolder", $db) ;
                        $path = $sitepath."category/$maincategory" ;
                        if ($subsubcategory != '') {
                              $path .= "/_$subcategory/__$subsubcategory" ;
                        }
                        else if ($subcategory != '') {
                              $path .= "/_$subcategory" ;
                        }
                        //Create output for category media
                        if (isset($_GET['page']))
                              $output .= displayCategoryMedia($resTR, $_GET['page'], $path, $filter) ;
                        else
                              $output .= displayCategoryMedia($resTR, 1, $path, $filter) ;
                  }
                  else {
                        $output .= "<h2>No media to display</h2>" ;
                  }
            }
            else {
                  $output .= "<h3>Sorry, this is not a category</h3>" ;
            }
      }
      else {
            $output .= "<h3>Sorry, this is not a category</h3>" ;
      }
      return $output ;
}

function displayCategoryMedia($res, $page = 1, $url = "", $filter) {
      global $db,$sitepath,$loggedIn,$templateimagepath ;
      if ($loggedIn) {
            $db->query("SELECT id FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
            $ures = $db->fetch() ;
            $memberid = $ures['id'] ;
            $db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
            $groupmembership = $db->fetchAll() ;
      }
      $vidcount = 0 ;
      foreach ($res as $key=>$value) {
            if ($value['added'] < time()) {
                  $groupid = $value['groupid'] ;
                  $groupprivate = $value['privacy'] ;
                  $visible = true ;
                  if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
                        if ($loggedIn) {
                              $approvedmember = false ;
                              foreach ($groupmembership as $gmkey=>$groupmember) {
                                    if ($groupmember['group_id_g'] == $groupid) {
                                          $approvedmember = true ;
                                          break ;
                                    }
                              }
                              if (!$approvedmember) {
                                    $visible = false ;
                              }
                        }
                        else {
                              $visible = false ;
                        }
                  }
                  if ($visible) {
                        $vidcount++ ;
                  }
            }
      }
      $perpage = getSetting("categorypp", $db) ;
      $pages = ceil($vidcount / $perpage) ;
      $path = getSetting("sitefolder", $db) ;
      $pageLinks = "" ;
      //Page formatting
      $pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
      $pp = $page - 1 ;
      if ($pp >= 1) {
            $pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
      }
      $p = 1 ;
      $stopat = ($pages <= 10) ? $pages : 10 ;
      if ($pages > 10 && $page > 6) {
            if (!$nomr) {
                  $pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
            }
            else {
                  $pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
            }
      }
      $p = 1 ;
      $stopat = ($pages <= 10) ? $pages : 10 ;
      if ($pages > 10 && $page > 5) {
            $p = $page - 5 ;
            $stopat = $page + 5 ;
            if ($stopat > $pages)
                  $stopat = $pages ;
      }
      for ($p; $p <= $stopat; $p++) {
            if (!$nomr) {
                  if ($p == $page)
                        $pageLinks .= "$p " ;
                  else
                        $pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
            }
            else {
                  if ($p == $page)
                        $pageLinks .= "$p " ;
                  else
                        $pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
            }
      }
      if ($pages > 10) {
            if (!$nomr) {
                  $pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
            }
            else {
                  $pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
            }
      }
      $np = $page + 1 ;
      if ($np <= $pages) {
            $pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
      }
      $pageLinks .= "</div></div></div></div>" ;
      $output = "" ;
      $count = 0 ;
      $page-- ;
      //Clear previous page results
      for ($i = 0; $i < $perpage * $page; $i++)
            unset($res[$i]) ;
      foreach ($res as $key=>$value) {
            if ($value['added'] < time()) {
                  $groupid = $value['groupid'] ;
                  $groupprivate = $value['privacy'] ;
                  $visible = true ;
                  if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
                        if ($loggedIn) {
                              $approvedmember = false ;
                              foreach ($groupmembership as $gmkey=>$groupmember) {
                                    if ($groupmember['group_id_g'] == $groupid) {
                                          $approvedmember = true ;
                                          break ;
                                    }
                              }
                              if (!$approvedmember) {
                                    $visible = false ;
                              }
                        }
                        else {
                              $visible = false ;
                        }
                  }
                  if ($visible) {
                        $count++ ;
                        $thumbpath = 'uploads/thumbs/' ;
                        $thumb = '' ;
                        $anim = '' ;
                        if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
                              $thumb = $templateimagepath."default_mature_thumb.jpg" ;
                        }
                        else {
                              if (file_exists($thumbpath.$value['thumb'].".small.jpg")) {
                                    $thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
                                    if (file_exists($thumbpath.$value['thumb'].".prv")) {
                                          $anim = $sitepath."uploads/thumbs/".$value['thumb'] ;
                                    }
                              }
                              elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg")) {
                                    $thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
                                    $anim = $sitepath."uploads/thumbs/".$value['mediaurl'] ;
                              }
                              elseif (findThumb($value['thumb'], true)) {
                                    $thumb = findThumb($value['thumb'], true) ;
                                    $thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
                                    $anim = $sitepath."uploads/thumbs/".$thumb[0] ;
                              }
                              if ($thumb == '') {
                                    $thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
                              }
                              $thumb = str_replace(" ", "%20", $thumb) ;
                        }
                        $kat = getCategoryPath($value['category']) ;
                        $db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
                        $resR = $db->fetch() ;
                        $title = url_encode($value['title']) ;
                        $output .= "<li>" ;
                        //thumbnail
                        if ($anim != "") {
                              $output .= "<div class=\"thumbholder\" id='thumb".$count."' onmouseover='replace_thumb(".$count.", \"<a href=&#39;".$sitepath."play".$kat."/".$title."&#39;><img src=&#39;".$thumb."&#39;></a>\");'>" ;
                              $output .= "<a href='".$sitepath."play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
                              $output .= "</div>" ;
                        }
                        else {
                              $output .= "<div class=\"thumbholder\" id='thumb".$count."'>" ;
                              $output .= "<a href='".$sitepath."play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
                              $output .= "</div>" ;
                        }
                        //title
                        $output .= "<h3>" ;
                        if ($anim != "") {
                              $output .= "<img class=\"preview\" onmouseover='start_thumb(".$count." ,\"".$anim."\")' src=\"".$templateimagepath."preview_box.png\">" ;
                        }
                        $output .= "&nbsp;&nbsp;<b><a href=\"".$sitepath."ply$kat/$title\">".str_replace("_", " ", $short_title)."</a><span class=\"rating\">".show_rating($value['id'])."</span></b></h3>" ;
                        $value['description'] = force_length($value['description'], 130) ;
                        $output .= "<p>".$value['description']."</p>\n" ;
                        if (($filter == "all") || ($filter == "")) {
                              $viewstring = $value['allviews'] ;
                        }
                        else if ($filter == "today") {
                              $viewstring = $value['dayviews'] ;
                        }
                        else if ($filter == "week") {
                              $viewstring = $value['weekviews'] ;
                        }
                        else if ($filter == "month") {
                              $viewstring = $value['monthviews'] ;
                        }
                        else if ($filter == "toprated") {
                              $viewstring = $value['allviews'] ;
                        }
                        if ($viewstring == '') {
                              $viewstring = 0 ;
                        }
                        $output .= "<div class=\"inf\"><div class=\"inf-right\"><b>From <a href=\"".$sitepath."profile/".$value['poster']."\">".$value['poster']."</a> on:</b> ".date("m.d.y", $value['added'])."<span class=\"views\"><b>views:</b> ".$viewstring ;
                        $output .= "</span></div></div>" ;
                        $output .= "</li>\n" ;
                        if ($count == $perpage)
                              break ;
                  }
            }
      }
      if ($pages != 1)
            $output .= $pageLinks ;
      return $output ;
}
?>