<?php 
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: settings.inc
 *    Description: Admin options for site settings
 *    $Date: 2010-04-04 20:13:11 +0100 (Sun, 04 Apr 2010) $
 *    $Revision: 59 $
 */
global $sitepath,$db ;
$site_template = getSetting("sitetemplate", $db) ;
$template_file = "templates/".$site_template."/modules/admin/settings_content.php" ;
if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
	include_once ($template_file) ;
	$output = settings_new($res, $page, $url) ;
	return $output ;
}
else {
	if (isset($_GET['page'])) {
		$mediasettings = $_GET['page'] == 'media' ;
		$playersettings = $_GET['page'] == 'player' ;
		$encodingsettings = $_GET['page'] == 'encoding' ;
		$perpagesettings = $_GET['page'] == 'perpage' ;
		$traffic = $_GET['page'] == 'traffic' ;
	}
	else {
		$globalsettings = true ;
	}
	$globallink = "<a href='".$sitepath."index.php?id=106'>Global</a>" ;
	$medialink = "<a href='".$sitepath."index.php?id=106&page=media'>Media</a>" ;
	$playerlink = "<a href='".$sitepath."index.php?id=106&page=player'>Player</a>" ;
	$encodinglink = "<a href='".$sitepath."index.php?id=106&page=encoding'>Encoding</a>" ;
	$perpagelink = "<a href='".$sitepath."index.php?id=106&page=perpage'>Items Per Page</a>" ;
	$trafficlink = "<a href='".$sitepath."index.php?id=106&page=traffic'>Traffic Exchange</a>" ;
	$manageadslink = "<a href='".$sitepath."index.php?id=117'>click here</a>" ;
	$db->query("SELECT * FROM setting WHERE setting='upload_videos'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('upload_videos','1')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='news'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('news','5')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='useredit'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('useredit','1')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='approval'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('approval','0')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='stags'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('stags','0')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='straffic'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('straffic','0')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='traffic'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('traffic','5')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='tags'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('tags','50')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='upload_music'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('upload_music','1')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='upload_images'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('upload_images','1')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='upload_games'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('upload_games','1')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='allow_embed'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('allow_embed','1')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='game_width'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('game_width','476')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='game_height'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('game_height','371')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='leavefileonserver'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('leavefileonserver','0')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='titledisplaylength'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('titledisplaylength','300')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='latest_page_table_layout'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('latest_page_table_layout','0')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='mostviewed_page_table_layout'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('mostviewed_page_table_layout','0')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='toprated_page_table_layout'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('toprated_page_table_layout','0')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='new_uploader'") ;
	if ($db->numRows() < 1) {
		$db->query("INSERT INTO setting (setting,value) VALUES ('new_uploader','1')") ;
	}
	$db->query("SELECT * FROM setting WHERE setting='player'") ;
	if ($db->numRows() < 1) {
		$db->query('UPDATE `menu` SET `content` = "<div id=\'right-col-content\'><div class=\'spacing\'><h2>Admin Menu</h2><?require_once \'includes/admin/index.inc\'?><ul>
<li><a href=\'<?=$sitepath?>?id=104\'>New Uploads (<?=$numNewVideos?> New)</a></li>
<li><a href=\'<?=$sitepath?>?id=103\'>Manage Media</a></li>
<li><a href=\'<?=$sitepath?>?id=105\'>Manage Users</a></li>
<li><a href=\'<?=$sitepath?>?id=117\'>Manage Video Ads</a></li>
<li><a href=\'<?=$sitepath?>?id=118\'>Manage Site Ads</a></li>
<li><a href=\'<?=$sitepath?>?id=102\'>Manage Categories</a></li>
<li><a href=\'<?=$sitepath?>?id=111\'>Manage Email Text</a></li>
<li><a href=\'<?=$sitepath?>?id=109\'>Manage Menus</a></li>
<li><a href=\'<?=$sitepath?>news\'>Manage News</a></li>
<li><a href=\'<?=$sitepath?>?id=113\'>Bad Words Filter</a></li>
<li><a href=\'<?=$sitepath?>?id=106\'>Site Settings</a></li>
<li><a href=\'<?=$sitepath?>?id=150\'>Site Features</a></li>
</ul></div></div>" WHERE `menu`.`id` = 2;');
		$db->query("INSERT INTO setting (setting,value) VALUES ('player','vidi')") ;
	}
	if (isset($_POST['submit'])) { //Save changes
		if ($globalsettings) {
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['contact_email'])."' WHERE `setting` = 'contact_email'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['default_from'])."' WHERE `setting` = 'default_from'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['sitename'])."' WHERE `setting` = 'sitename'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['sitetitle'])."' WHERE `setting` = 'sitetitle'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['sitefolder'])."' WHERE `setting` = 'sitefolder'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['sitetemplate'])."' WHERE `setting` = 'sitetemplate'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['news'])."' WHERE `setting` = 'news'") ;
			$postmax = ini_get('upload_max_filesize') ;
			$postmax = str_replace('M', '', $postmax) ;
			if (($postmax * 1048576) < $_POST['mediamaxsize']) {
				$_POST['videomaxsize'] = $postmax * 1048576 ;
				echo "Upload max Size in php.ini is smaller then the size you entered, size has been limited accordingly" ;
			}
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['mediamaxsize'])."' WHERE `setting` = 'mediamaxsize'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['titledisplaylength'])."' WHERE `setting` = 'titledisplaylength'") ;
			$leavefileonserver = $_POST['leavefileonserver'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($leavefileonserver)."' WHERE `setting` = 'leavefileonserver'") ;
			$latest_page_table_layout = $_POST['latest_page_table_layout'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($latest_page_table_layout)."' WHERE `setting` = 'latest_page_table_layout'") ;
			$mostviewed_page_table_layout = $_POST['mostviewed_page_table_layout'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($mostviewed_page_table_layout)."' WHERE `setting` = 'mostviewed_page_table_layout'") ;
			$toprated_page_table_layout = $_POST['toprated_page_table_layout'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($toprated_page_table_layout)."' WHERE `setting` = 'toprated_page_table_layout'") ;
			$activation = $_POST['activation'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($activation)."' WHERE `setting` = 'activation'") ;
			$approval = $_POST['approval'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($approval)."' WHERE `setting` = 'approval'") ;
			$stags = $_POST['stags'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($stags)."' WHERE `setting` = 'stags'") ;
			$straffic = $_POST['straffic'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($straffic)."' WHERE `setting` = 'straffic'") ;
			$accountpage = $_POST['accountpage'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($accountpage)."' WHERE `setting` = 'accountpageon'") ;
			$admin_notified = $_POST['admin_notified'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($admin_notified)."' WHERE `setting` = 'admin_notified'") ;
			$admin_automod = $_POST['admin_automod'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($admin_automod)."' WHERE `setting` = 'admin_automod'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['comment_length'])."' WHERE `setting` = 'comment_length'") ;
			$restrictpc = $_POST['restrictpc'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($restrictpc)."' WHERE `setting` = 'restrictpc'") ;
			$captchaformembers = $_POST['captchaformembers'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($captchaformembers)."' WHERE `setting` = 'captchaformembers'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['maxgroupiconsize'])."' WHERE `setting` = 'maxgroupiconsize'") ;
			$groupaddnotify = $_POST['groupaddnotify'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($groupaddnotify)."' WHERE `setting` = 'groupaddnotify'") ;
			$useredit = $_POST['useredit'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($useredit)."' WHERE `setting` = 'useredit'") ;
		}
		if ($mediasettings) {
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['avatar_w'])."' WHERE `setting` = 'avatar_w'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['avatar_h'])."' WHERE `setting` = 'avatar_h'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['savatar_w'])."' WHERE `setting` = 'savatar_w'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['savatar_h'])."' WHERE `setting` = 'savatar_h'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['thumb_w1'])."' WHERE `setting` = 'thumb_w1'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['thumb_h1'])."' WHERE `setting` = 'thumb_h1'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['thumb_w2'])."' WHERE `setting` = 'thumb_w2'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['thumb_h2'])."' WHERE `setting` = 'thumb_h2'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['game_width'])."' WHERE `setting` = 'game_width'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['game_height'])."' WHERE `setting` = 'game_height'") ;
			$restrictdown = $_POST['restrictdown'] == 'on' ? 0 : 1 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($restrictdown)."' WHERE `setting` = 'restrictdown'") ;
			$restrictdv = $_POST['restrictdv'] == 'on' ? 0 : 1 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($restrictdv)."' WHERE `setting` = 'restrictdv'") ;
			$moderate_media = $_POST['moderate_media'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($moderate_media)."' WHERE `setting` = 'moderate_media'") ;
			$show_embedcode = $_POST['show_embedcode'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($show_embedcode)."' WHERE `setting` = 'show_embedcode'") ;
			$upload_videos = $_POST['upload_videos'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($upload_videos)."' WHERE `setting` = 'upload_videos'") ;
			$upload_music = $_POST['upload_music'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($upload_music)."' WHERE `setting` = 'upload_music'") ;
			$upload_images = $_POST['upload_images'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($upload_images)."' WHERE `setting` = 'upload_images'") ;
			$upload_games = $_POST['upload_games'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($upload_games)."' WHERE `setting` = 'upload_games'") ;
			$allow_embed = $_POST['allow_embed'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($allow_embed)."' WHERE `setting` = 'allow_embed'") ;
			$player = $_POST['player'] == 'flow' ? 'flow' : 'vidi' ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($player)."' WHERE `setting` = 'player'") ;
		}
		if ($playersettings) {
			$autostart = $_POST['autostart'] == 'on' ? 1 : 0 ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($autostart)."' WHERE `setting` = 'autostart'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['buffertime'])."' WHERE `setting` = 'buffertime'") ;
			$watermarkpath = $_POST['watermarkpath'] ;
			if (! empty($_FILES['watermarkupload']['tmp_name'])) {
				echo "uploaded watermark" ;
				$filename = str_replace(" ", "_", $_FILES['watermarkupload']['name']) ;
				if (move_uploaded_file($_FILES['watermarkupload']['tmp_name'], 'uploads/'.$filename)) {
					$watermarkpath = $sitepath.'uploads/'.$filename ;
				}
			}
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($watermarkpath)."' WHERE `setting` = 'watermarkpath'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['watermarklink'])."' WHERE `setting` = 'watermarklink'") ;
		}
		if ($encodingsettings) {
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['ffmpegpath'])."' WHERE `setting` = 'ffmpegpath'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['mencoderpath'])."' WHERE `setting` = 'mencoderpath'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['flvtool2path'])."' WHERE `setting` = 'flvtool2path'") ;
			$encoder = $_POST['encoder'] == 'ffmpeg' ? 'ffmpeg' : 'mencoder' ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($encoder)."' WHERE `setting` = 'encoder'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['videobitrate'])."' WHERE `setting` = 'videobitrate'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['framerate'])."' WHERE `setting` = 'framerate'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['encodesize'])."' WHERE `setting` = 'encodesize'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['default_thumbtime'])."' WHERE `setting` = 'default_thumbtime'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['audiofrequency'])."' WHERE `setting` = 'audiofrequency'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['audiobitrate'])."' WHERE `setting` = 'audiobitrate'") ;
		}
		if ($perpagesettings) {
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['newestpp'])."' WHERE `setting` = 'newestpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['mainpp'])."' WHERE `setting` = 'mainpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['topratedpp'])."' WHERE `setting` = 'topratedpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['mostviewedpp'])."' WHERE `setting` = 'mostviewedpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['searchpp'])."' WHERE `setting` = 'searchpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['allgroupspp'])."' WHERE `setting` = 'allgroupspp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['groupmediapp'])."' WHERE `setting` = 'groupmediapp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['groupmemberpp'])."' WHERE `setting` = 'groupmemberpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['groupcommentspp'])."' WHERE `setting` = 'groupcommentspp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['categorypp'])."' WHERE `setting` = 'categorypp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['membersperpage'])."' WHERE `setting` = 'membersperpage'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['messagepp'])."' WHERE `setting` = 'messagepp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['sentmesspp'])."' WHERE `setting` = 'sentmesspp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['friendspp'])."' WHERE `setting` = 'friendspp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['recfriendpp'])."' WHERE `setting` = 'recfriendpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['sentfriendpp'])."' WHERE `setting` = 'sentfriendpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['blockedpp'])."' WHERE `setting` = 'blockedpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['subscriptionspp'])."' WHERE `setting` = 'subscriptionspp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['favoritespp'])."' WHERE `setting` = 'favoritespp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['mediapp'])."' WHERE `setting` = 'mediapp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['groupslistpp'])."' WHERE `setting` = 'groupslistpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['groupmempp'])."' WHERE `setting` = 'groupmempp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['historypp'])."' WHERE `setting` = 'historypp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['profilehistorypp'])."' WHERE `setting` = 'profilehistorypp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['profmedpp'])."' WHERE `setting` = 'profmedpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['proffavpp'])."' WHERE `setting` = 'proffavpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['profsubspp'])."' WHERE `setting` = 'profsubspp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['proffrdpp'])."' WHERE `setting` = 'proffrdpp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['profgrppp'])."' WHERE `setting` = 'profgrppp'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['relateduserpage'])."' WHERE `setting` = 'relateduserpage'") ;
			$db->query("UPDATE `setting` SET `value` = '".quote_smart($_POST['traffic'])."' WHERE `setting` = 'traffic'") ;
			$db->query("UPDATE `setting` SET `value` = '".$_POST['amutags']."' WHERE `setting` = 'tags'") ;
		}
		echo "<p>Settings saved.</p><br/>" ;
	}
	//Get templates
	$dir = opendir('./templates/') ;
	while (($file = readdir($dir)) !== false) {
		if ($file != "index.html") {
			if (is_dir("./templates/".$file."/") && $file != "." && $file != "..")
				$templates[] = $file ;
		}
	}
	closedir($dir) ;
	sort($templates) ;
	$cur_template = getSetting("sitetemplate", $db) ;
	if (!file_exists("templates/".$cur_template."/style.css"))
		$cur_template = "dark" ;
}
?>