
<p>NBBC is responsible for turning BBCode input into safe XHTML output, but one thing that
it does <i>not</i> do is any styling of the output.  For example, if you install NBBC and
start using it without any CSS styles, you'll see this:</p>

	<div style='margin-left:2em;'>
	<div class='code_header'>Code:</div>
	<xmp class='code'>[quote=Somebody]A rolling stone gathers no moss.[/quote]</xmp>
	<div class='output_header'>Output:</div>
	<div class='output'>
	<div>
	<div>Somebody wrote:</div>
	<div>A rolling stone gathers no moss.</div>
	</div>
	</div>
	</div>

<p>instead of seeing this:</p>

	<div style='margin-left:2em;'>
	<div class='output_header'>Output:</div>
	<div class='output'>
	<div class="bbcode_quote">
	<div class="bbcode_quote_head">Somebody wrote:</div>
	<div class="bbcode_quote_body">A rolling stone gathers no moss.</div>
	</div>
	</div>
	</div>

<p>Clearly, the latter appearance is preferable:  It has a nice blue box with a title area,
and formats its content attractively.  So why doesn't NBBC do this by default?  Because that's
probably not what you want.</p>

<p>NBBC can be used on a wide variety of web sites, and it has no way of knowing what kinds
of color schemes and fonts and artwork you're using for the basic theme of your site.
You could have a white background with black text, a black background with white text,
a red background with yellow text, or even an ugly purple image background with hideous
green text; and in all of those, NBBC needs to be able to conform to your needs, not the
other way around.  So instead of producing quotes that are always black-on-white with
a specific border, or rules that are always indented, NBBC's Standard BBCode Library
outputs fairly generic XHTML with very specific CSS classes attached to it so that
you can use your own CSS rules to style the output exactly as you want.</p>

<p>These are the CSS classes output by NBBC, grouped more-or-less by type:</p>

<ul>
<li><tt><b>bbcode_spoiler</b></tt>: <tt>&lt;span&gt;</tt> that contains a spoiler.</li>
<li><tt><b>bbcode_acronym</b></tt>: <tt>&lt;span&gt;</tt> that contains an acronym.<br /><br /></li>
<li><tt><b>bbcode_left</b></tt>: <tt>&lt;div&gt;</tt> that aligns content to the left.</li>
<li><tt><b>bbcode_right</b></tt>: <tt>&lt;div&gt;</tt> that aligns content to the right.</li>
<li><tt><b>bbcode_center</b></tt>: <tt>&lt;div&gt;</tt> that aligns content to the center.</li>
<li><tt><b>bbcode_indent</b></tt>: <tt>&lt;div&gt;</tt> that indents its content.<br /><br /></li>
<li><tt><b>bbcode_columns</b></tt>: <tt>&lt;table&gt;</tt> that is used to generate multiple columns.</li>
<li><tt><b>bbcode_column</b></tt>: <tt>&lt;td&gt;</tt> that contains any single column.</li>
<li><tt><b>bbcode_firstcolumn</b></tt>: <tt>&lt;td&gt;</tt> that contains the first column in a group.<br /><br /></li>
<li><tt><b>bbcode_code</b></tt>: <tt>&lt;div&gt;</tt> that wraps around a whole code block.</li>
<li><tt><b>bbcode_code_head</b></tt>: <tt>&lt;div&gt;</tt> that wraps around the "Code:" title area.</li>
<li><tt><b>bbcode_code_body</b></tt>: <tt>&lt;div&gt;</tt> that wraps around content of a code block.<br /><br /></li>
<li><tt><b>bbcode_quote</b></tt>: <tt>&lt;div&gt;</tt> that wraps around a whole quote block.</li>
<li><tt><b>bbcode_quote_head</b></tt>: <tt>&lt;div&gt;</tt> that wraps around the "So-and-so wrote:" title area.</li>
<li><tt><b>bbcode_quote_body</b></tt>: <tt>&lt;div&gt;</tt> that wraps around content of a code block.<br /><br /></li>
<li><tt><b>bbcode_url</b></tt>: <tt>&lt;a&gt;</tt> that was generated by a <tt>[url]</tt> tag.</li>
<li><tt><b>bbcode_email</b></tt>: <tt>&lt;a&gt;</tt> that was generated by an <tt>[email]</tt> tag.</li>
<li><tt><b>bbcode_wiki</b></tt>: <tt>&lt;a&gt;</tt> that was generated by a <tt>[wiki]</tt> or <tt>[[wiki]]</tt> tag.</li>
<li><tt><b>bbcode_img</b></tt>: <tt>&lt;img&gt;</tt> that was generated by an <tt>[img]</tt> tag.<br /><br /></li>
<li><tt><b>bbcode_list</b></tt>: <tt>&lt;ul&gt;</tt> or <tt>&lt;ol&gt;</tt> that was generated by a <tt>[list]</tt> tag.</li>
</ul>

<p>Generally, you will <i>not</i> want to provide CSS for most of these.  NBBC uses inline styles for some
tags whose purpose is obvious, such as <tt>[center]</tt> and <tt>[list]</tt>, so the CSS
classes are mainly included for convenience and completeness.  Typically, you'll want to
provide CSS for about half of these classes, like this example for a typcial black-on-white
site with blue accent colors:</p>

	<div style='margin-left:2em;'>
	<div class='code_header'>Code:</div>
	<xmp class='code'>/* Add a dashed underline to acronyms. */
span.acronym { border-bottom:1px dashed green; }
span.acronym:hover { color: green; border-bottom:1px dashed lightgreen; }

/* Make spoilers invisible, so that you need to select them with the mouse. */
span.spoiler { background-color: black; color: black; }

/* Align columns to the top, and add some space between them. */
table.bbcode_columns { border-collapse: collapse;
    margin-top: 1em; margin-bottom: 1em; }
table.bbcode_columns td.bbcode_column { padding: 0 1em; vertical-align: top;}
table.bbcode_columns td.bbcode_firstcolumn { border-left: 0; padding-left: 0; }

/* Wrap quotes in a big blue box. */
div.bbcode_quote { border: 1px solid blue; margin: 0.5em 0; }
div.bbcode_quote_head { background-color: blue; color: white;
    font-weight: bold; padding: 0.25em 0.5em; }
div.bbcode_quote_head a:link { color: yellow; }
div.bbcode_quote_head a:visited { color: yellow; }
div.bbcode_quote_head a:hover { color: white; text-decoration: underline; }
div.bbcode_quote_head a:active { color: white; text-decoration: underline; }
div.bbcode_quote_body { background-color: skyblue;
    color: black; padding: 0.5em 1em; }

/* Wrap code in a big blue box. */
div.bbcode_code { border: 1px solid blue; margin: 0.5em 0; }
div.bbcode_code_head { background-color: blue; color: white;
    font-weight: bold; padding: 0.25em 0.5em; }
div.bbcode_code_body { background-color: skyblue; color: black;
    font: 10pt monospace; padding: 0.5em 1em; }</xmp>
	</div>

<p>In short, you will need to provide some kind of CSS for <tt>[acronym]</tt>,
<tt>[spoiler]</tt>, <tt>[columns]</tt>, <tt>[quote]</tt>, and <tt>[code]</tt>,
primarily because NBBC can't guess in advance what colors and images and
backgrounds to use for them.</p>

<p>Hopefully, it doesn't need to be said that you also should wrap the entire
BBCode output in a <tt>&lt;span&gt;</tt> or <tt>&lt;div&gt;</tt> if you intend to
style content within it.  NBBC intentionally does not include a container
<tt>&lt;span&gt;</tt> or <tt>&lt;div&gt;</tt> so that you can decide for yourself
what kind of wrapper to use and whether to include additional content of your
own before or after the BBCode output.  You may want to see the
<a href="api_root.html#ref_parser_SetRootInline">SetRootInline()</a>
and <a href="api_root.html#ref_parser_SetRootBlock">SetRootBlock()</a> functions,
which contain more information on the subject of wrapping the output in an
HTML container element.</p>

<p>For more example CSS that you can use, look in the appendix section
with <a href="app_css.html">CSS Examples</a>.</p>

