/**
 * @copyright 2009-2019 Vanilla Forums Inc.
 * @license GPL-2.0-only
 */

import { INavigationTreeItem } from "@library/@types/api/core";

export const STORY_SITE_NAV_ACTIVE_RECORD = {
    recordID: 79,
    recordType: "article",
};

export const STORY_SITE_NAV_ITEMS: INavigationTreeItem[] = [
    {
        name: "Organization",
        parentID: 13,
        sort: 0,
        recordID: 26,
        recordType: "knowledgeCategory",
        url: "#",
        children: [
            {
                sort: 0,
                name: "Overview",
                recordType: "article",
                parentID: 26,
                recordID: 79,
                url: "#",
                children: [],
            },
            {
                sort: 1,
                name: "Resources",
                recordType: "article",
                parentID: 26,
                recordID: 53,
                url: "#",
                children: [],
            },
            {
                sort: 2,
                name: "Open Source",
                recordType: "article",
                parentID: 26,
                recordID: 49,
                url: "#",
                children: [],
            },
            {
                sort: 3,
                name: "Hiring",
                recordType: "article",
                parentID: 26,
                recordID: 48,
                url: "#",
                children: [],
            },
            {
                sort: 4,
                recordType: "article",
                parentID: 26,
                recordID: 97,
                url: "#",
                name: "Test Article",
                children: [],
            },
            {
                sort: 5,
                name: "test",
                recordType: "article",
                parentID: 26,
                recordID: 126,
                url: "#",
                children: [],
            },
            {
                sort: 6,
                name: "Alt test",
                recordType: "article",
                parentID: 26,
                recordID: 127,
                url: "#",
                children: [],
            },
        ],
    },
    {
        name: "Technical Process",
        parentID: 13,
        sort: 1,
        recordID: 20,
        recordType: "knowledgeCategory",
        url: "#",
        children: [
            {
                sort: 0,
                name: "Data Safety",
                recordType: "article",
                parentID: 20,
                recordID: 112,
                url: "#",
                children: [],
            },
            {
                sort: 1,
                name: "Releases & Branches",
                recordType: "article",
                parentID: 20,
                recordID: 51,
                url: "#",
                children: [],
            },
            {
                sort: 2,
                name: "Access & Accounts",
                recordType: "article",
                parentID: 20,
                recordID: 45,
                url: "#",
                children: [],
            },
            {
                sort: 3,
                name: "Using GitHub Labels",
                recordType: "article",
                parentID: 20,
                recordID: 61,
                url: "#",
                children: [],
            },
            {
                sort: 4,
                name: "HackerOne",
                recordType: "article",
                parentID: 20,
                recordID: 55,
                url: "#",
                children: [],
            },
            {
                sort: 5,
                name: "Repo Automation",
                recordType: "article",
                parentID: 20,
                recordID: 77,
                url: "#",
                children: [],
            },
            {
                sort: 6,
                name: "Code Review & QA",
                recordType: "article",
                parentID: 20,
                recordID: 46,
                url: "#",
                children: [],
            },
            {
                sort: 7,
                name: "Security Patch Workflow",
                recordType: "article",
                parentID: 20,
                recordID: 71,
                url: "#",
                children: [],
            },
            {
                sort: 8,
                name: "Deploying Infrastructure",
                recordType: "article",
                parentID: 20,
                recordID: 47,
                url: "#",
                children: [],
            },
            {
                sort: 9,
                name: "WordPress Plugin",
                recordType: "article",
                parentID: 20,
                recordID: 108,
                url: "#",
                children: [],
            },
        ],
    },
    {
        name: "R&D",
        parentID: 13,
        sort: 2,
        recordID: 14,
        recordType: "knowledgeCategory",
        url: "#",
        children: [
            {
                sort: 0,
                name: "Overview",
                recordType: "article",
                parentID: 14,
                recordID: 60,
                url: "#",
                children: [],
            },
            {
                sort: 1,
                name: "Product Sprints",
                recordType: "article",
                parentID: 14,
                recordID: 50,
                url: "#",
                children: [],
            },
            {
                sort: 2,
                name: "QA Phase Process",
                recordType: "article",
                parentID: 14,
                recordID: 74,
                url: "#",
                children: [],
            },
        ],
    },
    {
        name: "Support",
        parentID: 13,
        sort: 3,
        recordID: 15,
        recordType: "knowledgeCategory",
        url: "#",
        children: [
            {
                sort: 0,
                name: "Support Sprints",
                recordType: "article",
                parentID: 15,
                recordID: 52,
                url: "#",
                children: [],
            },
        ],
    },
    {
        name: "Services",
        parentID: 13,
        sort: 4,
        recordID: 23,
        recordType: "knowledgeCategory",
        url: "#",
        children: [
            {
                name: "Theming",
                parentID: 23,
                sort: 0,
                recordID: 27,
                recordType: "knowledgeCategory",
                url: "#",
                children: [
                    {
                        sort: 0,
                        name: "Pages checklist",
                        recordType: "article",
                        parentID: 27,
                        recordID: 84,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 1,
                        name: "QA Checklist",
                        recordType: "article",
                        parentID: 27,
                        recordID: 85,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 2,
                        name: "Common Issues",
                        recordType: "article",
                        parentID: 27,
                        recordID: 86,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 3,
                        name: "Estimation",
                        recordType: "article",
                        parentID: 27,
                        recordID: 87,
                        url: "#",
                        children: [],
                    },
                ],
            },
            {
                name: "Migrations",
                parentID: 23,
                sort: 1,
                recordID: 28,
                recordType: "knowledgeCategory",
                url: "#",
                children: [
                    {
                        sort: 0,
                        name: "Data orientation",
                        recordType: "article",
                        parentID: 28,
                        recordID: 95,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 1,
                        name: "Data Exports",
                        recordType: "article",
                        parentID: 28,
                        recordID: 80,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 2,
                        name: "Sending Us Data",
                        recordType: "article",
                        parentID: 28,
                        recordID: 88,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 3,
                        name: "Test Migration Overview",
                        recordType: "article",
                        parentID: 28,
                        recordID: 89,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 4,
                        name: "Localhost Setup",
                        recordType: "article",
                        parentID: 28,
                        recordID: 91,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 5,
                        name: "Estimation: Lithium",
                        recordType: "article",
                        parentID: 28,
                        recordID: 94,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 6,
                        name: "Test Migration Checklist",
                        recordType: "article",
                        parentID: 28,
                        recordID: 90,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 7,
                        name: "Estimation",
                        recordType: "article",
                        parentID: 28,
                        recordID: 92,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 8,
                        name: "Estimate Templates",
                        recordType: "article",
                        parentID: 28,
                        recordID: 93,
                        url: "#",
                        children: [],
                    },
                ],
            },
            {
                name: "Single Sign On",
                parentID: 23,
                sort: 2,
                recordID: 29,
                recordType: "knowledgeCategory",
                url: "#",
                children: [
                    {
                        sort: 0,
                        name: "Overview",
                        recordType: "article",
                        parentID: 29,
                        recordID: 81,
                        url: "#",
                        children: [],
                    },
                    {
                        sort: 1,
                        name: "Estimate Templates",
                        recordType: "article",
                        parentID: 29,
                        recordID: 83,
                        url: "#",
                        children: [],
                    },
                ],
            },
            {
                name: "Customizations",
                parentID: 23,
                sort: 3,
                recordID: 30,
                recordType: "knowledgeCategory",
                url: "#",
                children: [
                    {
                        sort: 0,
                        name: "Integrations",
                        recordType: "article",
                        parentID: 30,
                        recordID: 82,
                        url: "#",
                        children: [],
                    },
                ],
            },
            {
                name: "Code Sharing",
                parentID: 23,
                sort: 4,
                recordID: 31,
                recordType: "knowledgeCategory",
                url: "#",
                children: [],
            },
        ],
    },
    {
        name: "Cookbook",
        parentID: 13,
        sort: 5,
        recordID: 21,
        recordType: "knowledgeCategory",
        url: "#",
        children: [
            {
                sort: 0,
                name: "Overview",
                recordType: "article",
                parentID: 21,
                recordID: 72,
                url: "#",
                children: [],
            },
            {
                sort: 1,
                name: "React Event Listeners",
                recordType: "article",
                parentID: 21,
                recordID: 73,
                url: "#",
                children: [],
            },
            {
                sort: 2,
                name: "Styling",
                recordType: "article",
                parentID: 21,
                recordID: 100,
                url: "#",
                children: [],
            },
            {
                sort: 3,
                name: "Theming",
                recordType: "article",
                parentID: 21,
                recordID: 101,
                url: "#",
                children: [],
            },
        ],
    },
];
