/**
 * @author Stéphane LaFlèche <stephane.l@vanillaforums.com>
 * @copyright 2009-2019 Vanilla Forums Inc.
 * @license GPL-2.0-only
 */

import React from "react";
import { ButtonTypes } from "@library/forms/buttonTypes";
import Button from "@library/forms/Button";
import { IOptionalComponentID } from "@library/utility/idUtils";
import classNames from "classnames";

interface IProps extends IOptionalComponentID {
    children: React.ReactNode;
    className?: string;
    disabled?: boolean;
    legacyMode?: boolean;
    buttonType?: ButtonTypes;

    tabIndex?: number;
}

export default class ButtonSubmit extends React.Component<IProps, IOptionalComponentID> {
    public static defaultProps = {
        disabled: false,
        legacyMode: false,
    };

    constructor(props) {
        super(props);
    }

    public render() {
        return (
            <Button
                id={this.props.id}
                disabled={this.props.disabled}
                submit={true}
                className={this.props.className}
                prefix="submitButton"
                legacyMode={this.props.legacyMode}
                buttonType={this.props.buttonType}
                tabIndex={this.props.tabIndex}
            >
                {this.props.children}
            </Button>
        );
    }
}
