/**
 * @copyright 2009-2020 Vanilla Forums Inc.
 * @license GPL-2.0-only
 */

import { extractJsonErrorFromCFHtmlString } from "@library/apiv2";
import { CoreErrorMessages } from "@library/errorPages/CoreErrorMessages";
import React from "react";

export default {
    title: "Alerts/Errors",
};

export function CloudflareParsedErrorMessage() {
    const error = extractJsonErrorFromCFHtmlString(CF_ERROR_HMTL);

    return <CoreErrorMessages error={error!} />;
}

const CF_ERROR_HMTL = `
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>Vanilla | Security Error</title>
        <meta name="author" content="Vanilla Forums" />
    </head>
    <body>
        <div class="page">
            <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 105 121">
                <title>Gears</title>
                <defs>
                    <ellipse id="path-1" cx="45" cy="47.0406504" rx="8" ry="8.04065041"></ellipse>
                    <ellipse id="path-2" cx="74" cy="71.0406504" rx="8" ry="8.04065041"></ellipse>
                </defs>
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g id="Artboard" transform="translate(-9.000000, -1.000000)">
                        <path
                            d="M58.993577,3.48327508 L13.006423,30.2422831 C11.899765,30.8862254 11,32.4471129 11,33.726727 L11,87.2808405 C11,88.5631293 11.8983062,90.1204933 13.006423,90.7652844 L58.993577,117.524292 C60.100235,118.168235 61.8983062,118.169084 63.006423,117.524292 L108.993577,90.7652844 C110.100235,90.1213421 111,88.5604546 111,87.2808405 L111,33.726727 C111,32.4444382 110.101694,30.8870742 108.993577,30.2422831 L63.006423,3.48327508 C61.899765,2.83933282 60.1016938,2.83848399 58.993577,3.48327508 Z M57.9877099,1.7546249 C59.7171968,0.748270941 62.2834474,0.748645806 64.0122901,1.7546249 L109.999444,28.5136329 C111.723343,29.5167355 113,31.7326591 113,33.726727 L113,87.2808405 C113,89.272511 111.721644,91.491821 109.999444,92.4939346 L64.0122901,119.252943 C62.2828032,120.259297 59.7165526,120.258922 57.9877099,119.252943 L12.0005559,92.4939346 C10.2766567,91.490832 9,89.2749084 9,87.2808405 L9,33.726727 C9,31.7350565 10.2783564,29.5157465 12.0005559,28.5136329 L57.9877099,1.7546249 Z"
                            fill="#ff3934"
                            fill-rule="nonzero"
                        ></path>
                        <path
                            d="M48.0229598,33.0586755 L47.3697609,32.9189272 L46.5272949,28.3464943 C46.4961887,28.1776673 46.2831359,28 46.1126524,28 L43.4591187,28 C43.2870479,28 43.0758511,28.176209 43.0444762,28.3464943 L42.1806257,33.0349904 L41.5633779,33.1948157 C40.1371341,33.5641162 38.7830968,34.156949 37.5453115,34.9486138 L36.985109,35.306909 L32.9732538,32.5347436 C32.8358584,32.4398043 32.5632807,32.4653042 32.4422085,32.5869916 L30.5658768,34.4728575 C30.4413037,34.5980636 30.4155221,34.877216 30.5135835,35.0205755 L33.3152413,39.1164211 L32.990564,39.6646603 C32.270202,40.8810392 31.7350147,42.2003788 31.405812,43.5838204 L31.2552724,44.2164483 L26.3423876,45.1308647 C26.1776682,45.1615233 26,45.3767479 26,45.5529418 L26,48.2199589 C26,48.39775 26.176216,48.6111071 26.3423876,48.642036 L31.2552778,49.5564534 L31.4058183,50.1890796 C31.7350235,51.5725206 32.2702134,52.8918593 32.9905777,54.1082368 L33.3152568,54.6564766 L30.5136023,58.7523174 C30.4163768,58.894455 30.442446,59.1759585 30.5658956,59.3000353 L32.4422273,61.1859012 C32.5644222,61.308717 32.8346601,61.3339296 32.9732726,61.2381492 L36.9851319,58.465981 L37.5453338,58.8242744 C38.7831207,59.615937 40.1371592,60.2087672 41.563404,60.5780649 L42.1806534,60.7378894 L43.0445028,65.4263796 C43.075609,65.5952067 43.2886618,65.7728739 43.4591453,65.7728739 L46.112679,65.7728739 C46.2847498,65.7728739 46.4959466,65.5966649 46.5273215,65.4263796 L47.3697883,60.8539422 L48.0229856,60.7141929 C49.5477582,60.387973 50.999556,59.8090966 52.3270595,59.004842 L52.8809311,58.6692844 L56.5985439,61.2381303 C56.7359393,61.3330696 57.008517,61.3075698 57.1295892,61.1858823 L59.0059209,59.3000164 C59.130494,59.1748104 59.1562756,58.895658 59.0582142,58.7522985 L56.5531261,55.0900189 L56.9104076,54.5324704 C57.7829242,53.1708819 58.4173497,51.6678504 58.7817048,50.0817322 L58.928543,49.4425131 L63.2294101,48.6420092 C63.3941295,48.6113506 63.5717977,48.396126 63.5717977,48.2199321 L63.5717977,45.552915 C63.5717977,45.3751239 63.3955817,45.1617668 63.2294101,45.1308379 L58.9285379,44.3303331 L58.7816988,43.6911156 C58.4173407,42.1049982 57.7829124,40.6019679 56.9103932,39.2403812 L56.55311,38.6828322 L59.0581954,35.0205566 C59.155421,34.8784189 59.1293517,34.5969155 59.0059021,34.4728386 L57.1295704,32.5869727 C57.0073755,32.4641569 56.7371377,32.4389443 56.5985251,32.5347247 L52.8809076,35.1035738 L52.3270365,34.768018 C50.9995317,33.9637661 49.547733,33.3848925 48.0229598,33.0586755 Z"
                            stroke="#ff3934"
                            stroke-width="2"
                        ></path>
                        <g stroke-linecap="round" stroke-linejoin="round">
                            <ellipse
                                stroke="#ff3934"
                                stroke-width="1.39534884"
                                cx="45"
                                cy="47.0406504"
                                rx="8.69767442"
                                ry="8.73832483"
                            ></ellipse>
                        </g>
                        <path
                            d="M77.0229598,57.0586755 L76.3697609,56.9189272 L75.5272949,52.3464943 C75.4961887,52.1776673 75.2831359,52 75.1126524,52 L72.4591187,52 C72.2870479,52 72.0758511,52.176209 72.0444762,52.3464943 L71.1806257,57.0349904 L70.5633779,57.1948157 C69.1371341,57.5641162 67.7830968,58.156949 66.5453115,58.9486138 L65.985109,59.306909 L61.9732538,56.5347436 C61.8358584,56.4398043 61.5632807,56.4653042 61.4422085,56.5869916 L59.5658768,58.4728575 C59.4413037,58.5980636 59.4155221,58.877216 59.5135835,59.0205755 L62.3152413,63.1164211 L61.990564,63.6646603 C61.270202,64.8810392 60.7350147,66.2003788 60.405812,67.5838204 L60.2552724,68.2164483 L55.3423876,69.1308647 C55.1776682,69.1615233 55,69.3767479 55,69.5529418 L55,72.2199589 C55,72.39775 55.176216,72.6111071 55.3423876,72.642036 L60.2552778,73.5564534 L60.4058183,74.1890796 C60.7350235,75.5725206 61.2702134,76.8918593 61.9905777,78.1082368 L62.3152568,78.6564766 L59.5136023,82.7523174 C59.4163768,82.894455 59.442446,83.1759585 59.5658956,83.3000353 L61.4422273,85.1859012 C61.5644222,85.308717 61.8346601,85.3339296 61.9732726,85.2381492 L65.9851319,82.465981 L66.5453338,82.8242744 C67.7831207,83.615937 69.1371592,84.2087672 70.563404,84.5780649 L71.1806534,84.7378894 L72.0445028,89.4263796 C72.075609,89.5952067 72.2886618,89.7728739 72.4591453,89.7728739 L75.112679,89.7728739 C75.2847498,89.7728739 75.4959466,89.5966649 75.5273215,89.4263796 L76.3697883,84.8539422 L77.0229856,84.7141929 C78.5477582,84.387973 79.999556,83.8090966 81.3270595,83.004842 L81.8809311,82.6692844 L85.5985439,85.2381303 C85.7359393,85.3330696 86.008517,85.3075698 86.1295892,85.1858823 L88.0059209,83.3000164 C88.130494,83.1748104 88.1562756,82.895658 88.0582142,82.7522985 L85.5531261,79.0900189 L85.9104076,78.5324704 C86.7829242,77.1708819 87.4173497,75.6678504 87.7817048,74.0817322 L87.928543,73.4425131 L92.2294101,72.6420092 C92.3941295,72.6113506 92.5717977,72.396126 92.5717977,72.2199321 L92.5717977,69.552915 C92.5717977,69.3751239 92.3955817,69.1617668 92.2294101,69.1308379 L87.9285379,68.3303331 L87.7816988,67.6911156 C87.4173407,66.1049982 86.7829124,64.6019679 85.9103932,63.2403812 L85.55311,62.6828322 L88.0581954,59.0205566 C88.155421,58.8784189 88.1293517,58.5969155 88.0059021,58.4728386 L86.1295704,56.5869727 C86.0073755,56.4641569 85.7371377,56.4389443 85.5985251,56.5347247 L81.8809076,59.1035738 L81.3270365,58.768018 C79.9995317,57.9637661 78.547733,57.3848925 77.0229598,57.0586755 Z"
                            stroke="#ff3934"
                            stroke-width="2"
                            transform="translate(73.785899, 70.886437) rotate(12.000000) translate(-73.785899, -70.886437) "
                        ></path>
                        <g stroke-linecap="round" stroke-linejoin="round">
                            <ellipse
                                stroke="#ff3934"
                                stroke-width="1.39534884"
                                cx="74"
                                cy="71.0406504"
                                rx="8.69767442"
                                ry="8.73832483"
                            ></ellipse>
                        </g>
                    </g>
                </g>
            </svg>
            <div class="cf-error-details cf-error-1020">
                <h1>Access denied</h1>
                <p>This website is using a security service to protect itself from online attacks.</p>
                <ul class="cferror_details">
                    <li>Ray ID: 59b168dceb19ca5b</li>
                    <li>Timestamp: 2020-05-29 15:57:10 UTC</li>
                    <li>Your IP address: 24.225.138.124</li>
                    <li class="XXX_no_wrap_overflow_hidden">
                        Requested URL:
                        community.f-secure.com/api/v2/articles?knowledgeCategoryID=98&amp;expand=excerpt&amp;locale=no&amp;includeSubcategories=true&amp;limit=10&amp;page=1
                    </li>
                    <li>Error reference number: 1020</li>
                    <li>Server ID: FL_70F24</li>
                    <li>
                        User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/537.36 (KHTML, like
                        Gecko) Chrome/81.0.4044.138 Safari/537.36
                    </li>
                </ul>
            </div>
            <div class="content">
                <h2 class="pageSubTitle">
                    What can I do to resolve this?
                </h2>
                <p class="p">
                    Please try again in a few minutes. If the problem persists, you can contact the site owner to let
                    them know you were unable to reach the website.
                </p>
                <footer class="footer">
                    <p class="footer-p">
                        Your IP: 24.225.138.124
                    </p>
                    <p class="footer-p">
                        Ray ID: 59b168dceb19ca5b
                    </p>
                    <p class="footer-p">
                        <a href="http://docs.vanillaforums.com/" class="link-help" target="_blank">
                            Help
                        </a>
                        Performance &amp; Security by
                        <a class="link-home" href="https://vanillaforums.com/" target="_blank">
                            Vanilla Forums Inc.
                        </a>
                    </p>
                </footer>
            </div>
        </div>
    </body>
</html>
`;
