<!DOCTYPE html>
<html lang="{$CurrentLocale.Key}">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    {asset name="Head"}
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,400i,600,700,700i" rel="stylesheet">
</head>

{assign
    "linkFormat"
    "<div class='Navigation-linkContainer'>
        <a href='%url' class='Navigation-link %class'>
            %text
        </a>
    </div>"
}
{capture name="menu"}
    {if $User.SignedIn}
        <div class="Navigation-row NewDiscussion">
            <div class="NewDiscussion mobile">
                {module name="NewDiscussionModule" reorder=$DataDrivenTitleBar}
            </div>
        </div>
    {else}
        {if !$DataDrivenTitleBar}
            <div class="Navigation-row">
                <div class="SignIn mobile">
                    {module name="MeModule"}
                </div>
            </div>
        {/if}
    {/if}

    {if !$DataDrivenTitleBar}
        {activity_link format=$linkFormat}
        {categories_link format=$linkFormat}
        {discussions_link format=$linkFormat}
        {knowledge_link format=$linkFormat}
        {custom_menu format=$linkFormat}


    {/if}
{/capture}

{capture name="navLinks"}
    {if !$DataDrivenTitleBar}
        {activity_link format=$linkFormat}
        {categories_link format=$linkFormat}
        {discussions_link format=$linkFormat}
        {custom_menu format=$linkFormat}

    {/if}
{/capture}
{assign var="SectionGroups" value=(isset($Groups) || isset($Group))}
{assign var="TemplateCss" value="
    {if $ThemeOptions.Options.hasHeroBanner}
        ThemeOptions-hasHeroBanner
    {/if}

    {if $ThemeOptions.Options.hasFeatureSearchbox}
        ThemeOptions-hasFeatureSearchbox
    {else}
        {if !inSection(["DiscussionList"])}
            hideHomepageTitle
        {/if}
    {/if}

    {if $ThemeOptions.Options.panelToLeft}
        ThemeOptions-panelToLeft
    {/if}

    {if $User.SignedIn}
        UserLoggedIn
    {else}
        UserLoggedOut
    {/if}

    {if inSection('Discussion') and $Page gt 1}
        isNotFirstPage
    {/if}

    {if inSection('Group') && !isset($Group.Icon)}
        noGroupIcon
    {/if}

    locale-{$CurrentLocale.Lang}
"}
<body id="{$BodyID}" class="{$BodyClass}{$TemplateCss|strip:" "}">
<a href="#MainContent" class="Button Primary btn button-skipToContent sr-only SrOnly">{t c="Skip to content"}</a>

    <!--[if lt IE 9]>
      <p class="browsehappy">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->

    <div class="Frame">
        {if $DataDrivenTitleBar}
            <header id="titleBar" data-react="title-bar-hamburger" style="display: none!important;" data-unhide="true">
                {$smarty.capture.menu}
            </header>
        {else}
            <div class="Frame-top">
                <div class="Frame-header">
                    <!---------- Main Header ---------->
                    <header id="MainHeader" class="Header">
                        <div class="Container">
                            <div class="row">
                                <div class="Hamburger">
                                    <button class="Hamburger Hamburger-menuXcross" id="menu-button" aria-label="toggle menu">
                                        <span class="Hamburger-menuLines" aria-hidden="true">
                                        </span>
                                        <span class="Hamburger-visuallyHidden sr-only">
                                            toggle menu
                                        </span>
                                    </button>
                                </div>
                                <a href="{home_link format="%url"}" class="Header-logo">
                                    {logo}
                                </a>
                                <a href="{home_link format="%url"}" class="Header-logo mobile">
                                    {mobile_logo}
                                </a>
                                <nav class="Header-desktopNav">
                                     {$smarty.capture.navLinks}
                                </nav>
                                <div class="Header-flexSpacer"></div>
                                <div class="Header-right">
                                    {community_chooser buttonType='titleBarLink' buttonClass='Header-desktopCommunityChooser'}
                                    <div class="MeBox-header">
                                        {module name="MeModule" CssClass="FlyoutRight"}
                                    </div>
                                    {if $User.SignedIn}
                                        <button class="mobileMeBox-button">
                                            <span class="Photo PhotoWrap">
                                                <img src="{$User.Photo|escape:'html'}" class="ProfilePhotoSmall" alt="{t c='Avatar'}">
                                            </span>
                                        </button>
                                    {/if}
                                </div>
                            </div>
                        </div>

                        <!---------- Mobile Navigation ---------->
                        <nav class="Navigation js-nav needsInitialization">
                            <div class="Container">
                                {if $User.SignedIn}
                                    <div class="Navigation-row NewDiscussion">
                                        <div class="NewDiscussion mobile">
                                            {module name="NewDiscussionModule"}
                                        </div>
                                    </div>
                                {else}
                                    <div class="Navigation-row">
                                        <div class="SignIn mobile">
                                            {module name="MeModule"}
                                        </div>
                                    </div>
                                {/if}
                               {$smarty.capture.navLinks}

                                <div class='Navigation-linkContainer'>
                                    {community_chooser buttonType='reset' fullWidth=true buttonClass='Navigation-link'}
                                </div>
                            </div>
                        </nav>
                        <nav class="mobileMebox js-mobileMebox needsInitialization">
                            <div class="Container">
                                {module name="MeModule"}
                                <button class="mobileMebox-buttonClose Close">
                                    <span>×</span>
                                </button>
                            </div>
                        </nav>
                        <!---------- Mobile Navigation END ---------->

                    </header>
                    <!---------- Main Header END ---------->

                </div>
            {/if}
            <div class="Frame-body">

                <!---------- Hero Banner ---------->
                {if $ThemeOptions.Options.hasHeroBanner && inSection(["CategoryList", "DiscussionList", "CategoryDiscussionList"])}
                    <div class="Herobanner">
                        {if {banner_image_url}}
                            <div class="Herobanner-bgImage" style="background-image:url('{banner_image_url}')"></div>
                        {/if}
                        <div class="Container">
                            {if $ThemeOptions.Options.hasFeatureSearchbox}
                                <div class="SearchBox js-sphinxAutoComplete" role="search">
                                    {if $hasAdvancedSearch === true}
                                        {module name="AdvancedSearchModule"}
                                    {else}
                                        {searchbox}
                                    {/if}
                                </div>
                            {else}
                                {if $Category}
                                    <h2 class="H HomepageTitle">{$Category.Name|strip_tags}{follow_button}</h2>
                                    {if $sanitizedDescription}
                                        <p class="P PageDescription">{$sanitizedDescription}</p>
                                    {/if}
                                {elseif $Subcommunity && inSection(["DiscussionList"])}
                                    <h2 class="H HomepageTitle">{$Subcommunity.Name|strip_tags}</h2>
                                {else}
                                    {if {homepage_title} !== ""}
                                        <h2 class="H HomepageTitle">{homepage_title}</h2>
                                    {/if}
                                {/if}
                            {/if}
                        </div>
                    </div>
                {/if}
                <!---------- Hero Banner END ---------->

                <div class="Frame-content">
                    <div class="Container">
                        <div class="Frame-contentWrap">
                            <div class="Frame-details">
                                {if !$isHomepage}
                                    <div class="Frame-row">
                                        <nav class="BreadcrumbsBox">
                                            {breadcrumbs}
                                        </nav>
                                    </div>
                                {/if}
                                {if !$DataDrivenTitleBar}
                                    <div class="Frame-row SearchBoxMobile">
                                        {if !$SectionGroups && !inSection(["SearchResults"])}
                                            <div class="SearchBox js-sphinxAutoComplete" role="search">
                                                {if $hasAdvancedSearch === true}
                                                    {module name="AdvancedSearchModule"}
                                                {else}
                                                    {searchbox}
                                                {/if}
                                            </div>
                                        {/if}
                                    </div>
                                {/if}
                                <div class="Frame-row">

                                    <!---------- Main Content ---------->
                                    <main id="MainContent" class="Content MainContent">
                                        <!---------- Profile Page Header ---------->
                                        {if inSection("Profile")}
                                            <div class="Profile-header">
                                                <div class="Profile-photo">
                                                    <div class="PhotoLarge">
                                                        {module name="UserPhotoModule"}
                                                    </div>
                                                </div>
                                                <div class="Profile-name">
                                                    <div class="Profile-row">
                                                        <h1 class="Profile-username">
                                                            {$Profile.Name|escape:'html'}
                                                        </h1>
                                                    </div>
                                                    <div class="Profile-row">
                                                        {if isset($Rank)}
                                                            <span class="Profile-rank">
                                                                {$Rank.Label}
                                                            </span>
                                                        {/if}
                                                    </div>
                                                </div>
                                            </div>
                                        {/if}
                                        <!---------- Profile Page Header END ---------->

                                        {asset name="Content"}
                                    </main>
                                    <!---------- Main Content END ---------->

                                    <!---------- Main Panel ---------->
                                    <aside class="Panel Panel-main">
                                        {if !$SectionGroups && !$DataDrivenTitleBar}
                                            <div class="SearchBox js-sphinxAutoComplete" role="search">
                                                {searchbox}
                                            </div>
                                        {/if}
                                        {asset name="Panel"}
                                    </aside>
                                    <!---------- Main Panel END ---------->

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="Frame-footer">

            <!---------- Main Footer END ---------->
            <footer class="Footer">
                <div class="Container">
                    <div class="row">
                        <div class="col col-copyRight">
                            <p class="Footer-copyright">{t c="© Vanilla Keystone Theme"} {$smarty.now|date_format:"%Y"}</p>
                        </div>
                        <div class="col col-logo">
                            <div class="Vanilla-logo">
                              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 124.418 27" class="PoweredbyVanilla">
                                <title>Powered By Vanilla</title>
                                <path fill="currentColor" d="M72.512,26.847q-.2-.444-.389-.89c-.332-.78-.64-1.57-.909-2.375-1.324-3.95-1.86-8.865,1.458-11.991a8.318,8.318,0,0,1,3.76-1.977c.338-.084,1.409-.206,1.563-.261.373-.135.214-1.117.152-1.4-.322-1.459-2.2-2-3.481-1.876A5.405,5.405,0,0,0,71.3,7.991a10.813,10.813,0,0,0-1.912,3.055c-1.811,4.282-.943,11.279.231,13.246A9.434,9.434,0,0,0,68.1,22.835c-.44-.423-.886-.839-1.314-1.273a12.964,12.964,0,0,1-2.337-3.047,11.854,11.854,0,0,1-1.482-5.32,5.9,5.9,0,0,1,.72-3.2,3.662,3.662,0,0,0-2.959,1.125A4.134,4.134,0,0,0,59.011,14.4a11.164,11.164,0,0,0,1.681,4.073,22.229,22.229,0,0,0,5.255,6.215,24.779,24.779,0,0,0,3.621,2.533c.857.494,1.981,1.079,2.964.6.091-.044.258-.107.285-.214s-.062-.255-.1-.352c-.062-.138-.139-.269-.2-.407M96.19,15.979c.453-.881,1.614-2.209,1.269-3.287a1.589,1.589,0,0,0-2.477-.712c-1.2,1-1.131,6.827-.7,7.683.226.955,1.764,1.651,2.431.717a.4.4,0,0,0-.067-.56.881.881,0,0,0-.385-.048c-.607-.036-.744-1.332-.724-1.782a5,5,0,0,1,.657-2.011m-5.082,4.509c-.2-1.613,1.441-3.939,1.387-5.807a2.67,2.67,0,0,0-1.11-2.383,1.591,1.591,0,0,0-.371-.139,3.6,3.6,0,0,0-1.2-.039,3.922,3.922,0,0,0-1.295.353,5.793,5.793,0,0,0-1.912,1.6c-.266.319-.518.649-.771.978.02-.026-.153-.3-.173-.333-.066-.115-.137-.227-.214-.335a3.655,3.655,0,0,0-.516-.594,2.134,2.134,0,0,0-1.272-.617,1.612,1.612,0,0,0-.767.151,1.219,1.219,0,0,0-.543.411,1.227,1.227,0,0,0,0,.932A19.1,19.1,0,0,0,83.5,17.223c.04.089.079.178.115.268a9.535,9.535,0,0,1,.925,2.9c.038.662-.361,1.6.185,1.685,1.776.215,1.281-2.876,1.664-4.5A3.591,3.591,0,0,1,88.731,14.9a.45.45,0,0,1,.353.006.465.465,0,0,1,.222.389,10.823,10.823,0,0,1-.431,2.506,17.753,17.753,0,0,0-.365,2.725c-.066,1.739.443,3.5,2.32,3.92a2.6,2.6,0,0,0,2.517-.428,1.679,1.679,0,0,0,.442-2.309c-1.242.073-2.5.224-2.681-1.218M108.057,2.315c3.281-.054-2.808,8.594-5.378,8.522,1.125-2.794,3.73-8.5,5.378-8.522M104.4,23.094a4.753,4.753,0,0,1-1.2-.407,3.334,3.334,0,0,1-.758-.607,4.618,4.618,0,0,1-.963-1.695,8.976,8.976,0,0,1-.417-2.805,14.169,14.169,0,0,1,.447-3.55,11.375,11.375,0,0,1,.5-1.548c.078-.191.245-.537.245-.537s.689-.027.941-.073c2.632-.482,4.965-2.7,6.255-4.983.885-1.565,1.814-4.11-.061-5.347C106.452-.4,103.782,3.36,102.622,5.3a26.123,26.123,0,0,0-1.663,3.388c-.206.5-.4,1-.6,1.5-.068.177-.3.739-.3.739s-.362-.061-.458-.085a5.054,5.054,0,0,1-.678-.219A2.378,2.378,0,0,1,97.4,9.249c2.448.834,3.576-3.361.924-3.84-1.556-.216-2.441,1.1-2.28,2.558a4.17,4.17,0,0,0,1.01,2.366,5.131,5.131,0,0,0,2.052,1.22c.166.059.5.166.5.166l.19.051s-.082.316-.105.395c-.138.485-.272.971-.4,1.46a24.062,24.062,0,0,0-.6,3.08,16.094,16.094,0,0,0-.068,3.025c.13,1.891.478,4.305,1.985,5.618a2.671,2.671,0,0,0,2.855.5c.736-.463.927-1.446,1.194-2.21a.426.426,0,0,0-.062-.462.5.5,0,0,0-.2-.086m11.391-17.1c.93.41-1.666,7.077-7.2,8.983,1.038-3.583,5.908-9.564,7.2-8.983m-3.867,18.346a4.773,4.773,0,0,1-.885-.433,5.036,5.036,0,0,1-1.375-1.256A7.628,7.628,0,0,1,108.326,19a15,15,0,0,1-.1-2.34c6.89-1.492,10.235-9.165,9.153-11.052-.982-1.715-2.946-1.194-4.686-.052a15.607,15.607,0,0,0-6.709,10.181,2.721,2.721,0,0,1-1.272.01c-.164-.036-.411-.177-.576-.121a.3.3,0,0,0-.157.409.734.734,0,0,0,.365.338,4.065,4.065,0,0,0,1.409.47c-.326,2.935.616,7.675,2.473,9.651a2.531,2.531,0,0,0,2.533.7c.835-.234,2.21-1.085,1.889-2.143a1.1,1.1,0,0,0-.721-.711m7.742-5.681a8.28,8.28,0,0,1-1.265,1.976,3.007,3.007,0,0,1-1.858,1.337,1.741,1.741,0,0,1-.479-.021,1.421,1.421,0,0,1-1.319-1.632,4.067,4.067,0,0,1,1.187-2.649c1.424-1.407,4.833-1.687,3.734.989m4.191-2.375c-1.04-.15-1.782.878-2.5,1.217.615-1.669-.768-2.745-1.109-3.09-4.765-3.191-11.5,5.251-8.137,8.523a4.423,4.423,0,0,0,5.363.187c.227,2.632,5.324,3.044,5.362.468-6.206,1.619,1.131-3.651,2.034-5.62a1.162,1.162,0,0,0-1.017-1.685M78.37,21.119a1.858,1.858,0,0,1-1.025.828c-1.91.655-2.768-1.523-2.761-2.972a3.3,3.3,0,0,1,.824-2.267,2.382,2.382,0,0,1,1.957-.629,1.32,1.32,0,0,1,.674.328,2.2,2.2,0,0,1,.587,1.354,9.3,9.3,0,0,1,.146,1.47,3.6,3.6,0,0,1-.4,1.888m4.425,1a2.67,2.67,0,0,1-1.02-.676,3.911,3.911,0,0,1-.6-1.421,10.478,10.478,0,0,1-.118-3.39c.041-.562.093-1.122.149-1.682.045-.456.093-.912.135-1.369a4.07,4.07,0,0,0,.04-.756l0-.023a1.148,1.148,0,0,0-1.875-.511,1.9,1.9,0,0,0-.677,1.133c-.056.225-.093.454-.132.683a3.479,3.479,0,0,1-.134.666c-.056.143-.1-.009-.141-.088a2.24,2.24,0,0,0-.176-.274,2.182,2.182,0,0,0-.431-.438,2.552,2.552,0,0,0-1.141-.48,3.836,3.836,0,0,0-1.038-.032,2.977,2.977,0,0,0-.555.117c-1.343.429-2.126,1.863-2.554,3.156a8.093,8.093,0,0,0-.374,1.887,9.2,9.2,0,0,0,.049,1.949,8.2,8.2,0,0,0,.447,1.821,5.715,5.715,0,0,0,.821,1.5,2.947,2.947,0,0,0,2.974,1.21,4.439,4.439,0,0,0,2.946-2.87c.051-.162.054-.536.259-.447.107.046.282.524.357.638a3.306,3.306,0,0,0,1.009,1.023c.643.393,2.74.741,2.543-.585-.067-.452-.4-.589-.763-.746" transform="translate(-0.582 -1)"></path>
                                <path fill="currentColor" d="M.582,22V16.273H2.438a6.734,6.734,0,0,1,1.374.086,1.5,1.5,0,0,1,.825.561,1.779,1.779,0,0,1,.332,1.115,1.865,1.865,0,0,1-.192.887,1.557,1.557,0,0,1-.486.564,1.666,1.666,0,0,1-.6.272,6.657,6.657,0,0,1-1.2.082H1.738V22Zm1.156-4.758v1.625h.633a2.98,2.98,0,0,0,.914-.09.753.753,0,0,0,.361-.281.765.765,0,0,0,.131-.445.742.742,0,0,0-.183-.516.807.807,0,0,0-.465-.254,5.563,5.563,0,0,0-.832-.039Zm3.946,1.93A3.654,3.654,0,0,1,5.945,17.7a2.7,2.7,0,0,1,.534-.785,2.226,2.226,0,0,1,.74-.516,3.144,3.144,0,0,1,1.234-.226,2.688,2.688,0,0,1,2.026.785,3.01,3.01,0,0,1,.759,2.184,3,3,0,0,1-.754,2.169,2.663,2.663,0,0,1-2.015.784,2.692,2.692,0,0,1-2.031-.78A2.954,2.954,0,0,1,5.684,19.172Zm1.191-.039a2.146,2.146,0,0,0,.449,1.474,1.545,1.545,0,0,0,2.276,0,2.191,2.191,0,0,0,.443-1.494,2.153,2.153,0,0,0-.432-1.469,1.462,1.462,0,0,0-1.146-.484,1.471,1.471,0,0,0-1.153.49A2.168,2.168,0,0,0,6.875,19.133ZM12.953,22l-1.367-5.727H12.77l.863,3.934,1.047-3.934h1.375l1,4,.879-4H19.1L17.711,22H16.484l-1.14-4.281L14.207,22Zm6.738,0V16.273h4.247v.969h-3.09v1.27h2.875v.965H20.848v1.558h3.2V22Zm5.34,0V16.273h2.434a4.16,4.16,0,0,1,1.334.155,1.32,1.32,0,0,1,.666.549,1.645,1.645,0,0,1,.25.9,1.525,1.525,0,0,1-.379,1.064,1.821,1.821,0,0,1-1.133.53,2.669,2.669,0,0,1,.619.48,6.5,6.5,0,0,1,.658.93L30.18,22H28.8l-.836-1.246a8.243,8.243,0,0,0-.609-.842A.894.894,0,0,0,27,19.674a1.9,1.9,0,0,0-.582-.065h-.234V22Zm1.157-3.3h.855a4.415,4.415,0,0,0,1.039-.07.625.625,0,0,0,.324-.242.748.748,0,0,0,.117-.43.687.687,0,0,0-.154-.467.709.709,0,0,0-.435-.224q-.141-.02-.844-.02h-.9ZM30.805,22V16.273h4.246v.969h-3.09v1.27h2.875v.965H31.961v1.558h3.2V22Zm5.332-5.727H38.25a4.117,4.117,0,0,1,1.09.11,1.916,1.916,0,0,1,.863.527,2.5,2.5,0,0,1,.547.928,4.224,4.224,0,0,1,.188,1.353,3.767,3.767,0,0,1-.176,1.219,2.53,2.53,0,0,1-.614,1.012,2.027,2.027,0,0,1-.812.457A3.488,3.488,0,0,1,38.312,22H36.137Zm1.156.969v3.793h.863a3.109,3.109,0,0,0,.7-.055,1.052,1.052,0,0,0,.467-.238,1.207,1.207,0,0,0,.3-.553,3.736,3.736,0,0,0,.117-1.048,3.429,3.429,0,0,0-.117-1.02,1.307,1.307,0,0,0-.328-.555,1.109,1.109,0,0,0-.535-.269,5.191,5.191,0,0,0-.95-.055Zm6.852-.969h2.289a6.557,6.557,0,0,1,1.013.057,1.5,1.5,0,0,1,.6.236,1.47,1.47,0,0,1,.439.479,1.287,1.287,0,0,1,.176.67,1.358,1.358,0,0,1-.8,1.242,1.508,1.508,0,0,1,.8.52,1.373,1.373,0,0,1,.281.863,1.7,1.7,0,0,1-.181.76,1.532,1.532,0,0,1-.5.589,1.632,1.632,0,0,1-.776.272q-.288.032-1.394.039H44.145Zm1.156.954v1.324h.758q.675,0,.839-.02a.763.763,0,0,0,.467-.2.6.6,0,0,0,.17-.447.633.633,0,0,0-.146-.432.67.67,0,0,0-.436-.2c-.114-.013-.444-.019-.988-.019Zm0,2.277v1.531h1.07A5.3,5.3,0,0,0,47.164,21a.711.711,0,0,0,.42-.229.7.7,0,0,0,.162-.486.746.746,0,0,0-.125-.437.707.707,0,0,0-.361-.262,3.922,3.922,0,0,0-1.026-.082ZM51.422,22V19.59l-2.1-3.317H50.68l1.347,2.266,1.321-2.266H54.68L52.574,19.6V22Z" transform="translate(-0.582 -1)"></path>
                              </svg>
                          </div>
                        </div>
                    </div>
                    {asset name="Foot"}
                </div>
            </footer>
            <!---------- Main Footer END ---------->

        </div>
    </div>
    <div id="modals"></div>
    {event name="AfterBody"}
</body>

</html>
