
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `vanilla2021009`
--

-- --------------------------------------------------------

--
-- Table structure for table `GDN_AccessToken`
--

CREATE TABLE `GDN_AccessToken` (
  `AccessTokenID` int(11) NOT NULL AUTO_INCREMENT,
  `Token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `UserID` int(11) NOT NULL,
  `Type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Scope` text COLLATE utf8mb4_unicode_ci,
  `DateInserted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `InsertUserID` int(11) DEFAULT NULL,
  `InsertIPAddress` varbinary(16) NOT NULL,
  `DateExpires` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`AccessTokenID`),
  UNIQUE KEY `UX_AccessToken` (`Token`),
  KEY `IX_AccessToken_UserID` (`UserID`),
  KEY `IX_AccessToken_Type` (`Type`),
  KEY `IX_AccessToken_DateExpires` (`DateExpires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Activity`
--

CREATE TABLE `GDN_Activity` (
  `ActivityID` int(11) NOT NULL AUTO_INCREMENT,
  `ActivityTypeID` int(11) NOT NULL,
  `NotifyUserID` int(11) NOT NULL DEFAULT '0',
  `ActivityUserID` int(11) DEFAULT NULL,
  `RegardingUserID` int(11) DEFAULT NULL,
  `Photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `HeadlineFormat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Story` text COLLATE utf8mb4_unicode_ci,
  `Format` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Route` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `RecordType` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `RecordID` int(11) DEFAULT NULL,
  `InsertUserID` int(11) DEFAULT NULL,
  `DateInserted` datetime NOT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `Notified` tinyint(4) NOT NULL DEFAULT '0',
  `Emailed` tinyint(4) NOT NULL DEFAULT '0',
  `Data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ActivityID`),
  KEY `IX_Activity_Notify` (`NotifyUserID`,`Notified`),
  KEY `IX_Activity_Recent` (`NotifyUserID`,`DateUpdated`),
  KEY `IX_Activity_Feed` (`NotifyUserID`,`ActivityUserID`,`DateUpdated`),
  KEY `IX_Activity_DateUpdated` (`DateUpdated`),
  KEY `FK_Activity_InsertUserID` (`InsertUserID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `GDN_Activity`
--

INSERT INTO `GDN_Activity` VALUES
(1, 18, -1, 6, NULL, NULL, '{ActivityUserID,You} joined.', 'Welcome Aboard!', NULL, NULL, NULL, NULL, NULL, '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', 0, 0, '{"ActivityUserIDs":[5,4,3,2]}'),
(2, 16, -1, 2, 1, NULL, '{RegardingUserID,you} &rarr; {ActivityUserID,you}', 'Ping! An activity post is a public way to talk at someone. When you update your status here, it posts it on your activity feed.', 'Html', NULL, NULL, NULL, 1, '[[regtime]]', NULL, '[[regtime]]', 0, 0, NULL),
(3, 18, -2, 2, 3, NULL, '{ActivityUserID,user} added an account for {RegardingUserID,user}.', NULL, NULL, NULL, NULL, NULL, 2, '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', 0, 0, '[]'),
(4, 18, -2, 2, 4, NULL, '{ActivityUserID,user} added an account for {RegardingUserID,user}.', NULL, NULL, NULL, NULL, NULL, 2, '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', 0, 0, '[]'),
(5, 18, -2, 2, 5, NULL, '{ActivityUserID,user} added an account for {RegardingUserID,user}.', NULL, NULL, NULL, NULL, NULL, 2, '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', 0, 0, '[]'),
(6, 18, -2, 2, 6, NULL, '{ActivityUserID,user} added an account for {RegardingUserID,user}.', NULL, NULL, NULL, NULL, NULL, 2, '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', 0, 0, '[]');

-- --------------------------------------------------------

--
-- Table structure for table `GDN_ActivityComment`
--

CREATE TABLE `GDN_ActivityComment` (
  `ActivityCommentID` int(11) NOT NULL AUTO_INCREMENT,
  `ActivityID` int(11) NOT NULL,
  `Body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `Format` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `InsertUserID` int(11) NOT NULL,
  `DateInserted` datetime NOT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  PRIMARY KEY (`ActivityCommentID`),
  KEY `FK_ActivityComment_ActivityID` (`ActivityID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_ActivityType`
--

CREATE TABLE `GDN_ActivityType` (
  `ActivityTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `AllowComments` tinyint(4) NOT NULL DEFAULT '0',
  `ShowIcon` tinyint(4) NOT NULL DEFAULT '0',
  `ProfileHeadline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `FullHeadline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `RouteCode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Notify` tinyint(4) NOT NULL DEFAULT '0',
  `Public` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ActivityTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=31 ;

--
-- Dumping data for table `GDN_ActivityType`
--

INSERT INTO `GDN_ActivityType` VALUES
(1, 'SignIn', 0, 0, '%1$s signed in.', '%1$s signed in.', NULL, 0, 1),
(2, 'Join', 1, 0, '%1$s joined.', '%1$s joined.', NULL, 0, 1),
(3, 'JoinInvite', 1, 0, '%1$s accepted %4$s invitation for membership.', '%1$s accepted %4$s invitation for membership.', NULL, 0, 1),
(4, 'JoinApproved', 1, 0, '%1$s approved %4$s membership application.', '%1$s approved %4$s membership application.', NULL, 0, 1),
(5, 'JoinCreated', 1, 0, '%1$s created an account for %3$s.', '%1$s created an account for %3$s.', NULL, 0, 1),
(6, 'AboutUpdate', 1, 0, '%1$s updated %6$s profile.', '%1$s updated %6$s profile.', NULL, 0, 1),
(7, 'WallComment', 1, 1, '%1$s wrote:', '%1$s wrote on %4$s %5$s.', NULL, 0, 1),
(8, 'PictureChange', 1, 0, '%1$s changed %6$s profile picture.', '%1$s changed %6$s profile picture.', NULL, 0, 1),
(9, 'RoleChange', 1, 0, '%1$s changed %4$s permissions.', '%1$s changed %4$s permissions.', NULL, 1, 1),
(10, 'ActivityComment', 0, 1, '%1$s', '%1$s commented on %4$s %8$s.', 'activity', 1, 1),
(11, 'Import', 0, 0, '%1$s imported data.', '%1$s imported data.', NULL, 1, 0),
(12, 'Banned', 0, 0, '%1$s banned %3$s.', '%1$s banned %3$s.', NULL, 0, 1),
(13, 'Unbanned', 0, 0, '%1$s un-banned %3$s.', '%1$s un-banned %3$s.', NULL, 0, 1),
(14, 'Applicant', 0, 0, '%1$s applied for membership.', '%1$s applied for membership.', NULL, 1, 0),
(15, 'roleRequest', 0, 0, NULL, NULL, NULL, 1, 0),
(16, 'WallPost', 1, 1, '%3$s wrote:', '%3$s wrote on %2$s %5$s.', NULL, 0, 1),
(17, 'Default', 0, 0, NULL, NULL, NULL, 0, 1),
(18, 'Registration', 0, 0, NULL, NULL, NULL, 0, 1),
(19, 'Status', 0, 0, NULL, NULL, NULL, 0, 1),
(20, 'Ban', 0, 0, NULL, NULL, NULL, 0, 1),
(21, 'ConversationMessage', 0, 0, '%1$s sent you a %8$s.', '%1$s sent you a %8$s.', 'message', 1, 0),
(22, 'AddedToConversation', 0, 0, '%1$s added %3$s to a %8$s.', '%1$s added %3$s to a %8$s.', 'conversation', 1, 0),
(23, 'NewDiscussion', 0, 0, '%1$s started a %8$s.', '%1$s started a %8$s.', 'discussion', 0, 0),
(24, 'NewComment', 0, 0, '%1$s commented on a discussion.', '%1$s commented on a discussion.', 'discussion', 0, 0),
(25, 'DiscussionComment', 0, 0, '%1$s commented on %4$s %8$s.', '%1$s commented on %4$s %8$s.', 'discussion', 1, 0),
(26, 'DiscussionMention', 0, 0, '%1$s mentioned %3$s in a %8$s.', '%1$s mentioned %3$s in a %8$s.', 'discussion', 1, 0),
(27, 'CommentMention', 0, 0, '%1$s mentioned %3$s in a %8$s.', '%1$s mentioned %3$s in a %8$s.', 'comment', 1, 0),
(28, 'BookmarkComment', 0, 0, '%1$s commented on your %8$s.', '%1$s commented on your %8$s.', 'bookmarked discussion', 1, 0),
(29, 'Discussion', 0, 0, NULL, NULL, NULL, 0, 1),
(30, 'Comment', 0, 0, NULL, NULL, NULL, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `GDN_AnalyticsLocal`
--

CREATE TABLE `GDN_AnalyticsLocal` (
  `TimeSlot` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Views` int(11) DEFAULT NULL,
  `EmbedViews` int(11) DEFAULT NULL,
  UNIQUE KEY `UX_AnalyticsLocal` (`TimeSlot`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `GDN_AnalyticsLocal`
--


-- --------------------------------------------------------

--
-- Table structure for table `GDN_Attachment`
--

CREATE TABLE `GDN_Attachment` (
  `AttachmentID` int(11) NOT NULL AUTO_INCREMENT,
  `Type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ForeignID` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ForeignUserID` int(11) NOT NULL,
  `Source` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `SourceID` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `SourceURL` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Attributes` text COLLATE utf8mb4_unicode_ci,
  `DateInserted` datetime NOT NULL,
  `InsertUserID` int(11) NOT NULL,
  `InsertIPAddress` varbinary(16) NOT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `UpdateUserID` int(11) DEFAULT NULL,
  `UpdateIPAddress` varbinary(16) DEFAULT NULL,
  PRIMARY KEY (`AttachmentID`),
  KEY `IX_Attachment_ForeignID` (`ForeignID`),
  KEY `FK_Attachment_ForeignUserID` (`ForeignUserID`),
  KEY `FK_Attachment_InsertUserID` (`InsertUserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Ban`
--

CREATE TABLE `GDN_Ban` (
  `BanID` int(11) NOT NULL AUTO_INCREMENT,
  `BanType` enum('IPAddress','Name','Email') COLLATE utf8mb4_unicode_ci NOT NULL,
  `BanValue` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Notes` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `CountUsers` int(10) unsigned NOT NULL DEFAULT '0',
  `CountBlockedRegistrations` int(10) unsigned NOT NULL DEFAULT '0',
  `InsertUserID` int(11) NOT NULL,
  `DateInserted` datetime NOT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  `UpdateUserID` int(11) DEFAULT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `UpdateIPAddress` varbinary(16) DEFAULT NULL,
  PRIMARY KEY (`BanID`),
  UNIQUE KEY `UX_Ban` (`BanType`,`BanValue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Category`
--

CREATE TABLE `GDN_Category` (
  `CategoryID` int(11) NOT NULL AUTO_INCREMENT,
  `ParentCategoryID` int(11) DEFAULT NULL,
  `TreeLeft` int(11) DEFAULT NULL,
  `TreeRight` int(11) DEFAULT NULL,
  `Depth` int(11) NOT NULL DEFAULT '0',
  `CountCategories` int(11) NOT NULL DEFAULT '0',
  `CountDiscussions` int(11) NOT NULL DEFAULT '0',
  `CountAllDiscussions` int(11) NOT NULL DEFAULT '0',
  `CountComments` int(11) NOT NULL DEFAULT '0',
  `CountAllComments` int(11) NOT NULL DEFAULT '0',
  `LastCategoryID` int(11) NOT NULL DEFAULT '0',
  `DateMarkedRead` datetime DEFAULT NULL,
  `AllowDiscussions` tinyint(4) NOT NULL DEFAULT '1',
  `Archived` tinyint(4) NOT NULL DEFAULT '0',
  `CanDelete` tinyint(4) NOT NULL DEFAULT '1',
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `UrlCode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Description` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Sort` int(11) DEFAULT NULL,
  `CssClass` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `BannerImage` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PermissionCategoryID` int(11) NOT NULL DEFAULT '-1',
  `PointsCategoryID` int(11) NOT NULL DEFAULT '0',
  `HideAllDiscussions` tinyint(4) NOT NULL DEFAULT '0',
  `DisplayAs` enum('Categories','Discussions','Flat','Heading','Default') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Discussions',
  `InsertUserID` int(11) NOT NULL,
  `UpdateUserID` int(11) DEFAULT NULL,
  `DateInserted` datetime NOT NULL,
  `DateUpdated` datetime NOT NULL,
  `LastCommentID` int(11) DEFAULT NULL,
  `LastDiscussionID` int(11) DEFAULT NULL,
  `LastDateInserted` datetime DEFAULT NULL,
  `AllowedDiscussionTypes` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `DefaultDiscussionType` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Featured` tinyint(4) NOT NULL DEFAULT '0',
  `SortFeatured` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`CategoryID`),
  KEY `FK_Category_ParentCategoryID` (`ParentCategoryID`),
  KEY `FK_Category_InsertUserID` (`InsertUserID`),
  KEY `IX_Category_SortFeatured` (`SortFeatured`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `GDN_Category`
--

INSERT INTO `GDN_Category` VALUES
(-1, NULL, 1, 4, 0, 0, 0, 0, 0, 0, 0, NULL, 1, 0, 1, 'Root', 'root', 'Root of category tree. Users should never see this.', NULL, NULL, NULL, NULL, -1, 0, 0, 'Categories', 1, 1, '[[regtime]]', '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 0, 0),
(1, -1, 2, 3, 1, 0, 4, 4, 0, 0, 1, NULL, 1, 0, 1, 'General', 'general', 'General discussions', NULL, NULL, NULL, NULL, -1, 0, 0, 'Discussions', 1, 1, '[[regtime]]', '[[regtime]]', NULL, 3, '[[regtime]]', NULL, NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Comment`
--

CREATE TABLE `GDN_Comment` (
  `CommentID` int(11) NOT NULL AUTO_INCREMENT,
  `InsertUserID` int(11) DEFAULT NULL,
  `DiscussionID` int(11) NOT NULL,
  `UpdateUserID` int(11) DEFAULT NULL,
  `DeleteUserID` int(11) DEFAULT NULL,
  `Body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `Format` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `DateInserted` datetime DEFAULT NULL,
  `DateDeleted` datetime DEFAULT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  `UpdateIPAddress` varbinary(16) DEFAULT NULL,
  `Flag` tinyint(4) NOT NULL DEFAULT '0',
  `Score` float DEFAULT NULL,
  `Attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`CommentID`),
  KEY `IX_Comment_InsertUserID_DiscussionID` (`InsertUserID`,`DiscussionID`),
  KEY `IX_Comment_1` (`DiscussionID`,`DateInserted`),
  KEY `IX_Comment_DateInserted` (`DateInserted`),
  KEY `IX_Comment_Score` (`Score`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `GDN_Comment`
--

INSERT INTO `GDN_Comment` VALUES
(1, 5, 2, NULL, NULL, 'Thanks for these @"Karen A. Thomas", I''ll make sure everyone follows the rules!\n', 'Markdown', '[[regtime]]', NULL, NULL, '[[enc_clientip]]', NULL, 0, NULL, '{"StubLocale":"en","StubContentID":"comment-678cf390bc9d6d99","StubContentTag":"sample-rules-thanks"}'),
(2, 6, 3, NULL, NULL, 'Wow, I didn''t know about some of these, thanks!\n', 'Markdown', '[[regtime]]', NULL, NULL, '[[enc_clientip]]', NULL, 0, NULL, '{"StubLocale":"en","StubContentID":"comment-8a3393b2d8fe4c38","StubContentTag":"tips-and-tricks-thanks"}'),
(3, 4, 4, NULL, NULL, 'Great stuff @"Victorine Courtois", thank you for posting these helpful tips!', 'Markdown', '[[regtime]]', NULL, NULL, '[[enc_clientip]]', NULL, 0, NULL, '{"StubLocale":"en","StubContentID":"comment-69627fd8612f1db4","StubContentTag":"great-discussion-thanks"}');

-- --------------------------------------------------------

--
-- Table structure for table `GDN_contentDraft`
--

CREATE TABLE `GDN_contentDraft` (
  `draftID` int(11) NOT NULL AUTO_INCREMENT,
  `recordType` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recordID` int(11) DEFAULT NULL,
  `parentRecordID` int(11) DEFAULT NULL,
  `attributes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `insertUserID` int(11) NOT NULL,
  `dateInserted` datetime NOT NULL,
  `updateUserID` int(11) NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`draftID`),
  KEY `IX_contentDraft_recordType` (`recordType`),
  KEY `IX_contentDraft_insertUserID` (`insertUserID`),
  KEY `IX_contentDraft_record` (`recordType`,`recordID`),
  KEY `IX_contentDraft_parentRecord` (`recordType`,`parentRecordID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Conversation`
--

CREATE TABLE `GDN_Conversation` (
  `ConversationID` int(11) NOT NULL AUTO_INCREMENT,
  `Type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ForeignID` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Contributors` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `FirstMessageID` int(11) DEFAULT NULL,
  `InsertUserID` int(11) NOT NULL,
  `DateInserted` datetime DEFAULT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  `UpdateUserID` int(11) NOT NULL,
  `DateUpdated` datetime NOT NULL,
  `UpdateIPAddress` varbinary(16) DEFAULT NULL,
  `CountMessages` int(11) NOT NULL DEFAULT '0',
  `CountParticipants` int(11) NOT NULL DEFAULT '0',
  `LastMessageID` int(11) DEFAULT NULL,
  `RegardingID` int(11) DEFAULT NULL,
  PRIMARY KEY (`ConversationID`),
  KEY `IX_Conversation_Type` (`Type`),
  KEY `IX_Conversation_RegardingID` (`RegardingID`),
  KEY `FK_Conversation_FirstMessageID` (`FirstMessageID`),
  KEY `FK_Conversation_InsertUserID` (`InsertUserID`),
  KEY `FK_Conversation_DateInserted` (`DateInserted`),
  KEY `FK_Conversation_UpdateUserID` (`UpdateUserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_ConversationMessage`
--

CREATE TABLE `GDN_ConversationMessage` (
  `MessageID` int(11) NOT NULL AUTO_INCREMENT,
  `ConversationID` int(11) NOT NULL,
  `Body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `Format` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `InsertUserID` int(11) DEFAULT NULL,
  `DateInserted` datetime NOT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  PRIMARY KEY (`MessageID`),
  KEY `FK_ConversationMessage_ConversationID` (`ConversationID`),
  KEY `FK_ConversationMessage_InsertUserID` (`InsertUserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_dirtyRecord`
--

CREATE TABLE `GDN_dirtyRecord` (
  `recordType` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recordID` int(11) NOT NULL,
  `dateInserted` datetime NOT NULL,
  PRIMARY KEY (`recordType`,`recordID`),
  KEY `IX_dirtyRecord_recordType` (`recordType`,`dateInserted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `GDN_dirtyRecord`
--

INSERT INTO `GDN_dirtyRecord` VALUES
('category', 1, '[[regtime]]'),
('discussion', 2, '[[regtime]]'),
('discussion', 3, '[[regtime]]'),
('discussion', 4, '[[regtime]]'),
('user', 3, '[[regtime]]'),
('user', 4, '[[regtime]]'),
('user', 5, '[[regtime]]'),
('user', 2, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Discussion`
--

CREATE TABLE `GDN_Discussion` (
  `DiscussionID` int(11) NOT NULL AUTO_INCREMENT,
  `Type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ForeignID` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `CategoryID` int(11) NOT NULL,
  `InsertUserID` int(11) NOT NULL,
  `UpdateUserID` int(11) DEFAULT NULL,
  `FirstCommentID` int(11) DEFAULT NULL,
  `LastCommentID` int(11) DEFAULT NULL,
  `Name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `Format` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Tags` text COLLATE utf8mb4_unicode_ci,
  `CountComments` int(11) NOT NULL DEFAULT '0',
  `CountBookmarks` int(11) DEFAULT NULL,
  `CountViews` int(11) NOT NULL DEFAULT '1',
  `Closed` tinyint(4) NOT NULL DEFAULT '0',
  `Announce` tinyint(4) NOT NULL DEFAULT '0',
  `Sink` tinyint(4) NOT NULL DEFAULT '0',
  `DateInserted` datetime NOT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  `UpdateIPAddress` varbinary(16) DEFAULT NULL,
  `DateLastComment` datetime DEFAULT NULL,
  `LastCommentUserID` int(11) DEFAULT NULL,
  `Score` float DEFAULT NULL,
  `Attributes` text COLLATE utf8mb4_unicode_ci,
  `RegardingID` int(11) DEFAULT NULL,
  `hot` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`DiscussionID`),
  KEY `IX_Discussion_Type` (`Type`),
  KEY `IX_Discussion_ForeignID` (`ForeignID`),
  KEY `IX_Discussion_Announce` (`Announce`),
  KEY `IX_Discussion_DateInserted` (`DateInserted`),
  KEY `IX_Discussion_DateLastComment` (`DateLastComment`),
  KEY `IX_Discussion_Score` (`Score`),
  KEY `IX_Discussion_RegardingID` (`RegardingID`),
  KEY `IX_Discussion_hot` (`hot`),
  KEY `IX_Discussion_CategoryPages` (`CategoryID`,`DateLastComment`),
  KEY `IX_Discussion_CategoryInserted` (`CategoryID`,`DateInserted`),
  KEY `FK_Discussion_InsertUserID` (`InsertUserID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `GDN_Discussion`
--

INSERT INTO `GDN_Discussion` VALUES
(1, 'stub', 'discussion-1ca7c5ae8359e4ea', 1, 3, NULL, NULL, NULL, 'Welcome to awesome!', 'There''s nothing sweeter than a fresh new forum, ready to welcome your community. A Vanilla Forum has all the bits and pieces you need to build an awesome discussion platform customized to your needs. \n\n**Here are a few tips for you as the administrator:**\n\n* Use the [Getting Started](/dashboard/settings/gettingstarted) checklist in the Dashboard to get your site ready for visitors.\n* Don''t create too many categories. We recommend 3-8 to start with, keep it simple for your users!\n* **Announce** a discussion (click the gear) to stick to the top of the list, and **Close** it to stop further comments. This is useful for posting the rules, or welcoming new members.\n* Use **Sink** to take attention away from a discussion that might be getting out of hand. New comments will no longer bring it back to the top of the list.\n* **Bookmark** a discussion (click the star) to get notifications for new comments. You can edit notification settings from your [profile](/profile).\n\nWe''ve created a few sample discussions to help get you started. They contain some useful "Day 1" information and also show you how things might look once your forum has a bit of real activity. Feel free to keep, edit, or delete them as you see fit!\n\n*Now spread the word to get this place cooking. Cheers!*\n', 'Markdown', NULL, 0, NULL, 1, 0, 1, 0, '[[regtime]]', NULL, '[[enc_clientip]]', NULL, '[[regtime]]', NULL, NULL, '{"StubLocale":"en","StubContentID":"discussion-1ca7c5ae8359e4ea","StubContentTag":"welcome-to-vanilla"}', NULL, 0),
(2, 'stub', 'discussion-9bb6ff1a410526d7', 1, 4, NULL, 1, 1, 'Please Read Before Posting', '*This is an example of a ''rules'' discussion, laying out expected behaviour for new users who join the community. Customize it to suit your specific needs, or write your own rules completely from scratch!*  \n\nThis community has been created so that you can exchange ideas, converse and meet others who share a common interest.  \n\n**Here are some guidelines:**  \n\n* Keep your posts relevant to the forum category.\n* Please be respectful of others and don’t sweat the small stuff.\n* Please do not post any personal information or photos that you wouldn’t want to be seen by the public.\n* Do not post hateful or illegal content. Do not post copyrighted material without proper attribution.\n* SPAM will not be tolerated.\n* Use private messages to chat with moderators or other members in private.\n\nIn summary: be polite, enjoy yourself, and help us build a great community.\n', 'Markdown', NULL, 1, NULL, 1, 0, 0, 0, '[[regtime]]', NULL, '[[enc_clientip]]', NULL, '[[regtime]]', 5, NULL, '{"StubLocale":"en","StubContentID":"discussion-9bb6ff1a410526d7","StubContentTag":"sample-rules"}', NULL, 1),
(3, 'stub', 'discussion-fdbc6842dace5238', 1, 4, NULL, 2, 2, 'Getting the most out of this forum', 'Here are some tips and tricks for using this forum:  \n\n* **Use the reactions**. These let you share how you feel about other’s comments. The most liked content shows up on the [Best Of](/bestof) page.\n* **Mention others.** Put an @ symbol before the username to mention someone. They’ll get notified when you do.\n* **Update your notification preferences.** You’ll receive a notification if someone mentions you or posts to a discussion that you’ve bookmarked. You can set notifications from the Edit Profile page.\n* **Send messages.** You can private message members by going to your inbox, or visiting their profile page (click their username anywhere).\n* **Don’t want to see everyone’s signature?** You can hide signatures by going to Edit Profile > Signature Settings.\n* **Check out the forum from your mobile phone.** Just go to the forum URL in your browser - no need to download an app.\n* **Want to embed a YouTube video, a Pinterest Pin or a Tweet?** Just paste in the link. Vanilla will handle the embedding for you!\n* Check out what’s going on with other community members on the [Activity](/activity) page.\n\nHave fun!\n', 'Markdown', NULL, 1, NULL, 1, 0, 0, 0, '[[regtime]]', NULL, '[[enc_clientip]]', NULL, '[[regtime]]', 6, NULL, '{"StubLocale":"en","StubContentID":"discussion-fdbc6842dace5238","StubContentTag":"tips-and-tricks"}', NULL, 1),
(4, 'stub', 'discussion-255efb523e6177ca', 1, 5, NULL, 3, 3, 'How to start a great discussion', 'Thank you for starting new discussions and asking questions. The more you contribute, the better this forum becomes.  \n\nHere are a few tips to help you create great discussions:  \n\n* **Make the discussion title or question as descriptive as possible.** A good discussion title is a short preview of your post and is what gets people to click and read. A well written title is also going to help search engines better index your post which will bring more people into the discussion. For example, instead of ‘Won’t Connect’, try ‘Help, I’m having problems getting my Acme modem into bridge mode.’\n* **Proof read.** Spelling mistakes, typos, and bad grammar will distract readers from the point you’re trying to make. Vanilla automatically saves drafts as you type. If you’re writing a long post, save it as a draft and come back to it after a few minutes or as long as it takes your brain to forget what you had written.\n* **Use minimal formatting.** Overly formatted posts can also distract from the message and it encourages others to do likewise and you end up with a hard to read thread.\n* **Put your post in the right category.** The right category can be the one that has a relevant category name or it can be a category where this kind of post is often made.\n* **Use tags.** Tags are helpful for others to find keyword related posts. It also helps the site admins get a sense for what topics are popular.\n* **If you want responses, ask for them.** In marketing this is called a ‘call to action’. If you want others to comment, you can encourage them by asking them to do so. If your post is just an FYI then don’t.\n* **Go easy on the insider jargon.** Inside jokes and inside references can be fun and make the community unique but too much of it can turn off new members.\n* **Add an image.** Images add visual interest and make your post look great when shared to social networks. You can embed an image using the button bar or you can upload one from your desktop or phone.\n* **Mention others.** Credit other members if you are building off their previous comments or if you want to draw them into the discussion. Put the @ before a username to mention someone.\n* **Take ownership.** Most important of all, take ownership of the discussions that you have created. Respond to comments promptly and thoughtfully. Thank others for commenting on your discussion and help with moderation if things get heated.\n\nThanks for posting! Have fun!', 'Markdown', NULL, 1, NULL, 1, 0, 0, 0, '[[regtime]]', NULL, '[[enc_clientip]]', NULL, '[[regtime]]', 4, NULL, '{"StubLocale":"en","StubContentID":"discussion-255efb523e6177ca","StubContentTag":"starting-a-great-discussion"}', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Draft`
--

CREATE TABLE `GDN_Draft` (
  `DraftID` int(11) NOT NULL AUTO_INCREMENT,
  `DiscussionID` int(11) DEFAULT NULL,
  `CategoryID` int(11) DEFAULT NULL,
  `InsertUserID` int(11) NOT NULL,
  `UpdateUserID` int(11) NOT NULL,
  `Name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Tags` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Closed` tinyint(4) NOT NULL DEFAULT '0',
  `Announce` tinyint(4) NOT NULL DEFAULT '0',
  `Sink` tinyint(4) NOT NULL DEFAULT '0',
  `Body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `Format` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `DateInserted` datetime NOT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  PRIMARY KEY (`DraftID`),
  KEY `FK_Draft_DiscussionID` (`DiscussionID`),
  KEY `FK_Draft_CategoryID` (`CategoryID`),
  KEY `FK_Draft_InsertUserID` (`InsertUserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Invitation`
--

CREATE TABLE `GDN_Invitation` (
  `InvitationID` int(11) NOT NULL AUTO_INCREMENT,
  `Email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `RoleIDs` text COLLATE utf8mb4_unicode_ci,
  `Code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `InsertUserID` int(11) DEFAULT NULL,
  `DateInserted` datetime NOT NULL,
  `AcceptedUserID` int(11) DEFAULT NULL,
  `DateAccepted` datetime DEFAULT NULL,
  `DateExpires` datetime DEFAULT NULL,
  PRIMARY KEY (`InvitationID`),
  UNIQUE KEY `UX_Invitation` (`Code`),
  KEY `IX_Invitation_Email` (`Email`),
  KEY `IX_Invitation_userdate` (`InsertUserID`,`DateInserted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Log`
--

CREATE TABLE `GDN_Log` (
  `LogID` int(11) NOT NULL AUTO_INCREMENT,
  `Operation` enum('Delete','Edit','Spam','Moderate','Pending','Ban','Error') COLLATE utf8mb4_unicode_ci NOT NULL,
  `RecordType` enum('Discussion','Comment','User','Registration','Activity','ActivityComment','Configuration','Group','Event') COLLATE utf8mb4_unicode_ci NOT NULL,
  `TransactionLogID` int(11) DEFAULT NULL,
  `RecordID` int(11) DEFAULT NULL,
  `RecordUserID` int(11) DEFAULT NULL,
  `RecordDate` datetime NOT NULL,
  `RecordIPAddress` varbinary(16) DEFAULT NULL,
  `InsertUserID` int(11) NOT NULL,
  `DateInserted` datetime NOT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  `OtherUserIDs` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `ParentRecordID` int(11) DEFAULT NULL,
  `CategoryID` int(11) DEFAULT NULL,
  `Data` mediumtext COLLATE utf8mb4_unicode_ci,
  `CountGroup` int(11) DEFAULT NULL,
  PRIMARY KEY (`LogID`),
  KEY `IX_Log_Operation` (`Operation`),
  KEY `IX_Log_RecordType` (`RecordType`),
  KEY `IX_Log_RecordID` (`RecordID`),
  KEY `IX_Log_RecordUserID` (`RecordUserID`),
  KEY `IX_Log_RecordIPAddress` (`RecordIPAddress`),
  KEY `IX_Log_DateInserted` (`DateInserted`),
  KEY `IX_Log_ParentRecordID` (`ParentRecordID`),
  KEY `FK_Log_CategoryID` (`CategoryID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `GDN_Log`
--


-- --------------------------------------------------------

--
-- Table structure for table `GDN_Media`
--

CREATE TABLE `GDN_Media` (
  `MediaID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Size` int(11) NOT NULL,
  `Active` tinyint(4) NOT NULL DEFAULT '1',
  `InsertUserID` int(11) NOT NULL,
  `DateInserted` datetime NOT NULL,
  `ForeignID` int(11) DEFAULT NULL,
  `ForeignTable` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ImageWidth` smallint(5) unsigned DEFAULT NULL,
  `ImageHeight` smallint(5) unsigned DEFAULT NULL,
  `ThumbWidth` smallint(5) unsigned DEFAULT NULL,
  `ThumbHeight` smallint(5) unsigned DEFAULT NULL,
  `ThumbPath` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `foreignUrl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`MediaID`),
  UNIQUE KEY `UX_Media` (`foreignUrl`),
  KEY `IX_Media_InsertUserID` (`InsertUserID`),
  KEY `IX_Media_Foreign` (`ForeignID`,`ForeignTable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Message`
--

CREATE TABLE `GDN_Message` (
  `MessageID` int(11) NOT NULL AUTO_INCREMENT,
  `Content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `Format` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AllowDismiss` tinyint(4) NOT NULL DEFAULT '1',
  `Enabled` tinyint(4) NOT NULL DEFAULT '1',
  `Application` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Controller` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `CategoryID` int(11) DEFAULT NULL,
  `IncludeSubcategories` tinyint(4) NOT NULL DEFAULT '0',
  `AssetTarget` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `CssClass` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`MessageID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Permission`
--

CREATE TABLE `GDN_Permission` (
  `PermissionID` int(11) NOT NULL AUTO_INCREMENT,
  `RoleID` int(11) NOT NULL DEFAULT '0',
  `JunctionTable` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `JunctionColumn` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `JunctionID` int(11) DEFAULT NULL,
  `Garden.Email.View` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Settings.Manage` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Settings.View` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.SignIn.Allow` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Users.Add` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Users.Edit` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Users.Delete` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Users.Approve` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Activity.Delete` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Activity.View` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Profiles.View` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Profiles.Edit` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Curation.Manage` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Moderation.Manage` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.PersonalInfo.View` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.AdvancedNotifications.Allow` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Community.Manage` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Tokens.Add` tinyint(4) NOT NULL DEFAULT '0',
  `Garden.Uploads.Add` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Tagging.Add` tinyint(4) NOT NULL DEFAULT '0',
  `Conversations.Moderation.Manage` tinyint(4) NOT NULL DEFAULT '0',
  `Conversations.Conversations.Add` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Approval.Require` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Comments.Me` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Discussions.CloseOwn` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Discussions.View` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Discussions.Add` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Discussions.Edit` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Discussions.Announce` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Discussions.Sink` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Discussions.Close` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Discussions.Delete` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Comments.Add` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Comments.Edit` tinyint(4) NOT NULL DEFAULT '0',
  `Vanilla.Comments.Delete` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`PermissionID`),
  KEY `FK_Permission_RoleID` (`RoleID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `GDN_Permission`
--

INSERT INTO `GDN_Permission` VALUES
(1, 0, NULL, NULL, NULL, 3, 2, 2, 3, 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 3, 3, 2, 3, 2, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(2, 0, 'Category', 'PermissionCategoryID', NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 2, 2, 2, 2, 2, 3, 2, 2),
(3, 2, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(4, 2, 'Category', 'PermissionCategoryID', -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(5, 3, NULL, NULL, NULL, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(6, 3, 'Category', 'PermissionCategoryID', -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(7, 4, NULL, NULL, NULL, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(8, 4, 'Category', 'PermissionCategoryID', -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(9, 8, NULL, NULL, NULL, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0),
(10, 8, 'Category', 'PermissionCategoryID', -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0),
(11, 32, NULL, NULL, NULL, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(12, 32, 'Category', 'PermissionCategoryID', -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(13, 16, NULL, NULL, NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(14, 16, 'Category', 'PermissionCategoryID', -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `GDN_reaction`
--

CREATE TABLE `GDN_reaction` (
  `reactionID` int(11) NOT NULL AUTO_INCREMENT,
  `reactionOwnerID` int(11) NOT NULL,
  `recordID` int(11) NOT NULL,
  `reactionValue` int(11) NOT NULL,
  `insertUserID` int(11) NOT NULL,
  `dateInserted` datetime NOT NULL,
  `foreignID` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`reactionID`),
  KEY `IX_reaction_reactionOwnerID` (`reactionOwnerID`),
  KEY `IX_reaction_insertUserID` (`insertUserID`),
  KEY `IX_reaction_foreignID` (`foreignID`),
  KEY `IX_reaction_record` (`reactionOwnerID`,`recordID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_reactionOwner`
--

CREATE TABLE `GDN_reactionOwner` (
  `reactionOwnerID` int(11) NOT NULL AUTO_INCREMENT,
  `ownerType` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reactionType` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recordType` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `insertUserID` int(11) NOT NULL,
  `dateInserted` datetime NOT NULL,
  PRIMARY KEY (`reactionOwnerID`),
  UNIQUE KEY `UX_reactionOwner` (`ownerType`,`reactionType`,`recordType`),
  KEY `IX_reactionOwner_ownerType` (`ownerType`),
  KEY `IX_reactionOwner_reactionType` (`reactionType`),
  KEY `IX_reactionOwner_recordType` (`recordType`),
  KEY `IX_reactionOwner_insertUserID` (`insertUserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Regarding`
--

CREATE TABLE `GDN_Regarding` (
  `RegardingID` int(11) NOT NULL AUTO_INCREMENT,
  `Type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `InsertUserID` int(11) NOT NULL,
  `DateInserted` datetime NOT NULL,
  `ForeignType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ForeignID` int(11) NOT NULL,
  `OriginalContent` text COLLATE utf8mb4_unicode_ci,
  `ParentType` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ParentID` int(11) DEFAULT NULL,
  `ForeignURL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `Reports` int(11) DEFAULT NULL,
  PRIMARY KEY (`RegardingID`),
  KEY `FK_Regarding_Type` (`Type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_remoteResource`
--

CREATE TABLE `GDN_remoteResource` (
  `remoteResourceID` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` mediumtext COLLATE utf8mb4_unicode_ci,
  `lastError` text COLLATE utf8mb4_unicode_ci,
  `dateInserted` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`remoteResourceID`),
  UNIQUE KEY `UX_remoteResource` (`url`),
  KEY `IX_remoteResource_url` (`url`),
  KEY `IX_remoteResource_dateUpdated` (`dateUpdated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Role`
--

CREATE TABLE `GDN_Role` (
  `RoleID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Description` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Type` enum('guest','unconfirmed','applicant','member','moderator','administrator') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Sync` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Sort` int(11) DEFAULT NULL,
  `Deletable` tinyint(4) NOT NULL DEFAULT '1',
  `CanSession` tinyint(4) NOT NULL DEFAULT '1',
  `PersonalInfo` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`RoleID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=33 ;

--
-- Dumping data for table `GDN_Role`
--

INSERT INTO `GDN_Role` VALUES
(2, 'Guest', 'Guests can only view content. Anyone browsing the site who is not signed in is considered to be a "Guest".', 'guest', '', 1, 0, 0, 0),
(3, 'Unconfirmed', 'Users must confirm their emails before becoming full members. They get assigned to this role.', 'unconfirmed', '', 2, 0, 1, 0),
(4, 'Applicant', 'Users who have applied for membership, but have not yet been accepted. They have the same permissions as guests.', 'applicant', '', 3, 0, 1, 0),
(8, 'Member', 'Members can participate in discussions.', 'member', '', 4, 1, 1, 0),
(16, 'Administrator', 'Administrators have permission to do anything.', 'administrator', '', 6, 1, 1, 0),
(32, 'Moderator', 'Moderators have permission to edit most content.', 'moderator', '', 5, 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `GDN_roleRequest`
--

CREATE TABLE `GDN_roleRequest` (
  `roleRequestID` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('application','invitation') COLLATE utf8mb4_unicode_ci NOT NULL,
  `roleID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `status` enum('pending','approved','denied') COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateOfStatus` datetime NOT NULL,
  `statusUserID` int(11) NOT NULL,
  `statusIPAddress` varbinary(16) DEFAULT NULL,
  `dateExpires` datetime DEFAULT NULL,
  `attributes` json DEFAULT NULL,
  `dateInserted` datetime NOT NULL,
  `insertUserID` int(11) NOT NULL,
  `insertIPAddress` varbinary(16) DEFAULT NULL,
  `dateUpdated` datetime DEFAULT NULL,
  `updateUserID` int(11) DEFAULT NULL,
  `updateIPAddress` varbinary(16) DEFAULT NULL,
  PRIMARY KEY (`roleRequestID`),
  UNIQUE KEY `UX_roleRequest` (`roleID`,`userID`),
  KEY `FK_roleRequest_userID` (`userID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_roleRequestMeta`
--

CREATE TABLE `GDN_roleRequestMeta` (
  `roleID` int(11) NOT NULL,
  `type` enum('application','invitation') COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attributesSchema` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attributes` json DEFAULT NULL,
  `dateInserted` datetime NOT NULL,
  `insertUserID` int(11) NOT NULL,
  `insertIPAddress` varbinary(16) DEFAULT NULL,
  `dateUpdated` datetime DEFAULT NULL,
  `updateUserID` int(11) DEFAULT NULL,
  `updateIPAddress` varbinary(16) DEFAULT NULL,
  PRIMARY KEY (`roleID`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Session`
--

CREATE TABLE `GDN_Session` (
  `SessionID` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `UserID` int(11) NOT NULL DEFAULT '0',
  `DateInserted` datetime NOT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `DateExpires` datetime DEFAULT NULL,
  `Attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`SessionID`),
  KEY `IX_Session_DateExpires` (`DateExpires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Spammer`
--

CREATE TABLE `GDN_Spammer` (
  `UserID` int(11) NOT NULL,
  `CountSpam` smallint(5) unsigned NOT NULL DEFAULT '0',
  `CountDeletedSpam` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_Tag`
--

CREATE TABLE `GDN_Tag` (
  `TagID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `FullName` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ParentTagID` int(11) DEFAULT NULL,
  `InsertUserID` int(11) DEFAULT NULL,
  `DateInserted` datetime NOT NULL,
  `CategoryID` int(11) NOT NULL DEFAULT '-1',
  `CountDiscussions` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`TagID`),
  UNIQUE KEY `UX_Tag` (`Name`,`CategoryID`),
  KEY `IX_Tag_FullName` (`FullName`),
  KEY `IX_Tag_Type` (`Type`),
  KEY `FK_Tag_ParentTagID` (`ParentTagID`),
  KEY `FK_Tag_InsertUserID` (`InsertUserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_TagDiscussion`
--

CREATE TABLE `GDN_TagDiscussion` (
  `TagID` int(11) NOT NULL,
  `DiscussionID` int(11) NOT NULL,
  `CategoryID` int(11) NOT NULL,
  `DateInserted` datetime DEFAULT NULL,
  PRIMARY KEY (`TagID`,`DiscussionID`),
  KEY `IX_TagDiscussion_CategoryID` (`CategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_User`
--

CREATE TABLE `GDN_User` (
  `UserID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Password` varbinary(100) NOT NULL,
  `HashMethod` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Title` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Location` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `About` text COLLATE utf8mb4_unicode_ci,
  `Email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ShowEmail` tinyint(4) NOT NULL DEFAULT '0',
  `Gender` enum('u','m','f') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u',
  `CountVisits` int(11) NOT NULL DEFAULT '0',
  `CountInvitations` int(11) NOT NULL DEFAULT '0',
  `CountNotifications` int(11) DEFAULT NULL,
  `InviteUserID` int(11) DEFAULT NULL,
  `DiscoveryText` text COLLATE utf8mb4_unicode_ci,
  `Preferences` text COLLATE utf8mb4_unicode_ci,
  `Permissions` text COLLATE utf8mb4_unicode_ci,
  `Attributes` text COLLATE utf8mb4_unicode_ci,
  `DateSetInvitations` datetime DEFAULT NULL,
  `DateOfBirth` datetime DEFAULT NULL,
  `DateFirstVisit` datetime DEFAULT NULL,
  `DateLastActive` datetime DEFAULT NULL,
  `LastIPAddress` varbinary(16) DEFAULT NULL,
  `DateInserted` datetime NOT NULL,
  `InsertIPAddress` varbinary(16) DEFAULT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `UpdateIPAddress` varbinary(16) DEFAULT NULL,
  `HourOffset` int(11) NOT NULL DEFAULT '0',
  `Score` float DEFAULT NULL,
  `Admin` tinyint(4) NOT NULL DEFAULT '0',
  `Confirmed` tinyint(4) NOT NULL DEFAULT '1',
  `Verified` tinyint(4) NOT NULL DEFAULT '0',
  `Banned` tinyint(4) NOT NULL DEFAULT '0',
  `Deleted` tinyint(4) NOT NULL DEFAULT '0',
  `Points` int(11) NOT NULL DEFAULT '0',
  `CountUnreadConversations` int(11) DEFAULT NULL,
  `CountDiscussions` int(11) DEFAULT NULL,
  `CountUnreadDiscussions` int(11) DEFAULT NULL,
  `CountComments` int(11) DEFAULT NULL,
  `CountDrafts` int(11) DEFAULT NULL,
  `CountBookmarks` int(11) DEFAULT NULL,
  PRIMARY KEY (`UserID`),
  KEY `FK_User_Name` (`Name`),
  KEY `IX_User_Email` (`Email`),
  KEY `IX_User_DateLastActive` (`DateLastActive`),
  KEY `IX_User_DateInserted` (`DateInserted`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `GDN_User`
--

INSERT INTO `GDN_User` VALUES
(1, 'System', 'FGT3670UILMSIL3JIDVH', 'Random', '[[softurl]]/applications/dashboard/design/images/usericon.png', NULL, NULL, NULL, 'system@stub.vanillacommunity.example', 0, 'u', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime]]', NULL, NULL, NULL, 0, NULL, 2, 1, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL),
(2, '[[admin_username]]', '[[admin_pass]]', 'Vanilla', NULL, NULL, NULL, NULL, '[[admin_email]]', 0, 'u', 0, 0, NULL, NULL, NULL, NULL, '["Garden.Email.View","Garden.Settings.Manage","Garden.Settings.View","Garden.SignIn.Allow","Garden.Users.Add","Garden.Users.Edit","Garden.Users.Delete","Garden.Users.Approve","Garden.Activity.Delete","Garden.Activity.View","Garden.Profiles.View","Garden.Profiles.Edit","Garden.Curation.Manage","Garden.Moderation.Manage","Garden.PersonalInfo.View","Garden.AdvancedNotifications.Allow","Garden.Community.Manage","Garden.Uploads.Add","Conversations.Conversations.Add","Vanilla.Discussions.View","Vanilla.Discussions.Add","Vanilla.Discussions.Edit","Vanilla.Discussions.Announce","Vanilla.Discussions.Sink","Vanilla.Discussions.Close","Vanilla.Discussions.Delete","Vanilla.Comments.Add","Vanilla.Comments.Edit","Vanilla.Comments.Delete"]', '{"TimeZone":"Asia/Kolkata"}', NULL, '1975-09-16 00:00:00', '[[regtime]]', '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', NULL, 5, NULL, 1, 1, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'Vanilla Forums', 'UITOPZ9QZYE8QURSC7JN994H', 'Random', 'https://images.v-cdn.net/stubcontent/vanilla_avatar.jpg', NULL, NULL, NULL, 'vanilla@stub.vanillacommunity.example', 0, 'u', 0, 0, NULL, NULL, NULL, NULL, '', '{"StubLocale":"en","StubContentID":"user-a7aa242289be0507","StubContentTag":"vanilla-user"}', NULL, NULL, '[[regtime]]', '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', '[[enc_clientip]]', NULL, NULL, 0, NULL, 0, 1, 1, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL),
(4, 'Karen A. Thomas', 'E3OXN44AKAWY3DY7OPSLL0BU', 'Random', 'https://images.v-cdn.net/stubcontent/avatar_01.png', NULL, NULL, NULL, 'karen@stub.vanillacommunity.example', 0, 'u', 0, 0, NULL, NULL, NULL, NULL, '', '{"StubLocale":"en","StubContentID":"user-24c9e15e52afc47c","StubContentTag":"user1"}', NULL, NULL, '[[regtime]]', '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', '[[enc_clientip]]', NULL, NULL, 0, NULL, 0, 1, 1, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL),
(5, 'Victorine Courtois', 'W4DV9TZSUIXCM6VEH1XHPDRI', 'Random', 'https://images.v-cdn.net/stubcontent/avatar_02.png', NULL, NULL, NULL, 'victorine@stub.vanillacommunity.example', 0, 'u', 0, 0, NULL, NULL, NULL, NULL, '', '{"StubLocale":"en","StubContentID":"user-7e58d63b60197ceb","StubContentTag":"user2"}', NULL, NULL, '[[regtime]]', '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', '[[enc_clientip]]', NULL, NULL, 0, NULL, 0, 1, 1, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'Alex Powell', 'F7MYGG5AIN98W7DZ5H3MV2O6', 'Random', 'https://images.v-cdn.net/stubcontent/avatar_03.png', NULL, NULL, NULL, 'alex@stub.vanillacommunity.example', 0, 'u', 0, 0, NULL, NULL, NULL, NULL, '', '{"StubLocale":"en","StubContentID":"user-92877af70a45fd6a","StubContentTag":"user3"}', NULL, NULL, '[[regtime]]', '[[regtime]]', '[[enc_clientip]]', '[[regtime]]', '[[enc_clientip]]', NULL, NULL, 0, NULL, 0, 1, 1, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `GDN_userAttributes`
--

CREATE TABLE `GDN_userAttributes` (
  `userID` int(11) NOT NULL,
  `key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attributes` json DEFAULT NULL,
  PRIMARY KEY (`userID`,`key`),
  KEY `IX_userAttributes_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserAuthentication`
--

CREATE TABLE `GDN_UserAuthentication` (
  `ForeignUserKey` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ProviderKey` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `UserID` int(11) NOT NULL,
  PRIMARY KEY (`ForeignUserKey`,`ProviderKey`),
  KEY `FK_UserAuthentication_UserID` (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserAuthenticationNonce`
--

CREATE TABLE `GDN_UserAuthenticationNonce` (
  `Nonce` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Token` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`Nonce`),
  KEY `IX_UserAuthenticationNonce_Timestamp` (`Timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserAuthenticationProvider`
--

CREATE TABLE `GDN_UserAuthenticationProvider` (
  `UserAuthenticationProviderID` int(11) NOT NULL AUTO_INCREMENT,
  `AuthenticationKey` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `AuthenticationSchemeAlias` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `URL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AssociationSecret` text COLLATE utf8mb4_unicode_ci,
  `AssociationHashMethod` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AuthenticateUrl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `RegisterUrl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `SignInUrl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `SignOutUrl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `PasswordUrl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ProfileUrl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Attributes` text COLLATE utf8mb4_unicode_ci,
  `Active` tinyint(4) NOT NULL DEFAULT '1',
  `IsDefault` tinyint(4) NOT NULL DEFAULT '0',
  `Visible` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`UserAuthenticationProviderID`),
  UNIQUE KEY `UX_UserAuthenticationProvider` (`AuthenticationKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserAuthenticationToken`
--

CREATE TABLE `GDN_UserAuthenticationToken` (
  `Token` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ProviderKey` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ForeignUserKey` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TokenSecret` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `TokenType` enum('request','access') COLLATE utf8mb4_unicode_ci NOT NULL,
  `Authorized` tinyint(4) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Lifetime` int(11) NOT NULL,
  PRIMARY KEY (`Token`,`ProviderKey`),
  KEY `IX_UserAuthenticationToken_Timestamp` (`Timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserCategory`
--

CREATE TABLE `GDN_UserCategory` (
  `UserID` int(11) NOT NULL,
  `CategoryID` int(11) NOT NULL,
  `DateMarkedRead` datetime DEFAULT NULL,
  `Followed` tinyint(4) NOT NULL DEFAULT '0',
  `Unfollow` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`UserID`,`CategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserComment`
--

CREATE TABLE `GDN_UserComment` (
  `UserID` int(11) NOT NULL,
  `CommentID` int(11) NOT NULL,
  `Score` float DEFAULT NULL,
  `DateLastViewed` datetime DEFAULT NULL,
  PRIMARY KEY (`UserID`,`CommentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserConversation`
--

CREATE TABLE `GDN_UserConversation` (
  `UserID` int(11) NOT NULL,
  `ConversationID` int(11) NOT NULL,
  `CountReadMessages` int(11) NOT NULL DEFAULT '0',
  `LastMessageID` int(11) DEFAULT NULL,
  `DateLastViewed` datetime DEFAULT NULL,
  `DateCleared` datetime DEFAULT NULL,
  `Bookmarked` tinyint(4) NOT NULL DEFAULT '0',
  `Deleted` tinyint(4) NOT NULL DEFAULT '0',
  `DateConversationUpdated` datetime DEFAULT NULL,
  PRIMARY KEY (`UserID`,`ConversationID`),
  KEY `IX_UserConversation_Inbox` (`UserID`,`Deleted`,`DateConversationUpdated`),
  KEY `FK_UserConversation_ConversationID` (`ConversationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserDiscussion`
--

CREATE TABLE `GDN_UserDiscussion` (
  `UserID` int(11) NOT NULL,
  `DiscussionID` int(11) NOT NULL,
  `Score` float DEFAULT NULL,
  `CountComments` int(11) NOT NULL DEFAULT '0',
  `DateLastViewed` datetime DEFAULT NULL,
  `Dismissed` tinyint(4) NOT NULL DEFAULT '0',
  `Bookmarked` tinyint(4) NOT NULL DEFAULT '0',
  `Participated` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`UserID`,`DiscussionID`),
  KEY `IX_UserDiscussion_UserID_Bookmarked` (`UserID`,`Bookmarked`),
  KEY `FK_UserDiscussion_DiscussionID` (`DiscussionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `GDN_UserDiscussion`
--

INSERT INTO `GDN_UserDiscussion` VALUES
(3, 1, NULL, 0, '[[regtime]]', 0, 0, 1),
(4, 2, NULL, 0, '[[regtime]]', 0, 0, 1),
(4, 3, NULL, 0, '[[regtime]]', 0, 0, 1),
(5, 4, NULL, 0, '[[regtime]]', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserIP`
--

CREATE TABLE `GDN_UserIP` (
  `UserID` int(11) NOT NULL,
  `IPAddress` varbinary(16) NOT NULL,
  `DateInserted` datetime NOT NULL,
  `DateUpdated` datetime NOT NULL,
  PRIMARY KEY (`UserID`,`IPAddress`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserMerge`
--

CREATE TABLE `GDN_UserMerge` (
  `MergeID` int(11) NOT NULL AUTO_INCREMENT,
  `OldUserID` int(11) NOT NULL,
  `NewUserID` int(11) NOT NULL,
  `DateInserted` datetime NOT NULL,
  `InsertUserID` int(11) NOT NULL,
  `DateUpdated` datetime DEFAULT NULL,
  `UpdateUserID` int(11) DEFAULT NULL,
  `Attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`MergeID`),
  KEY `FK_UserMerge_OldUserID` (`OldUserID`),
  KEY `FK_UserMerge_NewUserID` (`NewUserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserMergeItem`
--

CREATE TABLE `GDN_UserMergeItem` (
  `MergeID` int(11) NOT NULL,
  `Table` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Column` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `RecordID` int(11) NOT NULL,
  `OldUserID` int(11) NOT NULL,
  `NewUserID` int(11) NOT NULL,
  KEY `FK_UserMergeItem_MergeID` (`MergeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserMeta`
--

CREATE TABLE `GDN_UserMeta` (
  `UserID` int(11) NOT NULL,
  `Name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`UserID`,`Name`),
  KEY `IX_UserMeta_Name` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `GDN_UserMeta`
--

INSERT INTO `GDN_UserMeta` VALUES
(0, 'stubcontent.record.comment-678cf390bc9d6d99', '{"contentID":"comment-678cf390bc9d6d99","rowID":"1","type":"comment"}'),
(0, 'stubcontent.record.comment-69627fd8612f1db4', '{"contentID":"comment-69627fd8612f1db4","rowID":"3","type":"comment"}'),
(0, 'stubcontent.record.comment-8a3393b2d8fe4c38', '{"contentID":"comment-8a3393b2d8fe4c38","rowID":"2","type":"comment"}'),
(0, 'stubcontent.record.discussion-1ca7c5ae8359e4ea', '{"contentID":"discussion-1ca7c5ae8359e4ea","rowID":"1","type":"discussion"}'),
(0, 'stubcontent.record.discussion-255efb523e6177ca', '{"contentID":"discussion-255efb523e6177ca","rowID":"4","type":"discussion"}'),
(0, 'stubcontent.record.discussion-9bb6ff1a410526d7', '{"contentID":"discussion-9bb6ff1a410526d7","rowID":"2","type":"discussion"}'),
(0, 'stubcontent.record.discussion-fdbc6842dace5238', '{"contentID":"discussion-fdbc6842dace5238","rowID":"3","type":"discussion"}'),
(0, 'stubcontent.record.locale', 'en'),
(0, 'stubcontent.record.user-24c9e15e52afc47c', '{"contentID":"user-24c9e15e52afc47c","rowID":"4","type":"user"}'),
(0, 'stubcontent.record.user-7e58d63b60197ceb', '{"contentID":"user-7e58d63b60197ceb","rowID":"5","type":"user"}'),
(0, 'stubcontent.record.user-92877af70a45fd6a', '{"contentID":"user-92877af70a45fd6a","rowID":"6","type":"user"}'),
(0, 'stubcontent.record.user-a7aa242289be0507', '{"contentID":"user-a7aa242289be0507","rowID":"3","type":"user"}');

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserPoints`
--

CREATE TABLE `GDN_UserPoints` (
  `SlotType` enum('d','w','m','y','a') COLLATE utf8mb4_unicode_ci NOT NULL,
  `TimeSlot` datetime NOT NULL,
  `Source` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Total',
  `CategoryID` int(11) NOT NULL DEFAULT '0',
  `UserID` int(11) NOT NULL,
  `Points` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`SlotType`,`TimeSlot`,`Source`,`CategoryID`,`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GDN_UserRole`
--

CREATE TABLE `GDN_UserRole` (
  `UserID` int(11) NOT NULL,
  `RoleID` int(11) NOT NULL,
  PRIMARY KEY (`UserID`,`RoleID`),
  KEY `IX_UserRole_RoleID` (`RoleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `GDN_UserRole`
--

INSERT INTO `GDN_UserRole` VALUES
(6, 8),
(1, 16),
(2, 16),
(3, 16),
(4, 16),
(5, 32);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
