/**
 * A filtered down version of the emoij data we use.
 *
 * This is significantly filtered. The original data sources are in the `emojibase-data` node module.
 * - `emojibase-data/en/data.json`
 * Transformation applied: data.map(({emoji, group}) => {emoji, group});
 *
 * - `emojibase-data/meta/groups.json`
 * Transformation applied: Manually copying/pasting out the groups.
 *
 * @author Adam (charrondev) Charron <adam.c@vanillaforums.com>
 * @copyright 2009-2019 Vanilla Forums Inc.
 * @license GPL-2.0-only
 */

import React from "react";
import {
    EmojiGroupActivitiesIcon,
    EmojiGroupAnimalsNatureIcon,
    EmojiGroupFlagsIcon,
    EmojiGroupFoodDrinkIcon,
    EmojiGroupObjectsIcon,
    EmojiGroupSmileysPeopleIcon,
    EmojiGroupSymbolsIcon,
    EmojiGroupTravelPlacesIcon,
} from "@library/icons/emojiGroups";

export const EMOJI_GROUPS = [
    {
        name: "Smileys & People",
        icon: <EmojiGroupSmileysPeopleIcon />,
    },
    {
        name: "Animals & Nature",
        icon: <EmojiGroupAnimalsNatureIcon />,
    },
    {
        name: "Food & Drink",
        icon: <EmojiGroupFoodDrinkIcon />,
    },
    {
        name: "Travel & Places",
        icon: <EmojiGroupTravelPlacesIcon />,
    },
    {
        name: "Activities",
        icon: <EmojiGroupActivitiesIcon />,
    },
    {
        name: "Objects",
        icon: <EmojiGroupObjectsIcon />,
    },
    {
        name: "Symbols",
        icon: <EmojiGroupSymbolsIcon />,
    },
    {
        name: "Flags",
        icon: <EmojiGroupFlagsIcon />,
    },
];

export const EMOJIS = [
    { emoji: "😀", group: 0 },
    { emoji: "😁", group: 0 },
    { emoji: "😂", group: 0 },
    { emoji: "🤣", group: 0 },
    { emoji: "😃", group: 0 },
    { emoji: "😄", group: 0 },
    { emoji: "😅", group: 0 },
    { emoji: "😆", group: 0 },
    { emoji: "😉", group: 0 },
    { emoji: "😊", group: 0 },
    { emoji: "😋", group: 0 },
    { emoji: "😎", group: 0 },
    { emoji: "😍", group: 0 },
    { emoji: "😘", group: 0 },
    { emoji: "😗", group: 0 },
    { emoji: "😙", group: 0 },
    { emoji: "😚", group: 0 },
    { emoji: "☺️", group: 0 },
    { emoji: "🙂", group: 0 },
    { emoji: "🤗", group: 0 },
    { emoji: "🤩", group: 0 },
    { emoji: "🤔", group: 0 },
    { emoji: "🤨", group: 0 },
    { emoji: "😐️", group: 0 },
    { emoji: "😑", group: 0 },
    { emoji: "😶", group: 0 },
    { emoji: "🙄", group: 0 },
    { emoji: "😏", group: 0 },
    { emoji: "😣", group: 0 },
    { emoji: "😥", group: 0 },
    { emoji: "😮", group: 0 },
    { emoji: "🤐", group: 0 },
    { emoji: "😯", group: 0 },
    { emoji: "😪", group: 0 },
    { emoji: "😫", group: 0 },
    { emoji: "😴", group: 0 },
    { emoji: "😌", group: 0 },
    { emoji: "😛", group: 0 },
    { emoji: "😜", group: 0 },
    { emoji: "😝", group: 0 },
    { emoji: "🤤", group: 0 },
    { emoji: "😒", group: 0 },
    { emoji: "😓", group: 0 },
    { emoji: "😔", group: 0 },
    { emoji: "😕", group: 0 },
    { emoji: "🙃", group: 0 },
    { emoji: "🤑", group: 0 },
    { emoji: "😲", group: 0 },
    { emoji: "☹️", group: 0 },
    { emoji: "🙁", group: 0 },
    { emoji: "😖", group: 0 },
    { emoji: "😞", group: 0 },
    { emoji: "😟", group: 0 },
    { emoji: "😤", group: 0 },
    { emoji: "😢", group: 0 },
    { emoji: "😭", group: 0 },
    { emoji: "😦", group: 0 },
    { emoji: "😧", group: 0 },
    { emoji: "😨", group: 0 },
    { emoji: "😩", group: 0 },
    { emoji: "🤯", group: 0 },
    { emoji: "😬", group: 0 },
    { emoji: "😰", group: 0 },
    { emoji: "😱", group: 0 },
    { emoji: "😳", group: 0 },
    { emoji: "🤪", group: 0 },
    { emoji: "😵", group: 0 },
    { emoji: "😡", group: 0 },
    { emoji: "😠", group: 0 },
    { emoji: "🤬", group: 0 },
    { emoji: "😷", group: 0 },
    { emoji: "🤒", group: 0 },
    { emoji: "🤕", group: 0 },
    { emoji: "🤢", group: 0 },
    { emoji: "🤮", group: 0 },
    { emoji: "🤧", group: 0 },
    { emoji: "😇", group: 0 },
    { emoji: "🤠", group: 0 },
    { emoji: "🤡", group: 0 },
    { emoji: "🤥", group: 0 },
    { emoji: "🤫", group: 0 },
    { emoji: "🤭", group: 0 },
    { emoji: "🧐", group: 0 },
    { emoji: "🤓", group: 0 },
    { emoji: "😈", group: 0 },
    { emoji: "👿", group: 0 },
    { emoji: "👹", group: 0 },
    { emoji: "👺", group: 0 },
    { emoji: "💀", group: 0 },
    { emoji: "☠️", group: 0 },
    { emoji: "👻", group: 0 },
    { emoji: "👽️", group: 0 },
    { emoji: "👾", group: 0 },
    { emoji: "🤖", group: 0 },
    { emoji: "💩", group: 0 },
    { emoji: "😺", group: 0 },
    { emoji: "😸", group: 0 },
    { emoji: "😹", group: 0 },
    { emoji: "😻", group: 0 },
    { emoji: "😼", group: 0 },
    { emoji: "😽", group: 0 },
    { emoji: "🙀", group: 0 },
    { emoji: "😿", group: 0 },
    { emoji: "😾", group: 0 },
    { emoji: "🙈", group: 0 },
    { emoji: "🙉", group: 0 },
    { emoji: "🙊", group: 0 },
    { emoji: "👶", group: 0 },
    { emoji: "🧒", group: 0 },
    { emoji: "👦", group: 0 },
    { emoji: "👧", group: 0 },
    { emoji: "🧑", group: 0 },
    { emoji: "👨", group: 0 },
    { emoji: "👩", group: 0 },
    { emoji: "🧓", group: 0 },
    { emoji: "👴", group: 0 },
    { emoji: "👵", group: 0 },
    { emoji: "👨‍⚕️", group: 0 },
    { emoji: "👩‍⚕️", group: 0 },
    { emoji: "👨‍🎓", group: 0 },
    { emoji: "👩‍🎓", group: 0 },
    { emoji: "👨‍🏫", group: 0 },
    { emoji: "👩‍🏫", group: 0 },
    { emoji: "👨‍⚖️", group: 0 },
    { emoji: "👩‍⚖️", group: 0 },
    { emoji: "👨‍🌾", group: 0 },
    { emoji: "👩‍🌾", group: 0 },
    { emoji: "👨‍🍳", group: 0 },
    { emoji: "👩‍🍳", group: 0 },
    { emoji: "👨‍🔧", group: 0 },
    { emoji: "👩‍🔧", group: 0 },
    { emoji: "👨‍🏭", group: 0 },
    { emoji: "👩‍🏭", group: 0 },
    { emoji: "👨‍💼", group: 0 },
    { emoji: "👩‍💼", group: 0 },
    { emoji: "👨‍🔬", group: 0 },
    { emoji: "👩‍🔬", group: 0 },
    { emoji: "👨‍💻", group: 0 },
    { emoji: "👩‍💻", group: 0 },
    { emoji: "👨‍🎤", group: 0 },
    { emoji: "👩‍🎤", group: 0 },
    { emoji: "👨‍🎨", group: 0 },
    { emoji: "👩‍🎨", group: 0 },
    { emoji: "👨‍✈️", group: 0 },
    { emoji: "👩‍✈️", group: 0 },
    { emoji: "👨‍🚀", group: 0 },
    { emoji: "👩‍🚀", group: 0 },
    { emoji: "👨‍🚒", group: 0 },
    { emoji: "👩‍🚒", group: 0 },
    { emoji: "👮", group: 0 },
    { emoji: "👮‍♂️", group: 0 },
    { emoji: "👮‍♀️", group: 0 },
    { emoji: "🕵️", group: 0 },
    { emoji: "🕵️‍♂️", group: 0 },
    { emoji: "🕵️‍♀️", group: 0 },
    { emoji: "💂", group: 0 },
    { emoji: "💂‍♂️", group: 0 },
    { emoji: "💂‍♀️", group: 0 },
    { emoji: "👷", group: 0 },
    { emoji: "👷‍♂️", group: 0 },
    { emoji: "👷‍♀️", group: 0 },
    { emoji: "🤴", group: 0 },
    { emoji: "👸", group: 0 },
    { emoji: "👳", group: 0 },
    { emoji: "👳‍♂️", group: 0 },
    { emoji: "👳‍♀️", group: 0 },
    { emoji: "👲", group: 0 },
    { emoji: "🧕", group: 0 },
    { emoji: "🧔", group: 0 },
    { emoji: "👱", group: 0 },
    { emoji: "👱‍♂️", group: 0 },
    { emoji: "👱‍♀️", group: 0 },
    { emoji: "🤵", group: 0 },
    { emoji: "👰", group: 0 },
    { emoji: "🤰", group: 0 },
    { emoji: "🤱", group: 0 },
    { emoji: "👼", group: 0 },
    { emoji: "🎅", group: 0 },
    { emoji: "🤶", group: 0 },
    { emoji: "🧙", group: 0 },
    { emoji: "🧙‍♀️", group: 0 },
    { emoji: "🧙‍♂️", group: 0 },
    { emoji: "🧚", group: 0 },
    { emoji: "🧚‍♀️", group: 0 },
    { emoji: "🧚‍♂️", group: 0 },
    { emoji: "🧛", group: 0 },
    { emoji: "🧛‍♀️", group: 0 },
    { emoji: "🧛‍♂️", group: 0 },
    { emoji: "🧜", group: 0 },
    { emoji: "🧜‍♀️", group: 0 },
    { emoji: "🧜‍♂️", group: 0 },
    { emoji: "🧝", group: 0 },
    { emoji: "🧝‍♀️", group: 0 },
    { emoji: "🧝‍♂️", group: 0 },
    { emoji: "🧞", group: 0 },
    { emoji: "🧞‍♀️", group: 0 },
    { emoji: "🧞‍♂️", group: 0 },
    { emoji: "🧟", group: 0 },
    { emoji: "🧟‍♀️", group: 0 },
    { emoji: "🧟‍♂️", group: 0 },
    { emoji: "🙍", group: 0 },
    { emoji: "🙍‍♂️", group: 0 },
    { emoji: "🙍‍♀️", group: 0 },
    { emoji: "🙎", group: 0 },
    { emoji: "🙎‍♂️", group: 0 },
    { emoji: "🙎‍♀️", group: 0 },
    { emoji: "🙅", group: 0 },
    { emoji: "🙅‍♂️", group: 0 },
    { emoji: "🙅‍♀️", group: 0 },
    { emoji: "🙆", group: 0 },
    { emoji: "🙆‍♂️", group: 0 },
    { emoji: "🙆‍♀️", group: 0 },
    { emoji: "💁", group: 0 },
    { emoji: "💁‍♂️", group: 0 },
    { emoji: "💁‍♀️", group: 0 },
    { emoji: "🙋", group: 0 },
    { emoji: "🙋‍♂️", group: 0 },
    { emoji: "🙋‍♀️", group: 0 },
    { emoji: "🙇", group: 0 },
    { emoji: "🙇‍♂️", group: 0 },
    { emoji: "🙇‍♀️", group: 0 },
    { emoji: "🤦", group: 0 },
    { emoji: "🤦‍♂️", group: 0 },
    { emoji: "🤦‍♀️", group: 0 },
    { emoji: "🤷", group: 0 },
    { emoji: "🤷‍♂️", group: 0 },
    { emoji: "🤷‍♀️", group: 0 },
    { emoji: "💆", group: 0 },
    { emoji: "💆‍♂️", group: 0 },
    { emoji: "💆‍♀️", group: 0 },
    { emoji: "💇", group: 0 },
    { emoji: "💇‍♂️", group: 0 },
    { emoji: "💇‍♀️", group: 0 },
    { emoji: "🚶", group: 0 },
    { emoji: "🚶‍♂️", group: 0 },
    { emoji: "🚶‍♀️", group: 0 },
    { emoji: "🏃", group: 0 },
    { emoji: "🏃‍♂️", group: 0 },
    { emoji: "🏃‍♀️", group: 0 },
    { emoji: "💃", group: 0 },
    { emoji: "🕺", group: 0 },
    { emoji: "👯", group: 0 },
    { emoji: "👯‍♂️", group: 0 },
    { emoji: "👯‍♀️", group: 0 },
    { emoji: "🧖", group: 0 },
    { emoji: "🧖‍♀️", group: 0 },
    { emoji: "🧖‍♂️", group: 0 },
    { emoji: "🧗", group: 0 },
    { emoji: "🧗‍♀️", group: 0 },
    { emoji: "🧗‍♂️", group: 0 },
    { emoji: "🧘", group: 0 },
    { emoji: "🧘‍♀️", group: 0 },
    { emoji: "🧘‍♂️", group: 0 },
    { emoji: "🛀", group: 0 },
    { emoji: "🛌", group: 0 },
    { emoji: "🕴️", group: 0 },
    { emoji: "🗣️", group: 0 },
    { emoji: "👤", group: 0 },
    { emoji: "👥", group: 0 },
    { emoji: "🤺", group: 0 },
    { emoji: "🏇", group: 0 },
    { emoji: "⛷️", group: 0 },
    { emoji: "🏂️", group: 0 },
    { emoji: "🏌️", group: 0 },
    { emoji: "🏌️‍♂️", group: 0 },
    { emoji: "🏌️‍♀️", group: 0 },
    { emoji: "🏄️", group: 0 },
    { emoji: "🏄‍♂️", group: 0 },
    { emoji: "🏄‍♀️", group: 0 },
    { emoji: "🚣", group: 0 },
    { emoji: "🚣‍♂️", group: 0 },
    { emoji: "🚣‍♀️", group: 0 },
    { emoji: "🏊️", group: 0 },
    { emoji: "🏊‍♂️", group: 0 },
    { emoji: "🏊‍♀️", group: 0 },
    { emoji: "⛹️", group: 0 },
    { emoji: "⛹️‍♂️", group: 0 },
    { emoji: "⛹️‍♀️", group: 0 },
    { emoji: "🏋️", group: 0 },
    { emoji: "🏋️‍♂️", group: 0 },
    { emoji: "🏋️‍♀️", group: 0 },
    { emoji: "🚴", group: 0 },
    { emoji: "🚴‍♂️", group: 0 },
    { emoji: "🚴‍♀️", group: 0 },
    { emoji: "🚵", group: 0 },
    { emoji: "🚵‍♂️", group: 0 },
    { emoji: "🚵‍♀️", group: 0 },
    { emoji: "🏎️", group: 0 },
    { emoji: "🏍️", group: 0 },
    { emoji: "🤸", group: 0 },
    { emoji: "🤸‍♂️", group: 0 },
    { emoji: "🤸‍♀️", group: 0 },
    { emoji: "🤼", group: 0 },
    { emoji: "🤼‍♂️", group: 0 },
    { emoji: "🤼‍♀️", group: 0 },
    { emoji: "🤽", group: 0 },
    { emoji: "🤽‍♂️", group: 0 },
    { emoji: "🤽‍♀️", group: 0 },
    { emoji: "🤾", group: 0 },
    { emoji: "🤾‍♂️", group: 0 },
    { emoji: "🤾‍♀️", group: 0 },
    { emoji: "🤹", group: 0 },
    { emoji: "🤹‍♂️", group: 0 },
    { emoji: "🤹‍♀️", group: 0 },
    { emoji: "👫", group: 0 },
    { emoji: "👬", group: 0 },
    { emoji: "👭", group: 0 },
    { emoji: "💏", group: 0 },
    { emoji: "👩‍❤️‍💋‍👨", group: 0 },
    { emoji: "👨‍❤️‍💋‍👨", group: 0 },
    { emoji: "👩‍❤️‍💋‍👩", group: 0 },
    { emoji: "💑", group: 0 },
    { emoji: "👩‍❤️‍👨", group: 0 },
    { emoji: "👨‍❤️‍👨", group: 0 },
    { emoji: "👩‍❤️‍👩", group: 0 },
    { emoji: "👪️", group: 0 },
    { emoji: "👨‍👩‍👦", group: 0 },
    { emoji: "👨‍👩‍👧", group: 0 },
    { emoji: "👨‍👩‍👧‍👦", group: 0 },
    { emoji: "👨‍👩‍👦‍👦", group: 0 },
    { emoji: "👨‍👩‍👧‍👧", group: 0 },
    { emoji: "👨‍👨‍👦", group: 0 },
    { emoji: "👨‍👨‍👧", group: 0 },
    { emoji: "👨‍👨‍👧‍👦", group: 0 },
    { emoji: "👨‍👨‍👦‍👦", group: 0 },
    { emoji: "👨‍👨‍👧‍👧", group: 0 },
    { emoji: "👩‍👩‍👦", group: 0 },
    { emoji: "👩‍👩‍👧", group: 0 },
    { emoji: "👩‍👩‍👧‍👦", group: 0 },
    { emoji: "👩‍👩‍👦‍👦", group: 0 },
    { emoji: "👩‍👩‍👧‍👧", group: 0 },
    { emoji: "👨‍👦", group: 0 },
    { emoji: "👨‍👦‍👦", group: 0 },
    { emoji: "👨‍👧", group: 0 },
    { emoji: "👨‍👧‍👦", group: 0 },
    { emoji: "👨‍👧‍👧", group: 0 },
    { emoji: "👩‍👦", group: 0 },
    { emoji: "👩‍👦‍👦", group: 0 },
    { emoji: "👩‍👧", group: 0 },
    { emoji: "👩‍👧‍👦", group: 0 },
    { emoji: "👩‍👧‍👧", group: 0 },
    { emoji: "🤳", group: 0 },
    { emoji: "💪", group: 0 },
    { emoji: "👈️", group: 0 },
    { emoji: "👉️", group: 0 },
    { emoji: "☝️", group: 0 },
    { emoji: "👆️", group: 0 },
    { emoji: "🖕", group: 0 },
    { emoji: "👇️", group: 0 },
    { emoji: "✌️", group: 0 },
    { emoji: "🤞", group: 0 },
    { emoji: "🖖", group: 0 },
    { emoji: "🤘", group: 0 },
    { emoji: "🤙", group: 0 },
    { emoji: "🖐️", group: 0 },
    { emoji: "✋", group: 0 },
    { emoji: "👌", group: 0 },
    { emoji: "👍️", group: 0 },
    { emoji: "👎️", group: 0 },
    { emoji: "✊", group: 0 },
    { emoji: "👊", group: 0 },
    { emoji: "🤛", group: 0 },
    { emoji: "🤜", group: 0 },
    { emoji: "🤚", group: 0 },
    { emoji: "👋", group: 0 },
    { emoji: "🤟", group: 0 },
    { emoji: "✍️", group: 0 },
    { emoji: "👏", group: 0 },
    { emoji: "👐", group: 0 },
    { emoji: "🙌", group: 0 },
    { emoji: "🤲", group: 0 },
    { emoji: "🙏", group: 0 },
    { emoji: "🤝", group: 0 },
    { emoji: "💅", group: 0 },
    { emoji: "👂️", group: 0 },
    { emoji: "👃", group: 0 },
    { emoji: "👣", group: 0 },
    { emoji: "👀", group: 0 },
    { emoji: "👁️", group: 0 },
    { emoji: "👁️‍🗨️", group: 0 },
    { emoji: "🧠", group: 0 },
    { emoji: "👅", group: 0 },
    { emoji: "👄", group: 0 },
    { emoji: "💋", group: 0 },
    { emoji: "💘", group: 0 },
    { emoji: "❤️", group: 0 },
    { emoji: "💓", group: 0 },
    { emoji: "💔", group: 0 },
    { emoji: "💕", group: 0 },
    { emoji: "💖", group: 0 },
    { emoji: "💗", group: 0 },
    { emoji: "💙", group: 0 },
    { emoji: "💚", group: 0 },
    { emoji: "💛", group: 0 },
    { emoji: "🧡", group: 0 },
    { emoji: "💜", group: 0 },
    { emoji: "🖤", group: 0 },
    { emoji: "💝", group: 0 },
    { emoji: "💞", group: 0 },
    { emoji: "💟", group: 0 },
    { emoji: "❣️", group: 0 },
    { emoji: "💌", group: 0 },
    { emoji: "💤", group: 0 },
    { emoji: "💢", group: 0 },
    { emoji: "💣️", group: 0 },
    { emoji: "💥", group: 0 },
    { emoji: "💦", group: 0 },
    { emoji: "💨", group: 0 },
    { emoji: "💫", group: 0 },
    { emoji: "💬", group: 0 },
    { emoji: "🗨️", group: 0 },
    { emoji: "🗯️", group: 0 },
    { emoji: "💭", group: 0 },
    { emoji: "🕳️", group: 0 },
    { emoji: "👓️", group: 0 },
    { emoji: "🕶️", group: 0 },
    { emoji: "👔", group: 0 },
    { emoji: "👕", group: 0 },
    { emoji: "👖", group: 0 },
    { emoji: "🧣", group: 0 },
    { emoji: "🧤", group: 0 },
    { emoji: "🧥", group: 0 },
    { emoji: "🧦", group: 0 },
    { emoji: "👗", group: 0 },
    { emoji: "👘", group: 0 },
    { emoji: "👙", group: 0 },
    { emoji: "👚", group: 0 },
    { emoji: "👛", group: 0 },
    { emoji: "👜", group: 0 },
    { emoji: "👝", group: 0 },
    { emoji: "🛍️", group: 0 },
    { emoji: "🎒", group: 0 },
    { emoji: "👞", group: 0 },
    { emoji: "👟", group: 0 },
    { emoji: "👠", group: 0 },
    { emoji: "👡", group: 0 },
    { emoji: "👢", group: 0 },
    { emoji: "👑", group: 0 },
    { emoji: "👒", group: 0 },
    { emoji: "🎩", group: 0 },
    { emoji: "🎓️", group: 0 },
    { emoji: "🧢", group: 0 },
    { emoji: "⛑️", group: 0 },
    { emoji: "📿", group: 0 },
    { emoji: "💄", group: 0 },
    { emoji: "💍", group: 0 },
    { emoji: "💎", group: 0 },
    { emoji: "🐵", group: 1 },
    { emoji: "🐒", group: 1 },
    { emoji: "🦍", group: 1 },
    { emoji: "🐶", group: 1 },
    { emoji: "🐕️", group: 1 },
    { emoji: "🐩", group: 1 },
    { emoji: "🐺", group: 1 },
    { emoji: "🦊", group: 1 },
    { emoji: "🐱", group: 1 },
    { emoji: "🐈️", group: 1 },
    { emoji: "🦁", group: 1 },
    { emoji: "🐯", group: 1 },
    { emoji: "🐅", group: 1 },
    { emoji: "🐆", group: 1 },
    { emoji: "🐴", group: 1 },
    { emoji: "🐎", group: 1 },
    { emoji: "🦄", group: 1 },
    { emoji: "🦓", group: 1 },
    { emoji: "🦌", group: 1 },
    { emoji: "🐮", group: 1 },
    { emoji: "🐂", group: 1 },
    { emoji: "🐃", group: 1 },
    { emoji: "🐄", group: 1 },
    { emoji: "🐷", group: 1 },
    { emoji: "🐖", group: 1 },
    { emoji: "🐗", group: 1 },
    { emoji: "🐽", group: 1 },
    { emoji: "🐏", group: 1 },
    { emoji: "🐑", group: 1 },
    { emoji: "🐐", group: 1 },
    { emoji: "🐪", group: 1 },
    { emoji: "🐫", group: 1 },
    { emoji: "🦒", group: 1 },
    { emoji: "🐘", group: 1 },
    { emoji: "🦏", group: 1 },
    { emoji: "🐭", group: 1 },
    { emoji: "🐁", group: 1 },
    { emoji: "🐀", group: 1 },
    { emoji: "🐹", group: 1 },
    { emoji: "🐰", group: 1 },
    { emoji: "🐇", group: 1 },
    { emoji: "🐿️", group: 1 },
    { emoji: "🦔", group: 1 },
    { emoji: "🦇", group: 1 },
    { emoji: "🐻", group: 1 },
    { emoji: "🐨", group: 1 },
    { emoji: "🐼", group: 1 },
    { emoji: "🐾", group: 1 },
    { emoji: "🦃", group: 1 },
    { emoji: "🐔", group: 1 },
    { emoji: "🐓", group: 1 },
    { emoji: "🐣", group: 1 },
    { emoji: "🐤", group: 1 },
    { emoji: "🐥", group: 1 },
    { emoji: "🐦️", group: 1 },
    { emoji: "🐧", group: 1 },
    { emoji: "🕊️", group: 1 },
    { emoji: "🦅", group: 1 },
    { emoji: "🦆", group: 1 },
    { emoji: "🦉", group: 1 },
    { emoji: "🐸", group: 1 },
    { emoji: "🐊", group: 1 },
    { emoji: "🐢", group: 1 },
    { emoji: "🦎", group: 1 },
    { emoji: "🐍", group: 1 },
    { emoji: "🐲", group: 1 },
    { emoji: "🐉", group: 1 },
    { emoji: "🦕", group: 1 },
    { emoji: "🦖", group: 1 },
    { emoji: "🐳", group: 1 },
    { emoji: "🐋", group: 1 },
    { emoji: "🐬", group: 1 },
    { emoji: "🐟️", group: 1 },
    { emoji: "🐠", group: 1 },
    { emoji: "🐡", group: 1 },
    { emoji: "🦈", group: 1 },
    { emoji: "🐙", group: 1 },
    { emoji: "🐚", group: 1 },
    { emoji: "🦀", group: 1 },
    { emoji: "🦐", group: 1 },
    { emoji: "🦑", group: 1 },
    { emoji: "🐌", group: 1 },
    { emoji: "🦋", group: 1 },
    { emoji: "🐛", group: 1 },
    { emoji: "🐜", group: 1 },
    { emoji: "🐝", group: 1 },
    { emoji: "🐞", group: 1 },
    { emoji: "🦗", group: 1 },
    { emoji: "🕷️", group: 1 },
    { emoji: "🕸️", group: 1 },
    { emoji: "🦂", group: 1 },
    { emoji: "💐", group: 1 },
    { emoji: "🌸", group: 1 },
    { emoji: "💮", group: 1 },
    { emoji: "🏵️", group: 1 },
    { emoji: "🌹", group: 1 },
    { emoji: "🥀", group: 1 },
    { emoji: "🌺", group: 1 },
    { emoji: "🌻", group: 1 },
    { emoji: "🌼", group: 1 },
    { emoji: "🌷", group: 1 },
    { emoji: "🌱", group: 1 },
    { emoji: "🌲", group: 1 },
    { emoji: "🌳", group: 1 },
    { emoji: "🌴", group: 1 },
    { emoji: "🌵", group: 1 },
    { emoji: "🌾", group: 1 },
    { emoji: "🌿", group: 1 },
    { emoji: "☘️", group: 1 },
    { emoji: "🍀", group: 1 },
    { emoji: "🍁", group: 1 },
    { emoji: "🍂", group: 1 },
    { emoji: "🍃", group: 1 },
    { emoji: "🍇", group: 2 },
    { emoji: "🍈", group: 2 },
    { emoji: "🍉", group: 2 },
    { emoji: "🍊", group: 2 },
    { emoji: "🍋", group: 2 },
    { emoji: "🍌", group: 2 },
    { emoji: "🍍", group: 2 },
    { emoji: "🍎", group: 2 },
    { emoji: "🍏", group: 2 },
    { emoji: "🍐", group: 2 },
    { emoji: "🍑", group: 2 },
    { emoji: "🍒", group: 2 },
    { emoji: "🍓", group: 2 },
    { emoji: "🥝", group: 2 },
    { emoji: "🍅", group: 2 },
    { emoji: "🥥", group: 2 },
    { emoji: "🥑", group: 2 },
    { emoji: "🍆", group: 2 },
    { emoji: "🥔", group: 2 },
    { emoji: "🥕", group: 2 },
    { emoji: "🌽", group: 2 },
    { emoji: "🌶️", group: 2 },
    { emoji: "🥒", group: 2 },
    { emoji: "🥦", group: 2 },
    { emoji: "🍄", group: 2 },
    { emoji: "🥜", group: 2 },
    { emoji: "🌰", group: 2 },
    { emoji: "🍞", group: 2 },
    { emoji: "🥐", group: 2 },
    { emoji: "🥖", group: 2 },
    { emoji: "🥨", group: 2 },
    { emoji: "🥞", group: 2 },
    { emoji: "🧀", group: 2 },
    { emoji: "🍖", group: 2 },
    { emoji: "🍗", group: 2 },
    { emoji: "🥩", group: 2 },
    { emoji: "🥓", group: 2 },
    { emoji: "🍔", group: 2 },
    { emoji: "🍟", group: 2 },
    { emoji: "🍕", group: 2 },
    { emoji: "🌭", group: 2 },
    { emoji: "🥪", group: 2 },
    { emoji: "🌮", group: 2 },
    { emoji: "🌯", group: 2 },
    { emoji: "🥙", group: 2 },
    { emoji: "🥚", group: 2 },
    { emoji: "🍳", group: 2 },
    { emoji: "🥘", group: 2 },
    { emoji: "🍲", group: 2 },
    { emoji: "🥣", group: 2 },
    { emoji: "🥗", group: 2 },
    { emoji: "🍿", group: 2 },
    { emoji: "🥫", group: 2 },
    { emoji: "🍱", group: 2 },
    { emoji: "🍘", group: 2 },
    { emoji: "🍙", group: 2 },
    { emoji: "🍚", group: 2 },
    { emoji: "🍛", group: 2 },
    { emoji: "🍜", group: 2 },
    { emoji: "🍝", group: 2 },
    { emoji: "🍠", group: 2 },
    { emoji: "🍢", group: 2 },
    { emoji: "🍣", group: 2 },
    { emoji: "🍤", group: 2 },
    { emoji: "🍥", group: 2 },
    { emoji: "🍡", group: 2 },
    { emoji: "🥟", group: 2 },
    { emoji: "🥠", group: 2 },
    { emoji: "🥡", group: 2 },
    { emoji: "🍦", group: 2 },
    { emoji: "🍧", group: 2 },
    { emoji: "🍨", group: 2 },
    { emoji: "🍩", group: 2 },
    { emoji: "🍪", group: 2 },
    { emoji: "🎂", group: 2 },
    { emoji: "🍰", group: 2 },
    { emoji: "🥧", group: 2 },
    { emoji: "🍫", group: 2 },
    { emoji: "🍬", group: 2 },
    { emoji: "🍭", group: 2 },
    { emoji: "🍮", group: 2 },
    { emoji: "🍯", group: 2 },
    { emoji: "🍼", group: 2 },
    { emoji: "🥛", group: 2 },
    { emoji: "☕️", group: 2 },
    { emoji: "🍵", group: 2 },
    { emoji: "🍶", group: 2 },
    { emoji: "🍾", group: 2 },
    { emoji: "🍷", group: 2 },
    { emoji: "🍸️", group: 2 },
    { emoji: "🍹", group: 2 },
    { emoji: "🍺", group: 2 },
    { emoji: "🍻", group: 2 },
    { emoji: "🥂", group: 2 },
    { emoji: "🥃", group: 2 },
    { emoji: "🥤", group: 2 },
    { emoji: "🥢", group: 2 },
    { emoji: "🍽️", group: 2 },
    { emoji: "🍴", group: 2 },
    { emoji: "🥄", group: 2 },
    { emoji: "🔪", group: 2 },
    { emoji: "🏺", group: 2 },
    { emoji: "🌍️", group: 3 },
    { emoji: "🌎️", group: 3 },
    { emoji: "🌏️", group: 3 },
    { emoji: "🌐", group: 3 },
    { emoji: "🗺️", group: 3 },
    { emoji: "🗾", group: 3 },
    { emoji: "🏔️", group: 3 },
    { emoji: "⛰️", group: 3 },
    { emoji: "🌋", group: 3 },
    { emoji: "🗻", group: 3 },
    { emoji: "🏕️", group: 3 },
    { emoji: "🏖️", group: 3 },
    { emoji: "🏜️", group: 3 },
    { emoji: "🏝️", group: 3 },
    { emoji: "🏞️", group: 3 },
    { emoji: "🏟️", group: 3 },
    { emoji: "🏛️", group: 3 },
    { emoji: "🏗️", group: 3 },
    { emoji: "🏘️", group: 3 },
    { emoji: "🏙️", group: 3 },
    { emoji: "🏚️", group: 3 },
    { emoji: "🏠️", group: 3 },
    { emoji: "🏡", group: 3 },
    { emoji: "🏢", group: 3 },
    { emoji: "🏣", group: 3 },
    { emoji: "🏤", group: 3 },
    { emoji: "🏥", group: 3 },
    { emoji: "🏦", group: 3 },
    { emoji: "🏨", group: 3 },
    { emoji: "🏩", group: 3 },
    { emoji: "🏪", group: 3 },
    { emoji: "🏫", group: 3 },
    { emoji: "🏬", group: 3 },
    { emoji: "🏭️", group: 3 },
    { emoji: "🏯", group: 3 },
    { emoji: "🏰", group: 3 },
    { emoji: "💒", group: 3 },
    { emoji: "🗼", group: 3 },
    { emoji: "🗽", group: 3 },
    { emoji: "⛪️", group: 3 },
    { emoji: "🕌", group: 3 },
    { emoji: "🕍", group: 3 },
    { emoji: "⛩️", group: 3 },
    { emoji: "🕋", group: 3 },
    { emoji: "⛲️", group: 3 },
    { emoji: "⛺️", group: 3 },
    { emoji: "🌁", group: 3 },
    { emoji: "🌃", group: 3 },
    { emoji: "🌄", group: 3 },
    { emoji: "🌅", group: 3 },
    { emoji: "🌆", group: 3 },
    { emoji: "🌇", group: 3 },
    { emoji: "🌉", group: 3 },
    { emoji: "♨️", group: 3 },
    { emoji: "🌌", group: 3 },
    { emoji: "🎠", group: 3 },
    { emoji: "🎡", group: 3 },
    { emoji: "🎢", group: 3 },
    { emoji: "💈", group: 3 },
    { emoji: "🎪", group: 3 },
    { emoji: "🎭️", group: 3 },
    { emoji: "🖼️", group: 3 },
    { emoji: "🎨", group: 3 },
    { emoji: "🎰", group: 3 },
    { emoji: "🚂", group: 3 },
    { emoji: "🚃", group: 3 },
    { emoji: "🚄", group: 3 },
    { emoji: "🚅", group: 3 },
    { emoji: "🚆", group: 3 },
    { emoji: "🚇️", group: 3 },
    { emoji: "🚈", group: 3 },
    { emoji: "🚉", group: 3 },
    { emoji: "🚊", group: 3 },
    { emoji: "🚝", group: 3 },
    { emoji: "🚞", group: 3 },
    { emoji: "🚋", group: 3 },
    { emoji: "🚌", group: 3 },
    { emoji: "🚍️", group: 3 },
    { emoji: "🚎", group: 3 },
    { emoji: "🚐", group: 3 },
    { emoji: "🚑️", group: 3 },
    { emoji: "🚒", group: 3 },
    { emoji: "🚓", group: 3 },
    { emoji: "🚔️", group: 3 },
    { emoji: "🚕", group: 3 },
    { emoji: "🚖", group: 3 },
    { emoji: "🚗", group: 3 },
    { emoji: "🚘️", group: 3 },
    { emoji: "🚙", group: 3 },
    { emoji: "🚚", group: 3 },
    { emoji: "🚛", group: 3 },
    { emoji: "🚜", group: 3 },
    { emoji: "🚲️", group: 3 },
    { emoji: "🛴", group: 3 },
    { emoji: "🛵", group: 3 },
    { emoji: "🚏", group: 3 },
    { emoji: "🛣️", group: 3 },
    { emoji: "🛤️", group: 3 },
    { emoji: "⛽️", group: 3 },
    { emoji: "🚨", group: 3 },
    { emoji: "🚥", group: 3 },
    { emoji: "🚦", group: 3 },
    { emoji: "🚧", group: 3 },
    { emoji: "🛑", group: 3 },
    { emoji: "⚓️", group: 3 },
    { emoji: "⛵️", group: 3 },
    { emoji: "🛶", group: 3 },
    { emoji: "🚤", group: 3 },
    { emoji: "🛳️", group: 3 },
    { emoji: "⛴️", group: 3 },
    { emoji: "🛥️", group: 3 },
    { emoji: "🚢", group: 3 },
    { emoji: "✈️", group: 3 },
    { emoji: "🛩️", group: 3 },
    { emoji: "🛫", group: 3 },
    { emoji: "🛬", group: 3 },
    { emoji: "💺", group: 3 },
    { emoji: "🚁", group: 3 },
    { emoji: "🚟", group: 3 },
    { emoji: "🚠", group: 3 },
    { emoji: "🚡", group: 3 },
    { emoji: "🛰️", group: 3 },
    { emoji: "🚀", group: 3 },
    { emoji: "🛸", group: 3 },
    { emoji: "🛎️", group: 3 },
    { emoji: "🚪", group: 3 },
    { emoji: "🛏️", group: 3 },
    { emoji: "🛋️", group: 3 },
    { emoji: "🚽", group: 3 },
    { emoji: "🚿", group: 3 },
    { emoji: "🛁", group: 3 },
    { emoji: "⌛️", group: 3 },
    { emoji: "⏳️", group: 3 },
    { emoji: "⌚️", group: 3 },
    { emoji: "⏰", group: 3 },
    { emoji: "⏱️", group: 3 },
    { emoji: "⏲️", group: 3 },
    { emoji: "🕰️", group: 3 },
    { emoji: "🕛️", group: 3 },
    { emoji: "🕧️", group: 3 },
    { emoji: "🕐️", group: 3 },
    { emoji: "🕜️", group: 3 },
    { emoji: "🕑️", group: 3 },
    { emoji: "🕝️", group: 3 },
    { emoji: "🕒️", group: 3 },
    { emoji: "🕞️", group: 3 },
    { emoji: "🕓️", group: 3 },
    { emoji: "🕟️", group: 3 },
    { emoji: "🕔️", group: 3 },
    { emoji: "🕠️", group: 3 },
    { emoji: "🕕️", group: 3 },
    { emoji: "🕡️", group: 3 },
    { emoji: "🕖️", group: 3 },
    { emoji: "🕢️", group: 3 },
    { emoji: "🕗️", group: 3 },
    { emoji: "🕣️", group: 3 },
    { emoji: "🕘️", group: 3 },
    { emoji: "🕤️", group: 3 },
    { emoji: "🕙️", group: 3 },
    { emoji: "🕥️", group: 3 },
    { emoji: "🕚️", group: 3 },
    { emoji: "🕦️", group: 3 },
    { emoji: "🌑", group: 3 },
    { emoji: "🌒", group: 3 },
    { emoji: "🌓", group: 3 },
    { emoji: "🌔", group: 3 },
    { emoji: "🌕️", group: 3 },
    { emoji: "🌖", group: 3 },
    { emoji: "🌗", group: 3 },
    { emoji: "🌘", group: 3 },
    { emoji: "🌙", group: 3 },
    { emoji: "🌚", group: 3 },
    { emoji: "🌛", group: 3 },
    { emoji: "🌜️", group: 3 },
    { emoji: "🌡️", group: 3 },
    { emoji: "☀️", group: 3 },
    { emoji: "🌝", group: 3 },
    { emoji: "🌞", group: 3 },
    { emoji: "⭐️", group: 3 },
    { emoji: "🌟", group: 3 },
    { emoji: "🌠", group: 3 },
    { emoji: "☁️", group: 3 },
    { emoji: "⛅️", group: 3 },
    { emoji: "⛈️", group: 3 },
    { emoji: "🌤️", group: 3 },
    { emoji: "🌥️", group: 3 },
    { emoji: "🌦️", group: 3 },
    { emoji: "🌧️", group: 3 },
    { emoji: "🌨️", group: 3 },
    { emoji: "🌩️", group: 3 },
    { emoji: "🌪️", group: 3 },
    { emoji: "🌫️", group: 3 },
    { emoji: "🌬️", group: 3 },
    { emoji: "🌀", group: 3 },
    { emoji: "🌈", group: 3 },
    { emoji: "🌂", group: 3 },
    { emoji: "☂️", group: 3 },
    { emoji: "☔️", group: 3 },
    { emoji: "⛱️", group: 3 },
    { emoji: "⚡️", group: 3 },
    { emoji: "❄️", group: 3 },
    { emoji: "☃️", group: 3 },
    { emoji: "⛄️", group: 3 },
    { emoji: "☄️", group: 3 },
    { emoji: "🔥", group: 3 },
    { emoji: "💧", group: 3 },
    { emoji: "🌊", group: 3 },
    { emoji: "🎃", group: 4 },
    { emoji: "🎄", group: 4 },
    { emoji: "🎆", group: 4 },
    { emoji: "🎇", group: 4 },
    { emoji: "✨", group: 4 },
    { emoji: "🎈", group: 4 },
    { emoji: "🎉", group: 4 },
    { emoji: "🎊", group: 4 },
    { emoji: "🎋", group: 4 },
    { emoji: "🎍", group: 4 },
    { emoji: "🎎", group: 4 },
    { emoji: "🎏", group: 4 },
    { emoji: "🎐", group: 4 },
    { emoji: "🎑", group: 4 },
    { emoji: "🎀", group: 4 },
    { emoji: "🎁", group: 4 },
    { emoji: "🎗️", group: 4 },
    { emoji: "🎟️", group: 4 },
    { emoji: "🎫", group: 4 },
    { emoji: "🎖️", group: 4 },
    { emoji: "🏆️", group: 4 },
    { emoji: "🏅", group: 4 },
    { emoji: "🥇", group: 4 },
    { emoji: "🥈", group: 4 },
    { emoji: "🥉", group: 4 },
    { emoji: "⚽️", group: 4 },
    { emoji: "⚾️", group: 4 },
    { emoji: "🏀", group: 4 },
    { emoji: "🏐", group: 4 },
    { emoji: "🏈", group: 4 },
    { emoji: "🏉", group: 4 },
    { emoji: "🎾", group: 4 },
    { emoji: "🎱", group: 4 },
    { emoji: "🎳", group: 4 },
    { emoji: "🏏", group: 4 },
    { emoji: "🏑", group: 4 },
    { emoji: "🏒", group: 4 },
    { emoji: "🏓", group: 4 },
    { emoji: "🏸", group: 4 },
    { emoji: "🥊", group: 4 },
    { emoji: "🥋", group: 4 },
    { emoji: "🥅", group: 4 },
    { emoji: "🎯", group: 4 },
    { emoji: "⛳️", group: 4 },
    { emoji: "⛸️", group: 4 },
    { emoji: "🎣", group: 4 },
    { emoji: "🎽", group: 4 },
    { emoji: "🎿", group: 4 },
    { emoji: "🛷", group: 4 },
    { emoji: "🥌", group: 4 },
    { emoji: "🎮️", group: 4 },
    { emoji: "🕹️", group: 4 },
    { emoji: "🎲", group: 4 },
    { emoji: "♠️", group: 4 },
    { emoji: "♥️", group: 4 },
    { emoji: "♦️", group: 4 },
    { emoji: "♣️", group: 4 },
    { emoji: "🃏", group: 4 },
    { emoji: "🀄️", group: 4 },
    { emoji: "🎴", group: 4 },
    { emoji: "🔇", group: 5 },
    { emoji: "🔈️", group: 5 },
    { emoji: "🔉", group: 5 },
    { emoji: "🔊", group: 5 },
    { emoji: "📢", group: 5 },
    { emoji: "📣", group: 5 },
    { emoji: "📯", group: 5 },
    { emoji: "🔔", group: 5 },
    { emoji: "🔕", group: 5 },
    { emoji: "🎼", group: 5 },
    { emoji: "🎵", group: 5 },
    { emoji: "🎶", group: 5 },
    { emoji: "🎙️", group: 5 },
    { emoji: "🎚️", group: 5 },
    { emoji: "🎛️", group: 5 },
    { emoji: "🎤", group: 5 },
    { emoji: "🎧️", group: 5 },
    { emoji: "📻️", group: 5 },
    { emoji: "🎷", group: 5 },
    { emoji: "🎸", group: 5 },
    { emoji: "🎹", group: 5 },
    { emoji: "🎺", group: 5 },
    { emoji: "🎻", group: 5 },
    { emoji: "🥁", group: 5 },
    { emoji: "📱", group: 5 },
    { emoji: "📲", group: 5 },
    { emoji: "☎️", group: 5 },
    { emoji: "📞", group: 5 },
    { emoji: "📟️", group: 5 },
    { emoji: "📠", group: 5 },
    { emoji: "🔋", group: 5 },
    { emoji: "🔌", group: 5 },
    { emoji: "💻️", group: 5 },
    { emoji: "🖥️", group: 5 },
    { emoji: "🖨️", group: 5 },
    { emoji: "⌨️", group: 5 },
    { emoji: "🖱️", group: 5 },
    { emoji: "🖲️", group: 5 },
    { emoji: "💽", group: 5 },
    { emoji: "💾", group: 5 },
    { emoji: "💿️", group: 5 },
    { emoji: "📀", group: 5 },
    { emoji: "🎥", group: 5 },
    { emoji: "🎞️", group: 5 },
    { emoji: "📽️", group: 5 },
    { emoji: "🎬️", group: 5 },
    { emoji: "📺️", group: 5 },
    { emoji: "📷️", group: 5 },
    { emoji: "📸", group: 5 },
    { emoji: "📹️", group: 5 },
    { emoji: "📼", group: 5 },
    { emoji: "🔍️", group: 5 },
    { emoji: "🔎", group: 5 },
    { emoji: "🔬", group: 5 },
    { emoji: "🔭", group: 5 },
    { emoji: "📡", group: 5 },
    { emoji: "🕯️", group: 5 },
    { emoji: "💡", group: 5 },
    { emoji: "🔦", group: 5 },
    { emoji: "🏮", group: 5 },
    { emoji: "📔", group: 5 },
    { emoji: "📕", group: 5 },
    { emoji: "📖", group: 5 },
    { emoji: "📗", group: 5 },
    { emoji: "📘", group: 5 },
    { emoji: "📙", group: 5 },
    { emoji: "📚️", group: 5 },
    { emoji: "📓", group: 5 },
    { emoji: "📒", group: 5 },
    { emoji: "📃", group: 5 },
    { emoji: "📜", group: 5 },
    { emoji: "📄", group: 5 },
    { emoji: "📰", group: 5 },
    { emoji: "🗞️", group: 5 },
    { emoji: "📑", group: 5 },
    { emoji: "🔖", group: 5 },
    { emoji: "🏷️", group: 5 },
    { emoji: "💰️", group: 5 },
    { emoji: "💴", group: 5 },
    { emoji: "💵", group: 5 },
    { emoji: "💶", group: 5 },
    { emoji: "💷", group: 5 },
    { emoji: "💸", group: 5 },
    { emoji: "💳️", group: 5 },
    { emoji: "💹", group: 5 },
    { emoji: "💱", group: 5 },
    { emoji: "💲", group: 5 },
    { emoji: "✉️", group: 5 },
    { emoji: "📧", group: 5 },
    { emoji: "📨", group: 5 },
    { emoji: "📩", group: 5 },
    { emoji: "📤️", group: 5 },
    { emoji: "📥️", group: 5 },
    { emoji: "📦️", group: 5 },
    { emoji: "📫️", group: 5 },
    { emoji: "📪️", group: 5 },
    { emoji: "📬️", group: 5 },
    { emoji: "📭️", group: 5 },
    { emoji: "📮", group: 5 },
    { emoji: "🗳️", group: 5 },
    { emoji: "✏️", group: 5 },
    { emoji: "✒️", group: 5 },
    { emoji: "🖋️", group: 5 },
    { emoji: "🖊️", group: 5 },
    { emoji: "🖌️", group: 5 },
    { emoji: "🖍️", group: 5 },
    { emoji: "📝", group: 5 },
    { emoji: "💼", group: 5 },
    { emoji: "📁", group: 5 },
    { emoji: "📂", group: 5 },
    { emoji: "🗂️", group: 5 },
    { emoji: "📅", group: 5 },
    { emoji: "📆", group: 5 },
    { emoji: "🗒️", group: 5 },
    { emoji: "🗓️", group: 5 },
    { emoji: "📇", group: 5 },
    { emoji: "📈", group: 5 },
    { emoji: "📉", group: 5 },
    { emoji: "📊", group: 5 },
    { emoji: "📋️", group: 5 },
    { emoji: "📌", group: 5 },
    { emoji: "📍", group: 5 },
    { emoji: "📎", group: 5 },
    { emoji: "🖇️", group: 5 },
    { emoji: "📏", group: 5 },
    { emoji: "📐", group: 5 },
    { emoji: "✂️", group: 5 },
    { emoji: "🗃️", group: 5 },
    { emoji: "🗄️", group: 5 },
    { emoji: "🗑️", group: 5 },
    { emoji: "🔒️", group: 5 },
    { emoji: "🔓️", group: 5 },
    { emoji: "🔏", group: 5 },
    { emoji: "🔐", group: 5 },
    { emoji: "🔑", group: 5 },
    { emoji: "🗝️", group: 5 },
    { emoji: "🔨", group: 5 },
    { emoji: "⛏️", group: 5 },
    { emoji: "⚒️", group: 5 },
    { emoji: "🛠️", group: 5 },
    { emoji: "🗡️", group: 5 },
    { emoji: "⚔️", group: 5 },
    { emoji: "🔫", group: 5 },
    { emoji: "🏹", group: 5 },
    { emoji: "🛡️", group: 5 },
    { emoji: "🔧", group: 5 },
    { emoji: "🔩", group: 5 },
    { emoji: "⚙️", group: 5 },
    { emoji: "🗜️", group: 5 },
    { emoji: "⚗️", group: 5 },
    { emoji: "⚖️", group: 5 },
    { emoji: "🔗", group: 5 },
    { emoji: "⛓️", group: 5 },
    { emoji: "💉", group: 5 },
    { emoji: "💊", group: 5 },
    { emoji: "🚬", group: 5 },
    { emoji: "⚰️", group: 5 },
    { emoji: "⚱️", group: 5 },
    { emoji: "🗿", group: 5 },
    { emoji: "🛢️", group: 5 },
    { emoji: "🔮", group: 5 },
    { emoji: "🛒", group: 5 },
    { emoji: "🏧", group: 6 },
    { emoji: "🚮", group: 6 },
    { emoji: "🚰", group: 6 },
    { emoji: "♿️", group: 6 },
    { emoji: "🚹️", group: 6 },
    { emoji: "🚺️", group: 6 },
    { emoji: "🚻", group: 6 },
    { emoji: "🚼️", group: 6 },
    { emoji: "🚾", group: 6 },
    { emoji: "🛂", group: 6 },
    { emoji: "🛃", group: 6 },
    { emoji: "🛄", group: 6 },
    { emoji: "🛅", group: 6 },
    { emoji: "⚠️", group: 6 },
    { emoji: "🚸", group: 6 },
    { emoji: "⛔️", group: 6 },
    { emoji: "🚫", group: 6 },
    { emoji: "🚳", group: 6 },
    { emoji: "🚭️", group: 6 },
    { emoji: "🚯", group: 6 },
    { emoji: "🚱", group: 6 },
    { emoji: "🚷", group: 6 },
    { emoji: "📵", group: 6 },
    { emoji: "🔞", group: 6 },
    { emoji: "☢️", group: 6 },
    { emoji: "☣️", group: 6 },
    { emoji: "⬆️", group: 6 },
    { emoji: "↗️", group: 6 },
    { emoji: "➡️", group: 6 },
    { emoji: "↘️", group: 6 },
    { emoji: "⬇️", group: 6 },
    { emoji: "↙️", group: 6 },
    { emoji: "⬅️", group: 6 },
    { emoji: "↖️", group: 6 },
    { emoji: "↕️", group: 6 },
    { emoji: "↔️", group: 6 },
    { emoji: "↩️", group: 6 },
    { emoji: "↪️", group: 6 },
    { emoji: "⤴️", group: 6 },
    { emoji: "⤵️", group: 6 },
    { emoji: "🔃", group: 6 },
    { emoji: "🔄", group: 6 },
    { emoji: "🔙", group: 6 },
    { emoji: "🔚", group: 6 },
    { emoji: "🔛", group: 6 },
    { emoji: "🔜", group: 6 },
    { emoji: "🔝", group: 6 },
    { emoji: "🛐", group: 6 },
    { emoji: "⚛️", group: 6 },
    { emoji: "🕉️", group: 6 },
    { emoji: "✡️", group: 6 },
    { emoji: "☸️", group: 6 },
    { emoji: "☯️", group: 6 },
    { emoji: "✝️", group: 6 },
    { emoji: "☦️", group: 6 },
    { emoji: "☪️", group: 6 },
    { emoji: "☮️", group: 6 },
    { emoji: "🕎", group: 6 },
    { emoji: "🔯", group: 6 },
    { emoji: "♈️", group: 6 },
    { emoji: "♉️", group: 6 },
    { emoji: "♊️", group: 6 },
    { emoji: "♋️", group: 6 },
    { emoji: "♌️", group: 6 },
    { emoji: "♍️", group: 6 },
    { emoji: "♎️", group: 6 },
    { emoji: "♏️", group: 6 },
    { emoji: "♐️", group: 6 },
    { emoji: "♑️", group: 6 },
    { emoji: "♒️", group: 6 },
    { emoji: "♓️", group: 6 },
    { emoji: "⛎", group: 6 },
    { emoji: "🔀", group: 6 },
    { emoji: "🔁", group: 6 },
    { emoji: "🔂", group: 6 },
    { emoji: "▶️", group: 6 },
    { emoji: "⏩️", group: 6 },
    { emoji: "⏭️", group: 6 },
    { emoji: "⏯️", group: 6 },
    { emoji: "◀️", group: 6 },
    { emoji: "⏪️", group: 6 },
    { emoji: "⏮️", group: 6 },
    { emoji: "🔼", group: 6 },
    { emoji: "⏫", group: 6 },
    { emoji: "🔽", group: 6 },
    { emoji: "⏬", group: 6 },
    { emoji: "⏸️", group: 6 },
    { emoji: "⏹️", group: 6 },
    { emoji: "⏺️", group: 6 },
    { emoji: "⏏️", group: 6 },
    { emoji: "🎦", group: 6 },
    { emoji: "🔅", group: 6 },
    { emoji: "🔆", group: 6 },
    { emoji: "📶", group: 6 },
    { emoji: "📳", group: 6 },
    { emoji: "📴", group: 6 },
    { emoji: "♀️", group: 6 },
    { emoji: "♂️", group: 6 },
    { emoji: "⚕️", group: 6 },
    { emoji: "♻️", group: 6 },
    { emoji: "⚜️", group: 6 },
    { emoji: "🔱", group: 6 },
    { emoji: "📛", group: 6 },
    { emoji: "🔰", group: 6 },
    { emoji: "⭕️", group: 6 },
    { emoji: "✅", group: 6 },
    { emoji: "☑️", group: 6 },
    { emoji: "✔️", group: 6 },
    { emoji: "✖️", group: 6 },
    { emoji: "❌", group: 6 },
    { emoji: "❎", group: 6 },
    { emoji: "➕", group: 6 },
    { emoji: "➖", group: 6 },
    { emoji: "➗", group: 6 },
    { emoji: "➰", group: 6 },
    { emoji: "➿", group: 6 },
    { emoji: "〽️", group: 6 },
    { emoji: "✳️", group: 6 },
    { emoji: "✴️", group: 6 },
    { emoji: "❇️", group: 6 },
    { emoji: "‼️", group: 6 },
    { emoji: "⁉️", group: 6 },
    { emoji: "❓️", group: 6 },
    { emoji: "❔", group: 6 },
    { emoji: "❕", group: 6 },
    { emoji: "❗️", group: 6 },
    { emoji: "〰️", group: 6 },
    { emoji: "©️", group: 6 },
    { emoji: "®️", group: 6 },
    { emoji: "™️", group: 6 },
    { emoji: "#️⃣", group: 6 },
    { emoji: "*️⃣", group: 6 },
    { emoji: "0️⃣", group: 6 },
    { emoji: "1️⃣", group: 6 },
    { emoji: "2️⃣", group: 6 },
    { emoji: "3️⃣", group: 6 },
    { emoji: "4️⃣", group: 6 },
    { emoji: "5️⃣", group: 6 },
    { emoji: "6️⃣", group: 6 },
    { emoji: "7️⃣", group: 6 },
    { emoji: "8️⃣", group: 6 },
    { emoji: "9️⃣", group: 6 },
    { emoji: "🔟", group: 6 },
    { emoji: "💯", group: 6 },
    { emoji: "🔠", group: 6 },
    { emoji: "🔡", group: 6 },
    { emoji: "🔢", group: 6 },
    { emoji: "🔣", group: 6 },
    { emoji: "🔤", group: 6 },
    { emoji: "🅰️", group: 6 },
    { emoji: "🆎", group: 6 },
    { emoji: "🅱️", group: 6 },
    { emoji: "🆑", group: 6 },
    { emoji: "🆒", group: 6 },
    { emoji: "🆓", group: 6 },
    { emoji: "ℹ️", group: 6 },
    { emoji: "🆔", group: 6 },
    { emoji: "Ⓜ️", group: 6 },
    { emoji: "🆕", group: 6 },
    { emoji: "🆖", group: 6 },
    { emoji: "🅾️", group: 6 },
    { emoji: "🆗", group: 6 },
    { emoji: "🅿️", group: 6 },
    { emoji: "🆘", group: 6 },
    { emoji: "🆙", group: 6 },
    { emoji: "🆚", group: 6 },
    { emoji: "🈁", group: 6 },
    { emoji: "🈂️", group: 6 },
    { emoji: "🈷️", group: 6 },
    { emoji: "🈶", group: 6 },
    { emoji: "🈯️", group: 6 },
    { emoji: "🉐", group: 6 },
    { emoji: "🈹", group: 6 },
    { emoji: "🈚️", group: 6 },
    { emoji: "🈲", group: 6 },
    { emoji: "🉑", group: 6 },
    { emoji: "🈸", group: 6 },
    { emoji: "🈴", group: 6 },
    { emoji: "🈳", group: 6 },
    { emoji: "㊗️", group: 6 },
    { emoji: "㊙️", group: 6 },
    { emoji: "🈺", group: 6 },
    { emoji: "🈵", group: 6 },
    { emoji: "▪️", group: 6 },
    { emoji: "▫️", group: 6 },
    { emoji: "◻️", group: 6 },
    { emoji: "◼️", group: 6 },
    { emoji: "◽️", group: 6 },
    { emoji: "◾️", group: 6 },
    { emoji: "⬛️", group: 6 },
    { emoji: "⬜️", group: 6 },
    { emoji: "🔶", group: 6 },
    { emoji: "🔷", group: 6 },
    { emoji: "🔸", group: 6 },
    { emoji: "🔹", group: 6 },
    { emoji: "🔺", group: 6 },
    { emoji: "🔻", group: 6 },
    { emoji: "💠", group: 6 },
    { emoji: "🔘", group: 6 },
    { emoji: "🔲", group: 6 },
    { emoji: "🔳", group: 6 },
    { emoji: "⚪️", group: 6 },
    { emoji: "⚫️", group: 6 },
    { emoji: "🔴", group: 6 },
    { emoji: "🔵", group: 6 },
    { emoji: "🏁", group: 7 },
    { emoji: "🚩", group: 7 },
    { emoji: "🎌", group: 7 },
    { emoji: "🏴", group: 7 },
    { emoji: "🏳️", group: 7 },
    { emoji: "🏳️‍🌈", group: 7 },
    { emoji: "🇦🇨", group: 7 },
    { emoji: "🇦🇩", group: 7 },
    { emoji: "🇦🇪", group: 7 },
    { emoji: "🇦🇫", group: 7 },
    { emoji: "🇦🇬", group: 7 },
    { emoji: "🇦🇮", group: 7 },
    { emoji: "🇦🇱", group: 7 },
    { emoji: "🇦🇲", group: 7 },
    { emoji: "🇦🇴", group: 7 },
    { emoji: "🇦🇶", group: 7 },
    { emoji: "🇦🇷", group: 7 },
    { emoji: "🇦🇸", group: 7 },
    { emoji: "🇦🇹", group: 7 },
    { emoji: "🇦🇺", group: 7 },
    { emoji: "🇦🇼", group: 7 },
    { emoji: "🇦🇽", group: 7 },
    { emoji: "🇦🇿", group: 7 },
    { emoji: "🇧🇦", group: 7 },
    { emoji: "🇧🇧", group: 7 },
    { emoji: "🇧🇩", group: 7 },
    { emoji: "🇧🇪", group: 7 },
    { emoji: "🇧🇫", group: 7 },
    { emoji: "🇧🇬", group: 7 },
    { emoji: "🇧🇭", group: 7 },
    { emoji: "🇧🇮", group: 7 },
    { emoji: "🇧🇯", group: 7 },
    { emoji: "🇧🇱", group: 7 },
    { emoji: "🇧🇲", group: 7 },
    { emoji: "🇧🇳", group: 7 },
    { emoji: "🇧🇴", group: 7 },
    { emoji: "🇧🇶", group: 7 },
    { emoji: "🇧🇷", group: 7 },
    { emoji: "🇧🇸", group: 7 },
    { emoji: "🇧🇹", group: 7 },
    { emoji: "🇧🇻", group: 7 },
    { emoji: "🇧🇼", group: 7 },
    { emoji: "🇧🇾", group: 7 },
    { emoji: "🇧🇿", group: 7 },
    { emoji: "🇨🇦", group: 7 },
    { emoji: "🇨🇨", group: 7 },
    { emoji: "🇨🇩", group: 7 },
    { emoji: "🇨🇫", group: 7 },
    { emoji: "🇨🇬", group: 7 },
    { emoji: "🇨🇭", group: 7 },
    { emoji: "🇨🇮", group: 7 },
    { emoji: "🇨🇰", group: 7 },
    { emoji: "🇨🇱", group: 7 },
    { emoji: "🇨🇲", group: 7 },
    { emoji: "🇨🇳", group: 7 },
    { emoji: "🇨🇴", group: 7 },
    { emoji: "🇨🇵", group: 7 },
    { emoji: "🇨🇷", group: 7 },
    { emoji: "🇨🇺", group: 7 },
    { emoji: "🇨🇻", group: 7 },
    { emoji: "🇨🇼", group: 7 },
    { emoji: "🇨🇽", group: 7 },
    { emoji: "🇨🇾", group: 7 },
    { emoji: "🇨🇿", group: 7 },
    { emoji: "🇩🇪", group: 7 },
    { emoji: "🇩🇬", group: 7 },
    { emoji: "🇩🇯", group: 7 },
    { emoji: "🇩🇰", group: 7 },
    { emoji: "🇩🇲", group: 7 },
    { emoji: "🇩🇴", group: 7 },
    { emoji: "🇩🇿", group: 7 },
    { emoji: "🇪🇦", group: 7 },
    { emoji: "🇪🇨", group: 7 },
    { emoji: "🇪🇪", group: 7 },
    { emoji: "🇪🇬", group: 7 },
    { emoji: "🇪🇭", group: 7 },
    { emoji: "🇪🇷", group: 7 },
    { emoji: "🇪🇸", group: 7 },
    { emoji: "🇪🇹", group: 7 },
    { emoji: "🇪🇺", group: 7 },
    { emoji: "🇫🇮", group: 7 },
    { emoji: "🇫🇯", group: 7 },
    { emoji: "🇫🇰", group: 7 },
    { emoji: "🇫🇲", group: 7 },
    { emoji: "🇫🇴", group: 7 },
    { emoji: "🇫🇷", group: 7 },
    { emoji: "🇬🇦", group: 7 },
    { emoji: "🇬🇧", group: 7 },
    { emoji: "🇬🇩", group: 7 },
    { emoji: "🇬🇪", group: 7 },
    { emoji: "🇬🇫", group: 7 },
    { emoji: "🇬🇬", group: 7 },
    { emoji: "🇬🇭", group: 7 },
    { emoji: "🇬🇮", group: 7 },
    { emoji: "🇬🇱", group: 7 },
    { emoji: "🇬🇲", group: 7 },
    { emoji: "🇬🇳", group: 7 },
    { emoji: "🇬🇵", group: 7 },
    { emoji: "🇬🇶", group: 7 },
    { emoji: "🇬🇷", group: 7 },
    { emoji: "🇬🇸", group: 7 },
    { emoji: "🇬🇹", group: 7 },
    { emoji: "🇬🇺", group: 7 },
    { emoji: "🇬🇼", group: 7 },
    { emoji: "🇬🇾", group: 7 },
    { emoji: "🇭🇰", group: 7 },
    { emoji: "🇭🇲", group: 7 },
    { emoji: "🇭🇳", group: 7 },
    { emoji: "🇭🇷", group: 7 },
    { emoji: "🇭🇹", group: 7 },
    { emoji: "🇭🇺", group: 7 },
    { emoji: "🇮🇨", group: 7 },
    { emoji: "🇮🇩", group: 7 },
    { emoji: "🇮🇪", group: 7 },
    { emoji: "🇮🇱", group: 7 },
    { emoji: "🇮🇲", group: 7 },
    { emoji: "🇮🇳", group: 7 },
    { emoji: "🇮🇴", group: 7 },
    { emoji: "🇮🇶", group: 7 },
    { emoji: "🇮🇷", group: 7 },
    { emoji: "🇮🇸", group: 7 },
    { emoji: "🇮🇹", group: 7 },
    { emoji: "🇯🇪", group: 7 },
    { emoji: "🇯🇲", group: 7 },
    { emoji: "🇯🇴", group: 7 },
    { emoji: "🇯🇵", group: 7 },
    { emoji: "🇰🇪", group: 7 },
    { emoji: "🇰🇬", group: 7 },
    { emoji: "🇰🇭", group: 7 },
    { emoji: "🇰🇮", group: 7 },
    { emoji: "🇰🇲", group: 7 },
    { emoji: "🇰🇳", group: 7 },
    { emoji: "🇰🇵", group: 7 },
    { emoji: "🇰🇷", group: 7 },
    { emoji: "🇰🇼", group: 7 },
    { emoji: "🇰🇾", group: 7 },
    { emoji: "🇰🇿", group: 7 },
    { emoji: "🇱🇦", group: 7 },
    { emoji: "🇱🇧", group: 7 },
    { emoji: "🇱🇨", group: 7 },
    { emoji: "🇱🇮", group: 7 },
    { emoji: "🇱🇰", group: 7 },
    { emoji: "🇱🇷", group: 7 },
    { emoji: "🇱🇸", group: 7 },
    { emoji: "🇱🇹", group: 7 },
    { emoji: "🇱🇺", group: 7 },
    { emoji: "🇱🇻", group: 7 },
    { emoji: "🇱🇾", group: 7 },
    { emoji: "🇲🇦", group: 7 },
    { emoji: "🇲🇨", group: 7 },
    { emoji: "🇲🇩", group: 7 },
    { emoji: "🇲🇪", group: 7 },
    { emoji: "🇲🇫", group: 7 },
    { emoji: "🇲🇬", group: 7 },
    { emoji: "🇲🇭", group: 7 },
    { emoji: "🇲🇰", group: 7 },
    { emoji: "🇲🇱", group: 7 },
    { emoji: "🇲🇲", group: 7 },
    { emoji: "🇲🇳", group: 7 },
    { emoji: "🇲🇴", group: 7 },
    { emoji: "🇲🇵", group: 7 },
    { emoji: "🇲🇶", group: 7 },
    { emoji: "🇲🇷", group: 7 },
    { emoji: "🇲🇸", group: 7 },
    { emoji: "🇲🇹", group: 7 },
    { emoji: "🇲🇺", group: 7 },
    { emoji: "🇲🇻", group: 7 },
    { emoji: "🇲🇼", group: 7 },
    { emoji: "🇲🇽", group: 7 },
    { emoji: "🇲🇾", group: 7 },
    { emoji: "🇲🇿", group: 7 },
    { emoji: "🇳🇦", group: 7 },
    { emoji: "🇳🇨", group: 7 },
    { emoji: "🇳🇪", group: 7 },
    { emoji: "🇳🇫", group: 7 },
    { emoji: "🇳🇬", group: 7 },
    { emoji: "🇳🇮", group: 7 },
    { emoji: "🇳🇱", group: 7 },
    { emoji: "🇳🇴", group: 7 },
    { emoji: "🇳🇵", group: 7 },
    { emoji: "🇳🇷", group: 7 },
    { emoji: "🇳🇺", group: 7 },
    { emoji: "🇳🇿", group: 7 },
    { emoji: "🇴🇲", group: 7 },
    { emoji: "🇵🇦", group: 7 },
    { emoji: "🇵🇪", group: 7 },
    { emoji: "🇵🇫", group: 7 },
    { emoji: "🇵🇬", group: 7 },
    { emoji: "🇵🇭", group: 7 },
    { emoji: "🇵🇰", group: 7 },
    { emoji: "🇵🇱", group: 7 },
    { emoji: "🇵🇲", group: 7 },
    { emoji: "🇵🇳", group: 7 },
    { emoji: "🇵🇷", group: 7 },
    { emoji: "🇵🇸", group: 7 },
    { emoji: "🇵🇹", group: 7 },
    { emoji: "🇵🇼", group: 7 },
    { emoji: "🇵🇾", group: 7 },
    { emoji: "🇶🇦", group: 7 },
    { emoji: "🇷🇪", group: 7 },
    { emoji: "🇷🇴", group: 7 },
    { emoji: "🇷🇸", group: 7 },
    { emoji: "🇷🇺", group: 7 },
    { emoji: "🇷🇼", group: 7 },
    { emoji: "🇸🇦", group: 7 },
    { emoji: "🇸🇧", group: 7 },
    { emoji: "🇸🇨", group: 7 },
    { emoji: "🇸🇩", group: 7 },
    { emoji: "🇸🇪", group: 7 },
    { emoji: "🇸🇬", group: 7 },
    { emoji: "🇸🇭", group: 7 },
    { emoji: "🇸🇮", group: 7 },
    { emoji: "🇸🇯", group: 7 },
    { emoji: "🇸🇰", group: 7 },
    { emoji: "🇸🇱", group: 7 },
    { emoji: "🇸🇲", group: 7 },
    { emoji: "🇸🇳", group: 7 },
    { emoji: "🇸🇴", group: 7 },
    { emoji: "🇸🇷", group: 7 },
    { emoji: "🇸🇸", group: 7 },
    { emoji: "🇸🇹", group: 7 },
    { emoji: "🇸🇻", group: 7 },
    { emoji: "🇸🇽", group: 7 },
    { emoji: "🇸🇾", group: 7 },
    { emoji: "🇸🇿", group: 7 },
    { emoji: "🇹🇦", group: 7 },
    { emoji: "🇹🇨", group: 7 },
    { emoji: "🇹🇩", group: 7 },
    { emoji: "🇹🇫", group: 7 },
    { emoji: "🇹🇬", group: 7 },
    { emoji: "🇹🇭", group: 7 },
    { emoji: "🇹🇯", group: 7 },
    { emoji: "🇹🇰", group: 7 },
    { emoji: "🇹🇱", group: 7 },
    { emoji: "🇹🇲", group: 7 },
    { emoji: "🇹🇳", group: 7 },
    { emoji: "🇹🇴", group: 7 },
    { emoji: "🇹🇷", group: 7 },
    { emoji: "🇹🇹", group: 7 },
    { emoji: "🇹🇻", group: 7 },
    { emoji: "🇹🇼", group: 7 },
    { emoji: "🇹🇿", group: 7 },
    { emoji: "🇺🇦", group: 7 },
    { emoji: "🇺🇬", group: 7 },
    { emoji: "🇺🇲", group: 7 },
    { emoji: "🇺🇳", group: 7 },
    { emoji: "🇺🇸", group: 7 },
    { emoji: "🇺🇾", group: 7 },
    { emoji: "🇺🇿", group: 7 },
    { emoji: "🇻🇦", group: 7 },
    { emoji: "🇻🇨", group: 7 },
    { emoji: "🇻🇪", group: 7 },
    { emoji: "🇻🇬", group: 7 },
    { emoji: "🇻🇮", group: 7 },
    { emoji: "🇻🇳", group: 7 },
    { emoji: "🇻🇺", group: 7 },
    { emoji: "🇼🇫", group: 7 },
    { emoji: "🇼🇸", group: 7 },
    { emoji: "🇽🇰", group: 7 },
    { emoji: "🇾🇪", group: 7 },
    { emoji: "🇾🇹", group: 7 },
    { emoji: "🇿🇦", group: 7 },
    { emoji: "🇿🇲", group: 7 },
    { emoji: "🇿🇼", group: 7 },
    { emoji: "🏴󠁧󠁢󠁥󠁮󠁧󠁿", group: 7 },
    { emoji: "🏴󠁧󠁢󠁳󠁣󠁴󠁿", group: 7 },
    { emoji: "🏴󠁧󠁢󠁷󠁬󠁳󠁿", group: 7 },
];
