/**
 * @copyright 2009-2019 Vanilla Forums Inc.
 * @license GPL-2.0-only
 */

import React from "react";

import classNames from "classnames";
import { iconClasses } from "@library/icons/iconStyles";

interface IProps extends React.HTMLAttributes<HTMLOrSVGElement> {}

export function SwaggerIcon(props: IProps) {
    const classes = iconClasses();
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            {...props}
            className={classNames(classes.standard, props.className)}
            viewBox="0 0 48 48"
        >
            <g fill="none" fillRule="evenodd" stroke="none" strokeWidth="1">
                <g fill="currentColor" fillRule="nonzero" transform="translate(4 3.181)">
                    <path
                        d="M21.45 28.941l5.05 8.381.183.305.182.304-.035.021-.034.02-.012.008-.003.002h-.003l-.004.004-.003.001-.107.061-.108.06c-.103.06-.206.118-.31.175l-.26.146-.45.229a17.728 17.728 0 01-3.783 1.35l-.055.013c-.1.023-.2.044-.3.065l-.179.038-.175.034-.307.056-.05.007-.582.088c-.778.104-1.562.156-2.347.156h-.082c-.117-.001-.235-.002-.35-.005-.082-.002-.163-.006-.244-.009-.062-.002-.124-.003-.187-.007a14.77 14.77 0 01-.305-.018l-.119-.007a14.667 14.667 0 01-.348-.03l-.07-.005-.284-.031-.151-.017-.144-.019a17.772 17.772 0 01-3.6-.862l-.085-.032-.085-.033c-.111-.04-.222-.084-.332-.127-.089-.034-.177-.065-.265-.101l-.007-.003h-.001l-.016-.006-.015-.006-.03-.011.002-.002.124-.303.146-.355 3.724-9.042c.11.046.223.08.336.12.112.04.222.084.336.118a7.15 7.15 0 005.433-.558c.104-.056.209-.111.311-.173zm-10.808-5.414c.082.807.303 1.602.657 2.348l-.033.02-8.982 5.411-.04-.07-.01-.017a17.223 17.223 0 01-.183-.349l-.025-.048a17.657 17.657 0 01-.158-.319l-.043-.09a20.025 20.025 0 01-.131-.28l-.063-.139c-.034-.078-.069-.155-.102-.234l-.08-.192-.077-.185-.096-.245-.05-.135c-.038-.1-.074-.198-.109-.298l-.03-.087c-.04-.115-.079-.23-.116-.344l-.007-.022a15.412 15.412 0 01-.126-.406c0-.004-.002-.007-.003-.01a17.573 17.573 0 01-.598-2.897l-.025-.226-.02-.19-.007-.077c-.01-.113-.02-.227-.028-.342-.004-.042-.005-.084-.008-.126L.13 23.68c-.003-.051-.004-.103-.006-.154zm-2.59-15.45l5.409 8.98.018.03a7.349 7.349 0 00-.248.193l-.03-.03-7.408-7.408a16.422 16.422 0 012.258-1.764z"
                        opacity="0.4"
                    />
                    <path
                        d="M13.227 28.355c.367.3.757.558 1.164.776l-.014.034-3.726 9.048-.263.638-.412-.193-.407-.205-.04-.021a22.696 22.696 0 01-.449-.246l-.167-.095a21.096 21.096 0 01-.273-.161l-.05-.03a17.806 17.806 0 01-1.716-1.19l-.037-.03a16.837 16.837 0 01-.29-.233l-.068-.056c-.084-.071-.169-.142-.253-.215l-.108-.095-.21-.186-.114-.107 7.408-7.408zm9.062-.004l.03.03 7.408 7.408c-.488.45-.995.869-1.518 1.255-.242.177-.49.346-.74.51l-5.41-8.98-.018-.03c.084-.063.167-.127.248-.193zM5.28 10.335l7.42 7.42c-.085.084-.16.175-.239.263-.08.088-.164.174-.24.265a7.121 7.121 0 00-1.581 3.82c-.012.119-.014.238-.02.357-.006.118-.017.237-.017.355H.11c0-.118.003-.237.006-.355l.004-.178.005-.178A17.606 17.606 0 013.224 12.8l.064-.093a17.7 17.7 0 011.5-1.858l.245-.257c.083-.085.162-.173.247-.257zm26.995 2.433c.363.523.698 1.067 1.004 1.63l.007.012c.063.116.124.234.185.352l.023.044.16.323.04.086c.046.094.09.189.133.283l.06.135.106.239.078.187.077.19.048.12.047.121a9.346 9.346 0 01.16.432 23.76 23.76 0 01.147.431c.004.017.01.034.015.05l.117.378.005.016c.24.815.421 1.644.542 2.48l.002.013c.019.133.036.267.053.4a.855.855 0 00.005.044c.014.124.028.248.04.371l.007.086c.01.111.02.222.028.333l.009.141.017.283.006.156H24.877a7.295 7.295 0 00-.346-1.593zM18.472 5.181l.154.006c.097.004.195.011.292.018l.132.008c.113.008.226.018.339.028l.08.007.285.031.147.017.148.02a17.71 17.71 0 015.901 1.863l.045.023c.095.05.19.102.285.154l.164.091.163.092.278.166.044.026c.298.181.59.375.876.574l-7.74 7.74a7.29 7.29 0 00-1.593-.346v-.041z"
                        opacity="0.8"
                    />
                    <path
                        d="M11.635 26.506a7.638 7.638 0 00.397.59l.095.126.097.123c.075.092.151.183.231.272l.12.131.124.13-7.419 7.418-.375-.387-.223-.241-.281-.318-.271-.321-.263-.326-.24-.313-.244-.336-.313-.456-.218-.334-.21-.34 8.993-5.418zm13.283-3.691h10.491l-.016.712a17.607 17.607 0 01-2.485 8.352l-.317.508-.14.216-.216.315a17.714 17.714 0 01-1.503 1.863l-.491.515-7.42-7.42c.085-.084.16-.175.24-.263.08-.088.164-.173.238-.264a7.124 7.124 0 001.582-3.822c.012-.118.014-.237.02-.356l.01-.178.007-.178zM17.76 5.165v10.492l-.178.004-.178.009a7.135 7.135 0 00-3.023.847l-.156.084-.155.089-5.416-8.991.193-.113.685-.385.45-.228a17.755 17.755 0 013.295-1.23l.544-.133.48-.104.53-.097a17.74 17.74 0 012.218-.229l.533-.012.178-.003z"
                        opacity="0.6"
                    />
                    <path
                        d="M38.526 2.049a4.913 4.913 0 00-7.877 5.658L19.944 18.414a4.915 4.915 0 101.293 7.877 4.914 4.914 0 00.925-5.659L32.868 9.925a4.914 4.914 0 005.658-7.876z"
                        opacity="0.85"
                    />
                </g>
            </g>
        </svg>
    );
}
