<?php if (!defined('APPLICATION')) exit();
$Session = Gdn::session();
$Alt = false;
$SubjectsVisible = c('Conversations.Subjects.Visible');

foreach ($this->data('Conversations') as $Conversation) {
    $Conversation = (object)$Conversation;
    $Alt = !$Alt;


    // Figure out the last photo.
    $LastPhoto = '';
    if (empty($Conversation->Participants)) {
        $User = Gdn::userModel()->getID($Conversation->LastInsertUserID);
        $LastPhoto = userPhoto($User);
    } else {
        foreach ($Conversation->Participants as $User) {
            if ($User['UserID'] == $Conversation->LastInsertUserID) {
                $LastPhoto = userPhoto($User);
                if ($LastPhoto)
                    break;
            } elseif (!$LastPhoto) {
                $LastPhoto = userPhoto($User);
            }
        }
    }

    $CssClass = 'Item';
    $CssClass .= $Alt ? ' Alt' : '';
    $CssClass .= $Conversation->CountNewMessages > 0 ? ' New' : '';
    $CssClass .= $LastPhoto != '' ? ' HasPhoto' : '';
    $CssClass .= ' '.($Conversation->CountNewMessages <= 0 ? 'Read' : 'Unread');

    $JumpToItem = $Conversation->CountMessages - $Conversation->CountNewMessages;

    if (stringIsNullOrEmpty(trim($Conversation->LastBody))) {
        $Message = t('Blank Message');
    } else {
        $Message = (sliceString(Gdn::formatService()->renderExcerpt($Conversation->LastBody, $Conversation->LastFormat), 100));
    }

    $this->EventArguments['Conversation'] = $Conversation;
    ?>
    <li class="<?php echo $CssClass; ?> pageBox">
        <?php
        $Names = ConversationModel::participantTitle($Conversation, false);
        ?>
        <div class="ItemContent Conversation">
            <?php
            $Url = '/messages/'.$Conversation->ConversationID.'/#Item_'.$JumpToItem;

            echo '<h3 aria-level="2" class="Users Title">';

            if ($Names) {
                if ($LastPhoto) {
                    echo '<div class="Author Photo">'.$LastPhoto.'</div>';
                }

                echo anchor(htmlspecialchars($Names), $Url);
            }
            if ($Subject = val('Subject', $Conversation)) {
                if ($Names) {
                    echo bullet(' ');
                }
                echo '<span class="Subject">'.anchor(htmlspecialchars($Subject), $Url).'</span>';
            }

            echo '</h3>';
            ?>
            <div class="Excerpt"><?php echo anchor(htmlspecialchars($Message), $Url, 'Message'); ?></div>
            <div class="Meta">
                <?php
                $this->fireEvent('BeforeConversationMeta');

                echo ' <span class="MItem CountMessages">'.sprintf(plural($Conversation->CountMessages, '%s message', '%s messages'), $Conversation->CountMessages).'</span> ';

                if ($Conversation->CountNewMessages > 0) {
                    echo ' <strong class="HasNew"> '.plural($Conversation->CountNewMessages, '%s new', '%s new').'</strong> ';
                }

                echo ' <span class="MItem LastDateInserted">'.Gdn_Format::date($Conversation->LastDateInserted).'</span> ';
                ?>
            </div>
        </div>
    </li>
<?php
}
