<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('zh_CN', array (
  'validators' => 
  array (
    'This value should be false.' => '该变量的值应为 false 。',
    'This value should be true.' => '该变量的值应为 true 。',
    'This value should be of type {{ type }}.' => '该变量的类型应为 {{ type }} 。',
    'This value should be blank.' => '该变量值应为空。',
    'The value you selected is not a valid choice.' => '选定变量的值不是有效的选项。',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => '您至少要选择 {{ limit }} 个选项。',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => '您最多能选择 {{ limit }} 个选项。',
    'One or more of the given values is invalid.' => '一个或者多个给定的值无效。',
    'This field was not expected.' => '此字段是多余的。',
    'This field is missing.' => '此字段缺失。',
    'This value is not a valid date.' => '该值不是一个有效的日期（date）。',
    'This value is not a valid datetime.' => '该值不是一个有效的日期时间（datetime）。',
    'This value is not a valid email address.' => '该值不是一个有效的邮件地址。',
    'The file could not be found.' => '文件未找到。',
    'The file is not readable.' => '文件不可读。',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => '文件太大 ({{ size }} {{ suffix }})。文件大小不可以超过 {{ limit }} {{ suffix }} 。',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => '无效的文件类型 ({{ type }}) 。允许的文件类型有 {{ types }} 。',
    'This value should be {{ limit }} or less.' => '这个变量的值应该小于或等于 {{ limit }}。',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => '字符串太长，长度不可超过 {{ limit }} 个字符。',
    'This value should be {{ limit }} or more.' => '该变量的值应该大于或等于 {{ limit }}。',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => '字符串太短，长度不可少于 {{ limit }} 个字符。',
    'This value should not be blank.' => '该变量不应为空。',
    'This value should not be null.' => '该变量不应为 null 。',
    'This value should be null.' => '该变量应为空 null 。',
    'This value is not valid.' => '该变量值无效 。',
    'This value is not a valid time.' => '该值不是一个有效的时间。',
    'This value is not a valid URL.' => '该值不是一个有效的 URL 。',
    'The two values should be equal.' => '这两个变量的值应该相等。',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => '文件太大，文件大小不可以超过 {{ limit }} {{ suffix }}。 ',
    'The file is too large.' => '文件太大。',
    'The file could not be uploaded.' => '无法上传此文件。',
    'This value should be a valid number.' => '该值应该为有效的数字。',
    'This file is not a valid image.' => '该文件不是有效的图片。',
    'This is not a valid IP address.' => '该值不是有效的IP地址。',
    'This value is not a valid language.' => '该值不是有效的语言名。',
    'This value is not a valid locale.' => '该值不是有效的区域值（locale）。',
    'This value is not a valid country.' => '该值不是有效的国家名。',
    'This value is already used.' => '该值已经被使用。',
    'The size of the image could not be detected.' => '不能解析图片大小。',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => '图片太宽 ({{ width }}px)，最大宽度为 {{ max_width }}px 。',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => '图片宽度不够 ({{ width }}px)，最小宽度为 {{ min_width }}px 。',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => '图片太高 ({{ height }}px)，最大高度为 {{ max_height }}px 。',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => '图片高度不够 ({{ height }}px)，最小高度为 {{ min_height }}px 。',
    'This value should be the user\'s current password.' => '该变量的值应为用户当前的密码。',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => '该变量应为 {{ limit }} 个字符。',
    'The file was only partially uploaded.' => '该文件的上传不完整。',
    'No file was uploaded.' => '没有上传任何文件。',
    'No temporary folder was configured in php.ini.' => 'php.ini 里没有配置临时文件目录。',
    'Cannot write temporary file to disk.' => '临时文件写入磁盘失败。',
    'A PHP extension caused the upload to fail.' => '某个 PHP 扩展造成上传失败。',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => '该集合最少应包含 {{ limit }} 个元素。',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => '该集合最多包含 {{ limit }} 个元素。',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => '该集合应包含 {{ limit }} 个元素 element 。',
    'Invalid card number.' => '无效的信用卡号。',
    'Unsupported card type or invalid card number.' => '不支持的信用卡类型或无效的信用卡号。',
    'This is not a valid International Bank Account Number (IBAN).' => '该值不是有效的国际银行帐号（IBAN）。',
    'This value is not a valid ISBN-10.' => '该值不是有效的10位国际标准书号（ISBN-10）。',
    'This value is not a valid ISBN-13.' => '该值不是有效的13位国际标准书号（ISBN-13）。',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => '该值不是有效的国际标准书号（ISBN-10 或 ISBN-13）。',
    'This value is not a valid ISSN.' => '该值不是有效的国际标准期刊号（ISSN）。',
    'This value is not a valid currency.' => '该值不是有效的货币名（currency）。',
    'This value should be equal to {{ compared_value }}.' => '该值应等于 {{ compared_value }} 。',
    'This value should be greater than {{ compared_value }}.' => '该值应大于 {{ compared_value }} 。',
    'This value should be greater than or equal to {{ compared_value }}.' => '该值应大于或等于 {{ compared_value }} 。',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => '该值应与 {{ compared_value_type }} {{ compared_value }} 相同。',
    'This value should be less than {{ compared_value }}.' => '该值应小于 {{ compared_value }} 。',
    'This value should be less than or equal to {{ compared_value }}.' => '该值应小于或等于 {{ compared_value }} 。',
    'This value should not be equal to {{ compared_value }}.' => '该值不应先等于 {{ compared_value }} 。',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => '该值不应与 {{ compared_value_type }} {{ compared_value }} 相同。',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => '图片宽高比太大 ({{ ratio }})。允许的最大宽高比为 {{ max_ratio }}。',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => '图片宽高比太小 ({{ ratio }})。允许的最大宽高比为 {{ min_ratio }}。',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => '图片是方形的 ({{ width }}x{{ height }}px)。不允许使用方形的图片。',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => '图片是横向的 ({{ width }}x{{ height }}px)。不允许使用横向的图片。',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => '图片是纵向的 ({{ width }}x{{ height }}px)。不允许使用纵向的图片。',
    'An empty file is not allowed.' => '不允许使用空文件。',
    'The host could not be resolved.' => '主机名无法解析。',
    'This value does not match the expected {{ charset }} charset.' => '该值不符合 {{ charset }} 编码。',
    'This is not a valid Business Identifier Code (BIC).' => '这不是有效的业务标识符代码（BIC)。',
    'Error' => '错误',
    'This is not a valid UUID.' => '这不是有效的UUID。',
    'This value should be a multiple of {{ compared_value }}.' => '此值应为 {{ compared_value }} 的倍数。',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => '此业务标识符代码（BIC）与IBAN {{ iban }} 无关。',
    'This value should be valid JSON.' => '该值应该是有效的JSON。',
    'This collection should contain only unique elements.' => '该集合应仅包含独一无二的元素。',
    'This value should be positive.' => '数值应为正数。',
    'This value should be either positive or zero.' => '数值应是正数，或为零。',
    'This value should be negative.' => '数值应为负数。',
    'This value should be either negative or zero.' => '数值应是负数，或为零。',
    'This value is not a valid timezone.' => '无效时区。',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => '此密码已被泄露，切勿使用。请更换密码。',
    'This value should be between {{ min }} and {{ max }}.' => '该数值应在 {{ min }} 和 {{ max }} 之间。',
    'This value is not a valid hostname.' => '该值不是有效的主机名称。',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => '该集合内的元素数量得是 {{ compared_value }} 的倍数。',
    'This value should satisfy at least one of the following constraints:' => '该值需符合以下其中一个约束：',
    'Each element of this collection should satisfy its own set of constraints.' => '该集合内的每个元素需符合元素本身规定的约束。',
    'This value is not a valid International Securities Identification Number (ISIN).' => '该值不是有效的国际证券识别码 （ISIN）。',
    'This value should be a valid expression.' => '该值需为一个有效的表达式。',
    'This value is not a valid CSS color.' => '该值不是有效的CSS颜色。',
    'This value is not a valid CIDR notation.' => '该值不是一个有效的CIDR表示。',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => '网络掩码的值应当在 {{ min }} 和 {{ max }} 之间。',
    'This form should not contain extra fields.' => '该表单中不可有额外字段.',
    'The uploaded file was too large. Please try to upload a smaller file.' => '上传文件太大， 请重新尝试上传一个较小的文件.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'CSRF 验证符无效， 请重新提交.',
    'This value is not a valid HTML5 color.' => '该数值不是个有效的 HTML5 颜色。',
    'Please enter a valid birthdate.' => '请输入有效的生日日期。',
    'The selected choice is invalid.' => '所选的选项无效。',
    'The collection is invalid.' => '集合无效。',
    'Please select a valid color.' => '请选择有效的颜色。',
    'Please select a valid country.' => '请选择有效的国家。',
    'Please select a valid currency.' => '请选择有效的货币。',
    'Please choose a valid date interval.' => '请选择有效的日期间隔。',
    'Please enter a valid date and time.' => '请输入有效的日期与时间。',
    'Please enter a valid date.' => '请输入有效的日期。',
    'Please select a valid file.' => '请选择有效的文件。',
    'The hidden field is invalid.' => '隐藏字段无效。',
    'Please enter an integer.' => '请输入整数。',
    'Please select a valid language.' => '请选择有效的语言。',
    'Please select a valid locale.' => '请选择有效的语言环境。',
    'Please enter a valid money amount.' => '请输入正确的金额。',
    'Please enter a number.' => '请输入数字。',
    'The password is invalid.' => '密码无效。',
    'Please enter a percentage value.' => '请输入百分比值。',
    'The values do not match.' => '数值不匹配。',
    'Please enter a valid time.' => '请输入有效的时间。',
    'Please select a valid timezone.' => '请选择有效的时区。',
    'Please enter a valid URL.' => '请输入有效的网址。',
    'Please enter a valid search term.' => '请输入有效的搜索词。',
    'Please provide a valid phone number.' => '请提供有效的手机号码。',
    'The checkbox has an invalid value.' => '无效的选框值。',
    'Please enter a valid email address.' => '请输入有效的电子邮件地址。',
    'Please select a valid option.' => '请选择有效的选项。',
    'Please select a valid range.' => '请选择有效的范围。',
    'Please enter a valid week.' => '请输入有效的星期。',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => '身份验证发生异常。',
    'Authentication credentials could not be found.' => '没有找到身份验证的凭证。',
    'Authentication request could not be processed due to a system problem.' => '由于系统故障，身份验证的请求无法被处理。',
    'Invalid credentials.' => '无效的凭证。',
    'Cookie has already been used by someone else.' => 'Cookie 已经被其他人使用。',
    'Not privileged to request the resource.' => '没有权限请求此资源。',
    'Invalid CSRF token.' => '无效的 CSRF token 。',
    'No authentication provider found to support the authentication token.' => '没有找到支持此 token 的身份验证服务提供方。',
    'No session available, it either timed out or cookies are not enabled.' => 'Session 不可用。会话超时或没有启用 cookies 。',
    'No token could be found.' => '找不到 token 。',
    'Username could not be found.' => '找不到用户名。',
    'Account has expired.' => '帐号已过期。',
    'Credentials have expired.' => '凭证已过期。',
    'Account is disabled.' => '帐号已被禁用。',
    'Account is locked.' => '帐号已被锁定。',
    'Too many failed login attempts, please try again later.' => '登入失败的次数过多，请稍后再试。',
    'Invalid or expired login link.' => '失效或过期的登入链接。',
    'Too many failed login attempts, please try again in %minutes% minute.' => '登入失败的次数过多，请在%minutes%分钟后再试。',
    'Too many failed login attempts, please try again in %minutes% minutes.' => '登入失败的次数过多，请在%minutes%分钟后再试。',
  ),
));

$catalogueZh = new MessageCatalogue('zh', array (
  'messages' => 
  array (
    'Signed in as' => '登入为',
    'Your Profile' => '您的个人资料',
    'Create Ticket' => '创建工单',
    'Create Agent' => '创建接单员',
    'Create Customer' => '建立客户',
    'Sign Out' => '登出',
    'Reports' => '报告书',
    'Rating' => '评分',
    'Kudos Rating' => '荣誉评分',
    'Remove profile picture' => '删除个人资料图片',
    'Success ! Profile updated successfully.' => '成功 ！个人资料更新成功。',
    'Howdy' => '你好',
    'Form successfully updated.' => '表格已成功更新。',
    'NEW FORM' => '新表格',
    'Text Box' => '文本框',
    'Text Area' => '文本区',
    'Select' => '选择',
    'Radio' => '收音机',
    'Checkbox' => '复选框',
    'Date' => '日期',
    'Both Date and Time' => '日期和时间',
    'Choose a status' => '选择状态',
    'Choose a group' => '选择一个组',
    'Choose your default timeformat' => '选择您的默认时间格式',
    'Can manage Group\'s Saved Reply' => '可以管理群组的已保存回复',
    'Can manage agent activity' => '可以管理代理活动',
    'Can manage marketing announcement' => '可以管理营销公告',
    'User Forgot Password' => '用户忘记密码',
    'Agent Deleted' => '代理已删除',
    'Agent Update' => '代理更新',
    'Customer Update' => '客户更新',
    'Customer Deleted' => '客户已删除',
    'Agent Updated' => '代理更新',
    'Agent Reply' => '代理回复',
    'Collaborator Added' => '添加了合作者',
    'Collaborator Reply' => '合作者回复',
    'Customer Reply' => '客户回复',
    'Ticket Deleted' => '票已删除',
    'Group Updated' => '组更新',
    'Note Added' => '注释已添加',
    'Priority Updated' => '优先更新',
    'Status Updated' => '状态更新',
    'Team Updated' => '团队更新',
    'Thread Updated' => '主题更新',
    'Type Updated' => '类型更新',
    'From Email' => '从电子邮件',
    'To Email' => '发邮件',
    'Is Equal To' => '等于',
    'Is Not Equal To' => '不等于',
    'Contains' => '包含',
    'Does Not Contain' => '不含',
    'Starts With' => '以。。开始',
    'Ends With' => '以。。结束',
    'Before On' => '开启前',
    'After On' => '开启后',
    'Mail To User' => '邮寄给用户',
    'Transfer Tickets' => '转车票',
    'Mail To Customer' => '邮寄给客户',
    'Permanently delete from Inbox' => '從收件箱中永久刪除',
    'Agent Activity' => '代理活动',
    'Report From' => '报告来源',
    'Search Agent' => '搜索代理',
    'Agent Last Reply' => '特工最后回覆',
    'View analytics and insights to serve a better experience for your customers' => '查看分析和见解，为您的客户提供更好的体验',
    'Marketing Announcement' => '营销公告',
    'Advertisment' => '广告宣传',
    'Announcement' => '公告',
    'New Announcement' => '新公告',
    'Add Announcement' => '添加公告',
    'Edit Announcement' => '编辑公告',
    'Promo Text' => '促销文字',
    'Promo Tag' => '促销标签',
    'Choose a promo tag' => '选择促销标签',
    'Tag-Color' => '标签颜色',
    'Tag background color' => '标签背景色',
    'Link Text' => '连结文字',
    'Link URL' => '连结网址',
    'Apps' => '应用',
    'Integrate apps as per your needs to get things done faster than ever' => '根据您的需求集成应用程序，以比以往更快的速度完成工作',
    'Explore Apps' => '探索应用',
    'Form Builder' => '表单生成器',
    'Knowledgebase' => '知识库',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => '知识库是固定成型和复杂信息的来源，可帮助客户自助服务',
    'Articles' => '文章',
    'Categories' => '分类目录',
    'Folders' => '资料夹',
    'FOLDERS' => '资料夹',
    'Productivity' => '生产率',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => '通过创建一组规则和预设来自动化您的流程，以更快地响应工单',
    'Prepared Responses' => '准备好的回应',
    'Saved Replies' => '保存的回复',
    'Edit Saved Reply' => '编辑已保存的回复',
    'Ticket Types' => '工单类型',
    'Workflows' => '工作流程',
    'Settings' => '设定',
    'Manage your Brand Identity, Company Information and other details at a glance' => '一目了然地管理您的品牌标识，公司信息和其他详细信息',
    'Branding' => '品牌推广',
    'Custom Fields' => '自定义字段',
    'Email Settings' => '电子邮件设定',
    'Email Templates' => '电子邮件模板',
    'Mailbox' => '邮箱',
    'Spam Settings' => '垃圾邮件设置',
    'Swift Mailer' => '快捷邮件管理器',
    'Tags' => '标记',
    'Users' => '用户数',
    'Control your Groups, Teams, Agents and Customers' => '管控您的群组，团队，接单员和客户',
    'Agents' => '接单员',
    'Customers' => '顾客',
    'Groups' => '群组',
    'Privileges' => '权限',
    'Teams' => '团队',
    'Applications' => '应用程序',
    'ECommerce Order Syncronization' => '电子商务订单同步',
    'Import ecommerce order details to your support tickets from different available platforms' => '从不同的可用平台将电子商务订单详细信息导入您的支持工单',
    'Search' => '搜索',
    'Sort By' => '排序方式',
    'Status' => '状态',
    'Sort By:' => '排序方式:',
    'Status:' => '状态:',
    'Created At' => '创建于',
    'Name' => '名称',
    'All' => '全部',
    'Published' => '已发布',
    'Draft' => '草稿',
    'New Folder' => '新建文件夹',
    'Create Knowledgebase Folder' => '创建知识库文件夹',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => '您尚未将任何文件夹添加到知识库中，创建第一个文件夹并开始添加类别/文章以便客户自助服务。',
    'Clear Filters' => '清除筛选器',
    'Back' => '后退',
    'Open' => '打开',
    'Pending' => '待办的',
    'Answered' => '已回答',
    'Resolved' => '已解决',
    'Closed' => '已关闭',
    'Spam' => '垃圾邮件',
    'New' => '新的',
    'UnAssigned' => '未分配',
    'UnAnswered' => '未解答',
    'My Tickets' => '我的工单',
    'Starred' => '已加星标',
    'Trashed' => '已删除',
    'New Label' => '新标签',
    'Tickets' => '工单',
    'Ticket Id' => '工单编号',
    'Last Replied' => '最后回复',
    'Assign To' => '分配给',
    'After Reply' => '回复后',
    'Customer Email' => '客户电邮',
    'Customer Name' => '顾客姓名',
    'Assets Visibility' => '资产可见性',
    'Channel/Source' => '渠道/来源',
    'Channel' => '渠道',
    'Website' => '网站',
    'Timestamp' => '时间戳',
    'TimeStamp' => '时间戳',
    'Team' => '团队',
    'Type' => '类型',
    'Replies' => '回复',
    'Agent' => '接单员',
    'ID' => 'ID',
    'Subject' => '主题',
    'Last Reply' => '最后回复',
    'Filter View' => '筛选器视图',
    'Please select CAPTCHA' => '请选择验证码',
    'Warning ! Please select correct CAPTCHA !' => '警告 ！请选择正确的验证码！',
    'reCAPTCHA Setting' => 'reCAPTCHA设置',
    'reCAPTCHA Site Key' => 'reCAPTCHA网站密钥',
    'reCAPTCHA Secret key' => 'reCAPTCHA密钥',
    'reCAPTCHA Status' => 'reCAPTCHA状态',
    'reCAPTCHA is Active' => 'reCAPTCHA已启用',
    'Save set of filters as a preset to stay more productive' => '将筛选器集另存为预设，以保持更高的生产率',
    'Saved Filters' => '保存的筛选器',
    'No saved filter created' => '未创建已保存的筛选器',
    'Customer' => '顾客',
    'Priority' => '优先级',
    'Tag' => '标记',
    'Source' => '来源',
    'Before' => '之前',
    'After' => '之后',
    'Replies less than' => '回复少于',
    'Replies more than' => '回复不只',
    'Clear All' => '全部清除',
    'Account' => '帐户',
    'Profile' => '个人资料',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => '上载个人资料图片（100px x 100px）<br> 使用PNG或JPG格式',
    'First Name' => '名',
    'Last Name' => '姓',
    'Email' => '电子邮件',
    'Contact Number' => '联系电话',
    'Timezone' => '时区',
    'Africa/Abidjan' => '非洲/阿比让',
    'Africa/Accra' => '非洲/阿克拉',
    'Africa/Addis_Ababa' => '非洲/亚的斯亚贝巴',
    'Africa/Algiers' => '非洲/阿尔及尔',
    'Africa/Asmara' => '非洲/阿斯马拉',
    'Africa/Bamako' => '非洲/巴马科',
    'Africa/Bangui' => '非洲/班吉',
    'Africa/Banjul' => '非洲/班珠尔',
    'Africa/Bissau' => '非洲/比绍',
    'Africa/Blantyre' => '非洲/布兰太尔',
    'Africa/Brazzaville' => '非洲/布拉柴维尔',
    'Africa/Bujumbura' => '非洲/布琼布拉',
    'Africa/Cairo' => '非洲/开罗',
    'Africa/Casablanca' => '非洲/卡萨布兰卡',
    'Africa/Ceuta' => '非洲/休达',
    'Africa/Conakry' => '非洲/科纳克里',
    'Africa/Dakar' => '非洲/达喀尔',
    'Africa/Dar_es_Salaam' => '非洲/达累斯萨拉姆',
    'Africa/Djibouti' => '非洲/吉布提',
    'Africa/Douala' => '非洲/杜阿拉',
    'Africa/El_Aaiun' => '非洲/ El_Aaiun',
    'Africa/Freetown' => '非洲/弗里敦',
    'Africa/Gaborone' => '非洲/加博隆',
    'Africa/Harare' => '非洲/哈拉雷',
    'Africa/Johannesburg' => '非洲/约翰内斯堡',
    'Africa/Juba' => '非洲/朱巴',
    'Africa/Kampala' => '非洲/坎帕拉',
    'Africa/Khartoum' => '非洲/喀土穆',
    'Africa/Kigali' => '非洲/基加利',
    'Africa/Kinshasa' => '非洲/金沙萨',
    'Africa/Lagos' => '非洲/拉各斯',
    'Africa/Libreville' => '非洲/利伯维尔',
    'Africa/Lome' => '非洲/洛美',
    'Africa/Luanda' => '非洲/罗安达',
    'Africa/Lubumbashi' => '非洲/卢本巴希',
    'Africa/Lusaka' => '非洲/卢萨卡',
    'Africa/Malabo' => '非洲/马拉博',
    'Africa/Maputo' => '非洲/马普托',
    'Africa/Maseru' => '非洲/马塞鲁',
    'Africa/Mbabane' => '非洲/姆巴巴内',
    'Africa/Mogadishu' => '非洲/摩加迪沙',
    'Africa/Monrovia' => '非洲/蒙罗维亚',
    'Africa/Nairobi' => '非洲/内罗毕',
    'Africa/Ndjamena' => '非洲/恩贾梅纳',
    'Africa/Niamey' => '非洲/尼亚美',
    'Africa/Nouakchott' => '非洲/努瓦克肖特',
    'Africa/Ouagadougou' => '非洲/瓦加杜古',
    'Africa/Porto-Novo' => '非洲/波多诺伏',
    'Africa/Sao_Tome' => '非洲/圣保罗',
    'Africa/Tripoli' => '非洲/的黎波里',
    'Africa/Tunis' => '非洲/突尼斯',
    'Africa/Windhoek' => '非洲/温得和克',
    'America/Adak' => '美国/阿达克',
    'America/Anchorage' => '美国/安克雷奇',
    'America/Anguilla' => '美国/安圭拉',
    'America/Antigua' => '美国/安提瓜',
    'America/Araguaina' => '美洲/阿拉瓜那',
    'America/Argentina/Buenos_Aires' => '美国/阿根廷/布宜诺斯艾利斯',
    'America/Argentina/Catamarca' => '美国/阿根廷/卡塔马卡',
    'America/Argentina/Cordoba' => '美国/阿根廷/科尔多瓦',
    'America/Argentina/Jujuy' => '美国/阿根廷/胡胡伊',
    'America/Argentina/La_Rioja' => '美国/阿根廷/拉里奥哈',
    'America/Argentina/Mendoza' => '美国/阿根廷/门多萨',
    'America/Argentina/Rio_Gallegos' => '美国/阿根廷/里约热内卢',
    'America/Argentina/Salta' => '美国/阿根廷/萨尔塔',
    'America/Argentina/San_Juan' => '美国/阿根廷/圣胡安',
    'America/Argentina/San_Luis' => '美国/阿根廷/圣路易斯',
    'America/Argentina/Tucuman' => '美国/阿根廷/土库曼',
    'America/Argentina/Ushuaia' => '美国/阿根廷/乌斯怀亚',
    'America/Aruba' => '美国/阿鲁巴',
    'America/Asuncion' => '美国/亚松森',
    'America/Atikokan' => '美国/ Atikokan',
    'America/Bahia' => '美国/巴伊亚州',
    'America/Bahia_Banderas' => '美国/巴伊亚州（Bahia_Banderas）',
    'America/Barbados' => '美国/巴巴多斯',
    'America/Belem' => '美国/贝伦',
    'America/Belize' => '美国/伯利兹',
    'America/Blanc-Sablon' => '美国/布兰-萨布隆',
    'America/Boa_Vista' => '美国/ Boa_Vista',
    'America/Bogota' => '美国/波哥大',
    'America/Boise' => '美国/博伊西',
    'America/Cambridge_Bay' => '美国/剑桥湾',
    'America/Campo_Grande' => '美国/ Campo_Grande',
    'America/Cancun' => '美国/坎昆',
    'America/Caracas' => '美国/加拉加斯',
    'America/Cayenne' => '美国/卡宴',
    'America/Cayman' => '美国/开曼',
    'America/Chicago' => '美国/芝加哥',
    'America/Chihuahua' => '美国/奇瓦瓦州',
    'America/Costa_Rica' => '美国/哥斯达黎加',
    'America/Creston' => '美国/克雷斯顿',
    'America/Cuiaba' => '美国/库亚巴',
    'America/Curacao' => '美国/库拉索岛',
    'America/Danmarkshavn' => '美国/丹麦',
    'America/Dawson' => '美国/道森',
    'America/Dawson_Creek' => '美国/道森克里克',
    'America/Denver' => '美国/丹佛',
    'America/Detroit' => '美国/底特律',
    'America/Dominica' => '美国/多米尼加',
    'America/Edmonton' => '美国/埃德蒙顿',
    'America/Eirunepe' => '美国/埃鲁尼佩',
    'America/El_Salvador' => '美国/萨尔瓦多',
    'America/Fort_Nelson' => '美国/纳尔逊堡',
    'America/Fortaleza' => '美国/福塔雷萨',
    'America/Glace_Bay' => '美国/ Glace_Bay',
    'America/Godthab' => '美国/哥达卜',
    'America/Goose_Bay' => '美国/鹅湾',
    'America/Grand_Turk' => '美国/大突厥',
    'America/Grenada' => '美国/格林纳达',
    'America/Guadeloupe' => '美国/瓜德罗普岛',
    'America/Guatemala' => '美国/危地马拉',
    'America/Guayaquil' => '美国/瓜亚基尔',
    'America/Guyana' => '美国/圭亚那',
    'America/Halifax' => '美国/哈利法克斯',
    'America/Havana' => '美国/哈瓦那',
    'America/Hermosillo' => '美国/埃莫西约',
    'America/Indiana/Indianapolis' => '美国/印第安纳州/印第安纳波利斯',
    'America/Indiana/Knox' => '美国/印第安纳州/诺克斯',
    'America/Indiana/Marengo' => '美洲/印第安纳州/马伦戈',
    'America/Indiana/Petersburg' => '美国/印第安纳州/彼得斯堡',
    'America/Indiana/Tell_City' => '美洲/印第安纳州/特拉城',
    'America/Indiana/Vevay' => '美洲/印第安纳州/韦韦',
    'America/Indiana/Vincennes' => '美国/印第安纳州/文森斯',
    'America/Indiana/Winamac' => '美洲/印第安纳州/威纳马克',
    'America/Inuvik' => '美国/ Inuvik',
    'America/Iqaluit' => '美国/伊卡卢特',
    'America/Jamaica' => '美国/牙买加',
    'America/Juneau' => '美国/朱诺',
    'America/Kentucky/Louisville' => '美国/肯塔基州/路易斯维尔',
    'America/Kentucky/Monticello' => '美国/肯塔基州/蒙蒂塞洛',
    'America/Kralendijk' => '美国/克拉伦代克',
    'America/La_Paz' => '美洲/拉巴斯',
    'America/Lima' => '美国/利马',
    'America/Los_Angeles' => '美国/洛杉矶',
    'America/Lower_Princes' => '美国/下王子',
    'America/Maceio' => '美国/马塞约',
    'America/Managua' => '美国/马那瓜',
    'America/Manaus' => '美国/马瑙斯',
    'America/Marigot' => '美国/马里戈特',
    'America/Martinique' => '美国/马提尼克岛',
    'America/Matamoros' => '美国/马塔莫罗斯',
    'America/Mazatlan' => '美洲/马萨特兰',
    'America/Menominee' => '美国/密胺',
    'America/Merida' => '美国/梅里达',
    'America/Metlakatla' => '美国/梅特拉卡特拉',
    'America/Mexico_City' => '美国/墨西哥城',
    'America/Miquelon' => '美国/密克隆',
    'America/Moncton' => '美国/蒙克顿',
    'America/Monterrey' => '美国/蒙特雷',
    'America/Montevideo' => '美国/蒙得维的亚',
    'America/Montserrat' => '美国/蒙特塞拉特',
    'America/Nassau' => '美国/拿骚',
    'America/New_York' => '美国/纽约',
    'America/Nipigon' => '美国/尼皮贡',
    'America/Nome' => '美国/ Nome',
    'America/Noronha' => '美国/诺罗尼亚',
    'America/North_Dakota/Beulah' => '美国/北达科他州/比拉',
    'America/North_Dakota' => '美国/北达科他州',
    'America/Ojinaga' => '美国/冲绳',
    'America/Panama' => '美国/巴拿马',
    'America/Pangnirtung' => '美国/庞尼城',
    'America/Paramaribo' => '美国/巴拉马里博',
    'America/Phoenix' => '美国/凤凰城',
    'America/Port-au-Prince' => '美国/太子港',
    'America/Port_of_Spain' => '美国/西班牙港',
    'America/Porto_Velho' => '美国/ Porto_Velho',
    'America/Puerto_Rico' => '美国/波多黎各',
    'America/Punta_Arenas' => '美国/蓬塔阿雷纳斯',
    'America/Rainy_River' => '美国/多雨河',
    'America/Rankin_Inlet' => '美国/ Rankin_Inlet',
    'America/Recife' => '美国/累西腓',
    'America/Regina' => '美国/里贾纳',
    'America/Resolute' => '美国/坚决',
    'America/Rio_Branco' => '美国/里约布兰科',
    'America/Santarem' => '美国/圣塔伦',
    'America/Santiago' => '美国/圣地亚哥',
    'America/Santo_Domingo' => '美国/圣多明各',
    'America/Sao_Paulo' => '美国/圣保罗',
    'America/Scoresbysund' => '美国/斯科比斯松',
    'America/Sitka' => '美国/锡特卡',
    'America/St_Barthelemy' => '美国/圣巴托洛缪岛',
    'America/St_Johns' => '美国/圣约翰斯',
    'America/St_Kitts' => '美国/圣基茨',
    'America/St_Lucia' => '美国/圣卢西亚',
    'America/St_Thomas' => '美国/圣托马斯',
    'America/St_Vincent' => '美国/圣文森特',
    'America/Swift_Current' => 'America / Swift_Current',
    'America/Tegucigalpa' => '美国/特古西加尔巴',
    'America/Thule' => '美国/图勒',
    'America/Thunder_Bay' => '美国/雷霆湾',
    'America/Tijuana' => '美国/蒂华纳',
    'America/Toronto' => '美国/多伦多',
    'America/Tortola' => '美国/托托拉',
    'America/Vancouver' => '美国/温哥华',
    'America/Whitehorse' => '美国/怀特霍斯',
    'America/Winnipeg' => '美国/温尼伯',
    'America/Yakutat' => '美国/雅库特',
    'America/Yellowknife' => '美国/黄刀',
    'Antarctica/Casey' => '南极洲/凯西',
    'Antarctica/Davis' => '南极洲/戴维斯',
    'Antarctica/DumontDUrville' => '南极洲/杜蒙特',
    'Antarctica/Macquarie' => '南极/麦格理',
    'Antarctica/McMurdo' => '南极洲/麦克默多',
    'Antarctica/Mawson' => '南极洲/莫森',
    'Antarctica/Palmer' => '南极洲/帕尔默',
    'Antarctica/Rothera' => '南极洲/罗瑟拉',
    'Antarctica/Syowa' => '南极洲/昭和',
    'Antarctica/Troll' => '南极/巨魔',
    'Antarctica/Vostok' => '南极洲/沃斯托克',
    'Arctic/Longyearbyen' => '北极/朗伊尔城',
    'Asia/Aden' => '亚洲/亚丁',
    'Asia/Almaty' => '亚洲/阿拉木图',
    'Asia/Amman' => '亚洲/安曼',
    'Asia/Anadyr' => '亚洲/ Anadyr',
    'Asia/Aqtau' => '亚洲/阿克套',
    'Asia/Aqtobe' => '亚洲/阿克托比',
    'Asia/Ashgabat' => '亚洲/阿什哈巴德',
    'Asia/Atyrau' => '亚洲/阿特劳',
    'Asia/Baghdad' => '亚洲/巴格达',
    'Asia/Bahrain' => '亚洲/巴林',
    'Asia/Baku' => '亚洲/巴库',
    'Asia/Bangkok' => '亚洲/曼谷',
    'Asia/Barnaul' => '亚洲/巴尔瑙尔',
    'Asia/Beirut' => '亚洲/贝鲁特',
    'Asia/Bishkek' => '亚洲/比什凯克',
    'Asia/Brunei' => '亚洲/文莱',
    'Asia/Chita' => '亚洲/赤塔',
    'Asia/Choibalsan' => '亚洲/乔瓦山',
    'Asia/Colombo' => '亚洲/科伦坡',
    'Asia/Damascus' => '亚洲/大马士革',
    'Asia/Dhaka' => '亚洲/达卡',
    'Asia/Dili' => '亚洲/帝力',
    'Asia/Dubai' => '亚洲/迪拜',
    'Asia/Dushanbe' => '亚洲/杜尚别',
    'Asia/Famagusta' => '亚洲/法马古斯塔',
    'Asia/Gaza' => '亚洲/加沙',
    'Asia/Hebron' => '亚洲/希伯伦',
    'Asia/Ho_Chi_Minh' => '亚洲/胡志明市',
    'Asia/Hong_Kong' => '亚洲/香港',
    'Asia/Hovd' => '亚洲/香港',
    'Asia/Irkutsk' => '亚洲/伊尔库茨克',
    'Asia/Jakarta' => '亚洲/雅加达',
    'Asia/Jayapura' => '亚洲/贾亚普拉',
    'Asia/Jerusalem' => '亚洲/耶路撒冷',
    'Asia/Kabul' => '亚洲/喀布尔',
    'Asia/Kamchatka' => '亚洲/堪察加半岛',
    'Asia/Karachi' => '亚洲/卡拉奇',
    'Asia/Kathmandu' => '亚洲/加德满都',
    'Asia/Khandyga' => '亚洲/坎迪加',
    'Asia/Kolkata' => '亚洲/加尔各答',
    'Asia/Krasnoyarsk' => '亚洲/克拉斯诺亚尔斯克',
    'Asia/Kuala_Lumpur' => '亚洲/吉隆坡',
    'Asia/Kuching' => '亚洲/古晋',
    'Asia/Kuwait' => '亚洲/科威特',
    'Asia/Macau' => '亚洲/澳门',
    'Asia/Magadan' => '亚洲/马达加丹',
    'Asia/Makassar' => '亚洲/马卡萨尔',
    'Asia/Manila' => '亚洲/马尼拉',
    'Asia/Muscat' => '亚洲/马斯喀特',
    'Asia/Nicosia' => '亚洲/尼科西亚',
    'Asia/Novokuznetsk' => '亚洲/新库兹涅茨克',
    'Asia/Novosibirsk' => '亚洲/新西伯利亚',
    'Asia/Omsk' => '亚洲/鄂木斯克',
    'Asia/Oral' => '亚洲/口头',
    'Asia/Phnom_Penh' => '亚洲/金边',
    'Asia/Pontianak' => '亚洲/蓬塔纳克',
    'Asia/Pyongyang' => '亚洲/平壤',
    'Asia/Qatar' => '亚洲/卡塔尔',
    'Asia/Qostanay' => '亚洲/ Qostanay',
    'Asia/Qyzylorda' => '亚洲/齐齐洛达',
    'Asia/Riyadh' => '亚洲/利雅得',
    'Asia/Sakhalin' => '亚洲/萨哈林岛',
    'Asia/Samarkand' => '亚洲/撒马尔罕',
    'Asia/Seoul' => '亚洲/首尔',
    'Asia/Shanghai' => '亚洲/上海',
    'Asia/Singapore' => '亚洲/新加坡',
    'Asia/Srednekolymsk' => '亚洲/斯雷德涅科林斯克',
    'Asia/Taipei' => '亚洲/台北',
    'Asia/Tashkent' => '亚洲/塔什干',
    'Asia/Tbilisi' => '亚洲/第比利斯',
    'Asia/Tehran' => '亚洲/德黑兰',
    'Asia/Thimphu' => '亚洲/廷布',
    'Asia/Tokyo' => '亚洲/东京',
    'Asia/Tomsk' => '亚洲/托木斯克',
    'Asia/Ulaanbaatar' => '亚洲/乌兰巴托',
    'Asia/Urumqi' => '亚洲/乌鲁木齐',
    'Asia/Ust-Nera' => '亚洲/乌斯特-尼拉',
    'Asia/Vientiane' => '亚洲/万象',
    'Asia/Vladivostok' => '亚洲/符拉迪沃斯托克（海参div）',
    'Asia/Yakutsk' => '亚洲/雅库茨克',
    'Asia/Yangon' => '亚洲/仰光',
    'Asia/Yekaterinburg' => '亚洲/叶卡捷琳堡',
    'Asia/Yerevan' => '亚洲/埃里温',
    'Atlantic/Azores' => '大西洋/亚速尔群岛',
    'Atlantic/Bermuda' => '大西洋/百慕大',
    'Atlantic/Canary' => '大西洋/金丝雀',
    'Atlantic/Cape_Verde' => '大西洋/佛得角',
    'Atlantic/Faroe' => '大西洋/法罗',
    'Atlantic/Madeira' => '大西洋/马德拉',
    'Atlantic/Reykjavik' => '大西洋/雷克雅未克',
    'Atlantic/South_Georgia' => '大西洋/南乔治亚',
    'Atlantic/St_Helena' => '大西洋/圣海伦娜',
    'Atlantic/Stanley' => '大西洋/史丹利',
    'Australia/Adelaide' => '澳大利亚/阿德莱德',
    'Australia/Brisbane' => '澳大利亚/布里斯班',
    'Australia/Broken_Hill' => '澳大利亚/断山',
    'Australia/Currie' => '澳大利亚/科里',
    'Australia/Darwin' => '澳大利亚/达尔文',
    'Australia/Eucla' => '澳大利亚/尤克拉',
    'Australia/Hobart' => '澳大利亚/霍巴特',
    'Australia/Lindeman' => '澳大利亚/林德曼',
    'Australia/Lord_Howe' => '澳大利亚/豪勋爵',
    'Australia/Melbourne' => '澳大利亚/墨尔本',
    'Australia/Perth' => '澳大利亚/珀斯',
    'Australia/Sydney' => '澳大利亚/悉尼',
    'Europe/Amsterdam' => '欧洲/阿姆斯特丹',
    'Europe/Andorra' => '欧洲/安道尔',
    'Europe/Astrakhan' => '欧洲/阿斯特拉罕',
    'Europe/Athens' => '欧洲/雅典',
    'Europe/Belgrade' => '欧洲/贝尔格莱德',
    'Europe/Berlin' => '欧洲/柏林',
    'Europe/Bratislava' => '欧洲/布拉迪斯拉发',
    'Europe/Brussels' => '欧洲/布鲁塞尔',
    'Europe/Bucharest' => '欧洲/布加勒斯特',
    'Europe/Budapest' => '欧洲/布达佩斯',
    'Europe/Busingen' => '欧洲/布辛根',
    'Europe/Chisinau' => '欧洲/基希讷乌',
    'Europe/Copenhagen' => '欧洲/哥本哈根',
    'Europe/Dublin' => '欧洲/都柏林',
    'Europe/Gibraltar' => '欧洲/直布罗陀',
    'Europe/Guernsey' => '欧洲/根西岛',
    'Europe/Helsinki' => '欧洲/赫尔辛基',
    'Europe/Isle_of_Man' => '欧洲/马恩岛',
    'Europe/Istanbul' => '欧洲/伊斯坦布尔',
    'Europe/Jersey' => '欧洲/泽西岛',
    'Europe/Kaliningrad' => '欧洲/加里宁格勒',
    'Europe/Kiev' => '欧洲/基辅',
    'Europe/Kirov' => '欧洲/基洛夫',
    'Europe/Lisbon' => '欧洲/里斯本',
    'Europe/Ljubljana' => '欧洲/卢布尔雅那',
    'Europe/London' => '欧洲/伦敦',
    'Europe/Luxembourg' => '欧洲/卢森堡',
    'Europe/Madrid' => '欧洲/马德里',
    'Europe/Malta' => '欧洲/马耳他',
    'Europe/Mariehamn' => '欧洲/玛丽港',
    'Europe/Minsk' => '欧洲/明斯克',
    'Europe/Monaco' => '欧洲/摩纳哥',
    'Europe/Moscow' => '欧洲/莫斯科',
    'Europe/Oslo' => '欧洲/奥斯陆',
    'Europe/Paris' => '欧洲/巴黎',
    'Europe/Podgorica' => '欧洲/波德戈里察',
    'Europe/Prague' => '欧洲/布拉格',
    'Europe/Riga' => '欧洲/里加',
    'Europe/Rome' => '欧洲/罗马',
    'Europe/Samara' => '欧洲/萨马拉',
    'Europe/San_Marino' => '欧洲/圣马力诺',
    'Europe/Sarajevo' => '欧洲/萨拉热窝',
    'Europe/Saratov' => '欧洲/萨拉托夫',
    'Europe/Simferopol' => '欧洲/辛菲罗波尔',
    'Europe/Skopje' => '欧洲/斯科普里',
    'Europe/Sofia' => '欧洲/索非亚',
    'Europe/Stockholm' => '欧洲/斯德哥尔摩',
    'Europe/Tallinn' => '欧洲/塔林',
    'Europe/Tirane' => '欧洲/地拉那',
    'Europe/Ulyanovsk' => '欧洲/乌利亚诺夫斯克',
    'Europe/Uzhgorod' => '欧洲/乌日哥罗德',
    'Europe/Vaduz' => '欧洲/瓦杜兹',
    'Europe/Vatican' => '欧洲/梵蒂冈',
    'Europe/Vienna' => '欧洲/维也纳',
    'Europe/Vilnius' => '欧洲/维尔纽斯',
    'Europe/Volgograd' => '欧洲/伏尔加格勒',
    'Europe/Warsaw' => '欧洲/华沙',
    'Europe/Zagreb' => '欧洲/萨格勒布',
    'Europe/Zaporozhye' => '欧洲/扎波罗热',
    'Europe/Zurich' => '欧洲/苏黎世',
    'Indian/Antananarivo' => '印度/塔那那利佛',
    'Indian/Chagos' => '印度/查戈斯',
    'Indian/Christmas' => '印度/圣诞节',
    'Indian/Cocos' => '印度/可可',
    'Indian/Comoro' => '印度/科摩罗',
    'Indian/Kerguelen' => '印度/克格伦',
    'Indian/Mahe' => '印度/马赫',
    'Indian/Maldives' => '印度/马尔代夫',
    'Indian/Mauritius' => '印度/毛里求斯',
    'Indian/Mayotte' => '印度/马约特岛',
    'Indian/Reunion' => '印度/留尼旺',
    'Pacific/Apia' => '太平洋/阿皮亚',
    'Pacific/Auckland' => '太平洋/奥克兰',
    'Pacific/Bougainville' => '太平洋/九重葛',
    'Pacific/Chatham' => '太平洋/查塔姆',
    'Pacific/Chuuk' => '太平洋/楚克',
    'Pacific/Easter' => '太平洋/复活节',
    'Pacific/Efate' => '太平洋/命运',
    'Pacific/Enderbury' => '太平洋/恩德伯里',
    'Pacific/Fakaofo' => '太平洋/法考福',
    'Pacific/Fiji' => '太平洋/斐济',
    'Pacific/Funafuti' => '太平洋/富纳富提',
    'Pacific/Galapagos' => '太平洋/加拉帕戈斯',
    'Pacific/Gambier' => '太平洋/甘比尔',
    'Pacific/Guadalcanal' => '太平洋/瓜达尔卡纳尔岛',
    'Pacific/Guam' => '太平洋/关岛',
    'Pacific/Honolulu' => '太平洋/檀香山',
    'Pacific/Kiritimati' => '太平洋/基里蒂马蒂',
    'Pacific/Kosrae' => '太平洋/科斯雷',
    'Pacific/Kwajalein' => '太平洋/夸贾林',
    'Pacific/Majuro' => '太平洋/马朱罗',
    'Pacific/Marquesas' => '太平洋/马萨诸塞州',
    'Pacific/Midway' => '太平洋/中途岛',
    'Pacific/Nauru' => '太平洋/瑙鲁',
    'Pacific/Niue' => '太平洋/纽埃',
    'Pacific/Norfolk' => '太平洋/诺福克',
    'Pacific/Noumea' => '太平洋/努美阿',
    'Pacific/Pago_Pago' => '太平洋/ Pago_Pago',
    'Pacific/Palau' => '太平洋/帕劳',
    'Pacific/Pitcairn' => '太平洋/皮特凯恩',
    'Pacific/Pohnpei' => '太平洋/庞贝',
    'Pacific/Port_Moresby' => '太平洋/莫尔斯比港',
    'Pacific/Rarotonga' => '太平洋/拉罗通加',
    'Pacific/Saipan' => '太平洋/塞班岛',
    'Pacific/Tahiti' => '太平洋/大溪地',
    'Pacific/Tarawa' => '太平洋/塔拉瓦',
    'Pacific/Tongatapu' => '太平洋/汤加塔普',
    'Pacific/Wake' => '太平洋/苏醒',
    'Pacific/Wallis' => '太平洋/沃利斯',
    'UTC' => '世界标准时间',
    'Time Format' => '时间格式',
    'Choose your default timezone' => '选择默认时区',
    'Signature' => '签名',
    'User signature will be append at the bottom of ticket reply box' => '用户签名将附加在工单回复框的底部',
    'Password' => '密码',
    'Password will remain same if you are not entering something in this field' => '如果您未在此字段中输入任何内容，密码将保持不变',
    'Confirm Password' => '确认密码',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => '密码必须包含至少8个字符的长度，至少两个字母（不区分大小写），一个数字，一个特殊字符（不允许空格）。',
    'Save Changes' => '保存更改',
    'SAVE CHANGES' => '保存更改',
    'CREATE TICKET' => '创建工单',
    'Customer full name' => '客户全程',
    'Customer email address' => '客户电子邮件地址',
    'Select Type' => '选择类型',
    'Support' => '支持',
    'Choose ticket type' => '选择工单类型',
    'Ticket subject' => '工单主题',
    'Message' => '信息',
    'Query Message' => '查询讯息',
    'Add Attachment' => '添加附件',
    'This field is mandatory' => '此字段是必填字段',
    'General' => '一般的',
    'Designation' => '指定',
    'Contant Number' => '接触数',
    'User signature will be append in the bottom of ticket reply box' => '用户签名将附加在工单回复框的底部',
    'Account Status' => '帐户状态',
    'Account is Active' => '帐户有效',
    'Assigning group(s) to user to view tickets regardless assignment.' => '将群组分配给用户以查看工单，无论分配如何。',
    'Default' => '默认',
    'Select All' => '全选',
    'Remove All' => '移除所有',
    'Assigning team(s) to user to view tickets regardless assignment.' => '将团队分配给用户以查看故障单，无论分配如何。',
    'No Team added !' => '未添加团队！',
    'Permission' => '许可',
    'Role' => '角色',
    'Administrator' => '行政人员',
    'Select agent role' => '选择接单员角色',
    'Add Customer' => '新增客户',
    'Action' => '行动',
    'Account Owner' => '帐户所有者',
    'Active' => '活动的',
    'Edit' => '编辑',
    'Delete' => '删除',
    'Disabled' => '已禁用',
    'New Group' => '新建群组',
    'Default Privileges' => '默认权限',
    'New Privileges' => '新权限',
    'NEW PRIVILEGE' => '新权限',
    'New Privilege' => '新权限',
    'New Team' => '新团队',
    'No Record Found' => '没有找到记录',
    'Order Synchronization' => '订单同步',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => '轻松地将不同的电子商务平台与您的服务台集成，然后可以在以后用于快速将电子商务订单详细信息与支持工单集成在一起。',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => '未添加任何渠道。',
    'Add BigCommerce Store' => '添加BigCommerce商店',
    'ADD BIGCOMMERCE STORE' => '添加BigCommerce商店',
    'Mangento' => 'Mangento',
    'Add Magento Store' => '添加Magento商店',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => '添加OpenCart商店',
    'ADD OPENCART STORE' => '添加OpenCART商店',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => '添加Shopify商店',
    'ADD SHOPIFY STORE' => '添加Shopify商店',
    'Integrate a new BigCommerce store' => '整合新的BigCommerce商店',
    'Your BigCommerce Store Name' => '您的BigCommerce商店名称',
    'Your BigCommerce Store Hash' => '您的BigCommerce商店哈希',
    'Your BigCommerce Api Token' => '您的BigCommerce Api令牌',
    'Your BigCommerce Api Client ID' => '您的BigCommerce Api客户ID',
    'Enable Channel' => '启用渠道',
    'Add Store' => '添加商店',
    'ADD STORE' => '添加商店',
    'Integrate a new Magento store' => '整合新的Magento商店',
    'Your Magento Api Username' => '您的Magento Api用户名',
    'Your Magento Api Password' => '您的Magento Api密码',
    'Integrate a new OpenCart store' => '整合新的OpenCart商店',
    'Your OpenCart Api Key' => '您的OpenCart Api密钥',
    'Your Shopify Store Name' => '您的Shopify商店名称',
    'Your Shopify Api Key' => '您的Shopify Api密钥',
    'Your Shopify Api Password' => '您的Shopify Api密码',
    'Easily embed custom form to help generate helpdesk tickets.' => '轻松嵌入自定义表单，以帮助生成服务台工单。',
    'Form-Builder' => '表单生成器',
    'Add Formbuilder' => '添加表单生成器',
    'ADD FORMBUILDER' => '添加表单生成器',
    'No FormBuilder have been added.' => '未添加表单生成器。',
    'Create a New Custom Form Below' => '在下面创建一个新的自定义表单',
    'Form Name' => '表单名称',
    'It will be shown in the list of created forms' => '它将显示在创建的表单列表中',
    'MANDATORY FIELDS' => '必须填写',
    'These fields will be visible in form and cant be edited' => '这些字段将以表单形式显示，并且无法进行编辑',
    'Reply' => '回复',
    'OPTIONAL FIELDS' => '可选字段',
    'Select These Fields to Add in your Form' => '选择这些字段以添加到表单中',
    'GDPR' => 'GDPR',
    'Order' => '订单',
    'Categorybuilder' => '分类构建器',
    'File' => '文件',
    'Add Form' => '新增表单',
    'ADD FORM' => '新增表单',
    'UPDATE FORM' => '更新表单',
    'Update Form' => '更新表单',
    'Embed' => '嵌入',
    'EMBED' => '嵌入',
    'EMBED FORMBUILDER' => '嵌入式表单生成器',
    'Embed Formbuilder' => '嵌入式表单生成器',
    'Visit' => '访问',
    'VISIT' => '访问',
    'Code' => '代码',
    'Total Ticket(s)' => '总工单数',
    'Ticket Count' => '工单计数',
    'SwiftMailer Configurations' => '快捷邮件管理器配置',
    'No swiftmailer configurations found' => '找不到快捷邮件管理器配置',
    'CREATE CONFIGURATION' => '创建配置',
    'Add configuration' => '添加配置',
    'Update configuration' => '更新配置',
    'Mailer ID' => '邮件ID',
    'Mailer ID - Leave blank to automatically create id' => '邮件程序ID-保留空白以自动创建ID',
    'Transport Type' => '传输类型',
    'SMTP' => 'SMTP协议',
    'Enable Delivery' => '启用传输',
    'Server' => '服务器',
    'Port' => '端口',
    'Encryption Mode' => '加密方式',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => '无',
    'Authentication Mode' => '认证方式',
    'login' => '登录',
    'Plain' => '明文',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => '发件人地址',
    'Delivery Address' => '邮寄地址',
    'Block Spam' => '阻止垃圾邮件',
    'Black list' => '黑名单',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => '以逗号（，）分隔的值（例如，support @ example.com，@ example.com，68.98.31.226）',
    'White list' => '白名单',
    'Mailbox Settings' => '邮箱设置',
    'No mailbox configurations found' => '找不到邮箱配置',
    'NEW MAILBOX' => '新邮箱',
    'New Mailbox' => '新邮箱',
    'Update Mailbox' => '更新邮箱',
    'Add Mailbox' => '添加邮箱',
    'Mailbox ID - Leave blank to automatically create id' => '邮箱ID-保留空白以自动创建ID',
    'Mailbox Name' => '邮箱名称',
    'Enable Mailbox' => '启用邮箱',
    'Incoming Mail (IMAP) Server' => '传入邮件（IMAP）服务器',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => '配置您的imap设置，该设置将用于从您的邮箱中获取电子邮件。',
    'Transport' => '传输',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => '主机',
    'IMAP Host' => 'IMAP主机',
    'Email address' => '电子邮件地址',
    'Associated Password' => '关联密码',
    'Outgoing Mail (SMTP) Server' => '发送邮件（SMTP）服务器',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => '选择一个有效的快捷邮件管理器配置，该配置将用于通过您的邮箱发送电子邮件。',
    'Swift Mailer ID' => '快捷邮件管理器ID',
    'None Selected' => '未选择',
    'Create Mailbox' => '创建邮箱',
    'CREATE MAILBOX' => '创建邮箱',
    'New Template' => '新模板',
    'NEW TEMPLATE' => '新模板',
    'Customer Forgot Password' => '客户忘记密码',
    'Customer Account Created' => '客户帐户已创建',
    'Ticket generated success mail to customer' => '工单生成的成功邮件发送给客户',
    'Customer Reply To The Agent' => '客户回复接单员',
    'Ticket Assign' => '工单分配',
    'Agent Forgot Password' => '接单员忘记密码',
    'Agent Account Created' => '接单员帐户已创建',
    'Ticket generated by customer' => '客户生成的工单',
    'Agent Reply To The Customers ticket' => '接单员回复客户工单',
    'Email template name' => '电子邮件模板名称',
    'Email template subject' => '电子邮件模板主题',
    'Template For' => '模板给',
    'Nothing Selected' => '无选择',
    'email template will be used for work related with selected option' => '电子邮件模板将用于与所选选项相关的工作',
    'Email template body' => '电子邮件模板正文',
    'Body' => '正文',
    'placeholders' => '占位符',
    'Ticket Subject' => '工单主题',
    'Ticket Message' => '工单信息',
    'Ticket Attachments' => '工单附件',
    'Ticket Tags' => '工单标记',
    'Ticket Source' => '工单来源',
    'Ticket Status' => '工单状态',
    'Ticket Priority' => '工单优先级',
    'Ticket Group' => '工单群组',
    'Ticket Team' => '工单团队',
    'Ticket Thread Message' => '工单线程消息',
    'Ticket Customer Name' => '工单客户名称',
    'Ticket Customer Email' => '工单客户电子邮件',
    'Ticket Agent Name' => '工单接单员名称',
    'Ticket Agent Email' => '工单接单员电子邮件',
    'Ticket Agent Link' => '工单接单员链接',
    'Ticket Customer Link' => '工单客户链接',
    'Last Collaborator Name' => '最后的协作者名字',
    'Last Collaborator Email' => '最后的协作者电子邮件',
    'Agent/ Customer Name' => '接单员/客户名称',
    'Account Validation Link' => '帐户验证链接',
    'Password Forgot Link' => '密码忘记链接',
    'Company Name' => '公司名称',
    'Company Logo' => '公司Logo',
    'Company URL' => '公司网址',
    'Swiftmailer id (Select from drop down)' => '快捷邮件管理器ID（从下拉列表中选择）',
    'PROCEED' => '继续',
    'Proceed' => '继续',
    'Theme Color' => '主题色',
    'Customer Created' => '客户创建',
    'Agent Created' => '接单员已创建',
    'Ticket Created' => '工单已创建',
    'Agent Replied on Ticket' => '接单员在工单上回复',
    'Customer Replied on Ticket' => '顾客回复工单',
    'Workflow Status' => '工作流程状态',
    'Workflow is Active' => '工作流程处于活动状态',
    'Events' => '事件',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => '事件会自动触发以检查条件并执行相应的预定义的一系列操作',
    'Select an Event' => '选择一个事件',
    'Add More' => '添加更多',
    'Conditions' => '条件',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => '条件是一组规则，用于检查特定场景并在特定情况下触发',
    'Subject or Description' => '主题或描述',
    'Actions' => '动作',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => '动作不仅减少了工作量，而且使工单自动化变得相当容易',
    'Select an Action' => '选择一个动作',
    'Add Note' => '加备注',
    'Mail to agent' => '邮寄给接单员',
    'Mail to customer' => '邮寄给客户',
    'Mail to group' => '邮寄到群组',
    'Mail to last collaborator' => '邮寄给最近的合作者',
    'Mail to team' => '邮寄给团队',
    'Mark Spam' => '标记为垃圾邮件',
    'Assign to agent' => '分配给接单员',
    'Assign to group' => '分配给群组',
    'Set Priority As' => '将优先级设置为',
    'Set Status As' => '将状态设置为',
    'Set Tag As' => '将标记设置为',
    'Set Label As' => '将标签设置为',
    'Assign to team' => '分配给团队',
    'Set Type As' => '将类型设置为',
    'Add Workflow' => '添加工作流程',
    'ADD WORKFLOW' => '添加工作流程',
    'Ticket Type code' => '工单类型代码',
    'Ticket Type description' => '工单类型描述',
    'Type Status' => '类型状态',
    'Type is Active' => '类型有效',
    'Add Save Reply' => '添加保存回复',
    'Saved reply name' => '保存的回复名称',
    'Share saved reply with user(s) in these group(s)' => '与这些群组中的用户共享保存的回复',
    'Share saved reply with user(s) in these teams(s)' => '与这些团队中的用户共享保存的回复',
    'Saved reply Body' => '保存的回复正文',
    'New Prepared Response' => '新的准备好的响应',
    'Prepared Response Status' => '准备好的响应状态',
    'Prepared Response is Active' => '准备好的响应处于活动状态',
    'Share prepared response with user(s) in these group(s)' => '与这些群组中的用户共享准备好的响应',
    'Share prepared response with user(s) in these teams(s)' => '与这些团队中的用户共享准备好的响应',
    'ADD PREPARED RESPONSE' => '添加准备的响应',
    'Add Prepared Response' => '添加准备好的响应',
    'Folder Name is shown upfront at Knowledge Base' => '文件夹名称显示在知识库的前面',
    'A small text about the folder helps user to navigate more easily' => '有关文件夹的小文字可帮助用户更轻松地导航',
    'Publish' => '发布',
    'Choose appropriate status' => '选择适当的状态',
    'Folder Image' => '资料夹图片',
    'An image is worth a thousands words and makes folder more accessible' => '图片价值数千个单词，使文件夹更易于访问',
    'Add Category' => '添加类别',
    'Category Name is shown upfront at Knowledge Base' => '类别名称显示在知识库的前面',
    'A small text about the category helps user to navigate more easily' => '有关类别的小文字可帮助用户更轻松地导航',
    'Using Category Order, you can decide which category should display first' => '使用类别顺序，您可以决定哪个类别应首先显示',
    'Sorting' => '排序',
    'Ascending Order (A-Z)' => '升序（A-Z）',
    'Descending Order (Z-A)' => '降序（Z-A）',
    'Based on Popularity' => '基于人气',
    'Article of this category will display according to selected option' => '此类别的文章将根据所选选项显示',
    'Article' => '文章',
    'Title' => '标题',
    'View' => '查看',
    'Make as Starred' => '加星标',
    'Yes' => '是',
    'No' => '否',
    'Stared' => '已加星标',
    'Revisions' => '修订版本',
    'Related Articles' => '相关文章',
    'Delete Article' => '删除文章',
    'Content' => '内容',
    'Slug' => '弹头',
    'Slug is the url identity of this article.' => 'Slug是本文的url身份。',
    'Meta Title' => '元标题',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => '标题标记和元描述是网页标题中的HTML代码的一部分。它们帮助搜索引擎了解页面上的内容。每当页面出现在搜索引擎结果中时，通常会显示页面标题标记和元描述',
    'Meta Keywords' => '元关键字',
    'Meta Description' => '元描述',
    'Description' => '描述',
    'Team Status' => '团队状态',
    'Team is Active' => '团队有效',
    'Edit Privilege' => '编辑权限',
    'Can create ticket' => '可以创建工单',
    'Can edit ticket' => '可以编辑工单',
    'Can delete ticket' => '可以删除工单',
    'Can restore trashed ticket' => '可以恢复垃圾工单',
    'Can assign ticket' => '可以分配工单',
    'Can assign ticket group' => '可以分配工单群组',
    'Can update ticket status' => '可以更新工单状态',
    'Can update ticket priority' => '可以更新工单优先级',
    'Can update ticket type' => '可以更新工单类型',
    'Can add internal notes to ticket' => '可以在工单中添加内部注释',
    'Can edit thread/notes' => '可以编辑线程/注释',
    'Can lock/unlock thread' => '可以锁定/解锁线程',
    'Can add collaborator to ticket' => '可以将协作者添加到工单',
    'Can delete collaborator from ticket' => '可以从工单中删除协作者',
    'Can delete thread/notes' => '可以删除线程/注释',
    'Can apply prepared response on ticket' => '可以在工单上应用准备好的响应',
    'Can add ticket tags' => '可以添加工单标记',
    'Can delete ticket tags' => '可以删除工单标记',
    'Can kick other ticket users' => '可以踢出其他工单用户',
    'Can manage email templates' => '可以管理电子邮件模板',
    'Can manage groups' => '可以管理群组',
    'Can manage Sub-Groups/ Teams' => '可以管理子群组/团队',
    'Can manage agents' => '可以管理接单员',
    'Can manage agent privileges' => '可以管理接单员权限',
    'Can manage ticket types' => '可以管理工单类型',
    'Can manage ticket custom fields' => '可以管理工单自定义字段',
    'Can manage customers' => '可以管理客户',
    'Can manage Prepared Responses' => '可以管理准备好的响应',
    'Can manage Automatic workflow' => '可以管理自动工作流程',
    'Can manage tags' => '可以管理标记',
    'Can manage knowledgebase' => '可以管理知识库',
    'Can manage Groups Saved Reply' => '可以管理群组已保存的回复',
    'Add Privilege' => '添加权限',
    'Choose set of privileges which will be available to the agent.' => '选择将对接单员可用的权限集。',
    'Advanced' => '高级的',
    'Privilege Name must have characters only' => '权限名称只能包含字符',
    'Maximum character length is 50' => '最大字符长度为50',
    'Open Tickets' => '开放工单',
    'New Customer' => '新客户',
    'New Agent' => '新接单员',
    'Total Article(s)' => '文章总数',
    'Please specify a valid email address' => '请指定一个有效的电子邮件地址',
    'Please enter the password associated with your email address' => '请输入与您的电子邮件地址关联的密码',
    'Please enter your server host address' => '请输入您的服务器主机地址',
    'Please specify a port number to connect with your mail server' => '请指定用于连接您的邮件服务器的端口号',
    'Success ! Branding details saved successfully.' => '成功 ！品牌推广详细信息已成功保存。',
    'Success ! Time details saved successfully.' => '成功 ！时间详细信息已成功保存。',
    'Spam setting saved successfully.' => '垃圾邮件设置已成功保存。',
    'Please specify a valid name for your mailbox.' => '请为您的邮箱指定一个有效的名称。',
    'Please select a valid swift-mailer configuration.' => '请选择一个有效的快捷邮件管理器配置。',
    'Please specify a valid host address.' => '请指定一个有效的主机地址。',
    'Please specify a valid email address.' => '请指定一个有效的电子邮件地址。',
    'Please enter the associated account password.' => '请输入关联的帐户密码。',
    'New Saved Reply' => '新保存的回复',
    'New Category' => '新类别',
    'Folder' => '文件夹',
    'Category' => '类别',
    'Created' => '已建立',
    'All Articles' => '所有文章',
    'Viewed' => '已查看',
    'New Article' => '新文章',
    'Thank you for your feedback!' => '感谢您的反馈意见！',
    'Was this article helpful?' => '本文是否有帮助？',
    'Helpdesk' => '服务台',
    'Support Center' => '支持中心',
    'Mailboxes' => '邮箱',
    'By' => '经过',
    'Search Tickets' => '搜索工单',
    'Customer Information' => '客户信息',
    'Total Replies' => '所有回复',
    'Filter With' => '筛选方式',
    'Type email to add' => '输入电子邮件以添加',
    'Collaborators' => '合作者',
    'Labels' => '标签',
    'Group' => '群组',
    'Stay on ticket' => '留在工单',
    'Redirect to list' => '重定向到列表',
    'Nothing interesting here...' => '这里没什么有趣的...',
    'Previous Ticket' => '上一工单',
    'Next Ticket' => '下一工单',
    'Forward' => '向前',
    'Note' => '注释',
    'Write a reply' => '写回复',
    'Created Ticket' => '已创建工单',
    'All Threads' => '所有线程',
    'Forwards' => '转发',
    'Notes' => '注释',
    'Pinned' => '固定',
    'Edit Ticket' => '编辑工单',
    'Print Ticket' => '打印工单',
    'Mark as Spam' => '标记为垃圾邮件',
    'Mark as Closed' => '标记为已关闭',
    'Delete Ticket' => '删除工单',
    'View order details from different eCommerce channels' => '查看来自不同电子商务渠道的订单详细信息',
    'ECOMMERCE CHANNELS' => '电子商务渠道',
    'Select channel' => '选择渠道',
    'Order Id' => '订单编号',
    'Fetch Order' => '取货单',
    'No orders have been integrated to this ticket yet.' => '尚无订单被集成到此工单。',
    'Enter your credentials below to gain access to your helpdesk account.' => '在下面输入您的凭据即可访问您的服务台帐户。',
    'Keep me logged in' => '保持登录状态',
    'Forgot Password?' => '忘记密码？',
    'Log in to your' => '登录到您的',
    'Sign In' => '登入',
    'Edit Customer' => '编辑客户',
    'Update' => '更新',
    'Discard' => '丢弃',
    'Cancel' => '取消',
    'Not Assigned' => '未分配',
    'Submit' => '提交',
    'Submit And Open' => '提交并打开',
    'Submit And Pending' => '提交并待定',
    'Submit And Answered' => '提交并回答',
    'Submit And Resolved' => '提交并解决',
    'Submit And Closed' => '提交并关闭',
    'Choose a Color' => '选择一种颜色',
    'Create' => '创建',
    'Edit Label' => '编辑标签',
    'Add Label' => '添加标签',
    'To' => '至',
    'Ticket' => '工单',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => '您的浏览器不支持JavaScript或您禁用了JavaScript，请启用这些功能！',
    'Confirm Action' => '确认动作',
    'Confirm' => '确认',
    'No result found' => '找不到结果',
    'ticket delivery status' => '工单交付状态',
    'Warning! Select valid image file.' => '警告！选择有效的图像文件。',
    'Error' => '错误',
    'Save' => '保存',
    'SEO' => '搜索引擎优化',
    'Edit Saved Filter' => '编辑已保存的筛选器',
    'Type atleast 2 letters' => '输入至少2个字母',
    'Remove Label' => '移除标签',
    'New Saved Filter' => '新保存的筛选器',
    'Is Default' => '是默认值',
    'Remove Saved Filter' => '删除保存的筛选器',
    'Ticket Info' => '工单信息',
    'Last Replied Agent' => '最后回复的接单员',
    'created Ticket' => '已创建的工单',
    'Uploaded Files' => '已上传的文件',
    'Download (as .zip)' => '下载（作为.zip文件）',
    'made last reply' => '做最后回复',
    'N/A' => '不适用',
    'Unassigned' => '未分配',
    'Label' => '标签',
    'Assigned to me' => '分配给我',
    'Search Query' => '搜索查询',
    'Searching' => '搜寻中',
    'Saved Filter' => '保存的筛选器',
    'No Label Created' => '没有创建标签',
    'Label with same name already exist.' => '具有相同名称的标签已存在。',
    'Create New' => '创建新的',
    'Mail status' => '邮件状态',
    'replied' => '回复',
    'added note' => '增加的注释',
    'forwarded' => '已转发',
    'TO' => '至',
    'CC' => '抄送',
    'BCC' => '密件抄送',
    'Locked' => '已锁定',
    'Edit Thread' => '编辑线程',
    'Delete Thread' => '删除线程',
    'Unpin Thread' => '取消固定线程',
    'Pin Thread' => '固定线程',
    'Unlock Thread' => '解锁线程',
    'Lock Thread' => '锁定线程',
    'Translate Thread' => '翻译线程',
    'Language' => '语言',
    'English' => '英语',
    'French' => '法语',
    'Italian' => '意大利语',
    'Arabic' => '阿拉伯语',
    'German' => '德语',
    'Spanish' => '西班牙语',
    'Turkish' => '土耳其语',
    'Danish' => '丹麦语',
    'System' => '系统语言',
    'Open in Files' => '在文件中打开',
    'Email address is invalid' => '电子邮箱地址不可用',
    'Tag with same name already exist' => '具有相同名称的标记已存在',
    'Text length should be less than 20 charactors' => '文字长度应少于20个字符',
    'Label with same name already exist' => '具有相同名称的标签已存在',
    'Agent Name' => '接单员名称',
    'Agent Email' => '接单员电子邮件',
    'open' => '打开',
    'Currently active agents on ticket' => '当前在工单上活跃的接单员',
    'Edit Customer Information' => '编辑客户信息',
    'Restore' => '恢复',
    'Delete Forever' => '永久删除',
    'Add Team' => '新增团队',
    'delete' => '删除',
    'You didnt have any folder for current filter(s).' => '您没有用于当前筛选器的任何文件夹。',
    'Add Folder' => '新增文件夹',
    'This field must have valid characters only' => '此字段只能包含有效字符',
    'Can edit task' => '可以编辑任务',
    'Can create task' => '可以创建任务',
    'Can delete task' => '可以删除任务',
    'Can add member to task' => '可以将成员添加到任务',
    'Can remove member from task' => '可以从任务中删除成员',
    'Agent Privileges' => '接单员权限',
    'Agent Privilege represents overall permissions in System.' => '接单员权限代表系统中的总体许可权限。',
    'Ticket View' => '工单视图',
    'User can view tickets based on selected scope.' => '用户可以根据所选范围查看工单。',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => '如果是个人访问，则用户只能查看分配的工单；如果是团队访问，则用户可以查看他所属的团队的所有工单，依此类推',
    'Global Access' => '全局访问',
    'Group Access' => '群组访问',
    'Team Access' => '团队访问',
    'Individual Access' => '个人访问',
    'This field must have characters only' => '此字段只能包含字符',
    'Maximum character length is 40' => '最大字符长度为40',
    'This is not a valid email address' => '这个电子邮件地址无效',
    'Password must contains 8 Characters' => '密码必须包含8个字符',
    'The passwords does not match' => '密码不匹配',
    'Enabled' => '已启用',
    'Create Configuration' => '创建配置',
    'Swift Mailer Settings' => '快捷邮件管理器设置',
    'Username' => '用户名',
    'Please select a swiftmailer id' => '请选择一个快捷邮件管理器ID',
    'Please enter a valid e-mail id' => '请输入有效的电子邮件ID',
    'Please enter a mailer id' => '请输入一个邮件管理器ID',
    'Email Id' => '电子邮件ID',
    'Are you sure? You want to perform this action.' => '你确定吗？您要执行此操作。',
    'Reorder' => '重新排序',
    'New Workflow' => '新工作流程',
    'OR' => '或者',
    'AND' => '并且',
    'Please enter a valid name.' => '请输入有效的名字。',
    'Please select a value.' => '请选择一个值。',
    'Please add a value.' => '请添加一个值。',
    'This field is required' => '此字段是必需的',
    'or' => '或者',
    'and' => '并且',
    'Select a Condition' => '选择条件',
    'Loading...' => '载入中...',
    'Select Option' => '选择选项',
    'Inactive' => '不活跃',
    'New Type' => '新类型',
    'Placeholders' => '占位符',
    'Ticket Link' => '工单链接',
    'Id' => 'ID',
    'Preview' => '预览',
    'Sort Order' => '排序',
    'This field must be a number' => '该字段必须是数字',
    'User' => '用户',
    'Edit Group' => '编辑群组',
    'Group Status' => '群组状态',
    'Group is Active' => '群组处于活动状态',
    'Add Group' => '新增群组',
    'Contact number is invalid' => '联络电话无效',
    'Edit Agent' => '编辑接单员',
    'No Privilege added, Please add Privilege(s) first !' => '未添加权，请先添加权限！',
    'Edit Email Template' => '编辑电子邮件模板',
    'Edit Workflow' => '编辑工作流程',
    'Save Workflow' => '保存工作流程',
    'Edit Ticket Type' => '编辑工单类型',
    'Add Ticket Type' => '添加工单类型',
    'Date Released' => '发布日期',
    'Free' => '自由的',
    'Premium' => '优质的',
    'Installed' => '已安装',
    'Installed Applications' => '已安装的应用程序',
    'Apps Dashboard' => '应用程序仪表板',
    'Nothing Interesting here' => '这里没什么有趣的',
    'No Categories Added' => '未添加类别',
    'ticket' => '工单',
    'Add Email Template' => '添加电子邮件模板',
    'This field contain 100 characters only' => '该字段仅包含100个字符',
    'This field contain characters only' => '该字段仅包含字符',
    'Name length must not be greater than 200 !!' => '名称长度不能大于200！',
    'Warning! Correct all field values first!' => '警告！首先更正所有字段值！',
    'Warning ! This is not a valid request' => '警告 ！这是无效的要求',
    'Success ! Tag removed successfully.' => '成功 ！标记已成功删除。',
    'Success ! Tags Saved successfully.' => '成功 ！标签已成功保存。',
    'Success ! Revision restored successfully.' => '成功 ！修订已成功恢复。',
    'Success ! Categories updated successfully.' => '成功 ！类别已成功更新。',
    'Success ! Article Related removed successfully.' => '成功 ！相关文章已成功删除。',
    'Success ! Article Related is already added.' => '成功 ！相关文章已添加。',
    'Success ! Cannot add self as relative article.' => '成功 ！无法将自己添加为相关文章。',
    'Success ! Article Related updated successfully.' => '成功 ！相关文章已成功更新。',
    'Success ! Articles removed successfully.' => '成功 ！文章已成功删除。',
    'Success ! Article status updated successfully.' => '成功 ！文章状态已成功更新。',
    'Success ! Article star updated successfully.' => '成功 ！文章星标已成功更新。',
    'Success! Article updated successfully' => '成功！文章更新成功',
    'Success ! Category sort  order updated successfully.' => '成功 ！类别排序已成功更新。',
    'Success ! Category status updated successfully.' => '成功 ！类别状态已成功更新。',
    'Success ! Folders updated successfully.' => '成功 ！文件夹更新成功。',
    'Success ! Categories removed successfully.' => '成功 ！类别已成功删除。',
    'Success ! Category updated successfully.' => '成功 ！类别已成功更新。',
    'Error ! Category is not exist.' => '错误 ！类别不存在。',
    'Warning ! Customer Login disabled by admin.' => '警告 ！客户登录已被管理员禁用。',
    'This Email is not registered with us.' => '此电子邮件未在我处注册。',
    'Your password has been updated successfully.' => '您的密码已成功更新。',
    'Password dont match.' => '密码不匹配。',
    'Error ! Profile image is not valid, please upload a valid format' => '错误 ！个人资料图片无效，请上传有效格式',
    'Warning! Provide valid image file. (Recommened' => '警告！提供有效的图像文件。 （推荐',
    'Success! Folder has been added successfully.' => '成功！文件夹已成功添加。',
    'Folder updated successfully.' => '文件夹更新成功。',
    'Success ! Folder status updated successfully.' => '成功 ！文件夹状态已成功更新。',
    'Error ! Folder is not exist.' => '错误 ！文件夹不存在。',
    'Success ! Folder updated successfully.' => '成功 ！文件夹更新成功。',
    'Error ! Folder does not exist.' => '错误 ！文件夹不存在。',
    'Success ! Folder deleted successfully.' => '成功 ！文件夹已成功删除。',
    'Warning ! Folder doesnt exists!' => '警告 ！文件夹不存在！',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => '警告 ！给定电子邮件已被管理员阻止，因此无法创建工单。',
    'Success ! Ticket has been created successfully.' => '成功 ！工单已成功创建。',
    'Warning ! Can not create ticket, invalid details.' => '警告 ！无法创建工单，无效的详细信息。',
    'Warning ! Post size can not exceed 25MB' => '警告 ！帖子大小不能超过25MB',
    'Create Ticket Request' => '创建工单请求',
    'Success ! Reply added successfully.' => '成功 ！回复已成功添加。',
    'Warning ! Reply field can not be blank.' => '警告 ！回复字段不能为空。',
    'Success ! Rating has been successfully added.' => '成功 ！评分已成功添加。',
    'Warning ! Invalid rating.' => '警告 ！无效的评分。',
    'Error ! Can not add customer as a collaborator.' => '错误 ！无法将客户添加为协作者。',
    'Success ! Collaborator added successfully.' => '成功 ！协作者添加成功。',
    'Error ! Collaborator is already added.' => '错误 ！协作者已添加。',
    'Success ! Collaborator removed successfully.' => '成功 ！协作者已成功删除。',
    'Error ! Invalid Collaborator.' => '错误 ！无效的协作者。',
    'An unexpected error occurred. Please try again later.' => '一个意料之外的问题发生了。请稍后再试。',
    'Feedback saved successfully.' => '反馈已成功保存。',
    'Feedback updated successfully.' => '反馈已成功更新。',
    'Invalid feedback provided.' => '提供了无效的反馈。',
    'Article not found.' => '找不到文章。',
    'You need to login to your account before can perform this action.' => '您需要先登录帐户，然后才能执行此操作。',
    'Warning! Please add valid Actions!' => '警告！请添加有效的动作！',
    'Warning! In Free Plan you can not change Events!' => '警告！在免费计划中，您无法更改事件！',
    'Success! Prepared Response has been updated successfully.' => '成功！准备好的响应已成功更新。',
    'Success! Prepared Response has been added successfully.' => '成功！准备好的响应已成功添加。',
    'Warning  This is not a valid request' => '警告这不是有效的请求',
    'Use Default Colors' => '使用默认颜色',
    'Masonry' => 'Masonry',
    'Popular Article' => '热门文章',
    'Manage Ticket Custom Fields' => '管理工单自定义字段',
    'You dont have premission to edit this Prepared response' => '您没有权限编辑此准备好的响应',
    'Save Prepared Response' => '保存准备好的响应',
    'Success ! Prepared response removed successfully.' => '成功 ！准备好的响应已成功删除。',
    'Warning! You are not allowed to perform this action.' => '警告！您无权执行此操作。',
    'Success! Workflow has been updated successfully.' => '成功！工作流程已成功更新。',
    'Success! Workflow has been added successfully.' => '成功！工作流程已成功添加。',
    'Success! Order has been updated successfully.' => '成功！订单已成功更新。',
    'Success! Workflow has been removed successfully.' => '成功！工作流程已成功删除。',
    'Mailbox successfully created.' => '邮箱已成功创建。',
    'Mailbox successfully updated.' => '邮箱已成功更新。',
    'Warning ! Bad request !' => '警告 ！错误的请求 ！',
    'Error! Given current password is incorrect.' => '错误！给出的当前密码不正确。',
    'Success ! Profile update successfully.' => '成功 ！个人资料更新成功。',
    'Error ! User with same email is already exist.' => '错误 ！具有相同电子邮件的用户已经存在。',
    'Success ! Agent updated successfully.' => '成功 ！接单员已成功更新。',
    'Success ! Agent removed successfully.' => '成功 ！接单员已成功删除。',
    'Warning ! You are allowed to remove account owners account.' => '警告 ！您可以删除帐户所有者帐户。',
    'Error ! Invalid user id.' => '错误 ！无效的用户ID。',
    'Success ! Filter has been saved successfully.' => '成功 ！筛选器已成功保存。',
    'Success ! Filter has been updated successfully.' => '成功 ！筛选器已成功更新。',
    'Success ! Filter has been removed successfully.' => '成功 ！筛选器已成功删除。',
    'Please check your mail for password update.' => '请检查您的邮件以获取密码更新。',
    'This Email address is not registered with us.' => '此电子邮件地址未在我处注册。',
    'Success ! Customer saved successfully.' => '成功 ！客户保存成功。',
    'Error ! User with same email already exist.' => '错误 ！具有相同电子邮件的用户已存在。',
    'Success ! Customer information updated successfully.' => '成功 ！客户信息更新成功。',
    'Success ! Customer updated successfully.' => '成功 ！客户更新成功。',
    'Error ! Customer with same email already exist.' => '错误 ！使用相同电子邮件的客户已经存在。',
    'unstarred Action Completed successfully' => '未加星标的动作已成功完成',
    'starred Action Completed successfully' => '已加星标的动作已成功完成',
    'Success ! Customer removed successfully.' => '成功 ！客户已成功删除。',
    'Error ! Invalid customer id.' => '错误 ！无效的客户ID。',
    'Success! Template has been updated successfully.' => '成功！模板已成功更新。',
    'Success! Template has been added successfully.' => '成功！模板已成功添加。',
    'Success! Template has been deleted successfully.' => '成功！模板已成功删除。',
    'Warning! resource not found.' => '警告！找不到资源。',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => '警告！您无法删除工作流中正在使用的预定义电子邮件模板。',
    'Success ! Email settings are updated successfully.' => '成功 ！电子邮件设置已成功更新。',
    'Success ! Group information updated successfully.' => '成功 ！群组信息已成功更新。',
    'Success ! Group information saved successfully.' => '成功 ！群组信息已成功保存。',
    'Support Group removed successfully.' => '支持群组已成功删除。',
    'Success ! Privilege information saved successfully.' => '成功 ！权限信息已成功保存。',
    'Privilege updated successfully.' => '权限已成功更新。',
    'Support Privilege removed successfully.' => '支持权限已成功删除。',
    'Success! Reply has been updated successfully.' => '成功！回复已成功更新。',
    'Success! Reply has been added successfully.' => '成功！回复已成功添加。',
    'Success! Saved Reply has been deleted successfully' => '成功！已保存的回复已成功删除',
    'SwiftMailer configuration updated successfully.' => '快捷邮件管理器配置已成功更新。',
    'Swiftmailer configuration removed successfully.' => '快捷邮件管理器配置已成功删除。',
    'Success ! Team information saved successfully.' => '成功 ！团队信息已成功保存。',
    'Success ! Team information updated successfully.' => '成功 ！团队信息已成功更新。',
    'Support Team removed successfully.' => '支持团队已成功删除。',
    'Success! Reply has been added successfully' => '成功！回复已成功添加',
    'Success ! Thread updated successfully.' => '成功 ！线程更新成功。',
    'Error ! Reply field can not be blank.' => '错误 ！回复字段不能为空。',
    'Success ! Thread removed successfully.' => '成功 ！线程已成功删除。',
    'Success ! Thread locked successfully' => '成功 ！线程已成功锁定',
    'Success ! Thread unlocked successfully' => '成功 ！线程已成功解锁',
    'Success ! Thread pinned successfully' => '成功 ！线程已成功固定',
    'Error ! Invalid thread.' => '错误 ！无效的线程。',
    'Could not create ticket, invalid details.' => '无法创建工单，无效的详细信息。',
    'Success ! Tag updated successfully.' => '成功 ！标记已成功更新。',
    'Error ! Customer can not be added as collaborator.' => '错误 ！无法将客户添加为协作者。',
    'Success ! Tag unassigned successfully.' => '成功 ！标记取消分配成功。',
    'Success ! Tag added successfully.' => '成功 ！标记添加成功。',
    'Please enter tag name.' => '请输入标记名称。',
    'Error ! Invalid tag.' => '错误 ！无效的标记。',
    'Success ! Type removed successfully.' => '成功 ！类型已成功删除。',
    'Success ! Ticket to label removed successfully.' => '成功 ！标签工单已成功删除。',
    'Unable to retrieve support team details' => '无法检索支持团队的详细信息',
    'Ticket support group updated successfully' => '工单支持群组已成功更新',
    'Unable to retrieve status details' => '无法检索状态详细信息',
    'Insufficient details provided.' => '提供的详细信息不足。',
    'Error! Subject field is mandatory' => '错误！主题字段为必填项',
    'Error! Reply field is mandatory' => '错误！回复字段为必填项',
    'Success ! Ticket has been updated successfully.' => '成功 ！工单已成功更新。',
    'Success ! Label updated successfully.' => '成功 ！标签已成功更新。',
    'Error ! Invalid label id.' => '错误 ！无效的标签ID。',
    'Success ! Label removed successfully.' => '成功 ！标签已成功删除。',
    'Success ! Label created successfully.' => '成功 ！标签创建成功。',
    'Error ! Label name can not be blank.' => '错误 ！标签名称不能为空。',
    'Success ! Ticket moved to trash successfully.' => '成功 ！工单已成功移至垃圾箱。',
    'Success! Ticket type saved successfully.' => '成功！工单类型已成功保存。',
    'Success! Ticket type updated successfully.' => '成功！工单类型已成功更新。',
    'Error! Ticket type with same name already exist' => '错误！具有相同名称的工单类型已存在',
    'SAVE' => '保存',
    'customer page' => '客户页面',
    'Howdy!' => '你好！',
    'New Ticket Request' => '请求开新工单',
    'Ticket Requests' => '工单请求',
    'Tickets have been updated successfully' => '工单已成功更新',
    'Please check your mail for password update' => '请检查您的邮件以获取密码更新',
    'This email address is not registered with us' => '此电子邮件地址未在我处注册',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => '您已经使用此链接更新了密码的话，如果您想再次更改密码，单击登录页面上的“忘记密码”链接。',
    'Your password has been successfully updated. Login using updated password' => '你的密码已被成功更新。使用更新的密码登录',
    'Please try again, The passwords do not match' => '请重试，密码不匹配',
    'Support Privilege removed successfully' => '支持权限已成功删除',
    'Success! Saved Reply has been deleted successfully.' => '成功！已保存的回复已成功删除。',
    'SwiftMailer configuration created successfully.' => '快捷邮件管理器配置成功创建。',
    'No swiftmailer configurations found for mailer id' => '找不到为此邮件发件人ID的快捷邮件管理器配置',
    'Reply content cannot be left blank.' => '回复内容不能为空。',
    'Reply added to the ticket and forwarded successfully.' => '已将回复添加到工单并成功转发。',
    'Success ! Thread pinned successfully.' => '成功 ！线程已成功固定。',
    'Success ! unpinned removed successfully.' => '成功 ！取消固定已成功删除。',
    'Unable to retrieve priority details' => '无法检索优先级详细信息',
    'Ticket support team updated successfully' => '工单支持团队已成功更新',
    'Ticket assigned to support group ' => '工单已分配给支持群组',
    'Mailbox configuration removed successfully.' => '邮箱配置已成功删除。',
    'visit our website' => '访问我们的网站',
    'Cookie Usage Policy' => 'Cookie使用政策',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => '帮助',
    'Home' => '主页',
    'Cookie Policy' => 'Cookie政策',
    'Prev' => '上一个',
    'Ticket query message' => '工单查询消息',
    'Select type' => '选择类型',
    'Search KnowledgeBase' => '搜索知识库',
    'You cant merge an account with itself.' => '您无法将帐户与其自身合并。',
    'Edit Profile' => '编辑个人资料',
    'Customer Login' => '客户登入',
    'Contact Us' => '联系我们（开新工单）',
    'If you have ever contacted our support previously, your account would have already been created.' => '如果您以前在我们的支持中心联系过，那么您的帐户则已经被创建。',
    'support' => '支持',
    'HelpDesk' => '服务台',
    'Enter search keyword' => '输入搜索关键字',
    'Browse via Folders' => '通过文件夹浏览',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => '寻找一般查询的内容？从下面选择一个相关的文件夹以探索可能的解决方案',
    'Unable to find an answer?' => '找不到答案？',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => '寻找常规查询中包含的任何特定文章？只需浏览各种相关的文件夹和类别，即可找到所需的文章。',
    'Popular Articles' => '热门文章',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => '以下是一些最受欢迎的文章，它们帮助许多用户解决了他们的查询和问题。',
    'Browse via Categories' => '通过分类浏览',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => '寻找特定的东西吗？从下面选择一个相关类别以探索可能的解决方案',
    'No Categories Found!' => '找不到分类！',
    'Powered by' => '技术动力提供',
    'Forgot Password' => '忘记密码',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => '输入您的电子邮件地址，我们将向您发送一封电子邮件，其中包含更新登录凭据的说明。',
    'Send Mail' => '发送邮件',
    'Sign In to %websitename%' => '登录 ％websitename％',
    'Enter your name' => '输入你的名字',
    'Enter your email' => '输入你的电子邮箱',
    'Learn more about %deliveryStatus%.' => '了解有关％deliveryStatus％的更多信息。',
    'To know more about how our privacy policy works, please %websiteLink%.' => '要了解有关我们的隐私政策如何运作的更多信息，请％websiteLink％。',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => '我们的某些网站页面使用％cookies％和其他跟踪技术。 ％cookie％是一个小型文本文件，可用于例如收集有关站点活动的信息。某些cookie和其他技术可能有助于回忆起站点用户先前指示的个人信息。您可以通过在浏览器上调整适当的设置来阻止cookie或删除现有的cookie。请查阅浏览器的％help％菜单以了解如何执行此操作。如果您阻止或删除％cookies％，您可能会发现我们网站的实用性受到损害。',
    'This field contain maximum 40 charectures.' => '该字段最多包含40个字符。',
    'This field contain maximum 50 charectures.' => '该字段最多包含50个字符。',
    '#misc' => '#杂项',
    'Time' => '时间',
    'Links' => '链接',
    'Broadcast Message' => '广播消息',
    'Wide Logo' => '宽幅徽标',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => '上载PNG或JPG格式的图片（200px x 48px）',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => '它将在知识库和服务台上显示为徽标',
    'Website Status' => '网站状态',
    'Enable front end website and knowledgebase for customer(s)' => '为客户启用前端网站和知识库',
    'Brand Color' => '品牌颜色',
    'Page Background Color' => '页面背景色',
    'Header Background Color' => '标头背景色',
    'Banner Background Color' => '横幅背景色',
    'Page Link Color' => '页面链接颜色',
    'Page Link Hover Color' => '页面链接悬停颜色',
    'Article Text Color' => '文章文字颜色',
    'Tag Line' => '标记行',
    'Hi! how can we help?' => '你好！我们能帮你什么吗？',
    'Layout' => '布局',
    'Ticket Create Option' => '工单创建选项',
    'Login Required To Create Tickets' => '必须先登录才能创建工单',
    'Remove Customer Login/Signin Button' => '删除客户登录/签入按钮',
    'Disable Customer Login' => '禁用客户登录',
    'Meta Description (Recommended)' => '元描述（推荐）',
    'Meta Keywords (Recommended)' => '元关键字（推荐）',
    'Header Link' => '标题链接',
    'URL (with http' => '网址（带http',
    'Footer Link' => '页脚链接',
    'Custom CSS (Optional)' => '自定义CSS（可选）',
    'It will be add to the frontend knowledgebase only' => '仅将其添加到前端知识库中',
    'Custom Javascript (Optional)' => '自定义Javascript（可选）',
    'Broadcast message content to show on helpdesk' => '广播消息内容将显示在服务台上',
    'From' => '从',
    'Time duration between which message will be displayed(if applicable)' => '显示消息的持续时间（如果适用）',
    'Broadcasting Status' => '广播状态',
    'Broadcasting is Active' => '广播处于活动状态',
    'Choose a default company timezone' => '选择默认的公司时区',
    'Date Time Format' => '日期时间格式',
    'Choose a format to convert date to specified date time format' => '选择一种格式以将日期转换为指定的日期时间格式',
    'An empty file is not allowed.' => '不允许为空文件。',
    'File size must not be greater than 200KB !!' => '文件大小不能大于200KB！',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => '请上传有效的图片文件（仅允许JPEG，JPG，PNG）！',
    'Provide a valid url(with protocol)' => '提供有效的网址（带有协议）',
    'ticket.message.placeHolders.info' => 'ticket.message.placeHolders.info',
    'ticket.attachments.placeHolders.info' => 'ticket.attachments.placeHolders.info',
    'ticket.threadMessage.placeHolders.info' => 'ticket.threadMessage.placeHolders.info',
    'ticket.tags.placeHolders.info' => 'ticket.tags.placeHolders.info',
    'ticket.source.placeHolders.info' => 'ticket.source.placeHolders.info',
    'ticket.collaborator.name.placeHolders.info' => 'ticket.collaborator.name.placeHolders.info',
    'ticket.collaborator.email.placeHolders.info' => 'ticket.collaborator.email.placeHolders.info',
    'user.name.info' => 'user.name.info',
    'user.email.info' => 'user.email.info',
    'user.account.validate.link.info' => 'user.account.validate.link.info',
    'user.password.forgot.link.info' => 'user.password.forgot.link.info',
    'global.companyName' => 'global.companyName',
    'global.companyLogo' => 'global.companyLogo',
    'global.companyUrl' => 'global.companyUrl',
    'ticket.priority.placeHolders.info' => 'ticket.priority.placeHolders.info',
    'ticket.group.placeHolders.info' => 'ticket.group.placeHolders.info',
    'ticket.team.placeHolders.info' => 'ticket.team.placeHolders.info',
    'ticket.customerName.placeHolders.info' => 'ticket.customerName.placeHolders.info',
    'ticket.customerEmail.placeHolders.info' => 'ticket.customerEmail.placeHolders.info',
    'ticket.agentName.placeHolders.info' => 'ticket.agentName.placeHolders.info',
    'ticket.agentEmail.placeHolders.info' => 'ticket.agentEmail.placeHolders.info',
    'ticket.link.placeHolders.info' => 'ticket.link.placeHolders.info',
    'ticket.id.placeHolders.info' => 'ticket.id.placeHolders.info',
    'ticket.subject.placeHolders.info' => 'ticket.subject.placeHolders.info',
    'ticket.status.placeHolders.info' => 'ticket.status.placeHolders.info',
    'comma "," separated' => '逗号分隔',
    'Low' => '低',
    'Medium' => '中等',
    'High' => '高',
    'Urgent' => '紧迫',
    'Reset Password' => '重设密码',
    'Enter your new password below to update your login credentials' => '在下面输入您的新密码以更新您的登录凭据',
    'Save Password' => '保存密码',
    'Rate Support' => '速率支持',
    'I am very Sad' => '我很难过',
    'I am Sad' => '我很伤心',
    'I am Neutral' => '我是中立的',
    'I am Happy' => '我很开心',
    'I am Very Happy' => '我很高兴',
    'Kudos' => '点赞',
    'Very Sad' => '很伤心',
    'Sad' => '伤心',
    'Neutral' => '中性的',
    'Happy' => '快乐的',
    'Very Happy' => '很高兴',
    'Star(s)' => '星星',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => '警告 ！ Swiftmailer 不工作。發送電子郵件時發生錯誤！',
    'Invalid credentials.' => '无效证件',
    'Success ! Project cache cleared successfully.' => '成功 ！项目缓存已成功清除。',
    'clear cache' => '清除缓存',
    'Last Updated' => '最近更新时间',
    'Error! Something went wrong.' => '错误！出了些问题。',
    'We were not able to find the page you are looking for.' => '我们无法找到您要查找的页面。',
    'Page not found' => '找不到网页',
    'Forbidden' => '禁止的',
    'You don’t have the necessary permissions to access this Web page :(' => '您没有访问此网页的必要权限 :(',
    'Internal server error' => '内部服务器错误',
    'Our system has goofed up for a while, but good part is it won\'t last long' => '我们的系统已经有一段时间了，但好的部分是它不会持续很长时间',
    'Unknown Error' => '未知错误',
    'We are quite confused about how did you land here:/' => '我们很困惑你是怎么在这里着陆的 :/',
    'Few of the links which may help you to get back on the track -' => '很少有链接可以帮助您重回正轨 -',
  ),
));
$catalogue->addFallbackCatalogue($catalogueZh);
$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This value should be a valid expression.' => 'This value should be a valid expression.',
    'This value is not a valid CSS color.' => 'This value is not a valid CSS color.',
    'This value is not a valid CIDR notation.' => 'This value is not a valid CIDR notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'The value of the netmask should be between {{ min }} and {{ max }}.',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
    'filter_searchword' => 'Searchword...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Signed in as',
    'Your Profile' => 'Your Profile',
    'Create Ticket' => 'Create Ticket',
    'Create Agent' => 'Create Agent',
    'Create Customer' => 'Create Customer',
    'Sign Out' => 'Sign Out',
    'Reports' => 'Reports',
    'Rating' => 'Rating',
    'Kudos Rating' => 'Kudos Rating',
    'Remove profile picture' => 'Remove profile picture',
    'Success ! Profile updated successfully.' => 'Success ! Profile updated successfully.',
    'Howdy' => 'Howdy',
    'Form successfully updated.' => 'Form successfully updated.',
    'NEW FORM' => 'NEW FORM',
    'Text Box' => 'Text Box',
    'Text Area' => 'Text Area',
    'Select' => 'Select',
    'Radio' => 'Radio',
    'Checkbox' => 'Checkbox',
    'Date' => 'Date',
    'Both Date and Time' => 'Both Date and Time',
    'Choose a status' => 'Choose a status',
    'Choose a group' => 'Choose a group',
    'Choose your default timeformat' => 'Choose your default timeformat',
    'Can manage Group\'s Saved Reply' => 'Can manage Group\'s Saved Reply',
    'Can manage agent activity' => 'Can manage agent activity',
    'Can manage marketing announcement' => 'Can manage marketing announcement',
    'User Forgot Password' => 'User Forgot Password',
    'Agent Deleted' => 'Agent Deleted',
    'Agent Update' => 'Agent Update',
    'Customer Update' => 'Customer Update',
    'Customer Deleted' => 'Customer Deleted',
    'Agent Updated' => 'Agent Updated',
    'Agent Reply' => 'Agent Reply',
    'Collaborator Added' => 'Collaborator Added',
    'Collaborator Reply' => 'Collaborator Reply',
    'Customer Reply' => 'Customer Reply',
    'Ticket Deleted' => 'Ticket Deleted',
    'Group Updated' => 'Group Updated',
    'Note Added' => 'Note Added',
    'Priority Updated' => 'Priority Updated',
    'Status Updated' => 'Status Updated',
    'Team Updated' => 'Team Updated',
    'Thread Updated' => 'Thread Updated',
    'Type Updated' => 'Type Updated',
    'From Email' => 'From Email',
    'To Email' => 'To Email',
    'Is Equal To' => 'Is Equal To',
    'Is Not Equal To' => 'Is Not Equal To',
    'Contains' => 'Contains',
    'Does Not Contain' => 'Does Not Contain',
    'Starts With' => 'Starts With',
    'Ends With' => 'Ends With',
    'Before On' => 'Before On',
    'After On' => 'After On',
    'Mail To User' => 'Mail To User',
    'Transfer Tickets' => 'Transfer Tickets',
    'Mail To Customer' => 'Mail To Customer',
    'Permanently delete from Inbox' => 'Permanently delete from Inbox',
    'Agent Activity' => 'Agent Activity',
    'Report From' => 'Report From',
    'Search Agent' => 'Search Agent',
    'Agent Last Reply' => 'Agent Last Reply',
    'View analytics and insights to serve a better experience for your customers' => 'Analytics and insight regarding your workflow',
    'Marketing Announcement' => 'Marketing Announcement',
    'Advertisment' => 'Advertisment',
    'Announcement' => 'Announcement',
    'New Announcement' => 'New Announcement',
    'Add Announcement' => 'Add Announcement',
    'Edit Announcement' => 'Edit Announcement',
    'Promo Text' => 'Promo Text',
    'Promo Tag' => 'Promo Tag',
    'Choose a promo tag' => 'Choose a promo tag',
    'Tag-Color' => 'Tag-Color',
    'Tag background color' => 'Tag background color',
    'Link Text' => 'Link Text',
    'Link URL' => 'Link URL',
    'Apps' => 'Apps',
    'Integrate apps as per your needs to get things done faster than ever' => 'Install new custom apps to boost your productivity.',
    'Explore Apps' => 'Explore Apps',
    'Form Builder' => 'Form Builder',
    'Knowledgebase' => 'Knowledgebase',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'Help your customers help themselves! Save time on support by building your knowledge base.',
    'Articles' => 'Articles',
    'Categories' => 'Categories',
    'Folders' => 'Folders',
    'FOLDERS' => 'FOLDERS',
    'Productivity' => 'Productivity',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Create automation rules to speed up your workflow.',
    'Prepared Responses' => 'Prepared Responses',
    'Saved Replies' => 'Saved Replies',
    'Edit Saved Reply' => 'Edit Saved Reply',
    'Ticket Types' => 'Ticket Types',
    'Workflows' => 'Workflows',
    'Settings' => 'Settings',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Manage your Brand Identity, Company Information and other details at a glance',
    'Branding' => 'Branding',
    'Custom Fields' => 'Custom Fields',
    'Email Settings' => 'Email Settings',
    'Email Templates' => 'Email Templates',
    'Mailbox' => 'Mailbox',
    'Spam Settings' => 'Spam Settings',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Tags',
    'Users' => 'Users',
    'Control your Groups, Teams, Agents and Customers' => 'Manage your Groups, Teams, Agents and Customers',
    'Agents' => 'Agents',
    'Customers' => 'Customers',
    'Groups' => 'Groups',
    'Privileges' => 'Privileges',
    'Teams' => 'Teams',
    'Applications' => 'Applications',
    'ECommerce Order Syncronization' => 'eCommerce Order Syncronization',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Import eCommerce order details to your support tickets from different available platforms',
    'Search' => 'Search',
    'Sort By' => 'Sort By',
    'Sort By:' => 'Sort By:',
    'Status' => 'Status',
    'Created At' => 'Created At',
    'Name' => 'Name',
    'All' => 'All',
    'Published' => 'Published',
    'Draft' => 'Draft',
    'New Folder' => 'New Folder',
    'Create Knowledgebase Folder' => 'Create Knowledgebase Folder',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'You don\'t have any folders yet! Create your first folder and start adding articles.',
    'Clear Filters' => 'Clear Filters',
    'Back' => 'Back',
    'Open' => 'Open',
    'Pending' => 'Pending',
    'Answered' => 'Answered',
    'Resolved' => 'Resolved',
    'Closed' => 'Closed',
    'Spam' => 'Spam',
    'New' => 'New',
    'UnAssigned' => 'Unassigned',
    'UnAnswered' => 'Unanswered',
    'My Tickets' => 'My Tickets',
    'Starred' => 'Starred',
    'Trashed' => 'Trashed',
    'New Label' => 'New Label',
    'Tickets' => 'Tickets',
    'Ticket Id' => 'Ticket Id',
    'Last Replied' => 'Last Replied',
    'Assign To' => 'Assign To',
    'After Reply' => 'After Reply',
    'Customer Email' => 'Customer Email',
    'Customer Name' => 'Customer Name',
    'Assets Visibility' => 'Assets Visibility',
    'Channel/Source' => 'Channel/Source',
    'Channel' => 'Channel',
    'Website' => 'Website',
    'Timestamp' => 'Timestamp',
    'TimeStamp' => 'TimeStamp',
    'Team' => 'Team',
    'Type' => 'Type',
    'Replies' => 'Replies',
    'Agent' => 'Agent',
    'ID' => 'ID',
    'Subject' => 'Subject',
    'Last Reply' => 'Last Reply',
    'Filter View' => 'Filter View',
    'Please select CAPTCHA' => 'Please select CAPTCHA',
    'Warning ! Please select correct CAPTCHA !' => 'CAPTCHA Failed, please try again',
    'reCAPTCHA Setting' => 'reCAPTCHA Setting',
    'reCAPTCHA Site Key' => 'reCAPTCHA Site Key',
    'reCAPTCHA Secret key' => 'reCAPTCHA Secret key',
    'reCAPTCHA Status' => 'reCAPTCHA Status',
    'reCAPTCHA is Active' => 'reCAPTCHA is Active',
    'Save set of filters as a preset to stay more productive' => 'Save filters as preset',
    'Saved Filters' => 'Saved Filters',
    'No saved filter created' => 'No saved filter created',
    'Customer' => 'Customer',
    'Priority' => 'Priority',
    'Tag' => 'Tag',
    'Source' => 'Source',
    'Before' => 'Before',
    'After' => 'After',
    'Replies less than' => 'Replies less than',
    'Replies more than' => 'Replies more than',
    'Clear All' => 'Clear All',
    'Account' => 'Account',
    'Profile' => 'Profile',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format',
    'First Name' => 'First Name',
    'Last Name' => 'Last Name',
    'Email' => 'Email',
    'Contact Number' => 'Contact Number',
    'Timezone' => 'Timezone',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Asmara' => 'Africa/Asmara',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Dakar' => 'Africa/Dakar',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Douala' => 'Africa/Douala',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Harare' => 'Africa/Harare',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Juba' => 'Africa/Juba',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Kigali' => 'Africa/Kigali',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lagos' => 'Africa/Lagos',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'America/Adak' => 'America/Adak',
    'America/Anchorage' => 'America/Anchorage',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Araguaina' => 'America/Araguaina',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Salta' => 'America/Argentina/Salta',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/San_Luis' => 'America/Argentina/San_Luis',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/Asuncion' => 'America/Asuncion',
    'America/Atikokan' => 'America/Atikokan',
    'America/Bahia' => 'America/Bahia',
    'America/Bahia_Banderas' => 'America/Bahia_Banderas',
    'America/Barbados' => 'America/Barbados',
    'America/Belem' => 'America/Belem',
    'America/Belize' => 'America/Belize',
    'America/Blanc-Sablon' => 'America/Blanc-Sablon',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Bogota' => 'America/Bogota',
    'America/Boise' => 'America/Boise',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cancun' => 'America/Cancun',
    'America/Caracas' => 'America/Caracas',
    'America/Cayenne' => 'America/Cayenne',
    'America/Cayman' => 'America/Cayman',
    'America/Chicago' => 'America/Chicago',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Creston' => 'America/Creston',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Curacao' => 'America/Curacao',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Dawson' => 'America/Dawson',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Denver' => 'America/Denver',
    'America/Detroit' => 'America/Detroit',
    'America/Dominica' => 'America/Dominica',
    'America/Edmonton' => 'America/Edmonton',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Fort_Nelson' => 'America/Fort_Nelson',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Godthab' => 'America/Godthab',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Guayaquil' => 'America/Guayaquil',
    'America/Guyana' => 'America/Guyana',
    'America/Halifax' => 'America/Halifax',
    'America/Havana' => 'America/Havana',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Petersburg' => 'America/Indiana/Petersburg',
    'America/Indiana/Tell_City' => 'America/Indiana/Tell_City',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Indiana/Vincennes' => 'America/Indiana/Vincennes',
    'America/Indiana/Winamac' => 'America/Indiana/Winamac',
    'America/Inuvik' => 'America/Inuvik',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Jamaica' => 'America/Jamaica',
    'America/Juneau' => 'America/Juneau',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Kralendijk' => 'America/Kralendijk',
    'America/La_Paz' => 'America/La_Paz',
    'America/Lima' => 'America/Lima',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Lower_Princes' => 'America/Lower_Princes',
    'America/Maceio' => 'America/Maceio',
    'America/Managua' => 'America/Managua',
    'America/Manaus' => 'America/Manaus',
    'America/Marigot' => 'America/Marigot',
    'America/Martinique' => 'America/Martinique',
    'America/Matamoros' => 'America/Matamoros',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Menominee' => 'America/Menominee',
    'America/Merida' => 'America/Merida',
    'America/Metlakatla' => 'America/Metlakatla',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Miquelon' => 'America/Miquelon',
    'America/Moncton' => 'America/Moncton',
    'America/Monterrey' => 'America/Monterrey',
    'America/Montevideo' => 'America/Montevideo',
    'America/Montserrat' => 'America/Montserrat',
    'America/Nassau' => 'America/Nassau',
    'America/New_York' => 'America/New_York',
    'America/Nipigon' => 'America/Nipigon',
    'America/Nome' => 'America/Nome',
    'America/Noronha' => 'America/Noronha',
    'America/North_Dakota/Beulah' => 'America/North_Dakota/Beulah',
    'America/North_Dakota' => 'America/North_Dakota',
    'America/Ojinaga' => 'America/Ojinaga',
    'America/Panama' => 'America/Panama',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Phoenix' => 'America/Phoenix',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/Punta_Arenas' => 'America/Punta_Arenas',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Recife' => 'America/Recife',
    'America/Regina' => 'America/Regina',
    'America/Resolute' => 'America/Resolute',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santarem' => 'America/Santarem',
    'America/Santiago' => 'America/Santiago',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Sitka' => 'America/Sitka',
    'America/St_Barthelemy' => 'America/St_Barthelemy',
    'America/St_Johns' => 'America/St_Johns',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Thule' => 'America/Thule',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Tijuana' => 'America/Tijuana',
    'America/Toronto' => 'America/Toronto',
    'America/Tortola' => 'America/Tortola',
    'America/Vancouver' => 'America/Vancouver',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Yakutat' => 'America/Yakutat',
    'America/Yellowknife' => 'America/Yellowknife',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Macquarie' => 'Antarctica/Macquarie',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Troll' => 'Antarctica/Troll',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Arctic/Longyearbyen' => 'Arctic/Longyearbyen',
    'Asia/Aden' => 'Asia/Aden',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Atyrau' => 'Asia/Atyrau',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Barnaul' => 'Asia/Barnaul',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Chita' => 'Asia/Chita',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Famagusta' => 'Asia/Famagusta',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Hebron' => 'Asia/Hebron',
    'Asia/Ho_Chi_Minh' => 'Asia/Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Kathmandu' => 'Asia/Kathmandu',
    'Asia/Khandyga' => 'Asia/Khandyga',
    'Asia/Kolkata' => 'Asia/Kolkata',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Novokuznetsk' => 'Asia/Novokuznetsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Qostanay' => 'Asia/Qostanay',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Srednekolymsk' => 'Asia/Srednekolymsk',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Tomsk' => 'Asia/Tomsk',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Ust-Nera' => 'Asia/Ust-Nera',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Yangon' => 'Asia/Yangon',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Atlantic/Faroe' => 'Atlantic/Faroe',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Eucla' => 'Australia/Eucla',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Lord_Howe' => 'Australia/Lord_Howe',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Sydney' => 'Australia/Sydney',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Astrakhan' => 'Europe/Astrakhan',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Bratislava' => 'Europe/Bratislava',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Budapest' => 'Europe/Budapest',
    'Europe/Busingen' => 'Europe/Busingen',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Europe/Dublin' => 'Europe/Dublin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Guernsey' => 'Europe/Guernsey',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Isle_of_Man' => 'Europe/Isle_of_Man',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Jersey' => 'Europe/Jersey',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Kirov' => 'Europe/Kirov',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Europe/Ljubljana' => 'Europe/Ljubljana',
    'Europe/London' => 'Europe/London',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Madrid' => 'Europe/Madrid',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Mariehamn' => 'Europe/Mariehamn',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Podgorica' => 'Europe/Podgorica',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Samara' => 'Europe/Samara',
    'Europe/San_Marino' => 'Europe/San_Marino',
    'Europe/Sarajevo' => 'Europe/Sarajevo',
    'Europe/Saratov' => 'Europe/Saratov',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'Europe/Skopje' => 'Europe/Skopje',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Ulyanovsk' => 'Europe/Ulyanovsk',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vatican' => 'Europe/Vatican',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Volgograd' => 'Europe/Volgograd',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Zagreb' => 'Europe/Zagreb',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Zurich' => 'Europe/Zurich',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Indian/Chagos' => 'Indian/Chagos',
    'Indian/Christmas' => 'Indian/Christmas',
    'Indian/Cocos' => 'Indian/Cocos',
    'Indian/Comoro' => 'Indian/Comoro',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Indian/Mahe' => 'Indian/Mahe',
    'Indian/Maldives' => 'Indian/Maldives',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Indian/Reunion' => 'Indian/Reunion',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Bougainville' => 'Pacific/Bougainville',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Chuuk' => 'Pacific/Chuuk',
    'Pacific/Easter' => 'Pacific/Easter',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pohnpei' => 'Pacific/Pohnpei',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'UTC' => 'UTC',
    'Time Format' => 'Time Format',
    'Choose your default timezone' => 'Choose your default timezone',
    'Signature' => 'Signature',
    'User signature will be append at the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Password' => 'Password',
    'Password will remain same if you are not entering something in this field' => 'Password not changed!',
    'Confirm Password' => 'Confirm Password',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'Password must be at least 8 characters, two letters (not case-sensitive), one number, and one special character (space is not allowed).',
    'Save Changes' => 'Save Changes',
    'SAVE CHANGES' => 'SAVE CHANGES',
    'CREATE TICKET' => 'CREATE TICKET',
    'Customer full name' => 'Customer full name',
    'Customer email address' => 'Customer email address',
    'Select Type' => 'Select Type',
    'Support' => 'Support',
    'Choose ticket type' => 'Choose ticket type',
    'Ticket subject' => 'Ticket subject',
    'Message' => 'Message',
    'Query Message' => 'Query Message',
    'Add Attachment' => 'Add Attachment',
    'This field is mandatory' => 'This field is mandatory',
    'General' => 'General',
    'Designation' => 'Designation',
    'Contant Number' => 'Content Number',
    'User signature will be append in the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Account Status' => 'Account Status',
    'Account is Active' => 'Account is Active',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Add user to group to view tickets regardless of owner.',
    'Default' => 'Default',
    'Select All' => 'Select All',
    'Remove All' => 'Remove All',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Add user to team to view tickets regardless of owner.',
    'No Team added !' => 'No Team added!',
    'Permission' => 'Permission',
    'Role' => 'Role',
    'Administrator' => 'Administrator',
    'Select agent role' => 'Select agent role',
    'Add Customer' => 'Add Customer',
    'Action' => 'Action',
    'Account Owner' => 'Account Owner',
    'Active' => 'Active',
    'Edit' => 'Edit',
    'Delete' => 'Delete',
    'Disabled' => 'Disabled',
    'New Group' => 'New Group',
    'Default Privileges' => 'Default Privileges',
    'New Privileges' => 'New Privileges',
    'NEW PRIVILEGE' => 'NEW PRIVILEGE',
    'New Privilege' => 'New Privilege',
    'New Team' => 'New Team',
    'No Record Found' => 'No Record Found',
    'Order Synchronization' => 'Order Synchronization',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Easily integrate different eCommerce platforms with your helpdesk to show order details within support tickets.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'No channels have been added.',
    'Add BigCommerce Store' => 'Add BigCommerce Store',
    'ADD BIGCOMMERCE STORE' => 'ADD BIGCOMMERCE STORE',
    'Mangento' => 'Mangento',
    'Add Magento Store' => 'Add Magento Store',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'Add OpenCart Store',
    'ADD OPENCART STORE' => 'ADD OPENCART STORE',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Add Shopify Store',
    'ADD SHOPIFY STORE' => 'ADD SHOPIFY STORE',
    'Integrate a new BigCommerce store' => 'Integrate a new BigCommerce store',
    'Your BigCommerce Store Name' => 'Your BigCommerce Store Name',
    'Your BigCommerce Store Hash' => 'Your BigCommerce Store Hash',
    'Your BigCommerce Api Token' => 'Your BigCommerce Api Token',
    'Your BigCommerce Api Client ID' => 'Your BigCommerce Api Client ID',
    'Enable Channel' => 'Enable Channel',
    'Add Store' => 'Add Store',
    'ADD STORE' => 'ADD STORE',
    'Integrate a new Magento store' => 'Integrate a new Magento store',
    'Your Magento Api Username' => 'Your Magento Api Username',
    'Your Magento Api Password' => 'Your Magento Api Password',
    'Integrate a new OpenCart store' => 'Integrate a new OpenCart store',
    'Your OpenCart Api Key' => 'Your OpenCart Api Key',
    'Your Shopify Store Name' => 'Your Shopify Store Name',
    'Your Shopify Api Key' => 'Your Shopify Api Key',
    'Your Shopify Api Password' => 'Your Shopify Api Password',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Easily embed custom forms for creating helpdesk tickets.',
    'Form-Builder' => 'Form-Builder',
    'Add Formbuilder' => 'Add Formbuilder',
    'ADD FORMBUILDER' => 'ADD FORMBUILDER',
    'No FormBuilder have been added.' => 'No FormBuilder was added.',
    'Create a New Custom Form Below' => 'Create a New Custom Form Below',
    'Form Name' => 'Form Name',
    'It will be shown in the list of created forms' => 'Displayed in the list of created forms',
    'MANDATORY FIELDS' => 'MANDATORY FIELDS',
    'These fields will be visible in form and cant be edited' => 'These fields will be visible in this form and can\'t be edited',
    'Reply' => 'Reply',
    'OPTIONAL FIELDS' => 'OPTIONAL FIELDS',
    'Select These Fields to Add in your Form' => 'Select fields to add',
    'GDPR' => 'GDPR',
    'Order' => 'Order',
    'Categorybuilder' => 'Categorybuilder',
    'File' => 'File',
    'Add Form' => 'Add Form',
    'ADD FORM' => 'ADD FORM',
    'UPDATE FORM' => 'UPDATE FORM',
    'Update Form' => 'Update Form',
    'Embed' => 'Embed',
    'EMBED' => 'EMBED',
    'EMBED FORMBUILDER' => 'EMBED FORMBUILDER',
    'Embed Formbuilder' => 'Embed Formbuilder',
    'Visit' => 'Visit',
    'VISIT' => 'VISIT',
    'Code' => 'Code',
    'Total Ticket(s)' => 'Total Ticket(s)',
    'Ticket Count' => 'Ticket Count',
    'SwiftMailer Configurations' => 'SwiftMailer Configurations',
    'No swiftmailer configurations found' => 'No SwiftMailer configurations found',
    'CREATE CONFIGURATION' => 'CREATE CONFIGURATION',
    'Add configuration' => 'Add configuration',
    'Update configuration' => 'Update configuration',
    'Mailer ID' => 'Mailer ID',
    'Mailer ID - Leave blank to automatically create id' => 'Mailer ID - Leave blank to automatically create id',
    'Transport Type' => 'Transport Type',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Enable Delivery',
    'Server' => 'Server',
    'Port' => 'Port',
    'Encryption Mode' => 'Encryption Mode',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'None',
    'Authentication Mode' => 'Authentication Mode',
    'login' => 'login',
    'Plain' => 'Plain',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Sender Address',
    'Delivery Address' => 'Delivery Address',
    'Block Spam' => 'Block Spam',
    'Black list' => 'Black list',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Comma separated values (Eg. support@example.com, @example.com, 68.98.31.226)',
    'White list' => 'White list',
    'Mailbox Settings' => 'Mailbox Settings',
    'No mailbox configurations found' => 'No mailbox configurations found',
    'NEW MAILBOX' => 'NEW MAILBOX',
    'New Mailbox' => 'New Mailbox',
    'Update Mailbox' => 'Update Mailbox',
    'Add Mailbox' => 'Add Mailbox',
    'Mailbox ID - Leave blank to automatically create id' => 'Mailbox ID - Leave blank to automatically create id',
    'Mailbox Name' => 'Mailbox Name',
    'Enable Mailbox' => 'Enable Mailbox',
    'Incoming Mail (IMAP) Server' => 'Incoming Mail (IMAP) Server',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Configure your imap settings in order to fetch new mail from your inbox.',
    'Transport' => 'Transport',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Host',
    'IMAP Host' => 'IMAP Host',
    'Email address' => 'Email address',
    'Associated Password' => 'Associated Password',
    'Outgoing Mail (SMTP) Server' => 'Outgoing Mail (SMTP) Server',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Select the SwiftMailer config to use for sending emails through your account.',
    'Swift Mailer ID' => 'Swift Mailer ID',
    'None Selected' => 'None Selected',
    'Create Mailbox' => 'Create Mailbox',
    'CREATE MAILBOX' => 'CREATE MAILBOX',
    'New Template' => 'New Template',
    'NEW TEMPLATE' => 'NEW TEMPLATE',
    'Customer Forgot Password' => 'Customer Forgot Password',
    'Customer Account Created' => 'Customer Account Created',
    'Ticket generated success mail to customer' => 'Ticket successfully generated and sent to customer',
    'Customer Reply To The Agent' => 'Customer reply',
    'Ticket Assign' => 'Ticket Assign',
    'Agent Forgot Password' => 'Agent Forgot Password',
    'Agent Account Created' => 'Agent Account Created',
    'Ticket generated by customer' => 'Ticket generated by customer',
    'Agent Reply To The Customers ticket' => 'Agent reply',
    'Email template name' => 'Email template name',
    'Email template subject' => 'Email template subject',
    'Template For' => 'Template For',
    'Nothing Selected' => 'Nothing Selected',
    'email template will be used for work related with selected option' => 'email template will be used for selected option',
    'Email template body' => 'Email template body',
    'Body' => 'Body',
    'placeholders' => 'placeholders',
    'Ticket Subject' => 'Ticket Subject',
    'Ticket Message' => 'Ticket Message',
    'Ticket Attachments' => 'Ticket Attachments',
    'Ticket Tags' => 'Ticket Tags',
    'Ticket Source' => 'Ticket Source',
    'Ticket Status' => 'Ticket Status',
    'Ticket Priority' => 'Ticket Priority',
    'Ticket Group' => 'Ticket Group',
    'Ticket Team' => 'Ticket Team',
    'Ticket Thread Message' => 'Ticket Thread Message',
    'Ticket Customer Name' => 'Ticket Customer Name',
    'Ticket Customer Email' => 'Ticket Customer Email',
    'Ticket Agent Name' => 'Ticket Agent Name',
    'Ticket Agent Email' => 'Ticket Agent Email',
    'Ticket Agent Link' => 'Ticket Agent Link',
    'Ticket Customer Link' => 'Ticket Customer Link',
    'Last Collaborator Name' => 'Last Collaborator Name',
    'Last Collaborator Email' => 'Last Collaborator Email',
    'Agent/ Customer Name' => 'Agent/ Customer Name',
    'Account Validation Link' => 'Account Validation Link',
    'Password Forgot Link' => 'Password Forgot Link',
    'Company Name' => 'Company Name',
    'Company Logo' => 'Company Logo',
    'Company URL' => 'Company URL',
    'Swiftmailer id (Select from drop down)' => 'Swiftmailer id (Select from drop down)',
    'PROCEED' => 'PROCEED',
    'Proceed' => 'Proceed',
    'Theme Color' => 'Theme Color',
    'Customer Created' => 'Customer Created',
    'Agent Created' => 'Agent Created',
    'Ticket Created' => 'Ticket Created',
    'Agent Replied on Ticket' => 'Agent replied to ticket',
    'Customer Replied on Ticket' => 'Customer replied to ticket',
    'Workflow Status' => 'Workflow status',
    'Workflow is Active' => 'Workflow is active',
    'Events' => 'Events',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'An event automatically triggers to check conditions and perform a set of pre-defined actions',
    'Select an Event' => 'Select an Event',
    'Add More' => 'Add More',
    'Conditions' => 'Conditions',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Conditions are sets of rules which check for specific scenarios.',
    'Subject or Description' => 'Subject or description',
    'Actions' => 'Actions',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Actions help you automate tickets',
    'Select an Action' => 'Select an action',
    'Add Note' => 'Add note',
    'Mail to agent' => 'Mail to agent',
    'Mail to customer' => 'Mail to customer',
    'Mail to group' => 'Mail to group',
    'Mail to last collaborator' => 'Mail to last collaborator',
    'Mail to team' => 'Mail to team',
    'Mark Spam' => 'Mark spam',
    'Assign to agent' => 'Assign to agent',
    'Assign to group' => 'Assign to group',
    'Set Priority As' => 'Set Priority As',
    'Set Status As' => 'Set Status As',
    'Set Tag As' => 'Set Tag As',
    'Set Label As' => 'Set Label As',
    'Assign to team' => 'Assign to team',
    'Set Type As' => 'Set Type As',
    'Add Workflow' => 'Add Workflow',
    'ADD WORKFLOW' => 'ADD WORKFLOW',
    'Ticket Type code' => 'Ticket Type code',
    'Ticket Type description' => 'Ticket Type description',
    'Type Status' => 'Type Status',
    'Type is Active' => 'Type is Active',
    'Add Save Reply' => 'Add Save Reply',
    'Saved reply name' => 'Saved reply name',
    'Share saved reply with user(s) in these group(s)' => 'Share saved reply with user(s) in these group(s)',
    'Share saved reply with user(s) in these teams(s)' => 'Share saved reply with user(s) in these teams(s)',
    'Saved reply Body' => 'Saved reply body',
    'New Prepared Response' => 'New Prepared Response',
    'Prepared Response Status' => 'Prepared Response Status',
    'Prepared Response is Active' => 'Prepared Response is Active',
    'Share prepared response with user(s) in these group(s)' => 'Share prepared response with user(s) in these group(s)',
    'Share prepared response with user(s) in these teams(s)' => 'Share prepared response with user(s) in these teams(s)',
    'ADD PREPARED RESPONSE' => 'ADD PREPARED RESPONSE',
    'Add Prepared Response' => 'Add Prepared Response',
    'Folder Name is shown upfront at Knowledge Base' => 'The folder name to show in the knowledge base',
    'A small text about the folder helps user to navigate more easily' => 'A bit more info about this folder',
    'Publish' => 'Publish',
    'Choose appropriate status' => 'Choose appropriate status',
    'Folder Image' => 'Folder Image',
    'An image is worth a thousands words and makes folder more accessible' => 'Help users identify the proper folder with a recognizable image.',
    'Add Category' => 'Add Category',
    'Category Name is shown upfront at Knowledge Base' => 'The category name to show in the knowledge base',
    'A small text about the category helps user to navigate more easily' => 'A bit more info about this category',
    'Using Category Order, you can decide which category should display first' => 'Using Category Order, you can decide which category should display first',
    'Sorting' => 'Sorting',
    'Ascending Order (A-Z)' => 'Ascending Order (A-Z)',
    'Descending Order (Z-A)' => 'Descending Order (Z-A)',
    'Based on Popularity' => 'Based on Popularity',
    'Article of this category will display according to selected option' => 'Articles in this category will display depending on selected option',
    'Article' => 'Article',
    'Title' => 'Title',
    'View' => 'View',
    'Make as Starred' => 'Mark as Starred',
    'Yes' => 'Yes',
    'No' => 'No',
    'Stared' => 'Stared',
    'Revisions' => 'Revisions',
    'Related Articles' => 'Related Articles',
    'Delete Article' => 'Delete Article',
    'Content' => 'Content',
    'Slug' => 'Slug',
    'Slug is the url identity of this article.' => 'The URL for this article',
    'Meta Title' => 'Meta Title',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. The title tag and meta description are usually shown in search engine results for the page.',
    'Meta Keywords' => 'Meta Keywords',
    'Meta Description' => 'Meta Description',
    'Description' => 'Description',
    'Team Status' => 'Team Status',
    'Team is Active' => 'Team is Active',
    'Edit Privilege' => 'Edit Privilege',
    'Can create ticket' => 'Can create ticket',
    'Can edit ticket' => 'Can edit ticket',
    'Can delete ticket' => 'Can delete ticket',
    'Can restore trashed ticket' => 'Can restore trashed ticket',
    'Can assign ticket' => 'Can assign ticket',
    'Can assign ticket group' => 'Can assign ticket group',
    'Can update ticket status' => 'Can update ticket status',
    'Can update ticket priority' => 'Can update ticket priority',
    'Can update ticket type' => 'Can update ticket type',
    'Can add internal notes to ticket' => 'Can add internal notes to ticket',
    'Can edit thread/notes' => 'Can edit thread/notes',
    'Can lock/unlock thread' => 'Can lock/unlock thread',
    'Can add collaborator to ticket' => 'Can add collaborator to ticket',
    'Can delete collaborator from ticket' => 'Can delete collaborator from ticket',
    'Can delete thread/notes' => 'Can delete thread/notes',
    'Can apply prepared response on ticket' => 'Can apply prepared response on ticket',
    'Can add ticket tags' => 'Can add ticket tags',
    'Can delete ticket tags' => 'Can delete ticket tags',
    'Can kick other ticket users' => 'Can kick other ticket users',
    'Can manage email templates' => 'Can manage email templates',
    'Can manage groups' => 'Can manage groups',
    'Can manage Sub-Groups/ Teams' => 'Can manage Sub-Groups/ Teams',
    'Can manage agents' => 'Can manage agents',
    'Can manage agent privileges' => 'Can manage agent privileges',
    'Can manage ticket types' => 'Can manage ticket types',
    'Can manage ticket custom fields' => 'Can manage ticket custom fields',
    'Can manage customers' => 'Can manage customers',
    'Can manage Prepared Responses' => 'Can manage Prepared Responses',
    'Can manage Automatic workflow' => 'Can manage Automatic workflow',
    'Can manage tags' => 'Can manage tags',
    'Can manage knowledgebase' => 'Can manage knowledgebase',
    'Can manage Groups Saved Reply' => 'Can manage Groups Saved Reply',
    'Add Privilege' => 'Add Privilege',
    'Choose set of privileges which will be available to the agent.' => 'Choose set of privileges which will be available to the agent.',
    'Advanced' => 'Advanced',
    'Privilege Name must have characters only' => 'Privilege Name must have characters only',
    'Maximum character length is 50' => 'Maximum character length is 50',
    'Open Tickets' => 'Open Tickets',
    'New Customer' => 'New Customer',
    'New Agent' => 'New Agent',
    'Total Article(s)' => 'Total Article(s)',
    'Please specify a valid email address' => 'Please specify a valid email address',
    'Please enter the password associated with your email address' => 'Please enter the password associated with your email address',
    'Please enter your server host address' => 'Please enter your server host address',
    'Please specify a port number to connect with your mail server' => 'Please specify the port number for your mail server',
    'Success ! Branding details saved successfully.' => 'Success! Branding details saved successfully.',
    'Success ! Time details saved successfully.' => 'Success! Time details saved successfully.',
    'Spam setting saved successfully.' => 'Spam setting saved successfully.',
    'Please specify a valid name for your mailbox.' => 'Please specify a valid name for your mailbox.',
    'Please select a valid swift-mailer configuration.' => 'Please select a valid swift-mailer configuration.',
    'Please specify a valid host address.' => 'Please specify a valid host address.',
    'Please specify a valid email address.' => 'Please specify a valid email address.',
    'Please enter the associated account password.' => 'Please enter the associated account password.',
    'New Saved Reply' => 'New Saved Reply',
    'New Category' => 'New Category',
    'Folder' => 'Folder',
    'Category' => 'Category',
    'Created' => 'Created',
    'All Articles' => 'All Articles',
    'Viewed' => 'Viewed',
    'New Article' => 'New Article',
    'Thank you for your feedback!' => 'Thank you for your feedback!',
    'Was this article helpful?' => 'Was this article helpful?',
    'Helpdesk' => 'Helpdesk',
    'Support Center' => 'Support Center',
    'Mailboxes' => 'Mailboxes',
    'By' => 'By',
    'Search Tickets' => 'Search Tickets',
    'Customer Information' => 'Customer Information',
    'Total Replies' => 'Total Replies',
    'Filter With' => 'Filter With',
    'Type email to add' => 'Type email to add',
    'Collaborators' => 'Collaborators',
    'Labels' => 'Labels',
    'Group' => 'Group',
    'Stay on ticket' => 'Stay on ticket',
    'Redirect to list' => 'Redirect to list',
    'Nothing interesting here...' => 'Nothing interesting here',
    'Previous Ticket' => 'Previous Ticket',
    'Next Ticket' => 'Next Ticket',
    'Forward' => 'Forward',
    'Note' => 'Note',
    'Write a reply' => 'Write a reply',
    'Created Ticket' => 'Created Ticket',
    'All Threads' => 'All Threads',
    'Forwards' => 'Forwards',
    'Notes' => 'Notes',
    'Pinned' => 'Pinned',
    'Edit Ticket' => 'Edit Ticket',
    'Print Ticket' => 'Print Ticket',
    'Mark as Spam' => 'Mark as Spam',
    'Mark as Closed' => 'Mark as Closed',
    'Delete Ticket' => 'Delete Ticket',
    'View order details from different eCommerce channels' => 'View order details from different eCommerce channels',
    'ECOMMERCE CHANNELS' => 'ECOMMERCE CHANNELS',
    'Select channel' => 'Select channel',
    'Order Id' => 'Order Id',
    'Fetch Order' => 'Fetch Order',
    'No orders have been integrated to this ticket yet.' => 'No orders have been associated with this ticket yet.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Enter your credentials below to sign in',
    'Keep me logged in' => 'Keep me logged in',
    'Forgot Password?' => 'Forgot Password?',
    'Log in to your' => 'Log in to your',
    'Sign In' => 'Sign In',
    'Edit Customer' => 'Edit Customer',
    'Update' => 'Update',
    'Discard' => 'Discard',
    'Cancel' => 'Cancel',
    'Not Assigned' => 'Not Assigned',
    'Submit' => 'Submit',
    'Submit And Open' => 'Submit And Open',
    'Submit And Pending' => 'Submit And Pending',
    'Submit And Answered' => 'Submit And Answered',
    'Submit And Resolved' => 'Submit And Resolved',
    'Submit And Closed' => 'Submit And Closed',
    'Choose a Color' => 'Choose a Color',
    'Create' => 'Create',
    'Edit Label' => 'Edit Label',
    'Add Label' => 'Add Label',
    'To' => 'To',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Your browser does not support Javascript or Javascript is disabled. Please correct this!',
    'Confirm Action' => 'Confirm Action',
    'Confirm' => 'Confirm',
    'No result found' => 'No result found',
    'ticket delivery status' => 'ticket delivery status',
    'Warning! Select valid image file.' => 'Warning! Select valid image file.',
    'Error' => 'Error',
    'Save' => 'Save',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Edit Saved Filter',
    'Type atleast 2 letters' => 'Type at least 2 letters',
    'Remove Label' => 'Remove Label',
    'New Saved Filter' => 'New Saved Filter',
    'Is Default' => 'Is Default',
    'Remove Saved Filter' => 'Remove Saved Filter',
    'Ticket Info' => 'Ticket Info',
    'Last Replied Agent' => 'Last Replied Agent',
    'created Ticket' => 'created Ticket',
    'Uploaded Files' => 'Uploaded Files',
    'Download (as .zip)' => 'Download ( as .zip)',
    'made last reply' => 'last reply',
    'N/A' => 'N/A',
    'Unassigned' => 'Unassigned',
    'Label' => 'Label',
    'Assigned to me' => 'Assigned to me',
    'Search Query' => 'Search Query',
    'Searching' => 'Searching',
    'Saved Filter' => 'Saved Filter',
    'No Label Created' => 'No Label Created',
    'Label with same name already exist.' => 'Label with same name already exists',
    'Create New' => 'Create New',
    'Mail status' => 'Mail status',
    'replied' => 'replied',
    'added note' => 'added note',
    'forwarded' => 'forwarded',
    'TO' => 'TO',
    'CC' => 'CC',
    'BCC' => 'BCC',
    'Locked' => 'Locked',
    'Edit Thread' => 'Edit Thread',
    'Delete Thread' => 'Delete Thread',
    'Unpin Thread' => 'Unpin Thread',
    'Pin Thread' => 'Pin Thread',
    'Unlock Thread' => 'Unlock Thread',
    'Lock Thread' => 'Lock Thread',
    'Translate Thread' => 'Translate Thread',
    'Language' => 'Language',
    'English' => 'English',
    'French' => 'French',
    'Italian' => 'Italian',
    'Arabic' => 'Arabic',
    'German' => 'German',
    'Spanish' => 'Spanish',
    'Turkish' => 'Turkish',
    'Danish' => 'Danish',
    'System' => 'System',
    'Open in Files' => 'Open in Files',
    'Email address is invalid' => 'Email address is invalid',
    'Tag with same name already exist' => 'Tag with this name already exist',
    'Text length should be less than 20 charactors' => 'Must be less than 20 characters',
    'Label with same name already exist' => 'Label with same name already exist',
    'Agent Name' => 'Agent Name',
    'Agent Email' => 'Agent Email',
    'open' => 'open',
    'Currently active agents on ticket' => 'Currently active agents on ticket',
    'Edit Customer Information' => 'Edit Customer Information',
    'Restore' => 'Restore',
    'Delete Forever' => 'Delete Forever',
    'Add Team' => 'Add Team',
    'delete' => 'delete',
    'You didnt have any folder for current filter(s).' => 'No folders match current filter(s).',
    'Add Folder' => 'Add Folder',
    'This field must have valid characters only' => 'This field must have valid characters only',
    'Can edit task' => 'Can edit task',
    'Can create task' => 'Can create task',
    'Can delete task' => 'Can delete task',
    'Can add member to task' => 'Can add member to task',
    'Can remove member from task' => 'Can remove member from task',
    'Agent Privileges' => 'Agent Privileges',
    'Agent Privilege represents overall permissions in System.' => 'Agent privilege represents overall permissions in your helpdesk.',
    'Ticket View' => 'Ticket View',
    'User can view tickets based on selected scope.' => 'User can view tickets based on selected scope.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) they belongs to, etc.',
    'Global Access' => 'Global Access',
    'Group Access' => 'Group Access',
    'Team Access' => 'Team Access',
    'Individual Access' => 'Individual Access',
    'This field must have characters only' => 'This field must have characters only',
    'Maximum character length is 40' => 'Maximum character length is 40',
    'This is not a valid email address' => 'This is not a valid email address',
    'Password must contains 8 Characters' => 'Password must contains 8 Characters',
    'The passwords does not match' => 'The passwords do not match',
    'Enabled' => 'Enabled',
    'Create Configuration' => 'Create Configuration',
    'Swift Mailer Settings' => 'Swift Mailer Settings',
    'Username' => 'Username',
    'Please select a swiftmailer id' => 'Please select a swiftmailer id',
    'Please enter a valid e-mail id' => 'Please enter a valid e-mail id',
    'Please enter a mailer id' => 'Please enter a mailer id',
    'Email Id' => 'Email Id',
    'Are you sure? You want to perform this action.' => 'Are you sure you want to perform this action?',
    'Reorder' => 'Reorder',
    'New Workflow' => 'New Workflow',
    'OR' => 'OR',
    'AND' => 'AND',
    'Please enter a valid name.' => 'Please enter a valid name.',
    'Please select a value.' => 'Please select a value.',
    'Please add a value.' => 'Please add a value.',
    'This field is required' => 'This field is required',
    'or' => 'or',
    'and' => 'and',
    'Select a Condition' => 'Select a Condition',
    'Loading...' => 'Loading...',
    'Select Option' => 'Select Option',
    'Inactive' => 'Inactive',
    'New Type' => 'New Type',
    'Placeholders' => 'Placeholders',
    'Ticket Link' => 'Ticket Link',
    'Id' => 'Id',
    'Preview' => 'Preview',
    'Sort Order' => 'Sort Order',
    'This field must be a number' => 'This field must be a number',
    'User' => 'User',
    'Edit Group' => 'Edit Group',
    'Group Status' => 'Group Status',
    'Group is Active' => 'Group is Active',
    'Add Group' => 'Add Group',
    'Contact number is invalid' => 'Contact number is invalid',
    'Edit Agent' => 'Edit Agent',
    'No Privilege added, Please add Privilege(s) first !' => 'No privilege added, please add privilege(s) first!',
    'Edit Email Template' => 'Edit Email Template',
    'Edit Workflow' => 'Edit Workflow',
    'Save Workflow' => 'Save Workflow',
    'Edit Ticket Type' => 'Edit Ticket Type',
    'Add Ticket Type' => 'Add Ticket Type',
    'Date Released' => '	Date Released',
    'Free' => 'Free',
    'Premium' => 'Premium',
    'Installed' => 'Installed',
    'Installed Applications' => 'Installed Applications',
    'Apps Dashboard' => 'Apps Dashboard',
    'Nothing Interesting here' => 'Nothing interesting here',
    'No Categories Added' => 'No Categories Added',
    'Error : Something went wrong, please try again later' => 'Error: Something went wrong, please try again later',
    'ticket' => 'ticket',
    'Add Email Template' => 'Add Email Template',
    'This field contain 100 characters only' => 'Max 100 characters',
    'This field contain characters only' => 'This field may contain characters only',
    'Name length must not be greater than 200 !!' => 'Name length must not be greater than 200!',
    'Warning! Correct all field values first!' => 'Warning! Correct all field values first!',
    'Warning ! This is not a valid request' => 'Warning! This is not a valid request',
    'Success ! Tag removed successfully.' => 'Success! Tag removed successfully.',
    'Success ! Tags Saved successfully.' => 'Success! Tags Saved successfully.',
    'Success ! Revision restored successfully.' => 'Success! Revision restored successfully.',
    'Success ! Categories updated successfully.' => 'Success! Categories updated successfully.',
    'Success ! Article Related removed successfully.' => 'Success! Related article removed successfully.',
    'Success ! Article Related is already added.' => 'Success! Related article added.',
    'Success ! Cannot add self as relative article.' => 'Success! Cannot add self as relative article.',
    'Success ! Article Related updated successfully.' => 'Success! Related article updated successfully.',
    'Success ! Articles removed successfully.' => 'Success! Articles removed successfully.',
    'Success ! Article status updated successfully.' => 'Success! Article status updated successfully.',
    'Success ! Article star updated successfully.' => 'Success! Article star updated successfully.',
    'Success! Article updated successfully' => 'Success! Article updated successfully',
    'Success ! Category sort  order updated successfully.' => 'Success! Category sort order updated successfully.',
    'Success ! Category status updated successfully.' => 'Success! Category status updated successfully.',
    'Success ! Folders updated successfully.' => 'Success! Folders updated successfully.',
    'Success ! Categories removed successfully.' => 'Success! Categories removed successfully.',
    'Success ! Category updated successfully.' => 'Success! Category updated successfully.',
    'Error ! Category is not exist.' => 'Error! Category does not exist.',
    'Warning ! Customer Login disabled by admin.' => 'Warning! Customer Login disabled by admin.',
    'This Email is not registered with us.' => 'This email is not registered with us.',
    'Your password has been updated successfully.' => 'Your password has been updated successfully.',
    'Password dont match.' => 'Password doesn\'t match.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Error! Profile image is not valid, please upload a valid format',
    'Warning! Provide valid image file. (Recommened": "PNG, JPG or GIF Format).' => 'Warning! invalid image file. (Recommened": "PNG, JPG or GIF Format).',
    'Success! Folder has been added successfully.' => 'Success! Folder has been added successfully.',
    'Folder updated successfully.' => 'Folder updated successfully.',
    'Success ! Folder status updated successfully.' => 'Success! Folder status updated successfully.',
    'Error ! Folder is not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder updated successfully.' => 'Success! Folder updated successfully.',
    'Error ! Folder does not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder deleted successfully.' => 'Success! Folder deleted successfully.',
    'Warning ! Folder doesnt exists!' => 'Warning! Folder doesn\'t exists!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Warning! Can\'t create ticket, given email is blocked by admin.',
    'Success ! Ticket has been created successfully.' => 'Success! Ticket has been created successfully.',
    'Warning ! Can not create ticket, invalid details.' => 'Warning! Can not create ticket, invalid details.',
    'Warning ! Post size can not exceed 25MB' => 'Warning! attachmment size can not exceed 25MB',
    'Create Ticket Request' => 'Create Ticket Request',
    'Success ! Reply added successfully.' => 'Success! Reply added successfully.',
    'Warning ! Reply field can not be blank.' => 'Warning! Reply field can not be blank.',
    'Success ! Rating has been successfully added.' => 'Success! Rating has been successfully added.',
    'Warning ! Invalid rating.' => 'Warning! Invalid rating.',
    'Error ! Can not add customer as a collaborator.' => 'Error! Can not add customer as a collaborator.',
    'Success ! Collaborator added successfully.' => 'Success! Collaborator added successfully.',
    'Error ! Collaborator is already added.' => 'Error! Collaborator is already added.',
    'Success ! Collaborator removed successfully.' => 'Success! Collaborator removed successfully.',
    'Error ! Invalid Collaborator.' => 'Error! Invalid Collaborator.',
    'An unexpected error occurred. Please try again later.' => 'An unexpected error occurred. Please try again later.',
    'Feedback saved successfully.' => 'Feedback saved successfully.',
    'Feedback updated successfully.' => 'Feedback updated successfully.',
    'Invalid feedback provided.' => 'Invalid feedback provided.',
    'Article not found.' => 'Article not found.',
    'You need to login to your account before can perform this action.' => 'You need to log in to your account before can perform this action.',
    'Warning! Please add valid Actions!' => 'Warning! Please add valid actions!',
    'Warning! In Free Plan you can not change Events!' => 'Warning! In free plan you can not change events!',
    'Success! Prepared Response has been updated successfully.' => 'Success! Prepared response has been updated successfully.',
    'Success! Prepared Response has been added successfully.' => 'Success! Prepared response has been added successfully.',
    'Warning  This is not a valid request' => 'Warning! This is not a valid request',
    'Use Default Colors' => 'Use Default Colors',
    'Masonry' => 'Masonry',
    'Popular Article' => 'Popular Article',
    'Manage Ticket Custom Fields' => 'Manage Ticket Custom Fields',
    'Mail status:' => 'Mail status:',
    'You dont have premission to edit this Prepared response' => 'You don\'t have premission to edit this prepared response',
    'Save Prepared Response' => 'Save prepared response',
    'Success ! Prepared response removed successfully.' => 'Success! Prepared response removed successfully.',
    'Warning! You are not allowed to perform this action.' => 'Warning! You are not allowed to perform this action.',
    'Success! Workflow has been updated successfully.' => 'Success! Workflow has been updated successfully.',
    'Success! Workflow has been added successfully.' => 'Success! Workflow has been added successfully.',
    'Success! Order has been updated successfully.' => 'Success! Order has been updated successfully.',
    'Success! Workflow has been removed successfully.' => 'Success! Workflow has been removed successfully.',
    'Mailbox successfully created.' => 'Mailbox successfully created.',
    'Mailbox successfully updated.' => 'Mailbox successfully updated.',
    'Warning ! Bad request !' => 'Warning! Bad request!',
    'Error! Given current password is incorrect.' => 'Error! Password is incorrect.',
    'Success ! Profile update successfully.' => 'Success! Profile update successfully.',
    'Error ! User with same email is already exist.' => 'Error! User with same email already exists.',
    'Success ! Agent updated successfully.' => 'Success! Agent updated successfully.',
    'Success ! Agent removed successfully.' => 'Success! Agent removed successfully.',
    'Warning ! You are allowed to remove account owners account.' => 'Warning! You are allowed to remove this account.',
    'Error ! Invalid user id.' => 'Error! Invalid user id.',
    'Success ! Filter has been saved successfully.' => 'Success! Filter has been saved successfully.',
    'Success ! Filter has been updated successfully.' => 'Success! Filter has been updated successfully.',
    'Success ! Filter has been removed successfully.' => 'Success! Filter has been removed successfully.',
    'Please check your mail for password update.' => 'Please check your inbox for a new password.',
    'This Email address is not registered with us.' => 'This email address is not registered with us.',
    'Success ! Customer saved successfully.' => 'Success! Customer saved successfully.',
    'Error ! User with same email already exist.' => 'Error! User with same email already exists.',
    'Success ! Customer information updated successfully.' => 'Success! Customer information updated successfully.',
    'Success ! Customer updated successfully.' => 'Success! Customer updated successfully.',
    'Error ! Customer with same email already exist.' => 'Error! Customer with same email already exists.',
    'unstarred Action Completed successfully' => 'unstarred action completed successfully',
    'starred Action Completed successfully' => 'starred action completed successfully',
    'Success ! Customer removed successfully.' => 'Success! Customer removed successfully.',
    'Error ! Invalid customer id.' => 'Error! Invalid customer id.',
    'Success! Template has been updated successfully.' => 'Success! Template has been updated successfully.',
    'Success! Template has been added successfully.' => 'Success! Template has been added successfully.',
    'Success! Template has been deleted successfully.' => 'Success! Template has been deleted successfully.',
    'Warning! resource not found.' => 'Warning! resource not found.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Warning! You can not remove an email template which is being used in workflow(s).',
    'Success ! Email settings are updated successfully.' => 'Success! Email settings successfully updated.',
    'Success ! Group information updated successfully.' => 'Success! Group information updated successfully.',
    'Success ! Group information saved successfully.' => 'Success! Group information saved successfully.',
    'Support Group removed successfully.' => 'Support Group removed successfully.',
    'Success ! Privilege information saved successfully.' => 'Success! Privilege information saved successfully.',
    'Privilege updated successfully.' => 'Privilege updated successfully.',
    'Support Privilege removed successfully.' => 'Support privilege removed successfully.',
    'Success! Reply has been updated successfully.' => 'Success! Reply has been updated successfully.',
    'Success! Reply has been added successfully.' => 'Success! Reply has been added successfully.',
    'Success! Saved Reply has been deleted successfully' => 'Success! Saved Reply has been deleted successfully',
    'SwiftMailer configuration updated successfully.' => 'SwiftMailer configuration updated successfully.',
    'Swiftmailer configuration removed successfully.' => 'Swiftmailer configuration removed successfully.',
    'Success ! Team information saved successfully.' => 'Success! Team information saved successfully.',
    'Success ! Team information updated successfully.' => 'Success! Team information updated successfully.',
    'Support Team removed successfully.' => 'Support Team removed successfully.',
    'Success! Reply has been added successfully' => 'Success! Reply has been added successfully',
    'Success ! Thread updated successfully.' => 'Success! Thread updated successfully.',
    'Error ! Reply field can not be blank.' => 'Error  Reply field can not be blank.',
    'Success ! Thread removed successfully.' => 'Success! Thread removed successfully.',
    'Success ! Thread locked successfully' => 'Success! Thread locked successfully',
    'Success ! Thread unlocked successfully' => 'Success! Thread unlocked successfully',
    'Success ! Thread pinned successfully' => 'Success! Thread unpinned successfully',
    'Error ! Invalid thread.' => 'Error! Invalid thread.',
    'Could not create ticket, invalid details.' => 'Could not create ticket, invalid details.',
    'Success ! Tag updated successfully.' => 'Success! Tag updated successfully.',
    'Error ! Customer can not be added as collaborator.' => 'Error! Customer can not be added as collaborator.',
    'Success ! Tag unassigned successfully.' => 'Success! Tag unassigned successfully.',
    'Success ! Tag added successfully.' => 'Success! Tag added successfully.',
    'Please enter tag name.' => 'Please enter tag name.',
    'Error ! Invalid tag.' => 'Error! Invalid tag.',
    'Success ! Type removed successfully.' => 'Success! Type removed successfully.',
    'Success ! Ticket to label removed successfully.' => 'Success! Ticket label removed successfully.',
    'Unable to retrieve support team details' => 'Unable to retrieve support team details',
    'Ticket support group updated successfully' => 'Ticket support group updated successfully',
    'Unable to retrieve status details' => 'Unable to retrieve status details',
    'Insufficient details provided.' => 'Insufficient details provided.',
    'Error! Subject field is mandatory' => 'Error! Subject field is mandatory',
    'Error! Reply field is mandatory' => 'Error! Reply field is mandatory',
    'Success ! Ticket has been updated successfully.' => 'Success! Ticket has been updated successfully.',
    'Success ! Label updated successfully.' => 'Success! Label updated successfully.',
    'Error ! Invalid label id.' => 'Error! Invalid label id.',
    'Success ! Label removed successfully.' => 'Success! Label removed successfully.',
    'Success ! Label created successfully.' => 'Success! Label created successfully.',
    'Error ! Label name can not be blank.' => 'Error! Label name can not be blank.',
    'Success ! Ticket moved to trash successfully.' => 'Success! Ticket moved to trash successfully.',
    'Success! Ticket type saved successfully.' => 'Success! Ticket type saved successfully.',
    'Success! Ticket type updated successfully.' => 'Success! Ticket type updated successfully.',
    'Error! Ticket type with same name already exist' => 'Error! Ticket type with same name already exist',
    'SAVE' => 'SAVE',
    'Howdy!' => 'Howdy!',
    'New Ticket Request' => 'New Ticket Request',
    'Ticket Requests' => 'Ticket Requests',
    'Tickets have been updated successfully' => 'Tickets have been updated successfully',
    'Please check your mail for password update' => 'Please check your inbox for a new password',
    'This email address is not registered with us' => 'This email address is not registered with us',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'You have already updated your password using this link. If you wish to change your password again click on the forget password link on the login page.',
    'Your password has been successfully updated. Login using updated password' => 'Your password has been successfully updated. Please log in using your new password.',
    'Please try again, The passwords do not match' => 'Please try again, The passwords do not match',
    'Support Privilege removed successfully' => 'Support Privilege removed successfully',
    'Success! Saved Reply has been deleted successfully.' => 'Success! Saved Reply has been deleted successfully.',
    'SwiftMailer configuration created successfully.' => 'SwiftMailer configuration created successfully.',
    'No swiftmailer configurations found for mailer id:' => 'No swiftmailer configurations found for mailer id:',
    'Reply content cannot be left blank.' => 'Reply content cannot be left blank.',
    'Reply added to the ticket and forwarded successfully.' => 'Reply added to the ticket and forwarded successfully.',
    'Success ! Thread pinned successfully.' => 'Success! Thread pinned successfully.',
    'Success ! unpinned removed successfully.' => 'Success! Thread unpinned successfully.',
    'Unable to retrieve priority details' => 'Unable to retrieve priority details',
    'Ticket support team updated successfully' => 'Ticket support team updated successfully',
    'Ticket assigned to support group ' => 'Ticket assigned to support group ',
    'Mailbox configuration removed successfully.' => 'Mailbox configuration removed successfully.',
    'visit our website' => 'visit our website',
    'Cookie Usage Policy' => 'Cookie Usage Policy',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => 'HELP',
    'Home' => 'Home',
    'Cookie Policy' => 'Cookie Policy',
    'Prev' => 'Prev',
    'Ticket query message' => 'Ticket content',
    'Select type' => 'Select type',
    'Search KnowledgeBase' => 'Search KnowledgeBase',
    'You cant merge an account with itself.' => 'You can\'t merge an account with itself.',
    'Edit Profile' => 'Edit Profile',
    'Customer Login' => 'Customer Login',
    'Contact Us' => 'Contact Us',
    'If you have ever contacted our support previously, your account would have already been created.' => 'If you have ever contacted us previously, your account is more than likely already created.',
    'support' => 'support',
    'HelpDesk' => 'HelpDesk',
    'Enter search keyword' => 'Enter search keyword',
    'Browse via Folders' => 'Explore the knowledge base',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Check out our knowledge base to see if your question has already been answered.',
    'Unable to find an answer?' => 'Contact Our Team',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'If you still can\'t find an answer to what you\'re looking for, or you have a specific question, open a new ticket and we\'d be happy to help!',
    'Popular Articles' => 'Popular Articles',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => 'Some of the more popular articles in our knowledge base that have helped other customers.',
    'Browse via Categories' => 'Browse via Categories',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Choose a category from the list below to view articles.',
    'No Categories Found!' => 'No Categories Found!',
    'Powered by' => 'Powered by',
    'Forgot Password' => 'Forgot Password',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'Enter your email address and we will send you a message to update your login credentials.',
    'Send Mail' => 'Send Mail',
    'Sign In to %websitename%' => 'Sign In to %websitename%',
    'Enter your name' => 'Enter your name',
    'Enter your email' => 'Enter your email',
    'Learn more about %deliveryStatus%.' => 'Learn more about %deliveryStatus%.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'To know more about our privacy policy, please visit %websiteLink%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.',
    'This field contain maximum 40 charectures.' => 'This field contain maximum 40 charectures.',
    'This field contain maximum 50 charectures.' => 'This field contain maximum 50 charectures.',
    'Time' => 'Time',
    'Links' => 'Links',
    'Broadcast Message' => 'Broadcast Message',
    'Wide Logo' => 'Wide Logo',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Upload an Image (200px x 48px) in</br> PNG or JPG Format',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Your knowledge base / helpdesk logo',
    'Website Status' => 'Website Status',
    'Enable front end website and knowledgebase for customer(s)' => 'Enable front end website and knowledgebase for customer(s)',
    'Brand Color' => 'Brand Color',
    'Page Background Color' => 'Page Background Color',
    'Header Background Color' => 'Header Background Color',
    'Banner Background Color' => 'Banner Background Color',
    'Page Link Color' => 'Page Link Color',
    'Page Link Hover Color' => 'Page Link Hover Color',
    'Article Text Color' => 'Article Text Color',
    'Tag Line' => 'Tag Line',
    'Hi! how can we help?' => 'Hi! how can we help?',
    'Layout' => 'Layout',
    'Ticket Create Option' => 'Ticket Create Option',
    'Login Required To Create Tickets' => 'Login required To create tickets',
    'Remove Customer Login/Signin Button' => 'Remove customer log in / sign in button',
    'Disable Customer Login' => 'Disable Customer Login',
    'Meta Description (Recommended)' => 'Meta Description (Recommended)',
    'Meta Keywords (Recommended)' => 'Meta Keywords (Recommended)',
    'Header Link' => 'Header Link',
    'URL (with http":/"/ or https":/"/)' => 'URL (with http":/"/ or https":/"/)',
    'Footer Link' => 'Footer Link',
    'Custom CSS (Optional)' => 'Custom CSS (Optional)',
    'It will be add to the frontend knowledgebase only' => 'Displayed only in front end knowledge base',
    'Custom Javascript (Optional)' => 'Custom Javascript (Optional)',
    'Broadcast message content to show on helpdesk' => 'Broadcast message content to show on helpdesk',
    'From' => 'From',
    'Time duration between which message will be displayed(if applicable)' => 'How long should the message be displayed?',
    'Broadcasting Status' => 'Broadcasting Status',
    'Broadcasting is Active' => 'Broadcasting is Active',
    'Choose a default company timezone' => 'Choose a default companys timezone',
    'Date Time Format' => 'Date Time Format',
    'Choose a format to convert date to specified date time format' => 'Choose a format to convert date to specified date time format',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'File size must not be greater than 200KB !!' => 'File size must not be greater than 200KB!',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Please upload a valid omage file (JPEG or PNG)!',
    'Provide a valid url(with protocol)' => 'Provide a valid url (with protocol)',
    'ticket.message.placeHolders.info' => 'ticket.message.placeHolders.info',
    'ticket.attachments.placeHolders.info' => '	ticket.attachments.placeHolders.info',
    'ticket.threadMessage.placeHolders.info' => 'ticket.threadMessage.placeHolders.info',
    'ticket.tags.placeHolders.info' => 'ticket.tags.placeHolders.info',
    'ticket.source.placeHolders.info' => 'ticket.source.placeHolders.info',
    'ticket.collaborator.name.placeHolders.info' => 'ticket.collaborator.name.placeHolders.info',
    'ticket.collaborator.email.placeHolders.info' => 'ticket.collaborator.email.placeHolders.info',
    'user.name.info' => 'user.name.info',
    'user.email.info' => 'user.email.info',
    'user.account.validate.link.info' => 'user.account.validate.link.info',
    'user.password.forgot.link.info' => 'user.password.forgot.link.info',
    'global.companyName' => 'global.companyName',
    'global.companyLogo' => 'global.companyLogo',
    'global.companyUrl' => 'global.companyUrl',
    'ticket.priority.placeHolders.info' => '	ticket.priority.placeHolders.info',
    'ticket.group.placeHolders.info' => 'ticket.group.placeHolders.info',
    'ticket.team.placeHolders.info' => 'ticket.team.placeHolders.info',
    'ticket.customerName.placeHolders.info' => '	ticket.customerName.placeHolders.info',
    'ticket.customerEmail.placeHolders.info' => '	ticket.customerEmail.placeHolders.info',
    'ticket.agentName.placeHolders.info' => 'ticket.agentName.placeHolders.info',
    'ticket.agentEmail.placeHolders.info' => 'ticket.agentEmail.placeHolders.info',
    'ticket.link.placeHolders.info' => '	ticket.link.placeHolders.info ',
    'ticket.id.placeHolders.info' => 'ticket.id.placeHolders.info',
    'ticket.subject.placeHolders.info' => '	ticket.subject.placeHolders.info',
    'ticket.status.placeHolders.info' => 'ticket.status.placeHolders.info',
    'comma "," separated' => 'comma separated (,)',
    'Low' => 'Low',
    'Medium' => 'Medium',
    'High' => 'High',
    'Urgent' => 'Urgent',
    'Reset Password' => 'Reset Password',
    'Enter your new password below to update your login credentials' => 'Enter your new password below to update your login credentials',
    'Save Password' => 'Save Password',
    'Rate Support' => 'Rate Support',
    'I am very Sad' => 'I am very disappointed',
    'I am Sad' => 'I am disappointed',
    'I am Neutral' => 'I am satisfied',
    'I am Happy' => 'I am happy',
    'I am Very Happy' => 'I am very happy',
    'Kudos' => 'Kudos',
    'Very Sad' => 'Very disappointed',
    'Sad' => 'Disappointed',
    'Neutral' => 'Satisfied',
    'Happy' => 'Happy',
    'Very Happy' => 'Very Happy',
    'Star(s)' => 'Star(s)',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Warning ! Swiftmailer not working. An error has occurred while sending emails!',
    'Invalid credentials.' => 'Invalid credentials',
    'Success ! Project cache cleared successfully.' => 'Success! Project cache cleared successfully.',
    'clear cache' => 'clear cache',
    'Last Updated' => 'Last Updated',
    'Error! Something went wrong.' => 'Error! Something went wrong.',
    'We were not able to find the page you are looking for.' => 'We were not able to find the page you are looking for.',
    'Page not found' => 'Page not found',
    'Forbidden' => 'Forbidden',
    'You don’t have the necessary permissions to access this Web page :(' => 'You don’t have the necessary permissions to access this Web page :(',
    'Internal server error' => 'Internal server error',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Our system has goofed up for a while, but good part is it won\'t last long',
    'Unknown Error' => 'Unknown Error',
    'We are quite confused about how did you land here:/' => 'We are quite confused about how did you land here :/',
    'Few of the links which may help you to get back on the track -' => 'Few of the links which may help you to get back on the track -',
  ),
));
$catalogueZh->addFallbackCatalogue($catalogueEn);

return $catalogue;
