<?php

namespace Symfony\Config\Framework\Workflows;

require_once __DIR__.\DIRECTORY_SEPARATOR.'WorkflowsConfig'.\DIRECTORY_SEPARATOR.'AuditTrailConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'WorkflowsConfig'.\DIRECTORY_SEPARATOR.'MarkingStoreConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'WorkflowsConfig'.\DIRECTORY_SEPARATOR.'PlaceConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'WorkflowsConfig'.\DIRECTORY_SEPARATOR.'TransitionConfig.php';

use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\Config\Loader\ParamConfigurator;


/**
 * This class is automatically generated to help in creating a config.
 */
class WorkflowsConfig 
{
    private $auditTrail;
    private $type;
    private $markingStore;
    private $supports;
    private $supportStrategy;
    private $initialMarking;
    private $eventsToDispatch;
    private $places;
    private $transitions;
    private $metadata;
    private $_usedProperties = [];
    
    public function auditTrail(array $value = []): \Symfony\Config\Framework\Workflows\WorkflowsConfig\AuditTrailConfig
    {
        if (null === $this->auditTrail) {
            $this->_usedProperties['auditTrail'] = true;
            $this->auditTrail = new \Symfony\Config\Framework\Workflows\WorkflowsConfig\AuditTrailConfig($value);
        } elseif ([] !== $value) {
            throw new InvalidConfigurationException('The node created by "auditTrail()" has already been initialized. You cannot pass values the second time you call auditTrail().');
        }
    
        return $this->auditTrail;
    }
    
    /**
     * @default 'state_machine'
     * @param ParamConfigurator|'workflow'|'state_machine' $value
     * @return $this
     */
    public function type($value): self
    {
        $this->_usedProperties['type'] = true;
        $this->type = $value;
    
        return $this;
    }
    
    public function markingStore(array $value = []): \Symfony\Config\Framework\Workflows\WorkflowsConfig\MarkingStoreConfig
    {
        if (null === $this->markingStore) {
            $this->_usedProperties['markingStore'] = true;
            $this->markingStore = new \Symfony\Config\Framework\Workflows\WorkflowsConfig\MarkingStoreConfig($value);
        } elseif ([] !== $value) {
            throw new InvalidConfigurationException('The node created by "markingStore()" has already been initialized. You cannot pass values the second time you call markingStore().');
        }
    
        return $this->markingStore;
    }
    
    /**
     * @param ParamConfigurator|list<mixed|ParamConfigurator> $value
     * @return $this
     */
    public function supports($value): self
    {
        $this->_usedProperties['supports'] = true;
        $this->supports = $value;
    
        return $this;
    }
    
    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function supportStrategy($value): self
    {
        $this->_usedProperties['supportStrategy'] = true;
        $this->supportStrategy = $value;
    
        return $this;
    }
    
    /**
     * @param ParamConfigurator|list<mixed|ParamConfigurator> $value
     * @return $this
     */
    public function initialMarking($value): self
    {
        $this->_usedProperties['initialMarking'] = true;
        $this->initialMarking = $value;
    
        return $this;
    }
    
    /**
     * Select which Transition events should be dispatched for this Workflow
     * @example workflow.enter
     * @example workflow.transition
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function eventsToDispatch($value = NULL): self
    {
        $this->_usedProperties['eventsToDispatch'] = true;
        $this->eventsToDispatch = $value;
    
        return $this;
    }
    
    public function place(array $value = []): \Symfony\Config\Framework\Workflows\WorkflowsConfig\PlaceConfig
    {
        $this->_usedProperties['places'] = true;
    
        return $this->places[] = new \Symfony\Config\Framework\Workflows\WorkflowsConfig\PlaceConfig($value);
    }
    
    public function transition(array $value = []): \Symfony\Config\Framework\Workflows\WorkflowsConfig\TransitionConfig
    {
        $this->_usedProperties['transitions'] = true;
    
        return $this->transitions[] = new \Symfony\Config\Framework\Workflows\WorkflowsConfig\TransitionConfig($value);
    }
    
    /**
     * @param ParamConfigurator|list<mixed|ParamConfigurator> $value
     * @return $this
     */
    public function metadata($value): self
    {
        $this->_usedProperties['metadata'] = true;
        $this->metadata = $value;
    
        return $this;
    }
    
    public function __construct(array $value = [])
    {
    
        if (array_key_exists('audit_trail', $value)) {
            $this->_usedProperties['auditTrail'] = true;
            $this->auditTrail = new \Symfony\Config\Framework\Workflows\WorkflowsConfig\AuditTrailConfig($value['audit_trail']);
            unset($value['audit_trail']);
        }
    
        if (array_key_exists('type', $value)) {
            $this->_usedProperties['type'] = true;
            $this->type = $value['type'];
            unset($value['type']);
        }
    
        if (array_key_exists('marking_store', $value)) {
            $this->_usedProperties['markingStore'] = true;
            $this->markingStore = new \Symfony\Config\Framework\Workflows\WorkflowsConfig\MarkingStoreConfig($value['marking_store']);
            unset($value['marking_store']);
        }
    
        if (array_key_exists('supports', $value)) {
            $this->_usedProperties['supports'] = true;
            $this->supports = $value['supports'];
            unset($value['supports']);
        }
    
        if (array_key_exists('support_strategy', $value)) {
            $this->_usedProperties['supportStrategy'] = true;
            $this->supportStrategy = $value['support_strategy'];
            unset($value['support_strategy']);
        }
    
        if (array_key_exists('initial_marking', $value)) {
            $this->_usedProperties['initialMarking'] = true;
            $this->initialMarking = $value['initial_marking'];
            unset($value['initial_marking']);
        }
    
        if (array_key_exists('events_to_dispatch', $value)) {
            $this->_usedProperties['eventsToDispatch'] = true;
            $this->eventsToDispatch = $value['events_to_dispatch'];
            unset($value['events_to_dispatch']);
        }
    
        if (array_key_exists('places', $value)) {
            $this->_usedProperties['places'] = true;
            $this->places = array_map(function ($v) { return new \Symfony\Config\Framework\Workflows\WorkflowsConfig\PlaceConfig($v); }, $value['places']);
            unset($value['places']);
        }
    
        if (array_key_exists('transitions', $value)) {
            $this->_usedProperties['transitions'] = true;
            $this->transitions = array_map(function ($v) { return new \Symfony\Config\Framework\Workflows\WorkflowsConfig\TransitionConfig($v); }, $value['transitions']);
            unset($value['transitions']);
        }
    
        if (array_key_exists('metadata', $value)) {
            $this->_usedProperties['metadata'] = true;
            $this->metadata = $value['metadata'];
            unset($value['metadata']);
        }
    
        if ([] !== $value) {
            throw new InvalidConfigurationException(sprintf('The following keys are not supported by "%s": ', __CLASS__).implode(', ', array_keys($value)));
        }
    }
    
    public function toArray(): array
    {
        $output = [];
        if (isset($this->_usedProperties['auditTrail'])) {
            $output['audit_trail'] = $this->auditTrail->toArray();
        }
        if (isset($this->_usedProperties['type'])) {
            $output['type'] = $this->type;
        }
        if (isset($this->_usedProperties['markingStore'])) {
            $output['marking_store'] = $this->markingStore->toArray();
        }
        if (isset($this->_usedProperties['supports'])) {
            $output['supports'] = $this->supports;
        }
        if (isset($this->_usedProperties['supportStrategy'])) {
            $output['support_strategy'] = $this->supportStrategy;
        }
        if (isset($this->_usedProperties['initialMarking'])) {
            $output['initial_marking'] = $this->initialMarking;
        }
        if (isset($this->_usedProperties['eventsToDispatch'])) {
            $output['events_to_dispatch'] = $this->eventsToDispatch;
        }
        if (isset($this->_usedProperties['places'])) {
            $output['places'] = array_map(function ($v) { return $v->toArray(); }, $this->places);
        }
        if (isset($this->_usedProperties['transitions'])) {
            $output['transitions'] = array_map(function ($v) { return $v->toArray(); }, $this->transitions);
        }
        if (isset($this->_usedProperties['metadata'])) {
            $output['metadata'] = $this->metadata;
        }
    
        return $output;
    }

}
