<?php

namespace Symfony\Config\Doctrine\Orm;

require_once __DIR__.\DIRECTORY_SEPARATOR.'EntityManagerConfig'.\DIRECTORY_SEPARATOR.'QueryCacheDriverConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'EntityManagerConfig'.\DIRECTORY_SEPARATOR.'MetadataCacheDriverConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'EntityManagerConfig'.\DIRECTORY_SEPARATOR.'ResultCacheDriverConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'EntityManagerConfig'.\DIRECTORY_SEPARATOR.'EntityListenersConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'EntityManagerConfig'.\DIRECTORY_SEPARATOR.'SecondLevelCacheConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'EntityManagerConfig'.\DIRECTORY_SEPARATOR.'MappingConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'EntityManagerConfig'.\DIRECTORY_SEPARATOR.'DqlConfig.php';
require_once __DIR__.\DIRECTORY_SEPARATOR.'EntityManagerConfig'.\DIRECTORY_SEPARATOR.'FilterConfig.php';

use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\Config\Loader\ParamConfigurator;


/**
 * This class is automatically generated to help in creating a config.
 */
class EntityManagerConfig 
{
    private $queryCacheDriver;
    private $metadataCacheDriver;
    private $resultCacheDriver;
    private $entityListeners;
    private $connection;
    private $classMetadataFactoryName;
    private $defaultRepositoryClass;
    private $autoMapping;
    private $namingStrategy;
    private $quoteStrategy;
    private $entityListenerResolver;
    private $repositoryFactory;
    private $secondLevelCache;
    private $hydrators;
    private $mappings;
    private $dql;
    private $filters;
    private $_usedProperties = [];
    
    public function queryCacheDriver(array $value = []): \Symfony\Config\Doctrine\Orm\EntityManagerConfig\QueryCacheDriverConfig
    {
        if (null === $this->queryCacheDriver) {
            $this->_usedProperties['queryCacheDriver'] = true;
            $this->queryCacheDriver = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\QueryCacheDriverConfig($value);
        } elseif ([] !== $value) {
            throw new InvalidConfigurationException('The node created by "queryCacheDriver()" has already been initialized. You cannot pass values the second time you call queryCacheDriver().');
        }
    
        return $this->queryCacheDriver;
    }
    
    public function metadataCacheDriver(array $value = []): \Symfony\Config\Doctrine\Orm\EntityManagerConfig\MetadataCacheDriverConfig
    {
        if (null === $this->metadataCacheDriver) {
            $this->_usedProperties['metadataCacheDriver'] = true;
            $this->metadataCacheDriver = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\MetadataCacheDriverConfig($value);
        } elseif ([] !== $value) {
            throw new InvalidConfigurationException('The node created by "metadataCacheDriver()" has already been initialized. You cannot pass values the second time you call metadataCacheDriver().');
        }
    
        return $this->metadataCacheDriver;
    }
    
    public function resultCacheDriver(array $value = []): \Symfony\Config\Doctrine\Orm\EntityManagerConfig\ResultCacheDriverConfig
    {
        if (null === $this->resultCacheDriver) {
            $this->_usedProperties['resultCacheDriver'] = true;
            $this->resultCacheDriver = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\ResultCacheDriverConfig($value);
        } elseif ([] !== $value) {
            throw new InvalidConfigurationException('The node created by "resultCacheDriver()" has already been initialized. You cannot pass values the second time you call resultCacheDriver().');
        }
    
        return $this->resultCacheDriver;
    }
    
    public function entityListeners(array $value = []): \Symfony\Config\Doctrine\Orm\EntityManagerConfig\EntityListenersConfig
    {
        if (null === $this->entityListeners) {
            $this->_usedProperties['entityListeners'] = true;
            $this->entityListeners = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\EntityListenersConfig($value);
        } elseif ([] !== $value) {
            throw new InvalidConfigurationException('The node created by "entityListeners()" has already been initialized. You cannot pass values the second time you call entityListeners().');
        }
    
        return $this->entityListeners;
    }
    
    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function connection($value): self
    {
        $this->_usedProperties['connection'] = true;
        $this->connection = $value;
    
        return $this;
    }
    
    /**
     * @default 'Doctrine\\ORM\\Mapping\\ClassMetadataFactory'
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function classMetadataFactoryName($value): self
    {
        $this->_usedProperties['classMetadataFactoryName'] = true;
        $this->classMetadataFactoryName = $value;
    
        return $this;
    }
    
    /**
     * @default 'Doctrine\\ORM\\EntityRepository'
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function defaultRepositoryClass($value): self
    {
        $this->_usedProperties['defaultRepositoryClass'] = true;
        $this->defaultRepositoryClass = $value;
    
        return $this;
    }
    
    /**
     * @default false
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function autoMapping($value): self
    {
        $this->_usedProperties['autoMapping'] = true;
        $this->autoMapping = $value;
    
        return $this;
    }
    
    /**
     * @default 'doctrine.orm.naming_strategy.default'
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function namingStrategy($value): self
    {
        $this->_usedProperties['namingStrategy'] = true;
        $this->namingStrategy = $value;
    
        return $this;
    }
    
    /**
     * @default 'doctrine.orm.quote_strategy.default'
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function quoteStrategy($value): self
    {
        $this->_usedProperties['quoteStrategy'] = true;
        $this->quoteStrategy = $value;
    
        return $this;
    }
    
    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function entityListenerResolver($value): self
    {
        $this->_usedProperties['entityListenerResolver'] = true;
        $this->entityListenerResolver = $value;
    
        return $this;
    }
    
    /**
     * @default 'doctrine.orm.container_repository_factory'
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function repositoryFactory($value): self
    {
        $this->_usedProperties['repositoryFactory'] = true;
        $this->repositoryFactory = $value;
    
        return $this;
    }
    
    public function secondLevelCache(array $value = []): \Symfony\Config\Doctrine\Orm\EntityManagerConfig\SecondLevelCacheConfig
    {
        if (null === $this->secondLevelCache) {
            $this->_usedProperties['secondLevelCache'] = true;
            $this->secondLevelCache = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\SecondLevelCacheConfig($value);
        } elseif ([] !== $value) {
            throw new InvalidConfigurationException('The node created by "secondLevelCache()" has already been initialized. You cannot pass values the second time you call secondLevelCache().');
        }
    
        return $this->secondLevelCache;
    }
    
    /**
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function hydrator(string $name, $value): self
    {
        $this->_usedProperties['hydrators'] = true;
        $this->hydrators[$name] = $value;
    
        return $this;
    }
    
    public function mapping(string $name, array $value = []): \Symfony\Config\Doctrine\Orm\EntityManagerConfig\MappingConfig
    {
        if (!isset($this->mappings[$name])) {
            $this->_usedProperties['mappings'] = true;
    
            return $this->mappings[$name] = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\MappingConfig($value);
        }
        if ([] === $value) {
            return $this->mappings[$name];
        }
    
        throw new InvalidConfigurationException('The node created by "mapping()" has already been initialized. You cannot pass values the second time you call mapping().');
    }
    
    public function dql(array $value = []): \Symfony\Config\Doctrine\Orm\EntityManagerConfig\DqlConfig
    {
        if (null === $this->dql) {
            $this->_usedProperties['dql'] = true;
            $this->dql = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\DqlConfig($value);
        } elseif ([] !== $value) {
            throw new InvalidConfigurationException('The node created by "dql()" has already been initialized. You cannot pass values the second time you call dql().');
        }
    
        return $this->dql;
    }
    
    public function filter(string $name, array $value = []): \Symfony\Config\Doctrine\Orm\EntityManagerConfig\FilterConfig
    {
        if (!isset($this->filters[$name])) {
            $this->_usedProperties['filters'] = true;
    
            return $this->filters[$name] = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\FilterConfig($value);
        }
        if ([] === $value) {
            return $this->filters[$name];
        }
    
        throw new InvalidConfigurationException('The node created by "filter()" has already been initialized. You cannot pass values the second time you call filter().');
    }
    
    public function __construct(array $value = [])
    {
    
        if (array_key_exists('query_cache_driver', $value)) {
            $this->_usedProperties['queryCacheDriver'] = true;
            $this->queryCacheDriver = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\QueryCacheDriverConfig($value['query_cache_driver']);
            unset($value['query_cache_driver']);
        }
    
        if (array_key_exists('metadata_cache_driver', $value)) {
            $this->_usedProperties['metadataCacheDriver'] = true;
            $this->metadataCacheDriver = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\MetadataCacheDriverConfig($value['metadata_cache_driver']);
            unset($value['metadata_cache_driver']);
        }
    
        if (array_key_exists('result_cache_driver', $value)) {
            $this->_usedProperties['resultCacheDriver'] = true;
            $this->resultCacheDriver = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\ResultCacheDriverConfig($value['result_cache_driver']);
            unset($value['result_cache_driver']);
        }
    
        if (array_key_exists('entity_listeners', $value)) {
            $this->_usedProperties['entityListeners'] = true;
            $this->entityListeners = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\EntityListenersConfig($value['entity_listeners']);
            unset($value['entity_listeners']);
        }
    
        if (array_key_exists('connection', $value)) {
            $this->_usedProperties['connection'] = true;
            $this->connection = $value['connection'];
            unset($value['connection']);
        }
    
        if (array_key_exists('class_metadata_factory_name', $value)) {
            $this->_usedProperties['classMetadataFactoryName'] = true;
            $this->classMetadataFactoryName = $value['class_metadata_factory_name'];
            unset($value['class_metadata_factory_name']);
        }
    
        if (array_key_exists('default_repository_class', $value)) {
            $this->_usedProperties['defaultRepositoryClass'] = true;
            $this->defaultRepositoryClass = $value['default_repository_class'];
            unset($value['default_repository_class']);
        }
    
        if (array_key_exists('auto_mapping', $value)) {
            $this->_usedProperties['autoMapping'] = true;
            $this->autoMapping = $value['auto_mapping'];
            unset($value['auto_mapping']);
        }
    
        if (array_key_exists('naming_strategy', $value)) {
            $this->_usedProperties['namingStrategy'] = true;
            $this->namingStrategy = $value['naming_strategy'];
            unset($value['naming_strategy']);
        }
    
        if (array_key_exists('quote_strategy', $value)) {
            $this->_usedProperties['quoteStrategy'] = true;
            $this->quoteStrategy = $value['quote_strategy'];
            unset($value['quote_strategy']);
        }
    
        if (array_key_exists('entity_listener_resolver', $value)) {
            $this->_usedProperties['entityListenerResolver'] = true;
            $this->entityListenerResolver = $value['entity_listener_resolver'];
            unset($value['entity_listener_resolver']);
        }
    
        if (array_key_exists('repository_factory', $value)) {
            $this->_usedProperties['repositoryFactory'] = true;
            $this->repositoryFactory = $value['repository_factory'];
            unset($value['repository_factory']);
        }
    
        if (array_key_exists('second_level_cache', $value)) {
            $this->_usedProperties['secondLevelCache'] = true;
            $this->secondLevelCache = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\SecondLevelCacheConfig($value['second_level_cache']);
            unset($value['second_level_cache']);
        }
    
        if (array_key_exists('hydrators', $value)) {
            $this->_usedProperties['hydrators'] = true;
            $this->hydrators = $value['hydrators'];
            unset($value['hydrators']);
        }
    
        if (array_key_exists('mappings', $value)) {
            $this->_usedProperties['mappings'] = true;
            $this->mappings = array_map(function ($v) { return new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\MappingConfig($v); }, $value['mappings']);
            unset($value['mappings']);
        }
    
        if (array_key_exists('dql', $value)) {
            $this->_usedProperties['dql'] = true;
            $this->dql = new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\DqlConfig($value['dql']);
            unset($value['dql']);
        }
    
        if (array_key_exists('filters', $value)) {
            $this->_usedProperties['filters'] = true;
            $this->filters = array_map(function ($v) { return new \Symfony\Config\Doctrine\Orm\EntityManagerConfig\FilterConfig($v); }, $value['filters']);
            unset($value['filters']);
        }
    
        if ([] !== $value) {
            throw new InvalidConfigurationException(sprintf('The following keys are not supported by "%s": ', __CLASS__).implode(', ', array_keys($value)));
        }
    }
    
    public function toArray(): array
    {
        $output = [];
        if (isset($this->_usedProperties['queryCacheDriver'])) {
            $output['query_cache_driver'] = $this->queryCacheDriver->toArray();
        }
        if (isset($this->_usedProperties['metadataCacheDriver'])) {
            $output['metadata_cache_driver'] = $this->metadataCacheDriver->toArray();
        }
        if (isset($this->_usedProperties['resultCacheDriver'])) {
            $output['result_cache_driver'] = $this->resultCacheDriver->toArray();
        }
        if (isset($this->_usedProperties['entityListeners'])) {
            $output['entity_listeners'] = $this->entityListeners->toArray();
        }
        if (isset($this->_usedProperties['connection'])) {
            $output['connection'] = $this->connection;
        }
        if (isset($this->_usedProperties['classMetadataFactoryName'])) {
            $output['class_metadata_factory_name'] = $this->classMetadataFactoryName;
        }
        if (isset($this->_usedProperties['defaultRepositoryClass'])) {
            $output['default_repository_class'] = $this->defaultRepositoryClass;
        }
        if (isset($this->_usedProperties['autoMapping'])) {
            $output['auto_mapping'] = $this->autoMapping;
        }
        if (isset($this->_usedProperties['namingStrategy'])) {
            $output['naming_strategy'] = $this->namingStrategy;
        }
        if (isset($this->_usedProperties['quoteStrategy'])) {
            $output['quote_strategy'] = $this->quoteStrategy;
        }
        if (isset($this->_usedProperties['entityListenerResolver'])) {
            $output['entity_listener_resolver'] = $this->entityListenerResolver;
        }
        if (isset($this->_usedProperties['repositoryFactory'])) {
            $output['repository_factory'] = $this->repositoryFactory;
        }
        if (isset($this->_usedProperties['secondLevelCache'])) {
            $output['second_level_cache'] = $this->secondLevelCache->toArray();
        }
        if (isset($this->_usedProperties['hydrators'])) {
            $output['hydrators'] = $this->hydrators;
        }
        if (isset($this->_usedProperties['mappings'])) {
            $output['mappings'] = array_map(function ($v) { return $v->toArray(); }, $this->mappings);
        }
        if (isset($this->_usedProperties['dql'])) {
            $output['dql'] = $this->dql->toArray();
        }
        if (isset($this->_usedProperties['filters'])) {
            $output['filters'] = array_map(function ($v) { return $v->toArray(); }, $this->filters);
        }
    
        return $output;
    }

}
