<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('it', array (
  'validators' => 
  array (
    'This value should be false.' => 'Questo valore dovrebbe essere falso.',
    'This value should be true.' => 'Questo valore dovrebbe essere vero.',
    'This value should be of type {{ type }}.' => 'Questo valore dovrebbe essere di tipo {{ type }}.',
    'This value should be blank.' => 'Questo valore dovrebbe essere vuoto.',
    'The value you selected is not a valid choice.' => 'Questo valore dovrebbe essere una delle opzioni disponibili.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Si dovrebbe selezionare almeno {{ limit }} opzione.|Si dovrebbero selezionare almeno {{ limit }} opzioni.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Si dovrebbe selezionare al massimo {{ limit }} opzione.|Si dovrebbero selezionare al massimo {{ limit }} opzioni.',
    'One or more of the given values is invalid.' => 'Uno o più valori inseriti non sono validi.',
    'This field was not expected.' => 'Questo campo non è stato previsto.',
    'This field is missing.' => 'Questo campo è mancante.',
    'This value is not a valid date.' => 'Questo valore non è una data valida.',
    'This value is not a valid datetime.' => 'Questo valore non è una data e ora valida.',
    'This value is not a valid email address.' => 'Questo valore non è un indirizzo email valido.',
    'The file could not be found.' => 'Non è stato possibile trovare il file.',
    'The file is not readable.' => 'Il file non è leggibile.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Il file è troppo grande ({{ size }} {{ suffix }}). La dimensione massima consentita è {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Il mime type del file non è valido ({{ type }}). I tipi permessi sono {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Questo valore dovrebbe essere {{ limit }} o inferiore.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Questo valore è troppo lungo. Dovrebbe essere al massimo di {{ limit }} carattere.|Questo valore è troppo lungo. Dovrebbe essere al massimo di {{ limit }} caratteri.',
    'This value should be {{ limit }} or more.' => 'Questo valore dovrebbe essere {{ limit }} o superiore.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Questo valore è troppo corto. Dovrebbe essere almeno di {{ limit }} carattere.|Questo valore è troppo corto. Dovrebbe essere almeno di {{ limit }} caratteri.',
    'This value should not be blank.' => 'Questo valore non dovrebbe essere vuoto.',
    'This value should not be null.' => 'Questo valore non dovrebbe essere nullo.',
    'This value should be null.' => 'Questo valore dovrebbe essere nullo.',
    'This value is not valid.' => 'Questo valore non è valido.',
    'This value is not a valid time.' => 'Questo valore non è un\'ora valida.',
    'This value is not a valid URL.' => 'Questo valore non è un URL valido.',
    'The two values should be equal.' => 'I due valori dovrebbero essere uguali.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Il file è troppo grande. La dimensione massima è {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Il file è troppo grande.',
    'The file could not be uploaded.' => 'Il file non può essere caricato.',
    'This value should be a valid number.' => 'Questo valore dovrebbe essere un numero.',
    'This file is not a valid image.' => 'Questo file non è una immagine valida.',
    'This is not a valid IP address.' => 'Questo valore non è un indirizzo IP valido.',
    'This value is not a valid language.' => 'Questo valore non è una lingua valida.',
    'This value is not a valid locale.' => 'Questo valore non è una impostazione regionale valida.',
    'This value is not a valid country.' => 'Questo valore non è una nazione valida.',
    'This value is already used.' => 'Questo valore è già stato utilizzato.',
    'The size of the image could not be detected.' => 'La dimensione dell\'immagine non può essere determinata.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'La larghezza dell\'immagine è troppo grande ({{ width }}px). La larghezza massima è di {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'La larghezza dell\'immagine è troppo piccola ({{ width }}px). La larghezza minima è di {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'L\'altezza dell\'immagine è troppo grande ({{ height }}px). L\'altezza massima è di {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'L\'altezza dell\'immagine è troppo piccola ({{ height }}px). L\'altezza minima è di {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Questo valore dovrebbe essere la password attuale dell\'utente.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Questo valore dovrebbe contenere esattamente {{ limit }} carattere.|Questo valore dovrebbe contenere esattamente {{ limit }} caratteri.',
    'The file was only partially uploaded.' => 'Il file è stato caricato solo parzialmente.',
    'No file was uploaded.' => 'Nessun file è stato caricato.',
    'No temporary folder was configured in php.ini.' => 'Nessuna cartella temporanea è stata configurata nel php.ini.',
    'Cannot write temporary file to disk.' => 'Impossibile scrivere il file temporaneo sul disco.',
    'A PHP extension caused the upload to fail.' => 'Un\'estensione PHP ha causato il fallimento del caricamento.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Questa collezione dovrebbe contenere almeno {{ limit }} elemento.|Questa collezione dovrebbe contenere almeno {{ limit }} elementi.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Questa collezione dovrebbe contenere massimo {{ limit }} elemento.|Questa collezione dovrebbe contenere massimo {{ limit }} elementi.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Questa collezione dovrebbe contenere esattamente {{ limit }} elemento.|Questa collezione dovrebbe contenere esattamente {{ limit }} elementi.',
    'Invalid card number.' => 'Numero di carta non valido.',
    'Unsupported card type or invalid card number.' => 'Tipo di carta non supportato o numero non valido.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Questo valore non è un IBAN (International Bank Account Number) valido.',
    'This value is not a valid ISBN-10.' => 'Questo valore non è un codice ISBN-10 valido.',
    'This value is not a valid ISBN-13.' => 'Questo valore non è un codice ISBN-13 valido.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Questo valore non è un codice ISBN-10 o ISBN-13 valido.',
    'This value is not a valid ISSN.' => 'Questo valore non è un codice ISSN valido.',
    'This value is not a valid currency.' => 'Questo valore non è una valuta valida.',
    'This value should be equal to {{ compared_value }}.' => 'Questo valore dovrebbe essere uguale a {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Questo valore dovrebbe essere maggiore di {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Questo valore dovrebbe essere maggiore o uguale a {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Questo valore dovrebbe essere identico a {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Questo valore dovrebbe essere minore di {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Questo valore dovrebbe essere minore o uguale a {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Questo valore dovrebbe essere diverso da {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Questo valore dovrebbe essere diverso da {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Il rapporto di aspetto dell\'immagine è troppo grande ({{ ratio }}). Il rapporto massimo consentito è {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Il rapporto di aspetto dell\'immagine è troppo piccolo ({{ ratio }}). Il rapporto minimo consentito è {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'L\'immagine è quadrata ({{ width }}x{{ height }}px). Le immagini quadrate non sono consentite.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'L\'immagine è orizzontale ({{ width }}x{{ height }}px). Le immagini orizzontali non sono consentite.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'L\'immagine è verticale ({{ width }}x{{ height }}px). Le immagini verticali non sono consentite.',
    'An empty file is not allowed.' => 'Un file vuoto non è consentito.',
    'The host could not be resolved.' => 'L\'host non può essere risolto.',
    'This value does not match the expected {{ charset }} charset.' => 'Questo valore non corrisponde al charset {{ charset }}.',
    'This is not a valid Business Identifier Code (BIC).' => 'Questo valore non è un codice BIC valido.',
    'Error' => 'Errore',
    'This is not a valid UUID.' => 'Questo non è un UUID valido.',
    'This value should be a multiple of {{ compared_value }}.' => 'Questo valore dovrebbe essere un multiplo di {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Questo codice identificativo bancario (BIC) non è associato all\'IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Questo valore dovrebbe essere un JSON valido.',
    'This collection should contain only unique elements.' => 'Questa collezione dovrebbe contenere solo elementi unici.',
    'This value should be positive.' => 'Questo valore dovrebbe essere positivo.',
    'This value should be either positive or zero.' => 'Questo valore dovrebbe essere positivo oppure zero.',
    'This value should be negative.' => 'Questo valore dovrebbe essere negativo.',
    'This value should be either negative or zero.' => 'Questo valore dovrebbe essere negativo oppure zero.',
    'This value is not a valid timezone.' => 'Questo valore non è un fuso orario valido.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Questa password è trapelata durante una compromissione di dati, non deve essere usata. Si prega di usare una password diversa.',
    'This value should be between {{ min }} and {{ max }}.' => 'Questo valore dovrebbe essere compreso tra {{ min }} e {{ max }}.',
    'This value is not a valid hostname.' => 'Questo valore non è un nome di host valido.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Il numero di elementi in questa collezione dovrebbe essere un multiplo di {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Questo valore dovrebbe soddisfare almeno uno dei vincoli seguenti:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Ciascun elemento di questa collezione dovrebbe soddisfare il suo insieme di vincoli.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Questo valore non è un codice identificativo internazionale di valori mobiliari (ISIN) valido.',
    'This value should be a valid expression.' => 'Questo valore dovrebbe essere un\'espressione valida.',
    'This value is not a valid CSS color.' => 'Questo valore non è un colore CSS valido.',
    'This value is not a valid CIDR notation.' => 'Questo valore non è una notazione CIDR valida.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'Il valore della netmask dovrebbe essere compreso tra {{ min }} e {{ max }}.',
    'This form should not contain extra fields.' => 'Questo form non dovrebbe contenere nessun campo extra.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Il file caricato è troppo grande. Per favore, carica un file più piccolo.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'Il token CSRF non è valido. Prova a reinviare il form.',
    'This value is not a valid HTML5 color.' => 'Il valore non è un colore HTML5 valido.',
    'Please enter a valid birthdate.' => 'Per favore, inserisci una data di compleanno valida.',
    'The selected choice is invalid.' => 'La scelta selezionata non è valida.',
    'The collection is invalid.' => 'La collezione non è valida.',
    'Please select a valid color.' => 'Per favore, seleziona un colore valido.',
    'Please select a valid country.' => 'Per favore, seleziona un paese valido.',
    'Please select a valid currency.' => 'Per favore, seleziona una valuta valida.',
    'Please choose a valid date interval.' => 'Per favore, scegli a valid date interval.',
    'Please enter a valid date and time.' => 'Per favore, inserisci a valid date and time.',
    'Please enter a valid date.' => 'Per favore, inserisci a valid date.',
    'Please select a valid file.' => 'Per favore, seleziona un file valido.',
    'The hidden field is invalid.' => 'Il campo nascosto non è valido.',
    'Please enter an integer.' => 'Per favore, inserisci un numero intero.',
    'Please select a valid language.' => 'Per favore, seleziona una lingua valida.',
    'Please select a valid locale.' => 'Per favore, seleziona una lingua valida.',
    'Please enter a valid money amount.' => 'Per favore, inserisci un importo valido.',
    'Please enter a number.' => 'Per favore, inserisci un numero.',
    'The password is invalid.' => 'La password non è valida.',
    'Please enter a percentage value.' => 'Per favore, inserisci un valore percentuale.',
    'The values do not match.' => 'I valori non corrispondono.',
    'Please enter a valid time.' => 'Per favore, inserisci un orario valido.',
    'Please select a valid timezone.' => 'Per favore, seleziona un fuso orario valido.',
    'Please enter a valid URL.' => 'Per favore, inserisci un URL valido.',
    'Please enter a valid search term.' => 'Per favore, inserisci un termine di ricerca valido.',
    'Please provide a valid phone number.' => 'Per favore, indica un numero di telefono valido.',
    'The checkbox has an invalid value.' => 'La casella di selezione non ha un valore valido.',
    'Please enter a valid email address.' => 'Per favore, indica un indirizzo email valido.',
    'Please select a valid option.' => 'Per favore, seleziona un\'opzione valida.',
    'Please select a valid range.' => 'Per favore, seleziona un intervallo valido.',
    'Please enter a valid week.' => 'Per favore, inserisci una settimana valida.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Si è verificato un errore di autenticazione.',
    'Authentication credentials could not be found.' => 'Impossibile trovare le credenziali di autenticazione.',
    'Authentication request could not be processed due to a system problem.' => 'La richiesta di autenticazione non può essere processata a causa di un errore di sistema.',
    'Invalid credentials.' => 'Credenziali non valide.',
    'Cookie has already been used by someone else.' => 'Il cookie è già stato usato da qualcun altro.',
    'Not privileged to request the resource.' => 'Non hai i privilegi per richiedere questa risorsa.',
    'Invalid CSRF token.' => 'CSRF token non valido.',
    'No authentication provider found to support the authentication token.' => 'Non è stato trovato un valido fornitore di autenticazione per supportare il token.',
    'No session available, it either timed out or cookies are not enabled.' => 'Nessuna sessione disponibile, può essere scaduta o i cookie non sono abilitati.',
    'No token could be found.' => 'Nessun token trovato.',
    'Username could not be found.' => 'Username non trovato.',
    'Account has expired.' => 'Account scaduto.',
    'Credentials have expired.' => 'Credenziali scadute.',
    'Account is disabled.' => 'L\'account è disabilitato.',
    'Account is locked.' => 'L\'account è bloccato.',
    'Too many failed login attempts, please try again later.' => 'Troppi tentativi di login falliti, riprova tra un po\'.',
    'Invalid or expired login link.' => 'Link di login scaduto o non valido.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Troppi tentativi di login falliti, riprova tra %minutes% minuto.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Troppi tentativi di login falliti, riprova tra %minutes% minuti.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Precedente',
    'label_next' => 'Successivo',
    'filter_searchword' => 'Ricerca...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Accesso eseguito come',
    'Your Profile' => 'Profilo',
    'Create Ticket' => 'Crea ticket',
    'Create Agent' => 'Crea agente',
    'Create Customer' => 'Crea cliente',
    'Sign Out' => 'Disconnessione',
    'Apps' => 'Applicazioni',
    'Rating' => 'Valutazione',
    'Kudos Rating' => 'Complimenti Valutazione',
    'Choose your default timeformat' => 'Scegli il tuo formato orario predefinito',
    'Remove profile picture' => 'Rimuovi l\'immagine del profilo',
    'Success ! Profile updated successfully.' => 'Successo ! Profilo aggiornato con successo.',
    'Howdy' => 'ciao',
    'Form successfully updated.' => 'Modulo aggiornato con successo.',
    'NEW FORM' => 'NUOVA FORMA',
    'Text Box' => 'Casella di testo',
    'Text Area' => 'Area di testo',
    'Select' => 'Selezionare',
    'Radio' => 'Radio',
    'Checkbox' => 'Casella di controllo',
    'Date' => 'Data',
    'Both Date and Time' => 'Sia data che ora',
    'Choose a status' => 'Scegli uno stato',
    'Choose a group' => 'Scegli un gruppo',
    'Can manage Group\'s Saved Reply' => 'Può gestire la risposta salvata del gruppo',
    'Can manage agent activity' => 'Può gestire l\'attività dell\'agente',
    'Can manage marketing announcement' => 'Può gestire annunci di marketing',
    'User Forgot Password' => 'L\'utente ha dimenticato la password',
    'Agent Deleted' => 'Agente eliminato',
    'Agent Update' => 'Aggiornamento agente',
    'Customer Update' => 'Aggiornamento del cliente',
    'Customer Deleted' => 'Cliente eliminato',
    'Agent Updated' => 'Agente aggiornato',
    'Agent Reply' => 'Risposta dell\'agente',
    'Collaborator Added' => 'Collaboratore aggiunto',
    'Collaborator Reply' => 'Risposta del collaboratore',
    'Customer Reply' => 'Risposta del cliente',
    'Ticket Deleted' => 'Biglietto cancellato',
    'Group Updated' => 'Gruppo aggiornato',
    'Note Added' => 'Nota aggiunta',
    'Priority Updated' => 'Priorità aggiornata',
    'Status Updated' => 'Stato aggiornato',
    'Team Updated' => 'Team aggiornato',
    'Thread Updated' => 'Discussione aggiornata',
    'Type Updated' => 'Tipo aggiornato',
    'From Email' => 'Dall\'email',
    'To Email' => 'Per e-mail',
    'Is Equal To' => 'È uguale a',
    'Is Not Equal To' => 'Non è uguale a',
    'Contains' => 'Contiene',
    'Does Not Contain' => 'Non contiene',
    'Starts With' => 'Inizia con',
    'Ends With' => 'Finisce con',
    'Before On' => 'Prima dell\'attivazione',
    'After On' => 'Dopo l\'attivazione',
    'Mail To User' => 'Posta all\'utente',
    'Permanently delete from Inbox' => 'Elimina in modo permanente dalla posta in arrivo',
    'Transfer Tickets' => 'Biglietti di trasferimento',
    'Reports' => 'Rapporti',
    'Agent Activity' => 'Attività dell\'agente',
    'Report From' => 'Rapporto da',
    'Search Agent' => 'Agente di ricerca',
    'Agent Last Reply' => 'Ultima risposta dell\'agente',
    'View analytics and insights to serve a better experience for your customers' => 'Visualizza analisi e approfondimenti per offrire una migliore esperienza ai tuoi clienti',
    'Marketing Announcement' => 'Annuncio di marketing',
    'Advertisment' => 'Pubblicità',
    'Announcement' => 'Annuncio',
    'New Announcement' => 'Nuovo annuncio',
    'Add Announcement' => 'Aggiungi annuncio',
    'Edit Announcement' => 'Modifica annuncio',
    'Promo Text' => 'Testo promozionale',
    'Promo Tag' => 'Tag promozionale',
    'Choose a promo tag' => 'Scegli un tag promozionale',
    'Tag-Color' => 'Tag-Color',
    'Tag background color' => 'Colore di sfondo del tag',
    'Link Text' => 'Testo del collegamento',
    'Link URL' => 'URL del collegamento',
    'Integrate apps as per your needs to get things done faster than ever' => 'Integra le app secondo le tue esigenze per fare le cose più velocemente che mai',
    'Explore Apps' => 'Esplora le applicazioni',
    'Form Builder' => 'Generatore di moduli',
    'Knowledgebase' => 'Knowledgebase',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'La knowledge base è una fonte di informazioni rigide e complesse che aiutano i clienti ad aiutare se stessi',
    'Articles' => 'Articoli',
    'Categories' => 'Categorie',
    'Folders' => 'Cartelle',
    'FOLDERS' => 'CARTELLE',
    'Productivity' => 'Produttività',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Automatizza i tuoi processi creando un set di regole e preset per rispondere più rapidamente ai ticket',
    'Prepared Responses' => 'Risposte preparate',
    'Saved Replies' => 'Risposte salvate',
    'Edit Saved Reply' => 'Modifica risposta salvata',
    'Ticket Types' => 'Tipi di ticket',
    'Workflows' => 'Flussi di lavoro',
    'Settings' => 'impostazioni',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Gestisci la tua identità di marchio, le informazioni sulla società e altri dettagli a colpo docchio',
    'Branding' => 'Branding',
    'Custom Fields' => 'Campi personalizzati',
    'Email Settings' => 'Impostazioni Email',
    'Email Templates' => 'Modelli email',
    'Mailbox' => 'Casella',
    'Spam Settings' => 'Impostazioni spam',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Tag',
    'Users' => 'Utenti',
    'Control your Groups, Teams, Agents and Customers' => 'Controlla i tuoi gruppi, team, agenti e clienti',
    'Agents' => 'Agenti',
    'Customers' => 'Clienti',
    'Groups' => 'Gruppi',
    'Privileges' => 'Privilegi',
    'Teams' => 'Team',
    'Applications' => 'Applicazioni',
    'ECommerce Order Syncronization' => 'Sincronizzazione degli ordini e-commerce',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Importa i dettagli dellordine e-commerce nei ticket di supporto da diverse piattaforme disponibili',
    'Search' => 'Ricerca',
    'Sort By' => 'Ordina per',
    'Sort By:' => 'Ordina per:',
    'Status' => 'Stato',
    'Created At' => 'Data di creazione',
    'Name' => 'Nome',
    'All' => 'Tutti',
    'Published' => 'Pubblicato',
    'Draft' => 'Bozza',
    'New Folder' => 'Nuova cartella',
    'Create Knowledgebase Folder' => 'Crea cartella della knowledgebase',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'Non hai ancora aggiunto alcuna cartella alla tua knowledge base, crea la tua prima cartella e inizia ad aggiungere categorie / articoli per aiutare i tuoi clienti.',
    'Clear Filters' => 'Elimina filtri',
    'Back' => 'Indietro',
    'Open' => 'Aperto',
    'Pending' => 'In attesa',
    'Answered' => 'Risposto',
    'Resolved' => 'Risolto',
    'Closed' => 'Chiuso',
    'Spam' => 'Spam',
    'New' => 'Nuovo',
    'UnAssigned' => 'Non assegnato',
    'UnAnswered' => 'Senza risposta',
    'My Tickets' => 'I miei ticket',
    'Starred' => 'Preferiti',
    'Trashed' => 'Cestinati',
    'New Label' => 'Nuova etichetta',
    'Tickets' => 'Ticket',
    'Ticket Id' => 'ID Ticket',
    'Last Replied' => 'Ultima risposta',
    'Assign To' => 'Assegnato a',
    'After Reply' => 'Dopo la risposta',
    'Customer Email' => 'Email Cliente',
    'Customer Name' => 'Nome Cliente',
    'Assets Visibility' => 'Visibilità delle risorse',
    'Channel/Source' => 'Canale / Fonte',
    'Channel' => 'Canale',
    'Website' => 'Sito web',
    'Timestamp' => 'Data e ora',
    'TimeStamp' => 'Data e Ora',
    'Team' => 'Team',
    'Type' => 'Tipo',
    'Replies' => 'Risposte',
    'Agent' => 'Agente',
    'ID' => 'ID',
    'Subject' => 'Oggetto',
    'Last Reply' => 'Ultima risposta',
    'Filter View' => 'Filtra',
    'Please select CAPTCHA' => 'Esegui la verifica CAPTCHA non sono un robot | Please select CAPTCHA Im not a robot',
    'Warning ! Please select correct CAPTCHA !' => 'Esegui la verifica CAPTCHA non sono un robot | Please select CAPTCHA Im not a robot',
    'reCAPTCHA Setting' => 'Impostazioni reCAPTCHA',
    'reCAPTCHA Site Key' => 'Chiave del sito reCAPTCHA',
    'reCAPTCHA Secret key' => 'Chiave segreta reCAPTCHA',
    'reCAPTCHA Status' => 'Stato reCAPTCHA',
    'reCAPTCHA is Active' => 'reCAPTCHA è attivo',
    'Save set of filters as a preset to stay more productive' => 'Salva set di filtri come predefinito per rimanere più produttivo',
    'Saved Filters' => 'Filtri salvati',
    'No saved filter created' => 'Nessun filtro salvato creato',
    'Customer' => 'Cliente',
    'Priority' => 'Priorità',
    'Tag' => 'Etichetta',
    'Source' => 'Fonte',
    'Before' => 'Prima',
    'After' => 'Dopo',
    'Replies less than' => 'Risposte meno di',
    'Replies more than' => 'Risposte più di',
    'Clear All' => 'Cancella tutto',
    'Account' => 'Account',
    'Profile' => 'Profilo',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Carica un\'immagine del profilo (100px x 100px) <br> in formato PNG o JPG',
    'First Name' => 'Nome',
    'Last Name' => 'Cognome',
    'Email' => 'E-mail',
    'Contact Number' => 'Numero di telefono',
    'Timezone' => 'Fuso orario',
    'Africa/Abidjan' => 'Africa / Abidjan',
    'Africa/Accra' => 'Africa / Accra',
    'Africa/Addis_Ababa' => 'Africa / Addis_Ababa',
    'Africa/Algiers' => 'Africa / Algiers',
    'Africa/Asmara' => 'Africa / Asmara',
    'Africa/Bamako' => 'Africa / Bamako',
    'Africa/Bangui' => 'Africa / Bangui',
    'Africa/Banjul' => 'Africa / Banjul',
    'Africa/Bissau' => 'Africa / Bissau',
    'Africa/Blantyre' => 'Africa / Blantyre',
    'Africa/Brazzaville' => 'Africa / Brazzaville',
    'Africa/Bujumbura' => 'Africa / Bujumbura',
    'Africa/Cairo' => 'Africa / Cairo',
    'Africa/Casablanca' => 'Africa / Casablanca',
    'Africa/Ceuta' => 'Africa / Ceuta',
    'Africa/Conakry' => 'Africa / Conakry',
    'Africa/Dakar' => 'Africa / Dakar',
    'Africa/Dar_es_Salaam' => 'Africa / Dar_es_Salaam',
    'Africa/Djibouti' => 'Africa / Gibuti',
    'Africa/Douala' => 'Africa / Douala',
    'Africa/El_Aaiun' => 'Africa / El_Aaiun',
    'Africa/Freetown' => 'Africa / Freetown',
    'Africa/Gaborone' => 'Africa / Gaborone',
    'Africa/Harare' => 'Africa / Harare',
    'Africa/Johannesburg' => 'Africa / Johannesburg',
    'Africa/Juba' => 'Africa / Juba',
    'Africa/Kampala' => 'Africa / Kampala',
    'Africa/Khartoum' => 'Africa / Khartoum',
    'Africa/Kigali' => 'Africa / Kigali',
    'Africa/Kinshasa' => 'Africa / Kinshasa',
    'Africa/Lagos' => 'Africa / Lagos',
    'Africa/Libreville' => 'Africa / Libreville',
    'Africa/Lome' => 'Africa / Lome',
    'Africa/Luanda' => 'Africa / Luanda',
    'Africa/Lubumbashi' => 'Africa / Lubumbashi',
    'Africa/Lusaka' => 'Africa / Lusaka',
    'Africa/Malabo' => 'Africa / Malabo',
    'Africa/Maputo' => 'Africa / Maputo',
    'Africa/Maseru' => 'Africa / Maseru',
    'Africa/Mbabane' => 'Africa / Mbabane',
    'Africa/Mogadishu' => 'Africa / Mogadishu',
    'Africa/Monrovia' => 'Africa / Monrovia',
    'Africa/Nairobi' => 'Africa / Nairobi',
    'Africa/Ndjamena' => 'Africa / Ndjamena',
    'Africa/Niamey' => 'Africa / Niamey',
    'Africa/Nouakchott' => 'Africa / Nouakchott',
    'Africa/Ouagadougou' => 'Africa / Ouagadougou',
    'Africa/Porto-Novo' => 'Africa / Porto-Novo',
    'Africa/Sao_Tome' => 'Africa / Sao_Tome',
    'Africa/Tripoli' => 'Africa / Tripoli',
    'Africa/Tunis' => 'Africa / Tunisi',
    'Africa/Windhoek' => 'Africa / Windhoek',
    'America/Adak' => 'America / Adak',
    'America/Anchorage' => 'America / Anchorage',
    'America/Anguilla' => 'America / Anguilla',
    'America/Antigua' => 'America / Antigua',
    'America/Araguaina' => 'America / Araguaina',
    'America/Argentina/Buenos_Aires' => 'America / Argentina / Buenos_Aires',
    'America/Argentina/Catamarca' => 'America / Argentina / Catamarca',
    'America/Argentina/Cordoba' => 'America / Argentina / Cordoba',
    'America/Argentina/Jujuy' => 'America / Argentina / Jujuy',
    'America/Argentina/La_Rioja' => 'America / Argentina / La_Rioja',
    'America/Argentina/Mendoza' => 'America / Argentina / Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America / Argentina / Rio_Gallegos',
    'America/Argentina/Salta' => 'America / Argentina / Salta',
    'America/Argentina/San_Juan' => 'America / Argentina / San_Juan',
    'America/Argentina/San_Luis' => 'America / Argentina / San_Luis',
    'America/Argentina/Tucuman' => 'America / Argentina / Tucuman',
    'America/Argentina/Ushuaia' => 'America / Argentina / Ushuaia',
    'America/Aruba' => 'America / Aruba',
    'America/Asuncion' => 'America / Asuncion',
    'America/Atikokan' => 'America / Atikokan',
    'America/Bahia' => 'America / Bahia',
    'America/Bahia_Banderas' => 'America / Bahia_Banderas',
    'America/Barbados' => 'America / Barbados',
    'America/Belem' => 'America / Belem',
    'America/Belize' => 'America / Belize',
    'America/Blanc-Sablon' => 'America / Blanc-Sablon',
    'America/Boa_Vista' => 'America / Boa_Vista',
    'America/Bogota' => 'America / Bogota',
    'America/Boise' => 'America / Boise',
    'America/Cambridge_Bay' => 'America / Cambridge_Bay',
    'America/Campo_Grande' => 'America / Campo_Grande',
    'America/Cancun' => 'America / Cancun',
    'America/Caracas' => 'America / Caracas',
    'America/Cayenne' => 'America / Cayenne',
    'America/Cayman' => 'America / Cayman',
    'America/Chicago' => 'America / Chicago',
    'America/Chihuahua' => 'America / Chihuahua',
    'America/Costa_Rica' => 'America / Costa_Rica',
    'America/Creston' => 'America / Creston',
    'America/Cuiaba' => 'America / Cuiaba',
    'America/Curacao' => 'America / Curacao',
    'America/Danmarkshavn' => 'America / Danmarkshavn',
    'America/Dawson' => 'America / Dawson',
    'America/Dawson_Creek' => 'America / Dawson_Creek',
    'America/Denver' => 'America / Denver',
    'America/Detroit' => 'America / Detroit',
    'America/Dominica' => 'America / Dominica',
    'America/Edmonton' => 'America / Edmonton',
    'America/Eirunepe' => 'America / Eirunepe',
    'America/El_Salvador' => 'America / El_Salvador',
    'America/Fort_Nelson' => 'America / Fort_Nelson',
    'America/Fortaleza' => 'America / Fortaleza',
    'America/Glace_Bay' => 'America / Glace_Bay',
    'America/Godthab' => 'America / Godthab',
    'America/Goose_Bay' => 'America / Goose_Bay',
    'America/Grand_Turk' => 'America / Grand_Turk',
    'America/Grenada' => 'America / Grenada',
    'America/Guadeloupe' => 'America / Guadeloupe',
    'America/Guatemala' => 'AMERICA / GUATEMALA',
    'America/Guayaquil' => 'America / Guayaquil',
    'America/Guyana' => 'America / Guyana',
    'America/Halifax' => 'America / Halifax',
    'America/Havana' => 'America / Havana',
    'America/Hermosillo' => 'America / Hermosillo',
    'America/Indiana/Indianapolis' => 'America / Indiana / Indianapolis',
    'America/Indiana/Knox' => 'America / Indiana / Knox',
    'America/Indiana/Marengo' => 'America / Indiana / Marengo',
    'America/Indiana/Petersburg' => 'America / Indiana / Petersburg',
    'America/Indiana/Tell_City' => 'America / Indiana / Tell_City',
    'America/Indiana/Vevay' => 'America / Indiana / Vevay',
    'America/Indiana/Vincennes' => 'America / Indiana / Vincennes',
    'America/Indiana/Winamac' => 'America / Indiana / Winamac',
    'America/Inuvik' => 'America / Inuvik',
    'America/Iqaluit' => 'America / Iqaluit',
    'America/Jamaica' => 'America / Jamaica',
    'America/Juneau' => 'America / Juneau',
    'America/Kentucky/Louisville' => 'America / Kentucky / Louisville',
    'America/Kentucky/Monticello' => 'America / Kentucky / Monticello',
    'America/Kralendijk' => 'America / Kralendijk',
    'America/La_Paz' => 'America / La_Paz',
    'America/Lima' => 'America / Lima',
    'America/Los_Angeles' => 'America / Los_Angeles',
    'America/Lower_Princes' => 'America / Lower_Princes',
    'America/Maceio' => 'America / Maceio',
    'America/Managua' => 'America / Managua',
    'America/Manaus' => 'America / Manaus',
    'America/Marigot' => 'America / Marigot',
    'America/Martinique' => 'America / Martinique',
    'America/Matamoros' => 'America / Matamoros',
    'America/Mazatlan' => 'America / Mazatlan',
    'America/Menominee' => 'America / Menominee',
    'America/Merida' => 'America / Merida',
    'America/Metlakatla' => 'America / Metlakatla',
    'America/Mexico_City' => 'America / Mexico_City',
    'America/Miquelon' => 'America / Miquelon',
    'America/Moncton' => 'America / Moncton',
    'America/Monterrey' => 'America / Monterrey',
    'America/Montevideo' => 'America / Montevideo',
    'America/Montserrat' => 'America / Montserrat',
    'America/Nassau' => 'America / Nassau',
    'America/New_York' => 'America / New_York',
    'America/Nipigon' => 'America / Nipigon',
    'America/Nome' => 'America / Nome',
    'America/Noronha' => 'America / Noronha',
    'America/North_Dakota/Beulah' => 'America / North_Dakota / Beulah',
    'America/North_Dakota' => 'America / North_Dakota',
    'America/Ojinaga' => 'America / Ojinaga',
    'America/Panama' => 'America / Panama',
    'America/Pangnirtung' => 'America / Pangnirtung',
    'America/Paramaribo' => 'America / Paramaribo',
    'America/Phoenix' => 'America / Phoenix',
    'America/Port-au-Prince' => 'America / Port-au-Prince',
    'America/Port_of_Spain' => 'America / Port_of_Spain',
    'America/Porto_Velho' => 'America / Porto_Velho',
    'America/Puerto_Rico' => 'America / Puerto_Rico',
    'America/Punta_Arenas' => 'America / Punta_Arenas',
    'America/Rainy_River' => 'America / Rainy_River',
    'America/Rankin_Inlet' => 'America / Rankin_Inlet',
    'America/Recife' => 'America / Recife',
    'America/Regina' => 'America / Regina',
    'America/Resolute' => 'America / Resolute',
    'America/Rio_Branco' => 'America / Rio_Branco',
    'America/Santarem' => 'America / Santarem',
    'America/Santiago' => 'America / Santiago',
    'America/Santo_Domingo' => 'America / Santo_Domingo',
    'America/Sao_Paulo' => 'America / Sao_Paulo',
    'America/Scoresbysund' => 'America / Scoresbysund',
    'America/Sitka' => 'America / Sitka',
    'America/St_Barthelemy' => 'America / St_Barthelemy',
    'America/St_Johns' => 'America / St_Johns',
    'America/St_Kitts' => 'America / St_Kitts',
    'America/St_Lucia' => 'America / St_Lucia',
    'America/St_Thomas' => 'America / St_Thomas',
    'America/St_Vincent' => 'America / St_Vincent',
    'America/Swift_Current' => 'America / Swift_Current',
    'America/Tegucigalpa' => 'America / Tegucigalpa',
    'America/Thule' => 'America / Thule',
    'America/Thunder_Bay' => 'America / Thunder_Bay',
    'America/Tijuana' => 'America / Tijuana',
    'America/Toronto' => 'America / Toronto',
    'America/Tortola' => 'America / Tortola',
    'America/Vancouver' => 'America / Vancouver',
    'America/Whitehorse' => 'America / Whitehorse',
    'America/Winnipeg' => 'America / Winnipeg',
    'America/Yakutat' => 'America / Yakutat',
    'America/Yellowknife' => 'America / Yellowknife',
    'Antarctica/Casey' => 'Antartide / Casey',
    'Antarctica/Davis' => 'Antartide / Davis',
    'Antarctica/DumontDUrville' => 'Antartide / DumontDUrville',
    'Antarctica/Macquarie' => 'Antartide / Macquarie',
    'Antarctica/McMurdo' => 'Antartide / McMurdo',
    'Antarctica/Mawson' => 'Antartide / Mawson',
    'Antarctica/Palmer' => 'Antartide / Palmer',
    'Antarctica/Rothera' => 'Antartide / Rothera',
    'Antarctica/Syowa' => 'Antartide / Syowa',
    'Antarctica/Troll' => 'Antartide / Troll',
    'Antarctica/Vostok' => 'Antartide / Vostok',
    'Arctic/Longyearbyen' => 'Arctic / Longyearbyen',
    'Asia/Aden' => 'Asia / Aden',
    'Asia/Almaty' => 'Asia / Almaty',
    'Asia/Amman' => 'Asia / Amman',
    'Asia/Anadyr' => 'Asia / Anadyr',
    'Asia/Aqtau' => 'Asia / Aqtau',
    'Asia/Aqtobe' => 'Asia / Aqtobe',
    'Asia/Ashgabat' => 'Asia / Ashgabat',
    'Asia/Atyrau' => 'Asia / Atyrau',
    'Asia/Baghdad' => 'Asia / Baghdad',
    'Asia/Bahrain' => 'Asia / Bahrain',
    'Asia/Baku' => 'Asia / Baku',
    'Asia/Bangkok' => 'Asia / Bangkok',
    'Asia/Barnaul' => 'Asia / Barnaul',
    'Asia/Beirut' => 'Asia / Beirut',
    'Asia/Bishkek' => 'Asia / Bishkek',
    'Asia/Brunei' => 'Asia / Brunei',
    'Asia/Chita' => 'Asia / Chita',
    'Asia/Choibalsan' => 'Asia / Choibalsan',
    'Asia/Colombo' => 'Asia / Colombo',
    'Asia/Damascus' => 'Asia / Damascus',
    'Asia/Dhaka' => 'Asia / Dhaka',
    'Asia/Dili' => 'Asia / Dili',
    'Asia/Dubai' => 'Asia / Dubai',
    'Asia/Dushanbe' => 'Asia / Dushanbe',
    'Asia/Famagusta' => 'Asia / Famagosta',
    'Asia/Gaza' => 'Asia / Gaza',
    'Asia/Hebron' => 'Asia / Hebron',
    'Asia/Ho_Chi_Minh' => 'Asia / Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asia / Hong_Kong',
    'Asia/Hovd' => 'Asia / Hovd',
    'Asia/Irkutsk' => 'Asia / Irkutsk',
    'Asia/Jakarta' => 'Asia / Jakarta',
    'Asia/Jayapura' => 'Asia / Jayapura',
    'Asia/Jerusalem' => 'Asia / Jerusalem',
    'Asia/Kabul' => 'Asia / Kabul',
    'Asia/Kamchatka' => 'Asia / Kamchatka',
    'Asia/Karachi' => 'Asia / Karachi',
    'Asia/Kathmandu' => 'Asia / Kathmandu',
    'Asia/Khandyga' => 'Asia / Khandyga',
    'Asia/Kolkata' => 'Asia / Kolkata',
    'Asia/Krasnoyarsk' => 'Asia / Krasnoyarsk',
    'Asia/Kuala_Lumpur' => 'Asia / Kuala_Lumpur',
    'Asia/Kuching' => 'Asia / Kuching',
    'Asia/Kuwait' => 'Asia / Kuwait',
    'Asia/Macau' => 'Asia / Macao',
    'Asia/Magadan' => 'Asia / Magadan',
    'Asia/Makassar' => 'Asia / Makassar',
    'Asia/Manila' => 'Asia / Manila',
    'Asia/Muscat' => 'Asia / Muscat',
    'Asia/Nicosia' => 'Asia / Nicosia',
    'Asia/Novokuznetsk' => 'Asia / Novokuznetsk',
    'Asia/Novosibirsk' => 'Asia / Novosibirsk',
    'Asia/Omsk' => 'Asia / Omsk',
    'Asia/Oral' => 'Asia / orale',
    'Asia/Phnom_Penh' => 'Asia / Phnom_Penh',
    'Asia/Pontianak' => 'Asia / Pontianak',
    'Asia/Pyongyang' => 'Asia / Pyongyang',
    'Asia/Qatar' => 'Asia / Qatar',
    'Asia/Qostanay' => 'Asia / Qostanay',
    'Asia/Qyzylorda' => 'Asia / Qyzylorda',
    'Asia/Riyadh' => 'Asia / Riyadh',
    'Asia/Sakhalin' => 'Asia / Sakhalin',
    'Asia/Samarkand' => 'Asia / Samarcanda',
    'Asia/Seoul' => 'Asia / Seoul',
    'Asia/Shanghai' => 'Asia / Shanghai',
    'Asia/Singapore' => 'Asia / Singapore',
    'Asia/Srednekolymsk' => 'Asia / Srednekolymsk',
    'Asia/Taipei' => 'Asia / Taipei',
    'Asia/Tashkent' => 'Asia / Tashkent',
    'Asia/Tbilisi' => 'Asia / Tbilisi',
    'Asia/Tehran' => 'Asia / Teheran',
    'Asia/Thimphu' => 'Asia / Thimphu',
    'Asia/Tokyo' => 'Asia / Tokyo',
    'Asia/Tomsk' => 'Asia / Tomsk',
    'Asia/Ulaanbaatar' => 'Asia / Ulaanbaatar',
    'Asia/Urumqi' => 'Asia / Urumqi',
    'Asia/Ust-Nera' => 'Asia / Ust-Nera',
    'Asia/Vientiane' => 'Asia / Vientiane',
    'Asia/Vladivostok' => 'Asia / Vladivostok',
    'Asia/Yakutsk' => 'Asia / Yakutsk',
    'Asia/Yangon' => 'Asia / Yangon',
    'Asia/Yekaterinburg' => 'Asia / Yekaterinburg',
    'Asia/Yerevan' => 'Asia / Yerevan',
    'Atlantic/Azores' => 'Atlantic / Azores',
    'Atlantic/Bermuda' => 'Atlantic / Bermuda',
    'Atlantic/Canary' => 'Atlantic / Canary',
    'Atlantic/Cape_Verde' => 'Atlantic / Cape_Verde',
    'Atlantic/Faroe' => 'Atlantic / Faroe',
    'Atlantic/Madeira' => 'Atlantic / Madeira',
    'Atlantic/Reykjavik' => 'Atlantic / Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantic / South_Georgia',
    'Atlantic/St_Helena' => 'Atlantic / St_Helena',
    'Atlantic/Stanley' => 'Atlantic / Stanley',
    'Australia/Adelaide' => 'Australia / Adelaide',
    'Australia/Brisbane' => 'Australia / Brisbane',
    'Australia/Broken_Hill' => 'Australia / Broken_Hill',
    'Australia/Currie' => 'Australia / Currie',
    'Australia/Darwin' => 'Australia / Darwin',
    'Australia/Eucla' => 'Australia / Eucla',
    'Australia/Hobart' => 'Australia / Hobart',
    'Australia/Lindeman' => 'Australia / Lindeman',
    'Australia/Lord_Howe' => 'Australia / Lord_Howe',
    'Australia/Melbourne' => 'Australia / Melbourne',
    'Australia/Perth' => 'Australia / Perth',
    'Australia/Sydney' => 'Australia / Sydney',
    'Europe/Amsterdam' => 'Europe / Amsterdam',
    'Europe/Andorra' => 'Europe / Andorra',
    'Europe/Astrakhan' => 'Europe / Astrakhan',
    'Europe/Athens' => 'Europe / Athens',
    'Europe/Belgrade' => 'Europe / Belgrado',
    'Europe/Berlin' => 'Europe / Berlin',
    'Europe/Bratislava' => 'Europe / Bratislava',
    'Europe/Brussels' => 'Europe / Brussels',
    'Europe/Bucharest' => 'Europe / Bucharest',
    'Europe/Budapest' => 'Europe / Budapest',
    'Europe/Busingen' => 'Europe / Busingen',
    'Europe/Chisinau' => 'Europe / Chisinau',
    'Europe/Copenhagen' => 'Europe / Copenhagen',
    'Europe/Dublin' => 'Europa / Dublino',
    'Europe/Gibraltar' => 'Europa / Gibilterra',
    'Europe/Guernsey' => 'Europe / Guernsey',
    'Europe/Helsinki' => 'Europe / Helsinki',
    'Europe/Isle_of_Man' => 'Europe / Isle_of_Man',
    'Europe/Istanbul' => 'Europe / Istanbul',
    'Europe/Jersey' => 'Europe / Jersey',
    'Europe/Kaliningrad' => 'Europe / Kaliningrad',
    'Europe/Kiev' => 'Europe / Kiev',
    'Europe/Kirov' => 'Europe / Kirov',
    'Europe/Lisbon' => 'Europe / Lisbon',
    'Europe/Ljubljana' => 'Europe / Ljubljana',
    'Europe/London' => 'Europe / London',
    'Europe/Luxembourg' => 'Europe / Luxembourg',
    'Europe/Madrid' => 'Europe / Madrid',
    'Europe/Malta' => 'Europe / Malta',
    'Europe/Mariehamn' => 'Europe / Mariehamn',
    'Europe/Minsk' => 'Europe / Minsk',
    'Europe/Monaco' => 'Europa / Monaco',
    'Europe/Moscow' => 'Europe / Moscow',
    'Europe/Oslo' => 'Europe / Oslo',
    'Europe/Paris' => 'Europe / Paris',
    'Europe/Podgorica' => 'Europe / Podgorica',
    'Europe/Prague' => 'Europe / Prague',
    'Europe/Riga' => 'Europe / Riga',
    'Europe/Rome' => 'Europe / Rome',
    'Europe/Samara' => 'Europe / Samara',
    'Europe/San_Marino' => 'Europe / San_Marino',
    'Europe/Sarajevo' => 'Europe / Sarajevo',
    'Europe/Saratov' => 'Europe / Saratov',
    'Europe/Simferopol' => 'Europe / Simferopol',
    'Europe/Skopje' => 'Europe / Skopje',
    'Europe/Sofia' => 'Europe / Sofia',
    'Europe/Stockholm' => 'Europa / Stoccolma',
    'Europe/Tallinn' => 'Europe / Tallinn',
    'Europe/Tirane' => 'Europe / Tirane',
    'Europe/Ulyanovsk' => 'Europe / Ulyanovsk',
    'Europe/Uzhgorod' => 'Europe / Uzhgorod',
    'Europe/Vaduz' => 'Europe / Vaduz',
    'Europe/Vatican' => 'Europe / Vatican',
    'Europe/Vienna' => 'Europe / Vienna',
    'Europe/Vilnius' => 'Europe / Vilnius',
    'Europe/Volgograd' => 'Europe / Volgograd',
    'Europe/Warsaw' => 'Europe / Warsaw',
    'Europe/Zagreb' => 'Europe / Zagreb',
    'Europe/Zaporozhye' => 'Europe / Zaporozhye',
    'Europe/Zurich' => 'Europe / Zurich',
    'Indian/Antananarivo' => 'Indian / Antananarivo',
    'Indian/Chagos' => 'Indiano / Chagos',
    'Indian/Christmas' => 'Indian / Natale',
    'Indian/Cocos' => 'Indian / Cocos',
    'Indian/Comoro' => 'Indian / Comore',
    'Indian/Kerguelen' => 'Indian / Kerguelen',
    'Indian/Mahe' => 'Indian / Mahe',
    'Indian/Maldives' => 'Indiano / Maldive',
    'Indian/Mauritius' => 'Indian / Mauritius',
    'Indian/Mayotte' => 'Indian / Mayotte',
    'Indian/Reunion' => 'Indian / Reunion',
    'Pacific/Apia' => 'Pacific / Apia',
    'Pacific/Auckland' => 'Pacifico / Auckland',
    'Pacific/Bougainville' => 'Pacifico / Bougainville',
    'Pacific/Chatham' => 'Pacifico / Chatham',
    'Pacific/Chuuk' => 'Pacifico / Chuuk',
    'Pacific/Easter' => 'Pacifico / Pasqua',
    'Pacific/Efate' => 'Pacifico / Efate',
    'Pacific/Enderbury' => 'Pacifico / Enderbury',
    'Pacific/Fakaofo' => 'Pacifico / Fakaofo',
    'Pacific/Fiji' => 'Pacifico / Fiji',
    'Pacific/Funafuti' => 'Pacifico / Funafuti',
    'Pacific/Galapagos' => 'Pacifico / Galapagos',
    'Pacific/Gambier' => 'Pacifico / Gambier',
    'Pacific/Guadalcanal' => 'Pacifico / Guadalcanal',
    'Pacific/Guam' => 'Pacifico / Guam',
    'Pacific/Honolulu' => 'Pacific / Honolulu',
    'Pacific/Kiritimati' => 'Pacifico / Kiritimati',
    'Pacific/Kosrae' => 'Pacifico / Kosrae',
    'Pacific/Kwajalein' => 'Pacifico / Kwajalein',
    'Pacific/Majuro' => 'Pacifico / Majuro',
    'Pacific/Marquesas' => 'Pacifico / Marchesi',
    'Pacific/Midway' => 'Pacifico / Midway',
    'Pacific/Nauru' => 'Pacifico / Nauru',
    'Pacific/Niue' => 'Pacifico / Niue',
    'Pacific/Norfolk' => 'Pacifico / Norfolk',
    'Pacific/Noumea' => 'Pacifico / Noumea',
    'Pacific/Pago_Pago' => 'Pacifico / Pago_Pago',
    'Pacific/Palau' => 'Pacifico / Palau',
    'Pacific/Pitcairn' => 'Pacifico / Pitcairn',
    'Pacific/Pohnpei' => 'Pacifico / Pohnpei',
    'Pacific/Port_Moresby' => 'Pacifico / Port_Moresby',
    'Pacific/Rarotonga' => 'Pacifico / Rarotonga',
    'Pacific/Saipan' => 'Pacifico / Saipan',
    'Pacific/Tahiti' => 'Pacifico / Tahiti',
    'Pacific/Tarawa' => 'Pacifico / Tarawa',
    'Pacific/Tongatapu' => 'Pacifico / Tongatapu',
    'Pacific/Wake' => 'Pacifico / Wake',
    'Pacific/Wallis' => 'Pacifico / Wallis',
    'UTC' => 'UTC',
    'Time Format' => 'Formato orario',
    'Choose your default timezone' => 'Scegli il fuso orario predefinito',
    'Signature' => 'Firma',
    'User signature will be append at the bottom of ticket reply box' => 'La firma verrà aggiunta nella parte inferiore della casella di risposta del ticket',
    'Password' => 'Password',
    'Password will remain same if you are not entering something in this field' => 'La password rimarrà la stessa se non si inserisce qualcosa in questo campo',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'La password deve contenere almeno 8 caratteri di lunghezza, almeno due lettere (senza distinzione tra maiuscole e minuscole), un numero, un carattere speciale (lo spazio non è consentito).',
    'Confirm Password' => 'Conferma password',
    'Save Changes' => 'Salva',
    'SAVE CHANGES' => 'SALVA',
    'CREATE TICKET' => 'CREA TICKET',
    'Customer full name' => 'Nome completo del cliente',
    'Customer email address' => 'Indirizzo email del cliente',
    'Select Type' => 'Seleziona tipo',
    'Support' => 'Supporto',
    'Choose ticket type' => 'Scegli il tipo di ticket',
    'Ticket subject' => 'Oggetto del ticket',
    'Message' => 'Messaggio',
    'Query Message' => 'Messaggio di query',
    'Add Attachment' => 'Aggiungi allegato',
    'This field is mandatory' => 'Questo campo è obbligatorio',
    'General' => 'Generale',
    'Designation' => 'Titolo',
    'Contant Number' => 'Numero concorrente',
    'User signature will be append in the bottom of ticket reply box' => 'La firma verrà aggiunta nella parte inferiore della casella di risposta del ticket',
    'Account Status' => 'Stato dell\'account',
    'Account is Active' => 'L\'account è attivo',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Assegnazione di gruppo / i all\'utente per visualizzare i ticket indipendentemente dall\'assegnazione.',
    'Default' => 'Predefinito',
    'Select All' => 'Seleziona tutto',
    'Remove All' => 'Rimuovi tutto',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Assegnazione di una o più squadre all\'utente per visualizzare i ticket indipendentemente dall\'assegnazione.',
    'No Team added !' => 'Nessuna squadra aggiunta!',
    'Permission' => 'Autorizzazione',
    'Role' => 'Ruolo',
    'Administrator' => 'Amministratore',
    'Select agent role' => 'Seleziona ruolo agente',
    'Add Customer' => 'Aggiungi cliente',
    'Action' => 'Azione',
    'Account Owner' => 'Titolare dell\'account',
    'Active' => 'Attivo',
    'Edit' => 'Modifica',
    'Delete' => 'Elimina',
    'Disabled' => 'Non attivo',
    'New Group' => 'Nuovo gruppo',
    'Default Privileges' => 'Privilegi predefiniti',
    'New Privileges' => 'Nuovi privilegi',
    'NEW PRIVILEGE' => 'NUOVO PRIVILEGIO',
    'New Privilege' => 'Nuovo privilegio',
    'New Team' => 'Nuovo team',
    'No Record Found' => 'Nessun record trovato',
    'Order Synchronization' => 'Sincronizzazione ordini',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Integra facilmente diverse piattaforme di e-commerce con il tuo helpdesk che può essere successivamente utilizzato per integrare rapidamente i dettagli dellordine e-commerce con i tuoi ticket di supporto.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'Nessun canale aggiunto.',
    'Add BigCommerce Store' => 'Aggiungi negozio BigCommerce',
    'ADD BIGCOMMERCE STORE' => 'AGGIUNGI BIGCOMMERCE STORE',
    'Mangento' => 'Mangento',
    'Add Magento Store' => 'Aggiungi Magento Store',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'Aggiungi OpenCart Store',
    'ADD OPENCART STORE' => 'AGGIUNGI NEGOZIO OPENCART',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Aggiungi negozio Shopify',
    'ADD SHOPIFY STORE' => 'AGGIUNGI NEGOZIO SHOPIFY',
    'Integrate a new BigCommerce store' => 'Integra un nuovo negozio BigCommerce',
    'Your BigCommerce Store Name' => 'Il nome del tuo negozio BigCommerce',
    'Your BigCommerce Store Hash' => 'Hash del tuo negozio BigCommerce',
    'Your BigCommerce Api Token' => 'Il tuo token Api BigCommerce',
    'Your BigCommerce Api Client ID' => 'Il tuo ID client Api BigCommerce',
    'Enable Channel' => 'Abilita canale',
    'Add Store' => 'Aggiungi negozio',
    'ADD STORE' => 'AGGIUNGI NEGOZIO',
    'Integrate a new Magento store' => 'Integra un nuovo negozio Magento',
    'Your Magento Api Username' => 'Il tuo nome utente Magento Api',
    'Your Magento Api Password' => 'La tua password Api Magento',
    'Integrate a new OpenCart store' => 'Integra un nuovo negozio OpenCart',
    'Your OpenCart Api Key' => 'La tua chiave Api OpenCart',
    'Your Shopify Store Name' => 'Il nome del tuo negozio Shopify',
    'Your Shopify Api Key' => 'La tua chiave Api di Shopify',
    'Your Shopify Api Password' => 'La tua password Api di Shopify',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Incorpora facilmente un modulo personalizzato per aiutare a generare ticket di helpdesk.',
    'Form-Builder' => 'Form-Builder',
    'Add Formbuilder' => 'Aggiungi formbuilder',
    'ADD FORMBUILDER' => 'AGGIUNGI FORMBUILDER',
    'No FormBuilder have been added.' => 'Nessun FormBuilder è stato aggiunto.',
    'Create a New Custom Form Below' => 'Crea un nuovo modulo personalizzato di seguito',
    'Form Name' => 'Nome modulo',
    'It will be shown in the list of created forms' => 'Verrà visualizzato nellelenco dei moduli creati',
    'MANDATORY FIELDS' => 'CAMPI OBBLIGATORI',
    'These fields will be visible in form and cant be edited' => 'Questi campi saranno visibili nel modulo e non possono essere modificati',
    'Reply' => 'Rispondere',
    'OPTIONAL FIELDS' => 'CAMPI OPZIONALI',
    'Select These Fields to Add in your Form' => 'Seleziona questi campi da aggiungere nel modulo',
    'GDPR' => 'GDPR',
    'Order' => 'Ordine',
    'Categorybuilder' => 'Categorybuilder',
    'File' => 'File',
    'Add Form' => 'Aggiungi modulo',
    'ADD FORM' => 'AGGIUNGI MODULO',
    'UPDATE FORM' => 'MODULO DI AGGIORNAMENTO',
    'Update Form' => 'Modulo di aggiornamento',
    'Embed' => 'Incorporare',
    'EMBED' => 'INCORPORARE',
    'EMBED FORMBUILDER' => 'FORMBUILDER EMBED',
    'Embed Formbuilder' => 'Incorpora Formbuilder',
    'Visit' => 'Visita',
    'VISIT' => 'VISITA',
    'Code' => 'Codice',
    'Total Ticket(s)' => 'Totale ticket',
    'Ticket Count' => 'Conteggio ticket',
    'SwiftMailer Configurations' => 'Configurazioni SwiftMailer',
    'No swiftmailer configurations found' => 'Nessuna configurazione di swiftmailer trovata',
    'CREATE CONFIGURATION' => 'CREA CONFIGURAZIONE',
    'Add configuration' => 'Aggiungi configurazione',
    'Update configuration' => 'Aggiorna configurazione',
    'Mailer ID' => 'ID mailer',
    'Mailer ID - Leave blank to automatically create id' => 'ID mailer - Lascia vuoto per creare automaticamente lid',
    'Transport Type' => 'Tipo di trasporto',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Abilita consegna',
    'Server' => 'server',
    'Port' => 'Porta',
    'Encryption Mode' => 'Modalità di crittografia',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'Nessuna',
    'Authentication Mode' => 'Modalità di autenticazione',
    'login' => 'accesso',
    'Plain' => 'Plain',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Indirizzo mittente',
    'Delivery Address' => 'Indirizzo di consegna',
    'Block Spam' => 'Blocca spam',
    'Black list' => 'Lista nera',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Valori separati tramite virgola (,) (es. support@esempio.com, @esempio.com, 68.98.31.226)',
    'White list' => 'Lista bianca',
    'Mailbox Settings' => 'Impostazioni Casella',
    'No mailbox configurations found' => 'Nessuna configurazione di casella trovata',
    'NEW MAILBOX' => 'NUOVA MAILBOX',
    'New Mailbox' => 'Nuova Casella',
    'Update Mailbox' => 'Aggiorna Casella',
    'Add Mailbox' => 'Aggiungi Casella',
    'Mailbox ID - Leave blank to automatically create id' => 'ID casella - Lascia vuoto per creare automaticamente lid',
    'Mailbox Name' => 'Nome casella',
    'Enable Mailbox' => 'Abilita casella',
    'Incoming Mail (IMAP) Server' => 'Server posta in arrivo (IMAP)',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Configura le impostazioni di imap che verranno utilizzate per recuperare le e-mail dalla tua casella di posta.',
    'Transport' => 'Trasporto',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Host',
    'IMAP Host' => 'Host IMAP',
    'Email address' => 'Indirizzo email',
    'Associated Password' => 'Password associata',
    'Outgoing Mail (SMTP) Server' => 'Server posta in uscita (SMTP)',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Seleziona una configurazione Swift Mailer valida che verrà utilizzata per inviare e-mail tramite la tua casella di posta.',
    'Swift Mailer ID' => 'Swift Mailer ID',
    'None Selected' => 'Nessuno selezionato',
    'Create Mailbox' => 'Crea casella',
    'CREATE MAILBOX' => 'CREA CASELLA',
    'New Template' => 'Nuovo modello',
    'NEW TEMPLATE' => 'NUOVO MODELLO',
    'Customer Forgot Password' => 'Password dimenticata cliente',
    'Customer Account Created' => 'Account cliente creato',
    'Ticket generated success mail to customer' => 'Un Ticket ha generato posta di successo al cliente',
    'Customer Reply To The Agent' => 'Risposta del cliente all\'agente',
    'Ticket Assign' => 'Ticket Assign',
    'Agent Forgot Password' => 'Password dimenticata agente',
    'Agent Account Created' => 'Account agente creato',
    'Ticket generated by customer' => 'Ticket generati dal cliente',
    'Agent Reply To The Customers ticket' => 'Risposta dell\'agente al ticket del cliente',
    'Email template name' => 'Nome modello email',
    'Email template subject' => 'Oggetto modello email',
    'Template For' => 'Modello per',
    'Nothing Selected' => 'Niente di selezionato',
    'email template will be used for work related with selected option' => 'Il modello di email verrà utilizzato per lavori relativi all\'opzione selezionata',
    'Email template body' => 'Corpo modello email',
    'Body' => 'Corpo',
    'placeholders' => 'Variabili',
    'Ticket Subject' => 'Oggetto Ticket',
    'Ticket Message' => 'Messaggio Ticket',
    'Ticket Attachments' => 'Allegati Ticket',
    'Ticket Tags' => 'Etichette Ticket',
    'Ticket Source' => 'Fonte Ticket',
    'Ticket Status' => 'Stato Ticket',
    'Ticket Priority' => 'Priorità Ticket',
    'Ticket Group' => 'Gruppo Ticket',
    'Ticket Team' => 'Team Ticket',
    'Ticket Thread Message' => 'Messaggio thread del ticket',
    'Ticket Customer Name' => 'Nome cliente del ticket',
    'Ticket Customer Email' => 'Email Cliente Ticket',
    'Ticket Agent Name' => 'Nome Agente Ticket',
    'Ticket Agent Email' => 'Email Agente Ticket',
    'Ticket Agent Link' => 'Link Agente Ticket',
    'Ticket Customer Link' => 'Link Cliente Ticket',
    'Last Collaborator Name' => 'Ultimo Cognome Collaboratore',
    'Last Collaborator Email' => 'Ultima Email Collaboratore',
    'Agent/ Customer Name' => 'Nome agente / cliente',
    'Account Validation Link' => 'Link di convalida dell\'account',
    'Password Forgot Link' => 'Password dimenticata collegamento',
    'Company Name' => 'Nome dell\'azienda',
    'Company Logo' => 'Logo dell\'azienda',
    'Company URL' => 'URL dell\'azienda',
    'Swiftmailer id (Select from drop down)' => 'ID Swiftmailer (seleziona dal menu)',
    'PROCEED' => 'PROCEDERE',
    'Proceed' => 'Procedere',
    'Theme Color' => 'Colore del tema',
    'Customer Created' => 'Cliente Creato',
    'Agent Created' => 'Agente Creato',
    'Ticket Created' => 'Ticket Creato',
    'Agent Replied on Ticket' => 'Risposta dell\'agente sul ticket',
    'Customer Replied on Ticket' => 'Risposta del cliente sul ticket',
    'Workflow Status' => 'Stato del flusso di lavoro',
    'Workflow is Active' => 'Il flusso di lavoro è attivo',
    'Events' => 'Eventi',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'Un evento si attiva automaticamente per verificare le condizioni ed eseguire un rispettivo set di azioni predefinito',
    'Select an Event' => 'Seleziona un evento',
    'Add More' => 'Aggiungi',
    'Conditions' => 'Condizioni',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Le condizioni sono un insieme di regole che verificano scenari specifici e sono attivate in occasioni specifiche',
    'Subject or Description' => 'Oggetto o descrizione',
    'Actions' => 'Azioni',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Unazione non solo riduce il carico di lavoro, ma lo rende anche più semplice per lautomazione dei ticket',
    'Select an Action' => 'Seleziona unazione',
    'Add Note' => 'Aggiungi nota',
    'Mail to agent' => 'Mail all\'agente',
    'Mail to customer' => 'Mail al cliente',
    'Mail to group' => 'Mail al gruppo',
    'Mail to last collaborator' => 'Mail all\'ultimo collaboratore',
    'Mail to team' => 'Mail al team',
    'Mark Spam' => 'Marca Spam',
    'Assign to agent' => 'Assegna a agente',
    'Assign to group' => 'Assegna a gruppo',
    'Set Priority As' => 'Imposta priorità come',
    'Set Status As' => 'Imposta stato come',
    'Set Tag As' => 'Imposta tag come',
    'Set Label As' => 'Imposta etichetta come',
    'Assign to team' => 'Assegna a squadra',
    'Set Type As' => 'Imposta tipo come',
    'Add Workflow' => 'Aggiungi flusso di lavoro',
    'ADD WORKFLOW' => 'AGGIUNGI FLUSSO DI LAVORO',
    'Ticket Type code' => 'Codice del tipo di ticket',
    'Ticket Type description' => 'Descrizione del tipo di ticket',
    'Type Status' => 'Tipo di stato',
    'Type is Active' => 'Tipo è attivo',
    'Add Save Reply' => 'Aggiungi Salva risposta',
    'Saved reply name' => 'Nome risposta salvato',
    'Share saved reply with user(s) in these group(s)' => 'Condividi la risposta salvata con gli utenti in questi gruppi',
    'Share saved reply with user(s) in these teams(s)' => 'Condividi la risposta salvata con gli utenti in questi team',
    'Saved reply Body' => 'Organismo di risposta salvato',
    'New Prepared Response' => 'Nuova risposta preparata',
    'Prepared Response Status' => 'Stato di risposta preparato',
    'Prepared Response is Active' => 'La risposta preparata è attiva',
    'Share prepared response with user(s) in these group(s)' => 'Condividi le risposte preparate con gli utenti in questi gruppi',
    'Share prepared response with user(s) in these teams(s)' => 'Condividi le risposte preparate con gli utenti in questi team',
    'ADD PREPARED RESPONSE' => 'AGGIUNGI RISPOSTA PREPARATA',
    'Add Prepared Response' => 'Aggiungi risposta preparata',
    'Folder Name is shown upfront at Knowledge Base' => 'Il nome della cartella viene mostrato in anticipo nella Knowledge Base',
    'A small text about the folder helps user to navigate more easily' => 'Un piccolo testo sulla cartella aiuta lutente a navigare più facilmente',
    'Publish' => 'Pubblicata',
    'Choose appropriate status' => 'Scegli lo stato appropriato',
    'Folder Image' => 'Immagine cartella',
    'An image is worth a thousands words and makes folder more accessible' => 'Unimmagine vale più di mille parole e rende la cartella più accessibile',
    'Add Category' => 'Aggiungi categoria',
    'Category Name is shown upfront at Knowledge Base' => 'Il nome della categoria è mostrato in anticipo nella Knowledge Base',
    'A small text about the category helps user to navigate more easily' => 'Un piccolo testo sulla categoria aiuta lutente a navigare più facilmente',
    'Using Category Order, you can decide which category should display first' => 'Utilizzando lordine delle categorie, puoi decidere quale categoria visualizzare per prima',
    'Sorting' => 'Ordinamento',
    'Ascending Order (A-Z)' => 'Ordine crescente (A-Z)',
    'Descending Order (Z-A)' => 'Ordine decrescente (Z-A)',
    'Based on Popularity' => 'Basato sulla popolarità',
    'Article of this category will display according to selected option' => 'Larticolo di questa categoria verrà visualizzato in base allopzione selezionata',
    'Article' => 'Articolo',
    'Title' => 'Titolo',
    'View' => 'Visualizza',
    'Make as Starred' => 'Crea come preferito',
    'Yes' => 'Sì',
    'No' => 'No',
    'Stared' => 'Fissato',
    'Revisions' => 'Revisioni',
    'Related Articles' => 'Articoli Correlati',
    'Delete Article' => 'Elimina articolo',
    'Content' => 'Contenuto',
    'Slug' => 'Slug',
    'Slug is the url identity of this article.' => 'Lo slug è l\'identità dell\'URL di questo articolo.',
    'Meta Title' => 'Meta Title',
    '# Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'I tag del titolo e le meta descrizioni sono frammenti di codice HTML nellintestazione di una pagina web. Aiutano i motori di ricerca a comprendere il contenuto di una pagina. Il tag del titolo e la meta descrizione di una pagina vengono generalmente visualizzati ogni volta che tale pagina appare nei risultati del motore di ricerca',
    'Meta Keywords' => 'Meta Keywords',
    'Meta Description' => 'Meta Description',
    'Description' => 'Descrizione',
    'Team Status' => 'Stato del Team',
    'Team is Active' => 'Il team è attivo',
    'Edit Privilege' => 'Modifica privilegio',
    'Can create ticket' => 'Può creare un ticket',
    'Can edit ticket' => 'Può modificare un ticket',
    'Can delete ticket' => 'Può eliminare un ticket',
    'Can restore trashed ticket' => 'Può ripristinare un ticket cestinato',
    'Can assign ticket' => 'Può assegnare un ticket',
    'Can assign ticket group' => 'Può assegnare un gruppo ad un ticket',
    'Can update ticket status' => 'Può aggiornare lo stato del ticket',
    'Can update ticket priority' => 'Può aggiornare la priorità del ticket',
    'Can update ticket type' => 'Può aggiornare il tipo di ticket',
    'Can add internal notes to ticket' => 'Può aggiungere note interne al ticket',
    'Can edit thread/notes' => 'Può modificare thread / note',
    'Can lock/unlock thread' => 'Può bloccare / sbloccare il thread',
    'Can add collaborator to ticket' => 'Può aggiungere un collaboratore al ticket',
    'Can delete collaborator from ticket' => 'Può eliminare il collaboratore dal ticket',
    'Can delete thread/notes' => 'Può eliminare thread / note',
    'Can apply prepared response on ticket' => 'Può applicare una risposta preparata su un ticket',
    'Can add ticket tags' => 'Può aggiungere tag ticket',
    'Can delete ticket tags' => 'Può eliminare i tag ticket',
    'Can kick other ticket users' => 'Può espellere altri utenti di un ticket',
    'Can manage email templates' => 'Può gestire i modelli di email',
    'Can manage groups' => 'Può gestire i gruppi',
    'Can manage Sub-Groups/ Teams' => 'Può gestire sottogruppi / squadre',
    'Can manage agents' => 'Può gestire gli agenti',
    'Can manage agent privileges' => 'Può gestire i privilegi degli agenti',
    'Can manage ticket types' => 'Può gestire i tipi di ticket',
    'Can manage ticket custom fields' => 'Può gestire i campi personalizzati dei ticket',
    'Can manage customers' => 'Può gestire i clienti',
    'Can manage Prepared Responses' => 'Può gestire le risposte preparate',
    'Can manage Automatic workflow' => 'Può gestire il flusso di lavoro automatico',
    'Can manage tags' => 'Può gestire i tag',
    'Can manage knowledgebase' => 'Può gestire la knowledge base',
    'Can manage Groups Saved Reply' => 'Può gestire la risposta salvata del gruppo',
    'Add Privilege' => 'Aggiungi privilegio',
    'Choose set of privileges which will be available to the agent.' => 'Scegli un set di privilegi che saranno disponibili per lagente.',
    'Advanced' => 'Avanzate',
    'Privilege Name must have characters only' => 'Il nome privilegio deve contenere solo caratteri',
    'Maximum character length is 50' => 'La lunghezza massima dei caratteri è 50',
    'Open Tickets' => 'Ticket aperti',
    'New Customer' => 'Nuovo cliente',
    'New Agent' => 'Nuovo agente',
    'Total Article(s)' => 'Totale articoli',
    'Please specify a valid email address' => 'Specifica un indirizzo email valido',
    'Please enter the password associated with your email address' => 'Inserisci la password associata al tuo indirizzo email',
    'Please enter your server host address' => 'Inserisci lindirizzo del tuo server',
    'Please specify a port number to connect with your mail server' => 'Specificare un numero di porta per connettersi con il proprio server di posta',
    'Success ! Branding details saved successfully.' => 'Successo! Dettagli di branding salvati correttamente. ',
    'Success ! Time details saved successfully.' => 'Successo! Dettagli temporali salvati correttamente. ',
    'Spam setting saved successfully.' => 'Impostazioni spam salvate correttamente.',
    'Please specify a valid name for your mailbox.' => 'Specifica un nome valido per la tua casella di posta.',
    'Please select a valid swift-mailer configuration.' => 'Seleziona una configurazione swift-mailer valida.',
    'Please specify a valid host address.' => 'Specificare un indirizzo host valido.',
    'Please specify a valid email address.' => 'Specifica un indirizzo email valido.',
    'Please enter the associated account password.' => 'Inserisci la password dellaccount associata.',
    'New Saved Reply' => 'Nuova risposta salvata',
    'New Category' => 'Nuova categoria',
    'Folder' => 'Cartella',
    'Category' => 'Categoria',
    'Created' => 'Data di creazione',
    'All Articles' => 'Tutti gli articoli',
    'Viewed' => 'Visualizzazioni',
    'New Article' => 'Nuovo articolo',
    'Thank you for your feedback!' => 'Grazie per il tuo feedback!',
    'Was this article helpful?' => 'Questo articolo è stato utile?',
    'Helpdesk' => 'Helpdesk',
    'Support Center' => 'Centro di supporto',
    'Mailboxes' => 'Caselle',
    'By' => 'Da',
    'Search Tickets' => 'Cerca ticket',
    'Customer Information' => 'Informazioni per il cliente',
    'Total Replies' => 'Risposte totali',
    'Filter With' => 'Filtra con',
    'Type email to add' => 'Digita lemail da aggiungere',
    'Collaborators' => 'Collaboratori',
    'Labels' => 'Etichette',
    'Group' => 'Gruppo',
    'Stay on ticket' => 'Resta sul ticket',
    'Redirect to list' => 'Reindirizza all\'elenco',
    'Nothing interesting here...' => 'Niente di interessante qui',
    'Previous Ticket' => 'Ticket precedente',
    'Next Ticket' => 'Ticket successivo',
    'Forward' => 'Inoltrare',
    'Note' => 'Nota',
    'Write a reply' => 'Scrivi una risposta',
    'Created Ticket' => 'Ticket creato',
    'All Threads' => 'Tutte le discussioni',
    'Forwards' => 'Inoltrati',
    'Notes' => 'Note',
    'Pinned' => 'Fissato',
    'Edit Ticket' => 'Modifica ticket',
    'Print Ticket' => 'Stampa ticket',
    'Mark as Spam' => 'Segna come spam',
    'Mark as Closed' => 'Segna come chiuso',
    'Delete Ticket' => 'Elimina ticket',
    'View order details from different eCommerce channels' => 'Visualizza i dettagli dellordine da diversi canali di e-commerce',
    'ECOMMERCE CHANNELS' => 'CANALI ECOMMERCE',
    'Select channel' => 'Seleziona canale',
    'Order Id' => 'ID ordine',
    'Fetch Order' => 'Recupera ordine',
    'No orders have been integrated to this ticket yet.' => 'Nessun ordine è stato ancora integrato in questo ticket.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Inserisci le credenziali per accedere al tuo account di helpdesk.',
    'Keep me logged in' => 'Resta collegato',
    'Forgot Password?' => 'Ha dimenticato la password?',
    'Log in to your' => 'Accedi al tuo',
    'Sign In' => 'Accedi',
    'Edit Customer' => 'Modifica cliente',
    'Update' => 'Aggiorna',
    'Discard' => 'Scarta',
    'Cancel' => 'Annulla',
    'Not Assigned' => 'Non assegnato',
    'Submit' => 'Invia',
    'Submit And Open' => 'Invia e aperto',
    'Submit And Pending' => 'Invia e in attesa',
    'Submit And Answered' => 'Invia e risposto',
    'Submit And Resolved' => 'Invia e risolto',
    'Submit And Closed' => 'Invia e chiuso',
    'Choose a Color' => 'Scegli un colore',
    'Create' => 'Creare',
    'Edit Label' => 'Modifica etichetta',
    'Add Label' => 'Aggiungi etichetta',
    'To' => 'Per',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Il tuo browser non supporta JavaScript o hai disabilitato JavaScript, abilitalo!',
    'Confirm Action' => 'Conferma azione',
    'Confirm' => 'Confermare',
    'No result found' => 'Nessun risultato trovato',
    'ticket delivery status' => 'stato di consegna del ticket',
    'Warning! Select valid image file.' => 'Avvertimento! Seleziona un file di immagine valido. ',
    'Error' => 'Errore',
    'Save' => 'Salva',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Modifica filtro salvato',
    'Type atleast 2 letters' => 'Digitare almeno 2 lettere',
    'Remove Label' => 'Rimuovi etichetta',
    'New Saved Filter' => 'Nuovo filtro salvato',
    'Is Default' => 'È predefinito',
    'Remove Saved Filter' => 'Rimuovi filtro salvato',
    'Ticket Info' => 'Informazioni ticket',
    'Last Replied Agent' => 'Ultimo agente replicato',
    'created Ticket' => 'Ticket creato',
    'Uploaded Files' => 'File caricati',
    'Download (as .zip)' => 'Scarica (con il nome .zip)',
    'made last reply' => 'ha fatto lultima risposta',
    'N/A' => 'N / A',
    'Unassigned' => 'Non assegnato',
    'Label' => 'Etichetta',
    'Assigned to me' => 'Assegnato a me',
    'Search Query' => 'Query di ricerca',
    'Searching' => 'Ricerca',
    'Saved Filter' => 'Filtro salvato',
    'No Label Created' => 'Nessuna etichetta creata',
    'Label with same name already exist.' => 'Un\'etichetta con lo stesso nome esiste già.',
    'Create New' => 'Creare nuovo',
    'Mail status' => 'Stato della posta',
    'replied' => 'Risposto',
    'added note' => 'nota aggiunta',
    'forwarded' => 'Trasmessa',
    'TO' => 'PER',
    'CC' => 'CC',
    'BCC' => 'BCC',
    'Locked' => 'Bloccato',
    'Edit Thread' => 'Modifica discussione',
    'Delete Thread' => 'Elimina discussione',
    'Unpin Thread' => 'Sblocca discussione',
    'Pin Thread' => 'Pin Thread',
    'Unlock Thread' => 'Sblocca discussione',
    'Lock Thread' => 'Blocca discussione',
    'Translate Thread' => 'Traduci discussione',
    'Language' => 'Linguaggio',
    'English' => 'Inglese',
    'French' => 'Francese',
    'Italian' => 'Italiano',
    'Arabic' => 'Arabo',
    'German' => 'Tedesco',
    'Spanish' => 'Spagnolo',
    'Turkish' => 'Turco',
    'Danish' => 'Danese',
    'System' => 'Sistema',
    'Open in Files' => 'Apri in file',
    'Email address is invalid' => 'Lindirizzo email non è valido',
    'Tag with same name already exist' => 'Il tag con lo stesso nome esiste già',
    'Text length should be less than 20 charactors' => 'La lunghezza del testo deve essere inferiore a 20 caratteri',
    'Label with same name already exist' => 'L\'etichetta con lo stesso nome esiste già',
    'Agent Name' => 'Nome agente',
    'Agent Email' => 'Email agente',
    'open' => 'Aperto',
    'Currently active agents on ticket' => 'Agenti attualmente attivi sul ticket',
    'Edit Customer Information' => 'Modifica informazioni cliente',
    'Restore' => 'Ristabilire',
    'Delete Forever' => 'Elimina per sempre',
    'Add Team' => 'Aggiungi squadra',
    'delete' => 'Elimina',
    'You didnt have any folder for current filter(s).' => 'Non avevi nessuna cartella per i filtri correnti.',
    'Add Folder' => 'Aggiungi cartella',
    'This field must have valid characters only' => 'Questo campo deve contenere solo caratteri validi',
    'Can edit task' => 'Può modificare l\'attività',
    'Can create task' => 'Può creare attività',
    'Can delete task' => 'Può eliminare lattività',
    'Can add member to task' => 'Può aggiungere un membro all\'attività',
    'Can remove member from task' => 'Può rimuovere un membro dall\'attività',
    'Agent Privileges' => 'Privilegi agente',
    'Agent Privilege represents overall permissions in System.' => 'Privilegio agente rappresenta le autorizzazioni generali nel sistema.',
    'Ticket View' => 'Ticket View',
    'User can view tickets based on selected scope.' => 'Lutente può visualizzare i ticket in base all\'ambito selezionato.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'Se l\'accesso individuale l\'utente può visualizzare solo i ticket assegnati, se l\'accesso al team l\'utente può visualizzare tutti i ticket della squadra a cui appartiene e così via',
    'Global Access' => 'Accesso globale',
    'Group Access' => 'Accesso al gruppo',
    'Team Access' => 'Accesso al team',
    'Individual Access' => 'Accesso individuale',
    'This field must have characters only' => 'Questo campo deve contenere solo caratteri',
    'Maximum character length is 40' => 'La lunghezza massima dei caratteri è 40',
    'This is not a valid email address' => 'Questo non è un indirizzo e-mail valido',
    'Password must contains 8 Characters' => 'La password deve contenere 8 caratteri',
    'The passwords does not match' => 'Le password non corrispondono',
    'Enabled' => 'Abilitato',
    'Create Configuration' => 'Crea configurazione',
    'Swift Mailer Settings' => 'Impostazioni di Swift Mailer',
    'Username' => 'Nome utente',
    'Please select a swiftmailer id' => 'Seleziona un ID swiftmailer',
    'Please enter a valid e-mail id' => 'Inserisci un ID e-mail valido',
    'Please enter a mailer id' => 'Inserisci un ID mailer',
    'Email Id' => 'E-mail identificativa',
    'Are you sure? You want to perform this action.' => 'Sei sicuro? Vuoi eseguire questa azione. ',
    'Reorder' => 'Riordina',
    'New Workflow' => 'Nuovo flusso di lavoro',
    'OR' => 'O',
    'AND' => 'E',
    'Please enter a valid name.' => 'Per favore inserire un nome valido.',
    'Please select a value.' => 'Seleziona un valore.',
    'Please add a value.' => 'Per favore, aggiungi un valore.',
    'This field is required' => 'Questo campo è obbligatorio',
    'or' => 'o',
    'and' => 'e',
    'Select a Condition' => 'Seleziona una condizione',
    'Loading...' => 'Caricamento in corso...',
    'Select Option' => 'Selezionare lopzione',
    'Inactive' => 'Inattivo',
    'New Type' => 'Nuovo tipo',
    'Placeholders' => 'segnaposto',
    'Ticket Link' => 'Ticket Link',
    'Id' => 'Id',
    'Preview' => 'Anteprima',
    'Sort Order' => 'Ordinamento',
    'This field must be a number' => 'Questo campo deve essere un numero',
    'User' => 'Utente',
    'Edit Group' => 'Modifica gruppo',
    'Group Status' => 'Stato del gruppo',
    'Group is Active' => 'Il gruppo è attivo',
    'Add Group' => 'Aggiungere gruppo',
    'Contact number is invalid' => 'Il numero di contatto non è valido',
    'Edit Agent' => 'Modifica agente',
    'No Privilege added, Please add Privilege(s) first !' => 'Nessun privilegio aggiunto, per favore aggiungi prima i privilegi!',
    'Edit Email Template' => 'Modifica modello email',
    'Edit Workflow' => 'Modifica flusso di lavoro',
    'Save Workflow' => 'Salva flusso di lavoro',
    'Edit Ticket Type' => 'Modifica tipo di ticket',
    'Add Ticket Type' => 'Aggiungi tipo di ticket',
    'Date Released' => 'Data di rilascio',
    'Free' => 'Gratuito',
    'Premium' => 'Premium',
    'Installed' => 'Installata',
    'Installed Applications' => 'Applicazioni installate',
    'Apps Dashboard' => 'Dashboard delle app',
    'Nothing Interesting here' => 'Niente di interessante qui',
    'No Categories Added' => 'Nessuna categoria aggiunta',
    'ticket' => 'ticket',
    'Add Email Template' => 'Aggiungi modello email',
    'This field contain 100 characters only' => 'Questo campo contiene solo 100 caratteri',
    'This field contain characters only' => 'Questo campo contiene solo caratteri',
    'Name length must not be greater than 200 !!' => 'La lunghezza del nome non deve essere maggiore di 200 !!',
    'Warning! Correct all field values first!' => 'Avvertimento! Prima correggi tutti i valori dei campi! ',
    'Warning ! This is not a valid request' => 'Avvertimento ! Questa non è una richiesta valida ',
    'Success ! Tag removed successfully.' => 'Successo! Tag rimosso correttamente. ',
    'Success ! Tags Saved successfully.' => 'Successo! Tag salvati correttamente. ',
    'Success ! Revision restored successfully.' => 'Successo! Revisione ripristinata correttamente. ',
    'Success ! Categories updated successfully.' => 'Successo! Categorie aggiornate correttamente. ',
    'Success ! Article Related removed successfully.' => 'Successo! Articolo correlato rimosso correttamente. ',
    'Success ! Article Related is already added.' => 'Successo! L\'articolo correlato è già stato aggiunto. ',
    'Success ! Cannot add self as relative article.' => 'Successo! Impossibile aggiungere se stesso come articolo relativo. ',
    'Success ! Article Related updated successfully.' => 'Successo! Articolo correlato aggiornato correttamente. ',
    'Success ! Articles removed successfully.' => 'Successo! Articoli rimossi correttamente. ',
    'Success ! Article status updated successfully.' => 'Successo! Stato dell\'articolo aggiornato correttamente. ',
    'Success ! Article star updated successfully.' => 'Successo! Stella dell\'articolo aggiornata correttamente. ',
    'Success! Article updated successfully' => 'Successo! Articolo aggiornato correttamente ',
    'Success ! Category sort  order updated successfully.' => 'Successo! Ordinamento delle categorie aggiornato correttamente. ',
    'Success ! Category status updated successfully.' => 'Successo! Stato della categoria aggiornato correttamente. ',
    'Success ! Folders updated successfully.' => 'Successo! Cartelle aggiornate correttamente. ',
    'Success ! Categories removed successfully.' => 'Successo! Categorie rimosse correttamente. ',
    'Success ! Category updated successfully.' => 'Successo! Categoria aggiornata correttamente. ',
    'Error ! Category is not exist.' => 'Errore! La categoria non esiste. ',
    'Warning ! Customer Login disabled by admin.' => 'Avvertimento ! Accesso cliente disabilitato dallamministratore. ',
    'This Email is not registered with us.' => 'Questa email non è registrata con noi.',
    'Your password has been updated successfully.' => 'La tua password è stata aggiornata correttamente.',
    'Password dont match.' => 'La password non corrisponde.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Errore! L\'immagine del profilo non è valida, carica un formato valido',
    'Success! Folder has been added successfully.' => 'Successo! La cartella è stata aggiunta correttamente. ',
    'Folder updated successfully.' => 'Cartella aggiornata correttamente.',
    'Success ! Folder status updated successfully.' => 'Successo! Stato della cartella aggiornato correttamente. ',
    'Error ! Folder is not exist.' => 'Errore! La cartella non esiste. ',
    'Success ! Folder updated successfully.' => 'Successo! Cartella aggiornata correttamente. ',
    'Error ! Folder does not exist.' => 'Errore! La cartella non esiste. ',
    'Success ! Folder deleted successfully.' => 'Successo! Cartella eliminata correttamente. ',
    'Warning ! Folder doesnt exists!' => 'Attenzione! La cartella non esiste!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Avvertimento ! Impossibile creare il ticket, dato che le-mail è bloccata dallamministratore.',
    'Success ! Ticket has been created successfully.' => 'Successo! Il ticket è stato creato correttamente. ',
    'Warning ! Can not create ticket, invalid details.' => 'Avvertimento ! Impossibile creare il ticket, dettagli non validi.',
    'Warning ! Post size can not exceed 25MB' => 'Attenzione! Le dimensioni del post non possono superare i 25 MB',
    'Create Ticket Request' => 'Crea richiesta ticket',
    'Success ! Reply added successfully.' => 'Successo! Risposta aggiunta correttamente.',
    'Warning ! Reply field can not be blank.' => 'Attenzione! Il campo di risposta non può essere vuoto.',
    'Success ! Rating has been successfully added.' => 'Successo! La valutazione è stata aggiunta correttamente. ',
    'Warning ! Invalid rating.' => 'Avvertimento ! Valutazione non valida.',
    'Error ! Can not add customer as a collaborator.' => 'Errore! Impossibile aggiungere il cliente come collaboratore',
    'Success ! Collaborator added successfully.' => 'Successo! Collaboratore aggiunto correttamente.',
    'Error ! Collaborator is already added.' => 'Errore! Il collaboratore è già stato aggiunto.',
    'Success ! Collaborator removed successfully.' => 'Successo! Collaboratore rimosso con successo.',
    'Error ! Invalid Collaborator.' => 'Errore! Collaboratore non valido.',
    'An unexpected error occurred. Please try again later.' => 'Si è verificato un errore imprevisto. Per favore riprova più tardi.',
    'Feedback saved successfully.' => 'Feedback salvato correttamente.',
    'Feedback updated successfully.' => 'Feedback aggiornato correttamente.',
    'Invalid feedback provided.' => 'Feedback non valido fornito.',
    'Article not found.' => 'Articolo non trovato.',
    'You need to login to your account before can perform this action.' => 'Devi accedere al tuo account prima di poter eseguire questa azione.',
    'Warning! Please add valid Actions!' => 'Avvertimento! Aggiungi azioni valide! ',
    'Warning! In Free Plan you can not change Events!' => 'Avvertimento! In Free Plan non puoi cambiare Eventi! ',
    'Success! Prepared Response has been updated successfully.' => 'Successo! La risposta preparata è stata aggiornata correttamente.',
    'Success! Prepared Response has been added successfully.' => 'Successo! La risposta preparata è stata aggiunta correttamente. ',
    'Warning  This is not a valid request' => 'Avviso Questa non è una richiesta valida',
    'Use Default Colors' => 'Usa colori predefiniti',
    'Masonry' => 'Masonry',
    'Popular article' => 'Articolo popolare',
    'Manage Ticket Custom Fields' => 'Gestisci campi personalizzati ticket',
    'You dont have premission to edit this Prepared response ' => 'Non hai la premessa di modificare questa risposta preparata',
    'Save Prepared Response' => 'Salva risposta preparata',
    'Success ! Prepared response removed successfully.' => 'Successo! Risposta preparata rimossa correttamente. ',
    'Warning! You are not allowed to perform this action.' => 'Avvertimento! Non ti è consentito eseguire questa azione. ',
    'Success! Workflow has been updated successfully.' => 'Successo! Il flusso di lavoro è stato aggiornato correttamente. ',
    'Success! Workflow has been added successfully.' => 'Successo! Il flusso di lavoro è stato aggiunto correttamente. ',
    'Success! Order has been updated successfully.' => 'Successo! L\'ordine è stato aggiornato correttamente. ',
    'Success! Workflow has been removed successfully.' => 'Successo! Il flusso di lavoro è stato rimosso correttamente. ',
    'Mailbox successfully created.' => 'Casella creata correttamente.',
    'Mailbox successfully updated.' => 'Casella aggiornata correttamente.',
    'Warning ! Bad request !' => 'Avvertimento ! Brutta richiesta !',
    'Error! Given current password is incorrect.' => 'Errore! La password corrente è errata. ',
    'Success ! Profile update successfully.' => 'Successo! Aggiornamento del profilo eseguito correttamente. ',
    'Error ! User with same email is already exist.' => 'Errore! Lutente con la stessa email è già esistente. ',
    'Success ! Agent updated successfully.' => 'Successo! Agente aggiornato correttamente. ',
    'Success ! Agent removed successfully.' => 'Successo! Agente rimosso correttamente. ',
    'Warning ! You are allowed to remove account owners account.' => 'Avviso! Puoi rimuovere l\'account del proprietario dell\'account.',
    'Error ! Invalid user id.' => 'Errore! ID utente non valido.',
    'Success ! Filter has been saved successfully.' => 'Successo! Il filtro è stato salvato con successo.',
    'Success ! Filter has been updated successfully.' => 'Successo! Il filtro è stato aggiornato con successo.',
    'Success ! Filter has been removed successfully.' => 'Operazione riuscita! Il filtro è stato rimosso correttamente.',
    'Please check your mail for password update.' => 'Controlla la tua posta per laggiornamento della password.',
    'This Email address is not registered with us.' => 'Questo indirizzo email non è registrato presso di noi.',
    'Success ! Customer saved successfully.' => 'Successo! Il cliente è stato salvato con successo.',
    'Error ! User with same email already exist.' => 'Errore! Esistono già utenti con la stessa e-mail.',
    'Success ! Customer information updated successfully.' => 'Successo! Informazioni sui clienti aggiornate con successo.',
    'Success ! Customer updated successfully.' => 'Successo! Il cliente è stato aggiornato con successo.',
    'Error ! Customer with same email already exist.' => 'Errore! Esistono già clienti con la stessa e-mail.',
    'unstarred Action Completed successfully' => 'Azione non contrassegnata completata correttamente',
    'starred Action Completed successfully' => 'Azione speciale completata correttamente',
    'Success ! Customer removed successfully.' => 'Successo! Cliente rimosso con successo.',
    'Error ! Invalid customer id.' => 'Errore! ID cliente non valido.',
    'Success! Template has been updated successfully.' => 'Successo! Il modello è stato aggiornato con successo.',
    'Success! Template has been added successfully.' => 'Successo! Il modello è stato aggiunto correttamente.',
    'Success! Template has been deleted successfully.' => 'Successo! Il modello è stato cancellato con successo.',
    'Warning! resource not found.' => 'Attenzione! Risorsa non trovata.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Attenzione! Non è possibile rimuovere il modello di posta elettronica predefinito utilizzato nei flussi di lavoro.',
    'Success ! Email settings are updated successfully.' => 'Operazione riuscita. Le impostazioni e-mail sono state aggiornate correttamente.',
    'Success ! Group information updated successfully.' => 'Successo! Informazioni sul gruppo aggiornate con successo.',
    'Success ! Group information saved successfully.' => 'Successo! Informazioni di gruppo salvate correttamente.',
    'Support Group removed successfully.' => 'Gruppo di supporto rimosso correttamente.',
    'Success ! Privilege information saved successfully.' => 'Successo! Informazioni sui privilegi salvate correttamente.',
    'Privilege updated successfully.' => 'Privilegio aggiornato con successo.',
    'Support Privilege removed successfully.' => 'Privilegio di supporto rimosso correttamente.',
    'Success! Reply has been updated successfully.' => 'Successo! La risposta è stata aggiornata correttamente.',
    'Success! Reply has been added successfully.' => 'Successo! La risposta è stata aggiunta correttamente.',
    'Success! Saved Reply has been deleted successfully' => 'Successo! La risposta salvata è stata eliminata correttamente',
    'SwiftMailer configuration updated successfully.' => 'Configurazione SwiftMailer aggiornata correttamente.',
    'Swiftmailer configuration removed successfully.' => 'La configurazione di Swiftmailer è stata rimossa correttamente.',
    'Success ! Team information saved successfully.' => 'Successo! Informazioni sulla squadra salvate correttamente.',
    'Success ! Team information updated successfully.' => 'Successo! Informazioni sulla squadra aggiornate con successo.',
    'Support Team removed successfully.' => 'Il team di supporto è stato rimosso correttamente.',
    'Success! Reply has been added successfully' => 'Successo! La risposta è stata aggiunta correttamente',
    'Success ! Thread updated successfully.' => 'Successo! Discussione aggiornata con successo.',
    'Error ! Reply field can not be blank.' => 'Errore! Il campo di risposta non può essere vuoto.',
    'Success ! Thread removed successfully.' => 'Operazione riuscita. Discussione rimossa correttamente.',
    'Success ! Thread locked successfully' => 'Successo! Discussione bloccata con successo',
    'Success ! Thread unlocked successfully' => 'Successo! Discussione sbloccata con successo',
    'Success ! Thread pinned successfully' => 'Successo! Discussione appuntata correttamente',
    'Error ! Invalid thread.' => 'Errore! Discussione non valida.',
    'Could not create ticket, invalid details.' => 'Impossibile creare il ticket, dettagli non validi.',
    'Success ! Tag updated successfully.' => 'Successo! Tag aggiornato correttamente.',
    'Error ! Customer can not be added as collaborator.' => 'Errore! Il cliente non può essere aggiunto come collaboratore.',
    'Success ! Tag unassigned successfully.' => 'Successo! Tag rimosso con successo.',
    'Success ! Tag added successfully.' => 'Successo! Tag aggiunto correttamente.',
    'Please enter tag name.' => 'Inserisci il nome del tag.',
    'Error ! Invalid tag.' => 'Errore! Tag non valido.',
    'Success ! Type removed successfully.' => 'Operazione riuscita. Tipo rimosso con successo.',
    'Success ! Ticket to label removed successfully.' => 'Successo! Il ticket per l\'etichetta è stato rimosso con successo.',
    'Unable to retrieve support team details' => 'Impossibile recuperare i dettagli del team di supporto',
    'Ticket support group updated successfully' => 'Gruppo di supporto ticket aggiornato correttamente',
    'Unable to retrieve status details' => 'Impossibile recuperare i dettagli dello stato',
    'Insufficient details provided.' => 'Dettagli forniti insufficienti.',
    'Error! Subject field is mandatory' => 'Errore! Il campo delloggetto è obbligatorio',
    'Error! Reply field is mandatory' => 'Errore! Il campo di risposta è obbligatorio',
    'Success ! Ticket has been updated successfully.' => 'Successo! Il ticket è stato aggiornato con successo.',
    'Success ! Label updated successfully.' => 'Successo! Etichetta aggiornata con successo.',
    'Error ! Invalid label id.' => 'Errore! ID etichetta non valido.',
    'Success ! Label removed successfully.' => 'Successo! Etichetta rimossa correttamente.',
    'Success ! Label created successfully.' => 'Successo! Etichetta creata con successo.',
    'Error ! Label name can not be blank.' => 'Errore! Il nome dell\'etichetta non può essere vuoto.',
    'Success ! Ticket moved to trash successfully.' => 'Successo! Il ticket è stato spostato correttamente nel cestino.',
    'Success! Ticket type saved successfully.' => 'Successo! Tipo di ticket salvato con successo.',
    'Success! Ticket type updated successfully.' => 'Operazione riuscita. Tipo di ticket aggiornato correttamente.',
    'Error! Ticket type with same name already exist' => 'Errore! Il tipo di ticket con lo stesso nome esiste già',
    'SAVE' => 'SALVA',
    '# Save' => 'Salva',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'I tag del titolo e le meta descrizioni sono frammenti di codice HTML nellintestazione di una pagina Web. Aiutano i motori di ricerca a comprendere il contenuto di una pagina. Il tag del titolo e la meta descrizione di una pagina sono generalmente mostrati ogni volta che quella pagina appare nei risultati del motore di ricerca',
    'Howdy!' => 'Salve!',
    'New Ticket Request' => 'Nuova richiesta',
    'Ticket Requests' => 'Richieste',
    'Tickets have been updated successfully' => NULL,
    'Please check your mail for password update' => 'Controlla la tua posta per l\'aggiornamento della password',
    'This email address is not registered with us' => 'Questo indirizzo email non è registrato presso di noi',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'Hai già aggiornato la password usando questo link se desideri cambiare di nuovo la password clicca sul link dimentica password qui dalla pagina di accesso',
    'Your password has been successfully updated. Login using updated password' => 'La tua password è stata aggiornata con successo. Accedi usando la password aggiornata',
    'Please try again, The passwords do not match' => 'Riprova, le password non corrispondono',
    'Support Privilege removed successfully' => 'Privilegio di supporto rimosso correttamente',
    'Success! Saved Reply has been deleted successfully.' => 'Successo! La risposta salvata è stata eliminata correttamente.',
    'SwiftMailer configuration created successfully.' => 'Configurazione di SwiftMailer creata correttamente.',
    'No swiftmailer configurations found for mailer id:' => 'Nessuna configurazione di swiftmailer trovata per l\'id mailer',
    'Reply content cannot be left blank.' => 'Il contenuto della risposta non può essere lasciato vuoto.',
    'Reply added to the ticket and forwarded successfully.' => 'Risposta aggiunta al ticket e inoltrata correttamente.',
    'Success ! Thread pinned successfully.' => 'Successo! Discussione appuntata correttamente.',
    'Success ! unpinned removed successfully.' => 'Successo! non accoppiato rimosso correttamente.',
    'Unable to retrieve priority details' => 'Impossibile recuperare i dettagli della priorità',
    'Ticket support team updated successfully' => 'Team di supporto ticket aggiornato correttamente',
    'Ticket assigned to support group ' => 'Ticket assegnato al gruppo di supporto',
    'Mailbox configuration removed successfully.' => 'Configurazione della casella rimossa correttamente.',
    'visit our website' => 'visita il nostro sito web',
    'Cookie Usage Policy' => 'Informativa sull\'uso dei cookie',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => 'AIUTO',
    'Home' => 'Home',
    'Cookie Policy' => 'Gestione dei Cookie',
    'Prev' => 'Precedente',
    'Ticket query message' => 'Messaggio del ticket',
    'Select type' => 'Seleziona il tipo',
    'Search KnowledgeBase' => 'Cerca nella knowledge base',
    'You cant merge an account with itself.' => 'Non puoi unire un account con se stesso.',
    'Edit Profile' => 'Modifica Profilo',
    'Customer Login' => 'Accesso cliente',
    'Contact Us' => 'Contattaci',
    'If you have ever contacted our support previously, your account would have already been created.' => 'Se ci hai già contattati in precedenza l\'account è già stato creato, puoi recuperarlo tramite la funzione di recupero password.',
    'HelpDesk' => 'HelpDesk',
    'Enter search keyword' => 'Inserisci la parola chiave di ricerca',
    'Browse via Folders' => 'Sfoglia tramite cartelle',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Alla ricerca di qualcosa che viene interrogato in generale? Scegli una cartella pertinente dal basso per esplorare le possibili soluzioni',
    'Unable to find an answer?' => 'Impossibile trovare una risposta?',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'Cerchi qualcosa di specifico che risieda nelle domande generali? Sfoglia le varie cartelle e categorie pertinenti e troverai larticolo desiderato.',
    'Popular Articles ' => 'Articoli popolari',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => 'Ecco alcuni degli articoli più popolari, che hanno aiutato il numero di utenti a risolvere le loro domande e domande.',
    'Browse via Categories' => 'Sfoglia le categorie',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Stai cercando qualcosa di specifico? Scegli una categoria pertinente in basso per esplorare le possibili soluzioni',
    'No Categories Found!' => 'Nessuna categoria trovata',
    'Powered by' => 'Offerto da',
    'Forgot Password' => 'Ha dimenticato la password',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'Inserisci il tuo indirizzo email, ti invieremo una email con le istruzioni per aggiornare le tue credenziali di accesso.',
    'Send Mail' => 'Invia una email',
    'Status:' => 'Stato:',
    'Sign In to %websitename%' => 'Accedere a %websitename%',
    'Enter your name' => 'Inserisci il tuo nome',
    'Enter your email' => 'Inserisci il tuo indirizzo email',
    'Learn more about %deliveryStatus%.' => 'Impara di più riguardo %deliveryStatus%.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'Per saperne di più su come funziona la nostra politica sulla privacy, per favore %websiteLink%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Alcune delle nostre pagine del sito utilizzano %cookies% e altre tecnologie di tracciamento. Un %cookie% è un piccolo file di testo che può essere utilizzato, ad esempio, per raccogliere informazioni sull\'attività del sito. Alcuni cookie e altre tecnologie potrebbero servire a richiamare informazioni personali precedentemente indicate da un utente del sito. È possibile bloccare i cookie o eliminare i cookie esistenti, modificando limpostazione appropriata sul proprio browser. Consulta il menu %help% del tuo browser per sapere come fare. Se blocchi o elimini %cookie%, potresti scoprire che lutilità del nostro sito è compromessa.',
    'This field contain maximum 40 charectures.' => 'Questo campo contiene un massimo di 40 lezioni.',
    'This field contain maximum 50 charectures.' => 'Questo campo contiene un massimo di 50 lezioni.',
    'Time' => 'Orario',
    'Links' => 'Links',
    'Broadcast Message' => 'Messaggio broadcast',
    'Wide Logo' => 'Logo largo',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Carica un\'immagine (200px x 48px) in </br> formato PNG o JPG',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Verrà mostrato come logo nella knowledge base e nell\'helpdesk',
    'Website Status' => 'Stato del sito Web',
    'Enable front end website and knowledgebase for customer(s)' => 'Abilita sito Web front-end e knowledge base per i clienti',
    'Brand Color' => 'Colore del marchio',
    'Page Background Color' => 'Colore sfondo pagina',
    'Header Background Color' => 'Colore di sfondo dell\'intestazione',
    'Banner Background Color' => 'Colore sfondo banner',
    'Page Link Color' => 'Colore link pagina',
    'Page Link Hover Color' => 'Colore al passaggio del mouse sul collegamento della pagina',
    'Article Text Color' => 'Colore testo articolo',
    'Tag Line' => 'Tag Line',
    'Hi! how can we help?' => 'Ciao! Come possiamo aiutare?',
    'Layout' => 'Disposizione',
    'Ticket Create Option' => 'Opzione di creazione ticket',
    'Login Required To Create Tickets' => 'Accesso richiesto per creare ticket',
    'Remove Customer Login/Signin Button' => 'Rimuovi pulsante Login / accesso cliente',
    'Disable Customer Login' => 'Disabilita accesso cliente',
    'Meta Description (Recommended)' => 'Meta Description (consigliato)',
    'Meta Keywords (Recommended)' => 'Meta Keywords (consigliate)',
    'Header Link' => 'Link intestazione',
    'URL (with http":/"/ or https":/"/)' => 'URL (con http": "// o https": "//)',
    'Footer Link' => 'Link piè di pagina',
    'Custom CSS (Optional)' => 'CSS personalizzato (opzionale)',
    'It will be add to the frontend knowledgebase only' => 'Verrà aggiunto solo alla knowledge base del frontend',
    'Custom Javascript (Optional)' => 'Javascript personalizzato (opzionale)',
    'Broadcast message content to show on helpdesk' => 'Trasmetti il ​​contenuto del messaggio da mostrare sull\'helpdesk',
    'From' => 'A partire dal',
    'Time duration between which message will be displayed(if applicable)' => 'Durata tra cui verrà visualizzato il messaggio (se applicabile)',
    'Broadcasting Status' => 'Stato di trasmissione',
    'Broadcasting is Active' => 'La trasmissione è attiva',
    'Choose a default company timezone' => 'Scegli il fuso orario di unazienda predefinita',
    'Date Time Format' => 'Formato data e ora',
    'Choose a format to convert date to specified date time format' => 'Scegli un formato per convertire la data nel formato di data e ora specificato',
    'An empty file is not allowed.' => 'Un file vuoto non è consentito.',
    'File size must not be greater than 200KB !!' => 'La dimensione del file non deve essere superiore a 200 KB !!',
    'comma "," separated' => 'separato da virgola',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Carica un file di immagine valido (sono consentiti solo JPEG, JPG, PNG) !!',
    'Provide a valid url(with protocol)' => 'Fornisci un URL valido (con protocollo)',
    'View all articles' => 'Visualizza tutti gli articoli',
    'View all categories' => 'Visualizza tutte le categorie',
    'Low' => 'Bassa',
    'Medium' => 'Media',
    'High' => 'Alta',
    'Urgent' => 'Urgente',
    'Reset Password' => 'Resetta la password',
    'Enter your new password below to update your login credentials' => 'Inserisci la tua nuova password qui sotto per aggiornare le tue credenziali di accesso',
    'Save Password' => 'Salva la password',
    'Rate Support' => 'Valuta il supporto',
    'I am very Sad' => 'Sono molto triste',
    'I am Sad' => 'Sono triste',
    'I am Neutral' => 'Sono neutrale',
    'I am Happy' => 'Sono felice',
    'I am Very Happy' => 'Sono molto felice',
    'Kudos' => 'Grado di soddisfazione Kudos',
    'Very Sad' => 'Molto triste',
    'Sad' => 'Triste',
    'Neutral' => 'Neutrale',
    'Happy' => 'Felice',
    'Very Happy' => 'Molto felice',
    'Star(s)' => 'Stelle',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Attenzione! Errrore Swiftmailer durante l\'invio delle e-mail | Warning ! Swiftmailer not working. An error has occurred while sending emails!',
    'Success ! Project cache cleared successfully.' => 'Successo ! La cache del progetto è stata cancellata correttamente.',
    'clear cache' => 'svuota la cache',
    'Last Updated' => 'Ultimo aggiornamento',
    'Error! Something went wrong.' => 'Errore! Qualcosa è andato storto.',
    'We were not able to find the page you are looking for.' => 'Non siamo riusciti a trovare la pagina che stai cercando.',
    'Page not found' => 'pagina non trovata',
    'Forbidden' => 'Proibita',
    'You don’t have the necessary permissions to access this Web page :(' => 'Non disponi delle autorizzazioni necessarie per accedere a questa pagina Web :(',
    'Internal server error' => 'Errore interno del server',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Il nostro sistema ha funzionato per un po\', ma la parte buona è che non durerà a lungo',
    'Unknown Error' => 'Errore sconosciuto',
    'We are quite confused about how did you land here:/' => 'Siamo piuttosto confusi su come sei atterrato qui :/',
    'Few of the links which may help you to get back on the track -' => 'Alcuni dei link che possono aiutarti a rimetterti in carreggiata -',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This value should be a valid expression.' => 'This value should be a valid expression.',
    'This value is not a valid CSS color.' => 'This value is not a valid CSS color.',
    'This value is not a valid CIDR notation.' => 'This value is not a valid CIDR notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'The value of the netmask should be between {{ min }} and {{ max }}.',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
    'filter_searchword' => 'Searchword...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Signed in as',
    'Your Profile' => 'Your Profile',
    'Create Ticket' => 'Create Ticket',
    'Create Agent' => 'Create Agent',
    'Create Customer' => 'Create Customer',
    'Sign Out' => 'Sign Out',
    'Reports' => 'Reports',
    'Rating' => 'Rating',
    'Kudos Rating' => 'Kudos Rating',
    'Remove profile picture' => 'Remove profile picture',
    'Success ! Profile updated successfully.' => 'Success ! Profile updated successfully.',
    'Howdy' => 'Howdy',
    'Form successfully updated.' => 'Form successfully updated.',
    'NEW FORM' => 'NEW FORM',
    'Text Box' => 'Text Box',
    'Text Area' => 'Text Area',
    'Select' => 'Select',
    'Radio' => 'Radio',
    'Checkbox' => 'Checkbox',
    'Date' => 'Date',
    'Both Date and Time' => 'Both Date and Time',
    'Choose a status' => 'Choose a status',
    'Choose a group' => 'Choose a group',
    'Choose your default timeformat' => 'Choose your default timeformat',
    'Can manage Group\'s Saved Reply' => 'Can manage Group\'s Saved Reply',
    'Can manage agent activity' => 'Can manage agent activity',
    'Can manage marketing announcement' => 'Can manage marketing announcement',
    'User Forgot Password' => 'User Forgot Password',
    'Agent Deleted' => 'Agent Deleted',
    'Agent Update' => 'Agent Update',
    'Customer Update' => 'Customer Update',
    'Customer Deleted' => 'Customer Deleted',
    'Agent Updated' => 'Agent Updated',
    'Agent Reply' => 'Agent Reply',
    'Collaborator Added' => 'Collaborator Added',
    'Collaborator Reply' => 'Collaborator Reply',
    'Customer Reply' => 'Customer Reply',
    'Ticket Deleted' => 'Ticket Deleted',
    'Group Updated' => 'Group Updated',
    'Note Added' => 'Note Added',
    'Priority Updated' => 'Priority Updated',
    'Status Updated' => 'Status Updated',
    'Team Updated' => 'Team Updated',
    'Thread Updated' => 'Thread Updated',
    'Type Updated' => 'Type Updated',
    'From Email' => 'From Email',
    'To Email' => 'To Email',
    'Is Equal To' => 'Is Equal To',
    'Is Not Equal To' => 'Is Not Equal To',
    'Contains' => 'Contains',
    'Does Not Contain' => 'Does Not Contain',
    'Starts With' => 'Starts With',
    'Ends With' => 'Ends With',
    'Before On' => 'Before On',
    'After On' => 'After On',
    'Mail To User' => 'Mail To User',
    'Transfer Tickets' => 'Transfer Tickets',
    'Mail To Customer' => 'Mail To Customer',
    'Permanently delete from Inbox' => 'Permanently delete from Inbox',
    'Agent Activity' => 'Agent Activity',
    'Report From' => 'Report From',
    'Search Agent' => 'Search Agent',
    'Agent Last Reply' => 'Agent Last Reply',
    'View analytics and insights to serve a better experience for your customers' => 'Analytics and insight regarding your workflow',
    'Marketing Announcement' => 'Marketing Announcement',
    'Advertisment' => 'Advertisment',
    'Announcement' => 'Announcement',
    'New Announcement' => 'New Announcement',
    'Add Announcement' => 'Add Announcement',
    'Edit Announcement' => 'Edit Announcement',
    'Promo Text' => 'Promo Text',
    'Promo Tag' => 'Promo Tag',
    'Choose a promo tag' => 'Choose a promo tag',
    'Tag-Color' => 'Tag-Color',
    'Tag background color' => 'Tag background color',
    'Link Text' => 'Link Text',
    'Link URL' => 'Link URL',
    'Apps' => 'Apps',
    'Integrate apps as per your needs to get things done faster than ever' => 'Install new custom apps to boost your productivity.',
    'Explore Apps' => 'Explore Apps',
    'Form Builder' => 'Form Builder',
    'Knowledgebase' => 'Knowledgebase',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'Help your customers help themselves! Save time on support by building your knowledge base.',
    'Articles' => 'Articles',
    'Categories' => 'Categories',
    'Folders' => 'Folders',
    'FOLDERS' => 'FOLDERS',
    'Productivity' => 'Productivity',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Create automation rules to speed up your workflow.',
    'Prepared Responses' => 'Prepared Responses',
    'Saved Replies' => 'Saved Replies',
    'Edit Saved Reply' => 'Edit Saved Reply',
    'Ticket Types' => 'Ticket Types',
    'Workflows' => 'Workflows',
    'Settings' => 'Settings',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Manage your Brand Identity, Company Information and other details at a glance',
    'Branding' => 'Branding',
    'Custom Fields' => 'Custom Fields',
    'Email Settings' => 'Email Settings',
    'Email Templates' => 'Email Templates',
    'Mailbox' => 'Mailbox',
    'Spam Settings' => 'Spam Settings',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Tags',
    'Users' => 'Users',
    'Control your Groups, Teams, Agents and Customers' => 'Manage your Groups, Teams, Agents and Customers',
    'Agents' => 'Agents',
    'Customers' => 'Customers',
    'Groups' => 'Groups',
    'Privileges' => 'Privileges',
    'Teams' => 'Teams',
    'Applications' => 'Applications',
    'ECommerce Order Syncronization' => 'eCommerce Order Syncronization',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Import eCommerce order details to your support tickets from different available platforms',
    'Search' => 'Search',
    'Sort By' => 'Sort By',
    'Sort By:' => 'Sort By:',
    'Status' => 'Status',
    'Created At' => 'Created At',
    'Name' => 'Name',
    'All' => 'All',
    'Published' => 'Published',
    'Draft' => 'Draft',
    'New Folder' => 'New Folder',
    'Create Knowledgebase Folder' => 'Create Knowledgebase Folder',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'You don\'t have any folders yet! Create your first folder and start adding articles.',
    'Clear Filters' => 'Clear Filters',
    'Back' => 'Back',
    'Open' => 'Open',
    'Pending' => 'Pending',
    'Answered' => 'Answered',
    'Resolved' => 'Resolved',
    'Closed' => 'Closed',
    'Spam' => 'Spam',
    'New' => 'New',
    'UnAssigned' => 'Unassigned',
    'UnAnswered' => 'Unanswered',
    'My Tickets' => 'My Tickets',
    'Starred' => 'Starred',
    'Trashed' => 'Trashed',
    'New Label' => 'New Label',
    'Tickets' => 'Tickets',
    'Ticket Id' => 'Ticket Id',
    'Last Replied' => 'Last Replied',
    'Assign To' => 'Assign To',
    'After Reply' => 'After Reply',
    'Customer Email' => 'Customer Email',
    'Customer Name' => 'Customer Name',
    'Assets Visibility' => 'Assets Visibility',
    'Channel/Source' => 'Channel/Source',
    'Channel' => 'Channel',
    'Website' => 'Website',
    'Timestamp' => 'Timestamp',
    'TimeStamp' => 'TimeStamp',
    'Team' => 'Team',
    'Type' => 'Type',
    'Replies' => 'Replies',
    'Agent' => 'Agent',
    'ID' => 'ID',
    'Subject' => 'Subject',
    'Last Reply' => 'Last Reply',
    'Filter View' => 'Filter View',
    'Please select CAPTCHA' => 'Please select CAPTCHA',
    'Warning ! Please select correct CAPTCHA !' => 'CAPTCHA Failed, please try again',
    'reCAPTCHA Setting' => 'reCAPTCHA Setting',
    'reCAPTCHA Site Key' => 'reCAPTCHA Site Key',
    'reCAPTCHA Secret key' => 'reCAPTCHA Secret key',
    'reCAPTCHA Status' => 'reCAPTCHA Status',
    'reCAPTCHA is Active' => 'reCAPTCHA is Active',
    'Save set of filters as a preset to stay more productive' => 'Save filters as preset',
    'Saved Filters' => 'Saved Filters',
    'No saved filter created' => 'No saved filter created',
    'Customer' => 'Customer',
    'Priority' => 'Priority',
    'Tag' => 'Tag',
    'Source' => 'Source',
    'Before' => 'Before',
    'After' => 'After',
    'Replies less than' => 'Replies less than',
    'Replies more than' => 'Replies more than',
    'Clear All' => 'Clear All',
    'Account' => 'Account',
    'Profile' => 'Profile',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format',
    'First Name' => 'First Name',
    'Last Name' => 'Last Name',
    'Email' => 'Email',
    'Contact Number' => 'Contact Number',
    'Timezone' => 'Timezone',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Asmara' => 'Africa/Asmara',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Dakar' => 'Africa/Dakar',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Douala' => 'Africa/Douala',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Harare' => 'Africa/Harare',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Juba' => 'Africa/Juba',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Kigali' => 'Africa/Kigali',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lagos' => 'Africa/Lagos',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'America/Adak' => 'America/Adak',
    'America/Anchorage' => 'America/Anchorage',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Araguaina' => 'America/Araguaina',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Salta' => 'America/Argentina/Salta',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/San_Luis' => 'America/Argentina/San_Luis',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/Asuncion' => 'America/Asuncion',
    'America/Atikokan' => 'America/Atikokan',
    'America/Bahia' => 'America/Bahia',
    'America/Bahia_Banderas' => 'America/Bahia_Banderas',
    'America/Barbados' => 'America/Barbados',
    'America/Belem' => 'America/Belem',
    'America/Belize' => 'America/Belize',
    'America/Blanc-Sablon' => 'America/Blanc-Sablon',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Bogota' => 'America/Bogota',
    'America/Boise' => 'America/Boise',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cancun' => 'America/Cancun',
    'America/Caracas' => 'America/Caracas',
    'America/Cayenne' => 'America/Cayenne',
    'America/Cayman' => 'America/Cayman',
    'America/Chicago' => 'America/Chicago',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Creston' => 'America/Creston',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Curacao' => 'America/Curacao',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Dawson' => 'America/Dawson',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Denver' => 'America/Denver',
    'America/Detroit' => 'America/Detroit',
    'America/Dominica' => 'America/Dominica',
    'America/Edmonton' => 'America/Edmonton',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Fort_Nelson' => 'America/Fort_Nelson',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Godthab' => 'America/Godthab',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Guayaquil' => 'America/Guayaquil',
    'America/Guyana' => 'America/Guyana',
    'America/Halifax' => 'America/Halifax',
    'America/Havana' => 'America/Havana',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Petersburg' => 'America/Indiana/Petersburg',
    'America/Indiana/Tell_City' => 'America/Indiana/Tell_City',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Indiana/Vincennes' => 'America/Indiana/Vincennes',
    'America/Indiana/Winamac' => 'America/Indiana/Winamac',
    'America/Inuvik' => 'America/Inuvik',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Jamaica' => 'America/Jamaica',
    'America/Juneau' => 'America/Juneau',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Kralendijk' => 'America/Kralendijk',
    'America/La_Paz' => 'America/La_Paz',
    'America/Lima' => 'America/Lima',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Lower_Princes' => 'America/Lower_Princes',
    'America/Maceio' => 'America/Maceio',
    'America/Managua' => 'America/Managua',
    'America/Manaus' => 'America/Manaus',
    'America/Marigot' => 'America/Marigot',
    'America/Martinique' => 'America/Martinique',
    'America/Matamoros' => 'America/Matamoros',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Menominee' => 'America/Menominee',
    'America/Merida' => 'America/Merida',
    'America/Metlakatla' => 'America/Metlakatla',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Miquelon' => 'America/Miquelon',
    'America/Moncton' => 'America/Moncton',
    'America/Monterrey' => 'America/Monterrey',
    'America/Montevideo' => 'America/Montevideo',
    'America/Montserrat' => 'America/Montserrat',
    'America/Nassau' => 'America/Nassau',
    'America/New_York' => 'America/New_York',
    'America/Nipigon' => 'America/Nipigon',
    'America/Nome' => 'America/Nome',
    'America/Noronha' => 'America/Noronha',
    'America/North_Dakota/Beulah' => 'America/North_Dakota/Beulah',
    'America/North_Dakota' => 'America/North_Dakota',
    'America/Ojinaga' => 'America/Ojinaga',
    'America/Panama' => 'America/Panama',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Phoenix' => 'America/Phoenix',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/Punta_Arenas' => 'America/Punta_Arenas',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Recife' => 'America/Recife',
    'America/Regina' => 'America/Regina',
    'America/Resolute' => 'America/Resolute',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santarem' => 'America/Santarem',
    'America/Santiago' => 'America/Santiago',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Sitka' => 'America/Sitka',
    'America/St_Barthelemy' => 'America/St_Barthelemy',
    'America/St_Johns' => 'America/St_Johns',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Thule' => 'America/Thule',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Tijuana' => 'America/Tijuana',
    'America/Toronto' => 'America/Toronto',
    'America/Tortola' => 'America/Tortola',
    'America/Vancouver' => 'America/Vancouver',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Yakutat' => 'America/Yakutat',
    'America/Yellowknife' => 'America/Yellowknife',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Macquarie' => 'Antarctica/Macquarie',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Troll' => 'Antarctica/Troll',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Arctic/Longyearbyen' => 'Arctic/Longyearbyen',
    'Asia/Aden' => 'Asia/Aden',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Atyrau' => 'Asia/Atyrau',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Barnaul' => 'Asia/Barnaul',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Chita' => 'Asia/Chita',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Famagusta' => 'Asia/Famagusta',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Hebron' => 'Asia/Hebron',
    'Asia/Ho_Chi_Minh' => 'Asia/Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Kathmandu' => 'Asia/Kathmandu',
    'Asia/Khandyga' => 'Asia/Khandyga',
    'Asia/Kolkata' => 'Asia/Kolkata',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Novokuznetsk' => 'Asia/Novokuznetsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Qostanay' => 'Asia/Qostanay',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Srednekolymsk' => 'Asia/Srednekolymsk',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Tomsk' => 'Asia/Tomsk',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Ust-Nera' => 'Asia/Ust-Nera',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Yangon' => 'Asia/Yangon',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Atlantic/Faroe' => 'Atlantic/Faroe',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Eucla' => 'Australia/Eucla',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Lord_Howe' => 'Australia/Lord_Howe',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Sydney' => 'Australia/Sydney',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Astrakhan' => 'Europe/Astrakhan',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Bratislava' => 'Europe/Bratislava',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Budapest' => 'Europe/Budapest',
    'Europe/Busingen' => 'Europe/Busingen',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Europe/Dublin' => 'Europe/Dublin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Guernsey' => 'Europe/Guernsey',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Isle_of_Man' => 'Europe/Isle_of_Man',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Jersey' => 'Europe/Jersey',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Kirov' => 'Europe/Kirov',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Europe/Ljubljana' => 'Europe/Ljubljana',
    'Europe/London' => 'Europe/London',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Madrid' => 'Europe/Madrid',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Mariehamn' => 'Europe/Mariehamn',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Podgorica' => 'Europe/Podgorica',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Samara' => 'Europe/Samara',
    'Europe/San_Marino' => 'Europe/San_Marino',
    'Europe/Sarajevo' => 'Europe/Sarajevo',
    'Europe/Saratov' => 'Europe/Saratov',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'Europe/Skopje' => 'Europe/Skopje',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Ulyanovsk' => 'Europe/Ulyanovsk',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vatican' => 'Europe/Vatican',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Volgograd' => 'Europe/Volgograd',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Zagreb' => 'Europe/Zagreb',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Zurich' => 'Europe/Zurich',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Indian/Chagos' => 'Indian/Chagos',
    'Indian/Christmas' => 'Indian/Christmas',
    'Indian/Cocos' => 'Indian/Cocos',
    'Indian/Comoro' => 'Indian/Comoro',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Indian/Mahe' => 'Indian/Mahe',
    'Indian/Maldives' => 'Indian/Maldives',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Indian/Reunion' => 'Indian/Reunion',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Bougainville' => 'Pacific/Bougainville',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Chuuk' => 'Pacific/Chuuk',
    'Pacific/Easter' => 'Pacific/Easter',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pohnpei' => 'Pacific/Pohnpei',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'UTC' => 'UTC',
    'Time Format' => 'Time Format',
    'Choose your default timezone' => 'Choose your default timezone',
    'Signature' => 'Signature',
    'User signature will be append at the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Password' => 'Password',
    'Password will remain same if you are not entering something in this field' => 'Password not changed!',
    'Confirm Password' => 'Confirm Password',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'Password must be at least 8 characters, two letters (not case-sensitive), one number, and one special character (space is not allowed).',
    'Save Changes' => 'Save Changes',
    'SAVE CHANGES' => 'SAVE CHANGES',
    'CREATE TICKET' => 'CREATE TICKET',
    'Customer full name' => 'Customer full name',
    'Customer email address' => 'Customer email address',
    'Select Type' => 'Select Type',
    'Support' => 'Support',
    'Choose ticket type' => 'Choose ticket type',
    'Ticket subject' => 'Ticket subject',
    'Message' => 'Message',
    'Query Message' => 'Query Message',
    'Add Attachment' => 'Add Attachment',
    'This field is mandatory' => 'This field is mandatory',
    'General' => 'General',
    'Designation' => 'Designation',
    'Contant Number' => 'Content Number',
    'User signature will be append in the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Account Status' => 'Account Status',
    'Account is Active' => 'Account is Active',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Add user to group to view tickets regardless of owner.',
    'Default' => 'Default',
    'Select All' => 'Select All',
    'Remove All' => 'Remove All',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Add user to team to view tickets regardless of owner.',
    'No Team added !' => 'No Team added!',
    'Permission' => 'Permission',
    'Role' => 'Role',
    'Administrator' => 'Administrator',
    'Select agent role' => 'Select agent role',
    'Add Customer' => 'Add Customer',
    'Action' => 'Action',
    'Account Owner' => 'Account Owner',
    'Active' => 'Active',
    'Edit' => 'Edit',
    'Delete' => 'Delete',
    'Disabled' => 'Disabled',
    'New Group' => 'New Group',
    'Default Privileges' => 'Default Privileges',
    'New Privileges' => 'New Privileges',
    'NEW PRIVILEGE' => 'NEW PRIVILEGE',
    'New Privilege' => 'New Privilege',
    'New Team' => 'New Team',
    'No Record Found' => 'No Record Found',
    'Order Synchronization' => 'Order Synchronization',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Easily integrate different eCommerce platforms with your helpdesk to show order details within support tickets.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'No channels have been added.',
    'Add BigCommerce Store' => 'Add BigCommerce Store',
    'ADD BIGCOMMERCE STORE' => 'ADD BIGCOMMERCE STORE',
    'Mangento' => 'Mangento',
    'Add Magento Store' => 'Add Magento Store',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'Add OpenCart Store',
    'ADD OPENCART STORE' => 'ADD OPENCART STORE',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Add Shopify Store',
    'ADD SHOPIFY STORE' => 'ADD SHOPIFY STORE',
    'Integrate a new BigCommerce store' => 'Integrate a new BigCommerce store',
    'Your BigCommerce Store Name' => 'Your BigCommerce Store Name',
    'Your BigCommerce Store Hash' => 'Your BigCommerce Store Hash',
    'Your BigCommerce Api Token' => 'Your BigCommerce Api Token',
    'Your BigCommerce Api Client ID' => 'Your BigCommerce Api Client ID',
    'Enable Channel' => 'Enable Channel',
    'Add Store' => 'Add Store',
    'ADD STORE' => 'ADD STORE',
    'Integrate a new Magento store' => 'Integrate a new Magento store',
    'Your Magento Api Username' => 'Your Magento Api Username',
    'Your Magento Api Password' => 'Your Magento Api Password',
    'Integrate a new OpenCart store' => 'Integrate a new OpenCart store',
    'Your OpenCart Api Key' => 'Your OpenCart Api Key',
    'Your Shopify Store Name' => 'Your Shopify Store Name',
    'Your Shopify Api Key' => 'Your Shopify Api Key',
    'Your Shopify Api Password' => 'Your Shopify Api Password',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Easily embed custom forms for creating helpdesk tickets.',
    'Form-Builder' => 'Form-Builder',
    'Add Formbuilder' => 'Add Formbuilder',
    'ADD FORMBUILDER' => 'ADD FORMBUILDER',
    'No FormBuilder have been added.' => 'No FormBuilder was added.',
    'Create a New Custom Form Below' => 'Create a New Custom Form Below',
    'Form Name' => 'Form Name',
    'It will be shown in the list of created forms' => 'Displayed in the list of created forms',
    'MANDATORY FIELDS' => 'MANDATORY FIELDS',
    'These fields will be visible in form and cant be edited' => 'These fields will be visible in this form and can\'t be edited',
    'Reply' => 'Reply',
    'OPTIONAL FIELDS' => 'OPTIONAL FIELDS',
    'Select These Fields to Add in your Form' => 'Select fields to add',
    'GDPR' => 'GDPR',
    'Order' => 'Order',
    'Categorybuilder' => 'Categorybuilder',
    'File' => 'File',
    'Add Form' => 'Add Form',
    'ADD FORM' => 'ADD FORM',
    'UPDATE FORM' => 'UPDATE FORM',
    'Update Form' => 'Update Form',
    'Embed' => 'Embed',
    'EMBED' => 'EMBED',
    'EMBED FORMBUILDER' => 'EMBED FORMBUILDER',
    'Embed Formbuilder' => 'Embed Formbuilder',
    'Visit' => 'Visit',
    'VISIT' => 'VISIT',
    'Code' => 'Code',
    'Total Ticket(s)' => 'Total Ticket(s)',
    'Ticket Count' => 'Ticket Count',
    'SwiftMailer Configurations' => 'SwiftMailer Configurations',
    'No swiftmailer configurations found' => 'No SwiftMailer configurations found',
    'CREATE CONFIGURATION' => 'CREATE CONFIGURATION',
    'Add configuration' => 'Add configuration',
    'Update configuration' => 'Update configuration',
    'Mailer ID' => 'Mailer ID',
    'Mailer ID - Leave blank to automatically create id' => 'Mailer ID - Leave blank to automatically create id',
    'Transport Type' => 'Transport Type',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Enable Delivery',
    'Server' => 'Server',
    'Port' => 'Port',
    'Encryption Mode' => 'Encryption Mode',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'None',
    'Authentication Mode' => 'Authentication Mode',
    'login' => 'login',
    'Plain' => 'Plain',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Sender Address',
    'Delivery Address' => 'Delivery Address',
    'Block Spam' => 'Block Spam',
    'Black list' => 'Black list',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Comma separated values (Eg. support@example.com, @example.com, 68.98.31.226)',
    'White list' => 'White list',
    'Mailbox Settings' => 'Mailbox Settings',
    'No mailbox configurations found' => 'No mailbox configurations found',
    'NEW MAILBOX' => 'NEW MAILBOX',
    'New Mailbox' => 'New Mailbox',
    'Update Mailbox' => 'Update Mailbox',
    'Add Mailbox' => 'Add Mailbox',
    'Mailbox ID - Leave blank to automatically create id' => 'Mailbox ID - Leave blank to automatically create id',
    'Mailbox Name' => 'Mailbox Name',
    'Enable Mailbox' => 'Enable Mailbox',
    'Incoming Mail (IMAP) Server' => 'Incoming Mail (IMAP) Server',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Configure your imap settings in order to fetch new mail from your inbox.',
    'Transport' => 'Transport',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Host',
    'IMAP Host' => 'IMAP Host',
    'Email address' => 'Email address',
    'Associated Password' => 'Associated Password',
    'Outgoing Mail (SMTP) Server' => 'Outgoing Mail (SMTP) Server',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Select the SwiftMailer config to use for sending emails through your account.',
    'Swift Mailer ID' => 'Swift Mailer ID',
    'None Selected' => 'None Selected',
    'Create Mailbox' => 'Create Mailbox',
    'CREATE MAILBOX' => 'CREATE MAILBOX',
    'New Template' => 'New Template',
    'NEW TEMPLATE' => 'NEW TEMPLATE',
    'Customer Forgot Password' => 'Customer Forgot Password',
    'Customer Account Created' => 'Customer Account Created',
    'Ticket generated success mail to customer' => 'Ticket successfully generated and sent to customer',
    'Customer Reply To The Agent' => 'Customer reply',
    'Ticket Assign' => 'Ticket Assign',
    'Agent Forgot Password' => 'Agent Forgot Password',
    'Agent Account Created' => 'Agent Account Created',
    'Ticket generated by customer' => 'Ticket generated by customer',
    'Agent Reply To The Customers ticket' => 'Agent reply',
    'Email template name' => 'Email template name',
    'Email template subject' => 'Email template subject',
    'Template For' => 'Template For',
    'Nothing Selected' => 'Nothing Selected',
    'email template will be used for work related with selected option' => 'email template will be used for selected option',
    'Email template body' => 'Email template body',
    'Body' => 'Body',
    'placeholders' => 'placeholders',
    'Ticket Subject' => 'Ticket Subject',
    'Ticket Message' => 'Ticket Message',
    'Ticket Attachments' => 'Ticket Attachments',
    'Ticket Tags' => 'Ticket Tags',
    'Ticket Source' => 'Ticket Source',
    'Ticket Status' => 'Ticket Status',
    'Ticket Priority' => 'Ticket Priority',
    'Ticket Group' => 'Ticket Group',
    'Ticket Team' => 'Ticket Team',
    'Ticket Thread Message' => 'Ticket Thread Message',
    'Ticket Customer Name' => 'Ticket Customer Name',
    'Ticket Customer Email' => 'Ticket Customer Email',
    'Ticket Agent Name' => 'Ticket Agent Name',
    'Ticket Agent Email' => 'Ticket Agent Email',
    'Ticket Agent Link' => 'Ticket Agent Link',
    'Ticket Customer Link' => 'Ticket Customer Link',
    'Last Collaborator Name' => 'Last Collaborator Name',
    'Last Collaborator Email' => 'Last Collaborator Email',
    'Agent/ Customer Name' => 'Agent/ Customer Name',
    'Account Validation Link' => 'Account Validation Link',
    'Password Forgot Link' => 'Password Forgot Link',
    'Company Name' => 'Company Name',
    'Company Logo' => 'Company Logo',
    'Company URL' => 'Company URL',
    'Swiftmailer id (Select from drop down)' => 'Swiftmailer id (Select from drop down)',
    'PROCEED' => 'PROCEED',
    'Proceed' => 'Proceed',
    'Theme Color' => 'Theme Color',
    'Customer Created' => 'Customer Created',
    'Agent Created' => 'Agent Created',
    'Ticket Created' => 'Ticket Created',
    'Agent Replied on Ticket' => 'Agent replied to ticket',
    'Customer Replied on Ticket' => 'Customer replied to ticket',
    'Workflow Status' => 'Workflow status',
    'Workflow is Active' => 'Workflow is active',
    'Events' => 'Events',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'An event automatically triggers to check conditions and perform a set of pre-defined actions',
    'Select an Event' => 'Select an Event',
    'Add More' => 'Add More',
    'Conditions' => 'Conditions',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Conditions are sets of rules which check for specific scenarios.',
    'Subject or Description' => 'Subject or description',
    'Actions' => 'Actions',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Actions help you automate tickets',
    'Select an Action' => 'Select an action',
    'Add Note' => 'Add note',
    'Mail to agent' => 'Mail to agent',
    'Mail to customer' => 'Mail to customer',
    'Mail to group' => 'Mail to group',
    'Mail to last collaborator' => 'Mail to last collaborator',
    'Mail to team' => 'Mail to team',
    'Mark Spam' => 'Mark spam',
    'Assign to agent' => 'Assign to agent',
    'Assign to group' => 'Assign to group',
    'Set Priority As' => 'Set Priority As',
    'Set Status As' => 'Set Status As',
    'Set Tag As' => 'Set Tag As',
    'Set Label As' => 'Set Label As',
    'Assign to team' => 'Assign to team',
    'Set Type As' => 'Set Type As',
    'Add Workflow' => 'Add Workflow',
    'ADD WORKFLOW' => 'ADD WORKFLOW',
    'Ticket Type code' => 'Ticket Type code',
    'Ticket Type description' => 'Ticket Type description',
    'Type Status' => 'Type Status',
    'Type is Active' => 'Type is Active',
    'Add Save Reply' => 'Add Save Reply',
    'Saved reply name' => 'Saved reply name',
    'Share saved reply with user(s) in these group(s)' => 'Share saved reply with user(s) in these group(s)',
    'Share saved reply with user(s) in these teams(s)' => 'Share saved reply with user(s) in these teams(s)',
    'Saved reply Body' => 'Saved reply body',
    'New Prepared Response' => 'New Prepared Response',
    'Prepared Response Status' => 'Prepared Response Status',
    'Prepared Response is Active' => 'Prepared Response is Active',
    'Share prepared response with user(s) in these group(s)' => 'Share prepared response with user(s) in these group(s)',
    'Share prepared response with user(s) in these teams(s)' => 'Share prepared response with user(s) in these teams(s)',
    'ADD PREPARED RESPONSE' => 'ADD PREPARED RESPONSE',
    'Add Prepared Response' => 'Add Prepared Response',
    'Folder Name is shown upfront at Knowledge Base' => 'The folder name to show in the knowledge base',
    'A small text about the folder helps user to navigate more easily' => 'A bit more info about this folder',
    'Publish' => 'Publish',
    'Choose appropriate status' => 'Choose appropriate status',
    'Folder Image' => 'Folder Image',
    'An image is worth a thousands words and makes folder more accessible' => 'Help users identify the proper folder with a recognizable image.',
    'Add Category' => 'Add Category',
    'Category Name is shown upfront at Knowledge Base' => 'The category name to show in the knowledge base',
    'A small text about the category helps user to navigate more easily' => 'A bit more info about this category',
    'Using Category Order, you can decide which category should display first' => 'Using Category Order, you can decide which category should display first',
    'Sorting' => 'Sorting',
    'Ascending Order (A-Z)' => 'Ascending Order (A-Z)',
    'Descending Order (Z-A)' => 'Descending Order (Z-A)',
    'Based on Popularity' => 'Based on Popularity',
    'Article of this category will display according to selected option' => 'Articles in this category will display depending on selected option',
    'Article' => 'Article',
    'Title' => 'Title',
    'View' => 'View',
    'Make as Starred' => 'Mark as Starred',
    'Yes' => 'Yes',
    'No' => 'No',
    'Stared' => 'Stared',
    'Revisions' => 'Revisions',
    'Related Articles' => 'Related Articles',
    'Delete Article' => 'Delete Article',
    'Content' => 'Content',
    'Slug' => 'Slug',
    'Slug is the url identity of this article.' => 'The URL for this article',
    'Meta Title' => 'Meta Title',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. The title tag and meta description are usually shown in search engine results for the page.',
    'Meta Keywords' => 'Meta Keywords',
    'Meta Description' => 'Meta Description',
    'Description' => 'Description',
    'Team Status' => 'Team Status',
    'Team is Active' => 'Team is Active',
    'Edit Privilege' => 'Edit Privilege',
    'Can create ticket' => 'Can create ticket',
    'Can edit ticket' => 'Can edit ticket',
    'Can delete ticket' => 'Can delete ticket',
    'Can restore trashed ticket' => 'Can restore trashed ticket',
    'Can assign ticket' => 'Can assign ticket',
    'Can assign ticket group' => 'Can assign ticket group',
    'Can update ticket status' => 'Can update ticket status',
    'Can update ticket priority' => 'Can update ticket priority',
    'Can update ticket type' => 'Can update ticket type',
    'Can add internal notes to ticket' => 'Can add internal notes to ticket',
    'Can edit thread/notes' => 'Can edit thread/notes',
    'Can lock/unlock thread' => 'Can lock/unlock thread',
    'Can add collaborator to ticket' => 'Can add collaborator to ticket',
    'Can delete collaborator from ticket' => 'Can delete collaborator from ticket',
    'Can delete thread/notes' => 'Can delete thread/notes',
    'Can apply prepared response on ticket' => 'Can apply prepared response on ticket',
    'Can add ticket tags' => 'Can add ticket tags',
    'Can delete ticket tags' => 'Can delete ticket tags',
    'Can kick other ticket users' => 'Can kick other ticket users',
    'Can manage email templates' => 'Can manage email templates',
    'Can manage groups' => 'Can manage groups',
    'Can manage Sub-Groups/ Teams' => 'Can manage Sub-Groups/ Teams',
    'Can manage agents' => 'Can manage agents',
    'Can manage agent privileges' => 'Can manage agent privileges',
    'Can manage ticket types' => 'Can manage ticket types',
    'Can manage ticket custom fields' => 'Can manage ticket custom fields',
    'Can manage customers' => 'Can manage customers',
    'Can manage Prepared Responses' => 'Can manage Prepared Responses',
    'Can manage Automatic workflow' => 'Can manage Automatic workflow',
    'Can manage tags' => 'Can manage tags',
    'Can manage knowledgebase' => 'Can manage knowledgebase',
    'Can manage Groups Saved Reply' => 'Can manage Groups Saved Reply',
    'Add Privilege' => 'Add Privilege',
    'Choose set of privileges which will be available to the agent.' => 'Choose set of privileges which will be available to the agent.',
    'Advanced' => 'Advanced',
    'Privilege Name must have characters only' => 'Privilege Name must have characters only',
    'Maximum character length is 50' => 'Maximum character length is 50',
    'Open Tickets' => 'Open Tickets',
    'New Customer' => 'New Customer',
    'New Agent' => 'New Agent',
    'Total Article(s)' => 'Total Article(s)',
    'Please specify a valid email address' => 'Please specify a valid email address',
    'Please enter the password associated with your email address' => 'Please enter the password associated with your email address',
    'Please enter your server host address' => 'Please enter your server host address',
    'Please specify a port number to connect with your mail server' => 'Please specify the port number for your mail server',
    'Success ! Branding details saved successfully.' => 'Success! Branding details saved successfully.',
    'Success ! Time details saved successfully.' => 'Success! Time details saved successfully.',
    'Spam setting saved successfully.' => 'Spam setting saved successfully.',
    'Please specify a valid name for your mailbox.' => 'Please specify a valid name for your mailbox.',
    'Please select a valid swift-mailer configuration.' => 'Please select a valid swift-mailer configuration.',
    'Please specify a valid host address.' => 'Please specify a valid host address.',
    'Please specify a valid email address.' => 'Please specify a valid email address.',
    'Please enter the associated account password.' => 'Please enter the associated account password.',
    'New Saved Reply' => 'New Saved Reply',
    'New Category' => 'New Category',
    'Folder' => 'Folder',
    'Category' => 'Category',
    'Created' => 'Created',
    'All Articles' => 'All Articles',
    'Viewed' => 'Viewed',
    'New Article' => 'New Article',
    'Thank you for your feedback!' => 'Thank you for your feedback!',
    'Was this article helpful?' => 'Was this article helpful?',
    'Helpdesk' => 'Helpdesk',
    'Support Center' => 'Support Center',
    'Mailboxes' => 'Mailboxes',
    'By' => 'By',
    'Search Tickets' => 'Search Tickets',
    'Customer Information' => 'Customer Information',
    'Total Replies' => 'Total Replies',
    'Filter With' => 'Filter With',
    'Type email to add' => 'Type email to add',
    'Collaborators' => 'Collaborators',
    'Labels' => 'Labels',
    'Group' => 'Group',
    'Stay on ticket' => 'Stay on ticket',
    'Redirect to list' => 'Redirect to list',
    'Nothing interesting here...' => 'Nothing interesting here',
    'Previous Ticket' => 'Previous Ticket',
    'Next Ticket' => 'Next Ticket',
    'Forward' => 'Forward',
    'Note' => 'Note',
    'Write a reply' => 'Write a reply',
    'Created Ticket' => 'Created Ticket',
    'All Threads' => 'All Threads',
    'Forwards' => 'Forwards',
    'Notes' => 'Notes',
    'Pinned' => 'Pinned',
    'Edit Ticket' => 'Edit Ticket',
    'Print Ticket' => 'Print Ticket',
    'Mark as Spam' => 'Mark as Spam',
    'Mark as Closed' => 'Mark as Closed',
    'Delete Ticket' => 'Delete Ticket',
    'View order details from different eCommerce channels' => 'View order details from different eCommerce channels',
    'ECOMMERCE CHANNELS' => 'ECOMMERCE CHANNELS',
    'Select channel' => 'Select channel',
    'Order Id' => 'Order Id',
    'Fetch Order' => 'Fetch Order',
    'No orders have been integrated to this ticket yet.' => 'No orders have been associated with this ticket yet.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Enter your credentials below to sign in',
    'Keep me logged in' => 'Keep me logged in',
    'Forgot Password?' => 'Forgot Password?',
    'Log in to your' => 'Log in to your',
    'Sign In' => 'Sign In',
    'Edit Customer' => 'Edit Customer',
    'Update' => 'Update',
    'Discard' => 'Discard',
    'Cancel' => 'Cancel',
    'Not Assigned' => 'Not Assigned',
    'Submit' => 'Submit',
    'Submit And Open' => 'Submit And Open',
    'Submit And Pending' => 'Submit And Pending',
    'Submit And Answered' => 'Submit And Answered',
    'Submit And Resolved' => 'Submit And Resolved',
    'Submit And Closed' => 'Submit And Closed',
    'Choose a Color' => 'Choose a Color',
    'Create' => 'Create',
    'Edit Label' => 'Edit Label',
    'Add Label' => 'Add Label',
    'To' => 'To',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Your browser does not support Javascript or Javascript is disabled. Please correct this!',
    'Confirm Action' => 'Confirm Action',
    'Confirm' => 'Confirm',
    'No result found' => 'No result found',
    'ticket delivery status' => 'ticket delivery status',
    'Warning! Select valid image file.' => 'Warning! Select valid image file.',
    'Error' => 'Error',
    'Save' => 'Save',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Edit Saved Filter',
    'Type atleast 2 letters' => 'Type at least 2 letters',
    'Remove Label' => 'Remove Label',
    'New Saved Filter' => 'New Saved Filter',
    'Is Default' => 'Is Default',
    'Remove Saved Filter' => 'Remove Saved Filter',
    'Ticket Info' => 'Ticket Info',
    'Last Replied Agent' => 'Last Replied Agent',
    'created Ticket' => 'created Ticket',
    'Uploaded Files' => 'Uploaded Files',
    'Download (as .zip)' => 'Download ( as .zip)',
    'made last reply' => 'last reply',
    'N/A' => 'N/A',
    'Unassigned' => 'Unassigned',
    'Label' => 'Label',
    'Assigned to me' => 'Assigned to me',
    'Search Query' => 'Search Query',
    'Searching' => 'Searching',
    'Saved Filter' => 'Saved Filter',
    'No Label Created' => 'No Label Created',
    'Label with same name already exist.' => 'Label with same name already exists',
    'Create New' => 'Create New',
    'Mail status' => 'Mail status',
    'replied' => 'replied',
    'added note' => 'added note',
    'forwarded' => 'forwarded',
    'TO' => 'TO',
    'CC' => 'CC',
    'BCC' => 'BCC',
    'Locked' => 'Locked',
    'Edit Thread' => 'Edit Thread',
    'Delete Thread' => 'Delete Thread',
    'Unpin Thread' => 'Unpin Thread',
    'Pin Thread' => 'Pin Thread',
    'Unlock Thread' => 'Unlock Thread',
    'Lock Thread' => 'Lock Thread',
    'Translate Thread' => 'Translate Thread',
    'Language' => 'Language',
    'English' => 'English',
    'French' => 'French',
    'Italian' => 'Italian',
    'Arabic' => 'Arabic',
    'German' => 'German',
    'Spanish' => 'Spanish',
    'Turkish' => 'Turkish',
    'Danish' => 'Danish',
    'System' => 'System',
    'Open in Files' => 'Open in Files',
    'Email address is invalid' => 'Email address is invalid',
    'Tag with same name already exist' => 'Tag with this name already exist',
    'Text length should be less than 20 charactors' => 'Must be less than 20 characters',
    'Label with same name already exist' => 'Label with same name already exist',
    'Agent Name' => 'Agent Name',
    'Agent Email' => 'Agent Email',
    'open' => 'open',
    'Currently active agents on ticket' => 'Currently active agents on ticket',
    'Edit Customer Information' => 'Edit Customer Information',
    'Restore' => 'Restore',
    'Delete Forever' => 'Delete Forever',
    'Add Team' => 'Add Team',
    'delete' => 'delete',
    'You didnt have any folder for current filter(s).' => 'No folders match current filter(s).',
    'Add Folder' => 'Add Folder',
    'This field must have valid characters only' => 'This field must have valid characters only',
    'Can edit task' => 'Can edit task',
    'Can create task' => 'Can create task',
    'Can delete task' => 'Can delete task',
    'Can add member to task' => 'Can add member to task',
    'Can remove member from task' => 'Can remove member from task',
    'Agent Privileges' => 'Agent Privileges',
    'Agent Privilege represents overall permissions in System.' => 'Agent privilege represents overall permissions in your helpdesk.',
    'Ticket View' => 'Ticket View',
    'User can view tickets based on selected scope.' => 'User can view tickets based on selected scope.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) they belongs to, etc.',
    'Global Access' => 'Global Access',
    'Group Access' => 'Group Access',
    'Team Access' => 'Team Access',
    'Individual Access' => 'Individual Access',
    'This field must have characters only' => 'This field must have characters only',
    'Maximum character length is 40' => 'Maximum character length is 40',
    'This is not a valid email address' => 'This is not a valid email address',
    'Password must contains 8 Characters' => 'Password must contains 8 Characters',
    'The passwords does not match' => 'The passwords do not match',
    'Enabled' => 'Enabled',
    'Create Configuration' => 'Create Configuration',
    'Swift Mailer Settings' => 'Swift Mailer Settings',
    'Username' => 'Username',
    'Please select a swiftmailer id' => 'Please select a swiftmailer id',
    'Please enter a valid e-mail id' => 'Please enter a valid e-mail id',
    'Please enter a mailer id' => 'Please enter a mailer id',
    'Email Id' => 'Email Id',
    'Are you sure? You want to perform this action.' => 'Are you sure you want to perform this action?',
    'Reorder' => 'Reorder',
    'New Workflow' => 'New Workflow',
    'OR' => 'OR',
    'AND' => 'AND',
    'Please enter a valid name.' => 'Please enter a valid name.',
    'Please select a value.' => 'Please select a value.',
    'Please add a value.' => 'Please add a value.',
    'This field is required' => 'This field is required',
    'or' => 'or',
    'and' => 'and',
    'Select a Condition' => 'Select a Condition',
    'Loading...' => 'Loading...',
    'Select Option' => 'Select Option',
    'Inactive' => 'Inactive',
    'New Type' => 'New Type',
    'Placeholders' => 'Placeholders',
    'Ticket Link' => 'Ticket Link',
    'Id' => 'Id',
    'Preview' => 'Preview',
    'Sort Order' => 'Sort Order',
    'This field must be a number' => 'This field must be a number',
    'User' => 'User',
    'Edit Group' => 'Edit Group',
    'Group Status' => 'Group Status',
    'Group is Active' => 'Group is Active',
    'Add Group' => 'Add Group',
    'Contact number is invalid' => 'Contact number is invalid',
    'Edit Agent' => 'Edit Agent',
    'No Privilege added, Please add Privilege(s) first !' => 'No privilege added, please add privilege(s) first!',
    'Edit Email Template' => 'Edit Email Template',
    'Edit Workflow' => 'Edit Workflow',
    'Save Workflow' => 'Save Workflow',
    'Edit Ticket Type' => 'Edit Ticket Type',
    'Add Ticket Type' => 'Add Ticket Type',
    'Date Released' => '	Date Released',
    'Free' => 'Free',
    'Premium' => 'Premium',
    'Installed' => 'Installed',
    'Installed Applications' => 'Installed Applications',
    'Apps Dashboard' => 'Apps Dashboard',
    'Nothing Interesting here' => 'Nothing interesting here',
    'No Categories Added' => 'No Categories Added',
    'Error : Something went wrong, please try again later' => 'Error: Something went wrong, please try again later',
    'ticket' => 'ticket',
    'Add Email Template' => 'Add Email Template',
    'This field contain 100 characters only' => 'Max 100 characters',
    'This field contain characters only' => 'This field may contain characters only',
    'Name length must not be greater than 200 !!' => 'Name length must not be greater than 200!',
    'Warning! Correct all field values first!' => 'Warning! Correct all field values first!',
    'Warning ! This is not a valid request' => 'Warning! This is not a valid request',
    'Success ! Tag removed successfully.' => 'Success! Tag removed successfully.',
    'Success ! Tags Saved successfully.' => 'Success! Tags Saved successfully.',
    'Success ! Revision restored successfully.' => 'Success! Revision restored successfully.',
    'Success ! Categories updated successfully.' => 'Success! Categories updated successfully.',
    'Success ! Article Related removed successfully.' => 'Success! Related article removed successfully.',
    'Success ! Article Related is already added.' => 'Success! Related article added.',
    'Success ! Cannot add self as relative article.' => 'Success! Cannot add self as relative article.',
    'Success ! Article Related updated successfully.' => 'Success! Related article updated successfully.',
    'Success ! Articles removed successfully.' => 'Success! Articles removed successfully.',
    'Success ! Article status updated successfully.' => 'Success! Article status updated successfully.',
    'Success ! Article star updated successfully.' => 'Success! Article star updated successfully.',
    'Success! Article updated successfully' => 'Success! Article updated successfully',
    'Success ! Category sort  order updated successfully.' => 'Success! Category sort order updated successfully.',
    'Success ! Category status updated successfully.' => 'Success! Category status updated successfully.',
    'Success ! Folders updated successfully.' => 'Success! Folders updated successfully.',
    'Success ! Categories removed successfully.' => 'Success! Categories removed successfully.',
    'Success ! Category updated successfully.' => 'Success! Category updated successfully.',
    'Error ! Category is not exist.' => 'Error! Category does not exist.',
    'Warning ! Customer Login disabled by admin.' => 'Warning! Customer Login disabled by admin.',
    'This Email is not registered with us.' => 'This email is not registered with us.',
    'Your password has been updated successfully.' => 'Your password has been updated successfully.',
    'Password dont match.' => 'Password doesn\'t match.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Error! Profile image is not valid, please upload a valid format',
    'Warning! Provide valid image file. (Recommened": "PNG, JPG or GIF Format).' => 'Warning! invalid image file. (Recommened": "PNG, JPG or GIF Format).',
    'Success! Folder has been added successfully.' => 'Success! Folder has been added successfully.',
    'Folder updated successfully.' => 'Folder updated successfully.',
    'Success ! Folder status updated successfully.' => 'Success! Folder status updated successfully.',
    'Error ! Folder is not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder updated successfully.' => 'Success! Folder updated successfully.',
    'Error ! Folder does not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder deleted successfully.' => 'Success! Folder deleted successfully.',
    'Warning ! Folder doesnt exists!' => 'Warning! Folder doesn\'t exists!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Warning! Can\'t create ticket, given email is blocked by admin.',
    'Success ! Ticket has been created successfully.' => 'Success! Ticket has been created successfully.',
    'Warning ! Can not create ticket, invalid details.' => 'Warning! Can not create ticket, invalid details.',
    'Warning ! Post size can not exceed 25MB' => 'Warning! attachmment size can not exceed 25MB',
    'Create Ticket Request' => 'Create Ticket Request',
    'Success ! Reply added successfully.' => 'Success! Reply added successfully.',
    'Warning ! Reply field can not be blank.' => 'Warning! Reply field can not be blank.',
    'Success ! Rating has been successfully added.' => 'Success! Rating has been successfully added.',
    'Warning ! Invalid rating.' => 'Warning! Invalid rating.',
    'Error ! Can not add customer as a collaborator.' => 'Error! Can not add customer as a collaborator.',
    'Success ! Collaborator added successfully.' => 'Success! Collaborator added successfully.',
    'Error ! Collaborator is already added.' => 'Error! Collaborator is already added.',
    'Success ! Collaborator removed successfully.' => 'Success! Collaborator removed successfully.',
    'Error ! Invalid Collaborator.' => 'Error! Invalid Collaborator.',
    'An unexpected error occurred. Please try again later.' => 'An unexpected error occurred. Please try again later.',
    'Feedback saved successfully.' => 'Feedback saved successfully.',
    'Feedback updated successfully.' => 'Feedback updated successfully.',
    'Invalid feedback provided.' => 'Invalid feedback provided.',
    'Article not found.' => 'Article not found.',
    'You need to login to your account before can perform this action.' => 'You need to log in to your account before can perform this action.',
    'Warning! Please add valid Actions!' => 'Warning! Please add valid actions!',
    'Warning! In Free Plan you can not change Events!' => 'Warning! In free plan you can not change events!',
    'Success! Prepared Response has been updated successfully.' => 'Success! Prepared response has been updated successfully.',
    'Success! Prepared Response has been added successfully.' => 'Success! Prepared response has been added successfully.',
    'Warning  This is not a valid request' => 'Warning! This is not a valid request',
    'Use Default Colors' => 'Use Default Colors',
    'Masonry' => 'Masonry',
    'Popular Article' => 'Popular Article',
    'Manage Ticket Custom Fields' => 'Manage Ticket Custom Fields',
    'Mail status:' => 'Mail status:',
    'You dont have premission to edit this Prepared response' => 'You don\'t have premission to edit this prepared response',
    'Save Prepared Response' => 'Save prepared response',
    'Success ! Prepared response removed successfully.' => 'Success! Prepared response removed successfully.',
    'Warning! You are not allowed to perform this action.' => 'Warning! You are not allowed to perform this action.',
    'Success! Workflow has been updated successfully.' => 'Success! Workflow has been updated successfully.',
    'Success! Workflow has been added successfully.' => 'Success! Workflow has been added successfully.',
    'Success! Order has been updated successfully.' => 'Success! Order has been updated successfully.',
    'Success! Workflow has been removed successfully.' => 'Success! Workflow has been removed successfully.',
    'Mailbox successfully created.' => 'Mailbox successfully created.',
    'Mailbox successfully updated.' => 'Mailbox successfully updated.',
    'Warning ! Bad request !' => 'Warning! Bad request!',
    'Error! Given current password is incorrect.' => 'Error! Password is incorrect.',
    'Success ! Profile update successfully.' => 'Success! Profile update successfully.',
    'Error ! User with same email is already exist.' => 'Error! User with same email already exists.',
    'Success ! Agent updated successfully.' => 'Success! Agent updated successfully.',
    'Success ! Agent removed successfully.' => 'Success! Agent removed successfully.',
    'Warning ! You are allowed to remove account owners account.' => 'Warning! You are allowed to remove this account.',
    'Error ! Invalid user id.' => 'Error! Invalid user id.',
    'Success ! Filter has been saved successfully.' => 'Success! Filter has been saved successfully.',
    'Success ! Filter has been updated successfully.' => 'Success! Filter has been updated successfully.',
    'Success ! Filter has been removed successfully.' => 'Success! Filter has been removed successfully.',
    'Please check your mail for password update.' => 'Please check your inbox for a new password.',
    'This Email address is not registered with us.' => 'This email address is not registered with us.',
    'Success ! Customer saved successfully.' => 'Success! Customer saved successfully.',
    'Error ! User with same email already exist.' => 'Error! User with same email already exists.',
    'Success ! Customer information updated successfully.' => 'Success! Customer information updated successfully.',
    'Success ! Customer updated successfully.' => 'Success! Customer updated successfully.',
    'Error ! Customer with same email already exist.' => 'Error! Customer with same email already exists.',
    'unstarred Action Completed successfully' => 'unstarred action completed successfully',
    'starred Action Completed successfully' => 'starred action completed successfully',
    'Success ! Customer removed successfully.' => 'Success! Customer removed successfully.',
    'Error ! Invalid customer id.' => 'Error! Invalid customer id.',
    'Success! Template has been updated successfully.' => 'Success! Template has been updated successfully.',
    'Success! Template has been added successfully.' => 'Success! Template has been added successfully.',
    'Success! Template has been deleted successfully.' => 'Success! Template has been deleted successfully.',
    'Warning! resource not found.' => 'Warning! resource not found.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Warning! You can not remove an email template which is being used in workflow(s).',
    'Success ! Email settings are updated successfully.' => 'Success! Email settings successfully updated.',
    'Success ! Group information updated successfully.' => 'Success! Group information updated successfully.',
    'Success ! Group information saved successfully.' => 'Success! Group information saved successfully.',
    'Support Group removed successfully.' => 'Support Group removed successfully.',
    'Success ! Privilege information saved successfully.' => 'Success! Privilege information saved successfully.',
    'Privilege updated successfully.' => 'Privilege updated successfully.',
    'Support Privilege removed successfully.' => 'Support privilege removed successfully.',
    'Success! Reply has been updated successfully.' => 'Success! Reply has been updated successfully.',
    'Success! Reply has been added successfully.' => 'Success! Reply has been added successfully.',
    'Success! Saved Reply has been deleted successfully' => 'Success! Saved Reply has been deleted successfully',
    'SwiftMailer configuration updated successfully.' => 'SwiftMailer configuration updated successfully.',
    'Swiftmailer configuration removed successfully.' => 'Swiftmailer configuration removed successfully.',
    'Success ! Team information saved successfully.' => 'Success! Team information saved successfully.',
    'Success ! Team information updated successfully.' => 'Success! Team information updated successfully.',
    'Support Team removed successfully.' => 'Support Team removed successfully.',
    'Success! Reply has been added successfully' => 'Success! Reply has been added successfully',
    'Success ! Thread updated successfully.' => 'Success! Thread updated successfully.',
    'Error ! Reply field can not be blank.' => 'Error  Reply field can not be blank.',
    'Success ! Thread removed successfully.' => 'Success! Thread removed successfully.',
    'Success ! Thread locked successfully' => 'Success! Thread locked successfully',
    'Success ! Thread unlocked successfully' => 'Success! Thread unlocked successfully',
    'Success ! Thread pinned successfully' => 'Success! Thread unpinned successfully',
    'Error ! Invalid thread.' => 'Error! Invalid thread.',
    'Could not create ticket, invalid details.' => 'Could not create ticket, invalid details.',
    'Success ! Tag updated successfully.' => 'Success! Tag updated successfully.',
    'Error ! Customer can not be added as collaborator.' => 'Error! Customer can not be added as collaborator.',
    'Success ! Tag unassigned successfully.' => 'Success! Tag unassigned successfully.',
    'Success ! Tag added successfully.' => 'Success! Tag added successfully.',
    'Please enter tag name.' => 'Please enter tag name.',
    'Error ! Invalid tag.' => 'Error! Invalid tag.',
    'Success ! Type removed successfully.' => 'Success! Type removed successfully.',
    'Success ! Ticket to label removed successfully.' => 'Success! Ticket label removed successfully.',
    'Unable to retrieve support team details' => 'Unable to retrieve support team details',
    'Ticket support group updated successfully' => 'Ticket support group updated successfully',
    'Unable to retrieve status details' => 'Unable to retrieve status details',
    'Insufficient details provided.' => 'Insufficient details provided.',
    'Error! Subject field is mandatory' => 'Error! Subject field is mandatory',
    'Error! Reply field is mandatory' => 'Error! Reply field is mandatory',
    'Success ! Ticket has been updated successfully.' => 'Success! Ticket has been updated successfully.',
    'Success ! Label updated successfully.' => 'Success! Label updated successfully.',
    'Error ! Invalid label id.' => 'Error! Invalid label id.',
    'Success ! Label removed successfully.' => 'Success! Label removed successfully.',
    'Success ! Label created successfully.' => 'Success! Label created successfully.',
    'Error ! Label name can not be blank.' => 'Error! Label name can not be blank.',
    'Success ! Ticket moved to trash successfully.' => 'Success! Ticket moved to trash successfully.',
    'Success! Ticket type saved successfully.' => 'Success! Ticket type saved successfully.',
    'Success! Ticket type updated successfully.' => 'Success! Ticket type updated successfully.',
    'Error! Ticket type with same name already exist' => 'Error! Ticket type with same name already exist',
    'SAVE' => 'SAVE',
    'Howdy!' => 'Howdy!',
    'New Ticket Request' => 'New Ticket Request',
    'Ticket Requests' => 'Ticket Requests',
    'Tickets have been updated successfully' => 'Tickets have been updated successfully',
    'Please check your mail for password update' => 'Please check your inbox for a new password',
    'This email address is not registered with us' => 'This email address is not registered with us',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'You have already updated your password using this link. If you wish to change your password again click on the forget password link on the login page.',
    'Your password has been successfully updated. Login using updated password' => 'Your password has been successfully updated. Please log in using your new password.',
    'Please try again, The passwords do not match' => 'Please try again, The passwords do not match',
    'Support Privilege removed successfully' => 'Support Privilege removed successfully',
    'Success! Saved Reply has been deleted successfully.' => 'Success! Saved Reply has been deleted successfully.',
    'SwiftMailer configuration created successfully.' => 'SwiftMailer configuration created successfully.',
    'No swiftmailer configurations found for mailer id:' => 'No swiftmailer configurations found for mailer id:',
    'Reply content cannot be left blank.' => 'Reply content cannot be left blank.',
    'Reply added to the ticket and forwarded successfully.' => 'Reply added to the ticket and forwarded successfully.',
    'Success ! Thread pinned successfully.' => 'Success! Thread pinned successfully.',
    'Success ! unpinned removed successfully.' => 'Success! Thread unpinned successfully.',
    'Unable to retrieve priority details' => 'Unable to retrieve priority details',
    'Ticket support team updated successfully' => 'Ticket support team updated successfully',
    'Ticket assigned to support group ' => 'Ticket assigned to support group ',
    'Mailbox configuration removed successfully.' => 'Mailbox configuration removed successfully.',
    'visit our website' => 'visit our website',
    'Cookie Usage Policy' => 'Cookie Usage Policy',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => 'HELP',
    'Home' => 'Home',
    'Cookie Policy' => 'Cookie Policy',
    'Prev' => 'Prev',
    'Ticket query message' => 'Ticket content',
    'Select type' => 'Select type',
    'Search KnowledgeBase' => 'Search KnowledgeBase',
    'You cant merge an account with itself.' => 'You can\'t merge an account with itself.',
    'Edit Profile' => 'Edit Profile',
    'Customer Login' => 'Customer Login',
    'Contact Us' => 'Contact Us',
    'If you have ever contacted our support previously, your account would have already been created.' => 'If you have ever contacted us previously, your account is more than likely already created.',
    'support' => 'support',
    'HelpDesk' => 'HelpDesk',
    'Enter search keyword' => 'Enter search keyword',
    'Browse via Folders' => 'Explore the knowledge base',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Check out our knowledge base to see if your question has already been answered.',
    'Unable to find an answer?' => 'Contact Our Team',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'If you still can\'t find an answer to what you\'re looking for, or you have a specific question, open a new ticket and we\'d be happy to help!',
    'Popular Articles' => 'Popular Articles',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => 'Some of the more popular articles in our knowledge base that have helped other customers.',
    'Browse via Categories' => 'Browse via Categories',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Choose a category from the list below to view articles.',
    'No Categories Found!' => 'No Categories Found!',
    'Powered by' => 'Powered by',
    'Forgot Password' => 'Forgot Password',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'Enter your email address and we will send you a message to update your login credentials.',
    'Send Mail' => 'Send Mail',
    'Sign In to %websitename%' => 'Sign In to %websitename%',
    'Enter your name' => 'Enter your name',
    'Enter your email' => 'Enter your email',
    'Learn more about %deliveryStatus%.' => 'Learn more about %deliveryStatus%.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'To know more about our privacy policy, please visit %websiteLink%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.',
    'This field contain maximum 40 charectures.' => 'This field contain maximum 40 charectures.',
    'This field contain maximum 50 charectures.' => 'This field contain maximum 50 charectures.',
    'Time' => 'Time',
    'Links' => 'Links',
    'Broadcast Message' => 'Broadcast Message',
    'Wide Logo' => 'Wide Logo',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Upload an Image (200px x 48px) in</br> PNG or JPG Format',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Your knowledge base / helpdesk logo',
    'Website Status' => 'Website Status',
    'Enable front end website and knowledgebase for customer(s)' => 'Enable front end website and knowledgebase for customer(s)',
    'Brand Color' => 'Brand Color',
    'Page Background Color' => 'Page Background Color',
    'Header Background Color' => 'Header Background Color',
    'Banner Background Color' => 'Banner Background Color',
    'Page Link Color' => 'Page Link Color',
    'Page Link Hover Color' => 'Page Link Hover Color',
    'Article Text Color' => 'Article Text Color',
    'Tag Line' => 'Tag Line',
    'Hi! how can we help?' => 'Hi! how can we help?',
    'Layout' => 'Layout',
    'Ticket Create Option' => 'Ticket Create Option',
    'Login Required To Create Tickets' => 'Login required To create tickets',
    'Remove Customer Login/Signin Button' => 'Remove customer log in / sign in button',
    'Disable Customer Login' => 'Disable Customer Login',
    'Meta Description (Recommended)' => 'Meta Description (Recommended)',
    'Meta Keywords (Recommended)' => 'Meta Keywords (Recommended)',
    'Header Link' => 'Header Link',
    'URL (with http":/"/ or https":/"/)' => 'URL (with http":/"/ or https":/"/)',
    'Footer Link' => 'Footer Link',
    'Custom CSS (Optional)' => 'Custom CSS (Optional)',
    'It will be add to the frontend knowledgebase only' => 'Displayed only in front end knowledge base',
    'Custom Javascript (Optional)' => 'Custom Javascript (Optional)',
    'Broadcast message content to show on helpdesk' => 'Broadcast message content to show on helpdesk',
    'From' => 'From',
    'Time duration between which message will be displayed(if applicable)' => 'How long should the message be displayed?',
    'Broadcasting Status' => 'Broadcasting Status',
    'Broadcasting is Active' => 'Broadcasting is Active',
    'Choose a default company timezone' => 'Choose a default companys timezone',
    'Date Time Format' => 'Date Time Format',
    'Choose a format to convert date to specified date time format' => 'Choose a format to convert date to specified date time format',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'File size must not be greater than 200KB !!' => 'File size must not be greater than 200KB!',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Please upload a valid omage file (JPEG or PNG)!',
    'Provide a valid url(with protocol)' => 'Provide a valid url (with protocol)',
    'ticket.message.placeHolders.info' => 'ticket.message.placeHolders.info',
    'ticket.attachments.placeHolders.info' => '	ticket.attachments.placeHolders.info',
    'ticket.threadMessage.placeHolders.info' => 'ticket.threadMessage.placeHolders.info',
    'ticket.tags.placeHolders.info' => 'ticket.tags.placeHolders.info',
    'ticket.source.placeHolders.info' => 'ticket.source.placeHolders.info',
    'ticket.collaborator.name.placeHolders.info' => 'ticket.collaborator.name.placeHolders.info',
    'ticket.collaborator.email.placeHolders.info' => 'ticket.collaborator.email.placeHolders.info',
    'user.name.info' => 'user.name.info',
    'user.email.info' => 'user.email.info',
    'user.account.validate.link.info' => 'user.account.validate.link.info',
    'user.password.forgot.link.info' => 'user.password.forgot.link.info',
    'global.companyName' => 'global.companyName',
    'global.companyLogo' => 'global.companyLogo',
    'global.companyUrl' => 'global.companyUrl',
    'ticket.priority.placeHolders.info' => '	ticket.priority.placeHolders.info',
    'ticket.group.placeHolders.info' => 'ticket.group.placeHolders.info',
    'ticket.team.placeHolders.info' => 'ticket.team.placeHolders.info',
    'ticket.customerName.placeHolders.info' => '	ticket.customerName.placeHolders.info',
    'ticket.customerEmail.placeHolders.info' => '	ticket.customerEmail.placeHolders.info',
    'ticket.agentName.placeHolders.info' => 'ticket.agentName.placeHolders.info',
    'ticket.agentEmail.placeHolders.info' => 'ticket.agentEmail.placeHolders.info',
    'ticket.link.placeHolders.info' => '	ticket.link.placeHolders.info ',
    'ticket.id.placeHolders.info' => 'ticket.id.placeHolders.info',
    'ticket.subject.placeHolders.info' => '	ticket.subject.placeHolders.info',
    'ticket.status.placeHolders.info' => 'ticket.status.placeHolders.info',
    'comma "," separated' => 'comma separated (,)',
    'Low' => 'Low',
    'Medium' => 'Medium',
    'High' => 'High',
    'Urgent' => 'Urgent',
    'Reset Password' => 'Reset Password',
    'Enter your new password below to update your login credentials' => 'Enter your new password below to update your login credentials',
    'Save Password' => 'Save Password',
    'Rate Support' => 'Rate Support',
    'I am very Sad' => 'I am very disappointed',
    'I am Sad' => 'I am disappointed',
    'I am Neutral' => 'I am satisfied',
    'I am Happy' => 'I am happy',
    'I am Very Happy' => 'I am very happy',
    'Kudos' => 'Kudos',
    'Very Sad' => 'Very disappointed',
    'Sad' => 'Disappointed',
    'Neutral' => 'Satisfied',
    'Happy' => 'Happy',
    'Very Happy' => 'Very Happy',
    'Star(s)' => 'Star(s)',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Warning ! Swiftmailer not working. An error has occurred while sending emails!',
    'Invalid credentials.' => 'Invalid credentials',
    'Success ! Project cache cleared successfully.' => 'Success! Project cache cleared successfully.',
    'clear cache' => 'clear cache',
    'Last Updated' => 'Last Updated',
    'Error! Something went wrong.' => 'Error! Something went wrong.',
    'We were not able to find the page you are looking for.' => 'We were not able to find the page you are looking for.',
    'Page not found' => 'Page not found',
    'Forbidden' => 'Forbidden',
    'You don’t have the necessary permissions to access this Web page :(' => 'You don’t have the necessary permissions to access this Web page :(',
    'Internal server error' => 'Internal server error',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Our system has goofed up for a while, but good part is it won\'t last long',
    'Unknown Error' => 'Unknown Error',
    'We are quite confused about how did you land here:/' => 'We are quite confused about how did you land here :/',
    'Few of the links which may help you to get back on the track -' => 'Few of the links which may help you to get back on the track -',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
