<?php 
@unlink('update_glpikey.php');

$key = random_bytes(32);
echo '<glpikey>'.$key.'</glpikey>';


//Generate private/public keypair using openssl functions
$key = openssl_pkey_new([
	'digest_alg'       => 'sha512',
	'private_key_bits' => 2048,
	'private_key_type' => OPENSSL_KEYTYPE_RSA,
]);

// export private key
openssl_pkey_export($key, $priv_key);

// export public key
$keyData = openssl_pkey_get_details($key);

$public_key = $keyData['key'];
$private_key = $priv_key;

echo '<publickey>'.$public_key.'</publickey>';
echo '<privatekey>'.$private_key.'</privatekey>';

?>