#!/bin/bash

FORCE=$(echo "$@" | grep -oP -- "--force")
do_log() {
    echo "[$(date)] $*" | tee -a /var/log/update_shared_ads.log;
}

INCLUDE_FILE="imh_include.html.tt"
LOCAL_ADS_VERSION_FILE="/etc/shared_ads"
LOCAL_TEMPLATE_FILE="/usr/local/cpanel/base/frontend/jupiter/_assets/${INCLUDE_FILE}"

# if development, use development URL
if hostname | grep -q dev; then
    REMOTE_ADS_URL="https://dedbackups.iad1.imhcloud.net/int-shared-ads/development"
else
    REMOTE_ADS_URL="https://dedbackups.iad1.imhcloud.net/int-shared-ads/production"
fi

if ! test -f $LOCAL_ADS_VERSION_FILE; then
    LOCAL_ADS_VERSION=0;
else
    LOCAL_ADS_VERSION=$(cat $LOCAL_ADS_VERSION_FILE);
fi

REMOTE_ADS_VERSION=$(curl -s "${REMOTE_ADS_URL}/version.txt")
if [[ ! -z "${REMOTE_ADS_VERSION}" ]]; then
    if [[ $REMOTE_ADS_VERSION -gt $LOCAL_ADS_VERSION || "${FORCE}" == "--force" ]]; then
        if [[ "${FORCE}" == "--force" ]]; then
            do_log "Updating IMH cPanel Ads release from ${LOCAL_ADS_VERSION} to ${REMOTE_ADS_VERSION} (force=True)";
        else
            do_log "Updating IMH cPanel Ads release from ${LOCAL_ADS_VERSION} to ${REMOTE_ADS_VERSION} (force=False)";
        fi
        wget -q -O "${LOCAL_TEMPLATE_FILE}" "${REMOTE_ADS_URL}/${INCLUDE_FILE}";
        echo "${REMOTE_ADS_VERSION}" > $LOCAL_ADS_VERSION_FILE;
    fi
else
    do_log "We failed to retrieve version information from int-shared-ads";
fi
