
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `unb`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ACL`
--

CREATE TABLE `[[dbprefix]]ACL` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `User` int(10) unsigned DEFAULT NULL,
  `Group` int(10) unsigned DEFAULT NULL,
  `Action` smallint(5) unsigned DEFAULT NULL,
  `Thread` int(10) unsigned DEFAULT NULL,
  `Forum` int(10) unsigned DEFAULT NULL,
  `Grant` int(11) DEFAULT NULL,
  `Enabled` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `User` (`User`,`Group`,`Action`,`Thread`,`Forum`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]ACL`
--

INSERT INTO `[[dbprefix]]ACL` VALUES
(1, 0, 1, 33, 0, 0, 1, 1),
(2, 0, 2, 82, 0, 0, 1, 1),
(3, 0, 3, 83, 0, 0, 1, 1),
(4, 0, 4, 84, 0, 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AnnounceRead`
--

CREATE TABLE `[[dbprefix]]AnnounceRead` (
  `Announce` int(10) unsigned NOT NULL DEFAULT '0',
  `User` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`Announce`,`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Announces`
--

CREATE TABLE `[[dbprefix]]Announces` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Forum` int(11) DEFAULT NULL,
  `Date` int(11) DEFAULT NULL,
  `User` int(10) unsigned DEFAULT NULL,
  `Subject` varchar(150) DEFAULT NULL,
  `Msg` text,
  `Options` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Forums`
--

CREATE TABLE `[[dbprefix]]Forums` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Sort` int(11) DEFAULT NULL,
  `Parent` int(10) unsigned DEFAULT NULL,
  `Name` varchar(100) DEFAULT NULL,
  `Flags` int(11) DEFAULT NULL,
  `Description` text,
  `Link` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ForumWatch`
--

CREATE TABLE `[[dbprefix]]ForumWatch` (
  `Forum` int(10) unsigned NOT NULL DEFAULT '0',
  `User` int(10) unsigned NOT NULL DEFAULT '0',
  `Mode` tinyint(3) unsigned DEFAULT NULL,
  `Flags` tinyint(3) unsigned DEFAULT NULL,
  `LastVisited` int(11) NOT NULL DEFAULT '0',
  `LastNotify` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Forum`,`User`),
  KEY `Forum` (`Forum`),
  KEY `User` (`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]GroupMembers`
--

CREATE TABLE `[[dbprefix]]GroupMembers` (
  `Group` int(10) unsigned NOT NULL DEFAULT '0',
  `User` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`Group`,`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]GroupMembers`
--

INSERT INTO `[[dbprefix]]GroupMembers` VALUES
(2, 1),
(4, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]GroupNames`
--

CREATE TABLE `[[dbprefix]]GroupNames` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Name` varchar(50) DEFAULT NULL,
  `ShowInTeam` tinyint(1) DEFAULT NULL,
  `PublicGroup` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]GroupNames`
--

INSERT INTO `[[dbprefix]]GroupNames` VALUES
(1, 'Guests', 0, NULL),
(2, 'Members', 0, NULL),
(3, 'Global Moderators', 1, NULL),
(4, 'Administrators', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Guests`
--

CREATE TABLE `[[dbprefix]]Guests` (
  `Session` varchar(80) DEFAULT NULL,
  `LastActivity` int(11) DEFAULT NULL,
  `LastForum` int(11) DEFAULT NULL,
  `UserName` varchar(40) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PollUsers`
--

CREATE TABLE `[[dbprefix]]PollUsers` (
  `Thread` int(10) unsigned NOT NULL DEFAULT '0',
  `User` int(10) unsigned NOT NULL DEFAULT '0',
  `VoteNum` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Thread`,`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PollVotes`
--

CREATE TABLE `[[dbprefix]]PollVotes` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Thread` int(10) unsigned DEFAULT NULL,
  `Sort` tinyint(4) DEFAULT NULL,
  `Title` varchar(100) DEFAULT NULL,
  `Votes` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Posts`
--

CREATE TABLE `[[dbprefix]]Posts` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Thread` int(10) unsigned DEFAULT NULL,
  `ReplyTo` int(10) unsigned DEFAULT NULL,
  `Date` int(11) DEFAULT NULL,
  `EditUser` int(10) unsigned DEFAULT NULL,
  `EditDate` int(11) DEFAULT NULL,
  `EditCount` smallint(5) unsigned DEFAULT NULL,
  `EditReason` varchar(255) DEFAULT NULL,
  `User` int(10) unsigned DEFAULT NULL,
  `UserName` varchar(40) DEFAULT NULL,
  `Subject` varchar(150) DEFAULT NULL,
  `Msg` text,
  `Options` int(10) unsigned DEFAULT NULL,
  `AttachFile` varchar(40) DEFAULT NULL,
  `AttachFileName` varchar(100) DEFAULT NULL,
  `AttachDLCount` int(10) unsigned DEFAULT NULL,
  `IP` varchar(15) DEFAULT NULL,
  `Hostname` varchar(150) DEFAULT NULL,
  `SpamRating` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `Thread` (`Thread`),
  KEY `Date` (`Date`),
  KEY `User` (`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Stat`
--

CREATE TABLE `[[dbprefix]]Stat` (
  `Date` int(11) NOT NULL DEFAULT '0',
  `NewThreads` int(11) NOT NULL DEFAULT '0',
  `NewPosts` int(11) NOT NULL DEFAULT '0',
  `OnlineUsers` int(11) NOT NULL DEFAULT '0',
  `OnlineGuests` int(11) NOT NULL DEFAULT '0',
  `PageHits` int(11) NOT NULL DEFAULT '0',
  `NewUsers` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Stat`
--

INSERT INTO `[[dbprefix]]Stat` VALUES
([[timestamp]], 0, 0, 1, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Threads`
--

CREATE TABLE `[[dbprefix]]Threads` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Forum` int(10) unsigned DEFAULT NULL,
  `LastPostDate` int(11) DEFAULT NULL,
  `Subject` varchar(150) DEFAULT NULL,
  `Desc` varchar(150) DEFAULT NULL,
  `Date` int(11) DEFAULT NULL,
  `User` int(10) unsigned DEFAULT NULL,
  `UserName` varchar(40) DEFAULT NULL,
  `Views` int(10) unsigned DEFAULT NULL,
  `Options` int(10) unsigned DEFAULT NULL,
  `Question` varchar(150) DEFAULT NULL,
  `PollTimeout` int(11) DEFAULT NULL,
  `LastVoted` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `LastPostDate` (`LastPostDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ThreadWatch`
--

CREATE TABLE `[[dbprefix]]ThreadWatch` (
  `Thread` int(10) unsigned NOT NULL DEFAULT '0',
  `User` int(10) unsigned NOT NULL DEFAULT '0',
  `Mode` tinyint(3) unsigned DEFAULT NULL,
  `LastRead` int(11) NOT NULL DEFAULT '0',
  `LastNotify` int(11) NOT NULL DEFAULT '0',
  `LastViewed` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Thread`,`User`),
  KEY `Thread` (`Thread`),
  KEY `User` (`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]UserForumFlags`
--

CREATE TABLE `[[dbprefix]]UserForumFlags` (
  `User` int(10) unsigned NOT NULL DEFAULT '0',
  `Forum` int(10) unsigned NOT NULL DEFAULT '0',
  `Thread` int(10) unsigned NOT NULL DEFAULT '0',
  `Flags` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`User`,`Forum`,`Thread`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Users`
--

CREATE TABLE `[[dbprefix]]Users` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Name` varchar(40) DEFAULT NULL,
  `Password` varchar(200) DEFAULT NULL,
  `RegDate` int(11) DEFAULT NULL,
  `ValidatedEMail` varchar(100) DEFAULT NULL,
  `DefaultNotify` tinyint(3) unsigned DEFAULT NULL,
  `EMail` varchar(100) DEFAULT NULL,
  `Jabber` varchar(50) DEFAULT NULL,
  `ICQ` varchar(15) DEFAULT NULL,
  `AIM` varchar(30) DEFAULT NULL,
  `YIM` varchar(30) DEFAULT NULL,
  `MSN` varchar(50) DEFAULT NULL,
  `LastActivity` int(11) DEFAULT NULL,
  `LastForum` int(11) DEFAULT NULL,
  `LastLogin` int(11) DEFAULT NULL,
  `LastLogout` int(11) DEFAULT NULL,
  `Signature` text,
  `BirthDay` tinyint(3) unsigned DEFAULT NULL,
  `BirthMonth` tinyint(3) unsigned DEFAULT NULL,
  `BirthYear` smallint(5) unsigned DEFAULT NULL,
  `About` text,
  `Title` varchar(40) DEFAULT NULL,
  `Location` varchar(50) DEFAULT NULL,
  `Homepage` varchar(150) DEFAULT NULL,
  `Gender` char(1) DEFAULT NULL,
  `Avatar` varchar(150) DEFAULT NULL,
  `AvatarX` smallint(6) DEFAULT NULL,
  `AvatarY` smallint(6) DEFAULT NULL,
  `Photo` varchar(150) DEFAULT NULL,
  `ValidateKey` varchar(50) DEFAULT NULL,
  `RecommendedBy` int(10) unsigned DEFAULT NULL,
  `Design` varchar(50) DEFAULT NULL,
  `Flags` int(10) unsigned DEFAULT NULL,
  `Timezone` tinyint(4) DEFAULT '99',
  `TimezoneDS` tinyint(4) DEFAULT '-1',
  `EditControls` int(10) unsigned DEFAULT NULL,
  `ThreadsPerPage` smallint(6) DEFAULT '-1',
  `ThreadSort` smallint(6) DEFAULT '-1',
  `ThreadTime` smallint(6) DEFAULT '-1',
  `Language` varchar(6) DEFAULT NULL,
  `DateFormat` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `LastActivity` (`LastActivity`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Users`
--

INSERT INTO `[[dbprefix]]Users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', [[timestamp]], 'admin@localhost', NULL, 'admin@localhost', NULL, NULL, NULL, NULL, NULL, [[timestamp]], 0, [[timestamp]], [[timestamp]], NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, 99, -1, NULL, -1, -1, -1, NULL, NULL);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
