<?php
// Unclassified NewsBoard
// Copyright 2003-5 by Yves Goergen
// Homepage: http://newsboard.unclassified.de
// See docs/license.txt for distribution/license details
//
// install.php
// Standard database installation

// Disable this file in productive environment!
if (file_exists('lock.conf')) die('The board setup is locked. Remove the file lock.conf to unlock it.');

// -------------------- BEGIN config area --------------------

// Debug mode string. Anything with a + in front of it will be enabled
// See forum.php for details.
$DEBUG = '+htmltype +showerrors';

// UNB's lib path where common.lib.php is located
// If your board's library path is somewhere else or you change it here, you
//   also need to update it in the framework page library's include statement.
// Don't forget the trailing slash!
$UNB['LibraryPath'] = 'unb_lib/';

// -------------------- END config area --------------------

// Prepare debug mode string
$DEBUG = ' ' . strtolower($DEBUG) . ' ';

define('ERR_REPORT_SET', 1);    // [nodoc]
define('DISPLAY_ERR_SET', 1);   // [nodoc]

// We don't want E_NOTICE output here!
error_reporting(E_ALL & ~E_NOTICE);

// Uncomment this line to suppress *any* error messages generated by PHP.
// Error messages may contain full pathnames and should therefore not be displayed
// in a productive environment. Errors are still logged to the log file, if this
// is enabled in your PHP configuration (default).
if (strstr($DEBUG, ' +showerrors '))
	@ini_set('display_errors', 1);
else
	@ini_set('display_errors', 0);

// This define is necessary so that the included files and libraries know they're
// running in a safe environment and cannot be called directly. If you require some
// of UNB's libraries in your own pages, you must also include this line.
define('UNB_RUNNING', 1);   // [nodoc]

$error = '';

// See if we have a config file and try to create one from the distribution file
$conf_filename = 'board.conf.php';
if ((!@file_exists($conf_filename) || @filesize($conf_filename) < 100) &&
	@file_exists($conf_filename . '.example'))
{
	if (!@copy($conf_filename . '.example', $conf_filename))
	{
		die('<br /><b>UNB error:</b> You have insufficient file access rights set for this PHP script. Please ensure the board can write to files in this directory. If you have any questions, please refer to the <a href="http://newsboard.unclassified.de/docs/install#steps">installation guide</a>.');
	}
}

// Import request variables
$step = intval($_REQUEST['step']);
if (!$step) $step = 1;
if ($step < 1 || $step > 4) die('Invalid step parameter');

// we don't have/need a database connection in the first steps
$UNB['NoDb'] = ($step < 3);

$UNB['Installing'] = true;
require_once($UNB['LibraryPath'] . 'common.lib.php');
$UNB['ThisPage'] = 'install.php';

require_once($UNB['LibraryPath'] . 'common_out.lib.php');
UnbRequireTxt('install');

$type = intval($_REQUEST['SetupType']);

// Guests' language selection
//
if (isset($_GET['set_lang']))
{
	if ($_GET['set_lang'] != '')
	{
		setcookie('UnbPrefLanguage', $_GET['set_lang'], time() + 3600 * 24 * 365);
	}
	else
	{
		setcookie('UnbPrefLanguage');
		unset($UnbPrefLanguage);
	}
	$_SESSION['UnbPrefLanguage'] = $_GET['set_lang'];
	UnbForwardHTML(UnbLink('@this'));
}

// Step 2 has to be done before the page is displayed because it writes the configuration file
// -- not for uninstallation
//
if ($step == 2)
{
	$UNB['ConfigFile']['forum_title'] = $_POST['ForumTitle'];

	// ----- BEGIN copy from form below -----
	$home_url = rc('home_url');
	if (!$home_url)
	{
		// auto-determine self-URL
		$port = $_SERVER['SERVER_PORT'];
		$http = ($port == 443 ? 'https://' : 'http://');
		if ($port != 80 && $port != 443)
			$port = ':' . $port;
		else
			$port = '';

		$home_url = $http . $_SERVER['SERVER_NAME'] . $port . $_SERVER['REQUEST_URI'];

		// cut $UNB['ThisPage'] from the end
		$pi = pathinfo($_SERVER['PHP_SELF']);
		if ($pos = strpos($home_url, $pi['basename']))
		{
			$home_url = substr($home_url, 0, $pos);
		}

		// add slash
		if (substr($home_url, -1) != '/') $home_url .= '/';
	}
	// ----- END copy -----
	#$UNB['ConfigFile']['home_url'] = $_POST['HomeURL'];
	$UNB['ConfigFile']['home_url'] = $home_url;

	$UNB['ConfigFile']['db_server'] = $_POST['DbServer'];
	$UNB['ConfigFile']['db_user'] = $_POST['DbUser'];
	if (($_POST['DbPass'] == '' || trim($_POST['DbPass']) != '')) $UNB['ConfigFile']['db_pass'] = 'b64:' . base64_encode($_POST['DbPass']);
	$UNB['ConfigFile']['db_name'] = $_POST['DbName'];
	$UNB['ConfigFile']['db_prefix'] = $_POST['DbPrefix'];

	#$UNB['ConfigFile']['prog_id'] = $_POST['ProgID'];
	if (rc('prog_id') == 'unb1')
		$UNB['ConfigFile']['prog_id'] = 'unb' . rand(100, 999);

	// Auto-setup current local timezone (with DST correction)
	$UNB['ConfigFile']['tz_offset'] = intval(date('Z')) / 3600 * 4;
	if (date('I')) $UNB['ConfigFile']['tz_offset'] -= 4;

	// Determine Apache mod_rewrite presence and enable short URLs
	if ($_REQUEST['mod_rewrite'] == 1)
		$UNB['ConfigFile']['mod_rewrite_urls'] = 1;

	if (!function_exists('imagejpeg') && !function_exists('imagepng'))
		$UNB['ConfigFile']['use_veriword'] = 0;

	// Store language
	$UNB['ConfigFile']['def_lang'] = $UNB['Lang'];

	// Determine client timezone
	if (isset($_POST['timezone']) && $_POST['timezone'] != '' && is_numeric($_POST['timezone']))
	{
		$UNB['ConfigFile']['tz_offset'] = intval(intval($_POST['timezone']) / 15);
		$UNB['ConfigFile']['tz_dst'] = 0;   // NOTE: JavaScript cannot detect if DST is in effect
	}

	if ($type == 1 ||   // NEW INSTALL
	    $type == 2 ||   // UPGRADE
	    $type == 3)     // IMPORT
	{
		$fwd = true;
	}
	else
	{
		$fwd = false;
	}

	// Stop installation process here and go back to the first page,
	// if we don't already know that we cannot write to files on disk
	if (!UnbRebuildConffile())
	{
		$error .= $UNB_T['error.write conffile'];
		$step = 1;
	}
	else if ($fwd)
	{
		UnbForwardHTML(UnbLink('@this', 'step=3&SetupType=' . $type));
	}
}

// -------------------- BEGIN page --------------------

UnbRequireCss('register');   // this stylesheet also includes installation styles

UnbBeginHTML($UNB_T['installation']);
UteShowAll();

if ($error)
{
	echo '<div class="error"><div>' . $error . '</div></div>';
}

if ($step == 1)
{
	// Check file access
	if (!($fp1 = @fopen($conf_filename, 'a')))
	{
		echo '<div class="p error"><div>' . $UNB_T['inst.warn nowrite'] . '</div></div>';
		UnbEndHTML();
		exit();
	}
	@fclose($fp1);
	@unlink($conf_tempname);

	echo UnbSelectLangBox();

	echo '<form action="' . UnbLink('@this', 'step=2', true) . '" method="post">';
	if ($_REQUEST['mod_rewrite'] == 1)
		echo '<input type="hidden" name="mod_rewrite" value="1" />';

	echo '<h1>' . $UNB_T['inst.welcome'] . '</h1>';

	echo '<div class="p">' . $UNB_T['inst.assistant'] . '</div>';

	echo '<div class="p">';
	echo '<table cellspacing="0" cellpadding="0" width="100%" class="installation">';

	$guessType = 0;
	if (!rc('db_user')) $guessType = 1;   // no DB username set -> guess new installation
	if (rc('db_user')) $guessType = 2;

	echo '<tr><td class="leftcol">' . $UNB_T['inst.type'] . ':</td>';
	echo '<td><label><input type="radio" name="SetupType" value="1"' . ($guessType == 1 ? ' checked="checked"' : '') . ' />' . $UNB_T['inst.type.new'] . '</label>';
	echo '<div class="subtitle_indent">' . $UNB_T['inst.type.new~'] . '</div></td></tr>';

	echo '<tr><td class="leftcol"></td>';
	echo '<td><label><input type="radio" name="SetupType" value="2"' . ($guessType == 2 ? ' checked="checked"' : '') . ' />' . $UNB_T['inst.type.update'] . '</label>';
	echo '<div class="subtitle_indent">' . $UNB_T['inst.type.update~'] . '</div></td></tr>';

	echo '<tr><td class="leftcol"></td>';
	echo '<td><label><input type="radio" name="SetupType" value="3"' . ($guessType == 3 ? ' checked="checked"' : '') . ' />' . $UNB_T['inst.type.import'] . '</label>';
	echo '<div class="subtitle_indent">' . $UNB_T['inst.type.import~'] . '</div></td></tr>';

	echo '<tr><td class="leftcol"></td>';
	echo '<td><label><input type="radio" name="SetupType" value="9"' . ($guessType == 9 ? ' checked="checked"' : '') . ' />' . $UNB_T['inst.type.uninstall'] . '</label>';
	echo '<div class="subtitle_indent">' . $UNB_T['inst.type.uninstall~'] . '</div></td></tr>';

	echo '<tr><td class="leftcol">' . $UNB_T['inst.board title'] . ':</td>';
	echo '<td><input type="text" name="ForumTitle" value="' . t2i(rc('forum_title')) . '" size="60" maxlength="100" style="width: 40em;" />';
	echo '<div class="subtitle">' . $UNB_T['inst.board title~'] . '</div></td></tr>';

/*
	$home_url = rc('home_url');
	if (!$home_url)
	{
		// auto-determine self-URL
		$port = $_SERVER['SERVER_PORT'];
		$http = ($port == 443 ? 'https://' : 'http://');
		if ($port != 80 && $port != 443)
			$port = ':' . $port;
		else
			$port = '';

		$home_url = $http . $_SERVER['SERVER_NAME'] . $port . $_SERVER['REQUEST_URI'];

		// cut $UNB['ThisPage'] from the end
		$pi = pathinfo($_SERVER['PHP_SELF']);
		if ($pos = strpos($home_url, $pi['basename']))
		{
			$home_url = substr($home_url, 0, $pos);
		}
	}
	echo '<tr><td class="leftcol">' . $UNB_T['home_url'] . ':</td>';
	echo '<td><input type="text" name="HomeURL" value="' . t2i($home_url) . '" size="60" maxlength="150" style="width: 40em;" /></td></tr>';
*/

	echo '<tr><td class="leftcol">' . $UNB_T['inst.db server'] . ':</td>';
	echo '<td><input type="text" name="DbServer" value="' . t2i(rc('db_server')) . '" size="40" maxlength="100" style="width: 20em;" /></td></tr>';

	echo '<tr><td class="leftcol">' . $UNB_T['inst.db user'] . ':</td>';
	echo '<td><input type="text" name="DbUser" value="' . t2i(rc('db_user')) . '" size="40" maxlength="40" style="width: 20em;" /></td></tr>';

	echo '<tr><td class="leftcol">' . $UNB_T['inst.db pass'] . ':</td>';
	echo '<td><input type="password" name="DbPass" value="' . (rc('db_pass') != '' ? '          ' : '') . '" size="40" maxlength="40" style="width: 20em;" /></td></tr>';

	echo '<tr><td class="leftcol">' . $UNB_T['inst.db name'] . ':</td>';
	echo '<td><input type="text" name="DbName" value="' . t2i(rc('db_name')) . '" size="40" maxlength="40" style="width: 20em;" /></td></tr>';

	echo '<tr><td class="leftcol">' . $UNB_T['inst.db prefix'] . ':</td>';
	echo '<td><input type="text" name="DbPrefix" value="' . t2i(rc('db_prefix')) . '" size="40" maxlength="40" style="width: 20em;" />';
	echo '<div class="subtitle">' . $UNB_T['inst.db prefix~'] . '</div></td></tr>';
	echo '</table>';

	echo '<div style="margin: 12px 0 20px; text-align: center;">';
	echo '<input type="submit" class="button" value="' . $UNB_T['inst.continue'] . '" />';
	echo '</div>';
	echo '</div>';

	echo '<input type="hidden" name="timezone" id="timezone" value="" />' . endl;
	echo '<script type="text/javascript">//<![CDATA[' . endl;
	echo 'getel("timezone").value = fetchTimezone();' . endl;
	echo '//]]></script>' . endl;

	echo '</form>';
}

if ($step == 2)
{
	if ($type == 9)   // UNINSTALL
	{
		echo '<div class="p"><b><a href="' . UnbLink('@this', 'step=3&SetupType=9', true) . '">' . $UNB_T['uninst.sure'] . '</a></b><br />';
		echo $UNB_T['uninst~'] . '</div>';

		echo '<div class="p">' . $UNB_T['uninst.summary'] . '<br />';
		echo $UNB_T['inst.db server'] . ': ' . t2h(rc('db_server')) . '<br />';
		echo $UNB_T['inst.db user'] . ': ' . t2h(rc('db_user')) . '<br />';
		echo $UNB_T['inst.db name'] . ': ' . t2h(rc('db_name')) . '<br />';
		echo $UNB_T['inst.db prefix'] . ': ' . t2h(rc('db_prefix')) . '</div>';
	}
}

if ($step == 3)
{
	if ($type == 1)   // NEW INSTALL
	{
		echo '<h1>' . $UNB_T['installation'] . '</h1>';

		echo '<div class="p">';
		echo $UNB_T['inst.create tables'] . '<br />';

		// ------------------------------------------------------------ FORUMS

		$UNB['Db']->RemoveTable('Forums') or die('remove error: ' . $UNB['Db']->LastError());
		$UNB['Db']->CreateTable('Forums',
						 '`ID` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Sort` INT, ' .
						 '`Parent` INT UNSIGNED, ' .
						 '`Name` VARCHAR(100), ' .
						 '`Flags` INT, ' .
						 '`Description` TEXT, ' .
						 '`Link` VARCHAR(255), ' .
						 'PRIMARY KEY (ID)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ THREADS

		$UNB['Db']->RemoveTable('Threads') or die('remove error');
		$UNB['Db']->CreateTable('Threads',
						 '`ID` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Forum` INT UNSIGNED, ' .
						 '`LastPostDate` INT, ' .
						 '`Subject` VARCHAR(150), ' .
						 '`Desc` VARCHAR(150), ' .
						 '`Date` INT, ' .
						 '`User` INT UNSIGNED, ' .
						 '`UserName` VARCHAR(40), ' .
						 '`Views` INT UNSIGNED, ' .
						 '`Options` INT UNSIGNED, ' .
						 '`Question` VARCHAR(150), ' .
						 '`PollTimeout` INT, ' .
						 '`LastVoted` INT, ' .
						 'PRIMARY KEY (ID),' .
						 'KEY LastPostDate (LastPostDate)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ POSTS

		$UNB['Db']->RemoveTable('Posts') or die('remove error');
		$UNB['Db']->CreateTable('Posts',
						 '`ID` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Thread` INT UNSIGNED, ' .
						 '`ReplyTo` INT UNSIGNED, ' .
						 '`Date` INT, ' .
						 '`EditUser` INT UNSIGNED, ' .
						 '`EditDate` INT, ' .
						 '`EditCount` SMALLINT UNSIGNED, ' .
						 '`EditReason` VARCHAR(255), ' .
						 '`User` INT UNSIGNED, ' .
						 '`UserName` VARCHAR(40), ' .
						 '`Subject` VARCHAR(150), ' .
						 '`Msg` TEXT, ' .
						 '`Options` INT UNSIGNED, ' .
						 '`AttachFile` VARCHAR(40), ' .
						 '`AttachFileName` VARCHAR(100), ' .
						 '`AttachDLCount` INT UNSIGNED, ' .
						 '`IP` VARCHAR(15), ' .
						 '`Hostname` VARCHAR(150), ' .
						 '`SpamRating` INT, ' .
						 'PRIMARY KEY (ID), ' .
						 'KEY Thread (Thread), ' .
						 'KEY Date (Date), ' .
						 'KEY User (User)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ USERS

		$extra = '';
		for ($n = 1; $n <= $UNB['ProfileExtraCount']; $n++)
		{
			$extra .= '`Extra' . $n . '` VARCHAR(255), ';
		}

		$UNB['Db']->RemoveTable('Users') or die('remove error');
		$UNB['Db']->CreateTable('Users',
						 '`ID` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Name` VARCHAR(40), ' .
						 '`Password` VARCHAR(200), ' .
						 '`RegDate` INT, ' .
						 '`ValidatedEMail` VARCHAR(100), ' .
						 '`DefaultNotify` TINYINT UNSIGNED, ' .
						 '`EMail` VARCHAR(100), ' .
						 '`Jabber` VARCHAR(50), ' .
						 '`ICQ` VARCHAR(15), ' .
						 '`AIM` VARCHAR(30), ' .
						 '`YIM` VARCHAR(30), ' .
						 '`MSN` VARCHAR(50), ' .
						 '`LastActivity` INT, ' .
						 '`LastForum` INT, ' .
						 '`LastLogin` INT, ' .
						 '`LastLogout` INT, ' .
						 '`Signature` TEXT, ' .
						 '`BirthDay` TINYINT UNSIGNED, ' .
						 '`BirthMonth` TINYINT UNSIGNED, ' .
						 '`BirthYear` SMALLINT UNSIGNED, ' .
						 '`About` TEXT, ' .
						 '`Title` VARCHAR(40), ' .
						 '`Location` VARCHAR(50), ' .
						 '`Homepage` VARCHAR(150), ' .
						 '`Gender` CHAR(1), ' .
						 '`Avatar` VARCHAR(150), ' .
						 '`AvatarX` SMALLINT, ' .
						 '`AvatarY` SMALLINT, ' .
						 '`Photo` VARCHAR(150), ' .
						 $extra .
						 '`ValidateKey` VARCHAR(50), ' .
						 '`RecommendedBy` INT UNSIGNED, ' .
						 '`Design` VARCHAR(50), ' .
						 '`Flags` INT UNSIGNED, ' .
						 '`Timezone` TINYINT DEFAULT 99, ' .
						 '`TimezoneDS` TINYINT DEFAULT -1, ' .
						 '`EditControls` INT UNSIGNED, ' .
						 '`ThreadsPerPage` SMALLINT DEFAULT -1, ' .
						 '`ThreadSort` SMALLINT DEFAULT -1, ' .
						 '`ThreadTime` SMALLINT DEFAULT -1, ' .
						 '`Language` VARCHAR(6), ' .
						 '`DateFormat` VARCHAR(20), ' .
						 'PRIMARY KEY (ID),' .
						 'KEY LastActivity (LastActivity)'
			) or die('create error: ' . $UNB['Db']->LastError());

		$UNB['Db']->SetTable('Users');
		$UNB['Db']->AddRecord(array('ID' => 1,
							 'Name' => 'Admin',
							 'Password' => UnbCreateUserPassword('admin'),
							 'RegDate' => time(),
							 'ValidatedEMail' => 'admin@localhost',
							 'EMail' => 'admin@localhost',
							 'LastActivity' => time(),
							 'Flags' => UNB_USER_AUTOLOGIN
			)) or die('add error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ POLL VOTES

		$UNB['Db']->RemoveTable('PollVotes') or die('remove error');
		$UNB['Db']->CreateTable('PollVotes',
						 '`ID` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Thread` INT UNSIGNED, ' .
						 '`Sort` TINYINT, ' .
						 '`Title` VARCHAR(100), ' .
						 '`Votes` INT UNSIGNED, ' .
						 'PRIMARY KEY (ID)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ POLL USERS

		$UNB['Db']->RemoveTable('PollUsers') or die('remove error');
		$UNB['Db']->CreateTable('PollUsers',
						 '`Thread` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`User` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`VoteNum` INT UNSIGNED, ' .
						 'PRIMARY KEY (Thread, User)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ ANNOUNCES

		$UNB['Db']->RemoveTable('Announces') or die('remove error');
		$UNB['Db']->CreateTable('Announces',
						 '`ID` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Forum` INT, ' .
						 '`Date` INT, ' .
						 '`User` INT UNSIGNED, ' .
						 '`Subject` VARCHAR(150), ' .
						 '`Msg` TEXT, ' .
						 '`Options` INT UNSIGNED, ' .
						 'PRIMARY KEY (ID)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ ANNOUNCEMENT READ

		$UNB['Db']->RemoveTable('AnnounceRead') or die('remove error');
		$UNB['Db']->CreateTable('AnnounceRead',
						 '`Announce` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`User` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 'PRIMARY KEY (Announce, User)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ THREAD WATCH

		$UNB['Db']->RemoveTable('ThreadWatch') or die('remove error');
		$UNB['Db']->CreateTable('ThreadWatch',
						 '`Thread` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`User` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Mode` TINYINT UNSIGNED, ' .
						 '`LastRead` INT NOT NULL DEFAULT 0, ' .
						 '`LastNotify` INT NOT NULL DEFAULT 0, ' .
						 '`LastViewed` INT NOT NULL DEFAULT 0, ' .
						 'PRIMARY KEY (Thread, User), ' .
						 'KEY Thread (Thread), ' .
						 'KEY User (User)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ FORUM WATCH

		$UNB['Db']->RemoveTable('ForumWatch') or die('remove error');
		$UNB['Db']->CreateTable('ForumWatch',
						 '`Forum` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`User` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Mode` TINYINT UNSIGNED, ' .
						 '`Flags` TINYINT UNSIGNED, ' .
						 '`LastVisited` INT NOT NULL DEFAULT 0, ' .
						 '`LastNotify` INT NOT NULL DEFAULT 0, ' .
						 'PRIMARY KEY (Forum, User), ' .
						 'KEY Forum (Forum), ' .
						 'KEY User (User)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ USER FORUM FLAGS

		$UNB['Db']->RemoveTable('UserForumFlags') or die('remove error');
		$UNB['Db']->CreateTable('UserForumFlags',
						 '`User` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Forum` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Thread` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Flags` TINYINT UNSIGNED, ' .
						 'PRIMARY KEY (User, Forum, Thread)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ ONLINE GUESTS

		$UNB['Db']->RemoveTable('Guests') or die('remove error');
		$UNB['Db']->CreateTable('Guests',
						 '`Session` VARCHAR(80), ' .
						 '`LastActivity` INT, ' .
						 '`LastForum` INT, ' .
						 '`UserName` VARCHAR(40)'
			) or die('create error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ STATISTICS

		$UNB['Db']->RemoveTable('Stat') or die('remove error');
		$UNB['Db']->CreateTable('Stat',
						 '`Date` INT NOT NULL DEFAULT 0, ' .
						 '`NewThreads` INT NOT NULL DEFAULT 0, ' .
						 '`NewPosts` INT NOT NULL DEFAULT 0, ' .
						 '`OnlineUsers` INT NOT NULL DEFAULT 0, ' .
						 '`OnlineGuests` INT NOT NULL DEFAULT 0, ' .
						 '`PageHits` INT NOT NULL DEFAULT 0, ' .
						 '`NewUsers` INT NOT NULL DEFAULT 0, ' .
						 'PRIMARY KEY (Date)'
			) or die('create error: ' . $UNB['Db']->LastError());

		$last_0h = getdate(UnbConvertTimezone(time()));
		$last_0h = gmmktime(0, 0, 0, $last_0h['mon'], $last_0h['mday'], $last_0h['year']);

		$UNB['Db']->SetTable('Stat');
		$UNB['Db']->AddRecord(array('Date' => $last_0h,
							 'NewThreads' => 0,
							 'NewPosts' => 0,
							 'OnlineUsers' => 0,
							 'OnlineGuests' => 0,
							 'PageHits' => 0,
							 'NewUsers' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ ACL

		$UNB['Db']->RemoveTable('ACL') or die('remove error');
		$UNB['Db']->CreateTable('ACL',
						 '`ID` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`User` INT UNSIGNED, ' .
						 '`Group` INT UNSIGNED, ' .
						 '`Action` SMALLINT UNSIGNED, ' .
						 '`Thread` INT UNSIGNED, ' .
						 '`Forum` INT UNSIGNED, ' .
						 '`Grant` INT, ' .
						 '`Enabled` BOOL, ' .
						 'PRIMARY KEY (ID), ' .
						 'UNIQUE INDEX (User, `Group`, Action, Thread, Forum)'
			) or die('create error: ' . $UNB['Db']->LastError());

		$UNB['Db']->SetTable('ACL');
		$UNB['Db']->AddRecord(array('ID' => 1,
							 'User' => 0,
							 'Group' => UNB_GROUP_GUESTS,
							 'Action' => 33,   // viewforum
							 'Thread' => 0,
							 'Forum' => 0,
							 'Grant' => 1,
							 'Enabled' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());
		$UNB['Db']->AddRecord(array('ID' => 2,
							 'User' => 0,
							 'Group' => UNB_GROUP_MEMBERS,
							 'Action' => 82,   // user rights
							 'Thread' => 0,
							 'Forum' => 0,
							 'Grant' => 1,
							 'Enabled' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());
		$UNB['Db']->AddRecord(array('ID' => 3,
							 'User' => 0,
							 'Group' => UNB_GROUP_MODS,
							 'Action' => 83,   // mod rights
							 'Thread' => 0,
							 'Forum' => 0,
							 'Grant' => 1,
							 'Enabled' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());
		$UNB['Db']->AddRecord(array('ID' => 4,
							 'User' => 0,
							 'Group' => UNB_GROUP_ADMINS,
							 'Action' => 84,   // admin rights
							 'Thread' => 0,
							 'Forum' => 0,
							 'Grant' => 1,
							 'Enabled' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ GROUP MEMBERS

		$UNB['Db']->RemoveTable('GroupMembers') or die('remove error');
		$UNB['Db']->CreateTable('GroupMembers',
						 '`Group` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`User` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 'PRIMARY KEY (`Group`, User)'
			) or die('create error: ' . $UNB['Db']->LastError());

		$UNB['Db']->SetTable('GroupMembers');
		$UNB['Db']->AddRecord(array('Group' => UNB_GROUP_MEMBERS,
							 'User' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());
		$UNB['Db']->AddRecord(array('Group' => UNB_GROUP_ADMINS,
							 'User' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());

		// ------------------------------------------------------------ GROUP NAMES

		$UNB['Db']->RemoveTable('GroupNames') or die('remove error');
		$UNB['Db']->CreateTable('GroupNames',
						 '`ID` INT UNSIGNED NOT NULL DEFAULT 0, ' .
						 '`Name` VARCHAR(50), ' .
						 '`ShowInTeam` TINYINT(1), ' .
						 '`PublicGroup` TINYINT(1), ' .
						 'PRIMARY KEY (ID)'
			) or die('create error: ' . $UNB['Db']->LastError());

		$UNB['Db']->SetTable('GroupNames');
		$UNB['Db']->AddRecord(array('ID' => UNB_GROUP_GUESTS,
							 'Name' => $UNB_T['inst.grp guests'],
							 'ShowInTeam' => 0
			)) or die('add error: ' . $UNB['Db']->LastError());
		$UNB['Db']->AddRecord(array('ID' => UNB_GROUP_MEMBERS,
							 'Name' => $UNB_T['inst.grp users'],
							 'ShowInTeam' => 0
			)) or die('add error: ' . $UNB['Db']->LastError());
		$UNB['Db']->AddRecord(array('ID' => UNB_GROUP_MODS,
							 'Name' => $UNB_T['inst.grp gmods'],
							 'ShowInTeam' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());
		$UNB['Db']->AddRecord(array('ID' => UNB_GROUP_ADMINS,
							 'Name' => $UNB_T['inst.grp admins'],
							 'ShowInTeam' => 1
			)) or die('add error: ' . $UNB['Db']->LastError());

		// remember the current version-time so we can notify about a necessary upgrade later
		$UNB['ConfigFile']['last_upgrade_version_time'] = $UNB['VersionTime'];
		if (!UnbRebuildConffile()) die($UNB_T['error.write conffile']);

		echo $UNB_T['inst.login'] . '<br />';

		$user = new IUser;
		if ($userid = $user->FindByName('Admin'))
		{
			// TODO: replace md5 call by something determined by UnbCreateUserPassword as required
			//       for a "half-hashed" password string
			if (UnbCreateSession($userid, md5('admin'), $user->GetPassword(), $user->GetFlags() & 32))
			{
				$user->SetLastLogin();
			}
		}

		echo '<b>' . $UNB_T['inst.done'] . '</b>';
		echo '</div>';

		echo '<div class="info"><div>' . $UNB_T['inst.db complete'] . '</div></div>';

		echo '<div class="p">' . $UNB_T['inst.complete~'] . '</div>';

		touch('lock.conf');
		echo '<div class="p">' . $UNB_T['inst.lock'] . '</div>';

		echo '<div class="p"><a href="' . UnbLink('@cp', 'cat=summary', true) . '">' . $UNB_T['inst.go cp'] . '</a></div>';
	} // if type = 1

	if ($type == 2)   // UPGRADE
	{
		echo '<h1>' . $UNB_T['installation'] . '</h1>';

		echo '<div class="p">';
		echo $UNB_T['inst.check db layout'] . '<br />';

		if (!$UNB['Db']->ListTableCols('Forums') &&
		    !$UNB['Db']->ListTableCols('Threads') &&
		    !$UNB['Db']->ListTableCols('Posts') &&
		    !$UNB['Db']->ListTableCols('Users'))
		{
			// No tables found! This is not a valid UNB database
			die('No UNB tables found in this database. You cannot upgrade from nothing! Please go back and select a normal installation.');
		}

		$cols = $UNB['Db']->ListTableCols('ForumWatch');
		if (!$cols)
		{
			$UNB['Db']->RemoveTable('ForumWatch') or
				UpgradeFatalDbError('remove table error');
			$UNB['Db']->CreateTable('ForumWatch',
							 '`Forum` INT UNSIGNED NOT NULL DEFAULT 0, ' .
							 '`User` INT UNSIGNED NOT NULL DEFAULT 0, ' .
							 '`Mode` TINYINT UNSIGNED, ' .
							 '`Flags` TINYINT UNSIGNED, ' .
							 '`LastVisited` INT, ' .
							 '`LastNotify` INT, ' .
							 'PRIMARY KEY (Forum, User), ' .
							 'KEY Forum (Forum), ' .
							 'KEY User (User)'
				) or
				UpgradeFatalDbError('create table error');
		}

		$cols = $UNB['Db']->ListTableCols('Forums');
		if (!$cols['Link'])
		{
			$UNB['Db']->AddField('Forums', 'Link', 'VARCHAR(255)', 'Description') or
				UpgradeFatalDbError('add column error');
		}
		if ($cols['IsCategory'])
		{
			$UNB['Db']->AddField('Forums', 'Flags', 'INT', 'Name') or
				UpgradeFatalDbError('add column error');
			$UNB['Db']->ChangeRecord(array('Flags' => 1), 'IsCategory', 'Forums') or
				UpgradeFatalDbError('update row error');
			$UNB['Db']->RemoveField('Forums', 'IsCategory') or
				UpgradeFatalDbError('remove column error');
		}
		if (stripos($cols['Description']['Type'], 'CHAR') !== false)
		{
			$UNB['Db']->ChangeField('Forums', 'Description', 'Description', 'TEXT') or
				UpgradeFatalDbError('alter column error');
		}

		$cols = $UNB['Db']->ListTableCols('Posts');
		if (stripos($cols['User']['Type'], 'UNSIGNED') !== false)
		{
			$UNB['Db']->ChangeField('Posts', 'User', 'User', 'INT') or
				UpgradeFatalDbError('alter column error');
		}

		$cols = $UNB['Db']->ListTableCols('Users');
		if (strpos($cols['Language']['Type'], '(5)') !== false)
		{
			$UNB['Db']->ChangeField('Users', 'Language', 'Language', 'VARCHAR(6)') or
				UpgradeFatalDbError('alter column error');
		}

		$cols = $UNB['Db']->ListTableCols('GroupNames');
		if (!$cols['ShowInTeam'])
		{
			$UNB['Db']->AddField('GroupNames', 'ShowInTeam', 'TINYINT(1)', 'Name') or
				UpgradeFatalDbError('add column error');
			$UNB['Db']->ChangeRecord(array('ShowInTeam' => 1), 'ID IN (2,3)', 'GroupNames') or
				UpgradeFatalDbError('update row error');
		}

		$acl = $UNB['Db']->FastQuery1st('ACL', 'COUNT(*)', 'Action IN (71,72, 73, 74)');
		if ($acl > 0)
		{
			$UNB['Db']->ChangeRecord('`Action` = `Action` + 10', 'Action IN (71,72,73,74)', 'ACL') or
				UpgradeFatalDbError('update row error');
		}

		$cols = $UNB['Db']->ListTableCols('Messages');
		if (stripos($cols['Forum']['Type'], 'UNSIGNED') !== false)
		{
			$UNB['Db']->ChangeField('Messages', 'Forum', 'Forum', 'INT') or
				UpgradeFatalDbError('alter column error');
		}

		// From version 1.5.1 on:
		$cols = $UNB['Db']->ListTableCols('ThreadWatch');
		if (!$cols['LastViewed'])
		{
			$UNB['Db']->AddField('ThreadWatch', 'LastViewed', 'INT') or
				UpgradeFatalDbError('add column error');
		}

		$cols = $UNB['Db']->ListTableCols('Guests');
		if (!$cols['UserName'])
		{
			$UNB['Db']->AddField('Guests', 'UserName', 'VARCHAR(40)') or
				UpgradeFatalDbError('add column error');
		}

		// From version 1.5.2 on:
		$cols = $UNB['Db']->ListTableCols('Stat');
		if ($cols['Date']['Key'] != 'PRI')
		{
			// First, delete any duplicate rows
			$pre = $UNB['Db']->tblprefix;
			$c = $UNB['Db']->FastQueryArray('Stat', 'Date, COUNT(*) AS cnt', '', '', '', 'Date', false, 'COUNT(*) > 1');
			if (is_array($c)) foreach ($c as $rec)
			{
				$UNB['Db']->RemoveRecord('Date=' . intval($rec['Date']), 'Stat', intval($rec['cnt']) - 1);
			}

			// Add primary index to Date column
			$UNB['Db']->AddIndex('Stat', 'PRIMARY KEY', 'Date') or
				UpgradeFatalDbError('add index error');
		}

		// From version 1.5.3 on:
		$cols = $UNB['Db']->ListTableCols('Announces');
		if (!$cols)
		{
			$UNB['Db']->RenameTable('Messages', 'Announces') or
				UpgradeFatalDbError('rename table error');
		}

		$cols = $UNB['Db']->ListTableCols('AnnounceRead');
		if (!$cols)
		{
			$UNB['Db']->RenameTable('MessageRead', 'AnnounceRead') or
				UpgradeFatalDbError('rename table error');
		}

		$cols = $UNB['Db']->ListTableCols('UserForumFlags');
		if (!$cols['Thread'])
		{
			$UNB['Db']->RenameTable('UserCategoryState', 'UserForumFlags') or
				UpgradeFatalDbError('rename table error');

			$UNB['Db']->AddField('UserForumFlags', 'Thread', 'INT UNSIGNED NOT NULL DEFAULT 0') or
				UpgradeFatalDbError('add column error');
			$UNB['Db']->ChangeField('UserForumFlags', 'State', 'Flags', 'TINYINT UNSIGNED') or
				UpgradeFatalDbError('change column error');

			$UNB['Db']->RemoveIndex('UserForumFlags') or
				UpgradeFatalDbError('remove primary index error');
			$UNB['Db']->AddIndex('UserForumFlags', 'PRIMARY KEY', array('User', 'Forum', 'Thread')) or
				UpgradeFatalDbError('add primary index error');

			// Set all user flags 128 (was: open links in new window; now: auto-ignore topics)
			#$pre = $UNB['Db']->tblprefix;
			#$UNB['Db']->ChangeRecord('Flags = Flags | 128', 'NOT (Flags & 128)', 'Users');
		}

		// From version 1.6 on:
		$cols = $UNB['Db']->ListTableCols('Users');
		if (!$cols['ValidateKey'])
		{
			$UNB['Db']->ChangeField('Users', 'ActivateKey', 'ValidateKey', 'VARCHAR(50)') or
				UpgradeFatalDbError('alter column error');
		}
		if (stripos($cols['Password']['Type'], 'varchar(200)') === false)
		{
			$UNB['Db']->ChangeField('Users', 'Password', 'Password', 'VARCHAR(200)') or
				UpgradeFatalDbError('alter column error');
		}
		if ($cols['Favourites'])
		{
			$UNB['Db']->RemoveField('Users', 'Favourites') or
				UpgradeFatalDbError('remove column error');
		}
		if (stripos($cols['Design']['Type'], 'INT') !== false)
		{
			$UNB['Db']->ChangeField('Users', 'Design', 'Design', 'VARCHAR(50)') or
				UpgradeFatalDbError('alter column error');
			$UNB['Db']->ChangeRecord("Design=''", '', 'Users');
		}

		$cols = $UNB['Db']->ListTableCols('AnnounceRead');
		if (!$cols['Announce'])
		{
			$UNB['Db']->ChangeField('AnnounceRead', 'Msg', 'Announce', 'INT UNSIGNED NOT NULL DEFAULT 0') or
				UpgradeFatalDbError('alter column error');
		}

		//$data = $UNB['Db']->FastQuery1st('ACL', '`Group`', 'Action = 82');   // If Guests have Member rights, this leads to a wrong result
		//if ($data == 1)   // default members group is still 1, insert guests group now

		// TODO: Test this
		$data = $UNB['Db']->FastQuery1st('GroupMembers', 'COUNT(*)', '`Group` = 1');
		if ($data > 0)
		{
			// Group that should be "Guests" now has members (so it must be the "Members" group actually)
			// -> insert guests group now
			$acl = $UNB['Db']->FastQueryArray('ACL', '*', '', '`Group` DESC');
			if (!is_array($acl)) UpgradeFatalDbError('update acl error (1a)');
			foreach ($acl as $rule)
				$UNB['Db']->ChangeRecord(
					'`Group` = `Group` + 1',
					'ID = \'' . UnbDbEncode($rule['ID']) . '\'',
					'ACL') or
					UpgradeFatalDbError('update acl error (1b)');

			$members = $UNB['Db']->FastQueryArray('GroupMembers', '*', '', '`Group` DESC');
			if (!is_array($members)) UpgradeFatalDbError('update acl error (2a)');
			foreach ($members as $member)
				$UNB['Db']->ChangeRecord(
					'`Group` = `Group` + 1',
					'`Group` = \'' . UnbDbEncode($member['Group']) . '\' AND User = \'' . UnbDbEncode($member['User']) . '\'',
					'GroupMembers') or
					UpgradeFatalDbError('update acl error (2b)');

			$groups = $UNB['Db']->FastQuery1stArray('GroupNames', 'ID', '', 'ID DESC');
			if (!is_array($groups)) UpgradeFatalDbError('update acl error (3a)');
			foreach ($groups as $group)
				$UNB['Db']->ChangeRecord(
					'ID = ID + 1',
					'ID = \'' . UnbDbEncode($group) . '\'',
					'GroupNames') or
					UpgradeFatalDbError('update acl error (3b)');

			$UNB['Db']->AddRecord(
				array('ID' => 1, 'Name' => $UNB_T['inst.grp guests']),
				'GroupNames') or
				UpgradeFatalDbError('update acl error (4)');
		}

		$data = $UNB['Db']->FastQuery1st('Threads', 'MAX(PollTimeout) AS MaxTimeout');
		if ($data > 100000)
		{
			// Convert poll timeout data from absolute timestamps to number of hours

			// for each thread where options = (poll and not moved) and polltimeout > 100000:
			//   set polltimeout = (polltimeout - date) / 3600
			// for each thread where options = (moved) and polltimeout > 100000:
			//   set polltimeout = (polltimeout - lastpostdate) / 3600

			$UNB['Db']->ChangeRecord(
				'PollTimeout = (PollTimeout - Date) / 3600',
				'(Options & ' . UNB_THREAD_POLL . ') AND NOT (Options & ' . UNB_THREAD_MOVED . ') AND PollTimeout > 100000',
				'Threads') or
				UpgradeFatalDbError('update poll timeout error (1)');
			$UNB['Db']->ChangeRecord(
				'PollTimeout = (PollTimeout - LastPostDate) / 3600',
				'(Options & ' . UNB_THREAD_MOVED . ') AND PollTimeout > 100000',
				'Threads') or
				UpgradeFatalDbError('update poll timeout error (2)');
		}

		$cols = $UNB['Db']->ListTableCols('Posts');
		if (!$cols['EditReason'])
		{
			$UNB['Db']->AddField('Posts', 'EditReason', 'VARCHAR(255)') or
				UpgradeFatalDbError('add column error');
		}

		// 1.6.3
		$cols = $UNB['Db']->ListTableCols('GroupNames');
		if (!$cols['PublicGroup'])
		{
			$UNB['Db']->AddField('GroupNames', 'PublicGroup', 'TINYINT(1)') or
				UpgradeFatalDbError('add column error');
		}

		// 1.6.5
		$cols = $UNB['Db']->ListTableCols('Users');
		if ($cols['RegEMail'])
		{
			$UNB['Db']->ChangeField('Users', 'RegEMail', 'ValidatedEMail', 'VARCHAR(100)') or
				UpgradeFatalDbError('alter column error');
			$UNB['Db']->ChangeRecord(
				'ValidatedEMail = EMail',
				'',
				'Users') or
				UpgradeFatalDbError('update validated e-mail error (2)');
		}

		// Added config options
		if (!rc('toplogo_url')) $UNB['ConfigFile']['toplogo_url'] = '';
		if (!rc('use_php_mail')) $UNB['ConfigFile']['use_php_mail'] = '0';
		if (!rc('smileset')) $UNB['ConfigFile']['smileset'] = 'unb';
		#if (!rc('plug_path')) $UNB['ConfigFile']['plug_path'] = 'unb_plugins/';
		if (!rc('online_users_reload_interval')) $UNB['ConfigFile']['online_users_reload_interval'] = '10000';
		if (!rc('allow_remote_avatars')) $UNB['ConfigFile']['allow_remote_avatars'] = '1';
		if (!rc('post_attach_inline_maxsize')) $UNB['ConfigFile']['post_attach_inline_maxsize'] = '51200';
		if (!rc('post_attach_inline_maxwidth')) $UNB['ConfigFile']['post_attach_inline_maxwidth'] = '750';
		if (!rc('post_attach_inline_maxheight')) $UNB['ConfigFile']['post_attach_inline_maxheight'] = '500';
		if (!rc('auto_ban_flood_ip')) $UNB['ConfigFile']['auto_ban_flood_ip'] = '1';
		if (!rc('auto_ban_flood_ip_period')) $UNB['ConfigFile']['auto_ban_flood_ip_period'] = '60';
		if (!rc('auto_ban_flood_ip_threshold')) $UNB['ConfigFile']['auto_ban_flood_ip_threshold'] = '30';
		// Version 1.6:
		if (rc('design_list')) $UNB['ConfigFile']['design_list'] = null;
		if (rc('design_textonly')) $UNB['ConfigFile']['design_textonly'] = null;
		if (is_numeric(rc('design')))
		{
			$UNB['ConfigFile']['design'] = 'modern';
			$UNB['ConfigFile']['login_top'] = 0;
			$UNB['ConfigFile']['advanced_thread_counter'] = 0;
		}
		if (rc('new_layout')) $UNB['ConfigFile']['new_layout'] = null;
		if (rc('small_layout')) $UNB['ConfigFile']['small_layout'] = null;
		if (rc('show_utitle')) $UNB['ConfigFile']['show_utitle'] = null;
		if (rc('show_uinfo_regdate')) $UNB['ConfigFile']['show_uinfo_regdate'] = null;
		if (rc('show_uinfo_posts')) $UNB['ConfigFile']['show_uinfo_posts'] = null;
		if (rc('show_uinfo_location')) $UNB['ConfigFile']['show_uinfo_location'] = null;
		if (rc('ulist_contact')) $UNB['ConfigFile']['ulist_contact'] = null;
		if (rc('post_use_rcol')) $UNB['ConfigFile']['post_use_rcol'] = null;
		if (rc('smilies')) $UNB['ConfigFile']['smilies'] = null;
		if (rc('smilie_cols')) $UNB['ConfigFile']['smilie_cols'] = null;
		if (rc('smilie_rows')) $UNB['ConfigFile']['smilie_rows'] = null;
		if (rc('special_chars')) $UNB['ConfigFile']['special_chars'] = null;
		if (rc('special_cols')) $UNB['ConfigFile']['special_cols'] = null;
		if (rc('special_rows')) $UNB['ConfigFile']['special_rows'] = null;
		if (rc('design_path')) $UNB['ConfigFile']['design_path'] = null;
		if (rc('avatar_path')) $UNB['ConfigFile']['avatar_path'] = null;
		if (rc('photo_path')) $UNB['ConfigFile']['photo_path'] = null;
		if (rc('attach_path')) $UNB['ConfigFile']['attach_path'] = null;
		if (rc('plug_path')) $UNB['ConfigFile']['plug_path'] = null;
		if (!rc('lib_url')) $UNB['ConfigFile']['lib_url'] = $UNB['ConfigFile']['lib_path'];
		if (rc('indep_file') || !rc('basefile'))
		{
			$UNB['ConfigFile']['basefile'] = $UNB['ConfigFile']['indep_file'];
			$UNB['ConfigFile']['indep_file'] = null;
		}
		if (!rc('baseurl')) $UNB['ConfigFile']['baseurl'] = $UNB['ConfigFile']['basefile'];
		if (rc('nowrite')) $UNB['ConfigFile']['nowrite'] = null;

		// remember the current version-time so we can notify about a necessary upgrade later
		$UNB['ConfigFile']['last_upgrade_version_time'] = $UNB['VersionTime'];
		if (!UnbRebuildConffile()) die($UNB_T['error.write conffile']);

		echo '<b>' . $UNB_T['inst.done'] . '</b>';
		echo '</div>';

		touch('lock.conf');
		echo '<div class="p">' . $UNB_T['inst.upgrade~'] . '</div>';
		echo '<div class="p">' . $UNB_T['inst.lock'] . '</div>';

		echo '<div class="p"><a href="' . UnbLink('@cp', 'cat=summary', true) . '">' . $UNB_T['inst.go cp'] . '</a></div>';
	} // if type = 2

	if ($type == 3)   // IMPORT
	{
		echo '<h1>' . $UNB_T['installation'] . '</h1>';

		echo '<div class="p">' . $UNB_T['inst.import~'] . '</div>';

		// scan local import module files
		$modules = array();
		$handle = @opendir('.');
		if ($handle !== false)
		{
			while ($file = readdir($handle))
				if (preg_match('/^import_[A-Za-z0-9\-]+\.php$/', $file))
				{
					$lines = file($file);
					foreach ($lines as $line)
					{
						if (preg_match('~^\s*//\s*TYPE:\s*(.*)$~i', $line, $m))
						{
							$modules[] = array('file' => $file, 'type' => trim($m[1]));
							break;
						}
					}
				}
			closedir($handle);
		}

		echo '<div class="p">';
		if ($modules)
		{
			foreach ($modules as $mod)
			{
				echo '<a href="' . UnbLink($mod['file'], null, true) . '">' . t2h($mod['type']) . '</a><br />';
			}
		}
		else
		{
			echo $UNB_T['inst.import.not found'];
		}
		echo '</div>';
	} // if type = 3

	if ($type == 9)   // UNINSTALL
	{
		echo '<h1>' . $UNB_T['uninstallation'] . '</h1>';

		echo '<div class="p">';

		echo $UNB_T['uninst.remove table'] . ': Forums<br />';
		if (!$UNB['Db']->RemoveTable('Forums')) echo 'remove error: ' . $UNB['Db']->LastError();

		echo $UNB_T['uninst.remove table'] . ': Threads<br />';
		if (!$UNB['Db']->RemoveTable('Threads')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': Posts<br />';
		if (!$UNB['Db']->RemoveTable('Posts')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': Users<br />';
		if (!$UNB['Db']->RemoveTable('Users')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': PollVotes<br />';
		if (!$UNB['Db']->RemoveTable('PollVotes')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': PollUsers<br />';
		if (!$UNB['Db']->RemoveTable('PollUsers')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': Announces<br />';
		if (!$UNB['Db']->RemoveTable('Announces')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': AnnounceRead<br />';
		if (!$UNB['Db']->RemoveTable('AnnounceRead')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': ThreadWatch<br />';
		if (!$UNB['Db']->RemoveTable('ThreadWatch')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': ForumWatch<br />';
		if (!$UNB['Db']->RemoveTable('ForumWatch')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': UserForumFlags<br />';
		if (!$UNB['Db']->RemoveTable('UserForumFlags')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': Guests<br />';
		if (!$UNB['Db']->RemoveTable('Guests')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': Stat<br />';
		if (!$UNB['Db']->RemoveTable('Stat')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': ACL<br />';
		if (!$UNB['Db']->RemoveTable('ACL')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': GroupNames<br />';
		if (!$UNB['Db']->RemoveTable('GroupNames')) echo 'remove error';

		echo $UNB_T['uninst.remove table'] . ': GroupMembers<br />';
		if (!$UNB['Db']->RemoveTable('GroupMembers')) echo 'remove error';

		echo '<br />';
		echo '<b>' . $UNB_T['uninst.complete'] . '</b>';
		echo '</div>';
	} // if type = 9
}

UnbEndHTML();
UteShowAll();

// Report a fatal error during upgrade
//
function UpgradeFatalDbError($msg)
{
	global $UNB, $UNB_T;

	echo '<div class="error"><div>';
	echo $UNB_T['inst.error.upgrade fatal error'] . '<br /><br />';
	echo t2h($msg) . '<br /><br />';
	echo 'SQL error: ' . t2h($UNB['Db']->LastError());
	echo '</div></div>';
	exit();
}

?>
