<?php
// Unclassified NewsBoard
// Copyright 2003-5 by Yves Goergen
// Homepage: http://newsboard.unclassified.de
// See docs/license.txt for distribution/license details
//
// forum.php
// Main page request program
// This file can be altered for embedded use of the newsboard system

// Initialise variables used for include()
$UNB = array();
$UNB['LibraryPath'] = '';

// -------------------- BEGIN config area --------------------

// Debug mode string. Anything with a + in front of it will be enabled
//
// +htmltype   = use content-type text/html instead of auto-negotiation (XML)
// +showerrors = don't suppress PHP error messages
//               (you should also set +htmltype in this case)
$DEBUG = '+htmltype -showerrors';

// UNB's lib path where common.lib.php is located
// If your board's library path is somewhere else or you change it here, you
// also need to update it in the framework page library's include statement.
// Don't forget the trailing slash!
$UNB['LibraryPath'] = 'unb_lib/';

// Framework's include file and begin_page/end_page function calls
#$UNB['FrameInclude'] = 'page.lib.php';
#$UNB['FrameBeginPage'] = 'begin_page($title);';
#$UNB['FrameEndPage'] = 'end_page();';

// -------------------- END config area --------------------

// Prepare debug mode string
$DEBUG = ' ' . strtolower($DEBUG) . ' ';

define('ERR_REPORT_SET', 1);    // Remember we have configured the error reporting
define('DISPLAY_ERR_SET', 1);   // Remember we have configured the error display

// We don't want E_NOTICE or E_DEPRECATED output here!
error_reporting(E_ALL & ~E_NOTICE & ~8192 /*E_DEPRECATED*/);

// Uncomment this line to suppress *any* error messages generated by PHP.
// Error messages may contain full pathnames and should therefore not be displayed
// in a productive environment. Errors are still logged to the log file, if this
// is enabled in your PHP configuration (default).
if (strstr($DEBUG, ' +showerrors '))
	@ini_set('display_errors', 1);
else
	@ini_set('display_errors', 0);

// This define is necessary so that the included files and libraries know they're
// running in a safe environment and cannot be called directly. If you require some
// of UNB's libraries in your own pages, you must also include this line.
define('UNB_RUNNING', 1);

// Parse additional parameters from mod_rewrite translation
// Read variables from the form:
//      param=value;param=value;...;param=value
//   or param;param;...;param
//   (or mixed)
// into the right PHP arrays ($_GET and $_REQUEST)
//
if (isset($_GET['rewrite']) && $_GET['rewrite'] !== '')
{
	$params = $_GET['rewrite'];
	while (true)
	{
		if (preg_match('_^([^;]+?)=([^;]*?);(.*)$_i', $params, $m) ||
		    preg_match('_^([^;]+?)=([^;]*?)$_i', $params, $m))
		{
			$_GET[$m[1]] = $_REQUEST[$m[1]] = $m[2];
			if (!($params = $m[3])) break;
		}
		else if (preg_match('_^([^;]+?);(.*)$_i', $params, $m) ||
		         preg_match('_^([^;]+?)$_i', $params, $m))
		{
			$_GET[$m[1]] = $_REQUEST[$m[1]] = 1;
			if (!($params = $m[2])) break;
		}
		else
		{
			break;
		}
	}
}

// Initialise template parameters
$UNB['TP'] = array();

// Framework's initialisation
if ($UNB['FrameInclude']) require_once($UNB['FrameInclude']);

// include UNB's public library
require_once($UNB['LibraryPath'] . 'common.lib.php');
require_once($UNB['LibraryPath'] . 'common_out.lib.php');

$UNB['ParseTime'] = debugPerformMsec();

// REQUEST-PARAMETER (see common.lib:UnbLink() for more details)
$request = $_REQUEST['req'];
if ($request == '') $request = 'main';

$UNB['ThisPage'] = '@' . $request;

$title = '';

switch ($request)
{
	case 'cp':
		require($UNB['LibraryPath'] . 'cp.inc.php');
		break;

	case 'derefer':
		$url = trim($_GET['url']);
		// remove outer double quotes if present
		if ($url{0} == '"' && $url{strlen($url) - 1} == '"') $url = substr($url, 1, -1);
		if (strpos($url, ':') === false) $url = 'http://' . $url;
		UnbAddLog('goto_url ' . $url);

		// Security check: only allow (http, https, ftp, ftps, mailto, news) protocol here!
		// NOTE: This code is obsolete and will only be used nowadays when the dereferrer is
		//       actually in use. This will be the case when the session ID is in the current
		//       page's URL which is likely only the case when session cookies are disabled.
		//       So don't rely on this feature! A better solution would now be to limit the
		//       protocol specifier to certain values in the [url] tag in the ABBC parser.
		if (strncasecmp($url, 'http:', 5) &&
		    strncasecmp($url, 'https:', 6) &&
		    strncasecmp($url, 'ftp:', 4) &&
		    strncasecmp($url, 'ftps:', 5) &&
		    strncasecmp($url, 'mailto:', 7) &&
		    strncasecmp($url, 'news:', 5))
		{
			// forbidden protocol!
			UnbErrorLog('forbidden link protocol detected!');

			$UNB['TP']['headNoIndex'] = true;
			$UNB['TP']['errorMsg'] .= 'This link protocol is not allowed here!';
			UnbBeginHTML('Forbidden link', true);
			UnbEndHTML();
			break;
		}

		UnbForwardHTML($url);
		break;

	case 'main':
		require($UNB['LibraryPath'] . 'main.inc.php');
		break;

	case 'post':
		require($UNB['LibraryPath'] . 'post.inc.php');
		break;

	case 'register':
		require($UNB['LibraryPath'] . 'register.inc.php');
		break;

	case 'search':
		require($UNB['LibraryPath'] . 'search.inc.php');
		break;

	case 'setuser':
		// Get forward URL
		switch ($_GET['module'])
		{
			case 'main':
				$url = UnbLink(
					'@main',
					array(
						'id' => $_GET['id'],
						'page' => $_GET['page']));
				break;
			case 'thread':
				$url = UnbLink(
					'@thread',
					array(
						'id' => $_GET['id'],
						'postid' => $_GET['postid'],
						'page' => $_GET['page']));
				break;
			case 'stat':
				$url = UnbLink(
					'@stat',
					array(
						'page' => $_GET['page']));
				break;
			case 'post':
				if ($_GET['thread'] || $_GET['quote'] || $_GET['replyto'] || $_GET['forum'])
				{
					$url = UnbLink(
						'@post',
						array(
							'thread' => $_GET['thread'],
							'quote' => $_GET['quote'],
							'replyto' => $_GET['replyto'],
							'forum' => $_GET['forum']));
				}
				else
				{
					$url = UnbLink('@main');
				}
				break;
			case 'search':
				$url = UnbLink(
					'@search',
					array(
						'Special' => $_GET['special']));
				break;
			default:
				$url = UnbLink('@main');
		}

		// Set new User
		$name = trim($_POST['LoginName']);
		if (!isset($_POST['LoginName']))
		{
			// only logout with the correct URL key to prevent automatic links
			if (UnbUrlCheckKey()) UnbTermSession();
			UnbForwardHTML($url);
		}
		elseif ($name != '')
		{
			$user = new IUser;
			if ($userid = $user->FindByName($name))
			{
				if (UnbCreateSession($userid, md5(trim($_POST['LoginPassword'])), $user->GetPassword(), $user->GetFlags() & 32))
				{
					// we were a "guest", so remove current session ID from the guests list
					$UNB['Db']->RemoveRecord('Session=\'' . session_id() . '\'', 'Guests');

					$first_login = ($user->GetLastActivity() == 0);

					$user->SetLastLogin();

					UnbAddLog('login ' . $user->GetName() . ' (' . $user->GetID() . ')');
					if ($first_login)
						// forward this user to his CP at his first login
						UnbForwardHTML(UnbLink(
							'@cp',
							array(
								'id' => $userid,
								'cat' => 'account')));
					else
						UnbForwardHTML($url);
				}
				else
				{
					UnbAddLog('login ' . $user->GetName() . ' error wrong_password');
					UnbTermSession();
					UnbForwardHTML(UnbLink(
						'@main',
						array(
							'err' => 3,
							'name' => $name,
							'userid' => $user->GetID())));
				}
			}
			else
			{
				UnbAddLog('login ' . $name . ' error unknown_user');
				UnbTermSession();
				UnbForwardHTML(UnbLink(
					'@main',
					array(
						'err' => 2,
						'name' => $name)));
			}
		}
		else
		{
			UnbTermSession();
			UnbForwardHTML(UnbLink(
				'@main',
				array(
					'err' => 1,
					'name' => $name)));
		}
		break;

	case 'showip':
		// Import request variables
		$postid = $_REQUEST['id'];
		if (!is_numeric($postid) || $postid < 0) $postid = 0;

		// Begin page
		UnbBeginHTML($UNB_T['ip/host']);

		$post = new IPost;
		$post->Load($postid);

		$thread = new IThread;
		$thread->Load($post->GetThread());

		if (UnbCheckRights('showip', $thread->GetForum(), $thread->GetID()))
		{
			$out = $UNB_T['date'] . ': ' . UnbFriendlyDate($post->GetDate(), 0, 7) . '<br />';
			$out .= $UNB_T['ip address'] . ': ' . $post->GetIP() . '<br />';
			$out .= $UNB_T['hostname'] . ': ' . $post->GetHostname() . '<br />';
			$UNB['TP']['infoMsg'] .= $out;

			UnbAddLog('show_ip for ' . $postid);
		}
		else
		{
			$error = $UNB_T['error.access denied'];
			$UNB['TP']['errorMsg'] .= $error;
			UnbErrorLog($error);
			UnbAddLog('show_ip for ' . $postid . ' no_access');
		}

		UnbUpdateStat('PageHits', 1);
		UnbEndHTML();
		break;

	case 'stat':
		require($UNB['LibraryPath'] . 'stat.inc.php');
		break;

	case 'thread':
		require($UNB['LibraryPath'] . 'thread.inc.php');
		break;

	case 'users':
		require($UNB['LibraryPath'] . 'users.inc.php');
		break;

	case 'rss':
		require($UNB['LibraryPath'] . 'rss.inc.php');
		break;

	case 'veriword':
		require_once($UNB['LibraryPath'] . 'captcha.class.php');

		$c = UnbCaptcha::GetConfiguration();
		switch ($UNB['Lang'])
		{
			case 'de':
				$c['wordsFileName'] = 'captcha_words_de.txt';
				break;
			case 'en':
			default:
				$c['wordsFileName'] = 'captcha_words_en.txt';
				break;
		}
		UnbCaptcha::SetConfiguration($c);

		UnbCaptcha::GenerateImage();   // Should not return
		break;

	default:
		$data = array('request' => $request, 'handled' => false);
		UnbCallHook('page.custom.handlerequest', $data);
		if ($data['handled'])
		{
			require($data['include']);
		}
		else
		{
			UnbBeginHTML();
			$UNB['TP']['errorMsg'] = 'Invalid request: ' . t2h($request);
			UnbEndHTML();
		}
}

UteShowAll();

?>