<?php
/*******************************************************************************
 *   copyright				: (C) 2013 - 2016 u-Auctions
 *   site					: https://www.u-auctions.com
 *******************************************************************************/

/*******************************************************************************
 *   This uAuctions is a Paid version of u-Auctions script.
 *   You are not allowed to resell/sell this script is  copyrighted to u-auctions.com.
 *   If you have been sold this script from a 3rd party and not from the 
 *   https://u-auctions.com website or https://ubidzz.com ask for a refund.
 *******************************************************************************/
/*******************************************************************************
 * If you bought this script from the https://u-Auctions.com website or https://ubidzz.com 
 * Please register at https://u-auctions.com/forum and contact the u-Auctions admin  
 * at https://u-auctions.com/forum with your order number and full name so we can change 
* your group to premium so you can view the paid area on the forums.
 *******************************************************************************/
define('InuAuctions', 1);
define('MAIN_PATH', getmainpath());
// SQL handler, class and connect to db
define('DATABASE_PATH', MAIN_PATH . 'includes/database/');
include DATABASE_PATH . 'Database.php';
include DATABASE_PATH . 'DatabasePDO.php';
$db = new DatabasePDO();

if(file_exists(MAIN_PATH . 'includes/config.inc.php'))
{
	include MAIN_PATH . 'includes/config.inc.php';
	$db->connect($DbHost, $DbUser, $DbPassword, $DbDatabase, $DBPrefix, 'utf-8');
}

function getSettings()
{
	global $db, $DBPrefix;
	
	$str = '';
	if($db && isset($DBPrefix) !='') {
		$query = "SELECT * FROM " . $DBPrefix . "settings";
		$db->direct_query($query);
		$str = $db->result();
	}
	return $str;
}

function getmainpath()
{
	$path = getcwd();
	$path = str_replace('install', '', $path);
	return $path;
}

function installNewDB()
{
	global $db, $DBPrefix;
	
	if($db) {
		$siteURL = urldecode($_GET['URL']);
		$siteEmail = $_GET['EMail'];
		include MAIN_PATH . 'install/sql/dump.inc.php';
		$countDB = @count($query);
		for ($i = 0; $i < $countDB; $i++)
		{
			$db->direct_query($query[$i]);
		}
		return array('imported' => $i, 'total' => $countDB);
	}
}

function getdomainpath()
{
	$path = dirname($_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
	if (strlen($path) < 12)
	{
		$path = dirname($_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']);
	}
	$path = str_replace('install', '', $path);
	return $path;
}

function makeconfigfile($contents, $main_path)
{
	$filename = $main_path . 'includes/config.inc.php';
	$altfilename = $main_path . 'includes/config.inc.php.new';

	if (!file_exists($filename))
	{
		if (file_exists($altfilename))
		{
			rename($altfilename, $filename);
		}
		else
		{
			touch($filename);
		}
	}

	@chmod($filename, 0777);

	if (is_writable($filename))
	{
		if (!$handle = fopen($filename, 'w')) 
		{
			$return = false;
		}
		else
		{
			if (fwrite($handle, $contents) === false)
			{
				$return = false;
			}
			else
			{
				$return = true;
			}
		}
		fclose($handle);
	}
	else
	{
		$return = false;
	}

	return $return;
}

function print_header($update)
{
	if ($update)
	{
		global $_SESSION;
		if (!isset($_SESSION['oldversion']))
		{
			$_SESSION['oldversion'] = installed_version();
		}
		
		return '<link rel="stylesheet" type="text/css" href="../themes/default/css/bootstrap.css"><link rel="stylesheet" type="text/css" href="../themes/default/css/bootstrap-responsive.css" ><link rel="stylesheet" type="text/css" href="../themes/default/css/style.css">
		<h1 align="center">uAuctions Updater v' . $_SESSION['oldversion'] . ' to v' . new_version() . '</h1>';
	}
	else
	{
		return '<link rel="stylesheet" type="text/css" href="../themes/default/css/bootstrap.css"><link rel="stylesheet" type="text/css" href="../themes/default/css/bootstrap-responsive.css" ><link rel="stylesheet" type="text/css" href="../themes/default/css/style.css">
		<h1 align="center">uAuctions Installer v' . new_version() . '</h1>';
	}
}

function new_version()
{
	$string = file_get_contents('thisversion.txt') or die('error');
	return $string;
}

function settings_array()
{
	return getSettings();
}

function installed_version()
{
	global $db, $DBPrefix;
	
	if($DBPrefix !='') 
	{
		if (!$db)
		{		
			$version = 'Failed to connect to the database';
		}else{
			$settingsData = getSettings();			
			$version = $settingsData['version'];
		}
	}else{
		$version = new_version();
	}
	return $version;
}


function check_installation()
{
	global $db;
	
	if($db) {
		$settingsData = getSettings();
		if($settingsData['version'] != new_version())
		{
			return true;
		}else{
			return false;
		}
	}
	else
	{
		return false;
	}
	
}

function deleteInstallFolder($str) 
{
	//deleting all the install files and directories
	if (is_file($str)) 
	{
		return @unlink($str);
	}
	elseif (is_dir($str)) 
	{
		$trim_str = rtrim($str,'/');
		$scan = glob($trim_str . '/*');
		foreach($scan as $index=>$path) 
		{
			deleteInstallFolder($path);
		}
		return @rmdir($str);
	}
}

function UpdateDB()
{
	global $db, $DBPrefix;
	
	$myversion = installed_version();
	@include 'sql/updatedump.inc.php';
	$countDB = @count($query);
	$arraydata = array();
	for ($i = 0; $i < $countDB; $i++)
	{
		$db->direct_query($query[$i]);
		$arraydata[] = $query[$i];
	}
	echo '<div class="span12 well">
				<div id="message"></div>
				<div class="progress progress-striped active">
					<div class="bar" id="progress-bar" style="width:0%"><div id="finishedPercent"></div></div>
				</div>
				<div id="log"></div>
			</div>
			<script type="text/javascript">
			var width = 0;
			var nIntervId;
			var counter = 0;
			var newHTML = [];

			window.onload = function()
			{ 
			    nIntervId = setInterval(updatemessage, 100);
			    nIntervId = setInterval(updatemessage, 100);
			}
			
			function updatemessage() 
			{
				width = width >= 100 ? 100 : width + 0.3;  
			    document.getElementById("progress-bar").style.width = width + "%"; 
			    document.getElementById("finishedPercent").innerHTML= "Updating Database: " + width + "% finished...";
			    var newVersion = "' . new_version() .'";
			    var installedVersion = "' . installed_version() . '";
			    				
			    if(width == 100)
			    {
			   		if(newVersion == installedVersion)
			   		{
			        	document.getElementById("message").innerHTML = "<h4>COMPLETE!</h4>Now to <b><a href=\"?step=3\">step 3</a></b> or view the database log.";
			        	document.getElementById("message").className = "alert alert-success";
			        	clearInterval(nIntervId);
			    	}else{
			       		document.getElementById("message").innerHTML = "<h4>ERROR!</h4>The database didn\'t update please try <b><a href=\"?step=2\">step 2</a></b> again.";
			       		document.getElementById("message").className = "alert alert-error";
			       		clearInterval(nIntervId);
			    	}
				}
				counter++;
				DBlog();
			}
			
			newHTML.push("<br /><h3>Database Log</h3><hr /><b>The Database log displays what tables that are being edited</b><hr />");
			function DBlog() 
			{
				var array = ' . json_encode($arraydata). ';
			    for (var i = 0; i < array.length; i++) {
			    	if(counter - 1 == [i]){
				    	newHTML.push("<div><b>Database:</b> " + array[i] + "</div>");
				    }
				}
				document.getElementById("log").innerHTML = newHTML.join("");
			}
  			</script>';
}

function show_config_table($fresh = true)
{
	$data = '<form name="form1" method="post" action="?step=1">';
	$data .= '<table  style="width:70%; margin-left:35px" cellspacing="1" class="table table-bordered table-striped table-condensed" cellpadding="6">';
	$data .= '<tr>';
	$data .= '	<td colspan="3"><b>Server Details:</b></td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '	<td width="140">URL</td>';
	$data .= '	<td width="108">';
	$data .= '	  <input type="text" name="URL" id="textfield" value="' . getdomainpath() . '">';
	$data .= '	</td>';
	$data .= '	<td rowspan="2">';
	$data .= '	  The url &amp; location of the uAuctions installation on your server. It\'s usually best to leave these as they are.<br>';
	$data .= '	  Also if your running on windows at the end of the <b>Doument Root</b> there should be a \\\\ (double backslash)';
	$data .= '	</td>';
	$data .= '  </tr>';
	$data .= '  <tr>';
	$data .= '	<td>Doument Root</td>';
	$data .= '	<td>';
	$data .= '	  <input type="text" name="mainpath" id="textfield" value="' . MAIN_PATH . '">';
	$data .= '	</td>';
	$data .= '</tr>';
	if ($fresh)
	{
		$data .= '<tr>';
		$data .= '	<td>Email Address</td>';
		$data .= '	<td>';
		$data .= '	  <input type="text" name="EMail" id="textfield">';
		$data .= '	</td>';
		$data .= '	<td>The admin email address</td>';
		$data .= '</tr>';
	}
	$data .= '<tr>';
	$data .= '	<td>Database Host</td>';
	$data .= '	<td>';
	$data .= '	  <input type="text" name="DBHost" id="textfield" value="localhost">';
	$data .= '	</td>';
	$data .= '	<td>The location of your MySQL database in most cases its just localhost</td>';
	$data .= '  </tr>';
	$data .= '  <tr>';
	$data .= '	<td>Database Username</td>';
	$data .= '	<td>';
	$data .= '	  <input type="text" name="DBUser" id="textfield">';
	$data .= '	</td>';
	$data .= '	<td rowspan="3">The username, password and database name of the database your installing uAuctions on</td>';
	$data .= '  </tr>';
	$data .= '  <tr>';
	$data .= '	<td>Database Password</td>';
	$data .= '	<td>';
	$data .= '	  <input type="text" name="DBPass" id="textfield">';
	$data .= '	</td>';
	$data .= '  </tr>';
	$data .= '  <tr>';
	$data .= '	<td>Database Name</td>';
	$data .= '	<td>';
	$data .= '	  <input type="text" name="DBName" id="textfield">';
	$data .= '	</td>';
	$data .= '  </tr>';
	$data .= '  <tr>';
	$data .= '	<td>Database Prefix</td>';
	$data .= '	<td>';
	$data .= '	  <input type="text" name="DBPrefix" id="textfield" value="uAuctions_">';
	$data .= '	</td>';
	$data .= '	<td>the prefix of the uAuctions tables in the database, used so you can install multiple scripts in the same database without issues.</td>';
	$data .= '</tr>';
	if ($fresh)
	{
		$data .= '<tr>';
		$data .= '	<td>Import Default Categories</td>';
		$data .= '	<td>';
		$data .= '	  <input type="checkbox" name="importcats" id="checkbox" checked="checked">';
		$data .= '	</td>';
		$data .= '	<td>Leaving this checked is recommened. But you make want to uncheck it if your auction site is a specalist niche and will need custom catergories.</td>';
		$data .= '</tr>';
	}

	if ($fresh)
	{
		$data .= '<tr>';
		$data .= '	<td colspan="3"><b>File Checks:</b></td>';
		$data .= '</tr>';
		$directories = array(
			'cache/',
			'uploaded/',
			'uploaded/avatar/',
			'uploaded/banners/',
			'uploaded/cache/',
			'uploaded/items/',
			'uploaded/logos/'
			);

		umask(0);

		$passed = true;
		foreach ($directories as $dir)
		{
			$exists = $write = false;

			// Try to create the directory if it does not exist
			if (!file_exists(MAIN_PATH . $dir))
			{
				if($dir == 'uploaded/items/')
				{
					@mkdir(MAIN_PATH . $dir, 0700);
					@chmod(MAIN_PATH . $dir, 0700);
				}
				else
				{
					@mkdir(MAIN_PATH . $dir, 0755);
					@chmod(MAIN_PATH . $dir, 0755);
				}
			}
			else
			{
				if($dir == 'uploaded/items/')
				{
					@chmod(MAIN_PATH . $dir, 0700);
				}
				else
				{
					@chmod(MAIN_PATH . $dir, 0755);
				}
			}

			// Now really check
			if (file_exists(MAIN_PATH . $dir) && is_dir(MAIN_PATH . $dir))
			{
				$exists = true;
			}

			// Now check if it is writable by storing a simple file
			$fp = @fopen(MAIN_PATH . $dir . 'test_lock', 'wb');
			if ($fp !== false)
			{
				$write = true;
			}
			@fclose($fp);

			@unlink(MAIN_PATH . $dir . 'test_lock');

			if (!$exists || !$write)
			{
				$passed = false;
			}

			$data .= '<tr ><td colspan="2">' . $dir . ':</td><td colspan="3">';
			$data .= ($exists) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
			$data .= ($write) ? ', <strong style="color:green">Writable</strong>' : (($exists) ? ', <strong style="color:red">Unwritable</strong>' : '');
			$data .= '</tr>';
		}

		//check config file exists and is writable
		$write = $exists = true;
		if (file_exists(MAIN_PATH . 'includes/config.inc.php'))
		{
			if (!@is_writable(MAIN_PATH . 'includes/config.inc.php'))
			{
				$write = false;
			}
		}
		elseif (file_exists(MAIN_PATH . 'includes/config.inc.php.new'))
		{
			if (!@is_writable(MAIN_PATH . 'includes/config.inc.php.new'))
			{
				$write = false;
			}
		}
		else
		{
			$write = $exists = false;
		}

		if (!$exists || !$write)
		{
			$passed = false;
		}

		$data .= '<tr><td colspan="2">includes/config.inc.php.new:</td><td colspan="2">';
		$data .= ($exists) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= ($write) ? ', <strong style="color:green">Writable</strong>' : (($exists) ? ', <strong style="color:red">Unwritable</strong>' : '');
		$data .= '</tr>';

		$directories = array(
			'includes/countries.inc.php',
			'includes/currencies.php',
			'includes/membertypes.inc.php',
			'language/EN/categories.inc.php',
			'language/EN/categories_select_box.inc.php'
			);

		foreach ($directories as $dir)
		{
			$write = $exists = true;
			if (file_exists(MAIN_PATH . $dir))
			{
				if (!@is_writable(MAIN_PATH . $dir))
				{
					$write = false;
				}
			}
			else
			{
				$write = $exists = false;
			}

			if (!$exists || !$write)
			{
				$passed = false;
			}

			$data .= '<tr><td colspan="2">' . $dir . ':</td><td colspan="2">';
			$data .= ($exists) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
			$data .= ($write) ? ', <strong style="color:green">Writable</strong>' : (($exists) ? ', <strong style="color:red">Unwritable</strong>' : '');
			$data .= '</tr>';
		}
		
		$data .= '<tr><td colspan="2">PHP Version must be higher than 5.4.x:</td><td colspan="2">';
		$data .= (phpversion() > '5.4.0') ? '<strong style="color:green">' . phpversion() . '</strong>' : '<strong style="color:red">' . phpversion() . '</strong>';
		$data .= '</tr>';

		$data .= '<tr><td colspan="2">GD Support:</td><td>';
		$data .= (extension_loaded('gd') && function_exists('gd_info')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';
		
		$gdinfo = gd_info();
		$data .= '<tr><td colspan="2">FreeType Support:</td><td colspan="2">';
		$data .= ($gdinfo['FreeType Support']) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';

		$data .= '<tr><td colspan="2">BC Math Support:</td><td colspan="2">';
		$data .= (extension_loaded('bcmath')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';
		
		$data .= '<tr><td colspan="2">PHP Data Objects (PDO) Support:</td><td colspan="2">';
		$data .= (extension_loaded('pdo')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';
		
		$data .= '<tr><td colspan="2">MBString Support:</td><td colspan="2">';
		$data .= (extension_loaded('mbstring')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';
		
		$data .= '<tr><td colspan="2">Mcrypt Encrypt Support:</td><td colspan="2">';
		$data .= (function_exists('mcrypt_encrypt')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';
				
		$data .= '<tr><td colspan="2">allow_url_fopen Support:</td><td>';
		$data .= (ini_get('allow_url_fopen')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';

		$data .= '<tr><td colspan="2">fopen Support:</td><td>';
		$data .= (function_exists('fopen')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';
		
		$data .= '<tr><td colspan="2">fread Support:</td><td>';
		$data .= (function_exists('fread')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';

		$data .= '<tr><td colspan="2">file_get_contents Support:</td><td>';
		$data .= (function_exists('file_get_contents')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';
		
		$data .= '<tr><td colspan="2">curl Support:</td><td>';
		$data .= (function_exists('curl_init') && function_exists('curl_setopt') && function_exists('curl_exec') && function_exists('curl_close')) ? '<strong style="color:green">Found</strong>' : '<strong style="color:red">Not Found</strong>';
		$data .= '</tr>';
	}

	if ($fresh && $passed || !$fresh)
	{
		$data .= '<tr><td colspan="3"><input type="submit" class="btn btn-primary" value="install"></td></tr>';
	}
	$data .= '</table>';
	$data .= '</form>';
	
	return $data;
}

function search_cats($parent_id, $level)
{
	global $DBPrefix, $catscontrol;
	$root = $catscontrol->get_virtual_root();
	$tree = $catscontrol->display_tree($root['left_id'], $root['right_id'], '|___');
	foreach ($tree as $k => $v)
	{
		$catstr .= ",\n" . $k . " => '" . $v . "'";
	}
	return $catstr;
}

function rebuild_cat_file()
{
	global $system, $DBPrefix, $db;
	
	$query = "SELECT * FROM " . $DBPrefix . "categories ORDER BY cat_name";
	$db->direct_query($query);
	$cats = array();
	while ($catarr = $db->result())
	{
		$cats[$catarr['cat_id']] = $catarr['cat_name'];
		$allcats[] = $catarr;
	}
	$output = "<?php\n";
	$output.= "$" . "category_names = array(\n";
	$num_rows = count($cats);
	$i = 0;
	foreach ($cats as $k => $v)
	{
		$output .= "$k => '$v'";
		$i++;
		if ($i < $num_rows)
			$output .= ",\n";
		else
			$output .= "\n";
	}
	$output .= ");\n\n";
	$output .= "$" . "category_plain = array(\n0 => ''";
	$output .= search_cats(0, 0);
	$output .= ");\n?>";
	$handle = fopen (MAIN_PATH . 'language/' . $system->SETTINGS['defaultlanguage'] . '/categories.inc.php', 'w');
	fputs($handle, $output);
}
?>