<?php
/*******************************************************************************
 *   copyright				: (C) 2013 - 2016 u-Auctions
 *   site					: https://www.u-auctions.com
 *******************************************************************************/

/*******************************************************************************
 *   This uAuctions is a Paid version of u-Auctions script.
 *   You are not allowed to resell/sell this script is  copyrighted to u-auctions.com.
 *   If you have been sold this script from a 3rd party and not from the 
 *   https://u-auctions.com website or https://ubidzz.com ask for a refund.
 *******************************************************************************/
/*******************************************************************************
 * If you bought this script from the https://u-Auctions.com website or https://ubidzz.com 
 * Please register at https://u-auctions.com/forum and contact the u-Auctions admin  
 * at https://u-auctions.com/forum with your order number and full name so we can change 
* your group to premium so you can view the paid area on the forums.
 *******************************************************************************/
if (!defined('InuAuctions')) exit('Access denied');
if (!defined('SECURITY_PATH')) exit('Access denied');

if ($system->SETTINGS['encryptionType'] == 'n' && function_exists('mcrypt_encrypt')) 
{
	//Encrypt and Decrypt data useing AES-256
	class security 
	{
		private static $salt;
		private static $public_key;
		private static $algorithm;
		private static $mode;
		private static $ivSize;
		private static $warning;
		private static $logged_in;
		
		public function security()
		{
			global $system;
			        
			self::$salt = $system->SETTINGS['encryption_key']; # Private key that was generated from the AdminCP
			self::$logged_in = false; # Used to check if the user is logged in
			# Just a warning message if someone is trying to hack the data and get through the base64_encode and rawurlencode encryption
			# This is not shown in the encryption result
			self::$warning = '=if_you_see_this_message_stop_trying_to_hack_this_site='; # 
			self::$algorithm = MCRYPT_RIJNDAEL_128; # encryption algorithm
	        self::$mode = MCRYPT_MODE_CBC; # encryption mode
	        self::$ivSize = mcrypt_get_iv_size(self::$algorithm, self::$mode); # Returns the size of the IV belonging to a specific cipher/mode combination
		}
		
		# Check key
	    protected static function _checkKey($key, $mode) 
	    {
	        if (strlen($key) < 32) {
	            return false;
	        }
	    }
		
		# Check public key
	    protected static function _getPublicKey($key = null, $images = null, $mode = null) 
	    {
	        global $user;
			
			if($mode === 'encrypt' && !$key) {
		    	if($user->logged_in && !$images) {
		    		self::$public_key = $user->user_data['user_key']; # This key changes every time the user login
		    		self::$logged_in = true;
		    	}else{
					self::$public_key = self::genRandString(32);
				}
			}
			elseif($mode === 'decrypt') {
				# The public key was encoded with base64 so we need to decode the public key
				$decoded_key = base64_decode($key);
				# Checking to see if the user key was used
				if($user->logged_in && !$images && $decoded_key === 'user_key') {
		    		#using the stored user key if the user is logged in
		    		self::$public_key = $user->user_data['user_key']; # This key changes every time the user login
				}else{
					# The user key was not used and was generated and stored with the encrypted content
			    	self::$public_key = $decoded_key; 
				}
			}else{
				# The public key could not be found so make the self::$public_key empty
				self::$public_key = null;
			}
					
			# Checking to see if the public key is 32 bytes
		    if(self::_checkKey(self::$public_key, $mode . '()') === false) {
		    	self::$public_key = null; # If the key is not 32 bytes fail the encryption/decryption
		    }
	    }
		
	    # Encrypt a value using AES-256.
	    public static function encrypt($plain, $images = null) 
	    {	
	    	self::_getPublicKey(null, $images, 'encrypt');
	    	# incase the public key is empty
	    	if(!self::$public_key) {
	    		return false;
	    	}else{
		        $key = substr(hash('sha256', self::$public_key . self::$salt), 0, 32); # Generate the encryption and hmac key
		        $iv = mcrypt_create_iv(self::$ivSize, MCRYPT_DEV_URANDOM); # Creates an initialization vector (IV) from a random source
		        $ciphertext = $iv . mcrypt_encrypt(self::$algorithm, $key, $plain, self::$mode, $iv); # Encrypts plaintext with given parameters
		        $hmac = hash_hmac('sha256', $ciphertext, $key); # Generate a keyed hash value using the HMAC method
		        if(self::$logged_in) {
		        	# Only used if the user is logged in and is not a image data and you can see we are not passing the public key
		        	$encryption = base64_encode(base64_encode($hmac . $ciphertext) . self::$warning . base64_encode('user_key'));
		        }else{
		        	# This is mostly used for image data and you can see we are adding the public key because this is a image data
		        	$encryption = base64_encode(base64_encode($hmac . $ciphertext) . self::$warning . base64_encode(self::$public_key));
		        }
		        # We are replacing the + with ^ because the + some times gives problems in URL like downloading digital item
		        $encrypted = str_replace('+','^',$encryption); 
		        # Sending the encrypted data back and it will be a really long string that is something like this 
		        # MDdlOWNmZjk5ZTRmNzg5NGU2MzljMmEzMTllMzgyMjIzOThkYjFlZGJlYmZkYTFhYTJjY2ExMDBlYzE3ZDZiMCVFNiVBM1NEJTFCJUUxJTA4eSVCNCU5NCU4N2UlNDAlNUMlRTI
		        # lOENLVSVFQSUxRSVDNCU5RiVGOCVEMSU4Mkt4JTk4JUJCZSU5MiU4MSUzREslM0RVMk5zVTFGRWRqWnJWV3A2VFdsT2MwVldZa2wxU21WNFNVdHdTbVpGZURRJTNE
		        return $encrypted; # (Good luck trying to hack this encrypted data)
			}
	    }
	  
	    # Decrypt a value using AES-256.
	    public static function decrypt($encrypted, $images = null)
	    {    	
	   		$fixed = str_replace('^','+', $encrypted); # Changing back the + from ^
	   		$decode = base64_decode($fixed); # Using base64_decode to decode the frist part
	   		# Splitting the encrypting data and public key in to a array from the encrypted data so we can use the data
	    	$spliter = explode(self::$warning, $decode); 
	    	$cipher = base64_decode($spliter[0]); # Getting the cipher and decoding it with base64_decode
	       	self::_getPublicKey($spliter[1], $images, 'decrypt'); # Getting the public key that was used
	    	# Check to see if the public key is found
			if(!self::$public_key) {
	    		return false;
	    	}
	    	# Check to see if the cipher is found
	    	elseif(empty($cipher)) { 
	    		return false;
	    	}else{
		       	//// Now do all the decrypting ////	        
		        # Generate the encryption and hmac key.
		        $key = substr(hash('sha256', self::$public_key . self::$salt), 0, 32); 
		 
		        # Split out hmac for comparison
		        $hmac = substr($cipher, 0, 64);
		        $cipher = substr($cipher, 64);
		 
		        $compareHmac = hash_hmac('sha256', $cipher, $key);
		        if ($hmac !== $compareHmac) {
		            return false;
		        }
		 
		        $iv = substr($cipher, 0, self::$ivSize);
		        $cipher = substr($cipher, self::$ivSize);
		        $plain = mcrypt_decrypt(self::$algorithm, $key, $cipher, self::$mode, $iv);
		        return rtrim($plain, "\0");
			}
	    }
	        
	    #Get Random String - Usefull for public key
	    public static function genRandString($length = 0) 
	    {
	        $charset = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
	        $str = '';
	        $count = strlen($charset);
	        while ($length-- > 0) {
	            $str .= $charset[mt_rand(0, $count-1)];
	        }
			return $str;
	    }
	}
}
