<?php
/*******************************************************************************
 *   copyright				: (C) 2013 - 2016 u-Auctions
 *   site					: https://www.u-auctions.com
 *******************************************************************************/

/*******************************************************************************
 *   This uAuctions is a Paid version of u-Auctions script.
 *   You are not allowed to resell/sell this script is  copyrighted to u-auctions.com.
 *   If you have been sold this script from a 3rd party and not from the 
 *   https://u-auctions.com website or https://ubidzz.com ask for a refund.
 *******************************************************************************/
/*******************************************************************************
 * If you bought this script from the https://u-Auctions.com website or https://ubidzz.com 
 * Please register at https://u-auctions.com/forum and contact the u-Auctions admin  
 * at https://u-auctions.com/forum with your order number and full name so we can change 
* your group to premium so you can view the paid area on the forums.
 *******************************************************************************/

if (!defined('InuAuctions')) exit('Access denied');
if (!defined('FEES_PATH')) exit('Access denied');

include FEES_PATH . 'gateway_callback.php'; //fees handler functions

class process_gateway extends gateway_callback
{
	function paypal_validate()
	{
		global $system;
		
		$sandbox = $system->SETTINGS['paypal_sandbox'] == 'y' ? true : false;
		$https = $system->SETTINGS['https'] == 'y' ? true : false; 
		// we ensure that the txn_id (transaction ID) contains only ASCII chars...
		$pos = strspn($this->data['txn_id'], $this->ASCII_RANGE);
		$len = strlen($this->data['txn_id']);

		if ($pos != $len)
		{
			return;
		}

		//validate payment
		$req = 'cmd=_notify-validate';
		foreach ($this->data as $key => $value)
		{
			// Handle escape characters, which depends on setting of magic quotes  
			if(get_magic_quotes_gpc())
				$value = urlencode(stripslashes($value));
			else
				$value = urlencode($value);
			$req .= '&' . $key . '=' . $value;
		}

		// Post back to PayPal system to validate
		$header = "POST /cgi-bin/webscr HTTP/1.1\r\n";
		$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
		
		if ($sandbox == true)
		{
			$header .= "Host: www.sandbox.paypal.com\r\n";
		}
		else
		{
			$header .= "Host: www.paypal.com\r\n";
		}
		
		$header .= "Content-Length: " . strlen($req) . "\r\n";
		$header .= "Connection: close\r\n\r\n";  
		
		if ($sandbox == true)
		{
			if ($https == true)
			{
				// connect via SSL
				$fp = fsockopen ('ssl://www.sandbox.paypal.com', 443, $errno, $errstr, 30);
			}
			else
			{
				// connect via HTTP
				$fp = fsockopen ('www.sandbox.paypal.com', 80, $errno, $errstr, 30);
			}			
		}
		else
		{
			if ($https == true)
			{
				// connect via SSL
				$fp = fsockopen ('ssl://www.paypal.com', 443, $errno, $errstr, 30);
			}
			else
			{
				// connect via HTTP
				$fp = fsockopen ('www.paypal.com', 80, $errno, $errstr, 30);
			}
		}
		if (!$fp)
		{
			$error_output = $errstr . ' (' . $errno . ')';
		}
		else
		{
			// Assign posted variables to local variables
			$payment_status = $this->data['payment_status'];
			$payment_amount = floatval ($this->data['mc_gross']);
			list($custom_id, $fee_type) = explode($system->SETTINGS['custom_code'], $this->data['custom']);
			fputs ($fp, $header . $req);

			while (!feof($fp))
			{
				$resl = trim(fgets ($fp, 1024));

				if (strcmp ($resl, 'VERIFIED') == 0)
				{
					// We can do various checks to make sure nothing is wrong and   
					// that txn_id has not been previously processed
					if ($payment_status == 'Completed')
					{
						// everything seems to be OK
						$this->process_callback($custom_id, $fee_type, $payment_amount);
					}
				}
				elseif (strcmp ($resl, 'INVALID') == 0)
				{
					// payment failed
					$redirect_url = $system->SETTINGS['siteurl'] . 'validate.php?fail';
					header('location: '. $redirect_url);
					exit;
				}
			}
			fclose ($fp);
		}
	}
	 	
	function authnet_validate()
	{
		global $system;

		$payment_amount = floatval ($this->data['x_amount']);
		list($custom_id, $fee_type) = explode($system->SETTINGS['custom_code'], $this->data['custom']);

		if ($this->data['x_response_code'] == 1)
		{
			$this->process_callback($custom_id, $fee_type, $payment_amount);
		}
		else
		{
			$redirect_url = $system->SETTINGS['siteurl'] . 'validate.php?fail';
			header('location: '. $redirect_url);
			exit;
		}
	}

	function worldpay_validate()
	{
		global $system;

		$payment_amount = floatval ($this->data['amount']);
		list($custom_id, $fee_type) = explode($system->SETTINGS['custom_code'],$this->data['cartId']);

		if ($this->data['transStatus'] == 'Y')
		{
			$this->process_callback($custom_id, $fee_type, $payment_amount);
		}
		else
		{
			$redirect_url = $system->SETTINGS['siteurl'] . 'validate.php?fail';
			header('location: '. $redirect_url);
			exit;
		}
	}

	function skrill_validate()
	{
		global $system;

		$payment_amount = floatval ($this->data['amount']);
		list($custom_id, $fee_type) = explode($system->SETTINGS['custom_code'],$this->data['trans_id']);

		if ($this->data['status'] == 2)
		{
			$this->process_callback($custom_id, $fee_type, $payment_amount);
		}
		else
		{
			$redirect_url = $system->SETTINGS['siteurl'] . 'validate.php?fail';
			header('location: '. $redirect_url);
			exit;
		}
	}

	function toocheckout_validate()
	{
		global $system;

		$payment_amount = floatval ($this->data['total']);
		list($custom_id, $fee_type) = explode($system->SETTINGS['custom_code'],$this->data['cart_order_id']);

		if ($this->data['cart_order_id'] != '' && $this->data['credit_card_processed'] == 'Y')
		{
			$this->process_callback($custom_id, $fee_type, $payment_amount);
		}
		else
		{
			$redirect_url = $system->SETTINGS['siteurl'] . 'validate.php?fail';
			header('location: '. $redirect_url);
			exit;
		}
	}
}