<?php
/*******************************************************************************
 *   copyright				: (C) 2013 - 2016 u-Auctions
 *   site					: https://www.u-auctions.com
 *******************************************************************************/

/*******************************************************************************
 *   This uAuctions is a Paid version of u-Auctions script.
 *   You are not allowed to resell/sell this script is  copyrighted to u-auctions.com.
 *   If you have been sold this script from a 3rd party and not from the 
 *   https://u-auctions.com website or https://ubidzz.com ask for a refund.
 *******************************************************************************/
/*******************************************************************************
 * If you bought this script from the https://u-Auctions.com website or https://ubidzz.com 
 * Please register at https://u-auctions.com/forum and contact the u-Auctions admin  
 * at https://u-auctions.com/forum with your order number and full name so we can change 
* your group to premium so you can view the paid area on the forums.
 *******************************************************************************/

session_start();

//Logging errors
$error_reporting = E_ALL^E_NOTICE;
//$error_reporting = E_ALL; // use this for debugging

define('InuAuctions', 1);
define('TrackUserIPs', 1);

// file check 
$install_path = (!defined('InAdmin')) ? 'install/install.php' : '../install/install.php';
if((file_exists($install_path)) || (!@include('includes/config.inc.php')))
{
	header('location: ' . $install_path);
	exit;
}

$MD5_PREFIX = (!isset($MD5_PREFIX)) ? 'fhQYBpS5FNs4' : $MD5_PREFIX; // if the user didnt set a code

//define the paths
define('MAIN_PATH', $main_path);
define('CACHE_PATH', MAIN_PATH . 'cache/');
define('INCLUDE_PATH', MAIN_PATH . 'includes/');
define('DATABASE_PATH', INCLUDE_PATH . 'database/');
define('TEMPLATE_PATH', INCLUDE_PATH . 'template/');
define('PLUGIN_PATH', INCLUDE_PATH . 'plugins/');
define('LANGUAGE_PATH', MAIN_PATH . 'language/');
define('SECURITY_PATH', INCLUDE_PATH . 'security/');
define('FEES_PATH', INCLUDE_PATH . 'fees/');

define('UPLOAD_FOLDER', 'uploaded/');
define('UPLOAD_PATH', MAIN_PATH . UPLOAD_FOLDER);

////  including all the pages that are need to run the u-Auctions script ////
//the different time zones settings
include INCLUDE_PATH . 'functions_timecorrections.php';

//load all the pages and classes that is needed to run the script
include INCLUDE_PATH . 'dates.inc.php'; //date/time handler functions

// SQL handler, class and connect to db
include DATABASE_PATH . 'Database.php';
include DATABASE_PATH . 'DatabasePDO.php';
$db = new DatabasePDO();

if (isset($CHARSET)) {
	$db->connect($DbHost, $DbUser, $DbPassword, $DbDatabase, $DBPrefix, $CHARSET);
}else{
	$db->connect($DbHost, $DbUser, $DbPassword, $DbDatabase, $DBPrefix, 'UTF-8');
}

include INCLUDE_PATH . 'functions_global.php';
$system = new global_class();

include SECURITY_PATH . 'functions_security.php';
$security = new security();

include INCLUDE_PATH . 'messages.inc.php'; //build the language messages

//Email pages and class
include INCLUDE_PATH . 'class_email_handler.php'; //email handler functions
$send_email = new send_email();

include INCLUDE_PATH . 'class_MPTTcategories.php'; //categories handler functions
include FEES_PATH . 'process_fees.php'; //fees handler functions

include INCLUDE_PATH . 'class_user.php'; //user handler functions
$user = new user();

//template handler and class
include TEMPLATE_PATH . 'Template.php'; //build the website template handler functions
$template = new template();

//password handler and class
include PLUGIN_PATH . 'PHPass/phpass.php'; //password handler functions
$phpass = new PasswordHash(8, false);

include PLUGIN_PATH . 'SEO/seo-core.php'; //SEO website links handler functions

include INCLUDE_PATH . 'errors.inc.php'; //error handler functions
set_error_handler('uAuctionsErrorHandler', $error_reporting); //error function for all errors to be submitted to db

// add auction types
$system->SETTINGS['auction_types'] = array();
if ($system->SETTINGS['standard_auctions'] == 'y') {		
	//only standard auction
	$system->SETTINGS['auction_types'][1] = $MSG['1021'];
}
if ($system->SETTINGS['dutch_auctions'] == 'y') {
	//only standard auction and dutch auction
	$system->SETTINGS['auction_types'][2] = $MSG['1020'];
}
if ($system->SETTINGS['di_auctions'] == 'y') {
	//only standard auction and digital item auction
	$system->SETTINGS['auction_types'][3] = $MSG['350_1010'];
}

// Atuomatically login user is necessary "Remember me" option
if (!$user->logged_in && isset($_COOKIE[$system->SETTINGS['cookie_name'] . '-RM_ID']))
{
	$user->rememberMe(alphanumeric($_COOKIE[$system->SETTINGS['cookie_name'] . '-RM_ID']));
}

if (!$user->is_logged_in())
{
	if($system->SETTINGS['daylight_savings'] == 'y')
	{
		if(date('I') == 1)
		{
			$system->tdiff = (time_correction($user->user_data['timecorrection'], 1) + 3600);
		}
		elseif(date('I') == 0)
		{
			$system->tdiff = (time_correction($user->user_data['timecorrection'], 1));
		}
	}
	elseif($system->SETTINGS['daylight_savings'] == 'n')
	{
		$system->tdiff = (time_correction($user->user_data['timecorrection'], 1));
	}
}

if(isset($_SESSION['REDIRECT_AFTER_LOGIN']) && !defined('AtLogin'))
{
	unset($_SESSION['REDIRECT_AFTER_LOGIN']);
}

$template->set_template();