<?php
# 
# Table structure for table `" . $DBPrefix . "accesseshistoric`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "accesseshistoric`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "accesseshistoric` (
  `month` char(2) NOT NULL default '',
  `year` char(4) NOT NULL default '',
  `pageviews` int(11) NOT NULL default '0',
  `uniquevisitiors` int(11) NOT NULL default '0',
  `usersessions` int(11) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "accesseshistoric`
#  

# ############################

# 
# Table structure for table `" . $DBPrefix . "accounts`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "accounts`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "accounts` (
	`id` INT(7) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	`nick` VARCHAR(20) NOT NULL,
	`name` TINYTEXT NOT NULL,
	`text` TEXT NOT NULL,
	`type` VARCHAR(15) NOT NULL,
	`paid_date` VARCHAR(16) NOT NULL,
	`amount` DOUBLE(6,2) NOT NULL,
	`day` INT(3) NOT NULL,
	`week` INT(2) NOT NULL,
	`month` INT(2) NOT NULL,
	`year` INT(4) NOT NULL
)";

# 
# Dumping data for table `" . $DBPrefix . "accounts`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "adsense`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "adsense`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "adsense` (
	`fieldname` varchar(50) NOT NULL,
	`fieldtype` varchar(10) NOT NULL,
	`value` text,
	`modifieddate` int(11) NOT NULL,
	`modifiedby` int(32) NOT NULL,
	PRIMARY KEY (`fieldname`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "adsense`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "adsense` VALUES ('header_banner_1', 'str', '', '', 1);";
$query[] = "INSERT INTO `" . $DBPrefix . "adsense` VALUES ('index_banner_2', 'str', '', '', 1);";
$query[] = "INSERT INTO `" . $DBPrefix . "adsense` VALUES ('index_banner_3', 'str', '', '', 1);";
$query[] = "INSERT INTO `" . $DBPrefix . "adsense` VALUES ('browse_banner_1', 'str', '', '', 1);";
$query[] = "INSERT INTO `" . $DBPrefix . "adsense` VALUES ('index_banner_1', 'str', '', '', 1);";


# ############################

# 
# Table structure for table `" . $DBPrefix . "adminusers`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "adminusers`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "adminusers` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(32) NOT NULL default '',
  `password` varchar(255) NOT NULL default '',
  `hash` varchar(5) NOT NULL default '',
  `created` varchar(8) NOT NULL default '',
  `lastlogin` varchar(14) NOT NULL default '',
  `status` int(2) NOT NULL default '0',
  `notes` text,
  KEY `id` (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "adminusers`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "auccounter`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "auccounter`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "auccounter` (
  `auction_id` int(11) NOT NULL default '0',
  `counter` int(11) NOT NULL default '0',
  PRIMARY KEY  (`auction_id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "auccounter`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "auctions`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "auctions`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "auctions` (
  `id` int(32) NOT NULL auto_increment,
  `user` int(32) default NULL,
  `title` varchar(70),
  `subtitle` varchar(70),
  `starts` varchar(14) default NULL,
  `description` text,
  `pict_url` tinytext,
  `category` int(11) default NULL,
  `secondcat` int(11) default NULL,
  `minimum_bid` double(16,2) default '0',
  `shipping_cost` double(16,2) default '0',
  `shipping_cost_additional` double(16,2) default '0',
  `reserve_price` double(16,2) default '0',
  `buy_now` double(16,2) default '0',
  `auction_type` char(1) default NULL,
  `duration` varchar(7) default NULL,
  `increment` double(8,2) NOT NULL default '0',
  `shipping` char(1) default NULL,
  `payment` tinytext,
  `international` char(1) default NULL,
  `ends` varchar(14) default NULL,
  `current_bid` double(16,2) default '0',
  `closed` int(1) default '0',
  `photo_uploaded` tinyint(1) default NULL,
  `quantity` int(11) default NULL,
  `suspended` int(1) default '0',
  `relist` int(11) NOT NULL default '0',
  `relisted` int(11) NOT NULL default '0',
  `num_bids` int(11) NOT NULL default '0',
  `sold` enum('y','n','s') NOT NULL default 'n',
  `shipping_terms` tinytext NOT NULL,
  `bn_only` enum('y','n') NOT NULL default 'n',
  `bold` enum('y','n') NOT NULL default 'n',
  `highlighted` enum('y','n') NOT NULL default 'n',
  `featured` enum('y','n') NOT NULL default 'n',
  `current_fee` double(16,2) default '0',
  `tax`  enum('y','n') NOT NULL default 'n',
  `taxinc`  enum('y','n') NOT NULL default 'y',
  `item_condition` varchar(40) default '',
  `item_manufacturer` varchar(32) default '',
  `item_model` varchar(32) default '',
  `item_colour` varchar(32) default '',
  `item_year` varchar(11) default '',
  `returns` char(1) default NULL,
  `sell_type` enum('free','sell') NOT NULL default 'sell',
  `locationMap`  enum('y','n') NOT NULL default 'n',
  PRIMARY KEY  (`id`),
  KEY `id` (`id`)
);";

# 
# Dumping data for table `" . $DBPrefix . "auctions`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "banners`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "banners`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "banners` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `type` enum('gif','jpg','png','swf') default NULL,
  `views` int(11) default NULL,
  `clicks` int(11) default NULL,
  `url` varchar(255) default NULL,
  `sponsortext` varchar(255) default NULL,
  `alt` varchar(255) default NULL,
  `purchased` int(11) NOT NULL default '0',
  `width` int(11) NOT NULL default '0',
  `height` int(11) NOT NULL default '0',
  `user` int(11) NOT NULL default '0',
  `seller` int(11) NOT NULL,
  KEY `id` (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "banners`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "bannerscategories`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "bannerscategories`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "bannerscategories` (
  `banner` int(11) NOT NULL default '0',
  `category` int(11) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "bannerscategories`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "bannerskeywords`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "bannerskeywords`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "bannerskeywords` (
  `banner` int(11) NOT NULL default '0',
  `keyword` varchar(255) NOT NULL default ''
) ;";

# 
# Dumping data for table `" . $DBPrefix . "bannerskeywords`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "bannersstats`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "bannersstats`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "bannersstats` (
  `banner` int(11) default NULL,
  `purchased` int(11) default NULL,
  `views` int(11) default NULL,
  `clicks` int(11) default NULL,
  KEY `id` (`banner`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "bannersstats`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "bannersusers`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "bannersusers`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "bannersusers` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `company` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `seller` int(11) default NULL,
  `newuser` enum('y','n') default NULL,
  `paid` int(2) default NULL,
  `ex_banner_paid` enum('y','n') default NULL,
  `time_stamp` int(20) default NULL,
  KEY `id` (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "bannersusers`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "bids`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "bids`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "bids` (
  `id` int(11) NOT NULL auto_increment,
  `auction` int(32) default NULL,
  `bidder` int(32) default NULL,
  `bid` double(16,2) default NULL,
  `bidwhen` varchar(14) default NULL,
  `quantity` int(11) default '0',
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "bids`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "categories`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "categories`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "categories` (
  `cat_id` int(4) NOT NULL auto_increment,
  `parent_id` int(4) default NULL,
  `left_id` INT(8) NOT NULL,
  `right_id` INT(8) NOT NULL,
  `level` INT(1) NOT NULL,
  `cat_name` tinytext,
  `sub_counter` int(11) default 0,
  `counter` int(11) default 0,
  `cat_colour` varchar(15) default '',
  `cat_image` varchar(150) default '',
  PRIMARY KEY  (`cat_id`),
  INDEX (`left_id`, `right_id`, `level`)
);";

# 
# Dumping data for table `" . $DBPrefix . "categories`
# 

if ($_GET['cats'] == 1)
{
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(1, -1, 1, 394, -1, 'All', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(2, 1, 340, 393, 0, 'Art &amp; Antiques', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(3, 2, 391, 392, 1, 'Textiles &amp; Linens', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(4, 2, 389, 390, 1, 'Amateur Art', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(5, 2, 387, 388, 1, 'Ancient World', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(6, 2, 385, 386, 1, 'Books &amp; Manuscripts', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(7, 2, 383, 384, 1, 'Cameras', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(8, 2, 363, 382, 1, 'Ceramics &amp; Glass', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(9, 8, 364, 381, 2, 'Glass', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(10, 9, 379, 380, 3, '40s, 50s &amp; 60s', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(11, 9, 377, 378, 3, 'Art Glass', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(12, 9, 375, 376, 3, 'Carnival', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(13, 9, 373, 374, 3, 'Chalkware', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(14, 9, 371, 372, 3, 'Chintz &amp; Shelley', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(15, 9, 369, 370, 3, 'Contemporary Glass', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(16, 9, 367, 368, 3, 'Decorative', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(17, 9, 365, 366, 3, 'Porcelain', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(18, 2, 361, 362, 1, 'Fine Art', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(19, 2, 359, 360, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(20, 2, 357, 358, 1, 'Musical Instruments', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(21, 2, 355, 356, 1, 'Orientalia', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(22, 2, 353, 354, 1, 'Painting', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(23, 2, 351, 352, 1, 'Photographic Images', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(24, 2, 349, 350, 1, 'Post-1900', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(25, 2, 347, 348, 1, 'Pre-1900', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(26, 2, 345, 346, 1, 'Prints', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(27, 2, 343, 344, 1, 'Scientific Instruments', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(28, 2, 341, 342, 1, 'Silver &amp; Silver Plate', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(29, 1, 262, 339, 0, 'Books', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(30, 29, 337, 338, 1, 'Animals', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(31, 29, 335, 336, 1, 'Arts, Architecture &amp; Photography', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(32, 29, 333, 334, 1, 'Audiobooks', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(33, 29, 331, 332, 1, 'Biographies &amp; Memoirs', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(34, 29, 329, 330, 1, 'Business &amp; Investing', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(35, 29, 327, 328, 1, 'Catalogs', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(36, 29, 325, 326, 1, 'Children', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(37, 29, 323, 324, 1, 'Computers &amp; Internet', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(38, 29, 321, 322, 1, 'Contemporary', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(39, 29, 319, 320, 1, 'Cooking, Food &amp; Wine', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(40, 29, 317, 318, 1, 'Entertainment', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(41, 29, 315, 316, 1, 'Foreign Language Instruction', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(42, 29, 313, 314, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(43, 29, 311, 312, 1, 'Health, Mind &amp; Body', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(44, 29, 309, 310, 1, 'Historical', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(45, 29, 307, 308, 1, 'History', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(46, 29, 305, 306, 1, 'Home &amp; Garden', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(47, 29, 303, 304, 1, 'Horror', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(48, 29, 301, 302, 1, 'Illustrated', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(49, 29, 299, 300, 1, 'Literature &amp; Fiction', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(50, 29, 297, 298, 1, 'Men', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(51, 29, 295, 296, 1, 'Mystery &amp; Thrillers', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(52, 29, 293, 294, 1, 'News', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(53, 29, 291, 292, 1, 'Nonfiction', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(54, 29, 289, 290, 1, 'Parenting &amp; Families', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(55, 29, 287, 288, 1, 'Poetry', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(56, 29, 285, 286, 1, 'Rare', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(57, 29, 283, 284, 1, 'Reference', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(58, 29, 281, 282, 1, 'Regency', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(59, 29, 279, 280, 1, 'Religion &amp; Spirituality', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(60, 29, 277, 278, 1, 'Science &amp; Nature', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(61, 29, 275, 276, 1, 'Science Fiction &amp; Fantasy', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(62, 29, 273, 274, 1, 'Sports', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(63, 29, 271, 272, 1, 'Sports &amp; Outdoors', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(64, 29, 269, 270, 1, 'Teens', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(65, 29, 267, 268, 1, 'Textbooks', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(66, 29, 265, 266, 1, 'Travel', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(67, 29, 263, 264, 1, 'Women', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(68, 1, 254, 261, 0, 'Clothing &amp; Accessories', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(69, 68, 259, 260, 1, 'Accessories', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(70, 68, 257, 258, 1, 'Clothing', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(71, 68, 255, 256, 1, 'Watches', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(72, 1, 248, 253, 0, 'Coins &amp; Stamps', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(73, 72, 251, 252, 1, 'Coins', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(74, 72, 249, 250, 1, 'Philately', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(75, 1, 172, 247, 0, 'Collectibles', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(76, 75, 245, 246, 1, 'Advertising', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(77, 75, 243, 244, 1, 'Animals', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(78, 75, 241, 242, 1, 'Animation', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(79, 75, 239, 240, 1, 'Antique Reproductions', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(80, 75, 237, 238, 1, 'Autographs', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(81, 75, 235, 236, 1, 'Barber Shop', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(82, 75, 233, 234, 1, 'Bears', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(83, 75, 231, 232, 1, 'Bells', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(84, 75, 229, 230, 1, 'Bottles &amp; Cans', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(85, 75, 227, 228, 1, 'Breweriana', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(86, 75, 225, 226, 1, 'Cars &amp; Motorcycles', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(87, 75, 223, 224, 1, 'Cereal Boxes &amp; Premiums', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(88, 75, 221, 222, 1, 'Character', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(89, 75, 219, 220, 1, 'Circus &amp; Carnival', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(90, 75, 217, 218, 1, 'Collector Plates', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(91, 75, 215, 216, 1, 'Dolls', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(92, 75, 213, 214, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(93, 75, 211, 212, 1, 'Historical &amp; Cultural', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(94, 75, 209, 210, 1, 'Holiday &amp; Seasonal', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(95, 75, 207, 208, 1, 'Household Items', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(96, 75, 205, 206, 1, 'Kitsch', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(97, 75, 203, 204, 1, 'Knives &amp; Swords', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(98, 75, 201, 202, 1, 'Lunchboxes', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(99, 75, 199, 200, 1, 'Magic &amp; Novelty Items', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(100, 75, 197, 198, 1, 'Memorabilia', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(101, 75, 195, 196, 1, 'Militaria', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(102, 75, 193, 194, 1, 'Music Boxes', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(103, 75, 191, 192, 1, 'Oddities', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(104, 75, 189, 190, 1, 'Paper', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(105, 75, 187, 188, 1, 'Pinbacks', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(106, 75, 185, 186, 1, 'Porcelain Figurines', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(107, 75, 183, 184, 1, 'Railroadiana', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(108, 75, 181, 182, 1, 'Religious', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(109, 75, 179, 180, 1, 'Rocks, Minerals &amp; Fossils', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(110, 75, 177, 178, 1, 'Scientific Instruments', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(111, 75, 175, 176, 1, 'Textiles', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(112, 75, 173, 174, 1, 'Tobacciana', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(113, 1, 154, 171, 0, 'Comics, Cards &amp; Science Fiction', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(114, 113, 169, 170, 1, 'Anime &amp; Manga', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(115, 113, 167, 168, 1, 'Comic Books', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(116, 113, 165, 166, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(117, 113, 163, 164, 1, 'Godzilla', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(118, 113, 161, 162, 1, 'Star Trek', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(119, 113, 159, 160, 1, 'The X-Files', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(120, 113, 157, 158, 1, 'Toys', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(121, 113, 155, 156, 1, 'Trading Cards', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(122, 1, 144, 153, 0, 'Computers &amp; Software', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(123, 122, 151, 152, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(124, 122, 149, 150, 1, 'Hardware', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(125, 122, 147, 148, 1, 'Internet Services', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(126, 122, 145, 146, 1, 'Software', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(127, 1, 132, 143, 0, 'Electronics &amp; Photography', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(128, 127, 141, 142, 1, 'Consumer Electronics', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(129, 127, 139, 140, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(130, 127, 137, 138, 1, 'Photo Equipment', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(131, 127, 135, 136, 1, 'Recording Equipment', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(132, 127, 133, 134, 1, 'Video Equipment', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(133, 1, 112, 131, 0, 'Home &amp; Garden', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(134, 133, 129, 130, 1, 'Baby Items', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(135, 133, 127, 128, 1, 'Crafts', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(136, 133, 125, 126, 1, 'Furniture', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(137, 133, 123, 124, 1, 'Garden', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(138, 133, 121, 122, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(139, 133, 119, 120, 1, 'Household Items', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(140, 133, 117, 118, 1, 'Pet Supplies', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(141, 133, 115, 116, 1, 'Tools &amp; Hardware', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(142, 133, 113, 114, 1, 'Weddings', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(143, 1, 98, 111, 0, 'Movies &amp; Video', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(144, 143, 109, 110, 1, 'Blueray', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(145, 143, 107, 108, 1, 'DVD', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(146, 143, 105, 106, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(147, 143, 103, 104, 1, 'HD-DVD', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(148, 143, 101, 102, 1, 'Laser Discs', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(149, 143, 99, 100, 1, 'VHS', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(150, 1, 84, 97, 0, 'Music', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(151, 150, 95, 96, 1, 'CDs', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(152, 150, 93, 94, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(153, 150, 91, 92, 1, 'Instruments', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(154, 150, 89, 90, 1, 'Memorabilia', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(155, 150, 87, 88, 1, 'Records', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(156, 150, 85, 86, 1, 'Tapes', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(157, 1, 74, 83, 0, 'Office &amp; Business', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(158, 157, 81, 82, 1, 'Briefcases', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(159, 157, 79, 80, 1, 'Fax Machines', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(160, 157, 77, 78, 1, 'General Equipment', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(161, 157, 75, 76, 1, 'Pagers', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(162, 1, 58, 73, 0, 'Other Goods &amp; Services', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(163, 162, 71, 72, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(164, 162, 69, 70, 1, 'Metaphysical', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(165, 162, 67, 68, 1, 'Property', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(166, 162, 65, 66, 1, 'Services', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(167, 162, 63, 64, 1, 'Tickets &amp; Events', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(168, 162, 61, 62, 1, 'Transportation', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(169, 162, 59, 60, 1, 'Travel', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(170, 1, 50, 57, 0, 'Sports &amp; Recreation', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(171, 170, 55, 56, 1, 'Apparel &amp; Equipment', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(172, 170, 53, 54, 1, 'Exercise Equipment', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(173, 170, 51, 52, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(174, 1, 2, 49, 0, 'Toys &amp; Games', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(175, 174, 47, 48, 1, 'Action Figures', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(176, 174, 45, 46, 1, 'Beanie Babies &amp; Beanbag Toys', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(177, 174, 43, 44, 1, 'Diecast', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(178, 174, 41, 42, 1, 'Fast Food', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(179, 174, 39, 40, 1, 'Fisher-Price', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(180, 174, 37, 38, 1, 'Furby', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(181, 174, 35, 36, 1, 'Games', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(182, 174, 33, 34, 1, 'General', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(183, 174, 31, 32, 1, 'Giga Pet &amp; Tamagotchi', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(184, 174, 29, 30, 1, 'Hobbies', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(185, 174, 27, 28, 1, 'Marbles', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(186, 174, 25, 26, 1, 'My Little Pony', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(187, 174, 23, 24, 1, 'Peanuts Gang', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(188, 174, 21, 22, 1, 'Pez', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(189, 174, 19, 20, 1, 'Plastic Models', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(190, 174, 17, 18, 1, 'Plush Toys', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(191, 174, 15, 16, 1, 'Puzzles', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(192, 174, 13, 14, 1, 'lot Cars', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(193, 174, 11, 12, 1, 'Teletubbies', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(194, 174, 9, 10, 1, 'Toy Soldiers', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(195, 174, 7, 8, 1, 'Vintage', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(196, 174, 5, 6, 1, 'Vintage Tin', 0, 0, '', '');";
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(197, 174, 3, 4, 1, 'Vintage Vehicles', 0, 0, '', '');";
}
else
{
	$query[] = "INSERT INTO `" . $DBPrefix . "categories` VALUES(NULL, -1, 1, 2, -1, 'All', 0, 0, '', '');";
}

# ############################

# 
# Table structure for table `" . $DBPrefix . "closedrelisted`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "closedrelisted`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "closedrelisted` (
  `auction` int(32) default '0',
  `relistdate` varchar(8) NOT NULL default '',
  `newauction` int(32) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "closedrelisted`
# 

# Table structure for table `" . $DBPrefix . "comm_messages`

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "comm_messages`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "comm_messages` (
  `id` int(11) NOT NULL auto_increment,
  `boardid` int(11) NOT NULL default '0',
  `msgdate` varchar(14) NOT NULL default '',
  `user` int(11) NOT NULL default '0',
  `username` varchar(255) NOT NULL default '',
  `message` text NOT NULL,
  KEY `msg_id` (`id`)
);";

# Dumping data for table `" . $DBPrefix . "comm_messages`


# Table structure for table `" . $DBPrefix . "community`

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "community`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "community` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '0',
  `messages` int(11) NOT NULL default '0',
  `lastmessage` varchar(14) NOT NULL default '0',
  `msgstoshow` int(11) NOT NULL default '0',
  `active` int(1) NOT NULL default '1',
  KEY `msg_id` (`id`)
);";

# Dumping data for table `" . $DBPrefix . "community`

$query[] = "INSERT INTO `" . $DBPrefix . "community` VALUES (1, 'Selling', 0, '', 30, 1);";
$query[] = "INSERT INTO `" . $DBPrefix . "community` VALUES (2, 'Buying', 0, '', 30, 1);";

# ############################

# 
# Table structure for table `" . $DBPrefix . "counters`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "counters`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "counters` (
  `users` int(11) default '0',
  `inactiveusers` int(11) NOT NULL default '0',
  `auctions` int(11) default '0',
  `closedauctions` int(11) NOT NULL default '0',
  `bids` int(11) NOT NULL default '0',
  `suspendedauctions` int(11) NOT NULL default '0',
  `items_sold` int(11) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "counters`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "counters` VALUES (0, 0, 0, 0, 0, 0, 0);";


# ############################

# 
# Table structure for table `" . $DBPrefix . "conditions`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "conditions`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "conditions` (
  `item_condition` varchar(40) NOT NULL default '',
  `condition_desc` varchar(200) default NULL
) ;";

# 
# Dumping data for table `" . $DBPrefix . "conditions`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "conditions` (`item_condition`, `condition_desc`) VALUES
('As New', 'As New: A used item that is fully functional and in excellent cosmetic condition,possibly without original packaging'),
('As New Never Used', 'As New Never Used: A brand-new unused item may not be in original packaging or packaging may not be sealed'),
('Brand New', 'Brand New: A brand-new unused unopened undamaged item ,in it&#39;s original packaging'),
('Faulty Suit Parts Only', 'Faulty Suit Parts Only: An item that has damage or is not working and is not worth repairing but may be used for parts'),
('Faulty Suit Parts or Repair', 'Faulty Suit Parts or Repair: An item that has damage or is not working and is possibly worth repairing or may be used for parts'),
('Manufacturer Refurbished', 'Manufacturer Refurbished: An item that has been restored by either the manufacturer or a professional repairer item should be perfect working order and in good cosmetic condition'),
('New Old Stock', 'New Old Stock: An item which was manufactured long ago but that has never been used and is either out of production or discontinued from the current line of product or has been sitting stored for some'),
('New With Tags', 'New With Tags: A brand-new unused and unworn item in it&#39;s original packaging if originally sold packaged with the original manufacturers tags'),
('New Without Tags', 'New Without Tags: A brand-new unused and unworn item maybe missing it&#39;s original packaging if originally sold packaged and without the original manufacturers tags'),
('Pre-Owned', 'Pre-Owned: An item that has been worn previously'),
('Seller Refurbished', 'Seller Refurbished: An item that has been restored by either the seller or a non professional repairer item should be perfect working order and in good cosmetic condition'),
('Used', 'Used: An item that has been used and may show signs of wear and tear but should be fully functional,unless stated in the item description.'),
('Factory Second', 'Factory Second: An item that is fully functional but may have some cosmectic damage ie dents or scratches');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "countries`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "countries`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "countries` (
  `country` varchar(40) NOT NULL default '',
  PRIMARY KEY  (`country`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "countries`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Afghanistan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Albania');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Algeria');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('American Samoa');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Andorra');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Angola');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Anguilla');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Antarctica');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Antigua And Barbuda');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Argentina');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Armenia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Aruba');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Australia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Austria');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Azerbaijan Republic');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bahamas');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bahrain');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bangladesh');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Barbados');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Belarus');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Belgium');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Belize');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Benin');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bermuda');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bhutan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bolivia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bosnia and Herzegowina');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Botswana');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bouvet Island');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Brazil');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('British Indian Ocean Territory');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Brunei Darussalam');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Bulgaria');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Burkina Faso');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Burma');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Burundi');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Cambodia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Cameroon');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Canada');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Cape Verde');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Cayman Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Central African Republic');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Chad');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Chile');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('China');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Christmas Island');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Cocos &#40;Keeling&#41; Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Colombia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Comoros');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Congo');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Congo, the Democratic Republic');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Cook Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Costa Rica');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Cote d&#39;Ivoire');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Croatia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Cyprus');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Czech Republic');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Denmark');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Djibouti');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Dominica');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Dominican Republic');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('East Timor');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Ecuador');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Egypt');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('El Salvador');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Equatorial Guinea');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Eritrea');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Estonia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Ethiopia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Falkland Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Faroe Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Fiji');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Finland');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('France');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('French Guiana');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('French Polynesia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('French Southern Territories');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Gabon');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Gambia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Georgia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Germany');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Ghana');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Gibraltar');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Great Britain');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Greece');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Greenland');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Grenada');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Guadeloupe');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Guam');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Guatemala');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Guinea');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Guinea-Bissau');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Guyana');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Haiti');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Heard and Mc Donald Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Honduras');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Hong Kong');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Hungary');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Iceland');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('India');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Indonesia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Ireland');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Israel');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Italy');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Jamaica');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Japan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Jordan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Kazakhstan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Kenya');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Kiribati');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Korea &#40;South&#41;');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Kuwait');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Kyrgyzstan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Lao People&#39;s Democratic Republic');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Latvia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Lebanon');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Lesotho');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Liberia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Liechtenstein');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Lithuania');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Luxembourg');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Macau');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Macedonia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Madagascar');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Malawi');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Malaysia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Maldives');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Mali');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Malta');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Marshall Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Martinique');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Mauritania');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Mauritius');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Mayotte');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Mexico');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Micronesia, Federated States of');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Moldova, Republic of');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Monaco');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Mongolia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Montserrat');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Morocco');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Mozambique');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Namibia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Nauru');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Nepal');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Netherlands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Netherlands Antilles');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('New Caledonia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('New Zealand');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Nicaragua');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Niger');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Nigeria');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Niuev');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Norfolk Island');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Northern Mariana Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Norway');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Oman');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Pakistan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Palau');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Panama');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Papua New Guinea');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Paraguay');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Peru');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Philippines');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Pitcairn');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Poland');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Portugal');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Puerto Rico');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Qatar');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Reunion');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Romania');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Russian Federation');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Rwanda');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Saint Kitts and Nevis');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Saint Lucia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Saint Vincent and the Grenadin');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Samoa &#40;Independent&#41;');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('San Marino');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Sao Tome and Principe');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Saudi Arabia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Senegal');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Seychelles');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Sierra Leone');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Singapore');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Slovakia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Slovenia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Solomon Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Somalia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('South Africa');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('South Georgia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Spain');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Sri Lanka');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('St. Helena');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('St. Pierre and Miquelon');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Suriname');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Svalbard and Jan Mayen Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Swaziland');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Sweden');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Switzerland');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Taiwan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Tajikistan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Tanzania');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Thailand');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Togo');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Tokelau');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Tonga');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Trinidad and Tobago');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Tunisia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Turkey');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Turkmenistan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Turks and Caicos Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Tuvalu');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Uganda');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Ukraine');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('United Arab Emiratesv');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('United Kingdom');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('United States');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Uruguay');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Uzbekistan');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Vanuatu');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Venezuela');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Viet Nam');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Virgin Islands &#40;British&#41;');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Virgin Islands &#40;U.S.&#41;');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Wallis and Futuna Islands');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Western Sahara');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Yemen');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Zambia');";
$query[] = "INSERT INTO `" . $DBPrefix . "countries` VALUES ('Zimbabwe');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "currentaccesses`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "currentaccesses`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "currentaccesses` (
  `day` char(2) NOT NULL default '0',
  `month` char(2) NOT NULL default '0',
  `year` char(4) NOT NULL default '0',
  `pageviews` int(11) NOT NULL default '0',
  `uniquevisitors` int(11) NOT NULL default '0',
  `usersessions` int(11) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "currentaccesses`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "currentbrowsers`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "currentbrowsers`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "currentbrowsers` (
  `month` char(2) NOT NULL default '0',
  `year` varchar(4) NOT NULL default '0',
  `browser` varchar(50) NOT NULL default '0',
  `counter` int(11) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "currentbrowsers`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "currentplatforms`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "currentplatforms`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "currentplatforms` (
  `month` char(2) NOT NULL default '0',
  `year` varchar(4) NOT NULL default '0',
  `platform` varchar(120) NOT NULL default '0',
  `counter` int(11) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "currentplatforms`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "currentbots`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "currentbots`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "currentbots` (
  `month` char(2) NOT NULL default '0',
  `year` varchar(4) NOT NULL default '0',
  `platform` varchar(120) NOT NULL default '0',
  `browser` varchar(50) NOT NULL default '0',
  `counter` int(11) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "currentbots`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "durations`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "durations`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "durations` (
  `days` int(11) NOT NULL default '0',
  `description` varchar(30) default NULL
) ;";

# 
# Dumping data for table `" . $DBPrefix . "durations`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "durations` VALUES (1, '1 day');";
$query[] = "INSERT INTO `" . $DBPrefix . "durations` VALUES (2, '2 days');";
$query[] = "INSERT INTO `" . $DBPrefix . "durations` VALUES (3, '3 days');";
$query[] = "INSERT INTO `" . $DBPrefix . "durations` VALUES (7, '1 week');";
$query[] = "INSERT INTO `" . $DBPrefix . "durations` VALUES (14, '2 weeks');";
$query[] = "INSERT INTO `" . $DBPrefix . "durations` VALUES (21, '3 weeks');";
$query[] = "INSERT INTO `" . $DBPrefix . "durations` VALUES (30, '1 month');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "email_blocks`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "email_blocks`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "email_blocks` (
  `id` int(11) NOT NULL auto_increment,
  `email_check` varchar(200) NOT NULL default '',
  KEY `id` (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "email_blocks`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "email_blocks` (`id`, `email_check`) VALUES
(1, '0815.ru0clickemail.com'),
(2, '0wnd.net'),
(3, '0wnd.org'),
(4, '10minutemail.com'),
(5, '20minutemail.com'),
(6, '2prong.com'),
(7, '3d-painting.com'),
(8, '4warding.com'),
(9, '4warding.net'),
(10, '4warding.org'),
(11, '9ox.net'),
(12, 'a-bc.net'),
(13, 'amilegit.com'),
(14, 'anonbox.net'),
(15, 'anonymbox.com'),
(16, 'antichef.com'),
(17, 'antichef.net'),
(18, 'antispam.de'),
(19, 'baxomale.ht.cx'),
(20, 'beefmilk.com'),
(21, 'binkmail.com'),
(22, 'bio-muesli.net'),
(23, 'bobmail.info'),
(24, 'bodhi.lawlita.com'),
(25, 'bofthew.com'),
(26, 'brefmail.com'),
(27, 'bsnow.net'),
(28, 'bugmenot.com'),
(29, 'bumpymail.com'),
(30, 'casualdx.com'),
(31, 'chogmail.com'),
(32, 'cool.fr.nf'),
(33, 'correo.blogos.net'),
(34, 'cosmorph.com'),
(35, 'courriel.fr.nf'),
(36, 'courrieltemporaire.com'),
(37, 'curryworld.de'),
(38, 'cust.in'),
(39, 'dacoolest.com'),
(40, 'dandikmail.com'),
(41, 'deadaddress.com'),
(42, 'despam.it'),
(43, 'devnullmail.com'),
(44, 'dfgh.net'),
(45, 'digitalsanctuary.com'),
(46, 'discardmail.com'),
(47, 'discardmail.de'),
(48, 'disposableaddress.com'),
(49, 'disposemail.com'),
(50, 'dispostable.com'),
(51, 'dm.w3internet.co.uk example.com'),
(52, 'dodgeit.com'),
(53, 'dodgit.com'),
(54, 'dodgit.org'),
(55, 'dontreg.com'),
(56, 'dontsendmespam.de'),
(57, 'dump-email.info'),
(58, 'dumpyemail.com'),
(59, 'e4ward.com'),
(60, 'email60.com'),
(61, 'emailias.com'),
(62, 'emailinfive.com'),
(63, 'emailmiser.com'),
(64, 'emailtemporario.com.br'),
(65, 'emailwarden.com'),
(66, 'ephemail.net'),
(67, 'explodemail.com'),
(68, 'fakeinbox.com'),
(69, 'fakeinformation.com'),
(70, 'fastacura.com'),
(71, 'filzmail.com'),
(72, 'fizmail.com'),
(73, 'frapmail.com'),
(74, 'garliclife.com'),
(75, 'get1mail.com'),
(76, 'getonemail.com'),
(77, 'getonemail.net'),
(78, 'girlsundertheinfluence.com'),
(79, 'gishpuppy.com'),
(80, 'great-host.in'),
(81, 'gsrv.co.uk'),
(82, 'guerillamail.biz'),
(83, 'guerillamail.com'),
(84, 'guerillamail.net'),
(85, 'guerillamail.org'),
(86, 'guerrillamail.com'),
(87, 'guerrillamailblock.com'),
(88, 'haltospam.com'),
(89, 'hotpop.com'),
(90, 'ieatspam.eu'),
(91, 'ieatspam.info'),
(92, 'ihateyoualot.info'),
(93, 'imails.info'),
(94, 'inboxclean.com'),
(95, 'inboxclean.org'),
(96, 'incognitomail.com'),
(97, 'incognitomail.net'),
(98, 'ipoo.org'),
(99, 'irish2me.com'),
(100, 'jetable.com'),
(101, 'jetable.fr.nf'),
(102, 'jetable.net'),
(103, 'jetable.org'),
(104, 'junk1e.com'),
(105, 'kaspop.com'),
(106, 'kulturbetrieb.info'),
(107, 'kurzepost.de'),
(108, 'lifebyfood.com'),
(109, 'link2mail.net'),
(110, 'litedrop.com'),
(111, 'lookugly.com'),
(112, 'lopl.co.cc'),
(113, 'lr78.com'),
(114, 'maboard.com'),
(115, 'mail.by'),
(116, 'mail.mezimages.net'),
(117, 'mail4trash.com'),
(118, 'mailbidon.com'),
(119, 'mailcatch.com'),
(120, 'maileater.com'),
(121, 'mailexpire.com'),
(122, 'mailin8r.com'),
(123, 'mailinator.com'),
(124, 'mailinator.net'),
(125, 'mailinator2.com'),
(126, 'mailincubator.com'),
(127, 'mailme.lv'),
(128, 'mailnator.com'),
(129, 'mailnull.com'),
(130, 'mailzilla.org'),
(131, 'mbx.cc'),
(132, 'mega.zik.dj'),
(133, 'meltmail.com'),
(134, 'mierdamail.com'),
(135, 'mintemail.com'),
(136, 'moncourrier.fr.nf'),
(137, 'monemail.fr.nf'),
(138, 'monmail.fr.nf'),
(139, 'mt2009.com'),
(140, 'mx0.wwwnew.eu'),
(141, 'mycleaninbox.net'),
(142, 'mytrashmail.com'),
(143, 'neverbox.com'),
(144, 'nobulk.com'),
(145, 'noclickemail.com'),
(146, 'nogmailspam.info'),
(147, 'nomail.xl.cx'),
(148, 'nomail2me.com'),
(149, 'no-spam.ws'),
(150, 'nospam.ze.tc'),
(151, 'nospam4.us'),
(152, 'nospamfor.us'),
(153, 'nowmymail.com'),
(154, 'objectmail.com'),
(155, 'obobbo.com'),
(156, 'onewaymail.com'),
(157, 'ordinaryamerican.net'),
(158, 'owlpic.com'),
(159, 'pookmail.com'),
(160, 'proxymail.eu'),
(161, 'punkass.com'),
(162, 'putthisinyourspamdatabase.com'),
(163, 'quickinbox.com'),
(164, 'rcpt.at'),
(165, 'recode.me'),
(166, 'recursor.net'),
(167, 'rediff.com'),
(168, 'regbypass.comsafe-mail.net'),
(169, 'safetymail.info'),
(170, 'sandelf.de'),
(171, 'saynotospams.com'),
(172, 'selfdestructingmail.com'),
(173, 'sendspamhere.com'),
(174, 'shiftmail.com'),
(175, '****mail.me'),
(176, 'skeefmail.com'),
(177, 'slopsbox.com'),
(178, 'smellfear.com'),
(179, 'snakemail.com'),
(180, 'sneakemail.com'),
(181, 'sofort-mail.de'),
(182, 'sogetthis.com'),
(183, 'soodonims.com'),
(184, 'spam.la'),
(185, 'spamavert.com'),
(186, 'spambob.net'),
(187, 'spambob.org'),
(188, 'spambog.com'),
(189, 'spambog.de'),
(190, 'spambog.ru'),
(191, 'spambox.info'),
(192, 'spambox.us'),
(193, 'spamcannon.com'),
(194, 'spamcannon.net'),
(195, 'spamcero.com'),
(196, 'spamcorptastic.com'),
(197, 'spamcowboy.com'),
(198, 'spamcowboy.net'),
(199, 'spamcowboy.org'),
(200, 'spamday.com'),
(201, 'spamex.com'),
(202, 'spamfree24.com'),
(203, 'spamfree24.de'),
(204, 'spamfree24.eu'),
(205, 'spamfree24.info'),
(206, 'spamfree24.net'),
(207, 'spamfree24.org'),
(208, 'spamgourmet.com'),
(209, 'spamgourmet.net'),
(210, 'spamgourmet.org'),
(211, 'spamherelots.com'),
(212, 'spamhereplease.com'),
(213, 'spamhole.com'),
(214, 'spamify.com'),
(215, 'spaminator.de'),
(216, 'spamkill.info'),
(217, 'spaml.com'),
(218, 'spaml.de'),
(219, 'spammotel.com'),
(220, 'spamobox.com'),
(221, 'spamspot.com'),
(222, 'spamthis.co.uk'),
(223, 'spamthisplease.com'),
(224, 'speed.1s.fr'),
(225, 'suremail.info'),
(226, 'tempalias.com'),
(227, 'tempemail.biz'),
(228, 'tempemail.com'),
(229, 'tempe-mail.com'),
(230, 'tempemail.net'),
(231, 'tempinbox.co.uk'),
(232, 'tempinbox.com'),
(233, 'tempomail.fr'),
(234, 'temporaryemail.net'),
(235, 'temporaryinbox.com'),
(236, 'thankyou2010.com'),
(237, 'thisisnotmyrealemail.com'),
(238, 'throwawayemailaddress.com'),
(239, 'tilien.com'),
(240, 'tmailinator.com'),
(241, 'tradermail.info'),
(242, 'trash2009.com'),
(243, 'trash-amil.com'),
(244, 'trashmail.at'),
(245, 'trash-mail.at'),
(246, 'trashmail.com'),
(247, 'trash-mail.com'),
(248, 'trash-mail.de'),
(249, 'trashmail.me'),
(250, 'trashmail.net'),
(251, 'trashymail.com'),
(252, 'trashymail.net'),
(253, 'tyldd.com'),
(254, 'uggsrock.com'),
(255, 'wegwerfmail.de'),
(256, 'wegwerfmail.net'),
(257, 'wegwerfmail.org'),
(258, 'wh4f.org'),
(259, 'whyspam.me'),
(260, 'willselfdestruct.com'),
(261, 'winemaven.info'),
(262, 'wronghead.com'),
(263, 'wuzupmail.net'),
(264, 'xoxy.net'),
(265, 'yogamaven.com'),
(266, 'yopmail.com'),
(267, 'yopmail.fr'),
(268, 'yopmail.net'),
(269, 'yuurok.com'),
(270, 'zippymail.info'),
(271, 'jnxjn.com'),
(272, 'trashmailer.com'),
(273, 'klzlk.com'),
(273, 'sina.com');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "faqs`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "faqs`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "faqs` (
  `id` int(11) NOT NULL auto_increment,
  `question` varchar(200) NOT NULL default '',
  `answer` text NOT NULL,
  `category` int(11) NOT NULL default '0',
  KEY `id` (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "faqs`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "faqs` VALUES (2, 'Registering', 'To register as a new user, click on Register at the top of the window. You will be asked for your name, a username and password, and contact information, including your email address.\r\n\r\n<B>You must be at least 18 years of age to register.</B>!', 1);";
$query[] = "INSERT INTO `" . $DBPrefix . "faqs` VALUES (4, 'Item Watch', '<b>Item watch</b> notifies you when someone bids on the auctions that you have added to your Item Watch. ', 3);";
$query[] = "INSERT INTO `" . $DBPrefix . "faqs` VALUES (5, 'What is a Dutch auction?', 'Dutch auction is a type of auction where the auctioneer begins with a high asking price which is lowered until some participant is willing to accept the auctioneer\'s price. The winning participant pays the last announced price.', 1);";

# ############################

# 
# Table structure for table `" . $DBPrefix . "faqs_translated`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "faqs_translated`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "faqs_translated` (
  `id` int(11) NOT NULL auto_increment,
  `lang` char(2) NOT NULL default '',
  `question` varchar(200) NOT NULL default '',
  `answer` text NOT NULL,
  KEY `id` (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "faqs_translated`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "faqs_translated` VALUES (2, 'EN', 'Registering', 'To register as a new user, click on Register at the top of the window. You will be asked for your name, a username and password, and contact information, including your email address.\r\n\r\n<B>You must be at least 18 years of age to register.</B>!');";
$query[] = "INSERT INTO `" . $DBPrefix . "faqs_translated` VALUES (4, 'EN', 'Item Watch', '<b>Item watch</b> notifies you when someone bids on the auctions that you have added to your Item Watch. ');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "faqscat_translated`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "faqscat_translated`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "faqscat_translated` (
  `id` int(11) NOT NULL default '0',
  `lang` char(2) NOT NULL default '',
  `category` varchar(255) NOT NULL default ''
) ;";

# 
# Dumping data for table `" . $DBPrefix . "faqscat_translated`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "faqscat_translated` VALUES (3, 'EN', 'Buying');";
$query[] = "INSERT INTO `" . $DBPrefix . "faqscat_translated` VALUES (1, 'EN', 'General');";
$query[] = "INSERT INTO `" . $DBPrefix . "faqscat_translated` VALUES (2, 'EN', 'Selling');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "faqscategories`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "faqscategories`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "faqscategories` (
  `id` int(11) NOT NULL auto_increment,
  `category` varchar(200) NOT NULL default '',
  KEY `id` (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "faqscategories`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "faqscategories` VALUES (1, 'General');";
$query[] = "INSERT INTO `" . $DBPrefix . "faqscategories` VALUES (2, 'Selling');";
$query[] = "INSERT INTO `" . $DBPrefix . "faqscategories` VALUES (3, 'Buying');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "favesellers`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "favesellers`;";
$query[] = "CREATE TABLE  `" . $DBPrefix . "favesellers` (
  `id` int(10) NOT NULL AUTO_INCREMENT ,
  `user_id` int(10) NOT NULL ,
  `seller_id` int(10) NOT NULL ,
  PRIMARY KEY (`id`)
);";

# 
# Dumping data for table `" . $DBPrefix . "favesellers`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "fblogin`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "fblogin`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "fblogin` (
   `id` int(30) NOT NULL auto_increment,
   `fb_id` varchar(150) default NULL,
   `name` varchar(60) default NULL,
   `email` varchar(100) default NULL,
   `image` varchar(600) default NULL,
   `postdate` int(100) default NULL,
   `address` varchar(100) default NULL,
   `phone` varchar(60) default NULL,
   `birthday` varchar(50) default NULL,
   `status` varchar(50) default NULL,
   PRIMARY KEY  (`id`)
 ) ;";
 
# 
# Dumping data for table `" . $DBPrefix . "fblogin`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "feedbacks`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "feedbacks`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "feedbacks` (
  `id` int(11) NOT NULL auto_increment,
  `rated_user_id` int(32) default NULL,
  `rater_user_nick` varchar(20) default NULL,
  `feedback` mediumtext,
  `rate` int(2) default NULL,
  `feedbackdate` INT(15) NOT NULL,
  `auction_id` int(32) NOT NULL default '0',
  `auction_title` varchar(200) default NULL,
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "feedbacks`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "fees`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "fees`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "fees` (
  `id` INT(5) NOT NULL AUTO_INCREMENT,
  `fee_from` double(16,2) NOT NULL default '0',
  `fee_to` double(16,2) NOT NULL default '0',
  `fee_type` enum('flat', 'perc') NOT NULL default 'flat',
  `value` double(8,2) NOT NULL default '0',
  `type` varchar(15) NOT NULL,
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "fees`
# 

$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'signup_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'buyer_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'setup');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'hpfeat_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'bolditem_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'hlitem_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'rp_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'picture_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'subtitle_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'excat_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'relist_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'buyout_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'endauc_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'banner_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'ex_banner_fee');";
$query[] = "INSERT INTO " . $DBPrefix . "fees (value, type) VALUES (0, 'geomap_fee');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "filterwords`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "filterwords`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "filterwords` (
  `word` varchar(255) NOT NULL default ''
) ;";

# 
# Dumping data for table `" . $DBPrefix . "filterwords`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "filterwords` VALUES ('');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "gateways`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "gateways`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "gateways` (
  `gateways` text,
  `paypal_address` varchar(50) NOT NULL default '',
  `paypal_required` int(1) NOT NULL default '0',
  `paypal_active` int(1) NOT NULL default '0',
  `authnet_address` varchar(50) NOT NULL default '',
  `authnet_password` varchar(50) NOT NULL default '',
  `authnet_required` int(1) NOT NULL default '0',
  `authnet_active` int(1) NOT NULL default '0',
  `worldpay_address` varchar(50) NOT NULL default '',
  `worldpay_required` int(1) NOT NULL default '0',
  `worldpay_active` int(1) NOT NULL default '0',
  `skrill_address` varchar(50) NOT NULL default '',
  `skrill_required` int(1) NOT NULL default '0',
  `skrill_active` int(1) NOT NULL default '0',
  `toocheckout_address` varchar(50) NOT NULL default '',
  `toocheckout_required` int(1) NOT NULL default '0',
  `toocheckout_active` int(1) NOT NULL default '0',
  `bank_name` varchar(50) NOT NULL default '',
  `bank_account` varchar(50) NOT NULL default '',
  `bank_routing` varchar(50) NOT NULL default '',
  `bank_required` int(1) NOT NULL default '0',
  `bank_active` int(1) NOT NULL default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "gateways`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "gateways` VALUES ('paypal,authnet,worldpay,skrill,toocheckout,bank', '', 0, 1, '', '', 0, 1, '', 0, 1, '', 0, 1, '', 0, 1, '', '', '', 0, 1);";

# ############################

# 
# Table structure for table `" . $DBPrefix . "groups`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "groups`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "groups` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(100) NOT NULL default '',
  `can_sell` int(1) NOT NULL default '0',
  `can_buy` int(1) NOT NULL default '0',
  `count` int(250) NOT NULL default '0',
  `auto_join` int(1) NOT NULL default '0',
  `no_fees` int(1) NOT NULL default '0',
  `no_setup_fee` int(1) NOT NULL default '0',
  `no_excat_fee` int(1) NOT NULL default '0',
  `no_subtitle_fee` int(1) NOT NULL default '0',
  `no_relist_fee` int(1) NOT NULL default '0',
  `no_picture_fee` int(1) NOT NULL default '0',
  `no_hpfeat_fee` int(1) NOT NULL default '0',
  `no_hlitem_fee` int(1) NOT NULL default '0',
  `no_bolditem_fee` int(1) NOT NULL default '0',
  `no_rp_fee` int(1) NOT NULL default '0',
  `no_buyout_fee` int(1) NOT NULL default '0',
  `no_fp_fee` int(1) NOT NULL default '0',
  `no_geomap_fee` int(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "groups`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "groups` VALUES (NULL, 'Sellers', 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);";
$query[] = "INSERT INTO `" . $DBPrefix . "groups` VALUES (NULL, 'Buyers', 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);";

# ############################

# 
# Table structure for table `" . $DBPrefix . "increments`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "increments`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "increments` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `low` double(16,2) default '0',
  `high` double(16,2) default '0',
  `increment` double(16,2) default '0',
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "increments`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "increments` VALUES (NULL, 0.0000, 0.9900, 0.2800);";
$query[] = "INSERT INTO `" . $DBPrefix . "increments` VALUES (NULL, 1.0000, 9.9900, 0.5000);";
$query[] = "INSERT INTO `" . $DBPrefix . "increments` VALUES (NULL, 10.0000, 29.9900, 1.0000);";
$query[] = "INSERT INTO `" . $DBPrefix . "increments` VALUES (NULL, 30.0000, 99.9900, 2.0000);";
$query[] = "INSERT INTO `" . $DBPrefix . "increments` VALUES (NULL, 100.0000, 249.9900, 5.0000);";
$query[] = "INSERT INTO `" . $DBPrefix . "increments` VALUES (NULL, 250.0000, 499.9900, 10.0000);";
$query[] = "INSERT INTO `" . $DBPrefix . "increments` VALUES (NULL, 500.0000, 999.9900, 25.0000);";

# ############################

# 
# Table structure for table `" . $DBPrefix . "logs`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "logs`;";
$query[] = "CREATE TABLE  `" . $DBPrefix . "logs` (
  `id` INT(200) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
  `type` VARCHAR(5) NOT NULL ,
  `message` TEXT NOT NULL ,
  `action_id` INT(11) NOT NULL DEFAULT  '0',
  `user_id` INT(32) NOT NULL DEFAULT  '0',
  `ip` VARCHAR(45) NOT NULL,
  `timestamp` INT(11) NOT NULL DEFAULT  '0'
);";

# 
# Dumping data for table `" . $DBPrefix . "logs`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "maintainance`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "maintainance`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "maintainance` (
  `id` int(11) NOT NULL auto_increment,
  `active` enum('y','n') default NULL,
  `superuser` varchar(32) default NULL,
  `maintainancetext` text,
  KEY `id` (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "maintainance`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "maintainance` VALUES (1, 'n', 'uAuctions', '<br>\r\n<center>\r\n<b>Under maintainance!!!!!!!</b>\r\n</center>');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "membertypes`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "membertypes`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "membertypes` (
  `id` int(11) NOT NULL auto_increment,
  `feedbacks` int(11) NOT NULL default '0',
  `icon` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "membertypes`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (24, 9, 'transparent.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (22, 999999, 'starFR.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (21, 99999, 'starFV.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (20, 49999, 'starFT.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (19, 24999, 'starFY.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (23, 9999, 'starG.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (17, 4999, 'starR.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (16, 999, 'starT.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (15, 99, 'starB.gif');";
$query[] = "INSERT INTO `" . $DBPrefix . "membertypes` VALUES (14, 49, 'starY.gif');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "messages`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "messages`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "messages` (
  `id` int(50) NOT NULL AUTO_INCREMENT ,
  `sentto` int(25) NOT NULL default '0',
  `sentfrom` int(25) NOT NULL default '0',
  `fromemail` varchar(50) NOT NULL default '',
  `sentat` varchar(20) NOT NULL default '',
  `message` text NOT NULL ,
  `isread` int(1) NOT NULL default '0',
  `subject` varchar(50) NOT NULL default '',
  `replied` int(1) NOT NULL default '0',
  `reply_of` INT(50) NOT NULL default '0',
  `question` int(15) NOT NULL default '0',
  `public` INT(1) NOT NULL default '0',
  PRIMARY KEY (`id`)
) ;";

# ############################

# 
# Table structure for table `" . $DBPrefix . "mods`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "mods`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "mods` (
	`id` int(32) NOT NULL auto_increment,
	`mod_name` varchar(100) NOT NULL default '',
	`backup` varchar(100) NOT NULL default '',
	`mod_version` varchar(100) NOT NULL default '',
	`downloaded` enum('y','n') NOT NULL default 'n',
	`installed` enum('y','n') NOT NULL default 'n',
	`install_time` int(9) NOT NULL,
	PRIMARY KEY (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "mods`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "news`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "news`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "news` (
  `id` int(32) NOT NULL auto_increment,
  `title` varchar(200) NOT NULL default '',
  `content` longtext NOT NULL,
  `new_date` int(8) NOT NULL default '0',
  `suspended` int(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "news`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "news_translated`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "news_translated`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "news_translated` (
  `id` int(11) NOT NULL default '0',
  `lang` char(2) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `content` text NOT NULL
) ;";

# 
# Dumping data for table `" . $DBPrefix . "news_translated`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "online`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "online`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "online` (
  `ID` bigint(21) NOT NULL auto_increment,
  `SESSION` varchar(32) NOT NULL default '',
  `time` bigint(21) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "online`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "pendingnotif`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "pendingnotif`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "pendingnotif` (
  `id` int(11) NOT NULL auto_increment,
  `auction_id` int(11) NOT NULL default '0',
  `seller_id` int(11) NOT NULL default '0',
  `winners` text NOT NULL,
  `auction` text NOT NULL,
  `seller` text NOT NULL,
  `thisdate` varchar(8) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "pendingnotif`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "proxybid`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "proxybid`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "proxybid` (
  `itemid` int(32) default NULL,
  `userid` int(32) default NULL,
  `bid` double(16,2) default '0'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "proxybid`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "rates`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "rates`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "rates` (
  `id` int(11) NOT NULL auto_increment,
  `ime` tinytext NOT NULL,
  `valuta` tinytext NOT NULL,
  `symbol` char(3) NOT NULL default '',
  KEY `id` (`id`)
) AUTO_INCREMENT=64 ;";

# 
# Dumping data for table `" . $DBPrefix . "rates`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (1, 'Great Britain', 'Pound Sterling ', 'GBP');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (2, 'Argentina', 'Argentinian Peso', 'ARS');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (3, 'Australia', 'Australian Dollar ', 'AUD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (4, 'Burma', 'Myanmar (Burma) Kyat', 'MMK');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (5, 'Brazil', 'Brazilian Real ', 'BRL');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (6, 'Chile', 'Chilean Peso ', 'CLP');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (7, 'China', 'Chinese Renminbi ', 'CNY');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (8, 'Colombia', 'Colombian Peso ', 'COP');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (9, 'Neth. Antilles', 'Neth. Antilles Guilder', 'ANG');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (10, 'Czech. Republic', 'Czech. Republic Koruna ', 'CZK');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (11, 'Denmark', 'Danish Krone ', 'DKK');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (12, 'European Union', 'EURO', 'EUR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (13, 'Fiji', 'Fiji Dollar ', 'FJD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (14, 'Jamaica', 'Jamaican Dollar', 'JMD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (15, 'Trinidad & Tobago', 'Trinidad & Tobago Dollar', 'TTD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (16, 'Hong Kong', 'Hong Kong Dollar', 'HKD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (17, 'Ghana', 'Ghanaian Cedi', 'GHC');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (18, 'Iceland', 'Icelandic Krona ', 'INR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (19, 'India', 'Indian Rupee', 'INR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (20, 'Indonesia', 'Indonesian Rupiah ', 'IDR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (21, 'Israel', 'Israeli New Shekel ', 'ILS');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (22, 'Japan', 'Japanese Yen', 'JPY');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (23, 'Malaysia', 'Malaysian Ringgit', 'MYR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (24, 'Mexico', 'New Peso', 'MXN');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (25, 'Morocco', 'Moroccan Dirham ', 'MAD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (26, 'Honduras', 'Honduras Lempira', 'HNL');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (27, 'Hungaria', 'Hungarian Forint', 'HUF');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (28, 'New Zealand', 'New Zealand Dollar', 'NZD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (29, 'Norway', 'Norwege Krone', 'NOK');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (30, 'Pakistan', 'Pakistan Rupee ', 'PKR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (31, 'Panama', 'Panamanian Balboa ', 'PAB');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (32, 'Peru', 'Peruvian New Sol', 'PEN');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (33, 'Philippine', 'Philippine Peso ', 'PHP');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (34, 'Poland', 'Polish Zloty', 'PLN');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (35, 'Russian', 'Russian Rouble', 'RUR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (36, 'Singapore', 'Singapore Dollar ', 'SGD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (37, 'Slovakia', 'Koruna', 'SKK');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (38, 'Slovenia', 'Slovenian Tolar', 'SIT');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (39, 'South Africa', 'South African Rand', 'ZAR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (40, 'South Korea', 'South Korean Won', 'KRW');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (41, 'Sri Lanka', 'Sri Lanka Rupee ', 'LKR');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (42, 'Sweden', 'Swedish Krona', 'SEK');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (43, 'Switzerland', 'Swiss Franc', 'CHF');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (44, 'Taiwan', 'Taiwanese New Dollar ', 'TWD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (45, 'Thailand', 'Thailand Thai Baht ', 'THB');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (46, 'Pacific Financial Community', 'Pacific Financial Community Franc', 'CFP');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (47, 'Tunisia', 'Tunisisan Dinar', 'TND');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (48, 'Turkey', 'Turkish Lira', 'TRL');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (49, 'United States', 'U.S. Dollar', 'USD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (50, 'Venezuela', 'Bolivar ', 'VEB');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (51, 'Bahamas', 'Bahamian Dollar', 'BSD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (52, 'Croatia', 'Croatian Kuna', 'HRK');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (53, 'East Caribe', 'East Caribbean Dollar', 'XCD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (54, 'CFA Franc (African Financial Community)', 'African Financial Community Franc', 'CFA');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (55, 'Canadian', 'Canadian Dollar', 'CAD');";
$query[] = "INSERT INTO `" . $DBPrefix . "rates` VALUES (56, 'Romanian', 'Romanian Leu', 'RON');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "regionalCodes`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "regionalCodes`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "regionalCodes` (
	`id` int(11) NOT NULL auto_increment,
	`region` varchar(50) NOT NULL,
	`code` varchar(2) NOT NULL,
	PRIMARY KEY (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "regionalCodes`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Afar', 'AA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Alberta', 'AB');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'American Eskimo', 'AE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Afrikaans', 'AF');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Anglo-French', 'AL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Amharic', 'AM');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Arabic', 'AR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Assamese', 'AS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Aymara', 'AY');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Azerbaijani', 'AZ');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Bashkir', 'BA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Byelorussian', 'BE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Bulgarian', 'BG');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Bihari', 'BH');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Bislama', 'BI');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Bengali', 'BN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Tibetan', 'BO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Brazilian Portuguese', 'BP');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Beginning Russian', 'BR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Catalan', 'CA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Canadian French', 'CF');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Confederation of Helvetia', 'CH');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Corsican', 'CO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Czech Republic', 'CR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Czech', 'CS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Welsh', 'CY');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'German', 'DE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Dominican Republic', 'DR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Bhutani', 'DZ');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'English French', 'EF');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'English German', 'EG');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'English Japanese', 'EJ');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Greek', 'EL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'English', 'EN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Esperanto', 'EO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'European Portuguese', 'EP');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'English Russian', 'ER');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Spanish', 'ES');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Estonian', 'ET');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Basque', 'EU');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Farsi', 'FA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Foreignish English', 'FE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Finnish', 'FL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Fiji', 'FJ');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Faroese', 'FO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'French', 'FR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Frisian', 'FY');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Gaelic', 'GA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Scots Gaelic', 'GD');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Galician', 'GL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Guarani', 'GN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Gujarati', 'GU');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Hausa', 'HA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Hebrew', 'HE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Hindi', 'HI');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Korean', 'HM');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Croatian', 'HR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Hungarian', 'HU');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Armenian', 'HY');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Interlingua', 'IA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Interlingue', 'IE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Inupiak', 'IK');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Illinois', 'IL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Indonesian', 'IN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Icelandic', 'IS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Italian', 'IT');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Hebrew', 'IW');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Japanese', 'JA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Yiddish', 'JI');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Javanese', 'JV');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Georgian', 'KA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Kazakh', 'KK');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Greenlandic', 'KL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Cambodian', 'NM');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Kannada', 'KN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Korean', 'KO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Kashmiri', 'KS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Kurdish', 'KU');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Kirghiz', 'KY');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Latin', 'LA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Lingala', 'LN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Laothian', 'LO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Los Santos', 'LS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Lithuanian', 'LT');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Latvian', 'LV');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Malagasy', 'MG');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Maori', 'MI');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Macedonian', 'MK');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Malayalam', 'ML');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Mongolian', 'MN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Moldavian', 'MO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Marathi', 'MR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Malay', 'MS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Montana', 'MT');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Burmese', 'MY');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Nauru', 'NA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Nepali', 'NE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Dutch', 'NL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Norwegian', 'NO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'New Taiwanese', 'NT');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Occitan', 'OC');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Old French', 'OF');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Original German', 'OG');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Afan', 'OM');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Oriya', 'OR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Punjabi', 'PA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Polish', 'PL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Pitcairn', 'PN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Pashto', 'PS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Portuguese', 'PT');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Quechua', 'QU');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Russian English', 'RE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Rhaeto-Romance', 'RM');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Kurundi', 'RN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Romanian', 'RO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Russian', 'RU');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Kinyarwanda', 'RW');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Sanskrit', 'SA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Sardinian', 'SC');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Sindhi', 'SD');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Sentence Fragment', 'SF');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Sangho', 'SG');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Serbo-croatian', 'SH');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Sino Indian', 'SI');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Slovak', 'SK');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Slovenian', 'SL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Samoan', 'SM');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Shona', 'SN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Somali', 'SO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Albanian', 'SQ');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Serbian', 'SR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Siswati', 'SS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Sesotho', 'ST');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Sundanese', 'SU');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Swedish', 'SV');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Swahili', 'SW');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Tamil', 'TA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Telugu', 'TE');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Tajik', 'TG');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Thai', 'TH');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Tigrinya', 'TI');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Total Jive', 'TJ');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Turkmen', 'TK');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Tagalog', 'TL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Setswana', 'TN');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Tonga', 'TO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Timor Portuguese', 'TP');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Turkish', 'TR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Tsonga', 'TS');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Tatar', 'TT');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Twi', 'TW');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Ukraine', 'UA');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Ukrainian', 'UK');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Uppaal Language', 'UL');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Urdu', 'UR');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Uzbek', 'UZ');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Vietnamese', 'VI');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Volapuk', 'VO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Wolof', 'WO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Xhosa', 'XH');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Yoruba', 'YO');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Zagreb (Croatia)', 'ZG');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Chinese', 'ZH');";
$query[] = "INSERT INTO `" . $DBPrefix . "regionalCodes` VALUES (NULL, 'Zulu', 'ZU');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "rememberme`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "rememberme`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "rememberme` (
  `userid` int(11) NOT NULL default '0',
  `hashkey` char(32) NOT NULL default ''
) ;";

# 
# Dumping data for table `" . $DBPrefix . "rememberme`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "report_reasons`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "report_reasons`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "report_reasons` (
  `report_reason` tinytext NOT NULL,
  `report_class` int(2) NOT NULL default '1'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "report_reasons`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "report_reasons` (`report_reason`, `report_class`) VALUES
('Adult material', 3),
('Copyright or Trademark Violation', 3),
('Duplicate listing for one item', 3),
('Firearms, Weapons, or Knives Listed', 3),
('Fraudulent Listing Activities', 3),
('Hazardous Materials', 3),
('Illegal Plant or Animal Listed', 3),
('Inappropriate Category', 3),
('Listing in an Incorrect Category', 3),
('Misleading or Excessive Keywords', 3),
('Offensive Language used in Comments', 3),
('Offensive Language used in Listing', 3),
('Offensive or Violent Material', 3),
('Offering or Requiring Additional Purchases', 3),
('Other Illegal Activity Concerns', 3),
('Other Prohibited or Restricted Items', 3),
('Replica Item listed as Original', 3),
('Stolen Property', 3);";

# ############################

# 
# Table structure for table `" . $DBPrefix . "report_listing`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "report_listing`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "report_listing` (
  `id` int(11) NOT NULL auto_increment,
  `reporter_id` int(32) default NULL,
  `reporter_nick` varchar(64) NOT NULL default '',
  `report_reason` varchar(64) NOT NULL default '',
  `report_comment` mediumtext,
  `report_date` int(15) NOT NULL,
  `listing_id` int(32) NOT NULL default '0',
  `listing_title` varchar(64) NOT NULL default '',
  `seller_id` int(32) default NULL,
  `seller_nick` varchar(64) NOT NULL default '',
  `report_closed` int(2) NOT NULL default '0',
  PRIMARY KEY (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "report_listing`
# 


# ############################

# 
# Table structure for table `" . $DBPrefix . "settings`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "settings`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "settings` (
  `sitename` varchar(255) NOT NULL default '',
  `siteurl` varchar(255) NOT NULL default '',
  `copyright` varchar(255) NOT NULL default '',
  `version` varchar(10) NOT NULL default '',
  `loginbox` int(1) NOT NULL default '0',
  `newsbox` int(1) NOT NULL default '0',
  `newstoshow` int(11) NOT NULL default '0',
  `helpbox` int(1) NOT NULL default '0',
  `perpage` int(10) NOT NULL default '15',
  `moneyformat` int(1) NOT NULL default '0',
  `moneydecimals` int(11) NOT NULL default '2',
  `moneysymbol` int(1) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default '',
  `adminmail` varchar(100) NOT NULL default '',
  `banners` int(1) NOT NULL default '0',
  `newsletter` int(1) NOT NULL default '0',
  `logo` varchar(255) NOT NULL default '',
  `timecorrection` int(3) NOT NULL default '0',
  `cron` int(1) NOT NULL default '0',
  `archiveafter` int(11) NOT NULL default '0',
  `datesformat` enum('USA','EUR') NOT NULL default 'EUR',
  `errortext` text NOT NULL,
  `picturesgallery` int(1) NOT NULL default '0',
  `maxpictures` int(11) NOT NULL default '0',
  `buy_now` int(1) NOT NULL default '1',
  `thumb_show` smallint(6) NOT NULL default '120',
  `thumb_list` smallint(6) NOT NULL default '120',
  `lastitemsnumber` int(11) NOT NULL default '0',
  `hotitemsnumber` int(11) NOT NULL default '0',
  `endingsoonnumber` int(11) NOT NULL default '0',
  `boards` enum('y','n') NOT NULL default 'y',
  `wordsfilter` enum('y','n') NOT NULL default 'y',
  `aboutus` enum('y','n') NOT NULL default 'y',
  `aboutustext` text NOT NULL,
  `terms` enum('y','n') NOT NULL default 'y',
  `termstext` text NOT NULL,
  `privacypolicy` enum('y','n') NOT NULL default 'y',
  `privacypolicytext` text NOT NULL,
  `defaultcountry` varchar(30) NOT NULL default '217',
  `defaultlanguage` char(2) NOT NULL default 'EN',
  `catsorting` enum('alpha','counter') NOT NULL default 'alpha',
  `usersauth` enum('y','n') NOT NULL default 'y',
  `descriptiontag` text NOT NULL,
  `keywordstag` text NOT NULL,
  `maxuploadsize` int(11) NOT NULL default '0',
  `contactseller` enum('always','logged','never') NOT NULL default 'always',
  `theme` tinytext,
  `catstoshow` int(11) NOT NULL default '0',
  `bn_only` enum('y','n') NOT NULL default 'n',
  `users_email` enum('y','n') NOT NULL default 'y',
  `boardsmsgs` int(11) NOT NULL default '0',
  `activationtype` INT(1) NOT NULL DEFAULT '1',
  `https` enum('y','n') NOT NULL default 'n',
  `https_url` varchar(255) NOT NULL default '',
  `bn_only_disable` enum('y','n') NOT NULL default 'n',
  `bn_only_percent` int(3) NOT NULL default '50',
  `buyerprivacy` ENUM('y','n') NOT NULL default 'n',
  `cust_increment` INT(1) NOT NULL DEFAULT '1',
  `subtitle` ENUM('y','n') NOT NULL default 'y',
  `extra_cat` ENUM('y','n') NOT NULL default 'n',
  `fees` ENUM('y','n') NOT NULL default 'n',
  `fee_type` int(1) NOT NULL default '1',
  `fee_max_debt` double(16,2) NOT NULL default '25.00',
  `fee_signup_bonus` double(16,2) NOT NULL default '0.00',
  `fee_disable_acc` enum('y','n') NOT NULL default 'y',
  `tax` enum('y','n') NOT NULL default 'n',
  `taxuser` enum('y','n') NOT NULL default 'n',
  `ae_status` enum('y','n') NOT NULL default 'n',
  `ae_timebefore` int(11) NOT NULL default '120',
  `ae_extend` int(11) NOT NULL default '300',
  `cache_theme` ENUM('y','n') NOT NULL default 'y',
  `edit_starttime` int(1) NOT NULL default '1',
  `banner_width` int(11) NOT NULL default '468',
  `banner_height` int(11) NOT NULL default '60',
  `banner_types` varchar(75) NOT NULL default '',
  `counter_auctions` enum('y','n') NOT NULL default 'y',
  `counter_users` enum('y','n') NOT NULL default 'y',
  `counter_online` enum('y','n') NOT NULL default 'y',
  `banemail` text NOT NULL,
  `mandatory_fields` varchar(255) NOT NULL default '',
  `displayed_feilds` VARCHAR(255) NOT NULL default '',
  `ao_hpf_enabled` enum('y','n') NOT NULL default 'y',
  `ao_hi_enabled` enum('y','n') NOT NULL default 'y',
  `ao_bi_enabled` enum('y','n') NOT NULL default 'y',
  `proxy_bidding` enum('y','n') NOT NULL default 'y',
  `recaptcha_public` varchar(40) NOT NULL default '',
  `recaptcha_private` varchar(40) NOT NULL default '',
  `spam_sendtofriend` int(1) NOT NULL default '1',
  `spam_register` int(1) NOT NULL default '1',
  `mod_queue` enum('y','n') NOT NULL default 'n',
  `payment_options` text NOT NULL,
  `autorelist` ENUM('y','n') NOT NULL default 'y',
  `autorelist_max` int(3) NOT NULL default '10',
  `invoice_yellow_line` varchar(255) NOT NULL default '',
  `invoice_thankyou` varchar(255) NOT NULL default '',
  `dites_upload_size` int(11) NOT NULL default '0',
  `di_auctions` ENUM('y','n') NOT NULL default 'n',
  `facebook_login` ENUM('y','n') NOT NULL default 'n',
  `facebook_app_id` varchar(100) NOT NULL default '',
  `facebook_app_secret` varchar(100) NOT NULL default '',
  `admin_folder` varchar(100) NOT NULL default '',
  `cookiespolicy` enum('y','n') NOT NULL default 'y',
  `cookiespolicytext` text NOT NULL,
  `counter_users_online` enum('y','n') NOT NULL default 'y',
  `item_conditions` enum('y','n') NOT NULL default 'n',
  `paypal_sandbox` enum('y','n') NOT NULL default 'n',
  `authnet_sandbox` enum('y','n') NOT NULL default 'n',
  `worldpay_sandbox` enum('y','n') NOT NULL default 'n',
  `skrill_sandbox` enum('y','n') NOT NULL default 'n',
  `checkout_sandbox` enum('y','n') NOT NULL default 'n',
  `dutch_auctions` enum('y','n') NOT NULL default 'y',
  `expire_unpaid` int(3) NOT NULL default '30',
  `cookie_name` varchar(150) NOT NULL default '',
  `sessions_name` varchar(150) NOT NULL default '',
  `custom_code` varchar(150) NOT NULL default '',
  `cat_counters` enum('y','n') NOT NULL default 'y',
  `disposable_email_block` enum('y','n') NOT NULL default 'y',
  `counter_sold_items` enum('y','n') NOT NULL default 'y',
  `mail_protocol` int(1) NOT NULL DEFAULT '0',
  `mail_parameter` VARCHAR(128) NOT NULL,
  `smtp_authentication`  enum('y', 'n') NOT NULL default 'n',
  `smtp_security` enum('none','tls','ssl') NOT NULL default 'none',
  `smtp_port` int(10) NOT NULL default '25',
  `smtp_host`VARCHAR(128) NOT NULL,
  `smtp_username` VARCHAR(128) NOT NULL,
  `smtp_password` VARCHAR(128) NOT NULL,
  `alert_emails` VARCHAR(128) NOT NULL,
  `cronlog` enum('y','n') NOT NULL default 'y',
  `encryption_key` VARCHAR(32) NOT NULL,
  `cookies_directive` ENUM('y','n') NOT NULL default 'y',
  `minimum_username_length` int(2) NOT NULL default '6',
  `minimum_password_length` int(2) NOT NULL default '6',
  `image_captcha_characters_length` int(2) NOT NULL default '7',
  `image_captcha_width` int(3) NOT NULL default '230',
  `max_image_width` int(5) NOT NULL default '1000',
  `max_image_height` int(5) NOT NULL default '800',
  `daylight_savings` enum('y','n') NOT NULL default 'y',
  `standard_auctions` enum('y','n') NOT NULL default 'y',
  `auction_setup_types` enum('0','1','2') NOT NULL default '2',
  `freemaxpictures` int(11) NOT NULL default '5',
  `shipping_conditions` enum('y','n') NOT NULL default 'y',
  `shipping_terms` enum('y','n') NOT NULL default 'y',
  `google_analytics` varchar(25) NOT NULL default '',
  `watermark` varchar(255) NOT NULL default '',
  `watermark_active` enum('y','n') NOT NULL default 'n',
  `featureditemsnumber` int(3) NOT NULL default '8',
  `upgradeAPIkey` varchar(250) NOT NULL default '',
  `gateways` varchar(250) NOT NULL default '',
  `encryptionType` enum('y','n') NOT NULL default 'n',
  `googleMap` enum('y','n') NOT NULL default 'n',
  `htmLawed_safe` int(1) NOT NULL default '1',
  `htmLawed_deny_attribute` text NOT NULL,
  `donated` text NOT NULL,
  `admin_theme` tinytext
  );";

# 
# Dumping data for table `" . $DBPrefix . "settings`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "settings` VALUES
('uAuctions',
'" . $siteURL . "',
'',
'" . new_version() . "',
1,
1,
5,
1,
15,
1,
2,
2,
'GBP',
'" . $siteEmail . "',
1,
1,
'logo.png',
0,
2,
30,
'EUR',
'An unexpected error occurred. The error has been forwarded to our technical team and will be fixed shortly',
1,
5,
2,
120,
120,
8,
8,
0,
'y',
'y',
'y',
'',
'y',
'',
'y',
'',
'217',
'EN',
'alpha',
'y',
'',
'',
10485760,
'always',
'default',
20,
'n',
'y',
0,
1,
'n',
'',
'n',
50,
'n',
1,
'y',
'n',
'n',
1,
'25.00',
'0.00',
'y',
'n',
'n',
'n',
120,
300,
'y',
1,
468,
60,
'gif, jpg, jpeg, png, swf',
'y',
'y',
'y',
'',
'a:7:{s:9:\"birthdate\";s:1:\"y\";s:7:\"address\";s:1:\"y\";s:4:\"city\";s:1:\"y\";s:4:\"prov\";s:1:\"y\";s:7:\"country\";s:1:\"y\";s:3:\"zip\";s:1:\"y\";s:3:\"tel\";s:1:\"y\";}',
'a:7:{s:17:\"birthdate_regshow\";s:1:\"y\";s:15:\"address_regshow\";s:1:\"y\";s:12:\"city_regshow\";s:1:\"y\";s:12:\"prov_regshow\";s:1:\"y\";s:15:\"country_regshow\";s:1:\"y\";s:11:\"zip_regshow\";s:1:\"y\";s:11:\"tel_regshow\";s:1:\"y\";}',
'y',
'y',
'y',
'y',
'',
'',
1,
1,
'n',
'a:2:{i:0;s:13:\"Wire Transfer\";i:1;s:6:\"Cheque\";}',
'y',
10,
'',
'Thank you for shopping with us and we hope to see you return soon!',
0,
'n',
'n',
'',
'',
'admin',
'y',
'',
'y',
'n',
'n',
'n',
'n',
'n',
'n',
'y',
60,
'uAuctions',
'uAuctions',
'uAuctions',
'y',
'y',
'y',
0,
'',
'n',
'none',
25,
'',
'',
'',
'',
'y',
'" . md5(uniqid(rand(0,99), true)) . "',
'y',
6,
6,
7,
230,
1000,
800,
'y',
'y',
1,
5,
'y',
'y',
'',
'',
'n',
8,
'',
'a:6:{s:6:\"paypal\";s:6:\"PayPal\";s:7:\"authnet\";s:13:\"Authorize.net\";s:8:\"worldpay\";s:8:\"WorldPay\";s:6:\"skrill\";s:6:\"Skrill\";s:11:\"toocheckout\";s:9:\"2Checkout\";s:4:\"bank\";s:13:\"Bank Transfer\";}',
'n',
'n',
1,
'id, style',
'To remove the u-Auctions copyright please donate $5.00 at www.u-auctions.com. This message will update after you have made a donation and if you are running version 5.4.0 or higher and made a donation the u-Auctions copyright will be automatically deleted in your u-Auctions script footers',
'admin'
);";


# ############################

# 
# Table structure for table `" . $DBPrefix . "statssettings`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "statssettings`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "statssettings` (
  `activate` enum('y','n') NOT NULL default 'y',
  `accesses` enum('y','n') NOT NULL default 'y',
  `browsers` enum('y','n') NOT NULL default 'y',
  `domains` enum('y','n') NOT NULL default 'y'
) ;";

# 
# Dumping data for table `" . $DBPrefix . "statssettings`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "statssettings` VALUES ('n', 'y', 'y', 'y');";


# ############################

# 
# Table structure for table `" . $DBPrefix . "support`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "support`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "support` (
	`id` int(128) NOT NULL auto_increment,
	`user` int(128) NOT NULL,
	`title` tinytext,
	`ticket_id` varchar(250) NOT NULL default '',
	`status` enum('open','close') NOT NULL default 'open',
	`last_reply_user` int(150) NOT NULL,
	`last_reply_time` int(15) NOT NULL,
	`created_time` int(15) NOT NULL,
	`ticket_reply_status` enum('user','support') NOT NULL default 'support',
	PRIMARY KEY (`id`)
);";

# 
# Dumping data for table `" . $DBPrefix . "support`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "support_messages`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "support_messages`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "support_messages` (
  `id` int(50) NOT NULL AUTO_INCREMENT ,
  `sentto` int(25) NOT NULL default '0',
  `sentfrom` int(25) NOT NULL default '0',
  `fromemail` varchar(50) NOT NULL default '',
  `sentat` varchar(20) NOT NULL default '',
  `message` text NOT NULL ,
  `subject` varchar(50) NOT NULL default '',
  `reply_of` INT(50) NOT NULL default '0',
  PRIMARY KEY (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "support_messages`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "tax`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "tax`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "tax` (
	  `id` INT(2) NOT NULL AUTO_INCREMENT,
	  `tax_name` VARCHAR(30) NOT NULL ,
	  `tax_rate` DOUBLE(16, 2) NOT NULL ,
	  `countries_seller` TEXT NOT NULL ,
	  `countries_buyer` TEXT NOT NULL ,
	  `fee_tax` INT(1) NOT NULL DEFAULT  '0',
	  PRIMARY KEY (`id`)
	);";

# 
# Dumping data for table `" . $DBPrefix . "tax`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "tax` VALUES (NULL, 'Site Fees', '0', '', '', '1');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "users`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "users`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "users` (
  `id` int(32) NOT NULL auto_increment,
  `nick` varchar(20) NOT NULL,
  `password` varchar(255) default '',
  `hash` varchar(5) default '',
  `name` tinytext,
  `address` tinytext,
  `city` varchar(25) default '',
  `prov` varchar(20) default '',
  `country` varchar(30) default '',
  `zip` varchar(10) default '',
  `phone` varchar(40) default '',
  `email` varchar(50) default '',
  `reg_date` int(15) default NULL,
  `rate_sum` int(11) NOT NULL default '0',
  `rate_num` int(11) NOT NULL default '0',
  `birthdate` int(8) default '0',
  `suspended` int(1) default '0',
  `nletter` int(1) NOT NULL default '0',
  `balance` double(16,2) NOT NULL default '0',
  `auc_watch` text,
  `item_watch` text,
  `endemailmode` enum('one','cum','none') NOT NULL default 'one',
  `startemailmode` enum('yes','no') NOT NULL default 'yes',
  `emailtype` enum('html','text') NOT NULL default 'html',
  `lastlogin` datetime NOT NULL default '0000-00-00 00:00:00',
  `payment_details` text,
  `groups` text,
  `bn_only` enum('y','n') NOT NULL default 'y',
  `timecorrection` int(3) NOT NULL default '0',
  `paypal_email` varchar(50) default '',
  `authnet_id` varchar(50) default '',
  `authnet_pass` varchar(50) default '',
  `worldpay_id` varchar(50) default '',
  `skrill_email` varchar(50) default '',
  `toocheckout_id` varchar(50) default '',
  `language` char(2) NOT NULL default '',
  `fblogin_id` varchar(100) NOT NULL default '',
  `avatar` varchar(250) NOT NULL default '',
  `is_online` int(10) NOT NULL default '0',
  `hide_online` enum('y','n') NOT NULL default 'n',
  `bank_name` varchar(50) NOT NULL default '',
  `bank_account` varchar(50) NOT NULL default '',
  `bank_routing` varchar(50) NOT NULL default '',
  `admin` int(1) NOT NULL default '0',
  `payment_reminder_sent` enum('y','n') NOT NULL default 'n',
  `user_key` varchar(32) NOT NULL default '',
  PRIMARY KEY (`id`)
);";

# 
# Dumping data for table `" . $DBPrefix . "users`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "useraccounts`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "useraccounts`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "useraccounts` (
  `useracc_id` int(11) NOT NULL AUTO_INCREMENT,
  `auc_id` int(15) NOT NULL default '0',
  `user_id` int(15) NOT NULL default '0',
  `date` int(15) NOT NULL default '0',
  `setup` double(8,2) NOT NULL default '0',
  `featured` double(8,2) NOT NULL default '0',
  `bold` double(8,2) NOT NULL default '0',
  `highlighted` double(8,2) NOT NULL default '0',
  `subtitle` double(8,2) NOT NULL default '0',
  `relist` double(8,2) NOT NULL default '0',
  `reserve` double(8,2) NOT NULL default '0',
  `buynow` double(8,2) NOT NULL default '0',
  `image` double(8,2) NOT NULL default '0',
  `extcat` double(8,2) NOT NULL default '0',
  `signup` double(8,2) NOT NULL default '0',
  `buyer` double(8,2) NOT NULL default '0',
  `finalval` double(8,2) NOT NULL default '0',
  `geomap` double(8,2) NOT NULL default '0',
  `balance` double(8,2) NOT NULL default '0',
  `total` double(8,2) NOT NULL,
  `paid` int(1) NOT NULL default '0',
  PRIMARY KEY (`useracc_id`)
);";

# 
# Dumping data for table `" . $DBPrefix . "useraccounts`
# 

# ############################

# 
# Table structure for table `" . $DBPrefix . "usersips`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "usersips`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "usersips` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(32) default NULL,
  `ip` varchar(15) default NULL,
  `type` enum('first','after') NOT NULL default 'first',
  `action` enum('accept','deny') NOT NULL default 'accept',
  PRIMARY KEY  (`id`)
) ;";

# 
# Dumping data for table `" . $DBPrefix . "usersips`
# 

# ############################

#
#Table structure for table `" . $DBPrefix . "digital_item`
#

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "digital_items`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "digital_items` (
	`id` int(11) NOT NULL auto_increment,
	`auctions` INT(10) NOT NULL,
	`seller` INT(10) NOT NULL,
	`item` TINYTEXT NOT NULL,
	`hash` varchar(100) NOT NULL default '',
	PRIMARY KEY  (`id`)
)";

# 
# Dumping data for table `" . $DBPrefix . "digital_item`
# 

# ############################

#
#Table structure for table `" . $DBPrefix . "digital_item_mime`
#

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "digital_item_mime`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "digital_item_mime` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(250) NOT NULL default '',
	`mine_type` varchar(250) NOT NULL default '',
	`file_extension` varchar(250) NOT NULL default '',
	`use_mime` enum('y','n') NOT NULL default 'n',
	PRIMARY KEY  (`id`)
)";

# 
# Dumping data for table `" . $DBPrefix . "digital_item_mime`
# 

$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, '7-Zip', 'application/x-7z-compressed', '7z', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'PostScript', 'application/postscript', 'ai', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Android Package Archive', 'application/vnd.android.package-archive', 'apk', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Audio Video Interleave (AVI)', 'video/x-msvideo', 'avi', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Bitmap Image File', 'image/bmp', 'bmp', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Cascading Style Sheets (CSS)', 'text/css', 'css', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Microsoft Word', 'application/msword', 'doc', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'PostScript', 'application/x-7z-compressed', '7z', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Microsoft Application', 'application/x-msdownload', 'exe', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Flash Video', 'video/x-f4v', 'f4v', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Flash Video', 'video/x-flv', 'flv', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Graphics Interchange Format', 'image/gif', 'gif', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'H.261', 'video/h261', 'h261', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'H.263', 'video/h263', 'h263', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'H.264', 'video/h264', 'h264', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'HyperText Markup Language (HTM)', 'text/html', 'htm', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'HyperText Markup Language (HTML)', 'text/html', 'html', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Icon Image', 'image/x-icon', 'ico', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Java Archive', 'application/java-archive', 'jar', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'JPEG Image', 'image/jpeg', 'jpe', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'JPEG Image', 'image/jpg', 'jpeg', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'JPEG Image', 'image/jpg', 'jpg', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'JavaScript', 'application/javascript', 'js', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'JavaScript Object Notation (JSON)', 'application/json', 'json', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'M4v', 'video/x-m4v', 'm4v', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Quicktime Video', 'video/quicktime', 'mov', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'MPEG-3 Audio', 'audio/mpeg', 'mp3', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'MPEG-4 Video', 'video/mp4', 'mp4', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'MPEG-4 Audio', 'audio/mp4', 'mp4a', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'MPEG Video', 'video/mpeg', 'mpeg', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'MPEG Audio', 'audio/mpeg', 'mpga', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'OpenDocument Spreadsheet', 'application/vnd.oasis.opendocument.spreadsheet', 'ods', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'OpenDocument Text', 'application/vnd.oasis.opendocument.text', 'odt', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Adobe Portable Document Format', 'application/pdf', 'pdf', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Portable Network Graphics (PNG)', 'image/png', 'png', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Microsoft PowerPoint', 'application/vnd.ms-powerpoint', 'ppt', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'PostScript', 'application/postscript', 'ps', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Photoshop Document', 'image/vnd.adobe.photoshop', 'psd', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Quicktime Video', 'video/quicktime', 'qt', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'RAR Archive', 'application/x-rar-compressed', 'rar', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Rich Text Format', 'application/rtf', 'rtf', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Digital Video Broadcasting', 'application/vnd.dvb.service', 'svc', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Scalable Vector Graphics (SVG)', 'image/svg+xml', 'svg', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Scalable Vector Graphics (SVG)', 'image/svg+xml', 'svgz', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Adobe Flash', 'application/x-shockwave-flash', 'swf', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Tagged Image File Format', 'image/tiff', 'tif', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Tagged Image File Format', 'image/tiff', 'tiff', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Text File', 'text/plain', 'txt', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Microsoft Windows Media', 'video/x-ms-wm', 'wm', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Microsoft Windows Media Audio', 'audio/x-ms-wma', 'wma', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Microsoft Excel', 'application/vnd.ms-excel', 'xls', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'XML - Extensible Markup Language', 'application/xml', 'xml', 'n');";
$query[] = "INSERT INTO `" . $DBPrefix . "digital_item_mime` VALUES (NULL, 'Zip Archive', 'application/zip', 'zip', 'n');";

# ############################

# 
# Table structure for table `" . $DBPrefix . "winners`
# 

$query[] = "DROP TABLE IF EXISTS `" . $DBPrefix . "winners`;";
$query[] = "CREATE TABLE `" . $DBPrefix . "winners` (
  `id` int(11) NOT NULL auto_increment,
  `auction` int(32) NOT NULL default '0',
  `seller` int(32) NOT NULL default '0',
  `winner` int(32) NOT NULL default '0',
  `bid` double(16,2) NOT NULL default '0',
  `closingdate` int(15) NOT NULL default '0',
  `feedback_win` tinyint(1) NOT NULL default '0',
  `feedback_sel` tinyint(1) NOT NULL default '0',
  `qty` int(11) NOT NULL default '1',
  `paid` int(1) NOT NULL default '0',
  `bf_paid` INT(1) NOT NULL DEFAULT  '0',
  `ff_paid` INT(1) NOT NULL DEFAULT '1',
  `shipped` INT(1) NOT NULL DEFAULT '0',
  `is_read` INT(1) NOT NULL DEFAULT '0',
  `is_counted` enum('y','n') NOT NULL DEFAULT 'n',
  KEY `id` (`id`)
) ;";