<?php
/*******************************************************************************
 *   copyright				: (C) 2013 - 2016 u-Auctions
 *   site					: https://www.u-auctions.com
 *******************************************************************************/

/*******************************************************************************
 *   This uAuctions is a Paid version of u-Auctions script.
 *   You are not allowed to resell/sell this script is  copyrighted to u-auctions.com.
 *   If you have been sold this script from a 3rd party and not from the 
 *   https://u-auctions.com website or https://ubidzz.com ask for a refund.
 *******************************************************************************/
/*******************************************************************************
 * If you bought this script from the https://u-Auctions.com website or https://ubidzz.com 
 * Please register at https://u-auctions.com/forum and contact the u-Auctions admin  
 * at https://u-auctions.com/forum with your order number and full name so we can change 
* your group to premium so you can view the paid area on the forums.
 *******************************************************************************/

if (!defined('InuAuctions')) exit();
if (!defined('InAdmin')) exit();

define('TMP_PATH', PLUGIN_PATH . 'ScriptUpdater/tmp/');
define('UNPACKED_PATH', TMP_PATH . 'unpacked/');
define('DOWNLOAD_PATH', TMP_PATH . 'download/');
define('UPGRADE_PATH', TMP_PATH . 'upgrade/');

function upgradeCheck($step, $version = '')
{	
	global $system;
	
	$buildURL = http_build_query(array(
		'action' => 'api-premium-upgrade',
		'api' => $system->SETTINGS['upgradeAPIkey'],
		'step' => $step,
		'version' => $version
	));
	$apiContent = load_file_from_url("https://www.u-auctions.com/api/check.php?" . $buildURL);
	//Decode the json data to get the value
	return  json_decode($apiContent, true); 
}
class upgrading
{
	//read the xml page
	function simplexml_to_array($data) {
	    $a = array();
	    foreach ($data as $node) 
	    {
			if (is_array($node)) unset($node);
		    else $a[$node->getName()] = (string) $node;
		}
		return $a;
	}
	
	//unzipping the upgrade.zip file
	function unzip_update($filename)
	{
		global $MSG;
		
		//the unzip folder where all the zip files are saved at
		$updateFolder = TMP_PATH;
		$unzip_file_path = UNPACKED_PATH;
		
		//making sure the folders exists
		if (is_dir($updateFolder) == false) mkdir($updateFolder, 0755);
		if (is_dir($unzip_file_path) == false) mkdir($unzip_file_path, 0755);
		if (is_dir($unzip_file_path) == false) chmod($unzip_file_path, 0755);
		
		$zip = new ZipArchive;
		if ($zip->open(DOWNLOAD_PATH . $filename) === TRUE) //unpack the zip file
		{
			$zip->extractTo($unzip_file_path);
			$zip->close();
			return $MSG['3500_1015708'];
		} 
		else //the zip was not unpacked
		{
			return $MSG['3500_1015707'];
		}
	}
	
	//downloading the upgrade.zip file
	function download_upgrade($path, $old_version)
	{	
		global $system, $MSG;
		
		if($old_version == $system->SETTINGS['version'])
		{
			$split_name = array_filter(explode('/',$path));
			$filename = end($split_name); //standered update file name that is used	
			$file = fopen ($path, "rb");
			if ($file) 
			{
				//the download folder where all the zip files are saved at
				$updateFolder = TMP_PATH;
				$download_file_path = DOWNLOAD_PATH;
				$upgrade_file_path = UPGRADE_PATH;
				
				//making sure the temp folders exists
				if (is_dir($updateFolder) == false) mkdir($updateFolder, 0755);
				if (is_dir($upgrade_file_path) == false) mkdir($upgrade_file_path, 0755);
				if (is_dir($upgrade_file_path) == false) chmod($upgrade_file_path, 0755);

				//making sure the folders exists
				if (is_dir($download_file_path) == false) mkdir($download_file_path, 0755);
				if (is_dir($download_file_path) == false) chmod($download_file_path, 0755);
			
				$newf = fopen ($download_file_path . $filename, "a");
				if ($newf)
					while(!feof($file)) 
					{
						fwrite($newf, fread($file, 1024 * 8 ), 1024 * 8 ); // copy the zip to the server
					}
					
					if (is_file($download_file_path . $filename) == true) //the upgrade zip was downloaded
					{
						$_SESSION['upgrade_message'] = 2;
						return $this->unzip_update($filename);
					} 
					else //the zip was not unpacked
					{
						$_SESSION['upgrade_message'] = 1;
						return $MSG['3500_1015706'];
					}
			}
			else //no file found
			{
				$_SESSION['upgrade_message'] = 1;
				return $MSG['3500_1015705'];
			}
			if ($file) 
			{
		    	fclose($file);
			}
			
			if ($newf) 
			{
				fclose($newf);
			}
		}
	}
		
	//updating the database
	function upgrade_db($myversion, $temp_folder, $db_finished = false)
	{
		global $db, $DBPrefix;
		
		include $temp_folder . '/install/sql/updatedump.inc.php';
		$verify_db = count($query);
		$db_finished=0;
		
		for ($i = 0; $i < @count($query); $i++)
		{
			$db->direct_query($query[$i]);
			$db_finished++;
		}
		
		if($verify_db == $db_finished)
		{
			return array('passed' => 'true', 'total' => $verify_db, 'updated' => $db_finished);
		}
		else
		{
			return array('passed' => 'failed', 'total' => $verify_db, 'updated' => $db_finished);
		}
	}
	
	function copy_temp($temp_folder_path, $temp_page, $falder_name) 
	{
		global $system;
		
		if($falder_name == 'root/') //the files are in the main u-Auctions folder
		{
			//deleting the old page beofre copying the new one over
			if ($dir = opendir(MAIN_PATH))
			{
				while (($file = readdir($dir)) !== false)
				{
					if (file_exists(MAIN_PATH . $file) && $file == $temp_page)
					{
						@unlink(MAIN_PATH . '/' . $file);
					}
				}
				closedir($dir);
			}
			$system->move_file($temp_folder_path . '/' . $temp_page, MAIN_PATH . $temp_page);
			@chmod(MAIN_PATH . $temp_page, 0644);
		}
		elseif($falder_name == 'admin/') //in case the admin folder was renamed
		{
			//deleting the old page beofre copying the new one over
			if ($dir = opendir(MAIN_PATH . $system->SETTINGS['admin_folder']  . '/'))
			{
				while (($file = readdir($dir)) !== false)
				{
					if (file_exists(MAIN_PATH . $system->SETTINGS['admin_folder']  . '/' . $file) && $file == $temp_page)
					{
						@unlink(MAIN_PATH . $system->SETTINGS['admin_folder']  . '/' . $file);
					}
				}
				closedir($dir);
			}
			$system->move_file($temp_folder_path . '/' . $falder_name . $temp_page, MAIN_PATH . $system->SETTINGS['admin_folder']  . '/' . $temp_page);
			@chmod(MAIN_PATH . $system->SETTINGS['admin_folder']  . '/' . $temp_page, 0644);
		}
		else //the files are in sub-folders
		{
			if (is_dir(MAIN_PATH . $falder_name) == false) mkdir(MAIN_PATH . $falder_name, 0755);
			if (is_dir(MAIN_PATH . $falder_name) == false) chmod(MAIN_PATH . $falder_name, 0755);

			//deleting the old page beofre copying the new one over
			if ($dir = opendir(MAIN_PATH . $falder_name))
			{
				while (($file = readdir($dir)) !== false)
				{
					if (file_exists(MAIN_PATH . $falder_name . $file) && $file == $temp_page)
					{
						@unlink(MAIN_PATH . $falder_name . $file);
					}
				}
				closedir($dir);
			}
			$system->move_file($temp_folder_path . '/' . $falder_name . $temp_page, MAIN_PATH . $falder_name . $temp_page);
			@chmod(MAIN_PATH . $falder_name . $temp_page, 0644);
		}
	}
	
	function deleteTemp($str, $cache) 
	{		
		//deleting the cache files that the u-Auctions script
		//this so the Admin does not have to clcik the clear cache button after the upgrade is finished
		if (is_dir(MAIN_PATH . 'cache') && $cache == 1)
		{
			$cacheDir = opendir(MAIN_PATH . 'cache');
			while (($cacheFile = readdir($cacheDir)) !== false)
			{
				if ($cacheFile != '.' && $cacheFile != '..' && $cacheFile != 'index.php')
				{
					@unlink(MAIN_PATH . 'cache/' . $cacheFile);
				}
			}
			closedir($cacheDir);
		}
		
		//deleting all the upgrade temp files and directories
		if (is_file($str)) 
	    {
			return @unlink($str);
		}
		elseif (is_dir($str)) 
		{
			$trim_str = rtrim($str,'/');
			$scan = glob($trim_str . '/*');
		    foreach($scan as $index=>$path) 
		    {
		    	$this->deleteTemp($path, 0);
		    }
		        return @rmdir($str);
		}
	}
	
	//start upgrading the current u-auctions script to the new version
	function start_upgrading($folders,$pages, $finished = false)
	{
		global $MSG, $system;

		//read the unzipped folder that in the (PLUGIN_PATH . 'ScriptUpdater/unpacked/) folder
		$unziped_file_path = UNPACKED_PATH;
		$handler = opendir($unziped_file_path);
		while ($file = readdir($handler))
		{
			if ($file != "." && $file != "..") 
			{
				$temp_folder = $unziped_file_path . $file;
			}
		}
		closedir($handler);
		
		//used to make sure all the pages was copied and making sure it loop through all the files
		$countPages = count(array_filter($pages));
		$countFolders = count(array_filter($folders));
		$p=0; 
		$f=0;		
			
		// coping the new files to the new directories
		//lopping each folder
		foreach(array_filter($folders) as $fk => $fv)
		{
			//lopping each page
			foreach(array_filter($pages) as $pk => $pv)
			{
				//checking to see if the page and file are correct and exists in the temp folder
				if(file_exists($temp_folder . '/' . $pv) && $fv == 'root/') 
				{
					$this->copy_temp($temp_folder, $pv, $fv);
					$p++;
				}
				//checking to see if the page and file are correct and exists in the temp folder
				elseif(file_exists($temp_folder . '/' . $fv . $pv)) 
				{
					$this->copy_temp($temp_folder, $pv, $fv);
					$p++;
				}
			}
			$f++;
		}

		sleep(1);//delay the page loading to make sure all the loops are finished
		
		//displaying all the error messages
		//checking to see if the pages was copied to the new directories
		if($p == $countPages && $f == $countFolders)
		{	
			//updating the DB and seeing if the DB updated
			if(file_exists(MAIN_PATH . 'install/scripts/newDB.php'))
			{
				include MAIN_PATH . 'install/scripts/newDB.php';
				sleep(1);
				//deleting all the temp upgrade files and folder and seeing if they did delete
				if($this->deleteTemp(TMP_PATH, 1) == 1)
				{
					return $MSG['3500_1015701'] . '<br>' . sprintf($MSG['3500_1015729'], $countFolders, $f) . '<br>' . sprintf($MSG['3500_1015730'], $countPages, $p) . '<br>' . sprintf($MSG['3500_1015732'], $dbUpgrade['total'], $dbUpgrade['updated']);
				}
				else //the temps files and folders didn't delete and there is still files and folder in (PLUGIN_PATH . 'ScriptUpdater/unpacked/)  
				{
					return $MSG['3500_1015702'] . '<br>' . sprintf($MSG['3500_1015729'], $countFolders, $f) . '<br>' . sprintf($MSG['3500_1015730'], $countPages, $p) . '<br>' . sprintf($MSG['3500_1015732'], $dbUpgrade['total'], $dbUpgrade['updated']);
				}
			}else{
				$dbUpgrade = $this->upgrade_db($system->SETTINGS['version'], $temp_folder);
				if($dbUpgrade['passed'] == 'true') 
				{									
					//deleting all the temp upgrade files and folder and seeing if they did delete
					if($this->deleteTemp(TMP_PATH, 1) == 1)
					{
						return $MSG['3500_1015701'] . '<br>' . sprintf($MSG['3500_1015729'], $countFolders, $f) . '<br>' . sprintf($MSG['3500_1015730'], $countPages, $p) . '<br>' . sprintf($MSG['3500_1015732'], $dbUpgrade['total'], $dbUpgrade['updated']);
					}
					else //the temps files and folders didn't delete and there is still files and folder in (PLUGIN_PATH . 'ScriptUpdater/unpacked/)  
					{
						return $MSG['3500_1015702'] . '<br>' . sprintf($MSG['3500_1015729'], $countFolders, $f) . '<br>' . sprintf($MSG['3500_1015730'], $countPages, $p) . '<br>' . sprintf($MSG['3500_1015732'], $dbUpgrade['total'], $dbUpgrade['updated']);
					}
				}
				elseif($dbUpgrade['passed'])
				{
					return $MSG['3500_1015700'] . '<br>' . sprintf($MSG['3500_1015732'], $dbUpgrade['total'], $dbUpgrade['updated']);
				}
			}
		}
		else
		{
			return $MSG['3500_1015699'] . '<br>' . sprintf($MSG['3500_1015729'], $countFolders, $f) . '<br>' . sprintf($MSG['3500_1015730'], $countPages, $p);
		}
	}
}