<?php
/*******************************************************************************
 *   copyright				: (C) 2013 - 2016 u-Auctions
 *   site					: https://www.u-auctions.com
 *******************************************************************************/

/*******************************************************************************
 *   This uAuctions is a Paid version of u-Auctions script.
 *   You are not allowed to resell/sell this script is  copyrighted to u-auctions.com.
 *   If you have been sold this script from a 3rd party and not from the 
 *   https://u-auctions.com website or https://ubidzz.com ask for a refund.
 *******************************************************************************/
/*******************************************************************************
 * If you bought this script from the https://u-Auctions.com website or https://ubidzz.com 
 * Please register at https://u-auctions.com/forum and contact the u-Auctions admin  
 * at https://u-auctions.com/forum with your order number and full name so we can change 
* your group to premium so you can view the paid area on the forums.
 *******************************************************************************/

if (!defined('InuAuctions')) exit('Access denied');
if (!defined('FEES_PATH')) exit('Access denied');

class gateway_callback
{
	function process_callback($custom_id, $fee_type, $payment_amount, $currency = NULL)
	{
		global $system, $DBPrefix, $db, $send_email, $security;
		
		switch ($fee_type)
		{
			case 1: // add to account balance
				$addquery = '';
				if ($system->SETTINGS['fee_disable_acc'] == 'y')
				{
					$query = "SELECT suspended, balance FROM " . $DBPrefix . "users WHERE id = :get_id";
					$params = array();
					$params[] = array(':get_id', $custom_id, 'int');
					$db->query($query, $params);
					$data = $db->result();
					// reable user account if it was disabled
					$params = array();
					if ($data['suspended'] == 7 && ($data['balance'] + $payment_amount) >= 0)
					{
						$addquery = ', suspended = 0, payment_reminder_sent = :payment ';
						$params[] = array(':payment', 'n', 'bool');
					}
				}
				$query = "UPDATE " . $DBPrefix . "users SET balance = balance + :payments" . $addquery . " WHERE id = :user_id";
				$params[] = array(':payments', $payment_amount, 'float');
				$params[] = array(':user_id', $custom_id, 'int');
				$db->query($query, $params);

				// add invoice
				$query = "INSERT INTO " . $DBPrefix . "useraccounts (user_id, date, balance, total, paid) VALUES
						(:user_id, :time_stamp, :payment, :extra_payment, 1)";
				$params = array();
				$params[] = array(':user_id', $custom_id, 'int');
				$params[] = array(':time_stamp', $system->ctime, 'int');
				$params[] = array(':payment', $payment_amount, 'float');
				$params[] = array(':extra_payment', $payment_amount, 'float');
				$db->query($query, $params);
			break;
			case 2: // pay for an item
				$query = "UPDATE " . $DBPrefix . "winners SET paid = 1, is_counted = 'y' WHERE id = :get_id";
				$params = array();
				$params[] = array(':get_id', $custom_id, 'int');
				$db->query($query, $params);
				
				//update the sold items counter
				$query = "UPDATE " . $DBPrefix . "counters SET items_sold = :sold";
				$params = array();
				$params[] = array(':sold', $system->COUNTERS['items_sold'] + 1, 'int');
				$db->query($query, $params);
			break;
			case 3: // pay signup fee (live mode)
				$query = "UPDATE " . $DBPrefix . "users SET suspended = 0 WHERE id = :get_id";
				$params = array();
				$params[] = array(':get_id', $custom_id, 'int');
				$db->query($query, $params);

				// add invoice
				$query = "INSERT INTO " . $DBPrefix . "useraccounts (user_id, date, signup, total, paid) VALUES
						(:get_id, :time_stamp, :payment, :extra_payment, 1)";
				$params = array();
				$params[] = array(':get_id', $custom_id, 'int');
				$params[] = array(':time_stamp', $system->ctime, 'int');
				$params[] = array(':payment', $payment_amount, 'float');
				$params[] = array(':extra_payment', $payment_amount, 'float');
				$db->query($query, $params);
			break;
			case 4: // pay auction fee (live mode)
				global $user, $MSG;
				$catscontrol = new MPTTcategories();

				$query = "SELECT auc_id FROM " . $DBPrefix . "useraccounts WHERE useracc_id = :useraccounts_id";
				$params = array();
				$params[] = array(':useraccounts_id', $custom_id, 'int');
				$db->query($query, $params);
				$auc_id = $db->result('auc_id');
				
				$query = "UPDATE " . $DBPrefix . "auctions SET suspended = 0 WHERE id = :auctions_id";
				$params = array();
				$params[] = array(':auctions_id', $auc_id, 'int');
				$db->query($query, $params);

				$query = "UPDATE " . $DBPrefix . "useraccounts SET paid = 1 WHERE auc_id = :useraccounts_id AND setup > 0";
				$params = array();
				$params[] = array(':useraccounts_id', $auc_id, 'int');
				$db->query($query, $params);

				$query = "UPDATE " . $DBPrefix . "counters SET auctions = auctions + :add_auction";
				$params = array();
				$params[] = array(':add_auction', 1, 'int');
				$db->query($query, $params);

				$query = "UPDATE " . $DBPrefix . "useraccounts SET paid = 1 WHERE useracc_id = :useraccounts_id";
				$params = array();
				$params[] = array(':useraccounts_id', $custom_id, 'int');
				$db->query($query, $params);

				$query = "SELECT id, category, title, minimum_bid, pict_url, buy_now, reserve_price, auction_type, ends
					FROM " . $DBPrefix . "auctions WHERE id = :auction_id";
				$params = array();
				$params[] = array(':auction_id', $auc_id, 'int');
				$db->query($query, $params);	
				$auc_data = $db->result();

				// auction data
				$auction_id = $auc_data['id'];
				$title = $auc_data['title'];
				$atype = $auc_data['auction_type'];
				$pict_url = $auc_data['pict_url'];
				$minimum_bid = $auc_data['minimum_bid'];
				$reserve_price = $auc_data['reserve_price'];
				$buy_now_price = $auc_data['buy_now'];
				$a_ends = $auc_data['ends'];

				if ($user->user_data['startemailmode'] == 'yes')
				{
					$send_email->confirmation($auction_id, $title, $atype, $pict_url, $minimum_bid, $reserve_price, $buy_now_price, $a_ends);
				}

				// update recursive categories
				$query = "SELECT left_id, right_id, level FROM " . $DBPrefix . "categories WHERE cat_id = :cats_id";
				$params = array();
				$params[] = array(':cats_id', $auc_data['category'], 'int');
				$db->query($query, $params);	
				$parent_node = $db->result();
				$crumbs = $catscontrol->get_bread_crumbs($parent_node['left_id'], $parent_node['right_id']);

				for ($i = 0; $i < count($crumbs); $i++)
				{
					$query = "UPDATE " . $DBPrefix . "categories SET sub_counter = sub_counter + 1 WHERE cat_id = :cats_id";
					$params = array();
					$params[] = array(':cats_id', $crumbs[$i]['cat_id'], 'int');
					$db->query($query, $params);
				}
			break;
			case 5: // pay relist fee (live mode)
				$query = "UPDATE " . $DBPrefix . "auctions SET suspended = 0 WHERE id = :auction_id";
				$params = array();
				$params[] = array(':auction_id', $custom_id, 'int');
				$db->query($query, $params);
				// add invoice
				$query = "INSERT INTO " . $DBPrefix . "useraccounts (user_id, auc_id, date, relist, total, paid) VALUES
						(:get_id, :get_extra_id, :time_stamp, :payment, :extra_payment, 1)";
				$params = array();
				$params[] = array(':get_id', $custom_id, 'int');
				$params[] = array(':get_extra_id', $custom_id, 'int');
				$params[] = array(':time_stamp', $system->ctime, 'int');
				$params[] = array(':payment', $payment_amount, 'float');
				$params[] = array(':extra_payment', $payment_amount, 'float');
				$db->query($query, $params);
			break;
			case 6:  // pay buyer fee (live mode)
				$query = "UPDATE " . $DBPrefix . "winners SET bf_paid = 1 WHERE bf_paid = 0 AND auction = :auction_id AND winner = :winner_id";
				$params = array();
				$params[] = array(':auction_id', $custom_id, 'int');
				$params[] = array(':winner_id', $user->user_data['id'], 'int');
				$db->query($query, $params);

				$query = "UPDATE " . $DBPrefix . "users SET balance = balance + :payment, suspended = 0 WHERE id = :user_id";
				$params = array();
				$params[] = array(':payment', $payment_amount, 'float');
				$params[] = array(':user_id', $user->user_data['id'], 'int');
				$db->query($query, $params);

				// add invoice
				$query = "INSERT INTO " . $DBPrefix . "useraccounts (user_id, auc_id, date, buyer, total, paid) VALUES
						(:user_id, :get_id, :time_stamp, :payment, :extra_payment, 1)";
				$params = array();
				$params[] = array(':user_id', $user->user_data['id'], 'int');
				$params[] = array(':get_id', $custom_id, 'int');
				$params[] = array(':time_stamp', $system->ctime, 'int');
				$params[] = array(':payment', $payment_amount, 'float');
				$params[] = array(':extra_payment', $payment_amount, 'float');
				$db->query($query, $params);
			break;
			case 7: // pay final value fee (live mode)
				$query = "UPDATE " . $DBPrefix . "winners SET ff_paid = 1 WHERE ff_paid = 0 AND auction = :auction_id AND seller = :user_id";
				$params = array();
				$params[] = array(':auction_id', $custom_id, 'int');
				$params[] = array(':user_id', $user->user_data['id'], 'int');
				$db->query($query, $params);

				$query = "UPDATE " . $DBPrefix . "users SET balance = balance + :payment, suspended = 0 WHERE id = :user_id";
				$params = array();
				$params[] = array(':payment', $payment_amount, 'float');
				$params[] = array(':user_id', $user->user_data['id'], 'int');
				$db->query($query, $params);

				// add invoice
				$query = "INSERT INTO " . $DBPrefix . "useraccounts (user_id, auc_id, date, finalval, total, paid) VALUES
						(:user_id, :get_id, :time_stamp, :payment, :extra_payment, 1)";
				$params = array();
				$params[] = array(':user_id', $user->user_data['id'], 'int');
				$params[] = array(':get_id', $custom_id, 'int');
				$params[] = array(':time_stamp', $system->ctime, 'int');
				$params[] = array(':payment', $payment_amount, 'float');
				$params[] = array(':extra_payment', $payment_amount, 'float');
				$db->query($query, $params);

			break;
			case 8: //Activate New Banner Account 
                $query = "UPDATE " . $DBPrefix . "bannersusers SET paid = 1 WHERE id = :bannersusers_id"; 
                $params = array();
				$params[] = array(':bannersusers_id', $custom_id, 'int');
				$db->query($query, $params);
            break; 
            case 9: //Activate Extra Banner on banner user account 
                $query = "UPDATE " . $DBPrefix . "bannersusers SET ex_banner_paid = 'y' WHERE id = :bannersusers_id";
                $params = array();
				$params[] = array(':bannersusers_id', $custom_id, 'int');
				$db->query($query, $params); 
            break; 
			case 10: //Digital item was paid now send email with digital item link
            	//Get auction id, winner id and seller id 
                $query = "SELECT DISTINCT w.bid, w.winner, w.auction, w.bid, b.title, d.item, d.seller, d.hash, u.nick, u.email, u.name
                FROM " . $DBPrefix . "winners w
                LEFT JOIN " . $DBPrefix . "auctions b ON (b.id = w.auction) 
        		LEFT JOIN " . $DBPrefix . "users u ON (u.id = w.winner) 
                LEFT JOIN " . $DBPrefix . "digital_items d ON (d.auctions = w.auction)
                WHERE w.id = :digital_id"; 
				$params = array();
				$params[] = array(':digital_id', $custom_id, 'int');
				$db->query($query, $params); 
				while ($data = $db->result())
				{
					$send_email->digital_item_email($data['title'], $data['name'], $data['auction'], $data['bid'], $data['nick'], $data['email'], $security->encrypt($data['hash']), $data['pict_url'], $data['id'], $data['email']);
				}
				//update winners db that the item was paid for
				$query = "UPDATE " . $DBPrefix . "winners SET paid = 1, is_counted = 'y' WHERE id = :paid_id";
				$params = array();
				$params[] = array(':paid_id', $custom_id, 'int');
				$db->query($query, $params); 
				
				//update the sold items counter
				$query = "UPDATE " . $DBPrefix . "counters SET items_sold = :sold";
				$params = array();
				$params[] = array(':sold', $system->COUNTERS['items_sold'] + 1, 'int');
				$db->query($query, $params);
            break;
			
		}
	}
}
