<?php
$current_page = 'banners';
include 'common.php';

include LANGUAGE_PATH . $language . '/categories.inc.php';

unset($ERR);
$banner = (isset($_GET['banner']) && !empty($_GET['banner'])) ? $_GET['banner'] : '';
$banner = (isset($_POST['banner']) && !empty($_POST['banner'])) ? $_POST['banner'] : $banner;
$id = intval($_REQUEST['id']);

if (isset($_POST['action']) && $_POST['action'] == 'insert')
{
	// Data integrity
	if (empty($_FILES['bannerfile']) || empty($_POST['url']))
	{
		$ERR = $ERR_047;
	}
	else
	{
		if ($_FILES['bannerfile']['tmp_name'] != '' && $_FILES['bannerfile']['tmp_name'] != 'none')
		{
			// Handle upload
			if (!file_exists(UPLOAD_PATH . 'banners'))
			{
				umask();
				mkdir(UPLOAD_PATH . 'banners', 0777);
			}
			if (!file_exists(UPLOAD_PATH . 'banners/' . $id))
			{
				umask();
				mkdir(UPLOAD_PATH . 'banners/' . $id, 0777);
			}
			$TARGET = UPLOAD_PATH . 'banners/' . $id . '/' . $_FILES['bannerfile']['name'];
			if (file_exists($TARGET))
			{
				unlink($TARGET);
			}
			list($imagewidth, $imageheight, $imageType) = getimagesize($_FILES['bannerfile']['tmp_name']);
			$filename = basename($_FILES['bannerfile']['name']);
			$file_ext = strtolower(substr($filename, strrpos($filename, '.') + 1));
			$file_types = explode(', ', $system->SETTINGS['banner_types']);
			$type = end(explode('.', strtolower($_FILES['bannerfile']['name']))); 
			$limit_size=50000;
			
			if ($imagewidth > $system->SETTINGS['banner_width'])
			{
				$imagewidth = $system->SETTINGS['banner_width'];
			}
			if ($imageheight > $system->SETTINGS['banner_height'])
			{
				$imageheight = $system->SETTINGS['banner_height'];
			}
			if ($imagewidth < $system->SETTINGS['banner_width'] || $imageheight < $system->SETTINGS['banner_height'])
 				{
   				$ERR = $MSG['350_10126'];
  				}
  				else
				{
					if (!in_array($type, $file_types))
					{
						$ERR = $MSG['_0048'];
					}
					else
					{
						$imageType = image_type_to_mime_type($imageType);
						switch ($imageType)
					{
						case 'image/gif':
							$FILETYPE = 'gif';
							break;
						case 'image/pjpeg':
						case 'image/jpeg':
						case 'image/jpg':
							$FILETYPE = 'jpg';
							break;
						case 'image/png':
						case 'image/x-png':
							$FILETYPE = 'png';
							break;
						case 'application/x-shockwave-flash':
							$FILETYPE = 'swf';
							break;
					}
					if (!empty($_FILES['bannerfile']['tmp_name']) && $_FILES['bannerfile']['tmp_name'] != 'none')
					{
						move_uploaded_file($_FILES['bannerfile']['tmp_name'], $TARGET);
						chmod($TARGET, 0666);
					}
				}
			}
		}

		// Update database
		$extrasql = '';
		$params = array();
		if ($_FILES['bannerfile']['tmp_name'] != '' && $_FILES['bannerfile']['tmp_name'] != 'none')
		{
			$extrasql = "name = :bannerfile,
				type = :type,
				width = :imagewidth,
				height = :imageheight,";
			$params[] = array(':bannerfile', $_FILES['bannerfile']['name'], 'str');
			$params[] = array(':type', $FILETYPE, 'bool');
			$params[] = array(':imagewidth', $imagewidth, 'int');
			$params[] = array(':imageheight', $imageheight, 'int');
		}		
	
		$query = "UPDATE " . $DBPrefix . "banners
			SET " . $extrasql . "
			url = :url,
			sponsortext = :sponsortext,
			alt = :alt,
			purchased = :purchased,
			seller = " . $user->user_data['id']. "
			WHERE id = :id";
		$params[] = array(':url', $_POST['url'], 'str');
		$params[] = array(':sponsortext', $_POST['sponsortext'], 'str');
		$params[] = array(':alt', $_POST['alt'], 'str');
		$params[] = array(':purchased', $_POST['purchased'], 'int');
		$params[] = array(':id', $banner, 'int');
		$db->query($query, $params);
	
	
		$query = "DELETE FROM " . $DBPrefix . "bannerscategories WHERE banner = :banner_id";
		$params = array();
		$params[] = array(':banner_id', $banner, 'int');
		$db->query($query, $params);
	
		$query = "DELETE FROM " . $DBPrefix . "bannerskeywords WHERE banner = :banner_id";
		$params = array();
		$params[] = array(':banner_id', $banner, 'int');
		$db->query($query, $params);
	
		// Handle filters
		if (is_array($_POST['category']))
		{
			foreach ($_POST['category'] as $k => $v)
			{
				$query = "INSERT INTO " . $DBPrefix . "bannerscategories VALUES (:banner_id, :cat)";
				$params = array();
				$params[] = array(':banner_id', $banner, 'int');
				$params[] = array(':cat', $v, 'int');
				$db->query($query, $params);
			}
		}
		if (!empty($_POST['keywords']))
		{
			$KEYWORDS = explode("\n", $_POST['keywords']);
			foreach ($KEYWORDS as $k => $v)
			{
				if (!empty($v))
				{
					$query = "INSERT INTO " . $DBPrefix . "bannerskeywords VALUES (:banner_id, :keyword)";
					$params = array();
					$params[] = array(':banner_id', $banner, 'int');
					$params[] = array(':keyword', $system->cleanvars(trim($v)), 'str');
					$db->query($query, $params);
				}
			}
		}
		header('location: userbanners.php?id=' . $id);
	}
}

// Retrieve user's banners
$query = "SELECT * FROM " . $DBPrefix . "banners WHERE id = :banner_id";
$params = array();
$params[] = array(':banner_id', $banner, 'int');
$db->query($query, $params);
$bg = '';
while ($row = $db->result())
{
	$BANNER = $row;
	$template->assign_block_vars('banners', array(
			'ID' => $row['id'],
			'TYPE' => $row['type'],
			'NAME' => $row['name'],
			'BANNER' => UPLOAD_FOLDER . 'banners/' . $id . '/' . $row['name'],
			'WIDTH' => $row['width'],
			'HEIGHT' => $row['height'],
			'URL' => $row['url'],
			'ALT' => $row['alt'],
			'SPONSERTEXT' => $row['sponsortext'],
			'VIEWS' => $row['views'],
			'CLICKS' => $row['clicks'],
			'PURCHASED' => $row['purchased'],
			'BG' => $bg
			));
	$bg = ($bg == '') ? 'class="bg"' : '';
}

// Retrieve user's information
$query = "SELECT * FROM " . $DBPrefix . "bannersusers WHERE id = " . $id;
$params = array();
$params[] = array(':banner_id', $id, 'int');
$db->query($query, $params);
if ($db->numrows() > 0)
{
	$USER = $db->result();
}

// Retrieve filters
$KEYWORDS = '';
$query = "SELECT keyword FROM " . $DBPrefix . "bannerskeywords WHERE banner = :banner_id";
$params = array();
$params[] = array(':banner_id', $banner, 'int');
$db->query($query, $params);
if ($db->numrows() > 0)
{
	while ($words = $db->result('keyword'))
	{
		$KEYWORDS .= $words . "\n";
	}
}

$template->assign_vars(array(
		'ERROR2' => (isset($ERR)) ? $ERR : '',
		'ID' => $id,
		'NAME' => $USER['name'],
		'COMPANY' => $USER['company'],
		'EMAIL' => $USER['email'],
		// form values
		'BANNERID' => $banner,
		'URL' => $BANNER['url'],
		'SPONSORTEXT' => $BANNER['sponsortext'],
		'ALT' => $BANNER['alt'],
		'PURCHASED' => $BANNER['purchased'],
		'KEYWORDS' => $KEYWORDS,
		'NOTEDIT' => false
		));
		
include 'header.php';
include 'includes/user_cp.php';
$template->set_filenames(array(
		'body' => 'editbanner.tpl'
		));
$template->display('body');
include 'footer.php';