<?php
/*******************************************************************************
 *   copyright				: (C) 2013 - 2016 u-Auctions
 *   site					: https://www.u-auctions.com
 *******************************************************************************/

/*******************************************************************************
 *   This uAuctions is a Paid version of u-Auctions script.
 *   You are not allowed to resell/sell this script is  copyrighted to u-auctions.com.
 *   If you have been sold this script from a 3rd party and not from the 
 *   https://u-auctions.com website or https://ubidzz.com ask for a refund.
 *******************************************************************************/
/*******************************************************************************
 * If you bought this script from the https://u-Auctions.com website or https://ubidzz.com 
 * Please register at https://u-auctions.com/forum and contact the u-Auctions admin  
 * at https://u-auctions.com/forum with your order number and full name so we can change 
* your group to premium so you can view the paid area on the forums.
 *******************************************************************************/

define('InAdmin', 1);
$current_page = 'Upgrading u-Auctions';
include '../common.php';
include INCLUDE_PATH . 'functions_admin.php';
include PLUGIN_PATH . 'ScriptUpdater/functions_upgrade.php';
include 'loggedin.inc.php';

$display_upgrade_message = isset($_SESSION['upgrade_message']) ? $_SESSION['upgrade_message'] : 1;
$upgrade_window = false;
unset($ERR);
$upgrading = new upgrading();

//checking to see if the upgrade button was clicked and now start upgrading the u-Auctions script
if($_POST['action'] == 'start_upgrading' && is_array($_POST['folders']) && is_array($_POST['pages']))
{			
	//making new sessions or editing them because the page has to be reloaded after the upgrade is finished
	$_SESSION['ERR_MESSAGE'] = $upgrading->start_upgrading($_POST['folders'],$_POST['pages']);
	$_SESSION['new_version'] = $system->SETTINGS['version'];	
	$_SESSION['upgrade_message'] = 1;
	//will reload the page now so that all the messages display the correct messages and values
	header('location: ' . $system->SETTINGS['siteurl'] . $system->SETTINGS['admin_folder'] .'/upgradescript.php');
	exit;
}
//checking to see if the download button was clicked and now download and unzip the upgrade file
elseif($_POST['action'] == 'upgrading' && isset($_POST['path']) && isset($_POST['required_version']) && isset($_POST['new_version']))
{			
	$ERR = $upgrading->download_upgrade($_POST['path'],$_POST['required_version']);
	$_SESSION['new_version'] = $_POST['new_version'];
	$display_upgrade_message = 2;
}
elseif(isset($_SESSION['ERR_MESSAGE']))
{
	$ERR = $_SESSION['ERR_MESSAGE'];
	$display_upgrade_message = 1;
}
elseif($_POST['action'] == 'apikey' && $_POST['api_key'] !='')
{
	$query = "UPDATE " . $DBPrefix . "settings SET upgradeAPIkey = :key";
	$params = array();
	$params[] = array(':key', $_POST['api_key'], 'str');
	$db->query($query, $params);
	$system->SETTINGS['upgradeAPIkey'] = $_POST['api_key'];
}

//in case the admin didn't upgrade but did download the upgrade file. 
//We want this PLUGIN_PATH . 'ScriptUpdater/upgrade/ folder empty if the $display_upgrade_message is set to 1
if($display_upgrade_message == 1 && is_dir(PLUGIN_PATH . 'ScriptUpdater/upgrade/'))
{
	$upgrading->deleteTemp(PLUGIN_PATH . 'ScriptUpdater/upgrade', 0);
}

switch ($display_upgrade_message) 
{
	case 1://display the new version list
		//get the list of the upgrade versions
		$apiUpgrade = upgradeCheck(1);
		if ($apiUpgrade['check'] == 'passed')
		{
			$upgrade_list_xml = simplexml_load_file($apiUpgrade['link']);
			$upgrade = false;
			foreach($upgrade_list_xml->upgrade as $child)
			{
				$old_version = $upgrading->simplexml_to_array($child);
				if (isset($child) && is_array($old_version))
				{
				    $old_versions = $old_version[old_version];
				}
				
				//only diplaying the versions that are higher then the current version that is installed
				if($old_versions == $system->SETTINGS['version']) 
				{
					$upgrade = true;
				    $new_version = $upgrading->simplexml_to_array($child->new_version);
				    if (isset($child->new_version) && is_array($new_version))
				    {
						$new_versions = $new_version[new_version];
					}
					$title = $upgrading->simplexml_to_array($child->title);
					if (isset($child->title) && is_array($title))
					{
					    $upgrade_title = $title[title];
					}
					$path = $upgrading->simplexml_to_array($child->link);
					if (isset($child->link) && is_array($path))
					{
						$upgrade_path = $path[link];
					}
					$upgrade_window = true;
					$template->assign_block_vars('upgrade_list', array(
						'TITLE' => $upgrade_title,
						'OLD_VERSION' => $old_versions,
						'NEW_VERSION' => $new_versions,
						'PATH' => $upgrade_path,
						'INSTALLED_VERSION' => $system->SETTINGS['version'],
						'HIDE_BUTTON' => true,
						'PAGE_NAME' => sprintf($MSG['3500_1015696'], $new_versions)
					));
				}
			}
			if(!$upgrade)
			{
				$template->assign_block_vars('upgrade_list', array(
					'TITLE' => $MSG['3500_1015695'],
					'OLD_VERSION' => $system->SETTINGS['version'],
					'NEW_VERSION' => $system->SETTINGS['version'],
					'PATH' => '',
					'INSTALLED_VERSION' => $system->SETTINGS['version'],
					'HIDE_BUTTON' => false,
					'PAGE_NAME' => $MSG['3500_1015694']
				));
			}
		}else{
			$ERR = 'Could not validate your API key please use a valid API key and reload this page!';
		}
	break;
	//downloaded the new version and now getting the xml page from the
	//u-Auctions website and display what page will be replaced and in what directories.
	case 2:	//This will also be used to move the pages to their correct directories.
		$apiUpgrade = upgradeCheck(2, $_SESSION['new_version']); 
		if($apiUpgrade['check'] == 'passed')
		{
			$upgrade_xml = simplexml_load_file($apiUpgrade['link']);

			//displaying the upgrade info
			foreach($upgrade_xml->upgrade->upgrade_info as $child)
			{
				$old_version = $upgrading->simplexml_to_array($child->old_version);
				if (isset($child) && is_array($old_version))
				{
				    $old_versions = $old_version[old_version];
				}
				$new_version = $upgrading->simplexml_to_array($child->new_version);
				if (isset($child->new_version) && is_array($new_version))
				{
					$new_versions = $new_version[new_version];
				}
				$title = $upgrading->simplexml_to_array($child->title);
				if (isset($child->title) && is_array($title))
				{
				    $upgrade_title = $title[title];
				}
				$description = $upgrading->simplexml_to_array($child->description);
				if (isset($child->description) && is_array($description))
				{
				    $upgrade_description = $description[description];
				}
				$script_bitbucket = $upgrading->simplexml_to_array($child->bitbucket->script);
				if (isset($child->bitbucket->script) && is_array($script_bitbucket))
				{
				    $bitbucket_script = $script_bitbucket[script];
				}
				$language_bitbucket = $upgrading->simplexml_to_array($child->bitbucket->language);
				if (isset($child->bitbucket->language) && is_array($language_bitbucket))
				{
				    $bitbucket_language = $language_bitbucket[language];
				}
				$help_forums = $upgrading->simplexml_to_array($child->help);
				if (isset($child->help) && is_array($help_forums))
				{
				    $support = $help_forums[help];
				}
				$extra = $upgrading->simplexml_to_array($child->extra_details);
				if (isset($child->extra_details) && is_array($extra))
				{
				    $extra_details = $extra[extra_details];
				}
							
				$template->assign_block_vars('upgrade_info', array(
					'TITLE' => $upgrade_title,
					'OLD_VERSION' => $old_versions,
					'NEW_VERSION' => $new_versions,
					'INSTALLED_VERSION' => $system->SETTINGS['version'],
					'DEC' => $upgrade_description,
					'SCRIPT_BITBUCKET' => $bitbucket_script,
					'LANGUAGE_BITBUCKET' => $bitbucket_language,
					'HELP' => $support,
					'EXTRAS' => $extra_details,
				));
			}
			
			//displaying the list of new pages
			foreach ($upgrade_xml->upgrade->upgrade_pages as $child)
			{
				//getting the file path for the pages
				$dir = $upgrading->simplexml_to_array($child->dir);
				if (isset($child) && is_array($dir))
				{
				    $temp_dir = $dir[dir];
				}
				$template->assign_block_vars('upgrade_dir', array(
					'FOLDER' => $temp_dir
				));
				//loop each page
				foreach($child->page as $page_child)
				{
					$template->assign_block_vars('upgrade_dir.upgrade_pages', array(
						'PAGE' => $page_child
					));
				}
			}
		}else{
			$ERR = 'Could not validate your API key please use a valid API key and reload this page!';		
		}					
	break;
}

unset($_SESSION['ERR_MESSAGE']);
$template->assign_vars(array(
	'ERROR' => (isset($ERR)) ? $ERR : '',
	'PAGE' => $display_upgrade_message == 2 ? true : false,
	'APIKEY' => $system->SETTINGS['upgradeAPIkey']
));

$template->set_filenames(array(
		'body' => 'upgradescript.tpl'
		));
$template->display('body');
