<?php

/*
#======================================================
|    Trellis Desk
|    =====================================
|    By DJ Tarazona (dj@accord5.com)
|    (c) 2010 ACCORD5
|    http://www.trellisdesk.com/
|    =====================================
|    Email: sales@accord5.com
#======================================================
|    @ Version: v1.0.4 Final Build 10440094
|    @ Version Int: 104.4.0.094
|    @ Version Num: 10440094
|    @ Build: 0094
#======================================================
|    | Admin Backup
#======================================================
*/

class ad_backup {

	#=======================================
	# @ Auto Run
	# Function that is run automatically
	# when the file is required.
	#=======================================

	function auto_run()
	{
		if ( ! $this->ifthd->member['acp']['tools_backup'] )
		{
			$this->ifthd->skin->error('no_perm');
		}
		
		$this->ifthd->skin->set_section( 'Tools &amp; Maintenance' );		
		$this->ifthd->skin->set_description( 'Run maintenance utilities, recount functions, cleaning utilities and backup functions.' );

		switch( $this->ifthd->input['code'] )
    	{
    		case 'full':
				$this->show_full();
    		break;
    		case 'sql':
				$this->show_sql();
    		break;
    		case 'file':
				$this->show_file();
    		break;

    		case 'dofull':
				$this->do_full();
    		break;
    		case 'dosql':
				$this->do_sql();
    		break;
    		case 'dofile':
				$this->do_file();
    		break;

    		default:
    			$this->show_full();
    		break;
		}
	}

	#=======================================
	# @ Show Full
	# Show the full backup page.
	#=======================================

	function show_full()
	{
		#=============================
		# Do Output
		#=============================

		$this->output = "<div class='groupbox'>Full Backup</div>
						<div class='subbox'>A full backup is a backup of all the files in the Trellis Desk directory, along with a backup of the SQL database.  To perform a full backup backup, simply select your desired options below and then click Backup.</div>
						<form action='<! HD_URL !>/admin.php?section=tools&amp;act=backup&amp;code=dofull' method='post'>
						<div class='option1'><label for='td_tables'><input type='checkbox' name='td_tables' id='td_tables' value='1' class='ckbox' checked='checked' /> Backup only Trellis Desk tables</label></div>
						<div class='option2'><label for='drop_table'><input type='checkbox' name='drop_table' id='drop_table' value='1' class='ckbox' checked='checked' /> Add DROP TABLE IF EXISTS</label></div>
						<div class='option1'><label for='if_not_exists'><input type='checkbox' name='if_not_exists' id='if_not_exists' value='1' class='ckbox' checked='checked' /> Use CREATE IF NOT EXISTS</label></div>
						<div class='option2'><label for='gzip'><input type='checkbox' name='gzip' id='gzip' value='1' class='ckbox' checked='checked' /> GZip Backup</label></div>
						<div class='formtail'><input type='submit' name='submit' id='submit' value='Backup' class='button' /></div>
						</form>";

		$this->ifthd->skin->add_output( $this->output );

		$this->nav = array(
						   "<a href='<! HD_URL !>/admin.php?section=tools'>Tools</a>",
						   "<a href='<! HD_URL !>/admin.php?section=tools&amp;act=backup'>Backup</a>",
						   "SQL Backup",
						   );

		$this->ifthd->skin->do_output( array( 'nav' => $this->nav, 'title' => 'Backups &amp; Updates' ) );
	}

	#=======================================
	# @ Show SQL
	# Show the SQL backup page.
	#=======================================

	function show_sql()
	{
		#=============================
		# Do Output
		#=============================

		$this->output = "<div class='groupbox'>SQL Backup</div>
						<div class='subbox'>To perform an SQL backup, simply select your desired options below and then click Backup.</div>
						<form action='<! HD_URL !>/admin.php?section=tools&amp;act=backup&amp;code=dosql' method='post'>
						<div class='option1'><label for='td_tables'><input type='checkbox' name='td_tables' id='td_tables' value='1' class='ckbox' checked='checked' /> Backup only Trellis Desk tables</label></div>
						<div class='option2'><label for='drop_table'><input type='checkbox' name='drop_table' id='drop_table' value='1' class='ckbox' checked='checked' /> Add DROP TABLE IF EXISTS</label></div>
						<div class='option1'><label for='if_not_exists'><input type='checkbox' name='if_not_exists' id='if_not_exists' value='1' class='ckbox' checked='checked' /> Use CREATE IF NOT EXISTS</label></div>
						<div class='option2'><label for='gzip'><input type='checkbox' name='gzip' id='gzip' value='1' class='ckbox' checked='checked' /> GZip Backup</label></div>
						<div class='formtail'><input type='submit' name='submit' id='submit' value='Backup' class='button' /></div>
						</form>";

		$this->ifthd->skin->add_output( $this->output );

		$this->nav = array(
						   "<a href='<! HD_URL !>/admin.php?section=tools'>Tools</a>",
						   "<a href='<! HD_URL !>/admin.php?section=tools&amp;act=backup'>Backup</a>",
						   "SQL Backup",
						   );

		$this->ifthd->skin->do_output( array( 'nav' => $this->nav, 'title' => 'Backups &amp; Updates' ) );
	}

	#=======================================
	# @ Show File
	# Show the file backup page.
	#=======================================

	function show_file()
	{
		#=============================
		# Do Output
		#=============================

		$this->output = "<div class='groupbox'>File Backup</div>
						<div class='subbox'>To perform a file backup, simply click the Backup button below.  This will take all the files and folders in the Trellis Desk directory and zips them.</div>
						<form action='<! HD_URL !>/admin.php?section=tools&amp;act=backup&amp;code=dofile' method='post'>
						<div class='formtail'><input type='submit' name='submit' id='submit' value='Backup' class='button' /></div>
						</form>";

		$this->ifthd->skin->add_output( $this->output );

		$this->nav = array(
						   "<a href='<! HD_URL !>/admin.php?section=tools'>Tools</a>",
						   "<a href='<! HD_URL !>/admin.php?section=tools&amp;act=backup'>Backup</a>",
						   "File Backup",
						   );

		$this->ifthd->skin->do_output( array( 'nav' => $this->nav, 'title' => 'Backups &amp; Updates' ) );
	}

	#=======================================
	# @ Do Full
	# Perform a full backup.
	#=======================================

	function do_full()
	{
		if ( $this->ifthd->input['td_tables'] )
		{
			$tables = array(
							DB_PRE .'announcements'		=> 1,
							DB_PRE .'articles'			=> 1,
							DB_PRE .'article_rate'		=> 1,
							DB_PRE .'asessions'			=> 1,
							DB_PRE .'attachments'		=> 1,
							DB_PRE .'canned'			=> 1,
							DB_PRE .'categories'		=> 1,
							DB_PRE .'comments'			=> 1,
							DB_PRE .'departments'		=> 1,
							DB_PRE .'depart_fields'		=> 1,
							DB_PRE .'groups'			=> 1,
							DB_PRE .'languages'			=> 1,
							DB_PRE .'logs'				=> 1,
							DB_PRE .'members'			=> 1,
							DB_PRE .'news_comments'		=> 1,
							DB_PRE .'pages'				=> 1,
							DB_PRE .'profile_fields'	=> 1,
							DB_PRE .'replies'			=> 1,
							DB_PRE .'reply_rate'		=> 1,
							DB_PRE .'sessions'			=> 1,
							DB_PRE .'settings'			=> 1,
							DB_PRE .'settings_groups'	=> 1,
							DB_PRE .'skins'				=> 1,
							DB_PRE .'tickets'			=> 1,
							DB_PRE .'tokens'			=> 1,
							DB_PRE .'upg_history'		=> 1,
							DB_PRE .'validation'		=> 1,
							);
		}

		$backup = $this->ifthd->core->db->get_backup( $tables, $this->ifthd->input['drop_table'], $this->ifthd->input['if_not_exists'] );

		if ( $this->ifthd->input['gzip'] )
		{
			$tmp_file = tempnam( HD_PATH .'core/tmp', 'sqlb_' ) .'.gz';
			$sql_file = 'sql_backup_td.sql.gz';

			$handle = gzopen( $tmp_file, 'w9' );

			gzwrite( $handle, $backup );

			gzclose( $handle );

			$f_tmp = @fopen( $tmp_file, 'r');

			$sql_data = @fread( $f_tmp, filesize( $tmp_file ) );

			fclose( $f_tmp );

			unlink( $tmp_file );
		}
		else
		{
			$sql_file = 'sql_backup_td.sql';
			$sql_data = $backup;
		}

		require_once HD_INC .'class_zip.php';

		$this->zip = new zipfile();

		$this->zip_add_dir( HD_PATH );

		$this->zip->addFile( $sql_data, $sql_file );

		$zip_content = $this->zip->file();

		header('Content-type: application/zip');
		header('Content-length: ' . strlen( $zip_content ));
		header('Content-Disposition: attachment; filename="full_backup_td.zip"');

		print $zip_content;
	}

	#=======================================
	# @ Do SQL
	# Perform an SQL database backup.
	#=======================================

	function do_sql()
	{
		if ( $this->ifthd->input['gzip'] )
		{
			header('Content-type: application/x-gzip gz tgz');
			header('Content-Disposition: attachment; filename="sql_backup_td.sql.gz"');
		}
		else
		{
			header('Content-type: application/sql');
			header('Content-Disposition: attachment; filename="sql_backup_td.sql"');
		}

		if ( $this->ifthd->input['td_tables'] )
		{
			$tables = array(
							DB_PRE .'announcements'		=> 1,
							DB_PRE .'articles'			=> 1,
							DB_PRE .'article_rate'		=> 1,
							DB_PRE .'asessions'			=> 1,
							DB_PRE .'attachments'		=> 1,
							DB_PRE .'canned'			=> 1,
							DB_PRE .'categories'		=> 1,
							DB_PRE .'comments'			=> 1,
							DB_PRE .'departments'		=> 1,
							DB_PRE .'depart_fields'		=> 1,
							DB_PRE .'groups'			=> 1,
							DB_PRE .'languages'			=> 1,
							DB_PRE .'logs'				=> 1,
							DB_PRE .'members'			=> 1,
							DB_PRE .'news_comments'		=> 1,
							DB_PRE .'pages'				=> 1,
							DB_PRE .'profile_fields'	=> 1,
							DB_PRE .'replies'			=> 1,
							DB_PRE .'reply_rate'		=> 1,
							DB_PRE .'sessions'			=> 1,
							DB_PRE .'settings'			=> 1,
							DB_PRE .'settings_groups'	=> 1,
							DB_PRE .'skins'				=> 1,
							DB_PRE .'tickets'			=> 1,
							DB_PRE .'tokens'			=> 1,
							DB_PRE .'upg_history'		=> 1,
							DB_PRE .'validation'		=> 1,
							);
		}

		$backup = $this->ifthd->core->db->get_backup( $tables, $this->ifthd->input['drop_table'], $this->ifthd->input['if_not_exists'] );

		if ( $this->ifthd->input['gzip'] )
		{
			$tmp_file = tempnam( HD_PATH .'core/tmp', 'sqlb_' ) .'.gz';

			$handle = gzopen( $tmp_file, 'w9' );

			gzwrite( $handle, $backup );

			gzclose( $handle );

			readgzfile( $tmp_file );

			unlink( $tmp_file );
		}
		else
		{
			print $backup;
		}
	}

	#=======================================
	# @ Do File
	# Perform a file backup.
	#=======================================

	function do_file()
	{
		require_once HD_INC .'class_zip.php';

		$this->zip = new zipfile();

		$this->zip_add_dir( HD_PATH );

		$zip_content = $this->zip->file();

		header('Content-type: application/zip');
		header('Content-length: ' . strlen( $zip_content ));
		header('Content-Disposition: attachment; filename="file_backup_td.zip"');

		print $zip_content;
	}

	#=======================================
	# @ Zip Add Directory
	# Adds a directory and its content to
	# the zip file.
	#=======================================

	function zip_add_dir($dir, $extdir="")
	{
		if ( $handle = opendir( $dir ) )
		{
     		while ( ( $file = readdir($handle) ) !== false )
			{
				if ( $file != "." && $file != ".." )
				{
					if ( ! is_dir( $dir . $file ) )
					{
						$f_tmp = @fopen( $dir . $file, 'r');

						if( $f_tmp )
						{
							$file_data = @fread( $f_tmp, filesize( $dir . $file ) );

							$this->zip->addFile( $file_data, $extdir . $file );

	           				fclose( $f_tmp );
						}
					}
					else
					{
						$this->zip_add_dir( $dir . $file .'/', $extdir . $file .'/' );
					}
				}
			}

			closedir($handle);
		}
	}

}

?>