
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_tomato11861`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]address_book`
--

CREATE TABLE `[[dbprefix]]address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `entry_gender` char(1) NOT NULL,
  `entry_company` varchar(32) DEFAULT NULL,
  `entry_firstname` varchar(32) NOT NULL,
  `entry_lastname` varchar(32) NOT NULL,
  `entry_street_address` varchar(64) NOT NULL,
  `entry_suburb` varchar(32) DEFAULT NULL,
  `entry_postcode` varchar(10) NOT NULL,
  `entry_city` varchar(32) NOT NULL,
  `entry_state` varchar(32) DEFAULT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  `entry_telephone` varchar(32) DEFAULT NULL,
  `entry_fax` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`address_book_id`),
  KEY `idx_address_book_customers_id` (`customers_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administrators`
--

CREATE TABLE `[[dbprefix]]administrators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(32) DEFAULT NULL,
  `user_password` varchar(40) NOT NULL,
  `user_settings` text,
  `email_address` varchar(96) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]administrators`
--

INSERT INTO `[[dbprefix]]administrators` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', NULL, '[[admin_email]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administrators_access`
--

CREATE TABLE `[[dbprefix]]administrators_access` (
  `administrators_id` int(11) NOT NULL,
  `module` varchar(255) NOT NULL,
  PRIMARY KEY (`administrators_id`,`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]administrators_access`
--

INSERT INTO `[[dbprefix]]administrators_access` VALUES
(1, '*');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administrators_log`
--

CREATE TABLE `[[dbprefix]]administrators_log` (
  `id` int(11) NOT NULL,
  `module` varchar(255) NOT NULL,
  `module_action` varchar(32) DEFAULT NULL,
  `module_id` int(11) DEFAULT NULL,
  `field_key` varchar(255) NOT NULL,
  `old_value` text,
  `new_value` text,
  `action` varchar(255) NOT NULL,
  `administrators_id` int(11) NOT NULL,
  `datestamp` datetime NOT NULL,
  KEY `idx_administrators_log_id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles`
--

CREATE TABLE `[[dbprefix]]articles` (
  `articles_id` int(11) NOT NULL AUTO_INCREMENT,
  `articles_categories_id` int(11) NOT NULL,
  `articles_status` tinyint(1) NOT NULL,
  `articles_order` int(10) NOT NULL,
  `articles_date_added` datetime NOT NULL,
  `articles_last_modified` datetime NOT NULL,
  `articles_image` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`articles_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]articles`
--

INSERT INTO `[[dbprefix]]articles` VALUES
(1, 1, 1, 1, '[[regtime]]', '[[regtime]]', NULL),
(2, 1, 1, 2, '[[regtime]]', '[[regtime]]', NULL),
(3, 1, 1, 3, '[[regtime]]', '[[regtime]]', NULL),
(4, 1, 1, 4, '[[regtime]]', '[[regtime]]', NULL),
(5, 1, 1, 5, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles_categories`
--

CREATE TABLE `[[dbprefix]]articles_categories` (
  `articles_categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `articles_categories_status` tinyint(1) NOT NULL,
  `articles_categories_order` int(10) NOT NULL,
  PRIMARY KEY (`articles_categories_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]articles_categories`
--

INSERT INTO `[[dbprefix]]articles_categories` VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles_categories_description`
--

CREATE TABLE `[[dbprefix]]articles_categories_description` (
  `articles_categories_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `articles_categories_name` varchar(255) NOT NULL,
  `articles_categories_url` varchar(255) NOT NULL,
  `articles_categories_page_title` varchar(255) NOT NULL,
  `articles_categories_meta_keywords` varchar(255) NOT NULL,
  `articles_categories_meta_description` varchar(255) NOT NULL,
  PRIMARY KEY (`articles_categories_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]articles_categories_description`
--

INSERT INTO `[[dbprefix]]articles_categories_description` VALUES
(1, 1, 'Information', 'information', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles_description`
--

CREATE TABLE `[[dbprefix]]articles_description` (
  `articles_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `articles_name` varchar(255) NOT NULL,
  `articles_url` varchar(255) NOT NULL,
  `articles_description` text NOT NULL,
  `articles_page_title` varchar(255) NOT NULL,
  `articles_meta_keywords` varchar(255) NOT NULL,
  `articles_meta_description` varchar(255) NOT NULL,
  PRIMARY KEY (`articles_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]articles_description`
--

INSERT INTO `[[dbprefix]]articles_description` VALUES
(1, 1, 'About Us', 'about-us', 'Put here the required information.', '', '', ''),
(2, 1, 'Shipping & Returns', 'shipping-returns', 'Put here the required information.', '', '', ''),
(3, 1, 'Privacy Notice', 'privacy-notice', 'Put here the required information.', '', '', ''),
(4, 1, 'Conditions of Use', 'conditions-of-use', 'Put here the required information.', '', '', ''),
(5, 1, 'Imprint', 'imprint', 'Put here the required information.', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners`
--

CREATE TABLE `[[dbprefix]]banners` (
  `banners_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_title` varchar(64) NOT NULL,
  `banners_url` varchar(255) NOT NULL,
  `banners_image` varchar(64) NOT NULL,
  `banners_group` varchar(10) NOT NULL,
  `banners_html_text` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `expires_impressions` int(7) DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `date_scheduled` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`banners_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners_history`
--

CREATE TABLE `[[dbprefix]]banners_history` (
  `banners_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_id` int(11) NOT NULL,
  `banners_shown` int(5) NOT NULL DEFAULT '0',
  `banners_clicked` int(5) NOT NULL DEFAULT '0',
  `banners_history_date` datetime NOT NULL,
  PRIMARY KEY (`banners_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(64) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  `categories_status` int(1) DEFAULT '1',
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`categories_id`),
  KEY `idx_categories_parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories_description`
--

CREATE TABLE `[[dbprefix]]categories_description` (
  `categories_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `categories_name` varchar(64) NOT NULL,
  `categories_url` varchar(64) NOT NULL,
  `categories_page_title` varchar(255) NOT NULL,
  `categories_meta_keywords` varchar(255) NOT NULL,
  `categories_meta_description` varchar(255) NOT NULL,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_name` (`categories_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories_ratings`
--

CREATE TABLE `[[dbprefix]]categories_ratings` (
  `categories_id` int(11) NOT NULL,
  `ratings_id` int(11) NOT NULL,
  PRIMARY KEY (`categories_id`,`ratings_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]configuration`
--

CREATE TABLE `[[dbprefix]]configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(64) NOT NULL,
  `configuration_key` varchar(64) NOT NULL,
  `configuration_value` varchar(1024) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_group_id` int(11) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `use_function` varchar(255) DEFAULT NULL,
  `set_function` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`configuration_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=188 ;

--
-- Dumping data for table `[[dbprefix]]configuration`
--

INSERT INTO `[[dbprefix]]configuration` VALUES
(1, 'Store Name', 'STORE_NAME', '[[store_name]]', 'The name of my store', 1, 1, NULL, '[[regtime]]', NULL, NULL),
(2, 'Store Owner', 'STORE_OWNER', '[[store_owner]]', 'The name of my store owner', 1, 2, NULL, '[[regtime]]', NULL, NULL),
(3, 'E-Mail Address', 'STORE_OWNER_EMAIL_ADDRESS', '[[admin_email]]', 'The e-mail address of my store owner', 1, 3, NULL, '[[regtime]]', NULL, NULL),
(4, 'E-Mail From', 'EMAIL_FROM', '"[[store_owner]]" <[[admin_email]]>', 'The e-mail address used in (sent) e-mails', 1, 4, NULL, '[[regtime]]', NULL, NULL),
(5, 'Country', 'STORE_COUNTRY', '223', 'The country my store is located in <br><br><b>Note: Please remember to update the store zone.</b>', 1, 6, NULL, '[[regtime]]', 'osC_Address::getCountryName', 'osc_cfg_set_countries_pulldown_menu'),
(6, 'Zone', 'STORE_ZONE', '', 'The zone my store is located in', 1, 7, NULL, '[[regtime]]', 'osC_Address::getZoneName', 'osc_cfg_set_zones_pulldown_menu'),
(7, 'Timezone(Get it at www.php.net/manual/en/timezones.php)', 'STORE_TIME_ZONE', '', 'The timezone my store is located in', 1, 8, NULL, '[[regtime]]', NULL, NULL),
(8, 'Send Extra Order Emails To', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'Send extra order emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', 1, 11, NULL, '[[regtime]]', NULL, NULL),
(9, 'Allow Guest To Tell A Friend', 'ALLOW_GUEST_TO_TELL_A_FRIEND', '-1', 'Allow guests to tell a friend about a product', 1, 15, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(10, 'Store Address and Phone', 'STORE_NAME_ADDRESS', 'Store Name\nAddress\nCountry\nPhone', 'This is the Store Name, Address and Phone used on printable documents and displayed online', 1, 18, NULL, '[[regtime]]', NULL, 'osc_cfg_set_textarea_field'),
(11, 'Tax Decimal Places', 'TAX_DECIMAL_PLACES', '0', 'Pad the tax value this amount of decimal places', 1, 20, NULL, '[[regtime]]', NULL, NULL),
(12, 'Display Prices with Tax', 'DISPLAY_PRICE_WITH_TAX', '1', 'Display prices with tax included (true) or add the tax at the end (false)', 1, 21, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(13, 'Invoice Start Number', 'INVOICE_START_NUMBER', '10000', 'Invoices would be numbered according to the starting number + increment value per Step 1.', 1, 22, NULL, '[[regtime]]', NULL, NULL),
(14, 'Maintenance mode', 'MAINTENANCE_MODE', '-1', 'Maintenance Mode', 1, 23, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(15, 'Use TinyMCE Editor', 'USE_WYSIWYG_TINYMCE_EDITOR', '-1', 'Use TinyMCE Editor', 1, 24, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(16, 'Display Products in the subcatalogs recursively', 'DISPLAY_SUBCATALOGS_PRODUCTS', '1', 'Display the products in the subcatalogs recursively!', 1, 25, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(17, 'Synchronize cart with the database when customer logged in', 'SYNCHRONIZE_CART_WITH_DATABASE', '-1', 'Synchronize cart with the database when customer logged in!', 1, 26, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(18, 'Check stocks when synchronize cart with the database', 'CHECK_STOCKS_SYNCHRONIZE_CART_WITH_DATABASE', '1', 'Check stocks when synchronize cart with the database', 1, 27, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(19, 'Enable the confirmation dialog for add to cart action', 'ENABLE_CONFIRMATION_DIALOG', '1', 'Enable the confirmation dialog for add to cart action', 1, 28, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(20, 'Enable administrators log', 'ENABLE_ADMINISTRATORS_LOG', '1', 'Set to true if you want to see the logs in the administrators log module', 1, 29, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(21, 'Credit Card Owner Name', 'CC_OWNER_MIN_LENGTH', '3', 'Minimum length of credit card owner name', 2, 12, NULL, '[[regtime]]', NULL, NULL),
(22, 'Credit Card Number', 'CC_NUMBER_MIN_LENGTH', '10', 'Minimum length of credit card number', 2, 13, NULL, '[[regtime]]', NULL, NULL),
(23, 'Review Text', 'REVIEW_TEXT_MIN_LENGTH', '50', 'Minimum length of review text', 2, 14, NULL, '[[regtime]]', NULL, NULL),
(24, 'Address Book Entries', 'MAX_ADDRESS_BOOK_ENTRIES', '100', 'Maximum address book entries a customer is allowed to have', 3, 1, NULL, '[[regtime]]', NULL, NULL),
(25, 'Search Results', 'MAX_DISPLAY_SEARCH_RESULTS', '20', 'Amount of products to list', 3, 2, NULL, '[[regtime]]', NULL, NULL),
(26, 'Categories To List Per Row', 'MAX_DISPLAY_CATEGORIES_PER_ROW', '3', 'How many categories to list per row', 3, 13, NULL, '[[regtime]]', NULL, NULL),
(27, 'New Products Listing', 'MAX_DISPLAY_PRODUCTS_NEW', '10', 'Maximum number of new products to display in new products page', 3, 14, NULL, '[[regtime]]', NULL, NULL),
(28, 'Order History', 'MAX_DISPLAY_ORDER_HISTORY', '10', 'Maximum number of orders to display in the order history page', 3, 18, NULL, '[[regtime]]', NULL, NULL),
(29, 'Search Results In Auto Completer ', 'MAX_DISPLAY_AUTO_COMPLETER_RESULTS', '10', 'Maximum number of search results in auto completer', 3, 19, NULL, '[[regtime]]', NULL, NULL),
(30, 'Maximum Characters For Product Name in Auto Completer', 'MAX_CHARACTERS_AUTO_COMPLETER', '40', 'Maximum number of characters for product name in auto completer', 3, 20, NULL, '[[regtime]]', NULL, NULL),
(31, 'Width Of Auto Completer List', 'WIDTH_AUTO_COMPLETER', '400', 'Width of auto completer list', 3, 21, NULL, '[[regtime]]', NULL, NULL),
(32, 'Heading Image Width', 'HEADING_IMAGE_WIDTH', '57', 'The pixel width of heading images', 4, 3, NULL, '[[regtime]]', NULL, NULL),
(33, 'Heading Image Height', 'HEADING_IMAGE_HEIGHT', '40', 'The pixel height of heading images', 4, 4, NULL, '[[regtime]]', NULL, NULL),
(34, 'Image Required', 'IMAGE_REQUIRED', '1', 'Enable to display broken images. Good for development.', 4, 8, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(35, 'Image Group Of Auto Completer', 'IMAGE_GROUP_AUTO_COMPLETER', 'thumbnail', 'The image group of the auto completer search list', 4, 9, NULL, '[[regtime]]', NULL, NULL),
(36, 'Gender', 'ACCOUNT_GENDER', '1', 'Ask for or require the customers gender.', 5, 10, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, 0, -1))'),
(37, 'First Name', 'ACCOUNT_FIRST_NAME', '2', 'Minimum requirement for the customers first name.', 5, 11, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6'', ''7'', ''8'', ''9'', ''10''))'),
(38, 'Last Name', 'ACCOUNT_LAST_NAME', '2', 'Minimum requirement for the customers last name.', 5, 12, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6'', ''7'', ''8'', ''9'', ''10''))'),
(39, 'Date Of Birth', 'ACCOUNT_DATE_OF_BIRTH', '1', 'Ask for the customers date of birth.', 5, 13, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(40, 'E-Mail Address', 'ACCOUNT_EMAIL_ADDRESS', '6', 'Minimum requirement for the customers e-mail address.', 5, 14, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6'', ''7'', ''8'', ''9'', ''10''))'),
(41, 'Password', 'ACCOUNT_PASSWORD', '5', 'Minimum requirement for the customers password.', 5, 15, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6'', ''7'', ''8'', ''9'', ''10''))'),
(42, 'Newsletter', 'ACCOUNT_NEWSLETTER', '1', 'Ask for a newsletter subscription.', 5, 16, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(43, 'Company Name', 'ACCOUNT_COMPANY', '0', 'Ask for or require the customers company name.', 5, 17, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(''10'', ''9'', ''8'', ''7'', ''6'', ''5'', ''4'', ''3'', ''2'', ''1'', 0, -1))'),
(44, 'Street Address', 'ACCOUNT_STREET_ADDRESS', '5', 'Minimum requirement for the customers street address.', 5, 18, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6'', ''7'', ''8'', ''9'', ''10''))'),
(45, 'Suburb', 'ACCOUNT_SUBURB', '0', 'Ask for or require the customers suburb.', 5, 19, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(''10'', ''9'', ''8'', ''7'', ''6'', ''5'', ''4'', ''3'', ''2'', ''1'', 0, -1))'),
(46, 'Post Code', 'ACCOUNT_POST_CODE', '0', 'Minimum requirement for the customers post code.', 5, 20, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(-1, 0, ''1'', ''2'', ''3'', ''4'', ''5'', ''6'', ''7'', ''8'', ''9'', ''10''))'),
(47, 'City', 'ACCOUNT_CITY', '4', 'Minimum requirement for the customers city.', 5, 21, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6'', ''7'', ''8'', ''9'', ''10''))'),
(48, 'State', 'ACCOUNT_STATE', '2', 'Ask for or require the customers state.', 5, 22, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(''10'', ''9'', ''8'', ''7'', ''6'', ''5'', ''4'', ''3'', ''2'', ''1'', 0, -1))'),
(49, 'Country', 'ACCOUNT_COUNTRY', '1', 'Ask for the customers country.', 5, 23, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1))'),
(50, 'Telephone Number', 'ACCOUNT_TELEPHONE', '3', 'Ask for or require the customers telephone number.', 5, 24, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(''10'', ''9'', ''8'', ''7'', ''6'', ''5'', ''4'', ''3'', ''2'', ''1'', 0, -1))'),
(51, 'Fax Number', 'ACCOUNT_FAX', '0', 'Ask for or require the customers fax number.', 5, 25, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(''10'', ''9'', ''8'', ''7'', ''6'', ''5'', ''4'', ''3'', ''2'', ''1'', 0, -1))'),
(52, 'Default Currency', 'DEFAULT_CURRENCY', 'USD', 'Default Currency', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(53, 'Default Language', 'DEFAULT_LANGUAGE', 'en_US', 'Default Language', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(54, 'Default Order Status For New Orders', 'DEFAULT_ORDERS_STATUS_ID', '1', 'When a new order is created, this order status will be assigned to it.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(55, 'Default Image Group', 'DEFAULT_IMAGE_GROUP_ID', '2', 'Default image group.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(56, 'Default Template', 'DEFAULT_TEMPLATE', 'glass_gray', 'TomatoCart Glass Gray', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(57, 'Country of Origin', 'SHIPPING_ORIGIN_COUNTRY', '223', 'Select the country of origin to be used in shipping quotes.', 7, 1, NULL, '[[regtime]]', 'osC_Address::getCountryName', 'osc_cfg_set_countries_pulldown_menu'),
(58, 'Postal Code', 'SHIPPING_ORIGIN_ZIP', 'NONE', 'Enter the Postal Code (ZIP) of the Store to be used in shipping quotes.', 7, 2, NULL, '[[regtime]]', NULL, NULL),
(59, 'Enter the Maximum Package Weight you will ship', 'SHIPPING_MAX_WEIGHT', '50', 'Carriers have a max weight limit for a single package. This is a common one for all.', 7, 3, NULL, '[[regtime]]', NULL, NULL),
(60, 'Package Tare weight.', 'SHIPPING_BOX_WEIGHT', '3', 'What is the weight of typical packaging of small to medium packages?', 7, 4, NULL, '[[regtime]]', NULL, NULL),
(61, 'Larger packages - percentage increase.', 'SHIPPING_BOX_PADDING', '10', 'For 10% enter 10', 7, 5, NULL, '[[regtime]]', NULL, NULL),
(62, 'Default Shipping Unit', 'SHIPPING_WEIGHT_UNIT', '2', 'Select the unit of weight to be used for shipping.', 7, 6, NULL, '[[regtime]]', 'osC_Weight::getTitle', 'osc_cfg_set_weight_classes_pulldown_menu'),
(63, 'Default Unit Class', 'DEFAULT_UNIT_CLASSES', '1', 'Default Unit Class', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(64, 'Display Product Image', 'PRODUCT_LIST_IMAGE', '1', 'Do you want to display the Product Image?', 8, 1, NULL, '[[regtime]]', NULL, NULL),
(65, 'Display Product Manufaturer Name', 'PRODUCT_LIST_MANUFACTURER', '0', 'Do you want to display the Product Manufacturer Name?', 8, 2, NULL, '[[regtime]]', NULL, NULL),
(66, 'Display Product SKU', 'PRODUCT_LIST_SKU', '0', 'Do you want to display the Product SKU?', 8, 3, NULL, '[[regtime]]', NULL, NULL),
(67, 'Display Product Name', 'PRODUCT_LIST_NAME', '2', 'Do you want to display the Product Name?', 8, 4, NULL, '[[regtime]]', NULL, NULL),
(68, 'Display Product Price', 'PRODUCT_LIST_PRICE', '3', 'Do you want to display the Product Price', 8, 5, NULL, '[[regtime]]', NULL, NULL),
(69, 'Display Product Quantity', 'PRODUCT_LIST_QUANTITY', '0', 'Do you want to display the Product Quantity?', 8, 6, NULL, '[[regtime]]', NULL, NULL),
(70, 'Display Product Weight', 'PRODUCT_LIST_WEIGHT', '0', 'Do you want to display the Product Weight?', 8, 7, NULL, '[[regtime]]', NULL, NULL),
(71, 'Display Buy Now column', 'PRODUCT_LIST_BUY_NOW', '4', 'Do you want to display the Buy Now column?', 8, 8, NULL, '[[regtime]]', NULL, NULL),
(72, 'Display Category/Manufacturer Filter', 'PRODUCT_LIST_FILTER', '1', 'Do you want to display the Category/Manufacturer Filter?', 8, 9, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(73, 'Display Product Attributes Filter', 'PRODUCT_ATTRIBUTES_FILTER', '1', 'Do you want to display the Product Attributes Filter?', 8, 10, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(74, 'Link the Product Attributes and Category/Manufacturer Filter', 'PRODUCT_LINK_FILTER', '1', 'Do you want to filter the products with the Product Attributes Filter and Category/Manufacturer Filter at the same time?', 8, 11, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(75, 'Location of Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)', 'PREV_NEXT_BAR_LOCATION', '2', 'Sets the location of the Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)', 8, 12, NULL, '[[regtime]]', NULL, NULL),
(76, 'Display Varains Options', 'PRODUCT_LIST_VARIANTS_OPTIONS', '1', 'Do you want to display the variants options in the product listing?', 8, 13, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(77, 'Display Quantity Input Field', 'PRODUCT_LIST_QUANTITY_INPUT', '1', 'Do you want to display quantity input field in the product listing?', 8, 14, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(78, 'Check stock level', 'STOCK_CHECK', '1', 'Check to see if sufficent stock is available', 9, 1, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(79, 'Subtract stock', 'STOCK_LIMITED', '1', 'Subtract product in stock by product orders', 9, 2, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(80, 'Allow Checkout', 'STOCK_ALLOW_CHECKOUT', '1', 'Allow customer to checkout even if there is insufficient stock', 9, 3, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(81, 'Mark product out of stock', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***', 'Display something on screen so customer can see which product has insufficient stock', 9, 4, NULL, '[[regtime]]', NULL, NULL),
(82, 'Stock Re-order level', 'STOCK_REORDER_LEVEL', '5', 'Define when stock needs to be re-ordered', 9, 5, NULL, '[[regtime]]', NULL, NULL),
(83, 'Out of stock email alerts', 'STOCK_EMAIL_ALERT', '1', 'Define send a email to administrator  if out of stock', 9, 6, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(84, 'Display Product Quantity', 'PRODUCT_INFO_QUANTITY', '1', 'Do you want to display the Product Quantity?', 10, 1, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(85, 'Display Product Minimum Order Quantity', 'PRODUCT_INFO_MOQ', '-1', 'Do you want to display the Product Minimum Order Quantity?', 10, 2, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(86, 'Display Product Order Increment', 'PRODUCT_INFO_ORDER_INCREMENT', '-1', 'Do you want to display the Order Increment?', 10, 3, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(87, 'Allow gift certificate return', 'ALLOW_GIFT_CERTIFICATE_RETURN', '-1', 'Do you want to allow customer return gift certificates?', 11, 3, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(88, 'Allow downloadable return', 'ALLOW_DOWNLOADABLE_RETURN', '-1', 'Do you want to allow customer return downloadable products?', 11, 4, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(89, 'Allow return request', 'ALLOW_RETURN_REQUEST', '1', 'Do you want to allow customer return product?', 11, 5, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(90, 'Download by redirect', 'DOWNLOAD_BY_REDIRECT', '-1', 'Use browser redirection for download. Disable on non-Unix systems.', 11, 1, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(91, 'Display the telephone number', 'DISPLAY_TELEPHONE_NUMBER', '1', 'Set true to make the telephone number display in the order details.', 11, 6, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(92, 'E-Mail Transport Method', 'EMAIL_TRANSPORT', 'sendmail', 'Defines if this server uses a local connection to sendmail or uses an SMTP connection via TCP/IP. Servers running on Windows and MacOS should change this setting to SMTP.', 12, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''sendmail'', ''smtp''))'),
(93, 'E-Mail Linefeeds', 'EMAIL_LINEFEED', 'LF', 'Defines the character sequence used to separate mail headers.', 12, 2, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''LF'', ''CRLF''))'),
(94, 'SMTP Server', 'SMTP_HOST', '', 'The SMTP E-Mail Server', 12, 3, NULL, '[[regtime]]', NULL, NULL),
(95, 'SMTP Server Port', 'SMTP_PORT', '25', 'The SMTP E-Mail Server', 12, 4, NULL, '[[regtime]]', NULL, NULL),
(96, 'SMTP Username', 'SMTP_USERNAME', '', 'SMTP Username', 12, 5, NULL, '[[regtime]]', NULL, NULL),
(97, 'SMTP Password', 'SMTP_PASSWORD', '', 'SMTP Password', 12, 6, NULL, '[[regtime]]', 'osc_cfg_use_get_encrypted_password', 'osc_cfg_set_password_field'),
(98, 'Enable SSL Connection', 'EMAIL_SSL', '1', 'Connect the smtp server with ssl connection', 12, 7, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(99, 'Use MIME HTML When Sending Emails', 'EMAIL_USE_HTML', '-1', 'Send e-mails in HTML format', 12, 8, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(100, 'Verify E-Mail Addresses Through DNS', 'ENTRY_EMAIL_ADDRESS_CHECK', '-1', 'Verify e-mail address through a DNS server', 12, 9, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(101, 'Send E-Mails', 'SEND_EMAILS', '1', 'Send out e-mails', 12, 10, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(102, 'Confirm Terms and Conditions During Checkout Procedure', 'DISPLAY_CONDITIONS_ON_CHECKOUT', '-1', 'Show the Terms and Conditions during the checkout procedure which the customer must agree to.', 16, 1, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(103, 'Confirm Privacy Notice During Account Creation Procedure', 'DISPLAY_PRIVACY_CONDITIONS', '-1', 'Show the Privacy Notice during the account creation procedure which the customer must agree to.', 16, 2, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(104, 'Verify With Regular Expressions', 'CFG_CREDIT_CARDS_VERIFY_WITH_REGEXP', '1', 'Verify credit card numbers with server-side regular expression patterns.', 17, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(105, 'Verify With Javascript', 'CFG_CREDIT_CARDS_VERIFY_WITH_JS', '1', 'Verify credit card numbers with javascript based regular expression patterns.', 17, 1, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(106, 'GZIP', 'CFG_APP_GZIP', '', 'The program location to gzip.', 18, 1, NULL, '[[regtime]]', NULL, NULL),
(107, 'GUNZIP', 'CFG_APP_GUNZIP', '', 'The program location to gunzip.', 18, 2, NULL, '[[regtime]]', NULL, NULL),
(108, 'ZIP', 'CFG_APP_ZIP', '', 'The program location to zip.', 18, 3, NULL, '[[regtime]]', NULL, NULL),
(109, 'UNZIP', 'CFG_APP_UNZIP', '', 'The program location to unzip.', 18, 4, NULL, '[[regtime]]', NULL, NULL),
(110, 'cURL', 'CFG_APP_CURL', '', 'The program location to cURL.', 18, 5, NULL, '[[regtime]]', NULL, NULL),
(111, 'Activate Captcha', 'ACTIVATE_CAPTCHA', '1', 'active captcha for contact us page and guest book', 19, 1, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(112, 'Disallow more than one vote from the same IP address', 'DISALLOW_MORE_THAN_ONE_VOTE', '1', 'Disallow more than one vote from the same IP address', 19, 2, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(113, 'Minimum List Size', 'BOX_BEST_SELLERS_MIN_LIST', '3', 'Minimum amount of products that must be shown in the listing', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(114, 'Maximum List Size', 'BOX_BEST_SELLERS_MAX_LIST', '10', 'Maximum amount of products to show in the listing', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(115, 'Cache Contents', 'BOX_BEST_SELLERS_CACHE', '60', 'Number of minutes to keep the contents cached (0 = no cache)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(116, 'Show Product Count', 'BOX_CATEGORIES_SHOW_PRODUCT_COUNT', '1', 'Show the amount of products each category has', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(117, 'Display Drop Down Menu', 'BOX_CATEGORIES_DISPLAY_DROP_DOWN_MENU', '1', 'Use MenuMatic to display drop down menu', 6, 1, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(118, 'Drop Down Menu Effect', 'BOX_CATEGORIES_DROP_DOWN_MENU_EFFECT', 'slide & fade', 'Drop Down Menu Effect', 6, 2, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(''fade'', ''slide'', ''slide & fade''))'),
(119, 'Drop Down Menu Duration', 'BOX_CATEGORIES_DROP_DOWN_MENU_DURATION', '600', 'Drop Down Menu Duration', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(120, 'Manufacturers List Type', 'BOX_MANUFACTURERS_LIST_TYPE', 'Image List', 'The type of the manufacturers list(ComboBox, Image List).', 6, 0, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''ComboBox'', ''Image List''))'),
(121, 'Manufacturers List Size', 'BOX_MANUFACTURERS_LIST_SIZE', '1', 'The size of the manufacturers pull down menu listing.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(122, 'Maximum List Size', 'BOX_ORDER_HISTORY_MAX_LIST', '5', 'Maximum amount of products to show in the listing', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(123, 'Random Review Selection', 'BOX_REVIEWS_RANDOM_SELECT', '10', 'Select a random review from this amount of the newest reviews available', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(124, 'Cache Contents', 'BOX_REVIEWS_CACHE', '1', 'Number of minutes to keep the contents cached (0 = no cache)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(125, 'Random Product Specials Selection', 'BOX_SPECIALS_RANDOM_SELECT', '10', 'Select a random product on special from this amount of the newest products on specials available', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(126, 'Cache Contents', 'BOX_SPECIALS_CACHE', '1', 'Number of minutes to keep the contents cached (0 = no cache)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(127, 'Random New Product Selection', 'BOX_WHATS_NEW_RANDOM_SELECT', '10', 'Select a random new product from this amount of the newest products available', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(128, 'Cache Contents', 'BOX_WHATS_NEW_CACHE', '1', 'Number of minutes to keep the contents cached (0 = no cache)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(129, 'Maximum Entries To Display', 'MODULE_CONTENT_NEW_PRODUCTS_MAX_DISPLAY', '9', 'Maximum number of new products to display', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(130, 'Cache Contents', 'MODULE_CONTENT_NEW_PRODUCTS_CACHE', '60', 'Number of minutes to keep the contents cached (0 = no cache)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(131, 'Minimum Entries To Display', 'MODULE_CONTENT_ALSO_PURCHASED_MIN_DISPLAY', '1', 'Minimum number of also purchased products to display', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(132, 'Maximum Entries To Display', 'MODULE_CONTENT_ALSO_PURCHASED_MAX_DISPLAY', '6', 'Maximum number of also purchased products to display', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(133, 'Cache Contents', 'MODULE_CONTENT_ALSO_PURCHASED_PRODUCTS_CACHE', '60', 'Number of minutes to keep the contents cached (0 = no cache)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(134, 'Maximum Entries To Display', 'MODULE_CONTENT_UPCOMING_PRODUCTS_MAX_DISPLAY', '10', 'Maximum number of upcoming products to display', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(135, 'Cache Contents', 'MODULE_CONTENT_UPCOMING_PRODUCTS_CACHE', '1440', 'Number of minutes to keep the contents cached (0 = no cache)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(136, 'Maximum Entries To Display', 'MODULE_CONTENT_FEATURE_PRODUCTS_MAX_DISPLAY', '9', 'Maximum number of new products to display', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(137, 'GZIP Compression Level', 'SERVICE_OUTPUT_COMPRESSION_GZIP_LEVEL', '5', 'Set the GZIP compression level to this value (0=min, 9=max).', 6, 0, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''0'', ''1'', ''2'', ''3'', ''4'', ''5'', ''6'', ''7'', ''8'', ''9''))'),
(138, 'Force Cookie Usage', 'SERVICE_SESSION_FORCE_COOKIE_USAGE', '-1', 'Only start a session when cookies are enabled.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(139, 'Block Search Engine Spiders', 'SERVICE_SESSION_BLOCK_SPIDERS', '-1', 'Block search engine spider robots from starting a session.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(140, 'Check SSL Session ID', 'SERVICE_SESSION_CHECK_SSL_SESSION_ID', '-1', 'Check the SSL_SESSION_ID on every secure HTTPS page request.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(141, 'Check User Agent', 'SERVICE_SESSION_CHECK_USER_AGENT', '-1', 'Check the browser user agent on every page request.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(142, 'Check IP Address', 'SERVICE_SESSION_CHECK_IP_ADDRESS', '-1', 'Check the IP address on every page request.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(143, 'Regenerate Session ID', 'SERVICE_SESSION_REGENERATE_ID', '-1', 'Regenerate the session ID when a customer logs on or creates an account (requires PHP >= 4.1).', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(144, 'Max Life Time', 'SERVICE_SESSION_MAX_LIFETIME', '15', 'The session will be expired after the number of minutes', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(145, 'Use Default Language Currency', 'USE_DEFAULT_LANGUAGE_CURRENCY', '-1', 'The default currency could be set under Definitions > Currencies or Definitions > Languages module. Set this configuration to True to use the default currency for each language ', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(146, 'Calculate Number Of Products In Each Category', 'SERVICES_CATEGORY_PATH_CALCULATE_PRODUCT_COUNT', '1', 'Recursively calculate how many products are in each category.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(147, 'Detect Search Engine Spider Robots', 'SERVICE_WHOS_ONLINE_SPIDER_DETECTION', '1', 'Detect search engine spider robots (GoogleBot, Yahoo, etc).', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(148, 'Special Products', 'MAX_DISPLAY_SPECIAL_PRODUCTS', '9', 'Maximum number of products on special to display', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(149, 'New Reviews', 'MAX_DISPLAY_NEW_REVIEWS', '6', 'Maximum number of new reviews to display', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(150, 'Review Level', 'SERVICE_REVIEW_ENABLE_REVIEWS', '1', 'Customer level required to write a review.', 6, 0, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(1, -1))'),
(151, 'Moderate Reviews', 'SERVICE_REVIEW_ENABLE_MODERATION', '-1', 'Should reviews be approved by store admin.', 6, 0, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(1, -1))'),
(152, 'Display latest products', 'SERVICE_RECENTLY_VISITED_SHOW_PRODUCTS', '1', 'Display recently visited products.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(153, 'Display product images', 'SERVICE_RECENTLY_VISITED_SHOW_PRODUCT_IMAGES', '1', 'Display the product image.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(154, 'Display product prices', 'SERVICE_RECENTLY_VISITED_SHOW_PRODUCT_PRICES', '1', 'Display the products price.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(155, 'Maximum products to show', 'SERVICE_RECENTLY_VISITED_MAX_PRODUCTS', '5', 'Maximum number of recently visited products to show', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(156, 'Display latest categories', 'SERVICE_RECENTLY_VISITED_SHOW_CATEGORIES', '1', 'Display recently visited categories.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(157, 'Maximum categories to show', 'SERVICE_RECENTLY_VISITED_MAX_CATEGORIES', '3', 'Mazimum number of recently visited categories to show', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(158, 'Display latest searches', 'SERVICE_RECENTLY_VISITED_SHOW_SEARCHES', '1', 'Show recent searches.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(159, 'Maximum searches to show', 'SERVICE_RECENTLY_VISITED_MAX_SEARCHES', '3', 'Mazimum number of recent searches to display', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(160, 'Service Modules', 'MODULE_SERVICES_INSTALLED', 'output_compression;session;language;currencies;core;whos_online;simple_counter;category_path;recently_visited;breadcrumb;specials;reviews', 'Installed services modules', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(161, 'Enable Cash On Delivery Module', 'MODULE_PAYMENT_COD_STATUS', '1', 'Do you want to accept Cash On Delivery payments?', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))'),
(162, 'Payment Zone', 'MODULE_PAYMENT_COD_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_zone_class_title', 'osc_cfg_set_zone_classes_pull_down_menu'),
(163, 'Sort order of display.', 'MODULE_PAYMENT_COD_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(164, 'Set Order Status', 'MODULE_PAYMENT_COD_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_order_status_title', 'osc_cfg_set_order_statuses_pull_down_menu'),
(165, 'Enable Flat Shipping', 'MODULE_SHIPPING_FLAT_STATUS', 'True', 'Do you want to offer flat rate shipping?', 6, 0, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''True'', ''False''))'),
(166, 'Shipping Cost', 'MODULE_SHIPPING_FLAT_COST', '5.00', 'The shipping cost for all orders using this shipping method.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(167, 'Tax Class', 'MODULE_SHIPPING_FLAT_TAX_CLASS', '0', 'Use the following tax class on the shipping fee.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_tax_class_title', 'osc_cfg_set_tax_classes_pull_down_menu'),
(168, 'Shipping Zone', 'MODULE_SHIPPING_FLAT_ZONE', '0', 'If a zone is selected, only enable this shipping method for that zone.', 6, 0, NULL, '[[regtime]]', 'osc_cfg_use_get_zone_class_title', 'osc_cfg_set_zone_classes_pull_down_menu'),
(169, 'Sort Order', 'MODULE_SHIPPING_FLAT_SORT_ORDER', '0', 'Sort order of display.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(170, 'Display Sub-Total', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'Do you want to display the order sub-total cost?', 6, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''true'', ''false''))'),
(171, 'Sort Order', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '10', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(172, 'Display Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'Do you want to display the order shipping cost?', 6, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''true'', ''false''))'),
(173, 'Sort Order', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '20', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(174, 'Display Tax', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'true', 'Do you want to display the order tax value?', 6, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''true'', ''false''))'),
(175, 'Sort Order', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '50', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(176, 'Display Total', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', 'Do you want to display the total order value?', 6, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''true'', ''false''))'),
(177, 'Sort Order', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '80', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(178, 'Display Coupon', 'MODULE_ORDER_TOTAL_COUPON_STATUS', 'true', 'Do you want to enable coupon?', 6, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''true'', ''false''))'),
(179, 'Sort Order', 'MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', '40', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(180, 'Enable Gift Certificate', 'MODULE_ORDER_TOTAL_GIFT_CERTIFICATE_STATUS', 'true', 'Do you want to enable gift certificate?', 6, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''true'', ''false''))'),
(181, 'Sort Order', 'MODULE_ORDER_TOTAL_GIFT_CERTIFICATE_SORT_ORDER', '70', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(182, 'Enable Store Credit', 'MODULE_ORDER_TOTAL_STORE_CREDIT_STATUS', 'true', 'Do you want to enable store credit?', 6, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''true'', ''false''))'),
(183, 'Sort Order', 'MODULE_ORDER_TOTAL_STORE_CREDIT_SORT_ORDER', '65', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(184, 'Display Wrapping', 'MODULE_ORDER_TOTAL_GIFT_WRAPPING_STATUS', 'true', 'Do you want to enable gift wrapping?', 6, 1, NULL, '[[regtime]]', NULL, 'osc_cfg_set_boolean_value(array(''true'', ''false''))'),
(185, 'Sort Order', 'MODULE_ORDER_TOTAL_GIFT_WRAPPING_SORT_ORDER', '25', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(186, 'Gift Wrapping Price', 'MODULE_ORDER_TOTAL_GIFT_WRAPPING_PRICE', '10', 'The price for the gift wrapping.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(187, 'Gift Wrapping Tax', 'MODULE_ORDER_TOTAL_GIFT_WRAPPING_TAX', '0', 'Use the following tax class on the gift wrapping.', 6, 7, NULL, '[[regtime]]', 'osc_cfg_use_get_tax_class_title', 'osc_cfg_set_tax_classes_pull_down_menu');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]configuration_group`
--

CREATE TABLE `[[dbprefix]]configuration_group` (
  `configuration_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_group_title` varchar(64) NOT NULL,
  `configuration_group_description` varchar(255) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]configuration_group`
--

INSERT INTO `[[dbprefix]]configuration_group` VALUES
(1, 'My Store', 'General information about my store', 1, 1),
(2, 'Minimum Values', 'The minimum values for functions / data', 2, 1),
(3, 'Maximum Values', 'The maximum values for functions / data', 3, 1),
(4, 'Images', 'Image parameters', 4, 1),
(5, 'Customer Details', 'Customer account configuration', 5, 1),
(6, 'Module Options', 'Hidden from configuration', 6, 0),
(7, 'Shipping/Packaging', 'Shipping options available at my store', 7, 1),
(8, 'Product Listing', 'Product Listing    configuration options', 8, 1),
(9, 'Stock', 'Stock configuration options', 9, 1),
(10, 'Product Details', 'Product info page configuration', 10, 1),
(11, 'Order Settings', 'Order Settings', 11, 1),
(12, 'E-Mail Options', 'General setting for E-Mail transport and HTML E-Mails', 12, 1),
(16, 'Regulations', 'Regulation options', 16, 1),
(17, 'Credit Cards', 'Credit card options', 17, 1),
(18, 'Program Locations', 'Locations to certain programs on the server.', 18, 1),
(19, 'Content Management System', 'Content Management System Configuration', 19, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]counter`
--

CREATE TABLE `[[dbprefix]]counter` (
  `startdate` datetime DEFAULT NULL,
  `counter` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]countries`
--

CREATE TABLE `[[dbprefix]]countries` (
  `countries_id` int(11) NOT NULL AUTO_INCREMENT,
  `countries_name` varchar(64) NOT NULL,
  `countries_iso_code_2` char(2) NOT NULL,
  `countries_iso_code_3` char(3) NOT NULL,
  `address_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`countries_id`),
  KEY `IDX_COUNTRIES_NAME` (`countries_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=240 ;

--
-- Dumping data for table `[[dbprefix]]countries`
--

INSERT INTO `[[dbprefix]]countries` VALUES
(1, 'Afghanistan', 'AF', 'AFG', ''),
(2, 'Albania', 'AL', 'ALB', ''),
(3, 'Algeria', 'DZ', 'DZA', ''),
(4, 'American Samoa', 'AS', 'ASM', ''),
(5, 'Andorra', 'AD', 'AND', ''),
(6, 'Angola', 'AO', 'AGO', ''),
(7, 'Anguilla', 'AI', 'AIA', ''),
(8, 'Antarctica', 'AQ', 'ATA', ''),
(9, 'Antigua and Barbuda', 'AG', 'ATG', ''),
(10, 'Argentina', 'AR', 'ARG', ':name\n:street_address\n:postcode :city\n:country'),
(11, 'Armenia', 'AM', 'ARM', ''),
(12, 'Aruba', 'AW', 'ABW', ''),
(13, 'Australia', 'AU', 'AUS', ':name\n:street_address\n:suburb :state_code :postcode\n:country'),
(14, 'Austria', 'AT', 'AUT', ':name\n:street_address\nA-:postcode :city\n:country'),
(15, 'Azerbaijan', 'AZ', 'AZE', ''),
(16, 'Bahamas', 'BS', 'BHS', ''),
(17, 'Bahrain', 'BH', 'BHR', ''),
(18, 'Bangladesh', 'BD', 'BGD', ''),
(19, 'Barbados', 'BB', 'BRB', ''),
(20, 'Belarus', 'BY', 'BLR', ''),
(21, 'Belgium', 'BE', 'BEL', ':name\n:street_address\nB-:postcode :city\n:country'),
(22, 'Belize', 'BZ', 'BLZ', ''),
(23, 'Benin', 'BJ', 'BEN', ''),
(24, 'Bermuda', 'BM', 'BMU', ''),
(25, 'Bhutan', 'BT', 'BTN', ''),
(26, 'Bolivia', 'BO', 'BOL', ''),
(27, 'Bosnia and Herzegowina', 'BA', 'BIH', ''),
(28, 'Botswana', 'BW', 'BWA', ''),
(29, 'Bouvet Island', 'BV', 'BVT', ''),
(30, 'Brazil', 'BR', 'BRA', ':name\n:street_address\n:state\n:postcode\n:country'),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', ''),
(32, 'Brunei Darussalam', 'BN', 'BRN', ''),
(33, 'Bulgaria', 'BG', 'BGR', ''),
(34, 'Burkina Faso', 'BF', 'BFA', ''),
(35, 'Burundi', 'BI', 'BDI', ''),
(36, 'Cambodia', 'KH', 'KHM', ''),
(37, 'Cameroon', 'CM', 'CMR', ''),
(38, 'Canada', 'CA', 'CAN', ':name\n:street_address\n:city :state_code :postcode\n:country'),
(39, 'Cape Verde', 'CV', 'CPV', ''),
(40, 'Cayman Islands', 'KY', 'CYM', ''),
(41, 'Central African Republic', 'CF', 'CAF', ''),
(42, 'Chad', 'TD', 'TCD', ''),
(43, 'Chile', 'CL', 'CHL', ':name\n:street_address\n:city\n:country'),
(44, 'China', 'CN', 'CHN', ':name\n:street_address\n:postcode :city\n:country'),
(45, 'Christmas Island', 'CX', 'CXR', ''),
(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', ''),
(47, 'Colombia', 'CO', 'COL', ''),
(48, 'Comoros', 'KM', 'COM', ''),
(49, 'Congo', 'CG', 'COG', ''),
(50, 'Cook Islands', 'CK', 'COK', ''),
(51, 'Costa Rica', 'CR', 'CRI', ''),
(52, 'Cote D''Ivoire', 'CI', 'CIV', ''),
(53, 'Croatia', 'HR', 'HRV', ''),
(54, 'Cuba', 'CU', 'CUB', ''),
(55, 'Cyprus', 'CY', 'CYP', ''),
(56, 'Czech Republic', 'CZ', 'CZE', ''),
(57, 'Denmark', 'DK', 'DNK', ':name\n:street_address\nDK-:postcode :city\n:country'),
(58, 'Djibouti', 'DJ', 'DJI', ''),
(59, 'Dominica', 'DM', 'DMA', ''),
(60, 'Dominican Republic', 'DO', 'DOM', ''),
(61, 'East Timor', 'TP', 'TMP', ''),
(62, 'Ecuador', 'EC', 'ECU', ''),
(63, 'Egypt', 'EG', 'EGY', ''),
(64, 'El Salvador', 'SV', 'SLV', ''),
(65, 'Equatorial Guinea', 'GQ', 'GNQ', ''),
(66, 'Eritrea', 'ER', 'ERI', ''),
(67, 'Estonia', 'EE', 'EST', ''),
(68, 'Ethiopia', 'ET', 'ETH', ''),
(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', ''),
(70, 'Faroe Islands', 'FO', 'FRO', ''),
(71, 'Fiji', 'FJ', 'FJI', ''),
(72, 'Finland', 'FI', 'FIN', ':name\n:street_address\nFIN-:postcode :city\n:country'),
(73, 'France', 'FR', 'FRA', ':name\n:street_address\n:postcode :city\n:country'),
(74, 'France, Metropolitan', 'FX', 'FXX', ':name\n:street_address\n:postcode :city\n:country'),
(75, 'French Guiana', 'GF', 'GUF', ':name\n:street_address\n:postcode :city\n:country'),
(76, 'French Polynesia', 'PF', 'PYF', ':name\n:street_address\n:postcode :city\n:country'),
(77, 'French Southern Territories', 'TF', 'ATF', ':name\n:street_address\n:postcode :city\n:country'),
(78, 'Gabon', 'GA', 'GAB', ''),
(79, 'Gambia', 'GM', 'GMB', ''),
(80, 'Georgia', 'GE', 'GEO', ''),
(81, 'Germany', 'DE', 'DEU', ':name\n:street_address\nD-:postcode :city\n:country'),
(82, 'Ghana', 'GH', 'GHA', ''),
(83, 'Gibraltar', 'GI', 'GIB', ''),
(84, 'Greece', 'GR', 'GRC', ''),
(85, 'Greenland', 'GL', 'GRL', ':name\n:street_address\nDK-:postcode :city\n:country'),
(86, 'Grenada', 'GD', 'GRD', ''),
(87, 'Guadeloupe', 'GP', 'GLP', ''),
(88, 'Guam', 'GU', 'GUM', ''),
(89, 'Guatemala', 'GT', 'GTM', ''),
(90, 'Guinea', 'GN', 'GIN', ''),
(91, 'Guinea-Bissau', 'GW', 'GNB', ''),
(92, 'Guyana', 'GY', 'GUY', ''),
(93, 'Haiti', 'HT', 'HTI', ''),
(94, 'Heard and McDonald Islands', 'HM', 'HMD', ''),
(95, 'Honduras', 'HN', 'HND', ''),
(96, 'Hong Kong', 'HK', 'HKG', ':name\n:street_address\n:city\n:country'),
(97, 'Hungary', 'HU', 'HUN', ''),
(98, 'Iceland', 'IS', 'ISL', ':name\n:street_address\nIS:postcode :city\n:country'),
(99, 'India', 'IN', 'IND', ':name\n:street_address\n:city-:postcode\n:country'),
(100, 'Indonesia', 'ID', 'IDN', ':name\n:street_address\n:city :postcode\n:country'),
(101, 'Iran', 'IR', 'IRN', ''),
(102, 'Iraq', 'IQ', 'IRQ', ''),
(103, 'Ireland', 'IE', 'IRL', ':name\n:street_address\nIE-:city\n:country'),
(104, 'Israel', 'IL', 'ISR', ':name\n:street_address\n:postcode :city\n:country'),
(105, 'Italy', 'IT', 'ITA', ':name\n:street_address\n:postcode-:city :state_code\n:country'),
(106, 'Jamaica', 'JM', 'JAM', ''),
(107, 'Japan', 'JP', 'JPN', ':name\n:street_address, :suburb\n:city :postcode\n:country'),
(108, 'Jordan', 'JO', 'JOR', ''),
(109, 'Kazakhstan', 'KZ', 'KAZ', ''),
(110, 'Kenya', 'KE', 'KEN', ''),
(111, 'Kiribati', 'KI', 'KIR', ''),
(112, 'Korea, North', 'KP', 'PRK', ''),
(113, 'Korea, South', 'KR', 'KOR', ''),
(114, 'Kuwait', 'KW', 'KWT', ''),
(115, 'Kyrgyzstan', 'KG', 'KGZ', ''),
(116, 'Laos', 'LA', 'LAO', ''),
(117, 'Latvia', 'LV', 'LVA', ''),
(118, 'Lebanon', 'LB', 'LBN', ''),
(119, 'Lesotho', 'LS', 'LSO', ''),
(120, 'Liberia', 'LR', 'LBR', ''),
(121, 'Libyan Arab Jamahiriya', 'LY', 'LBY', ''),
(122, 'Liechtenstein', 'LI', 'LIE', ''),
(123, 'Lithuania', 'LT', 'LTU', ''),
(124, 'Luxembourg', 'LU', 'LUX', ':name\n:street_address\nL-:postcode :city\n:country'),
(125, 'Macau', 'MO', 'MAC', ''),
(126, 'Macedonia', 'MK', 'MKD', ''),
(127, 'Madagascar', 'MG', 'MDG', ''),
(128, 'Malawi', 'MW', 'MWI', ''),
(129, 'Malaysia', 'MY', 'MYS', ''),
(130, 'Maldives', 'MV', 'MDV', ''),
(131, 'Mali', 'ML', 'MLI', ''),
(132, 'Malta', 'MT', 'MLT', ''),
(133, 'Marshall Islands', 'MH', 'MHL', ''),
(134, 'Martinique', 'MQ', 'MTQ', ''),
(135, 'Mauritania', 'MR', 'MRT', ''),
(136, 'Mauritius', 'MU', 'MUS', ''),
(137, 'Mayotte', 'YT', 'MYT', ''),
(138, 'Mexico', 'MX', 'MEX', ':name\n:street_address\n:postcode :city, :state_code\n:country'),
(139, 'Micronesia', 'FM', 'FSM', ''),
(140, 'Moldova', 'MD', 'MDA', ''),
(141, 'Monaco', 'MC', 'MCO', ''),
(142, 'Mongolia', 'MN', 'MNG', ''),
(143, 'Montserrat', 'MS', 'MSR', ''),
(144, 'Morocco', 'MA', 'MAR', ''),
(145, 'Mozambique', 'MZ', 'MOZ', ''),
(146, 'Myanmar', 'MM', 'MMR', ''),
(147, 'Namibia', 'NA', 'NAM', ''),
(148, 'Nauru', 'NR', 'NRU', ''),
(149, 'Nepal', 'NP', 'NPL', ''),
(150, 'Netherlands', 'NL', 'NLD', ':name\n:street_address\n:postcode :city\n:country'),
(151, 'Netherlands Antilles', 'AN', 'ANT', ':name\n:street_address\n:postcode :city\n:country'),
(152, 'New Caledonia', 'NC', 'NCL', ''),
(153, 'New Zealand', 'NZ', 'NZL', ':name\n:street_address\n:suburb\n:city :postcode\n:country'),
(154, 'Nicaragua', 'NI', 'NIC', ''),
(155, 'Niger', 'NE', 'NER', ''),
(156, 'Nigeria', 'NG', 'NGA', ''),
(157, 'Niue', 'NU', 'NIU', ''),
(158, 'Norfolk Island', 'NF', 'NFK', ''),
(159, 'Northern Mariana Islands', 'MP', 'MNP', ''),
(160, 'Norway', 'NO', 'NOR', ':name\n:street_address\nNO-:postcode :city\n:country'),
(161, 'Oman', 'OM', 'OMN', ''),
(162, 'Pakistan', 'PK', 'PAK', ''),
(163, 'Palau', 'PW', 'PLW', ''),
(164, 'Panama', 'PA', 'PAN', ''),
(165, 'Papua New Guinea', 'PG', 'PNG', ''),
(166, 'Paraguay', 'PY', 'PRY', ''),
(167, 'Peru', 'PE', 'PER', ''),
(168, 'Philippines', 'PH', 'PHL', ''),
(169, 'Pitcairn', 'PN', 'PCN', ''),
(170, 'Poland', 'PL', 'POL', ':name\n:street_address\n:postcode :city\n:country'),
(171, 'Portugal', 'PT', 'PRT', ':name\n:street_address\n:postcode :city\n:country'),
(172, 'Puerto Rico', 'PR', 'PRI', ''),
(173, 'Qatar', 'QA', 'QAT', ''),
(174, 'Reunion', 'RE', 'REU', ''),
(175, 'Romania', 'RO', 'ROM', ''),
(176, 'Russia', 'RU', 'RUS', ':name\n:street_address\n:postcode :city\n:country'),
(177, 'Rwanda', 'RW', 'RWA', ''),
(178, 'Saint Kitts and Nevis', 'KN', 'KNA', ''),
(179, 'Saint Lucia', 'LC', 'LCA', ''),
(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', ''),
(181, 'Samoa', 'WS', 'WSM', ''),
(182, 'San Marino', 'SM', 'SMR', ''),
(183, 'Sao Tome and Principe', 'ST', 'STP', ''),
(184, 'Saudi Arabia', 'SA', 'SAU', ''),
(185, 'Senegal', 'SN', 'SEN', ''),
(186, 'Seychelles', 'SC', 'SYC', ''),
(187, 'Sierra Leone', 'SL', 'SLE', ''),
(188, 'Singapore', 'SG', 'SGP', ':name\n:street_address\n:city :postcode\n:country'),
(189, 'Slovakia', 'SK', 'SVK', ''),
(190, 'Slovenia', 'SI', 'SVN', ''),
(191, 'Solomon Islands', 'SB', 'SLB', ''),
(192, 'Somalia', 'SO', 'SOM', ''),
(193, 'South Africa', 'ZA', 'ZAF', ':name\n:street_address\n:suburb\n:city\n:postcode :country'),
(194, 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', ''),
(195, 'Spain', 'ES', 'ESP', ':name\n:street_address\n:postcode :city\n:country'),
(196, 'Sri Lanka', 'LK', 'LKA', ''),
(197, 'St. Helena', 'SH', 'SHN', ''),
(198, 'St. Pierre and Miquelon', 'PM', 'SPM', ''),
(199, 'Sudan', 'SD', 'SDN', ''),
(200, 'Suriname', 'SR', 'SUR', ''),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', ''),
(202, 'Swaziland', 'SZ', 'SWZ', ''),
(203, 'Sweden', 'SE', 'SWE', ':name\n:street_address\n:postcode :city\n:country'),
(204, 'Switzerland', 'CH', 'CHE', ':name\n:street_address\n:postcode :city\n:country'),
(205, 'Syrian Arab Republic', 'SY', 'SYR', ''),
(206, 'Taiwan', 'TW', 'TWN', ':name\n:street_address\n:city :postcode\n:country'),
(207, 'Tajikistan', 'TJ', 'TJK', ''),
(208, 'Tanzania', 'TZ', 'TZA', ''),
(209, 'Thailand', 'TH', 'THA', ''),
(210, 'Togo', 'TG', 'TGO', ''),
(211, 'Tokelau', 'TK', 'TKL', ''),
(212, 'Tonga', 'TO', 'TON', ''),
(213, 'Trinidad and Tobago', 'TT', 'TTO', ''),
(214, 'Tunisia', 'TN', 'TUN', ''),
(215, 'Turkey', 'TR', 'TUR', ''),
(216, 'Turkmenistan', 'TM', 'TKM', ''),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', ''),
(218, 'Tuvalu', 'TV', 'TUV', ''),
(219, 'Uganda', 'UG', 'UGA', ''),
(220, 'Ukraine', 'UA', 'UKR', ''),
(221, 'United Arab Emirates', 'AE', 'ARE', ''),
(222, 'United Kingdom', 'GB', 'GBR', ':name\n:street_address\n:city\n:postcode\n:country'),
(223, 'United States of America', 'US', 'USA', ':name\n:street_address\n:city :state_code :postcode\n:country'),
(224, 'United States Minor Outlying Islands', 'UM', 'UMI', ''),
(225, 'Uruguay', 'UY', 'URY', ''),
(226, 'Uzbekistan', 'UZ', 'UZB', ''),
(227, 'Vanuatu', 'VU', 'VUT', ''),
(228, 'Vatican City State (Holy See)', 'VA', 'VAT', ''),
(229, 'Venezuela', 'VE', 'VEN', ''),
(230, 'Vietnam', 'VN', 'VNM', ''),
(231, 'Virgin Islands (British)', 'VG', 'VGB', ''),
(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', ''),
(233, 'Wallis and Futuna Islands', 'WF', 'WLF', ''),
(234, 'Western Sahara', 'EH', 'ESH', ''),
(235, 'Yemen', 'YE', 'YEM', ''),
(236, 'Yugoslavia', 'YU', 'YUG', ''),
(237, 'Zaire', 'ZR', 'ZAR', ''),
(238, 'Zambia', 'ZM', 'ZMB', ''),
(239, 'Zimbabwe', 'ZW', 'ZWE', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons`
--

CREATE TABLE `[[dbprefix]]coupons` (
  `coupons_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_type` int(1) NOT NULL,
  `coupons_status` tinyint(1) NOT NULL,
  `coupons_include_tax` tinyint(1) NOT NULL,
  `coupons_include_shipping` tinyint(1) NOT NULL,
  `coupons_code` varchar(32) NOT NULL,
  `coupons_amount` decimal(8,4) NOT NULL,
  `coupons_minimum_order` decimal(8,4) NOT NULL,
  `uses_per_coupon` int(11) NOT NULL,
  `uses_per_customer` int(11) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `coupons_date_created` datetime DEFAULT NULL,
  `coupons_date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`coupons_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons_description`
--

CREATE TABLE `[[dbprefix]]coupons_description` (
  `coupons_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `coupons_name` varchar(32) NOT NULL,
  `coupons_description` text NOT NULL,
  PRIMARY KEY (`coupons_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons_redeem_history`
--

CREATE TABLE `[[dbprefix]]coupons_redeem_history` (
  `coupons_redeem_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_id` int(11) NOT NULL,
  `customers_id` int(11) NOT NULL,
  `orders_id` int(11) NOT NULL,
  `redeem_amount` decimal(15,4) NOT NULL,
  `redeem_date` datetime DEFAULT NULL,
  `redeem_ip_address` varchar(15) NOT NULL,
  PRIMARY KEY (`coupons_redeem_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons_to_categories`
--

CREATE TABLE `[[dbprefix]]coupons_to_categories` (
  `coupons_id` int(11) NOT NULL,
  `categories_id` int(11) NOT NULL,
  PRIMARY KEY (`coupons_id`,`categories_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons_to_products`
--

CREATE TABLE `[[dbprefix]]coupons_to_products` (
  `coupons_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  PRIMARY KEY (`coupons_id`,`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]credit_cards`
--

CREATE TABLE `[[dbprefix]]credit_cards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `credit_card_name` varchar(32) NOT NULL,
  `pattern` varchar(64) NOT NULL,
  `credit_card_status` char(1) NOT NULL,
  `sort_order` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]credit_cards`
--

INSERT INTO `[[dbprefix]]credit_cards` VALUES
(1, 'American Express', '/^(34|37)\\d{13}$/', '0', 0),
(2, 'Diners Club', '/^(30|36|38)\\d{12}$/', '0', 0),
(3, 'JCB', '/^((2131|1800)\\d{11}|3[0135]\\d{14})$/', '0', 0),
(4, 'MasterCard', '/^5[1-5]\\d{14}$/', '1', 0),
(5, 'Visa', '/^4\\d{12}(\\d{3})?$/', '1', 0),
(6, 'Discover Card', '/^6011\\d{12}$/', '0', 0),
(7, 'Solo', '/^(63|67)\\d{14}(\\d{2,3})?$/', '0', 0),
(8, 'Switch', '/^(49|56|63|67)\\d{14}(\\d{2,3})?$/', '0', 0),
(9, 'Australian Bankcard', '/^5610\\d{12}$/', '0', 0),
(10, 'enRoute', '/^(2014|2149)\\d{11}$/', '0', 0),
(11, 'Laser', '/^6304\\d{12}(\\d{2,3})?$/', '0', 0),
(12, 'Maestro', '/^(50|56|57|58|6)/', '0', 0),
(13, 'Saferpay Test Card', '/^9451123100000004$/', '0', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `code` char(3) NOT NULL,
  `symbol_left` varchar(12) DEFAULT NULL,
  `symbol_right` varchar(12) DEFAULT NULL,
  `decimal_places` char(1) DEFAULT NULL,
  `value` float(13,8) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`currencies_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

INSERT INTO `[[dbprefix]]currencies` VALUES
(1, 'US Dollar', 'USD', '$', '', '2', 1.00000000, '[[regtime]]'),
(2, 'Euro', 'EUR', '€', '', '2', 0.73457497, '[[regtime]]'),
(3, 'British Pounds', 'GBP', '￡', '', '2', 0.65841001, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers`
--

CREATE TABLE `[[dbprefix]]customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_groups_id` int(11) DEFAULT NULL,
  `customers_gender` char(1) DEFAULT NULL,
  `customers_firstname` varchar(32) NOT NULL,
  `customers_lastname` varchar(32) NOT NULL,
  `customers_dob` datetime DEFAULT NULL,
  `customers_email_address` varchar(96) NOT NULL,
  `customers_default_address_id` int(11) DEFAULT NULL,
  `customers_telephone` varchar(32) DEFAULT NULL,
  `customers_fax` varchar(32) DEFAULT NULL,
  `customers_password` varchar(40) DEFAULT NULL,
  `customers_newsletter` char(1) DEFAULT NULL,
  `customers_status` int(1) DEFAULT '0',
  `customers_ip_address` varchar(15) DEFAULT NULL,
  `customers_credits` decimal(15,4) DEFAULT '0.0000',
  `date_last_logon` datetime DEFAULT NULL,
  `number_of_logons` int(5) DEFAULT NULL,
  `date_account_created` datetime DEFAULT NULL,
  `date_account_last_modified` datetime DEFAULT NULL,
  `global_product_notifications` int(1) DEFAULT '0',
  `abandoned_cart_last_contact_date` datetime DEFAULT NULL,
  PRIMARY KEY (`customers_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers_basket`
--

CREATE TABLE `[[dbprefix]]customers_basket` (
  `customers_basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `customers_basket_quantity` int(11) NOT NULL,
  `gift_certificates_data` text,
  `customizations` text,
  `final_price` decimal(15,4) NOT NULL,
  `customers_basket_date_added` datetime DEFAULT NULL,
  PRIMARY KEY (`customers_basket_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers_credits_history`
--

CREATE TABLE `[[dbprefix]]customers_credits_history` (
  `customers_credits_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `orders_id` int(11) DEFAULT NULL,
  `action_type` tinyint(1) NOT NULL,
  `date_added` datetime NOT NULL,
  `amount` decimal(15,4) NOT NULL,
  `comments` text NOT NULL,
  PRIMARY KEY (`customers_credits_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers_groups`
--

CREATE TABLE `[[dbprefix]]customers_groups` (
  `customers_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_groups_discount` int(11) NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  PRIMARY KEY (`customers_groups_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers_groups_description`
--

CREATE TABLE `[[dbprefix]]customers_groups_description` (
  `customers_groups_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `customers_groups_name` varchar(255) NOT NULL,
  PRIMARY KEY (`customers_groups_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers_ratings`
--

CREATE TABLE `[[dbprefix]]customers_ratings` (
  `customers_ratings_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `reviews_id` int(11) NOT NULL,
  `ratings_id` int(11) NOT NULL,
  `ratings_value` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_ratings_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customization_fields`
--

CREATE TABLE `[[dbprefix]]customization_fields` (
  `customization_fields_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `is_required` tinyint(1) NOT NULL,
  PRIMARY KEY (`customization_fields_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customization_fields_description`
--

CREATE TABLE `[[dbprefix]]customization_fields_description` (
  `customization_fields_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`customization_fields_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]departments`
--

CREATE TABLE `[[dbprefix]]departments` (
  `departments_id` int(11) NOT NULL AUTO_INCREMENT,
  `departments_email_address` varchar(96) NOT NULL,
  PRIMARY KEY (`departments_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]departments_description`
--

CREATE TABLE `[[dbprefix]]departments_description` (
  `departments_id` int(11) NOT NULL AUTO_INCREMENT,
  `languages_id` int(11) NOT NULL,
  `departments_title` varchar(64) NOT NULL DEFAULT '',
  `departments_description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`departments_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_accounts`
--

CREATE TABLE `[[dbprefix]]email_accounts` (
  `accounts_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `accounts_name` varchar(100) NOT NULL,
  `accounts_email` varchar(100) NOT NULL,
  `signature` text,
  `type` varchar(4) DEFAULT NULL,
  `host` varchar(100) DEFAULT NULL,
  `port` int(11) NOT NULL,
  `use_ssl` tinyint(1) NOT NULL DEFAULT '0',
  `novalidate_cert` tinyint(1) NOT NULL DEFAULT '0',
  `username` varchar(50) NOT NULL,
  `password` varchar(64) NOT NULL,
  `mbroot` varchar(30) DEFAULT NULL,
  `sent` varchar(100) DEFAULT NULL,
  `drafts` varchar(100) DEFAULT NULL,
  `trash` varchar(100) DEFAULT NULL,
  `spam` varchar(100) DEFAULT NULL,
  `save_copy_on_server` tinyint(1) DEFAULT '0',
  `examine_headers` tinyint(1) NOT NULL DEFAULT '0',
  `use_system_mailer` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_host` varchar(100) DEFAULT NULL,
  `smtp_port` int(11) DEFAULT NULL,
  `smtp_encryption` char(3) DEFAULT NULL,
  `smtp_username` varchar(50) DEFAULT NULL,
  `smtp_password` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`accounts_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_folders`
--

CREATE TABLE `[[dbprefix]]email_folders` (
  `folders_id` int(11) NOT NULL AUTO_INCREMENT,
  `accounts_id` int(11) NOT NULL,
  `folders_name` varchar(100) DEFAULT NULL,
  `folders_flag` int(4) NOT NULL DEFAULT '0',
  `subscribed` tinyint(1) NOT NULL DEFAULT '0',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `delimiter` char(1) NOT NULL DEFAULT '',
  `attributes` int(11) NOT NULL DEFAULT '0',
  `sort_order` tinyint(4) NOT NULL DEFAULT '0',
  `auto_check` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`folders_id`),
  KEY `accounts_id` (`accounts_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_messages`
--

CREATE TABLE `[[dbprefix]]email_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `accounts_id` int(11) NOT NULL,
  `folders_id` int(11) NOT NULL,
  `uid` varchar(255) NOT NULL,
  `messages_id` varchar(255) NOT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `from_address` varchar(100) DEFAULT NULL,
  `to_address` varchar(100) DEFAULT NULL,
  `reply_to` varchar(100) DEFAULT NULL,
  `udate` int(11) NOT NULL,
  `size` int(11) NOT NULL,
  `attachments` tinyint(1) NOT NULL,
  `priority` tinyint(1) NOT NULL,
  `new` tinyint(1) NOT NULL,
  `content_type` varchar(100) NOT NULL,
  `content_transfer_encoding` varchar(100) NOT NULL,
  `fetch_timestamp` int(11) NOT NULL,
  `messages_flag` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `folders_id` (`folders_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_templates`
--

CREATE TABLE `[[dbprefix]]email_templates` (
  `email_templates_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_templates_name` varchar(100) NOT NULL,
  `email_templates_status` tinyint(1) NOT NULL,
  PRIMARY KEY (`email_templates_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]email_templates`
--

INSERT INTO `[[dbprefix]]email_templates` VALUES
(1, 'create_account_email', 1),
(2, 'password_forgotten', 1),
(3, 'tell_a_friend', 1),
(4, 'new_order_created', 1),
(5, 'admin_order_status_updated', 1),
(6, 'admin_create_account_email', 1),
(7, 'abandoned_cart_inquiry', 1),
(8, 'send_coupon', 1),
(9, 'admin_customer_credits_change_notification', 1),
(10, 'share_wishlist', 1),
(11, 'active_gift_certificate', 1),
(12, 'active_downloadable_product', 1),
(13, 'admin_create_order_credit_slip', 1),
(14, 'admin_create_order_store_credit', 1),
(15, 'admin_password_forgotten', 1),
(16, 'out_of_stock_alerts', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_templates_description`
--

CREATE TABLE `[[dbprefix]]email_templates_description` (
  `email_templates_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `email_title` varchar(255) NOT NULL,
  `email_content` text NOT NULL,
  PRIMARY KEY (`email_templates_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]email_templates_description`
--

INSERT INTO `[[dbprefix]]email_templates_description` VALUES
(1, 1, 'Welcome to %%store_name%%', '<p>%%greeting_text%%</p><br /><br /><p>We welcome you to %%store_name%%!</p><br /><br /><p>You can now take part in the various services we have offer for you. Some of these services include:</p><br /><br /><ul><br /><li>Permanent Cart - Any products added to your online cart remain there until you remove them, or check them out.<br /><li>Address Book - We can now deliver your products to another address other than yours! This is perfect to send birthday gifts direct to the birthday-person themselves.<br /><li>Order History - View your history of purchases that you have made with us.<br /><li>Products Reviews - Share your opinions on products with our other customers.<br /></ul><br /><p>For help with any of our online services, please email the store-owner: %%store_owner_email_address%%.</p><br /><br />Note: This email address was given to us by one of our customers. If you did not signup to be a member, please send an email to the store owner.'),
(2, 1, 'Password Reminder to TomatoCart', 'A new password was requested from %%customer_ip_address%%.<br /><br />Your new password to %%store_name%% is:<br /><br />%%customer_password%%<br /><br />For help with any of our online services, please email the store-owner: %%store_owner_email_address%%.<br /><br />Note: If you did not request this action via our password forgotten page, please notify the store owner as soon as possible.'),
(3, 1, 'Your friend %%from_name%% has recommended this great product from %%store_name%%', 'Hi %%to_name%%!<br /><br />Your friend, %%from_name%%, thought that you would be interested in %%product_name%% from %%store_name%%.<br /><br />%%message%%<br /><br />To view the product click on the link below or copy and paste the link into your web browser:<br /><br />%%product_link%%<br /><br />Regards,<br /><br />%%store_name%% <br />%%store_address%%'),
(4, 1, 'Order Process', 'TomatoCart<br />------------------------------------------------------<br />Order Number: %%order_number%%<br />Detailed Invoice: %%invoice_link%%<br />Date Ordered: %%date_ordered%%<br /><br />%%order_details%%<br /><br />Delivery Address<br />------------------------------------------------------<br />%%delivery_address%%<br /><br />Billing Address<br />------------------------------------------------------<br />%%billing_address%%<br /><br />Order Status: %%order_status%%<br />------------------------------------------------------<br />%%order_comments%%'),
(5, 1, 'Order Update (%%store_name%%)', '%%store_name%%<br />------------------------------------------------------<br />Order Number: %%order_number%%<br />Detailed Invoice: %%invoice_link%%<br />Date Ordered: %%date_ordered%%<br /><br />Order Comment<br />------------------------------------------------------<br />%%order_comment%%<br /><br />Order Status<br />------------------------------------------------------<br />New Status: %%new_order_status%%<br /><br />Please reply to this e-mail if you have any questions regarding this order.'),
(6, 1, 'Welcome to %%store_name%%', '%%greeting_text%%<br /><br />We welcome you to %%store_name%%.<br /><br />You can now take part in the various services we have to offer you. Some of these services include:<br /><br />* Permanent Shopping Cart - Any products added to your online shopping cart remain there until you purchase or remove them<br />* Address Book - Products can be delivered to any addresses you define in your address book! This is perfect to send gifts directly to the customers.<br />* Order History - The previous orders you have made can be viewed online.<br />* Product Reviews -  Share opinions about products with other customers.<br /><br />For help with any of our online services please email us at: %%store_owner_email_address%%<br />Please note: This account has been created for you by the store owner. <br /><br />Please use your e-mail address with the following password as your login account: %%password%%'),
(7, 1, 'Inquiry from %%store_name%%', '%%greeting_text%%<br /><br />We noticed that during a visit to our store you placed the following item(s) in your shopping cart, but did not complete the transaction.<br /><br />Shopping Cart Contents:<br /><br />%%shopping_cart_contents%%<br /><br />Comment:<br /><br />%%comment%%<br /><br />We are always interested in knowing what happened and if there was a reason that you decided not to purchase at this time. If you could be so kind as to let us know if you had any issues or concerns, we would appreciate it. <br /><br />We are asking for feedback from you and others as to how we can help make your experience at %%store_name%% better.<br /><br />PLEASE NOTE:<br /><br />If you believe you completed your purchase and are wondering why it was not delivered, this email is an indication that your order was NOT completed, and that you have NOT been charged! Please return to the store in order to complete your order.<br /><br />Our apologies if you already completed your purchase, we try not to send these messages in those cases, but sometimes it is hard for us to tell depending on individual circumstances.<br /><br />Again, thank you for your time and consideration in helping us improve the %%store_name%%.<br /><br />Sincerely,<br />%%store_name%%'),
(8, 1, 'You have received a coupon from %%store_name%%', '%%greeting_text%%<br /><br />You have received a coupon from %%store_name%%. You can redeem this coupon during checkout. Just enter the code in the box provided, and click on the redeem button.<br /><br />The coupon code is: %%coupon_code%%<br /><br />Don''t lose the coupon code, make sure to keep the code safe so you can benefit from this special offer.<br /><br />%%addtional_message%%'),
(9, 1, 'You have receive a store credit from administrator', '%%greeting_text%% <p> The administrator has updated your store credits. Now you have %%customer_credits%% credits in your account. </p>'),
(10, 1, 'Your friend %%from_name%% want to share his wishlist from %%store_name%%', 'Hi!<br /><br />Your friend %%from_name%% want to share his wishlist from %%store_name%%.<br /><br />%%message%%<br /><br />To view the wishlist click on the link below or copy and paste the link into your web browser:<br /><br />%%wishlist_url%%<br /><br />Regards,<br /><br />%%store_name%% <br />%%store_address%%'),
(11, 1, 'You have received a gift certificate from %%recipient_name%%', 'Dear %%recipient_name%%,<br /><br />You have received a gift certificate from %%sender_name%%. You can redeem this gift certificate during checkout. Just enter the code in the box provided, and click on the redeem button.<br /><br />The gift certificate amount is %%gift_certificate_amount%% and  the gift certificate code is: %%gift_certificate_code%%<br /><br />Don''t lose the gift certificate code and make sure to keep the code safe.<br /><br /><b>%%gift_certificate_message%%</b><br /><br />Regards,<br /><br />%%store_name%% <br />%%store_owner_email_address%%'),
(12, 1, 'The download link for %%downloadable_products%% is actived', 'Dear %%customer_name%%,<br /><br />The download link for the products you purchased from store %%store_name%%: <br /><br />%%downloadable_products%%<br /><br />is actived.<br /><br />Please go to the orders area of "My Account" and download the products.<br /><br />%%download_link%%<br /><br />Regards,<br /><br />%%store_name%% <br />%%store_owner_email_address%%'),
(13, 1, 'A new credit slip is created for returned products', 'Dear %%customer_name%%,<br /><br />A new credit slip is created for following returned products:<br /><br /> %%returned_products%% <br /><br />from order %%order_number%%. The slip number is %%slip_number%% and the total amount is %%total_amount%%. You can print out the credit slip in the "My Acount" area. <br /><br />Regards,<br /><br />%%store_name%% <br />%%store_owner_email_address%%'),
(14, 1, 'New store credit is created for returned products', 'Dear %%customer_name%%,<br /><br />New store credit is created for following returned products:<br /><br /> %%returned_products%% <br /><br />from order %%order_number%%. The total amount is %%total_amount%% and the store credit is made to your billing account so that it can be used for future purchases. <br /><br />Regards,<br /><br />%%store_name%% <br />%%store_owner_email_address%%'),
(15, 1, 'Administrator Password Reminder to TomatoCart', 'A new password was requested from %%admin_ip_address%%.<br /><br />Your new password is:<br /><br />%%admin_password%%<br /><br />Regards,<br /><br />%%store_name%% <br />%%store_owner_email_address%%'),
(16, 1, 'Product out of Stock', 'TomatoCart<br>---------------------------------------------------<br>%%products_name%% %%products_variants%% is out of stock.<br>---------------------------------------------------<br>Remaining stock: %%products_quantity%%. You are advised to turn <br>to the Products section in the admin panel to replenish the inventory.');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faqs`
--

CREATE TABLE `[[dbprefix]]faqs` (
  `faqs_id` int(11) NOT NULL AUTO_INCREMENT,
  `faqs_status` tinyint(1) NOT NULL,
  `faqs_order` int(10) NOT NULL,
  `faqs_date_added` datetime NOT NULL,
  `faqs_last_modified` datetime NOT NULL,
  PRIMARY KEY (`faqs_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faqs_description`
--

CREATE TABLE `[[dbprefix]]faqs_description` (
  `faqs_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `faqs_question` varchar(255) NOT NULL,
  `faqs_url` varchar(255) NOT NULL,
  `faqs_answer` text NOT NULL,
  PRIMARY KEY (`faqs_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]geo_zones`
--

CREATE TABLE `[[dbprefix]]geo_zones` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `geo_zone_name` varchar(32) NOT NULL,
  `geo_zone_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`geo_zone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]geo_zones`
--

INSERT INTO `[[dbprefix]]geo_zones` VALUES
(1, 'Florida', 'Florida local sales tax zone', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gift_certificates`
--

CREATE TABLE `[[dbprefix]]gift_certificates` (
  `gift_certificates_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `gift_certificates_type` int(5) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `amount` decimal(15,4) NOT NULL,
  `gift_certificates_code` varchar(32) NOT NULL,
  `senders_name` varchar(64) NOT NULL,
  `senders_email` varchar(96) NOT NULL,
  `recipients_name` varchar(64) NOT NULL,
  `recipients_email` varchar(96) NOT NULL,
  `messages` text NOT NULL,
  PRIMARY KEY (`gift_certificates_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gift_certificates_redeem_history`
--

CREATE TABLE `[[dbprefix]]gift_certificates_redeem_history` (
  `gift_certificates_redeem_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `gift_certificates_id` int(11) NOT NULL,
  `customers_id` int(11) NOT NULL,
  `orders_id` int(11) NOT NULL,
  `redeem_date` datetime NOT NULL,
  `redeem_amount` decimal(15,4) NOT NULL,
  `redeem_ip_address` varchar(15) NOT NULL,
  PRIMARY KEY (`gift_certificates_redeem_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]guest_books`
--

CREATE TABLE `[[dbprefix]]guest_books` (
  `guest_books_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `guest_books_status` tinyint(1) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `content` text NOT NULL,
  `date_added` datetime DEFAULT NULL,
  PRIMARY KEY (`guest_books_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages`
--

CREATE TABLE `[[dbprefix]]languages` (
  `languages_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `code` char(5) NOT NULL,
  `locale` varchar(255) NOT NULL,
  `charset` varchar(32) NOT NULL,
  `date_format_short` varchar(32) NOT NULL,
  `date_format_long` varchar(32) NOT NULL,
  `time_format` varchar(32) NOT NULL,
  `text_direction` varchar(12) NOT NULL,
  `currencies_id` int(11) NOT NULL,
  `numeric_separator_decimal` varchar(12) NOT NULL,
  `numeric_separator_thousands` varchar(12) NOT NULL,
  `parent_id` int(11) DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`languages_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]languages`
--

INSERT INTO `[[dbprefix]]languages` VALUES
(1, 'English', 'en_US', 'en_US.UTF-8,en_US,english', 'utf-8', '%m/%d/%Y', '%A %d %B, %Y', '%H:%M:%S', 'ltr', 1, '.', ',', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages_definitions`
--

CREATE TABLE `[[dbprefix]]languages_definitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `languages_id` int(11) NOT NULL,
  `content_group` varchar(32) NOT NULL,
  `definition_key` varchar(255) NOT NULL,
  `definition_value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_LANGUAGES_DEFINITIONS_LANGUAGES` (`languages_id`),
  KEY `IDX_LANGUAGES_DEFINITIONS` (`languages_id`,`content_group`),
  KEY `IDX_LANGUAGES_DEFINITIONS_GROUPS` (`content_group`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1136 ;

--
-- Dumping data for table `[[dbprefix]]languages_definitions`
--

INSERT INTO `[[dbprefix]]languages_definitions` VALUES
(1, 1, 'general', 'home', 'Home'),
(2, 1, 'general', 'specials', 'Specials'),
(3, 1, 'general', 'special_products', 'Special Products'),
(4, 1, 'general', 'new_products', 'New Products'),
(5, 1, 'general', 'feature_products', 'Feature Products'),
(6, 1, 'general', 'contact_us', 'Contact Us'),
(7, 1, 'general', 'db_connection_failed', 'Databases Error: Database connection failed.'),
(8, 1, 'general', 'enter_captcha_code', 'Enter Captcha Code:'),
(9, 1, 'general', 'guest_book', 'Guest Book'),
(10, 1, 'general', 'my_account', 'My Account'),
(11, 1, 'general', 'my_wishlist', 'My Wishlist'),
(12, 1, 'general', 'login', 'Login'),
(13, 1, 'general', 'logoff', 'Logoff'),
(14, 1, 'general', 'create_account', 'Create Account'),
(15, 1, 'general', 'cart_contents', 'Cart Contents'),
(16, 1, 'general', 'save_cart_status_success', 'status of the blockcart module updated in the cookie'),
(17, 1, 'general', 'no_cart_status_setted', 'ERROR: No status setted'),
(18, 1, 'general', 'error_no_shipping_flat_url', 'Track Information is currently not available. Please contact us for more information or email us at info@tomatocart.com'),
(19, 1, 'general', 'table_heading_carrier', 'Carrier :'),
(20, 1, 'general', 'table_heading_track_number', 'Track Number :'),
(21, 1, 'general', 'table_heading_track', 'Track :'),
(22, 1, 'general', 'table_heading_error', 'Error :'),
(23, 1, 'general', 'button_track_your_order', 'Track your order'),
(24, 1, 'general', 'heading_title_order_track_infomation', 'Track Infomation'),
(25, 1, 'general', 'save_cart_status_error', 'ERROR: bad status setted. Only collapse or expand status of the blockcart module are available.'),
(26, 1, 'general', 'field_guestbook_title_error', 'ERROR: Please specify the message title.'),
(27, 1, 'general', 'field_guestbook_email_error', 'ERROR: Please specify the correct email address.'),
(28, 1, 'general', 'field_guestbook_content_error', 'ERROR: Please specify the content.'),
(29, 1, 'general', 'field_guestbook_verify_code_error', 'ERROR: Please specify the correct verify code.'),
(30, 1, 'general', 'field_guestbook_no_records', 'There isn''t any guestbook yet.'),
(31, 1, 'general', 'success_guestbook_saved', 'The message has been successfully saved.'),
(32, 1, 'general', 'verification_info_note', 'Enter the code in the Box bellow.'),
(33, 1, 'general', 'checkout', 'Checkout'),
(34, 1, 'general', 'breadcrumb_top', 'Top'),
(35, 1, 'general', 'breadcrumb_shop', 'Online Shop'),
(36, 1, 'general', 'bookmark', 'Bookmark'),
(37, 1, 'general', 'text_items', 'item(s)'),
(38, 1, 'general', 'sign_in', 'Sign In'),
(39, 1, 'general', 'sign_out', 'Sign Out'),
(40, 1, 'general', 'gender_male', 'Male'),
(41, 1, 'general', 'gender_female', 'Female'),
(42, 1, 'general', 'close', 'Close'),
(43, 1, 'general', 'pull_down_default', '--Please Select--'),
(44, 1, 'general', 'admin_logout', 'Administrator Logout'),
(45, 1, 'general', 'field_username', 'Username:'),
(46, 1, 'general', 'field_password', 'Password:'),
(47, 1, 'general', 'button_login', 'Login'),
(48, 1, 'general', 'introduction_maintenance_mode_text', 'We apologize for any inconvenience, this website is down for maintenance, please come back latter!'),
(49, 1, 'general', 'error_admin_login_no_match', 'There was no match for username and/or password. Please try again.'),
(50, 1, 'general', 'js_error', 'Errors have occured during the process of your form.\\n\\nPlease make the following corrections:\\n\\n'),
(51, 1, 'general', 'js_error_already_submitted', 'This form has already been submitted. Please press Ok and wait for this process to be completed.'),
(52, 1, 'general', 'error_download_max_num_of_days', 'You have reached the maximum download days.'),
(53, 1, 'general', 'error_download_max_num_of_times', 'You have reached the maximum download times.'),
(54, 1, 'general', 'error_download_file_not_exist', 'The requested file does not exist.'),
(55, 1, 'general', 'products', 'Products'),
(56, 1, 'general', 'shipping', 'Shipping'),
(57, 1, 'general', 'total', 'Total'),
(58, 1, 'general', 'product', 'Product'),
(59, 1, 'general', 'No products', 'No products'),
(60, 1, 'general', 'form_required_information', '* Required information'),
(61, 1, 'general', 'result_set_current_page', 'Page %s of %d'),
(62, 1, 'general', 'result_set_number_of_products', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> products)'),
(63, 1, 'general', 'result_set_number_of_orders', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> orders)'),
(64, 1, 'general', 'result_set_number_of_orders_returns', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> returned orders)'),
(65, 1, 'general', 'result_set_number_of_reviews', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> reviews)'),
(66, 1, 'general', 'result_set_number_of_articles', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> articles)'),
(67, 1, 'general', 'result_set_previous_page', '[&lt;&lt;&nbsp;Prev]'),
(68, 1, 'general', 'result_set_next_page', '[Next&nbsp;&gt;&gt;]'),
(69, 1, 'general', 'button_add_address', 'Add Address'),
(70, 1, 'general', 'button_back', 'Back'),
(71, 1, 'general', 'button_buy_now', 'Buy Now'),
(72, 1, 'general', 'button_write_message', 'Write Message'),
(73, 1, 'general', 'button_read_more', 'Read More'),
(74, 1, 'general', 'button_get_more', 'Get More'),
(75, 1, 'general', 'button_add', 'Add'),
(76, 1, 'general', 'button_clear', 'Clear'),
(77, 1, 'general', 'button_compare_now', 'Compare Now'),
(78, 1, 'general', 'add_to_cart_confirmation', 'Success: You have added %s to your shopping cart!'),
(79, 1, 'general', 'add_to_wishlist', 'Add To Wishlist'),
(80, 1, 'general', 'add_to_compare', 'Add To Compare'),
(81, 1, 'general', 'print', 'Print'),
(82, 1, 'general', 'button_change_address', 'Change Address'),
(83, 1, 'general', 'button_checkout', 'Checkout'),
(84, 1, 'general', 'button_confirm_order', 'Confirm Order'),
(85, 1, 'general', 'button_continue', 'Continue'),
(86, 1, 'general', 'submit_reviews', 'Submit Reviews'),
(87, 1, 'general', 'button_delete', 'Delete'),
(88, 1, 'general', 'button_edit', 'Edit'),
(89, 1, 'general', 'button_view', 'View'),
(90, 1, 'general', 'button_print', 'Print'),
(91, 1, 'general', 'button_return', 'Return'),
(92, 1, 'general', 'button_sign_in', 'Sign In'),
(93, 1, 'general', 'button_add_to_cart', 'Add to Shopping Cart'),
(94, 1, 'general', 'button_cart', 'Cart'),
(95, 1, 'general', 'button_reviews', 'Reviews'),
(96, 1, 'general', 'button_search', 'Search'),
(97, 1, 'general', 'button_update_cart', 'Update Shopping Cart'),
(98, 1, 'general', 'button_continue_shopping', 'Continue Shopping'),
(99, 1, 'general', 'button_write_review', 'Write Review'),
(100, 1, 'general', 'button_result', 'Result'),
(101, 1, 'general', 'button_vote', 'Vote'),
(102, 1, 'general', 'icon_in_cart', 'Add to Shopping Cart'),
(103, 1, 'general', 'tax_rate_unknown', 'Tax rate unknown'),
(104, 1, 'general', 'footer', 'Copyright &copy; %s <a href="%s">%s</a><br />Powered by <a href="http://www.tomatocart.com" target="_blank">TomatoCart</a>'),
(105, 1, 'index', 'rss_heading', 'RSS Feeds'),
(106, 1, 'index', 'rss_categories', 'Categories'),
(107, 1, 'index', 'index_heading', 'Welcome to %s!'),
(108, 1, 'index', 'index_text', 'This is a default setup of the TomatoCart e-commerce shopping cart solution, products shown are for demonstrational purposes, <b>any products purchased will not be delivered nor will the customer be billed</b>. Any information seen on these products is to be treated as fictional.'),
(109, 1, 'general', 'listing_image_heading', 'Image'),
(110, 1, 'general', 'listing_sku_heading', 'SKU'),
(111, 1, 'general', 'listing_products_heading', 'Products'),
(112, 1, 'general', 'listing_manufacturer_heading', 'Manufacturer'),
(113, 1, 'general', 'listing_quantity_heading', 'Quantity'),
(114, 1, 'general', 'listing_price_heading', 'Price'),
(115, 1, 'general', 'listing_weight_heading', 'Weight'),
(116, 1, 'general', 'listing_buy_now_heading', 'Buy Now'),
(117, 1, 'general', 'products_attributes_filter', 'Product Attributes'),
(118, 1, 'general', 'section_heading_products_attachments', 'Attachments'),
(119, 1, 'general', 'section_heading_products_accessories', 'Accessories'),
(120, 1, 'general', 'no_products_in_category', 'There are no products available in this category.'),
(121, 1, 'general', 'filter_show', 'Show:'),
(122, 1, 'general', 'filter_all_categories', 'All Categories'),
(123, 1, 'general', 'close_panel', 'Close Panel'),
(124, 1, 'general', 'hello_guest', 'Hello Guest!'),
(125, 1, 'general', 'register', 'Register'),
(126, 1, 'general', 'welcome', 'Welcome'),
(127, 1, 'general', 'filter_all_manufacturers', 'All Manufacturers'),
(128, 1, 'index', 'greeting_guest', 'Welcome! <a href="%s">Sign in</a> and see <a href="%s">what''s new</a> since your last visit.'),
(129, 1, 'index', 'greeting_customer', 'Welcome back %s! Take a look at <a href="%s">what is new</a> since your last visit!'),
(130, 1, 'general', 'listing_sort_ascendingly', 'Sort by %s ascendingly'),
(131, 1, 'general', 'listing_sort_descendingly', 'Sort by %s descendingly'),
(132, 1, 'general', 'wishlist_title', 'My Wishlist'),
(133, 1, 'account', 'field_create_account_captcha_check_error', 'ERROR: Please specify the correct verify code.'),
(134, 1, 'account', 'share_your_wishlist_title', 'Share Your Wishlist'),
(135, 1, 'account', 'field_share_wishlist_customer_name', 'Your Name:'),
(136, 1, 'account', 'field_share_wishlist_customer_email', 'Your E-Mail Address:'),
(137, 1, 'account', 'field_share_wishlist_emails', 'Emails: (seperated by comma)'),
(138, 1, 'account', 'field_share_wishlist_message', 'Message:'),
(139, 1, 'account', 'field_share_wishlist_customer_name_error', 'Please specify your Name.'),
(140, 1, 'account', 'field_share_wishlist_customer_email_error', 'Please specify your E-Mail address.'),
(141, 1, 'account', 'field_share_wishlist_emails_error', 'Please specify your friends'' E-Mail address.'),
(142, 1, 'account', 'field_share_wishlist_message_error', 'Please specify the message.'),
(143, 1, 'account', 'listing_comments_heading', 'Comments'),
(144, 1, 'account', 'listing_date_added_heading', 'Date Added'),
(145, 1, 'account', 'success_wishlist_entry_deleted', 'The selected product has been successfully removed from your wishlistbook.'),
(146, 1, 'account', 'success_wishlist_entry_updated', 'Your wishlist has been successfully updated.'),
(147, 1, 'account', 'failed_wishlist_entry_updated', 'Error: Failed to update your wishlist.'),
(148, 1, 'account', 'success_share_wishlist_email_sent', 'Your wishlist has been successfully sent to your friends.'),
(149, 1, 'account', 'wishlist_empty', 'There is no product in your wishlist.'),
(150, 1, 'account', 'error_wishlist_product_existed', 'Error: this product has already been added into your wishlist!'),
(151, 1, 'account', 'breadcrumb_sign_in', 'Sign In'),
(152, 1, 'account', 'breadcrumb_sign_out', 'Sign Out'),
(153, 1, 'account', 'breadcrumb_my_account', 'My Account'),
(154, 1, 'account', 'breadcrumb_edit_account', 'Edit Account'),
(155, 1, 'account', 'breadcrumb_edit_password', 'Change Password'),
(156, 1, 'account', 'breadcrumb_my_orders', 'Orders'),
(157, 1, 'account', 'breadcrumb_order_information', 'Order #%s'),
(158, 1, 'account', 'breadcrumb_newsletters', 'Newsletters'),
(159, 1, 'account', 'breadcrumb_notifications', 'Notifications'),
(160, 1, 'account', 'breadcrumb_address_book', 'Address Book'),
(161, 1, 'account', 'breadcrumb_wishlist', 'My Wishlist'),
(162, 1, 'account', 'breadcrumb_address_book_add_entry', 'Add Entry'),
(163, 1, 'account', 'breadcrumb_address_book_edit_entry', 'Edit Entry'),
(164, 1, 'account', 'breadcrumb_address_book_delete_entry', 'Delete Entry'),
(165, 1, 'account', 'breadcrumb_create_account', 'Create an Account'),
(166, 1, 'account', 'breadcrumb_password_forgotten', 'Password Forgotten'),
(167, 1, 'account', 'sign_in_heading', 'Welcome, Please Sign In'),
(168, 1, 'account', 'sign_out_heading', 'Sign Out From Your Account'),
(169, 1, 'account', 'wishlist_heading', 'My Wishlist'),
(170, 1, 'account', 'account_heading', 'My Account'),
(171, 1, 'account', 'account_edit_heading', 'My Account Information'),
(172, 1, 'account', 'account_password_heading', 'My Account Password'),
(173, 1, 'account', 'orders_heading', 'My Orders'),
(174, 1, 'account', 'order_information_heading', 'Order #%s'),
(175, 1, 'account', 'return_slip_heading_title', 'Return Slip'),
(176, 1, 'account', 'operation_heading_return_id', 'Return Number:'),
(177, 1, 'account', 'operation_heading_return_date', 'Return Date:'),
(178, 1, 'account', 'operation_heading_order_id', 'Order Number:'),
(179, 1, 'account', 'operation_heading_order_date', 'Order Date:'),
(180, 1, 'account', 'operation_heading_comments', 'Comment:'),
(181, 1, 'account', 'heading_products_name', 'Product Name'),
(182, 1, 'account', 'heading_products_quantity', 'Qty.'),
(183, 1, 'account', 'operation_heading_reminder', 'Reminder:'),
(184, 1, 'account', 'return_slip_reminder', '- The products must be returned in their original packaging without damage or wear. <br /> - Please print out this return slip and include it into the return package. <br /> - We reserve the right to refuse the package if the conditions listed above are not respected.'),
(185, 1, 'account', 'credit_slip_heading_title', 'Credit Slip'),
(186, 1, 'account', 'pdf_order_heading_title', 'Order'),
(187, 1, 'account', 'pdf_invoice_heading_title', 'Invoice'),
(188, 1, 'account', 'operation_heading_invoice_number', 'Invoice Number:'),
(189, 1, 'account', 'operation_heading_invoice_date', 'Invoice Date:'),
(190, 1, 'account', 'operation_heading_credit_slip_id', 'Credit Slip Number:'),
(191, 1, 'account', 'operation_heading_credit_slip_date', 'Date Created:'),
(192, 1, 'account', 'heading_products_price', 'Price'),
(193, 1, 'account', 'heading_products_total', 'Total'),
(194, 1, 'account', 'refund_sub_total', 'Sub Total:'),
(195, 1, 'account', 'refund_shipping', 'Shipping:'),
(196, 1, 'account', 'refund_handling', 'Handling Fee:'),
(197, 1, 'account', 'refund_total', 'Refund Total'),
(198, 1, 'account', 'credit_slips_heading', 'Credit Slips'),
(199, 1, 'account', 'credit_slip_number', 'Credit Slip Number:'),
(200, 1, 'account', 'date_added', 'Date Added:'),
(201, 1, 'account', 'orders_returns_heading', 'Return Requests'),
(202, 1, 'account', 'orders_returns_information_heading', 'Return item(s) for order #%s'),
(203, 1, 'account', 'field_return_comments', 'Comment for return item(s):'),
(204, 1, 'account', 'error_quantity_for_return_product', 'Please choose the quantity for %s.'),
(205, 1, 'account', 'error_return_comments_empty', 'Please specify the comments for return item(s).'),
(206, 1, 'account', 'error_return_items_empty', 'Please choose at least one product to return.'),
(207, 1, 'account', 'no_products_available_for_return', 'There is not products available for return.'),
(208, 1, 'account', 'order_return_number', 'Order return ID:'),
(209, 1, 'account', 'order_return_date_added', 'Date Added:'),
(210, 1, 'account', 'order_return_products', 'Products:'),
(211, 1, 'account', 'order_return_comments', 'Comment:'),
(212, 1, 'account', 'newsletters_heading', 'My Newsletter Subscriptions'),
(213, 1, 'account', 'notifications_heading', 'My Product Notifications'),
(214, 1, 'account', 'address_book_heading', 'My Address Book'),
(215, 1, 'account', 'address_book_add_entry_heading', 'New Address Book Entry'),
(216, 1, 'account', 'address_book_edit_entry_heading', 'Edit Address Book Entry'),
(217, 1, 'account', 'address_book_delete_entry_heading', 'Remove Address Book Entry'),
(218, 1, 'account', 'create_account_heading', 'Create an Account'),
(219, 1, 'account', 'create_account_success_heading', 'Your Account Has Been Created!'),
(220, 1, 'account', 'login_new_customer_heading', 'New Customer'),
(221, 1, 'account', 'login_new_customer_text', 'I am a new customer and do not yet have an account here.<br /><br />By creating an account you will be able to take advantage of this store by shopping faster, be kept up to date on the status of an order, and keep track of the orders you have made.'),
(222, 1, 'account', 'login_returning_customer_heading', 'Returning Customer'),
(223, 1, 'account', 'login_returning_customer_text', 'I am a returning customer and already have an account here.'),
(224, 1, 'account', 'login_returning_customer_password_forgotten', 'Password forgotten? <a href="%s">Click here</a>.'),
(225, 1, 'account', 'error_login_no_match', 'There was no match for the e-mail address and/or password. Please try again.'),
(226, 1, 'account', 'error_login_status_disabled', 'Your account is deactivated, please contact administrator.'),
(227, 1, 'account', 'guest', 'Not a member'),
(228, 1, 'account', 'lost_password', 'Lost the password'),
(229, 1, 'account', 'register_success', 'Register successfully!'),
(230, 1, 'checkout', 'date_added_to_shopping_cart', 'Date Added: %s'),
(231, 1, 'account', 'sign_out_text', 'You have sign out successfully from your account. Your shopping cart has been saved and will be restored the next time you sign on again.<br /><br />It is now safe to leave this site.'),
(232, 1, 'account', 'my_account_title', 'My Account'),
(233, 1, 'info', 'guestbook_heading', 'Guest Book'),
(234, 1, 'info', 'breadcrumb_guestbook', 'Guest Book'),
(235, 1, 'info', 'guestbook_new_heading', 'New Message'),
(236, 1, 'info', 'field_title', 'Title:'),
(237, 1, 'info', 'field_email', 'Email:'),
(238, 1, 'info', 'field_url', 'URL:'),
(239, 1, 'info', 'field_content', 'Content:'),
(240, 1, 'info', 'field_image_verification', 'Image Verification:'),
(241, 1, 'info', 'information_title', 'Information'),
(242, 1, 'info', 'info_article_categories_heading', 'Articles'),
(243, 1, 'info', 'info_faqs_heading', 'FAQs'),
(244, 1, 'info', 'info_not_found_heading', 'Information not found'),
(245, 1, 'info', 'info_not_found', 'Information not found!'),
(246, 1, 'info', 'no_article_in_this_category', 'There are no articles in this category yet!'),
(247, 1, 'account', 'my_account_information', 'View or change my account information.'),
(248, 1, 'account', 'my_account_address_book', 'View or change entries in my address book.'),
(249, 1, 'account', 'my_account_password', 'Change my account password.'),
(250, 1, 'account', 'my_wishlist_title', 'My Wishlist'),
(251, 1, 'account', 'my_wishlist_view', 'View the products in my wishlist.'),
(252, 1, 'account', 'my_orders_title', 'My Orders'),
(253, 1, 'account', 'my_orders_return_view', 'View the returned requests I have made.'),
(254, 1, 'account', 'no_orders_returns_made_yet', 'There are no return requests!'),
(255, 1, 'account', 'credit_slips', 'Print Credit Slips'),
(256, 1, 'account', 'orders_id', 'Orders Number:'),
(257, 1, 'account', 'no_credit_slips', 'There are no credit slips!'),
(258, 1, 'account', 'result_set_number_of_credit_slips', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> credit slips)'),
(259, 1, 'account', 'my_credit_slips_view', 'View my credit slips.'),
(260, 1, 'account', 'my_orders_view', 'View the orders I have made.'),
(261, 1, 'account', 'my_notifications_title', 'My Notifications'),
(262, 1, 'account', 'my_notifications_newsletters', 'Subscribe and unsubscribe from newsletters.'),
(263, 1, 'account', 'my_notifications_products', 'View and change my product notifications list.'),
(264, 1, 'account', 'my_password_title', 'My Password'),
(265, 1, 'account', 'order_number', 'Order Number:'),
(266, 1, 'account', 'order_status', 'Order Status:'),
(267, 1, 'account', 'return_status', 'Status:'),
(268, 1, 'account', 'order_date', 'Order Date:'),
(269, 1, 'account', 'order_shipped_to', 'Shipped To:'),
(270, 1, 'account', 'order_billed_to', 'Billed To:'),
(271, 1, 'account', 'order_products', 'Products:'),
(272, 1, 'account', 'order_cost', 'Order Cost:'),
(273, 1, 'account', 'no_orders_made_yet', 'You have not made any purchases yet.'),
(274, 1, 'account', 'order_number_heading', 'Order #%s'),
(275, 1, 'account', 'order_date_heading', 'Order Date:'),
(276, 1, 'account', 'order_total_heading', 'Order Total:'),
(277, 1, 'account', 'download_file', 'Download File'),
(278, 1, 'account', 'gift_wrapping_message_heading', 'Gift Wrapping Message'),
(279, 1, 'account', 'order_history_heading', 'Order History'),
(280, 1, 'account', 'download_heading', 'Download links'),
(281, 1, 'account', 'download_link_expires', 'Link expires: %s'),
(282, 1, 'account', 'download_counter_remaining', 'downloads remaining'),
(283, 1, 'account', 'newsletter_subscriptions_heading', 'My Newletter Subscriptions'),
(284, 1, 'account', 'newsletter_general', 'General Newletter'),
(285, 1, 'account', 'newsletter_general_description', 'Including store news, new products, special offers, and other promotional announcements.'),
(286, 1, 'account', 'newsletter_product_notifications', 'My Product Notifications'),
(287, 1, 'account', 'newsletter_product_notifications_description', 'The product notification list allows you to stay up to date on products you find of interest.<br /><br />To be up to date on all product changes, select <b>Global Product Notifications</b>.'),
(288, 1, 'account', 'newsletter_product_notifications_global', 'Global Product Notifications'),
(289, 1, 'account', 'newsletter_product_notifications_global_description', 'Recieve notifications on all available products.'),
(290, 1, 'account', 'newsletter_product_notifications_products', 'Product Notifications'),
(291, 1, 'account', 'newsletter_product_notifications_products_description', 'To remove a product notification, clear the products checkbox and click on Continue.'),
(292, 1, 'account', 'newsletter_product_notifications_products_none', 'There are currently no products marked to be notified on.<br /><br />To add products to your product notification list, click on the notification link available on the detailed product information page.'),
(293, 1, 'account', 'primary_address_title', 'Primary Address'),
(294, 1, 'account', 'primary_address_description', 'This address is used as the pre-selected shipping and billing address for orders placed on this store.<br /><br />This address is also used as the base for product and service tax calculations.'),
(295, 1, 'account', 'address_book_title', 'Address Book Entries'),
(296, 1, 'account', 'primary_address_marker', '(primary address)'),
(297, 1, 'account', 'address_book_maximum_entries', '<font color="#ff0000"><b>NOTE:</b></font> A maximum of %s address book entries allowed.'),
(298, 1, 'account', 'address_book_delete_address_title', 'Delete Address'),
(299, 1, 'account', 'address_book_delete_address_description', 'Are you sure you would like to delete the selected address from your address book?'),
(300, 1, 'account', 'address_book_new_address_title', 'New Address'),
(301, 1, 'account', 'selected_address_title', 'Selected Address'),
(302, 1, 'account', 'set_as_primary', 'Set as primary address.'),
(303, 1, 'account', 'create_account_terms_heading', 'Privacy Statement'),
(304, 1, 'account', 'create_account_terms_description', 'Please acknowledge you agree with our privacy statement by ticking the following box. The privacy statement can be read <a href="%s">here</a>.'),
(305, 1, 'account', 'create_account_terms_confirm', 'I have read and agreed to your privacy statement.'),
(306, 1, 'account', 'password_forgotten_heading', 'Password Forgotten'),
(307, 1, 'account', 'password_forgotten', 'If you''ve forgotten your password, enter your e-mail address below and we''ll send you an e-mail message containing your new password.'),
(308, 1, 'account', 'email_create_account_subject', 'Welcome to %s'),
(309, 1, 'account', 'email_create_account_body', 'We welcome you to %s!\n\nYou can now take part in the various services we have on offer for you. Some of these services include:\n\n<li>Permanent Cart - Any products added to your online cart remain there until you remove them, or check them out.\n<li>Address Book - We can now deliver your products to another address other than yours! This is perfect to send birthday gifts direct to the birthday-person themselves.\n<li>Order History - View your history of purchases that you have made with us.\n<li>Products Reviews - Share your opinions on products with our other customers.\n\nFor help with any of our online services, please email the store-owner: %s.\n\nNote: This email address was given to us by one of our customers. If you did not signup to be a member, please send an email to the store owner.'),
(310, 1, 'general', 'email_addressing_gender_male', 'Dear Mr. %s,'),
(311, 1, 'general', 'email_addressing_gender_female', 'Dear Ms. %s,'),
(312, 1, 'general', 'email_addressing_gender_unknown', 'Dear %s,'),
(313, 1, 'account', 'email_password_reminder_subject', 'Password Reminder to %s'),
(314, 1, 'account', 'email_password_reminder_body', 'A new password was requested from %s.\n\nYour new password to %s is:\n\n%s\n\nFor help with any of our online services, please email the store-owner: %s.\n\nNote: If you did not request this action via our password forgotten page, please notify the store owner as soon as possible.'),
(315, 1, 'account', 'success_account_created', 'Congratulations! Your new account has been successfully created! You can now take advantage of member privileges to enhance your online shopping experience with us. If you have any questions about the operation of this online shop, please email the <a href="%s">store owner</a>.<br /><br />A confirmation has been sent to the provided email address. If you have not received it within the hour, please contact us.'),
(316, 1, 'account', 'success_account_updated', 'Your account has been successfully updated!'),
(317, 1, 'account', 'success_password_updated', 'Your account password has been successfully updated!'),
(318, 1, 'account', 'success_newsletter_updated', 'Your newsletter subscriptions have been successfully updated!'),
(319, 1, 'account', 'success_notifications_updated', 'Your product notifications have been successfully updated!'),
(320, 1, 'account', 'success_address_book_entry_deleted', 'The selected address has been successfully removed from your address book.'),
(321, 1, 'account', 'success_address_book_entry_updated', 'Your address book has been successfully updated.'),
(322, 1, 'account', 'success_password_forgotten_sent', 'Success: A new password has been sent to your e-mail address.'),
(323, 1, 'account', 'warning_primary_address_deletion', 'The primary address cannot be deleted. Please set another address as the primary address and try again.'),
(324, 1, 'account', 'error_current_password_not_matching', 'Your current password does not match our records. Please try again.'),
(325, 1, 'account', 'error_address_book_entry_non_existing', 'The address book entry does not exist.'),
(326, 1, 'account', 'error_address_book_full', 'Your address book is full. Please delete an unneeded address to save a new one.'),
(327, 1, 'account', 'error_password_forgotten_no_email_address_found', 'Error: The E-Mail Address was not found in our records, please try again.'),
(328, 1, 'account', 'email_address', 'E-Mail Address:'),
(329, 1, 'general', 'warning_install_directory_exists', 'Installation directory exists at: %s. Please remove this directory for security reasons.'),
(330, 1, 'general', 'warning_config_file_writeable', 'I am able to write to the configuration file: %s. This is a potential security risk - please set the right user permissions on this file.'),
(331, 1, 'general', 'warning_session_directory_non_existent', 'The sessions directory does not exist: %s. Sessions will not work until this directory is created.'),
(332, 1, 'general', 'warning_session_directory_not_writeable', 'I am not able to write to the sessions directory: %s. Sessions will not work until the right user permissions are set.'),
(333, 1, 'general', 'warning_session_auto_start', 'session.auto_start is enabled - please disable this php feature in php.ini and restart the web server.'),
(334, 1, 'general', 'warning_download_directory_non_existent', 'The downloadable products directory does not exist: %s. Downloadable products will not work until this directory is valid.'),
(335, 1, 'checkout', 'breadcrumb_checkout', 'Checkout'),
(336, 1, 'checkout', 'alternative_checkout_methods', '- OR -'),
(337, 1, 'checkout', 'shipping', 'Shipping'),
(338, 1, 'checkout', 'choose_billing_address', 'Please select the preferred billing address.'),
(339, 1, 'checkout', 'create_new_billing_address', 'Create New Billing Address'),
(340, 1, 'checkout', 'ship_to_this_address', 'Ship To This Address'),
(341, 1, 'checkout', 'choose_shipping_address', 'Please select the preferred shipping address.'),
(342, 1, 'checkout', 'create_new_shipping_address', 'Create New Shipping Address'),
(343, 1, 'checkout', 'breadcrumb_checkout_shopping_cart', 'Shopping Cart'),
(344, 1, 'checkout', 'breadcrumb_checkout_shipping', 'Shipping Method'),
(345, 1, 'checkout', 'breadcrumb_checkout_shipping_address', 'Shipping Address'),
(346, 1, 'checkout', 'breadcrumb_checkout_payment', 'Payment Method'),
(347, 1, 'checkout', 'breadcrumb_checkout_payment_address', 'Payment Address'),
(348, 1, 'checkout', 'error_shopping_cart_order_total_zero', 'The shoppingcart''s order total is already zero, you do not have to use store credit to pay this order.'),
(349, 1, 'checkout', 'breadcrumb_checkout_confirmation', 'Confirmation'),
(350, 1, 'checkout', 'breadcrumb_checkout_success', 'Success!'),
(351, 1, 'general', 'error_minimum_order_quantity', 'The minimum order quantity of %s is %s.'),
(352, 1, 'general', 'error_maximum_order_quantity', 'The maximum order quantity of %s is %s.'),
(353, 1, 'general', 'error_gift_certificate_quantity_must_be_one', 'Error: The gift certificate quantity should be no larger than one.'),
(354, 1, 'general', 'error_order_increment', 'The order increment of %s is %s.'),
(355, 1, 'checkout', 'senders_name', 'Sender Name'),
(356, 1, 'checkout', 'senders_email', 'Sender Email'),
(357, 1, 'checkout', 'recipients_name', 'Recipient Name'),
(358, 1, 'checkout', 'recipients_email', 'Recipient Email'),
(359, 1, 'checkout', 'shopping_cart_heading', 'Shopping Cart'),
(360, 1, 'checkout', 'shipping_method_heading', 'Shipping Method'),
(361, 1, 'checkout', 'checkout_method', 'Checkout Method'),
(362, 1, 'checkout', 'checkout_billing_information', 'Billing Information'),
(363, 1, 'checkout', 'checkout_shipping_information', 'Shipping Information'),
(364, 1, 'checkout', 'checkout_shipping_method', 'Shipping Method'),
(365, 1, 'checkout', 'checkout_payment_information', 'Payment Information'),
(366, 1, 'checkout', 'checkout_order_review', 'Order Review'),
(367, 1, 'checkout', 'shipping_address_heading', 'Shipping Address'),
(368, 1, 'checkout', 'payment_method_heading', 'Payment Method'),
(369, 1, 'checkout', 'payment_address_heading', 'Payment Address'),
(370, 1, 'checkout', 'confirmation_heading', 'Confirmation'),
(371, 1, 'checkout', 'coupons_redeem_heading', 'Redeem Coupon'),
(372, 1, 'checkout', 'coupons_redeem_information_title', 'Please specify the coupon code.'),
(373, 1, 'checkout', 'fields_coupons_redeem_code', 'Coupon Code:'),
(374, 1, 'checkout', 'gift_certificates_redeem_heading', 'Redeem Gift Certificate'),
(375, 1, 'checkout', 'gift_certificates_redeem_information_title', 'Please specify the gift certificate code.'),
(376, 1, 'checkout', 'fields_gift_certificates_redeem_code', 'Gift Certificate Code:'),
(377, 1, 'checkout', 'success_heading', 'Your Order Has Been Processed!'),
(378, 1, 'checkout', 'shipping_address_title', 'Shipping Address'),
(379, 1, 'checkout', 'choose_shipping_destination', 'Please choose from your address book where you would like the items to be delivered to.'),
(380, 1, 'checkout', 'selected_shipping_destination', 'This is the currently selected shipping address where the items in this order will be delivered to.'),
(381, 1, 'checkout', 'current_shipping_address_title', 'Shipping Address:'),
(382, 1, 'checkout', 'please_select', 'Please Select'),
(383, 1, 'checkout', 'shipping_method_title', 'Shipping Method'),
(384, 1, 'checkout', 'choose_shipping_method', 'Please select the preferred shipping method to use on this order.'),
(385, 1, 'checkout', 'only_one_shipping_method_available', 'This is currently the only shipping method available to use on this order.'),
(386, 1, 'checkout', 'add_comment_to_order_title', 'Add A Note To This Order'),
(387, 1, 'checkout', 'address_book_entries_title', 'Address Book Entries'),
(388, 1, 'checkout', 'select_another_shipping_destination', 'Please select the preferred shipping address if the items in this order are to be delivered elsewhere.'),
(389, 1, 'checkout', 'select_another_billing_destination', 'Please select the preferred billing address if the invoice to this order is to be delivered elsewhere.'),
(390, 1, 'checkout', 'new_shipping_address_title', 'New Shipping Address'),
(391, 1, 'checkout', 'new_shipping_address', 'Please use the following form to create a new shipping address to use for this order.'),
(392, 1, 'checkout', 'new_billing_address_title', 'New Billing Address'),
(393, 1, 'checkout', 'create_new_billing_address_title', 'Create a new billing address'),
(394, 1, 'checkout', 'create_new_shipping_address_title', 'Create a new shipping address'),
(395, 1, 'checkout', 'use_billing_address_title', 'Use billing address'),
(396, 1, 'checkout', 'estimate_shipping', 'Estimate Shipping'),
(397, 1, 'checkout', 'introduce_estimate_shipping', 'Enter your destination to get a shipping estimate.'),
(398, 1, 'checkout', 'get_a_quote', 'Get a Quote'),
(399, 1, 'checkout', 'update_total', 'Update Total'),
(400, 1, 'checkout', 'ship_to_this_address', 'Ship to this address'),
(401, 1, 'checkout', 'new_billing_address', 'Please use the following form to create a new billing address to use for this order.'),
(402, 1, 'checkout', 'billing_address_title', 'Billing Address'),
(403, 1, 'checkout', 'selected_billing_destination', 'This is the currently selected billing address where the invoice to this order will be delivered to.'),
(404, 1, 'checkout', 'choose_billing_destination', 'Please choose from your address book where you would like the invoice to be sent to.'),
(405, 1, 'checkout', 'current_billing_address_title', 'Billing Address:'),
(406, 1, 'checkout', 'continue_checkout_procedure_title', 'Continue Checkout Procedure'),
(407, 1, 'checkout', 'continue_checkout_procedure_to_shipping', 'to select the preferred shipping method.'),
(408, 1, 'checkout', 'continue_checkout_procedure_to_payment', 'to select the preferred payment method.'),
(409, 1, 'checkout', 'continue_checkout_procedure_to_confirmation', 'to confirm this order.'),
(410, 1, 'checkout', 'shopping_cart_empty', 'Your Shopping Cart is empty!'),
(411, 1, 'checkout', 'subtotal_title', 'Sub-Total:'),
(412, 1, 'checkout', 'total_title', 'Total:'),
(413, 1, 'checkout', 'products_out_of_stock_checkout_not_possible', 'Products marked with %s don''t exist in desired quantity in our stock.<br />Please change the quantity of the marked products.'),
(414, 1, 'checkout', 'products_out_of_stock_checkout_possible', 'Products marked with %s don''t exist in desired quantity in our stock.<br />You can buy them anyway and check the quantity we have in stock for immediate delivery in the checkout process.'),
(415, 1, 'checkout', 'order_conditions_title', 'Terms and Conditions'),
(416, 1, 'checkout', 'order_conditions_description', 'Please acknowledge the terms and conditions bound to this order by ticking the following box. The terms and conditions can be read <a href="%s"><u>here</u></a>.'),
(417, 1, 'checkout', 'order_conditions_acknowledge', 'I have read and agreed to the terms and conditions bound to this order.'),
(418, 1, 'checkout', 'payment_method_title', 'Payment Method'),
(419, 1, 'checkout', 'choose_payment_method', 'Please select the preferred payment method to use on this order.'),
(420, 1, 'checkout', 'only_one_payment_method_available', 'This is currently the only payment method available to use on this order.'),
(421, 1, 'checkout', 'pay_with_store_credit_title', 'Pay with Store Credit (%s)'),
(422, 1, 'checkout', 'error_coupon_not_exist', 'The coupon code does not exist.'),
(423, 1, 'checkout', 'error_coupon_not_valid', 'Please specify a valid coupon.'),
(424, 1, 'checkout', 'error_coupon_invalid_date', 'The coupon has expired.'),
(425, 1, 'checkout', 'error_coupon_exceed_uses_per_coupon', 'The coupon has reach the maximum number of usages.'),
(426, 1, 'checkout', 'error_coupon_exceed_uses_per_customer', 'The coupon has reach the maximum number of customers.'),
(427, 1, 'checkout', 'error_coupon_no_match_products', 'The coupon can not apply to any of the products in the shopping cart.'),
(428, 1, 'checkout', 'error_coupon_minimum_order_quantity', 'The cart total is less than the coupon''s minimum order total.'),
(429, 1, 'checkout', 'error_shopping_cart_total_zero', 'The cart total is already zero, you do not have to use the gift certificate.'),
(430, 1, 'checkout', 'error_gift_certificate_exist', 'The gift certificate does exist.'),
(431, 1, 'checkout', 'error_invalid_gift_certificate', 'Please specify a valid gift certificate.'),
(432, 1, 'checkout', 'button_coupon_redeem', 'Redeem Coupon'),
(433, 1, 'checkout', 'button_gift_certificate_redeem', 'Redeem Gift Certificate'),
(434, 1, 'order', 'order_delivery_address_title', 'Delivery Address'),
(435, 1, 'order', 'order_shipping_method_title', 'Shipping Method'),
(436, 1, 'order', 'order_shipping_tracking_no_title', 'Tracking No.'),
(437, 1, 'order', 'order_products_title', 'Products'),
(438, 1, 'order', 'order_tax_title', 'Tax'),
(439, 1, 'order', 'order_total_title', 'Total'),
(440, 1, 'order', 'order_billing_address_title', 'Billing Address'),
(441, 1, 'order', 'order_payment_method_title', 'Payment Method'),
(442, 1, 'order', 'order_payment_information_title', 'Payment Information'),
(443, 1, 'order', 'order_comments_title', 'Comments Added To Your Order'),
(444, 1, 'order', 'order_text_edit_title', '(edit)'),
(445, 1, 'checkout', 'store_credit_title', 'Store Credit'),
(446, 1, 'checkout', 'store_credit_order_number', 'Order: #%s'),
(447, 1, 'checkout', 'email_order_subject', 'Order Process'),
(448, 1, 'checkout', 'email_order_order_number', 'Order Number: %s'),
(449, 1, 'checkout', 'email_order_invoice_url', 'Detailed Invoice: %s'),
(450, 1, 'checkout', 'email_order_date_ordered', 'Date Ordered: %s'),
(451, 1, 'checkout', 'email_order_status', 'Order Status: %s'),
(452, 1, 'checkout', 'email_order_products', 'Products'),
(453, 1, 'checkout', 'email_order_delivery_address', 'Delivery Address'),
(454, 1, 'checkout', 'email_order_billing_address', 'Billing Address'),
(455, 1, 'checkout', 'email_order_payment_method', 'Payment Method'),
(456, 1, 'checkout', 'email_order_separator', '------------------------------------------------------'),
(457, 1, 'checkout', 'order_processed_successfully', 'Your order has been successfully processed! Your products will arrive at their destination within 2-5 working days.'),
(458, 1, 'checkout', 'add_selection_to_product_notifications', 'Please notify me of updates to the products I have selected below:'),
(459, 1, 'checkout', 'view_order_history', 'You can view your order history by going to the <a href="%s">My Account</a> page and by clicking on <a href="%s">History</a>.'),
(460, 1, 'checkout', 'view_downloadable_products_link', 'There is the download link to the downloadable product!'),
(461, 1, 'checkout', 'contact_store_owner', 'Please direct any questions you have to the <a href="%s">store owner</a>.'),
(462, 1, 'checkout', 'thanks_for_shopping_with_us', 'Thanks for shopping with us online!'),
(463, 1, 'general', 'download_footer', 'You can also download your products at a later time at %s'),
(464, 1, 'info', 'breadcrumb_information', 'Information'),
(465, 1, 'info', 'breadcrumb_conditions', 'Conditions'),
(466, 1, 'info', 'breadcrumb_contact', 'Contact'),
(467, 1, 'info', 'breadcrumb_privacy', 'Privacy'),
(468, 1, 'info', 'breadcrumb_shipping', 'Shipping'),
(469, 1, 'info', 'breadcrumb_sitemap', 'Sitemap'),
(470, 1, 'info', 'breadcrumb_cookie_usage', 'Cookie Usage'),
(471, 1, 'info', 'breadcrumb_ssl_check', 'Security Check'),
(472, 1, 'info', 'info_heading', 'Information and Help'),
(473, 1, 'info', 'info_conditions_heading', 'Terms and Conditions'),
(474, 1, 'info', 'info_contact_heading', 'Contact'),
(475, 1, 'info', 'contact_departments_title', 'Department:'),
(476, 1, 'info', 'info_privacy_heading', 'Privacy Notice'),
(477, 1, 'info', 'contact_telephone_title', 'Telephone:'),
(478, 1, 'info', 'info_shipping_heading', 'Shipping and Returns'),
(479, 1, 'info', 'info_sitemap_heading', 'Sitemap'),
(480, 1, 'info', 'info_cookie_usage_heading', 'Cookie Usage'),
(481, 1, 'info', 'info_ssl_check_heading', 'Security Check'),
(482, 1, 'info', 'conditions', 'Put here the required information.'),
(483, 1, 'info', 'contact_code_title', 'Image Verification:'),
(484, 1, 'info', 'captcha_image_title', 'CAPTCHA Image'),
(485, 1, 'info', 'contact_code_notice_title', 'Enter the code in the Box bellow:'),
(486, 1, 'info', 'contact', 'Put here the required information.'),
(487, 1, 'info', 'privacy', 'Put here the required information.'),
(488, 1, 'info', 'shipping', 'Put here the required information.'),
(489, 1, 'info', 'cookie_usage', 'We have detected that your browser does not support cookies, or has set cookies to be disabled.<br /><br />To continue shopping online, we encourage you to enable cookies on your browser.<br /><br />For <b>Internet Explorer</b> browsers, please follow these instructions:<br /><ol><li>Click on the Tools menubar, and select Internet Options</li><li>Select the Security tab, and reset the security level to Medium</li></ol>We have taken this measurement of security for your benefit, and apologize upfront if any inconveniences are caused.<br /><br />Please contact the store owner if you have any questions relating to this requirement, or to continue purchasing products offline.'),
(490, 1, 'info', 'ssl_check', 'We have detected that your browser has generated a different SSL Session ID used throughout our secure pages.<br /><br />For security measures you will need to logon to your account again to continue shopping online.<br /><br />Certain older browsers do not have the capability of generating a secure SSL Session ID automatically which we require. If you use such a browser, we recommend switching to another browser such as <a href="http://www.microsoft.com/ie/" target="_blank">Microsoft Internet Explorer</a>, <a href="http://www.mozilla.com/firefox/" target="_blank">Firefox</a>, or <a href="http://www.opera.com" target="_blank">Opera</a> to continue your online shopping experience.<br /><br />We have taken this measurement of security for your benefit, and apologize upfront if any inconveniences are caused.<br /><br />Please contact the store owner if you have any questions relating to this requirement, or to continue purchasing products offline.'),
(491, 1, 'info', 'contact_title', 'Contact Information'),
(492, 1, 'info', 'contact_store_address_title', 'Store Address'),
(493, 1, 'info', 'contact_name_title', 'Full Name:'),
(494, 1, 'info', 'contact_email_address_title', 'Email Address:'),
(495, 1, 'info', 'contact_enquiry_title', 'Enquiry:'),
(496, 1, 'info', 'contact_email_sent_successfully', 'Your enquiry has been successfully sent to the store owner.'),
(497, 1, 'info', 'contact_email_subject', 'Contact Enquiry'),
(498, 1, 'info', 'refresh_captcha_image_title', 'Refresh Image'),
(499, 1, 'info', 'sitemap_account', 'My Account'),
(500, 1, 'info', 'sitemap_account_edit', 'Account Information'),
(501, 1, 'info', 'sitemap_address_book', 'Address Book'),
(502, 1, 'info', 'sitemap_account_history', 'Order History'),
(503, 1, 'info', 'sitemap_account_notifications', 'Newsletter Subscriptions'),
(504, 1, 'info', 'sitemap_shopping_cart', 'Shopping Cart'),
(505, 1, 'info', 'sitemap_checkout_shipping', 'Checkout'),
(506, 1, 'info', 'sitemap_advanced_search', 'Advanced Search'),
(507, 1, 'info', 'sitemap_products_new', 'New Products'),
(508, 1, 'info', 'sitemap_specials', 'Specials'),
(509, 1, 'info', 'sitemap_reviews', 'Reviews'),
(510, 1, 'info', 'cookie_usage_box_heading', 'Cookie Privacy and Security'),
(511, 1, 'info', 'cookie_usage_box_contents', 'Cookies must be enabled to purchase online on this store to embrace privacy and security related issues regarding your visit to this site.<br /><br />By enabling cookie support on your browser, the communication between you and this site is strengthened to be certain it is you who are making transactions on your own behalf, and to prevent leakage of your privacy information.'),
(512, 1, 'info', 'ssl_check_box_heading', 'Privacy and Security'),
(513, 1, 'info', 'ssl_check_box_contents', 'We validate the SSL Session ID automatically generated by your browser on every secure page request made to this server.<br /><br />This validation assures that it is you who is navigating on this site with your account and not somebody else.'),
(514, 1, 'products', 'table_heading_weight', 'Weight'),
(515, 1, 'products', 'table_heading_quantity', 'Quantity'),
(516, 1, 'products', 'table_heading_discount', 'Discount'),
(517, 1, 'products', 'table_heading_price', 'Price'),
(518, 1, 'products', 'section_heading_attributes', 'Product Attributes'),
(519, 1, 'products', 'table_heading_sku', 'SKU'),
(520, 1, 'products', 'section_heading_variants', 'Product Variants'),
(521, 1, 'products', 'section_heading_customizations', 'Customizations'),
(522, 1, 'products', 'section_heading_reviews', 'Reviews'),
(523, 1, 'products', 'section_heading_quantity_discount', 'Quantity Discount'),
(524, 1, 'products', 'breadcrumb_new_products', 'New Products'),
(525, 1, 'products', 'breadcrumb_specials', 'Specials'),
(526, 1, 'products', 'breadcrumb_reviews', 'Reviews'),
(527, 1, 'products', 'breadcrumb_reviews_new', 'New Review'),
(528, 1, 'products', 'breadcrumb_tell_a_friend', 'Tell A Friend'),
(529, 1, 'products', 'product_not_found_heading', 'Product Not Found'),
(530, 1, 'products', 'no_new_products', 'There are currently no products available.'),
(531, 1, 'products', 'new_products_heading', 'New Products'),
(532, 1, 'products', 'compare_products_heading', 'Compare Products'),
(533, 1, 'products', 'specials_heading', 'Specials'),
(534, 1, 'products', 'reviews_heading', 'Reviews'),
(535, 1, 'products', 'product_not_found', 'Product not found!'),
(536, 1, 'products', 'number_of_product_reviews', 'Current Reviews:'),
(537, 1, 'products', 'including_tax', 'incl. tax'),
(538, 1, 'products', 'in_stock', 'In Stock'),
(539, 1, 'products', 'out_of_stock', 'Out Of Stock'),
(540, 1, 'products', 'not_available', 'Not Available'),
(541, 1, 'products', 'field_sku', 'SKU:'),
(542, 1, 'products', 'field_availability', 'Availability:'),
(543, 1, 'products', 'field_quantity', 'Quantity:'),
(544, 1, 'products', 'field_moq', 'Minimum Order Qty:'),
(545, 1, 'products', 'field_order_increment', 'Order Increment:'),
(546, 1, 'products', 'field_sample_url', 'Sample File:'),
(547, 1, 'products', 'field_gift_certificate_amount', 'Amount:'),
(548, 1, 'products', 'field_senders_name', 'Sender Name:'),
(549, 1, 'products', 'field_senders_email', 'Sender Email:'),
(550, 1, 'products', 'field_recipients_name', 'Recipient Name:'),
(551, 1, 'products', 'field_recipients_email', 'Recipient Email:'),
(552, 1, 'products', 'fields_gift_certificate_message', 'Message:'),
(553, 1, 'products', 'field_short_quantity', 'Qty:'),
(554, 1, 'products', 'field_products_name', 'Product Name:'),
(555, 1, 'products', 'field_products_price', 'Product Price:'),
(556, 1, 'products', 'field_products_weight', 'Product Weight:'),
(557, 1, 'products', 'field_products_sku', 'Product SKU:'),
(558, 1, 'products', 'field_products_manufacturer', 'Manufacturer:'),
(559, 1, 'products', 'field_products_description', 'Product Description:'),
(560, 1, 'products', 'field_products_variants', 'Product Variants:'),
(561, 1, 'products', 'field_products_attributes', 'Product Attributes:'),
(562, 1, 'products', 'error_sender_name_empty', 'Please specify the send name.'),
(563, 1, 'products', 'error_sender_email_empty', 'Please specify the send Email.'),
(564, 1, 'products', 'error_recipient_name_empty', 'Please specify the recipient name.'),
(565, 1, 'products', 'error_recipient_email_empty', 'Please specify the recipient Email.'),
(566, 1, 'products', 'error_message_empty', 'Please specify the message.'),
(567, 1, 'products', 'error_message_open_gift_certificate_amount', 'Please specify a correct value for the gift certificate amount.'),
(568, 1, 'products', 'error_customization_field_must_be_specified', 'Please specify a value for the customization field: %s.'),
(569, 1, 'products', 'error_gift_certificate_data_missing', 'Please specify the data for the gift certificate.'),
(570, 1, 'products', 'error_customization_fields_missing', 'Please specify the value for customization fields before adding the product to shopping cart.'),
(571, 1, 'products', 'go_to_external_products_webpage', 'For more information, please visit this products <a href="%s" target="_blank">webpage</a>.'),
(572, 1, 'products', 'date_availability', '<font color="#ff0000">This product will be in stock on %s.</font>'),
(573, 1, 'products', 'section_heading_products_description', 'Description'),
(574, 1, 'products', 'product_attributes', 'Available Options:'),
(575, 1, 'products', 'enlarge_image', 'Click to enlarge'),
(576, 1, 'products', 'date_added', 'Date Added:'),
(577, 1, 'products', 'manufacturer', 'Manufacturer:'),
(578, 1, 'products', 'price', 'Price:'),
(579, 1, 'products', 'login_to_write_review', 'Please <a href="%s"><b>click here</b></a> to login to your account to write review.'),
(580, 1, 'products', 'average_rating', 'Average Rating:'),
(581, 1, 'products', 'login_to_write_review', 'Please login to write review.'),
(582, 1, 'products', 'no_review', 'There are no reviews for this product.'),
(583, 1, 'products', 'heading_write_review', 'WRITE REVIEWS'),
(584, 1, 'products', 'introduction_rating', 'How do you rate this product?'),
(585, 1, 'products', '1_star', '1star'),
(586, 1, 'products', '2_star', '2star'),
(587, 1, 'products', '3_star', '3star'),
(588, 1, 'products', '4_star', '4star'),
(589, 1, 'products', '5_star', '5star'),
(590, 1, 'products', 'rating_of_5_stars', '%s of 5 Stars!'),
(591, 1, 'products', 'no_reviews_available', 'No reviews found.'),
(592, 1, 'products', 'new_review_title', 'New Review'),
(593, 1, 'products', 'field_review_rating', 'Rating:'),
(594, 1, 'products', 'field_review', 'Review'),
(595, 1, 'products', 'field_review_from', 'From:'),
(596, 1, 'products', 'field_review_author', 'Your Name:'),
(597, 1, 'products', 'review_note_message', '<em>Note:</em> HTML is not translated!'),
(598, 1, 'products', 'introduction_rating', 'Please give your ratings with this product:'),
(599, 1, 'products', 'login_to_write', 'Please login to write your reviews.'),
(600, 1, 'products', 'review_lowest_rating_title', 'Bad'),
(601, 1, 'products', 'review_highest_rating_title', 'Good'),
(602, 1, 'products', 'customer_details_title', 'Your Details');
INSERT INTO `[[dbprefix]]languages_definitions` VALUES
(603, 1, 'products', 'friend_details_title', 'Your Friends Details'),
(604, 1, 'products', 'tell_a_friend_message', 'Your Message'),
(605, 1, 'products', 'field_tell_a_friend_customer_name', 'Your Name:'),
(606, 1, 'products', 'field_tell_a_friend_customer_email_address', 'Your E-Mail Address:'),
(607, 1, 'products', 'field_tell_a_friend_friends_name', 'Your Friends Name:'),
(608, 1, 'products', 'field_tell_a_friend_friends_email_address', 'Your Friends E-Mail Address:'),
(609, 1, 'products', 'email_tell_a_friend_subject', 'Your friend %s has recommended this great product from %s'),
(610, 1, 'products', 'email_tell_a_friend_intro', 'Hi %s!\n\nYour friend, %s, thought that you would be interested in %s from %s.'),
(611, 1, 'products', 'email_tell_a_friend_link', 'To view the product click on the link below or copy and paste the link into your web browser:\n\n%s'),
(612, 1, 'products', 'email_tell_a_friend_signature', 'Regards,\n\n%s'),
(613, 1, 'products', 'success_review_new', 'Thank you for your review! It has been received and is now active!'),
(614, 1, 'products', 'success_review_moderation', 'Thank you for your review! It has been received and is pending for approval.'),
(615, 1, 'products', 'success_tell_a_friend_email_sent', 'Your email about %s has been successfully sent to %s.'),
(616, 1, 'products', 'error_tell_a_friend_friends_name_empty', 'Error: Your friends name must not be empty.'),
(617, 1, 'products', 'error_tell_a_friend_invalid_friends_email_address', 'Error: Your friends e-mail address must be a valid e-mail address.'),
(618, 1, 'products', 'error_tell_a_friend_customers_name_empty', 'Error: Your name must not be empty.'),
(619, 1, 'products', 'error_tell_a_friend_invalid_customers_email_address', 'Error: Your e-mail address must be a valid e-mail address.'),
(620, 1, 'search', 'breadcrumb_search', 'Search'),
(621, 1, 'search', 'breadcrumb_search_results', 'Results'),
(622, 1, 'search', 'search_heading', 'Search'),
(623, 1, 'search', 'advanced_search_heading', 'Advanced Search'),
(624, 1, 'search', 'search_results_heading', 'Search Results'),
(625, 1, 'search', 'search_criteria_title', 'Search Criteria'),
(626, 1, 'search', 'field_search_categories', 'Categories:'),
(627, 1, 'search', 'field_search_recursive', 'Include Subcategories'),
(628, 1, 'search', 'field_search_manufacturers', 'Manufacturers:'),
(629, 1, 'search', 'field_search_price_from', 'Price From:'),
(630, 1, 'search', 'field_search_price_to', 'Price To:'),
(631, 1, 'search', 'field_search_date_from', 'Date From:'),
(632, 1, 'search', 'field_search_date_to', 'Date To:'),
(633, 1, 'search', 'search_help_tips', 'Search Help'),
(634, 1, 'search', 'search_help_heading', 'Search Help'),
(635, 1, 'search', 'search_help', 'Keywords may be separated by AND and/or OR statements for greater control of the search results.<br /><br />For example, <u>Microsoft AND mouse</u> would generate a result set that contain both words. However, for <u>mouse OR keyboard</u>, the result set returned would contain both or either words.<br /><br />Exact matches can be searched for by enclosing keywords in double-quotes.<br /><br />For example, <u>"notebook computer"</u> would generate a result set which match the exact string.<br /><br />Brackets can be used for further control on the result set.<br /><br />For example, <u>Microsoft and (keyboard or mouse or "visual basic")</u>.'),
(636, 1, 'general', 'close_window', 'Close Window'),
(637, 1, 'search', 'error_search_at_least_one_input', 'At least one of the fields in the search form must be entered.'),
(638, 1, 'search', 'error_search_invalid_from_date', 'Invalid From Date.'),
(639, 1, 'search', 'error_search_invalid_to_date', 'Invalid To Date.'),
(640, 1, 'search', 'error_search_to_date_less_than_from_date', 'To Date must be greater than or equal to From Date.'),
(641, 1, 'search', 'error_search_price_from_not_numeric', 'Price From must be a number.'),
(642, 1, 'search', 'error_search_price_to_not_numeric', 'Price To must be a number.'),
(643, 1, 'search', 'error_search_price_to_less_than_price_from', 'Price To must be greater than or equal to Price From.'),
(644, 1, 'search', 'error_search_invalid_keywords', 'Invalid keywords.'),
(645, 1, 'products', 'js_review_text', '* The Review Text must have at least %s characters.'),
(646, 1, 'products', 'js_review_rating', '* You must rate the product for your review.'),
(647, 1, 'products', 'js_customization_file_size', 'The filesize must small than %s .'),
(648, 1, 'checkout', 'js_no_payment_module_selected', '* Please select a payment method for your order.'),
(649, 1, 'checkout', 'error_no_payment_module_selected', 'Please select a payment method for your order.'),
(650, 1, 'checkout', 'error_conditions_not_accepted', 'Please confirm the terms and conditions bound to this order by ticking the box below.'),
(651, 1, 'account', 'error_privacy_statement_not_accepted', 'Please confirm the privacy statement by ticking the box below.'),
(652, 1, 'general', 'field_customer_gender', 'Gender:'),
(653, 1, 'general', 'field_customer_gender_error', 'Please select your Gender.'),
(654, 1, 'general', 'field_customer_first_name', 'First Name:'),
(655, 1, 'general', 'field_customer_first_name_error', 'Your First Name must contain a minimum of %s characters.'),
(656, 1, 'general', 'field_customer_last_name', 'Last Name:'),
(657, 1, 'general', 'field_customer_last_name_error', 'Your Last Name must contain a minimum of %s characters.'),
(658, 1, 'general', 'field_customer_date_of_birth', 'Date of Birth:'),
(659, 1, 'general', 'field_customer_date_of_birth_error', 'Your Date of Birth must be set correctly.'),
(660, 1, 'general', 'field_customer_email_address', 'E-Mail Address:'),
(661, 1, 'general', 'field_customer_group', 'Customer Group:'),
(662, 1, 'general', 'field_customer_store_credit', 'Store Credit:'),
(663, 1, 'general', 'field_customer_email_address_error', 'Your E-Mail Address must contain a minimum of %s characters.'),
(664, 1, 'general', 'field_customer_email_address_check_error', 'Your E-Mail Address does not appear to be valid - please make any necessary corrections.'),
(665, 1, 'general', 'field_customer_email_address_exists_error', 'Your E-Mail Address already exists in our records - please log in with the e-mail address or create an account with a different address.'),
(666, 1, 'general', 'field_customer_company', 'Company Name:'),
(667, 1, 'general', 'field_customer_company_error', 'Your Company Name must contain a minimum of %s characters.'),
(668, 1, 'general', 'field_customer_street_address', 'Street Address:'),
(669, 1, 'general', 'field_customer_street_address_error', 'Your Street Address must contain a minimum of %s characters.'),
(670, 1, 'general', 'field_customer_suburb', 'Suburb:'),
(671, 1, 'general', 'field_customer_suburb_error', 'Your Suburb must contain a minimum of %s characters.'),
(672, 1, 'general', 'field_customer_post_code', 'Post Code:'),
(673, 1, 'general', 'field_customer_post_code_error', 'Your Post Code must contain a minimum of %s characters.'),
(674, 1, 'general', 'field_customer_city', 'City:'),
(675, 1, 'general', 'field_customer_city_error', 'Your City must contain a minimum of %s characters.'),
(676, 1, 'general', 'field_customer_state', 'State/Province:'),
(677, 1, 'general', 'field_customer_state_error', 'Your State must contain a minimum of %s characters.'),
(678, 1, 'general', 'field_customer_state_select_pull_down_error', 'Please select a state from the States pull down menu.'),
(679, 1, 'general', 'field_customer_country', 'Country:'),
(680, 1, 'general', 'field_customer_country_error', 'You must select a country from the Countries pull down menu.'),
(681, 1, 'general', 'field_customer_telephone_number', 'Telephone Number:'),
(682, 1, 'general', 'field_customer_telephone_number_error', 'Your Telephone Number must contain a minimum of %s characters.'),
(683, 1, 'general', 'field_customer_fax_number', 'Fax Number:'),
(684, 1, 'general', 'field_customer_fax_number_error', 'Your Fax Number must contain a minium of %s characters.'),
(685, 1, 'general', 'field_customer_newsletter', 'Newsletter:'),
(686, 1, 'general', 'field_customer_password', 'Password:'),
(687, 1, 'general', 'field_customer_password_error', 'Your Password must contain a minimum of %s characters.'),
(688, 1, 'general', 'field_customer_password_mismatch_with_confirmation', 'The Password Confirmation must match your Password.'),
(689, 1, 'general', 'field_customer_password_confirmation', 'Password Confirmation:'),
(690, 1, 'general', 'field_customer_password_current', 'Current Password:'),
(691, 1, 'general', 'field_customer_password_current_error', 'Your Password must contain a minimum of %s characters.'),
(692, 1, 'general', 'field_customer_password_new', 'New Password:'),
(693, 1, 'general', 'field_customer_password_new_error', 'Your new Password must contain a minimum of %s characters.'),
(694, 1, 'general', 'field_customer_password_new_mismatch_with_confirmation_error', 'The Password Confirmation must match your new Password.'),
(695, 1, 'products', 'reviewed_by', 'Review by %s'),
(696, 1, 'products', 'review_rating', 'Rating: %s [%s]'),
(697, 1, 'products', 'no_review', 'There are no reviews for this product.'),
(698, 1, 'products', 'field_posted_on', 'Posted on'),
(699, 1, 'products', 'heading_write_review', 'Write Your Own Reviews'),
(700, 1, 'products', 'review_date_added', 'Date Added: %s'),
(701, 1, 'general', 'credit_card_number_error', 'The credit card number entered is invalid.<br />Please check the number and try again.'),
(702, 1, 'general', 'maximum_file_upload_size', '(Max: %s)'),
(703, 1, 'general', 'field_concat_captcha_check_error', 'ERROR: Please specify the correct captcha text'),
(704, 1, 'general', 'field_customer_name_error', 'ERROR: Please specify the name'),
(705, 1, 'general', 'field_customer_concat_email_error', 'ERROR: Please specify the correct customer e-mail'),
(706, 1, 'general', 'field_departments_email_error', 'ERROR: Please specify the correct department e-mail address'),
(707, 1, 'general', 'field_customer_name_required', 'ERROR: Please specify the name'),
(708, 1, 'general', 'field_enquiry_error', 'ERROR: Please specify the enquiry'),
(709, 1, 'general', 'field_telephone_error', 'ERROR: Please specify the telephone'),
(710, 1, 'modules-boxes', 'box_articles_categories_heading', 'Article Categories'),
(711, 1, 'modules-boxes', 'box_best_sellers_heading', 'Best Sellers'),
(712, 1, 'modules-boxes', 'box_categories_heading', 'Categories'),
(713, 1, 'modules-boxes', 'box_ordering_steps_heading', 'Ordering Steps'),
(714, 1, 'modules-boxes', 'box_ordering_steps_delivery', 'Shipping Information'),
(715, 1, 'modules-boxes', 'box_ordering_steps_payment', 'Payment Information'),
(716, 1, 'modules-boxes', 'box_ordering_steps_confirmation', 'Confirmation'),
(717, 1, 'modules-boxes', 'box_ordering_steps_complete', 'Finished!'),
(718, 1, 'modules-boxes', 'box_compare_products_heading', 'Compare Products'),
(719, 1, 'modules-boxes', 'box_currencies_heading', 'Currencies'),
(720, 1, 'modules-boxes', 'box_faqs_heading', 'FAQs'),
(721, 1, 'modules-boxes', 'box_guest_book_heading', 'Guest Book'),
(722, 1, 'modules-boxes', 'box_information_heading', 'Information'),
(723, 1, 'modules-boxes', 'box_information_privacy', 'Privacy Notice'),
(724, 1, 'modules-boxes', 'box_information_conditions', 'Conditions of Use'),
(725, 1, 'modules-boxes', 'box_information_shipping', 'Shipping and Returns'),
(726, 1, 'modules-boxes', 'box_information_contact', 'Contact Us'),
(727, 1, 'modules-boxes', 'box_information_sitemap', 'Sitemap'),
(728, 1, 'modules-boxes', 'box_languages_heading', 'Languages'),
(729, 1, 'modules-boxes', 'box_lastest_news_heading', 'Lastest News'),
(730, 1, 'modules-boxes', 'box_manufacturer_info_heading', 'Manufacturer Info'),
(731, 1, 'modules-boxes', 'box_manufacturer_info_website', 'Visit %s''s website'),
(732, 1, 'modules-boxes', 'box_manufacturer_info_products', 'View all products'),
(733, 1, 'modules-boxes', 'box_manufacturers_heading', 'Manufacturers'),
(734, 1, 'modules-boxes', 'box_order_history_heading', 'Order History'),
(735, 1, 'modules-boxes', 'box_polls_heading', 'Polls'),
(736, 1, 'modules-boxes', 'box_polls_one_vote_per_ip_error', 'Error: Only one vote per IP is allowed for a poll.'),
(737, 1, 'modules-boxes', 'box_polls_votes', 'votes'),
(738, 1, 'modules-boxes', 'box_popular_search_terms_tag_cloud_heading', 'Popular Search Terms'),
(739, 1, 'modules-boxes', 'box_product_notifications_heading', 'Product Notifications'),
(740, 1, 'modules-boxes', 'box_product_notifications_add', 'Notify me of updates to %s'),
(741, 1, 'modules-boxes', 'box_product_notifications_remove', 'Remove my notifications to %s'),
(742, 1, 'modules-boxes', 'box_products_scroller_heading', 'Products Scroller'),
(743, 1, 'modules-content', 'products_scroller_new_products_title', 'New Products'),
(744, 1, 'modules-content', 'products_scroller_special_products_title', 'Special Products'),
(745, 1, 'modules-content', 'products_scroller_best_sellers_title', 'Best Sellers'),
(746, 1, 'modules-boxes', 'box_reviews_heading', 'Reviews'),
(747, 1, 'modules-boxes', 'box_reviews_write', 'Write a review on this product!'),
(748, 1, 'modules-boxes', 'box_reviews_stars_rating', '%s of 5 Stars!'),
(749, 1, 'modules-boxes', 'box_search_heading', 'Search'),
(750, 1, 'modules-boxes', 'box_search_text', '(try our <a href="%s">advanced search</a>)'),
(751, 1, 'modules-boxes', 'box_shop_by_price_heading', 'Shop By Price'),
(752, 1, 'modules-boxes', 'box_shopping_cart_heading', 'Shopping Cart'),
(753, 1, 'modules-boxes', 'box_shopping_cart_empty', '0 items'),
(754, 1, 'modules-boxes', 'box_shopping_cart_subtotal', 'Sub-Total:'),
(755, 1, 'modules-boxes', 'box_specials_heading', 'Specials'),
(756, 1, 'modules-boxes', 'box_tell_a_friend_heading', 'Tell a Friend'),
(757, 1, 'modules-boxes', 'box_tell_a_friend_text', 'Tell someone you know about this product.'),
(758, 1, 'modules-boxes', 'box_templates_heading', 'Templates'),
(759, 1, 'modules-boxes', 'box_whats_new_heading', 'New Products'),
(760, 1, 'modules-content', 'customers_also_purchased_title', 'Customers Who Purchased This Product Also Purchased'),
(761, 1, 'modules-content', 'feature_products_title', 'Feature Products'),
(762, 1, 'modules-content', 'box_guestbook_heading', 'Guest Book'),
(763, 1, 'modules-content', 'box_list_guest_book_heading', 'All Guest Books'),
(764, 1, 'modules-content', 'box_guest_book_info_heading', 'Guest Book Info'),
(765, 1, 'modules-content', 'image_menu_show_title', 'Image Menu'),
(766, 1, 'modules-content', 'new_products_title', 'New Products'),
(767, 1, 'modules-content', 'products_slider_title', 'Products Slider'),
(768, 1, 'modules-content', 'products_slider_new_products_title', 'New Products'),
(769, 1, 'modules-content', 'products_slider_special_products_title', 'Special Products'),
(770, 1, 'modules-content', 'products_slider_best_sellers_title', 'Best Sellers'),
(771, 1, 'modules-content', 'recently_visited_title', 'Your Recent History'),
(772, 1, 'modules-content', 'recently_visited_products_title', 'Recently Visited Products'),
(773, 1, 'modules-content', 'recently_visited_categories_title', 'Recent Categories'),
(774, 1, 'modules-content', 'recently_visited_searches_title', 'Recent Searches'),
(775, 1, 'modules-content', 'recently_visited_item_in_category', 'in %s'),
(776, 1, 'modules-content', 'slide_show_title', 'Slideshow'),
(777, 1, 'modules-content', 'upcoming_products_title', 'Upcoming Products'),
(778, 1, 'modules-content', 'xsell_products_title', 'Cross Sell Products'),
(779, 1, 'modules-order_total', 'order_total_cod_title', 'Cash on Delivery Fee'),
(780, 1, 'modules-order_total', 'order_total_cod_description', 'Cash on Delivery Fee'),
(781, 1, 'modules-order_total', 'order_total_coupon_title', 'Coupon'),
(782, 1, 'modules-order_total', 'order_total_coupon_description', 'Coupon'),
(783, 1, 'modules-order_total', 'order_total_gift_certificate_title', 'Gift Certificate'),
(784, 1, 'modules-order_total', 'order_total_gift_certificate_description', 'Gift Certificate'),
(785, 1, 'modules-order_total', 'order_total_gift_wrapping_title', 'Gift Wrapping'),
(786, 1, 'modules-order_total', 'order_total_gift_wrapping_description', 'Gift Wrapping'),
(787, 1, 'modules-order_total', 'gift_wrapping_heading', 'Gift Wrapping'),
(788, 1, 'modules-order_total', 'gift_wrapping_description', 'Please click the checkbox to have your item(s) gift-wrapped. It will cost additional %s.'),
(789, 1, 'modules-order_total', 'order_total_loworderfee_title', 'Low Order Fee'),
(790, 1, 'modules-order_total', 'order_total_loworderfee_description', 'Low Order Fee'),
(791, 1, 'modules-order_total', 'order_total_shipping_title', 'Shipping'),
(792, 1, 'modules-order_total', 'order_total_shipping_description', 'Order Shipping Cost'),
(793, 1, 'modules-order_total', 'order_total_store_credit_title', 'Store Credit'),
(794, 1, 'modules-order_total', 'order_total_store_credit_description', 'Store Credit'),
(795, 1, 'modules-order_total', 'order_total_subtotal_title', 'Sub-Total'),
(796, 1, 'modules-order_total', 'order_total_subtotal_description', 'Order Sub-Total'),
(797, 1, 'modules-order_total', 'order_total_tax_title', 'Tax'),
(798, 1, 'modules-order_total', 'order_total_tax_description', 'Order Tax'),
(799, 1, 'modules-order_total', 'order_total_total_title', 'Total'),
(800, 1, 'modules-order_total', 'order_total_total_description', 'Order Total'),
(801, 1, 'modules-payment', 'payment_amazon_title', 'Amazon IPN'),
(802, 1, 'modules-payment', 'payment_amazon_description', 'Amazon IPN'),
(803, 1, 'modules-payment', 'payment_amazon_method_title', 'Amazon IPN'),
(804, 1, 'modules-payment', 'payment_authorizenet_cc_aim_title', 'Authorize.net Credit Card AIM'),
(805, 1, 'modules-payment', 'payment_authorizenet_cc_aim_method_title', 'Credit Card (Processed by Authorize.net AIM)'),
(806, 1, 'modules-payment', 'payment_authorizenet_cc_aim_description', '<img src="images/icon_popup.gif" border="0">&nbsp;<a href="https://www.authorize.net" target="_blank" style="text-decoration: underline; font-weight: bold;">Visit Authorize.net Website</a>'),
(807, 1, 'modules-payment', 'payment_authorizenet_cc_aim_credit_card_owner', 'Credit Card Owner:'),
(808, 1, 'modules-payment', 'payment_authorizenet_cc_aim_credit_card_number', 'Credit Card Number:'),
(809, 1, 'modules-payment', 'payment_authorizenet_cc_aim_credit_card_expires', 'Credit Card Expiry Date:'),
(810, 1, 'modules-payment', 'payment_authorizenet_cc_aim_credit_card_cvc', 'Credit Card Check Number (CVC):'),
(811, 1, 'modules-payment', 'payment_authorizenet_cc_aim_js_credit_card_not_accepted', '* This credit card type is not accepted. Please try again with another card or payment method.'),
(812, 1, 'modules-payment', 'payment_authorizenet_cc_aim_js_credit_card_cvc', '* The credit card check number (CVC) must be at least 3 characters.'),
(813, 1, 'modules-payment', 'payment_authorizenet_cc_aim_js_credit_card_number', '* The credit card number must be at least %s characters.'),
(814, 1, 'modules-payment', 'payment_authorizenet_cc_aim_error_title', 'There has been an error processing your credit card'),
(815, 1, 'modules-payment', 'payment_authorizenet_cc_aim_error_general', 'Please try again and if problems persist, please try another payment method.'),
(816, 1, 'modules-payment', 'payment_authorizenet_cc_aim_error_declined', 'This credit card transaction has been declined. Please try again and if problems persist, please try another credit card or payment method.'),
(817, 1, 'modules-payment', 'payment_authorizenet_cc_aim_error_invalid_exp_date', 'The credit card expiration date is invalid. Please check the card information and try again.'),
(818, 1, 'modules-payment', 'payment_authorizenet_cc_aim_error_expired', 'The credit card has expired. Please try again with another card or payment method.'),
(819, 1, 'modules-payment', 'payment_authorizenet_cc_aim_error_cvc', 'The credit card check number (CVC) is invalid. Please check the card information and try again.'),
(820, 1, 'modules-payment', 'payment_authorizenet_cc_aim_error_not_accepted', 'This credit card type is not accepted. Please try again with another card or payment method.'),
(821, 1, 'modules-payment', 'payment_authorizenet_cc_sim_title', 'Authorize.net Credit Card SIM'),
(822, 1, 'modules-payment', 'payment_authorizenet_cc_sim_method_title', 'Credit Card (Processed by Authorize.net SIM)'),
(823, 1, 'modules-payment', 'payment_authorizenet_cc_sim_error_title', 'There has been an error processing your credit card.'),
(824, 1, 'modules-payment', 'payment_authorizenet_cc_sim_error_verification', 'The credit card transaction could not be verified with this order. Please try again and if problems persist, please try another payment method.'),
(825, 1, 'modules-payment', 'payment_authorizenet_cc_sim_error_declined', 'This credit card transaction has been declined. Please try again and if problems persist, please try another payment method.'),
(826, 1, 'modules-payment', 'payment_authorizenet_cc_sim_error_general', 'Please try again and if problems persist, please try another payment method.'),
(827, 1, 'modules-payment', 'payment_authorizenet_cc_sim_error_ajax_valid', 'Note that if you see the url in the web browser is test.authorize.net/gateway/transact.dll, it means you are still on the authorize.net gateway server. Otherwise, you are redirected to the merchine site. And, if you are on the authorize.net server, this page is generated by the merchant web server. For the security, authorize.net can not send the ajax request to the merchant site. So, the ajax shopping cart and checkout form is empty. Please click the checkout menu to try the payment again.'),
(828, 1, 'modules-payment', 'payment_bank_wire_title', 'Bank Wire'),
(829, 1, 'modules-payment', 'payment_bank_wire_description', 'Bank Wire'),
(830, 1, 'modules-payment', 'payment_bank_wire_method_title', 'Bank Wire'),
(831, 1, 'modules-payment', 'payment_bank_wire_bank_account_owner', 'Account Owner'),
(832, 1, 'modules-payment', 'payment_bank_wire_bank_detail', 'Bank Detail'),
(833, 1, 'modules-payment', 'payment_bank_wire_bank_address', 'Bank Address'),
(834, 1, 'modules-payment', 'payment_cc_title', 'Credit Card'),
(835, 1, 'modules-payment', 'payment_cc_description', 'Credit Card Test Info:<br /><br />CC#: 4111111111111111<br />Expiry: Any'),
(836, 1, 'modules-payment', 'payment_cc_method_title', 'Credit Card'),
(837, 1, 'modules-payment', 'payment_cc_credit_card_owner', 'Credit Card Owner:'),
(838, 1, 'modules-payment', 'payment_cc_credit_card_number', 'Credit Card Number:'),
(839, 1, 'modules-payment', 'payment_cc_credit_card_expiry_date', 'Credit Card Expiry Date:'),
(840, 1, 'modules-payment', 'payment_cc_js_credit_card_owner', '* The owner''s name of the credit card must be at least %s characters.'),
(841, 1, 'modules-payment', 'payment_cc_js_credit_card_number', '* The credit card number must be at least %s characters.'),
(842, 1, 'modules-payment', 'payment_cc_js_credit_card_not_accepted', '* This credit card type is not accepted. Please try again with another card or payment method.'),
(843, 1, 'modules-payment', 'payment_cc_error_general', 'There was a problem processing this credit card. Please check the card information and try again.'),
(844, 1, 'modules-payment', 'payment_cc_error_not_accepted', 'This credit card type is not accepted. Please try again with another card or payment method.'),
(845, 1, 'modules-payment', 'payment_cc_error_invalid_expiration_date', 'The credit card expiration date is invalid. Please check the card information and try again.'),
(846, 1, 'modules-payment', 'payment_cc_error_expired', 'The credit card has expired. Please try again with another card or payment method.'),
(847, 1, 'modules-payment', 'payment_cc_error_unknown_card', 'This is an unknown credit card which cannot be processed. Please try again with another card or payment method.'),
(848, 1, 'modules-payment', 'payment_cheque_title', 'Cheque'),
(849, 1, 'modules-payment', 'payment_cheque_description', 'Cheque'),
(850, 1, 'modules-payment', 'payment_cheque_method_title', 'Cheque'),
(851, 1, 'modules-payment', 'payment_cheque_account_owner', 'To the order of'),
(852, 1, 'modules-payment', 'payment_cheque_address', 'Address'),
(853, 1, 'modules-payment', 'payment_chronopay_title', 'ChronoPay'),
(854, 1, 'modules-payment', 'payment_chronopay_description', 'ChronoPay'),
(855, 1, 'modules-payment', 'payment_chronopay_method_title', 'Credit Card'),
(856, 1, 'modules-payment', 'payment_cod_title', 'Cash on Delivery'),
(857, 1, 'modules-payment', 'payment_cod_description', 'Cash on Delivery'),
(858, 1, 'modules-payment', 'payment_cod_method_title', 'Cash on Delivery'),
(859, 1, 'modules-payment', 'payment_eway_title', 'eWAY Payment Credit Card'),
(860, 1, 'modules-payment', 'payment_eway_description', 'eWAY Payment Credit Card'),
(861, 1, 'modules-payment', 'payment_eway_method_title', 'eWAY Payment Credit Card'),
(862, 1, 'modules-payment', 'payment_eway_au_title', 'eWAY Payment'),
(863, 1, 'modules-payment', 'payment_eway_au_description', 'eWAY Payment'),
(864, 1, 'modules-payment', 'payment_eway_au_method_title', 'eWAY Payment'),
(865, 1, 'modules-payment', 'payment_eway_au_credit_card_owner', 'Credit Card Owner:'),
(866, 1, 'modules-payment', 'payment_eway_au_credit_card_number', 'Credit Card Number:'),
(867, 1, 'modules-payment', 'payment_eway_au_credit_card_expiry_date', 'Credit Card Expiry Date:'),
(868, 1, 'modules-payment', 'payment_eway_au_credit_card_cvv', 'CVV Number:'),
(869, 1, 'modules-payment', 'payment_eway_eu_js_credit_card_owner', '* The owner''s name of the credit card must be at least %s characters.'),
(870, 1, 'modules-payment', 'payment_eway_eu_js_credit_card_number', '* The credit card number must be at least %s characters.'),
(871, 1, 'modules-payment', 'payment_eway_eu_cc_js_credit_card_cvc', '* The credit card check number (CVC) must be at least 3 characters.'),
(872, 1, 'modules-payment', 'payment_inpay_title', 'Inpay - instant online bank transfers'),
(873, 1, 'modules-payment', 'payment_inpay_method_title', 'Pay with your online bank - instant and 100% secure'),
(874, 1, 'modules-payment', 'payment_ipayment_title', 'iPayment'),
(875, 1, 'modules-payment', 'payment_ipayment_description', 'Credit Card Test Info:<br /><br />CC#: 4111111111111111<br />Expiry: Any'),
(876, 1, 'modules-payment', 'payment_ipayment_error_heading', 'There has been an error processing your credit card'),
(877, 1, 'modules-payment', 'payment_ipayment_error_message', 'Please check your credit card details!'),
(878, 1, 'modules-payment', 'payment_ipayment_credit_card_owner', 'Credit Card Owner:'),
(879, 1, 'modules-payment', 'payment_ipayment_credit_card_number', 'Credit Card Number:'),
(880, 1, 'modules-payment', 'payment_ipayment_credit_card_expiry_date', 'Credit Card Expiry Date:'),
(881, 1, 'modules-payment', 'payment_ipayment_credit_card_checknumber', 'Credit Card Checknumber:'),
(882, 1, 'modules-payment', 'payment_ipayment_credit_card_checknumber_location', '(located at the back of the credit card)'),
(883, 1, 'modules-payment', 'payment_ipayment_js_credit_card_owner', '* The owner''s name of the credit card must be at least %s characters.'),
(884, 1, 'modules-payment', 'payment_ipayment_js_credit_card_number', '* The credit card number must be at least %s characters.'),
(885, 1, 'modules-payment', 'payment_ipayment_credit_card_type', 'Credit Card Type:'),
(886, 1, 'modules-payment', 'payment_moneybookers_title', 'Moneybookers'),
(887, 1, 'modules-payment', 'payment_moneybookers_description', 'Moneybookers'),
(888, 1, 'modules-payment', 'payment_moneybookers_method_title', 'Moneybookers'),
(889, 1, 'modules-payment', 'payment_moneybookers_email', 'Email'),
(890, 1, 'modules-payment', 'payment_moneyorder_title', 'Check/Money Order'),
(891, 1, 'modules-payment', 'payment_moneyorder_description', 'Make Payable To:&nbsp;%s<br /><br />Send To:<br />%s<br /><br />Your order will not ship until we receive payment.'),
(892, 1, 'modules-payment', 'payment_moneyorder_email_footer', 'Make Payable To: %s\n\nSend To:\n%\n\nYour order will not ship until we receive payment.'),
(893, 1, 'modules-payment', 'payment_nochex_title', 'NOCHEX'),
(894, 1, 'modules-payment', 'payment_nochex_method_title', 'NoChex'),
(895, 1, 'modules-payment', 'payment_nochex_description', 'NOCHEX<br />Requires the GBP currency.'),
(896, 1, 'modules-payment', 'payment_ogone_directlink_cc_title', 'Ogone DirectLink Credit Card'),
(897, 1, 'modules-payment', 'payment_ogone_directlink_cc_description', 'Ogone DirectLink Credit Card Transactions'),
(898, 1, 'modules-payment', 'payment_ogone_directlink_cc_method_title', 'Credit Card'),
(899, 1, 'modules-payment', 'payment_ogone_directlink_cc_credit_card_owner', 'Credit Card Owner:'),
(900, 1, 'modules-payment', 'payment_ogone_directlink_cc_credit_card_number', 'Credit Card Number:'),
(901, 1, 'modules-payment', 'payment_ogone_directlink_cc_credit_card_expiry_date', 'Credit Card Expiry Date:'),
(902, 1, 'modules-payment', 'payment_ogone_directlink_cc_credit_card_cvc', 'Credit Card Check Number (CVC):'),
(903, 1, 'modules-payment', 'payment_ogone_directlink_cc_js_credit_card_owner', '* The owner''s name of the credit card must be at least %s characters.'),
(904, 1, 'modules-payment', 'payment_ogone_directlink_cc_js_credit_card_number', '* The credit card number must be at least %s characters.'),
(905, 1, 'modules-payment', 'payment_ogone_directlink_cc_js_credit_card_not_accepted', '* This credit card type is not accepted. Please try again with another card or payment method.'),
(906, 1, 'modules-payment', 'payment_ogone_directlink_cc_js_credit_card_cvc', '* The credit card check number (CVC) must be at least 3 characters.'),
(907, 1, 'modules-payment', 'payment_ogone_directlink_cc_error_general', 'There was a problem processing this credit card. Please check the card information and try again.'),
(908, 1, 'modules-payment', 'payment_ogone_directlink_cc_error_not_accepted', 'This credit card type is not accepted. Please try again with another card or payment method.'),
(909, 1, 'modules-payment', 'payment_paypal_direct_title', 'PayPal Website Payments Pro (US) Direct Payments'),
(910, 1, 'modules-payment', 'payment_paypal_direct_description', '<b>Note: PayPal requires the PayPal Express Checkout payment module to be enabled if this module is activated.</b><br /><br /><img src="images/icon_popup.gif" border="0">&nbsp;<a href="https://www.paypal.com/mrb/pal=PS2X9Q773CKG4" target="_blank" style="text-decoration: underline; font-weight: bold;">Visit PayPal Website</a>&nbsp;<a href="javascript:toggleDivBlock(\\''paypalDirectInfo\\'');">(info)</a><span id="paypalDirectInfo" style="display: none;"><br><i>Using the above link to signup at PayPal grants osCommerce a small financial bonus for referring a customer.</i></span>'),
(911, 1, 'modules-payment', 'payment_paypal_direct_method_title', 'Credit or Debit Card (Processed securely by PayPal)'),
(912, 1, 'modules-payment', 'payment_paypal_direct_card_owner', 'Card Owner:'),
(913, 1, 'modules-payment', 'payment_paypal_direct_card_type', 'Card Type:'),
(914, 1, 'modules-payment', 'payment_paypal_direct_card_number', 'Card Number:'),
(915, 1, 'modules-payment', 'payment_paypal_direct_card_valid_from', 'Card Valid From Date:'),
(916, 1, 'modules-payment', 'payment_paypal_direct_card_valid_from_info', '(if available)'),
(917, 1, 'modules-payment', 'payment_paypal_direct_card_expires', 'Card Expiry Date:'),
(918, 1, 'modules-payment', 'payment_paypal_direct_card_cvc', 'Card Security Code (CVV2):'),
(919, 1, 'modules-payment', 'payment_paypal_direct_card_issue_number', 'Card Issue Number:'),
(920, 1, 'modules-payment', 'payment_paypal_direct_card_issue_number_info', '(for Maestro and Solo cards only)'),
(921, 1, 'modules-payment', 'payment_paypal_direct_error_all_fields_required', 'Error: All payment information fields are required.'),
(922, 1, 'modules-payment', 'payment_paypal_express_title', 'PayPal Express Checkout'),
(923, 1, 'modules-payment', 'payment_paypal_express_description', 'PayPal Express Checkout'),
(924, 1, 'modules-payment', 'payment_paypal_express_method_title', 'PayPal Express (including Credit Cards and Debit Cards)'),
(925, 1, 'modules-payment', 'payment_paypal_express_button_title', 'Pay with PayPal Express Checkout'),
(926, 1, 'modules-payment', 'payment_paypal_express_error_title', 'Error generated by PayPal:'),
(927, 1, 'modules-payment', 'payment_paypal_express_text_button', 'Checkout with PayPal'),
(928, 1, 'modules-payment', 'payment_paypal_express_button', 'https://www.paypal.com/en_US/i/btn/btn_xpressCheckout.gif'),
(929, 1, 'modules-payment', 'payment_paypal_express_language_locale', 'en_US'),
(930, 1, 'modules-payment', 'payment_paypal_ipn_title', 'PayPal IPN'),
(931, 1, 'modules-payment', 'payment_paypal_ipn_description', 'PayPal IPN'),
(932, 1, 'modules-payment', 'payment_paypal_ipn_method_title', 'PayPal'),
(933, 1, 'modules-payment', 'payment_paypal_standard_title', 'PayPal Website Payments Standard'),
(934, 1, 'modules-payment', 'payment_paypal_standard_method_title', 'PayPal Website Payments Standard'),
(935, 1, 'modules-payment', 'payment_paypal_uk_direct_title', 'PayPal Website Payments Pro (UK) Direct Payments'),
(936, 1, 'modules-payment', 'payment_paypal_uk_direct_description', 'PayPal UK Direct'),
(937, 1, 'modules-payment', 'payment_paypal_uk_direct_method_title', 'PayPal UK Direct (including Credit Cards and Debit Cards)'),
(938, 1, 'modules-payment', 'payment_paypal_uk_direct_card_owner', 'Card Owner:'),
(939, 1, 'modules-payment', 'payment_paypal_uk_direct_card_type', 'Card Type:'),
(940, 1, 'modules-payment', 'payment_paypal_uk_direct_card_number', 'Card Number:'),
(941, 1, 'modules-payment', 'payment_paypal_uk_direct_card_valid_from', 'Card Valid From Date:'),
(942, 1, 'modules-payment', 'payment_paypal_uk_direct_card_valid_from_info', '(if available)'),
(943, 1, 'modules-payment', 'payment_paypal_uk_direct_card_expires', 'Card Expiry Date:'),
(944, 1, 'modules-payment', 'payment_paypal_uk_direct_card_cvc', 'Card Security Code (CVV2):'),
(945, 1, 'modules-payment', 'payment_paypal_uk_direct_card_issue_number', 'Card Issue Number:'),
(946, 1, 'modules-payment', 'payment_paypal_uk_direct_card_issue_number_info', '(for Maestro and Solo cards only)'),
(947, 1, 'modules-payment', 'payment_paypal_uk_direct_error_general', 'Error: A general problem has occurred with the transaction. Please try again.'),
(948, 1, 'modules-payment', 'payment_paypal_uk_direct_error_cfg_error', 'Error: Payment module configuration error. Please verify the login credentials.'),
(949, 1, 'modules-payment', 'payment_paypal_uk_direct_error_address', 'Error: A match of the Shipping Address City, State, and Postal Code failed. Please try again.'),
(950, 1, 'modules-payment', 'payment_paypal_uk_direct_error_all_fields_required', 'Error: All payment information fields are required.'),
(951, 1, 'modules-payment', 'payment_paypal_uk_direct_error_declined', 'Error: This transaction has been declined. Please try again.'),
(952, 1, 'modules-payment', 'payment_paypal_uk_direct_error_invalid_credit_card', 'Error: The provided credit card information is invalid. Please try again.'),
(953, 1, 'modules-payment', 'payment_paypal_uk_express_title', 'PayPal Website Payments Pro (UK) Express Checkout'),
(954, 1, 'modules-payment', 'payment_paypal_uk_express_description', 'PayPal UK Express'),
(955, 1, 'modules-payment', 'payment_paypal_uk_express_method_title', 'PayPal UK Express (including Credit Cards and Debit Cards)'),
(956, 1, 'modules-payment', 'payment_paypal_uk_express_error_cfg_error', 'Error: Payment module configuration error. Please verify the login credentials.'),
(957, 1, 'modules-payment', 'payment_paypal_uk_express_error_address', 'Error: A match of the Shipping Address City, State, and Postal Code failed. Please try again.'),
(958, 1, 'modules-payment', 'payment_paypal_uk_express_error_declined', 'Error: This transaction has been declined. Please try again.'),
(959, 1, 'modules-payment', 'payment_paypal_uk_express_error_express_disabled', 'Error: PayPal Express Checkout has been disabled for this merchant. Please contact PayPal Customer Service.'),
(960, 1, 'modules-payment', 'payment_paypal_uk_express_error_general', 'Error: A general problem has occurred with the transaction. Please try again.'),
(961, 1, 'modules-payment', 'payment_payquake_cc_title', 'PayQuake Credit Card'),
(962, 1, 'modules-payment', 'payment_payquake_cc_description', 'PayQuake Credit Card Transactions'),
(963, 1, 'modules-payment', 'payment_payquake_cc_method_title', 'Credit Card'),
(964, 1, 'modules-payment', 'payment_payquake_cc_credit_card_owner', 'Credit Card Owner:'),
(965, 1, 'modules-payment', 'payment_payquake_cc_credit_card_number', 'Credit Card Number:'),
(966, 1, 'modules-payment', 'payment_payquake_cc_credit_card_expiry_date', 'Credit Card Expiry Date:'),
(967, 1, 'modules-payment', 'payment_payquake_cc_credit_card_cvc', 'Credit Card Check Number (CVC):'),
(968, 1, 'modules-payment', 'payment_payquake_cc_js_credit_card_owner', '* The owner''s name of the credit card must be at least %s characters.'),
(969, 1, 'modules-payment', 'payment_payquake_cc_js_credit_card_number', '* The credit card number must be at least %s characters.'),
(970, 1, 'modules-payment', 'payment_payquake_cc_js_credit_card_not_accepted', '* This credit card type is not accepted. Please try again with another card or payment method.'),
(971, 1, 'modules-payment', 'payment_payquake_cc_js_credit_card_cvc', '* The credit card check number (CVC) must be at least 3 characters.'),
(972, 1, 'modules-payment', 'payment_payquake_cc_error_general', 'There was a problem processing this credit card. Please check the card information and try again.'),
(973, 1, 'modules-payment', 'payment_payquake_cc_error_not_accepted', 'This credit card type is not accepted. Please try again with another card or payment method.'),
(974, 1, 'modules-payment', 'payment_payquake_cc_error_invalid_expiry_date', 'The credit card expiration date is invalid. Please check the card information and try again.'),
(975, 1, 'modules-payment', 'payment_payquake_cc_error_expired', 'The credit card has expired. Please try again with another card or payment method.'),
(976, 1, 'modules-payment', 'payment_pm2checkout_title', '2CheckOut'),
(977, 1, 'modules-payment', 'payment_pm2checkout_description', 'Credit Cards and Alternatives'),
(978, 1, 'modules-payment', 'payment_pm2checkout_method_title', '2Checkout'),
(979, 1, 'modules-payment', 'payment_pm2checkout_text_error_message', 'There has been an error processing your credit card. Please try again.'),
(980, 1, 'modules-payment', 'payment_pm2checkout_text_warning_demo_mode', 'In Review: Transaction performed in demo mode.'),
(981, 1, 'modules-payment', 'payment_pm2checkout_text_warning_transaction_order', 'In Review: Transaction total did not match order total.'),
(982, 1, 'modules-payment', 'payment_psigate_title', 'PSiGate'),
(983, 1, 'modules-payment', 'payment_psigate_description', 'Credit Card Test Info:<br /><br />CC#: 4111111111111111<br />Expiry: Any'),
(984, 1, 'modules-payment', 'payment_psigate_credit_card_owner', 'Credit Card Owner:'),
(985, 1, 'modules-payment', 'payment_psigate_credit_card_number', 'Credit Card Number:'),
(986, 1, 'modules-payment', 'payment_psigate_credit_card_expiry_date', 'Credit Card Expiry Date:'),
(987, 1, 'modules-payment', 'payment_psigate_credit_card_type', 'Type:'),
(988, 1, 'modules-payment', 'payment_psigate_js_credit_card_number', '* The credit card number must be at least '' . CC_NUMBER_MIN_LENGTH . '' characters.\\n'),
(989, 1, 'modules-payment', 'payment_psigate_error_message', 'There has been an error processing your credit card. Please try again.'),
(990, 1, 'modules-payment', 'payment_psigate_error', 'Credit Card Error!'),
(991, 1, 'modules-payment', 'payment_saferpay_cc_title', 'Saferpay Credit Card'),
(992, 1, 'modules-payment', 'payment_saferpay_cc_description', 'Saferpay Credit Card Transactions'),
(993, 1, 'modules-payment', 'payment_saferpay_cc_method_title', 'Credit Card'),
(994, 1, 'modules-payment', 'payment_saferpay_cc_credit_card_owner', 'Credit Card Owner:'),
(995, 1, 'modules-payment', 'payment_saferpay_cc_credit_card_number', 'Credit Card Number:'),
(996, 1, 'modules-payment', 'payment_saferpay_cc_credit_card_expiry_date', 'Credit Card Expiry Date:'),
(997, 1, 'modules-payment', 'payment_saferpay_cc_credit_card_cvc', 'Credit Card Check Number (CVC):'),
(998, 1, 'modules-payment', 'payment_saferpay_cc_js_credit_card_owner', '* The owner''s name of the credit card must be at least %s characters.'),
(999, 1, 'modules-payment', 'payment_saferpay_cc_js_credit_card_number', '* The credit card number must be at least %s characters.'),
(1000, 1, 'modules-payment', 'payment_saferpay_cc_js_credit_card_not_accepted', '* This credit card type is not accepted. Please try again with another card or payment method.'),
(1001, 1, 'modules-payment', 'payment_saferpay_cc_js_credit_card_cvc', '* The credit card check number (CVC) must be at least 3 characters.'),
(1002, 1, 'modules-payment', 'payment_saferpay_cc_error_general', 'There was a problem processing this credit card. Please check the card information and try again.'),
(1003, 1, 'modules-payment', 'payment_saferpay_cc_error_not_accepted', 'This credit card type is not accepted. Please try again with another card or payment method.'),
(1004, 1, 'modules-payment', 'payment_saferpay_cc_error_62', 'The credit card expiration date is invalid. Please check the card information and try again.'),
(1005, 1, 'modules-payment', 'payment_saferpay_cc_error_63', 'The credit card has expired. Please try again with another card or payment method.'),
(1006, 1, 'modules-payment', 'payment_saferpay_cc_error_64', 'This is an unknown credit card which cannot be processed. Please try again with another card or payment method.'),
(1007, 1, 'modules-payment', 'payment_saferpay_elv_title', 'Saferpay Bank Transfer'),
(1008, 1, 'modules-payment', 'payment_saferpay_elv_description', 'Saferpay Bank Transfer Transactions'),
(1009, 1, 'modules-payment', 'payment_saferpay_elv_method_title', 'Bank Transfer'),
(1010, 1, 'modules-payment', 'payment_saferpay_elv_bank_owner', 'Account Owner Name:'),
(1011, 1, 'modules-payment', 'payment_saferpay_elv_bank_account_number', 'Account Number:'),
(1012, 1, 'modules-payment', 'payment_saferpay_elv_bank_code', 'Bank Code:'),
(1013, 1, 'modules-payment', 'payment_saferpay_elv_js_error', '* All fields required.'),
(1014, 1, 'modules-payment', 'payment_saferpay_elv_error_general', 'There was a problem processing this bank account. Please check the account information and try again.'),
(1015, 1, 'modules-payment', 'payment_saferpay_vt_title', 'Saferpay Virtual Terminal'),
(1016, 1, 'modules-payment', 'payment_saferpay_vt_description', 'Saferpay Virtual Terminal Transactions'),
(1017, 1, 'modules-payment', 'payment_saferpay_vt_method_title', 'Credit Card'),
(1018, 1, 'modules-payment', 'payment_saferpay_vt_error_general', 'There was a problem processing this order. Please check the billing information and try again.'),
(1019, 1, 'modules-payment', 'payment_sage_pay_form_title', 'Sage Pay Form'),
(1020, 1, 'modules-payment', 'payment_sage_pay_form_description', 'Sage Pay Form'),
(1021, 1, 'modules-payment', 'payment_sage_pay_form_method_title', 'Credit Card or Bank Card (Processed by Sage Pay)'),
(1022, 1, 'modules-payment', 'payment_sage_pay_form_error_general', 'Please try again and if problems persist, please try another payment method.'),
(1023, 1, 'modules-payment', 'payment_sage_pay_form_error_title', 'There has been an error processing your order transaction.'),
(1024, 1, 'modules-payment', 'payment_secpay_title', 'SECPay'),
(1025, 1, 'modules-payment', 'payment_secpay_description', 'Credit Card Test Info:<br /><br />CC#: 4444333322221111<br />Expiry: Any'),
(1026, 1, 'modules-payment', 'payment_secpay_error', 'Credit Card Error!'),
(1027, 1, 'modules-payment', 'payment_secpay_error_message', 'There has been an error processing your credit card. Please try again.'),
(1028, 1, 'modules-payment', 'payment_western_union_title', 'Western Union'),
(1029, 1, 'modules-payment', 'payment_western_union_description', 'Western Union'),
(1030, 1, 'modules-payment', 'payment_western_union_method_title', 'Western Union'),
(1031, 1, 'modules-payment', 'payment_western_union_owner_country', 'Country:'),
(1032, 1, 'modules-payment', 'payment_western_union_owner_city', 'City:'),
(1033, 1, 'modules-payment', 'payment_western_union_owner_name', 'Name:'),
(1034, 1, 'modules-payment', 'payment_western_union_owner_email', 'Email:'),
(1035, 1, 'modules-payment', 'payment_western_union_owner_telephone', 'Telephone:'),
(1036, 1, 'modules-payment', 'payment_wirecard_cc_title', 'Wire Card Credit Card'),
(1037, 1, 'modules-payment', 'payment_wirecard_cc_description', 'Wire Card Credit Card Transactions'),
(1038, 1, 'modules-payment', 'payment_wirecard_cc_method_title', 'Credit Card'),
(1039, 1, 'modules-payment', 'payment_wirecard_cc_credit_card_owner', 'Credit Card Owner:'),
(1040, 1, 'modules-payment', 'payment_wirecard_cc_credit_card_number', 'Credit Card Number:'),
(1041, 1, 'modules-payment', 'payment_wirecard_cc_credit_card_expiry_date', 'Credit Card Expiry Date:'),
(1042, 1, 'modules-payment', 'payment_wirecard_cc_credit_card_cvc', 'Credit Card Check Number (CVC):'),
(1043, 1, 'modules-payment', 'payment_wirecard_cc_js_credit_card_owner', '* The owner''s name of the credit card must be at least %s characters.'),
(1044, 1, 'modules-payment', 'payment_wirecard_cc_js_credit_card_number', '* The credit card number must be at least %s characters.'),
(1045, 1, 'modules-payment', 'payment_wirecard_cc_js_credit_card_not_accepted', '* This credit card type is not accepted. Please try again with another card or payment method.'),
(1046, 1, 'modules-payment', 'payment_wirecard_cc_js_credit_card_cvc', '* The credit card check number (CVC) must be at least 3 characters.'),
(1047, 1, 'modules-payment', 'payment_wirecard_cc_error_general', 'There was a problem processing this credit card. Please check the card information and try again.'),
(1048, 1, 'modules-payment', 'payment_wirecard_cc_error_not_accepted', 'This credit card type is not accepted. Please try again with another card or payment method.'),
(1049, 1, 'modules-payment', 'payment_wirecard_cc_error_20071', 'The credit card expiration date is invalid. Please check the card information and try again.'),
(1050, 1, 'modules-payment', 'payment_wirecard_cc_error_33', 'The credit card has expired. Please try again with another card or payment method.'),
(1051, 1, 'modules-payment', 'payment_wirecard_cc_error_unkown_card', 'This is an unknown credit card which cannot be processed. Please try again with another card or payment method.'),
(1052, 1, 'modules-payment', 'payment_wirecard_eft_title', 'Wire Card EFT'),
(1053, 1, 'modules-payment', 'payment_wirecard_eft_description', 'Wire Card EFT Transactions'),
(1054, 1, 'modules-payment', 'payment_wirecard_eft_method_title', 'Bank Transfer'),
(1055, 1, 'modules-payment', 'payment_wirecard_eft_bank_owner', 'Account Owner Name:'),
(1056, 1, 'modules-payment', 'payment_wirecard_eft_bank_owner_firstname', 'Account Owner First Name:'),
(1057, 1, 'modules-payment', 'payment_wirecard_eft_bank_owner_lastname', 'Account Owner Last Name:'),
(1058, 1, 'modules-payment', 'payment_wirecard_eft_account_type', 'Account Type:'),
(1059, 1, 'modules-payment', 'payment_wirecard_eft_account_type_checking', 'Checking'),
(1060, 1, 'modules-payment', 'payment_wirecard_eft_account_type_savings', 'Savings'),
(1061, 1, 'modules-payment', 'payment_wirecard_eft_bank_account_number', 'Account Number:'),
(1062, 1, 'modules-payment', 'payment_wirecard_eft_bank_code', 'Bank Code:'),
(1063, 1, 'modules-payment', 'payment_wirecard_eft_check_number', 'Check Number:'),
(1064, 1, 'modules-payment', 'payment_wirecard_eft_id_number', 'Identification Number:'),
(1065, 1, 'modules-payment', 'payment_wirecard_eft_js_error', '* All fields required.'),
(1066, 1, 'modules-payment', 'payment_wirecard_eft_error_general', 'There was a problem processing this bank account. Please check the account information and try again.'),
(1067, 1, 'modules-shipping', 'shipping_flat_title', 'Flat Rate'),
(1068, 1, 'modules-shipping', 'shipping_flat_description', 'Flat Rate'),
(1069, 1, 'modules-shipping', 'shipping_flat_method', 'Best Way'),
(1070, 1, 'modules-shipping', 'shipping_free_title', 'Free Shipping'),
(1071, 1, 'modules-shipping', 'shipping_free_description', 'Free Shipping'),
(1072, 1, 'modules-shipping', 'shipping_free_for_amount', 'for orders over %s'),
(1073, 1, 'modules-shipping', 'shipping_item_title', 'Per Item'),
(1074, 1, 'modules-shipping', 'shipping_item_description', 'Per Item'),
(1075, 1, 'modules-shipping', 'shipping_item_method', 'Best Way'),
(1076, 1, 'modules-shipping', 'shipping_self_pickup_title', 'Self Pickup'),
(1077, 1, 'modules-shipping', 'shipping_self_pickup_description', 'Self Pickup'),
(1078, 1, 'modules-shipping', 'shipping_self_pickup_method', 'Best Way'),
(1079, 1, 'modules-shipping', 'shipping_table_title', 'Table Rate'),
(1080, 1, 'modules-shipping', 'shipping_table_description', 'Table Rate'),
(1081, 1, 'modules-shipping', 'shipping_table_method', 'Best Way'),
(1082, 1, 'modules-shipping', 'shipping_ups_title', 'United Parcel Service'),
(1083, 1, 'modules-shipping', 'shipping_ups_description', 'United Parcel Service.'),
(1084, 1, 'modules-shipping', 'shipping_usps_title', 'United States Postal Service (USPS)'),
(1085, 1, 'modules-shipping', 'shipping_usps_description', 'United States Postal Service<br /><br />You will need to have registered an account with USPS at http://www.uspsprioritymail.com/et_regcert.html to use this module<br /><br />USPS expects you to use pounds as weight measure for your products.'),
(1086, 1, 'modules-shipping', 'shipping_usps_error', 'An error occured with the USPS shipping calculations.<br />If you prefer to use USPS as your shipping method, please contact the store owner.'),
(1087, 1, 'modules-shipping', 'shipping_usps_status_text', 'Enable USPS Shipping'),
(1088, 1, 'modules-shipping', 'shipping_usps_status_description', 'Do you want to offer USPS shipping?'),
(1089, 1, 'modules-shipping', 'shipping_usps_user_id_text', '* User ID'),
(1090, 1, 'modules-shipping', 'shipping_usps_user_id_description', 'Enter the USPS USERID assigned to you'),
(1091, 1, 'modules-shipping', 'shipping_usps_user_password_text', 'User Password(Optional)'),
(1092, 1, 'modules-shipping', 'shipping_usps_user_password_description', 'Enter the USPS USER PASSWORD assigned to you.');
INSERT INTO `[[dbprefix]]languages_definitions` VALUES
(1093, 1, 'modules-shipping', 'shipping_usps_zip_code_text', '* Zip Code:'),
(1094, 1, 'modules-shipping', 'shipping_usps_zip_code_description', 'Enter the Origination Zip code. It must be valid.'),
(1095, 1, 'modules-shipping', 'shipping_usps_domestic_services_text', 'Domestic Services:'),
(1096, 1, 'modules-shipping', 'shipping_usps_international_services_text', 'International Services:'),
(1097, 1, 'modules-shipping', 'shipping_usps_size_text', 'Size:'),
(1098, 1, 'modules-shipping', 'shipping_usps_container_text', 'Container:'),
(1099, 1, 'modules-shipping', 'shipping_usps_machinable_text', 'Machinable:'),
(1100, 1, 'modules-shipping', 'shipping_usps_dimensions_width_text', 'Dimensions Width:'),
(1101, 1, 'modules-shipping', 'shipping_usps_dimensions_width_description', 'Average package dimensions width for shipping package.'),
(1102, 1, 'modules-shipping', 'shipping_usps_dimensions_height_text', 'Dimensions Height:'),
(1103, 1, 'modules-shipping', 'shipping_usps_dimensions_height_description', 'Average package dimensions height for shipping package.'),
(1104, 1, 'modules-shipping', 'shipping_usps_dimensions_length_text', 'Dimensions Length:'),
(1105, 1, 'modules-shipping', 'shipping_usps_dimensions_length_description', 'Average package dimensions length for shipping package.'),
(1106, 1, 'modules-shipping', 'shipping_usps_girth_text', 'Girth:'),
(1107, 1, 'modules-shipping', 'shipping_usps_girth_description', 'To find the girth of your package, measure the distance around the thickest part of the non-rectangular package'),
(1108, 1, 'modules-shipping', 'shipping_usps_display_delivery_time_text', 'Display Delivery Time:'),
(1109, 1, 'modules-shipping', 'shipping_usps_display_delivery_time_description', 'Do you want to display the shipping time? (e.g. Ships within 3 to 5 days)'),
(1110, 1, 'modules-shipping', 'shipping_usps_display_delivery_weight_text', 'Display Delivery Weight:'),
(1111, 1, 'modules-shipping', 'shipping_usps_display_delivery_weight_description', 'Do you want to display the shipping weight? (e.g. Delivery Weight : 2.7674 Kg\\''s)'),
(1112, 1, 'modules-shipping', 'shipping_usps_weight_class_text', 'Weight Classes:'),
(1113, 1, 'modules-shipping', 'shipping_usps_weight_class_description', 'Must be set to Pound.'),
(1114, 1, 'modules-shipping', 'shipping_usps_server_mode_text', 'Server Mode:'),
(1115, 1, 'modules-shipping', 'shipping_usps_server_mode_description', 'With Testing mode to test the API'),
(1116, 1, 'modules-shipping', 'shipping_usps_debug_email_text', 'Debug Email:'),
(1117, 1, 'modules-shipping', 'shipping_usps_debug_email_description', 'Send request data and recv data from usps api server to the debug email'),
(1118, 1, 'modules-shipping', 'shipping_usps_handling_fee_text', 'Handling Fee'),
(1119, 1, 'modules-shipping', 'shipping_usps_handling_fee_description', 'Handling fee for this shipping method.'),
(1120, 1, 'modules-shipping', 'shipping_usps_tax_classes_text', 'Tax Class'),
(1121, 1, 'modules-shipping', 'shipping_usps_tax_classes_description', 'Use the following tax class on the shipping fee.'),
(1122, 1, 'modules-shipping', 'shipping_usps_zone_text', 'Shipping Zone'),
(1123, 1, 'modules-shipping', 'shipping_usps_zone_description', 'If a zone is selected, only enable this shipping method for that zone.'),
(1124, 1, 'modules-shipping', 'shipping_usps_sort_order_text', 'Sort Order'),
(1125, 1, 'modules-shipping', 'shipping_usps_sort_order_description', 'Sort order of display.'),
(1126, 1, 'modules-shipping', 'shipping_usps_error', 'Sorry! We are unable to obtain a Shipping Cost value at this time due to a Communication Problem with USPS API Server. Please call the Store Owner at:'),
(1127, 1, 'modules-shipping', 'shipping_usps_debug_mode_text', 'Enable the debug mode'),
(1128, 1, 'modules-shipping', 'shipping_usps_debug_mode_description', 'Enable the debug mode to display the error from USPS in the checkout'),
(1129, 1, 'modules-shipping', 'shipping_usps_estimated_time', 'Estimated Time:'),
(1130, 1, 'modules-shipping', 'shipping_usps_weight_text', 'Weight:'),
(1131, 1, 'modules-shipping', 'shipping_zones_title', 'Zone Rates'),
(1132, 1, 'modules-shipping', 'shipping_zones_description', 'Zone Based Rates'),
(1133, 1, 'modules-shipping', 'shipping_zones_method', 'Shipping to'),
(1134, 1, 'modules-shipping', 'shipping_zones_invalid_zone', 'No shipping available to the selected country'),
(1135, 1, 'modules-shipping', 'shipping_zones_undefined_rate', 'The shipping rate cannot be determined at this time');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]manufacturers`
--

CREATE TABLE `[[dbprefix]]manufacturers` (
  `manufacturers_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_name` varchar(32) NOT NULL,
  `manufacturers_image` varchar(64) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`),
  KEY `IDX_MANUFACTURERS_NAME` (`manufacturers_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]manufacturers_info`
--

CREATE TABLE `[[dbprefix]]manufacturers_info` (
  `manufacturers_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `manufacturers_url` varchar(255) NOT NULL,
  `manufacturers_friendly_url` varchar(64) NOT NULL,
  `manufacturers_page_title` varchar(255) NOT NULL,
  `manufacturers_meta_keywords` varchar(255) NOT NULL,
  `manufacturers_meta_description` varchar(255) NOT NULL,
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletters`
--

CREATE TABLE `[[dbprefix]]newsletters` (
  `newsletters_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `module` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_sent` datetime DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `locked` int(1) DEFAULT '0',
  PRIMARY KEY (`newsletters_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletters_log`
--

CREATE TABLE `[[dbprefix]]newsletters_log` (
  `newsletters_id` int(11) NOT NULL,
  `email_address` varchar(255) NOT NULL,
  `date_sent` datetime DEFAULT NULL,
  KEY `IDX_NEWSLETTERS_LOG_NEWSLETTERS_ID` (`newsletters_id`),
  KEY `IDX_NEWSLETTERS_LOG_EMAIL_ADDRESS` (`email_address`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders`
--

CREATE TABLE `[[dbprefix]]orders` (
  `orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(10) DEFAULT NULL,
  `customers_id` int(11) NOT NULL,
  `customers_name` varchar(64) NOT NULL,
  `customers_company` varchar(32) DEFAULT NULL,
  `customers_street_address` varchar(64) NOT NULL,
  `customers_suburb` varchar(32) DEFAULT NULL,
  `customers_city` varchar(32) NOT NULL,
  `customers_postcode` varchar(10) NOT NULL,
  `customers_state` varchar(32) DEFAULT NULL,
  `customers_state_code` varchar(32) DEFAULT NULL,
  `customers_country` varchar(64) NOT NULL,
  `customers_country_iso2` char(2) NOT NULL,
  `customers_country_iso3` char(3) NOT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_email_address` varchar(96) NOT NULL,
  `customers_address_format` varchar(255) NOT NULL,
  `customers_ip_address` varchar(15) DEFAULT NULL,
  `delivery_name` varchar(64) NOT NULL,
  `delivery_company` varchar(32) DEFAULT NULL,
  `delivery_street_address` varchar(64) NOT NULL,
  `delivery_suburb` varchar(32) DEFAULT NULL,
  `delivery_city` varchar(32) NOT NULL,
  `delivery_postcode` varchar(10) NOT NULL,
  `delivery_state` varchar(32) DEFAULT NULL,
  `delivery_zone_id` int(11) NOT NULL,
  `delivery_state_code` varchar(32) DEFAULT NULL,
  `delivery_country_id` int(11) NOT NULL,
  `delivery_country` varchar(64) NOT NULL,
  `delivery_country_iso2` char(2) NOT NULL,
  `delivery_country_iso3` char(3) NOT NULL,
  `delivery_address_format` varchar(255) NOT NULL,
  `delivery_telephone` varchar(32) NOT NULL,
  `billing_name` varchar(64) NOT NULL,
  `billing_company` varchar(32) DEFAULT NULL,
  `billing_street_address` varchar(64) NOT NULL,
  `billing_suburb` varchar(32) DEFAULT NULL,
  `billing_city` varchar(32) NOT NULL,
  `billing_postcode` varchar(10) NOT NULL,
  `billing_state` varchar(32) DEFAULT NULL,
  `billing_zone_id` int(11) NOT NULL,
  `billing_state_code` varchar(32) DEFAULT NULL,
  `billing_country_id` int(11) NOT NULL,
  `billing_country` varchar(64) NOT NULL,
  `billing_country_iso2` char(2) NOT NULL,
  `billing_country_iso3` char(3) NOT NULL,
  `billing_address_format` varchar(255) NOT NULL,
  `billing_telephone` varchar(32) NOT NULL,
  `payment_method` varchar(255) NOT NULL,
  `payment_module` varchar(255) NOT NULL,
  `uses_store_credit` tinyint(1) NOT NULL,
  `store_credit_amount` decimal(15,4) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_purchased` datetime DEFAULT NULL,
  `orders_status` int(5) NOT NULL,
  `customers_comment` text,
  `admin_comment` text,
  `orders_date_finished` datetime DEFAULT NULL,
  `currency` char(3) DEFAULT NULL,
  `currency_value` decimal(14,6) DEFAULT NULL,
  `invoice_date` datetime DEFAULT NULL,
  `tracking_no` varchar(64) DEFAULT NULL,
  `gift_wrapping` tinyint(1) NOT NULL,
  `wrapping_message` text NOT NULL,
  PRIMARY KEY (`orders_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_products`
--

CREATE TABLE `[[dbprefix]]orders_products` (
  `orders_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  `products_type` int(4) NOT NULL DEFAULT '0',
  `products_sku` varchar(64) DEFAULT NULL,
  `products_name` varchar(255) NOT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `final_price` decimal(15,4) NOT NULL,
  `products_tax` decimal(7,4) NOT NULL,
  `products_quantity` int(2) NOT NULL,
  `products_return_quantity` int(2) NOT NULL,
  PRIMARY KEY (`orders_products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_products_customizations`
--

CREATE TABLE `[[dbprefix]]orders_products_customizations` (
  `orders_products_customizations_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  PRIMARY KEY (`orders_products_customizations_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_products_customizations_values`
--

CREATE TABLE `[[dbprefix]]orders_products_customizations_values` (
  `orders_products_customizations_values_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_products_customizations_id` int(11) NOT NULL,
  `customization_fields_id` int(11) NOT NULL,
  `customization_fields_name` varchar(64) NOT NULL,
  `customization_fields_type` tinyint(1) NOT NULL,
  `customization_fields_value` varchar(255) NOT NULL,
  `cache_file_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`orders_products_customizations_values_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_products_download`
--

CREATE TABLE `[[dbprefix]]orders_products_download` (
  `orders_products_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `orders_products_filename` varchar(255) NOT NULL,
  `orders_products_cache_filename` varchar(255) NOT NULL,
  `download_maxdays` int(2) NOT NULL,
  `download_count` int(2) NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`orders_products_download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_products_variants`
--

CREATE TABLE `[[dbprefix]]orders_products_variants` (
  `orders_products_variants_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `products_variants_groups_id` int(11) NOT NULL,
  `products_variants_groups` varchar(32) NOT NULL,
  `products_variants_values_id` int(11) NOT NULL,
  `products_variants_values` varchar(32) NOT NULL,
  PRIMARY KEY (`orders_products_variants_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_refunds`
--

CREATE TABLE `[[dbprefix]]orders_refunds` (
  `orders_refunds_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_refunds_type` tinyint(1) NOT NULL,
  `orders_id` int(11) NOT NULL,
  `credit_slips_id` int(11) DEFAULT NULL,
  `sub_total` decimal(15,4) NOT NULL,
  `shipping` decimal(15,4) NOT NULL,
  `handling` decimal(15,4) NOT NULL,
  `refund_total` decimal(15,4) NOT NULL,
  `comments` text NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`orders_refunds_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_refunds_products`
--

CREATE TABLE `[[dbprefix]]orders_refunds_products` (
  `orders_refunds_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_refunds_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `products_quantity` int(11) NOT NULL,
  PRIMARY KEY (`orders_refunds_products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_returns`
--

CREATE TABLE `[[dbprefix]]orders_returns` (
  `orders_returns_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_returns_status_id` int(5) NOT NULL,
  `customers_comments` text,
  `admin_comments` text,
  `date_added` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`orders_returns_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_returns_products`
--

CREATE TABLE `[[dbprefix]]orders_returns_products` (
  `orders_returns_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `products_quantity` int(11) NOT NULL,
  PRIMARY KEY (`orders_returns_id`,`orders_products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_returns_status`
--

CREATE TABLE `[[dbprefix]]orders_returns_status` (
  `orders_returns_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `languages_id` int(11) NOT NULL,
  `orders_returns_status_name` varchar(100) NOT NULL,
  PRIMARY KEY (`orders_returns_status_id`,`languages_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]orders_returns_status`
--

INSERT INTO `[[dbprefix]]orders_returns_status` VALUES
(1, 1, 'Pending'),
(2, 1, 'Confirmed'),
(3, 1, 'Received'),
(4, 1, 'Return Authorized'),
(5, 1, 'Return Refunded(Credit Slip)'),
(6, 1, 'Return Refunded(Store Credit)'),
(7, 1, 'Return Rejected');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_status`
--

CREATE TABLE `[[dbprefix]]orders_status` (
  `orders_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `orders_status_name` varchar(32) NOT NULL,
  `public_flag` tinyint(1) NOT NULL DEFAULT '1',
  `downloads_flag` tinyint(1) NOT NULL DEFAULT '0',
  `returns_flag` tinyint(1) NOT NULL DEFAULT '0',
  `gift_certificates_flag` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`orders_status_id`,`language_id`),
  KEY `idx_orders_status_name` (`orders_status_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]orders_status`
--

INSERT INTO `[[dbprefix]]orders_status` VALUES
(1, 1, 'Pending', 1, 0, 0, 0),
(2, 1, 'Processing', 1, 0, 0, 0),
(3, 1, 'Preparing', 1, 0, 0, 0),
(4, 1, 'Partly Paid', 1, 0, 0, 0),
(5, 1, 'Paid', 1, 1, 0, 1),
(6, 1, 'Partly Delivered', 1, 1, 1, 1),
(7, 1, 'Delivered', 1, 1, 1, 1),
(8, 1, 'Cancelled', 1, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_status_history`
--

CREATE TABLE `[[dbprefix]]orders_status_history` (
  `orders_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_status_id` int(5) NOT NULL,
  `date_added` datetime NOT NULL,
  `customer_notified` int(1) DEFAULT '0',
  `comments` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  PRIMARY KEY (`orders_status_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_total`
--

CREATE TABLE `[[dbprefix]]orders_total` (
  `orders_total_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` varchar(255) NOT NULL,
  `value` decimal(15,4) NOT NULL,
  `class` varchar(32) NOT NULL,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`orders_total_id`),
  KEY `idx_orders_total_orders_id` (`orders_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_transactions_history`
--

CREATE TABLE `[[dbprefix]]orders_transactions_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orders_id` int(10) unsigned NOT NULL,
  `transaction_code` int(11) NOT NULL,
  `transaction_return_value` text NOT NULL,
  `transaction_return_status` int(11) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_orders_transactions_history_orders_id` (`orders_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders_transactions_status`
--

CREATE TABLE `[[dbprefix]]orders_transactions_status` (
  `id` int(10) unsigned NOT NULL,
  `language_id` int(10) unsigned NOT NULL,
  `status_name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`,`language_id`),
  KEY `idx_orders_transactions_status_name` (`status_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]orders_transactions_status`
--

INSERT INTO `[[dbprefix]]orders_transactions_status` VALUES
(1, 1, 'Authorize'),
(2, 1, 'Cancel'),
(3, 1, 'Approve'),
(4, 1, 'Inquiry');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]polls`
--

CREATE TABLE `[[dbprefix]]polls` (
  `polls_id` int(11) NOT NULL AUTO_INCREMENT,
  `polls_type` tinyint(1) NOT NULL,
  `polls_status` tinyint(1) NOT NULL,
  `votes_count` int(11) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`polls_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]polls_answers`
--

CREATE TABLE `[[dbprefix]]polls_answers` (
  `polls_answers_id` int(11) NOT NULL AUTO_INCREMENT,
  `polls_id` int(10) NOT NULL,
  `votes_count` int(10) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`polls_answers_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]polls_answers_description`
--

CREATE TABLE `[[dbprefix]]polls_answers_description` (
  `polls_answers_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `answers_title` varchar(255) NOT NULL,
  PRIMARY KEY (`polls_answers_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]polls_description`
--

CREATE TABLE `[[dbprefix]]polls_description` (
  `polls_id` int(11) NOT NULL,
  `polls_title` varchar(255) NOT NULL,
  `languages_id` int(11) NOT NULL,
  PRIMARY KEY (`polls_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]polls_votes`
--

CREATE TABLE `[[dbprefix]]polls_votes` (
  `polls_votes_id` int(11) NOT NULL AUTO_INCREMENT,
  `polls_id` int(11) NOT NULL,
  `polls_answers_id` int(11) NOT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `date_voted` datetime NOT NULL,
  `customers_ip_address` varchar(32) NOT NULL,
  PRIMARY KEY (`polls_votes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products`
--

CREATE TABLE `[[dbprefix]]products` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_type` int(4) NOT NULL DEFAULT '0',
  `products_quantity` int(4) NOT NULL DEFAULT '1',
  `products_moq` int(11) NOT NULL DEFAULT '1',
  `products_max_order_quantity` int(11) NOT NULL DEFAULT '-1',
  `products_price` decimal(15,4) NOT NULL,
  `products_sku` varchar(64) NOT NULL,
  `products_model` varchar(64) NOT NULL,
  `products_date_added` datetime NOT NULL,
  `products_last_modified` datetime DEFAULT NULL,
  `products_date_available` datetime DEFAULT NULL,
  `products_weight` decimal(5,2) NOT NULL,
  `products_weight_class` int(11) NOT NULL,
  `products_status` tinyint(1) NOT NULL,
  `products_tax_class_id` int(11) NOT NULL,
  `manufacturers_id` int(11) DEFAULT NULL,
  `products_ordered` int(11) NOT NULL DEFAULT '0',
  `quantity_discount_groups_id` int(11) DEFAULT NULL,
  `quantity_unit_class` int(11) NOT NULL,
  `order_increment` int(11) NOT NULL DEFAULT '1',
  `products_attributes_groups_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`products_id`),
  KEY `idx_products_date_added` (`products_date_added`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_accessories`
--

CREATE TABLE `[[dbprefix]]products_accessories` (
  `products_id` int(11) NOT NULL,
  `accessories_id` int(11) NOT NULL,
  PRIMARY KEY (`products_id`,`accessories_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_attachments`
--

CREATE TABLE `[[dbprefix]]products_attachments` (
  `attachments_id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(128) NOT NULL,
  `cache_filename` varchar(128) NOT NULL,
  PRIMARY KEY (`attachments_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_attachments_description`
--

CREATE TABLE `[[dbprefix]]products_attachments_description` (
  `attachments_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL DEFAULT '1',
  `attachments_name` varchar(128) NOT NULL,
  `attachments_description` text,
  PRIMARY KEY (`attachments_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_attachments_to_products`
--

CREATE TABLE `[[dbprefix]]products_attachments_to_products` (
  `attachments_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  PRIMARY KEY (`attachments_id`,`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_attributes`
--

CREATE TABLE `[[dbprefix]]products_attributes` (
  `products_id` int(11) NOT NULL,
  `products_attributes_values_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`products_id`,`products_attributes_values_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_attributes_groups`
--

CREATE TABLE `[[dbprefix]]products_attributes_groups` (
  `products_attributes_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_attributes_groups_name` varchar(100) NOT NULL,
  PRIMARY KEY (`products_attributes_groups_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_attributes_values`
--

CREATE TABLE `[[dbprefix]]products_attributes_values` (
  `products_attributes_values_id` int(11) NOT NULL,
  `products_attributes_groups_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `status` int(4) NOT NULL,
  `module` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`products_attributes_values_id`,`products_attributes_groups_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_description`
--

CREATE TABLE `[[dbprefix]]products_description` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_name` varchar(255) NOT NULL DEFAULT '',
  `products_short_description` text,
  `products_description` text,
  `products_keyword` varchar(64) DEFAULT NULL,
  `products_tags` varchar(255) DEFAULT NULL,
  `products_url` varchar(255) DEFAULT NULL,
  `products_friendly_url` varchar(255) DEFAULT NULL,
  `products_page_title` varchar(255) NOT NULL,
  `products_meta_keywords` varchar(255) NOT NULL,
  `products_meta_description` varchar(255) NOT NULL,
  `products_viewed` int(5) DEFAULT '0',
  PRIMARY KEY (`products_id`,`language_id`),
  KEY `products_name` (`products_name`),
  KEY `products_description_keyword` (`products_keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_downloadables`
--

CREATE TABLE `[[dbprefix]]products_downloadables` (
  `products_id` int(11) NOT NULL,
  `filename` varchar(100) NOT NULL,
  `cache_filename` varchar(100) NOT NULL,
  `sample_filename` varchar(100) NOT NULL,
  `cache_sample_filename` varchar(100) NOT NULL,
  `number_of_downloads` int(11) NOT NULL,
  `number_of_accessible_days` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_download_history`
--

CREATE TABLE `[[dbprefix]]products_download_history` (
  `products_download_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_products_download_id` int(11) NOT NULL,
  `download_date` datetime NOT NULL,
  `download_ip_address` varchar(15) NOT NULL,
  PRIMARY KEY (`products_download_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_frontpage`
--

CREATE TABLE `[[dbprefix]]products_frontpage` (
  `products_id` int(11) NOT NULL,
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_gift_certificates`
--

CREATE TABLE `[[dbprefix]]products_gift_certificates` (
  `products_id` int(11) NOT NULL,
  `gift_certificates_type` int(5) NOT NULL,
  `gift_certificates_amount_type` int(5) NOT NULL,
  `open_amount_min_value` decimal(15,4) NOT NULL,
  `open_amount_max_value` decimal(15,4) NOT NULL,
  PRIMARY KEY (`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_images`
--

CREATE TABLE `[[dbprefix]]products_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `image` varchar(255) NOT NULL,
  `default_flag` tinyint(1) NOT NULL,
  `sort_order` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `products_images_products_id` (`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_images_groups`
--

CREATE TABLE `[[dbprefix]]products_images_groups` (
  `id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `code` varchar(32) NOT NULL,
  `size_width` int(11) DEFAULT NULL,
  `size_height` int(11) DEFAULT NULL,
  `force_size` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]products_images_groups`
--

INSERT INTO `[[dbprefix]]products_images_groups` VALUES
(1, 1, 'Originals', 'originals', 0, 0, 0),
(2, 1, 'Thumbnails', 'thumbnails', 100, 80, 0),
(3, 1, 'Product Information Page', 'product_info', 240, 180, 0),
(4, 1, 'Large', 'large', 480, 360, 0),
(5, 1, 'Mini', 'mini', 55, 45, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_notifications`
--

CREATE TABLE `[[dbprefix]]products_notifications` (
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`products_id`,`customers_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_to_categories`
--

CREATE TABLE `[[dbprefix]]products_to_categories` (
  `products_id` int(11) NOT NULL,
  `categories_id` int(11) NOT NULL,
  PRIMARY KEY (`products_id`,`categories_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_variants`
--

CREATE TABLE `[[dbprefix]]products_variants` (
  `products_variants_id` int(11) NOT NULL AUTO_INCREMENT,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_images_id` int(11) DEFAULT NULL,
  `products_status` tinyint(1) NOT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `products_sku` varchar(64) NOT NULL,
  `products_model` varchar(255) NOT NULL,
  `products_quantity` int(4) NOT NULL,
  `products_weight` decimal(5,2) NOT NULL,
  `filename` varchar(100) NOT NULL,
  `cache_filename` varchar(100) NOT NULL,
  PRIMARY KEY (`products_variants_id`),
  KEY `idx_products_variants_products_id` (`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_variants_entries`
--

CREATE TABLE `[[dbprefix]]products_variants_entries` (
  `products_variants_entries_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_variants_id` int(11) NOT NULL,
  `products_variants_groups_id` int(11) NOT NULL,
  `products_variants_values_id` int(11) NOT NULL,
  PRIMARY KEY (`products_variants_entries_id`),
  KEY `idx_products_variants_groups_values_id` (`products_variants_id`,`products_variants_groups_id`,`products_variants_values_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_variants_groups`
--

CREATE TABLE `[[dbprefix]]products_variants_groups` (
  `products_variants_groups_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_variants_groups_name` varchar(32) NOT NULL DEFAULT '',
  `sort_order` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_variants_groups_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_variants_values`
--

CREATE TABLE `[[dbprefix]]products_variants_values` (
  `products_variants_values_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_variants_values_name` varchar(64) NOT NULL DEFAULT '',
  `sort_order` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_variants_values_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_variants_values_to_products_variants_groups`
--

CREATE TABLE `[[dbprefix]]products_variants_values_to_products_variants_groups` (
  `products_variants_values_to_products_variants_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_variants_groups_id` int(11) NOT NULL,
  `products_variants_values_id` int(11) NOT NULL,
  PRIMARY KEY (`products_variants_values_to_products_variants_groups_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_xsell`
--

CREATE TABLE `[[dbprefix]]products_xsell` (
  `products_id` int(10) unsigned NOT NULL DEFAULT '1',
  `xsell_products_id` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`products_id`,`xsell_products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quantity_discount_groups`
--

CREATE TABLE `[[dbprefix]]quantity_discount_groups` (
  `quantity_discount_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `quantity_discount_groups_name` varchar(128) NOT NULL,
  PRIMARY KEY (`quantity_discount_groups_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quantity_discount_groups_values`
--

CREATE TABLE `[[dbprefix]]quantity_discount_groups_values` (
  `quantity_discount_groups_values_id` int(11) NOT NULL AUTO_INCREMENT,
  `quantity_discount_groups_id` int(11) NOT NULL,
  `customers_groups_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  PRIMARY KEY (`quantity_discount_groups_values_id`),
  KEY `quantity_discount_groups_id` (`quantity_discount_groups_id`),
  KEY `customers_groups_id` (`customers_groups_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quantity_unit_classes`
--

CREATE TABLE `[[dbprefix]]quantity_unit_classes` (
  `quantity_unit_class_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `quantity_unit_class_title` varchar(32) NOT NULL,
  PRIMARY KEY (`quantity_unit_class_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]quantity_unit_classes`
--

INSERT INTO `[[dbprefix]]quantity_unit_classes` VALUES
(1, 1, 'pcs'),
(2, 1, 'kg'),
(3, 1, 'liter'),
(4, 1, 'dozen');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ratings`
--

CREATE TABLE `[[dbprefix]]ratings` (
  `ratings_id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`ratings_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ratings_description`
--

CREATE TABLE `[[dbprefix]]ratings_description` (
  `ratings_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `ratings_text` varchar(64) NOT NULL,
  PRIMARY KEY (`ratings_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reviews`
--

CREATE TABLE `[[dbprefix]]reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(64) NOT NULL,
  `reviews_rating` int(1) DEFAULT NULL,
  `languages_id` int(11) NOT NULL,
  `reviews_text` text NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  `reviews_status` tinyint(1) NOT NULL,
  PRIMARY KEY (`reviews_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_terms`
--

CREATE TABLE `[[dbprefix]]search_terms` (
  `search_terms_id` int(10) NOT NULL AUTO_INCREMENT,
  `text` varchar(128) NOT NULL,
  `products_count` int(10) NOT NULL,
  `search_count` int(10) NOT NULL,
  `synonym` varchar(128) NOT NULL,
  `show_in_terms` tinyint(1) NOT NULL,
  `date_updated` datetime NOT NULL,
  PRIMARY KEY (`search_terms_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `sesskey` varchar(32) NOT NULL,
  `expiry` int(11) unsigned NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`sesskey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]slide_images`
--

CREATE TABLE `[[dbprefix]]slide_images` (
  `image_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `description` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `image_url` char(255) NOT NULL,
  `sort_order` int(5) NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`image_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]specials`
--

CREATE TABLE `[[dbprefix]]specials` (
  `specials_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `specials_new_products_price` decimal(15,4) NOT NULL,
  `specials_date_added` datetime DEFAULT NULL,
  `specials_last_modified` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`specials_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tax_class`
--

CREATE TABLE `[[dbprefix]]tax_class` (
  `tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_class_title` varchar(32) NOT NULL,
  `tax_class_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_class_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]tax_class`
--

INSERT INTO `[[dbprefix]]tax_class` VALUES
(1, 'Taxable Goods', 'The following types of products are included non-food, services, etc', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tax_rates`
--

CREATE TABLE `[[dbprefix]]tax_rates` (
  `tax_rates_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_zone_id` int(11) NOT NULL,
  `tax_class_id` int(11) NOT NULL,
  `tax_priority` int(5) DEFAULT '1',
  `tax_rate` decimal(7,4) NOT NULL,
  `tax_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_rates_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]tax_rates`
--

INSERT INTO `[[dbprefix]]tax_rates` VALUES
(1, 1, 1, 1, '7.0000', 'FL TAX 7.0%', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]templates`
--

CREATE TABLE `[[dbprefix]]templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `code` varchar(32) NOT NULL,
  `author_name` varchar(64) NOT NULL,
  `author_www` varchar(255) DEFAULT NULL,
  `markup_version` varchar(32) DEFAULT NULL,
  `css_based` tinyint(4) DEFAULT NULL,
  `medium` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]templates`
--

INSERT INTO `[[dbprefix]]templates` VALUES
(1, 'TomatoCart Glass Gray', 'glass_gray', 'TomatoCart', 'http://www.tomatocart.com', 'XHTML 1.0 Transitional', 1, 'Screen');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]templates_boxes`
--

CREATE TABLE `[[dbprefix]]templates_boxes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `code` varchar(32) NOT NULL,
  `author_name` varchar(64) NOT NULL,
  `author_www` varchar(255) DEFAULT NULL,
  `modules_group` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=31 ;

--
-- Dumping data for table `[[dbprefix]]templates_boxes`
--

INSERT INTO `[[dbprefix]]templates_boxes` VALUES
(1, 'Best Sellers', 'best_sellers', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(2, 'Categories', 'categories', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(3, 'Currencies', 'currencies', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(4, 'Information', 'information', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(5, 'Manufacturer Info', 'manufacturer_info', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(6, 'Manufacturers', 'manufacturers', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(7, 'Order History', 'order_history', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(8, 'Product Notifications', 'product_notifications', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(9, 'Reviews', 'reviews', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(10, 'Specials', 'specials', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(11, 'Tell a Friend', 'tell_a_friend', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(12, 'What''s New', 'whats_new', 'osCommerce', 'http://www.oscommerce.com', 'boxes'),
(13, 'New Products', 'new_products', 'osCommerce', 'http://www.oscommerce.com', 'content'),
(14, 'Upcoming Products', 'upcoming_products', 'osCommerce', 'http://www.oscommerce.com', 'content'),
(15, 'Recently Visited', 'recently_visited', 'osCommerce', 'http://www.oscommerce.com', 'content'),
(16, 'Also Purchased Products', 'also_purchased_products', 'osCommerce', 'http://www.oscommerce.com', 'content'),
(17, 'Cross Sell Products', 'xsell_products', 'TomatoCart', 'http://www.tomatocart.com', 'content'),
(18, 'Compare Products', 'compare_products', 'TomatoCart', 'http://www.tomatocart.com', 'boxes'),
(19, 'Popular Search Term', 'popular_search_terms_tag_cloud', 'TomatoCart', 'http://www.tomatocart.com', 'boxes'),
(20, 'Feature Products', 'feature_products', 'TomatoCart', 'http://www.tomatocart.com', 'content'),
(21, 'payment_cod_title', 'cod', 'osCommerce', 'http://www.oscommerce.com', 'payment'),
(22, 'shipping_flat_title', 'flat', 'osCommerce', 'http://www.oscommerce.com', 'shipping'),
(23, 'order_total_subtotal_title', 'sub_total', 'osCommerce', 'http://www.oscommerce.com', 'order_total'),
(24, 'order_total_shipping_title', 'shipping', 'osCommerce', 'http://www.oscommerce.com', 'order_total'),
(25, 'order_total_tax_title', 'tax', 'osCommerce', 'http://www.oscommerce.com', 'order_total'),
(26, 'order_total_total_title', 'total', 'osCommerce', 'http://www.oscommerce.com', 'order_total'),
(27, 'order_total_coupon_title', 'coupon', 'TomatoCart', 'http://www.tomatocart.com', 'order_total'),
(28, 'order_total_gift_certificate_title', 'gift_certificate', 'TomatoCart', 'http://www.tomatocart.com', 'order_total'),
(29, 'order_total_store_credit_title', 'store_credit', 'TomatoCart', 'http://www.tomatocart.com', 'order_total'),
(30, 'order_total_gift_wrapping_title', 'gift_wrapping', 'TomatoCart', 'http://www.tomatocart.com', 'order_total');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]templates_boxes_to_pages`
--

CREATE TABLE `[[dbprefix]]templates_boxes_to_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `templates_boxes_id` int(11) NOT NULL,
  `templates_id` int(11) NOT NULL,
  `content_page` varchar(255) NOT NULL,
  `boxes_group` varchar(32) NOT NULL,
  `sort_order` int(11) DEFAULT '0',
  `page_specific` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `templates_boxes_id` (`templates_boxes_id`,`templates_id`,`content_page`,`boxes_group`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `[[dbprefix]]templates_boxes_to_pages`
--

INSERT INTO `[[dbprefix]]templates_boxes_to_pages` VALUES
(1, 2, 1, '*', 'left', 100, 0),
(2, 6, 1, '*', 'left', 200, 0),
(3, 12, 1, '*', 'right', 100, 0),
(4, 4, 1, '*', 'left', 300, 0),
(5, 5, 1, 'products/info', 'right', 200, 0),
(6, 7, 1, '*', 'right', 300, 0),
(7, 1, 1, '*', 'right', 400, 0),
(8, 8, 1, 'products/info', 'right', 500, 0),
(9, 11, 1, 'products/info', 'right', 600, 0),
(10, 10, 1, '*', 'right', 700, 0),
(11, 9, 1, '*', 'right', 800, 0),
(12, 3, 1, '*', 'right', 1000, 0),
(13, 13, 1, 'index/category_listing', 'after', 400, 0),
(14, 13, 1, 'index/index', 'after', 400, 0),
(15, 14, 1, 'index/index', 'after', 450, 0),
(16, 15, 1, '*', 'after', 500, 0),
(17, 16, 1, 'products/info', 'after', 100, 0),
(18, 17, 1, 'products/info', 'after', 200, 0),
(19, 18, 1, '*', 'right', 10, 0),
(20, 19, 1, '*', 'right', 1200, 0),
(21, 20, 1, 'index/index', 'after', 100, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]weight_classes`
--

CREATE TABLE `[[dbprefix]]weight_classes` (
  `weight_class_id` int(11) NOT NULL DEFAULT '0',
  `weight_class_key` varchar(4) NOT NULL DEFAULT '',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `weight_class_title` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`weight_class_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]weight_classes`
--

INSERT INTO `[[dbprefix]]weight_classes` VALUES
(1, 'g', 1, 'Gram(s)'),
(2, 'kg', 1, 'Kilogram(s)'),
(3, 'oz', 1, 'Ounce(s)'),
(4, 'lb', 1, 'Pound(s)');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]weight_classes_rules`
--

CREATE TABLE `[[dbprefix]]weight_classes_rules` (
  `weight_class_from_id` int(11) NOT NULL DEFAULT '0',
  `weight_class_to_id` int(11) NOT NULL DEFAULT '0',
  `weight_class_rule` decimal(15,4) NOT NULL DEFAULT '0.0000'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]weight_classes_rules`
--

INSERT INTO `[[dbprefix]]weight_classes_rules` VALUES
(1, 2, '0.0010'),
(1, 3, '0.0352'),
(1, 4, '0.0022'),
(2, 1, '1000.0000'),
(2, 3, '35.2739'),
(2, 4, '2.2046'),
(3, 1, '28.3495'),
(3, 2, '0.0283'),
(3, 4, '0.0625'),
(4, 1, '453.5923'),
(4, 2, '0.4535'),
(4, 3, '16.0000');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]whos_online`
--

CREATE TABLE `[[dbprefix]]whos_online` (
  `customer_id` int(11) DEFAULT NULL,
  `full_name` varchar(64) NOT NULL,
  `session_id` varchar(128) NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `time_entry` varchar(14) NOT NULL,
  `time_last_click` varchar(14) NOT NULL,
  `last_page_url` varchar(255) NOT NULL,
  `referrer_url` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wishlists`
--

CREATE TABLE `[[dbprefix]]wishlists` (
  `wishlists_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) DEFAULT NULL,
  `wishlists_token` varchar(32) NOT NULL,
  PRIMARY KEY (`wishlists_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wishlists_products`
--

CREATE TABLE `[[dbprefix]]wishlists_products` (
  `wishlists_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `wishlists_id` int(11) NOT NULL,
  `products_id_string` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `comments` text NOT NULL,
  PRIMARY KEY (`wishlists_products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]zones`
--

CREATE TABLE `[[dbprefix]]zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_code` varchar(32) NOT NULL,
  `zone_name` varchar(64) NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4257 ;

--
-- Dumping data for table `[[dbprefix]]zones`
--

INSERT INTO `[[dbprefix]]zones` VALUES
(1, 1, 'BDS', 'بد خشان'),
(2, 1, 'BDG', 'بادغیس'),
(3, 1, 'BGL', 'بغلان'),
(4, 1, 'BAL', 'بلخ'),
(5, 1, 'BAM', 'بامیان'),
(6, 1, 'DAY', 'دایکندی'),
(7, 1, 'FRA', 'فراه'),
(8, 1, 'FYB', 'فارياب'),
(9, 1, 'GHA', 'غزنى'),
(10, 1, 'GHO', 'غور'),
(11, 1, 'HEL', 'هلمند'),
(12, 1, 'HER', 'هرات'),
(13, 1, 'JOW', 'جوزجان'),
(14, 1, 'KAB', 'کابل'),
(15, 1, 'KAN', 'قندھار'),
(16, 1, 'KAP', 'کاپيسا'),
(17, 1, 'KHO', 'خوست'),
(18, 1, 'KNR', 'کُنَر'),
(19, 1, 'KDZ', 'كندوز'),
(20, 1, 'LAG', 'لغمان'),
(21, 1, 'LOW', 'لوګر'),
(22, 1, 'NAN', 'ننگرهار'),
(23, 1, 'NIM', 'نیمروز'),
(24, 1, 'NUR', 'نورستان'),
(25, 1, 'ORU', 'ؤروزگان'),
(26, 1, 'PIA', 'پکتیا'),
(27, 1, 'PKA', 'پکتيکا'),
(28, 1, 'PAN', 'پنج شیر'),
(29, 1, 'PAR', 'پروان'),
(30, 1, 'SAM', 'سمنگان'),
(31, 1, 'SAR', 'سر پل'),
(32, 1, 'TAK', 'تخار'),
(33, 1, 'WAR', 'وردک'),
(34, 1, 'ZAB', 'زابل'),
(35, 2, 'BR', 'Beratit'),
(36, 2, 'BU', 'Bulqizës'),
(37, 2, 'DI', 'Dibrës'),
(38, 2, 'DL', 'Delvinës'),
(39, 2, 'DR', 'Durrësit'),
(40, 2, 'DV', 'Devollit'),
(41, 2, 'EL', 'Elbasanit'),
(42, 2, 'ER', 'Kolonjës'),
(43, 2, 'FR', 'Fierit'),
(44, 2, 'GJ', 'Gjirokastrës'),
(45, 2, 'GR', 'Gramshit'),
(46, 2, 'HA', 'Hasit'),
(47, 2, 'KA', 'Kavajës'),
(48, 2, 'KB', 'Kurbinit'),
(49, 2, 'KC', 'Kuçovës'),
(50, 2, 'KO', 'Korçës'),
(51, 2, 'KR', 'Krujës'),
(52, 2, 'KU', 'Kukësit'),
(53, 2, 'LB', 'Librazhdit'),
(54, 2, 'LE', 'Lezhës'),
(55, 2, 'LU', 'Lushnjës'),
(56, 2, 'MK', 'Mallakastrës'),
(57, 2, 'MM', 'Malësisë së Madhe'),
(58, 2, 'MR', 'Mirditës'),
(59, 2, 'MT', 'Matit'),
(60, 2, 'PG', 'Pogradecit'),
(61, 2, 'PQ', 'Peqinit'),
(62, 2, 'PR', 'Përmetit'),
(63, 2, 'PU', 'Pukës'),
(64, 2, 'SH', 'Shkodrës'),
(65, 2, 'SK', 'Skraparit'),
(66, 2, 'SR', 'Sarandës'),
(67, 2, 'TE', 'Tepelenës'),
(68, 2, 'TP', 'Tropojës'),
(69, 2, 'TR', 'Tiranës'),
(70, 2, 'VL', 'Vlorës'),
(71, 3, '01', 'ولاية أدرار'),
(72, 3, '02', 'ولاية الشلف'),
(73, 3, '03', 'ولاية الأغواط'),
(74, 3, '04', 'ولاية أم البواقي'),
(75, 3, '05', 'ولاية باتنة'),
(76, 3, '06', 'ولاية بجاية'),
(77, 3, '07', 'ولاية بسكرة'),
(78, 3, '08', 'ولاية بشار'),
(79, 3, '09', 'البليدة‎'),
(80, 3, '10', 'ولاية البويرة'),
(81, 3, '11', 'ولاية تمنراست'),
(82, 3, '12', 'ولاية تبسة'),
(83, 3, '13', 'تلمسان'),
(84, 3, '14', 'ولاية تيارت'),
(85, 3, '15', 'تيزي وزو'),
(86, 3, '16', 'ولاية الجزائر'),
(87, 3, '17', 'ولاية عين الدفلى'),
(88, 3, '18', 'ولاية جيجل'),
(89, 3, '19', 'ولاية سطيف'),
(90, 3, '20', 'ولاية سعيدة'),
(91, 3, '21', 'السكيكدة'),
(92, 3, '22', 'ولاية سيدي بلعباس'),
(93, 3, '23', 'ولاية عنابة'),
(94, 3, '24', 'ولاية قالمة'),
(95, 3, '25', 'قسنطينة'),
(96, 3, '26', 'ولاية المدية'),
(97, 3, '27', 'ولاية مستغانم'),
(98, 3, '28', 'ولاية المسيلة'),
(99, 3, '29', 'ولاية معسكر'),
(100, 3, '30', 'ورقلة'),
(101, 3, '31', 'وهران'),
(102, 3, '32', 'ولاية البيض'),
(103, 3, '33', 'ولاية اليزي'),
(104, 3, '34', 'ولاية برج بوعريريج'),
(105, 3, '35', 'ولاية بومرداس'),
(106, 3, '36', 'ولاية الطارف'),
(107, 3, '37', 'تندوف'),
(108, 3, '38', 'ولاية تسمسيلت'),
(109, 3, '39', 'ولاية الوادي'),
(110, 3, '40', 'ولاية خنشلة'),
(111, 3, '41', 'ولاية سوق أهراس'),
(112, 3, '42', 'ولاية تيبازة'),
(113, 3, '43', 'ولاية ميلة'),
(114, 3, '44', 'ولاية عين الدفلى'),
(115, 3, '45', 'ولاية النعامة'),
(116, 3, '46', 'ولاية عين تموشنت'),
(117, 3, '47', 'ولاية غرداية'),
(118, 3, '48', 'ولاية غليزان'),
(119, 4, 'EA', 'Eastern'),
(120, 4, 'MA', 'Manu''a'),
(121, 4, 'RI', 'Rose Island'),
(122, 4, 'SI', 'Swains Island'),
(123, 4, 'WE', 'Western'),
(124, 5, 'AN', 'Andorra la Vella'),
(125, 5, 'CA', 'Canillo'),
(126, 5, 'EN', 'Encamp'),
(127, 5, 'LE', 'Escaldes-Engordany'),
(128, 5, 'LM', 'La Massana'),
(129, 5, 'OR', 'Ordino'),
(130, 5, 'SJ', 'Sant Juliá de Lória'),
(131, 6, 'BGO', 'Bengo'),
(132, 6, 'BGU', 'Benguela'),
(133, 6, 'BIE', 'Bié'),
(134, 6, 'CAB', 'Cabinda'),
(135, 6, 'CCU', 'Cuando Cubango'),
(136, 6, 'CNO', 'Cuanza Norte'),
(137, 6, 'CUS', 'Cuanza Sul'),
(138, 6, 'CNN', 'Cunene'),
(139, 6, 'HUA', 'Huambo'),
(140, 6, 'HUI', 'Huíla'),
(141, 6, 'LUA', 'Luanda'),
(142, 6, 'LNO', 'Lunda Norte'),
(143, 6, 'LSU', 'Lunda Sul'),
(144, 6, 'MAL', 'Malanje'),
(145, 6, 'MOX', 'Moxico'),
(146, 6, 'NAM', 'Namibe'),
(147, 6, 'UIG', 'Uíge'),
(148, 6, 'ZAI', 'Zaire'),
(149, 9, 'BAR', 'Barbuda'),
(150, 9, 'SGE', 'Saint George'),
(151, 9, 'SJO', 'Saint John'),
(152, 9, 'SMA', 'Saint Mary'),
(153, 9, 'SPA', 'Saint Paul'),
(154, 9, 'SPE', 'Saint Peter'),
(155, 9, 'SPH', 'Saint Philip'),
(156, 10, 'A', 'Salta'),
(157, 10, 'B', 'Buenos Aires Province'),
(158, 10, 'C', 'Capital Federal'),
(159, 10, 'D', 'San Luis'),
(160, 10, 'E', 'Entre Ríos'),
(161, 10, 'F', 'La Rioja'),
(162, 10, 'G', 'Santiago del Estero'),
(163, 10, 'H', 'Chaco'),
(164, 10, 'J', 'San Juan'),
(165, 10, 'K', 'Catamarca'),
(166, 10, 'L', 'La Pampa'),
(167, 10, 'M', 'Mendoza'),
(168, 10, 'N', 'Misiones'),
(169, 10, 'P', 'Formosa'),
(170, 10, 'Q', 'Neuquén'),
(171, 10, 'R', 'Río Negro'),
(172, 10, 'S', 'Santa Fe'),
(173, 10, 'T', 'Tucumán'),
(174, 10, 'U', 'Chubut'),
(175, 10, 'V', 'Tierra del Fuego'),
(176, 10, 'W', 'Corrientes'),
(177, 10, 'X', 'Córdoba'),
(178, 10, 'Y', 'Jujuy'),
(179, 10, 'Z', 'Santa Cruz'),
(180, 11, 'AG', 'Արագածոտն'),
(181, 11, 'AR', 'Արարատ'),
(182, 11, 'AV', 'Արմավիր'),
(183, 11, 'ER', 'Երևան'),
(184, 11, 'GR', 'Գեղարքունիք'),
(185, 11, 'KT', 'Կոտայք'),
(186, 11, 'LO', 'Լոռի'),
(187, 11, 'SH', 'Շիրակ'),
(188, 11, 'SU', 'Սյունիք'),
(189, 11, 'TV', 'Տավուշ'),
(190, 11, 'VD', 'Վայոց Ձոր'),
(191, 13, 'ACT', 'Australian Capital Territory'),
(192, 13, 'NSW', 'New South Wales'),
(193, 13, 'NT', 'Northern Territory'),
(194, 13, 'QLD', 'Queensland'),
(195, 13, 'SA', 'South Australia'),
(196, 13, 'TAS', 'Tasmania'),
(197, 13, 'VIC', 'Victoria'),
(198, 13, 'WA', 'Western Australia'),
(199, 14, '1', 'Burgenland'),
(200, 14, '2', 'Kärnten'),
(201, 14, '3', 'Niederösterreich'),
(202, 14, '4', 'Oberösterreich'),
(203, 14, '5', 'Salzburg'),
(204, 14, '6', 'Steiermark'),
(205, 14, '7', 'Tirol'),
(206, 14, '8', 'Voralberg'),
(207, 14, '9', 'Wien'),
(208, 15, 'AB', 'Əli Bayramlı'),
(209, 15, 'ABS', 'Abşeron'),
(210, 15, 'AGC', 'Ağcabədi'),
(211, 15, 'AGM', 'Ağdam'),
(212, 15, 'AGS', 'Ağdaş'),
(213, 15, 'AGA', 'Ağstafa'),
(214, 15, 'AGU', 'Ağsu'),
(215, 15, 'AST', 'Astara'),
(216, 15, 'BA', 'Bakı'),
(217, 15, 'BAB', 'Babək'),
(218, 15, 'BAL', 'Balakən'),
(219, 15, 'BAR', 'Bərdə'),
(220, 15, 'BEY', 'Beyləqan'),
(221, 15, 'BIL', 'Biləsuvar'),
(222, 15, 'CAB', 'Cəbrayıl'),
(223, 15, 'CAL', 'Cəlilabab'),
(224, 15, 'CUL', 'Julfa'),
(225, 15, 'DAS', 'Daşkəsən'),
(226, 15, 'DAV', 'Dəvəçi'),
(227, 15, 'FUZ', 'Füzuli'),
(228, 15, 'GA', 'Gəncə'),
(229, 15, 'GAD', 'Gədəbəy'),
(230, 15, 'GOR', 'Goranboy'),
(231, 15, 'GOY', 'Göyçay'),
(232, 15, 'HAC', 'Hacıqabul'),
(233, 15, 'IMI', 'İmişli'),
(234, 15, 'ISM', 'İsmayıllı'),
(235, 15, 'KAL', 'Kəlbəcər'),
(236, 15, 'KUR', 'Kürdəmir'),
(237, 15, 'LA', 'Lənkəran'),
(238, 15, 'LAC', 'Laçın'),
(239, 15, 'LAN', 'Lənkəran'),
(240, 15, 'LER', 'Lerik'),
(241, 15, 'MAS', 'Masallı'),
(242, 15, 'MI', 'Mingəçevir'),
(243, 15, 'NA', 'Naftalan'),
(244, 15, 'NEF', 'Neftçala'),
(245, 15, 'OGU', 'Oğuz'),
(246, 15, 'ORD', 'Ordubad'),
(247, 15, 'QAB', 'Qəbələ'),
(248, 15, 'QAX', 'Qax'),
(249, 15, 'QAZ', 'Qazax'),
(250, 15, 'QOB', 'Qobustan'),
(251, 15, 'QBA', 'Quba'),
(252, 15, 'QBI', 'Qubadlı'),
(253, 15, 'QUS', 'Qusar'),
(254, 15, 'SA', 'Şəki'),
(255, 15, 'SAT', 'Saatlı'),
(256, 15, 'SAB', 'Sabirabad'),
(257, 15, 'SAD', 'Sədərək'),
(258, 15, 'SAH', 'Şahbuz'),
(259, 15, 'SAK', 'Şəki'),
(260, 15, 'SAL', 'Salyan'),
(261, 15, 'SM', 'Sumqayıt'),
(262, 15, 'SMI', 'Şamaxı'),
(263, 15, 'SKR', 'Şəmkir'),
(264, 15, 'SMX', 'Samux'),
(265, 15, 'SAR', 'Şərur'),
(266, 15, 'SIY', 'Siyəzən'),
(267, 15, 'SS', 'Şuşa (City)'),
(268, 15, 'SUS', 'Şuşa'),
(269, 15, 'TAR', 'Tərtər'),
(270, 15, 'TOV', 'Tovuz'),
(271, 15, 'UCA', 'Ucar'),
(272, 15, 'XA', 'Xankəndi'),
(273, 15, 'XAC', 'Xaçmaz'),
(274, 15, 'XAN', 'Xanlar'),
(275, 15, 'XIZ', 'Xızı'),
(276, 15, 'XCI', 'Xocalı'),
(277, 15, 'XVD', 'Xocavənd'),
(278, 15, 'YAR', 'Yardımlı'),
(279, 15, 'YE', 'Yevlax (City)'),
(280, 15, 'YEV', 'Yevlax'),
(281, 15, 'ZAN', 'Zəngilan'),
(282, 15, 'ZAQ', 'Zaqatala'),
(283, 15, 'ZAR', 'Zərdab'),
(284, 15, 'NX', 'Nakhichevan'),
(285, 16, 'AC', 'Acklins and Crooked Islands'),
(286, 16, 'BI', 'Bimini'),
(287, 16, 'CI', 'Cat Island'),
(288, 16, 'EX', 'Exuma'),
(289, 16, 'FR', 'Freeport'),
(290, 16, 'FC', 'Fresh Creek'),
(291, 16, 'GH', 'Governor''s Harbour'),
(292, 16, 'GT', 'Green Turtle Cay'),
(293, 16, 'HI', 'Harbour Island'),
(294, 16, 'HR', 'High Rock'),
(295, 16, 'IN', 'Inagua'),
(296, 16, 'KB', 'Kemps Bay'),
(297, 16, 'LI', 'Long Island'),
(298, 16, 'MH', 'Marsh Harbour'),
(299, 16, 'MA', 'Mayaguana'),
(300, 16, 'NP', 'New Providence'),
(301, 16, 'NT', 'Nicholls Town and Berry Islands'),
(302, 16, 'RI', 'Ragged Island'),
(303, 16, 'RS', 'Rock Sound'),
(304, 16, 'SS', 'San Salvador and Rum Cay'),
(305, 16, 'SP', 'Sandy Point'),
(306, 17, '01', 'الحد'),
(307, 17, '02', 'المحرق'),
(308, 17, '03', 'المنامة'),
(309, 17, '04', 'جد حفص'),
(310, 17, '05', 'المنطقة الشمالية'),
(311, 17, '06', 'سترة'),
(312, 17, '07', 'المنطقة الوسطى'),
(313, 17, '08', 'مدينة عيسى'),
(314, 17, '09', 'الرفاع والمنطقة الجنوبية'),
(315, 17, '10', 'المنطقة الغربية'),
(316, 17, '11', 'جزر حوار'),
(317, 17, '12', 'مدينة حمد'),
(318, 18, '01', 'Bandarban'),
(319, 18, '02', 'Barguna'),
(320, 18, '03', 'Bogra'),
(321, 18, '04', 'Brahmanbaria'),
(322, 18, '05', 'Bagerhat'),
(323, 18, '06', 'Barisal'),
(324, 18, '07', 'Bhola'),
(325, 18, '08', 'Comilla'),
(326, 18, '09', 'Chandpur'),
(327, 18, '10', 'Chittagong'),
(328, 18, '11', 'Cox''s Bazar'),
(329, 18, '12', 'Chuadanga'),
(330, 18, '13', 'Dhaka'),
(331, 18, '14', 'Dinajpur'),
(332, 18, '15', 'Faridpur'),
(333, 18, '16', 'Feni'),
(334, 18, '17', 'Gopalganj'),
(335, 18, '18', 'Gazipur'),
(336, 18, '19', 'Gaibandha'),
(337, 18, '20', 'Habiganj'),
(338, 18, '21', 'Jamalpur'),
(339, 18, '22', 'Jessore'),
(340, 18, '23', 'Jhenaidah'),
(341, 18, '24', 'Jaipurhat'),
(342, 18, '25', 'Jhalakati'),
(343, 18, '26', 'Kishoreganj'),
(344, 18, '27', 'Khulna'),
(345, 18, '28', 'Kurigram'),
(346, 18, '29', 'Khagrachari'),
(347, 18, '30', 'Kushtia'),
(348, 18, '31', 'Lakshmipur'),
(349, 18, '32', 'Lalmonirhat'),
(350, 18, '33', 'Manikganj'),
(351, 18, '34', 'Mymensingh'),
(352, 18, '35', 'Munshiganj'),
(353, 18, '36', 'Madaripur'),
(354, 18, '37', 'Magura'),
(355, 18, '38', 'Moulvibazar'),
(356, 18, '39', 'Meherpur'),
(357, 18, '40', 'Narayanganj'),
(358, 18, '41', 'Netrakona'),
(359, 18, '42', 'Narsingdi'),
(360, 18, '43', 'Narail'),
(361, 18, '44', 'Natore'),
(362, 18, '45', 'Nawabganj'),
(363, 18, '46', 'Nilphamari'),
(364, 18, '47', 'Noakhali'),
(365, 18, '48', 'Naogaon'),
(366, 18, '49', 'Pabna'),
(367, 18, '50', 'Pirojpur'),
(368, 18, '51', 'Patuakhali'),
(369, 18, '52', 'Panchagarh'),
(370, 18, '53', 'Rajbari'),
(371, 18, '54', 'Rajshahi'),
(372, 18, '55', 'Rangpur'),
(373, 18, '56', 'Rangamati'),
(374, 18, '57', 'Sherpur'),
(375, 18, '58', 'Satkhira'),
(376, 18, '59', 'Sirajganj'),
(377, 18, '60', 'Sylhet'),
(378, 18, '61', 'Sunamganj'),
(379, 18, '62', 'Shariatpur'),
(380, 18, '63', 'Tangail'),
(381, 18, '64', 'Thakurgaon'),
(382, 19, 'A', 'Saint Andrew'),
(383, 19, 'C', 'Christ Church'),
(384, 19, 'E', 'Saint Peter'),
(385, 19, 'G', 'Saint George'),
(386, 19, 'J', 'Saint John'),
(387, 19, 'L', 'Saint Lucy'),
(388, 19, 'M', 'Saint Michael'),
(389, 19, 'O', 'Saint Joseph'),
(390, 19, 'P', 'Saint Philip'),
(391, 19, 'S', 'Saint James'),
(392, 19, 'T', 'Saint Thomas'),
(393, 20, 'BR', 'Брэ́сцкая во́бласць'),
(394, 20, 'HO', 'Го́мельская во́бласць'),
(395, 20, 'HR', 'Гро́дзенская во́бласць'),
(396, 20, 'MA', 'Магілёўская во́бласць'),
(397, 20, 'MI', 'Мі́нская во́бласць'),
(398, 20, 'VI', 'Ві́цебская во́бласць'),
(399, 21, 'BRU', 'Brussel'),
(400, 21, 'VAN', 'Antwerpen'),
(401, 21, 'VBR', 'Vlaams-Brabant'),
(402, 21, 'VLI', 'Limburg'),
(403, 21, 'VOV', 'Oost-Vlaanderen'),
(404, 21, 'VWV', 'West-Vlaanderen'),
(405, 21, 'WBR', 'Brabant Wallonië'),
(406, 21, 'WHT', 'Henegouwen'),
(407, 21, 'WLG', 'Luik'),
(408, 21, 'WLX', 'Luxemburg'),
(409, 21, 'WNA', 'Namen'),
(410, 22, 'BZ', 'Belize District'),
(411, 22, 'CY', 'Cayo District'),
(412, 22, 'CZL', 'Corozal District'),
(413, 22, 'OW', 'Orange Walk District'),
(414, 22, 'SC', 'Stann Creek District'),
(415, 22, 'TOL', 'Toledo District'),
(416, 23, 'AL', 'Alibori'),
(417, 23, 'AK', 'Atakora'),
(418, 23, 'AQ', 'Atlantique'),
(419, 23, 'BO', 'Borgou'),
(420, 23, 'CO', 'Collines'),
(421, 23, 'DO', 'Donga'),
(422, 23, 'KO', 'Kouffo'),
(423, 23, 'LI', 'Littoral'),
(424, 23, 'MO', 'Mono'),
(425, 23, 'OU', 'Ouémé'),
(426, 23, 'PL', 'Plateau'),
(427, 23, 'ZO', 'Zou'),
(428, 24, 'DEV', 'Devonshire'),
(429, 24, 'HA', 'Hamilton City'),
(430, 24, 'HAM', 'Hamilton'),
(431, 24, 'PAG', 'Paget'),
(432, 24, 'PEM', 'Pembroke'),
(433, 24, 'SAN', 'Sandys'),
(434, 24, 'SG', 'Saint George City'),
(435, 24, 'SGE', 'Saint George''s'),
(436, 24, 'SMI', 'Smiths'),
(437, 24, 'SOU', 'Southampton'),
(438, 24, 'WAR', 'Warwick'),
(439, 25, '11', 'Paro'),
(440, 25, '12', 'Chukha'),
(441, 25, '13', 'Haa'),
(442, 25, '14', 'Samtse'),
(443, 25, '15', 'Thimphu'),
(444, 25, '21', 'Tsirang'),
(445, 25, '22', 'Dagana'),
(446, 25, '23', 'Punakha'),
(447, 25, '24', 'Wangdue Phodrang'),
(448, 25, '31', 'Sarpang'),
(449, 25, '32', 'Trongsa'),
(450, 25, '33', 'Bumthang'),
(451, 25, '34', 'Zhemgang'),
(452, 25, '41', 'Trashigang'),
(453, 25, '42', 'Mongar'),
(454, 25, '43', 'Pemagatshel'),
(455, 25, '44', 'Luentse'),
(456, 25, '45', 'Samdrup Jongkhar'),
(457, 25, 'GA', 'Gasa'),
(458, 25, 'TY', 'Trashiyangse'),
(459, 26, 'B', 'El Beni'),
(460, 26, 'C', 'Cochabamba'),
(461, 26, 'H', 'Chuquisaca'),
(462, 26, 'L', 'La Paz'),
(463, 26, 'N', 'Pando'),
(464, 26, 'O', 'Oruro'),
(465, 26, 'P', 'Potosí'),
(466, 26, 'S', 'Santa Cruz'),
(467, 26, 'T', 'Tarija'),
(468, 28, 'CE', 'Central'),
(469, 28, 'GH', 'Ghanzi'),
(470, 28, 'KG', 'Kgalagadi'),
(471, 28, 'KL', 'Kgatleng'),
(472, 28, 'KW', 'Kweneng'),
(473, 28, 'NE', 'North-East'),
(474, 28, 'NW', 'North-West'),
(475, 28, 'SE', 'South-East'),
(476, 28, 'SO', 'Southern'),
(477, 30, 'AC', 'Acre'),
(478, 30, 'AL', 'Alagoas'),
(479, 30, 'AM', 'Amazônia'),
(480, 30, 'AP', 'Amapá'),
(481, 30, 'BA', 'Bahia'),
(482, 30, 'CE', 'Ceará'),
(483, 30, 'DF', 'Distrito Federal'),
(484, 30, 'ES', 'Espírito Santo'),
(485, 30, 'GO', 'Goiás'),
(486, 30, 'MA', 'Maranhão'),
(487, 30, 'MG', 'Minas Gerais'),
(488, 30, 'MS', 'Mato Grosso do Sul'),
(489, 30, 'MT', 'Mato Grosso'),
(490, 30, 'PA', 'Pará'),
(491, 30, 'PB', 'Paraíba'),
(492, 30, 'PE', 'Pernambuco'),
(493, 30, 'PI', 'Piauí'),
(494, 30, 'PR', 'Paraná'),
(495, 30, 'RJ', 'Rio de Janeiro'),
(496, 30, 'RN', 'Rio Grande do Norte'),
(497, 30, 'RO', 'Rondônia'),
(498, 30, 'RR', 'Roraima'),
(499, 30, 'RS', 'Rio Grande do Sul'),
(500, 30, 'SC', 'Santa Catarina'),
(501, 30, 'SE', 'Sergipe'),
(502, 30, 'SP', 'São Paulo'),
(503, 30, 'TO', 'Tocantins'),
(504, 31, 'PB', 'Peros Banhos'),
(505, 31, 'SI', 'Salomon Islands'),
(506, 31, 'NI', 'Nelsons Island'),
(507, 31, 'TB', 'Three Brothers'),
(508, 31, 'EA', 'Eagle Islands'),
(509, 31, 'DI', 'Danger Island'),
(510, 31, 'EG', 'Egmont Islands'),
(511, 31, 'DG', 'Diego Garcia'),
(512, 32, 'BE', 'Belait'),
(513, 32, 'BM', 'Brunei-Muara'),
(514, 32, 'TE', 'Temburong'),
(515, 32, 'TU', 'Tutong'),
(516, 33, '01', 'Blagoevgrad'),
(517, 33, '02', 'Burgas'),
(518, 33, '03', 'Varna'),
(519, 33, '04', 'Veliko Tarnovo'),
(520, 33, '05', 'Vidin'),
(521, 33, '06', 'Vratsa'),
(522, 33, '07', 'Gabrovo'),
(523, 33, '08', 'Dobrich'),
(524, 33, '09', 'Kardzhali'),
(525, 33, '10', 'Kyustendil'),
(526, 33, '11', 'Lovech'),
(527, 33, '12', 'Montana'),
(528, 33, '13', 'Pazardzhik'),
(529, 33, '14', 'Pernik'),
(530, 33, '15', 'Pleven'),
(531, 33, '16', 'Plovdiv'),
(532, 33, '17', 'Razgrad'),
(533, 33, '18', 'Ruse'),
(534, 33, '19', 'Silistra'),
(535, 33, '20', 'Sliven'),
(536, 33, '21', 'Smolyan'),
(537, 33, '23', 'Sofia'),
(538, 33, '22', 'Sofia Province'),
(539, 33, '24', 'Stara Zagora'),
(540, 33, '25', 'Targovishte'),
(541, 33, '26', 'Haskovo'),
(542, 33, '27', 'Shumen'),
(543, 33, '28', 'Yambol'),
(544, 34, 'BAL', 'Balé'),
(545, 34, 'BAM', 'Bam'),
(546, 34, 'BAN', 'Banwa'),
(547, 34, 'BAZ', 'Bazèga'),
(548, 34, 'BGR', 'Bougouriba'),
(549, 34, 'BLG', 'Boulgou'),
(550, 34, 'BLK', 'Boulkiemdé'),
(551, 34, 'COM', 'Komoé'),
(552, 34, 'GAN', 'Ganzourgou'),
(553, 34, 'GNA', 'Gnagna'),
(554, 34, 'GOU', 'Gourma'),
(555, 34, 'HOU', 'Houet'),
(556, 34, 'IOB', 'Ioba'),
(557, 34, 'KAD', 'Kadiogo'),
(558, 34, 'KEN', 'Kénédougou'),
(559, 34, 'KMD', 'Komondjari'),
(560, 34, 'KMP', 'Kompienga'),
(561, 34, 'KOP', 'Koulpélogo'),
(562, 34, 'KOS', 'Kossi'),
(563, 34, 'KOT', 'Kouritenga'),
(564, 34, 'KOW', 'Kourwéogo'),
(565, 34, 'LER', 'Léraba'),
(566, 34, 'LOR', 'Loroum'),
(567, 34, 'MOU', 'Mouhoun'),
(568, 34, 'NAM', 'Namentenga'),
(569, 34, 'NAO', 'Naouri'),
(570, 34, 'NAY', 'Nayala'),
(571, 34, 'NOU', 'Noumbiel'),
(572, 34, 'OUB', 'Oubritenga'),
(573, 34, 'OUD', 'Oudalan'),
(574, 34, 'PAS', 'Passoré'),
(575, 34, 'PON', 'Poni'),
(576, 34, 'SEN', 'Séno'),
(577, 34, 'SIS', 'Sissili'),
(578, 34, 'SMT', 'Sanmatenga'),
(579, 34, 'SNG', 'Sanguié'),
(580, 34, 'SOM', 'Soum'),
(581, 34, 'SOR', 'Sourou'),
(582, 34, 'TAP', 'Tapoa'),
(583, 34, 'TUI', 'Tui'),
(584, 34, 'YAG', 'Yagha'),
(585, 34, 'YAT', 'Yatenga'),
(586, 34, 'ZIR', 'Ziro'),
(587, 34, 'ZON', 'Zondoma'),
(588, 34, 'ZOU', 'Zoundwéogo'),
(589, 35, 'BB', 'Bubanza'),
(590, 35, 'BJ', 'Bujumbura Mairie'),
(591, 35, 'BR', 'Bururi'),
(592, 35, 'CA', 'Cankuzo'),
(593, 35, 'CI', 'Cibitoke'),
(594, 35, 'GI', 'Gitega'),
(595, 35, 'KR', 'Karuzi'),
(596, 35, 'KY', 'Kayanza'),
(597, 35, 'KI', 'Kirundo'),
(598, 35, 'MA', 'Makamba'),
(599, 35, 'MU', 'Muramvya'),
(600, 35, 'MY', 'Muyinga'),
(601, 35, 'MW', 'Mwaro'),
(602, 35, 'NG', 'Ngozi'),
(603, 35, 'RT', 'Rutana'),
(604, 35, 'RY', 'Ruyigi'),
(605, 37, 'AD', 'Adamaoua'),
(606, 37, 'CE', 'Centre'),
(607, 37, 'EN', 'Extrême-Nord'),
(608, 37, 'ES', 'Est'),
(609, 37, 'LT', 'Littoral'),
(610, 37, 'NO', 'Nord'),
(611, 37, 'NW', 'Nord-Ouest'),
(612, 37, 'OU', 'Ouest'),
(613, 37, 'SU', 'Sud'),
(614, 37, 'SW', 'Sud-Ouest'),
(615, 38, 'AB', 'Alberta'),
(616, 38, 'BC', 'British Columbia'),
(617, 38, 'MB', 'Manitoba'),
(618, 38, 'NB', 'New Brunswick'),
(619, 38, 'NL', 'Newfoundland and Labrador'),
(620, 38, 'NS', 'Nova Scotia'),
(621, 38, 'NT', 'Northwest Territories'),
(622, 38, 'NU', 'Nunavut'),
(623, 38, 'ON', 'Ontario'),
(624, 38, 'PE', 'Prince Edward Island'),
(625, 38, 'QC', 'Quebec'),
(626, 38, 'SK', 'Saskatchewan'),
(627, 38, 'YT', 'Yukon Territory'),
(628, 39, 'BR', 'Brava'),
(629, 39, 'BV', 'Boa Vista'),
(630, 39, 'CA', 'Santa Catarina'),
(631, 39, 'CR', 'Santa Cruz'),
(632, 39, 'CS', 'Calheta de São Miguel'),
(633, 39, 'MA', 'Maio'),
(634, 39, 'MO', 'Mosteiros'),
(635, 39, 'PA', 'Paúl'),
(636, 39, 'PN', 'Porto Novo'),
(637, 39, 'PR', 'Praia'),
(638, 39, 'RG', 'Ribeira Grande'),
(639, 39, 'SD', 'São Domingos'),
(640, 39, 'SF', 'São Filipe'),
(641, 39, 'SL', 'Sal'),
(642, 39, 'SN', 'São Nicolau'),
(643, 39, 'SV', 'São Vicente'),
(644, 39, 'TA', 'Tarrafal'),
(645, 40, 'CR', 'Creek'),
(646, 40, 'EA', 'Eastern'),
(647, 40, 'MI', 'Midland'),
(648, 40, 'SO', 'South Town'),
(649, 40, 'SP', 'Spot Bay'),
(650, 40, 'ST', 'Stake Bay'),
(651, 40, 'WD', 'West End'),
(652, 40, 'WN', 'Western'),
(653, 41, 'AC ', 'Ouham'),
(654, 41, 'BB ', 'Bamingui-Bangoran'),
(655, 41, 'BGF', 'Bangui'),
(656, 41, 'BK ', 'Basse-Kotto'),
(657, 41, 'HK ', 'Haute-Kotto'),
(658, 41, 'HM ', 'Haut-Mbomou'),
(659, 41, 'HS ', 'Mambéré-Kadéï'),
(660, 41, 'KB ', 'Nana-Grébizi'),
(661, 41, 'KG ', 'Kémo'),
(662, 41, 'LB ', 'Lobaye'),
(663, 41, 'MB ', 'Mbomou'),
(664, 41, 'MP ', 'Ombella-M''Poko'),
(665, 41, 'NM ', 'Nana-Mambéré'),
(666, 41, 'OP ', 'Ouham-Pendé'),
(667, 41, 'SE ', 'Sangha-Mbaéré'),
(668, 41, 'UK ', 'Ouaka'),
(669, 41, 'VR ', 'Vakaga'),
(670, 42, 'BA ', 'Batha'),
(671, 42, 'BET', 'Borkou-Ennedi-Tibesti'),
(672, 42, 'BI ', 'Biltine'),
(673, 42, 'CB ', 'Chari-Baguirmi'),
(674, 42, 'GR ', 'Guéra'),
(675, 42, 'KA ', 'Kanem'),
(676, 42, 'LC ', 'Lac'),
(677, 42, 'LR ', 'Logone-Oriental'),
(678, 42, 'LO ', 'Logone-Occidental'),
(679, 42, 'MC ', 'Moyen-Chari'),
(680, 42, 'MK ', 'Mayo-Kébbi'),
(681, 42, 'OD ', 'Ouaddaï'),
(682, 42, 'SA ', 'Salamat'),
(683, 42, 'TA ', 'Tandjilé'),
(684, 43, 'AI', 'Aisén del General Carlos Ibañez'),
(685, 43, 'AN', 'Antofagasta'),
(686, 43, 'AR', 'La Araucanía'),
(687, 43, 'AT', 'Atacama'),
(688, 43, 'BI', 'Biobío'),
(689, 43, 'CO', 'Coquimbo'),
(690, 43, 'LI', 'Libertador Bernardo O''Higgins'),
(691, 43, 'LL', 'Los Lagos'),
(692, 43, 'MA', 'Magallanes y de la Antartica'),
(693, 43, 'ML', 'Maule'),
(694, 43, 'RM', 'Metropolitana de Santiago'),
(695, 43, 'TA', 'Tarapacá'),
(696, 43, 'VS', 'Valparaíso'),
(697, 44, '11', '北京'),
(698, 44, '12', '天津'),
(699, 44, '13', '河北'),
(700, 44, '14', '山西'),
(701, 44, '15', '内蒙古自治区'),
(702, 44, '21', '辽宁'),
(703, 44, '22', '吉林'),
(704, 44, '23', '黑龙江省'),
(705, 44, '31', '上海'),
(706, 44, '32', '江苏'),
(707, 44, '33', '浙江'),
(708, 44, '34', '安徽'),
(709, 44, '35', '福建'),
(710, 44, '36', '江西'),
(711, 44, '37', '山东'),
(712, 44, '41', '河南'),
(713, 44, '42', '湖北'),
(714, 44, '43', '湖南'),
(715, 44, '44', '广东'),
(716, 44, '45', '广西壮族自治区'),
(717, 44, '46', '海南'),
(718, 44, '50', '重庆'),
(719, 44, '51', '四川'),
(720, 44, '52', '贵州'),
(721, 44, '53', '云南'),
(722, 44, '54', '西藏自治区'),
(723, 44, '61', '陕西'),
(724, 44, '62', '甘肃'),
(725, 44, '63', '青海'),
(726, 44, '64', '宁夏'),
(727, 44, '65', '新疆'),
(728, 44, '71', '臺灣'),
(729, 44, '91', '香港'),
(730, 44, '92', '澳門'),
(731, 46, 'D', 'Direction Island'),
(732, 46, 'H', 'Home Island'),
(733, 46, 'O', 'Horsburgh Island'),
(734, 46, 'S', 'South Island'),
(735, 46, 'W', 'West Island'),
(736, 47, 'AMA', 'Amazonas'),
(737, 47, 'ANT', 'Antioquia'),
(738, 47, 'ARA', 'Arauca'),
(739, 47, 'ATL', 'Atlántico'),
(740, 47, 'BOL', 'Bolívar'),
(741, 47, 'BOY', 'Boyacá'),
(742, 47, 'CAL', 'Caldas'),
(743, 47, 'CAQ', 'Caquetá'),
(744, 47, 'CAS', 'Casanare'),
(745, 47, 'CAU', 'Cauca'),
(746, 47, 'CES', 'Cesar'),
(747, 47, 'CHO', 'Chocó'),
(748, 47, 'COR', 'Córdoba'),
(749, 47, 'CUN', 'Cundinamarca'),
(750, 47, 'DC', 'Bogotá Distrito Capital'),
(751, 47, 'GUA', 'Guainía'),
(752, 47, 'GUV', 'Guaviare'),
(753, 47, 'HUI', 'Huila'),
(754, 47, 'LAG', 'La Guajira'),
(755, 47, 'MAG', 'Magdalena'),
(756, 47, 'MET', 'Meta'),
(757, 47, 'NAR', 'Nariño'),
(758, 47, 'NSA', 'Norte de Santander'),
(759, 47, 'PUT', 'Putumayo'),
(760, 47, 'QUI', 'Quindío'),
(761, 47, 'RIS', 'Risaralda'),
(762, 47, 'SAN', 'Santander'),
(763, 47, 'SAP', 'San Andrés y Providencia'),
(764, 47, 'SUC', 'Sucre'),
(765, 47, 'TOL', 'Tolima'),
(766, 47, 'VAC', 'Valle del Cauca'),
(767, 47, 'VAU', 'Vaupés'),
(768, 47, 'VID', 'Vichada'),
(769, 48, 'A', 'Anjouan'),
(770, 48, 'G', 'Grande Comore'),
(771, 48, 'M', 'Mohéli'),
(772, 49, 'BC', 'Congo-Central'),
(773, 49, 'BN', 'Bandundu'),
(774, 49, 'EQ', 'Équateur'),
(775, 49, 'KA', 'Katanga'),
(776, 49, 'KE', 'Kasai-Oriental'),
(777, 49, 'KN', 'Kinshasa'),
(778, 49, 'KW', 'Kasai-Occidental'),
(779, 49, 'MA', 'Maniema'),
(780, 49, 'NK', 'Nord-Kivu'),
(781, 49, 'OR', 'Orientale'),
(782, 49, 'SK', 'Sud-Kivu'),
(783, 50, 'PU', 'Pukapuka'),
(784, 50, 'RK', 'Rakahanga'),
(785, 50, 'MK', 'Manihiki'),
(786, 50, 'PE', 'Penrhyn'),
(787, 50, 'NI', 'Nassau Island'),
(788, 50, 'SU', 'Surwarrow'),
(789, 50, 'PA', 'Palmerston'),
(790, 50, 'AI', 'Aitutaki'),
(791, 50, 'MA', 'Manuae'),
(792, 50, 'TA', 'Takutea'),
(793, 50, 'MT', 'Mitiaro'),
(794, 50, 'AT', 'Atiu'),
(795, 50, 'MU', 'Mauke'),
(796, 50, 'RR', 'Rarotonga'),
(797, 50, 'MG', 'Mangaia'),
(798, 51, 'A', 'Alajuela'),
(799, 51, 'C', 'Cartago'),
(800, 51, 'G', 'Guanacaste'),
(801, 51, 'H', 'Heredia'),
(802, 51, 'L', 'Limón'),
(803, 51, 'P', 'Puntarenas'),
(804, 51, 'SJ', 'San José'),
(805, 52, '01', 'Lagunes'),
(806, 52, '02', 'Haut-Sassandra'),
(807, 52, '03', 'Savanes'),
(808, 52, '04', 'Vallée du Bandama'),
(809, 52, '05', 'Moyen-Comoé'),
(810, 52, '06', 'Dix-Huit'),
(811, 52, '07', 'Lacs'),
(812, 52, '08', 'Zanzan'),
(813, 52, '09', 'Bas-Sassandra'),
(814, 52, '10', 'Denguélé'),
(815, 52, '11', 'N''zi-Comoé'),
(816, 52, '12', 'Marahoué'),
(817, 52, '13', 'Sud-Comoé'),
(818, 52, '14', 'Worodouqou'),
(819, 52, '15', 'Sud-Bandama'),
(820, 52, '16', 'Agnébi'),
(821, 52, '17', 'Bafing'),
(822, 52, '18', 'Fromager'),
(823, 52, '19', 'Moyen-Cavally'),
(824, 53, '01', 'Zagrebačka županija'),
(825, 53, '02', 'Krapinsko-zagorska županija'),
(826, 53, '03', 'Sisačko-moslavačka županija'),
(827, 53, '04', 'Karlovačka županija'),
(828, 53, '05', 'Varaždinska županija'),
(829, 53, '06', 'Koprivničko-križevačka županija'),
(830, 53, '07', 'Bjelovarsko-bilogorska županija'),
(831, 53, '08', 'Primorsko-goranska županija'),
(832, 53, '09', 'Ličko-senjska županija'),
(833, 53, '10', 'Virovitičko-podravska županija'),
(834, 53, '11', 'Požeško-slavonska županija'),
(835, 53, '12', 'Brodsko-posavska županija'),
(836, 53, '13', 'Zadarska županija'),
(837, 53, '14', 'Osječko-baranjska županija'),
(838, 53, '15', 'Šibensko-kninska županija'),
(839, 53, '16', 'Vukovarsko-srijemska županija'),
(840, 53, '17', 'Splitsko-dalmatinska županija'),
(841, 53, '18', 'Istarska županija'),
(842, 53, '19', 'Dubrovačko-neretvanska županija'),
(843, 53, '20', 'Međimurska županija'),
(844, 53, '21', 'Zagreb'),
(845, 54, '01', 'Pinar del Río'),
(846, 54, '02', 'La Habana'),
(847, 54, '03', 'Ciudad de La Habana'),
(848, 54, '04', 'Matanzas'),
(849, 54, '05', 'Villa Clara'),
(850, 54, '06', 'Cienfuegos'),
(851, 54, '07', 'Sancti Spíritus'),
(852, 54, '08', 'Ciego de Ávila'),
(853, 54, '09', 'Camagüey'),
(854, 54, '10', 'Las Tunas'),
(855, 54, '11', 'Holguín'),
(856, 54, '12', 'Granma'),
(857, 54, '13', 'Santiago de Cuba'),
(858, 54, '14', 'Guantánamo'),
(859, 54, '99', 'Isla de la Juventud'),
(860, 55, '01', 'Κερύvεια'),
(861, 55, '02', 'Λευκωσία'),
(862, 55, '03', 'Αμμόχωστος'),
(863, 55, '04', 'Λάρνακα'),
(864, 55, '05', 'Λεμεσός'),
(865, 55, '06', 'Πάφος'),
(866, 56, 'JC', 'Jihočeský kraj'),
(867, 56, 'JM', 'Jihomoravský kraj'),
(868, 56, 'KA', 'Karlovarský kraj'),
(869, 56, 'VY', 'Vysočina kraj'),
(870, 56, 'KR', 'Královéhradecký kraj'),
(871, 56, 'LI', 'Liberecký kraj'),
(872, 56, 'MO', 'Moravskoslezský kraj'),
(873, 56, 'OL', 'Olomoucký kraj'),
(874, 56, 'PA', 'Pardubický kraj'),
(875, 56, 'PL', 'Plzeňský kraj'),
(876, 56, 'PR', 'Hlavní město Praha'),
(877, 56, 'ST', 'Středočeský kraj'),
(878, 56, 'US', 'Ústecký kraj'),
(879, 56, 'ZL', 'Zlínský kraj'),
(880, 57, '040', 'Bornholms Regionskommune'),
(881, 57, '101', 'København'),
(882, 57, '147', 'Frederiksberg'),
(883, 57, '070', 'Århus Amt'),
(884, 57, '015', 'Københavns Amt'),
(885, 57, '020', 'Frederiksborg Amt'),
(886, 57, '042', 'Fyns Amt'),
(887, 57, '080', 'Nordjyllands Amt'),
(888, 57, '055', 'Ribe Amt'),
(889, 57, '065', 'Ringkjøbing Amt'),
(890, 57, '025', 'Roskilde Amt'),
(891, 57, '050', 'Sønderjyllands Amt'),
(892, 57, '035', 'Storstrøms Amt'),
(893, 57, '060', 'Vejle Amt'),
(894, 57, '030', 'Vestsjællands Amt'),
(895, 57, '076', 'Viborg Amt'),
(896, 58, 'AS', 'Region d''Ali Sabieh'),
(897, 58, 'AR', 'Region d''Arta'),
(898, 58, 'DI', 'Region de Dikhil'),
(899, 58, 'DJ', 'Ville de Djibouti'),
(900, 58, 'OB', 'Region d''Obock'),
(901, 58, 'TA', 'Region de Tadjourah'),
(902, 59, 'AND', 'Saint Andrew Parish'),
(903, 59, 'DAV', 'Saint David Parish'),
(904, 59, 'GEO', 'Saint George Parish'),
(905, 59, 'JOH', 'Saint John Parish'),
(906, 59, 'JOS', 'Saint Joseph Parish'),
(907, 59, 'LUK', 'Saint Luke Parish'),
(908, 59, 'MAR', 'Saint Mark Parish'),
(909, 59, 'PAT', 'Saint Patrick Parish'),
(910, 59, 'PAU', 'Saint Paul Parish'),
(911, 59, 'PET', 'Saint Peter Parish'),
(912, 60, '01', 'Distrito Nacional'),
(913, 60, '02', 'Ázua'),
(914, 60, '03', 'Baoruco'),
(915, 60, '04', 'Barahona'),
(916, 60, '05', 'Dajabón'),
(917, 60, '06', 'Duarte'),
(918, 60, '07', 'Elías Piña'),
(919, 60, '08', 'El Seibo'),
(920, 60, '09', 'Espaillat'),
(921, 60, '10', 'Independencia'),
(922, 60, '11', 'La Altagracia'),
(923, 60, '12', 'La Romana'),
(924, 60, '13', 'La Vega'),
(925, 60, '14', 'María Trinidad Sánchez'),
(926, 60, '15', 'Monte Cristi'),
(927, 60, '16', 'Pedernales'),
(928, 60, '17', 'Peravia'),
(929, 60, '18', 'Puerto Plata'),
(930, 60, '19', 'Salcedo'),
(931, 60, '20', 'Samaná'),
(932, 60, '21', 'San Cristóbal'),
(933, 60, '22', 'San Juan'),
(934, 60, '23', 'San Pedro de Macorís'),
(935, 60, '24', 'Sánchez Ramírez'),
(936, 60, '25', 'Santiago'),
(937, 60, '26', 'Santiago Rodríguez'),
(938, 60, '27', 'Valverde'),
(939, 60, '28', 'Monseñor Nouel'),
(940, 60, '29', 'Monte Plata'),
(941, 60, '30', 'Hato Mayor'),
(942, 61, 'AL', 'Aileu'),
(943, 61, 'AN', 'Ainaro'),
(944, 61, 'BA', 'Baucau'),
(945, 61, 'BO', 'Bobonaro'),
(946, 61, 'CO', 'Cova-Lima'),
(947, 61, 'DI', 'Dili'),
(948, 61, 'ER', 'Ermera'),
(949, 61, 'LA', 'Lautem'),
(950, 61, 'LI', 'Liquiçá'),
(951, 61, 'MF', 'Manufahi'),
(952, 61, 'MT', 'Manatuto'),
(953, 61, 'OE', 'Oecussi'),
(954, 61, 'VI', 'Viqueque'),
(955, 62, 'A', 'Azuay'),
(956, 62, 'B', 'Bolívar'),
(957, 62, 'C', 'Carchi'),
(958, 62, 'D', 'Orellana'),
(959, 62, 'E', 'Esmeraldas'),
(960, 62, 'F', 'Cañar'),
(961, 62, 'G', 'Guayas'),
(962, 62, 'H', 'Chimborazo'),
(963, 62, 'I', 'Imbabura'),
(964, 62, 'L', 'Loja'),
(965, 62, 'M', 'Manabí'),
(966, 62, 'N', 'Napo'),
(967, 62, 'O', 'El Oro'),
(968, 62, 'P', 'Pichincha'),
(969, 62, 'R', 'Los Ríos'),
(970, 62, 'S', 'Morona-Santiago'),
(971, 62, 'T', 'Tungurahua'),
(972, 62, 'U', 'Sucumbíos'),
(973, 62, 'W', 'Galápagos'),
(974, 62, 'X', 'Cotopaxi'),
(975, 62, 'Y', 'Pastaza'),
(976, 62, 'Z', 'Zamora-Chinchipe'),
(977, 63, 'ALX', 'الإسكندرية'),
(978, 63, 'ASN', 'أسوان'),
(979, 63, 'AST', 'أسيوط'),
(980, 63, 'BA', 'البحر الأحمر'),
(981, 63, 'BH', 'البحيرة'),
(982, 63, 'BNS', 'بني سويف'),
(983, 63, 'C', 'القاهرة'),
(984, 63, 'DK', 'الدقهلية'),
(985, 63, 'DT', 'دمياط'),
(986, 63, 'FYM', 'الفيوم'),
(987, 63, 'GH', 'الغربية'),
(988, 63, 'GZ', 'الجيزة'),
(989, 63, 'IS', 'الإسماعيلية'),
(990, 63, 'JS', 'جنوب سيناء'),
(991, 63, 'KB', 'القليوبية'),
(992, 63, 'KFS', 'كفر الشيخ'),
(993, 63, 'KN', 'قنا'),
(994, 63, 'MN', 'محافظة المنيا'),
(995, 63, 'MNF', 'المنوفية'),
(996, 63, 'MT', 'مطروح'),
(997, 63, 'PTS', 'محافظة بور سعيد'),
(998, 63, 'SHG', 'محافظة سوهاج'),
(999, 63, 'SHR', 'المحافظة الشرقيّة'),
(1000, 63, 'SIN', 'شمال سيناء'),
(1001, 63, 'SUZ', 'السويس'),
(1002, 63, 'WAD', 'الوادى الجديد'),
(1003, 64, 'AH', 'Ahuachapán'),
(1004, 64, 'CA', 'Cabañas'),
(1005, 64, 'CH', 'Chalatenango'),
(1006, 64, 'CU', 'Cuscatlán'),
(1007, 64, 'LI', 'La Libertad'),
(1008, 64, 'MO', 'Morazán'),
(1009, 64, 'PA', 'La Paz'),
(1010, 64, 'SA', 'Santa Ana'),
(1011, 64, 'SM', 'San Miguel'),
(1012, 64, 'SO', 'Sonsonate'),
(1013, 64, 'SS', 'San Salvador'),
(1014, 64, 'SV', 'San Vicente'),
(1015, 64, 'UN', 'La Unión'),
(1016, 64, 'US', 'Usulután'),
(1017, 65, 'AN', 'Annobón'),
(1018, 65, 'BN', 'Bioko Norte'),
(1019, 65, 'BS', 'Bioko Sur'),
(1020, 65, 'CS', 'Centro Sur'),
(1021, 65, 'KN', 'Kié-Ntem'),
(1022, 65, 'LI', 'Litoral'),
(1023, 65, 'WN', 'Wele-Nzas'),
(1024, 66, 'AN', 'Zoba Anseba'),
(1025, 66, 'DK', 'Zoba Debubawi Keyih Bahri'),
(1026, 66, 'DU', 'Zoba Debub'),
(1027, 66, 'GB', 'Zoba Gash-Barka'),
(1028, 66, 'MA', 'Zoba Ma''akel'),
(1029, 66, 'SK', 'Zoba Semienawi Keyih Bahri'),
(1030, 67, '37', 'Harju maakond'),
(1031, 67, '39', 'Hiiu maakond'),
(1032, 67, '44', 'Ida-Viru maakond'),
(1033, 67, '49', 'Jõgeva maakond'),
(1034, 67, '51', 'Järva maakond'),
(1035, 67, '57', 'Lääne maakond'),
(1036, 67, '59', 'Lääne-Viru maakond'),
(1037, 67, '65', 'Põlva maakond'),
(1038, 67, '67', 'Pärnu maakond'),
(1039, 67, '70', 'Rapla maakond'),
(1040, 67, '74', 'Saare maakond'),
(1041, 67, '78', 'Tartu maakond'),
(1042, 67, '82', 'Valga maakond'),
(1043, 67, '84', 'Viljandi maakond'),
(1044, 67, '86', 'Võru maakond'),
(1045, 68, 'AA', 'አዲስ አበባ'),
(1046, 68, 'AF', 'አፋር'),
(1047, 68, 'AH', 'አማራ'),
(1048, 68, 'BG', 'ቤንሻንጉል-ጉምዝ'),
(1049, 68, 'DD', 'ድሬዳዋ'),
(1050, 68, 'GB', 'ጋምቤላ ሕዝቦች'),
(1051, 68, 'HR', 'ሀረሪ ሕዝብ'),
(1052, 68, 'OR', 'ኦሮሚያ'),
(1053, 68, 'SM', 'ሶማሌ'),
(1054, 68, 'SN', 'ደቡብ ብሔሮች ብሔረሰቦችና ሕዝቦች'),
(1055, 68, 'TG', 'ትግራይ'),
(1056, 71, 'C', 'Central'),
(1057, 71, 'E', 'Northern'),
(1058, 71, 'N', 'Eastern'),
(1059, 71, 'R', 'Rotuma'),
(1060, 71, 'W', 'Western'),
(1061, 72, 'AL', 'Ahvenanmaan maakunta'),
(1062, 72, 'ES', 'Etelä-Suomen lääni'),
(1063, 72, 'IS', 'Itä-Suomen lääni'),
(1064, 72, 'LL', 'Lapin lääni'),
(1065, 72, 'LS', 'Länsi-Suomen lääni'),
(1066, 72, 'OL', 'Oulun lääni'),
(1067, 73, '01', 'Ain'),
(1068, 73, '02', 'Aisne'),
(1069, 73, '03', 'Allier'),
(1070, 73, '04', 'Alpes-de-Haute-Provence'),
(1071, 73, '05', 'Hautes-Alpes'),
(1072, 73, '06', 'Alpes-Maritimes'),
(1073, 73, '07', 'Ardèche'),
(1074, 73, '08', 'Ardennes'),
(1075, 73, '09', 'Ariège'),
(1076, 73, '10', 'Aube'),
(1077, 73, '11', 'Aude'),
(1078, 73, '12', 'Aveyron'),
(1079, 73, '13', 'Bouches-du-Rhône'),
(1080, 73, '14', 'Calvados'),
(1081, 73, '15', 'Cantal'),
(1082, 73, '16', 'Charente'),
(1083, 73, '17', 'Charente-Maritime'),
(1084, 73, '18', 'Cher'),
(1085, 73, '19', 'Corrèze'),
(1086, 73, '21', 'Côte-d''Or'),
(1087, 73, '22', 'Côtes-d''Armor'),
(1088, 73, '23', 'Creuse'),
(1089, 73, '24', 'Dordogne'),
(1090, 73, '25', 'Doubs'),
(1091, 73, '26', 'Drôme'),
(1092, 73, '27', 'Eure'),
(1093, 73, '28', 'Eure-et-Loir'),
(1094, 73, '29', 'Finistère'),
(1095, 73, '2A', 'Corse-du-Sud'),
(1096, 73, '2B', 'Haute-Corse'),
(1097, 73, '30', 'Gard'),
(1098, 73, '31', 'Haute-Garonne'),
(1099, 73, '32', 'Gers'),
(1100, 73, '33', 'Gironde'),
(1101, 73, '34', 'Hérault'),
(1102, 73, '35', 'Ille-et-Vilaine'),
(1103, 73, '36', 'Indre'),
(1104, 73, '37', 'Indre-et-Loire'),
(1105, 73, '38', 'Isère'),
(1106, 73, '39', 'Jura'),
(1107, 73, '40', 'Landes'),
(1108, 73, '41', 'Loir-et-Cher'),
(1109, 73, '42', 'Loire'),
(1110, 73, '43', 'Haute-Loire'),
(1111, 73, '44', 'Loire-Atlantique'),
(1112, 73, '45', 'Loiret'),
(1113, 73, '46', 'Lot'),
(1114, 73, '47', 'Lot-et-Garonne'),
(1115, 73, '48', 'Lozère'),
(1116, 73, '49', 'Maine-et-Loire'),
(1117, 73, '50', 'Manche'),
(1118, 73, '51', 'Marne'),
(1119, 73, '52', 'Haute-Marne'),
(1120, 73, '53', 'Mayenne'),
(1121, 73, '54', 'Meurthe-et-Moselle'),
(1122, 73, '55', 'Meuse'),
(1123, 73, '56', 'Morbihan'),
(1124, 73, '57', 'Moselle'),
(1125, 73, '58', 'Nièvre'),
(1126, 73, '59', 'Nord'),
(1127, 73, '60', 'Oise'),
(1128, 73, '61', 'Orne'),
(1129, 73, '62', 'Pas-de-Calais'),
(1130, 73, '63', 'Puy-de-Dôme'),
(1131, 73, '64', 'Pyrénées-Atlantiques'),
(1132, 73, '65', 'Hautes-Pyrénées'),
(1133, 73, '66', 'Pyrénées-Orientales'),
(1134, 73, '67', 'Bas-Rhin'),
(1135, 73, '68', 'Haut-Rhin'),
(1136, 73, '69', 'Rhône'),
(1137, 73, '70', 'Haute-Saône'),
(1138, 73, '71', 'Saône-et-Loire'),
(1139, 73, '72', 'Sarthe'),
(1140, 73, '73', 'Savoie'),
(1141, 73, '74', 'Haute-Savoie'),
(1142, 73, '75', 'Paris'),
(1143, 73, '76', 'Seine-Maritime'),
(1144, 73, '77', 'Seine-et-Marne'),
(1145, 73, '78', 'Yvelines'),
(1146, 73, '79', 'Deux-Sèvres'),
(1147, 73, '80', 'Somme'),
(1148, 73, '81', 'Tarn'),
(1149, 73, '82', 'Tarn-et-Garonne'),
(1150, 73, '83', 'Var'),
(1151, 73, '84', 'Vaucluse'),
(1152, 73, '85', 'Vendée'),
(1153, 73, '86', 'Vienne'),
(1154, 73, '87', 'Haute-Vienne'),
(1155, 73, '88', 'Vosges'),
(1156, 73, '89', 'Yonne'),
(1157, 73, '90', 'Territoire de Belfort'),
(1158, 73, '91', 'Essonne'),
(1159, 73, '92', 'Hauts-de-Seine'),
(1160, 73, '93', 'Seine-Saint-Denis'),
(1161, 73, '94', 'Val-de-Marne'),
(1162, 73, '95', 'Val-d''Oise'),
(1163, 73, 'NC', 'Territoire des Nouvelle-Calédonie et Dependances'),
(1164, 73, 'PF', 'Polynésie Française'),
(1165, 73, 'PM', 'Saint-Pierre et Miquelon'),
(1166, 73, 'TF', 'Terres australes et antarctiques françaises'),
(1167, 73, 'YT', 'Mayotte'),
(1168, 73, 'WF', 'Territoire des îles Wallis et Futuna'),
(1169, 76, 'M', 'Archipel des Marquises'),
(1170, 76, 'T', 'Archipel des Tuamotu'),
(1171, 76, 'I', 'Archipel des Tubuai'),
(1172, 76, 'V', 'Iles du Vent'),
(1173, 76, 'S', 'Iles Sous-le-Vent '),
(1174, 77, 'C', 'Iles Crozet'),
(1175, 77, 'K', 'Iles Kerguelen'),
(1176, 77, 'A', 'Ile Amsterdam'),
(1177, 77, 'P', 'Ile Saint-Paul'),
(1178, 77, 'D', 'Adelie Land'),
(1179, 78, 'ES', 'Estuaire'),
(1180, 78, 'HO', 'Haut-Ogooue'),
(1181, 78, 'MO', 'Moyen-Ogooue'),
(1182, 78, 'NG', 'Ngounie'),
(1183, 78, 'NY', 'Nyanga'),
(1184, 78, 'OI', 'Ogooue-Ivindo'),
(1185, 78, 'OL', 'Ogooue-Lolo'),
(1186, 78, 'OM', 'Ogooue-Maritime'),
(1187, 78, 'WN', 'Woleu-Ntem'),
(1188, 79, 'AH', 'Ashanti'),
(1189, 79, 'BA', 'Brong-Ahafo'),
(1190, 79, 'CP', 'Central'),
(1191, 79, 'EP', 'Eastern'),
(1192, 79, 'AA', 'Greater Accra'),
(1193, 79, 'NP', 'Northern'),
(1194, 79, 'UE', 'Upper East'),
(1195, 79, 'UW', 'Upper West'),
(1196, 79, 'TV', 'Volta'),
(1197, 79, 'WP', 'Western'),
(1198, 80, 'AB', 'აფხაზეთი'),
(1199, 80, 'AJ', 'აჭარა'),
(1200, 80, 'GU', 'გურია'),
(1201, 80, 'IM', 'იმერეთი'),
(1202, 80, 'KA', 'კახეთი'),
(1203, 80, 'KK', 'ქვემო ქართლი'),
(1204, 80, 'MM', 'მცხეთა-მთიანეთი'),
(1205, 80, 'RL', 'რაჭა-ლეჩხუმი და ქვემო სვანეთი'),
(1206, 80, 'SJ', 'სამცხე-ჯავახეთი'),
(1207, 80, 'SK', 'შიდა ქართლი'),
(1208, 80, 'SZ', 'სამეგრელო-ზემო სვანეთი'),
(1209, 80, 'TB', 'თბილისი'),
(1210, 81, 'BE', 'Berlin'),
(1211, 81, 'BR', 'Brandenburg'),
(1212, 81, 'BW', 'Baden-Württemberg'),
(1213, 81, 'BY', 'Bayern'),
(1214, 81, 'HB', 'Bremen'),
(1215, 81, 'HE', 'Hessen'),
(1216, 81, 'HH', 'Hamburg'),
(1217, 81, 'MV', 'Mecklenburg-Vorpommern'),
(1218, 81, 'NI', 'Niedersachsen'),
(1219, 81, 'NW', 'Nordrhein-Westfalen'),
(1220, 81, 'RP', 'Rheinland-Pfalz'),
(1221, 81, 'SH', 'Schleswig-Holstein'),
(1222, 81, 'SL', 'Saarland'),
(1223, 81, 'SN', 'Sachsen'),
(1224, 81, 'ST', 'Sachsen-Anhalt'),
(1225, 81, 'TH', 'Thüringen'),
(1226, 82, 'AA', 'Greater Accra'),
(1227, 82, 'AH', 'Ashanti'),
(1228, 82, 'BA', 'Brong-Ahafo'),
(1229, 82, 'CP', 'Central'),
(1230, 82, 'EP', 'Eastern'),
(1231, 82, 'NP', 'Northern'),
(1232, 82, 'TV', 'Volta'),
(1233, 82, 'UE', 'Upper East'),
(1234, 82, 'UW', 'Upper West'),
(1235, 82, 'WP', 'Western'),
(1236, 84, '01', 'Αιτωλοακαρνανία'),
(1237, 84, '03', 'Βοιωτία'),
(1238, 84, '04', 'Εύβοια'),
(1239, 84, '05', 'Ευρυτανία'),
(1240, 84, '06', 'Φθιώτιδα'),
(1241, 84, '07', 'Φωκίδα'),
(1242, 84, '11', 'Αργολίδα'),
(1243, 84, '12', 'Αρκαδία'),
(1244, 84, '13', 'Ἀχαΐα'),
(1245, 84, '14', 'Ηλεία'),
(1246, 84, '15', 'Κορινθία'),
(1247, 84, '16', 'Λακωνία'),
(1248, 84, '17', 'Μεσσηνία'),
(1249, 84, '21', 'Ζάκυνθος'),
(1250, 84, '22', 'Κέρκυρα'),
(1251, 84, '23', 'Κεφαλλονιά'),
(1252, 84, '24', 'Λευκάδα'),
(1253, 84, '31', 'Άρτα'),
(1254, 84, '32', 'Θεσπρωτία'),
(1255, 84, '33', 'Ιωάννινα'),
(1256, 84, '34', 'Πρεβεζα'),
(1257, 84, '41', 'Καρδίτσα'),
(1258, 84, '42', 'Λάρισα'),
(1259, 84, '43', 'Μαγνησία'),
(1260, 84, '44', 'Τρίκαλα'),
(1261, 84, '51', 'Γρεβενά'),
(1262, 84, '52', 'Δράμα'),
(1263, 84, '53', 'Ημαθία'),
(1264, 84, '54', 'Θεσσαλονίκη'),
(1265, 84, '55', 'Καβάλα'),
(1266, 84, '56', 'Καστοριά'),
(1267, 84, '57', 'Κιλκίς'),
(1268, 84, '58', 'Κοζάνη'),
(1269, 84, '59', 'Πέλλα'),
(1270, 84, '61', 'Πιερία'),
(1271, 84, '62', 'Σερρών'),
(1272, 84, '63', 'Φλώρινα'),
(1273, 84, '64', 'Χαλκιδική'),
(1274, 84, '69', 'Όρος Άθως'),
(1275, 84, '71', 'Έβρος'),
(1276, 84, '72', 'Ξάνθη'),
(1277, 84, '73', 'Ροδόπη'),
(1278, 84, '81', 'Δωδεκάνησα'),
(1279, 84, '82', 'Κυκλάδες'),
(1280, 84, '83', 'Λέσβου'),
(1281, 84, '84', 'Σάμος'),
(1282, 84, '85', 'Χίος'),
(1283, 84, '91', 'Ηράκλειο'),
(1284, 84, '92', 'Λασίθι'),
(1285, 84, '93', 'Ρεθύμνο'),
(1286, 84, '94', 'Χανίων'),
(1287, 84, 'A1', 'Αττική'),
(1288, 85, 'A', 'Avannaa'),
(1289, 85, 'T', 'Tunu '),
(1290, 85, 'K', 'Kitaa'),
(1291, 86, 'A', 'Saint Andrew'),
(1292, 86, 'D', 'Saint David'),
(1293, 86, 'G', 'Saint George'),
(1294, 86, 'J', 'Saint John'),
(1295, 86, 'M', 'Saint Mark'),
(1296, 86, 'P', 'Saint Patrick'),
(1297, 89, 'AV', 'Alta Verapaz'),
(1298, 89, 'BV', 'Baja Verapaz'),
(1299, 89, 'CM', 'Chimaltenango'),
(1300, 89, 'CQ', 'Chiquimula'),
(1301, 89, 'ES', 'Escuintla'),
(1302, 89, 'GU', 'Guatemala'),
(1303, 89, 'HU', 'Huehuetenango'),
(1304, 89, 'IZ', 'Izabal'),
(1305, 89, 'JA', 'Jalapa'),
(1306, 89, 'JU', 'Jutiapa'),
(1307, 89, 'PE', 'El Petén'),
(1308, 89, 'PR', 'El Progreso'),
(1309, 89, 'QC', 'El Quiché'),
(1310, 89, 'QZ', 'Quetzaltenango'),
(1311, 89, 'RE', 'Retalhuleu'),
(1312, 89, 'SA', 'Sacatepéquez'),
(1313, 89, 'SM', 'San Marcos'),
(1314, 89, 'SO', 'Sololá'),
(1315, 89, 'SR', 'Santa Rosa'),
(1316, 89, 'SU', 'Suchitepéquez'),
(1317, 89, 'TO', 'Totonicapán'),
(1318, 89, 'ZA', 'Zacapa'),
(1319, 90, 'BE', 'Beyla'),
(1320, 90, 'BF', 'Boffa'),
(1321, 90, 'BK', 'Boké'),
(1322, 90, 'CO', 'Coyah'),
(1323, 90, 'DB', 'Dabola'),
(1324, 90, 'DI', 'Dinguiraye'),
(1325, 90, 'DL', 'Dalaba'),
(1326, 90, 'DU', 'Dubréka'),
(1327, 90, 'FA', 'Faranah'),
(1328, 90, 'FO', 'Forécariah'),
(1329, 90, 'FR', 'Fria'),
(1330, 90, 'GA', 'Gaoual'),
(1331, 90, 'GU', 'Guékédou'),
(1332, 90, 'KA', 'Kankan'),
(1333, 90, 'KB', 'Koubia'),
(1334, 90, 'KD', 'Kindia'),
(1335, 90, 'KE', 'Kérouané'),
(1336, 90, 'KN', 'Koundara'),
(1337, 90, 'KO', 'Kouroussa'),
(1338, 90, 'KS', 'Kissidougou'),
(1339, 90, 'LA', 'Labé'),
(1340, 90, 'LE', 'Lélouma'),
(1341, 90, 'LO', 'Lola'),
(1342, 90, 'MC', 'Macenta'),
(1343, 90, 'MD', 'Mandiana'),
(1344, 90, 'ML', 'Mali'),
(1345, 90, 'MM', 'Mamou'),
(1346, 90, 'NZ', 'Nzérékoré'),
(1347, 90, 'PI', 'Pita'),
(1348, 90, 'SI', 'Siguiri'),
(1349, 90, 'TE', 'Télimélé'),
(1350, 90, 'TO', 'Tougué'),
(1351, 90, 'YO', 'Yomou'),
(1352, 91, 'BF', 'Bafata'),
(1353, 91, 'BB', 'Biombo'),
(1354, 91, 'BS', 'Bissau'),
(1355, 91, 'BL', 'Bolama'),
(1356, 91, 'CA', 'Cacheu'),
(1357, 91, 'GA', 'Gabu'),
(1358, 91, 'OI', 'Oio'),
(1359, 91, 'QU', 'Quinara'),
(1360, 91, 'TO', 'Tombali'),
(1361, 92, 'BA', 'Barima-Waini'),
(1362, 92, 'CU', 'Cuyuni-Mazaruni'),
(1363, 92, 'DE', 'Demerara-Mahaica'),
(1364, 92, 'EB', 'East Berbice-Corentyne'),
(1365, 92, 'ES', 'Essequibo Islands-West Demerara'),
(1366, 92, 'MA', 'Mahaica-Berbice'),
(1367, 92, 'PM', 'Pomeroon-Supenaam'),
(1368, 92, 'PT', 'Potaro-Siparuni'),
(1369, 92, 'UD', 'Upper Demerara-Berbice'),
(1370, 92, 'UT', 'Upper Takutu-Upper Essequibo'),
(1371, 93, 'AR', 'Artibonite'),
(1372, 93, 'CE', 'Centre'),
(1373, 93, 'GA', 'Grand''Anse'),
(1374, 93, 'NI', 'Nippes'),
(1375, 93, 'ND', 'Nord'),
(1376, 93, 'NE', 'Nord-Est'),
(1377, 93, 'NO', 'Nord-Ouest'),
(1378, 93, 'OU', 'Ouest'),
(1379, 93, 'SD', 'Sud'),
(1380, 93, 'SE', 'Sud-Est'),
(1381, 94, 'F', 'Flat Island'),
(1382, 94, 'M', 'McDonald Island'),
(1383, 94, 'S', 'Shag Island'),
(1384, 94, 'H', 'Heard Island'),
(1385, 95, 'AT', 'Atlántida'),
(1386, 95, 'CH', 'Choluteca'),
(1387, 95, 'CL', 'Colón'),
(1388, 95, 'CM', 'Comayagua'),
(1389, 95, 'CP', 'Copán'),
(1390, 95, 'CR', 'Cortés'),
(1391, 95, 'EP', 'El Paraíso'),
(1392, 95, 'FM', 'Francisco Morazán'),
(1393, 95, 'GD', 'Gracias a Dios'),
(1394, 95, 'IB', 'Islas de la Bahía'),
(1395, 95, 'IN', 'Intibucá'),
(1396, 95, 'LE', 'Lempira'),
(1397, 95, 'LP', 'La Paz'),
(1398, 95, 'OC', 'Ocotepeque'),
(1399, 95, 'OL', 'Olancho'),
(1400, 95, 'SB', 'Santa Bárbara'),
(1401, 95, 'VA', 'Valle'),
(1402, 95, 'YO', 'Yoro'),
(1403, 96, 'HCW', '中西區'),
(1404, 96, 'HEA', '東區'),
(1405, 96, 'HSO', '南區'),
(1406, 96, 'HWC', '灣仔區'),
(1407, 96, 'KKC', '九龍城區'),
(1408, 96, 'KKT', '觀塘區'),
(1409, 96, 'KSS', '深水埗區'),
(1410, 96, 'KWT', '黃大仙區'),
(1411, 96, 'KYT', '油尖旺區'),
(1412, 96, 'NIS', '離島區'),
(1413, 96, 'NKT', '葵青區'),
(1414, 96, 'NNO', '北區'),
(1415, 96, 'NSK', '西貢區'),
(1416, 96, 'NST', '沙田區'),
(1417, 96, 'NTP', '大埔區'),
(1418, 96, 'NTW', '荃灣區'),
(1419, 96, 'NTM', '屯門區'),
(1420, 96, 'NYL', '元朗區'),
(1421, 97, 'BA', 'Baranja megye'),
(1422, 97, 'BC', 'Békéscsaba'),
(1423, 97, 'BE', 'Békés megye'),
(1424, 97, 'BK', 'Bács-Kiskun megye'),
(1425, 97, 'BU', 'Budapest'),
(1426, 97, 'BZ', 'Borsod-Abaúj-Zemplén megye'),
(1427, 97, 'CS', 'Csongrád megye'),
(1428, 97, 'DE', 'Debrecen'),
(1429, 97, 'DU', 'Dunaújváros'),
(1430, 97, 'EG', 'Eger'),
(1431, 97, 'FE', 'Fejér megye'),
(1432, 97, 'GS', 'Győr-Moson-Sopron megye'),
(1433, 97, 'GY', 'Győr'),
(1434, 97, 'HB', 'Hajdú-Bihar megye'),
(1435, 97, 'HE', 'Heves megye'),
(1436, 97, 'HV', 'Hódmezővásárhely'),
(1437, 97, 'JN', 'Jász-Nagykun-Szolnok megye'),
(1438, 97, 'KE', 'Komárom-Esztergom megye'),
(1439, 97, 'KM', 'Kecskemét'),
(1440, 97, 'KV', 'Kaposvár'),
(1441, 97, 'MI', 'Miskolc'),
(1442, 97, 'NK', 'Nagykanizsa'),
(1443, 97, 'NO', 'Nógrád megye'),
(1444, 97, 'NY', 'Nyíregyháza'),
(1445, 97, 'PE', 'Pest megye'),
(1446, 97, 'PS', 'Pécs'),
(1447, 97, 'SD', 'Szeged'),
(1448, 97, 'SF', 'Székesfehérvár'),
(1449, 97, 'SH', 'Szombathely'),
(1450, 97, 'SK', 'Szolnok'),
(1451, 97, 'SN', 'Sopron'),
(1452, 97, 'SO', 'Somogy megye'),
(1453, 97, 'SS', 'Szekszárd'),
(1454, 97, 'ST', 'Salgótarján'),
(1455, 97, 'SZ', 'Szabolcs-Szatmár-Bereg megye'),
(1456, 97, 'TB', 'Tatabánya'),
(1457, 97, 'TO', 'Tolna megye'),
(1458, 97, 'VA', 'Vas megye'),
(1459, 97, 'VE', 'Veszprém megye'),
(1460, 97, 'VM', 'Veszprém'),
(1461, 97, 'ZA', 'Zala megye'),
(1462, 97, 'ZE', 'Zalaegerszeg'),
(1463, 98, '1', 'Höfuðborgarsvæðið'),
(1464, 98, '2', 'Suðurnes'),
(1465, 98, '3', 'Vesturland'),
(1466, 98, '4', 'Vestfirðir'),
(1467, 98, '5', 'Norðurland vestra'),
(1468, 98, '6', 'Norðurland eystra'),
(1469, 98, '7', 'Austfirðir'),
(1470, 98, '8', 'Suðurland'),
(1471, 99, 'IN-AN', 'अंडमान और निकोबार द्वीप'),
(1472, 99, 'IN-AP', 'ఆంధ్ర ప్రదేశ్'),
(1473, 99, 'IN-AR', 'अरुणाचल प्रदेश'),
(1474, 99, 'IN-AS', 'অসম'),
(1475, 99, 'IN-BR', 'बिहार'),
(1476, 99, 'IN-CH', 'चंडीगढ़'),
(1477, 99, 'IN-CT', 'छत्तीसगढ़'),
(1478, 99, 'IN-DD', 'દમણ અને દિવ'),
(1479, 99, 'IN-DL', 'दिल्ली'),
(1480, 99, 'IN-DN', 'દાદરા અને નગર હવેલી'),
(1481, 99, 'IN-GA', 'गोंय'),
(1482, 99, 'IN-GJ', 'ગુજરાત'),
(1483, 99, 'IN-HP', 'हिमाचल प्रदेश'),
(1484, 99, 'IN-HR', 'हरियाणा'),
(1485, 99, 'IN-JH', 'झारखंड'),
(1486, 99, 'IN-JK', 'जम्मू और कश्मीर'),
(1487, 99, 'IN-KA', 'ಕನಾ೯ಟಕ'),
(1488, 99, 'IN-KL', 'കേരളം'),
(1489, 99, 'IN-LD', 'ലക്ഷദ്വീപ്'),
(1490, 99, 'IN-ML', 'मेघालय'),
(1491, 99, 'IN-MH', 'महाराष्ट्र'),
(1492, 99, 'IN-MN', 'मणिपुर'),
(1493, 99, 'IN-MP', 'मध्य प्रदेश'),
(1494, 99, 'IN-MZ', 'मिज़ोरम'),
(1495, 99, 'IN-NL', 'नागालैंड'),
(1496, 99, 'IN-OR', 'उड़ीसा'),
(1497, 99, 'IN-PB', 'ਪੰਜਾਬ'),
(1498, 99, 'IN-PY', 'புதுச்சேரி'),
(1499, 99, 'IN-RJ', 'राजस्थान'),
(1500, 99, 'IN-SK', 'सिक्किम'),
(1501, 99, 'IN-TN', 'தமிழ் நாடு'),
(1502, 99, 'IN-TR', 'ত্রিপুরা'),
(1503, 99, 'IN-UL', 'उत्तरांचल'),
(1504, 99, 'IN-UP', 'उत्तर प्रदेश'),
(1505, 99, 'IN-WB', 'পশ্চিমবঙ্গ'),
(1506, 100, 'AC', 'Aceh'),
(1507, 100, 'BA', 'Bali'),
(1508, 100, 'BB', 'Bangka-Belitung'),
(1509, 100, 'BE', 'Bengkulu'),
(1510, 100, 'BT', 'Banten'),
(1511, 100, 'GO', 'Gorontalo'),
(1512, 100, 'IJ', 'Papua'),
(1513, 100, 'JA', 'Jambi'),
(1514, 100, 'JI', 'Jawa Timur'),
(1515, 100, 'JK', 'Jakarta Raya'),
(1516, 100, 'JR', 'Jawa Barat'),
(1517, 100, 'JT', 'Jawa Tengah'),
(1518, 100, 'KB', 'Kalimantan Barat'),
(1519, 100, 'KI', 'Kalimantan Timur'),
(1520, 100, 'KS', 'Kalimantan Selatan'),
(1521, 100, 'KT', 'Kalimantan Tengah'),
(1522, 100, 'LA', 'Lampung'),
(1523, 100, 'MA', 'Maluku'),
(1524, 100, 'MU', 'Maluku Utara'),
(1525, 100, 'NB', 'Nusa Tenggara Barat'),
(1526, 100, 'NT', 'Nusa Tenggara Timur'),
(1527, 100, 'RI', 'Riau'),
(1528, 100, 'SB', 'Sumatera Barat'),
(1529, 100, 'SG', 'Sulawesi Tenggara'),
(1530, 100, 'SL', 'Sumatera Selatan'),
(1531, 100, 'SN', 'Sulawesi Selatan'),
(1532, 100, 'ST', 'Sulawesi Tengah'),
(1533, 100, 'SW', 'Sulawesi Utara'),
(1534, 100, 'SU', 'Sumatera Utara'),
(1535, 100, 'YO', 'Yogyakarta'),
(1536, 101, '01', 'محافظة آذربایجان شرقي'),
(1537, 101, '02', 'محافظة آذربایجان غربي'),
(1538, 101, '03', 'محافظة اردبیل'),
(1539, 101, '04', 'محافظة اصفهان'),
(1540, 101, '05', 'محافظة ایلام'),
(1541, 101, '06', 'محافظة بوشهر'),
(1542, 101, '07', 'محافظة طهران'),
(1543, 101, '08', 'محافظة چهارمحل و بختیاري'),
(1544, 101, '09', 'محافظة خراسان رضوي'),
(1545, 101, '10', 'محافظة خوزستان'),
(1546, 101, '11', 'محافظة زنجان'),
(1547, 101, '12', 'محافظة سمنان'),
(1548, 101, '13', 'محافظة سيستان وبلوتشستان'),
(1549, 101, '14', 'محافظة فارس'),
(1550, 101, '15', 'محافظة کرمان'),
(1551, 101, '16', 'محافظة کردستان'),
(1552, 101, '17', 'محافظة کرمانشاه'),
(1553, 101, '18', 'محافظة کهکیلویه و بویر أحمد'),
(1554, 101, '19', 'محافظة گیلان'),
(1555, 101, '20', 'محافظة لرستان'),
(1556, 101, '21', 'محافظة مازندران'),
(1557, 101, '22', 'محافظة مرکزي'),
(1558, 101, '23', 'محافظة هرمزگان'),
(1559, 101, '24', 'محافظة همدان'),
(1560, 101, '25', 'محافظة یزد'),
(1561, 101, '26', 'محافظة قم'),
(1562, 101, '27', 'محافظة گلستان'),
(1563, 101, '28', 'محافظة قزوين'),
(1564, 102, 'AN', 'محافظة الأنبار'),
(1565, 102, 'AR', 'أربيل'),
(1566, 102, 'BA', 'محافظة البصرة'),
(1567, 102, 'BB', 'بابل'),
(1568, 102, 'BG', 'محافظة بغداد'),
(1569, 102, 'DA', 'دهوك'),
(1570, 102, 'DI', 'ديالى'),
(1571, 102, 'DQ', 'ذي قار'),
(1572, 102, 'KA', 'كربلاء'),
(1573, 102, 'MA', 'ميسان'),
(1574, 102, 'MU', 'المثنى'),
(1575, 102, 'NA', 'النجف'),
(1576, 102, 'NI', 'نینوى'),
(1577, 102, 'QA', 'القادسية'),
(1578, 102, 'SD', 'صلاح الدين'),
(1579, 102, 'SW', 'محافظة السليمانية'),
(1580, 102, 'TS', 'التأمیم'),
(1581, 102, 'WA', 'واسط'),
(1582, 103, 'C', 'Corcaigh'),
(1583, 103, 'CE', 'Contae an Chláir'),
(1584, 103, 'CN', 'An Cabhán'),
(1585, 103, 'CW', 'Ceatharlach'),
(1586, 103, 'D', 'Baile Átha Cliath'),
(1587, 103, 'DL', 'Dún na nGall'),
(1588, 103, 'G', 'Gaillimh'),
(1589, 103, 'KE', 'Cill Dara');
INSERT INTO `[[dbprefix]]zones` VALUES
(1590, 103, 'KK', 'Cill Chainnigh'),
(1591, 103, 'KY', 'Contae Chiarraí'),
(1592, 103, 'LD', 'An Longfort'),
(1593, 103, 'LH', 'Contae Lú'),
(1594, 103, 'LK', 'Luimneach'),
(1595, 103, 'LM', 'Contae Liatroma'),
(1596, 103, 'LS', 'Contae Laoise'),
(1597, 103, 'MH', 'Contae na Mí'),
(1598, 103, 'MN', 'Muineachán'),
(1599, 103, 'MO', 'Contae Mhaigh Eo'),
(1600, 103, 'OY', 'Contae Uíbh Fhailí'),
(1601, 103, 'RN', 'Ros Comáin'),
(1602, 103, 'SO', 'Sligeach'),
(1603, 103, 'TA', 'Tiobraid Árann'),
(1604, 103, 'WD', 'Port Lairge'),
(1605, 103, 'WH', 'Contae na hIarmhí'),
(1606, 103, 'WW', 'Cill Mhantáin'),
(1607, 103, 'WX', 'Loch Garman'),
(1608, 104, 'D ', 'מחוז הדרום'),
(1609, 104, 'HA', 'מחוז חיפה'),
(1610, 104, 'JM', 'ירושלים'),
(1611, 104, 'M ', 'מחוז המרכז'),
(1612, 104, 'TA', 'תל אביב-יפו'),
(1613, 104, 'Z ', 'מחוז הצפון'),
(1614, 105, 'AG', 'Agrigento'),
(1615, 105, 'AL', 'Alessandria'),
(1616, 105, 'AN', 'Ancona'),
(1617, 105, 'AO', 'Valle d''Aosta'),
(1618, 105, 'AP', 'Ascoli Piceno'),
(1619, 105, 'AQ', 'L''Aquila'),
(1620, 105, 'AR', 'Arezzo'),
(1621, 105, 'AT', 'Asti'),
(1622, 105, 'AV', 'Avellino'),
(1623, 105, 'BA', 'Bari'),
(1624, 105, 'BG', 'Bergamo'),
(1625, 105, 'BI', 'Biella'),
(1626, 105, 'BL', 'Belluno'),
(1627, 105, 'BN', 'Benevento'),
(1628, 105, 'BO', 'Bologna'),
(1629, 105, 'BR', 'Brindisi'),
(1630, 105, 'BS', 'Brescia'),
(1631, 105, 'BT', 'Barletta-Andria-Trani'),
(1632, 105, 'BZ', 'Alto Adige'),
(1633, 105, 'CA', 'Cagliari'),
(1634, 105, 'CB', 'Campobasso'),
(1635, 105, 'CE', 'Caserta'),
(1636, 105, 'CH', 'Chieti'),
(1637, 105, 'CI', 'Carbonia-Iglesias'),
(1638, 105, 'CL', 'Caltanissetta'),
(1639, 105, 'CN', 'Cuneo'),
(1640, 105, 'CO', 'Como'),
(1641, 105, 'CR', 'Cremona'),
(1642, 105, 'CS', 'Cosenza'),
(1643, 105, 'CT', 'Catania'),
(1644, 105, 'CZ', 'Catanzaro'),
(1645, 105, 'EN', 'Enna'),
(1646, 105, 'FE', 'Ferrara'),
(1647, 105, 'FG', 'Foggia'),
(1648, 105, 'FI', 'Firenze'),
(1649, 105, 'FM', 'Fermo'),
(1650, 105, 'FO', 'Forlì-Cesena'),
(1651, 105, 'FR', 'Frosinone'),
(1652, 105, 'GE', 'Genova'),
(1653, 105, 'GO', 'Gorizia'),
(1654, 105, 'GR', 'Grosseto'),
(1655, 105, 'IM', 'Imperia'),
(1656, 105, 'IS', 'Isernia'),
(1657, 105, 'KR', 'Crotone'),
(1658, 105, 'LC', 'Lecco'),
(1659, 105, 'LE', 'Lecce'),
(1660, 105, 'LI', 'Livorno'),
(1661, 105, 'LO', 'Lodi'),
(1662, 105, 'LT', 'Latina'),
(1663, 105, 'LU', 'Lucca'),
(1664, 105, 'MC', 'Macerata'),
(1665, 105, 'MD', 'Medio Campidano'),
(1666, 105, 'ME', 'Messina'),
(1667, 105, 'MI', 'Milano'),
(1668, 105, 'MN', 'Mantova'),
(1669, 105, 'MO', 'Modena'),
(1670, 105, 'MS', 'Massa-Carrara'),
(1671, 105, 'MT', 'Matera'),
(1672, 105, 'MZ', 'Monza e Brianza'),
(1673, 105, 'NA', 'Napoli'),
(1674, 105, 'NO', 'Novara'),
(1675, 105, 'NU', 'Nuoro'),
(1676, 105, 'OG', 'Ogliastra'),
(1677, 105, 'OR', 'Oristano'),
(1678, 105, 'OT', 'Olbia-Tempio'),
(1679, 105, 'PA', 'Palermo'),
(1680, 105, 'PC', 'Piacenza'),
(1681, 105, 'PD', 'Padova'),
(1682, 105, 'PE', 'Pescara'),
(1683, 105, 'PG', 'Perugia'),
(1684, 105, 'PI', 'Pisa'),
(1685, 105, 'PN', 'Pordenone'),
(1686, 105, 'PO', 'Prato'),
(1687, 105, 'PR', 'Parma'),
(1688, 105, 'PS', 'Pesaro e Urbino'),
(1689, 105, 'PT', 'Pistoia'),
(1690, 105, 'PV', 'Pavia'),
(1691, 105, 'PZ', 'Potenza'),
(1692, 105, 'RA', 'Ravenna'),
(1693, 105, 'RC', 'Reggio Calabria'),
(1694, 105, 'RE', 'Reggio Emilia'),
(1695, 105, 'RG', 'Ragusa'),
(1696, 105, 'RI', 'Rieti'),
(1697, 105, 'RM', 'Roma'),
(1698, 105, 'RN', 'Rimini'),
(1699, 105, 'RO', 'Rovigo'),
(1700, 105, 'SA', 'Salerno'),
(1701, 105, 'SI', 'Siena'),
(1702, 105, 'SO', 'Sondrio'),
(1703, 105, 'SP', 'La Spezia'),
(1704, 105, 'SR', 'Siracusa'),
(1705, 105, 'SS', 'Sassari'),
(1706, 105, 'SV', 'Savona'),
(1707, 105, 'TA', 'Taranto'),
(1708, 105, 'TE', 'Teramo'),
(1709, 105, 'TN', 'Trento'),
(1710, 105, 'TO', 'Torino'),
(1711, 105, 'TP', 'Trapani'),
(1712, 105, 'TR', 'Terni'),
(1713, 105, 'TS', 'Trieste'),
(1714, 105, 'TV', 'Treviso'),
(1715, 105, 'UD', 'Udine'),
(1716, 105, 'VA', 'Varese'),
(1717, 105, 'VB', 'Verbano-Cusio-Ossola'),
(1718, 105, 'VC', 'Vercelli'),
(1719, 105, 'VE', 'Venezia'),
(1720, 105, 'VI', 'Vicenza'),
(1721, 105, 'VR', 'Verona'),
(1722, 105, 'VT', 'Viterbo'),
(1723, 105, 'VV', 'Vibo Valentia'),
(1724, 106, '01', 'Kingston'),
(1725, 106, '02', 'Half Way Tree'),
(1726, 106, '03', 'Morant Bay'),
(1727, 106, '04', 'Port Antonio'),
(1728, 106, '05', 'Port Maria'),
(1729, 106, '06', 'Saint Ann''s Bay'),
(1730, 106, '07', 'Falmouth'),
(1731, 106, '08', 'Montego Bay'),
(1732, 106, '09', 'Lucea'),
(1733, 106, '10', 'Savanna-la-Mar'),
(1734, 106, '11', 'Black River'),
(1735, 106, '12', 'Mandeville'),
(1736, 106, '13', 'May Pen'),
(1737, 106, '14', 'Spanish Town'),
(1738, 107, '01', '北海道'),
(1739, 107, '02', '青森'),
(1740, 107, '03', '岩手'),
(1741, 107, '04', '宮城'),
(1742, 107, '05', '秋田'),
(1743, 107, '06', '山形'),
(1744, 107, '07', '福島'),
(1745, 107, '08', '茨城'),
(1746, 107, '09', '栃木'),
(1747, 107, '10', '群馬'),
(1748, 107, '11', '埼玉'),
(1749, 107, '12', '千葉'),
(1750, 107, '13', '東京'),
(1751, 107, '14', '神奈川'),
(1752, 107, '15', '新潟'),
(1753, 107, '16', '富山'),
(1754, 107, '17', '石川'),
(1755, 107, '18', '福井'),
(1756, 107, '19', '山梨'),
(1757, 107, '20', '長野'),
(1758, 107, '21', '岐阜'),
(1759, 107, '22', '静岡'),
(1760, 107, '23', '愛知'),
(1761, 107, '24', '三重'),
(1762, 107, '25', '滋賀'),
(1763, 107, '26', '京都'),
(1764, 107, '27', '大阪'),
(1765, 107, '28', '兵庫'),
(1766, 107, '29', '奈良'),
(1767, 107, '30', '和歌山'),
(1768, 107, '31', '鳥取'),
(1769, 107, '32', '島根'),
(1770, 107, '33', '岡山'),
(1771, 107, '34', '広島'),
(1772, 107, '35', '山口'),
(1773, 107, '36', '徳島'),
(1774, 107, '37', '香川'),
(1775, 107, '38', '愛媛'),
(1776, 107, '39', '高知'),
(1777, 107, '40', '福岡'),
(1778, 107, '41', '佐賀'),
(1779, 107, '42', '長崎'),
(1780, 107, '43', '熊本'),
(1781, 107, '44', '大分'),
(1782, 107, '45', '宮崎'),
(1783, 107, '46', '鹿児島'),
(1784, 107, '47', '沖縄'),
(1785, 108, 'AJ', 'محافظة عجلون'),
(1786, 108, 'AM', 'محافظة العاصمة'),
(1787, 108, 'AQ', 'محافظة العقبة'),
(1788, 108, 'AT', 'محافظة الطفيلة'),
(1789, 108, 'AZ', 'محافظة الزرقاء'),
(1790, 108, 'BA', 'محافظة البلقاء'),
(1791, 108, 'JA', 'محافظة جرش'),
(1792, 108, 'JR', 'محافظة إربد'),
(1793, 108, 'KA', 'محافظة الكرك'),
(1794, 108, 'MA', 'محافظة المفرق'),
(1795, 108, 'MD', 'محافظة مادبا'),
(1796, 108, 'MN', 'محافظة معان'),
(1797, 109, 'AL', 'Алматы'),
(1798, 109, 'AC', 'Almaty City'),
(1799, 109, 'AM', 'Ақмола'),
(1800, 109, 'AQ', 'Ақтөбе'),
(1801, 109, 'AS', 'Астана'),
(1802, 109, 'AT', 'Атырау'),
(1803, 109, 'BA', 'Батыс Қазақстан'),
(1804, 109, 'BY', 'Байқоңыр'),
(1805, 109, 'MA', 'Маңғыстау'),
(1806, 109, 'ON', 'Оңтүстік Қазақстан'),
(1807, 109, 'PA', 'Павлодар'),
(1808, 109, 'QA', 'Қарағанды'),
(1809, 109, 'QO', 'Қостанай'),
(1810, 109, 'QY', 'Қызылорда'),
(1811, 109, 'SH', 'Шығыс Қазақстан'),
(1812, 109, 'SO', 'Солтүстік Қазақстан'),
(1813, 109, 'ZH', 'Жамбыл'),
(1814, 110, '110', 'Nairobi'),
(1815, 110, '200', 'Central'),
(1816, 110, '300', 'Mombasa'),
(1817, 110, '400', 'Eastern'),
(1818, 110, '500', 'North Eastern'),
(1819, 110, '600', 'Nyanza'),
(1820, 110, '700', 'Rift Valley'),
(1821, 110, '900', 'Western'),
(1822, 111, 'G', 'Gilbert Islands'),
(1823, 111, 'L', 'Line Islands'),
(1824, 111, 'P', 'Phoenix Islands'),
(1825, 112, 'CHA', '자강도'),
(1826, 112, 'HAB', '함경 북도'),
(1827, 112, 'HAN', '함경 남도'),
(1828, 112, 'HWB', '황해 북도'),
(1829, 112, 'HWN', '황해 남도'),
(1830, 112, 'KAN', '강원도'),
(1831, 112, 'KAE', '개성시'),
(1832, 112, 'NAJ', '라선 직할시'),
(1833, 112, 'NAM', '남포 특급시'),
(1834, 112, 'PYB', '평안 북도'),
(1835, 112, 'PYN', '평안 남도'),
(1836, 112, 'PYO', '평양 직할시'),
(1837, 112, 'YAN', '량강도'),
(1838, 113, '11', '서울특별시'),
(1839, 113, '26', '부산 광역시'),
(1840, 113, '27', '대구 광역시'),
(1841, 113, '28', '인천광역시'),
(1842, 113, '29', '광주 광역시'),
(1843, 113, '30', '대전 광역시'),
(1844, 113, '31', '울산 광역시'),
(1845, 113, '41', '경기도'),
(1846, 113, '42', '강원도'),
(1847, 113, '43', '충청 북도'),
(1848, 113, '44', '충청 남도'),
(1849, 113, '45', '전라 북도'),
(1850, 113, '46', '전라 남도'),
(1851, 113, '47', '경상 북도'),
(1852, 113, '48', '경상 남도'),
(1853, 113, '49', '제주특별자치도'),
(1854, 114, 'AH', 'الاحمدي'),
(1855, 114, 'FA', 'الفروانية'),
(1856, 114, 'JA', 'الجهراء'),
(1857, 114, 'KU', 'ألعاصمه'),
(1858, 114, 'HW', 'حولي'),
(1859, 114, 'MU', 'مبارك الكبير'),
(1860, 115, 'B', 'Баткен областы'),
(1861, 115, 'C', 'Чүй областы'),
(1862, 115, 'GB', 'Бишкек'),
(1863, 115, 'J', 'Жалал-Абад областы'),
(1864, 115, 'N', 'Нарын областы'),
(1865, 115, 'O', 'Ош областы'),
(1866, 115, 'T', 'Талас областы'),
(1867, 115, 'Y', 'Ысык-Көл областы'),
(1868, 116, 'AT', 'ອັດຕະປື'),
(1869, 116, 'BK', 'ບໍ່ແກ້ວ'),
(1870, 116, 'BL', 'ບໍລິຄໍາໄຊ'),
(1871, 116, 'CH', 'ຈໍາປາສັກ'),
(1872, 116, 'HO', 'ຫົວພັນ'),
(1873, 116, 'KH', 'ຄໍາມ່ວນ'),
(1874, 116, 'LM', 'ຫລວງນໍ້າທາ'),
(1875, 116, 'LP', 'ຫລວງພະບາງ'),
(1876, 116, 'OU', 'ອຸດົມໄຊ'),
(1877, 116, 'PH', 'ຜົງສາລີ'),
(1878, 116, 'SL', 'ສາລະວັນ'),
(1879, 116, 'SV', 'ສະຫວັນນະເຂດ'),
(1880, 116, 'VI', 'ວຽງຈັນ'),
(1881, 116, 'VT', 'ວຽງຈັນ'),
(1882, 116, 'XA', 'ໄຊຍະບູລີ'),
(1883, 116, 'XE', 'ເຊກອງ'),
(1884, 116, 'XI', 'ຊຽງຂວາງ'),
(1885, 116, 'XN', 'ໄຊສົມບູນ'),
(1886, 117, 'AI', 'Aizkraukles rajons'),
(1887, 117, 'AL', 'Alūksnes rajons'),
(1888, 117, 'BL', 'Balvu rajons'),
(1889, 117, 'BU', 'Bauskas rajons'),
(1890, 117, 'CE', 'Cēsu rajons'),
(1891, 117, 'DA', 'Daugavpils rajons'),
(1892, 117, 'DGV', 'Daugpilis'),
(1893, 117, 'DO', 'Dobeles rajons'),
(1894, 117, 'GU', 'Gulbenes rajons'),
(1895, 117, 'JEL', 'Jelgava'),
(1896, 117, 'JK', 'Jēkabpils rajons'),
(1897, 117, 'JL', 'Jelgavas rajons'),
(1898, 117, 'JUR', 'Jūrmala'),
(1899, 117, 'KR', 'Krāslavas rajons'),
(1900, 117, 'KU', 'Kuldīgas rajons'),
(1901, 117, 'LE', 'Liepājas rajons'),
(1902, 117, 'LM', 'Limbažu rajons'),
(1903, 117, 'LPX', 'Liepoja'),
(1904, 117, 'LU', 'Ludzas rajons'),
(1905, 117, 'MA', 'Madonas rajons'),
(1906, 117, 'OG', 'Ogres rajons'),
(1907, 117, 'PR', 'Preiļu rajons'),
(1908, 117, 'RE', 'Rēzeknes rajons'),
(1909, 117, 'REZ', 'Rēzekne'),
(1910, 117, 'RI', 'Rīgas rajons'),
(1911, 117, 'RIX', 'Rīga'),
(1912, 117, 'SA', 'Saldus rajons'),
(1913, 117, 'TA', 'Talsu rajons'),
(1914, 117, 'TU', 'Tukuma rajons'),
(1915, 117, 'VE', 'Ventspils rajons'),
(1916, 117, 'VEN', 'Ventspils'),
(1917, 117, 'VK', 'Valkas rajons'),
(1918, 117, 'VM', 'Valmieras rajons'),
(1919, 119, 'A', 'Maseru'),
(1920, 119, 'B', 'Butha-Buthe'),
(1921, 119, 'C', 'Leribe'),
(1922, 119, 'D', 'Berea'),
(1923, 119, 'E', 'Mafeteng'),
(1924, 119, 'F', 'Mohale''s Hoek'),
(1925, 119, 'G', 'Quthing'),
(1926, 119, 'H', 'Qacha''s Nek'),
(1927, 119, 'J', 'Mokhotlong'),
(1928, 119, 'K', 'Thaba-Tseka'),
(1929, 120, 'BG', 'Bong'),
(1930, 120, 'BM', 'Bomi'),
(1931, 120, 'CM', 'Grand Cape Mount'),
(1932, 120, 'GB', 'Grand Bassa'),
(1933, 120, 'GG', 'Grand Gedeh'),
(1934, 120, 'GK', 'Grand Kru'),
(1935, 120, 'GP', 'Gbarpolu'),
(1936, 120, 'LO', 'Lofa'),
(1937, 120, 'MG', 'Margibi'),
(1938, 120, 'MO', 'Montserrado'),
(1939, 120, 'MY', 'Maryland'),
(1940, 120, 'NI', 'Nimba'),
(1941, 120, 'RG', 'River Gee'),
(1942, 120, 'RI', 'Rivercess'),
(1943, 120, 'SI', 'Sinoe'),
(1944, 121, 'AJ', 'Ajdābiyā'),
(1945, 121, 'BA', 'Banghāzī'),
(1946, 121, 'BU', 'Al Buţnān'),
(1947, 121, 'BW', 'Banī Walīd'),
(1948, 121, 'DR', 'Darnah'),
(1949, 121, 'GD', 'Ghadāmis'),
(1950, 121, 'GR', 'Gharyān'),
(1951, 121, 'GT', 'Ghāt'),
(1952, 121, 'HZ', 'Al Ḩizām al Akhḑar'),
(1953, 121, 'JA', 'Al Jabal al Akhḑar'),
(1954, 121, 'JB', 'Jaghbūb'),
(1955, 121, 'JI', 'Al Jifārah'),
(1956, 121, 'JU', 'Al Jufrah'),
(1957, 121, 'KF', 'Al Kufrah'),
(1958, 121, 'MB', 'Al Marqab'),
(1959, 121, 'MI', 'Mişrātah'),
(1960, 121, 'MJ', 'Al Marj'),
(1961, 121, 'MQ', 'Murzuq'),
(1962, 121, 'MZ', 'Mizdah'),
(1963, 121, 'NL', 'Nālūt'),
(1964, 121, 'NQ', 'An Nuqaţ al Khams'),
(1965, 121, 'QB', 'Al Qubbah'),
(1966, 121, 'QT', 'Al Qaţrūn'),
(1967, 121, 'SB', 'Sabhā'),
(1968, 121, 'SH', 'Ash Shāţi'),
(1969, 121, 'SR', 'Surt'),
(1970, 121, 'SS', 'Şabrātah Şurmān'),
(1971, 121, 'TB', 'Ţarābulus'),
(1972, 121, 'TM', 'Tarhūnah-Masallātah'),
(1973, 121, 'TN', 'Tājūrā wa an Nawāḩī al Arbāʻ'),
(1974, 121, 'WA', 'Al Wāḩah'),
(1975, 121, 'WD', 'Wādī al Ḩayāt'),
(1976, 121, 'YJ', 'Yafran-Jādū'),
(1977, 121, 'ZA', 'Az Zāwiyah'),
(1978, 122, 'B', 'Balzers'),
(1979, 122, 'E', 'Eschen'),
(1980, 122, 'G', 'Gamprin'),
(1981, 122, 'M', 'Mauren'),
(1982, 122, 'P', 'Planken'),
(1983, 122, 'R', 'Ruggell'),
(1984, 122, 'A', 'Schaan'),
(1985, 122, 'L', 'Schellenberg'),
(1986, 122, 'N', 'Triesen'),
(1987, 122, 'T', 'Triesenberg'),
(1988, 122, 'V', 'Vaduz'),
(1989, 123, 'AL', 'Alytaus Apskritis'),
(1990, 123, 'KL', 'Klaipėdos Apskritis'),
(1991, 123, 'KU', 'Kauno Apskritis'),
(1992, 123, 'MR', 'Marijampolės Apskritis'),
(1993, 123, 'PN', 'Panevėžio Apskritis'),
(1994, 123, 'SA', 'Šiaulių Apskritis'),
(1995, 123, 'TA', 'Tauragės Apskritis'),
(1996, 123, 'TE', 'Telšių Apskritis'),
(1997, 123, 'UT', 'Utenos Apskritis'),
(1998, 123, 'VL', 'Vilniaus Apskritis'),
(1999, 124, 'D', 'Diekirch'),
(2000, 124, 'G', 'Grevenmacher'),
(2001, 124, 'L', 'Luxemburg'),
(2002, 125, 'I', '海島市'),
(2003, 125, 'M', '澳門市'),
(2004, 126, 'BR', 'Berovo'),
(2005, 126, 'CH', 'Чешиново-Облешево'),
(2006, 126, 'DL', 'Делчево'),
(2007, 126, 'KB', 'Карбинци'),
(2008, 126, 'OC', 'Кочани'),
(2009, 126, 'LO', 'Лозово'),
(2010, 126, 'MK', 'Македонска каменица'),
(2011, 126, 'PH', 'Пехчево'),
(2012, 126, 'PT', 'Пробиштип'),
(2013, 126, 'ST', 'Штип'),
(2014, 126, 'SL', 'Свети Николе'),
(2015, 126, 'NI', 'Виница'),
(2016, 126, 'ZR', 'Зрновци'),
(2017, 126, 'KY', 'Кратово'),
(2018, 126, 'KZ', 'Крива Паланка'),
(2019, 126, 'UM', 'Куманово'),
(2020, 126, 'LI', 'Липково'),
(2021, 126, 'RN', 'Ранковце'),
(2022, 126, 'NA', 'Старо Нагоричане'),
(2023, 126, 'TL', 'Битола'),
(2024, 126, 'DM', 'Демир Хисар'),
(2025, 126, 'DE', 'Долнени'),
(2026, 126, 'KG', 'Кривогаштани'),
(2027, 126, 'KS', 'Крушево'),
(2028, 126, 'MG', 'Могила'),
(2029, 126, 'NV', 'Новаци'),
(2030, 126, 'PP', 'Прилеп'),
(2031, 126, 'RE', 'Ресен'),
(2032, 126, 'VJ', 'Боговиње'),
(2033, 126, 'BN', 'Брвеница'),
(2034, 126, 'GT', 'Гостивар'),
(2035, 126, 'JG', 'Јегуновце'),
(2036, 126, 'MR', 'Маврово и Ростуша'),
(2037, 126, 'TR', 'Теарце'),
(2038, 126, 'ET', 'Тетово'),
(2039, 126, 'VH', 'Врапчиште'),
(2040, 126, 'ZE', 'Желино'),
(2041, 126, 'AD', 'Аеродром'),
(2042, 126, 'AR', 'Арачиново'),
(2043, 126, 'BU', 'Бутел'),
(2044, 126, 'CI', 'Чаир'),
(2045, 126, 'CE', 'Центар'),
(2046, 126, 'CS', 'Чучер Сандево'),
(2047, 126, 'GB', 'Гази Баба'),
(2048, 126, 'GP', 'Ѓорче Петров'),
(2049, 126, 'IL', 'Илинден'),
(2050, 126, 'KX', 'Карпош'),
(2051, 126, 'VD', 'Кисела Вода'),
(2052, 126, 'PE', 'Петровец'),
(2053, 126, 'AJ', 'Сарај'),
(2054, 126, 'SS', 'Сопиште'),
(2055, 126, 'SU', 'Студеничани'),
(2056, 126, 'SO', 'Шуто Оризари'),
(2057, 126, 'ZK', 'Зелениково'),
(2058, 126, 'BG', 'Богданци'),
(2059, 126, 'BS', 'Босилово'),
(2060, 126, 'GV', 'Гевгелија'),
(2061, 126, 'KN', 'Конче'),
(2062, 126, 'NS', 'Ново Село'),
(2063, 126, 'RV', 'Радовиш'),
(2064, 126, 'SD', 'Стар Дојран'),
(2065, 126, 'RU', 'Струмица'),
(2066, 126, 'VA', 'Валандово'),
(2067, 126, 'VL', 'Василево'),
(2068, 126, 'CZ', 'Центар Жупа'),
(2069, 126, 'DB', 'Дебар'),
(2070, 126, 'DA', 'Дебарца'),
(2071, 126, 'DR', 'Другово'),
(2072, 126, 'KH', 'Кичево'),
(2073, 126, 'MD', 'Македонски Брод'),
(2074, 126, 'OD', 'Охрид'),
(2075, 126, 'OS', 'Осломеј'),
(2076, 126, 'PN', 'Пласница'),
(2077, 126, 'UG', 'Струга'),
(2078, 126, 'VV', 'Вевчани'),
(2079, 126, 'VC', 'Вранештица'),
(2080, 126, 'ZA', 'Зајас'),
(2081, 126, 'CA', 'Чашка'),
(2082, 126, 'DK', 'Демир Капија'),
(2083, 126, 'GR', 'Градско'),
(2084, 126, 'AV', 'Кавадарци'),
(2085, 126, 'NG', 'Неготино'),
(2086, 126, 'RM', 'Росоман'),
(2087, 126, 'VE', 'Велес'),
(2088, 127, 'A', 'Toamasina'),
(2089, 127, 'D', 'Antsiranana'),
(2090, 127, 'F', 'Fianarantsoa'),
(2091, 127, 'M', 'Mahajanga'),
(2092, 127, 'T', 'Antananarivo'),
(2093, 127, 'U', 'Toliara'),
(2094, 128, 'BA', 'Balaka'),
(2095, 128, 'BL', 'Blantyre'),
(2096, 128, 'C', 'Central'),
(2097, 128, 'CK', 'Chikwawa'),
(2098, 128, 'CR', 'Chiradzulu'),
(2099, 128, 'CT', 'Chitipa'),
(2100, 128, 'DE', 'Dedza'),
(2101, 128, 'DO', 'Dowa'),
(2102, 128, 'KR', 'Karonga'),
(2103, 128, 'KS', 'Kasungu'),
(2104, 128, 'LK', 'Likoma Island'),
(2105, 128, 'LI', 'Lilongwe'),
(2106, 128, 'MH', 'Machinga'),
(2107, 128, 'MG', 'Mangochi'),
(2108, 128, 'MC', 'Mchinji'),
(2109, 128, 'MU', 'Mulanje'),
(2110, 128, 'MW', 'Mwanza'),
(2111, 128, 'MZ', 'Mzimba'),
(2112, 128, 'N', 'Northern'),
(2113, 128, 'NB', 'Nkhata'),
(2114, 128, 'NK', 'Nkhotakota'),
(2115, 128, 'NS', 'Nsanje'),
(2116, 128, 'NU', 'Ntcheu'),
(2117, 128, 'NI', 'Ntchisi'),
(2118, 128, 'PH', 'Phalombe'),
(2119, 128, 'RU', 'Rumphi'),
(2120, 128, 'S', 'Southern'),
(2121, 128, 'SA', 'Salima'),
(2122, 128, 'TH', 'Thyolo'),
(2123, 128, 'ZO', 'Zomba'),
(2124, 129, '01', 'Johor Darul Takzim'),
(2125, 129, '02', 'Kedah Darul Aman'),
(2126, 129, '03', 'Kelantan Darul Naim'),
(2127, 129, '04', 'Melaka Negeri Bersejarah'),
(2128, 129, '05', 'Negeri Sembilan Darul Khusus'),
(2129, 129, '06', 'Pahang Darul Makmur'),
(2130, 129, '07', 'Pulau Pinang'),
(2131, 129, '08', 'Perak Darul Ridzuan'),
(2132, 129, '09', 'Perlis Indera Kayangan'),
(2133, 129, '10', 'Selangor Darul Ehsan'),
(2134, 129, '11', 'Terengganu Darul Iman'),
(2135, 129, '12', 'Sabah Negeri Di Bawah Bayu'),
(2136, 129, '13', 'Sarawak Bumi Kenyalang'),
(2137, 129, '14', 'Wilayah Persekutuan Kuala Lumpur'),
(2138, 129, '15', 'Wilayah Persekutuan Labuan'),
(2139, 129, '16', 'Wilayah Persekutuan Putrajaya'),
(2140, 130, 'THU', 'Thiladhunmathi Uthuru'),
(2141, 130, 'THD', 'Thiladhunmathi Dhekunu'),
(2142, 130, 'MLU', 'Miladhunmadulu Uthuru'),
(2143, 130, 'MLD', 'Miladhunmadulu Dhekunu'),
(2144, 130, 'MAU', 'Maalhosmadulu Uthuru'),
(2145, 130, 'MAD', 'Maalhosmadulu Dhekunu'),
(2146, 130, 'FAA', 'Faadhippolhu'),
(2147, 130, 'MAA', 'Male Atoll'),
(2148, 130, 'AAU', 'Ari Atoll Uthuru'),
(2149, 130, 'AAD', 'Ari Atoll Dheknu'),
(2150, 130, 'FEA', 'Felidhe Atoll'),
(2151, 130, 'MUA', 'Mulaku Atoll'),
(2152, 130, 'NAU', 'Nilandhe Atoll Uthuru'),
(2153, 130, 'NAD', 'Nilandhe Atoll Dhekunu'),
(2154, 130, 'KLH', 'Kolhumadulu'),
(2155, 130, 'HDH', 'Hadhdhunmathi'),
(2156, 130, 'HAU', 'Huvadhu Atoll Uthuru'),
(2157, 130, 'HAD', 'Huvadhu Atoll Dhekunu'),
(2158, 130, 'FMU', 'Fua Mulaku'),
(2159, 130, 'ADD', 'Addu'),
(2160, 131, '1', 'Kayes'),
(2161, 131, '2', 'Koulikoro'),
(2162, 131, '3', 'Sikasso'),
(2163, 131, '4', 'Ségou'),
(2164, 131, '5', 'Mopti'),
(2165, 131, '6', 'Tombouctou'),
(2166, 131, '7', 'Gao'),
(2167, 131, '8', 'Kidal'),
(2168, 131, 'BK0', 'Bamako'),
(2169, 132, 'ATT', 'Attard'),
(2170, 132, 'BAL', 'Balzan'),
(2171, 132, 'BGU', 'Birgu'),
(2172, 132, 'BKK', 'Birkirkara'),
(2173, 132, 'BRZ', 'Birzebbuga'),
(2174, 132, 'BOR', 'Bormla'),
(2175, 132, 'DIN', 'Dingli'),
(2176, 132, 'FGU', 'Fgura'),
(2177, 132, 'FLO', 'Floriana'),
(2178, 132, 'GDJ', 'Gudja'),
(2179, 132, 'GZR', 'Gzira'),
(2180, 132, 'GRG', 'Gargur'),
(2181, 132, 'GXQ', 'Gaxaq'),
(2182, 132, 'HMR', 'Hamrun'),
(2183, 132, 'IKL', 'Iklin'),
(2184, 132, 'ISL', 'Isla'),
(2185, 132, 'KLK', 'Kalkara'),
(2186, 132, 'KRK', 'Kirkop'),
(2187, 132, 'LIJ', 'Lija'),
(2188, 132, 'LUQ', 'Luqa'),
(2189, 132, 'MRS', 'Marsa'),
(2190, 132, 'MKL', 'Marsaskala'),
(2191, 132, 'MXL', 'Marsaxlokk'),
(2192, 132, 'MDN', 'Mdina'),
(2193, 132, 'MEL', 'Melliea'),
(2194, 132, 'MGR', 'Mgarr'),
(2195, 132, 'MST', 'Mosta'),
(2196, 132, 'MQA', 'Mqabba'),
(2197, 132, 'MSI', 'Msida'),
(2198, 132, 'MTF', 'Mtarfa'),
(2199, 132, 'NAX', 'Naxxar'),
(2200, 132, 'PAO', 'Paola'),
(2201, 132, 'PEM', 'Pembroke'),
(2202, 132, 'PIE', 'Pieta'),
(2203, 132, 'QOR', 'Qormi'),
(2204, 132, 'QRE', 'Qrendi'),
(2205, 132, 'RAB', 'Rabat'),
(2206, 132, 'SAF', 'Safi'),
(2207, 132, 'SGI', 'San Giljan'),
(2208, 132, 'SLU', 'Santa Lucija'),
(2209, 132, 'SPB', 'San Pawl il-Bahar'),
(2210, 132, 'SGW', 'San Gwann'),
(2211, 132, 'SVE', 'Santa Venera'),
(2212, 132, 'SIG', 'Siggiewi'),
(2213, 132, 'SLM', 'Sliema'),
(2214, 132, 'SWQ', 'Swieqi'),
(2215, 132, 'TXB', 'Ta Xbiex'),
(2216, 132, 'TRX', 'Tarxien'),
(2217, 132, 'VLT', 'Valletta'),
(2218, 132, 'XGJ', 'Xgajra'),
(2219, 132, 'ZBR', 'Zabbar'),
(2220, 132, 'ZBG', 'Zebbug'),
(2221, 132, 'ZJT', 'Zejtun'),
(2222, 132, 'ZRQ', 'Zurrieq'),
(2223, 132, 'FNT', 'Fontana'),
(2224, 132, 'GHJ', 'Ghajnsielem'),
(2225, 132, 'GHR', 'Gharb'),
(2226, 132, 'GHS', 'Ghasri'),
(2227, 132, 'KRC', 'Kercem'),
(2228, 132, 'MUN', 'Munxar'),
(2229, 132, 'NAD', 'Nadur'),
(2230, 132, 'QAL', 'Qala'),
(2231, 132, 'VIC', 'Victoria'),
(2232, 132, 'SLA', 'San Lawrenz'),
(2233, 132, 'SNT', 'Sannat'),
(2234, 132, 'ZAG', 'Xagra'),
(2235, 132, 'XEW', 'Xewkija'),
(2236, 132, 'ZEB', 'Zebbug'),
(2237, 133, 'ALK', 'Ailuk'),
(2238, 133, 'ALL', 'Ailinglapalap'),
(2239, 133, 'ARN', 'Arno'),
(2240, 133, 'AUR', 'Aur'),
(2241, 133, 'EBO', 'Ebon'),
(2242, 133, 'ENI', 'Eniwetok'),
(2243, 133, 'JAB', 'Jabat'),
(2244, 133, 'JAL', 'Jaluit'),
(2245, 133, 'KIL', 'Kili'),
(2246, 133, 'KWA', 'Kwajalein'),
(2247, 133, 'LAE', 'Lae'),
(2248, 133, 'LIB', 'Lib'),
(2249, 133, 'LIK', 'Likiep'),
(2250, 133, 'MAJ', 'Majuro'),
(2251, 133, 'MAL', 'Maloelap'),
(2252, 133, 'MEJ', 'Mejit'),
(2253, 133, 'MIL', 'Mili'),
(2254, 133, 'NMK', 'Namorik'),
(2255, 133, 'NMU', 'Namu'),
(2256, 133, 'RON', 'Rongelap'),
(2257, 133, 'UJA', 'Ujae'),
(2258, 133, 'UJL', 'Ujelang'),
(2259, 133, 'UTI', 'Utirik'),
(2260, 133, 'WTJ', 'Wotje'),
(2261, 133, 'WTN', 'Wotho'),
(2262, 135, '01', 'ولاية الحوض الشرقي'),
(2263, 135, '02', 'ولاية الحوض الغربي'),
(2264, 135, '03', 'ولاية العصابة'),
(2265, 135, '04', 'ولاية كركول'),
(2266, 135, '05', 'ولاية البراكنة'),
(2267, 135, '06', 'ولاية الترارزة'),
(2268, 135, '07', 'ولاية آدرار'),
(2269, 135, '08', 'ولاية داخلت نواذيبو'),
(2270, 135, '09', 'ولاية تكانت'),
(2271, 135, '10', 'ولاية كيدي ماغة'),
(2272, 135, '11', 'ولاية تيرس زمور'),
(2273, 135, '12', 'ولاية إينشيري'),
(2274, 135, 'NKC', 'نواكشوط'),
(2275, 136, 'AG', 'Agalega Islands'),
(2276, 136, 'BL', 'Black River'),
(2277, 136, 'BR', 'Beau Bassin-Rose Hill'),
(2278, 136, 'CC', 'Cargados Carajos Shoals'),
(2279, 136, 'CU', 'Curepipe'),
(2280, 136, 'FL', 'Flacq'),
(2281, 136, 'GP', 'Grand Port'),
(2282, 136, 'MO', 'Moka'),
(2283, 136, 'PA', 'Pamplemousses'),
(2284, 136, 'PL', 'Port Louis'),
(2285, 136, 'PU', 'Port Louis City'),
(2286, 136, 'PW', 'Plaines Wilhems'),
(2287, 136, 'QB', 'Quatre Bornes'),
(2288, 136, 'RO', 'Rodrigues'),
(2289, 136, 'RR', 'Riviere du Rempart'),
(2290, 136, 'SA', 'Savanne'),
(2291, 136, 'VP', 'Vacoas-Phoenix'),
(2292, 138, 'AGU', 'Aguascalientes'),
(2293, 138, 'BCN', 'Baja California'),
(2294, 138, 'BCS', 'Baja California Sur'),
(2295, 138, 'CAM', 'Campeche'),
(2296, 138, 'CHH', 'Chihuahua'),
(2297, 138, 'CHP', 'Chiapas'),
(2298, 138, 'COA', 'Coahuila'),
(2299, 138, 'COL', 'Colima'),
(2300, 138, 'DIF', 'Distrito Federal'),
(2301, 138, 'DUR', 'Durango'),
(2302, 138, 'GRO', 'Guerrero'),
(2303, 138, 'GUA', 'Guanajuato'),
(2304, 138, 'HID', 'Hidalgo'),
(2305, 138, 'JAL', 'Jalisco'),
(2306, 138, 'MEX', 'Mexico'),
(2307, 138, 'MIC', 'Michoacán'),
(2308, 138, 'MOR', 'Morelos'),
(2309, 138, 'NAY', 'Nayarit'),
(2310, 138, 'NLE', 'Nuevo León'),
(2311, 138, 'OAX', 'Oaxaca'),
(2312, 138, 'PUE', 'Puebla'),
(2313, 138, 'QUE', 'Querétaro'),
(2314, 138, 'ROO', 'Quintana Roo'),
(2315, 138, 'SIN', 'Sinaloa'),
(2316, 138, 'SLP', 'San Luis Potosí'),
(2317, 138, 'SON', 'Sonora'),
(2318, 138, 'TAB', 'Tabasco'),
(2319, 138, 'TAM', 'Tamaulipas'),
(2320, 138, 'TLA', 'Tlaxcala'),
(2321, 138, 'VER', 'Veracruz'),
(2322, 138, 'YUC', 'Yucatan'),
(2323, 138, 'ZAC', 'Zacatecas'),
(2324, 139, 'KSA', 'Kosrae'),
(2325, 139, 'PNI', 'Pohnpei'),
(2326, 139, 'TRK', 'Chuuk'),
(2327, 139, 'YAP', 'Yap'),
(2328, 140, 'BA', 'Bălţi'),
(2329, 140, 'CA', 'Cahul'),
(2330, 140, 'CU', 'Chişinău'),
(2331, 140, 'ED', 'Edineţ'),
(2332, 140, 'GA', 'Găgăuzia'),
(2333, 140, 'LA', 'Lăpuşna'),
(2334, 140, 'OR', 'Orhei'),
(2335, 140, 'SN', 'Stânga Nistrului'),
(2336, 140, 'SO', 'Soroca'),
(2337, 140, 'TI', 'Tighina'),
(2338, 140, 'UN', 'Ungheni'),
(2339, 141, 'MC', 'Monte Carlo'),
(2340, 141, 'LR', 'La Rousse'),
(2341, 141, 'LA', 'Larvotto'),
(2342, 141, 'MV', 'Monaco Ville'),
(2343, 141, 'SM', 'Saint Michel'),
(2344, 141, 'CO', 'Condamine'),
(2345, 141, 'LC', 'La Colle'),
(2346, 141, 'RE', 'Les Révoires'),
(2347, 141, 'MO', 'Moneghetti'),
(2348, 141, 'FV', 'Fontvieille'),
(2349, 142, '1', 'Улаанбаатар'),
(2350, 142, '035', 'Орхон аймаг'),
(2351, 142, '037', 'Дархан-Уул аймаг'),
(2352, 142, '039', 'Хэнтий аймаг'),
(2353, 142, '041', 'Хөвсгөл аймаг'),
(2354, 142, '043', 'Ховд аймаг'),
(2355, 142, '046', 'Увс аймаг'),
(2356, 142, '047', 'Төв аймаг'),
(2357, 142, '049', 'Сэлэнгэ аймаг'),
(2358, 142, '051', 'Сүхбаатар аймаг'),
(2359, 142, '053', 'Өмнөговь аймаг'),
(2360, 142, '055', 'Өвөрхангай аймаг'),
(2361, 142, '057', 'Завхан аймаг'),
(2362, 142, '059', 'Дундговь аймаг'),
(2363, 142, '061', 'Дорнод аймаг'),
(2364, 142, '063', 'Дорноговь аймаг'),
(2365, 142, '064', 'Говьсүмбэр аймаг'),
(2366, 142, '065', 'Говь-Алтай аймаг'),
(2367, 142, '067', 'Булган аймаг'),
(2368, 142, '069', 'Баянхонгор аймаг'),
(2369, 142, '071', 'Баян Өлгий аймаг'),
(2370, 142, '073', 'Архангай аймаг'),
(2371, 143, 'A', 'Saint Anthony'),
(2372, 143, 'G', 'Saint Georges'),
(2373, 143, 'P', 'Saint Peter'),
(2374, 145, 'A', 'Niassa'),
(2375, 145, 'B', 'Manica'),
(2376, 145, 'G', 'Gaza'),
(2377, 145, 'I', 'Inhambane'),
(2378, 145, 'L', 'Maputo'),
(2379, 145, 'MPM', 'Maputo cidade'),
(2380, 145, 'N', 'Nampula'),
(2381, 145, 'P', 'Cabo Delgado'),
(2382, 145, 'Q', 'Zambézia'),
(2383, 145, 'S', 'Sofala'),
(2384, 145, 'T', 'Tete'),
(2385, 146, 'AY', 'ဧရာ၀တီတိုင္‌း'),
(2386, 146, 'BG', 'ပဲခူးတုိင္‌း'),
(2387, 146, 'MG', 'မကေ္ဝးတိုင္‌း'),
(2388, 146, 'MD', 'မန္တလေးတုိင္‌း'),
(2389, 146, 'SG', 'စစ္‌ကုိင္‌း‌တုိင္‌း'),
(2390, 146, 'TN', 'တနင္သာရိတုိင္‌း'),
(2391, 146, 'YG', 'ရန္‌ကုန္‌တုိင္‌း'),
(2392, 146, 'CH', 'ခ္ယင္‌းပ္ရည္‌နယ္‌'),
(2393, 146, 'KC', 'ကခ္ယင္‌ပ္ရည္‌နယ္‌'),
(2394, 146, 'KH', 'ကယား‌ပ္ရည္‌နယ္‌'),
(2395, 146, 'KN', 'ကရင္‌‌ပ္ရည္‌နယ္‌'),
(2396, 146, 'MN', 'မ္ဝန္‌ပ္ရည္‌နယ္‌'),
(2397, 146, 'RK', 'ရခုိင္‌ပ္ရည္‌နယ္‌'),
(2398, 146, 'SH', 'ရုမ္‌းပ္ရည္‌နယ္‌'),
(2399, 147, 'CA', 'Caprivi'),
(2400, 147, 'ER', 'Erongo'),
(2401, 147, 'HA', 'Hardap'),
(2402, 147, 'KA', 'Karas'),
(2403, 147, 'KH', 'Khomas'),
(2404, 147, 'KU', 'Kunene'),
(2405, 147, 'OD', 'Otjozondjupa'),
(2406, 147, 'OH', 'Omaheke'),
(2407, 147, 'OK', 'Okavango'),
(2408, 147, 'ON', 'Oshana'),
(2409, 147, 'OS', 'Omusati'),
(2410, 147, 'OT', 'Oshikoto'),
(2411, 147, 'OW', 'Ohangwena'),
(2412, 148, 'AO', 'Aiwo'),
(2413, 148, 'AA', 'Anabar'),
(2414, 148, 'AT', 'Anetan'),
(2415, 148, 'AI', 'Anibare'),
(2416, 148, 'BA', 'Baiti'),
(2417, 148, 'BO', 'Boe'),
(2418, 148, 'BU', 'Buada'),
(2419, 148, 'DE', 'Denigomodu'),
(2420, 148, 'EW', 'Ewa'),
(2421, 148, 'IJ', 'Ijuw'),
(2422, 148, 'ME', 'Meneng'),
(2423, 148, 'NI', 'Nibok'),
(2424, 148, 'UA', 'Uaboe'),
(2425, 148, 'YA', 'Yaren'),
(2426, 149, 'BA', 'Bagmati'),
(2427, 149, 'BH', 'Bheri'),
(2428, 149, 'DH', 'Dhawalagiri'),
(2429, 149, 'GA', 'Gandaki'),
(2430, 149, 'JA', 'Janakpur'),
(2431, 149, 'KA', 'Karnali'),
(2432, 149, 'KO', 'Kosi'),
(2433, 149, 'LU', 'Lumbini'),
(2434, 149, 'MA', 'Mahakali'),
(2435, 149, 'ME', 'Mechi'),
(2436, 149, 'NA', 'Narayani'),
(2437, 149, 'RA', 'Rapti'),
(2438, 149, 'SA', 'Sagarmatha'),
(2439, 149, 'SE', 'Seti'),
(2440, 150, 'DR', 'Drenthe'),
(2441, 150, 'FL', 'Flevoland'),
(2442, 150, 'FR', 'Friesland'),
(2443, 150, 'GE', 'Gelderland'),
(2444, 150, 'GR', 'Groningen'),
(2445, 150, 'LI', 'Limburg'),
(2446, 150, 'NB', 'Noord-Brabant'),
(2447, 150, 'NH', 'Noord-Holland'),
(2448, 150, 'OV', 'Overijssel'),
(2449, 150, 'UT', 'Utrecht'),
(2450, 150, 'ZE', 'Zeeland'),
(2451, 150, 'ZH', 'Zuid-Holland'),
(2452, 152, 'L', 'Province des Îles'),
(2453, 152, 'N', 'Province Nord'),
(2454, 152, 'S', 'Province Sud'),
(2455, 153, 'AUK', 'Auckland'),
(2456, 153, 'BOP', 'Bay of Plenty'),
(2457, 153, 'CAN', 'Canterbury'),
(2458, 153, 'GIS', 'Gisborne'),
(2459, 153, 'HKB', 'Hawke''s Bay'),
(2460, 153, 'MBH', 'Marlborough'),
(2461, 153, 'MWT', 'Manawatu-Wanganui'),
(2462, 153, 'NSN', 'Nelson'),
(2463, 153, 'NTL', 'Northland'),
(2464, 153, 'OTA', 'Otago'),
(2465, 153, 'STL', 'Southland'),
(2466, 153, 'TAS', 'Tasman'),
(2467, 153, 'TKI', 'Taranaki'),
(2468, 153, 'WGN', 'Wellington'),
(2469, 153, 'WKO', 'Waikato'),
(2470, 153, 'WTC', 'West Coast'),
(2471, 154, 'AN', 'Atlántico Norte'),
(2472, 154, 'AS', 'Atlántico Sur'),
(2473, 154, 'BO', 'Boaco'),
(2474, 154, 'CA', 'Carazo'),
(2475, 154, 'CI', 'Chinandega'),
(2476, 154, 'CO', 'Chontales'),
(2477, 154, 'ES', 'Estelí'),
(2478, 154, 'GR', 'Granada'),
(2479, 154, 'JI', 'Jinotega'),
(2480, 154, 'LE', 'León'),
(2481, 154, 'MD', 'Madriz'),
(2482, 154, 'MN', 'Managua'),
(2483, 154, 'MS', 'Masaya'),
(2484, 154, 'MT', 'Matagalpa'),
(2485, 154, 'NS', 'Nueva Segovia'),
(2486, 154, 'RI', 'Rivas'),
(2487, 154, 'SJ', 'Río San Juan'),
(2488, 155, '1', 'Agadez'),
(2489, 155, '2', 'Daffa'),
(2490, 155, '3', 'Dosso'),
(2491, 155, '4', 'Maradi'),
(2492, 155, '5', 'Tahoua'),
(2493, 155, '6', 'Tillabéry'),
(2494, 155, '7', 'Zinder'),
(2495, 155, '8', 'Niamey'),
(2496, 156, 'AB', 'Abia State'),
(2497, 156, 'AD', 'Adamawa State'),
(2498, 156, 'AK', 'Akwa Ibom State'),
(2499, 156, 'AN', 'Anambra State'),
(2500, 156, 'BA', 'Bauchi State'),
(2501, 156, 'BE', 'Benue State'),
(2502, 156, 'BO', 'Borno State'),
(2503, 156, 'BY', 'Bayelsa State'),
(2504, 156, 'CR', 'Cross River State'),
(2505, 156, 'DE', 'Delta State'),
(2506, 156, 'EB', 'Ebonyi State'),
(2507, 156, 'ED', 'Edo State'),
(2508, 156, 'EK', 'Ekiti State'),
(2509, 156, 'EN', 'Enugu State'),
(2510, 156, 'GO', 'Gombe State'),
(2511, 156, 'IM', 'Imo State'),
(2512, 156, 'JI', 'Jigawa State'),
(2513, 156, 'KB', 'Kebbi State'),
(2514, 156, 'KD', 'Kaduna State'),
(2515, 156, 'KN', 'Kano State'),
(2516, 156, 'KO', 'Kogi State'),
(2517, 156, 'KT', 'Katsina State'),
(2518, 156, 'KW', 'Kwara State'),
(2519, 156, 'LA', 'Lagos State'),
(2520, 156, 'NA', 'Nassarawa State'),
(2521, 156, 'NI', 'Niger State'),
(2522, 156, 'OG', 'Ogun State'),
(2523, 156, 'ON', 'Ondo State'),
(2524, 156, 'OS', 'Osun State'),
(2525, 156, 'OY', 'Oyo State'),
(2526, 156, 'PL', 'Plateau State'),
(2527, 156, 'RI', 'Rivers State'),
(2528, 156, 'SO', 'Sokoto State'),
(2529, 156, 'TA', 'Taraba State'),
(2530, 156, 'ZA', 'Zamfara State'),
(2531, 159, 'N', 'Northern Islands'),
(2532, 159, 'R', 'Rota'),
(2533, 159, 'S', 'Saipan'),
(2534, 159, 'T', 'Tinian'),
(2535, 160, '01', 'Østfold fylke'),
(2536, 160, '02', 'Akershus fylke'),
(2537, 160, '03', 'Oslo fylke'),
(2538, 160, '04', 'Hedmark fylke'),
(2539, 160, '05', 'Oppland fylke'),
(2540, 160, '06', 'Buskerud fylke'),
(2541, 160, '07', 'Vestfold fylke'),
(2542, 160, '08', 'Telemark fylke'),
(2543, 160, '09', 'Aust-Agder fylke'),
(2544, 160, '10', 'Vest-Agder fylke'),
(2545, 160, '11', 'Rogaland fylke'),
(2546, 160, '12', 'Hordaland fylke'),
(2547, 160, '14', 'Sogn og Fjordane fylke'),
(2548, 160, '15', 'Møre og Romsdal fylke'),
(2549, 160, '16', 'Sør-Trøndelag fylke'),
(2550, 160, '17', 'Nord-Trøndelag fylke'),
(2551, 160, '18', 'Nordland fylke'),
(2552, 160, '19', 'Troms fylke'),
(2553, 160, '20', 'Finnmark fylke'),
(2554, 161, 'BA', 'الباطنة'),
(2555, 161, 'DA', 'الداخلية'),
(2556, 161, 'DH', 'ظفار'),
(2557, 161, 'MA', 'مسقط'),
(2558, 161, 'MU', 'مسندم'),
(2559, 161, 'SH', 'الشرقية'),
(2560, 161, 'WU', 'الوسطى'),
(2561, 161, 'ZA', 'الظاهرة'),
(2562, 162, 'BA', 'بلوچستان'),
(2563, 162, 'IS', 'وفاقی دارالحکومت'),
(2564, 162, 'JK', 'آزاد کشمیر'),
(2565, 162, 'NA', 'شمالی علاقہ جات'),
(2566, 162, 'NW', 'شمال مغربی سرحدی صوبہ'),
(2567, 162, 'PB', 'پنجاب'),
(2568, 162, 'SD', 'سندھ'),
(2569, 162, 'TA', 'وفاقی قبائلی علاقہ جات'),
(2570, 163, 'AM', 'Aimeliik'),
(2571, 163, 'AR', 'Airai'),
(2572, 163, 'AN', 'Angaur'),
(2573, 163, 'HA', 'Hatohobei'),
(2574, 163, 'KA', 'Kayangel'),
(2575, 163, 'KO', 'Koror'),
(2576, 163, 'ME', 'Melekeok'),
(2577, 163, 'NA', 'Ngaraard'),
(2578, 163, 'NG', 'Ngarchelong'),
(2579, 163, 'ND', 'Ngardmau'),
(2580, 163, 'NT', 'Ngatpang'),
(2581, 163, 'NC', 'Ngchesar'),
(2582, 163, 'NR', 'Ngeremlengui'),
(2583, 163, 'NW', 'Ngiwal'),
(2584, 163, 'PE', 'Peleliu'),
(2585, 163, 'SO', 'Sonsorol'),
(2586, 164, '1', 'Bocas del Toro'),
(2587, 164, '2', 'Coclé'),
(2588, 164, '3', 'Colón'),
(2589, 164, '4', 'Chiriquí'),
(2590, 164, '5', 'Darién'),
(2591, 164, '6', 'Herrera'),
(2592, 164, '7', 'Los Santos'),
(2593, 164, '8', 'Panamá'),
(2594, 164, '9', 'Veraguas'),
(2595, 164, 'Q', 'Kuna Yala'),
(2596, 165, 'CPK', 'Chimbu'),
(2597, 165, 'CPM', 'Central'),
(2598, 165, 'EBR', 'East New Britain'),
(2599, 165, 'EHG', 'Eastern Highlands'),
(2600, 165, 'EPW', 'Enga'),
(2601, 165, 'ESW', 'East Sepik'),
(2602, 165, 'GPK', 'Gulf'),
(2603, 165, 'MBA', 'Milne Bay'),
(2604, 165, 'MPL', 'Morobe'),
(2605, 165, 'MPM', 'Madang'),
(2606, 165, 'MRL', 'Manus'),
(2607, 165, 'NCD', 'National Capital District'),
(2608, 165, 'NIK', 'New Ireland'),
(2609, 165, 'NPP', 'Northern'),
(2610, 165, 'NSA', 'North Solomons'),
(2611, 165, 'SAN', 'Sandaun'),
(2612, 165, 'SHM', 'Southern Highlands'),
(2613, 165, 'WBK', 'West New Britain'),
(2614, 165, 'WHM', 'Western Highlands'),
(2615, 165, 'WPD', 'Western'),
(2616, 166, '1', 'Concepción'),
(2617, 166, '2', 'San Pedro'),
(2618, 166, '3', 'Cordillera'),
(2619, 166, '4', 'Guairá'),
(2620, 166, '5', 'Caaguazú'),
(2621, 166, '6', 'Caazapá'),
(2622, 166, '7', 'Itapúa'),
(2623, 166, '8', 'Misiones'),
(2624, 166, '9', 'Paraguarí'),
(2625, 166, '10', 'Alto Paraná'),
(2626, 166, '11', 'Central'),
(2627, 166, '12', 'Ñeembucú'),
(2628, 166, '13', 'Amambay'),
(2629, 166, '14', 'Canindeyú'),
(2630, 166, '15', 'Presidente Hayes'),
(2631, 166, '16', 'Alto Paraguay'),
(2632, 166, '19', 'Boquerón'),
(2633, 166, 'ASU', 'Asunción'),
(2634, 167, 'AMA', 'Amazonas'),
(2635, 167, 'ANC', 'Ancash'),
(2636, 167, 'APU', 'Apurímac'),
(2637, 167, 'ARE', 'Arequipa'),
(2638, 167, 'AYA', 'Ayacucho'),
(2639, 167, 'CAJ', 'Cajamarca'),
(2640, 167, 'CAL', 'Callao'),
(2641, 167, 'CUS', 'Cuzco'),
(2642, 167, 'HUC', 'Huánuco'),
(2643, 167, 'HUV', 'Huancavelica'),
(2644, 167, 'ICA', 'Ica'),
(2645, 167, 'JUN', 'Junín'),
(2646, 167, 'LAL', 'La Libertad'),
(2647, 167, 'LAM', 'Lambayeque'),
(2648, 167, 'LIM', 'Lima'),
(2649, 167, 'LOR', 'Loreto'),
(2650, 167, 'MDD', 'Madre de Dios'),
(2651, 167, 'MOQ', 'Moquegua'),
(2652, 167, 'PAS', 'Pasco'),
(2653, 167, 'PIU', 'Piura'),
(2654, 167, 'PUN', 'Puno'),
(2655, 167, 'SAM', 'San Martín'),
(2656, 167, 'TAC', 'Tacna'),
(2657, 167, 'TUM', 'Tumbes'),
(2658, 167, 'UCA', 'Ucayali'),
(2659, 168, 'ABR', 'Abra'),
(2660, 168, 'AGN', 'Agusan del Norte'),
(2661, 168, 'AGS', 'Agusan del Sur'),
(2662, 168, 'AKL', 'Aklan'),
(2663, 168, 'ALB', 'Albay'),
(2664, 168, 'ANT', 'Antique'),
(2665, 168, 'APA', 'Apayao'),
(2666, 168, 'AUR', 'Aurora'),
(2667, 168, 'BAN', 'Bataan'),
(2668, 168, 'BAS', 'Basilan'),
(2669, 168, 'BEN', 'Benguet'),
(2670, 168, 'BIL', 'Biliran'),
(2671, 168, 'BOH', 'Bohol'),
(2672, 168, 'BTG', 'Batangas'),
(2673, 168, 'BTN', 'Batanes'),
(2674, 168, 'BUK', 'Bukidnon'),
(2675, 168, 'BUL', 'Bulacan'),
(2676, 168, 'CAG', 'Cagayan'),
(2677, 168, 'CAM', 'Camiguin'),
(2678, 168, 'CAN', 'Camarines Norte'),
(2679, 168, 'CAP', 'Capiz'),
(2680, 168, 'CAS', 'Camarines Sur'),
(2681, 168, 'CAT', 'Catanduanes'),
(2682, 168, 'CAV', 'Cavite'),
(2683, 168, 'CEB', 'Cebu'),
(2684, 168, 'COM', 'Compostela Valley'),
(2685, 168, 'DAO', 'Davao Oriental'),
(2686, 168, 'DAS', 'Davao del Sur'),
(2687, 168, 'DAV', 'Davao del Norte'),
(2688, 168, 'EAS', 'Eastern Samar'),
(2689, 168, 'GUI', 'Guimaras'),
(2690, 168, 'IFU', 'Ifugao'),
(2691, 168, 'ILI', 'Iloilo'),
(2692, 168, 'ILN', 'Ilocos Norte'),
(2693, 168, 'ILS', 'Ilocos Sur'),
(2694, 168, 'ISA', 'Isabela'),
(2695, 168, 'KAL', 'Kalinga'),
(2696, 168, 'LAG', 'Laguna'),
(2697, 168, 'LAN', 'Lanao del Norte'),
(2698, 168, 'LAS', 'Lanao del Sur'),
(2699, 168, 'LEY', 'Leyte'),
(2700, 168, 'LUN', 'La Union'),
(2701, 168, 'MAD', 'Marinduque'),
(2702, 168, 'MAG', 'Maguindanao'),
(2703, 168, 'MAS', 'Masbate'),
(2704, 168, 'MDC', 'Mindoro Occidental'),
(2705, 168, 'MDR', 'Mindoro Oriental'),
(2706, 168, 'MOU', 'Mountain Province'),
(2707, 168, 'MSC', 'Misamis Occidental'),
(2708, 168, 'MSR', 'Misamis Oriental'),
(2709, 168, 'NCO', 'Cotabato'),
(2710, 168, 'NSA', 'Northern Samar'),
(2711, 168, 'NEC', 'Negros Occidental'),
(2712, 168, 'NER', 'Negros Oriental'),
(2713, 168, 'NUE', 'Nueva Ecija'),
(2714, 168, 'NUV', 'Nueva Vizcaya'),
(2715, 168, 'PAM', 'Pampanga'),
(2716, 168, 'PAN', 'Pangasinan'),
(2717, 168, 'PLW', 'Palawan'),
(2718, 168, 'QUE', 'Quezon'),
(2719, 168, 'QUI', 'Quirino'),
(2720, 168, 'RIZ', 'Rizal'),
(2721, 168, 'ROM', 'Romblon'),
(2722, 168, 'SAR', 'Sarangani'),
(2723, 168, 'SCO', 'South Cotabato'),
(2724, 168, 'SIG', 'Siquijor'),
(2725, 168, 'SLE', 'Southern Leyte'),
(2726, 168, 'SLU', 'Sulu'),
(2727, 168, 'SOR', 'Sorsogon'),
(2728, 168, 'SUK', 'Sultan Kudarat'),
(2729, 168, 'SUN', 'Surigao del Norte'),
(2730, 168, 'SUR', 'Surigao del Sur'),
(2731, 168, 'TAR', 'Tarlac'),
(2732, 168, 'TAW', 'Tawi-Tawi'),
(2733, 168, 'WSA', 'Samar'),
(2734, 168, 'ZAN', 'Zamboanga del Norte'),
(2735, 168, 'ZAS', 'Zamboanga del Sur'),
(2736, 168, 'ZMB', 'Zambales'),
(2737, 168, 'ZSI', 'Zamboanga Sibugay'),
(2738, 170, 'DS', 'Dolnośląskie'),
(2739, 170, 'KP', 'Kujawsko-Pomorskie'),
(2740, 170, 'LU', 'Lubelskie'),
(2741, 170, 'LB', 'Lubuskie'),
(2742, 170, 'LD', 'Łódzkie'),
(2743, 170, 'MA', 'Małopolskie'),
(2744, 170, 'MZ', 'Mazowieckie'),
(2745, 170, 'OP', 'Opolskie'),
(2746, 170, 'PK', 'Podkarpackie'),
(2747, 170, 'PD', 'Podlaskie'),
(2748, 170, 'PM', 'Pomorskie'),
(2749, 170, 'SL', 'Śląskie'),
(2750, 170, 'SK', 'Świętokrzyskie'),
(2751, 170, 'WN', 'Warmińsko-Mazurskie'),
(2752, 170, 'WP', 'Wielkopolskie'),
(2753, 170, 'ZP', 'Zachodniopomorskie'),
(2754, 171, '01', 'Aveiro'),
(2755, 171, '02', 'Beja'),
(2756, 171, '03', 'Braga'),
(2757, 171, '04', 'Bragança'),
(2758, 171, '05', 'Castelo Branco'),
(2759, 171, '06', 'Coimbra'),
(2760, 171, '07', 'Évora'),
(2761, 171, '08', 'Faro'),
(2762, 171, '09', 'Guarda'),
(2763, 171, '10', 'Leiria'),
(2764, 171, '11', 'Lisboa'),
(2765, 171, '12', 'Portalegre'),
(2766, 171, '13', 'Porto'),
(2767, 171, '14', 'Santarém'),
(2768, 171, '15', 'Setúbal'),
(2769, 171, '16', 'Viana do Castelo'),
(2770, 171, '17', 'Vila Real'),
(2771, 171, '18', 'Viseu'),
(2772, 171, '20', 'Região Autónoma dos Açores'),
(2773, 171, '30', 'Região Autónoma da Madeira'),
(2774, 173, 'DA', 'الدوحة'),
(2775, 173, 'GH', 'الغويرية'),
(2776, 173, 'JB', 'جريان الباطنة'),
(2777, 173, 'JU', 'الجميلية'),
(2778, 173, 'KH', 'الخور'),
(2779, 173, 'ME', 'مسيعيد'),
(2780, 173, 'MS', 'الشمال'),
(2781, 173, 'RA', 'الريان'),
(2782, 173, 'US', 'أم صلال'),
(2783, 173, 'WA', 'الوكرة'),
(2784, 175, 'AB', 'Alba'),
(2785, 175, 'AG', 'Argeş'),
(2786, 175, 'AR', 'Arad'),
(2787, 175, 'B', 'Bucureşti'),
(2788, 175, 'BC', 'Bacău'),
(2789, 175, 'BH', 'Bihor'),
(2790, 175, 'BN', 'Bistriţa-Năsăud'),
(2791, 175, 'BR', 'Brăila'),
(2792, 175, 'BT', 'Botoşani'),
(2793, 175, 'BV', 'Braşov'),
(2794, 175, 'BZ', 'Buzău'),
(2795, 175, 'CJ', 'Cluj'),
(2796, 175, 'CL', 'Călăraşi'),
(2797, 175, 'CS', 'Caraş-Severin'),
(2798, 175, 'CT', 'Constanţa'),
(2799, 175, 'CV', 'Covasna'),
(2800, 175, 'DB', 'Dâmboviţa'),
(2801, 175, 'DJ', 'Dolj'),
(2802, 175, 'GJ', 'Gorj'),
(2803, 175, 'GL', 'Galaţi'),
(2804, 175, 'GR', 'Giurgiu'),
(2805, 175, 'HD', 'Hunedoara'),
(2806, 175, 'HG', 'Harghita'),
(2807, 175, 'IF', 'Ilfov'),
(2808, 175, 'IL', 'Ialomiţa'),
(2809, 175, 'IS', 'Iaşi'),
(2810, 175, 'MH', 'Mehedinţi'),
(2811, 175, 'MM', 'Maramureş'),
(2812, 175, 'MS', 'Mureş'),
(2813, 175, 'NT', 'Neamţ'),
(2814, 175, 'OT', 'Olt'),
(2815, 175, 'PH', 'Prahova'),
(2816, 175, 'SB', 'Sibiu'),
(2817, 175, 'SJ', 'Sălaj'),
(2818, 175, 'SM', 'Satu Mare'),
(2819, 175, 'SV', 'Suceava'),
(2820, 175, 'TL', 'Tulcea'),
(2821, 175, 'TM', 'Timiş'),
(2822, 175, 'TR', 'Teleorman'),
(2823, 175, 'VL', 'Vâlcea'),
(2824, 175, 'VN', 'Vrancea'),
(2825, 175, 'VS', 'Vaslui'),
(2826, 176, 'AD', 'Адыге́я Респу́блика'),
(2827, 176, 'AGB', 'Аги́нский-Буря́тский автоно́мный о́круг'),
(2828, 176, 'AL', 'Алта́й Респу́блика'),
(2829, 176, 'ALT', 'Алта́йский край'),
(2830, 176, 'AMU', 'Аму́рская о́бласть'),
(2831, 176, 'ARK', 'Арха́нгельская о́бласть'),
(2832, 176, 'AST', 'Астраха́нская о́бласть'),
(2833, 176, 'BA', 'Башкортоста́н Респу́блика'),
(2834, 176, 'BEL', 'Белгоро́дская о́бласть'),
(2835, 176, 'BRY', 'Бря́нская о́бласть'),
(2836, 176, 'BU', 'Буря́тия Респу́блика'),
(2837, 176, 'CE', 'Чече́нская Респу́блика'),
(2838, 176, 'CHE', 'Челя́бинская о́бласть'),
(2839, 176, 'CHI', 'Чити́нская о́бласть'),
(2840, 176, 'CHU', 'Чуко́тский автоно́мный о́круг'),
(2841, 176, 'CU', 'Чува́шская Респу́блика'),
(2842, 176, 'DA', 'Дагеста́н Респу́блика'),
(2843, 176, 'EVE', 'Эвенки́йский автоно́мный о́круг'),
(2844, 176, 'IN', 'Ингуше́тия Респу́блика'),
(2845, 176, 'IRK', 'Ирку́тская о́бласть'),
(2846, 176, 'IVA', 'Ива́новская о́бласть'),
(2847, 176, 'KAM', 'Камча́тская о́бласть'),
(2848, 176, 'KB', 'Кабарди́но-Балка́рская Респу́блика'),
(2849, 176, 'KC', 'Карача́ево-Черке́сская Респу́блика'),
(2850, 176, 'KDA', 'Краснода́рский край'),
(2851, 176, 'KEM', 'Ке́меровская о́бласть'),
(2852, 176, 'KGD', 'Калинингра́дская о́бласть'),
(2853, 176, 'KGN', 'Курга́нская о́бласть'),
(2854, 176, 'KHA', 'Хаба́ровский край'),
(2855, 176, 'KHM', 'Ха́нты-Манси́йский автоно́мный о́круг—Югра́'),
(2856, 176, 'KIA', 'Красноя́рский край'),
(2857, 176, 'KIR', 'Ки́ровская о́бласть'),
(2858, 176, 'KK', 'Хака́сия'),
(2859, 176, 'KL', 'Калмы́кия Респу́блика'),
(2860, 176, 'KLU', 'Калу́жская о́бласть'),
(2861, 176, 'KO', 'Ко́ми Респу́блика'),
(2862, 176, 'KOR', 'Коря́кский автоно́мный о́круг'),
(2863, 176, 'KOS', 'Костромска́я о́бласть'),
(2864, 176, 'KR', 'Каре́лия Респу́блика'),
(2865, 176, 'KRS', 'Ку́рская о́бласть'),
(2866, 176, 'LEN', 'Ленингра́дская о́бласть'),
(2867, 176, 'LIP', 'Ли́пецкая о́бласть'),
(2868, 176, 'MAG', 'Магада́нская о́бласть'),
(2869, 176, 'ME', 'Мари́й Эл Респу́блика'),
(2870, 176, 'MO', 'Мордо́вия Респу́блика'),
(2871, 176, 'MOS', 'Моско́вская о́бласть'),
(2872, 176, 'MOW', 'Москва́'),
(2873, 176, 'MUR', 'Му́рманская о́бласть'),
(2874, 176, 'NEN', 'Нене́цкий автоно́мный о́круг'),
(2875, 176, 'NGR', 'Новгоро́дская о́бласть'),
(2876, 176, 'NIZ', 'Нижегоро́дская о́бласть'),
(2877, 176, 'NVS', 'Новосиби́рская о́бласть'),
(2878, 176, 'OMS', 'О́мская о́бласть'),
(2879, 176, 'ORE', 'Оренбу́ргская о́бласть'),
(2880, 176, 'ORL', 'Орло́вская о́бласть'),
(2881, 176, 'PNZ', 'Пе́нзенская о́бласть'),
(2882, 176, 'PRI', 'Примо́рский край'),
(2883, 176, 'PSK', 'Пско́вская о́бласть'),
(2884, 176, 'ROS', 'Росто́вская о́бласть'),
(2885, 176, 'RYA', 'Ряза́нская о́бласть'),
(2886, 176, 'SA', 'Саха́ (Яку́тия) Респу́блика'),
(2887, 176, 'SAK', 'Сахали́нская о́бласть'),
(2888, 176, 'SAM', 'Сама́рская о́бласть'),
(2889, 176, 'SAR', 'Сара́товская о́бласть'),
(2890, 176, 'SE', 'Се́верная Осе́тия–Ала́ния Респу́блика'),
(2891, 176, 'SMO', 'Смол́енская о́бласть'),
(2892, 176, 'SPE', 'Санкт-Петербу́рг'),
(2893, 176, 'STA', 'Ставропо́льский край'),
(2894, 176, 'SVE', 'Свердло́вская о́бласть'),
(2895, 176, 'TA', 'Респу́блика Татарста́н'),
(2896, 176, 'TAM', 'Тамбо́вская о́бласть'),
(2897, 176, 'TAY', 'Таймы́рский автоно́мный о́круг'),
(2898, 176, 'TOM', 'То́мская о́бласть'),
(2899, 176, 'TUL', 'Ту́льская о́бласть'),
(2900, 176, 'TVE', 'Тверска́я о́бласть'),
(2901, 176, 'TY', 'Тыва́ Респу́блика'),
(2902, 176, 'TYU', 'Тюме́нская о́бласть'),
(2903, 176, 'UD', 'Удму́ртская Респу́блика'),
(2904, 176, 'ULY', 'Улья́новская о́бласть'),
(2905, 176, 'UOB', 'Усть-Орды́нский Буря́тский автоно́мный о́круг'),
(2906, 176, 'VGG', 'Волгогра́дская о́бласть'),
(2907, 176, 'VLA', 'Влади́мирская о́бласть'),
(2908, 176, 'VLG', 'Волого́дская о́бласть'),
(2909, 176, 'VOR', 'Воро́нежская о́бласть'),
(2910, 176, 'XXX', 'Пе́рмский край'),
(2911, 176, 'YAN', 'Яма́ло-Нене́цкий автоно́мный о́круг'),
(2912, 176, 'YAR', 'Яросла́вская о́бласть'),
(2913, 176, 'YEV', 'Евре́йская автоно́мная о́бласть'),
(2914, 177, 'N', 'Nord'),
(2915, 177, 'E', 'Est'),
(2916, 177, 'S', 'Sud'),
(2917, 177, 'O', 'Ouest'),
(2918, 177, 'K', 'Kigali'),
(2919, 178, 'K', 'Saint Kitts'),
(2920, 178, 'N', 'Nevis'),
(2921, 179, 'AR', 'Anse-la-Raye'),
(2922, 179, 'CA', 'Castries'),
(2923, 179, 'CH', 'Choiseul'),
(2924, 179, 'DA', 'Dauphin'),
(2925, 179, 'DE', 'Dennery'),
(2926, 179, 'GI', 'Gros-Islet'),
(2927, 179, 'LA', 'Laborie'),
(2928, 179, 'MI', 'Micoud'),
(2929, 179, 'PR', 'Praslin'),
(2930, 179, 'SO', 'Soufriere'),
(2931, 179, 'VF', 'Vieux-Fort'),
(2932, 180, 'C', 'Charlotte'),
(2933, 180, 'R', 'Grenadines'),
(2934, 180, 'A', 'Saint Andrew'),
(2935, 180, 'D', 'Saint David'),
(2936, 180, 'G', 'Saint George'),
(2937, 180, 'P', 'Saint Patrick'),
(2938, 181, 'AA', 'A''ana'),
(2939, 181, 'AL', 'Aiga-i-le-Tai'),
(2940, 181, 'AT', 'Atua'),
(2941, 181, 'FA', 'Fa''asaleleaga'),
(2942, 181, 'GE', 'Gaga''emauga'),
(2943, 181, 'GI', 'Gaga''ifomauga'),
(2944, 181, 'PA', 'Palauli'),
(2945, 181, 'SA', 'Satupa''itea'),
(2946, 181, 'TU', 'Tuamasaga'),
(2947, 181, 'VF', 'Va''a-o-Fonoti'),
(2948, 181, 'VS', 'Vaisigano'),
(2949, 182, 'AC', 'Acquaviva'),
(2950, 182, 'BM', 'Borgo Maggiore'),
(2951, 182, 'CH', 'Chiesanuova'),
(2952, 182, 'DO', 'Domagnano'),
(2953, 182, 'FA', 'Faetano'),
(2954, 182, 'FI', 'Fiorentino'),
(2955, 182, 'MO', 'Montegiardino'),
(2956, 182, 'SM', 'Citta di San Marino'),
(2957, 182, 'SE', 'Serravalle'),
(2958, 183, 'P', 'Príncipe'),
(2959, 183, 'S', 'São Tomé'),
(2960, 184, '01', 'الرياض'),
(2961, 184, '02', 'مكة المكرمة'),
(2962, 184, '03', 'المدينه'),
(2963, 184, '04', 'الشرقية'),
(2964, 184, '05', 'القصيم'),
(2965, 184, '06', 'حائل'),
(2966, 184, '07', 'تبوك'),
(2967, 184, '08', 'الحدود الشمالية'),
(2968, 184, '09', 'جيزان'),
(2969, 184, '10', 'نجران'),
(2970, 184, '11', 'الباحة'),
(2971, 184, '12', 'الجوف'),
(2972, 184, '14', 'عسير'),
(2973, 185, 'DA', 'Dakar'),
(2974, 185, 'DI', 'Diourbel'),
(2975, 185, 'FA', 'Fatick'),
(2976, 185, 'KA', 'Kaolack'),
(2977, 185, 'KO', 'Kolda'),
(2978, 185, 'LO', 'Louga'),
(2979, 185, 'MA', 'Matam'),
(2980, 185, 'SL', 'Saint-Louis'),
(2981, 185, 'TA', 'Tambacounda'),
(2982, 185, 'TH', 'Thies '),
(2983, 185, 'ZI', 'Ziguinchor'),
(2984, 186, 'AP', 'Anse aux Pins'),
(2985, 186, 'AB', 'Anse Boileau'),
(2986, 186, 'AE', 'Anse Etoile'),
(2987, 186, 'AL', 'Anse Louis'),
(2988, 186, 'AR', 'Anse Royale'),
(2989, 186, 'BL', 'Baie Lazare'),
(2990, 186, 'BS', 'Baie Sainte Anne'),
(2991, 186, 'BV', 'Beau Vallon'),
(2992, 186, 'BA', 'Bel Air'),
(2993, 186, 'BO', 'Bel Ombre'),
(2994, 186, 'CA', 'Cascade'),
(2995, 186, 'GL', 'Glacis'),
(2996, 186, 'GM', 'Grand'' Anse (on Mahe)'),
(2997, 186, 'GP', 'Grand'' Anse (on Praslin)'),
(2998, 186, 'DG', 'La Digue'),
(2999, 186, 'RA', 'La Riviere Anglaise'),
(3000, 186, 'MB', 'Mont Buxton'),
(3001, 186, 'MF', 'Mont Fleuri'),
(3002, 186, 'PL', 'Plaisance'),
(3003, 186, 'PR', 'Pointe La Rue'),
(3004, 186, 'PG', 'Port Glaud'),
(3005, 186, 'SL', 'Saint Louis'),
(3006, 186, 'TA', 'Takamaka'),
(3007, 187, 'E', 'Eastern'),
(3008, 187, 'N', 'Northern'),
(3009, 187, 'S', 'Southern'),
(3010, 187, 'W', 'Western'),
(3011, 189, 'BC', 'Banskobystrický kraj'),
(3012, 189, 'BL', 'Bratislavský kraj'),
(3013, 189, 'KI', 'Košický kraj'),
(3014, 189, 'NJ', 'Nitrianský kraj'),
(3015, 189, 'PV', 'Prešovský kraj'),
(3016, 189, 'TA', 'Trnavský kraj'),
(3017, 189, 'TC', 'Trenčianský kraj'),
(3018, 189, 'ZI', 'Žilinský kraj'),
(3019, 190, '001', 'Ajdovščina'),
(3020, 190, '002', 'Beltinci'),
(3021, 190, '003', 'Bled'),
(3022, 190, '004', 'Bohinj'),
(3023, 190, '005', 'Borovnica'),
(3024, 190, '006', 'Bovec'),
(3025, 190, '007', 'Brda'),
(3026, 190, '008', 'Brezovica'),
(3027, 190, '009', 'Brežice'),
(3028, 190, '010', 'Tišina'),
(3029, 190, '011', 'Celje'),
(3030, 190, '012', 'Cerklje na Gorenjskem'),
(3031, 190, '013', 'Cerknica'),
(3032, 190, '014', 'Cerkno'),
(3033, 190, '015', 'Črenšovci');
INSERT INTO `[[dbprefix]]zones` VALUES
(3034, 190, '016', 'Črna na Koroškem'),
(3035, 190, '017', 'Črnomelj'),
(3036, 190, '018', 'Destrnik'),
(3037, 190, '019', 'Divača'),
(3038, 190, '020', 'Dobrepolje'),
(3039, 190, '021', 'Dobrova-Polhov Gradec'),
(3040, 190, '022', 'Dol pri Ljubljani'),
(3041, 190, '023', 'Domžale'),
(3042, 190, '024', 'Dornava'),
(3043, 190, '025', 'Dravograd'),
(3044, 190, '026', 'Duplek'),
(3045, 190, '027', 'Gorenja vas-Poljane'),
(3046, 190, '028', 'Gorišnica'),
(3047, 190, '029', 'Gornja Radgona'),
(3048, 190, '030', 'Gornji Grad'),
(3049, 190, '031', 'Gornji Petrovci'),
(3050, 190, '032', 'Grosuplje'),
(3051, 190, '033', 'Šalovci'),
(3052, 190, '034', 'Hrastnik'),
(3053, 190, '035', 'Hrpelje-Kozina'),
(3054, 190, '036', 'Idrija'),
(3055, 190, '037', 'Ig'),
(3056, 190, '038', 'Ilirska Bistrica'),
(3057, 190, '039', 'Ivančna Gorica'),
(3058, 190, '040', 'Izola'),
(3059, 190, '041', 'Jesenice'),
(3060, 190, '042', 'Juršinci'),
(3061, 190, '043', 'Kamnik'),
(3062, 190, '044', 'Kanal ob Soči'),
(3063, 190, '045', 'Kidričevo'),
(3064, 190, '046', 'Kobarid'),
(3065, 190, '047', 'Kobilje'),
(3066, 190, '048', 'Kočevje'),
(3067, 190, '049', 'Komen'),
(3068, 190, '050', 'Koper'),
(3069, 190, '051', 'Kozje'),
(3070, 190, '052', 'Kranj'),
(3071, 190, '053', 'Kranjska Gora'),
(3072, 190, '054', 'Krško'),
(3073, 190, '055', 'Kungota'),
(3074, 190, '056', 'Kuzma'),
(3075, 190, '057', 'Laško'),
(3076, 190, '058', 'Lenart'),
(3077, 190, '059', 'Lendava'),
(3078, 190, '060', 'Litija'),
(3079, 190, '061', 'Ljubljana'),
(3080, 190, '062', 'Ljubno'),
(3081, 190, '063', 'Ljutomer'),
(3082, 190, '064', 'Logatec'),
(3083, 190, '065', 'Loška Dolina'),
(3084, 190, '066', 'Loški Potok'),
(3085, 190, '067', 'Luče'),
(3086, 190, '068', 'Lukovica'),
(3087, 190, '069', 'Majšperk'),
(3088, 190, '070', 'Maribor'),
(3089, 190, '071', 'Medvode'),
(3090, 190, '072', 'Mengeš'),
(3091, 190, '073', 'Metlika'),
(3092, 190, '074', 'Mežica'),
(3093, 190, '075', 'Miren-Kostanjevica'),
(3094, 190, '076', 'Mislinja'),
(3095, 190, '077', 'Moravče'),
(3096, 190, '078', 'Moravske Toplice'),
(3097, 190, '079', 'Mozirje'),
(3098, 190, '080', 'Murska Sobota'),
(3099, 190, '081', 'Muta'),
(3100, 190, '082', 'Naklo'),
(3101, 190, '083', 'Nazarje'),
(3102, 190, '084', 'Nova Gorica'),
(3103, 190, '085', 'Novo mesto'),
(3104, 190, '086', 'Odranci'),
(3105, 190, '087', 'Ormož'),
(3106, 190, '088', 'Osilnica'),
(3107, 190, '089', 'Pesnica'),
(3108, 190, '090', 'Piran'),
(3109, 190, '091', 'Pivka'),
(3110, 190, '092', 'Podčetrtek'),
(3111, 190, '093', 'Podvelka'),
(3112, 190, '094', 'Postojna'),
(3113, 190, '095', 'Preddvor'),
(3114, 190, '096', 'Ptuj'),
(3115, 190, '097', 'Puconci'),
(3116, 190, '098', 'Rače-Fram'),
(3117, 190, '099', 'Radeče'),
(3118, 190, '100', 'Radenci'),
(3119, 190, '101', 'Radlje ob Dravi'),
(3120, 190, '102', 'Radovljica'),
(3121, 190, '103', 'Ravne na Koroškem'),
(3122, 190, '104', 'Ribnica'),
(3123, 190, '106', 'Rogaška Slatina'),
(3124, 190, '105', 'Rogašovci'),
(3125, 190, '107', 'Rogatec'),
(3126, 190, '108', 'Ruše'),
(3127, 190, '109', 'Semič'),
(3128, 190, '110', 'Sevnica'),
(3129, 190, '111', 'Sežana'),
(3130, 190, '112', 'Slovenj Gradec'),
(3131, 190, '113', 'Slovenska Bistrica'),
(3132, 190, '114', 'Slovenske Konjice'),
(3133, 190, '115', 'Starše'),
(3134, 190, '116', 'Sveti Jurij'),
(3135, 190, '117', 'Šenčur'),
(3136, 190, '118', 'Šentilj'),
(3137, 190, '119', 'Šentjernej'),
(3138, 190, '120', 'Šentjur pri Celju'),
(3139, 190, '121', 'Škocjan'),
(3140, 190, '122', 'Škofja Loka'),
(3141, 190, '123', 'Škofljica'),
(3142, 190, '124', 'Šmarje pri Jelšah'),
(3143, 190, '125', 'Šmartno ob Paki'),
(3144, 190, '126', 'Šoštanj'),
(3145, 190, '127', 'Štore'),
(3146, 190, '128', 'Tolmin'),
(3147, 190, '129', 'Trbovlje'),
(3148, 190, '130', 'Trebnje'),
(3149, 190, '131', 'Tržič'),
(3150, 190, '132', 'Turnišče'),
(3151, 190, '133', 'Velenje'),
(3152, 190, '134', 'Velike Lašče'),
(3153, 190, '135', 'Videm'),
(3154, 190, '136', 'Vipava'),
(3155, 190, '137', 'Vitanje'),
(3156, 190, '138', 'Vodice'),
(3157, 190, '139', 'Vojnik'),
(3158, 190, '140', 'Vrhnika'),
(3159, 190, '141', 'Vuzenica'),
(3160, 190, '142', 'Zagorje ob Savi'),
(3161, 190, '143', 'Zavrč'),
(3162, 190, '144', 'Zreče'),
(3163, 190, '146', 'Železniki'),
(3164, 190, '147', 'Žiri'),
(3165, 190, '148', 'Benedikt'),
(3166, 190, '149', 'Bistrica ob Sotli'),
(3167, 190, '150', 'Bloke'),
(3168, 190, '151', 'Braslovče'),
(3169, 190, '152', 'Cankova'),
(3170, 190, '153', 'Cerkvenjak'),
(3171, 190, '154', 'Dobje'),
(3172, 190, '155', 'Dobrna'),
(3173, 190, '156', 'Dobrovnik'),
(3174, 190, '157', 'Dolenjske Toplice'),
(3175, 190, '158', 'Grad'),
(3176, 190, '159', 'Hajdina'),
(3177, 190, '160', 'Hoče-Slivnica'),
(3178, 190, '161', 'Hodoš'),
(3179, 190, '162', 'Horjul'),
(3180, 190, '163', 'Jezersko'),
(3181, 190, '164', 'Komenda'),
(3182, 190, '165', 'Kostel'),
(3183, 190, '166', 'Križevci'),
(3184, 190, '167', 'Lovrenc na Pohorju'),
(3185, 190, '168', 'Markovci'),
(3186, 190, '169', 'Miklavž na Dravskem polju'),
(3187, 190, '170', 'Mirna Peč'),
(3188, 190, '171', 'Oplotnica'),
(3189, 190, '172', 'Podlehnik'),
(3190, 190, '173', 'Polzela'),
(3191, 190, '174', 'Prebold'),
(3192, 190, '175', 'Prevalje'),
(3193, 190, '176', 'Razkrižje'),
(3194, 190, '177', 'Ribnica na Pohorju'),
(3195, 190, '178', 'Selnica ob Dravi'),
(3196, 190, '179', 'Sodražica'),
(3197, 190, '180', 'Solčava'),
(3198, 190, '181', 'Sveta Ana'),
(3199, 190, '182', 'Sveti Andraž v Slovenskih goricah'),
(3200, 190, '183', 'Šempeter-Vrtojba'),
(3201, 190, '184', 'Tabor'),
(3202, 190, '185', 'Trnovska vas'),
(3203, 190, '186', 'Trzin'),
(3204, 190, '187', 'Velika Polana'),
(3205, 190, '188', 'Veržej'),
(3206, 190, '189', 'Vransko'),
(3207, 190, '190', 'Žalec'),
(3208, 190, '191', 'Žetale'),
(3209, 190, '192', 'Žirovnica'),
(3210, 190, '193', 'Žužemberk'),
(3211, 190, '194', 'Šmartno pri Litiji'),
(3212, 191, 'CE', 'Central'),
(3213, 191, 'CH', 'Choiseul'),
(3214, 191, 'GC', 'Guadalcanal'),
(3215, 191, 'HO', 'Honiara'),
(3216, 191, 'IS', 'Isabel'),
(3217, 191, 'MK', 'Makira'),
(3218, 191, 'ML', 'Malaita'),
(3219, 191, 'RB', 'Rennell and Bellona'),
(3220, 191, 'TM', 'Temotu'),
(3221, 191, 'WE', 'Western'),
(3222, 192, 'AD', 'Awdal'),
(3223, 192, 'BK', 'Bakool'),
(3224, 192, 'BN', 'Banaadir'),
(3225, 192, 'BR', 'Bari'),
(3226, 192, 'BY', 'Bay'),
(3227, 192, 'GD', 'Gedo'),
(3228, 192, 'GG', 'Galguduud'),
(3229, 192, 'HR', 'Hiiraan'),
(3230, 192, 'JD', 'Jubbada Dhexe'),
(3231, 192, 'JH', 'Jubbada Hoose'),
(3232, 192, 'MD', 'Mudug'),
(3233, 192, 'NG', 'Nugaal'),
(3234, 192, 'SD', 'Shabeellaha Dhexe'),
(3235, 192, 'SG', 'Sanaag'),
(3236, 192, 'SH', 'Shabeellaha Hoose'),
(3237, 192, 'SL', 'Sool'),
(3238, 192, 'TG', 'Togdheer'),
(3239, 192, 'WG', 'Woqooyi Galbeed'),
(3240, 193, 'EC', 'Eastern Cape'),
(3241, 193, 'FS', 'Free State'),
(3242, 193, 'GT', 'Gauteng'),
(3243, 193, 'LP', 'Limpopo'),
(3244, 193, 'MP', 'Mpumalanga'),
(3245, 193, 'NC', 'Northern Cape'),
(3246, 193, 'NL', 'KwaZulu-Natal'),
(3247, 193, 'NW', 'North-West'),
(3248, 193, 'WC', 'Western Cape'),
(3249, 195, 'AN', 'Andalucía'),
(3250, 195, 'AR', 'Aragón'),
(3251, 195, 'A', 'Alicante'),
(3252, 195, 'AB', 'Albacete'),
(3253, 195, 'AL', 'Almería'),
(3254, 195, 'AN', 'Andalucía'),
(3255, 195, 'AV', 'Ávila'),
(3256, 195, 'B', 'Barcelona'),
(3257, 195, 'BA', 'Badajoz'),
(3258, 195, 'BI', 'Vizcaya'),
(3259, 195, 'BU', 'Burgos'),
(3260, 195, 'C', 'A Coruña'),
(3261, 195, 'CA', 'Cádiz'),
(3262, 195, 'CC', 'Cáceres'),
(3263, 195, 'CE', 'Ceuta'),
(3264, 195, 'CL', 'Castilla y León'),
(3265, 195, 'CM', 'Castilla-La Mancha'),
(3266, 195, 'CN', 'Islas Canarias'),
(3267, 195, 'CO', 'Córdoba'),
(3268, 195, 'CR', 'Ciudad Real'),
(3269, 195, 'CS', 'Castellón'),
(3270, 195, 'CT', 'Catalonia'),
(3271, 195, 'CU', 'Cuenca'),
(3272, 195, 'EX', 'Extremadura'),
(3273, 195, 'GA', 'Galicia'),
(3274, 195, 'GC', 'Las Palmas'),
(3275, 195, 'GI', 'Girona'),
(3276, 195, 'GR', 'Granada'),
(3277, 195, 'GU', 'Guadalajara'),
(3278, 195, 'H', 'Huelva'),
(3279, 195, 'HU', 'Huesca'),
(3280, 195, 'IB', 'Islas Baleares'),
(3281, 195, 'J', 'Jaén'),
(3282, 195, 'L', 'Lleida'),
(3283, 195, 'LE', 'León'),
(3284, 195, 'LO', 'La Rioja'),
(3285, 195, 'LU', 'Lugo'),
(3286, 195, 'M', 'Madrid'),
(3287, 195, 'MA', 'Málaga'),
(3288, 195, 'ML', 'Melilla'),
(3289, 195, 'MU', 'Murcia'),
(3290, 195, 'NA', 'Navarre'),
(3291, 195, 'O', 'Asturias'),
(3292, 195, 'OR', 'Ourense'),
(3293, 195, 'P', 'Palencia'),
(3294, 195, 'PM', 'Baleares'),
(3295, 195, 'PO', 'Pontevedra'),
(3296, 195, 'PV', 'Basque Euskadi'),
(3297, 195, 'S', 'Cantabria'),
(3298, 195, 'SA', 'Salamanca'),
(3299, 195, 'SE', 'Seville'),
(3300, 195, 'SG', 'Segovia'),
(3301, 195, 'SO', 'Soria'),
(3302, 195, 'SS', 'Guipúzcoa'),
(3303, 195, 'T', 'Tarragona'),
(3304, 195, 'TE', 'Teruel'),
(3305, 195, 'TF', 'Santa Cruz De Tenerife'),
(3306, 195, 'TO', 'Toledo'),
(3307, 195, 'V', 'Valencia'),
(3308, 195, 'VA', 'Valladolid'),
(3309, 195, 'VI', 'Álava'),
(3310, 195, 'Z', 'Zaragoza'),
(3311, 195, 'ZA', 'Zamora'),
(3312, 196, 'CE', 'Central'),
(3313, 196, 'NC', 'North Central'),
(3314, 196, 'NO', 'North'),
(3315, 196, 'EA', 'Eastern'),
(3316, 196, 'NW', 'North Western'),
(3317, 196, 'SO', 'Southern'),
(3318, 196, 'UV', 'Uva'),
(3319, 196, 'SA', 'Sabaragamuwa'),
(3320, 196, 'WE', 'Western'),
(3321, 199, 'ANL', 'أعالي النيل'),
(3322, 199, 'BAM', 'البحر الأحمر'),
(3323, 199, 'BRT', 'البحيرات'),
(3324, 199, 'JZR', 'ولاية الجزيرة'),
(3325, 199, 'KRT', 'الخرطوم'),
(3326, 199, 'QDR', 'القضارف'),
(3327, 199, 'WDH', 'الوحدة'),
(3328, 199, 'ANB', 'النيل الأبيض'),
(3329, 199, 'ANZ', 'النيل الأزرق'),
(3330, 199, 'ASH', 'الشمالية'),
(3331, 199, 'BJA', 'الاستوائية الوسطى'),
(3332, 199, 'GIS', 'غرب الاستوائية'),
(3333, 199, 'GBG', 'غرب بحر الغزال'),
(3334, 199, 'GDA', 'غرب دارفور'),
(3335, 199, 'GKU', 'غرب كردفان'),
(3336, 199, 'JDA', 'جنوب دارفور'),
(3337, 199, 'JKU', 'جنوب كردفان'),
(3338, 199, 'JQL', 'جونقلي'),
(3339, 199, 'KSL', 'كسلا'),
(3340, 199, 'NNL', 'ولاية نهر النيل'),
(3341, 199, 'SBG', 'شمال بحر الغزال'),
(3342, 199, 'SDA', 'شمال دارفور'),
(3343, 199, 'SKU', 'شمال كردفان'),
(3344, 199, 'SIS', 'شرق الاستوائية'),
(3345, 199, 'SNR', 'سنار'),
(3346, 199, 'WRB', 'واراب'),
(3347, 200, 'BR', 'Brokopondo'),
(3348, 200, 'CM', 'Commewijne'),
(3349, 200, 'CR', 'Coronie'),
(3350, 200, 'MA', 'Marowijne'),
(3351, 200, 'NI', 'Nickerie'),
(3352, 200, 'PM', 'Paramaribo'),
(3353, 200, 'PR', 'Para'),
(3354, 200, 'SA', 'Saramacca'),
(3355, 200, 'SI', 'Sipaliwini'),
(3356, 200, 'WA', 'Wanica'),
(3357, 202, 'HH', 'Hhohho'),
(3358, 202, 'LU', 'Lubombo'),
(3359, 202, 'MA', 'Manzini'),
(3360, 202, 'SH', 'Shiselweni'),
(3361, 203, 'AB', 'Stockholms län'),
(3362, 203, 'C', 'Uppsala län'),
(3363, 203, 'D', 'Södermanlands län'),
(3364, 203, 'E', 'Östergötlands län'),
(3365, 203, 'F', 'Jönköpings län'),
(3366, 203, 'G', 'Kronobergs län'),
(3367, 203, 'H', 'Kalmar län'),
(3368, 203, 'I', 'Gotlands län'),
(3369, 203, 'K', 'Blekinge län'),
(3370, 203, 'M', 'Skåne län'),
(3371, 203, 'N', 'Hallands län'),
(3372, 203, 'O', 'Västra Götalands län'),
(3373, 203, 'S', 'Värmlands län;'),
(3374, 203, 'T', 'Örebro län'),
(3375, 203, 'U', 'Västmanlands län;'),
(3376, 203, 'W', 'Dalarnas län'),
(3377, 203, 'X', 'Gävleborgs län'),
(3378, 203, 'Y', 'Västernorrlands län'),
(3379, 203, 'Z', 'Jämtlands län'),
(3380, 203, 'AC', 'Västerbottens län'),
(3381, 203, 'BD', 'Norrbottens län'),
(3382, 204, 'ZH', 'Zürich'),
(3383, 204, 'BE', 'Bern'),
(3384, 204, 'LU', 'Luzern'),
(3385, 204, 'UR', 'Uri'),
(3386, 204, 'SZ', 'Schwyz'),
(3387, 204, 'OW', 'Obwalden'),
(3388, 204, 'NW', 'Nidwalden'),
(3389, 204, 'GL', 'Glasrus'),
(3390, 204, 'ZG', 'Zug'),
(3391, 204, 'FR', 'Fribourg'),
(3392, 204, 'SO', 'Solothurn'),
(3393, 204, 'BS', 'Basel-Stadt'),
(3394, 204, 'BL', 'Basel-Landschaft'),
(3395, 204, 'SH', 'Schaffhausen'),
(3396, 204, 'AR', 'Appenzell Ausserrhoden'),
(3397, 204, 'AI', 'Appenzell Innerrhoden'),
(3398, 204, 'SG', 'Saint Gallen'),
(3399, 204, 'GR', 'Graubünden'),
(3400, 204, 'AG', 'Aargau'),
(3401, 204, 'TG', 'Thurgau'),
(3402, 204, 'TI', 'Ticino'),
(3403, 204, 'VD', 'Vaud'),
(3404, 204, 'VS', 'Valais'),
(3405, 204, 'NE', 'Nuechâtel'),
(3406, 204, 'GE', 'Genève'),
(3407, 204, 'JU', 'Jura'),
(3408, 205, 'DI', 'دمشق'),
(3409, 205, 'DR', 'درعا'),
(3410, 205, 'DZ', 'دير الزور'),
(3411, 205, 'HA', 'الحسكة'),
(3412, 205, 'HI', 'حمص'),
(3413, 205, 'HL', 'حلب'),
(3414, 205, 'HM', 'حماه'),
(3415, 205, 'ID', 'ادلب'),
(3416, 205, 'LA', 'اللاذقية'),
(3417, 205, 'QU', 'القنيطرة'),
(3418, 205, 'RA', 'الرقة'),
(3419, 205, 'RD', 'ریف دمشق'),
(3420, 205, 'SU', 'السويداء'),
(3421, 205, 'TA', 'طرطوس'),
(3422, 206, 'CHA', '彰化縣'),
(3423, 206, 'CYI', '嘉義市'),
(3424, 206, 'CYQ', '嘉義縣'),
(3425, 206, 'HSQ', '新竹縣'),
(3426, 206, 'HSZ', '新竹市'),
(3427, 206, 'HUA', '花蓮縣'),
(3428, 206, 'ILA', '宜蘭縣'),
(3429, 206, 'KEE', '基隆市'),
(3430, 206, 'KHH', '高雄市'),
(3431, 206, 'KHQ', '高雄縣'),
(3432, 206, 'MIA', '苗栗縣'),
(3433, 206, 'NAN', '南投縣'),
(3434, 206, 'PEN', '澎湖縣'),
(3435, 206, 'PIF', '屏東縣'),
(3436, 206, 'TAO', '桃源县'),
(3437, 206, 'TNN', '台南市'),
(3438, 206, 'TNQ', '台南縣'),
(3439, 206, 'TPE', '臺北市'),
(3440, 206, 'TPQ', '臺北縣'),
(3441, 206, 'TTT', '台東縣'),
(3442, 206, 'TXG', '台中市'),
(3443, 206, 'TXQ', '台中縣'),
(3444, 206, 'YUN', '雲林縣'),
(3445, 207, 'GB', 'کوهستان بدخشان'),
(3446, 207, 'KT', 'ختلان'),
(3447, 207, 'SU', 'سغد'),
(3448, 208, '01', 'Arusha'),
(3449, 208, '02', 'Dar es Salaam'),
(3450, 208, '03', 'Dodoma'),
(3451, 208, '04', 'Iringa'),
(3452, 208, '05', 'Kagera'),
(3453, 208, '06', 'Pemba Sever'),
(3454, 208, '07', 'Zanzibar Sever'),
(3455, 208, '08', 'Kigoma'),
(3456, 208, '09', 'Kilimanjaro'),
(3457, 208, '10', 'Pemba Jih'),
(3458, 208, '11', 'Zanzibar Jih'),
(3459, 208, '12', 'Lindi'),
(3460, 208, '13', 'Mara'),
(3461, 208, '14', 'Mbeya'),
(3462, 208, '15', 'Zanzibar Západ'),
(3463, 208, '16', 'Morogoro'),
(3464, 208, '17', 'Mtwara'),
(3465, 208, '18', 'Mwanza'),
(3466, 208, '19', 'Pwani'),
(3467, 208, '20', 'Rukwa'),
(3468, 208, '21', 'Ruvuma'),
(3469, 208, '22', 'Shinyanga'),
(3470, 208, '23', 'Singida'),
(3471, 208, '24', 'Tabora'),
(3472, 208, '25', 'Tanga'),
(3473, 208, '26', 'Manyara'),
(3474, 209, 'TH-10', 'กรุงเทพมหานคร'),
(3475, 209, 'TH-11', 'สมุทรปราการ'),
(3476, 209, 'TH-12', 'นนทบุรี'),
(3477, 209, 'TH-13', 'ปทุมธานี'),
(3478, 209, 'TH-14', 'พระนครศรีอยุธยา'),
(3479, 209, 'TH-15', 'อ่างทอง'),
(3480, 209, 'TH-16', 'ลพบุรี'),
(3481, 209, 'TH-17', 'สิงห์บุรี'),
(3482, 209, 'TH-18', 'ชัยนาท'),
(3483, 209, 'TH-19', 'สระบุรี'),
(3484, 209, 'TH-20', 'ชลบุรี'),
(3485, 209, 'TH-21', 'ระยอง'),
(3486, 209, 'TH-22', 'จันทบุรี'),
(3487, 209, 'TH-23', 'ตราด'),
(3488, 209, 'TH-24', 'ฉะเชิงเทรา'),
(3489, 209, 'TH-25', 'ปราจีนบุรี'),
(3490, 209, 'TH-26', 'นครนายก'),
(3491, 209, 'TH-27', 'สระแก้ว'),
(3492, 209, 'TH-30', 'นครราชสีมา'),
(3493, 209, 'TH-31', 'บุรีรัมย์'),
(3494, 209, 'TH-32', 'สุรินทร์'),
(3495, 209, 'TH-33', 'ศรีสะเกษ'),
(3496, 209, 'TH-34', 'อุบลราชธานี'),
(3497, 209, 'TH-35', 'ยโสธร'),
(3498, 209, 'TH-36', 'ชัยภูมิ'),
(3499, 209, 'TH-37', 'อำนาจเจริญ'),
(3500, 209, 'TH-39', 'หนองบัวลำภู'),
(3501, 209, 'TH-40', 'ขอนแก่น'),
(3502, 209, 'TH-41', 'อุดรธานี'),
(3503, 209, 'TH-42', 'เลย'),
(3504, 209, 'TH-43', 'หนองคาย'),
(3505, 209, 'TH-44', 'มหาสารคาม'),
(3506, 209, 'TH-45', 'ร้อยเอ็ด'),
(3507, 209, 'TH-46', 'กาฬสินธุ์'),
(3508, 209, 'TH-47', 'สกลนคร'),
(3509, 209, 'TH-48', 'นครพนม'),
(3510, 209, 'TH-49', 'มุกดาหาร'),
(3511, 209, 'TH-50', 'เชียงใหม่'),
(3512, 209, 'TH-51', 'ลำพูน'),
(3513, 209, 'TH-52', 'ลำปาง'),
(3514, 209, 'TH-53', 'อุตรดิตถ์'),
(3515, 209, 'TH-55', 'น่าน'),
(3516, 209, 'TH-56', 'พะเยา'),
(3517, 209, 'TH-57', 'เชียงราย'),
(3518, 209, 'TH-58', 'แม่ฮ่องสอน'),
(3519, 209, 'TH-60', 'นครสวรรค์'),
(3520, 209, 'TH-61', 'อุทัยธานี'),
(3521, 209, 'TH-62', 'กำแพงเพชร'),
(3522, 209, 'TH-63', 'ตาก'),
(3523, 209, 'TH-64', 'สุโขทัย'),
(3524, 209, 'TH-66', 'ชุมพร'),
(3525, 209, 'TH-67', 'พิจิตร'),
(3526, 209, 'TH-70', 'ราชบุรี'),
(3527, 209, 'TH-71', 'กาญจนบุรี'),
(3528, 209, 'TH-72', 'สุพรรณบุรี'),
(3529, 209, 'TH-73', 'นครปฐม'),
(3530, 209, 'TH-74', 'สมุทรสาคร'),
(3531, 209, 'TH-75', 'สมุทรสงคราม'),
(3532, 209, 'TH-76', 'เพชรบุรี'),
(3533, 209, 'TH-77', 'ประจวบคีรีขันธ์'),
(3534, 209, 'TH-80', 'นครศรีธรรมราช'),
(3535, 209, 'TH-81', 'กระบี่'),
(3536, 209, 'TH-82', 'พังงา'),
(3537, 209, 'TH-83', 'ภูเก็ต'),
(3538, 209, 'TH-84', 'สุราษฎร์ธานี'),
(3539, 209, 'TH-85', 'ระนอง'),
(3540, 209, 'TH-86', 'ชุมพร'),
(3541, 209, 'TH-90', 'สงขลา'),
(3542, 209, 'TH-91', 'สตูล'),
(3543, 209, 'TH-92', 'ตรัง'),
(3544, 209, 'TH-93', 'พัทลุง'),
(3545, 209, 'TH-94', 'ปัตตานี'),
(3546, 209, 'TH-95', 'ยะลา'),
(3547, 209, 'TH-96', 'นราธิวาส'),
(3548, 210, 'C', 'Centrale'),
(3549, 210, 'K', 'Kara'),
(3550, 210, 'M', 'Maritime'),
(3551, 210, 'P', 'Plateaux'),
(3552, 210, 'S', 'Savanes'),
(3553, 211, 'A', 'Atafu'),
(3554, 211, 'F', 'Fakaofo'),
(3555, 211, 'N', 'Nukunonu'),
(3556, 212, 'H', 'Ha''apai'),
(3557, 212, 'T', 'Tongatapu'),
(3558, 212, 'V', 'Vava''u'),
(3559, 213, 'ARI', 'Arima'),
(3560, 213, 'CHA', 'Chaguanas'),
(3561, 213, 'CTT', 'Couva-Tabaquite-Talparo'),
(3562, 213, 'DMN', 'Diego Martin'),
(3563, 213, 'ETO', 'Eastern Tobago'),
(3564, 213, 'RCM', 'Rio Claro-Mayaro'),
(3565, 213, 'PED', 'Penal-Debe'),
(3566, 213, 'PTF', 'Point Fortin'),
(3567, 213, 'POS', 'Port of Spain'),
(3568, 213, 'PRT', 'Princes Town'),
(3569, 213, 'SFO', 'San Fernando'),
(3570, 213, 'SGE', 'Sangre Grande'),
(3571, 213, 'SJL', 'San Juan-Laventille'),
(3572, 213, 'SIP', 'Siparia'),
(3573, 213, 'TUP', 'Tunapuna-Piarco'),
(3574, 213, 'WTO', 'Western Tobago'),
(3575, 214, '11', 'ولاية تونس'),
(3576, 214, '12', 'ولاية أريانة'),
(3577, 214, '13', 'ولاية بن عروس'),
(3578, 214, '14', 'ولاية منوبة'),
(3579, 214, '21', 'ولاية نابل'),
(3580, 214, '22', 'ولاية زغوان'),
(3581, 214, '23', 'ولاية بنزرت'),
(3582, 214, '31', 'ولاية باجة'),
(3583, 214, '32', 'ولاية جندوبة'),
(3584, 214, '33', 'ولاية الكاف'),
(3585, 214, '34', 'ولاية سليانة'),
(3586, 214, '41', 'ولاية القيروان'),
(3587, 214, '42', 'ولاية القصرين'),
(3588, 214, '43', 'ولاية سيدي بوزيد'),
(3589, 214, '51', 'ولاية سوسة'),
(3590, 214, '52', 'ولاية المنستير'),
(3591, 214, '53', 'ولاية المهدية'),
(3592, 214, '61', 'ولاية صفاقس'),
(3593, 214, '71', 'ولاية قفصة'),
(3594, 214, '72', 'ولاية توزر'),
(3595, 214, '73', 'ولاية قبلي'),
(3596, 214, '81', 'ولاية قابس'),
(3597, 214, '82', 'ولاية مدنين'),
(3598, 214, '83', 'ولاية تطاوين'),
(3599, 215, '01', 'Adana'),
(3600, 215, '02', 'Adıyaman'),
(3601, 215, '03', 'Afyonkarahisar'),
(3602, 215, '04', 'Ağrı'),
(3603, 215, '05', 'Amasya'),
(3604, 215, '06', 'Ankara'),
(3605, 215, '07', 'Antalya'),
(3606, 215, '08', 'Artvin'),
(3607, 215, '09', 'Aydın'),
(3608, 215, '10', 'Balıkesir'),
(3609, 215, '11', 'Bilecik'),
(3610, 215, '12', 'Bingöl'),
(3611, 215, '13', 'Bitlis'),
(3612, 215, '14', 'Bolu'),
(3613, 215, '15', 'Burdur'),
(3614, 215, '16', 'Bursa'),
(3615, 215, '17', 'Çanakkale'),
(3616, 215, '18', 'Çankırı'),
(3617, 215, '19', 'Çorum'),
(3618, 215, '20', 'Denizli'),
(3619, 215, '21', 'Diyarbakır'),
(3620, 215, '22', 'Edirne'),
(3621, 215, '23', 'Elazığ'),
(3622, 215, '24', 'Erzincan'),
(3623, 215, '25', 'Erzurum'),
(3624, 215, '26', 'Eskişehir'),
(3625, 215, '27', 'Gaziantep'),
(3626, 215, '28', 'Giresun'),
(3627, 215, '29', 'Gümüşhane'),
(3628, 215, '30', 'Hakkari'),
(3629, 215, '31', 'Hatay'),
(3630, 215, '32', 'Isparta'),
(3631, 215, '33', 'Mersin'),
(3632, 215, '34', 'İstanbul'),
(3633, 215, '35', 'İzmir'),
(3634, 215, '36', 'Kars'),
(3635, 215, '37', 'Kastamonu'),
(3636, 215, '38', 'Kayseri'),
(3637, 215, '39', 'Kırklareli'),
(3638, 215, '40', 'Kırşehir'),
(3639, 215, '41', 'Kocaeli'),
(3640, 215, '42', 'Konya'),
(3641, 215, '43', 'Kütahya'),
(3642, 215, '44', 'Malatya'),
(3643, 215, '45', 'Manisa'),
(3644, 215, '46', 'Kahramanmaraş'),
(3645, 215, '47', 'Mardin'),
(3646, 215, '48', 'Muğla'),
(3647, 215, '49', 'Muş'),
(3648, 215, '50', 'Nevşehir'),
(3649, 215, '51', 'Niğde'),
(3650, 215, '52', 'Ordu'),
(3651, 215, '53', 'Rize'),
(3652, 215, '54', 'Sakarya'),
(3653, 215, '55', 'Samsun'),
(3654, 215, '56', 'Siirt'),
(3655, 215, '57', 'Sinop'),
(3656, 215, '58', 'Sivas'),
(3657, 215, '59', 'Tekirdağ'),
(3658, 215, '60', 'Tokat'),
(3659, 215, '61', 'Trabzon'),
(3660, 215, '62', 'Tunceli'),
(3661, 215, '63', 'Şanlıurfa'),
(3662, 215, '64', 'Uşak'),
(3663, 215, '65', 'Van'),
(3664, 215, '66', 'Yozgat'),
(3665, 215, '67', 'Zonguldak'),
(3666, 215, '68', 'Aksaray'),
(3667, 215, '69', 'Bayburt'),
(3668, 215, '70', 'Karaman'),
(3669, 215, '71', 'Kırıkkale'),
(3670, 215, '72', 'Batman'),
(3671, 215, '73', 'Şırnak'),
(3672, 215, '74', 'Bartın'),
(3673, 215, '75', 'Ardahan'),
(3674, 215, '76', 'Iğdır'),
(3675, 215, '77', 'Yalova'),
(3676, 215, '78', 'Karabük'),
(3677, 215, '79', 'Kilis'),
(3678, 215, '80', 'Osmaniye'),
(3679, 215, '81', 'Düzce'),
(3680, 216, 'A', 'Ahal welaýaty'),
(3681, 216, 'B', 'Balkan welaýaty'),
(3682, 216, 'D', 'Daşoguz welaýaty'),
(3683, 216, 'L', 'Lebap welaýaty'),
(3684, 216, 'M', 'Mary welaýaty'),
(3685, 217, 'AC', 'Ambergris Cays'),
(3686, 217, 'DC', 'Dellis Cay'),
(3687, 217, 'FC', 'French Cay'),
(3688, 217, 'LW', 'Little Water Cay'),
(3689, 217, 'RC', 'Parrot Cay'),
(3690, 217, 'PN', 'Pine Cay'),
(3691, 217, 'SL', 'Salt Cay'),
(3692, 217, 'GT', 'Grand Turk'),
(3693, 217, 'SC', 'South Caicos'),
(3694, 217, 'EC', 'East Caicos'),
(3695, 217, 'MC', 'Middle Caicos'),
(3696, 217, 'NC', 'North Caicos'),
(3697, 217, 'PR', 'Providenciales'),
(3698, 217, 'WC', 'West Caicos'),
(3699, 218, 'FUN', 'Funafuti'),
(3700, 218, 'NMA', 'Nanumea'),
(3701, 218, 'NMG', 'Nanumanga'),
(3702, 218, 'NIT', 'Niutao'),
(3703, 218, 'NIU', 'Nui'),
(3704, 218, 'NKF', 'Nukufetau'),
(3705, 218, 'NKL', 'Nukulaelae'),
(3706, 218, 'VAI', 'Vaitupu'),
(3707, 219, '101', 'Kalangala'),
(3708, 219, '102', 'Kampala'),
(3709, 219, '103', 'Kiboga'),
(3710, 219, '104', 'Luwero'),
(3711, 219, '105', 'Masaka'),
(3712, 219, '106', 'Mpigi'),
(3713, 219, '107', 'Mubende'),
(3714, 219, '108', 'Mukono'),
(3715, 219, '109', 'Nakasongola'),
(3716, 219, '110', 'Rakai'),
(3717, 219, '111', 'Sembabule'),
(3718, 219, '112', 'Kayunga'),
(3719, 219, '113', 'Wakiso'),
(3720, 219, '201', 'Bugiri'),
(3721, 219, '202', 'Busia'),
(3722, 219, '203', 'Iganga'),
(3723, 219, '204', 'Jinja'),
(3724, 219, '205', 'Kamuli'),
(3725, 219, '206', 'Kapchorwa'),
(3726, 219, '207', 'Katakwi'),
(3727, 219, '208', 'Kumi'),
(3728, 219, '209', 'Mbale'),
(3729, 219, '210', 'Pallisa'),
(3730, 219, '211', 'Soroti'),
(3731, 219, '212', 'Tororo'),
(3732, 219, '213', 'Kaberamaido'),
(3733, 219, '214', 'Mayuge'),
(3734, 219, '215', 'Sironko'),
(3735, 219, '301', 'Adjumani'),
(3736, 219, '302', 'Apac'),
(3737, 219, '303', 'Arua'),
(3738, 219, '304', 'Gulu'),
(3739, 219, '305', 'Kitgum'),
(3740, 219, '306', 'Kotido'),
(3741, 219, '307', 'Lira'),
(3742, 219, '308', 'Moroto'),
(3743, 219, '309', 'Moyo'),
(3744, 219, '310', 'Nebbi'),
(3745, 219, '311', 'Nakapiripirit'),
(3746, 219, '312', 'Pader'),
(3747, 219, '313', 'Yumbe'),
(3748, 219, '401', 'Bundibugyo'),
(3749, 219, '402', 'Bushenyi'),
(3750, 219, '403', 'Hoima'),
(3751, 219, '404', 'Kabale'),
(3752, 219, '405', 'Kabarole'),
(3753, 219, '406', 'Kasese'),
(3754, 219, '407', 'Kibale'),
(3755, 219, '408', 'Kisoro'),
(3756, 219, '409', 'Masindi'),
(3757, 219, '410', 'Mbarara'),
(3758, 219, '411', 'Ntungamo'),
(3759, 219, '412', 'Rukungiri'),
(3760, 219, '413', 'Kamwenge'),
(3761, 219, '414', 'Kanungu'),
(3762, 219, '415', 'Kyenjojo'),
(3763, 220, '05', 'Вінницька область'),
(3764, 220, '07', 'Волинська область'),
(3765, 220, '09', 'Луганська область'),
(3766, 220, '12', 'Дніпропетровська область'),
(3767, 220, '14', 'Донецька область'),
(3768, 220, '18', 'Житомирська область'),
(3769, 220, '19', 'Рівненська область'),
(3770, 220, '21', 'Закарпатська область'),
(3771, 220, '23', 'Запорізька область'),
(3772, 220, '26', 'Івано-Франківська область'),
(3773, 220, '30', 'Київ'),
(3774, 220, '32', 'Київська область'),
(3775, 220, '35', 'Кіровоградська область'),
(3776, 220, '40', 'Севастополь'),
(3777, 220, '43', 'Автономная Республика Крым'),
(3778, 220, '46', 'Львівська область'),
(3779, 220, '48', 'Миколаївська область'),
(3780, 220, '51', 'Одеська область'),
(3781, 220, '53', 'Полтавська область'),
(3782, 220, '59', 'Сумська область'),
(3783, 220, '61', 'Тернопільська область'),
(3784, 220, '63', 'Харківська область'),
(3785, 220, '65', 'Херсонська область'),
(3786, 220, '68', 'Хмельницька область'),
(3787, 220, '71', 'Черкаська область'),
(3788, 220, '74', 'Чернігівська область'),
(3789, 220, '77', 'Чернівецька область'),
(3790, 222, 'ABD', 'Aberdeenshire'),
(3791, 222, 'ABE', 'Aberdeen'),
(3792, 222, 'AGB', 'Argyll and Bute'),
(3793, 222, 'AGY', 'Isle of Anglesey'),
(3794, 222, 'ANS', 'Angus'),
(3795, 222, 'ANT', 'Antrim'),
(3796, 222, 'ARD', 'Ards'),
(3797, 222, 'ARM', 'Armagh'),
(3798, 222, 'BAS', 'Bath and North East Somerset'),
(3799, 222, 'BBD', 'Blackburn with Darwen'),
(3800, 222, 'BDF', 'Bedfordshire'),
(3801, 222, 'BDG', 'Barking and Dagenham'),
(3802, 222, 'BEN', 'Brent'),
(3803, 222, 'BEX', 'Bexley'),
(3804, 222, 'BFS', 'Belfast'),
(3805, 222, 'BGE', 'Bridgend'),
(3806, 222, 'BGW', 'Blaenau Gwent'),
(3807, 222, 'BIR', 'Birmingham'),
(3808, 222, 'BKM', 'Buckinghamshire'),
(3809, 222, 'BLA', 'Ballymena'),
(3810, 222, 'BLY', 'Ballymoney'),
(3811, 222, 'BMH', 'Bournemouth'),
(3812, 222, 'BNB', 'Banbridge'),
(3813, 222, 'BNE', 'Barnet'),
(3814, 222, 'BNH', 'Brighton and Hove'),
(3815, 222, 'BNS', 'Barnsley'),
(3816, 222, 'BOL', 'Bolton'),
(3817, 222, 'BPL', 'Blackpool'),
(3818, 222, 'BRC', 'Bracknell'),
(3819, 222, 'BRD', 'Bradford'),
(3820, 222, 'BRY', 'Bromley'),
(3821, 222, 'BST', 'Bristol'),
(3822, 222, 'BUR', 'Bury'),
(3823, 222, 'CAM', 'Cambridgeshire'),
(3824, 222, 'CAY', 'Caerphilly'),
(3825, 222, 'CGN', 'Ceredigion'),
(3826, 222, 'CGV', 'Craigavon'),
(3827, 222, 'CHS', 'Cheshire'),
(3828, 222, 'CKF', 'Carrickfergus'),
(3829, 222, 'CKT', 'Cookstown'),
(3830, 222, 'CLD', 'Calderdale'),
(3831, 222, 'CLK', 'Clackmannanshire'),
(3832, 222, 'CLR', 'Coleraine'),
(3833, 222, 'CMA', 'Cumbria'),
(3834, 222, 'CMD', 'Camden'),
(3835, 222, 'CMN', 'Carmarthenshire'),
(3836, 222, 'CON', 'Cornwall'),
(3837, 222, 'COV', 'Coventry'),
(3838, 222, 'CRF', 'Cardiff'),
(3839, 222, 'CRY', 'Croydon'),
(3840, 222, 'CSR', 'Castlereagh'),
(3841, 222, 'CWY', 'Conwy'),
(3842, 222, 'DAL', 'Darlington'),
(3843, 222, 'DBY', 'Derbyshire'),
(3844, 222, 'DEN', 'Denbighshire'),
(3845, 222, 'DER', 'Derby'),
(3846, 222, 'DEV', 'Devon'),
(3847, 222, 'DGN', 'Dungannon and South Tyrone'),
(3848, 222, 'DGY', 'Dumfries and Galloway'),
(3849, 222, 'DNC', 'Doncaster'),
(3850, 222, 'DND', 'Dundee'),
(3851, 222, 'DOR', 'Dorset'),
(3852, 222, 'DOW', 'Down'),
(3853, 222, 'DRY', 'Derry'),
(3854, 222, 'DUD', 'Dudley'),
(3855, 222, 'DUR', 'Durham'),
(3856, 222, 'EAL', 'Ealing'),
(3857, 222, 'EAY', 'East Ayrshire'),
(3858, 222, 'EDH', 'Edinburgh'),
(3859, 222, 'EDU', 'East Dunbartonshire'),
(3860, 222, 'ELN', 'East Lothian'),
(3861, 222, 'ELS', 'Eilean Siar'),
(3862, 222, 'ENF', 'Enfield'),
(3863, 222, 'ERW', 'East Renfrewshire'),
(3864, 222, 'ERY', 'East Riding of Yorkshire'),
(3865, 222, 'ESS', 'Essex'),
(3866, 222, 'ESX', 'East Sussex'),
(3867, 222, 'FAL', 'Falkirk'),
(3868, 222, 'FER', 'Fermanagh'),
(3869, 222, 'FIF', 'Fife'),
(3870, 222, 'FLN', 'Flintshire'),
(3871, 222, 'GAT', 'Gateshead'),
(3872, 222, 'GLG', 'Glasgow'),
(3873, 222, 'GLS', 'Gloucestershire'),
(3874, 222, 'GRE', 'Greenwich'),
(3875, 222, 'GSY', 'Guernsey'),
(3876, 222, 'GWN', 'Gwynedd'),
(3877, 222, 'HAL', 'Halton'),
(3878, 222, 'HAM', 'Hampshire'),
(3879, 222, 'HAV', 'Havering'),
(3880, 222, 'HCK', 'Hackney'),
(3881, 222, 'HEF', 'Herefordshire'),
(3882, 222, 'HIL', 'Hillingdon'),
(3883, 222, 'HLD', 'Highland'),
(3884, 222, 'HMF', 'Hammersmith and Fulham'),
(3885, 222, 'HNS', 'Hounslow'),
(3886, 222, 'HPL', 'Hartlepool'),
(3887, 222, 'HRT', 'Hertfordshire'),
(3888, 222, 'HRW', 'Harrow'),
(3889, 222, 'HRY', 'Haringey'),
(3890, 222, 'IOS', 'Isles of Scilly'),
(3891, 222, 'IOW', 'Isle of Wight'),
(3892, 222, 'ISL', 'Islington'),
(3893, 222, 'IVC', 'Inverclyde'),
(3894, 222, 'JSY', 'Jersey'),
(3895, 222, 'KEC', 'Kensington and Chelsea'),
(3896, 222, 'KEN', 'Kent'),
(3897, 222, 'KHL', 'Kingston upon Hull'),
(3898, 222, 'KIR', 'Kirklees'),
(3899, 222, 'KTT', 'Kingston upon Thames'),
(3900, 222, 'KWL', 'Knowsley'),
(3901, 222, 'LAN', 'Lancashire'),
(3902, 222, 'LBH', 'Lambeth'),
(3903, 222, 'LCE', 'Leicester'),
(3904, 222, 'LDS', 'Leeds'),
(3905, 222, 'LEC', 'Leicestershire'),
(3906, 222, 'LEW', 'Lewisham'),
(3907, 222, 'LIN', 'Lincolnshire'),
(3908, 222, 'LIV', 'Liverpool'),
(3909, 222, 'LMV', 'Limavady'),
(3910, 222, 'LND', 'London'),
(3911, 222, 'LRN', 'Larne'),
(3912, 222, 'LSB', 'Lisburn'),
(3913, 222, 'LUT', 'Luton'),
(3914, 222, 'MAN', 'Manchester'),
(3915, 222, 'MDB', 'Middlesbrough'),
(3916, 222, 'MDW', 'Medway'),
(3917, 222, 'MFT', 'Magherafelt'),
(3918, 222, 'MIK', 'Milton Keynes'),
(3919, 222, 'MLN', 'Midlothian'),
(3920, 222, 'MON', 'Monmouthshire'),
(3921, 222, 'MRT', 'Merton'),
(3922, 222, 'MRY', 'Moray'),
(3923, 222, 'MTY', 'Merthyr Tydfil'),
(3924, 222, 'MYL', 'Moyle'),
(3925, 222, 'NAY', 'North Ayrshire'),
(3926, 222, 'NBL', 'Northumberland'),
(3927, 222, 'NDN', 'North Down'),
(3928, 222, 'NEL', 'North East Lincolnshire'),
(3929, 222, 'NET', 'Newcastle upon Tyne'),
(3930, 222, 'NFK', 'Norfolk'),
(3931, 222, 'NGM', 'Nottingham'),
(3932, 222, 'NLK', 'North Lanarkshire'),
(3933, 222, 'NLN', 'North Lincolnshire'),
(3934, 222, 'NSM', 'North Somerset'),
(3935, 222, 'NTA', 'Newtownabbey'),
(3936, 222, 'NTH', 'Northamptonshire'),
(3937, 222, 'NTL', 'Neath Port Talbot'),
(3938, 222, 'NTT', 'Nottinghamshire'),
(3939, 222, 'NTY', 'North Tyneside'),
(3940, 222, 'NWM', 'Newham'),
(3941, 222, 'NWP', 'Newport'),
(3942, 222, 'NYK', 'North Yorkshire'),
(3943, 222, 'NYM', 'Newry and Mourne'),
(3944, 222, 'OLD', 'Oldham'),
(3945, 222, 'OMH', 'Omagh'),
(3946, 222, 'ORK', 'Orkney Islands'),
(3947, 222, 'OXF', 'Oxfordshire'),
(3948, 222, 'PEM', 'Pembrokeshire'),
(3949, 222, 'PKN', 'Perth and Kinross'),
(3950, 222, 'PLY', 'Plymouth'),
(3951, 222, 'POL', 'Poole'),
(3952, 222, 'POR', 'Portsmouth'),
(3953, 222, 'POW', 'Powys'),
(3954, 222, 'PTE', 'Peterborough'),
(3955, 222, 'RCC', 'Redcar and Cleveland'),
(3956, 222, 'RCH', 'Rochdale'),
(3957, 222, 'RCT', 'Rhondda Cynon Taf'),
(3958, 222, 'RDB', 'Redbridge'),
(3959, 222, 'RDG', 'Reading'),
(3960, 222, 'RFW', 'Renfrewshire'),
(3961, 222, 'RIC', 'Richmond upon Thames'),
(3962, 222, 'ROT', 'Rotherham'),
(3963, 222, 'RUT', 'Rutland'),
(3964, 222, 'SAW', 'Sandwell'),
(3965, 222, 'SAY', 'South Ayrshire'),
(3966, 222, 'SCB', 'Scottish Borders'),
(3967, 222, 'SFK', 'Suffolk'),
(3968, 222, 'SFT', 'Sefton'),
(3969, 222, 'SGC', 'South Gloucestershire'),
(3970, 222, 'SHF', 'Sheffield'),
(3971, 222, 'SHN', 'Saint Helens'),
(3972, 222, 'SHR', 'Shropshire'),
(3973, 222, 'SKP', 'Stockport'),
(3974, 222, 'SLF', 'Salford'),
(3975, 222, 'SLG', 'Slough'),
(3976, 222, 'SLK', 'South Lanarkshire'),
(3977, 222, 'SND', 'Sunderland'),
(3978, 222, 'SOL', 'Solihull'),
(3979, 222, 'SOM', 'Somerset'),
(3980, 222, 'SOS', 'Southend-on-Sea'),
(3981, 222, 'SRY', 'Surrey'),
(3982, 222, 'STB', 'Strabane'),
(3983, 222, 'STE', 'Stoke-on-Trent'),
(3984, 222, 'STG', 'Stirling'),
(3985, 222, 'STH', 'Southampton'),
(3986, 222, 'STN', 'Sutton'),
(3987, 222, 'STS', 'Staffordshire'),
(3988, 222, 'STT', 'Stockton-on-Tees'),
(3989, 222, 'STY', 'South Tyneside'),
(3990, 222, 'SWA', 'Swansea'),
(3991, 222, 'SWD', 'Swindon'),
(3992, 222, 'SWK', 'Southwark'),
(3993, 222, 'TAM', 'Tameside'),
(3994, 222, 'TFW', 'Telford and Wrekin'),
(3995, 222, 'THR', 'Thurrock'),
(3996, 222, 'TOB', 'Torbay'),
(3997, 222, 'TOF', 'Torfaen'),
(3998, 222, 'TRF', 'Trafford'),
(3999, 222, 'TWH', 'Tower Hamlets'),
(4000, 222, 'VGL', 'Vale of Glamorgan'),
(4001, 222, 'WAR', 'Warwickshire'),
(4002, 222, 'WBK', 'West Berkshire'),
(4003, 222, 'WDU', 'West Dunbartonshire'),
(4004, 222, 'WFT', 'Waltham Forest'),
(4005, 222, 'WGN', 'Wigan'),
(4006, 222, 'WIL', 'Wiltshire'),
(4007, 222, 'WKF', 'Wakefield'),
(4008, 222, 'WLL', 'Walsall'),
(4009, 222, 'WLN', 'West Lothian'),
(4010, 222, 'WLV', 'Wolverhampton'),
(4011, 222, 'WNM', 'Windsor and Maidenhead'),
(4012, 222, 'WOK', 'Wokingham'),
(4013, 222, 'WOR', 'Worcestershire'),
(4014, 222, 'WRL', 'Wirral'),
(4015, 222, 'WRT', 'Warrington'),
(4016, 222, 'WRX', 'Wrexham'),
(4017, 222, 'WSM', 'Westminster'),
(4018, 222, 'WSX', 'West Sussex'),
(4019, 222, 'YOR', 'Yorkshire'),
(4020, 222, 'ZET', 'Shetland Islands'),
(4021, 223, 'AK', 'Alaska'),
(4022, 223, 'AL', 'Alabama'),
(4023, 223, 'AS', 'American Samoa'),
(4024, 223, 'AR', 'Arkansas'),
(4025, 223, 'AZ', 'Arizona'),
(4026, 223, 'CA', 'California'),
(4027, 223, 'CO', 'Colorado'),
(4028, 223, 'CT', 'Connecticut'),
(4029, 223, 'DC', 'District of Columbia'),
(4030, 223, 'DE', 'Delaware'),
(4031, 223, 'FL', 'Florida'),
(4032, 223, 'GA', 'Georgia'),
(4033, 223, 'GU', 'Guam'),
(4034, 223, 'HI', 'Hawaii'),
(4035, 223, 'IA', 'Iowa'),
(4036, 223, 'ID', 'Idaho'),
(4037, 223, 'IL', 'Illinois'),
(4038, 223, 'IN', 'Indiana'),
(4039, 223, 'KS', 'Kansas'),
(4040, 223, 'KY', 'Kentucky'),
(4041, 223, 'LA', 'Louisiana'),
(4042, 223, 'MA', 'Massachusetts'),
(4043, 223, 'MD', 'Maryland'),
(4044, 223, 'ME', 'Maine'),
(4045, 223, 'MI', 'Michigan'),
(4046, 223, 'MN', 'Minnesota'),
(4047, 223, 'MO', 'Missouri'),
(4048, 223, 'MS', 'Mississippi'),
(4049, 223, 'MT', 'Montana'),
(4050, 223, 'NC', 'North Carolina'),
(4051, 223, 'ND', 'North Dakota'),
(4052, 223, 'NE', 'Nebraska'),
(4053, 223, 'NH', 'New Hampshire'),
(4054, 223, 'NJ', 'New Jersey'),
(4055, 223, 'NM', 'New Mexico'),
(4056, 223, 'NV', 'Nevada'),
(4057, 223, 'NY', 'New York'),
(4058, 223, 'MP', 'Northern Mariana Islands'),
(4059, 223, 'OH', 'Ohio'),
(4060, 223, 'OK', 'Oklahoma'),
(4061, 223, 'OR', 'Oregon'),
(4062, 223, 'PA', 'Pennsylvania'),
(4063, 223, 'PR', 'Puerto Rico'),
(4064, 223, 'RI', 'Rhode Island'),
(4065, 223, 'SC', 'South Carolina'),
(4066, 223, 'SD', 'South Dakota'),
(4067, 223, 'TN', 'Tennessee'),
(4068, 223, 'TX', 'Texas'),
(4069, 223, 'UM', 'U.S. Minor Outlying Islands'),
(4070, 223, 'UT', 'Utah'),
(4071, 223, 'VA', 'Virginia'),
(4072, 223, 'VI', 'Virgin Islands of the U.S.'),
(4073, 223, 'VT', 'Vermont'),
(4074, 223, 'WA', 'Washington'),
(4075, 223, 'WI', 'Wisconsin'),
(4076, 223, 'WV', 'West Virginia'),
(4077, 223, 'WY', 'Wyoming'),
(4078, 224, 'BI', 'Baker Island'),
(4079, 224, 'HI', 'Howland Island'),
(4080, 224, 'JI', 'Jarvis Island'),
(4081, 224, 'JA', 'Johnston Atoll'),
(4082, 224, 'KR', 'Kingman Reef'),
(4083, 224, 'MA', 'Midway Atoll'),
(4084, 224, 'NI', 'Navassa Island'),
(4085, 224, 'PA', 'Palmyra Atoll'),
(4086, 224, 'WI', 'Wake Island'),
(4087, 225, 'AR', 'Artigas'),
(4088, 225, 'CA', 'Canelones'),
(4089, 225, 'CL', 'Cerro Largo'),
(4090, 225, 'CO', 'Colonia'),
(4091, 225, 'DU', 'Durazno'),
(4092, 225, 'FD', 'Florida'),
(4093, 225, 'FS', 'Flores'),
(4094, 225, 'LA', 'Lavalleja'),
(4095, 225, 'MA', 'Maldonado'),
(4096, 225, 'MO', 'Montevideo'),
(4097, 225, 'PA', 'Paysandu'),
(4098, 225, 'RN', 'Río Negro'),
(4099, 225, 'RO', 'Rocha'),
(4100, 225, 'RV', 'Rivera'),
(4101, 225, 'SA', 'Salto'),
(4102, 225, 'SJ', 'San José'),
(4103, 225, 'SO', 'Soriano'),
(4104, 225, 'TA', 'Tacuarembó'),
(4105, 225, 'TT', 'Treinta y Tres'),
(4106, 226, 'AN', 'Andijon viloyati'),
(4107, 226, 'BU', 'Buxoro viloyati'),
(4108, 226, 'FA', 'Farg''ona viloyati'),
(4109, 226, 'JI', 'Jizzax viloyati'),
(4110, 226, 'NG', 'Namangan viloyati'),
(4111, 226, 'NW', 'Navoiy viloyati'),
(4112, 226, 'QA', 'Qashqadaryo viloyati'),
(4113, 226, 'QR', 'Qoraqalpog''iston Respublikasi'),
(4114, 226, 'SA', 'Samarqand viloyati'),
(4115, 226, 'SI', 'Sirdaryo viloyati'),
(4116, 226, 'SU', 'Surxondaryo viloyati'),
(4117, 226, 'TK', 'Toshkent'),
(4118, 226, 'TO', 'Toshkent viloyati'),
(4119, 226, 'XO', 'Xorazm viloyati'),
(4120, 227, 'MAP', 'Malampa'),
(4121, 227, 'PAM', 'Pénama'),
(4122, 227, 'SAM', 'Sanma'),
(4123, 227, 'SEE', 'Shéfa'),
(4124, 227, 'TAE', 'Taféa'),
(4125, 227, 'TOB', 'Torba'),
(4126, 229, 'A', 'Distrito Capital'),
(4127, 229, 'B', 'Anzoátegui'),
(4128, 229, 'C', 'Apure'),
(4129, 229, 'D', 'Aragua'),
(4130, 229, 'E', 'Barinas'),
(4131, 229, 'F', 'Bolívar'),
(4132, 229, 'G', 'Carabobo'),
(4133, 229, 'H', 'Cojedes'),
(4134, 229, 'I', 'Falcón'),
(4135, 229, 'J', 'Guárico'),
(4136, 229, 'K', 'Lara'),
(4137, 229, 'L', 'Mérida'),
(4138, 229, 'M', 'Miranda'),
(4139, 229, 'N', 'Monagas'),
(4140, 229, 'O', 'Nueva Esparta'),
(4141, 229, 'P', 'Portuguesa'),
(4142, 229, 'R', 'Sucre'),
(4143, 229, 'S', 'Tachira'),
(4144, 229, 'T', 'Trujillo'),
(4145, 229, 'U', 'Yaracuy'),
(4146, 229, 'V', 'Zulia'),
(4147, 229, 'W', 'Capital Dependencia'),
(4148, 229, 'X', 'Vargas'),
(4149, 229, 'Y', 'Delta Amacuro'),
(4150, 229, 'Z', 'Amazonas'),
(4151, 230, '01', 'Lai Châu'),
(4152, 230, '02', 'Lào Cai'),
(4153, 230, '03', 'Hà Giang'),
(4154, 230, '04', 'Cao Bằng'),
(4155, 230, '05', 'Sơn La'),
(4156, 230, '06', 'Yên Bái'),
(4157, 230, '07', 'Tuyên Quang'),
(4158, 230, '09', 'Lạng Sơn'),
(4159, 230, '13', 'Quảng Ninh'),
(4160, 230, '14', 'Hòa Bình'),
(4161, 230, '15', 'Hà Tây'),
(4162, 230, '18', 'Ninh Bình'),
(4163, 230, '20', 'Thái Bình'),
(4164, 230, '21', 'Thanh Hóa'),
(4165, 230, '22', 'Nghệ An'),
(4166, 230, '23', 'Hà Tĩnh'),
(4167, 230, '24', 'Quảng Bình'),
(4168, 230, '25', 'Quảng Trị'),
(4169, 230, '26', 'Thừa Thiên-Huế'),
(4170, 230, '27', 'Quảng Nam'),
(4171, 230, '28', 'Kon Tum'),
(4172, 230, '29', 'Quảng Ngãi'),
(4173, 230, '30', 'Gia Lai'),
(4174, 230, '31', 'Bình Định'),
(4175, 230, '32', 'Phú Yên'),
(4176, 230, '33', 'Đắk Lắk'),
(4177, 230, '34', 'Khánh Hòa'),
(4178, 230, '35', 'Lâm Đồng'),
(4179, 230, '36', 'Ninh Thuận'),
(4180, 230, '37', 'Tây Ninh'),
(4181, 230, '39', 'Đồng Nai'),
(4182, 230, '40', 'Bình Thuận'),
(4183, 230, '41', 'Long An'),
(4184, 230, '43', 'Bà Rịa-Vũng Tàu'),
(4185, 230, '44', 'An Giang'),
(4186, 230, '45', 'Đồng Tháp'),
(4187, 230, '46', 'Tiền Giang'),
(4188, 230, '47', 'Kiên Giang'),
(4189, 230, '48', 'Cần Thơ'),
(4190, 230, '49', 'Vĩnh Long'),
(4191, 230, '50', 'Bến Tre'),
(4192, 230, '51', 'Trà Vinh'),
(4193, 230, '52', 'Sóc Trăng'),
(4194, 230, '53', 'Bắc Kạn'),
(4195, 230, '54', 'Bắc Giang'),
(4196, 230, '55', 'Bạc Liêu'),
(4197, 230, '56', 'Bắc Ninh'),
(4198, 230, '57', 'Bình Dương'),
(4199, 230, '58', 'Bình Phước'),
(4200, 230, '59', 'Cà Mau'),
(4201, 230, '60', 'Đà Nẵng'),
(4202, 230, '61', 'Hải Dương'),
(4203, 230, '62', 'Hải Phòng'),
(4204, 230, '63', 'Hà Nam'),
(4205, 230, '64', 'Hà Nội'),
(4206, 230, '65', 'Sài Gòn'),
(4207, 230, '66', 'Hưng Yên'),
(4208, 230, '67', 'Nam Định'),
(4209, 230, '68', 'Phú Thọ'),
(4210, 230, '69', 'Thái Nguyên'),
(4211, 230, '70', 'Vĩnh Phúc'),
(4212, 230, '71', 'Điện Biên'),
(4213, 230, '72', 'Đắk Nông'),
(4214, 230, '73', 'Hậu Giang'),
(4215, 232, 'C', 'Saint Croix'),
(4216, 232, 'J', 'Saint John'),
(4217, 232, 'T', 'Saint Thomas'),
(4218, 233, 'A', 'Alo'),
(4219, 233, 'S', 'Sigave'),
(4220, 233, 'W', 'Wallis'),
(4221, 235, 'AB', 'أبين‎'),
(4222, 235, 'AD', 'عدن'),
(4223, 235, 'AM', 'عمران'),
(4224, 235, 'BA', 'البيضاء'),
(4225, 235, 'DA', 'الضالع'),
(4226, 235, 'DH', 'ذمار'),
(4227, 235, 'HD', 'حضرموت'),
(4228, 235, 'HJ', 'حجة'),
(4229, 235, 'HU', 'الحديدة'),
(4230, 235, 'IB', 'إب'),
(4231, 235, 'JA', 'الجوف'),
(4232, 235, 'LA', 'لحج'),
(4233, 235, 'MA', 'مأرب'),
(4234, 235, 'MR', 'المهرة'),
(4235, 235, 'MW', 'المحويت'),
(4236, 235, 'SD', 'صعدة'),
(4237, 235, 'SN', 'صنعاء'),
(4238, 235, 'SH', 'شبوة'),
(4239, 235, 'TA', 'تعز'),
(4240, 238, '01', 'Western'),
(4241, 238, '02', 'Central'),
(4242, 238, '03', 'Eastern'),
(4243, 238, '04', 'Luapula'),
(4244, 238, '05', 'Northern'),
(4245, 238, '06', 'North-Western'),
(4246, 238, '07', 'Southern'),
(4247, 238, '08', 'Copperbelt'),
(4248, 238, '09', 'Lusaka'),
(4249, 239, 'MA', 'Manicaland'),
(4250, 239, 'MC', 'Mashonaland Central'),
(4251, 239, 'ME', 'Mashonaland East'),
(4252, 239, 'MI', 'Midlands'),
(4253, 239, 'MN', 'Matabeleland North'),
(4254, 239, 'MS', 'Matabeleland South'),
(4255, 239, 'MV', 'Masvingo'),
(4256, 239, 'MW', 'Mashonaland West');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]zones_to_geo_zones`
--

CREATE TABLE `[[dbprefix]]zones_to_geo_zones` (
  `association_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `geo_zone_id` int(11) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`association_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]zones_to_geo_zones`
--

INSERT INTO `[[dbprefix]]zones_to_geo_zones` VALUES
(1, 223, 4031, 1, NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `toc_variants_specials`
--

CREATE TABLE `toc_variants_specials` (
  `variants_specials_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_variants_id` int(11) NOT NULL,
  `variants_specials_price` decimal(15,4) NOT NULL,
  `specials_date_added` datetime DEFAULT NULL,
  `specials_last_modified` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`variants_specials_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
