<?php
/****************************************************************************
* todoyu is published under the BSD License:
* http://www.opensource.org/licenses/bsd-license.php
*
* Copyright (c) 2013, snowflake productions GmbH, Switzerland
* All rights reserved.
*
* This script is part of the todoyu project.
* The todoyu project is free software; you can redistribute it and/or modify
* it under the terms of the BSD License.
*
* This script is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the BSD License
* for more details.
*
* This copyright notice MUST APPEAR in all copies of the script.
*****************************************************************************/

/**
 * Test for: TodoyuProjectTask
 *
 * @package		Todoyu
 * @subpackage	Project
 */

/**
 * Test class for TodoyuPortalManager.
 * Generated by PHPUnit on 2010-03-12 at 16:38:16.
 */
class TodoyuProjectTaskTest extends PHPUnit_Framework_TestCase
{
	/**
	 * @var TodoyuProjectTask
	 */
	protected $object;

	/**
	 * @var Array
	 */
	private $array;


	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp() {
			// Get ID of some task
		$where		= 'deleted = 0 AND `type` = ' . TASK_TYPE_TASK;
		$idTestTask	= Todoyu::db()->getFieldValue('id', 'ext_project_task', $where, '', '', '0,1', 'id');

		$this->array	= array(
			'id'	=> $idTestTask
		);

			// Construct
		$this->object = new TodoyuProjectTask($idTestTask);
	}



	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 */
	protected function tearDown() {

	}



	/**
	 * Test TodoyuProjectTask::__construct
	 */
	public function testConstructor() {
			// Test successful constructor
		$idTask	= TodoyuArray::getColumn($this->array, 'id');

		$task = new TodoyuProjectTask($idTask);
		$this->assertNotNull($task, 'constructor test');

			// Test construction with task ID (0)
		$task = new TodoyuProjectTask(0);
		$this->assertNotNull($task, 'constructor test without ID');
		$title	= $task->getTitle();
		$this->assertEquals(0, strlen($title), 'task 0 title is empty');
	}



	/**
	 * Test TodoyuProjectTask::testGetTitle().
	 */
	public function testGetTitle() {
//		$title	= $this->object->getTitle();
//
//		$this->assertInternalType( 'string', $title );
//		$this->assertGreaterThan( 0, strlen($title) );
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * Test TodoyuProjectTask::testGetFullTitle().
	 */
	public function testGetFullTitle() {
		$fullTitle	= $this->object->getFullTitle();

		$this->assertInternalType( 'string', $fullTitle );
		$this->assertGreaterThan(0, strlen($fullTitle));

			// Full title must be longer than title
		$title	= $this->object->getTitle();
		$this->assertGreaterThan(strlen($title), strlen($fullTitle));
	}



	/**
	 * @todo Implement testGetTaskNumber().
	 *
	 * @param	Boolean		$full
	 */
	public function testGetTaskNumber($full = true) {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testHasStatus().
	 */
	public function testHasStatus() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetStatus().
	 */
	public function testGetStatus() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetStatusKey().
	 */
	public function testGetStatusKey() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetStatusLabel().
	 */
	public function testGetStatusLabel() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testHasParentTask().
	 */
	public function testHasParentTask() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testHasSubTasks().
	 */
	public function testHasSubTasks() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetParentTask().
	 */
	public function testGetParentTask() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetParentTaskID().
	 */
	public function testGetParentTaskID() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetProjectID().
	 */
	public function testGetProjectID() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetProjectArray().
	 */
	public function testGetProjectArray() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetProject().
	 */
	public function testGetProject() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetActivity().
	 */
	public function testGetActivity() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetType().
	 */
	public function testGetType() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetStartDate().
	 */
	public function testGetStartDate() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetEndDate().
	 */
	public function testGetEndDate() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetDeadlineDate().
	 */
	public function testGetDeadlineDate() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testIsContainer().
	 */
	public function testIsContainer() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testIsTask().
	 */
	public function testIsTask() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testIsPublic().
	 */
	public function testIsPublic() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testIsAcknowledged().
	 */
	public function testIsAcknowledged() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testLoadForeignData().
	 */
	public function testLoadForeignData() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 * @todo Implement testGetTemplateData().
	 */
	public function testGetTemplateData() {
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
		  'This test has not been implemented yet.'
		);
	}



	/**
	 *
	 */
	public function testEstimatedTimeExceededConfigToZero() {
		$configZero = array(
			'toleranceEnddate'	=> 0,
			'toleranceDeadline'	=> 0,
		);

		$configNull = array(
			'toleranceEnddate'	=> null,
			'toleranceDeadline'	=> null,
		);

		$month = 1 * 30 * 24 * 3600;

		$task	= TodoyuProjectTaskManager::getTask($this->array['id']);

		// 1 month in the future (false anyway)
		$dateToCheck = NOW + $month;
		$task->set('date_deadline', $dateToCheck);
		$task->set('date_end', $dateToCheck);


		$this->assertEquals($dateToCheck, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateDeadline());
		$this->assertEquals($dateToCheck, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateEnd());

		TodoyuSysmanagerExtConfManager::setExtConf('project', $configZero);
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateDeadlineExceeded());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		TodoyuSysmanagerExtConfManager::setExtConf('project', $configNull);
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateDeadlineExceeded());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// 1 month in the past
		$dateToCheck = NOW - $month;
		$task->set('date_deadline', $dateToCheck);
		$task->set('date_end', $dateToCheck);

		$this->assertEquals($dateToCheck, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateDeadline());
		$this->assertEquals($dateToCheck, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateEnd());

		TodoyuSysmanagerExtConfManager::setExtConf('project', $configZero);
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateDeadlineExceeded());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		TodoyuSysmanagerExtConfManager::setExtConf('project', $configNull);
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateDeadlineExceeded());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));
	}



	/**
	 *
	 */
	public function testDateEndExceeded() {
		$config = array(
			'toleranceEnddate'	=> 24 * 60,
			'toleranceDeadline'	=> 0
		);

		$caseExceeded		= NOW - 24 * 3600 - 1;

		$caseNotExceeded	= NOW - 24 * 3600;
		$caseNotExceeded1	= NOW + 24 * 3600;
		$caseNotExceeded2	= NOW;
		$caseNotExceeded3	= $caseExceeded;

		$task	= TodoyuProjectTaskManager::getTask($this->array['id']);

		TodoyuSysmanagerExtConfManager::setExtConf('project', $config);
		$task->set('status', STATUS_OPEN);

		// case Exceeded
		$task->set('date_end', $caseExceeded);
		$this->assertEquals($caseExceeded, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateEnd());
		$this->assertEquals(STATUS_OPEN, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertTrue(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// case Not Exceeded
		$task->set('date_end', $caseNotExceeded);
		$this->assertEquals($caseNotExceeded, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateEnd());
		$this->assertEquals(STATUS_OPEN, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// case Not Exceeded 1
		$task->set('date_end', $caseNotExceeded1);
		$this->assertEquals($caseNotExceeded1, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateEnd());
		$this->assertEquals(STATUS_OPEN, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// case Not Exceeded 2
		$task->set('date_end', $caseNotExceeded2);
		$this->assertEquals($caseNotExceeded2, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateEnd());
		$this->assertEquals(STATUS_OPEN, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// case Not Exceeded 3
		$task->set('date_end', $caseNotExceeded3);
		$task->set('status', STATUS_CLEARED);

		$this->assertEquals($caseNotExceeded3, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateEnd());
		$this->assertEquals(STATUS_CLEARED, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateEndExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));
	}



	/**
	 *
	 */
	public function testDateDeadlineExceeded() {
		$config = array(
			'toleranceEnddate'	=> 0,
			'toleranceDeadline'	=> 24 * 60,
		);

		$caseExceeded		= NOW - 24 * 3600 - 1;

		$caseNotExceeded	= NOW - 24 * 3600;
		$caseNotExceeded1	= NOW + 24 * 3600;
		$caseNotExceeded2	= NOW;
		$caseNotExceeded3	= $caseExceeded;

		$task	= TodoyuProjectTaskManager::getTask($this->array['id']);

		TodoyuSysmanagerExtConfManager::setExtConf('project', $config);
		$task->set('status', STATUS_OPEN);

		// case Exceeded
		$task->set('date_deadline', $caseExceeded);
		$this->assertEquals($caseExceeded, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateDeadline());
		$this->assertEquals($caseExceeded, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateDeadline());
		$this->assertEquals(STATUS_OPEN, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertTrue($task->isDateDeadlineExceeded());
		$this->assertArrayHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// case Not Exceeded
		$task->set('date_deadline', $caseNotExceeded);
		$this->assertEquals($caseNotExceeded,TodoyuProjectTaskManager::getTask($this->array['id'])->getDateDeadline());
		$this->assertEquals(STATUS_OPEN, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateDeadlineExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// case Not Exceeded 1
		$task->set('date_deadline', $caseNotExceeded1);
		$this->assertEquals($caseNotExceeded1, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateDeadline());
		$this->assertEquals(STATUS_OPEN, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateDeadlineExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// case Not Exceeded 2
		$task->set('date_deadline', $caseNotExceeded2);
		$this->assertEquals($caseNotExceeded2, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateDeadline());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateDeadlineExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// case Not Exceeded 3
		$task->set('date_deadline', $caseNotExceeded3);
		$task->set('status', STATUS_CLEARED);

		$this->assertEquals($caseNotExceeded3, TodoyuProjectTaskManager::getTask($this->array['id'])->getDateDeadline());
		$this->assertEquals(STATUS_CLEARED, TodoyuProjectTaskManager::getTask($this->array['id'])->getStatus());
		$this->assertFalse(TodoyuProjectTaskManager::getTask($this->array['id'])->isDateDeadlineExceeded());
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));
	}



	public function testCombinatedExeeeding() {
		$config = array(
			'toleranceEnddate'	=> 60,
			'toleranceDeadline'	=> 24 * 60,
		);

		$dateEnd1 = 0;
		$dateEnd2 = NOW - 3600;
		$dateEnd3 = NOW - 24 * 3600;

		$dateDeadline1 = NOW - 24 * 3600;
		$dateDeadline2 = NOW - 24 * 3600 - 1;

		$task	= TodoyuProjectTaskManager::getTask($this->array['id']);
		// set relevant status for exceeding
		$task->set('status', STATUS_OPEN);

		// config
		TodoyuSysmanagerExtConfManager::setExtConf('project', $config);

		// Enddate 0, Deadline not exceeded = NOT EXCEEDED
		$task->set('date_end', $dateEnd1);
		$task->set('date_deadline', $dateDeadline1);
		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// Enddate 0, Deadline exceeded = EXCEEDED
		$task->set('date_end', $dateEnd1);
		$task->set('date_deadline', $dateDeadline2);
		$this->assertArrayHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// Enddate not exceeded, Deadline not exceeded = NOT EXCEEDED
		$task->set('date_end', $dateEnd2);
		$task->set('date_deadline', $dateDeadline1);

		$this->assertArrayNotHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// Enddate exceeded, Deadline not exceeded = EXCEEDED
		$task->set('date_end', $dateEnd3);
		$task->set('date_deadline', $dateDeadline1);

		$this->assertArrayHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// Enddate not Exceeded, Deadline exceeded = EXCEEDED
		$task->set('date_end', $dateEnd2);
		$task->set('date_deadline', $dateDeadline2);

		$this->assertArrayHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));

		// Enddate exceeded, Deadline exceeded = EXCEEDED
		$task->set('date_end', $dateEnd3);
		$task->set('date_deadline', $dateDeadline2);

		$this->assertArrayHasKey('dateover', TodoyuProjectTaskManager::getTaskIcons(array(), $this->array['id']));
	}

}

?>