
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `ttrss198`
--

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_access_keys`
--

CREATE TABLE `ttrss_access_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `access_key` varchar(250) NOT NULL,
  `feed_id` varchar(250) NOT NULL,
  `is_cat` tinyint(1) NOT NULL DEFAULT '0',
  `owner_uid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_archived_feeds`
--

CREATE TABLE `ttrss_archived_feeds` (
  `id` int(11) NOT NULL,
  `owner_uid` int(11) NOT NULL,
  `created` datetime NOT NULL,
  `title` varchar(200) NOT NULL,
  `feed_url` text NOT NULL,
  `site_url` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_cat_counters_cache`
--

CREATE TABLE `ttrss_cat_counters_cache` (
  `feed_id` int(11) NOT NULL,
  `owner_uid` int(11) NOT NULL,
  `value` int(11) NOT NULL DEFAULT '0',
  `updated` datetime NOT NULL,
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_counters_cache`
--

CREATE TABLE `ttrss_counters_cache` (
  `feed_id` int(11) NOT NULL,
  `owner_uid` int(11) NOT NULL,
  `value` int(11) NOT NULL DEFAULT '0',
  `updated` datetime NOT NULL,
  KEY `owner_uid` (`owner_uid`),
  KEY `ttrss_counters_cache_feed_id_idx` (`feed_id`),
  KEY `ttrss_counters_cache_value_idx` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_enclosures`
--

CREATE TABLE `ttrss_enclosures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_url` text NOT NULL,
  `content_type` varchar(250) NOT NULL,
  `post_id` int(11) NOT NULL,
  `title` text NOT NULL,
  `duration` text NOT NULL,
  `width` int(11) NOT NULL DEFAULT '0',
  `height` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_entries`
--

CREATE TABLE `ttrss_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `guid` varchar(255) NOT NULL,
  `link` text NOT NULL,
  `updated` datetime NOT NULL,
  `content` longtext NOT NULL,
  `content_hash` varchar(250) NOT NULL,
  `cached_content` longtext,
  `no_orig_date` tinyint(1) NOT NULL DEFAULT '0',
  `date_entered` datetime NOT NULL,
  `date_updated` datetime NOT NULL,
  `num_comments` int(11) NOT NULL DEFAULT '0',
  `plugin_data` longtext,
  `lang` varchar(2) DEFAULT NULL,
  `comments` varchar(250) NOT NULL DEFAULT '',
  `author` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `guid` (`guid`),
  KEY `ttrss_entries_date_entered_index` (`date_entered`),
  KEY `ttrss_entries_updated_idx` (`updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_entry_comments`
--

CREATE TABLE `ttrss_entry_comments` (
  `id` int(11) NOT NULL,
  `ref_id` int(11) NOT NULL,
  `owner_uid` int(11) NOT NULL,
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `date_entered` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ref_id` (`ref_id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_error_log`
--

CREATE TABLE `ttrss_error_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_uid` int(11) DEFAULT NULL,
  `errno` int(11) NOT NULL,
  `errstr` text NOT NULL,
  `filename` text NOT NULL,
  `lineno` int(11) NOT NULL,
  `context` text NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_feedbrowser_cache`
--

CREATE TABLE `ttrss_feedbrowser_cache` (
  `feed_url` text NOT NULL,
  `site_url` text NOT NULL,
  `title` text NOT NULL,
  `subscribers` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_feeds`
--

CREATE TABLE `ttrss_feeds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_uid` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `cat_id` int(11) DEFAULT NULL,
  `feed_url` text NOT NULL,
  `icon_url` varchar(250) NOT NULL DEFAULT '',
  `update_interval` int(11) NOT NULL DEFAULT '0',
  `purge_interval` int(11) NOT NULL DEFAULT '0',
  `last_updated` datetime DEFAULT NULL,
  `last_unconditional` datetime DEFAULT NULL,
  `last_error` varchar(250) NOT NULL DEFAULT '',
  `last_modified` varchar(250) NOT NULL DEFAULT '',
  `favicon_avg_color` varchar(11) DEFAULT NULL,
  `site_url` varchar(250) NOT NULL DEFAULT '',
  `auth_login` varchar(250) NOT NULL DEFAULT '',
  `auth_pass` varchar(250) NOT NULL DEFAULT '',
  `parent_feed` int(11) DEFAULT NULL,
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `rtl_content` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `include_in_digest` tinyint(1) NOT NULL DEFAULT '1',
  `cache_images` tinyint(1) NOT NULL DEFAULT '0',
  `hide_images` tinyint(1) NOT NULL DEFAULT '0',
  `cache_content` tinyint(1) NOT NULL DEFAULT '0',
  `auth_pass_encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `last_viewed` datetime DEFAULT NULL,
  `last_update_started` datetime DEFAULT NULL,
  `always_display_enclosures` tinyint(1) NOT NULL DEFAULT '0',
  `update_method` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `mark_unread_on_update` tinyint(1) NOT NULL DEFAULT '0',
  `update_on_checksum_change` tinyint(1) NOT NULL DEFAULT '0',
  `strip_images` tinyint(1) NOT NULL DEFAULT '0',
  `view_settings` varchar(250) NOT NULL DEFAULT '',
  `pubsub_state` int(11) NOT NULL DEFAULT '0',
  `favicon_last_checked` datetime DEFAULT NULL,
  `feed_language` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `feed_url` (`feed_url`(255),`owner_uid`),
  KEY `owner_uid` (`owner_uid`),
  KEY `cat_id` (`cat_id`),
  KEY `parent_feed` (`parent_feed`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ttrss_feeds`
--

INSERT INTO `ttrss_feeds` VALUES
(1, 1, 'Tiny Tiny RSS: Forum', NULL, 'http://tt-rss.org/forum/rss.php', '', 0, 0, NULL, NULL, '', '', NULL, '', '', '', NULL, 0, 0, 0, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, 0, 0, 0, '', 0, NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_feed_categories`
--

CREATE TABLE `ttrss_feed_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_uid` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `collapsed` tinyint(1) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `parent_cat` int(11) DEFAULT NULL,
  `view_settings` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `parent_cat` (`parent_cat`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_filters2`
--

CREATE TABLE `ttrss_filters2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_uid` int(11) NOT NULL,
  `match_any_rule` tinyint(1) NOT NULL DEFAULT '0',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `inverse` tinyint(1) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `last_triggered` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_filters2_actions`
--

CREATE TABLE `ttrss_filters2_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filter_id` int(11) NOT NULL,
  `action_id` int(11) NOT NULL DEFAULT '1',
  `action_param` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `filter_id` (`filter_id`),
  KEY `action_id` (`action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_filters2_rules`
--

CREATE TABLE `ttrss_filters2_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filter_id` int(11) NOT NULL,
  `reg_exp` text NOT NULL,
  `inverse` tinyint(1) NOT NULL DEFAULT '0',
  `filter_type` int(11) NOT NULL,
  `feed_id` int(11) DEFAULT NULL,
  `cat_id` int(11) DEFAULT NULL,
  `cat_filter` tinyint(1) NOT NULL DEFAULT '0',
  `match_on` text,
  PRIMARY KEY (`id`),
  KEY `filter_id` (`filter_id`),
  KEY `filter_type` (`filter_type`),
  KEY `feed_id` (`feed_id`),
  KEY `cat_id` (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_filter_actions`
--

CREATE TABLE `ttrss_filter_actions` (
  `id` int(11) NOT NULL,
  `name` varchar(120) NOT NULL,
  `description` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ttrss_filter_actions`
--

INSERT INTO `ttrss_filter_actions` VALUES
(1, 'filter', 'Delete article'),
(2, 'catchup', 'Mark as read'),
(3, 'mark', 'Set starred'),
(4, 'tag', 'Assign tags'),
(5, 'publish', 'Publish article'),
(6, 'score', 'Modify score'),
(7, 'label', 'Assign label'),
(8, 'stop', 'Stop / Do nothing'),
(9, 'plugin', 'Invoke plugin');

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_filter_types`
--

CREATE TABLE `ttrss_filter_types` (
  `id` int(11) NOT NULL,
  `name` varchar(120) NOT NULL,
  `description` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ttrss_filter_types`
--

INSERT INTO `ttrss_filter_types` VALUES
(1, 'title', 'Title'),
(2, 'content', 'Content'),
(3, 'both', 'Title or Content'),
(4, 'link', 'Link'),
(5, 'date', 'Article Date'),
(6, 'author', 'Author'),
(7, 'tag', 'Article Tags');

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_labels2`
--

CREATE TABLE `ttrss_labels2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_uid` int(11) NOT NULL,
  `caption` varchar(250) NOT NULL,
  `fg_color` varchar(15) NOT NULL DEFAULT '',
  `bg_color` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_linked_feeds`
--

CREATE TABLE `ttrss_linked_feeds` (
  `feed_url` text NOT NULL,
  `site_url` text NOT NULL,
  `title` text NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `instance_id` int(11) NOT NULL,
  `subscribers` int(11) NOT NULL,
  KEY `instance_id` (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_linked_instances`
--

CREATE TABLE `ttrss_linked_instances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_connected` datetime NOT NULL,
  `last_status_in` int(11) NOT NULL,
  `last_status_out` int(11) NOT NULL,
  `access_key` varchar(250) NOT NULL,
  `access_url` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_key` (`access_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_plugin_storage`
--

CREATE TABLE `ttrss_plugin_storage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `owner_uid` int(11) NOT NULL,
  `content` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_prefs`
--

CREATE TABLE `ttrss_prefs` (
  `pref_name` varchar(250) NOT NULL,
  `type_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL DEFAULT '1',
  `access_level` int(11) NOT NULL DEFAULT '0',
  `def_value` text NOT NULL,
  PRIMARY KEY (`pref_name`),
  KEY `type_id` (`type_id`),
  KEY `section_id` (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ttrss_prefs`
--

INSERT INTO `ttrss_prefs` VALUES
('ALLOW_DUPLICATE_POSTS', 1, 1, 0, 'false'),
('AUTO_ASSIGN_LABELS', 1, 3, 1, 'false'),
('BLACKLISTED_TAGS', 2, 3, 0, 'main, generic, misc, uncategorized, blog, blogroll, general, news'),
('CDM_AUTO_CATCHUP', 1, 2, 0, 'false'),
('CDM_EXPANDED', 1, 2, 1, 'true'),
('COMBINED_DISPLAY_MODE', 1, 2, 0, 'true'),
('CONFIRM_FEED_CATCHUP', 1, 2, 0, 'true'),
('DEFAULT_ARTICLE_LIMIT', 3, 2, 0, '30'),
('DEFAULT_SEARCH_LANGUAGE', 2, 2, 0, ''),
('DEFAULT_UPDATE_INTERVAL', 3, 1, 0, '30'),
('DIGEST_CATCHUP', 1, 4, 0, 'false'),
('DIGEST_ENABLE', 1, 4, 0, 'false'),
('DIGEST_PREFERRED_TIME', 2, 4, 0, '00:00'),
('ENABLE_API_ACCESS', 1, 1, 0, 'false'),
('ENABLE_FEED_CATS', 1, 2, 0, 'true'),
('FEEDS_SORT_BY_UNREAD', 1, 2, 0, 'false'),
('FRESH_ARTICLE_MAX_AGE', 3, 2, 1, '24'),
('HIDE_READ_FEEDS', 1, 2, 0, 'false'),
('HIDE_READ_SHOWS_SPECIAL', 1, 2, 1, 'true'),
('LONG_DATE_FORMAT', 2, 3, 0, 'D, M d Y - G:i'),
('ON_CATCHUP_SHOW_NEXT_FEED', 1, 2, 1, 'false'),
('PURGE_OLD_DAYS', 3, 1, 0, '60'),
('PURGE_UNREAD_ARTICLES', 1, 3, 0, 'true'),
('REVERSE_HEADLINES', 1, 2, 0, 'false'),
('SHORT_DATE_FORMAT', 2, 3, 0, 'M d, G:i'),
('SHOW_CONTENT_PREVIEW', 1, 2, 1, 'true'),
('SORT_HEADLINES_BY_FEED_DATE', 1, 2, 1, 'false'),
('SSL_CERT_SERIAL', 2, 3, 0, ''),
('STRIP_IMAGES', 1, 2, 0, 'false'),
('STRIP_UNSAFE_TAGS', 1, 3, 0, 'true'),
('USER_CSS_THEME', 2, 2, 0, ''),
('USER_LANGUAGE', 2, 2, 0, ''),
('USER_STYLESHEET', 2, 2, 0, ''),
('USER_TIMEZONE', 2, 1, 0, 'Automatic'),
('VFEED_GROUP_BY_FEED', 1, 2, 1, 'false'),
('_COLLAPSED_FEEDLIST', 1, 1, 0, 'false'),
('_COLLAPSED_LABELS', 1, 1, 0, 'false'),
('_COLLAPSED_SPECIAL', 1, 1, 0, 'false'),
('_COLLAPSED_UNCAT', 1, 1, 0, 'false'),
('_DEFAULT_INCLUDE_CHILDREN', 1, 1, 0, 'false'),
('_DEFAULT_VIEW_LIMIT', 3, 1, 0, '30'),
('_DEFAULT_VIEW_MODE', 2, 1, 0, 'adaptive'),
('_DEFAULT_VIEW_ORDER_BY', 2, 1, 0, 'default'),
('_ENABLED_PLUGINS', 2, 1, 0, ''),
('_MOBILE_BROWSE_CATS', 1, 1, 0, 'true'),
('_MOBILE_ENABLE_CATS', 1, 1, 0, 'false'),
('_MOBILE_HIDE_READ', 1, 1, 0, 'false'),
('_MOBILE_REVERSE_HEADLINES', 1, 1, 0, 'false'),
('_MOBILE_SHOW_IMAGES', 1, 1, 0, 'false'),
('_MOBILE_SORT_FEEDS_UNREAD', 1, 1, 0, 'false'),
('_PREFS_ACTIVE_TAB', 2, 1, 0, ''),
('_PREFS_SHOW_EMPTY_CATS', 1, 1, 0, 'false'),
('_THEME_ID', 2, 1, 0, '0');

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_prefs_sections`
--

CREATE TABLE `ttrss_prefs_sections` (
  `id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ttrss_prefs_sections`
--

INSERT INTO `ttrss_prefs_sections` VALUES
(1, 0),
(2, 1),
(3, 3),
(4, 2);

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_prefs_types`
--

CREATE TABLE `ttrss_prefs_types` (
  `id` int(11) NOT NULL,
  `type_name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ttrss_prefs_types`
--

INSERT INTO `ttrss_prefs_types` VALUES
(1, 'bool'),
(2, 'string'),
(3, 'integer');

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_sessions`
--

CREATE TABLE `ttrss_sessions` (
  `id` varchar(250) NOT NULL,
  `data` text,
  `expire` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_settings_profiles`
--

CREATE TABLE `ttrss_settings_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `owner_uid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_tags`
--

CREATE TABLE `ttrss_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_uid` int(11) NOT NULL,
  `tag_name` varchar(250) NOT NULL,
  `post_int_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `post_int_id` (`post_int_id`),
  KEY `owner_uid` (`owner_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_users`
--

CREATE TABLE `ttrss_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(120) NOT NULL,
  `pwd_hash` varchar(250) NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `access_level` int(11) NOT NULL DEFAULT '0',
  `email` varchar(250) NOT NULL DEFAULT '',
  `full_name` varchar(250) NOT NULL DEFAULT '',
  `email_digest` tinyint(1) NOT NULL DEFAULT '0',
  `last_digest_sent` datetime DEFAULT NULL,
  `salt` varchar(250) NOT NULL DEFAULT '',
  `created` datetime DEFAULT NULL,
  `twitter_oauth` longtext,
  `otp_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `resetpass_token` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ttrss_users`
--

INSERT INTO `ttrss_users` VALUES
(1, 'admin', '[[admin_pass]]', NULL, 10, '[[admin_email]]', '', 0, NULL, '', NULL, NULL, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_user_entries`
--

CREATE TABLE `ttrss_user_entries` (
  `int_id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL,
  `uuid` varchar(200) NOT NULL,
  `feed_id` int(11) DEFAULT NULL,
  `orig_feed_id` int(11) DEFAULT NULL,
  `owner_uid` int(11) NOT NULL,
  `marked` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `tag_cache` text NOT NULL,
  `label_cache` text NOT NULL,
  `last_read` datetime DEFAULT NULL,
  `score` int(11) NOT NULL DEFAULT '0',
  `note` longtext,
  `last_marked` datetime DEFAULT NULL,
  `last_published` datetime DEFAULT NULL,
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`int_id`),
  KEY `ref_id` (`ref_id`),
  KEY `feed_id` (`feed_id`),
  KEY `orig_feed_id` (`orig_feed_id`),
  KEY `owner_uid` (`owner_uid`),
  KEY `ttrss_user_entries_unread_idx` (`unread`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_user_labels2`
--

CREATE TABLE `ttrss_user_labels2` (
  `label_id` int(11) NOT NULL,
  `article_id` int(11) NOT NULL,
  KEY `label_id` (`label_id`),
  KEY `article_id` (`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_user_prefs`
--

CREATE TABLE `ttrss_user_prefs` (
  `owner_uid` int(11) NOT NULL,
  `pref_name` varchar(250) DEFAULT NULL,
  `value` longtext NOT NULL,
  `profile` int(11) DEFAULT NULL,
  KEY `profile` (`profile`),
  KEY `owner_uid` (`owner_uid`),
  KEY `pref_name` (`pref_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ttrss_user_prefs`
--

INSERT INTO `ttrss_user_prefs` VALUES
(1, 'USER_LANGUAGE', '[[language]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ttrss_version`
--

CREATE TABLE `ttrss_version` (
  `schema_version` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ttrss_version`
--

INSERT INTO `ttrss_version` VALUES
(138);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `ttrss_access_keys`
--
ALTER TABLE `ttrss_access_keys`
  ADD CONSTRAINT `ttrss_access_keys_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_archived_feeds`
--
ALTER TABLE `ttrss_archived_feeds`
  ADD CONSTRAINT `ttrss_archived_feeds_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_cat_counters_cache`
--
ALTER TABLE `ttrss_cat_counters_cache`
  ADD CONSTRAINT `ttrss_cat_counters_cache_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_counters_cache`
--
ALTER TABLE `ttrss_counters_cache`
  ADD CONSTRAINT `ttrss_counters_cache_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_enclosures`
--
ALTER TABLE `ttrss_enclosures`
  ADD CONSTRAINT `ttrss_enclosures_ibfk_1` FOREIGN KEY (`post_id`) REFERENCES `ttrss_entries` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_entry_comments`
--
ALTER TABLE `ttrss_entry_comments`
  ADD CONSTRAINT `ttrss_entry_comments_ibfk_1` FOREIGN KEY (`ref_id`) REFERENCES `ttrss_entries` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_entry_comments_ibfk_2` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_error_log`
--
ALTER TABLE `ttrss_error_log`
  ADD CONSTRAINT `ttrss_error_log_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `ttrss_feeds`
--
ALTER TABLE `ttrss_feeds`
  ADD CONSTRAINT `ttrss_feeds_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_feeds_ibfk_2` FOREIGN KEY (`cat_id`) REFERENCES `ttrss_feed_categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `ttrss_feeds_ibfk_3` FOREIGN KEY (`parent_feed`) REFERENCES `ttrss_feeds` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `ttrss_feed_categories`
--
ALTER TABLE `ttrss_feed_categories`
  ADD CONSTRAINT `ttrss_feed_categories_ibfk_1` FOREIGN KEY (`parent_cat`) REFERENCES `ttrss_feed_categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `ttrss_feed_categories_ibfk_2` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_filters2`
--
ALTER TABLE `ttrss_filters2`
  ADD CONSTRAINT `ttrss_filters2_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_filters2_actions`
--
ALTER TABLE `ttrss_filters2_actions`
  ADD CONSTRAINT `ttrss_filters2_actions_ibfk_1` FOREIGN KEY (`filter_id`) REFERENCES `ttrss_filters2` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_filters2_actions_ibfk_2` FOREIGN KEY (`action_id`) REFERENCES `ttrss_filter_actions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_filters2_rules`
--
ALTER TABLE `ttrss_filters2_rules`
  ADD CONSTRAINT `ttrss_filters2_rules_ibfk_1` FOREIGN KEY (`filter_id`) REFERENCES `ttrss_filters2` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_filters2_rules_ibfk_2` FOREIGN KEY (`filter_type`) REFERENCES `ttrss_filter_types` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_filters2_rules_ibfk_3` FOREIGN KEY (`feed_id`) REFERENCES `ttrss_feeds` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_filters2_rules_ibfk_4` FOREIGN KEY (`cat_id`) REFERENCES `ttrss_feed_categories` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_labels2`
--
ALTER TABLE `ttrss_labels2`
  ADD CONSTRAINT `ttrss_labels2_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_linked_feeds`
--
ALTER TABLE `ttrss_linked_feeds`
  ADD CONSTRAINT `ttrss_linked_feeds_ibfk_1` FOREIGN KEY (`instance_id`) REFERENCES `ttrss_linked_instances` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_plugin_storage`
--
ALTER TABLE `ttrss_plugin_storage`
  ADD CONSTRAINT `ttrss_plugin_storage_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_prefs`
--
ALTER TABLE `ttrss_prefs`
  ADD CONSTRAINT `ttrss_prefs_ibfk_1` FOREIGN KEY (`type_id`) REFERENCES `ttrss_prefs_types` (`id`),
  ADD CONSTRAINT `ttrss_prefs_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `ttrss_prefs_sections` (`id`);

--
-- Constraints for table `ttrss_settings_profiles`
--
ALTER TABLE `ttrss_settings_profiles`
  ADD CONSTRAINT `ttrss_settings_profiles_ibfk_1` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_tags`
--
ALTER TABLE `ttrss_tags`
  ADD CONSTRAINT `ttrss_tags_ibfk_1` FOREIGN KEY (`post_int_id`) REFERENCES `ttrss_user_entries` (`int_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_tags_ibfk_2` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_user_entries`
--
ALTER TABLE `ttrss_user_entries`
  ADD CONSTRAINT `ttrss_user_entries_ibfk_1` FOREIGN KEY (`ref_id`) REFERENCES `ttrss_entries` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_user_entries_ibfk_2` FOREIGN KEY (`feed_id`) REFERENCES `ttrss_feeds` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_user_entries_ibfk_3` FOREIGN KEY (`orig_feed_id`) REFERENCES `ttrss_archived_feeds` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `ttrss_user_entries_ibfk_4` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_user_labels2`
--
ALTER TABLE `ttrss_user_labels2`
  ADD CONSTRAINT `ttrss_user_labels2_ibfk_1` FOREIGN KEY (`label_id`) REFERENCES `ttrss_labels2` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_user_labels2_ibfk_2` FOREIGN KEY (`article_id`) REFERENCES `ttrss_entries` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ttrss_user_prefs`
--
ALTER TABLE `ttrss_user_prefs`
  ADD CONSTRAINT `ttrss_user_prefs_ibfk_1` FOREIGN KEY (`profile`) REFERENCES `ttrss_settings_profiles` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_user_prefs_ibfk_2` FOREIGN KEY (`owner_uid`) REFERENCES `ttrss_users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ttrss_user_prefs_ibfk_3` FOREIGN KEY (`pref_name`) REFERENCES `ttrss_prefs` (`pref_name`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
