
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `tiki159`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[indexName]]`
--

CREATE TABLE `[[indexName]]` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_type` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `object_id` varchar(300) COLLATE utf8_unicode_ci NOT NULL,
  `title` text COLLATE utf8_unicode_ci,
  `creation_date` datetime DEFAULT NULL,
  `modification_date` datetime DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `language` text COLLATE utf8_unicode_ci,
  `gallery_id` text COLLATE utf8_unicode_ci,
  `searchable` text COLLATE utf8_unicode_ci,
  `view_permission` text COLLATE utf8_unicode_ci,
  `attachments` text COLLATE utf8_unicode_ci,
  `primary_image` text COLLATE utf8_unicode_ci,
  `geo_located` text COLLATE utf8_unicode_ci,
  `geo_location` text COLLATE utf8_unicode_ci,
  `allowed_groups` text COLLATE utf8_unicode_ci,
  `allowed_users` text COLLATE utf8_unicode_ci,
  `relations` text COLLATE utf8_unicode_ci,
  `relation_types` text COLLATE utf8_unicode_ci,
  `relation_count` text COLLATE utf8_unicode_ci,
  `title_initial` text COLLATE utf8_unicode_ci,
  `title_firstword` text COLLATE utf8_unicode_ci,
  `url` text COLLATE utf8_unicode_ci,
  `contents` text COLLATE utf8_unicode_ci,
  `user_country` text COLLATE utf8_unicode_ci,
  `user_gender` text COLLATE utf8_unicode_ci,
  `user_homepage` text COLLATE utf8_unicode_ci,
  `user_realName` text COLLATE utf8_unicode_ci,
  `user_allowmsgs` text COLLATE utf8_unicode_ci,
  `user_language` text COLLATE utf8_unicode_ci,
  `user_style` text COLLATE utf8_unicode_ci,
  `user_page` text COLLATE utf8_unicode_ci,
  `groups` text COLLATE utf8_unicode_ci,
  `addongroup` text COLLATE utf8_unicode_ci,
  `addonleadergroup` text COLLATE utf8_unicode_ci,
  `addonpendinggroup` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `object_type` (`object_type`,`object_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[indexName]]`
--

INSERT INTO `[[indexName]]` VALUES
(1, 'file gallery', '1', 'File Galleries', NULL, NULL, '', 'unknown', '-1', 'n', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'F', 'File', 'tiki-list_file_gallery.php?galleryId=1', ' File Galleries  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'file gallery', '2', 'Users File Galleries', NULL, NULL, '', 'unknown', '-1', 'n', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'U', 'Users', 'tiki-list_file_gallery.php?galleryId=2', ' Users File Galleries  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'file gallery', '3', 'Wiki Attachments', NULL, NULL, '', 'unknown', '-1', 'n', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'W', 'Wiki', 'tiki-list_file_gallery.php?galleryId=3', ' Wiki Attachments  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(8, 'user', 'admin', 'System Administrator', '[[regtime]]', NULL, NULL, NULL, NULL, 'n', NULL, '', '', 'n', NULL, 'tokenvqzucfytrvaeewccbtqwwyacuevybdrf', '', '', '', '', 'S', 'System', 'admin', ' System Administrator   ', '', '', '', 'System Administrator', 'y', 'tokenycfefedxfbytywbaaucdupydwdqbbudw', '', '', 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt tokenvqzucfytrvaeewccbtqwwyacuevybdrf', NULL, NULL, NULL),
(5, 'group', 'Admins', 'Admins', NULL, NULL, 'Administrator and accounts managers.', NULL, NULL, 'n', 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'A', 'Admins', 'Admins', ' Admins Administrator and accounts managers. ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'n', 'n', 'n'),
(6, 'group', 'Anonymous', 'Anonymous', NULL, NULL, 'Public users not logged', NULL, NULL, 'n', 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'A', 'Anonymous', 'Anonymous', ' Anonymous Public users not logged ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'n', 'n', 'n'),
(7, 'group', 'Registered', 'Registered', NULL, NULL, 'Users logged into the system', NULL, NULL, 'n', 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'R', 'Registered', 'Registered', ' Registered Users logged into the system ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'n', 'n', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `messu_archive`
--

CREATE TABLE `messu_archive` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8_unicode_ci,
  `user_cc` text COLLATE utf8_unicode_ci,
  `user_bcc` text COLLATE utf8_unicode_ci,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8_unicode_ci,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messu_messages`
--

CREATE TABLE `messu_messages` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8_unicode_ci,
  `user_cc` text COLLATE utf8_unicode_ci,
  `user_bcc` text COLLATE utf8_unicode_ci,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8_unicode_ci,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`),
  KEY `userIsRead` (`user`,`isRead`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messu_sent`
--

CREATE TABLE `messu_sent` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8_unicode_ci,
  `user_cc` text COLLATE utf8_unicode_ci,
  `user_bcc` text COLLATE utf8_unicode_ci,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8_unicode_ci,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `sesskey` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `expiry` int(11) unsigned NOT NULL,
  `expireref` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`sesskey`),
  KEY `expiry` (`expiry`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_account`
--

CREATE TABLE `tiki_acct_account` (
  `accountBookId` int(10) unsigned NOT NULL,
  `accountId` int(10) unsigned NOT NULL DEFAULT '0',
  `accountName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `accountNotes` text COLLATE utf8_unicode_ci NOT NULL,
  `accountBudget` double NOT NULL DEFAULT '0',
  `accountLocked` int(1) NOT NULL DEFAULT '0',
  `accountTax` int(11) NOT NULL DEFAULT '0',
  `accountUserId` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`accountBookId`,`accountId`),
  KEY `accountTax` (`accountTax`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_bankaccount`
--

CREATE TABLE `tiki_acct_bankaccount` (
  `bankBookId` int(10) unsigned NOT NULL,
  `bankAccountId` int(10) unsigned NOT NULL,
  `externalNumber` int(10) NOT NULL,
  `bankCountry` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `bankCode` varchar(11) COLLATE utf8_unicode_ci NOT NULL,
  `bankIBAN` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `bankBIC` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `bankDelimeter` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT ';',
  `bankDecPoint` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT ',',
  `bankThousand` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '.',
  `bankHasHeader` tinyint(1) NOT NULL DEFAULT '1',
  `fieldNameAccount` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `fieldNameBookingDate` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `formatBookingDate` varchar(31) COLLATE utf8_unicode_ci NOT NULL,
  `fieldNameValueDate` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `formatValueDate` varchar(31) COLLATE utf8_unicode_ci NOT NULL,
  `fieldNameBookingText` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `fieldNameReason` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `fieldNameCounterpartName` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `fieldNameCounterpartAccount` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `fieldNameCounterpartBankCode` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `fieldNameAmount` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `amountType` int(10) unsigned NOT NULL,
  `fieldNameAmountSign` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `SignPositive` varchar(7) COLLATE utf8_unicode_ci NOT NULL,
  `SignNegative` varchar(7) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`bankBookId`,`bankAccountId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_book`
--

CREATE TABLE `tiki_acct_book` (
  `bookId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bookName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `bookClosed` enum('y','n') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `bookStartDate` date DEFAULT NULL,
  `bookEndDate` date DEFAULT NULL,
  `bookCurrency` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'EUR',
  `bookCurrencyPos` int(11) NOT NULL,
  `bookDecimals` int(11) NOT NULL DEFAULT '2',
  `bookDecPoint` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT ',',
  `bookThousand` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '.',
  `exportSeparator` varchar(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT ';',
  `exportEOL` varchar(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'LF',
  `exportQuote` varchar(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT '"',
  `bookAutoTax` enum('y','n') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (`bookId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_item`
--

CREATE TABLE `tiki_acct_item` (
  `itemBookId` int(10) unsigned NOT NULL,
  `itemJournalId` int(10) unsigned NOT NULL DEFAULT '0',
  `itemAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `itemType` int(1) NOT NULL DEFAULT '-1',
  `itemAmount` double NOT NULL DEFAULT '0',
  `itemText` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `itemTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`itemBookId`,`itemJournalId`,`itemAccountId`,`itemType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_journal`
--

CREATE TABLE `tiki_acct_journal` (
  `journalBookId` int(10) unsigned NOT NULL,
  `journalId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `journalDate` date DEFAULT NULL,
  `journalDescription` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `journalCancelled` int(1) NOT NULL DEFAULT '0',
  `journalTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`journalId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_stack`
--

CREATE TABLE `tiki_acct_stack` (
  `stackBookId` int(10) unsigned NOT NULL,
  `stackId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `stackDate` date DEFAULT NULL,
  `stackDescription` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `stackTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`stackId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_stackitem`
--

CREATE TABLE `tiki_acct_stackitem` (
  `stackBookId` int(10) unsigned NOT NULL,
  `stackItemStackId` int(10) unsigned NOT NULL DEFAULT '0',
  `stackItemAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `stackItemType` int(1) NOT NULL DEFAULT '-1',
  `stackItemAmount` double NOT NULL DEFAULT '0',
  `stackItemText` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`stackBookId`,`stackItemStackId`,`stackItemAccountId`,`stackItemType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_statement`
--

CREATE TABLE `tiki_acct_statement` (
  `statementBookId` int(10) unsigned NOT NULL,
  `statementAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `statementId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `statementBookingDate` date DEFAULT NULL,
  `statementValueDate` date DEFAULT NULL,
  `statementBookingText` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `statementReason` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `statementCounterpart` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `statementCounterpartAccount` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `statementCounterpartBankCode` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `statementAmount` double NOT NULL,
  `statementJournalId` int(10) unsigned NOT NULL DEFAULT '0',
  `statementStackId` int(11) NOT NULL,
  PRIMARY KEY (`statementId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_tax`
--

CREATE TABLE `tiki_acct_tax` (
  `taxBookId` int(10) unsigned NOT NULL,
  `taxId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taxText` varchar(63) COLLATE utf8_unicode_ci NOT NULL,
  `taxAmount` double NOT NULL DEFAULT '0',
  `taxIsFix` enum('y','n') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`taxId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog`
--

CREATE TABLE `tiki_actionlog` (
  `actionId` int(8) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lastModif` int(14) DEFAULT NULL,
  `object` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `objectType` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `ip` varchar(39) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comment` text COLLATE utf8_unicode_ci,
  `categId` int(12) NOT NULL DEFAULT '0',
  `client` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`actionId`),
  KEY `lastModif` (`lastModif`),
  KEY `object` (`object`(100),`objectType`,`action`(100))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_actionlog`
--


-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog_conf`
--

CREATE TABLE `tiki_actionlog_conf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `status` char(1) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`action`,`objectType`),
  KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=61 ;

--
-- Dumping data for table `tiki_actionlog_conf`
--

INSERT INTO `tiki_actionlog_conf` VALUES
(1, 'Created', 'wiki page', 'y'),
(2, 'Updated', 'wiki page', 'y'),
(3, 'Removed', 'wiki page', 'y'),
(4, 'Viewed', 'wiki page', 'n'),
(5, 'Viewed', 'forum', 'n'),
(6, 'Posted', 'forum', 'n'),
(7, 'Replied', 'forum', 'n'),
(8, 'Updated', 'forum', 'n'),
(9, 'Viewed', 'file gallery', 'n'),
(10, 'Viewed', 'image gallery', 'n'),
(11, 'Uploaded', 'file gallery', 'n'),
(12, 'Uploaded', 'image gallery', 'n'),
(13, '%', 'category', 'n'),
(14, 'login', 'system', 'y'),
(15, 'Posted', 'message', 'n'),
(16, 'Replied', 'message', 'n'),
(17, 'Viewed', 'message', 'n'),
(18, 'Removed version', 'wiki page', 'n'),
(19, 'Removed last version', 'wiki page', 'n'),
(20, 'Rollback', 'wiki page', 'n'),
(21, 'Removed', 'forum', 'n'),
(22, 'Downloaded', 'file gallery', 'n'),
(23, 'Posted', 'comment', 'n'),
(24, 'Replied', 'comment', 'n'),
(25, 'Updated', 'comment', 'n'),
(26, 'Removed', 'comment', 'n'),
(27, 'Renamed', 'wiki page', 'n'),
(28, 'Created', 'sheet', 'n'),
(29, 'Updated', 'sheet', 'n'),
(30, 'Removed', 'sheet', 'n'),
(31, 'Viewed', 'sheet', 'n'),
(32, 'Viewed', 'blog', 'n'),
(33, 'Posted', 'blog', 'n'),
(34, 'Updated', 'blog', 'n'),
(35, 'Removed', 'blog', 'n'),
(36, 'Removed', 'file', 'n'),
(37, 'Viewed', 'article', 'n'),
(38, '%', 'system', 'y'),
(39, 'feature', 'system', 'y'),
(40, 'Updated', 'trackeritem', 'n'),
(41, 'Created', 'trackeritem', 'n'),
(42, 'Viewed', 'trackeritem', 'n'),
(43, 'Created', 'wiki page attachment', 'n'),
(44, 'Removed', 'wiki page attachment', 'n'),
(45, 'Categorized', 'wiki page', 'n'),
(46, 'Uncategorized', 'wiki page', 'n'),
(47, 'Flagged', 'wiki page', 'n'),
(48, 'Fetch', 'url', 'n'),
(49, 'Refresh', 'url', 'n'),
(50, 'Joined Room', 'bigbluebutton', 'n'),
(51, 'Left Room', 'bigbluebutton', 'n'),
(52, 'Created', 'tracker', 'y'),
(53, 'Updated', 'tracker', 'y'),
(54, 'Removed', 'tracker', 'y'),
(55, 'Created', 'category', 'y'),
(56, 'Updated', 'category', 'y'),
(57, 'Removed', 'category', 'y'),
(58, 'Created', 'calendar event', 'n'),
(59, 'Updated', 'calendar event', 'n'),
(60, 'Removed', 'calendar event', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog_params`
--

CREATE TABLE `tiki_actionlog_params` (
  `actionId` int(8) NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  KEY `actionId` (`actionId`),
  KEY `nameValue` (`name`,`value`(200))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream`
--

CREATE TABLE `tiki_activity_stream` (
  `activityId` int(8) NOT NULL AUTO_INCREMENT,
  `eventType` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `eventDate` int(11) NOT NULL,
  `arguments` blob,
  PRIMARY KEY (`activityId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream_mapping`
--

CREATE TABLE `tiki_activity_stream_mapping` (
  `field_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `field_type` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`field_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream_rules`
--

CREATE TABLE `tiki_activity_stream_rules` (
  `ruleId` int(8) NOT NULL AUTO_INCREMENT,
  `eventType` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `ruleType` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `rule` text COLLATE utf8_unicode_ci,
  `notes` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`ruleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_addon_profiles`
--

CREATE TABLE `tiki_addon_profiles` (
  `addon` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `version` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `profile` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `install_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`addon`,`version`,`profile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_areas`
--

CREATE TABLE `tiki_areas` (
  `categId` int(11) NOT NULL,
  `perspectives` text COLLATE utf8_unicode_ci,
  `exclusive` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `share_common` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `enabled` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  KEY `categId` (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_articles`
--

CREATE TABLE `tiki_articles` (
  `articleId` int(8) NOT NULL AUTO_INCREMENT,
  `topline` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subtitle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `linkto` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` char(1) COLLATE utf8_unicode_ci DEFAULT 's',
  `authorName` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topicId` int(14) DEFAULT NULL,
  `topicName` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `size` int(12) DEFAULT NULL,
  `useImage` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_name` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_caption` text COLLATE utf8_unicode_ci,
  `image_type` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_size` int(14) DEFAULT NULL,
  `image_x` int(4) DEFAULT NULL,
  `image_y` int(4) DEFAULT NULL,
  `list_image_x` int(4) DEFAULT NULL,
  `list_image_y` int(4) DEFAULT NULL,
  `image_data` longblob,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `heading` text COLLATE utf8_unicode_ci,
  `body` text COLLATE utf8_unicode_ci,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `author` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nbreads` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` int(14) DEFAULT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rating` decimal(3,2) DEFAULT NULL,
  `isfloat` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ispublished` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (`articleId`),
  KEY `title` (`title`),
  KEY `heading` (`heading`(255)),
  KEY `body` (`body`(255)),
  KEY `nbreads` (`nbreads`),
  KEY `author` (`author`(32)),
  KEY `topicId` (`topicId`),
  KEY `publishDate` (`publishDate`),
  KEY `expireDate` (`expireDate`),
  KEY `type` (`type`),
  FULLTEXT KEY `ft` (`title`,`heading`,`body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_article_types`
--

CREATE TABLE `tiki_article_types` (
  `type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `use_ratings` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_pre_publ` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_post_expire` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `heading_only` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `allow_comments` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `show_image` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `show_avatar` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_author` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `show_pubdate` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `show_expdate` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_reads` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `show_size` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `show_topline` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `show_subtitle` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `show_linkto` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `show_image_caption` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `creator_edit` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comment_can_rate_article` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`type`),
  KEY `show_pre_publ` (`show_pre_publ`),
  KEY `show_post_expire` (`show_post_expire`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tiki_article_types`
--

INSERT INTO `tiki_article_types` VALUES
('Article', NULL, NULL, 'y', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Review', 'y', NULL, 'y', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Event', NULL, NULL, 'n', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Classified', NULL, NULL, 'n', 'y', 'n', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_auth_tokens`
--

CREATE TABLE `tiki_auth_tokens` (
  `tokenId` int(11) NOT NULL AUTO_INCREMENT,
  `creation` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `timeout` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '1',
  `maxhits` int(11) NOT NULL DEFAULT '1',
  `token` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `parameters` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `groups` text COLLATE utf8_unicode_ci,
  `createUser` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `userPrefix` varchar(200) COLLATE utf8_unicode_ci DEFAULT '_token',
  PRIMARY KEY (`tokenId`),
  KEY `tiki_auth_tokens_token` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banners`
--

CREATE TABLE `tiki_banners` (
  `bannerId` int(12) NOT NULL AUTO_INCREMENT,
  `client` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `alt` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `which` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `imageData` longblob,
  `imageType` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `imageName` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `HTMLData` text COLLATE utf8_unicode_ci,
  `fixedURLData` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `textData` text COLLATE utf8_unicode_ci,
  `fromDate` int(14) DEFAULT NULL,
  `toDate` int(14) DEFAULT NULL,
  `useDates` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mon` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tue` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wed` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `thu` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fri` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sat` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sun` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hourFrom` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hourTo` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `maxImpressions` int(8) DEFAULT NULL,
  `impressions` int(8) DEFAULT NULL,
  `maxUserImpressions` int(8) DEFAULT '-1',
  `maxClicks` int(8) DEFAULT NULL,
  `clicks` int(8) DEFAULT NULL,
  `zone` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `onlyInURIs` text COLLATE utf8_unicode_ci,
  `exceptInURIs` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`bannerId`),
  KEY `ban1` (`zone`,`useDates`,`impressions`,`maxImpressions`,`hourFrom`,`hourTo`,`fromDate`,`toDate`,`mon`,`tue`,`wed`,`thu`,`fri`,`sat`,`sun`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banning`
--

CREATE TABLE `tiki_banning` (
  `banId` int(12) NOT NULL AUTO_INCREMENT,
  `mode` enum('user','ip') COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip1` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip2` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip3` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip4` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `date_from` timestamp NULL DEFAULT NULL,
  `date_to` timestamp NULL DEFAULT NULL,
  `use_dates` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `message` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`banId`),
  KEY `ban` (`use_dates`,`date_from`,`date_to`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banning_sections`
--

CREATE TABLE `tiki_banning_sections` (
  `banId` int(12) NOT NULL DEFAULT '0',
  `section` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`banId`,`section`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blogs`
--

CREATE TABLE `tiki_blogs` (
  `blogId` int(8) NOT NULL AUTO_INCREMENT,
  `created` int(14) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `public` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `posts` int(8) DEFAULT NULL,
  `maxPosts` int(8) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `activity` decimal(4,2) DEFAULT NULL,
  `heading` text COLLATE utf8_unicode_ci,
  `post_heading` text COLLATE utf8_unicode_ci,
  `use_find` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `use_title` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `use_title_in_post` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `use_description` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `use_breadcrumbs` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `use_author` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `use_excerpt` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_date` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_poster` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `allow_comments` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_avatar` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `always_owner` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_related` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `related_max` int(4) DEFAULT '5',
  PRIMARY KEY (`blogId`),
  KEY `title` (`title`),
  KEY `description` (`description`(255)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_activity`
--

CREATE TABLE `tiki_blog_activity` (
  `blogId` int(8) NOT NULL DEFAULT '0',
  `day` int(14) NOT NULL DEFAULT '0',
  `posts` int(8) DEFAULT NULL,
  PRIMARY KEY (`blogId`,`day`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_posts`
--

CREATE TABLE `tiki_blog_posts` (
  `postId` int(8) NOT NULL AUTO_INCREMENT,
  `blogId` int(8) NOT NULL DEFAULT '0',
  `data` text COLLATE utf8_unicode_ci,
  `data_size` int(11) unsigned NOT NULL DEFAULT '0',
  `excerpt` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `hits` bigint(20) DEFAULT '0',
  `trackbacks_to` text COLLATE utf8_unicode_ci,
  `trackbacks_from` text COLLATE utf8_unicode_ci,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `priv` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `wysiwyg` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`postId`),
  KEY `data` (`data`(255)),
  KEY `blogId` (`blogId`),
  KEY `created` (`created`),
  FULLTEXT KEY `ft` (`data`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_posts_images`
--

CREATE TABLE `tiki_blog_posts_images` (
  `imgId` int(14) NOT NULL AUTO_INCREMENT,
  `postId` int(14) NOT NULL DEFAULT '0',
  `filename` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filetype` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `data` longblob,
  PRIMARY KEY (`imgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendars`
--

CREATE TABLE `tiki_calendars` (
  `calendarId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customlocations` enum('n','y') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `customcategories` enum('n','y') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `customlanguages` enum('n','y') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `custompriorities` enum('n','y') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `customparticipants` enum('n','y') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `customsubscription` enum('n','y') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `customstatus` enum('n','y') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  `personal` enum('n','y') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_categories`
--

CREATE TABLE `tiki_calendar_categories` (
  `calcatId` int(11) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`calcatId`),
  UNIQUE KEY `catname` (`calendarId`,`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_items`
--

CREATE TABLE `tiki_calendar_items` (
  `calitemId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `start` int(14) NOT NULL DEFAULT '0',
  `end` int(14) NOT NULL DEFAULT '0',
  `locationId` int(14) DEFAULT NULL,
  `categoryId` int(14) DEFAULT NULL,
  `nlId` int(12) NOT NULL DEFAULT '0',
  `priority` enum('0','1','2','3','4','5','6','7','8','9') COLLATE utf8_unicode_ci DEFAULT '0',
  `status` enum('0','1','2') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `recurrenceId` int(14) DEFAULT NULL,
  `changed` tinyint(1) DEFAULT '0',
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`calitemId`),
  KEY `calendarId` (`calendarId`),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_locations`
--

CREATE TABLE `tiki_calendar_locations` (
  `callocId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` blob,
  PRIMARY KEY (`callocId`),
  UNIQUE KEY `locname` (`calendarId`,`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_options`
--

CREATE TABLE `tiki_calendar_options` (
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `optionName` varchar(120) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calendarId`,`optionName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_recurrence`
--

CREATE TABLE `tiki_calendar_recurrence` (
  `recurrenceId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `start` int(4) NOT NULL DEFAULT '0',
  `end` int(4) NOT NULL DEFAULT '2359',
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  `locationId` int(14) DEFAULT NULL,
  `categoryId` int(14) DEFAULT NULL,
  `nlId` int(12) NOT NULL DEFAULT '0',
  `priority` enum('1','2','3','4','5','6','7','8','9') COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `status` enum('0','1','2') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` blob,
  `weekly` tinyint(1) DEFAULT '0',
  `weekday` tinyint(1) DEFAULT NULL,
  `monthly` tinyint(1) DEFAULT '0',
  `dayOfMonth` int(2) DEFAULT NULL,
  `yearly` tinyint(1) DEFAULT '0',
  `dateOfYear` int(4) DEFAULT NULL,
  `nbRecurrences` int(8) DEFAULT NULL,
  `startPeriod` int(14) DEFAULT NULL,
  `endPeriod` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  PRIMARY KEY (`recurrenceId`),
  KEY `calendarId` (`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_roles`
--

CREATE TABLE `tiki_calendar_roles` (
  `calitemId` int(14) NOT NULL DEFAULT '0',
  `username` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role` enum('0','1','2','3','6') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`calitemId`,`username`(16),`role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_cart_inventory_hold`
--

CREATE TABLE `tiki_cart_inventory_hold` (
  `productId` int(14) NOT NULL,
  `quantity` int(14) NOT NULL,
  `timeHeld` int(14) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories`
--

CREATE TABLE `tiki_categories` (
  `categId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parentId` int(12) DEFAULT NULL,
  `rootId` int(11) NOT NULL DEFAULT '0',
  `hits` int(8) DEFAULT NULL,
  PRIMARY KEY (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categorized_objects`
--

CREATE TABLE `tiki_categorized_objects` (
  `catObjectId` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_category_objects`
--

CREATE TABLE `tiki_category_objects` (
  `catObjectId` int(12) NOT NULL DEFAULT '0',
  `categId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`,`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_category_sites`
--

CREATE TABLE `tiki_category_sites` (
  `categId` int(10) NOT NULL DEFAULT '0',
  `siteId` int(14) NOT NULL DEFAULT '0',
  PRIMARY KEY (`categId`,`siteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_channels`
--

CREATE TABLE `tiki_chat_channels` (
  `channelId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `max_users` int(8) DEFAULT NULL,
  `mode` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `moderator` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refresh` int(6) DEFAULT NULL,
  PRIMARY KEY (`channelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_messages`
--

CREATE TABLE `tiki_chat_messages` (
  `messageId` int(8) NOT NULL AUTO_INCREMENT,
  `channelId` int(8) NOT NULL DEFAULT '0',
  `data` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `poster` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'anonymous',
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_users`
--

CREATE TABLE `tiki_chat_users` (
  `nickname` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `channelId` int(8) NOT NULL DEFAULT '0',
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`nickname`,`channelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_comments`
--

CREATE TABLE `tiki_comments` (
  `threadId` int(14) NOT NULL AUTO_INCREMENT,
  `object` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parentId` int(14) DEFAULT NULL,
  `userName` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `commentDate` int(14) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `average` decimal(8,4) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `website` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_ip` varchar(39) COLLATE utf8_unicode_ci DEFAULT NULL,
  `summary` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smiley` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message_id` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `in_reply_to` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comment_rating` tinyint(2) DEFAULT NULL,
  `archived` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `approved` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `locked` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`threadId`),
  UNIQUE KEY `no_repeats` (`parentId`,`userName`(40),`title`(100),`commentDate`,`message_id`(40),`in_reply_to`(40)),
  KEY `title` (`title`),
  KEY `data` (`data`(255)),
  KEY `hits` (`hits`),
  KEY `tc_pi` (`parentId`),
  KEY `objectType` (`object`,`objectType`),
  KEY `commentDate` (`commentDate`),
  KEY `threaded` (`message_id`,`in_reply_to`,`parentId`),
  FULLTEXT KEY `ft` (`title`,`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_connect`
--

CREATE TABLE `tiki_connect` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8_unicode_ci,
  `guid` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `server` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `server` (`server`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content`
--

CREATE TABLE `tiki_content` (
  `contentId` int(8) NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `contentLabel` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`contentId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content_templates`
--

CREATE TABLE `tiki_content_templates` (
  `templateId` int(10) NOT NULL AUTO_INCREMENT,
  `template_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'static',
  `content` longblob,
  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`templateId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content_templates_sections`
--

CREATE TABLE `tiki_content_templates_sections` (
  `templateId` int(10) NOT NULL DEFAULT '0',
  `section` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`templateId`,`section`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_contributions`
--

CREATE TABLE `tiki_contributions` (
  `contributionId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`contributionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_contributions_assigned`
--

CREATE TABLE `tiki_contributions_assigned` (
  `contributionId` int(12) NOT NULL,
  `objectId` int(12) NOT NULL,
  PRIMARY KEY (`objectId`,`contributionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_cookies`
--

CREATE TABLE `tiki_cookies` (
  `cookieId` int(10) NOT NULL AUTO_INCREMENT,
  `cookie` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`cookieId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_copyrights`
--

CREATE TABLE `tiki_copyrights` (
  `copyrightId` int(12) NOT NULL AUTO_INCREMENT,
  `page` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `authors` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `holder` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `copyright_order` int(11) DEFAULT NULL,
  `userName` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`copyrightId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits`
--

CREATE TABLE `tiki_credits` (
  `creditId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userId` int(8) NOT NULL,
  `credit_type` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expiration_date` timestamp NULL DEFAULT NULL,
  `total_amount` float NOT NULL DEFAULT '0',
  `used_amount` float NOT NULL DEFAULT '0',
  `product_id` int(8) DEFAULT NULL,
  PRIMARY KEY (`creditId`),
  KEY `userId` (`userId`,`credit_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits_types`
--

CREATE TABLE `tiki_credits_types` (
  `credit_type` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `display_text` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unit_text` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_static_level` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `scaling_divisor` float NOT NULL DEFAULT '1',
  PRIMARY KEY (`credit_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits_usage`
--

CREATE TABLE `tiki_credits_usage` (
  `usageId` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `usage_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `credit_type` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `used_amount` float NOT NULL DEFAULT '0',
  `product_id` int(8) DEFAULT NULL,
  PRIMARY KEY (`usageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_db_status`
--

CREATE TABLE `tiki_db_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `objectId` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `tableName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `other` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `tiki_db_status`
--

INSERT INTO `tiki_db_status` VALUES
(1, '1', 'tiki_pages', 'new9.0+', NULL),
(2, '1', 'tiki_history', 'new9.0+', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_categories`
--

CREATE TABLE `tiki_directory_categories` (
  `categId` int(10) NOT NULL AUTO_INCREMENT,
  `parent` int(10) DEFAULT NULL,
  `name` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `childrenType` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sites` int(10) DEFAULT NULL,
  `viewableChildren` int(4) DEFAULT NULL,
  `allowSites` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `showCount` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `editorGroup` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hits` int(12) DEFAULT NULL,
  PRIMARY KEY (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_search`
--

CREATE TABLE `tiki_directory_search` (
  `term` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  PRIMARY KEY (`term`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_sites`
--

CREATE TABLE `tiki_directory_sites` (
  `siteId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hits` int(12) DEFAULT NULL,
  `isValid` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `cache` longblob,
  `cache_timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`siteId`),
  KEY `isValid` (`isValid`),
  KEY `url` (`url`),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_discount`
--

CREATE TABLE `tiki_discount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `max` int(11) DEFAULT NULL,
  `comment` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_download`
--

CREATE TABLE `tiki_download` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `userId` int(8) NOT NULL DEFAULT '0',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date` int(14) NOT NULL DEFAULT '0',
  `IP` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `object` (`object`,`userId`,`type`),
  KEY `userId` (`userId`),
  KEY `type` (`type`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_dsn`
--

CREATE TABLE `tiki_dsn` (
  `dsnId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dsn` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`dsnId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_dynamic_variables`
--

CREATE TABLE `tiki_dynamic_variables` (
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `lang` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_extwiki`
--

CREATE TABLE `tiki_extwiki` (
  `extwikiId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `extwiki` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `indexname` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `groups` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`extwikiId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_faqs`
--

CREATE TABLE `tiki_faqs` (
  `faqId` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `questions` int(5) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `canSuggest` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`faqId`),
  KEY `title` (`title`),
  KEY `description` (`description`(255)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_faq_questions`
--

CREATE TABLE `tiki_faq_questions` (
  `questionId` int(10) NOT NULL AUTO_INCREMENT,
  `faqId` int(10) DEFAULT NULL,
  `position` int(4) DEFAULT NULL,
  `question` text COLLATE utf8_unicode_ci,
  `answer` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`questionId`),
  KEY `faqId` (`faqId`),
  KEY `question` (`question`(255)),
  KEY `answer` (`answer`(255)),
  KEY `created` (`created`),
  FULLTEXT KEY `ft` (`question`,`answer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_feature`
--

CREATE TABLE `tiki_feature` (
  `feature_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `feature_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `parent_id` mediumint(9) NOT NULL,
  `status` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'active',
  `setting_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `feature_type` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'feature',
  `template` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permission` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ordinal` mediumint(9) NOT NULL DEFAULT '1',
  `depends_on` mediumint(9) DEFAULT NULL,
  `keyword` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tip` text COLLATE utf8_unicode_ci,
  `feature_count` mediumint(9) NOT NULL DEFAULT '0',
  `feature_path` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`feature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_featured_links`
--

CREATE TABLE `tiki_featured_links` (
  `url` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `hits` int(8) DEFAULT NULL,
  `position` int(6) DEFAULT NULL,
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_files`
--

CREATE TABLE `tiki_files` (
  `fileId` int(14) NOT NULL AUTO_INCREMENT,
  `galleryId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `filename` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longblob,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `author` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hits` int(14) DEFAULT NULL,
  `maxhits` int(14) DEFAULT NULL,
  `lastDownload` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_url` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_reference` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `search_data` longtext COLLATE utf8_unicode_ci,
  `metadata` longtext COLLATE utf8_unicode_ci,
  `lastModif` int(14) DEFAULT NULL,
  `lastModifUser` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `comment` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `archiveId` int(14) DEFAULT '0',
  `deleteAfter` int(14) DEFAULT NULL,
  PRIMARY KEY (`fileId`),
  KEY `name` (`name`),
  KEY `description` (`description`(255)),
  KEY `created` (`created`),
  KEY `archiveId` (`archiveId`),
  KEY `galleryId` (`galleryId`),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`name`,`description`,`search_data`,`filename`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_backlinks`
--

CREATE TABLE `tiki_file_backlinks` (
  `fileId` int(14) NOT NULL,
  `objectId` int(12) NOT NULL,
  KEY `objectId` (`objectId`),
  KEY `fileId` (`fileId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_drafts`
--

CREATE TABLE `tiki_file_drafts` (
  `fileId` int(14) NOT NULL,
  `filename` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longblob,
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  `lastModif` int(14) DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`fileId`,`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_galleries`
--

CREATE TABLE `tiki_file_galleries` (
  `galleryId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `template` int(10) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `visible` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `maxRows` int(10) DEFAULT NULL,
  `public` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_id` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_icon` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_name` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_size` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_description` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `max_desc` int(8) DEFAULT NULL,
  `show_created` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_hits` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_lastDownload` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parentId` int(14) NOT NULL DEFAULT '-1',
  `lockable` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `show_lockedby` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `archives` int(4) DEFAULT '0',
  `sort_mode` char(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_modified` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_author` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_creator` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subgal_conf` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_last_user` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_comment` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_files` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_explorer` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_path` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_slideshow` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `default_view` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quota` int(8) DEFAULT '0',
  `size` int(14) DEFAULT NULL,
  `wiki_syntax` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `backlinkPerms` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `show_backlinks` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_deleteAfter` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_checked` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_share` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_max_size_x` int(8) NOT NULL DEFAULT '0',
  `image_max_size_y` int(8) NOT NULL DEFAULT '0',
  `show_source` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'o',
  `icon_fileId` int(14) unsigned DEFAULT NULL,
  PRIMARY KEY (`galleryId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_file_galleries`
--

INSERT INTO `tiki_file_galleries` VALUES
(1, 'File Galleries', 'system', NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL),
(2, 'Users File Galleries', 'system', NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL),
(3, 'Wiki Attachments', 'system', NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_handlers`
--

CREATE TABLE `tiki_file_handlers` (
  `mime_type` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cmd` varchar(238) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums`
--

CREATE TABLE `tiki_forums` (
  `forumId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `lastPost` int(14) DEFAULT NULL,
  `threads` int(8) DEFAULT NULL,
  `comments` int(8) DEFAULT NULL,
  `controlFlood` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `floodInterval` int(8) DEFAULT NULL,
  `moderator` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `mail` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `useMail` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `section` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usePruneUnreplied` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pruneUnrepliedAge` int(8) DEFAULT NULL,
  `usePruneOld` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pruneMaxAge` int(8) DEFAULT NULL,
  `topicsPerPage` int(6) DEFAULT NULL,
  `topicOrdering` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `threadOrdering` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `att` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `att_store` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `att_store_dir` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `att_max_size` int(12) DEFAULT NULL,
  `att_list_nb` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ui_level` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `forum_password` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `forum_use_password` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `moderator_group` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `approval_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outbound_address` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outbound_mails_for_inbound_mails` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outbound_mails_reply_link` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outbound_from` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inbound_pop_server` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inbound_pop_port` int(4) DEFAULT NULL,
  `inbound_pop_user` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inbound_pop_password` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topic_smileys` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ui_avatar` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ui_rating_choice_topic` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ui_flag` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ui_posts` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ui_email` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ui_online` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topic_summary` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_description` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_list_replies` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_list_reads` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_list_pts` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_list_lastpost` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_list_lastpost_title` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_list_lastpost_avatar` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_list_author` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_list_author_avatar` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vote_threads` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `forum_last_n` int(2) DEFAULT '0',
  `threadStyle` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commentsPerPage` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_flat` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mandatory_contribution` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `forumLanguage` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`forumId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums_queue`
--

CREATE TABLE `tiki_forums_queue` (
  `qId` int(14) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parentId` int(14) DEFAULT NULL,
  `forumId` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `title` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `type` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topic_smiley` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topic_title` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `summary` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `in_reply_to` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tags` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`qId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums_reported`
--

CREATE TABLE `tiki_forums_reported` (
  `threadId` int(12) NOT NULL DEFAULT '0',
  `forumId` int(12) NOT NULL DEFAULT '0',
  `parentId` int(12) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `timestamp` int(14) DEFAULT NULL,
  `reason` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forum_attachments`
--

CREATE TABLE `tiki_forum_attachments` (
  `attId` int(14) NOT NULL AUTO_INCREMENT,
  `threadId` int(14) NOT NULL DEFAULT '0',
  `qId` int(14) NOT NULL DEFAULT '0',
  `forumId` int(14) DEFAULT NULL,
  `filename` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filesize` int(12) DEFAULT NULL,
  `data` longblob,
  `dir` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `path` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attId`),
  KEY `threadId` (`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forum_reads`
--

CREATE TABLE `tiki_forum_reads` (
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `threadId` int(14) NOT NULL DEFAULT '0',
  `forumId` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`user`,`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_freetagged_objects`
--

CREATE TABLE `tiki_freetagged_objects` (
  `tagId` int(12) NOT NULL AUTO_INCREMENT,
  `objectId` int(11) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tagId`,`user`,`objectId`),
  KEY `tagId` (`tagId`),
  KEY `user` (`user`),
  KEY `objectId` (`objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_freetags`
--

CREATE TABLE `tiki_freetags` (
  `tagId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `raw_tag` varchar(150) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lang` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`tagId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_galleries`
--

CREATE TABLE `tiki_galleries` (
  `galleryId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `visible` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geographic` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `theme` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  `maxRows` int(10) DEFAULT NULL,
  `rowImages` int(10) DEFAULT NULL,
  `thumbSizeX` int(10) DEFAULT NULL,
  `thumbSizeY` int(10) DEFAULT NULL,
  `public` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sortorder` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'created',
  `sortdirection` varchar(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'desc',
  `galleryimage` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'first',
  `parentgallery` int(14) NOT NULL DEFAULT '-1',
  `showname` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `showimageid` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `showdescription` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `showcreated` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `showuser` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `showhits` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `showxysize` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `showfilesize` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `showfilename` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `defaultscale` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'o',
  `showcategories` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`galleryId`),
  KEY `name` (`name`),
  KEY `description` (`description`(255)),
  KEY `hits` (`hits`),
  KEY `parentgallery` (`parentgallery`),
  KEY `visibleUser` (`visible`,`user`),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_galleries_scales`
--

CREATE TABLE `tiki_galleries_scales` (
  `galleryId` int(14) NOT NULL DEFAULT '0',
  `scale` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`galleryId`,`scale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_goals`
--

CREATE TABLE `tiki_goals` (
  `goalId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user',
  `description` text COLLATE utf8_unicode_ci,
  `enabled` int(11) NOT NULL DEFAULT '0',
  `daySpan` int(11) NOT NULL DEFAULT '14',
  `from` datetime DEFAULT NULL,
  `to` datetime DEFAULT NULL,
  `eligible` blob,
  `conditions` blob,
  `rewards` blob,
  PRIMARY KEY (`goalId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_goal_events`
--

CREATE TABLE `tiki_goal_events` (
  `eventId` int(11) NOT NULL AUTO_INCREMENT,
  `eventDate` int(11) NOT NULL,
  `eventType` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `targetType` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `targetObject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `groups` blob NOT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_groupalert`
--

CREATE TABLE `tiki_groupalert` (
  `groupName` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `objectId` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `displayEachuser` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`groupName`,`objectType`,`objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_group_inclusion`
--

CREATE TABLE `tiki_group_inclusion` (
  `groupName` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `includeGroup` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`groupName`(120),`includeGroup`(120))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tiki_group_inclusion`
--

INSERT INTO `tiki_group_inclusion` VALUES
('Registered', 'Anonymous');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_group_watches`
--

CREATE TABLE `tiki_group_watches` (
  `watchId` int(12) NOT NULL AUTO_INCREMENT,
  `group` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `event` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `object` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`watchId`),
  KEY `event-object-group` (`event`,`object`(100),`group`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_history`
--

CREATE TABLE `tiki_history` (
  `historyId` int(12) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `version` int(8) NOT NULL DEFAULT '0',
  `version_minor` int(8) NOT NULL DEFAULT '0',
  `lastModif` int(14) DEFAULT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(39) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comment` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longblob,
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_html` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pageName`,`version`),
  KEY `user` (`user`),
  KEY `historyId` (`historyId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_history`
--


-- --------------------------------------------------------

--
-- Table structure for table `tiki_hotwords`
--

CREATE TABLE `tiki_hotwords` (
  `word` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`word`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_html_pages`
--

CREATE TABLE `tiki_html_pages` (
  `pageName` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` longblob,
  `refresh` int(10) DEFAULT NULL,
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`pageName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_html_pages_dynamic_zones`
--

CREATE TABLE `tiki_html_pages_dynamic_zones` (
  `pageName` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `zone` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`pageName`,`zone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_images`
--

CREATE TABLE `tiki_images` (
  `imageId` int(14) NOT NULL AUTO_INCREMENT,
  `galleryId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `lon` float DEFAULT NULL,
  `lat` float DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`imageId`),
  KEY `name` (`name`),
  KEY `description` (`description`(255)),
  KEY `hits` (`hits`),
  KEY `ti_gId` (`galleryId`),
  KEY `ti_cr` (`created`),
  KEY `ti_us` (`user`),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_images_data`
--

CREATE TABLE `tiki_images_data` (
  `imageId` int(14) NOT NULL DEFAULT '0',
  `xsize` int(8) NOT NULL DEFAULT '0',
  `ysize` int(8) NOT NULL DEFAULT '0',
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(14) DEFAULT NULL,
  `filetype` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filename` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longblob,
  `etag` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`imageId`,`xsize`,`ysize`,`type`),
  KEY `t_i_d_it` (`imageId`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_integrator_reps`
--

CREATE TABLE `tiki_integrator_reps` (
  `repID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `start_page` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `css_file` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `visibility` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `cacheable` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `expiration` int(11) NOT NULL DEFAULT '0',
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`repID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tiki_integrator_reps`
--

INSERT INTO `tiki_integrator_reps` VALUES
(1, 'Doxygened (1.3.4) Documentation', '', 'index.html', 'doxygen.css', 'n', 'y', 0, 'Use this repository as rule source for all your repositories based on doxygened docs. To setup yours just add new repository and copy rules from this repository :)');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_integrator_rules`
--

CREATE TABLE `tiki_integrator_rules` (
  `ruleID` int(11) NOT NULL AUTO_INCREMENT,
  `repID` int(11) NOT NULL DEFAULT '0',
  `ord` int(2) unsigned NOT NULL DEFAULT '0',
  `srch` blob NOT NULL,
  `repl` blob NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `casesense` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `rxmod` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `enabled` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ruleID`),
  KEY `repID` (`repID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_integrator_rules`
--

INSERT INTO `tiki_integrator_rules` VALUES
(1, 1, 1, '.*<body[^>]*?>(.*?)</body.*', '1', 'y', 'n', 'i', 'y', 'Extract code between <body> and </body> tags'),
(2, 1, 2, 'img src=("|'')(?!http://)', 'img src=1{path}/', 'y', 'n', 'i', 'y', 'Fix image paths'),
(3, 1, 3, 'href=("|'')(?!(#|(http|ftp)://))', 'href=1tiki-integrator.php?repID={repID}&file=', 'y', 'n', 'i', 'y', 'Replace internal links to integrator. Don not touch an external link.');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_invite`
--

CREATE TABLE `tiki_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inviter` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `groups` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ts` int(11) NOT NULL,
  `emailsubject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `emailcontent` text COLLATE utf8_unicode_ci NOT NULL,
  `wikicontent` text COLLATE utf8_unicode_ci,
  `wikipageafter` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_invited`
--

CREATE TABLE `tiki_invited` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_invite` int(11) NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `firstname` varchar(24) COLLATE utf8_unicode_ci NOT NULL,
  `lastname` varchar(24) COLLATE utf8_unicode_ci NOT NULL,
  `used` enum('no','registered','logged') COLLATE utf8_unicode_ci NOT NULL,
  `used_on_user` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_invite` (`id_invite`),
  KEY `used_on_user` (`used_on_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_language`
--

CREATE TABLE `tiki_language` (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `source` text COLLATE utf8_unicode_ci NOT NULL,
  `lang` char(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran` text COLLATE utf8_unicode_ci,
  `changed` tinyint(1) DEFAULT NULL,
  `userId` int(8) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_links`
--

CREATE TABLE `tiki_links` (
  `fromPage` varchar(160) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `toPage` varchar(160) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`fromPage`,`toPage`),
  KEY `toPage` (`toPage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_link_cache`
--

CREATE TABLE `tiki_link_cache` (
  `cacheId` int(14) NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longblob,
  `refresh` int(14) DEFAULT NULL,
  PRIMARY KEY (`cacheId`),
  KEY `url` (`url`),
  KEY `urlindex` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_events`
--

CREATE TABLE `tiki_live_support_events` (
  `eventId` int(14) NOT NULL AUTO_INCREMENT,
  `reqId` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `seqId` int(14) DEFAULT NULL,
  `senderId` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_messages`
--

CREATE TABLE `tiki_live_support_messages` (
  `msgId` int(12) NOT NULL AUTO_INCREMENT,
  `data` text COLLATE utf8_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  `status` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `assigned_to` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `resolution` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module` int(4) DEFAULT NULL,
  `email` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_message_comments`
--

CREATE TABLE `tiki_live_support_message_comments` (
  `cId` int(12) NOT NULL AUTO_INCREMENT,
  `msgId` int(12) DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`cId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_modules`
--

CREATE TABLE `tiki_live_support_modules` (
  `modId` int(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`modId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `tiki_live_support_modules`
--

INSERT INTO `tiki_live_support_modules` VALUES
(1, 'wiki'),
(2, 'forums'),
(3, 'image galleries'),
(4, 'file galleries'),
(5, 'directory');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_operators`
--

CREATE TABLE `tiki_live_support_operators` (
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `accepted_requests` int(10) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `longest_chat` int(10) DEFAULT NULL,
  `shortest_chat` int(10) DEFAULT NULL,
  `average_chat` int(10) DEFAULT NULL,
  `last_chat` int(14) DEFAULT NULL,
  `time_online` int(10) DEFAULT NULL,
  `votes` int(10) DEFAULT NULL,
  `points` int(10) DEFAULT NULL,
  `status_since` int(14) DEFAULT NULL,
  PRIMARY KEY (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_requests`
--

CREATE TABLE `tiki_live_support_requests` (
  `reqId` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tiki_user` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `operator` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `operator_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reason` text COLLATE utf8_unicode_ci,
  `req_timestamp` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  `status` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `resolution` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `chat_started` int(14) DEFAULT NULL,
  `chat_ended` int(14) DEFAULT NULL,
  PRIMARY KEY (`reqId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_logs`
--

CREATE TABLE `tiki_logs` (
  `logId` int(8) NOT NULL AUTO_INCREMENT,
  `logtype` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `logmessage` text COLLATE utf8_unicode_ci NOT NULL,
  `loguser` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `logip` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `logclient` text COLLATE utf8_unicode_ci NOT NULL,
  `logtime` int(14) NOT NULL,
  PRIMARY KEY (`logId`),
  KEY `logtype` (`logtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mailin_accounts`
--

CREATE TABLE `tiki_mailin_accounts` (
  `accountId` int(12) NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `protocol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'pop',
  `host` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `port` int(4) DEFAULT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `anonymous` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `admin` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `attachments` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `routing` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `article_topicId` int(4) DEFAULT NULL,
  `article_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discard_after` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `show_inlineImages` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `save_html` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `categoryId` int(12) DEFAULT NULL,
  `namespace` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `respond_email` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  `leave_email` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`accountId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mail_events`
--

CREATE TABLE `tiki_mail_events` (
  `event` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `object` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mail_queue`
--

CREATE TABLE `tiki_mail_queue` (
  `messageId` int(11) NOT NULL AUTO_INCREMENT,
  `message` text COLLATE utf8_unicode_ci,
  `attempts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menus`
--

CREATE TABLE `tiki_menus` (
  `menuId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `use_items_icons` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `parse` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`menuId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=43 ;

--
-- Dumping data for table `tiki_menus`
--

INSERT INTO `tiki_menus` VALUES
(42, 'Application menu', 'Main extensive navigation menu', 'd', NULL, 'y', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menu_languages`
--

CREATE TABLE `tiki_menu_languages` (
  `menuId` int(8) NOT NULL AUTO_INCREMENT,
  `language` char(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`menuId`,`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menu_options`
--

CREATE TABLE `tiki_menu_options` (
  `optionId` int(8) NOT NULL AUTO_INCREMENT,
  `menuId` int(8) DEFAULT NULL,
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` int(4) DEFAULT NULL,
  `section` text COLLATE utf8_unicode_ci,
  `perm` text COLLATE utf8_unicode_ci,
  `groupname` text COLLATE utf8_unicode_ci,
  `userlevel` int(4) DEFAULT '0',
  `icon` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `class` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`optionId`),
  UNIQUE KEY `uniq_menu` (`menuId`,`name`(30),`url`(50),`position`,`section`(60),`perm`(50),`groupname`(50))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=196 ;

--
-- Dumping data for table `tiki_menu_options`
--

INSERT INTO `tiki_menu_options` VALUES
(1, 42, 'o', 'Home', './', 10, '', '', '', 0, 'home48x48', NULL),
(2, 42, 'o', 'Search', 'tiki-searchresults.php', 13, 'feature_search_fulltext', 'tiki_p_search', '', 0, 'xfce4-appfinder48x48', NULL),
(3, 42, 'o', 'Search', 'tiki-searchindex.php', 13, 'feature_search', 'tiki_p_search', '', 0, 'xfce4-appfinder48x48', NULL),
(4, 42, 'o', 'Contact Us', 'tiki-contact.php', 20, 'feature_contact,feature_messages', '', '', 0, 'contactus48x48', NULL),
(5, 42, 'o', 'Stats', 'tiki-stats.php', 23, 'feature_stats', 'tiki_p_view_stats', '', 0, 'stats48x48', NULL),
(6, 42, 'o', 'Categories', 'tiki-browse_categories.php', 25, 'feature_categories', 'tiki_p_view_category', '', 0, 'categories48x48', NULL),
(7, 42, 'o', 'Tags', 'tiki-browse_freetags.php', 27, 'feature_freetags', 'tiki_p_view_freetags', '', 0, 'vcard48x48', NULL),
(8, 42, 'o', 'Calendar', 'tiki-calendar.php', 35, 'feature_calendar', 'tiki_p_view_calendar', '', 0, 'date48x48', NULL),
(9, 42, 'o', 'Tiki Calendar', 'tiki-action_calendar.php', 37, 'feature_action_calendar', 'tiki_p_view_tiki_calendar', '', 0, 'tikicalendar48x48', NULL),
(10, 42, 'o', 'Payments', 'tiki-payment.php', 39, 'payment_feature', 'tiki_p_payment_view', '', 0, NULL, NULL),
(11, 42, 'o', 'Payments', 'tiki-payment.php', 39, 'payment_feature', 'tiki_p_payment_request', '', 0, NULL, NULL),
(12, 42, 'o', '(debug)', 'javascript:toggle(''debugconsole'')', 40, 'feature_debug_console', 'tiki_p_admin', '', 0, 'debug48x48', NULL),
(13, 42, 'o', 'User Wizard', 'tiki-wizard_user.php', 45, 'feature_wizard_user', '', 'Registered', 0, 'wizard_user48x48', NULL),
(14, 42, 's', 'My Account', 'tiki-my_tiki.php', 50, 'feature_mytiki', '', 'Registered', 0, 'userfiles48x48', NULL),
(15, 42, 'o', 'My Account Home', 'tiki-my_tiki.php', 51, 'feature_mytiki', '', 'Registered', 0, NULL, NULL),
(16, 42, 'o', 'Preferences', 'tiki-user_preferences.php', 55, 'feature_mytiki,feature_userPreferences', '', 'Registered', 0, NULL, NULL),
(17, 42, 'o', 'Messages', 'messu-mailbox.php', 60, 'feature_mytiki,feature_messages', 'tiki_p_messages', 'Registered', 0, NULL, NULL),
(18, 42, 'o', 'Tasks', 'tiki-user_tasks.php', 65, 'feature_mytiki,feature_tasks', 'tiki_p_tasks', 'Registered', 0, NULL, NULL),
(19, 42, 'o', 'Bookmarks', 'tiki-user_bookmarks.php', 70, 'feature_mytiki,feature_user_bookmarks', 'tiki_p_create_bookmarks', 'Registered', 0, NULL, NULL),
(20, 42, 'o', 'Modules', 'tiki-user_assigned_modules.php', 75, 'feature_mytiki,user_assigned_modules', 'tiki_p_configure_modules', 'Registered', 0, NULL, NULL),
(21, 42, 'o', 'Webmail', 'tiki-webmail.php', 85, 'feature_mytiki,feature_webmail', 'tiki_p_use_webmail', 'Registered', 0, NULL, NULL),
(22, 42, 'o', 'Contacts', 'tiki-contacts.php', 87, 'feature_mytiki,feature_contacts', '', 'Registered', 0, NULL, NULL),
(23, 42, 'o', 'Mail-in', 'tiki-user_mailin.php', 88, 'feature_mytiki,feature_mailin', '', 'Registered', 0, NULL, NULL),
(24, 42, 'o', 'Notepad', 'tiki-notepad_list.php', 90, 'feature_mytiki,feature_notepad', 'tiki_p_notepad', 'Registered', 0, NULL, NULL),
(25, 42, 'o', 'My Files', 'tiki-userfiles.php', 95, 'feature_mytiki,feature_userfiles', 'tiki_p_userfiles', 'Registered', 0, NULL, NULL),
(26, 42, 'o', 'User Menu', 'tiki-usermenu.php', 100, 'feature_mytiki,feature_usermenu', 'tiki_p_usermenu', 'Registered', 0, NULL, NULL),
(27, 42, 'o', 'Mini Calendar', 'tiki-minical.php', 105, 'feature_mytiki,feature_minical', 'tiki_p_minical', 'Registered', 0, NULL, NULL),
(28, 42, 'o', 'My Watches', 'tiki-user_watches.php', 110, 'feature_mytiki,feature_user_watches', '', 'Registered', 0, NULL, NULL),
(29, 42, 's', 'Community', 'tiki-list_users.php', 187, 'feature_friends', 'tiki_p_list_users', '', 0, 'users48x48', NULL),
(30, 42, 'o', 'User List', 'tiki-list_users.php', 188, 'feature_friends', 'tiki_p_list_users', '', 0, NULL, NULL),
(31, 42, 'o', 'Friendship Network', 'tiki-friends.php', 189, 'feature_friends', '', 'Registered', 0, NULL, NULL),
(32, 42, 's', 'Wiki', 'tiki-index.php', 200, 'feature_wiki', 'tiki_p_view', '', 0, 'wikipages48x48', NULL),
(33, 42, 'o', 'Wiki Home', 'tiki-index.php', 202, 'feature_wiki', 'tiki_p_view', '', 0, NULL, NULL),
(34, 42, 'o', 'Last Changes', 'tiki-lastchanges.php', 205, 'feature_wiki,feature_lastChanges', 'tiki_p_view', '', 0, NULL, NULL),
(35, 42, 'o', 'Dump', 'dump/new.tar', 210, 'feature_wiki,feature_dump', 'tiki_p_view', '', 0, NULL, NULL),
(36, 42, 'o', 'Rankings', 'tiki-wiki_rankings.php', 215, 'feature_wiki,feature_wiki_rankings', 'tiki_p_view', '', 0, NULL, NULL),
(37, 42, 'o', 'List Pages', 'tiki-listpages.php?cookietab=1#tab1', 220, 'feature_wiki,feature_listPages', 'tiki_p_view', '', 0, NULL, NULL),
(38, 42, 'o', 'Create a Wiki Page', 'tiki-listpages.php?cookietab=2#tab2', 222, 'feature_wiki,feature_listPages', 'tiki_p_view,tiki_p_edit', '', 0, NULL, NULL),
(39, 42, 'o', 'Orphan Pages', 'tiki-orphan_pages.php', 225, 'feature_wiki,feature_listorphanPages', 'tiki_p_view', '', 0, NULL, NULL),
(40, 42, 'o', 'Sandbox', 'tiki-editpage.php?page=sandbox', 230, 'feature_wiki,feature_sandbox', 'tiki_p_view', '', 0, NULL, NULL),
(41, 42, 'o', 'Multiple Print', 'tiki-print_pages.php', 235, 'feature_wiki,feature_wiki_multiprint', 'tiki_p_view', '', 0, NULL, NULL),
(42, 42, 'o', 'Send Pages', 'tiki-send_objects.php', 240, 'feature_wiki,feature_comm', 'tiki_p_view,tiki_p_send_pages', '', 0, NULL, NULL),
(43, 42, 'o', 'Received Pages', 'tiki-received_pages.php', 245, 'feature_wiki,feature_comm', 'tiki_p_view,tiki_p_admin_received_pages', '', 0, NULL, NULL),
(44, 42, 'o', 'Structures', 'tiki-admin_structures.php', 250, 'feature_wiki,feature_wiki_structure', 'tiki_p_view', '', 0, NULL, NULL),
(45, 42, 'o', 'Mind Map', 'tiki-mindmap.php', 255, 'feature_wiki_mindmap', 'tiki_p_view', '', 0, NULL, NULL),
(46, 42, 's', 'Image Galleries', 'tiki-galleries.php', 300, 'feature_galleries', 'tiki_p_view_image_gallery', '', 0, 'stock_select-color48x48', NULL),
(47, 42, 'o', 'Galleries', 'tiki-galleries.php', 305, 'feature_galleries', 'tiki_p_list_image_galleries', '', 0, NULL, NULL),
(48, 42, 'o', 'Rankings', 'tiki-galleries_rankings.php', 310, 'feature_galleries,feature_gal_rankings', 'tiki_p_list_image_galleries', '', 0, NULL, NULL),
(49, 42, 'o', 'Upload Image', 'tiki-upload_image.php', 315, 'feature_galleries', 'tiki_p_upload_images', '', 0, NULL, NULL),
(50, 42, 'o', 'Directory Batch', 'tiki-batch_upload.php', 318, 'feature_galleries,feature_gal_batch', 'tiki_p_batch_upload', '', 0, NULL, NULL),
(51, 42, 'o', 'System Gallery', 'tiki-list_gallery.php?galleryId=0', 320, 'feature_galleries', 'tiki_p_admin_galleries', '', 0, NULL, NULL),
(52, 42, 's', 'Articles', 'tiki-view_articles.php', 350, 'feature_articles', 'tiki_p_read_article', '', 0, 'stock_bold48x48', NULL),
(53, 42, 's', 'Articles', 'tiki-view_articles.php', 350, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, 'stock_bold48x48', NULL),
(54, 42, 'o', 'Articles Home', 'tiki-view_articles.php', 355, 'feature_articles', 'tiki_p_read_article', '', 0, NULL, NULL),
(55, 42, 'o', 'Articles Home', 'tiki-view_articles.php', 355, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, NULL, NULL),
(56, 42, 'o', 'List Articles', 'tiki-list_articles.php', 360, 'feature_articles', 'tiki_p_read_article', '', 0, NULL, NULL),
(57, 42, 'o', 'List Articles', 'tiki-list_articles.php', 360, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, NULL, NULL),
(58, 42, 'o', 'Rankings', 'tiki-cms_rankings.php', 365, 'feature_articles,feature_cms_rankings', 'tiki_p_read_article', '', 0, NULL, NULL),
(59, 42, 'o', 'Submit Article', 'tiki-edit_submission.php', 370, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_submit_article', '', 0, NULL, NULL),
(60, 42, 'o', 'View submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_submit_article', '', 0, NULL, NULL),
(61, 42, 'o', 'View submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_approve_submission', '', 0, NULL, NULL),
(62, 42, 'o', 'View Submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_remove_submission', '', 0, NULL, NULL),
(63, 42, 'o', 'New Article', 'tiki-edit_article.php', 380, 'feature_articles', 'tiki_p_read_article,tiki_p_edit_article', '', 0, NULL, NULL),
(64, 42, 'o', 'Send Articles', 'tiki-send_objects.php', 385, 'feature_articles,feature_comm', 'tiki_p_read_article,tiki_p_send_articles', '', 0, NULL, NULL),
(65, 42, 'o', 'Received Articles', 'tiki-received_articles.php', 385, 'feature_articles,feature_comm', 'tiki_p_read_article,tiki_p_admin_received_articles', '', 0, NULL, NULL),
(66, 42, 'o', 'Admin Types', 'tiki-article_types.php', 395, 'feature_articles', 'tiki_p_articles_admin_types', '', 0, NULL, NULL),
(67, 42, 'o', 'Admin Topics', 'tiki-admin_topics.php', 390, 'feature_articles', 'tiki_p_articles_admin_topics', '', 0, NULL, NULL),
(68, 42, 's', 'Blogs', 'tiki-list_blogs.php', 450, 'feature_blogs', 'tiki_p_read_blog', '', 0, 'blogs48x48', NULL),
(69, 42, 'o', 'List Blogs', 'tiki-list_blogs.php', 455, 'feature_blogs', 'tiki_p_read_blog', '', 0, NULL, NULL),
(70, 42, 'o', 'Rankings', 'tiki-blog_rankings.php', 460, 'feature_blogs,feature_blog_rankings', 'tiki_p_read_blog', '', 0, NULL, NULL),
(71, 42, 'o', 'Create Blog', 'tiki-edit_blog.php', 465, 'feature_blogs', 'tiki_p_read_blog,tiki_p_create_blogs', '', 0, NULL, NULL),
(72, 42, 'o', 'New Blog Post', 'tiki-blog_post.php', 470, 'feature_blogs', 'tiki_p_read_blog,tiki_p_blog_post', '', 0, NULL, NULL),
(73, 42, 'o', 'List Blog Posts', 'tiki-list_posts.php', 475, 'feature_blogs', 'tiki_p_read_blog,tiki_p_blog_admin', '', 0, NULL, NULL),
(74, 42, 's', 'Forums', 'tiki-forums.php', 500, 'feature_forums', 'tiki_p_forum_read', '', 0, 'stock_index48x48', NULL),
(75, 42, 'o', 'List Forums', 'tiki-forums.php', 505, 'feature_forums', 'tiki_p_forum_read', '', 0, NULL, NULL),
(76, 42, 'o', 'Rankings', 'tiki-forum_rankings.php', 510, 'feature_forums,feature_forum_rankings', 'tiki_p_forum_read', '', 0, NULL, NULL),
(77, 42, 'o', 'Admin Forums', 'tiki-admin_forums.php', 515, 'feature_forums', 'tiki_p_forum_read,tiki_p_admin_forum', '', 0, NULL, NULL),
(78, 42, 's', 'Directory', 'tiki-directory_browse.php', 550, 'feature_directory', 'tiki_p_view_directory', '', 0, 'directory48x48', NULL),
(79, 42, 'o', 'Submit a new link', 'tiki-directory_add_site.php', 555, 'feature_directory', 'tiki_p_submit_link', '', 0, NULL, NULL),
(80, 42, 'o', 'Browse Directory', 'tiki-directory_browse.php', 560, 'feature_directory', 'tiki_p_view_directory', '', 0, NULL, NULL),
(81, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_admin_directory_cats', '', 0, NULL, NULL),
(82, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_admin_directory_sites', '', 0, NULL, NULL),
(83, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_validate_links', '', 0, NULL, NULL),
(84, 42, 's', 'File Galleries', 'tiki-list_file_gallery.php', 600, 'feature_file_galleries', 'tiki_p_list_file_galleries|tiki_p_view_file_gallery|tiki_p_upload_files', '', 0, 'file-manager48x48', NULL),
(85, 42, 'o', 'List Galleries', 'tiki-list_file_gallery.php', 605, 'feature_file_galleries', 'tiki_p_list_file_galleries', '', 0, NULL, NULL),
(86, 42, 'o', 'Rankings', 'tiki-file_galleries_rankings.php', 610, 'feature_file_galleries,feature_file_galleries_rankings', 'tiki_p_list_file_galleries', '', 0, NULL, NULL),
(87, 42, 'o', 'Upload File', 'tiki-upload_file.php', 615, 'feature_file_galleries', 'tiki_p_upload_files', '', 0, NULL, NULL),
(88, 42, 'o', 'Directory batch', 'tiki-batch_upload_files.php', 617, 'feature_file_galleries_batch', 'tiki_p_batch_upload_file_dir', '', 0, NULL, NULL),
(89, 42, 's', 'FAQs', 'tiki-list_faqs.php', 650, 'feature_faqs', 'tiki_p_view_faqs', '', 0, 'stock_dialog_question48x48', NULL),
(90, 42, 'o', 'List FAQs', 'tiki-list_faqs.php', 665, 'feature_faqs', 'tiki_p_view_faqs', '', 0, NULL, NULL),
(91, 42, 'o', 'Admin FAQs', 'tiki-list_faqs.php', 660, 'feature_faqs', 'tiki_p_admin_faqs', '', 0, NULL, NULL),
(92, 42, 's', 'Quizzes', 'tiki-list_quizzes.php', 750, 'feature_quizzes', 'tiki_p_take_quiz', '', 0, 'quizzes48x48', NULL),
(93, 42, 'o', 'List Quizzes', 'tiki-list_quizzes.php', 755, 'feature_quizzes', 'tiki_p_take_quiz', '', 0, NULL, NULL),
(94, 42, 'o', 'Quiz Stats', 'tiki-quiz_stats.php', 760, 'feature_quizzes', 'tiki_p_view_quiz_stats', '', 0, NULL, NULL),
(95, 42, 'o', 'Admin Quizzes', 'tiki-edit_quiz.php', 765, 'feature_quizzes', 'tiki_p_admin_quizzes', '', 0, NULL, NULL),
(96, 42, 's', 'Spreadsheets', 'tiki-sheets.php', 780, 'feature_sheet', 'tiki_p_view_sheet', '', 0, 'spreadsheet48x48', NULL),
(97, 42, 'o', 'List Sheets', 'tiki-sheets.php', 782, 'feature_sheet', 'tiki_p_view_sheet', '', 0, NULL, NULL),
(98, 42, 's', 'Trackers', 'tiki-list_trackers.php', 800, 'feature_trackers', 'tiki_p_list_trackers', '', 0, 'gnome-settings-font48x48', NULL),
(99, 42, 'o', 'List Trackers', 'tiki-list_trackers.php', 805, 'feature_trackers', 'tiki_p_list_trackers', '', 0, NULL, NULL),
(100, 42, 'o', 'Manage Tabular Formats', 'tiki-tabular-manage', 810, 'tracker_tabular_enabled', 'tiki_p_tabular_admin', '', 0, NULL, NULL),
(101, 42, 's', 'Accounting', 'tiki-accounting_books.php', 830, 'feature_accounting', 'tiki_p_acct_view', '', 0, 'accounting48x48', NULL),
(102, 42, 'o', 'Accounting books', 'tiki-accounting_books.php', 835, 'feature_accounting', 'tiki_p_acct_view', '', 0, NULL, NULL),
(103, 42, 's', 'Surveys', 'tiki-list_surveys.php', 850, 'feature_surveys', 'tiki_p_take_survey', '', 0, 'surveys48x48', NULL),
(104, 42, 'o', 'List Surveys', 'tiki-list_surveys.php', 855, 'feature_surveys', 'tiki_p_take_survey', '', 0, NULL, NULL),
(105, 42, 'o', 'Stats', 'tiki-survey_stats.php', 860, 'feature_surveys', 'tiki_p_view_survey_stats', '', 0, 'stats48x48', NULL),
(106, 42, 'o', 'Admin Surveys', 'tiki-admin_surveys.php', 865, 'feature_surveys', 'tiki_p_admin_surveys', '', 0, NULL, NULL),
(107, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_subscribe_newsletters', '', 0, 'messages48x48', NULL),
(108, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_send_newsletters', '', 0, 'messages48x48', NULL),
(109, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_admin_newsletters', '', 0, 'messages48x48', NULL),
(110, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_list_newsletters', '', 0, 'messages48x48', NULL),
(111, 42, 'o', 'Send Newsletters', 'tiki-send_newsletters.php', 905, 'feature_newsletters', 'tiki_p_send_newsletters', '', 0, NULL, NULL),
(112, 42, 'o', 'Admin Newsletters', 'tiki-admin_newsletters.php', 910, 'feature_newsletters', 'tiki_p_admin_newsletters', '', 0, NULL, NULL),
(113, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin', '', 0, 'icon-configuration48x48', NULL),
(114, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_categories', '', 0, 'icon-configuration48x48', NULL),
(115, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_banners', '', 0, 'icon-configuration48x48', NULL),
(116, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(117, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_cookies', '', 0, 'icon-configuration48x48', NULL),
(118, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_dynamic', '', 0, 'icon-configuration48x48', NULL),
(119, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_mailin', '', 0, 'icon-configuration48x48', NULL),
(120, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_content_templates', '', 0, 'icon-configuration48x48', NULL),
(121, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_html_pages', '', 0, 'icon-configuration48x48', NULL),
(122, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_view_referer_stats', '', 0, 'icon-configuration48x48', NULL),
(123, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_shoutbox', '', 0, 'icon-configuration48x48', NULL),
(124, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_live_support_admin', '', 0, 'icon-configuration48x48', NULL),
(125, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'user_is_operator', '', 0, 'icon-configuration48x48', NULL),
(126, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_integrator', 'tiki_p_admin_integrator', '', 0, 'icon-configuration48x48', NULL),
(127, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_edit_templates', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(128, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_view_tpl', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(129, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_editcss', 'tiki_p_create_css', '', 0, 'icon-configuration48x48', NULL),
(130, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_contribution', '', 0, 'icon-configuration48x48', NULL),
(131, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_users', '', 0, 'icon-configuration48x48', NULL),
(132, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_toolbars', '', 0, 'icon-configuration48x48', NULL),
(133, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_menu', '', 0, 'icon-configuration48x48', NULL),
(134, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_clean_cache', '', 0, 'icon-configuration48x48', NULL),
(135, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_modules', '', 0, 'icon-configuration48x48', NULL),
(136, 42, 'o', ' Control Panels', 'tiki-admin.php', 1051, '', 'tiki_p_admin', '', 0, NULL, NULL),
(137, 42, 'o', 'Live Support', 'tiki-live_support_admin.php', 1055, 'feature_live_support', 'tiki_p_live_support_admin', '', 0, NULL, NULL),
(138, 42, 'o', 'Live Support', 'tiki-live_support_admin.php', 1055, 'feature_live_support', 'user_is_operator', '', 0, NULL, NULL),
(139, 42, 'o', 'Banning', 'tiki-admin_banning.php', 1060, 'feature_banning', 'tiki_p_admin_banning', '', 0, NULL, NULL),
(140, 42, 'o', 'Calendar', 'tiki-admin_calendars.php', 1065, 'feature_calendar', 'tiki_p_admin_calendar', '', 0, NULL, NULL),
(141, 42, 'o', 'Admin credits', 'tiki-admin_credits.php', 1067, 'payment_feature', 'tiki_p_admin_users', '', 0, NULL, NULL),
(142, 42, 'o', 'Users', 'tiki-adminusers.php', 1070, '', 'tiki_p_admin_users', '', 0, NULL, NULL),
(143, 42, 'o', 'Groups', 'tiki-admingroups.php', 1075, '', 'tiki_p_admin', '', 0, NULL, NULL),
(144, 42, 'o', 'External Pages Cache', 'tiki-list_cache.php', 1080, 'cachepages', 'tiki_p_admin', '', 0, NULL, NULL),
(145, 42, 'o', 'Modules', 'tiki-admin_modules.php', 1085, '', 'tiki_p_admin_modules', '', 0, NULL, NULL),
(146, 42, 'o', 'Hotwords', 'tiki-admin_hotwords.php', 1095, 'feature_hotwords', 'tiki_p_admin', '', 0, NULL, NULL),
(147, 42, 'o', 'Edit languages', 'tiki-edit_languages.php', 1098, 'lang_use_db', 'tiki_p_edit_languages', '', 0, NULL, NULL),
(148, 42, 'o', 'External Feeds', 'tiki-admin_rssmodules.php', 1100, '', 'tiki_p_admin_rssmodules', '', 0, NULL, NULL),
(149, 42, 'o', 'External Wikis', 'tiki-admin_external_wikis.php', 1102, '', 'tiki_p_admin', '', 0, NULL, NULL),
(150, 42, 'o', 'Menus', 'tiki-admin_menus.php', 1105, '', 'tiki_p_edit_menu', '', 0, NULL, NULL),
(151, 42, 'o', 'Polls', 'tiki-admin_polls.php', 1110, 'feature_polls', 'tiki_p_admin_polls', '', 0, NULL, NULL),
(152, 42, 'o', 'Mail Notifications', 'tiki-admin_notifications.php', 1120, '', 'tiki_p_admin_notifications', '', 0, NULL, NULL),
(153, 42, 'o', 'Search Stats', 'tiki-search_stats.php', 1125, 'feature_search_stats', 'tiki_p_admin', '', 0, NULL, NULL),
(154, 42, 'o', 'Theme Control', 'tiki-theme_control.php', 1130, 'feature_theme_control', 'tiki_p_admin', '', 0, NULL, NULL),
(155, 42, 'o', 'Tokens', 'tiki-admin_tokens.php', 1132, 'auth_token_access', 'tiki_p_admin', '', 0, NULL, NULL),
(156, 42, 'o', 'Toolbars', 'tiki-admin_toolbars.php', 1135, '', 'tiki_p_admin_toolbars', '', 0, NULL, NULL),
(157, 42, 'o', 'Transitions', 'tiki-admin_transitions.php', 1140, '', 'tiki_p_admin', '', 0, NULL, NULL),
(158, 42, 'o', 'Categories', 'tiki-admin_categories.php', 1145, 'feature_categories', 'tiki_p_admin_categories', '', 0, 'categories48x48', NULL),
(159, 42, 'o', 'Banners', 'tiki-list_banners.php', 1150, 'feature_banners', 'tiki_p_admin_banners', '', 0, NULL, NULL),
(160, 42, 'o', 'Edit Templates', 'tiki-edit_templates.php', 1155, 'feature_edit_templates', 'tiki_p_edit_templates', '', 0, NULL, NULL),
(161, 42, 'o', 'View Templates', 'tiki-edit_templates.php', 1155, 'feature_view_tpl', 'tiki_p_edit_templates', '', 2, NULL, NULL),
(162, 42, 'o', 'Edit CSS', 'tiki-edit_css.php', 1158, 'feature_editcss', 'tiki_p_create_css', '', 2, NULL, NULL),
(163, 42, 'o', 'Dynamic content', 'tiki-list_contents.php', 1165, 'feature_dynamic_content', 'tiki_p_admin_dynamic', '', 0, NULL, NULL),
(164, 42, 'o', 'Mail-in', 'tiki-admin_mailin.php', 1175, 'feature_mailin', 'tiki_p_admin_mailin', '', 0, NULL, NULL),
(165, 42, 'o', 'HTML Pages', 'tiki-admin_html_pages.php', 1185, 'feature_html_pages', 'tiki_p_edit_html_pages', '', 0, NULL, NULL),
(166, 42, 'o', 'Shoutbox', 'tiki-shoutbox.php', 1190, 'feature_shoutbox', 'tiki_p_admin_shoutbox', '', 0, NULL, NULL),
(167, 42, 'o', 'Shoutbox Words', 'tiki-admin_shoutbox_words.php', 1191, 'feature_shoutbox', 'tiki_p_admin_shoutbox', '', 0, NULL, NULL),
(168, 42, 'o', 'Referer Stats', 'tiki-referer_stats.php', 1195, 'feature_referer_stats', 'tiki_p_view_referer_stats', '', 0, NULL, NULL),
(169, 42, 'o', 'Integrator', 'tiki-admin_integrator.php', 1205, 'feature_integrator', 'tiki_p_admin_integrator', '', 0, NULL, NULL),
(170, 42, 'o', 'phpinfo', 'tiki-phpinfo.php', 1215, '', 'tiki_p_admin', '', 0, NULL, NULL),
(171, 42, 'o', 'Tiki Cache/Sys Admin', 'tiki-admin_system.php', 1230, '', 'tiki_p_clean_cache', '', 0, NULL, NULL),
(172, 42, 'o', 'Tiki Importer', 'tiki-importer.php', 1240, '', 'tiki_p_admin_importer', '', 0, NULL, NULL),
(173, 42, 'o', 'Tiki Logs', 'tiki-syslog.php', 1245, '', 'tiki_p_admin', '', 0, NULL, NULL),
(174, 42, 'o', 'Security Admin', 'tiki-admin_security.php', 1250, '', 'tiki_p_admin', '', 0, NULL, NULL),
(175, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_admin', '', 0, NULL, NULL),
(176, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_view_actionlog', '', 0, NULL, NULL),
(177, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_view_actionlog_owngroups', '', 0, NULL, NULL),
(178, 42, 'o', 'Content Templates', 'tiki-admin_content_templates.php', 1256, 'feature_wiki_templates', 'tiki_p_edit_content_templates', '', 0, NULL, NULL),
(179, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_wiki_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(180, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_article_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(181, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_file_galleries_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(182, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_image_galleries_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(183, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_poll_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(184, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_faq_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(185, 42, 'o', 'Contribution', 'tiki-admin_contribution.php', 1265, 'feature_contribution', 'tiki_p_admin_contribution', '', 0, NULL, NULL),
(186, 42, 's', 'Kaltura Video', 'tiki-list_kaltura_entries.php', 950, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_list_videos', '', 0, 'kaltura48x48', NULL),
(187, 42, 'o', 'List Media', 'tiki-list_kaltura_entries.php', 952, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_list_videos', '', 0, NULL, NULL),
(188, 42, 'o', 'Upload Media', 'tiki-kaltura_upload.php', 954, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_upload_videos', '', 0, NULL, NULL),
(189, 42, 'o', 'Permissions', 'tiki-objectpermissions.php', 1077, '', 'tiki_p_admin|tiki_p_admin_objects', '', 0, NULL, NULL),
(190, 42, 'o', 'Perspectives', 'tiki-edit_perspective.php', 1081, 'feature_perspective', 'tiki_p_admin', '', 0, NULL, NULL),
(191, 42, 'o', 'Social networks', 'tiki-socialnetworks.php', 115, 'feature_mytiki,feature_socialnetworks', 'tiki_p_socialnetworks|tiki_p_admin_socialnetworks', 'Registered', 0, NULL, NULL),
(192, 42, 'r', 'Invoice', 'tiki-list_invoices.php', 790, 'feature_invoice', 'tiki_p_admin', '', 0, 'invoice48x48', NULL),
(193, 42, 'o', 'New Invoice', 'tiki-edit_invoice.php', 791, 'feature_invoice', 'tiki_p_admin', '', 0, NULL, NULL),
(194, 42, 'o', 'TimeSheet', 'tiki-timesheet.php', 39, 'feature_time_sheet', '', '', 0, 'timesheet48x48', NULL),
(195, 42, 'o', 'Reports', 'tiki-edit_report.php', 38, 'feature_reports', 'tiki_p_admin', '', 0, 'reports48x48', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minical_events`
--

CREATE TABLE `tiki_minical_events` (
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `eventId` int(12) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `start` int(14) DEFAULT NULL,
  `end` int(14) DEFAULT NULL,
  `security` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `duration` int(3) DEFAULT NULL,
  `topicId` int(12) DEFAULT NULL,
  `reminded` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minical_topics`
--

CREATE TABLE `tiki_minical_topics` (
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `topicId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filename` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filetype` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filesize` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longblob,
  `path` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isIcon` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`topicId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minichat`
--

CREATE TABLE `tiki_minichat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel` varchar(31) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ts` int(10) unsigned NOT NULL,
  `user` varchar(31) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nick` varchar(31) COLLATE utf8_unicode_ci DEFAULT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `channel` (`channel`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_modules`
--

CREATE TABLE `tiki_modules` (
  `moduleId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `position` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ord` int(4) NOT NULL DEFAULT '0',
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cache_time` int(14) DEFAULT NULL,
  `rows` int(4) DEFAULT NULL,
  `params` text COLLATE utf8_unicode_ci,
  `groups` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`moduleId`),
  KEY `positionType` (`position`,`type`),
  KEY `namePosOrdParam` (`name`(100),`position`,`ord`,`params`(120))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `tiki_modules`
--

INSERT INTO `tiki_modules` VALUES
(1, 'menu', 'left', 1, NULL, NULL, 7200, NULL, 'id=42&flip=y', 'a:1:{i:0;s:10:"Registered";}'),
(2, 'logo', 'top', 1, NULL, NULL, 7200, NULL, 'nobox=y', 'a:0:{}'),
(3, 'login_box', 'top', 2, NULL, NULL, 0, NULL, 'mode=popup&nobox=y', 'a:0:{}'),
(4, 'quickadmin', 'top', 3, NULL, NULL, 7200, NULL, 'nobox=y', 'a:1:{i:0;s:6:"Admins";}'),
(5, 'rsslist', 'bottom', 1, NULL, NULL, 7200, NULL, 'nobox=y', 'a:0:{}'),
(6, 'poweredby', 'bottom', 2, NULL, NULL, 7200, NULL, 'nobox=y&icons=n&version=n', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletters`
--

CREATE TABLE `tiki_newsletters` (
  `nlId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `lastSent` int(14) DEFAULT NULL,
  `editions` int(10) DEFAULT NULL,
  `users` int(10) DEFAULT NULL,
  `allowUserSub` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `allowAnySub` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unsubMsg` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `validateAddr` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `frequency` int(14) DEFAULT NULL,
  `allowTxt` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `author` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `allowArticleClip` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  `autoArticleClip` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `articleClipTypes` text COLLATE utf8_unicode_ci,
  `articleClipRange` int(14) DEFAULT NULL,
  `emptyClipBlocksSend` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  PRIMARY KEY (`nlId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_groups`
--

CREATE TABLE `tiki_newsletter_groups` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `groupName` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `include_groups` char(1) COLLATE utf8_unicode_ci DEFAULT 'y',
  PRIMARY KEY (`nlId`,`groupName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_included`
--

CREATE TABLE `tiki_newsletter_included` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `includedId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nlId`,`includedId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_pages`
--

CREATE TABLE `tiki_newsletter_pages` (
  `nlId` int(12) NOT NULL,
  `wikiPageName` varchar(160) COLLATE utf8_unicode_ci NOT NULL,
  `validateAddrs` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `addToList` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`nlId`,`wikiPageName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_subscriptions`
--

CREATE TABLE `tiki_newsletter_subscriptions` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valid` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subscribed` int(14) DEFAULT NULL,
  `isUser` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `included` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`nlId`,`email`,`isUser`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_objects`
--

CREATE TABLE `tiki_objects` (
  `objectId` int(12) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `itemId` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `href` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `comments_locked` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`objectId`),
  KEY `type` (`type`,`objectId`),
  KEY `itemId` (`itemId`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_attributes`
--

CREATE TABLE `tiki_object_attributes` (
  `attributeId` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `itemId` varchar(160) COLLATE utf8_unicode_ci NOT NULL,
  `attribute` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attributeId`),
  UNIQUE KEY `item_attribute_uq` (`type`,`itemId`,`attribute`),
  KEY `attribute_lookup_ix` (`attribute`,`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_ratings`
--

CREATE TABLE `tiki_object_ratings` (
  `catObjectId` int(12) NOT NULL DEFAULT '0',
  `pollId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`,`pollId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_relations`
--

CREATE TABLE `tiki_object_relations` (
  `relationId` int(11) NOT NULL AUTO_INCREMENT,
  `relation` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `source_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `source_itemId` varchar(160) COLLATE utf8_unicode_ci NOT NULL,
  `target_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `target_itemId` varchar(160) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`relationId`),
  KEY `relation_source_ix` (`source_type`,`source_itemId`),
  KEY `relation_target_ix` (`target_type`,`target_itemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_scores`
--

CREATE TABLE `tiki_object_scores` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `triggerObjectType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `triggerObjectId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `triggerUser` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `triggerEvent` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ruleId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `recipientObjectType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `recipientObjectId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pointsAssigned` int(11) NOT NULL,
  `pointsBalance` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `reversalOf` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_output`
--

CREATE TABLE `tiki_output` (
  `entityId` varchar(160) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `outputType` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `version` int(8) NOT NULL DEFAULT '0',
  `outputId` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`outputId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages`
--

CREATE TABLE `tiki_pages` (
  `page_id` int(14) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pageSlug` varchar(160) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `data` mediumtext COLLATE utf8_unicode_ci,
  `description` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `comment` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `version` int(8) NOT NULL DEFAULT '0',
  `version_minor` int(8) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `ip` varchar(39) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flag` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `points` int(8) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `cache` longtext COLLATE utf8_unicode_ci,
  `wiki_cache` int(10) DEFAULT NULL,
  `cache_timestamp` int(14) DEFAULT NULL,
  `pageRank` decimal(4,3) DEFAULT NULL,
  `creator` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_size` int(10) unsigned DEFAULT '0',
  `lang` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_html` tinyint(1) DEFAULT '0',
  `created` int(14) DEFAULT NULL,
  `wysiwyg` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wiki_authors_style` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `comments_enabled` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `pageName` (`pageName`),
  UNIQUE KEY `pageSlug` (`pageSlug`),
  KEY `data` (`data`(255)),
  KEY `pageRank` (`pageRank`),
  KEY `lastModif` (`lastModif`),
  FULLTEXT KEY `ft` (`pageName`,`description`,`data`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tiki_pages`
--

INSERT INTO `tiki_pages` VALUES
(1, 'HomePage', 'HomePage', 0, '!Congratulations\nThis is the default homepage for your Tiki. If you are seeing this page, your installation was successful.\n\nYou can change this page after logging in. Please review the [http://doc.tiki.org/wiki+syntax|wiki syntax] for editing details.\n\n\n!!Get started.\nTo begin configuring your site:\n{FANCYLIST()}\n1) Log in with your newly created password.\n2) Manually [tiki-admin.php?page=features|Enable specific Tiki features] that you didn''t enable with the Admin wizard.\n3) Run [tiki-admin.php?page=profiles|Tiki Profiles] to quickly get up and running.\n{FANCYLIST}\n\n!!Need help?\nFor more information:\n*[https://tiki.org/Introduction|Learn more about Tiki].\n*[https://tiki.org/|Get help], including the [http://doc.tiki.org|official documentation] and [http://tiki.org/forums|support forums].\n*[https://tiki.org/Join|Join the Tiki community].\n', '', [[timestamp]], 'Tiki initialization', 1, 0, 'admin', '0.0.0.0', '', NULL, NULL, NULL, NULL, NULL, NULL, 'admin', 851, 'en', '', 0, [[timestamp]], 'n', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages_changes`
--

CREATE TABLE `tiki_pages_changes` (
  `page_id` int(14) NOT NULL DEFAULT '0',
  `version` int(10) NOT NULL DEFAULT '0',
  `segments_added` int(10) DEFAULT NULL,
  `segments_removed` int(10) DEFAULT NULL,
  `segments_total` int(10) DEFAULT NULL,
  PRIMARY KEY (`page_id`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages_translation_bits`
--

CREATE TABLE `tiki_pages_translation_bits` (
  `translation_bit_id` int(14) NOT NULL AUTO_INCREMENT,
  `page_id` int(14) NOT NULL,
  `version` int(8) NOT NULL,
  `source_translation_bit` int(10) DEFAULT NULL,
  `original_translation_bit` int(10) DEFAULT NULL,
  `flags` set('critical') COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`translation_bit_id`),
  KEY `page_id` (`page_id`),
  KEY `original_translation_bit` (`original_translation_bit`),
  KEY `source_translation_bit` (`source_translation_bit`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pageviews`
--

CREATE TABLE `tiki_pageviews` (
  `day` int(14) NOT NULL DEFAULT '0',
  `pageviews` int(14) DEFAULT NULL,
  PRIMARY KEY (`day`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_page_footnotes`
--

CREATE TABLE `tiki_page_footnotes` (
  `user` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pageName` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`user`(150),`pageName`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_page_references`
--

CREATE TABLE `tiki_page_references` (
  `ref_id` int(14) NOT NULL AUTO_INCREMENT,
  `page_id` int(14) DEFAULT NULL,
  `biblio_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `part` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uri` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `year` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `publisher` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ref_id`),
  UNIQUE KEY `uk1_tiki_page_ref_biblio_code` (`page_id`,`biblio_code`),
  KEY `PageId` (`page_id`),
  KEY `idx_tiki_page_ref_title` (`title`),
  KEY `idx_tiki_page_ref_author` (`author`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_payment_received`
--

CREATE TABLE `tiki_payment_received` (
  `paymentReceivedId` int(11) NOT NULL AUTO_INCREMENT,
  `paymentRequestId` int(11) NOT NULL,
  `payment_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `amount` decimal(7,2) DEFAULT NULL,
  `type` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'paid',
  `details` text COLLATE utf8_unicode_ci,
  `userId` int(8) DEFAULT NULL,
  PRIMARY KEY (`paymentReceivedId`),
  KEY `payment_request_ix` (`paymentRequestId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_payment_requests`
--

CREATE TABLE `tiki_payment_requests` (
  `paymentRequestId` int(11) NOT NULL AUTO_INCREMENT,
  `amount` decimal(7,2) NOT NULL,
  `amount_paid` decimal(7,2) NOT NULL DEFAULT '0.00',
  `currency` char(3) COLLATE utf8_unicode_ci NOT NULL,
  `request_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `due_date` timestamp NULL DEFAULT NULL,
  `authorized_until` timestamp NULL DEFAULT NULL,
  `cancel_date` timestamp NULL DEFAULT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `actions` text COLLATE utf8_unicode_ci,
  `detail` text COLLATE utf8_unicode_ci,
  `userId` int(8) DEFAULT NULL,
  PRIMARY KEY (`paymentRequestId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_perspectives`
--

CREATE TABLE `tiki_perspectives` (
  `perspectiveId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`perspectiveId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_perspective_preferences`
--

CREATE TABLE `tiki_perspective_preferences` (
  `perspectiveId` int(11) NOT NULL,
  `pref` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`perspectiveId`,`pref`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_plugin_security`
--

CREATE TABLE `tiki_plugin_security` (
  `fingerprint` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `added_by` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `approval_by` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_objectType` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `last_objectId` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`fingerprint`),
  KEY `last_object` (`last_objectType`,`last_objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_polls`
--

CREATE TABLE `tiki_polls` (
  `pollId` int(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `active` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `publishDate` int(14) DEFAULT NULL,
  `voteConsiderationSpan` int(4) DEFAULT '0',
  PRIMARY KEY (`pollId`),
  KEY `tiki_poll_lookup` (`active`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_poll_objects`
--

CREATE TABLE `tiki_poll_objects` (
  `catObjectId` int(11) NOT NULL DEFAULT '0',
  `pollId` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`catObjectId`,`pollId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_poll_options`
--

CREATE TABLE `tiki_poll_options` (
  `pollId` int(8) NOT NULL DEFAULT '0',
  `optionId` int(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` int(4) NOT NULL DEFAULT '0',
  `votes` int(8) DEFAULT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_preferences`
--

CREATE TABLE `tiki_preferences` (
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tiki_preferences`
--

INSERT INTO `tiki_preferences` VALUES
('browsertitle', '[[site_name]]'),
('sender_email', '[[admin_email]]'),
('https_login', 'allowed'),
('https_port', ''),
('error_reporting_level', '2039'),
('use_proxy', 'n'),
('proxy_host', ''),
('proxy_port', ''),
('proxy_user', ''),
('proxy_pass', ''),
('error_reporting_adminonly', 'y'),
('smarty_notice_reporting', 'n'),
('log_tpl', 'n'),
('feature_switch_ssl_mode', 'n'),
('feature_show_stay_in_ssl_mode', 'y'),
('language', 'en'),
('unified_identifier_fields', 'a:15:{i:0;s:8:"language";i:1;s:10:"gallery_id";i:2;s:10:"searchable";i:3;s:15:"view_permission";i:4;s:13:"primary_image";i:5;s:11:"geo_located";i:6;s:12:"geo_location";i:7;s:13:"title_initial";i:8;s:15:"title_firstword";i:9;s:3:"url";i:10;s:11:"object_type";i:11;s:9:"object_id";i:12;s:10:"addongroup";i:13;s:16:"addonleadergroup";i:14;s:17:"addonpendinggroup";}'),
('unified_mysql_index_current', '[[indexName]]'),
('unified_last_rebuild', '[[timestamp]]'),
('wizard_admin_hide_on_login', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_private_messages`
--

CREATE TABLE `tiki_private_messages` (
  `messageId` int(8) NOT NULL AUTO_INCREMENT,
  `toNickname` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `poster` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'anonymous',
  `timestamp` int(14) DEFAULT NULL,
  `received` tinyint(1) NOT NULL DEFAULT '0',
  `message` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`messageId`),
  KEY `received` (`received`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_profile_symbols`
--

CREATE TABLE `tiki_profile_symbols` (
  `domain` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `profile` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `object` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(160) COLLATE utf8_unicode_ci NOT NULL,
  `named` enum('y','n') COLLATE utf8_unicode_ci NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`domain`,`profile`,`object`),
  KEY `named` (`named`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_programmed_content`
--

CREATE TABLE `tiki_programmed_content` (
  `pId` int(8) NOT NULL AUTO_INCREMENT,
  `contentId` int(8) NOT NULL DEFAULT '0',
  `content_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'static',
  `publishDate` int(14) NOT NULL DEFAULT '0',
  `data` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`pId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_queue`
--

CREATE TABLE `tiki_queue` (
  `entryId` int(11) NOT NULL AUTO_INCREMENT,
  `queue` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `handler` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`entryId`),
  KEY `queue_name_ix` (`queue`),
  KEY `queue_handler_ix` (`handler`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quizzes`
--

CREATE TABLE `tiki_quizzes` (
  `quizId` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `canRepeat` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `storeResults` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `questionsPerPage` int(4) DEFAULT NULL,
  `timeLimited` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timeLimit` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `taken` int(10) DEFAULT NULL,
  `immediateFeedback` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `showAnswers` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shuffleQuestions` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shuffleAnswers` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `bDeleted` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nAuthor` int(4) DEFAULT NULL,
  `bOnline` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bRandomQuestions` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nRandomQuestions` tinyint(4) DEFAULT NULL,
  `bLimitQuestionsPerPage` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nLimitQuestionsPerPage` tinyint(4) DEFAULT NULL,
  `bMultiSession` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nCanRepeat` tinyint(4) DEFAULT NULL,
  `sGradingMethod` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sShowScore` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sShowCorrectAnswers` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sPublishStats` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bAdditionalQuestions` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bForum` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sForum` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sPrologue` text COLLATE utf8_unicode_ci,
  `sData` text COLLATE utf8_unicode_ci,
  `sEpilogue` text COLLATE utf8_unicode_ci,
  `passingperct` int(4) DEFAULT '0',
  PRIMARY KEY (`quizId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_questions`
--

CREATE TABLE `tiki_quiz_questions` (
  `questionId` int(10) NOT NULL AUTO_INCREMENT,
  `quizId` int(10) DEFAULT NULL,
  `question` text COLLATE utf8_unicode_ci,
  `position` int(4) DEFAULT NULL,
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `maxPoints` int(4) DEFAULT NULL,
  PRIMARY KEY (`questionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_question_options`
--

CREATE TABLE `tiki_quiz_question_options` (
  `optionId` int(10) NOT NULL AUTO_INCREMENT,
  `questionId` int(10) DEFAULT NULL,
  `optionText` text COLLATE utf8_unicode_ci,
  `points` int(4) DEFAULT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_results`
--

CREATE TABLE `tiki_quiz_results` (
  `resultId` int(10) NOT NULL AUTO_INCREMENT,
  `quizId` int(10) DEFAULT NULL,
  `fromPoints` int(4) DEFAULT NULL,
  `toPoints` int(4) DEFAULT NULL,
  `answer` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`resultId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_stats`
--

CREATE TABLE `tiki_quiz_stats` (
  `quizId` int(10) NOT NULL DEFAULT '0',
  `questionId` int(10) NOT NULL DEFAULT '0',
  `optionId` int(10) NOT NULL DEFAULT '0',
  `votes` int(10) DEFAULT NULL,
  PRIMARY KEY (`quizId`,`questionId`,`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_stats_sum`
--

CREATE TABLE `tiki_quiz_stats_sum` (
  `quizId` int(10) NOT NULL DEFAULT '0',
  `quizName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timesTaken` int(10) DEFAULT NULL,
  `avgpoints` decimal(5,2) DEFAULT NULL,
  `avgavg` decimal(5,2) DEFAULT NULL,
  `avgtime` decimal(5,2) DEFAULT NULL,
  PRIMARY KEY (`quizId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rating_configs`
--

CREATE TABLE `tiki_rating_configs` (
  `ratingConfigId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `expiry` int(11) NOT NULL DEFAULT '3600',
  `formula` text COLLATE utf8_unicode_ci NOT NULL,
  `callbacks` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`ratingConfigId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rating_obtained`
--

CREATE TABLE `tiki_rating_obtained` (
  `ratingId` int(11) NOT NULL AUTO_INCREMENT,
  `ratingConfigId` int(11) NOT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `object` int(11) NOT NULL,
  `expire` int(11) NOT NULL,
  `value` float NOT NULL,
  PRIMARY KEY (`ratingId`),
  UNIQUE KEY `tiki_obtained_rating_uq` (`type`,`object`,`ratingConfigId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_received_articles`
--

CREATE TABLE `tiki_received_articles` (
  `receivedArticleId` int(14) NOT NULL AUTO_INCREMENT,
  `receivedFromSite` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receivedFromUser` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receivedDate` int(14) DEFAULT NULL,
  `title` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `authorName` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `size` int(12) DEFAULT NULL,
  `useImage` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_name` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_type` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_size` int(14) DEFAULT NULL,
  `image_x` int(4) DEFAULT NULL,
  `image_y` int(4) DEFAULT NULL,
  `image_data` longblob,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `heading` text COLLATE utf8_unicode_ci,
  `body` longblob,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `author` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rating` decimal(3,2) DEFAULT NULL,
  PRIMARY KEY (`receivedArticleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_received_pages`
--

CREATE TABLE `tiki_received_pages` (
  `receivedPageId` int(14) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` longblob,
  `description` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comment` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receivedFromSite` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receivedFromUser` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receivedDate` int(14) DEFAULT NULL,
  `parent` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` tinyint(3) unsigned DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `structureName` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parentName` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_alias` varchar(250) COLLATE utf8_unicode_ci DEFAULT '',
  `pos` int(4) DEFAULT NULL,
  PRIMARY KEY (`receivedPageId`),
  KEY `structureName` (`structureName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_referer_stats`
--

CREATE TABLE `tiki_referer_stats` (
  `referer` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) DEFAULT NULL,
  `last` int(14) DEFAULT NULL,
  `lasturl` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`referer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_registration_fields`
--

CREATE TABLE `tiki_registration_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  `show` tinyint(1) NOT NULL DEFAULT '1',
  `size` varchar(10) COLLATE utf8_unicode_ci DEFAULT '10',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_related_categories`
--

CREATE TABLE `tiki_related_categories` (
  `categId` int(10) NOT NULL DEFAULT '0',
  `relatedTo` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`categId`,`relatedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_feeds`
--

CREATE TABLE `tiki_rss_feeds` (
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rssVer` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `refresh` int(8) DEFAULT '300',
  `lastUpdated` int(14) DEFAULT NULL,
  `cache` longblob,
  PRIMARY KEY (`name`,`rssVer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_items`
--

CREATE TABLE `tiki_rss_items` (
  `rssItemId` int(11) NOT NULL AUTO_INCREMENT,
  `rssId` int(11) NOT NULL,
  `guid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url` text COLLATE utf8_unicode_ci NOT NULL,
  `publication_date` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `author` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `content` text COLLATE utf8_unicode_ci,
  `categories` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`rssItemId`),
  KEY `tiki_rss_items_rss` (`rssId`),
  KEY `tiki_rss_items_item` (`rssId`,`guid`(200))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_modules`
--

CREATE TABLE `tiki_rss_modules` (
  `rssId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `refresh` int(8) DEFAULT NULL,
  `lastUpdated` int(14) DEFAULT NULL,
  `showTitle` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `showPubDate` char(1) COLLATE utf8_unicode_ci DEFAULT 'n',
  `sitetitle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `siteurl` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `actions` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`rssId`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_schema`
--

CREATE TABLE `tiki_schema` (
  `patch_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `install_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patch_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tiki_schema`
--

INSERT INTO `tiki_schema` VALUES
('00000000_schema_change_tiki', '[[regtime]]'),
('20080227_invite_tiki', '[[regtime]]'),
('20080809_semlinks_tiki', '[[regtime]]'),
('20080827_bigfeaturetype_tiki', '[[regtime]]'),
('20080829_pagealiasdata_tiki', '[[regtime]]'),
('20080829_pluginvalidation_tiki', '[[regtime]]'),
('20080901_pluginvalidation_tiki', '[[regtime]]'),
('20080902_trackerparsedesc_tiki', '[[regtime]]'),
('20080905_feature_tip_tiki', '[[regtime]]'),
('20080916_webservice_registry_tiki', '[[regtime]]'),
('20080922_calendar_customstatus_tiki', '[[regtime]]'),
('20080924_webmail_tiki', '[[regtime]]'),
('20080926_bannerindex_tiki', '[[regtime]]'),
('20081004_mindmap_menu_tiki', '[[regtime]]'),
('20081006_comments_moderation_tiki', '[[regtime]]'),
('20081008_bit_flags_nullable_tiki', '[[regtime]]'),
('20081010_filter_perms_tiki', '[[regtime]]'),
('20081014_trust_input_perm_tiki', '[[regtime]]'),
('20081018_filter_perms_tiki', '[[regtime]]'),
('20081019_score_tiki', '[[regtime]]'),
('20081022_application_menu_tiki', '[[regtime]]'),
('20081024_fulltext_file_tiki', '[[regtime]]'),
('20081027_calendar_tiki', '[[regtime]]'),
('20081027_file_galleries_tiki', '[[regtime]]'),
('20081027_groupalert_tiki', '[[regtime]]'),
('20081027_surveys_tiki', '[[regtime]]'),
('20081027_trackers_tiki', '[[regtime]]'),
('20081027_wysiwyg_history_tiki', '[[regtime]]'),
('20081029_tracker_index_tiki', '[[regtime]]'),
('20081102_application_menu_structures_tiki', '[[regtime]]'),
('20081105_calendar_items_allday_tiki', '[[regtime]]'),
('20081107_menu42_tiki', '[[regtime]]'),
('20081112_tiki_p_tracker_view_comments_tiki', '[[regtime]]'),
('20081114_tiki_banner_tiki', '[[regtime]]'),
('20081119_tiki_p_export_tracker_tiki', '[[regtime]]'),
('20081120_showCategories_tiki', '[[regtime]]'),
('20081120_tiki_poll_structures_update_tiki', '[[regtime]]'),
('20081125_tiki_tracker_types_tiki', '[[regtime]]'),
('20081127_calendar_recurrence_tiki', '[[regtime]]'),
('20081130_tiki_users_permission_tiki', '[[regtime]]'),
('20081211_newsletter_files_tiki', '[[regtime]]'),
('20081211_score_tiki', '[[regtime]]'),
('20081212_tiki_p_view_backlinks_tiki', '[[regtime]]'),
('20081214_webservice_post_tiki', '[[regtime]]'),
('20090106_group_watch_tiki', '[[regtime]]'),
('20090120_sefurl_rules_tiki', '[[regtime]]'),
('20090129_callendar_search_tiki', '[[regtime]]'),
('20090203_null_tiki', '[[regtime]]'),
('20090205_forum_and_comments_locking_tiki', '[[regtime]]'),
('20090205_menucase_tiki', '[[regtime]]'),
('20090205_menus_items_icons_tiki', '[[regtime]]'),
('20090206_content_tpl_menu_tiki', '[[regtime]]'),
('20090206_poll_tiki', '[[regtime]]'),
('20090211_mailnotification_tiki', '[[regtime]]'),
('20090212_forum_tiki', '[[regtime]]'),
('20090220_admin_section_tiki', '[[regtime]]'),
('20090226_admin_menu_tiki', '[[regtime]]'),
('20090301_browsertitle_tiki', '[[regtime]]'),
('20090304_tiki_p_view_backlink_without_s_tiki', '[[regtime]]'),
('20090306_menu_perms_tiki', '[[regtime]]'),
('20090306_text_for_menu_options_tiki', '[[regtime]]'),
('20090310_application_menu_tiki', '[[regtime]]'),
('20090310_feature_search_show_object_filter_tiki', '[[regtime]]'),
('20090311_remove_mod_menu_application_menu_tiki', '[[regtime]]'),
('20090316_index_tiki', '[[regtime]]'),
('20090323_maxUserImpressions_banners_tiki', '[[regtime]]'),
('20090330_quicktags_renames_tiki', '[[regtime]]'),
('20090401_newsletters_included_tiki', '[[regtime]]'),
('20090401_replace_shoutjax_with_shoutbox_tiki', '[[regtime]]'),
('20090401_replace_switch_lang2_with_switch_lang_tiki', '[[regtime]]'),
('20090416_plugin_security_tiki', '[[regtime]]'),
('20090416_quicktags_kil_email_tiki', '[[regtime]]'),
('20090416_quicktags_plugin_helpers_tiki', '[[regtime]]'),
('20090427_filegal_optionalize_tiki', '[[regtime]]'),
('20090429_groupId_tiki', '[[regtime]]'),
('20090513_calendar_priority_tiki', '[[regtime]]'),
('20090513_swffix_tiki', '[[regtime]]'),
('20090513_wiki_similar_permission_tiki', '[[regtime]]'),
('20090515_score_tiki', '[[regtime]]'),
('20090602_webmail_protocols_tiki', '[[regtime]]'),
('20090605_tiki_p_modify_tracker_items_pending_closed_tiki', '[[regtime]]'),
('20090617_add_new_table_for_reports_tiki', '[[regtime]]'),
('20090623_actionlog_view_article_tiki', '[[regtime]]'),
('20090626_change_pear_auth_preferences_to_ldap_tiki', '[[regtime]]'),
('20090707_tiki_p_delete_account_tiki', '[[regtime]]'),
('20090713_tiki_importer_permission_and_menu_entry_tiki', '[[regtime]]'),
('20090715_sefurl_for_filegalleries_tiki', '[[regtime]]'),
('20090720_perspectives_tiki', '[[regtime]]'),
('20090721_webmail_ext_public_tiki', '[[regtime]]'),
('20090727_category_permissions_tiki', '[[regtime]]'),
('20090727_user_votings_index_tiki', '[[regtime]]'),
('20090730_p_list_newsletters_tiki', '[[regtime]]'),
('20090803_perspective_permission_tiki', '[[regtime]]'),
('20090804_kaltura_permissions_tiki', '[[regtime]]'),
('20090804_menu_search_tiki', '[[regtime]]'),
('20090805_kill_newsreader_tiki', '[[regtime]]'),
('20090805_remove_drawings_prefs_etc_tiki', '[[regtime]]'),
('20090805_remove_games_tiki', '[[regtime]]'),
('20090806_group_permissions_tiki', '[[regtime]]'),
('20090806_menu_list_trackers_tiki', '[[regtime]]'),
('20090806_perms_featurechecks_tiki', '[[regtime]]'),
('20090806_remove_charts_tiki', '[[regtime]]'),
('20090806_remove_latin_collations_tiki', '[[regtime]]'),
('20090806_strasa_option_rename_tiki', '[[regtime]]'),
('20090807_transitions_tiki', '[[regtime]]'),
('20090808_add_wiki_minor_edits_tiki', '[[regtime]]'),
('20090809_marc_needs_more_space_tiki', '[[regtime]]'),
('20090811_filegals_container_tiki', '[[regtime]]'),
('20090811_kaltura_editor_pref_tiki', '[[regtime]]'),
('20090811_quizzes_tiki', '[[regtime]]'),
('20090811_rename_quicktags_to_toolbars_tiki', '[[regtime]]'),
('20090823_kaltura_menu_options_tiki', '[[regtime]]'),
('20090826_group_expiration_tiki', '[[regtime]]'),
('20090904_wysiwyg_newsletters_tiki', '[[regtime]]'),
('20090911_tracker_item_change_user_tiki', '[[regtime]]'),
('20090912_change_feature_name_for_lesser_magic_tiki', '[[regtime]]'),
('20090913_plugin_security_addedby_tiki', '[[regtime]]'),
('20090915_change_perms_for_browse_cats_tiki', '[[regtime]]'),
('20090921_logo_tiki', '[[regtime]]'),
('20090923_mod_change_category_defaults_tiki', '[[regtime]]'),
('20090925_online_logged_users_modules_merge_tiki', '[[regtime]]'),
('20090927_top_images_modules_merge_tiki', '[[regtime]]'),
('20090928_galaxia_leftovers_tiki', '[[regtime]]'),
('20090928_last_images_modules_merge_tiki', '[[regtime]]'),
('20090928_transition_guards_text_tiki', '[[regtime]]'),
('20091004_last_tracker_items_modules_merge_tiki', '[[regtime]]'),
('20091007_update_database_structure_tiki', '[[regtime]]'),
('20091008_reg_group_includes_anon_tiki', '[[regtime]]'),
('20091011_serurl_dl_order_tiki', '[[regtime]]'),
('20091013_fix_perms_tiki', '[[regtime]]'),
('20091015_application_menu_admin_renames_tiki', '[[regtime]]'),
('20091016_categorization_tracker_item_tiki', '[[regtime]]'),
('20091019_article_by_rating_modules_merge_tiki', '[[regtime]]'),
('20091019_last_articles_modules_merge_tiki', '[[regtime]]'),
('20091019_users_perms_types_tidying_tiki', '[[regtime]]'),
('20091020_bigger_user_prefs_tiki', '[[regtime]]'),
('20091020_faq_created_tiki', '[[regtime]]'),
('20091020_kaltura_tiki', '[[regtime]]'),
('20091020_remove_charts_tiki', '[[regtime]]'),
('20091020_sefurl_trackeritem_tiki', '[[regtime]]'),
('20091021_moz_pagelist_tiki', '[[regtime]]'),
('20091023_bookmarks_name_lengthen_tiki', '[[regtime]]'),
('20091023_nul_categ_tiki', '[[regtime]]'),
('20091023_report_tiki', '[[regtime]]'),
('20091027_multiple_session_handler_tiki', '[[regtime]]'),
('20091028_quota_tiki', '[[regtime]]'),
('20091030_wiki_watch_tiki', '[[regtime]]'),
('20091103_upgrade_categperm_tiki', '[[regtime]]'),
('20091105_auth_tokens_tiki', '[[regtime]]'),
('20091111_fgal_size_tiki', '[[regtime]]'),
('20091112_rename_mnu_application_menu_tiki', '[[regtime]]'),
('20091112_template_type_tiki', '[[regtime]]'),
('20091113_old_categ_perm_tiki', '[[regtime]]'),
('20091118_sefurl_tiki', '[[regtime]]'),
('20091120_poll_lookup_index_tiki', '[[regtime]]'),
('20091120_username_pattern_tiki', '[[regtime]]'),
('20091123_dns_permission_tiki', '[[regtime]]'),
('20091123_metrics_tiki', '[[regtime]]'),
('20091123_upgrade_categperm_2_tiki', '[[regtime]]'),
('20091124_fgal_backlink_tiki', '[[regtime]]'),
('20091124_metrics_dsn_tiki', '[[regtime]]'),
('20091125_wiki_comments_per_page_tiki', '[[regtime]]'),
('20091126_dynamic_variables_i18n_tiki', '[[regtime]]'),
('20091204_filegal_wiki_syntax_tiki', '[[regtime]]'),
('20091204_tiki_p_view_newsletter_tiki', '[[regtime]]'),
('20091208_backlink_perms_tiki', '[[regtime]]'),
('20091209_rss_feeds_name_tiki', '[[regtime]]'),
('20091210_charset_tiki', '[[regtime]]'),
('20091210_dcs_type_tiki', '[[regtime]]'),
('20091214_perspective_management_tiki', '[[regtime]]'),
('20091216_show_backlinks_tiki', '[[regtime]]'),
('20091228_page_keywords_tiki', '[[regtime]]'),
('20100101_search_modules_merge_tiki', '[[regtime]]'),
('20100101_search_wiki_page_modules_merge_tiki', '[[regtime]]'),
('20100104_tiki_p_tracker_revote_ratings_tiki', '[[regtime]]'),
('20100106_forum_att_list_nb_tiki', '[[regtime]]'),
('20100107_payment_tiki', '[[regtime]]'),
('20100113_forum_display_tiki', '[[regtime]]'),
('20100114_tiki_actionlog_merge_tiki', '[[regtime]]'),
('20100115_admin_modules_menu_tiki', '[[regtime]]'),
('20100115_tiki_p_admin_modules_tiki', '[[regtime]]'),
('20100115_translations_in_progress_tiki', '[[regtime]]'),
('20100117_old_doc_tw_o_url_tiki', '[[regtime]]'),
('20100118_blog_use_author_tiki', '[[regtime]]'),
('20100118_forum_display_tiki', '[[regtime]]'),
('20100126_file_lastDownload_tiki', '[[regtime]]'),
('20100128_tiki_p_blog_view_ref_tiki', '[[regtime]]'),
('20100129_clean_up_tiki', '[[regtime]]'),
('20100129_events_kil_tiki', '[[regtime]]'),
('20100203_payment_detail_tiki', '[[regtime]]'),
('20100205_tiki_p_wiki_view_ref_tiki', '[[regtime]]'),
('20100207_repair_file_galleries_tiki', '[[regtime]]'),
('20100211_rss_items_tiki', '[[regtime]]'),
('20100211_tiki_perms_menu_item_tiki', '[[regtime]]'),
('20100211_tiki_sheet_add_parseValues_tiki', '[[regtime]]'),
('20100212_rss_automation_tiki', '[[regtime]]'),
('20100213_group_inclusion_key_tiki', '[[regtime]]'),
('20100214_workspaces_remove_menu_items_tiki', '[[regtime]]'),
('20100215_create_tiki_user_login_cookies_tiki', '[[regtime]]'),
('20100215_rating_permissions_tiki', '[[regtime]]'),
('20100216_attributes_tiki', '[[regtime]]'),
('20100216_kil_moz_screencast_tiki', '[[regtime]]'),
('20100216_rename_tikisheet_tiki', '[[regtime]]'),
('20100217_rating_config_tiki', '[[regtime]]'),
('20100218_auth_token_reuse_tiki', '[[regtime]]'),
('20100222_add_webmail_fromEmail_field_tiki', '[[regtime]]'),
('20100222_sheet_toolbar_default_tiki', '[[regtime]]'),
('20100223_blog_always_owner_tiki', '[[regtime]]'),
('20100224_object_relations_tiki', '[[regtime]]'),
('20100226_menu_template_feature_check_tiki', '[[regtime]]'),
('20100226_tracker_dump_perm_tiki', '[[regtime]]'),
('20100302_filegal_images_max_sizes_tiki', '[[regtime]]'),
('20100308_file_delete_after_tiki', '[[regtime]]'),
('20100309_add_sheet_parent_tiki', '[[regtime]]'),
('20100312_emailPattern_tiki', '[[regtime]]'),
('20100324_newsletters_clippings_tiki', '[[regtime]]'),
('20100409_bigger_module_params_tiki', '[[regtime]]'),
('20100414_actionlog_pref_tiki', '[[regtime]]'),
('20100414_actionlog_system_tiki', '[[regtime]]'),
('20100419_bigbluebutton_tiki', '[[regtime]]'),
('20100422_tracker_log_tiki', '[[regtime]]'),
('20100429_newsletter_pages_tiki', '[[regtime]]'),
('20100507_flash_banner_tiki', '[[regtime]]'),
('20100519_actionlog_tiki', '[[regtime]]'),
('20100525_tracker_validation_message_tiki', '[[regtime]]'),
('20100525_tracker_validation_tiki', '[[regtime]]'),
('20100611_rss_items_url_tiki', '[[regtime]]'),
('20100617_sefurl_user_info_tiki', '[[regtime]]'),
('20100618_calendar_participation_tiki', '[[regtime]]'),
('20100621_pageprefixaliasdata_tiki', '[[regtime]]'),
('20100622_pageprefixtrackeritemid_tiki', '[[regtime]]'),
('20100623_semantic_to_relation_tiki', '[[regtime]]'),
('20100624_banning_index_tiki', '[[regtime]]'),
('20100628_payment_user_tiki', '[[regtime]]'),
('20100629_remove_feature_blog_comments_tiki', '[[regtime]]'),
('20100702_discount_tiki', '[[regtime]]'),
('20100712_remove_unsupported_feed_formats_tiki', '[[regtime]]'),
('20100713_rename_feed_prefs_tiki', '[[regtime]]'),
('20100714_batch_transition_tiki', '[[regtime]]'),
('20100716_user_selector_pref_rename_tiki', '[[regtime]]'),
('20100720_tiki_p_view_page_contribution_tiki', '[[regtime]]'),
('20100721_batch_transition_rollback_tiki', '[[regtime]]'),
('20100721_todo_tiki', '[[regtime]]'),
('20100721_todonotif_tiki', '[[regtime]]'),
('20100727_tiki_p_promote_page_tiki', '[[regtime]]'),
('20100730_list_image_article_tiki', '[[regtime]]'),
('20100802_tiki_p_share_tiki', '[[regtime]]'),
('20100802_url_shortener_tiki', '[[regtime]]'),
('20100804_remove_tiki_languages_tiki', '[[regtime]]'),
('20100806_blog_posts_header_tiki', '[[regtime]]'),
('20100807_alter_tiki_translate_fields_to_text_tiki', '[[regtime]]'),
('20100810_title_comments_upgrade_tiki', '[[regtime]]'),
('20100812_blog_control_max_related_content_tiki', '[[regtime]]'),
('20100812_blog_show_related_content_tiki', '[[regtime]]'),
('20100817_add_email_and_website_fields_to_comments_tiki', '[[regtime]]'),
('20100817_credits_tiki', '[[regtime]]'),
('20100817_rename_preference_wiki_comments_notitle_tiki', '[[regtime]]'),
('20100818_watch_tiki', '[[regtime]]'),
('20100820_blog_posts_wysiwyg_tiki', '[[regtime]]'),
('20100820_feed_fields_text_and_desc_are_not_empty_tiki', '[[regtime]]'),
('20100824_blog_post_excerpt_tiki', '[[regtime]]'),
('20100825_add_changed_column_to_tiki_language_table_tiki', '[[regtime]]'),
('20100825_remove_blog_option_use_title_tiki', '[[regtime]]'),
('20100830_sheet_add_styles_and_classes_tiki', '[[regtime]]'),
('20100831_freetag_tiki', '[[regtime]]'),
('20100901_duplic_actionlog_tiki', '[[regtime]]'),
('20100901_expire_tiki', '[[regtime]]'),
('20100902_invit_tiki', '[[regtime]]'),
('20100903_article_ispublished_tiki', '[[regtime]]'),
('20100906_sheet_toolbar_default_tiki', '[[regtime]]'),
('20100909_alter_tiki_language_fields_to_text_tiki', '[[regtime]]'),
('20100909_ckeditor_upgrade_tiki', '[[regtime]]'),
('20100909_lengthen_wiki_attachments_filename_tiki', '[[regtime]]'),
('20100910_new_fields_for_tiki_blogs_tiki', '[[regtime]]'),
('20100912_rename_autosave_pref_tiki', '[[regtime]]'),
('20100915_add_edit_languages_menu_option_tiki', '[[regtime]]'),
('20100919_tiki_page_contribution_tiki', '[[regtime]]'),
('20100920_ckeditor_remove_pref_tiki', '[[regtime]]'),
('20100920_jq_sheet_remove_pref_tiki', '[[regtime]]'),
('20100920_todo_event_tiki', '[[regtime]]'),
('20100923_fix_column_position_tiki', '[[regtime]]'),
('20100923_social_networking_permission_and_menuitem_tiki', '[[regtime]]'),
('20100925_fix_some_default_value_tiki', '[[regtime]]'),
('20100927_better_column_fix2_tiki', '[[regtime]]'),
('20100927_better_column_fix_tiki', '[[regtime]]'),
('20100928_sefurl_regex_reordering_tiki', '[[regtime]]'),
('20101008_user_id_for_tiki_language_tiki', '[[regtime]]'),
('20101014_tiki_language_add_lastModif_column_tiki', '[[regtime]]'),
('20101015_tiki_admin_perms_tiki', '[[regtime]]'),
('20101021_rename_blog_post_comment_object_type_tiki', '[[regtime]]'),
('20101025_fgal_show_deleteAfter_tiki', '[[regtime]]'),
('20101025_profile_sources_pref_tikiwiki_to_tiki', '[[regtime]]'),
('20101025_rename_create_blog_menu_entry_tiki', '[[regtime]]'),
('20101026_auth_token_add_columns_tiki', '[[regtime]]'),
('20101027_add_file_gallery_columns_tiki', '[[regtime]]'),
('20101027_rename_invit_to_invite_tiki', '[[regtime]]'),
('20101028_p_invit_tiki', '[[regtime]]'),
('20101110_actionlog_tiki', '[[regtime]]'),
('20101117_actionlog_tiki', '[[regtime]]'),
('20101119_categ_perm_tiki', '[[regtime]]'),
('20101126_fgal_add_gallerie_user_tiki', '[[regtime]]'),
('20101130_recreate_tiki_accounting_tables_tiki', '[[regtime]]'),
('20101130_tiki_accounting_tiki', '[[regtime]]'),
('20101201_tiki_accounting_fix_index_tiki', '[[regtime]]'),
('20101203_fgal_archive_default_tiki', '[[regtime]]'),
('20101207_feature_file_drafts_tiki', '[[regtime]]'),
('20101208_webservice_soap_tiki', '[[regtime]]'),
('20101210_fgal_add_wiki_attachments_tiki', '[[regtime]]'),
('20101210_sync_users_ldap_tiki', '[[regtime]]'),
('20101211_filegal_maxhits_column_tiki', '[[regtime]]'),
('20101211_kil_feature_phplayers_tiki', '[[regtime]]'),
('20101215_remove_files_tiki', '[[regtime]]'),
('20101215_template_file_galleries_tiki', '[[regtime]]'),
('20101219_kill_feature_mobile_tiki', '[[regtime]]'),
('20101230_create_top_modules_tiki', '[[regtime]]'),
('20110103_include_in_history_tiki', '[[regtime]]'),
('20110104_flagged_revision_log_tiki', '[[regtime]]'),
('20110104_sefurl_trackeritem_again_tiki', '[[regtime]]'),
('20110104_sefurl_trackeritem_tiki', '[[regtime]]'),
('20110112_approval_permissions_tiki', '[[regtime]]'),
('20110115_create_bottom_modules_tiki', '[[regtime]]'),
('20110118_p_remove_tracker_items_tiki', '[[regtime]]'),
('20110124_update_sheet_to_support_cloning_tiki', '[[regtime]]'),
('20110201_c_code_to_user_modules_tiki', '[[regtime]]'),
('20110209_p_list_users_tiki', '[[regtime]]'),
('20110220_p_tracker_view_attachments_tiki', '[[regtime]]'),
('20110223_queue_tiki', '[[regtime]]'),
('20110224_tiki_cart_inventory_hold_tiki', '[[regtime]]'),
('20110307_remove_calendar_reminder_tiki', '[[regtime]]'),
('20110308_rss_item_key_tiki', '[[regtime]]'),
('20110317_attributes_increase_length_tiki', '[[regtime]]'),
('20110411_banner_tiki', '[[regtime]]'),
('20110412_permissions_out_of_db_tiki', '[[regtime]]'),
('20110413_blog_post_priv_default_value_tiki', '[[regtime]]'),
('20110419_kill_old_search_tiki', '[[regtime]]'),
('20110420_newsletter_optional_group_inclusion_tiki', '[[regtime]]'),
('20110421_compact_search_in_topbar_tiki', '[[regtime]]'),
('20110507_remove_module_style_params_tiki', '[[regtime]]'),
('20110513_banner_tiki', '[[regtime]]'),
('20110519_quick_edit_categ_params_merge_tiki', '[[regtime]]'),
('20110603_convert_tracker_comments_tiki', '[[regtime]]'),
('20110606_convert_ip_fields_to_ipv6_tiki', '[[regtime]]'),
('20110609_batch_update_tracker_item_links_tiki', '[[regtime]]'),
('20110609_missing_sql_tiki', '[[regtime]]'),
('20110609_unique_login_tiki', '[[regtime]]'),
('20110610_readd_sefurl_index_left_tiki', '[[regtime]]'),
('20110610_revert_poll_additions_tiki', '[[regtime]]'),
('20110611_accounting_fix_primarykeys_tiki', '[[regtime]]'),
('20110613_filegal_source_display_tiki', '[[regtime]]'),
('20110614_provider_authentication_tiki', '[[regtime]]'),
('20110615_structure_alias_tiki', '[[regtime]]'),
('20110622_file_from_url_log_tiki', '[[regtime]]'),
('20110630_fix_blogs_copyright_frencho_tiki', '[[regtime]]'),
('20110717_invoice_menu_options_tiki', '[[regtime]]'),
('20110725_tracker_field_permname_tiki', '[[regtime]]'),
('20110727_tracker_multilingual_convert_tiki', '[[regtime]]'),
('20110803_objectpermissions_tiki', '[[regtime]]'),
('20110808_default_perm_name_tiki', '[[regtime]]'),
('20110808_tracker_tiki', '[[regtime]]'),
('20110815_creator_lost_7_tiki', '[[regtime]]'),
('20110819_group_max_length_tiki', '[[regtime]]'),
('20110823_tiki_connect_create_tiki', '[[regtime]]'),
('20110830_default_enable_in_use_tiki', '[[regtime]]'),
('20110830_tiki_connect_longer_guid_tiki', '[[regtime]]'),
('20110902_revert_rootCategId_addition_tiki', '[[regtime]]'),
('20110904_shoutbox_def_tweetid_tiki', '[[regtime]]'),
('20110905_extend_actionlog_comment_tiki', '[[regtime]]'),
('20110905_multibyte_lc_fix_tiki', '[[regtime]]'),
('20110908_author_submission_tiki', '[[regtime]]'),
('20110909_tiki_forums_add_language_tiki', '[[regtime]]'),
('20110911_add_missing_engine_specs_tiki', '[[regtime]]'),
('20110912_groupsexpiryanniversary_tiki', '[[regtime]]'),
('20110912_remove_unused_fields_tiki', '[[regtime]]'),
('20110923_referer_stats_tiki', '[[regtime]]'),
('20110926_tracker_menu_feature_reports_tiki', '[[regtime]]'),
('20111001_add_tiki_areas_tiki', '[[regtime]]'),
('20111006_drop_useless_key_tiki', '[[regtime]]'),
('20111010_revert_fix_user_bookmarks_folders_key_tiki', '[[regtime]]'),
('20111014_menu_feature_time_sheet_tiki', '[[regtime]]'),
('20111118_remove_versionOfPreferencesCache_tiki', '[[regtime]]'),
('20111210_add_blog_hits_tiki', '[[regtime]]'),
('20111217_on_value_tracker_tiki', '[[regtime]]'),
('20120115_remove_article_show_lang_tiki', '[[regtime]]'),
('20120118_remove_users_prefs_language_tiki', '[[regtime]]'),
('20120123_remove_column_from_tiki_user_reports_tiki', '[[regtime]]'),
('20120315_list_image_article_y_tiki', '[[regtime]]'),
('20120319_remove_sheets_with_no_relation_tiki', '[[regtime]]'),
('20120320_remove_admin_trackers_application_menu_tiki', '[[regtime]]'),
('20120323_add_reports_to_application_menu_tiki', '[[regtime]]'),
('20120323_remove_tracker_reports_from_application_menu_tiki', '[[regtime]]'),
('20120324_add_filegals_icon_tiki', '[[regtime]]'),
('20120401_kaltura_prefs_rename_tiki', '[[regtime]]'),
('20120408_add_forumthread_sefurl_tiki', '[[regtime]]'),
('20120421_autoincementtoautoincrement_tiki', '[[regtime]]'),
('20120422_mime_tiki', '[[regtime]]'),
('20120423_add_page_refs_tiki', '[[regtime]]'),
('20120423_add_status_attr_tiki', '[[regtime]]'),
('20120426_perspectives_menu_entry_tiki', '[[regtime]]'),
('20120426_tiki_db_status_tiki', '[[regtime]]'),
('20120429_fix_collation_tiki', '[[regtime]]'),
('20120510_mailqueue_tiki', '[[regtime]]'),
('20120604_add_holder_to_copyright_tiki', '[[regtime]]'),
('20120628_correct_admin_user_createdate_tiki', '[[regtime]]'),
('20120823_admin_user_credit_menu_entry_tiki', '[[regtime]]'),
('20120823_workspace_template_tiki', '[[regtime]]'),
('20120824_advanced_mode_flag_tiki', '[[regtime]]'),
('20120825_accounting_menu_entry_tiki', '[[regtime]]'),
('20120826_store_metadata_tiki', '[[regtime]]'),
('20120904_category_root_tiki', '[[regtime]]'),
('20120927_add_area_exclusive_and_common_tiki', '[[regtime]]'),
('20120927_add_menu_parse_tiki', '[[regtime]]'),
('20120930_tiki_p_view_poll_choices_tiki', '[[regtime]]'),
('20121009_module_search_box_to_search_tiki', '[[regtime]]'),
('20121016_actionlog_comment_text_tiki', '[[regtime]]'),
('20121027_tracker_samerow_fix_tiki', '[[regtime]]'),
('20121210_add_missing_index_user_assigned_modules_tiki', '[[regtime]]'),
('20121210_better_forum_reported_index_tiki', '[[regtime]]'),
('20121213_module_zone_enlarge_tiki', '[[regtime]]'),
('20130220_wiki_attachments_tiki', '[[regtime]]'),
('20130228_bigger_token_groups_tiki', '[[regtime]]'),
('20130301_sefurl_tracker_type_tiki', '[[regtime]]'),
('20130314_keep_search_pref_settings_tiki', '[[regtime]]'),
('20130322_app_menu_timesheet_pos_tiki', '[[regtime]]'),
('20130322_restore_lost_filegals_tiki', '[[regtime]]'),
('20130328_extend_actionlog_bbb_tiki', '[[regtime]]'),
('20130410_keep_wysiwyg_htmltowiki_setting_tiki', '[[regtime]]'),
('20130415_repair_file_galleries_again_tiki', '[[regtime]]'),
('20130417_score_alter_tiki', '[[regtime]]'),
('20130417_score_tiki', '[[regtime]]'),
('20130419_newsletters_clippings_tiki', '[[regtime]]'),
('20130513_convert_tracker_field_parameters_tiki', '[[regtime]]'),
('20130530_category_log_tiki', '[[regtime]]'),
('20130530_tracker_modification_log_tiki', '[[regtime]]'),
('20130605_mailin_show_inline_tiki', '[[regtime]]'),
('20130606_mailin_add_categoryId_tiki', '[[regtime]]'),
('20130608_convert_mailin_pwd_tiki', '[[regtime]]'),
('20130608_mailin_response_tiki', '[[regtime]]'),
('20130611_mailin_add_html_tiki', '[[regtime]]'),
('20130614_mailin_add_admin_tiki', '[[regtime]]'),
('20130616_mailin_add_namespace_tiki', '[[regtime]]'),
('20130623_create_mailin_user_struct_tiki', '[[regtime]]'),
('20130624_mailin_add_attr_tiki', '[[regtime]]'),
('20130704_catname_tiki', '[[regtime]]'),
('20130705_activity_stream_tiki', '[[regtime]]'),
('20130715_activity_stream_rules_tiki', '[[regtime]]'),
('20130730_friendship_conversion_tiki', '[[regtime]]'),
('20130730_wiki_para_format_default_change_tiki', '[[regtime]]'),
('20130807_tracker_files_display_param_change_tiki', '[[regtime]]'),
('20130809_limit_name_lengths_in_objects_tiki', '[[regtime]]'),
('20131007_menus_items_missing_icons_tiki', '[[regtime]]'),
('20131108_mytiki_add_mailin_tiki', '[[regtime]]'),
('20131117_unified_engine_default_change_tiki', '[[regtime]]'),
('20131218_stored_queries_tiki', '[[regtime]]'),
('20131231_add_sheet_metadata_tiki', '[[regtime]]'),
('20140109_query_unique_name_tiki', '[[regtime]]'),
('20140117_monitor_tiki', '[[regtime]]'),
('20140129_bigger_target_monitor_tiki', '[[regtime]]'),
('20140203_menu_item_and_icon_user_wizard_tiki', '[[regtime]]'),
('20140206_add_parser_column_tiki', '[[regtime]]'),
('20140210_user_wizard_add_section_name_tiki', '[[regtime]]'),
('20140214_goals_tiki', '[[regtime]]'),
('20140219_full_goal_events_tiki', '[[regtime]]'),
('20140301_add_column_rating_choice_topic_on_forums_tiki', '[[regtime]]'),
('20140318_user_wizard_add_groupname_tiki', '[[regtime]]'),
('20140402_mailin_protocol_option_tiki', '[[regtime]]'),
('20140402_payment_authorization_tiki', '[[regtime]]'),
('20140402_remove_mailin_smtp_tiki', '[[regtime]]'),
('20140509_rss_add_categories_tiki', '[[regtime]]'),
('20140625_survey_tiki', '[[regtime]]'),
('20140705_page_slug_tiki', '[[regtime]]'),
('20140807_federated_search_tiki', '[[regtime]]'),
('20140812_convert_tiki_connect_data_to_json_tiki', '[[regtime]]'),
('20140914_addon_profiles_tiki', '[[regtime]]'),
('20141003_change_style_pref_to_theme_tiki', '[[regtime]]'),
('20141106_menu_configuration_panel_tiki', '[[regtime]]'),
('20141114_remove_babelfish_tiki', '[[regtime]]'),
('20141120_tracker_tabular_tiki', '[[regtime]]'),
('20141122_change_prefname_availblestyles_to_availablethemes_tiki', '[[regtime]]'),
('20141125_menu_control_panels_tiki', '[[regtime]]'),
('20150109_tabular_filters_tiki', '[[regtime]]'),
('20150112_theme_option_etc_tiki', '[[regtime]]'),
('20150203_add_menu_option_class_tiki', '[[regtime]]'),
('20150310_rename_freetags_in_menu_42_tiki', '[[regtime]]'),
('20150310_rename_mytiki_in_menu_42_tiki', '[[regtime]]'),
('20150327_tracker_showPopup_option_fix_tiki', '[[regtime]]'),
('20150414_profile_symbol_tooshort_fix_tiki', '[[regtime]]'),
('20150426_menu_item_external_wikis_restored_tiki', '[[regtime]]'),
('20150508_perspectives_style_to_theme_tiki', '[[regtime]]'),
('20150730_menu_item_tabular_trackers_tiki', '[[regtime]]'),
('20150901_prefname_char_length_tiki', '[[regtime]]'),
('20150929_make_hotwords_longer_tiki', '[[regtime]]'),
('20151203_tiki_score_revamp_tiki', '[[regtime]]'),
('20151203_tokens_create_user_tiki', '[[regtime]]'),
('20160120_remove_gmap_menu_item_tiki', '[[regtime]]'),
('20160201_remove_maps_menus_tiki', '[[regtime]]'),
('20160206_theme_option_modules_tiki', '[[regtime]]'),
('20160315_correct_blogpost_encoding_tiki', '[[regtime]]'),
('20160325_menu_42_list_pages_tiki', '[[regtime]]'),
('20160420_correct_blogpost_encoding_tiki', '[[regtime]]'),
('20160519_calendar_events_action_log_tiki', '[[regtime]]'),
('20160527_menu_item_payment_tiki', '[[regtime]]'),
('20160604_remove_unwanted_files_tiki', '[[regtime]]'),
('20160608_menu_item_admin_tokens_tiki', '[[regtime]]'),
('20160627_remove_more_unwanted_files_tiki', '[[regtime]]'),
('20160817_fix_dymanic_list_field_values_tiki', '[[regtime]]'),
('20160914_extwiki_missing_columns_fix_tiki', '[[regtime]]'),
('20160915_extwiki_indexname_length_tiki', '[[regtime]]'),
('20170322_fix_allocate_memory_prefs_tiki', '[[regtime]]'),
('999999991_decode_pages_sources_tiki', '[[regtime]]'),
('99999999_image_plugins_kill_tiki', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_score`
--

CREATE TABLE `tiki_score` (
  `event` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8_unicode_ci,
  `reversalEvent` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`event`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tiki_score`
--

INSERT INTO `tiki_score` VALUES
('tiki.user.login', '[\n	{"ruleId":"User logs in","recipientType":"user","recipient":"user","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.view', '[\n	{"ruleId":"See other user''s profile","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your profile seen","recipientType":"user","recipient":"object","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.friend', '[\n	{"ruleId":"Make friends","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.message', '[\n	{"ruleId":"Send message","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Receive message","recipientType":"user","recipient":"object","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.article.create', '[\n	{"ruleId":"Publish new article","recipientType":"user","recipient":"user","score":"20","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.article.view', '[\n	{"ruleId":"Read an article","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your article read","recipientType":"user","recipient":"author","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.filegallery.create', '[\n	{"ruleId":"Create new file gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.file.create', '[\n	{"ruleId":"Upload new file to gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.file.download', '[\n	{"ruleId":"Download other user''s file","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your file downloaded","recipientType":"user","recipient":"owner","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.imagegallery.create', '[\n	{"ruleId":"Create new image gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.image.create', '[\n	{"ruleId":"Upload new image to gallery","recipientType":"user","recipient":"user","score":"6","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.image.view', '[\n	{"ruleId":"See other user''s image","recipientType":"user","recipient":"user","score":"3","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your image seen","recipientType":"user","recipient":"owner","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blog.create', '[\n	{"ruleId":"Create new blog","recipientType":"user","recipient":"user","score":"20","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blogpost.create', '[\n	{"ruleId":"Post in a blog","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blog.view', '[\n	{"ruleId":"Read other user''s blog","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your blog read","recipientType":"user","recipient":"author","score":"3","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.create', '[\n	{"ruleId":"Create a wiki page","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.update', '[\n	{"ruleId":"Edit an existing wiki page","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.attachfile', '[\n	{"ruleId":"Attach file to wiki page","recipientType":"user","recipient":"user","score":"3","validObjectIds":[""],"expiration":""}\n]', '');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_search_queries`
--

CREATE TABLE `tiki_search_queries` (
  `queryId` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `lastModif` int(11) DEFAULT NULL,
  `label` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `priority` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `query` blob,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`queryId`),
  UNIQUE KEY `tiki_user_query_uq` (`userId`,`label`),
  KEY `query_userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_search_stats`
--

CREATE TABLE `tiki_search_stats` (
  `term` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) DEFAULT NULL,
  PRIMARY KEY (`term`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_secdb`
--

CREATE TABLE `tiki_secdb` (
  `md5_value` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `filename` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `tiki_version` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `severity` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`md5_value`,`filename`(100),`tiki_version`),
  KEY `sdb_fn` (`filename`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tiki_secdb`
--

INSERT INTO `tiki_secdb` VALUES
('723708bd628ddb40ed99e0272ce4718d', './about.php', '15.9', 0),
('8344a8851104023718f925f4aa4c8569', './addons/index.php', '15.9', 0),
('f29b630c1499af7aa047903b1ab6215c', './admin/include_ads.php', '15.9', 0),
('da43b0300551b3aa12c52fb36e7cc437', './admin/include_articles.php', '15.9', 0),
('4b4f6e238895dedf285be980104ddf22', './admin/include_blogs.php', '15.9', 0),
('b0e41be1335edb45d86739158e6a2e06', './admin/include_calendar.php', '15.9', 0),
('eb49e478103f5cc8c82e62a88241103a', './admin/include_category.php', '15.9', 0),
('75987665a78e214da388c9f41d593061', './admin/include_comments.php', '15.9', 0),
('76606920090136af8bf3c0c54b82ade2', './admin/include_community.php', '15.9', 0),
('22b32d024af4f3783bc06677ff5a2d3c', './admin/include_connect.php', '15.9', 0),
('48e6bfc5b365fee258048f1ed0d479b4', './admin/include_copyright.php', '15.9', 0),
('7f2ccf7520e5a86a8d27f543f7e8f9e1', './admin/include_directory.php', '15.9', 0),
('23645e2aad7c33561da3051957ecbe63', './admin/include_faqs.php', '15.9', 0),
('5b2f2bcb2e204c23dbcadb1801a110d5', './admin/include_features.php', '15.9', 0),
('171f77b292ff09177add66b7975ac039', './admin/include_fgal.php', '15.9', 0),
('f6406ceaec6bc99aa3423ca1339e9e95', './admin/include_forums.php', '15.9', 0),
('b65203ba38d7d8e087c3344b7bbfdc24', './admin/include_freetags.php', '15.9', 0),
('cf0a5979a0715f0cbdff878c08a58547', './admin/include_gal.php', '15.9', 0),
('17409b7d8323b0257e7556dc4e406923', './admin/include_general.php', '15.9', 0),
('0f9c57aad741fabe0c8ef5b71256222e', './admin/include_i18n.php', '15.9', 0),
('a89a4d7ea7e38122f93d55cd75e52f32', './admin/include_intertiki.php', '15.9', 0),
('80042de9f0b70e660b6ad1a4cf49d762', './admin/include_login.php', '15.9', 0),
('8b7cb90283bec1c6984497dc505884db', './admin/include_look.php', '15.9', 0),
('2834ceb91222395eca6e42751d3d323a', './admin/include_maps.php', '15.9', 0),
('d28d11be955408ad874074e53377f04b', './admin/include_messages.php', '15.9', 0),
('c1c9e83b0bb5156a1828bb8dec255b01', './admin/include_metatags.php', '15.9', 0),
('41fb224ab16769fe8862ec3e393534f8', './admin/include_module.php', '15.9', 0),
('47938c69c3584de9bcb39f5d6be4ec20', './admin/include_payment.php', '15.9', 0),
('09e63cccb7b1616c6e59dbf928a4a16d', './admin/include_performance.php', '15.9', 0),
('2e41e7ecbfe884da345e0b9abea5f3fb', './admin/include_polls.php', '15.9', 0),
('677a9cf06e9c8bb3fe3a1ed471013b68', './admin/include_profiles.php', '15.9', 0),
('d9f3ec9a16564e9599a66329de781924', './admin/include_rating.php', '15.9', 0),
('892979d14efd279ddf99f32f29643495', './admin/include_rss.php', '15.9', 0),
('f2eee13de9aa754e730570813965ef18', './admin/include_score.php', '15.9', 0),
('ff73b4857f15ba3e16883c66d9378516', './admin/include_search.php', '15.9', 0),
('a2bf24bfd9e82a1255f3307df61b7ff2', './admin/include_security.php', '15.9', 0),
('f5a0b491c699a34ebf76c294a092fa8e', './admin/include_sefurl.php', '15.9', 0),
('00ebc430f4bead367bee55648117923e', './admin/include_semantic.php', '15.9', 0),
('f4091e0c330b3edd2aa7e496fa9fd6e6', './admin/include_share.php', '15.9', 0),
('a0266108578986ac91df3438ad96a4d8', './admin/include_socialnetworks.php', '15.9', 0),
('c934b0ee8e1558db42ebff7e931ce4d5', './admin/include_stats.php', '15.9', 0),
('5539f26e0d999757efe91d2202248b19', './admin/include_textarea.php', '15.9', 0),
('7749b2e4b450c72ccd86880fae8be301', './admin/include_trackers.php', '15.9', 0),
('67cf4d4b5dc4364b00a7e1714238ad76', './admin/include_userfiles.php', '15.9', 0),
('ee9d67ca551ed55d3730d7dad00913d8', './admin/include_video.php', '15.9', 0),
('e6b3d2ac82cb373023b45d2baac4bf93', './admin/include_webmail.php', '15.9', 0),
('16be3039dfcababa693e36cb3c8e6d83', './admin/include_webservices.php', '15.9', 0),
('251e47f18deec8ac42ae554840aa3b2b', './admin/include_wiki.php', '15.9', 0),
('18ac0b364197531d5a05f1093de59997', './admin/include_wikiatt.php', '15.9', 0),
('84b10ad98cc86742f3a28918892319ac', './admin/include_workspace.php', '15.9', 0),
('ab1954986288c0e9724e5dd65f9e8d9a', './admin/include_wysiwyg.php', '15.9', 0),
('c0356dbd6a3b52730a927f5e1df4de26', './admin/index.php', '15.9', 0),
('ec04af362a488c758f112f83dfe22b77', './antibot.php', '15.9', 0),
('9a3dd488b2c53099f7c87899ade28141', './article_image.php', '15.9', 0),
('0946fb6df40e81e844901b6b14190fdd', './banner_click.php', '15.9', 0),
('830d5f0ed743f8850963404fc6a139ca', './banner_image.php', '15.9', 0),
('ba01dd71486b2d636060b021a6070f59', './categorize.php', '15.9', 0),
('3a987e400ee9d550e1ae5eee3242f390', './categorize_list.php', '15.9', 0),
('1bd952f48bea7a09e46dd6e595cf5d7f', './check_composer_exists.php', '15.9', 0),
('c1479743302b5d829297b8164c0c0936', './comments.php', '15.9', 0),
('c66b52ae20099b62342e5b9b81ac409e', './commxmlrpc.php', '15.9', 0),
('cd19554d11b4b3b1147fa894b6026ee5', './console.php', '15.9', 0),
('41907b1be2201671f70d02e29c59c9ef', './contribution.php', '15.9', 0),
('146d9e7c674a622d6725ccb7df793201', './copyrights.php', '15.9', 0),
('4276a0a7f9801e3e92e036b76bf2728a', './db/cert/index.php', '15.9', 0),
('4276a0a7f9801e3e92e036b76bf2728a', './db/config/index.php', '15.9', 0),
('3da82fef2ac687cc55cfae2e8e2ee278', './db/index.php', '15.9', 0),
('9d51fd6dffeb7e9bb0c032ecd6fdfd43', './db/preconfiguration.php', '15.9', 0),
('e2aee7d903ac81adf22a9635b47e712d', './db/tiki-db.php', '15.9', 0),
('33cf8a22684883b6ac9db99f3a73bab1', './db/tiki-secdb_15.5_mysql.sql', '15.9', 0),
('f338a0819190ada5966f65f6eec75442', './db/tiki-secdb_15.6_mysql.sql', '15.9', 0),
('f8080d1bc6c0361b8a98415d1c397296', './db/tiki-secdb_15.7_mysql.sql', '15.9', 0),
('0974ace67ba0458fc6f99dab2a12ceb6', './db/tiki-secdb_15.8_mysql.sql', '15.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './db/tiki-secdb_15.9_mysql.sql', '15.9', 0),
('b9429595e869b3a16fb652a05b42416b', './db/tiki.sql', '15.9', 0),
('899fff16a2f625881b2692f401cfc81e', './db/tiki_1.8to1.9.sql', '15.9', 0),
('0ed7a0c57379173e3bd6581df9444554', './db/tiki_1.9to2.0.sql', '15.9', 0),
('4b8f9e148fbcde0eb48d3bb78e45fa80', './db/tiki_2.0to3.0.sql', '15.9', 0),
('a42fd3b0f3b3c0793d0d176ab7f01b1e', './db/tiki_convert_myisam_to_innodb.sql', '15.9', 0),
('3615eeb274cae64b7ba7ad7f29da31f8', './db/tiki_fulltext_indexes.sql', '15.9', 0),
('73caf883eeb2f4fdb331f37318adc2a1', './db/tiki_innodb.sql', '15.9', 0),
('670af6eafd3a778bd47b98d23498a497', './db/tiki_myisam.sql', '15.9', 0),
('083d60257ba44ae55069b340b4defa61', './display_banner.php', '15.9', 0),
('1925c89e873f73dc168165dfca0b863a', './doc/devtools/20160715_trim50_tracker_permanent_names_for_mysqlfts_tiki.sql', '15.9', 0),
('462f3d1d633cc1e88f2a9b4527ba51ef', './doc/devtools/backup.php', '15.9', 0),
('b8ebd32f5133a11eda6a2dcf859140f0', './doc/devtools/buildincrement.php', '15.9', 0),
('edfd444ae2ced48439e1063ff458c8bb', './doc/devtools/check_filegal_dir.php', '15.9', 0),
('fdbecf3bd4ba1b14c77e3083a9122bed', './doc/devtools/check_tiki-new.php', '15.9', 0),
('272db08d56efe533512f70b4b386706a', './doc/devtools/check_tiki.php', '15.9', 0),
('966ac267f0ee77dba51de323abccd8ef', './doc/devtools/convert_templates_prefs-2.0.php', '15.9', 0),
('bed9e3770fa1404fe8e1e71ef3593a8e', './doc/devtools/convert_tpl_ajax.php', '15.9', 0),
('5e1a1088c4f24c2b38b71004a5b0a148', './doc/devtools/experimental/index.php', '15.9', 0),
('5e1a1088c4f24c2b38b71004a5b0a148', './doc/devtools/experimental/unzip/index.php', '15.9', 0),
('073e6b29f9e0fb01f992ca4033dc883c', './doc/devtools/experimental/unzip/unzipper.php', '15.9', 0),
('8b9b45f62ab9de9332d9e3838ffdd51b', './doc/devtools/export_translations_to_file.php', '15.9', 0),
('09ba82627ed939735bee17bda4e9ca64', './doc/devtools/extract-img-db-to-fs.php', '15.9', 0),
('fd8b124161867c620a6239db95b4a989', './doc/devtools/fix-encoding.php', '15.9', 0),
('d0d4be9db9a05ddb7a1d0edf57e6408f', './doc/devtools/get_translation_percentage.php', '15.9', 0),
('a0beb65bd244cb09d824fefcdffded48', './doc/devtools/ggg-trace.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './doc/devtools/index.php', '15.9', 0),
('f2acbdb4de2663193c5f8e88768cd0e9', './doc/devtools/ks_prefreport.php', '15.9', 0),
('bca5b18a1f93134f5e77f429e907bf60', './doc/devtools/mergelang.php', '15.9', 0),
('99d6a0cc0dde86042e4cdffd7cc7a5aa', './doc/devtools/parse_tiki.php', '15.9', 0),
('aef6649cd6a972098beeed4c31ec9645', './doc/devtools/prefreport.php', '15.9', 0),
('ebdad6cdac8c8595010695ea51237524', './doc/devtools/rebuild_search_index.php', '15.9', 0),
('22be5a61975b081994c24c4b9b04dc5a', './doc/devtools/release.php', '15.9', 0),
('f282fb695dec627454dd0c79390a561e', './doc/devtools/remove_empty_wiki_attachment_filegals.php', '15.9', 0),
('011a12ac7e41956e30c7ba4ca722b014', './doc/devtools/restorehelp.php', '15.9', 0),
('3ccaca5ca247bd88cf0cc530329061d7', './doc/devtools/search_smarty_prefs-2.0.php', '15.9', 0),
('c8eecf70c9c0752fe3345b94357e0e36', './doc/devtools/securitycheck.php', '15.9', 0),
('df586cd612ee30a9bc4a36a223c22687', './doc/devtools/stripcomments.php', '15.9', 0),
('ccf0b98d53374a12ab3f163c2368dc92', './doc/devtools/svnbranch.php', '15.9', 0),
('bde2b50ce7dda122c2348f8197b8da16', './doc/devtools/svnbranchreview.php', '15.9', 0),
('33dc7e0c0bdbc3b92fb25231258f3aff', './doc/devtools/svnbranchupdate.php', '15.9', 0),
('cebff43969f5f710a3e0406d72944ae0', './doc/devtools/svnmerge.php', '15.9', 0),
('38b3ff9fac4a22b7b0cd1b917d630e3e', './doc/devtools/svnswitch.php', '15.9', 0),
('4892d84e52efaf816c6b850eebb96874', './doc/devtools/svntools.php', '15.9', 0),
('41dca2e790e91ce077d0c02757fce3e6', './doc/devtools/svnup.php', '15.9', 0),
('35781c778397593f7c034878cad6c1dd', './doc/devtools/sync.php', '15.9', 0),
('b6e1652a54c02d61b031926c3595944d', './doc/devtools/tiki-create_md5.php', '15.9', 0),
('44c619809d1577aca8cc3d2132405595', './doc/devtools/tiki-show_raw_links.php', '15.9', 0),
('f57391392f494e3eba3ce96f31b67548', './doc/devtools/tiki-sync_ldap.php', '15.9', 0),
('5e1a1088c4f24c2b38b71004a5b0a148', './doc/devtools/tim/index.php', '15.9', 0),
('43ae5c30d1eea13ff6271a34eb9ce1da', './doc/devtools/update_english_strings.php', '15.9', 0),
('214a3022a15d52cb769682000b45ae55', './doc/devtools/upto_4.1_delete_all_cetgory_perms.sql', '15.9', 0),
('d20bb5a10ce694a47c9ddc3a595615e7', './doc/devtools/upto_4.1_drop_unused_4.0_tables.sql', '15.9', 0),
('58572000763181f94d8101a459c40a14', './doc/devtools/upto_7_drop_unused_6.x_tables.sql', '15.9', 0),
('c313a36fa9ab690f74c5f2852284a9f1', './doc/index.php', '15.9', 0),
('5e1a1088c4f24c2b38b71004a5b0a148', './doc/reports/index.php', '15.9', 0),
('900976058a9a4cb79fa14fbf9d40ece5', './dump/index.php', '15.9', 0),
('18feb158aaf39dd32519025c5f60a8f4', './fgal_listing_conf.php', '15.9', 0),
('c161717be9dc792f7e0cb5c0296d58a7', './files/forums/index.php', '15.9', 0),
('9fb5866878e889d4e9f41a7917f6396c', './files/index.php', '15.9', 0),
('c161717be9dc792f7e0cb5c0296d58a7', './files/templates/index.php', '15.9', 0),
('c161717be9dc792f7e0cb5c0296d58a7', './files/templates/listpages/index.php', '15.9', 0),
('58116831bca1f243c4c7e4c565e12efe', './freetag_apply.php', '15.9', 0),
('de47abc8dfd50efc17a2c01696b705a8', './freetag_list.php', '15.9', 0),
('679c1c114f952e1e5e9c58e66d59ac38', './get_strings.php', '15.9', 0),
('1e3d88246d0373614cb5809a2d93cca4', './group_tracker_ajax.php', '15.9', 0),
('85bb8c9d90a81075f0b88c721aa9e873', './help.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/avatars/index.php', '15.9', 0),
('04af087ba7ed44776f5c72bd7457cc14', './img/flags/flagnames.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/flags/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/icons/index.php', '15.9', 0),
('45d657f445e1451cc456756746abfedb', './img/icons/large/index.php', '15.9', 0),
('45d657f445e1451cc456756746abfedb', './img/icons/mime/index.php', '15.9', 0),
('45d657f445e1451cc456756746abfedb', './img/icons/sprite/index.php', '15.9', 0),
('d8c03db8038a0f00b5d503794addf07b', './img/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/openlayers/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/profiles/index.php', '15.9', 0),
('42150b102c18d1b3767655346f8b0ad6', './img/rating_smiles/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/smiles/index.php', '15.9', 0),
('42150b102c18d1b3767655346f8b0ad6', './img/superfish/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/tiki/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/trackers/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/webmail/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/wiki/index.php', '15.9', 0),
('e0b760daedc50eda49c9aacd9ba071f7', './img/wiki_up/index.php', '15.9', 0),
('f33b3d7389ee809ddd2d83313c4fccc5', './index.php', '15.9', 0),
('b78efa0ffaef7a97437d3d00b266efbb', './installer/index.php', '15.9', 0),
('c6d820243b032bae29c64a225de898c8', './installer/installlib.php', '15.9', 0),
('2bb856c10f0c98e0a6e8bc5be5bf7e6b', './installer/schema/00000000_schema_change_tiki.sql', '15.9', 0),
('006c768f38fb584f81a9577977988c40', './installer/schema/20080227_invite_tiki.sql', '15.9', 0),
('5bd2ff4c8ebe71e34e631f8b2782d68b', './installer/schema/20080809_semlinks_tiki.sql', '15.9', 0),
('b7bc39833ff6498a7f2810f6ba477c7c', './installer/schema/20080827_bigfeaturetype_tiki.sql', '15.9', 0),
('2398106f99b68b3767b9719765489233', './installer/schema/20080829_pagealiasdata_tiki.sql', '15.9', 0),
('c4f4acac0dc6cbc2ebfb2f9c0be7e529', './installer/schema/20080829_pluginvalidation_tiki.sql', '15.9', 0),
('b3e9d8bf2668aefc4771dab17d0a24a2', './installer/schema/20080901_pluginvalidation_tiki.sql', '15.9', 0),
('ff79e407ffb5b00ff4d1e89a73c9704a', './installer/schema/20080902_trackerparsedesc_tiki.sql', '15.9', 0),
('7f8b965f930f78a8bddcef926ae47037', './installer/schema/20080905_feature_tip_tiki.sql', '15.9', 0),
('26494582b5aef3ad210554fc8ae1ecbe', './installer/schema/20080916_webservice_registry_tiki.sql', '15.9', 0),
('32603465e3345c4fb4135313fd639fed', './installer/schema/20080922_calendar_customstatus_tiki.sql', '15.9', 0),
('b5ab53b9f57092bca8ea8592fa037f7b', './installer/schema/20080924_webmail_tiki.sql', '15.9', 0),
('a692f6c42ad0de8abb9d754288dec8d2', './installer/schema/20080926_bannerindex_tiki.sql', '15.9', 0),
('bc29e3e80740fc29e33d27defbcbc97f', './installer/schema/20081004_mindmap_menu_tiki.sql', '15.9', 0),
('536631185aad52c71ef92899b5c5b62f', './installer/schema/20081006_comments_moderation_tiki.sql', '15.9', 0),
('97837099f4b69a93e84f567d3c56d257', './installer/schema/20081008_bit_flags_nullable_tiki.sql', '15.9', 0),
('49ed8d384cebe8c438a3f339c1956521', './installer/schema/20081010_filter_perms_tiki.sql', '15.9', 0),
('2e63a1b5e05aab6502e083ce82c0dc79', './installer/schema/20081014_trust_input_perm_tiki.sql', '15.9', 0),
('a360c4d3bf674a0701ab7f4280f5c3a8', './installer/schema/20081018_filter_perms_tiki.sql', '15.9', 0),
('4e4ceee2e728162c861597b2d63964af', './installer/schema/20081019_score_tiki.sql', '15.9', 0),
('9936db192fac5ee273acfe31dec15cf9', './installer/schema/20081022_application_menu_tiki.sql', '15.9', 0),
('9a97cd6ca26d30c0b9d05c4aa537084d', './installer/schema/20081024_fulltext_file_tiki.sql', '15.9', 0),
('8d701d07641ef5d3f7b69d7e6d5a33a9', './installer/schema/20081027_calendar_tiki.sql', '15.9', 0),
('3d53e3b67422f25ff924fbe763538155', './installer/schema/20081027_file_galleries_tiki.sql', '15.9', 0),
('dbfdbfde39917c424944e123e208343b', './installer/schema/20081027_groupalert_tiki.sql', '15.9', 0),
('58df86055cb0233d2b7d32defd83828b', './installer/schema/20081027_surveys_tiki.sql', '15.9', 0),
('9ec9d1e68f44edbf587713bcd1e456c7', './installer/schema/20081027_trackers_tiki.sql', '15.9', 0),
('b716c67361eacf1a987e1bb40f6316ee', './installer/schema/20081027_wysiwyg_history_tiki.sql', '15.9', 0),
('dca26112be92a3177d122e04f6fa959a', './installer/schema/20081029_tracker_index_tiki.sql', '15.9', 0),
('00c60bf6063b7c4d89e0c9ead79abf75', './installer/schema/20081102_application_menu_structures_tiki.sql', '15.9', 0),
('1ef6d37f65c50ed067481f95baf4fd09', './installer/schema/20081105_calendar_items_allday_tiki.sql', '15.9', 0),
('27788e1efb7a90034e8950fd8f4354bd', './installer/schema/20081107_menu42_tiki.sql', '15.9', 0),
('d4c56d850365c4b6acf6ad25b90d4c73', './installer/schema/20081112_tiki_p_tracker_view_comments_tiki.sql', '15.9', 0),
('43d6558ec8576961ad0fa57eea6ec549', './installer/schema/20081114_tiki_banner_tiki.sql', '15.9', 0),
('dafa2c29eca3f81a8cb59ee6208de018', './installer/schema/20081119_tiki_p_export_tracker_tiki.sql', '15.9', 0),
('910db98348db50f457bcd220e6b94d96', './installer/schema/20081120_showCategories_tiki.sql', '15.9', 0),
('b96d9c4717c53493180e1b3bba0448ac', './installer/schema/20081120_tiki_poll_structures_update_tiki.sql', '15.9', 0),
('89c22600772bbf20691a784f5abafb0b', './installer/schema/20081125_tiki_tracker_types_tiki.sql', '15.9', 0),
('c4858dc87e49712ef3bca67407abc8bf', './installer/schema/20081127_calendar_recurrence_tiki.sql', '15.9', 0),
('87e87aca605d69c54c0144768facb548', './installer/schema/20081130_tiki_users_permission_tiki.sql', '15.9', 0),
('fd571504556edc7207bf8dd9b0b1df86', './installer/schema/20081211_newsletter_files_tiki.sql', '15.9', 0),
('fd50074486eece74754eff0e24fa8cc7', './installer/schema/20081211_score_tiki.sql', '15.9', 0),
('419cfa4072a49c9712f047c6d00019e7', './installer/schema/20081212_tiki_p_view_backlinks_tiki.sql', '15.9', 0),
('5671f4746f9ab96caf1673eaabfc8134', './installer/schema/20081214_webservice_post_tiki.sql', '15.9', 0),
('6f4230c895245acccd656a7fdcea3687', './installer/schema/20090106_group_watch_tiki.sql', '15.9', 0),
('6f603625fb97a8d6a22b8d992430e10e', './installer/schema/20090120_sefurl_rules_tiki.sql', '15.9', 0),
('c26a0ce1737db912d15bf60e52b22d1d', './installer/schema/20090129_callendar_search_tiki.sql', '15.9', 0),
('78e3b5aa3c867fa9b6bc5766c70ee9eb', './installer/schema/20090203_null_tiki.sql', '15.9', 0),
('c635a46b0df03ad6549eb3aa555ef0c3', './installer/schema/20090205_forum_and_comments_locking_tiki.sql', '15.9', 0),
('ae4896884f1506b3aef47977d105a445', './installer/schema/20090205_menucase_tiki.sql', '15.9', 0),
('7767c3b7b399c9c01a2687a136c90c6b', './installer/schema/20090205_menus_items_icons_tiki.sql', '15.9', 0),
('500233565a264f3160e0d76034b5bbb2', './installer/schema/20090206_content_tpl_menu_tiki.sql', '15.9', 0),
('70324c0efc3a3fa7d82966f01050c621', './installer/schema/20090206_poll_tiki.sql', '15.9', 0),
('526e7e62f79d0a3a303661f107ab8c50', './installer/schema/20090211_mailnotification_tiki.sql', '15.9', 0),
('7803cbadaa3504e48ab96d2073b85a9f', './installer/schema/20090212_forum_tiki.sql', '15.9', 0),
('b9996cda2a892f43f736e15331321b44', './installer/schema/20090220_admin_section_tiki.sql', '15.9', 0),
('e2e57d5445fccb30772d339a4b6b3e4a', './installer/schema/20090226_admin_menu_tiki.sql', '15.9', 0),
('270f4a015a19424cef2cc35021be8572', './installer/schema/20090301_browsertitle_tiki.sql', '15.9', 0),
('e0d61c3cc6c9b77a755c891d85cb177c', './installer/schema/20090304_tiki_p_view_backlink_without_s_tiki.sql', '15.9', 0),
('f7bd45395c2ff0fd2798e35562df924a', './installer/schema/20090306_menu_perms_tiki.sql', '15.9', 0),
('06fd6cb8f5d2b047ea709ad02c625170', './installer/schema/20090306_text_for_menu_options_tiki.sql', '15.9', 0),
('ce4a78cdeb27a383ce8810ee4fa0d964', './installer/schema/20090310_application_menu_tiki.sql', '15.9', 0),
('cbbffca4f72b5728da74826e7837f286', './installer/schema/20090310_feature_search_show_object_filter_tiki.sql', '15.9', 0),
('667061194dd0bf84dfb4d1dcabeea9b1', './installer/schema/20090311_remove_mod_menu_application_menu_tiki.sql', '15.9', 0),
('956e0e696703ab32441f8ee6f8a6ab77', './installer/schema/20090316_index_tiki.sql', '15.9', 0),
('cbe4979f2306bafb7cbd672dd1cf01d8', './installer/schema/20090323_maxUserImpressions_banners_tiki.sql', '15.9', 0),
('54b66f96391a42d5708064e4ef4c8f97', './installer/schema/20090330_quicktags_renames_tiki.sql', '15.9', 0),
('6b2b361cdf76da968df937fa7376a181', './installer/schema/20090401_newsletters_included_tiki.sql', '15.9', 0),
('39598df227aa9dc8bdadd488df7bbee8', './installer/schema/20090401_replace_shoutjax_with_shoutbox_tiki.sql', '15.9', 0),
('bef61fb68a07da74003ff4afe066c802', './installer/schema/20090401_replace_switch_lang2_with_switch_lang_tiki.sql', '15.9', 0),
('b3dec386fa19bdbbd6572eb1f10a2929', './installer/schema/20090416_plugin_security_tiki.php', '15.9', 0),
('0709621b46eb632b681f02421fe5f492', './installer/schema/20090416_plugin_security_tiki.sql', '15.9', 0),
('c90f5078217322adfb556675fa934a82', './installer/schema/20090416_quicktags_kil_email_tiki.sql', '15.9', 0),
('93c12b32158f54c0633bf753269b6494', './installer/schema/20090416_quicktags_plugin_helpers_tiki.sql', '15.9', 0),
('bf02c6a99bf51c768fa4cd2078bb985b', './installer/schema/20090427_filegal_optionalize_tiki.sql', '15.9', 0),
('55df14def9249a255c63a08a413e8d52', './installer/schema/20090429_groupId_tiki.sql', '15.9', 0),
('47b2e95f6c75fc43dd02ec7cb3d3ce7c', './installer/schema/20090513_calendar_priority_tiki.sql', '15.9', 0),
('d9a996de940eb309bf773b52303d825f', './installer/schema/20090513_swffix_tiki.sql', '15.9', 0),
('32809522a429ac7b66f2f96d06d45a8f', './installer/schema/20090513_wiki_similar_permission_tiki.sql', '15.9', 0),
('4e4ceee2e728162c861597b2d63964af', './installer/schema/20090515_score_tiki.sql', '15.9', 0),
('9b769896b43df599d973fdd73835fb90', './installer/schema/20090602_webmail_protocols_tiki.sql', '15.9', 0),
('442aa44b3f6f263b01edc9228dcad2ce', './installer/schema/20090605_tiki_p_modify_tracker_items_pending_closed_tiki.sql', '15.9', 0),
('337e0cfb80b1d8dc0a41385b9d3ac655', './installer/schema/20090617_add_new_table_for_reports_tiki.sql', '15.9', 0),
('9f92fa8fa2b8160595b2ac1381fae55a', './installer/schema/20090623_actionlog_view_article_tiki.sql', '15.9', 0),
('cb7026c21dbab9aeec235fff9f1a06b6', './installer/schema/20090626_change_pear_auth_preferences_to_ldap_tiki.sql', '15.9', 0),
('420b72a12e9646cae3b236144528f393', './installer/schema/20090707_tiki_p_delete_account_tiki.sql', '15.9', 0),
('ba933dc23124eb6cc7252fa0fceaa90c', './installer/schema/20090713_tiki_importer_permission_and_menu_entry_tiki.sql', '15.9', 0),
('62dd644b6e39e612d19f540e44282414', './installer/schema/20090715_sefurl_for_filegalleries_tiki.sql', '15.9', 0),
('9326744c20da216c4dceeb558095a200', './installer/schema/20090720_perspectives_tiki.sql', '15.9', 0),
('e9b19e102e3eedad9ef8e8f7d032792c', './installer/schema/20090721_webmail_ext_public_tiki.sql', '15.9', 0),
('8139d5f5e562aafc301fe9e64a721c02', './installer/schema/20090727_category_permissions_tiki.sql', '15.9', 0),
('52d147c0e3a28323ddeae7728a6cd2d9', './installer/schema/20090727_user_votings_index_tiki.sql', '15.9', 0),
('628613b2da84a05f443544eaa6b99424', './installer/schema/20090730_p_list_newsletters_tiki.sql', '15.9', 0),
('b92b91a727e9bfb7a7fbe4ad11953a33', './installer/schema/20090803_perspective_permission_tiki.sql', '15.9', 0),
('82f33550024286cdc27d2915604e9158', './installer/schema/20090804_kaltura_permissions_tiki.sql', '15.9', 0),
('d5dc1e57a3396aef995cf2a910469897', './installer/schema/20090804_menu_search_tiki.sql', '15.9', 0),
('f72547e2cb4c194b8fa32d3bec3c9018', './installer/schema/20090805_kill_newsreader_tiki.sql', '15.9', 0),
('cc5c96b09f7b9706036f9bf9b9b73fac', './installer/schema/20090805_remove_drawings_prefs_etc_tiki.sql', '15.9', 0),
('c3f351efc86fb06230ecb11592ed2e9a', './installer/schema/20090805_remove_games_tiki.sql', '15.9', 0),
('cb13f0c90d7565566ffddedd17449dc0', './installer/schema/20090806_group_permissions_tiki.sql', '15.9', 0),
('4fffdf190d26d20a72f384036f924cbf', './installer/schema/20090806_menu_list_trackers_tiki.sql', '15.9', 0),
('2ac3852a87ef99e70fd38dceafcfac46', './installer/schema/20090806_perms_featurechecks_tiki.sql', '15.9', 0),
('ee38952775b551eacf1bb72da93c5acb', './installer/schema/20090806_remove_charts_tiki.sql', '15.9', 0),
('8b5d955462daed16192cd422fc514590', './installer/schema/20090806_remove_latin_collations_tiki.sql', '15.9', 0),
('e1e6b59348c4e6ceb064d2af676b3620', './installer/schema/20090806_strasa_option_rename_tiki.sql', '15.9', 0),
('622a095687c3338868e18dc51cbcf547', './installer/schema/20090807_transitions_tiki.sql', '15.9', 0),
('6adbc7a739c0fd262f6600bfc9630510', './installer/schema/20090808_add_wiki_minor_edits_tiki.sql', '15.9', 0),
('0067c2b32ca47ce7b42ea5d45f64cdf4', './installer/schema/20090809_marc_needs_more_space_tiki.sql', '15.9', 0),
('e0a7048d37a6f4ae95fe246a70935e6f', './installer/schema/20090811_filegals_container_tiki.sql', '15.9', 0),
('90cbc20466a1dcd55a42f4532099a4b3', './installer/schema/20090811_kaltura_editor_pref_tiki.sql', '15.9', 0),
('0c64b4b6661d1601b4b1d847b1e6810c', './installer/schema/20090811_quizzes_tiki.sql', '15.9', 0),
('b97dac6447ab14c1278a80bfef18d0d6', './installer/schema/20090811_rename_quicktags_to_toolbars_tiki.sql', '15.9', 0),
('4795abe4f54b97fe2fe1e851d1665031', './installer/schema/20090823_kaltura_menu_options_tiki.sql', '15.9', 0),
('4c19a550fa670b8680b4536491de9f58', './installer/schema/20090826_group_expiration_tiki.sql', '15.9', 0),
('c456caa0febc6f77a02d7202820b6878', './installer/schema/20090904_wysiwyg_newsletters_tiki.sql', '15.9', 0),
('055a4c9f0da1ea66388257c95851fd37', './installer/schema/20090911_tracker_item_change_user_tiki.sql', '15.9', 0),
('647c88b4faa510131fd775b6fd494129', './installer/schema/20090912_change_feature_name_for_lesser_magic_tiki.sql', '15.9', 0),
('97dea83392a7fde1ab54f1ce3df0f26a', './installer/schema/20090913_plugin_security_addedby_tiki.sql', '15.9', 0),
('fd23b4fc2cb7b31f09fcd533ec21f264', './installer/schema/20090915_change_perms_for_browse_cats_tiki.sql', '15.9', 0),
('1f07cce9c277e528d55fb4554f28cea1', './installer/schema/20090921_logo_tiki.sql', '15.9', 0),
('9fe55cfcde1a8df105cfcf1bda9d14a0', './installer/schema/20090923_mod_change_category_defaults_tiki.php', '15.9', 0),
('f580a5bdef3c93176c9fcc963d6f7ee5', './installer/schema/20090925_online_logged_users_modules_merge_tiki.sql', '15.9', 0),
('b74f2d4a9ac9b184868809defef17b9e', './installer/schema/20090927_top_images_modules_merge_tiki.sql', '15.9', 0),
('d581271bb2b939b62a9c7d3468d71363', './installer/schema/20090928_galaxia_leftovers_tiki.sql', '15.9', 0),
('a9b31268ede9a9d19bad4b3e9a560858', './installer/schema/20090928_last_images_modules_merge_tiki.sql', '15.9', 0),
('47512729ed5702c29ebf674158b7dd22', './installer/schema/20090928_transition_guards_text_tiki.sql', '15.9', 0),
('60871c4e9be0612e31483ea7afae82a8', './installer/schema/20091004_last_tracker_items_modules_merge_tiki.php', '15.9', 0),
('566e10ed8016fd2ae2e77017a6af5bc5', './installer/schema/20091007_update_database_structure_tiki.sql', '15.9', 0),
('44c61ac918cc1385b7640393c138efff', './installer/schema/20091008_reg_group_includes_anon_tiki.sql', '15.9', 0),
('1a6e2252aefc8b4549eea766c4681418', './installer/schema/20091011_serurl_dl_order_tiki.sql', '15.9', 0),
('2e691f9f536276faf13b3e7708f77863', './installer/schema/20091013_fix_perms_tiki.sql', '15.9', 0),
('c7ca3defd20741232a8c11b89d2250ab', './installer/schema/20091015_application_menu_admin_renames_tiki.sql', '15.9', 0),
('273bebc06180dcf99c0fbb6f57f32cae', './installer/schema/20091016_categorization_tracker_item_tiki.sql', '15.9', 0),
('b3038876c7512d1a386e3206c541e089', './installer/schema/20091019_article_by_rating_modules_merge_tiki.php', '15.9', 0),
('c88b798a0e10de45431da756980f4d01', './installer/schema/20091019_last_articles_modules_merge_tiki.php', '15.9', 0),
('f8cef1ce28764cf186963efb6e754b6d', './installer/schema/20091019_users_perms_types_tidying_tiki.sql', '15.9', 0),
('cea39d8b633ccf21c530eb38dc8d5d4d', './installer/schema/20091020_bigger_user_prefs_tiki.sql', '15.9', 0),
('97f2e29237a5f2f66a8d68ef1d519aa9', './installer/schema/20091020_faq_created_tiki.sql', '15.9', 0),
('d64f44fb2fc4a66091c7f084278da4f0', './installer/schema/20091020_kaltura_tiki.sql', '15.9', 0),
('849edab4e7d7fdec986089032840ef2c', './installer/schema/20091020_remove_charts_tiki.sql', '15.9', 0),
('87b5cd3a5894c73bc20c2351b549d774', './installer/schema/20091020_sefurl_trackeritem_tiki.sql', '15.9', 0),
('89456db508a7a0d97200907f83c143b0', './installer/schema/20091021_moz_pagelist_tiki.sql', '15.9', 0),
('de6aa476f72445aa4dae312681ce9ebb', './installer/schema/20091023_bookmarks_name_lengthen_tiki.sql', '15.9', 0),
('4ebf9ad2bf9cc6d3e0c6046a38cd3096', './installer/schema/20091023_nul_categ_tiki.sql', '15.9', 0),
('a149de4e5b9d725180961926b6732bb9', './installer/schema/20091023_report_tiki.sql', '15.9', 0),
('345569753d67064166061deda3c47e34', './installer/schema/20091027_multiple_session_handler_tiki.sql', '15.9', 0),
('b3db4a3b28d2e6ca3751e7fdfd22a7a9', './installer/schema/20091028_quota_tiki.sql', '15.9', 0),
('a278b9df0b6b039001b9219863cb7625', './installer/schema/20091030_wiki_watch_tiki.sql', '15.9', 0),
('1b8a0a6e82679de283e65e8b560200e6', './installer/schema/20091103_upgrade_categperm_tiki.php', '15.9', 0),
('268e0ceff0dcf5af18ef2c9da6517cde', './installer/schema/20091105_auth_tokens_tiki.sql', '15.9', 0),
('f1570b8fd47a0dca223a15382da22709', './installer/schema/20091111_fgal_size_tiki.sql', '15.9', 0),
('7bd8ac55be14e25c7120a26f23eff436', './installer/schema/20091112_rename_mnu_application_menu_tiki.sql', '15.9', 0),
('712125292ff84ad268db796e12d0d860', './installer/schema/20091112_template_type_tiki.sql', '15.9', 0),
('7b18ad1124c4793f68eee26efecc6c15', './installer/schema/20091113_old_categ_perm_tiki.sql', '15.9', 0),
('cbeebd65f32c65d2171b5afe3cb0bb88', './installer/schema/20091118_sefurl_tiki.sql', '15.9', 0),
('893c7f6e4e519c67adc07265daffd31d', './installer/schema/20091120_poll_lookup_index_tiki.sql', '15.9', 0),
('df8cef1f416acca82b52e30e6094aadd', './installer/schema/20091120_username_pattern_tiki.sql', '15.9', 0),
('3e981f300423d52b094778c83e513245', './installer/schema/20091123_dns_permission_tiki.sql', '15.9', 0),
('483a3492ca6307f43c5c44e34f5626ae', './installer/schema/20091123_metrics_tiki.sql', '15.9', 0),
('14dd6e13511e9b0656b8e1aa23654c14', './installer/schema/20091123_upgrade_categperm_2_tiki.php', '15.9', 0),
('12a347caeff47151488740cd2a4fe055', './installer/schema/20091124_fgal_backlink_tiki.sql', '15.9', 0),
('5b47492ea791031cf119ac3daf791f97', './installer/schema/20091124_metrics_dsn_tiki.sql', '15.9', 0),
('c070d97d1927459c781cd75887f40d11', './installer/schema/20091125_wiki_comments_per_page_tiki.sql', '15.9', 0),
('94d90cb820a65bdb9a64cb0d2396a643', './installer/schema/20091126_dynamic_variables_i18n_tiki.sql', '15.9', 0),
('5cb9af495c32baaab1a4c975d8cceaef', './installer/schema/20091204_filegal_wiki_syntax_tiki.sql', '15.9', 0),
('a72f40dc524ffce5390afc15923cb78f', './installer/schema/20091204_tiki_p_view_newsletter_tiki.sql', '15.9', 0),
('bb96171d83b521a6699b6cb1630c178e', './installer/schema/20091208_backlink_perms_tiki.sql', '15.9', 0),
('8e295076a1387fd3d68c8a0e23066c7a', './installer/schema/20091209_rss_feeds_name_tiki.sql', '15.9', 0),
('a5044acc14e9a7efe50944b93917d7b2', './installer/schema/20091210_charset_tiki.sql', '15.9', 0),
('d617149349d294764b6820ed8d412244', './installer/schema/20091210_dcs_type_tiki.sql', '15.9', 0),
('7cee7ba62911c48b3850532fbc1cbd8c', './installer/schema/20091214_perspective_management_tiki.php', '15.9', 0),
('c275deb83663a95e4265677d33bda5de', './installer/schema/20091214_perspective_management_tiki.sql', '15.9', 0),
('ec2eeddd35627137e13ae7eef8c18f4c', './installer/schema/20091216_show_backlinks_tiki.sql', '15.9', 0),
('bff553fae8d722d9c239714e9e75f369', './installer/schema/20091228_page_keywords_tiki.sql', '15.9', 0),
('5b547103c6c3720dfd46515f3dc4b9cf', './installer/schema/20100101_search_modules_merge_tiki.sql', '15.9', 0),
('2e4b473f1a5ab5dbbf7933ddbb7e2cf4', './installer/schema/20100101_search_wiki_page_modules_merge_tiki.sql', '15.9', 0),
('6b8a6f903619170fc06b5e21acb8a88d', './installer/schema/20100104_tiki_p_tracker_revote_ratings_tiki.sql', '15.9', 0),
('3cbd0d19bfef3b685a304e96902656d8', './installer/schema/20100106_forum_att_list_nb_tiki.sql', '15.9', 0),
('8909c5619e1f9825829ca6e73fef69d3', './installer/schema/20100107_payment_tiki.sql', '15.9', 0),
('0e531e6cd9f6bc248c9e940afcdce1c9', './installer/schema/20100113_forum_display_tiki.sql', '15.9', 0),
('3e8c5924e3563c9f15474662ed5165c5', './installer/schema/20100114_tiki_actionlog_merge_tiki.sql', '15.9', 0),
('8b23e2a3a3dc1aa2bd6be6650005e50e', './installer/schema/20100115_admin_modules_menu_tiki.sql', '15.9', 0),
('69a98c55dfdb0639be58af44be275639', './installer/schema/20100115_tiki_p_admin_modules_tiki.sql', '15.9', 0),
('b6ae85c6847322df833836d4f1f5d013', './installer/schema/20100115_translations_in_progress_tiki.sql', '15.9', 0),
('42a4ae39d6d4045d0e4d96fd785fd620', './installer/schema/20100117_old_doc_tw_o_url_tiki.sql', '15.9', 0),
('a7311875283acb4a98ea9210ff9588ba', './installer/schema/20100118_blog_use_author_tiki.sql', '15.9', 0),
('79e3b88f76c6ced0918f76d5b6665578', './installer/schema/20100118_forum_display_tiki.sql', '15.9', 0),
('2ea1308ff02955c7b6656076301299ab', './installer/schema/20100126_file_lastDownload_tiki.sql', '15.9', 0),
('68f8d2e78cc73e8562839970ba92a70d', './installer/schema/20100128_tiki_p_blog_view_ref_tiki.sql', '15.9', 0),
('6f2fff9200d779aabaf21e7144b5ecdd', './installer/schema/20100129_clean_up_tiki.sql', '15.9', 0),
('7413da3b3b575abed3464e09b768a080', './installer/schema/20100129_events_kil_tiki.sql', '15.9', 0),
('c66c9f9a5d2d14ae38ac664738d0836d', './installer/schema/20100203_payment_detail_tiki.sql', '15.9', 0),
('888c53dd6f29cd376fde45828fc8d69d', './installer/schema/20100205_tiki_p_wiki_view_ref_tiki.sql', '15.9', 0),
('5a94b04a57f9d43e4e5b280f2285fe76', './installer/schema/20100207_repair_file_galleries_tiki.php', '15.9', 0),
('2934b25f69d3b260887455284954a1ed', './installer/schema/20100211_rss_items_tiki.sql', '15.9', 0),
('350aff4b5e0a30d274134424b0788327', './installer/schema/20100211_tiki_perms_menu_item_tiki.sql', '15.9', 0),
('3fcab51527f14091b72a61862d375c45', './installer/schema/20100211_tiki_sheet_add_parseValues_tiki.sql', '15.9', 0),
('f2596badf24baf56d10e2c6789213960', './installer/schema/20100212_rss_automation_tiki.sql', '15.9', 0),
('b8760600ba1e21e712f362e63befac45', './installer/schema/20100213_group_inclusion_key_tiki.sql', '15.9', 0),
('c517e0b264751804c7ff41e37f1a413c', './installer/schema/20100214_workspaces_remove_menu_items_tiki.sql', '15.9', 0),
('f9f70e45d4aba2e18b5efbf4e173bc84', './installer/schema/20100215_create_tiki_user_login_cookies_tiki.sql', '15.9', 0),
('54cc4bcc3ffa4453554c3ce8b06fecc3', './installer/schema/20100215_rating_permissions_tiki.sql', '15.9', 0),
('61f764609054bba7654e372b4b3b9198', './installer/schema/20100216_attributes_tiki.sql', '15.9', 0),
('36037bd886a0e5868c5fe59c337f6c2e', './installer/schema/20100216_kil_moz_screencast_tiki.sql', '15.9', 0),
('8a232ebfe1aff7c6a9cc6ad47b88a4cf', './installer/schema/20100216_rename_tikisheet_tiki.sql', '15.9', 0),
('57b882c76446cb0f321f972c4bc060e8', './installer/schema/20100217_rating_config_tiki.sql', '15.9', 0),
('62a29f5266842c3aafc5e77ca31a4b3f', './installer/schema/20100218_auth_token_reuse_tiki.sql', '15.9', 0),
('0dcee212645ce8000ad216d6bf812c2e', './installer/schema/20100222_add_webmail_fromEmail_field_tiki.sql', '15.9', 0),
('5cf4ae8252efbc6fc53560fb1855fbd6', './installer/schema/20100222_sheet_toolbar_default_tiki.sql', '15.9', 0),
('01714f7d35dd064f2ea3075ea8046096', './installer/schema/20100223_blog_always_owner_tiki.sql', '15.9', 0),
('7f1e29c8442ea45d77b1d4e2e5a2c5d8', './installer/schema/20100224_object_relations_tiki.sql', '15.9', 0),
('9a60dd3d2db1b9e7a0187a818ef08d7a', './installer/schema/20100226_menu_template_feature_check_tiki.sql', '15.9', 0),
('ce7a80dc86bcabf4372e9745cce0e440', './installer/schema/20100226_tracker_dump_perm_tiki.sql', '15.9', 0),
('a1191e4c09d52e1886507e62e6573994', './installer/schema/20100302_filegal_images_max_sizes_tiki.sql', '15.9', 0),
('bf751d0e1c3ad816fbdd7e612c1880db', './installer/schema/20100308_file_delete_after_tiki.sql', '15.9', 0),
('902b64fe934469ed98341678a7840245', './installer/schema/20100309_add_sheet_parent_tiki.sql', '15.9', 0),
('6164442730abf0ff4849170a5c90dbda', './installer/schema/20100312_emailPattern_tiki.sql', '15.9', 0),
('3c97d38fb32ce744185b6ff04d58fa0d', './installer/schema/20100324_newsletters_clippings_tiki.sql', '15.9', 0),
('8d0e67468c13d44ce90601a230c7fd68', './installer/schema/20100409_bigger_module_params_tiki.sql', '15.9', 0),
('4177492c2f4ee3bfbe97c90f38ae0626', './installer/schema/20100414_actionlog_pref_tiki.sql', '15.9', 0),
('f2e50c371c67658571f3290165beff43', './installer/schema/20100414_actionlog_system_tiki.sql', '15.9', 0),
('bbaebffa62af9ccfc56bcece0793b7e0', './installer/schema/20100419_bigbluebutton_tiki.sql', '15.9', 0),
('b58b594e873ea23c88f75f30277ebe0f', './installer/schema/20100422_tracker_log_tiki.sql', '15.9', 0),
('308355b22eed6e20d83a812cf0462fd0', './installer/schema/20100429_newsletter_pages_tiki.sql', '15.9', 0),
('8f15f1dccbfa6e8668425a3ed6a33705', './installer/schema/20100507_flash_banner_tiki.php', '15.9', 0),
('1b5f530a959dd6c18375fdacf258c03e', './installer/schema/20100519_actionlog_tiki.sql', '15.9', 0),
('f7f3a83c028f4a1afbc5e4ad922386fb', './installer/schema/20100525_tracker_validation_message_tiki.sql', '15.9', 0),
('50075186c65a27d7a0eee7962f0f0862', './installer/schema/20100525_tracker_validation_tiki.sql', '15.9', 0),
('c85d90ed2ab759856b41dc3d705f7a96', './installer/schema/20100611_rss_items_url_tiki.sql', '15.9', 0),
('4cb7c699ac79b750404f413e18841472', './installer/schema/20100617_sefurl_user_info_tiki.sql', '15.9', 0),
('7a887d3c80359db3c7baf7a18b4a51d0', './installer/schema/20100618_calendar_participation_tiki.sql', '15.9', 0),
('2c666df90eaaa04fb2ee6d1928b38814', './installer/schema/20100621_pageprefixaliasdata_tiki.sql', '15.9', 0),
('838bb67100b2ef14a12db5d8f026fe24', './installer/schema/20100622_pageprefixtrackeritemid_tiki.sql', '15.9', 0),
('07bea2047559da9a3878b1a50a596d91', './installer/schema/20100623_semantic_to_relation_tiki.php', '15.9', 0),
('4673960aa9da0b18682403cb6be37d5a', './installer/schema/20100623_semantic_to_relation_tiki.sql', '15.9', 0),
('690f54a7ae99b145b7fdda6c8df6d1b8', './installer/schema/20100624_banning_index_tiki.sql', '15.9', 0),
('49f703eb7f92a2ecf5d8cd7e127dd02e', './installer/schema/20100628_payment_user_tiki.sql', '15.9', 0),
('687f64c286450f0fe0de1cfbf05c3d0e', './installer/schema/20100629_remove_feature_blog_comments_tiki.sql', '15.9', 0),
('ab1c9da67c601119962b5a37f0843f25', './installer/schema/20100702_discount_tiki.sql', '15.9', 0),
('1cd43cc0c8d523dc0e9d7dda5e6fd25f', './installer/schema/20100712_remove_unsupported_feed_formats_tiki.sql', '15.9', 0),
('19adc11a5cc9a329cedc5f84f4f90e61', './installer/schema/20100713_rename_feed_prefs_tiki.sql', '15.9', 0),
('91725fe31a54b7681540807302be4a48', './installer/schema/20100714_batch_transition_tiki.sql', '15.9', 0),
('e62cac7f6a4bc314978ee2ac087d67a7', './installer/schema/20100716_user_selector_pref_rename_tiki.sql', '15.9', 0),
('a0719690681cf54c6ecdddeda600dc28', './installer/schema/20100720_tiki_p_view_page_contribution_tiki.sql', '15.9', 0),
('7fbf99c2db7f32abaa339668cbcd06d3', './installer/schema/20100721_batch_transition_rollback_tiki.sql', '15.9', 0),
('0263d633a37436a9da9e83bae8c6a005', './installer/schema/20100721_todo_tiki.sql', '15.9', 0),
('57eb1c692598aebcc6f6c62be8267419', './installer/schema/20100721_todonotif_tiki.sql', '15.9', 0),
('5b12e1bc1238983e0fd1ced13c876eb0', './installer/schema/20100727_tiki_p_promote_page_tiki.sql', '15.9', 0),
('c3049a9ad85d934d80509f1bce54ed56', './installer/schema/20100730_list_image_article_tiki.sql', '15.9', 0),
('5b0a22957d84f831f300f0040aeeb6a0', './installer/schema/20100802_tiki_p_share_tiki.sql', '15.9', 0),
('31fa326bbce1b86470fd1ffab2e2d3be', './installer/schema/20100802_url_shortener_tiki.sql', '15.9', 0),
('44806754ed381ae3a982f7837e49bccd', './installer/schema/20100804_remove_tiki_languages_tiki.sql', '15.9', 0),
('d25e77ce8d4571079e175bc6c47396f2', './installer/schema/20100806_blog_posts_header_tiki.sql', '15.9', 0),
('fc4de3ac7012ea438e14cb5cafa43144', './installer/schema/20100807_alter_tiki_translate_fields_to_text_tiki.sql', '15.9', 0),
('7ef9c8bb7582170a536f47932aee91d4', './installer/schema/20100810_title_comments_upgrade_tiki.sql', '15.9', 0),
('8df0894c777a22e016d7c86adeb5c21a', './installer/schema/20100812_blog_control_max_related_content_tiki.sql', '15.9', 0),
('3ea3be26f5d40cf2edd81abd799ba344', './installer/schema/20100812_blog_show_related_content_tiki.sql', '15.9', 0),
('31c1a0ef9f413ab92ceb6bfe4523fbe3', './installer/schema/20100817_add_email_and_website_fields_to_comments_tiki.sql', '15.9', 0),
('1c2a372fab7bddcf1ae656be318b9747', './installer/schema/20100817_credits_tiki.sql', '15.9', 0),
('5d2cc4aa05385cfc2eba8ac701ae148e', './installer/schema/20100817_rename_preference_wiki_comments_notitle_tiki.sql', '15.9', 0),
('4a3d0c92c69fb3dcc0b9770d62d27c71', './installer/schema/20100818_watch_tiki.sql', '15.9', 0),
('2759ff42a931fce14c367e87ae4c0331', './installer/schema/20100820_blog_posts_wysiwyg_tiki.sql', '15.9', 0),
('31bcc44f8cb269593a399ee00313995e', './installer/schema/20100820_feed_fields_text_and_desc_are_not_empty_tiki.sql', '15.9', 0),
('8d0992f78c263a025ccbd605f6fb7262', './installer/schema/20100824_blog_post_excerpt_tiki.sql', '15.9', 0),
('e2a19962bed53701d9998d7c4434a85d', './installer/schema/20100825_add_changed_column_to_tiki_language_table_tiki.sql', '15.9', 0),
('f0f6af415f67e26aee90c86b87dbf387', './installer/schema/20100825_remove_blog_option_use_title_tiki.sql', '15.9', 0),
('890a3d6accb68581f7d00ebd2c347c1e', './installer/schema/20100830_sheet_add_styles_and_classes_tiki.sql', '15.9', 0),
('560834495744de5dc66690afea1a7626', './installer/schema/20100831_freetag_tiki.sql', '15.9', 0),
('47ed97c0106c3693caa30a0e2ba418fb', './installer/schema/20100901_duplic_actionlog_tiki.sql', '15.9', 0),
('d1f95ffd6ff3f55516c7ff77e3d51297', './installer/schema/20100901_expire_tiki.sql', '15.9', 0),
('4911e367a33cab5c27e0c206a0e6dbdc', './installer/schema/20100902_invit_tiki.sql', '15.9', 0),
('c2b3511dc21a90f27e01a2b270b36ff4', './installer/schema/20100903_article_ispublished_tiki.sql', '15.9', 0),
('57ba839a9b670ba2d383e95875842a79', './installer/schema/20100906_sheet_toolbar_default_tiki.sql', '15.9', 0),
('f61a018b959a88de7c3ff07f5933403e', './installer/schema/20100909_alter_tiki_language_fields_to_text_tiki.sql', '15.9', 0),
('c683eda8812e428e63b7fe0812a93526', './installer/schema/20100909_ckeditor_upgrade_tiki.sql', '15.9', 0),
('0d2cdf85fdd09e62d49b8f21ce1e0b48', './installer/schema/20100909_lengthen_wiki_attachments_filename_tiki.sql', '15.9', 0),
('c2c91b87c9818a362b19af7d95361bee', './installer/schema/20100910_new_fields_for_tiki_blogs_tiki.sql', '15.9', 0),
('de4d46f4cc1e55843ee4fb763f1bfbb2', './installer/schema/20100912_rename_autosave_pref_tiki.sql', '15.9', 0),
('ceb893e4b41453e3f40e6f49740694a8', './installer/schema/20100915_add_edit_languages_menu_option_tiki.sql', '15.9', 0),
('b013ef3769d8303ade0931d40bcadbbe', './installer/schema/20100919_tiki_page_contribution_tiki.sql', '15.9', 0),
('9628e595d2392ac509aa9a851b416822', './installer/schema/20100920_ckeditor_remove_pref_tiki.sql', '15.9', 0),
('ea7b94f6c26c78f9cfe9914004b126a2', './installer/schema/20100920_jq_sheet_remove_pref_tiki.sql', '15.9', 0),
('0f0e8d6edd889f948074b5c58eb706d3', './installer/schema/20100920_todo_event_tiki.sql', '15.9', 0),
('0a44187ddda66fb57a8e37de3c683697', './installer/schema/20100923_fix_column_position_tiki.sql', '15.9', 0),
('70deaf3aecb55eff018d3f3d692a7838', './installer/schema/20100923_social_networking_permission_and_menuitem_tiki.sql', '15.9', 0),
('15b3ea9e0602ba476f14eca5ed031f62', './installer/schema/20100925_fix_some_default_value_tiki.sql', '15.9', 0),
('e0e72ee0ab9a712a3e9879b66ebba82e', './installer/schema/20100927_better_column_fix2_tiki.php', '15.9', 0),
('9ba57ed4e2d85eeadb1aa4c463ca143b', './installer/schema/20100927_better_column_fix_tiki.php', '15.9', 0),
('7078f85293d9b2df64d6b783fd69a8f9', './installer/schema/20100928_sefurl_regex_reordering_tiki.sql', '15.9', 0),
('b319e7d8b377939e46e5c59fbbfc9cdb', './installer/schema/20101008_user_id_for_tiki_language_tiki.sql', '15.9', 0),
('aa530de5c60b975c437300e3789b2f88', './installer/schema/20101014_tiki_language_add_lastModif_column_tiki.sql', '15.9', 0),
('d982ed41cbf120d9b6c2ebe5ac7e2813', './installer/schema/20101015_tiki_admin_perms_tiki.sql', '15.9', 0),
('f641cc4bf74fb2e9ff547e1aac5c17ae', './installer/schema/20101021_rename_blog_post_comment_object_type_tiki.sql', '15.9', 0),
('ae10d405e50604c62961ff3f82c58fdb', './installer/schema/20101025_fgal_show_deleteAfter_tiki.sql', '15.9', 0),
('0a0afe6962bb24e3d73b2c9409e54fcd', './installer/schema/20101025_profile_sources_pref_tikiwiki_to_tiki.sql', '15.9', 0),
('8d475ba6cabe360e56d29efdbea5e905', './installer/schema/20101025_rename_create_blog_menu_entry_tiki.sql', '15.9', 0),
('3e70698041a57203ad6063378c85984a', './installer/schema/20101026_auth_token_add_columns_tiki.sql', '15.9', 0),
('6497387d0c7806b7aa2427ebef94f37b', './installer/schema/20101027_add_file_gallery_columns_tiki.sql', '15.9', 0),
('228fe45691621f0bb44c70c86a2313c4', './installer/schema/20101027_rename_invit_to_invite_tiki.sql', '15.9', 0),
('8c9d09f4bcecefe64b6610e390492a55', './installer/schema/20101028_p_invit_tiki.sql', '15.9', 0),
('06adc57267b54f62d81f7045853d2842', './installer/schema/20101110_actionlog_tiki.sql', '15.9', 0),
('b61f72f5e9c94f9868f641b673f08ec9', './installer/schema/20101117_actionlog_tiki.sql', '15.9', 0),
('18252b1f4851a73f05c7108718b95836', './installer/schema/20101119_categ_perm_tiki.sql', '15.9', 0),
('16397ba8ee5c4358301a28cde756c566', './installer/schema/20101126_fgal_add_gallerie_user_tiki.php', '15.9', 0),
('c0889acb88741573ccf4b8c532e35937', './installer/schema/20101130_recreate_tiki_accounting_tables_tiki.sql', '15.9', 0),
('665d1af813204e3970726a4dcdff77ca', './installer/schema/20101130_tiki_accounting_tiki.sql', '15.9', 0),
('f4f667d5a0393718c980cf83fe5be0a6', './installer/schema/20101201_tiki_accounting_fix_index_tiki.sql', '15.9', 0),
('ab434bc67f52b72a28cce6ab0ae0d351', './installer/schema/20101203_fgal_archive_default_tiki.sql', '15.9', 0),
('9d6fdac3ebb63a29a4a6fc67e925d9f7', './installer/schema/20101207_feature_file_drafts_tiki.sql', '15.9', 0),
('a46381a5a632a1c933b5e776c39fee0d', './installer/schema/20101208_webservice_soap_tiki.sql', '15.9', 0),
('596f113937a8ba9ef309c1c422044d85', './installer/schema/20101210_fgal_add_wiki_attachments_tiki.php', '15.9', 0),
('dd5468fab59af87a2aa1d9d86c46d125', './installer/schema/20101210_sync_users_ldap_tiki.sql', '15.9', 0),
('5058136507b87f7dad9221c554f053b4', './installer/schema/20101211_filegal_maxhits_column_tiki.sql', '15.9', 0),
('d20488731541266f57e9e9102e472886', './installer/schema/20101211_kil_feature_phplayers_tiki.php', '15.9', 0),
('f6e3f8d12dc1ab16f9b8375f553a64be', './installer/schema/20101215_remove_files_tiki.sql', '15.9', 0),
('56bd633ebe67ea8013b7263320d9d442', './installer/schema/20101215_template_file_galleries_tiki.sql', '15.9', 0),
('3de83e0ba0fb478781deadea680de629', './installer/schema/20101219_kill_feature_mobile_tiki.sql', '15.9', 0),
('31f872c8abc7e3bc2b8a385a50fec44e', './installer/schema/20101230_create_top_modules_tiki.php', '15.9', 0),
('4ee4898cf36420a15d9bce153645e92d', './installer/schema/20110103_include_in_history_tiki.sql', '15.9', 0),
('24ff523ffad872d3ce90571ce0d70702', './installer/schema/20110104_flagged_revision_log_tiki.sql', '15.9', 0),
('80bf3571ece806c22a7c99ca3fbd8e20', './installer/schema/20110104_sefurl_trackeritem_again_tiki.sql', '15.9', 0),
('80bf3571ece806c22a7c99ca3fbd8e20', './installer/schema/20110104_sefurl_trackeritem_tiki.sql', '15.9', 0),
('83e49b253f0a00059a979cd3a88a6343', './installer/schema/20110112_approval_permissions_tiki.sql', '15.9', 0),
('84d48cff287b3330c0a0f64dcc5983dc', './installer/schema/20110115_create_bottom_modules_tiki.php', '15.9', 0),
('0b0ad5da10e9c802b02aff9be0e603a7', './installer/schema/20110118_p_remove_tracker_items_tiki.sql', '15.9', 0),
('c55afd33b7db3e2822c266655eee7aa7', './installer/schema/20110124_update_sheet_to_support_cloning_tiki.sql', '15.9', 0),
('fa1eec6ab5a82d4c754190013e2e1b4d', './installer/schema/20110201_c_code_to_user_modules_tiki.php', '15.9', 0),
('96de5f8fc058be02a0d781c11f96876f', './installer/schema/20110209_p_list_users_tiki.sql', '15.9', 0),
('e182b1170b0628144f3b7031b4ae9e56', './installer/schema/20110220_p_tracker_view_attachments_tiki.sql', '15.9', 0),
('cf450811ce67bd74a29f4c977127e74f', './installer/schema/20110223_queue_tiki.sql', '15.9', 0),
('dc769150bdc3b8e1b35f070e6e088ea3', './installer/schema/20110224_tiki_cart_inventory_hold_tiki.sql', '15.9', 0),
('097d060cf3ea7d34012d7692bcdefe40', './installer/schema/20110307_remove_calendar_reminder_tiki.sql', '15.9', 0),
('9383d1ca207d3aec10bf0e8847b8e8f2', './installer/schema/20110308_rss_item_key_tiki.sql', '15.9', 0),
('58b53aa01ecf477ac82dde6e4ef3d7e5', './installer/schema/20110317_attributes_increase_length_tiki.sql', '15.9', 0),
('9830d9ebee9ed93916946a229528d0f0', './installer/schema/20110411_banner_tiki.sql', '15.9', 0),
('8540fc07af7bdbbe76307d4af97a02fc', './installer/schema/20110412_permissions_out_of_db_tiki.sql', '15.9', 0),
('93e5ba1928f66db69d80f8556f6e0279', './installer/schema/20110413_blog_post_priv_default_value_tiki.sql', '15.9', 0),
('56eb71d5321768180d28bbdd0d54a1ae', './installer/schema/20110419_kill_old_search_tiki.sql', '15.9', 0),
('221fbfc6f88ef2630110ad5f6e19a358', './installer/schema/20110420_newsletter_optional_group_inclusion_tiki.sql', '15.9', 0),
('37c7ccf6d9b10f0bd4612d2967a8c309', './installer/schema/20110421_compact_search_in_topbar_tiki.sql', '15.9', 0),
('22ac2552b70bc5b077c29450466aeec9', './installer/schema/20110507_remove_module_style_params_tiki.sql', '15.9', 0),
('c19e62816382404968d7a6dfff401da2', './installer/schema/20110513_banner_tiki.sql', '15.9', 0),
('2d3bb3cde96805403cb9c66beda78857', './installer/schema/20110519_quick_edit_categ_params_merge_tiki.php', '15.9', 0),
('d43e01ff75818f0ce802cf666a5a9123', './installer/schema/20110603_convert_tracker_comments_tiki.sql', '15.9', 0),
('9820218bc613e80463759ac5cdffcb61', './installer/schema/20110606_convert_ip_fields_to_ipv6_tiki.sql', '15.9', 0),
('37a2a6f5a49f66e71513bccecde11ebc', './installer/schema/20110609_batch_update_tracker_item_links_tiki.php', '15.9', 0),
('787a5f5d2bab3458b3012ae54469ee1c', './installer/schema/20110609_missing_sql_tiki.sql', '15.9', 0),
('35981f9439ad309fac283bf9647ca2f7', './installer/schema/20110609_unique_login_tiki.php', '15.9', 0),
('7c32b0b9245fca8e6303c678bde74d45', './installer/schema/20110610_readd_sefurl_index_left_tiki.php', '15.9', 0),
('b6b89255a8f8ed151ccb3fc34d91ae74', './installer/schema/20110610_revert_poll_additions_tiki.php', '15.9', 0),
('118fe0373f666f454253d166c37723d3', './installer/schema/20110611_accounting_fix_primarykeys_tiki.sql', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('7ac89aee06b1e7dfc191afd6b837af2b', './installer/schema/20110613_filegal_source_display_tiki.sql', '15.9', 0),
('4b62d99df0d8d47fa3e7796bb7690672', './installer/schema/20110614_provider_authentication_tiki.sql', '15.9', 0),
('45cc111cc1df4c17c6982177b24a0250', './installer/schema/20110615_structure_alias_tiki.sql', '15.9', 0),
('3d3efcb12b2491dade431346a93f4272', './installer/schema/20110622_file_from_url_log_tiki.sql', '15.9', 0),
('2881aa2867a68821baa2f8a9d95e16cb', './installer/schema/20110630_fix_blogs_copyright_frencho_tiki.sql', '15.9', 0),
('1207ff134476c048445fa5a175aeda3d', './installer/schema/20110717_invoice_menu_options_tiki.sql', '15.9', 0),
('d706c164e7327bf66d68644d7297e921', './installer/schema/20110725_tracker_field_permname_tiki.sql', '15.9', 0),
('5b5a9159c6eb0ebf5aa61b6e67cb0dc9', './installer/schema/20110727_tracker_multilingual_convert_tiki.php', '15.9', 0),
('9c2fe77d70c17df2c038e4488b17d794', './installer/schema/20110727_tracker_multilingual_convert_tiki.sql', '15.9', 0),
('94392c46b0ed3843e2cc020e7c75db6f', './installer/schema/20110803_objectpermissions_tiki.sql', '15.9', 0),
('3713bca2297fd26847d523ac6512224b', './installer/schema/20110808_default_perm_name_tiki.sql', '15.9', 0),
('2616b96d2ce5225935c658d36a171833', './installer/schema/20110808_tracker_tiki.sql', '15.9', 0),
('a08aa709071292d07d56267037fd0f95', './installer/schema/20110815_creator_lost_7_tiki.sql', '15.9', 0),
('4fc9819d32aca61b48496e52c8aa36f9', './installer/schema/20110819_group_max_length_tiki.sql', '15.9', 0),
('b131c7e2456a254398bb60f9bc7c98c1', './installer/schema/20110823_tiki_connect_create_tiki.sql', '15.9', 0),
('70646a43b852f19a9ab8ac922ee6ffd7', './installer/schema/20110830_default_enable_in_use_tiki.php', '15.9', 0),
('1b9c3c961e6deca124a4012adf6a2734', './installer/schema/20110830_tiki_connect_longer_guid_tiki.sql', '15.9', 0),
('93c9738c01da0ed6c10de3e0fe138aea', './installer/schema/20110902_revert_rootCategId_addition_tiki.php', '15.9', 0),
('328b8627af75d5564f388731ab74c711', './installer/schema/20110904_shoutbox_def_tweetid_tiki.sql', '15.9', 0),
('06177cffcaa034aa10f307ab16118ee4', './installer/schema/20110905_extend_actionlog_comment_tiki.sql', '15.9', 0),
('1c74ca68692bddf1678a54ef5dabb79d', './installer/schema/20110905_multibyte_lc_fix_tiki.php', '15.9', 0),
('24ce6ceaf2a590a5291cbb899b6b8ce7', './installer/schema/20110908_author_submission_tiki.sql', '15.9', 0),
('322244495b3f612ff070dba910433fde', './installer/schema/20110909_tiki_forums_add_language_tiki.sql', '15.9', 0),
('13a301980674abdc01e85abea9425dfa', './installer/schema/20110911_add_missing_engine_specs_tiki.sql', '15.9', 0),
('76e3828702b68de894048a364ad096f3', './installer/schema/20110912_groupsexpiryanniversary_tiki.sql', '15.9', 0),
('6e71326d28f1b81e66467802d5dfed74', './installer/schema/20110912_remove_unused_fields_tiki.sql', '15.9', 0),
('6114f9218bd29cdc11f8c1a1d039985e', './installer/schema/20110923_referer_stats_tiki.sql', '15.9', 0),
('5cb9b8bc23137ec40da043d997af27cc', './installer/schema/20110926_tracker_menu_feature_reports_tiki.sql', '15.9', 0),
('88ab07eb3d0e22cd523e956692869bca', './installer/schema/20111001_add_tiki_areas_tiki.sql', '15.9', 0),
('407750420d6d2827c1198ce722fefc24', './installer/schema/20111006_drop_useless_key_tiki.sql', '15.9', 0),
('ba1b39203d9969ca3474fee2a932a8e1', './installer/schema/20111010_revert_fix_user_bookmarks_folders_key_tiki.php', '15.9', 0),
('e4fd615f3ee7224ce7065179ac05b602', './installer/schema/20111014_menu_feature_time_sheet_tiki.sql', '15.9', 0),
('e49fc3a8c6b20f7beee8389d50f0f134', './installer/schema/20111118_remove_versionOfPreferencesCache_tiki.sql', '15.9', 0),
('955501778236fe83504e4ce2c02099c8', './installer/schema/20111210_add_blog_hits_tiki.sql', '15.9', 0),
('8c3eefd5747facc604522bce0b7a3b0a', './installer/schema/20111217_on_value_tracker_tiki.sql', '15.9', 0),
('54901ab93551e49fd2372410d26f24d7', './installer/schema/20120115_remove_article_show_lang_tiki.sql', '15.9', 0),
('eb75b6d04c0ba431ba96f3f3e00b183e', './installer/schema/20120118_remove_users_prefs_language_tiki.sql', '15.9', 0),
('8aa7cfcc0e89ac36204d4d2923d782dd', './installer/schema/20120123_remove_column_from_tiki_user_reports_tiki.sql', '15.9', 0),
('6f7ae9d4d88d1fd8f47ed4207a142ec7', './installer/schema/20120315_list_image_article_y_tiki.sql', '15.9', 0),
('885239c9f8095951b27783e13121d9b3', './installer/schema/20120319_remove_sheets_with_no_relation_tiki.sql', '15.9', 0),
('47a64215b806bc69fc1762bec8628a80', './installer/schema/20120320_remove_admin_trackers_application_menu_tiki.sql', '15.9', 0),
('8be855afd09afffd9421030ef884d7c0', './installer/schema/20120323_add_reports_to_application_menu_tiki.sql', '15.9', 0),
('5915f745e660dbfb599856e21d1d5a8c', './installer/schema/20120323_remove_tracker_reports_from_application_menu_tiki.sql', '15.9', 0),
('e7ea4b231baf637b6aad4f570dc4f151', './installer/schema/20120324_add_filegals_icon_tiki.sql', '15.9', 0),
('ef7cd89a6a747950a94c018b0b9b3021', './installer/schema/20120401_kaltura_prefs_rename_tiki.sql', '15.9', 0),
('d584b6468da64406ca9c74047e2b2f45', './installer/schema/20120408_add_forumthread_sefurl_tiki.sql', '15.9', 0),
('e5c32a4acc3564abb7646802d82939ea', './installer/schema/20120421_autoincementtoautoincrement_tiki.sql', '15.9', 0),
('0351e57b91c6022444ecfeffc7c72e07', './installer/schema/20120422_mime_tiki.sql', '15.9', 0),
('98c3ad22db54d5a603bf29f8711da702', './installer/schema/20120423_add_page_refs_tiki.sql', '15.9', 0),
('0a97722ec5858dade8610abc538d06a3', './installer/schema/20120423_add_status_attr_tiki.sql', '15.9', 0),
('eb751653821eea4afa005a21965fb001', './installer/schema/20120426_perspectives_menu_entry_tiki.sql', '15.9', 0),
('065220f370cf11f688281a5c21a047ce', './installer/schema/20120426_tiki_db_status_tiki.sql', '15.9', 0),
('0ff20a24d98b24e7dc5223b34bd51dca', './installer/schema/20120429_fix_collation_tiki.php', '15.9', 0),
('2a1743af01a89efb43f2e6b0822ca5d7', './installer/schema/20120510_mailqueue_tiki.sql', '15.9', 0),
('02fd7c020f0f0eecb8c46c966387bfa7', './installer/schema/20120604_add_holder_to_copyright_tiki.sql', '15.9', 0),
('76c9d5df3cf491f680198d41898a1611', './installer/schema/20120628_correct_admin_user_createdate_tiki.sql', '15.9', 0),
('f77420b5c17943f0f57b9ae25f40fd04', './installer/schema/20120823_admin_user_credit_menu_entry_tiki.sql', '15.9', 0),
('12883dd19af98f0a15e96c8e12355986', './installer/schema/20120823_workspace_template_tiki.sql', '15.9', 0),
('849d88e7bb98c32166cc7f7c8e422bf0', './installer/schema/20120824_advanced_mode_flag_tiki.sql', '15.9', 0),
('b09f72e445325d5b290bd74023b5f956', './installer/schema/20120825_accounting_menu_entry_tiki.sql', '15.9', 0),
('b94ca87f607d459633ed52b307917eb8', './installer/schema/20120826_store_metadata_tiki.sql', '15.9', 0),
('ca9e50c68ed65fab24cac214c8cbabf8', './installer/schema/20120904_category_root_tiki.php', '15.9', 0),
('040310ecc810ced038db139a0bf9943d', './installer/schema/20120904_category_root_tiki.sql', '15.9', 0),
('dfbc0326eaf9bf5754084b932219749c', './installer/schema/20120927_add_area_exclusive_and_common_tiki.sql', '15.9', 0),
('68149c594b7a77a3f2af17c08505df1d', './installer/schema/20120927_add_menu_parse_tiki.sql', '15.9', 0),
('2a44d38e5345ebf58742ba826ecb5ecc', './installer/schema/20120930_tiki_p_view_poll_choices_tiki.sql', '15.9', 0),
('3cb67ce6e2d0c884110fd7848c94a7c9', './installer/schema/20121009_module_search_box_to_search_tiki.sql', '15.9', 0),
('7ffee0c3c2c04925d2657e7a3aced53e', './installer/schema/20121016_actionlog_comment_text_tiki.sql', '15.9', 0),
('a0febeb05f910d11a36b2494bf89f707', './installer/schema/20121027_tracker_samerow_fix_tiki.sql', '15.9', 0),
('1cdbb1b1c87529f75509a40d900de4cd', './installer/schema/20121210_add_missing_index_user_assigned_modules_tiki.sql', '15.9', 0),
('fddde4267df7ab11df0999f2114b76b0', './installer/schema/20121210_better_forum_reported_index_tiki.sql', '15.9', 0),
('615bf972626b172eccd5fdf84a847654', './installer/schema/20121213_module_zone_enlarge_tiki.php', '15.9', 0),
('566786e812240f906c36fd1d4acd9542', './installer/schema/20121213_module_zone_enlarge_tiki.sql', '15.9', 0),
('f400a5ecec07b112fec66e77b1d2f729', './installer/schema/20130220_wiki_attachments_tiki.sql', '15.9', 0),
('737e19c901e25ff8c54a4558fe018a29', './installer/schema/20130228_bigger_token_groups_tiki.sql', '15.9', 0),
('ee050d5b8a9eca59e6f125a45c283475', './installer/schema/20130301_sefurl_tracker_type_tiki.sql', '15.9', 0),
('4138f4be211d6405360c32336408f7ce', './installer/schema/20130314_keep_search_pref_settings_tiki.php', '15.9', 0),
('cad976420a3bc2e4a49506632af268e4', './installer/schema/20130322_app_menu_timesheet_pos_tiki.sql', '15.9', 0),
('44ec4903b1538e416525a6594899e66c', './installer/schema/20130322_restore_lost_filegals_tiki.sql', '15.9', 0),
('78828e075e63206219481fd1a96faca5', './installer/schema/20130328_extend_actionlog_bbb_tiki.sql', '15.9', 0),
('02a7624c6122ca174f3d03f821500499', './installer/schema/20130410_keep_wysiwyg_htmltowiki_setting_tiki.php', '15.9', 0),
('8fbc6dfc0bb538f99e354354abf71741', './installer/schema/20130415_repair_file_galleries_again_tiki.php', '15.9', 0),
('a6dc788402261b5ad7f8dc457a519d38', './installer/schema/20130417_score_alter_tiki.sql', '15.9', 0),
('1548a7f6c0f3e048a2d9cff98040430e', './installer/schema/20130417_score_tiki.sql', '15.9', 0),
('2ec218efe4d675718cb4874068bcb483', './installer/schema/20130419_newsletters_clippings_tiki.sql', '15.9', 0),
('f7a63e9581967d8c7739feeee1a1502f', './installer/schema/20130513_convert_tracker_field_parameters_tiki.php', '15.9', 0),
('06c8be2f743dd4a2a13a7a0a364abbc3', './installer/schema/20130530_category_log_tiki.sql', '15.9', 0),
('ccfa5273eda1b232f21b778e00ddfc2a', './installer/schema/20130530_tracker_modification_log_tiki.sql', '15.9', 0),
('362b275807bed067759ba6fb1502cf15', './installer/schema/20130605_mailin_show_inline_tiki.sql', '15.9', 0),
('6f6945a8092cae1c0a663ea8a915770d', './installer/schema/20130606_mailin_add_categoryId_tiki.sql', '15.9', 0),
('b8bfb17a7574fb229c48116f6a2777b5', './installer/schema/20130608_convert_mailin_pwd_tiki.php', '15.9', 0),
('810b71aa0c0166b64f8f27194511fb83', './installer/schema/20130608_mailin_response_tiki.sql', '15.9', 0),
('b5732bd4a0ea92ba019ca86d43a66d63', './installer/schema/20130611_mailin_add_html_tiki.sql', '15.9', 0),
('15de188ed2b8dbb2239e575b1150e0a3', './installer/schema/20130614_mailin_add_admin_tiki.sql', '15.9', 0),
('8c1977cb799881db7f7d87c4ec260f99', './installer/schema/20130616_mailin_add_namespace_tiki.sql', '15.9', 0),
('9999046bd18c5de75cb848e939a4f48a', './installer/schema/20130623_create_mailin_user_struct_tiki.sql', '15.9', 0),
('627798cd87e30d93a1bf3a9a4147dc9e', './installer/schema/20130624_mailin_add_attr_tiki.sql', '15.9', 0),
('22381e5220531fc9df24b9a92f1d3f9e', './installer/schema/20130704_catname_tiki.sql', '15.9', 0),
('3927bb8ba89cef57e6679b080295d62d', './installer/schema/20130705_activity_stream_tiki.sql', '15.9', 0),
('5cd63d71a596f99fde4c47176211bca1', './installer/schema/20130715_activity_stream_rules_tiki.sql', '15.9', 0),
('b0c92047743ffa0882fd6d9638b60428', './installer/schema/20130730_friendship_conversion_tiki.sql', '15.9', 0),
('c5c1a2071bb1213ab9cf8982806de08f', './installer/schema/20130730_wiki_para_format_default_change_tiki.php', '15.9', 0),
('187b36d02ed87a3bc277e27c919e13fb', './installer/schema/20130807_tracker_files_display_param_change_tiki.php', '15.9', 0),
('41d84d86ed45c355c75a8f3b89d4dd01', './installer/schema/20130809_limit_name_lengths_in_objects_tiki.php', '15.9', 0),
('31334949f0ce1de52c3f6a93a28fe43c', './installer/schema/20131007_menus_items_missing_icons_tiki.sql', '15.9', 0),
('571ae86418cc31331bb0021296349765', './installer/schema/20131108_mytiki_add_mailin_tiki.sql', '15.9', 0),
('0736546180e8fa478b885e61a7566a58', './installer/schema/20131117_unified_engine_default_change_tiki.php', '15.9', 0),
('86cd27c113512611f4dfe5421617b970', './installer/schema/20131218_stored_queries_tiki.sql', '15.9', 0),
('818b79ae45f7ed853c70c0ecb19e7c46', './installer/schema/20131231_add_sheet_metadata_tiki.sql', '15.9', 0),
('5d4970d01862e922d6ffda13229d4fe9', './installer/schema/20140109_query_unique_name_tiki.sql', '15.9', 0),
('7bcd2c028606a9a113d75c2507b8de38', './installer/schema/20140117_monitor_tiki.sql', '15.9', 0),
('1e08c3fc2c93915f8b3a631a3d26044d', './installer/schema/20140129_bigger_target_monitor_tiki.sql', '15.9', 0),
('1c47a37146f38292f1d968bfef47ebb8', './installer/schema/20140203_menu_item_and_icon_user_wizard_tiki.sql', '15.9', 0),
('ce1c7d411fae4b462bed93d9ac6a5a95', './installer/schema/20140206_add_parser_column_tiki.sql', '15.9', 0),
('edde062c490700faca572aaabf77cb52', './installer/schema/20140210_user_wizard_add_section_name_tiki.sql', '15.9', 0),
('46a7dcca1dda0c9c09a99c8de2d981fa', './installer/schema/20140214_goals_tiki.sql', '15.9', 0),
('3f2880d67d546ecec4844c570e6546ba', './installer/schema/20140219_full_goal_events_tiki.sql', '15.9', 0),
('d6e3d03ba7405a447f4d3fd47f0ce4aa', './installer/schema/20140301_add_column_rating_choice_topic_on_forums_tiki.sql', '15.9', 0),
('8ab2629b201dc667190659d2fc0d3c02', './installer/schema/20140318_user_wizard_add_groupname_tiki.sql', '15.9', 0),
('44d633f4dfefff02d3a54fda12a86304', './installer/schema/20140402_mailin_protocol_option_tiki.sql', '15.9', 0),
('9fcb77f139414164845c0f9117748905', './installer/schema/20140402_payment_authorization_tiki.sql', '15.9', 0),
('c8cbc000d5875cc0a92f7953db4797fe', './installer/schema/20140402_remove_mailin_smtp_tiki.sql', '15.9', 0),
('664417ce11b34798af188c68990f9782', './installer/schema/20140509_rss_add_categories_tiki.sql', '15.9', 0),
('dd9a3fc5e45cf923014c6798b659969b', './installer/schema/20140625_survey_tiki.sql', '15.9', 0),
('611834b319710f11acf2934ba290fea5', './installer/schema/20140705_page_slug_tiki.php', '15.9', 0),
('e8434febe415828ffc72641e5b2013b3', './installer/schema/20140705_page_slug_tiki.sql', '15.9', 0),
('7500c5dfb3f24af214a04dfddc30d94f', './installer/schema/20140807_federated_search_tiki.sql', '15.9', 0),
('46b2fac08d13d6637e62be401a3d81a6', './installer/schema/20140812_convert_tiki_connect_data_to_json_tiki.php', '15.9', 0),
('d3f9fe4c0c27936f9aa9b5bc40746dcb', './installer/schema/20140914_addon_profiles_tiki.sql', '15.9', 0),
('43fd18819a7d7612dad9ce522369a9aa', './installer/schema/20141003_change_style_pref_to_theme_tiki.php', '15.9', 0),
('b570b04882abe860e483717f508a4424', './installer/schema/20141106_menu_configuration_panel_tiki.sql', '15.9', 0),
('722ef80e1f2641b33d0c51930cda0439', './installer/schema/20141114_remove_babelfish_tiki.sql', '15.9', 0),
('e1dd3729566945079ebeab2325aa4faf', './installer/schema/20141120_tracker_tabular_tiki.sql', '15.9', 0),
('1c4726c7c1398af65801e1e79b66049f', './installer/schema/20141122_change_prefname_availblestyles_to_availablethemes_tiki.sql', '15.9', 0),
('109233b6947f5095378ea739f554ecde', './installer/schema/20141125_menu_control_panels_tiki.sql', '15.9', 0),
('810f09f5a3711abf92c3e4976f9807fd', './installer/schema/20150109_tabular_filters_tiki.sql', '15.9', 0),
('58c344c5452911759d101ad286b68d7d', './installer/schema/20150112_theme_option_etc_tiki.sql', '15.9', 0),
('1eee7b39a4687be425eeb55a590d8d22', './installer/schema/20150203_add_menu_option_class_tiki.sql', '15.9', 0),
('975871b45b1c2c9d8e493e3b3d0cdaaa', './installer/schema/20150310_rename_freetags_in_menu_42_tiki.sql', '15.9', 0),
('fb48dee14b960d1d7c48a08a85ef7fc8', './installer/schema/20150310_rename_mytiki_in_menu_42_tiki.sql', '15.9', 0),
('2d346e27c91070cc840b7dab52504a0f', './installer/schema/20150327_tracker_showPopup_option_fix_tiki.sql', '15.9', 0),
('8e032a195dac36d92fdbeaf0aecfd85e', './installer/schema/20150414_profile_symbol_tooshort_fix_tiki.sql', '15.9', 0),
('fc3c6bd5ed7353f96f36fa1fe9c318b1', './installer/schema/20150426_menu_item_external_wikis_restored_tiki.sql', '15.9', 0),
('0983f5c5760688e2de08af8d171aa213', './installer/schema/20150508_perspectives_style_to_theme_tiki.php', '15.9', 0),
('bd25949296c7ceaf65935eb8530c73c6', './installer/schema/20150730_menu_item_tabular_trackers_tiki.sql', '15.9', 0),
('ffb42720a6dd9ba8670b6bacaf35eb84', './installer/schema/20150901_prefname_char_length_tiki.sql', '15.9', 0),
('7fae5fdf9dcc1a2446e7d930bbc0fdfe', './installer/schema/20150929_make_hotwords_longer_tiki.sql', '15.9', 0),
('462be72a12dc5c56777f9e02bc633228', './installer/schema/20151203_tiki_score_revamp_tiki.sql', '15.9', 0),
('0b0ac54a682f34d94dddc4505b328c7f', './installer/schema/20151203_tokens_create_user_tiki.sql', '15.9', 0),
('5468fa2c97256a0f7fb4c92251f7b880', './installer/schema/20160120_remove_gmap_menu_item_tiki.sql', '15.9', 0),
('381f850f916bceec588cda286a9361be', './installer/schema/20160201_remove_maps_menus_tiki.sql', '15.9', 0),
('6647ca98d6677dbfe4f2c096488e1c88', './installer/schema/20160206_theme_option_modules_tiki.sql', '15.9', 0),
('d767fe6ea302cb082eb0a2e91a024b23', './installer/schema/20160315_correct_blogpost_encoding_tiki.sql', '15.9', 0),
('ea2f7fb91e7fde0d126e2221f16cb7f0', './installer/schema/20160325_menu_42_list_pages_tiki.sql', '15.9', 0),
('8cc364ddb16d2f13d019c3eacd1ff66b', './installer/schema/20160420_correct_blogpost_encoding_tiki.sql', '15.9', 0),
('12fe008b7f0546d15f76f80aacf97e16', './installer/schema/20160519_calendar_events_action_log_tiki.sql', '15.9', 0),
('861d7ba1007a5553f7df989ff948be5c', './installer/schema/20160527_menu_item_payment_tiki.sql', '15.9', 0),
('110b72dcad7ff9bb9424d8b987ad89a2', './installer/schema/20160604_remove_unwanted_files_tiki.php', '15.9', 0),
('8cc8de59f71262e6a1f99d927b79aaba', './installer/schema/20160608_menu_item_admin_tokens_tiki.sql', '15.9', 0),
('64fa29ad9cced58fdbbf53cdf8e3505e', './installer/schema/20160627_remove_more_unwanted_files_tiki.php', '15.9', 0),
('a99280fa59b8872578f508349de33f09', './installer/schema/20160817_fix_dymanic_list_field_values_tiki.php', '15.9', 0),
('a25455a589f55817f23eb9aad20a280a', './installer/schema/20160914_extwiki_missing_columns_fix_tiki.php', '15.9', 0),
('e989dbbf57a7bf4951f0abb97563fec0', './installer/schema/20160915_extwiki_indexname_length_tiki.sql', '15.9', 0),
('9ed43fbdc01e8c73bd2e7ee263f10b21', './installer/schema/20170322_fix_allocate_memory_prefs_tiki.sql', '15.9', 0),
('425c8a35f2aba3d54f2ffeec3b6241a8', './installer/schema/999999991_decode_pages_sources_tiki.php', '15.9', 0),
('39094becda4c75aa4d24946d7823896d', './installer/schema/99999999_image_plugins_kill_tiki.php', '15.9', 0),
('c161717be9dc792f7e0cb5c0296d58a7', './installer/schema/index.php', '15.9', 0),
('957f8b7e5d115c82d01fadfb97a0bc75', './installer/script/index.php', '15.9', 0),
('5c2dbd6863fc225e4f96c20db0d64b9f', './installer/shell.php', '15.9', 0),
('cdead7576f41c6468d22ea7c659f9696', './installer/tiki-installer.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/ar/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/ar/language.js', '15.9', 0),
('f056b561814fce553a6be04d092ac9e1', './lang/ar/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/bg/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/bg/language.js', '15.9', 0),
('09a3c7288b331a499fe438dda9f71ae8', './lang/bg/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/ca/index.php', '15.9', 0),
('1aad9c919b3a6350bf6da1bc2ccaacf0', './lang/ca/language.js', '15.9', 0),
('fec3baf911d34ca550a3fadca5c73b0c', './lang/ca/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/cn/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/cn/language.js', '15.9', 0),
('a77fe773fd43d1abf690e8094d237fe8', './lang/cn/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/cs/index.php', '15.9', 0),
('3d65dd2cf952246c89367e5a1fc66207', './lang/cs/language.js', '15.9', 0),
('43169dc91d7d772b5400dbbdfcaf3e61', './lang/cs/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/cy/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/cy/language.js', '15.9', 0),
('85e39bec167752a407e901138050ba54', './lang/cy/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/da/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/da/language.js', '15.9', 0),
('991e89b1143754d1470223bf18a485a6', './lang/da/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/de/index.php', '15.9', 0),
('b9add9743b01968089e3d7b45ba59dec', './lang/de/language.js', '15.9', 0),
('1755eebff3697e925e34f8d197c047e3', './lang/de/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/dk/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/dk/language.js', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/el/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/el/language.js', '15.9', 0),
('c57c609dba6ba525ce62f0d769c04ceb', './lang/el/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/en-uk/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/en-uk/language.js', '15.9', 0),
('af2eb13473505660536e690282c7e1cd', './lang/en-uk/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/en/index.php', '15.9', 0),
('f5fcfd9a68bf424a860e73b88c852fbe', './lang/en/language.js', '15.9', 0),
('6df52b60e71e3806683731235962efa3', './lang/en/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/es/index.php', '15.9', 0),
('65c62c1081b622cda91f979d78b0607c', './lang/es/language.js', '15.9', 0),
('3d3c226a015556b8e64db668b2e4bde7', './lang/es/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/fa/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/fa/language.js', '15.9', 0),
('8b6d137050afde76076f2952ae165fca', './lang/fa/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/fi/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/fi/language.js', '15.9', 0),
('bfa56cc8541e0bd55e7f64716bac7fcf', './lang/fi/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/fj/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/fj/language.js', '15.9', 0),
('e963f520280737f4bbcaaa3b4527fa05', './lang/fj/language.php', '15.9', 0),
('21100fed7bde4b2550e7e60e93b9a0d5', './lang/flagmapping.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/fr/index.php', '15.9', 0),
('decabd3d70c1906e0e5c7cb778ddd089', './lang/fr/language.js', '15.9', 0),
('52f4c7ea6c5231877f26a0cc27e3cf47', './lang/fr/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/fy-NL/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/fy-NL/language.js', '15.9', 0),
('de64a553b61c373fe4b071accd402ea3', './lang/fy-NL/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/gl/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/gl/language.js', '15.9', 0),
('707e1d42def3a59e34d96fc588ad0855', './lang/gl/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/he/index.php', '15.9', 0),
('13c726e9b9696aa7b76d1ea034485f11', './lang/he/language.js', '15.9', 0),
('e5057b4cec567a0310af1e2327a9227d', './lang/he/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/hr/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/hr/language.js', '15.9', 0),
('b66a8a74369ea9429ec273f206be0962', './lang/hr/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/hu/index.php', '15.9', 0),
('f5ed89d324f6f0eae008c3ec53fbf12c', './lang/hu/language.js', '15.9', 0),
('b5d97485ae14dd715297e8f66b7b74c8', './lang/hu/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/id/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/id/language.js', '15.9', 0),
('8f9859eeb3b983e76917625e7d4618de', './lang/id/language.php', '15.9', 0),
('992f6de95d03bce872d8b7729cac7965', './lang/index.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/is/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/is/language.js', '15.9', 0),
('4019e41936122d7756f5ff837b278f31', './lang/is/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/it/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/it/language.js', '15.9', 0),
('e7aa51861b4d30866a91c9348bd99741', './lang/it/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/iu-iq/index.php', '15.9', 0),
('d4814387534381f22fa6492b42d137ff', './lang/iu-iq/language.js', '15.9', 0),
('c4202459e45f0f3fdd007bd995f77145', './lang/iu-iq/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/iu-ro/index.php', '15.9', 0),
('d4814387534381f22fa6492b42d137ff', './lang/iu-ro/language.js', '15.9', 0),
('c4202459e45f0f3fdd007bd995f77145', './lang/iu-ro/language.php', '15.9', 0),
('19cb5e100cd2a141683922e48ce94bfc', './lang/iu/index.php', '15.9', 0),
('d4814387534381f22fa6492b42d137ff', './lang/iu/language.js', '15.9', 0),
('ea7e287db0d46e979494d1c328ed08ad', './lang/iu/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/ja/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/ja/language.js', '15.9', 0),
('1237d080abf07a45e4f52422d35d2677', './lang/ja/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/ko/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/ko/language.js', '15.9', 0),
('b52cab44094bfd8be8a1409fbd1edde9', './lang/ko/language.php', '15.9', 0),
('19b8c446cd57932ba3bc327e713e3a40', './lang/langmapping.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/lt/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/lt/language.js', '15.9', 0),
('1cb36156fe271729ac2c50adc1aea20b', './lang/lt/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/nds/index.php', '15.9', 0),
('a62347831caf7c70d03c6f8d029aae4e', './lang/nds/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/nl/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/nl/language.js', '15.9', 0),
('08095e6d9f603abdf78492aec8d649ec', './lang/nl/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/no/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/no/language.js', '15.9', 0),
('0e6c440714aea1d2cc3351d2733a194c', './lang/no/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/pl/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/pl/language.js', '15.9', 0),
('057ea14cd2612bb0242e58166360306e', './lang/pl/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/pt-br/index.php', '15.9', 0),
('d5020fda99116cbf4603fd76ad95259d', './lang/pt-br/language.js', '15.9', 0),
('7a0ff6ef340652b34ba69c3ea6777f8e', './lang/pt-br/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/pt/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/pt/language.js', '15.9', 0),
('86e7f67e6d8b2160ced24a8249b054a7', './lang/pt/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/rm/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/rm/language.js', '15.9', 0),
('00f8f43b58747c8b032ae0313ae48536', './lang/rm/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/ro/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/ro/language.js', '15.9', 0),
('afc0f9a811437ab8777d420d436573ff', './lang/ro/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/ru/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/ru/language.js', '15.9', 0),
('31e8c4a512b166a88db3c9f9134a5b5b', './lang/ru/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/sb/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/sb/language.js', '15.9', 0),
('bf5a5819b65c35936120a3cc2433e822', './lang/sb/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/si/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/si/language.js', '15.9', 0),
('d40911e084547cb193078ee8707c58bc', './lang/si/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/sk/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/sk/language.js', '15.9', 0),
('3a12d18df097163798169043ce529bf6', './lang/sk/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/sl/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/sl/language.js', '15.9', 0),
('0484a8b51d6eee0d681a1a94f4bb0319', './lang/sl/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/sq/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/sq/language.js', '15.9', 0),
('2999790117b44f2086d3c0ccde9a9eac', './lang/sq/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/sr-latn/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/sr-latn/language.js', '15.9', 0),
('fe3e001bf2cd933951e870af4513ded3', './lang/sr-latn/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/sv/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/sv/language.js', '15.9', 0),
('2081c276c7b4999131f634160364d99e', './lang/sv/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/sw/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/sw/language.js', '15.9', 0),
('d44e8627d48e7df596ed9148fdcdfe9f', './lang/th/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/th/language.js', '15.9', 0),
('c639dd4826e1eb111708eab80760689d', './lang/th/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/tr/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/tr/language.js', '15.9', 0),
('f39140613e9c09bee4b772bc68df1483', './lang/tr/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/tv/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/tv/language.js', '15.9', 0),
('904b298489fc102d230069c5feb0633d', './lang/tv/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/tw/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/tw/language.js', '15.9', 0),
('8734cb7b44cc3db530a937960eef4801', './lang/tw/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/uk/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/uk/language.js', '15.9', 0),
('5a9290350c2a74eb77f202bb082ce36a', './lang/uk/language.php', '15.9', 0),
('193e15122e68bd976bdd2584a146a6b3', './lang/vi/index.php', '15.9', 0),
('60ff8e90609707487b13cd2722a75652', './lang/vi/language.js', '15.9', 0),
('17ba680c39d10a5ec5f7521e3f27887d', './lang/vi/language.php', '15.9', 0),
('8f8a45f323fe43e086cee0e22179f760', './lib/TikiWebdav/Auth/Default.php', '15.9', 0),
('97c26e28e3a092d86ffe8d6f3a457796', './lib/TikiWebdav/Auth/Wiki.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/TikiWebdav/Auth/index.php', '15.9', 0),
('58fbb7f53567136bf2832d4be2b50def', './lib/TikiWebdav/Backend/File.php', '15.9', 0),
('adc36d5e4d194c9c7d2f18f8e0940bf3', './lib/TikiWebdav/Backend/Wiki.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/TikiWebdav/Backend/index.php', '15.9', 0),
('972cd39902094b962927209b3d9f63df', './lib/TikiWebdav/PathFactories/File.php', '15.9', 0),
('a30f56f8c32354d0822e19d2f03bd479', './lib/TikiWebdav/PathFactories/Wiki.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/TikiWebdav/PathFactories/index.php', '15.9', 0),
('3e62138b93976989392ca9b84ffa2c4d', './lib/TikiWebdav/Server.php', '15.9', 0),
('829ff875b2a3bb2bb3c2436a2bed2d1e', './lib/TikiWebdav/autoload.php', '15.9', 0),
('e5c931a0f8fc157f7e5e92ed546abc78', './lib/TikiWebdav/index.php', '15.9', 0),
('15b7946fe846104707693e5990e2da86', './lib/ZeroClipboard.js', '15.9', 0),
('dcf8e3ad3d0e1ce9e92d19af0c106f27', './lib/accounting/accountinglib.php', '15.9', 0),
('e5c931a0f8fc157f7e5e92ed546abc78', './lib/accounting/index.php', '15.9', 0),
('e34cdfdeab3821c87149c16e94a7a124', './lib/activity/activitylib.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/activity/index.php', '15.9', 0),
('40c0c50d19ef11c5a51fb541ccba7d60', './lib/admin/adminlib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/admin/index.php', '15.9', 0),
('82537d0d641b94e5c88326437f4a9b6c', './lib/ajax/autosave.js', '15.9', 0),
('e64b335a6b2e9577156c9e32827d19e1', './lib/ajax/autosave.php', '15.9', 0),
('e5c931a0f8fc157f7e5e92ed546abc78', './lib/ajax/index.php', '15.9', 0),
('f6161eafb72ae052cc15c3178941a7d7', './lib/articles/artlib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/articles/index.php', '15.9', 0),
('9c294d166b0d95bcf30c3abd9fa35e39', './lib/attributes/attributelib.php', '15.9', 0),
('e5c931a0f8fc157f7e5e92ed546abc78', './lib/attributes/index.php', '15.9', 0),
('7d8fb12f4eca107f4f8ee5ced0943da7', './lib/attributes/relationlib.php', '15.9', 0),
('b4a7f32df378260bd565ad2656da83c8', './lib/auth/PasswordHash.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/auth/index.php', '15.9', 0),
('4cbf370dbe9ad6495de6ba23ef9a6f4e', './lib/auth/ldap.php', '15.9', 0),
('9dc11e4566c398618e84d1c6f6d73329', './lib/auth/phpbb.php', '15.9', 0),
('f4cc337858912b12816fc32bbf58171b', './lib/auth/tokens.php', '15.9', 0),
('28dd3d74dd691fd84c655a80fd26941c', './lib/avatarlib.php', '15.9', 0),
('6a6cbfd8b5e41d64e393eaf62dcd8db4', './lib/ban/banlib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/ban/index.php', '15.9', 0),
('840f35aa4a26ebcca906df06308c9239', './lib/banners/bannerlib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/banners/index.php', '15.9', 0),
('4744f8308c4f35a70ce9cd5fcbcebc27', './lib/bigbluebuttonlib.php', '15.9', 0),
('e4a86c611e8a441fbea4de6852d222b9', './lib/blogs/bloglib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/blogs/index.php', '15.9', 0),
('35c53b45a3a7cb2cdc41f7b5309dbfcb', './lib/bookmarks/bookmarklib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/bookmarks/index.php', '15.9', 0),
('62c9184e21ec77404cf6288937535cad', './lib/breadcrumblib.php', '15.9', 0),
('3a36c23e9382ba3663462f61f6d2489b', './lib/cache/cachelib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/cache/index.php', '15.9', 0),
('089ba22a05a749f416c556bf62b359ab', './lib/cache/memcachelib.php', '15.9', 0),
('917e57d772b4ff32d42e36c93a0e5dcc', './lib/calendar/calendarlib.php', '15.9', 0),
('7e191ccca010f7a691b6e8aab6449ce3', './lib/calendar/calrecurrence.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/calendar/index.php', '15.9', 0),
('e13b1eadf1a8d5284222904fa64c93be', './lib/calendar/tikicalendarlib.php', '15.9', 0),
('520f67854402980720bfc2f8c35ed050', './lib/captcha/Captcha_Questions.php', '15.9', 0),
('3499e18d217341cf9337640812b5b275', './lib/captcha/Captcha_ReCaptcha20.php', '15.9', 0),
('32340e1423025d6d7d9aeb69e8f6cc31', './lib/captcha/captchalib.js', '15.9', 0),
('b11964e25c91751ee034a781746c7c69', './lib/captcha/captchalib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/captcha/index.php', '15.9', 0),
('9ca328729291f43b32f0fc80da70e72c', './lib/categories/categlib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/categories/index.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/ckeditor_tiki/ckeditor-icons/index.php', '15.9', 0),
('e5c931a0f8fc157f7e5e92ed546abc78', './lib/ckeditor_tiki/index.php', '15.9', 0),
('d2035934e47492bfb9ebf52c13aec964', './lib/ckeditor_tiki/plugins/_tikilink/dialogs/index.php', '15.9', 0),
('8ca8ee0f4f12aa4078c1e125237c817a', './lib/ckeditor_tiki/plugins/_tikilink/dialogs/tikilink.js', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/ckeditor_tiki/plugins/_tikilink/index.php', '15.9', 0),
('019a5581e5d12021faad71b7ed6a875c', './lib/ckeditor_tiki/plugins/_tikilink/plugin.js', '15.9', 0),
('d2035934e47492bfb9ebf52c13aec964', './lib/ckeditor_tiki/plugins/autosave/images/index.php', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/ckeditor_tiki/plugins/autosave/index.php', '15.9', 0),
('b1fdcc52ee30a4b03a574492e8f4fed2', './lib/ckeditor_tiki/plugins/autosave/plugin.js', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/ckeditor_tiki/plugins/index.php', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/ckeditor_tiki/plugins/inlinecancel/index.php', '15.9', 0),
('5bd7f224c2e501a1f3fa1e2f79045ef3', './lib/ckeditor_tiki/plugins/inlinecancel/plugin.js', '15.9', 0),
('cadd36cc36db8574a9975bcc4d436452', './lib/ckeditor_tiki/plugins/inlinesave/images/index.php', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/ckeditor_tiki/plugins/inlinesave/index.php', '15.9', 0),
('892a62a12fd4cb4a4fe4761244291150', './lib/ckeditor_tiki/plugins/inlinesave/plugin.js', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/ckeditor_tiki/plugins/tikiplugin/index.php', '15.9', 0),
('c04d39e075daceaecd6256f40b4d63e7', './lib/ckeditor_tiki/plugins/tikiplugin/plugin.js', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/ckeditor_tiki/plugins/tikiwiki/index.php', '15.9', 0),
('6e7efd4bea702e33dea28f13a380fb8f', './lib/ckeditor_tiki/plugins/tikiwiki/plugin.js', '15.9', 0),
('8be1eaa2e761b19c4aae77de9b4df003', './lib/ckeditor_tiki/tiki-ckeditor.js', '15.9', 0),
('76228dffcb2bda30c388d4e9cfd3005f', './lib/ckeditor_tiki/tikilink_dialog.js', '15.9', 0),
('3f66ae3e75befb86d9079a26b2542987', './lib/ckeditor_tiki/tikistyles.js', '15.9', 0),
('e434b993e907c930e337ccf8aed9ae29', './lib/ckeditor_tiki/tikitemplates.js', '15.9', 0),
('7d68fe6e932d167b4b808062597bcd25', './lib/ckeditor_tiki/wysiwyglib.php', '15.9', 0),
('8134f3f86450a113b1715cd139792a09', './lib/codemirror_tiki/codemirror_tiki.css', '15.9', 0),
('08a80461cdf8ad2aa7e8e5ca582d78f7', './lib/codemirror_tiki/codemirror_tiki.js', '15.9', 0),
('e5c931a0f8fc157f7e5e92ed546abc78', './lib/codemirror_tiki/index.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/codemirror_tiki/mode/index.php', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/codemirror_tiki/mode/tiki/index.php', '15.9', 0),
('66e3c6ba0ab0c6e5fca877e3361ad2ad', './lib/codemirror_tiki/mode/tiki/tiki.css', '15.9', 0),
('1f5ae82cf0ab3bcbcf90d9017fba4517', './lib/codemirror_tiki/mode/tiki/tiki.js', '15.9', 0),
('ceab170c1baca4dcf358418a8231ba18', './lib/codemirror_tiki/tiki_codemirror.php', '15.9', 0),
('362ef59a425672e4be5636572b08a7c3', './lib/commcenter/commlib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/commcenter/index.php', '15.9', 0),
('a574a9051a0d7f9cf43ef8b5b792f26d', './lib/comments/commentslib.js', '15.9', 0),
('f42cc18ef9d2d1437fb4f05289f9adf9', './lib/comments/commentslib.php', '15.9', 0),
('e5c931a0f8fc157f7e5e92ed546abc78', './lib/comments/index.php', '15.9', 0),
('0986056eaa92fa5466d52f1807a1a4cd', './lib/contribution/contributionlib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/contribution/index.php', '15.9', 0),
('332ead31cd21e946de1c118634bb53b8', './lib/copyrights/copyrightslib.php', '15.9', 0),
('3e64481e6c8e2a08b34ae43fb2aaf9f0', './lib/copyrights/index.php', '15.9', 0),
('2bd13d9c61d5608441d4a5db91fa6b30', './lib/core/Category/Manipulator.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/core/Category/index.php', '15.9', 0),
('35153bdee91a84701e0df70cbad3e5cb', './lib/core/DeclFilter.php', '15.9', 0),
('d96495156ff74b722c2935665d2de3a3', './lib/core/DeclFilter/CatchAllFilterRule.php', '15.9', 0),
('ddb06fc0092377135d462df02519f33c', './lib/core/DeclFilter/CatchAllUnsetRule.php', '15.9', 0),
('8c62be0b3bd7696ecb5509d8d32c7568', './lib/core/DeclFilter/FilterRule.php', '15.9', 0),
('59eada371cc692096f2c8cfa24b49e46', './lib/core/DeclFilter/KeyPatternFilterRule.php', '15.9', 0),
('214b4f329ad585256ad2ba9a0e50ed2f', './lib/core/DeclFilter/KeyPatternUnsetRule.php', '15.9', 0),
('e3dc73d02f53a5fb258f87bad61bdaf6', './lib/core/DeclFilter/Rule.php', '15.9', 0),
('93317d0e774b4de200f08b862dae2a05', './lib/core/DeclFilter/StaticKeyFilterRule.php', '15.9', 0),
('146a85c600354c99194dfad2f19f57d8', './lib/core/DeclFilter/StaticKeyUnsetRule.php', '15.9', 0),
('860d516ead57b31a5ca10467a86eb8d3', './lib/core/DeclFilter/UnsetRule.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/core/DeclFilter/index.php', '15.9', 0),
('95cbfc7201b3e0654c8580a2ba5cee9b', './lib/core/Feed/Abstract.php', '15.9', 0),
('0da0308e5b507811dc8043531fb2d3ac', './lib/core/Feed/Container.php', '15.9', 0),
('dfaa94d38577722d4161f6d91a1fd12a', './lib/core/Feed/Contents.php', '15.9', 0),
('fa206301405017a0dad6fe9f034bc980', './lib/core/Feed/Html.php', '15.9', 0),
('5e905760f6df065278c6e06518e79f9d', './lib/core/Feed/Html/Receive.php', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/core/Feed/Html/index.php', '15.9', 0),
('fa01747d953a558d4e35b4ae02ce1396', './lib/core/Feed/Item.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/core/Feed/index.php', '15.9', 0),
('79a4c9ab93ac0fcabcb620998030b6da', './lib/core/FutureLink/FutureUI.php', '15.9', 0),
('e79771699e8886fb63d7f16bffee8be1', './lib/core/FutureLink/Metadata.php', '15.9', 0),
('b39958b8a3604fe9a76a3bd45bc5af23', './lib/core/FutureLink/MetadataAssembler.php', '15.9', 0),
('296c71bc5aa35279de7f0bc68402b58b', './lib/core/FutureLink/PageLookup.php', '15.9', 0),
('0b049cf1bcda44d6d4c49f670d3cdd0d', './lib/core/FutureLink/Pair.php', '15.9', 0),
('cd134995a2b80a3c14293befa458201a', './lib/core/FutureLink/Pairs.php', '15.9', 0),
('d168a6124d6f7a7846795a99da0ac18f', './lib/core/FutureLink/PastUI.php', '15.9', 0),
('ede2ec64fefca34cebbf356acbf2b785', './lib/core/FutureLink/ReceiveFromPast.php', '15.9', 0),
('3d36aac32644ab59cce7bc56fab7ea01', './lib/core/FutureLink/Search.php', '15.9', 0),
('20dd97819f9d715216b45495c2487a43', './lib/core/FutureLink/SendToFuture.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/FutureLink/index.php', '15.9', 0),
('4e654eef10a069a95c53e381eee9e139', './lib/core/Horde/Exception.php', '15.9', 0),
('4bdcd45e62e2b7b5406c9be5df8b9eb6', './lib/core/Horde/Exception/LastError.php', '15.9', 0),
('d1ca461c8176930ce65123ad05573f3a', './lib/core/Horde/Exception/NotFound.php', '15.9', 0),
('92800d0fa370f23ab32bc2e85db0bfc4', './lib/core/Horde/Exception/Pear.php', '15.9', 0),
('7eeb72ba01218e676a252a7b69d1b6b0', './lib/core/Horde/Exception/PermissionDenied.php', '15.9', 0),
('511801d245bb82cb18c92a138d326f34', './lib/core/Horde/Exception/Translation.php', '15.9', 0),
('b88f5896b6b591a1775db4e4c32dd989', './lib/core/Horde/Exception/Wrapped.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Horde/Exception/index.php', '15.9', 0),
('85a4f70d35f01e4f666fb0315a545624', './lib/core/Horde/Yaml.php', '15.9', 0),
('bb8bed76c0d555824638d78e59f7eda7', './lib/core/Horde/Yaml/Dumper.php', '15.9', 0),
('dc18e85d33e56488933bd0b0c1cc7dc9', './lib/core/Horde/Yaml/Exception.php', '15.9', 0),
('c09bcc36223e5ce5e0f509a0115c23f7', './lib/core/Horde/Yaml/Loader.php', '15.9', 0),
('2d6c7972c58f407951bd8d185e9bd4ea', './lib/core/Horde/Yaml/Node.php', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/core/Horde/Yaml/index.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/core/Horde/index.php', '15.9', 0),
('6bb93faedc7f15fc6b14d6079583c690', './lib/core/JisonParser/Phraser.js', '15.9', 0),
('6be5e26bd1e963304d96134d75370b83', './lib/core/JisonParser/Phraser.php', '15.9', 0),
('9da07891251782737b3f60ce8173e4ec', './lib/core/JisonParser/Phraser/Handler.php', '15.9', 0),
('eca136d7a458e000489f2958a5e530cb', './lib/core/JisonParser/Phraser/index.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/core/JisonParser/index.php', '15.9', 0),
('43f5957450b7c6d98c4779f4f1d088bf', './lib/core/JitFilter.php', '15.9', 0),
('fbaf618f26d3e743111271b1f8fdd427', './lib/core/JitFilter/Element.php', '15.9', 0),
('f1a0392250547b887c7dc427d19327ce', './lib/core/JitFilter/index.php', '15.9', 0),
('22b409b2c45ce4946cbbf3a2c12995df', './lib/core/Math/Formula/Element.php', '15.9', 0),
('b269219748249e029e2ff1c366308c98', './lib/core/Math/Formula/Exception.php', '15.9', 0),
('bf8df39e63746796947d0ef00f9e0094', './lib/core/Math/Formula/Function.php', '15.9', 0),
('b36cf72966fd5f77109e959c22e6d6cb', './lib/core/Math/Formula/Function/Add.php', '15.9', 0),
('39352f22b243ac66ee9a6409d3ddbcd5', './lib/core/Math/Formula/Function/And.php', '15.9', 0),
('2f3a2b72031d22e64e35b1456a3b194a', './lib/core/Math/Formula/Function/Avg.php', '15.9', 0),
('04ac9c48a4a5b959a535567fa2557529', './lib/core/Math/Formula/Function/Ceil.php', '15.9', 0),
('aaa3fa4f701a216f49631e1198acff00', './lib/core/Math/Formula/Function/Coalesce.php', '15.9', 0),
('165b1366bf93d7db85caa43da8582899', './lib/core/Math/Formula/Function/Concat.php', '15.9', 0),
('3ab66b6991eda75ce177ddc3f78bc34d', './lib/core/Math/Formula/Function/Contains.php', '15.9', 0),
('35f4313e3c7384e0987d9b3d2b3a6ffe', './lib/core/Math/Formula/Function/Date.php', '15.9', 0),
('3d60525b61b3a4ef40f0f936e86e9c18', './lib/core/Math/Formula/Function/Div.php', '15.9', 0),
('9a9c3efb19f2ca492471d3fa7c2d2dfc', './lib/core/Math/Formula/Function/Equals.php', '15.9', 0),
('ff09aee6b75821f36b609163ea7b6757', './lib/core/Math/Formula/Function/Eval.php', '15.9', 0),
('45e8457c9754a665076d5def8e276bf6', './lib/core/Math/Formula/Function/Floor.php', '15.9', 0),
('700d63d57c6e0315e1b1ceec50ba8e5b', './lib/core/Math/Formula/Function/ForEach.php', '15.9', 0),
('59530c0433f51cbfbd13d665cbbde784', './lib/core/Math/Formula/Function/Hash.php', '15.9', 0),
('2ed942fc5519827b7c8c0e9ab5853da9', './lib/core/Math/Formula/Function/If.php', '15.9', 0),
('377af9ef308a00addd2b4c1a5b06f503', './lib/core/Math/Formula/Function/IsEmpty.php', '15.9', 0),
('d49db15cf99a0eb75c203c185a67118a', './lib/core/Math/Formula/Function/LessThan.php', '15.9', 0),
('ce0ecadd43beeb2f363beaad9090b5bf', './lib/core/Math/Formula/Function/Lower.php', '15.9', 0),
('0112deb4e174c0df0a75c849c858e6c2', './lib/core/Math/Formula/Function/Map.php', '15.9', 0),
('b7acaa3d0582edcfbbc87d322fee33a3', './lib/core/Math/Formula/Function/Max.php', '15.9', 0),
('d87dd56e2fe55b81c39d1812a5988c8a', './lib/core/Math/Formula/Function/Min.php', '15.9', 0),
('3112c0ab2d8eeb23d0abc4cd0d475812', './lib/core/Math/Formula/Function/MoreThan.php', '15.9', 0),
('ef10bc10e99d14d1f9041f24de5cffb1', './lib/core/Math/Formula/Function/Mul.php', '15.9', 0),
('a91fd8ed37ecee2f3f93a94a2b4287ab', './lib/core/Math/Formula/Function/Not.php', '15.9', 0),
('790b5539ea2f1bef692a97bfe91c4d6d', './lib/core/Math/Formula/Function/NotEquals.php', '15.9', 0),
('2c353823c36fd6efff586e6cd37aee45', './lib/core/Math/Formula/Function/Or.php', '15.9', 0),
('07a53cc98bd6862db42e93a990af0e51', './lib/core/Math/Formula/Function/Pad.php', '15.9', 0),
('ef1559be8b053cd8d50d84719790149b', './lib/core/Math/Formula/Function/Random.php', '15.9', 0),
('3d407e9936c0ee9d9d6d152d638f39b0', './lib/core/Math/Formula/Function/Round.php', '15.9', 0),
('c5a10ae3135651500723a259fa65971a', './lib/core/Math/Formula/Function/SplitList.php', '15.9', 0),
('11ab27cf98298f2a8ac217e5ebe454d7', './lib/core/Math/Formula/Function/Str.php', '15.9', 0),
('64183d0a0df1b962d88da6f8cc622006', './lib/core/Math/Formula/Function/Sub.php', '15.9', 0),
('4a382b879b752c262af535e52f83ec96', './lib/core/Math/Formula/Function/Substring.php', '15.9', 0),
('63fb8a3ffc16eefb1ef82ca769603f91', './lib/core/Math/Formula/Function/Upper.php', '15.9', 0),
('6e50621d86ac351b42e2288e3af3f3e4', './lib/core/Math/Formula/Function/index.php', '15.9', 0),
('18491a4213215c40cd9471db04ad7570', './lib/core/Math/Formula/InternalString.php', '15.9', 0),
('ae222d32de16968bc0c058294ed1e674', './lib/core/Math/Formula/Parser.php', '15.9', 0),
('29a23f2f7df497c6bba7fb75dcdd2a26', './lib/core/Math/Formula/Parser/Exception.php', '15.9', 0),
('6e50621d86ac351b42e2288e3af3f3e4', './lib/core/Math/Formula/Parser/index.php', '15.9', 0),
('e4535795643c99db5f64d789640ba653', './lib/core/Math/Formula/Runner.php', '15.9', 0),
('4510b3628ffc8709e3837996556465c2', './lib/core/Math/Formula/Runner/Exception.php', '15.9', 0),
('6e50621d86ac351b42e2288e3af3f3e4', './lib/core/Math/Formula/Runner/index.php', '15.9', 0),
('f8a4a75c1e1502997f013a3eb1552ba1', './lib/core/Math/Formula/Tokenizer.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Math/Formula/index.php', '15.9', 0),
('507d7192835c21e14d6b334b0e32c1c9', './lib/core/Math/index.php', '15.9', 0),
('5d0b5bac35e21bf3d3651464948bc05f', './lib/core/Multilingual/Aligner/BilingualAligner.php', '15.9', 0),
('5af5ae39d8555684c0168cf08e437408', './lib/core/Multilingual/Aligner/MockMTWrapper.php', '15.9', 0),
('8dd5298936198044c6b5b9b23c9ce829', './lib/core/Multilingual/Aligner/SentenceAlignments.php', '15.9', 0),
('1ffd9ddadb203492c8897f026c222075', './lib/core/Multilingual/Aligner/SentenceAlignments3.php', '15.9', 0),
('7575704f9e2794047d62826834a60461', './lib/core/Multilingual/Aligner/SentenceSegmentor.php', '15.9', 0),
('aeeb0223b80190c44cc0ad401aad0723', './lib/core/Multilingual/Aligner/ShortestPathFinder.php', '15.9', 0),
('cc6cebeeba7ece2d3b931cb601e64508', './lib/core/Multilingual/Aligner/UpdatePages.php', '15.9', 0),
('3a36b0e198ec940dc8439716b20b1e8d', './lib/core/Multilingual/Aligner/UpdateSentences.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Multilingual/Aligner/index.php', '15.9', 0),
('add1b47323856477ce918bb04f1598d9', './lib/core/Multilingual/MachineTranslation.php', '15.9', 0),
('f305f3dbec08988dd5c7a7472d078866', './lib/core/Multilingual/MachineTranslation/BingTranslateWrapper.php', '15.9', 0),
('89743dca7de46764005c850c76e82506', './lib/core/Multilingual/MachineTranslation/Cache.php', '15.9', 0),
('4b8ca0369ac5e22aafd20d0cd8a49929', './lib/core/Multilingual/MachineTranslation/GoogleTranslateWrapper.php', '15.9', 0),
('ec034368688076bc357baee41a6deac9', './lib/core/Multilingual/MachineTranslation/Interface.php', '15.9', 0),
('4fd275ea8e132df5bdd77cfbff645fae', './lib/core/Multilingual/MachineTranslation/Null.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Multilingual/MachineTranslation/index.php', '15.9', 0),
('507d7192835c21e14d6b334b0e32c1c9', './lib/core/Multilingual/index.php', '15.9', 0),
('c284f35076151cf29468e04cf802c377', './lib/core/Perms.php', '15.9', 0),
('fc0a9c9f1c0de9c3aae3df491be70644', './lib/core/Perms/Accessor.php', '15.9', 0),
('abdb80ff507bc020ebba2b1ed18e4ab2', './lib/core/Perms/Applier.php', '15.9', 0),
('31166d3a26515845738cc6093a3e1562', './lib/core/Perms/Builder.php', '15.9', 0),
('f2242c68d997fb58fe482d4f369a5d40', './lib/core/Perms/Check.php', '15.9', 0),
('56013f08fe6fc3aa242c31233bb74773', './lib/core/Perms/Check/Alternate.php', '15.9', 0),
('00af599118468f94a43c7213be249601', './lib/core/Perms/Check/Creator.php', '15.9', 0),
('c7024698a3a42973e98520e7f29f69bf', './lib/core/Perms/Check/Direct.php', '15.9', 0),
('734fd83e2a6766ab2a72435fd5ef3eb5', './lib/core/Perms/Check/Fixed.php', '15.9', 0),
('f7d75f02fee645ddeddd5f241896509c', './lib/core/Perms/Check/Indirect.php', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('ee6754389e094b28425bb5c46d97a901', './lib/core/Perms/Check/index.php', '15.9', 0),
('16331a3d7c6f97b2ee708493be076bd8', './lib/core/Perms/Context.php', '15.9', 0),
('0a90ebef2f443eca4d8ea5aa2fb7a741', './lib/core/Perms/Reflection/Category.php', '15.9', 0),
('4bec21c2c0fe455434c7652b752a8b2f', './lib/core/Perms/Reflection/Container.php', '15.9', 0),
('6d36b3b1fccee4a704950fd59153c6b5', './lib/core/Perms/Reflection/Factory.php', '15.9', 0),
('c4b0f7ecff9d72e1acd540cb3ee1fbd7', './lib/core/Perms/Reflection/Global.php', '15.9', 0),
('3b0208e4ba702325df3bc4f29e488022', './lib/core/Perms/Reflection/Object.php', '15.9', 0),
('c3a6be888778f947a59e89ef17ff2e52', './lib/core/Perms/Reflection/PermissionComparator.php', '15.9', 0),
('aec16a7b3a1e67e72d2b50f60f68f536', './lib/core/Perms/Reflection/PermissionSet.php', '15.9', 0),
('8a771f0a64b66386fcfd8d65e3673da3', './lib/core/Perms/Reflection/Quick.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Perms/Reflection/index.php', '15.9', 0),
('7d3b0997d609ffc09f204e4765683726', './lib/core/Perms/Resolver.php', '15.9', 0),
('3674eb3ab3a6fb28499fb92ac9653156', './lib/core/Perms/Resolver/Default.php', '15.9', 0),
('9ec66588ebeb59d6f4b66e40e87f34ba', './lib/core/Perms/Resolver/Static.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Perms/Resolver/index.php', '15.9', 0),
('ab26056cf52ecac80486a8ae1f8676bc', './lib/core/Perms/ResolverFactory.php', '15.9', 0),
('d7c9b815340778951355dfc610104ad5', './lib/core/Perms/ResolverFactory/CategoryFactory.php', '15.9', 0),
('ead177e86f89bdff5b9b2785fada246f', './lib/core/Perms/ResolverFactory/GlobalFactory.php', '15.9', 0),
('cae98f191159328612f74a93809cc0d5', './lib/core/Perms/ResolverFactory/ObjectFactory.php', '15.9', 0),
('1945a5df4189a821417d96919cf758ea', './lib/core/Perms/ResolverFactory/StaticFactory.php', '15.9', 0),
('fbdeb0ab46d0d115781e995f70a93f20', './lib/core/Perms/ResolverFactory/TestFactory.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Perms/ResolverFactory/index.php', '15.9', 0),
('507d7192835c21e14d6b334b0e32c1c9', './lib/core/Perms/index.php', '15.9', 0),
('37f9a89b74dcf0d7c9291eac3e5dd7b9', './lib/core/Report/Builder.js', '15.9', 0),
('ad8c9743cb8c02f999b3e0af57613a1e', './lib/core/Report/Builder.php', '15.9', 0),
('2fee09bc1b28326722262ab131acb928', './lib/core/Report/Definition/Logs.php', '15.9', 0),
('0363c5b70c0689851a4937748299c587', './lib/core/Report/Definition/Tracker.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Report/Definition/index.php', '15.9', 0),
('507d7192835c21e14d6b334b0e32c1c9', './lib/core/Report/index.php', '15.9', 0),
('3e4837a10e03f41179b75bb45053608f', './lib/core/Reports/Cache.php', '15.9', 0),
('cad6c336f77513ba1d5b72a47679e928', './lib/core/Reports/Factory.php', '15.9', 0),
('ccf9c5cff1c75d3ebdf68a3c5a457243', './lib/core/Reports/Manager.php', '15.9', 0),
('2c28f8256167302ddbacc21b6f443adc', './lib/core/Reports/Send.php', '15.9', 0),
('f7c3e68e132be7df194013193f386ad3', './lib/core/Reports/Send/EmailBuilder.php', '15.9', 0),
('c01612e432969821fea9b09c2e3147eb', './lib/core/Reports/Send/EmailBuilder/Abstract.php', '15.9', 0),
('286de1d53e9cd59f1101060f5cf3b1b1', './lib/core/Reports/Send/EmailBuilder/ArticleDeleted.php', '15.9', 0),
('5335e9d48e098007b46ccc456df16800', './lib/core/Reports/Send/EmailBuilder/ArticleEdited.php', '15.9', 0),
('0e6183a8e95cfba2b1c639d58470e472', './lib/core/Reports/Send/EmailBuilder/ArticleSubmitted.php', '15.9', 0),
('3546a5db8065c95c609707b807f2be2f', './lib/core/Reports/Send/EmailBuilder/BlogPost.php', '15.9', 0),
('d13fb96e23f26a47c3b6c03a6b7101a3', './lib/core/Reports/Send/EmailBuilder/CalendarChanged.php', '15.9', 0),
('f6d2d258312f87d04fbb10e5494859af', './lib/core/Reports/Send/EmailBuilder/CategoryChanged.php', '15.9', 0),
('276fdf1bd410b71e15d71dac2365aed9', './lib/core/Reports/Send/EmailBuilder/Factory.php', '15.9', 0),
('ec01621dc7bb3e2329ee1f200bd71f2e', './lib/core/Reports/Send/EmailBuilder/FileGalleryChanged.php', '15.9', 0),
('49eb5bd22fa16f1bf127186036d666a6', './lib/core/Reports/Send/EmailBuilder/ForumPostThread.php', '15.9', 0),
('e009ea8dd628cba307cb33394e666121', './lib/core/Reports/Send/EmailBuilder/ForumPostTopic.php', '15.9', 0),
('57feeabec0cefb7a9b0ee71542e5fce6', './lib/core/Reports/Send/EmailBuilder/ImageGalleryChanged.php', '15.9', 0),
('d354c65c6a50c05c2edd9f143d2404d7', './lib/core/Reports/Send/EmailBuilder/StructureAdd.php', '15.9', 0),
('698fac385cc07dcda7a2e868b5c69e2f', './lib/core/Reports/Send/EmailBuilder/StructureMoveDown.php', '15.9', 0),
('e71b7909b9a04ab5fa0fe2891cc97b7d', './lib/core/Reports/Send/EmailBuilder/StructureMoveUp.php', '15.9', 0),
('3eb2e88ff4583a923eec8b1d180989b5', './lib/core/Reports/Send/EmailBuilder/StructureRemove.php', '15.9', 0),
('067f34ea71889b7ee4423e1c71bd9da4', './lib/core/Reports/Send/EmailBuilder/TrackerFileAttachment.php', '15.9', 0),
('dba96e479805a06ecac0ff9262cddb1a', './lib/core/Reports/Send/EmailBuilder/TrackerItemComment.php', '15.9', 0),
('3ad5295f3483ddab8a66d53358008e36', './lib/core/Reports/Send/EmailBuilder/TrackerItemModified.php', '15.9', 0),
('5c53a522b3030c6bc668380b5a47d528', './lib/core/Reports/Send/EmailBuilder/WikiFileAttached.php', '15.9', 0),
('9ce34d1f98de1509704497c0e9f62880', './lib/core/Reports/Send/EmailBuilder/WikiPageChanged.php', '15.9', 0),
('c2116306f439ccd985cf2caa8dd4e8a1', './lib/core/Reports/Send/EmailBuilder/WikiPageCreated.php', '15.9', 0),
('c1d8e60ea76e211f89cb0e71ba16a634', './lib/core/Reports/Send/EmailBuilder/WikiPageDeleted.php', '15.9', 0),
('4492af1d7ba70f684108be5a138be904', './lib/core/Reports/Send/EmailBuilder/index.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Reports/Send/index.php', '15.9', 0),
('560ba5a42b26b5ff470b0c89096884db', './lib/core/Reports/Users.php', '15.9', 0),
('507d7192835c21e14d6b334b0e32c1c9', './lib/core/Reports/index.php', '15.9', 0),
('7585d9e24e1d3d4ad7562e9d2f9f29a6', './lib/core/Search/Action/Action.php', '15.9', 0),
('5d31895e027179867df754761e0647cb', './lib/core/Search/Action/ActionStep.php', '15.9', 0),
('9d095959fac2e1bcceba88f47f27f340', './lib/core/Search/Action/ChangeStatusAction.php', '15.9', 0),
('5a37d328dcc1ba3128812e514cdcb042', './lib/core/Search/Action/Delete.php', '15.9', 0),
('8605a6e86fda24738e6e3160afc780c0', './lib/core/Search/Action/EmailAction.php', '15.9', 0),
('c8a535106d74bc6faccdaf47f433d019', './lib/core/Search/Action/Factory.php', '15.9', 0),
('94e13e7fe122ca8bc90783133ce0c0dd', './lib/core/Search/Action/ReportingTransform.php', '15.9', 0),
('f15809d11c80a94db3047c8b09a6b66f', './lib/core/Search/Action/Sequence.php', '15.9', 0),
('44633facdc9fca424f900e76849f0acc', './lib/core/Search/Action/Step.php', '15.9', 0),
('b08287b5b70f6407556aa6c3ace59d5a', './lib/core/Search/Action/TrackerItemModify.php', '15.9', 0),
('984ccb8eebe34de05f02c6f1deb26e2f', './lib/core/Search/Action/UnknownStep.php', '15.9', 0),
('8990dab385ff843f630d02a507fe805a', './lib/core/Search/Action/WikiApprovalAction.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Search/Action/index.php', '15.9', 0),
('8926a065f95fe09795ecf27f07c8caa5', './lib/core/Search/AddonSource/Interface.php', '15.9', 0),
('cb0ccce905145b777dbdd3eba2ee4973', './lib/core/Search/ContentFilter/VersionNumber.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Search/ContentFilter/index.php', '15.9', 0),
('535ae3334662358f9819053456af9f6a', './lib/core/Search/ContentSource/ActivityStreamSource.php', '15.9', 0),
('8d59282210d9a77ffb51084985e1db02', './lib/core/Search/ContentSource/ArticleSource.php', '15.9', 0),
('61718c28ba8c8a408c0769347ffa1581', './lib/core/Search/ContentSource/BlogPostSource.php', '15.9', 0),
('761b16739e3744b64037316173522abe', './lib/core/Search/ContentSource/CategorySource.php', '15.9', 0),
('f743dbca9bb4cc3de10292cd00c28635', './lib/core/Search/ContentSource/CommentSource.php', '15.9', 0),
('93a81f51cf58613f5f9e02a3a61e830e', './lib/core/Search/ContentSource/FileGallerySource.php', '15.9', 0),
('aa4df7fa067e199ca208eea6776db0a0', './lib/core/Search/ContentSource/FileSource.php', '15.9', 0),
('98699a2c22e53bc8b9817da519e5b183', './lib/core/Search/ContentSource/ForumPostSource.php', '15.9', 0),
('f0ff311cf0cb665eb1c928569602a2f9', './lib/core/Search/ContentSource/ForumSource.php', '15.9', 0),
('f1497bf1ac5a8b4219d7b639b2e1e463', './lib/core/Search/ContentSource/GoalEventSource.php', '15.9', 0),
('b9dfca57c42ebd824fef56729e8683a5', './lib/core/Search/ContentSource/GroupSource.php', '15.9', 0),
('ee6b6031a6da16589e735e7c44b507f6', './lib/core/Search/ContentSource/Interface.php', '15.9', 0),
('ce5d7f7db0e5999f0b9b875d3fdf970d', './lib/core/Search/ContentSource/SheetSource.php', '15.9', 0),
('9455536ba8897d503639333403c86828', './lib/core/Search/ContentSource/Static.php', '15.9', 0),
('cacab958f7cc31b0bc3692c4461884a2', './lib/core/Search/ContentSource/TrackerFieldSource.php', '15.9', 0),
('7baeac51d9175b7e063530d472ba86e2', './lib/core/Search/ContentSource/TrackerItemSource.php', '15.9', 0),
('7968fc8dcd72ffc2b75b2bee8c83a55f', './lib/core/Search/ContentSource/TrackerSource.php', '15.9', 0),
('7e05dc82fd1145ada29c7b9103522e78', './lib/core/Search/ContentSource/UserSource.php', '15.9', 0),
('c92097732ffdf99ecc6ebb679130322b', './lib/core/Search/ContentSource/WikiSource.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Search/ContentSource/index.php', '15.9', 0),
('c6b72ac270221b516ea154ecb43de567', './lib/core/Search/Elastic/BulkOperation.php', '15.9', 0),
('e5f647058765d3cd25b86828b52bb526', './lib/core/Search/Elastic/Connection.php', '15.9', 0),
('588acdccc5518307923fc5994cf6b19e', './lib/core/Search/Elastic/Exception.php', '15.9', 0),
('2b8d94732a534bef0e1d2237a6d36c07', './lib/core/Search/Elastic/FacetBuilder.php', '15.9', 0),
('e599a3fc01384782dfb86fae44b9fe4b', './lib/core/Search/Elastic/FacetReader.php', '15.9', 0),
('95c1af905e2c14441468b328463e49ba', './lib/core/Search/Elastic/Index.php', '15.9', 0),
('224d4f903b16cd5432276c1362996025', './lib/core/Search/Elastic/MappingException.php', '15.9', 0),
('926e1e6600ff25d0ef126a04a21a091c', './lib/core/Search/Elastic/NotFoundException.php', '15.9', 0),
('c794ec258b2d476a4aad52bd1c07f031', './lib/core/Search/Elastic/NumberFormatException.php', '15.9', 0),
('548f8c26ed4c8f8258f9bad1c5eb058d', './lib/core/Search/Elastic/OrderBuilder.php', '15.9', 0),
('a563ab8d3c0b6263c99b5bb9dbaf3b7e', './lib/core/Search/Elastic/QueryBuilder.php', '15.9', 0),
('14595f330bce1d01d3cebe665ce6c831', './lib/core/Search/Elastic/QueryParsingException.php', '15.9', 0),
('6f89a173195d1373f9ca73457418a80a', './lib/core/Search/Elastic/RescoreQueryBuilder.php', '15.9', 0),
('8fbabf69cf42eefa58ee2f2ec274ff07', './lib/core/Search/Elastic/ResultSet.php', '15.9', 0),
('24a0fb00f953f8162ae2f96c27ed5ca9', './lib/core/Search/Elastic/SortException.php', '15.9', 0),
('a61ad2637e6d492783d8e21a2abde1f2', './lib/core/Search/Elastic/TransportException.php', '15.9', 0),
('b59f8d3aa5e39f0106fb4ffbfb7e6213', './lib/core/Search/Elastic/TypeFactory.php', '15.9', 0),
('9b5c715c9594854d4bc4a28d390db064', './lib/core/Search/Exception.php', '15.9', 0),
('0d89e7b2a367be2ec7facc413808ae72', './lib/core/Search/Expr/And.php', '15.9', 0),
('06d8d01ac940ae5c0661d63c6398d8e3', './lib/core/Search/Expr/ExplicitPhrase.php', '15.9', 0),
('e679deb1e550ed990e7b6eba2fbd86e4', './lib/core/Search/Expr/ImplicitPhrase.php', '15.9', 0),
('e4e1d3bc50e49965e2eab3ee035f2e7e', './lib/core/Search/Expr/Initial.php', '15.9', 0),
('37f1ceee434939dc4a7637442d945abe', './lib/core/Search/Expr/Interface.php', '15.9', 0),
('4d547249aa44fbdd004c595adfbe4fb5', './lib/core/Search/Expr/MoreLikeThis.php', '15.9', 0),
('dfd86d61f9acbc45fae002421c70b1c0', './lib/core/Search/Expr/Not.php', '15.9', 0),
('54be303f52a2f63fcd600e18fd89ed66', './lib/core/Search/Expr/Or.php', '15.9', 0),
('0fea16a6a24830d00e29809d60ef62b5', './lib/core/Search/Expr/Parser.php', '15.9', 0),
('fe870445c4d8a1b30915be9ea09e3aac', './lib/core/Search/Expr/Range.php', '15.9', 0),
('e376f78e04dda4a999bb91ee4d079cfb', './lib/core/Search/Expr/Token.php', '15.9', 0),
('11040b6bd8ed4709653f5414cac649fe', './lib/core/Search/Expr/Tokenizer.php', '15.9', 0),
('ee6754389e094b28425bb5c46d97a901', './lib/core/Search/Expr/index.php', '15.9', 0),
('3372fb16023e79a2b4cfd7c60ec2f217', './lib/core/Search/FacetProvider.php', '15.9', 0),
('369302888239c376ce2e494e1e8e86d3', './lib/core/Search/FacetProvider/Interface.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Search/FacetProvider/index.php', '15.9', 0),
('1fcd6f62cf700f6beb490ca19f994a73', './lib/core/Search/Federated/CompilerPass.php', '15.9', 0),
('4b5ea1909d68e7554afb99da78b8be77', './lib/core/Search/Federated/IndexInterface.php', '15.9', 0),
('311465d1bced89b1e0cff712505873d1', './lib/core/Search/Federated/ManifoldCfIndex.php', '15.9', 0),
('d34a730861b2627bdb64daa30874c565', './lib/core/Search/Federated/TikiIndex.php', '15.9', 0),
('039aad7f78d41495d7a1567ef3d5b741', './lib/core/Search/Federated/UrlPrefixTransform.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Search/Federated/index.php', '15.9', 0),
('5a9a179f3bb2ba790d0177154d027a61', './lib/core/Search/Formatter.php', '15.9', 0),
('3fa1fb1906d5ef493b06adf64b5ae711', './lib/core/Search/Formatter/AppendPagination.php', '15.9', 0),
('61e6b481051092c02fee84d77bbac7ba', './lib/core/Search/Formatter/ArrayBuilder.php', '15.9', 0),
('88ed377c88733ceaf72dedd62e9b5d07', './lib/core/Search/Formatter/Builder.php', '15.9', 0),
('7a568464b3c265d9e9bf0bee92a64018', './lib/core/Search/Formatter/DataSource/Declarative.php', '15.9', 0),
('d37d0e97367cf47dc8bb9f51e72512cb', './lib/core/Search/Formatter/DataSource/Interface.php', '15.9', 0),
('6e50621d86ac351b42e2288e3af3f3e4', './lib/core/Search/Formatter/DataSource/index.php', '15.9', 0),
('a4ffcb9c8afc5c53a565076fd53bb29b', './lib/core/Search/Formatter/Plugin/Interface.php', '15.9', 0),
('fa301d13a7197576ada340de54bf8a32', './lib/core/Search/Formatter/Plugin/SmartyTemplate.php', '15.9', 0),
('621a55e0c0d8ee2df7a8cd023acb7346', './lib/core/Search/Formatter/Plugin/WikiTemplate.php', '15.9', 0),
('6e50621d86ac351b42e2288e3af3f3e4', './lib/core/Search/Formatter/Plugin/index.php', '15.9', 0),
('19a2888aef436e39a1008f251531f9cc', './lib/core/Search/Formatter/Transform/DynamicLoader.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Search/Formatter/Transform/index.php', '15.9', 0),
('e36c8bce261448e43d7e0446dfc5ab9b', './lib/core/Search/Formatter/ValueFormatter.php', '15.9', 0),
('f9b413ff842fc9b6ba2b6e83bc7dfc21', './lib/core/Search/Formatter/ValueFormatter/Abstract.php', '15.9', 0),
('d632f83b53ba4288405b371702efd14e', './lib/core/Search/Formatter/ValueFormatter/Categorylist.php', '15.9', 0),
('36f4e44c6a4240e2f121fa15e4a5eecc', './lib/core/Search/Formatter/ValueFormatter/Date.php', '15.9', 0),
('501d7b183cb13e6f15a4bf84a49e89e4', './lib/core/Search/Formatter/ValueFormatter/Datetime.php', '15.9', 0),
('2b66b01873290e0557e5ee4112ea9ead', './lib/core/Search/Formatter/ValueFormatter/Imagegrabber.php', '15.9', 0),
('12dd10c08f83b18cf1521c254f6aa753', './lib/core/Search/Formatter/ValueFormatter/Interface.php', '15.9', 0),
('9ad8fef2bc01fd72c3cc878668a3c678', './lib/core/Search/Formatter/ValueFormatter/Objectlink.php', '15.9', 0),
('b50e23adc6ac831dd3686c65a68d0a29', './lib/core/Search/Formatter/ValueFormatter/Plain.php', '15.9', 0),
('1813439354ed1be4934964a5ead8de5b', './lib/core/Search/Formatter/ValueFormatter/Reference.php', '15.9', 0),
('d5194bbf0671756f4386db882915e292', './lib/core/Search/Formatter/ValueFormatter/Snippet.php', '15.9', 0),
('d8ac5f258894d8363e448ecf38e3d4a1', './lib/core/Search/Formatter/ValueFormatter/Sorthandle.php', '15.9', 0),
('2dc81769c87dd31ffd8242c248b395ae', './lib/core/Search/Formatter/ValueFormatter/Timeago.php', '15.9', 0),
('a37a6a794d75e338b221eef584b06921', './lib/core/Search/Formatter/ValueFormatter/Trackerrender.php', '15.9', 0),
('e7836ddee4454ecce38bd963d99234b0', './lib/core/Search/Formatter/ValueFormatter/Urlencode.php', '15.9', 0),
('d95f78623392fb78e87c594170176434', './lib/core/Search/Formatter/ValueFormatter/Wikiplugin.php', '15.9', 0),
('039ce2676049b9ba0da51d6bad515236', './lib/core/Search/Formatter/ValueFormatter/index.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Search/Formatter/index.php', '15.9', 0),
('f45c390acc7366fb99ca45961301f1e4', './lib/core/Search/GlobalSource/AdvancedRatingSource.php', '15.9', 0),
('b86c3f45a089840f0e7969e66b75197f', './lib/core/Search/GlobalSource/ArticleAttachmentSource.php', '15.9', 0),
('973fbe4587173f1158e39354fdf141df', './lib/core/Search/GlobalSource/CategorySource.php', '15.9', 0),
('8b7c73a9d05f4daf7c7e686c77d23093', './lib/core/Search/GlobalSource/CommentSource.php', '15.9', 0),
('053b661ff697f80896fab6e4f9cdd8c9', './lib/core/Search/GlobalSource/FileAttachmentSource.php', '15.9', 0),
('3f5043690892422d6d3880a390843ff6', './lib/core/Search/GlobalSource/FreeTagSource.php', '15.9', 0),
('33e7e8f6325df5a595d179afa4121042', './lib/core/Search/GlobalSource/Geolocation.php', '15.9', 0),
('e4ad80fff1b1d62f22881522c1bdee53', './lib/core/Search/GlobalSource/Interface.php', '15.9', 0),
('c7413720fe8cd9c5f4b6afcb6623f4b9', './lib/core/Search/GlobalSource/PermissionSource.php', '15.9', 0),
('890e64a277b9039b5640d2596dd468fb', './lib/core/Search/GlobalSource/RelationSource.php', '15.9', 0),
('1cd62558f316f54b497136dbe0408a4d', './lib/core/Search/GlobalSource/SearchableSource.php', '15.9', 0),
('95d3b958fb4c6f1808cd138ba66f49c4', './lib/core/Search/GlobalSource/SocialSource.php', '15.9', 0),
('95279b1c0dba87803ad89d48fcaea00a', './lib/core/Search/GlobalSource/Static.php', '15.9', 0),
('6f9831f217f8391810acb2046d7ee361', './lib/core/Search/GlobalSource/TitleInitialSource.php', '15.9', 0),
('f6773e65e19f4082b829450518f73841', './lib/core/Search/GlobalSource/UrlSource.php', '15.9', 0),
('f42b82bbfc78082f4f58df79acc1f495', './lib/core/Search/GlobalSource/VisitsSource.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Search/GlobalSource/index.php', '15.9', 0),
('ad0e13279c5880e549d1a1818256170e', './lib/core/Search/Index/AbstractIndexDecorator.php', '15.9', 0),
('7c2bf554f1507ed0d3414758106816bd', './lib/core/Search/Index/CategoryFilterDecorator.php', '15.9', 0),
('de9150352c04818305847ed1ea345b79', './lib/core/Search/Index/Interface.php', '15.9', 0),
('422ed6b1adf329fa08e9ca7a459285c9', './lib/core/Search/Index/Memory.php', '15.9', 0),
('dd81214c768b0f0671f62e8a0650fcac', './lib/core/Search/Index/QueryAlertDecorator.php', '15.9', 0),
('f3d9d54aa21fe1a7e9c6a695e4780f5f', './lib/core/Search/Index/QueryRepository.php', '15.9', 0),
('d8adb60612aac2c52c221b56cf313feb', './lib/core/Search/Index/TypeAnalysisDecorator.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Search/Index/index.php', '15.9', 0),
('1bff19d7d76b2343efa3c51c10fb5078', './lib/core/Search/Indexer.php', '15.9', 0),
('a62b450410be8d86f21b675337d3466c', './lib/core/Search/Lucene/HighlightHelper.php', '15.9', 0),
('14be77de2c22c7ec14f498f16a168bae', './lib/core/Search/Lucene/Index.php', '15.9', 0),
('98f8ed03efce6d26b3c7dcb8ad769f62', './lib/core/Search/Lucene/TypeFactory.php', '15.9', 0),
('d6d82e21815f0977defcbc12a1a69ba6', './lib/core/Search/MySql/Exception.php', '15.9', 0),
('bd16000893002b5d900c3f188b2bd6a3', './lib/core/Search/MySql/FieldQueryBuilder.php', '15.9', 0),
('3c81d95ee064b8b7e701eee50e24ebfe', './lib/core/Search/MySql/HighlightHelper.php', '15.9', 0),
('29055c7894fcdad6c0314ea2629fea4b', './lib/core/Search/MySql/Index.php', '15.9', 0),
('716153859baf31d164e4f7ed248f0bda', './lib/core/Search/MySql/LimitReachedException.php', '15.9', 0),
('7ff094b9d07ea5bbfc0e4379b7945b68', './lib/core/Search/MySql/QueryBuffer.php', '15.9', 0),
('e00c26d2a5c5e014a5c68660f47a648c', './lib/core/Search/MySql/QueryBuilder.php', '15.9', 0),
('8e446e39cabd847013dc99918b232688', './lib/core/Search/MySql/QueryException.php', '15.9', 0),
('896d6d3863f7b5cf00b7bf88037f0fd6', './lib/core/Search/MySql/Table.php', '15.9', 0),
('943689fee99a3825fd40c63ae80cbfad', './lib/core/Search/MySql/TypeFactory.php', '15.9', 0),
('9acb3a355e226713f9d1670bd1cb2c00', './lib/core/Search/Query.php', '15.9', 0),
('90e2b835dad18d479af9ccb27dd3267c', './lib/core/Search/Query/Facet/Interface.php', '15.9', 0),
('88491b5d8bf148916fcda0c1e3465922', './lib/core/Search/Query/Facet/Term.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Search/Query/Facet/index.php', '15.9', 0),
('9b52f0ef30e70aa3eadeeba6456442f7', './lib/core/Search/Query/FacetWikiBuilder.php', '15.9', 0),
('216ecb375db14eeec0fddbaac7db73da', './lib/core/Search/Query/Interface.php', '15.9', 0),
('76a25a352971532ca0e505128a1dfee6', './lib/core/Search/Query/Order.php', '15.9', 0),
('a0c4f79de9315cfd0ccb3d5ca088fe4d', './lib/core/Search/Query/Relation.php', '15.9', 0),
('36b0b90bad3d12cbd2f04ce8644a8238', './lib/core/Search/Query/RelationReplacer.php', '15.9', 0),
('cb827dc7908351398ff8244730264544', './lib/core/Search/Query/WeightCalculator/Field.php', '15.9', 0),
('af68cfe9b99053dc511672d13b020642', './lib/core/Search/Query/WeightCalculator/Interface.php', '15.9', 0),
('039ce2676049b9ba0da51d6bad515236', './lib/core/Search/Query/WeightCalculator/index.php', '15.9', 0),
('fb91d31c132ed7e434b1061ce8ce9ea8', './lib/core/Search/Query/WikiBuilder.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Search/Query/index.php', '15.9', 0),
('9ae26b1f6962f050697f3802c4ec2247', './lib/core/Search/ResultSet.php', '15.9', 0),
('9414cd7baa5951ced1276e3c3f1dab5e', './lib/core/Search/ResultSet/FacetFilter.php', '15.9', 0),
('742104989354dd4d5eb8453b23cff605', './lib/core/Search/ResultSet/SnippetHelper.php', '15.9', 0),
('979aa7194241f75ccefb4af8e6d7a8e9', './lib/core/Search/ResultSet/UrlHighlightTermsTransform.php', '15.9', 0),
('c5324ce1fec0499a01de9b6f1d55eee8', './lib/core/Search/ResultSet/WikiBuilder.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Search/ResultSet/index.php', '15.9', 0),
('5207e4ea1a5ef7bad184604096d3a539', './lib/core/Search/Type/Analyzer.php', '15.9', 0),
('543bc1ad862aa9aef53259874063c544', './lib/core/Search/Type/DateTime.php', '15.9', 0),
('28b325ade67b2a42fc29b5296b3475d5', './lib/core/Search/Type/Factory/Direct.php', '15.9', 0),
('b1edb67ece439f11bbd572af89a7fd8d', './lib/core/Search/Type/Factory/Interface.php', '15.9', 0),
('039ce2676049b9ba0da51d6bad515236', './lib/core/Search/Type/Factory/index.php', '15.9', 0),
('26f5eb10609a63823fc87ed96e1b7f36', './lib/core/Search/Type/Interface.php', '15.9', 0),
('5a74ce7b046d04bed5d77bb67097d5ad', './lib/core/Search/Type/MultivaluePlain.php', '15.9', 0),
('fcff9e7b3c014145fd1d47a22161d304', './lib/core/Search/Type/MultivalueText.php', '15.9', 0),
('7997d87c6634f8a8f05e635a8f4e2eed', './lib/core/Search/Type/Numeric.php', '15.9', 0),
('e9a3b5c7fa806534033e1940fc50f11c', './lib/core/Search/Type/PlainShortText.php', '15.9', 0),
('d0e79c281ee4a6cc9fe72603bdf2ac8f', './lib/core/Search/Type/PlainText.php', '15.9', 0),
('79b666e872b8bc6dbbed30c0848e72eb', './lib/core/Search/Type/ShortText.php', '15.9', 0),
('f4720466b09c6facfb66b0c35821c798', './lib/core/Search/Type/Timestamp.php', '15.9', 0),
('c812133d61e80b4279304aa1913eb1c1', './lib/core/Search/Type/Whole.php', '15.9', 0),
('dc388d63626700a2eee8f869c1ef3c78', './lib/core/Search/Type/WikiText.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Search/Type/index.php', '15.9', 0),
('0377192c72db7530ff416441dfe055e6', './lib/core/Search/index.php', '15.9', 0),
('2432a1a03737061b0451d0a58452655c', './lib/core/Services/Access/Controller.php', '15.9', 0),
('f8af15b8e080119ab7a35388f43d6915', './lib/core/Services/Access/index.php', '15.9', 0),
('2fc55cc243f16c3cee9e01894382906e', './lib/core/Services/ActivityStream/Controller.php', '15.9', 0),
('e403ccf04b37e42fedcd84778090332c', './lib/core/Services/ActivityStream/ManageController.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/ActivityStream/index.php', '15.9', 0),
('478ad76fff6e6065ac476b4099a3fda9', './lib/core/Services/Article/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/Article/index.php', '15.9', 0),
('84bcd0163f6fb0a533fd3243e928bf39', './lib/core/Services/Attribute/Controller.php', '15.9', 0),
('be85369379c27d960daf8c244af3bd0a', './lib/core/Services/AuthSource/Controller.php', '15.9', 0),
('6cbe0cc6a198782c598c96575ea7495e', './lib/core/Services/AuthSource/OAuthController.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/AuthSource/index.php', '15.9', 0),
('c9423287a68527d8710a97562a7aeb5a', './lib/core/Services/AutoSave/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/AutoSave/index.php', '15.9', 0),
('6b3a15bdf29a61fa8483f9efb27b5ac3', './lib/core/Services/BigBlueButton/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/BigBlueButton/index.php', '15.9', 0),
('6a79496b85502d0152e7014e3a5398f8', './lib/core/Services/Broker.php', '15.9', 0),
('f1d65bbdfd365430895f59115ef0e5b3', './lib/core/Services/Calendar/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/Calendar/index.php', '15.9', 0),
('5b98d3cec52f58cf7fc489d1e2b3756a', './lib/core/Services/Category/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Category/index.php', '15.9', 0),
('7e732714cb915b89a084fdbe41c90bb5', './lib/core/Services/Comment/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Comment/index.php', '15.9', 0),
('ae6ed50ec77c0c66e9ce99ce46df5fe4', './lib/core/Services/Connect/Client.php', '15.9', 0),
('c82063981ee939aa9140ded4ad9dc366', './lib/core/Services/Connect/Server.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Connect/index.php', '15.9', 0),
('60168534c5dac64588097deca5c324b0', './lib/core/Services/ContentTemplate/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/ContentTemplate/index.php', '15.9', 0),
('7f30a88a06e9d5b5648e8f3fd4be1397', './lib/core/Services/Draw/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Draw/index.php', '15.9', 0),
('13dbd5f3aabfa3e6cfbe3de552214f64', './lib/core/Services/Edit/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Edit/index.php', '15.9', 0),
('e71a1c68b33cfeec6b130859f3d2ffb2', './lib/core/Services/Exception.php', '15.9', 0),
('40fbe5326b42d49e3011cdd7c6665c6e', './lib/core/Services/Exception/BadRequest.php', '15.9', 0),
('b24f9bd9a3580f2f7dbf4205f375a771', './lib/core/Services/Exception/Denied.php', '15.9', 0),
('eeda6df32f15859087d8f9eb31c8e41b', './lib/core/Services/Exception/Disabled.php', '15.9', 0),
('28ee7c23f7f8d09bc186901652fb4cdf', './lib/core/Services/Exception/DuplicateValue.php', '15.9', 0),
('09c051a0215d7815aaf14e9bbf43f999', './lib/core/Services/Exception/FieldError.php', '15.9', 0),
('0ab6e9e62bffb57f3a7d20928dbe26cc', './lib/core/Services/Exception/MissingValue.php', '15.9', 0),
('95ae3b58a99acad4d4d27a914f610caf', './lib/core/Services/Exception/NotAvailable.php', '15.9', 0),
('7b5a5ecafffb463daf0f201452d6f7fd', './lib/core/Services/Exception/NotFound.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Exception/index.php', '15.9', 0),
('ac73a3d495c08341f16c083417871f2b', './lib/core/Services/File/Controller.php', '15.9', 0),
('f61a23be3552263666ee646468861d55', './lib/core/Services/File/FinderController.php', '15.9', 0),
('fd0c7e8b06f77c3a145f532dad92a31b', './lib/core/Services/File/Utilities.php', '15.9', 0),
('c53e775700862e5f08b4d8fb3fcdd06e', './lib/core/Services/File/VimeoController.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/File/index.php', '15.9', 0),
('11c9653b1c09848d6c922bd78a8f2b8c', './lib/core/Services/Forum/Controller.php', '15.9', 0),
('3181e811b55065852959ca43fdd60e6d', './lib/core/Services/Forum/index.php', '15.9', 0),
('3d1eaab1413694d66d7a7c08c9835ffd', './lib/core/Services/Goal/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/Goal/index.php', '15.9', 0),
('13e43094693d39bc93aced121c5ba39b', './lib/core/Services/JCapture/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/JCapture/index.php', '15.9', 0),
('87befebe1df30c1527faa3acad5c9630', './lib/core/Services/Kaltura/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/Kaltura/index.php', '15.9', 0),
('15f0986ae15f338ecaea5690b7cd2435', './lib/core/Services/Language/Controller.php', '15.9', 0),
('350efefb8d35fefe73248d85d42ad6b3', './lib/core/Services/Language/TranslationController.php', '15.9', 0),
('88413980252d10c1a9a4bf322206f692', './lib/core/Services/Language/Utilities.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Language/index.php', '15.9', 0),
('77679e5a19035a3a6c5cb5f63cdded53', './lib/core/Services/MailIn/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/MailIn/index.php', '15.9', 0),
('25f8a7602f24a6dadc27d1be378a0da4', './lib/core/Services/Menu/Controller.php', '15.9', 0),
('990e729c921c812a4c24ba472483ad6b', './lib/core/Services/Menu/index.php', '15.9', 0),
('c62c4f1783ca6e407798592cbcb0963c', './lib/core/Services/Module/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Module/index.php', '15.9', 0),
('e993c1830b7b90d9efa66fc46e14dfff', './lib/core/Services/MustRead/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/MustRead/index.php', '15.9', 0),
('9a3b77f09ab8f536d119a3acc73176c2', './lib/core/Services/Object/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Object/index.php', '15.9', 0),
('d2cf38d824f400e71f7d07abb2ffa940', './lib/core/Services/Payment/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Payment/index.php', '15.9', 0),
('c8e832c4027485b22481cfac6df3f5ea', './lib/core/Services/Rating/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Rating/index.php', '15.9', 0),
('4c0fb507e8c532948efa63263206e1c1', './lib/core/Services/Recommendation/DevelopmentController.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/Recommendation/index.php', '15.9', 0),
('980bad1802b9f09c5f934924e6b513c4', './lib/core/Services/Relation/Controller.php', '15.9', 0),
('a7454e37fa8108bc3206eca7c5a9dca5', './lib/core/Services/RemoteController.php', '15.9', 0),
('6904a253c86ddad59d1ec7afdc331a22', './lib/core/Services/Report/Controller.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Report/index.php', '15.9', 0),
('73a6a650043e56dd0efb633ef420c09f', './lib/core/Services/ResultLoader.php', '15.9', 0),
('778966fd9aa5f2efd23f62646f03b79b', './lib/core/Services/ResultLoader/WebService.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/ResultLoader/index.php', '15.9', 0),
('d662d775292c8279a0fdc6afeac39259', './lib/core/Services/Score/Controller.php', '15.9', 0),
('755a1b7171f0509e17a77ff3017252be', './lib/core/Services/Search/Controller.php', '15.9', 0),
('11501300f933000f409c5d6af6c4da58', './lib/core/Services/Search/CustomSearchController.php', '15.9', 0),
('f842540f605020316039f1658d94b483', './lib/core/Services/Search/ManifoldController.php', '15.9', 0),
('41e914e7c83d95dc3ab8f644ccea592c', './lib/core/Services/Search/StoredController.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/Search/index.php', '15.9', 0),
('e5b5d3bac1ec4a4cc3cf4a67a3e94991', './lib/core/Services/ShowTikiOrg/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/ShowTikiOrg/index.php', '15.9', 0),
('355b440d3a579582d82f7bbe5ba1d390', './lib/core/Services/Suite/Controller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/Suite/index.php', '15.9', 0),
('f01f91fc0315bd024ff35c7ae8555ec9', './lib/core/Services/Tracker/CalendarController.php', '15.9', 0),
('08af0992a986094d2d4905f3421a4f8b', './lib/core/Services/Tracker/Controller.php', '15.9', 0),
('d924e4f6496aaa7cfa500b93b64affa2', './lib/core/Services/Tracker/SyncController.php', '15.9', 0),
('2df809e18b264544b5b79211ba37aac1', './lib/core/Services/Tracker/TabularController.php', '15.9', 0),
('6c3f864ba086b79da60c286072fa81aa', './lib/core/Services/Tracker/TodoController.php', '15.9', 0),
('e350b253e374251131f64320265deaf5', './lib/core/Services/Tracker/Utilities.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Tracker/index.php', '15.9', 0),
('d5915d4602fd4e99934a3a6756912b0e', './lib/core/Services/User/ConditionsController.php', '15.9', 0),
('e89b8530d7cd41eca55944ed1f656e98', './lib/core/Services/User/Controller.php', '15.9', 0),
('cae5c97a745e8c010c34be54a6e53b8e', './lib/core/Services/User/FavoriteController.php', '15.9', 0),
('7270db026a12504fb4897fdbf4f67001', './lib/core/Services/User/MonitorController.php', '15.9', 0),
('eb14fbc78fa4963c68e4437448c7aa89', './lib/core/Services/User/SocialController.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/User/index.php', '15.9', 0),
('fd89806c0bd968599e585ab83a60d795', './lib/core/Services/Utilities/Controller.php', '15.9', 0),
('f8af15b8e080119ab7a35388f43d6915', './lib/core/Services/Utilities/index.php', '15.9', 0),
('d12281573d385a0abf5d341acd32e3b5', './lib/core/Services/Wiki/Controller.php', '15.9', 0),
('e1bdf36b0d3a51f14f46f6da7ba05d26', './lib/core/Services/Wiki/StructureController.php', '15.9', 0),
('5ef79ab1799aa16dd3d27ad879ce3751', './lib/core/Services/Wiki/index.php', '15.9', 0),
('5e57925b2b10581656e528fcfd8a1d04', './lib/core/Services/Workspace/Controller.php', '15.9', 0),
('2b8d8ba0234f6cf0f46f03f1390f4109', './lib/core/Services/Workspace/ProfileAnalyser.php', '15.9', 0),
('9be08053e242d7be205a812c8ecf209f', './lib/core/Services/Workspace/ProfileBuilder.php', '15.9', 0),
('77329cb5c5e47ff5fda52760860c73cd', './lib/core/Services/Workspace/Utilities.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Services/Workspace/index.php', '15.9', 0),
('75ba62719259581ae0266da505bdcbe4', './lib/core/Services/index.php', '15.9', 0),
('8173083f7d670377c816fb5af29d7e05', './lib/core/StandardAnalyzer/Analyzer/Standard.php', '15.9', 0),
('8c8007480dc1504b188d443bb3d1ef31', './lib/core/StandardAnalyzer/Analyzer/Standard/English.php', '15.9', 0),
('1915218057a6e338d0e1c7bc396cae7f', './lib/core/StandardAnalyzer/Analyzer/Standard/index.php', '15.9', 0),
('75c1818e1a9f32151a48db13fb8c1ba1', './lib/core/StandardAnalyzer/Analyzer/index.php', '15.9', 0),
('3f17271c8eeb52b95ca0f8d3e4b555ba', './lib/core/StandardAnalyzer/TokenFilter/EnglishStemmer.php', '15.9', 0),
('49234a01500b8c71257bb1b8fd883c1e', './lib/core/StandardAnalyzer/TokenFilter/EnglishStemmer/PorterStemmer.php', '15.9', 0),
('1915218057a6e338d0e1c7bc396cae7f', './lib/core/StandardAnalyzer/TokenFilter/EnglishStemmer/index.php', '15.9', 0),
('75c1818e1a9f32151a48db13fb8c1ba1', './lib/core/StandardAnalyzer/TokenFilter/index.php', '15.9', 0),
('75ba62719259581ae0266da505bdcbe4', './lib/core/StandardAnalyzer/index.php', '15.9', 0),
('98c563450c6008c669202b517543ba04', './lib/core/Table/Check.php', '15.9', 0),
('8fc7ddb64df3bf5723be3541fd9174b5', './lib/core/Table/Code/Abstract.php', '15.9', 0),
('3b4b67718a3f8a589dc22e2291e3eadb', './lib/core/Table/Code/Bind.php', '15.9', 0),
('43289213bf1d0296aa6bd53207bf1044', './lib/core/Table/Code/MainOptions.php', '15.9', 0),
('396eccce9f11228b458d1f6f5cad4372', './lib/core/Table/Code/Manager.php', '15.9', 0),
('b67daae25869285781dfb4ff96909bd4', './lib/core/Table/Code/Other.php', '15.9', 0),
('95af9f85ce53ff4b3d5e2f598bdd341e', './lib/core/Table/Code/WidgetOptions.php', '15.9', 0),
('50f0adc8d146543aa864c495b2373399', './lib/core/Table/Code/WidgetOptionsFilter.php', '15.9', 0),
('aed216f6abb75578fdb2e54deabe2c55', './lib/core/Table/Code/WidgetOptionsMath.php', '15.9', 0),
('322115ec08f2b37b47e7d2ba14b6b534', './lib/core/Table/Code/WidgetOptionsPager.php', '15.9', 0),
('4988d9010100a0956fee4492acb256a6', './lib/core/Table/Code/index.php', '15.9', 0),
('6ac96477749d78a0ed7507e7e2799035', './lib/core/Table/Factory.php', '15.9', 0),
('65d711cf00a388914972f7dd59cc22c5', './lib/core/Table/Manager.php', '15.9', 0),
('62750071b0c519153525368a92735704', './lib/core/Table/Plugin.php', '15.9', 0),
('1617d45f87eaa674768990a502de62ce', './lib/core/Table/Settings/Abstract.php', '15.9', 0),
('129edbf9bb3e0542def71e2d78233489', './lib/core/Table/Settings/Plugin.php', '15.9', 0),
('facf824f9541015cc5f3d0575458f985', './lib/core/Table/Settings/PluginWithAjax.php', '15.9', 0),
('a396886ad274fdf6234b35fb2f1a3bde', './lib/core/Table/Settings/Standard.php', '15.9', 0),
('f59b14467815743bb84ff0ddb46cc714', './lib/core/Table/Settings/TikiAdminForums.php', '15.9', 0),
('04e90d34f40bff730c81bead8ad05b81', './lib/core/Table/Settings/TikiAdminusers.php', '15.9', 0),
('13fcb9a1ec463bed06cdd35e14aed971', './lib/core/Table/Settings/TikiForums.php', '15.9', 0),
('6725348bf2aa874cdf6a537636bd9533', './lib/core/Table/Settings/TikiListpages.php', '15.9', 0),
('79cd21c37a8d9c825db6a9f43b819d00', './lib/core/Table/Settings/TikiPayment.php', '15.9', 0),
('ad757dfdf03a32fd25f528aaa6da7df9', './lib/core/Table/Settings/TikiPaymentPast.php', '15.9', 0),
('feb256bc661a47ed3353e6a70599d84c', './lib/core/Table/Settings/TikiViewforum.php', '15.9', 0),
('37662c33035038fe7ef67b11cca7dce7', './lib/core/Table/Settings/index.php', '15.9', 0),
('1376cd22ebf2620f345329379c707565', './lib/core/Table/Totals.php', '15.9', 0),
('9cb891d19ac0a3658ec614d91172bd1b', './lib/core/Table/index.php', '15.9', 0),
('3106c3e173f44926e15367897cd950d6', './lib/core/Tiki/BigBlueButton/Configuration.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/BigBlueButton/index.php', '15.9', 0),
('96a4519ad6b9d3a18fa5ad23c5902aca', './lib/core/Tiki/Command/AddonInstallCommand.php', '15.9', 0),
('ec09cbada75985dba6379da6298a2de2', './lib/core/Tiki/Command/AddonRemoveCommand.php', '15.9', 0),
('045648b70700fe1f68da0cc6d59bd921', './lib/core/Tiki/Command/AddonUpgradeCommand.php', '15.9', 0),
('797c14a077f2b99088a6923d0b7b721a', './lib/core/Tiki/Command/Application.php', '15.9', 0),
('76e621eb0de0cf8fe55312052f22f8fd', './lib/core/Tiki/Command/BackupDBCommand.php', '15.9', 0),
('50b73211b66c214564885c239d494ca1', './lib/core/Tiki/Command/BackupFilesCommand.php', '15.9', 0),
('fc0b2d857c20601a419e0f8e6dd1db48', './lib/core/Tiki/Command/CacheClearCommand.php', '15.9', 0),
('a5a135a744a2bb6baad09cc91f27b5e7', './lib/core/Tiki/Command/ConfigureCommand.php', '15.9', 0),
('1b220f189cb1e17be45fec9326b57da7', './lib/core/Tiki/Command/DailyReportSendCommand.php', '15.9', 0),
('a94f4719e6d0502e21cc8346c05d0c88', './lib/core/Tiki/Command/FilesBatchuploadCommand.php', '15.9', 0),
('df82fbd3f560ee9ba39df2a3af32f825', './lib/core/Tiki/Command/FilesCopyCommand.php', '15.9', 0),
('bd0198cce21add1f2d54f1a95b661197', './lib/core/Tiki/Command/FilesDeleteoldCommand.php', '15.9', 0),
('2dc71c2a60e9b76762924693103fc40c', './lib/core/Tiki/Command/FilesMoveCommand.php', '15.9', 0),
('6018823f4e1eaed0e5253671c5bb4ed8', './lib/core/Tiki/Command/GoalCheckCommand.php', '15.9', 0),
('f1c3ab85d9f435d12395727c7fd53472', './lib/core/Tiki/Command/IndexCatchUpCommand.php', '15.9', 0),
('c272bb4ca8b67afcc72c48adc32531b6', './lib/core/Tiki/Command/IndexOptimizeCommand.php', '15.9', 0),
('9bd2267197d8132540904ebe295f3743', './lib/core/Tiki/Command/IndexRebuildCommand.php', '15.9', 0),
('b5da6ecac5dde9cc015b249f86280921', './lib/core/Tiki/Command/InstallCommand.php', '15.9', 0),
('a3dd80c50ca16ac8244d3cf4a99b6941', './lib/core/Tiki/Command/LessCompileCommand.php', '15.9', 0),
('c13853368b1b44d9a223624401d84e65', './lib/core/Tiki/Command/ListExecuteCommand.php', '15.9', 0),
('46a264882b66884d4ed3d005b54c71df', './lib/core/Tiki/Command/MailInPollCommand.php', '15.9', 0),
('acc33ce77c686b48a892c490b65220b6', './lib/core/Tiki/Command/MailQueueSendCommand.php', '15.9', 0),
('28ddc308af61d7aab6e16c627324910a', './lib/core/Tiki/Command/MultiTikiListCommand.php', '15.9', 0),
('cbbaa0ec8c68a595a22976bcc155ab14', './lib/core/Tiki/Command/MultiTikiMoveCommand.php', '15.9', 0),
('8413d933cceb0556d0b30340118b5845', './lib/core/Tiki/Command/NotificationDigestCommand.php', '15.9', 0),
('1acde47098a03c612307b532a1acd856', './lib/core/Tiki/Command/ProfileBaselineCommand.php', '15.9', 0),
('439b205dfc35380d5d6c153f8672add4', './lib/core/Tiki/Command/ProfileExport/ActivityRuleSet.php', '15.9', 0),
('2365c94d007a7c96d7ad79ba7bfa659c', './lib/core/Tiki/Command/ProfileExport/ActivityStreamRule.php', '15.9', 0),
('00ac8162e336bd2f6cc990f1dd4df459', './lib/core/Tiki/Command/ProfileExport/AllModules.php', '15.9', 0),
('0e1c7e224cf08a8388ace6d4d1e05cef', './lib/core/Tiki/Command/ProfileExport/Article.php', '15.9', 0),
('0005d32dc36103288ddc3b0b4a754ec2', './lib/core/Tiki/Command/ProfileExport/ArticleTopic.php', '15.9', 0),
('b0ede11f1d768e7b2a88a98bf7125e5b', './lib/core/Tiki/Command/ProfileExport/ArticleType.php', '15.9', 0),
('de2b8d8de1b55e3e02925a95a2484f71', './lib/core/Tiki/Command/ProfileExport/Category.php', '15.9', 0),
('e6204a25dbf3f69f0ea9419078887381', './lib/core/Tiki/Command/ProfileExport/FileGallery.php', '15.9', 0),
('83a126dbd4c96a74baa96bf4aafd2a4e', './lib/core/Tiki/Command/ProfileExport/Finalize.php', '15.9', 0),
('f519065bacc8dc7a36310c38165e130c', './lib/core/Tiki/Command/ProfileExport/Forum.php', '15.9', 0),
('1fff3f37d8aeeb168ca0cbdabbebaea2', './lib/core/Tiki/Command/ProfileExport/Goal.php', '15.9', 0),
('86af5ebaa17592bb64863edb5541f5b1', './lib/core/Tiki/Command/ProfileExport/GoalSet.php', '15.9', 0),
('fef332c25e6ccbed14f769afc5e0bac3', './lib/core/Tiki/Command/ProfileExport/Group.php', '15.9', 0),
('3c166e70a8fe8c4cd3d2647fd0e438f2', './lib/core/Tiki/Command/ProfileExport/IncludeProfile.php', '15.9', 0),
('c3ca6eec3990b77435217bceea60a8bf', './lib/core/Tiki/Command/ProfileExport/Init.php', '15.9', 0),
('6f943021ddcd84520af4e591aacd2041', './lib/core/Tiki/Command/ProfileExport/Menu.php', '15.9', 0),
('1bc93eeb94c265824c3d01b9fa5a9293', './lib/core/Tiki/Command/ProfileExport/Module.php', '15.9', 0),
('383535cd5420a246472bb3b3d5ed1249', './lib/core/Tiki/Command/ProfileExport/ObjectWriter.php', '15.9', 0),
('ee5548d3a206931c14723fbab7967780', './lib/core/Tiki/Command/ProfileExport/Preference.php', '15.9', 0),
('98ad43fc2579c8670959a37580c56df9', './lib/core/Tiki/Command/ProfileExport/RatingConfig.php', '15.9', 0),
('fbc93c5bc7e036bad7eda0426169affb', './lib/core/Tiki/Command/ProfileExport/RatingConfigSet.php', '15.9', 0),
('9a967e8dc0a875e9bc25bf4477cceb44', './lib/core/Tiki/Command/ProfileExport/RecentChanges.php', '15.9', 0),
('7218d614dbfd46ad980c76e929b26605', './lib/core/Tiki/Command/ProfileExport/Rss.php', '15.9', 0),
('ea8050b45fc3ec8454b8e63791121c18', './lib/core/Tiki/Command/ProfileExport/Tracker.php', '15.9', 0),
('ab9aa145852385ffe18fb89d0db72dc0', './lib/core/Tiki/Command/ProfileExport/TrackerField.php', '15.9', 0),
('93517643caba57141f834ac50f2807f4', './lib/core/Tiki/Command/ProfileExport/WikiPage.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Command/ProfileExport/index.php', '15.9', 0),
('1a4658298cb760d42229f49c23c13059', './lib/core/Tiki/Command/ProfileForgetCommand.php', '15.9', 0),
('a7dc9dfced7043d701e9470ca23ae645', './lib/core/Tiki/Command/ProfileInstallCommand.php', '15.9', 0),
('4b997791f110bdf0fd979c05b027ee73', './lib/core/Tiki/Command/RecommendationBatchCommand.php', '15.9', 0),
('e9c964088c86b6e752bf575ad5b82989', './lib/core/Tiki/Command/RedactDBCommand.php', '15.9', 0),
('1ad6ab34cfb9e0fcaf6aa28a6532d267', './lib/core/Tiki/Command/RefreshRssCommand.php', '15.9', 0),
('884e9c5a14a2b220dcf8eed94952c8c0', './lib/core/Tiki/Command/RssClearCacheCommand.php', '15.9', 0),
('f66b383030f161ccd2e9355c97b2d409', './lib/core/Tiki/Command/TrackerClearCommand.php', '15.9', 0),
('6d15a777dbd91ee76ef046a2acb74a01', './lib/core/Tiki/Command/TrackerImportCommand.php', '15.9', 0),
('19bf55ca75bf594c6b340b8ac54d0d52', './lib/core/Tiki/Command/UnavailableCommand.php', '15.9', 0),
('5fada6b084a00b5144b8c3ca4b2a6ea9', './lib/core/Tiki/Command/UpdateCommand.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Command/index.php', '15.9', 0),
('56c6a38ff26883e64f2b4ebb79c1961a', './lib/core/Tiki/Composer/BootstrapCompiler.php', '15.9', 0),
('8467be148bf331b0f68a5b9e69f2f65a', './lib/core/Tiki/Composer/CleanVendors.php', '15.9', 0),
('079ffbcae61927f9fda185f3bb9c4f25', './lib/core/Tiki/Composer/ThemeInstaller.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Composer/index.php', '15.9', 0),
('e0c07b83d7f1c76f13db58a1b91165ba', './lib/core/Tiki/Config/Ini.php', '15.9', 0),
('1d31a2eed09cbb8f1f2fd17137951cdd', './lib/core/Tiki/Config/index.php', '15.9', 0),
('016efe833c5a692876cf572cd78bc0b8', './lib/core/Tiki/Connect/Abstract.php', '15.9', 0),
('de5c6ff7b1a5f0e792e3172932d17786', './lib/core/Tiki/Connect/Client.php', '15.9', 0),
('962a38cc99ba9bc19a29021a7b782b56', './lib/core/Tiki/Connect/Server.php', '15.9', 0),
('75ba62719259581ae0266da505bdcbe4', './lib/core/Tiki/Connect/index.php', '15.9', 0),
('b4cce41bdbdf7c85e8579357966655db', './lib/core/Tiki/Editable/Value.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Editable/index.php', '15.9', 0),
('006af90f33969b1fe5c17585813e58b0', './lib/core/Tiki/Event/Chain.php', '15.9', 0),
('2638f75aded40f9ac3a45b9a45b6fca8', './lib/core/Tiki/Event/Customizer.php', '15.9', 0),
('ff1be3e83ae8f22d8b172a6040480dc0', './lib/core/Tiki/Event/Customizer/Executor.php', '15.9', 0),
('136344553679766385581a5167e7cc53', './lib/core/Tiki/Event/Customizer/RuleSet.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Event/Customizer/index.php', '15.9', 0),
('1a7b99f300f0cb87932f9820d8547e44', './lib/core/Tiki/Event/EdgeProvider.php', '15.9', 0),
('735ecbde774610dcc3a7b6e48056f6ad', './lib/core/Tiki/Event/Function/EventNotify.php', '15.9', 0),
('22b5ea6849c5b5d3a4b19399cf6e0ca0', './lib/core/Tiki/Event/Function/EventRecord.php', '15.9', 0),
('fb56dba9a1c3f439c4d460c40cbc15b4', './lib/core/Tiki/Event/Function/EventSample.php', '15.9', 0),
('009a18a2c6bbd2da74972ba9fae7c869', './lib/core/Tiki/Event/Function/EventTrigger.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Event/Function/index.php', '15.9', 0),
('71c62235edad8fb3a2d8ac3a869a33b0', './lib/core/Tiki/Event/Lib.php', '15.9', 0),
('35b6146a3a9972e7502ea166e32d3405', './lib/core/Tiki/Event/Manager.php', '15.9', 0),
('75ba62719259581ae0266da505bdcbe4', './lib/core/Tiki/Event/index.php', '15.9', 0),
('e53b88c14dfcca44daf2dae686644960', './lib/core/Tiki/FileGallery/Definition.php', '15.9', 0),
('8004f4c5a6742cbeae790206adec4ed6', './lib/core/Tiki/FileGallery/File.php', '15.9', 0),
('73bc5685180df3105ad1d509225ffa9d', './lib/core/Tiki/FileGallery/FileWrapper/PhysicalFile.php', '15.9', 0),
('177be426ae8b1ace48d6b20d29ecb645', './lib/core/Tiki/FileGallery/FileWrapper/PreloadedContent.php', '15.9', 0),
('dd916b192339a7391fcaff136991970b', './lib/core/Tiki/FileGallery/FileWrapper/WrapperInterface.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/FileGallery/FileWrapper/index.php', '15.9', 0),
('efdf48a539a28184374cf089d05a72b0', './lib/core/Tiki/FileGallery/Handler/FileSystem.php', '15.9', 0),
('a342f373497b9f3e28c36e285e2e9dd4', './lib/core/Tiki/FileGallery/Handler/HandlerInterface.php', '15.9', 0),
('b03994421d2f1146ba7d47e17b233ab4', './lib/core/Tiki/FileGallery/Handler/Podcast.php', '15.9', 0),
('af9a5c269b7395d90503bc8d5158aabb', './lib/core/Tiki/FileGallery/Handler/Preloaded.php', '15.9', 0),
('d1d06c74ecfd3b9f72fec3cda4d9e4bc', './lib/core/Tiki/FileGallery/Handler/System.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/FileGallery/Handler/index.php', '15.9', 0),
('75ba62719259581ae0266da505bdcbe4', './lib/core/Tiki/FileGallery/index.php', '15.9', 0),
('5f87e8bb0fee61d0285f290dff3ce01d', './lib/core/Tiki/MailIn/Account.php', '15.9', 0),
('ac947b295a7180f07fdc1b4f53228912', './lib/core/Tiki/MailIn/Action/ActionInterface.php', '15.9', 0),
('307957a9eb68a128b2dc6bc4d629302b', './lib/core/Tiki/MailIn/Action/ArticlePut.php', '15.9', 0),
('b35b84f0de892cc827cdefcae357226e', './lib/core/Tiki/MailIn/Action/Comment.php', '15.9', 0),
('6be3c57f13ea793e40ff0e67b8c7da1e', './lib/core/Tiki/MailIn/Action/DirectFactory.php', '15.9', 0),
('7ee87474f4bd01d5b1fd7d2c321b5b30', './lib/core/Tiki/MailIn/Action/FactoryInterface.php', '15.9', 0),
('92645d128584e7142845c48e35b16fea', './lib/core/Tiki/MailIn/Action/RecipientPlaceholderFactory.php', '15.9', 0),
('6066cab897ade99fa51ee927d2def477', './lib/core/Tiki/MailIn/Action/SubjectPrefixFactory.php', '15.9', 0),
('25b63ab08ea57a2f42249e8356bc37ef', './lib/core/Tiki/MailIn/Action/WikiAppend.php', '15.9', 0),
('d146e62f1d0ce77479aa92987656a3d2', './lib/core/Tiki/MailIn/Action/WikiGet.php', '15.9', 0),
('52b42b7061aeecaf23420bca98bdc429', './lib/core/Tiki/MailIn/Action/WikiPrepend.php', '15.9', 0),
('3e69fd7643026b8917712bfdc430b777', './lib/core/Tiki/MailIn/Action/WikiPut.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/MailIn/Action/index.php', '15.9', 0),
('cfe223cd85c598808adea4ed46514cab', './lib/core/Tiki/MailIn/Exception/MailInException.php', '15.9', 0),
('9054e037225064d74adc291d61e3d3f8', './lib/core/Tiki/MailIn/Exception/TransportException.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/MailIn/Exception/index.php', '15.9', 0),
('fef7ba51497de1609a0fcd21ef923aeb', './lib/core/Tiki/MailIn/Provider/ArticlePutProvider.php', '15.9', 0),
('ab6413c37aea4009952d1ff12f438949', './lib/core/Tiki/MailIn/Provider/BasicWikiProvider.php', '15.9', 0),
('0c5c71b641dc867dda3fd4ecc18cf1e1', './lib/core/Tiki/MailIn/Provider/CompilerPass.php', '15.9', 0),
('dcbe166d7a5d4fbe357dc991ac1f842b', './lib/core/Tiki/MailIn/Provider/ProviderInterface.php', '15.9', 0),
('c27f977d9fa6980a069d91b9df458777', './lib/core/Tiki/MailIn/Provider/ProviderList.php', '15.9', 0),
('b9e6da00971c6daf132847f0d419f1f7', './lib/core/Tiki/MailIn/Provider/ReplyHandlerProvider.php', '15.9', 0),
('54918336c6012216ecdc6f1150061113', './lib/core/Tiki/MailIn/Provider/WikiMultipleProvider.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/MailIn/Provider/index.php', '15.9', 0),
('47d52fc774d62f60fead186066695d5e', './lib/core/Tiki/MailIn/Source/Imap.php', '15.9', 0),
('36dcfdc544ebdba9cfb479998fba8921', './lib/core/Tiki/MailIn/Source/Message.php', '15.9', 0),
('60b44a2f5f3cef57b04158f97b47d1bd', './lib/core/Tiki/MailIn/Source/Pop3.php', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('3081bf698885f4e12c8f2a76f84b2bc2', './lib/core/Tiki/MailIn/Source/SourceInterface.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/MailIn/Source/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/MailIn/index.php', '15.9', 0),
('3b73a646bed528133cff524339d5ddbf', './lib/core/Tiki/MemoryLimit.php', '15.9', 0),
('92e778c32985a6888d411813186364d2', './lib/core/Tiki/Object/Selector.php', '15.9', 0),
('145e2eabca5b1d250cfea10c8000bf01', './lib/core/Tiki/Object/SelectorItem.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Object/index.php', '15.9', 0),
('9342bbcb8fa4b0241da2e310069c7771', './lib/core/Tiki/PageCache.php', '15.9', 0),
('9ee31549b312c6b3ba8754c8aecb965a', './lib/core/Tiki/Profile.php', '15.9', 0),
('31db53df2b1c3d7e793dcdc580b1d5a5', './lib/core/Tiki/Profile/ChannelList.php', '15.9', 0),
('54578738a2e4582d66abe3c91da27163', './lib/core/Tiki/Profile/Converter.php', '15.9', 0),
('173428e86a9a98dbd71f01992b9084e9', './lib/core/Tiki/Profile/DateConverter.php', '15.9', 0),
('4070f3d214d1397737f789257d70e884', './lib/core/Tiki/Profile/InstallHandler.php', '15.9', 0),
('83c4b83c3e9b8ea8cf0bcf33ce8d8e59', './lib/core/Tiki/Profile/InstallHandler/ActivityRuleSet.php', '15.9', 0),
('0430d6aae62663c2cefe4ad5231dd43e', './lib/core/Tiki/Profile/InstallHandler/ActivityStreamRule.php', '15.9', 0),
('f84ce7b1115bcf33b3ca0f5a6770e33c', './lib/core/Tiki/Profile/InstallHandler/AreaBinding.php', '15.9', 0),
('be77f5b2e2355b751f998e75000fcc0b', './lib/core/Tiki/Profile/InstallHandler/Article.php', '15.9', 0),
('c03ae21be590452ef60f947af3026516', './lib/core/Tiki/Profile/InstallHandler/ArticleTopic.php', '15.9', 0),
('eef5c3e872e5623c49f113dd8460a4cd', './lib/core/Tiki/Profile/InstallHandler/ArticleType.php', '15.9', 0),
('b4f5d965c4695e8ad5915674e89ef9b0', './lib/core/Tiki/Profile/InstallHandler/Blog.php', '15.9', 0),
('011af2b0bd02f47462c34e9527383f07', './lib/core/Tiki/Profile/InstallHandler/BlogPost.php', '15.9', 0),
('ff01961a304bf12f7427ce1526dbf3dc', './lib/core/Tiki/Profile/InstallHandler/Calendar.php', '15.9', 0),
('b511f9e734416cea3e6e7886a59796f0', './lib/core/Tiki/Profile/InstallHandler/Categorize.php', '15.9', 0),
('b4a1f5b3714130c629caf261b5e0378b', './lib/core/Tiki/Profile/InstallHandler/Category.php', '15.9', 0),
('3cc63a58d86079e7ac24d56daf5ac765', './lib/core/Tiki/Profile/InstallHandler/DataChannel.php', '15.9', 0),
('13eebb377b6140920f1e7a7026bf9669', './lib/core/Tiki/Profile/InstallHandler/ExtWiki.php', '15.9', 0),
('affc7b638b6a300bff2aabd8e0816c2c', './lib/core/Tiki/Profile/InstallHandler/FileGallery.php', '15.9', 0),
('30d74ba7be25281aea54e89a55361290', './lib/core/Tiki/Profile/InstallHandler/Forum.php', '15.9', 0),
('2fdc2811a28afac1cd3f3164e7f2d2db', './lib/core/Tiki/Profile/InstallHandler/Goal.php', '15.9', 0),
('49d6fb7e1cd1c648b0b1c4d78fe70126', './lib/core/Tiki/Profile/InstallHandler/GoalSet.php', '15.9', 0),
('2d540d509c91fee6d27842e3a0d67f35', './lib/core/Tiki/Profile/InstallHandler/Menu.php', '15.9', 0),
('bb5917fa751c03661fdc96eaaad3de44', './lib/core/Tiki/Profile/InstallHandler/MenuOption.php', '15.9', 0),
('83f1c21370dfa031c8b60d074590727f', './lib/core/Tiki/Profile/InstallHandler/Module.php', '15.9', 0),
('eaf2828b905c557b7e71e1f5f2fe405b', './lib/core/Tiki/Profile/InstallHandler/Perspective.php', '15.9', 0),
('bc29d8d59d379379af80780812481cc3', './lib/core/Tiki/Profile/InstallHandler/PluginAlias.php', '15.9', 0),
('9281773d585c8da3294b4c711768a542', './lib/core/Tiki/Profile/InstallHandler/RatingConfig.php', '15.9', 0),
('78a2f9efc0b130e91be3cb1b442ed8de', './lib/core/Tiki/Profile/InstallHandler/RatingConfigSet.php', '15.9', 0),
('72930a3bab369cf197b52c94dd826a70', './lib/core/Tiki/Profile/InstallHandler/Rss.php', '15.9', 0),
('1e41e3e34d42e8af240d01ad582ae584', './lib/core/Tiki/Profile/InstallHandler/Sheet.php', '15.9', 0),
('bf8030b9e271d6cd5a36f720e5fd844f', './lib/core/Tiki/Profile/InstallHandler/Template.php', '15.9', 0),
('02916180cee250c77c396cf55c141cad', './lib/core/Tiki/Profile/InstallHandler/Tracker.php', '15.9', 0),
('8d2f690a7ce99c9f4e61337aff85acab', './lib/core/Tiki/Profile/InstallHandler/TrackerField.php', '15.9', 0),
('eff717796031ab634d1b8090cb034244', './lib/core/Tiki/Profile/InstallHandler/TrackerItem.php', '15.9', 0),
('fce49a5c81de2b814f7aabc7e433efed', './lib/core/Tiki/Profile/InstallHandler/TrackerOption.php', '15.9', 0),
('c212f91e0bd329edc3103d0fa29cfad1', './lib/core/Tiki/Profile/InstallHandler/Transition.php', '15.9', 0),
('b1bd1bcc307d9471219830728747fdf6', './lib/core/Tiki/Profile/InstallHandler/User.php', '15.9', 0),
('3e88edbfba80dbe047d6699c4f4e10fc', './lib/core/Tiki/Profile/InstallHandler/Webmail.php', '15.9', 0),
('c0f818872eb9b287e7970aab8a62d46e', './lib/core/Tiki/Profile/InstallHandler/WebmailAccount.php', '15.9', 0),
('eebfab8e2ca2edb0f937b78f53463c8c', './lib/core/Tiki/Profile/InstallHandler/Webservice.php', '15.9', 0),
('4c77c8756f5b69322c539600e062ee14', './lib/core/Tiki/Profile/InstallHandler/WebserviceTemplate.php', '15.9', 0),
('f446772dc5ee6b50a744a544ba5491ab', './lib/core/Tiki/Profile/InstallHandler/WikiPage.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Profile/InstallHandler/index.php', '15.9', 0),
('f453068ef07945fa2db5a04208bf340c', './lib/core/Tiki/Profile/Installer.php', '15.9', 0),
('cf6c678dd9fc243c463dae399a981306', './lib/core/Tiki/Profile/List.php', '15.9', 0),
('900d84da170303d32381f9e274bb5546', './lib/core/Tiki/Profile/Object.php', '15.9', 0),
('f83388dc6b59333b8d0ced94a48c0bdc', './lib/core/Tiki/Profile/SymbolLoader.php', '15.9', 0),
('7b8a8d3e7340d26bce3501de339bafd3', './lib/core/Tiki/Profile/Transport/File.php', '15.9', 0),
('dcc907fb8acfbdc06921ad70c3a32053', './lib/core/Tiki/Profile/Transport/Interface.php', '15.9', 0),
('4c5f096449110d67b0c8f40b577515d5', './lib/core/Tiki/Profile/Transport/Local.php', '15.9', 0),
('921dcf40da411c0d2e5219da441e7969', './lib/core/Tiki/Profile/Transport/Repository.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Profile/Transport/index.php', '15.9', 0),
('0665968f8da422fa2cd33f38c2931055', './lib/core/Tiki/Profile/ValueMapConverter.php', '15.9', 0),
('0dcfb62a2038fd1956537b7574fdcb3b', './lib/core/Tiki/Profile/Writer.php', '15.9', 0),
('124feb49046d8260938b78d379e9b66a', './lib/core/Tiki/Profile/Writer/ExternalWriter.php', '15.9', 0),
('182c10789b0d07150d762aad01a55882', './lib/core/Tiki/Profile/Writer/Helper.php', '15.9', 0),
('91ad07990dce38c9786d8df6b017ce4c', './lib/core/Tiki/Profile/Writer/ProfileFinder.php', '15.9', 0),
('a8b8e65ce5abc0be8bf9d71a77fa2356', './lib/core/Tiki/Profile/Writer/Queue.php', '15.9', 0),
('29c3f432673161a67663b00d97b60d13', './lib/core/Tiki/Profile/Writer/ReferenceProvider.php', '15.9', 0),
('df3793326667de103e2ce8eb06668726', './lib/core/Tiki/Profile/Writer/SearchFieldHelper.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Profile/Writer/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Profile/index.php', '15.9', 0),
('5c17198d4d5cf6b3a1e2fb1babbe0b23', './lib/core/Tiki/Recommendation/BatchProcessor.php', '15.9', 0),
('2dd5567e0b90a718c52a089cb29abb2f', './lib/core/Tiki/Recommendation/Comparator.php', '15.9', 0),
('0f1bcaff7004cb7ac2bd9e4554a78d91', './lib/core/Tiki/Recommendation/Debug/SourceDocument.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Recommendation/Debug/index.php', '15.9', 0),
('babf38447eb14a8093efe7cabcbc1ede', './lib/core/Tiki/Recommendation/Engine/CompilerPass.php', '15.9', 0),
('c1588a9b6e0171231dd92109e8db71c6', './lib/core/Tiki/Recommendation/Engine/EngineInterface.php', '15.9', 0),
('49d072207c731542ff72d33e3ed7a58c', './lib/core/Tiki/Recommendation/Engine/FakeEngine.php', '15.9', 0),
('1913df42cbf53f378245e7825e168a75', './lib/core/Tiki/Recommendation/Engine/UserFavorite.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Recommendation/Engine/index.php', '15.9', 0),
('5429771cd3a0b48d03eb3785d9c9d483', './lib/core/Tiki/Recommendation/EngineOutput.php', '15.9', 0),
('797373a0384de28ad5ebf26da28fb555', './lib/core/Tiki/Recommendation/EngineSet.php', '15.9', 0),
('13f69dc7b764b3fcb50e212bcf80ce9e', './lib/core/Tiki/Recommendation/Input/UserInput.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Recommendation/Input/index.php', '15.9', 0),
('2cc70b93a90976bfd4f4537bc3d73934', './lib/core/Tiki/Recommendation/Recommendation.php', '15.9', 0),
('ea1642f0805bd0ad5ace4a918655af01', './lib/core/Tiki/Recommendation/RecommendationSet.php', '15.9', 0),
('cb3097ed76e749884c1a80b90225e3f2', './lib/core/Tiki/Recommendation/Store/ActivityStore.php', '15.9', 0),
('8bc828f9a9aba979935c09fc5b948122', './lib/core/Tiki/Recommendation/Store/StoreInterface.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Recommendation/Store/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Recommendation/index.php', '15.9', 0),
('b47bbe1be5ed83180e04417ae0a9968e', './lib/core/Tiki/Render/Editable.php', '15.9', 0),
('b678e4e16f6dd32c442fbfb3c860875b', './lib/core/Tiki/Render/Lazy.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Render/index.php', '15.9', 0),
('593a9c76f4786b4d43a953dcd80583f8', './lib/core/Tiki/Request.php', '15.9', 0),
('071a84969a01073057b2221c0fe3a834', './lib/core/Tiki/Security.php', '15.9', 0),
('f1946a3e77f99c3d54b8a18b7f48b989', './lib/core/Tiki/TimeLimit.php', '15.9', 0),
('950781ebc269c5d128994647e884e90b', './lib/core/Tiki/Transition.php', '15.9', 0),
('1bc40bbb9b12af79dbf37b000abb2624', './lib/core/Tiki/Version/Checker.php', '15.9', 0),
('f397694245d79b13efd6d88308297814', './lib/core/Tiki/Version/Upgrade.php', '15.9', 0),
('3b474307be71e524a2884d637f803418', './lib/core/Tiki/Version/Version.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Version/index.php', '15.9', 0),
('88acb7f3b57ed5e5275b0f1913ed0013', './lib/core/Tiki/Wiki/SlugManager.php', '15.9', 0),
('78411b35abbb5a794fad4f12ccb1946a', './lib/core/Tiki/Wiki/SlugManager/CompilerPass.php', '15.9', 0),
('fca80918f6a2453564c2d133f2e7c3bf', './lib/core/Tiki/Wiki/SlugManager/DashGenerator.php', '15.9', 0),
('a5a52ff1910997161997b4d2fa9bb61d', './lib/core/Tiki/Wiki/SlugManager/Generator.php', '15.9', 0),
('479f5751155c9a1321b88a8f28c5f66e', './lib/core/Tiki/Wiki/SlugManager/InMemoryTracker.php', '15.9', 0),
('17739a3d14b48aa4e0a1818f94ffd1c9', './lib/core/Tiki/Wiki/SlugManager/UnderscoreGenerator.php', '15.9', 0),
('12ac9e658f4f443caf51c9829f94f242', './lib/core/Tiki/Wiki/SlugManager/UrlencodeGenerator.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tiki/Wiki/SlugManager/index.php', '15.9', 0),
('21fdbc5e1bf23d910335d78f8b32b0ba', './lib/core/Tiki/index.php', '15.9', 0),
('c6d5b08057c40eec2c78a519d63eed6a', './lib/core/TikiAddons.php', '15.9', 0),
('529e58c20c3979a23ec470eb95668d73', './lib/core/TikiAddons/Addon.php', '15.9', 0),
('a09d4ed71efeec911b400f99495ba7db', './lib/core/TikiAddons/Api.php', '15.9', 0),
('b4c62a4f3581ae5ebb12b45f99128275', './lib/core/TikiAddons/Api/Events.php', '15.9', 0),
('0983b2ac12e7a526cbcdac4a4f6b0741', './lib/core/TikiAddons/Api/FileGallery.php', '15.9', 0),
('4c801cbfcd17541b6713b5d74bcf6e1b', './lib/core/TikiAddons/Api/Group.php', '15.9', 0),
('d550dc3d2d1ebc3e14cb55bd33312a18', './lib/core/TikiAddons/Api/NavBar.php', '15.9', 0),
('b50fdcc249cdaa1de3b0b7bcbab77ff9', './lib/core/TikiAddons/Api/Search.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/TikiAddons/Api/index.php', '15.9', 0),
('9c20cc546306e500af227d78d25be9bf', './lib/core/TikiAddons/Utilities.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/TikiAddons/index.php', '15.9', 0),
('f17dc782a068f929a47b1f8cc7dc7df0', './lib/core/TikiDb.php', '15.9', 0),
('572645416afc638b46976ea93d5d3dff', './lib/core/TikiDb/Adodb.php', '15.9', 0),
('c52d00f76a5a0c4288c898bae37ddc11', './lib/core/TikiDb/Bridge.php', '15.9', 0),
('03ca1967939177764c293633dac5e1b8', './lib/core/TikiDb/ErrorHandler.php', '15.9', 0),
('c0f05f60223d8e4da88e8c04a0c227c7', './lib/core/TikiDb/Exception.php', '15.9', 0),
('6b1dba4dc241761b790330d91670d8ee', './lib/core/TikiDb/Exception/DuplicateEntry.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/TikiDb/Exception/index.php', '15.9', 0),
('d076b0b03a47f3cd67a65e53d440eea4', './lib/core/TikiDb/Expr.php', '15.9', 0),
('8aa1078449aa346d99123c49342bd987', './lib/core/TikiDb/Initializer.php', '15.9', 0),
('197e1cf71f1d6698a2ddcf6023a69b33', './lib/core/TikiDb/Initializer/Adodb.php', '15.9', 0),
('6c3586869dd2667e4475594fc38d23bd', './lib/core/TikiDb/Initializer/Pdo.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/TikiDb/Initializer/index.php', '15.9', 0),
('46f53595a15d6ef637b41725cebaf2ae', './lib/core/TikiDb/MasterSlaveDispatch.php', '15.9', 0),
('0efd17455b573552a0e6edec1533a2e4', './lib/core/TikiDb/Pdo.php', '15.9', 0),
('cc42150e8cc958dd577ddf31747a66e2', './lib/core/TikiDb/Table.php', '15.9', 0),
('a344059b71841b8cba58f545c1f52a5e', './lib/core/TikiDb/Transaction.php', '15.9', 0),
('0a95f37bf86a1cca3360ca75d0d370cd', './lib/core/TikiDb/index.php', '15.9', 0),
('efef2a97341218b06bace1977448a96f', './lib/core/TikiFilter.php', '15.9', 0),
('efa5b458820bc3b6aa0535aeb1698d88', './lib/core/TikiFilter/Alnum.php', '15.9', 0),
('0324c0359de6192b0598c99820b255bc', './lib/core/TikiFilter/Alpha.php', '15.9', 0),
('77f8d9f7a3b79cfe77258b9917c19941', './lib/core/TikiFilter/AttributeType.php', '15.9', 0),
('f7572da2b8e6ef7f242f067e0207cefa', './lib/core/TikiFilter/Callback.php', '15.9', 0),
('4cdbe66ca4a8ba71334d9dafc574727e', './lib/core/TikiFilter/HtmlPurifier.php', '15.9', 0),
('e9fffdc33c6364fa862723e0e144f7a5', './lib/core/TikiFilter/IsoDate.php', '15.9', 0),
('fed624a8b832e4a6d6e91b4166d378c6', './lib/core/TikiFilter/Lang.php', '15.9', 0),
('2e847c04fbd4e7211c38f41b550586aa', './lib/core/TikiFilter/PregFilter.php', '15.9', 0),
('68714d14137691e5b3e01617e39009bf', './lib/core/TikiFilter/PrepareInput.php', '15.9', 0),
('9972f5dc4a61363c09d152b29a72d217', './lib/core/TikiFilter/PreventXss.php', '15.9', 0),
('5a8b7480d587fc767346710bd36c4f73', './lib/core/TikiFilter/RawUnsafe.php', '15.9', 0),
('80cb728a88721641f8888276249d43e4', './lib/core/TikiFilter/RelativeURL.php', '15.9', 0),
('e8a02c3c38ead20f2eed1645b4817211', './lib/core/TikiFilter/WikiContent.php', '15.9', 0),
('01a4c018376b886c920ba50128d579dc', './lib/core/TikiFilter/Word.php', '15.9', 0),
('0a95f37bf86a1cca3360ca75d0d370cd', './lib/core/TikiFilter/index.php', '15.9', 0),
('17b88e40941f38c353d88601a7cc1e3d', './lib/core/Tracker/CompilerPass.php', '15.9', 0),
('9b0739fa823444a2252c35dc476523f5', './lib/core/Tracker/Definition.php', '15.9', 0),
('9c6be359457fa5b711f9b5a74b001cef', './lib/core/Tracker/Field/Abstract.php', '15.9', 0),
('594a12d7dbfa6d3d549b79a4c1ec78f6', './lib/core/Tracker/Field/Action.php', '15.9', 0),
('c65ca9d3727ed1acbe5f9a3b613681b3', './lib/core/Tracker/Field/Articles.php', '15.9', 0),
('3e72cd23c29004a2c9a092bae707fa2f', './lib/core/Tracker/Field/AutoIncrement.php', '15.9', 0),
('ea1fdf7a964a89778db2c8b7b9226e5a', './lib/core/Tracker/Field/Category.php', '15.9', 0),
('03b10ec79de42dcfd83bcf2ae4ab51a8', './lib/core/Tracker/Field/Checkbox.php', '15.9', 0),
('c0a6410f3c44cbf26b37362d1f1572d3', './lib/core/Tracker/Field/Computed.php', '15.9', 0),
('e3131f62d2bd471dc750fc5cfaf193a1', './lib/core/Tracker/Field/CountrySelector.php', '15.9', 0),
('767e266e4d7a16fe074ea934ab1a3988', './lib/core/Tracker/Field/Currency.php', '15.9', 0),
('b8d5193d651f1ebf66553b5af8e83b32', './lib/core/Tracker/Field/DateTime.php', '15.9', 0),
('88e3de8b4710ab689e6b911694973be8', './lib/core/Tracker/Field/Dropdown.php', '15.9', 0),
('3d134d6e9fb7650493535d070262585f', './lib/core/Tracker/Field/DynamicList.php', '15.9', 0),
('f8a85e5959b770bf2f8252e264086959', './lib/core/Tracker/Field/Email.php', '15.9', 0),
('086f36f6a223b4f233dee87e9bca657e', './lib/core/Tracker/Field/Exportable.php', '15.9', 0),
('f3c33e937be387e81c119c9f69880f90', './lib/core/Tracker/Field/Factory.php', '15.9', 0),
('7acf4e25ca1d60bdb5103c790b61d9aa', './lib/core/Tracker/Field/File.php', '15.9', 0),
('23e4a595e0bd741674b5329679b38ed9', './lib/core/Tracker/Field/Files.php', '15.9', 0),
('383c4bd3f10e216df419059d1002fbcf', './lib/core/Tracker/Field/Filterable.php', '15.9', 0),
('a5d7291d636c8c93ccaeaec7f9223efe', './lib/core/Tracker/Field/Freetags.php', '15.9', 0),
('e9b9b7776bf9bbc45b29afe4207c7e34', './lib/core/Tracker/Field/GeographicFeature.php', '15.9', 0),
('5836328d6797ffb5b31f081033396a1f', './lib/core/Tracker/Field/GroupSelector.php', '15.9', 0),
('da7ecb58708a9a87f3c049b823c2c368', './lib/core/Tracker/Field/Header.php', '15.9', 0),
('b9755c3522131131bb06bfb47d0fa548', './lib/core/Tracker/Field/Icon.php', '15.9', 0),
('a8d369564f2248c5a3c1a13ce4bb37bf', './lib/core/Tracker/Field/Image.php', '15.9', 0),
('a6cf2e27b02dff880722cfe2b498f3cf', './lib/core/Tracker/Field/InGroup.php', '15.9', 0),
('674faad1164c999bb371a47a6b4d39fa', './lib/core/Tracker/Field/Indexable.php', '15.9', 0),
('7e2e1f2ba049a45b94d3b3448a7100b7', './lib/core/Tracker/Field/Interface.php', '15.9', 0),
('8d5141894a8b4896d44374729a2095b0', './lib/core/Tracker/Field/Ip.php', '15.9', 0),
('d2c16848edcacbcda93f77207d2df878', './lib/core/Tracker/Field/ItemLink.php', '15.9', 0),
('132085aa3fc7a9d4a5cff274988da79b', './lib/core/Tracker/Field/ItemsList.php', '15.9', 0),
('ab1259a5b6675badbef2353e2347c53e', './lib/core/Tracker/Field/JsCalendar.php', '15.9', 0),
('83409d6d81e207ffb6c478bae9651bf9', './lib/core/Tracker/Field/Kaltura.php', '15.9', 0),
('dfbabc88959fbda3a30150af2084eabb', './lib/core/Tracker/Field/Language.php', '15.9', 0),
('7e64caf95c79673c4c95607551f2f7bc', './lib/core/Tracker/Field/Ldap.php', '15.9', 0),
('59ad1820001337be6669865871b02cc0', './lib/core/Tracker/Field/Location.php', '15.9', 0),
('5ca3577e4d414ef02817ac27d33a4258', './lib/core/Tracker/Field/Math.php', '15.9', 0),
('15bc6708e78cfdee09a1a438bee6b4c8', './lib/core/Tracker/Field/Numeric.php', '15.9', 0),
('fd4d36abced17d3892b77210ff7b1e52', './lib/core/Tracker/Field/PageSelector.php', '15.9', 0),
('225ae3de46e3508046b2ce3724960bea', './lib/core/Tracker/Field/Rating.php', '15.9', 0),
('3f7e74cf12a4b74cf460b34f22036803', './lib/core/Tracker/Field/Relation.php', '15.9', 0),
('39d51545dabce2933ba7506798239d30', './lib/core/Tracker/Field/ShowTikiOrg.php', '15.9', 0),
('a5db0c1e16e03b05816fafa6fe38219a', './lib/core/Tracker/Field/StaticText.php', '15.9', 0),
('961770e447772418de45a95a64cda3fe', './lib/core/Tracker/Field/Synchronizable.php', '15.9', 0),
('6ec0966014d81b08aa03199a92081251', './lib/core/Tracker/Field/Text.php', '15.9', 0),
('4d747d2df6ee8b283de0aa221cd6ad89', './lib/core/Tracker/Field/TextArea.php', '15.9', 0),
('19ed43cee7de7712668e48a424751430', './lib/core/Tracker/Field/Url.php', '15.9', 0),
('9279aaf34eca689437a13fd25710f165', './lib/core/Tracker/Field/UserGroups.php', '15.9', 0),
('48ca399210da807416b2e34cb767a18a', './lib/core/Tracker/Field/UserPreference.php', '15.9', 0),
('695b94b28cd508bdeac57eb6abc2a3b7', './lib/core/Tracker/Field/UserSelector.php', '15.9', 0),
('5ad57247f33af1ff6e29f4217e32495a', './lib/core/Tracker/Field/UserSubscription.php', '15.9', 0),
('32b6d3114b58bce62875521c421add0c', './lib/core/Tracker/Field/WebService.php', '15.9', 0),
('3473fc19bd72c1c704728ed94368eb60', './lib/core/Tracker/Field/Wiki.php', '15.9', 0),
('8031dc3efbe99f4cbf61a158c75b354e', './lib/core/Tracker/Field/index.php', '15.9', 0),
('2086afb270761db0bd689bb47bf9521e', './lib/core/Tracker/Filter/Collection.php', '15.9', 0),
('51b22d9fd4bf721360463415316b465e', './lib/core/Tracker/Filter/Control/Control.php', '15.9', 0),
('562976b44d8a81a7117fdc96f4f010c6', './lib/core/Tracker/Filter/Control/DateRange.php', '15.9', 0),
('199f7c70b0257997c10526b64870f6d4', './lib/core/Tracker/Filter/Control/DropDown.php', '15.9', 0),
('7f19806f468c393837b9a3e2b0b17514', './lib/core/Tracker/Filter/Control/InlineCheckboxes.php', '15.9', 0),
('5e44e24831780b915bfd0bbd5edaac0e', './lib/core/Tracker/Filter/Control/MultiSelect.php', '15.9', 0),
('09a0016c175ee3ec694cde64029cb0e5', './lib/core/Tracker/Filter/Control/ObjectSelector.php', '15.9', 0),
('a9c7d7bdf596b6ef8f3f0a648cf4decf', './lib/core/Tracker/Filter/Control/TextField.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tracker/Filter/Control/index.php', '15.9', 0),
('50eff66c78340b13a88a82da83b450ca', './lib/core/Tracker/Filter/Exception/Exception.php', '15.9', 0),
('bb7d818fe931a08038b1e240ee551d00', './lib/core/Tracker/Filter/Exception/FieldNotFound.php', '15.9', 0),
('c54c7a3a18088ef9b21d2d5e329c385d', './lib/core/Tracker/Filter/Exception/ModeNotSupported.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tracker/Filter/Exception/index.php', '15.9', 0),
('13711c7636e877778759afc1a6ac25fc', './lib/core/Tracker/Filter/Filter.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tracker/Filter/index.php', '15.9', 0),
('e87c07435e74a11049df31f417fdd6da', './lib/core/Tracker/Item.php', '15.9', 0),
('00bb31e365f7fa81cedfa450cfc6b77a', './lib/core/Tracker/Options.php', '15.9', 0),
('70c1c6699ecfd3bc62fcbb1b0471d5f2', './lib/core/Tracker/Query.php', '15.9', 0),
('a79d1b7222b3ed5041d77130f61c23d6', './lib/core/Tracker/Tabular/Exception/Exception.php', '15.9', 0),
('051357c4cf2d1b6e4f09fb478d958a0f', './lib/core/Tracker/Tabular/Exception/FieldNotFound.php', '15.9', 0),
('1b865d8581a8e6a2aa5f474cbfdae7be', './lib/core/Tracker/Tabular/Exception/ModeNotSupported.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tracker/Tabular/Exception/index.php', '15.9', 0),
('2f02a623a59ded55e12220b0d58693e3', './lib/core/Tracker/Tabular/Manager.php', '15.9', 0),
('fca465c9c3ece8a252987a4f593dc6c1', './lib/core/Tracker/Tabular/Schema.php', '15.9', 0),
('e28b9417695555a6136910c817851ccb', './lib/core/Tracker/Tabular/Schema/CachedLookupHelper.php', '15.9', 0),
('86e020c15bfcea7d14907c5bbe26eec4', './lib/core/Tracker/Tabular/Schema/Column.php', '15.9', 0),
('56966a78528e4cff301a10634133c428', './lib/core/Tracker/Tabular/Schema/DateHelper.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tracker/Tabular/Schema/index.php', '15.9', 0),
('2e795825fafc8a667171ec840f4b7ef5', './lib/core/Tracker/Tabular/Source/AutoDetectCsvSource.php', '15.9', 0),
('17c1bafed9c6ba4fb716dc746fa8b18a', './lib/core/Tracker/Tabular/Source/CsvSource.php', '15.9', 0),
('78bcbea00dbf24d37561399d493bd9e3', './lib/core/Tracker/Tabular/Source/CsvSourceEntry.php', '15.9', 0),
('d1bd947844c04ca2c161b5eae8033a84', './lib/core/Tracker/Tabular/Source/PaginatedQuerySource.php', '15.9', 0),
('4b8187c34fa1e84fdd7f587c7c8db311', './lib/core/Tracker/Tabular/Source/QuerySource.php', '15.9', 0),
('fed9e4c82ec8e2adf545fac13b62951d', './lib/core/Tracker/Tabular/Source/QuerySourceEntry.php', '15.9', 0),
('04bee5783a6a94bab1f198cca6b1428a', './lib/core/Tracker/Tabular/Source/SourceInterface.php', '15.9', 0),
('273834ec68541815f1d706f5df40eb4f', './lib/core/Tracker/Tabular/Source/TrackerSource.php', '15.9', 0),
('5637d9df9912924367c9938194651b21', './lib/core/Tracker/Tabular/Source/TrackerSourceEntry.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tracker/Tabular/Source/index.php', '15.9', 0),
('9c56ab97930a791234e4faaca6641197', './lib/core/Tracker/Tabular/Writer/CsvWriter.php', '15.9', 0),
('3b7f41e3ea8ba9613232522f65f11b9c', './lib/core/Tracker/Tabular/Writer/HtmlWriter.php', '15.9', 0),
('458c98209f78abf20ead0ecd6b05325f', './lib/core/Tracker/Tabular/Writer/TrackerWriter.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tracker/Tabular/Writer/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/Tracker/Tabular/index.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/core/Tracker/index.php', '15.9', 0),
('2012f30fff1df4cfd0b70eddccd73e16', './lib/core/Type.php', '15.9', 0),
('241e1566641068293bde40943b830b4c', './lib/core/WikiParser/OutputLink.php', '15.9', 0),
('a4e171594c7414d2342e1f71b76f14eb', './lib/core/WikiParser/PluginArgumentParser.php', '15.9', 0),
('f8a07236561ddf9d0bc00e8e67943bcd', './lib/core/WikiParser/PluginDefinition.php', '15.9', 0),
('9619f7cb2948c2c7cc34dc95ffb1b226', './lib/core/WikiParser/PluginMatcher.php', '15.9', 0),
('00bb0cdf0d9e61b98bb8efc84e985621', './lib/core/WikiParser/PluginOutput.php', '15.9', 0),
('476ac27993146e00ac0e53ca1a9da2cf', './lib/core/WikiParser/PluginParser.php', '15.9', 0),
('1c6fc28f679c0131d23da08b2c2f65cd', './lib/core/WikiParser/PluginRepository.php', '15.9', 0),
('7c046c0404b95ca393f710b232bc5e85', './lib/core/WikiParser/PluginRunner.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/core/WikiParser/index.php', '15.9', 0),
('22d0c166ea6c5e28d7d713a01d9d6b3a', './lib/core/WikiPlugin/Negotiator/Wiki.php', '15.9', 0),
('6ddfc32b1624cc48b55f22c6afc963fb', './lib/core/WikiPlugin/Negotiator/Wiki/Alias.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/WikiPlugin/Negotiator/Wiki/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/core/WikiPlugin/Negotiator/index.php', '15.9', 0),
('63f8aa818f3dde2e81526389e88bb789', './lib/core/Yaml/Directive/Include.php', '15.9', 0),
('5bb5405bc71919054242246b5e518ad8', './lib/core/Yaml/Directives.php', '15.9', 0),
('43b94b90b8ab94de33ba5fe698a5501e', './lib/core/Yaml/Filter/FilterInterface.php', '15.9', 0),
('a953213abc8d2f2eab408a6633a92134', './lib/core/Yaml/Filter/ReplaceUserData.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/core/index.php', '15.9', 0),
('4f6c777f962e1833d910f5ea245828a6', './lib/credits/creditslib.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/credits/index.php', '15.9', 0),
('3aa9e58576b8013cca113c22e468d080', './lib/crypt/cryptlib.php', '15.9', 0),
('20abe532cf382abe1020be400f3ab3be', './lib/crypt/index.php', '15.9', 0),
('1a6bad94d7541622d37c34d879c75af1', './lib/csslib.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/db/index.php', '15.9', 0),
('2047408518edc098c8f7bdef32f77f00', './lib/db/tiki_registration_fields.php', '15.9', 0),
('ae723383d6b4b26643bd481a31c5ac18', './lib/dcs/dcslib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/dcs/index.php', '15.9', 0),
('e0025a5f66df3601aa5c59b3566bf720', './lib/debug/Tracer.php', '15.9', 0),
('f836e160d98149ea525cfa2288541b82', './lib/debug/debug-command_dmsg.php', '15.9', 0),
('1ea2de9e703d24dd091c5b5bbe123564', './lib/debug/debug-command_features.php', '15.9', 0),
('f466d08a8e21a84c6bd5a74e2c430b6e', './lib/debug/debug-command_perm.php', '15.9', 0),
('e63c8e07ddb534a8f0e7be8aae3c5e2e', './lib/debug/debug-command_print.php', '15.9', 0),
('6eb844ad394536cbbdbab7869024aa63', './lib/debug/debug-command_slist.php', '15.9', 0),
('f86eba3a3b316b2fe6b1d564deb501b0', './lib/debug/debug-command_sprint.php', '15.9', 0),
('312789371190bae1a67202a066c3dfaf', './lib/debug/debug-command_sql.php', '15.9', 0),
('5e84b30993ef08e23da024b8e23d3abc', './lib/debug/debug-command_test.php', '15.9', 0),
('9c90612ab8a7cf2dfae4ba71d79cfc88', './lib/debug/debug-command_tikitables.php', '15.9', 0),
('d3c98c15f2bfeeaa0ca4caa592748996', './lib/debug/debug-command_watch.php', '15.9', 0),
('a1151a0d1c614fd5d728d9f5fd9e593b', './lib/debug/debugger-common.php', '15.9', 0),
('6f40f4141faa488e771fdb0fcee2fa04', './lib/debug/debugger-ext.php', '15.9', 0),
('cd505051efd863ebf53fff5946047041', './lib/debug/debugger.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/debug/index.php', '15.9', 0),
('7d44a6583cb3dbec9efc65e5c26d6e84', './lib/diff.php', '15.9', 0),
('77d82cbc8d021d7f1ae585aae6bb0a45', './lib/diff/Diff.php', '15.9', 0),
('19a84f05b55cb6f9570c2b359683851c', './lib/diff/Renderer.php', '15.9', 0),
('67498e1e1c4081cea1e0cbefae626ea9', './lib/diff/difflib.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/diff/index.php', '15.9', 0),
('bd73aab7fffc865fb2aaf7f96583d873', './lib/diff/renderer_bytes.php', '15.9', 0),
('53457c25d812c1a2389147b1e4b09d34', './lib/diff/renderer_character.php', '15.9', 0),
('8be6e5cf236317834ceae975361fc463', './lib/diff/renderer_character_inline.php', '15.9', 0),
('c2780dffbbdf0976cd0dbc1312e955b3', './lib/diff/renderer_htmldiff.php', '15.9', 0),
('231f49334c2885814486b0f284c069b8', './lib/diff/renderer_inline.php', '15.9', 0),
('49ba4b318615cfdae2f03ef4592a51d5', './lib/diff/renderer_sidebyside.php', '15.9', 0),
('bef4c0c2ea3b253619d6c6cb8d3f8ec2', './lib/diff/renderer_unified.php', '15.9', 0),
('8f6c70eb56db868049d6711728ca8031', './lib/directory/dirlib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/directory/index.php', '15.9', 0),
('7e524f8e5ab0921701e77fde1af8ec03', './lib/dracula/graffle.js', '15.9', 0),
('6e9b58af0d870378f4c69483b175e87d', './lib/dracula/graph.js', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/dracula/index.php', '15.9', 0),
('8b1b503c7e881b85379888e7d9c39873', './lib/dracula/raphael-min.js', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/encoding/index.php', '15.9', 0),
('38ce2d0a69ccc1c5c86251946cc4d84f', './lib/encoding/lib-encoding.php', '15.9', 0),
('20ee14d4006fdfd83a7a39e3e7e01e85', './lib/equation/class.latexrender.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/equation/index.php', '15.9', 0),
('d1e4406574842cbe27525f79d27ddfae', './lib/equation/pictures/index.php', '15.9', 0),
('d1e4406574842cbe27525f79d27ddfae', './lib/equation/tmp/index.php', '15.9', 0),
('9d828d2cf74024593107a68ec75b6497', './lib/errorreportlib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/events/index.php', '15.9', 0),
('cde969a7c87ad2c03ddc21f21403c361', './lib/faqs/faqlib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/faqs/index.php', '15.9', 0),
('d809470d12d74cc25926d47a6c0aeaf2', './lib/featured_links/flinkslib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/featured_links/index.php', '15.9', 0),
('0da726a2b53e34c6a843948c60ef2125', './lib/filegals/filegalbatchlib.php', '15.9', 0),
('48ff7164f63efe483c257934210e17f7', './lib/filegals/filegalcopylib.php', '15.9', 0),
('ca2dc6ea25705fb4bfb928a9f9c1dcf5', './lib/filegals/filegallib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/filegals/index.php', '15.9', 0),
('0ddf169536e9335c4cf86c74f2f91d6e', './lib/filegals/max_upload_size.php', '15.9', 0),
('a796033ddf40320f0257ceb88843b573', './lib/filegals/scormlib.php', '15.9', 0),
('7395a8dcce4aa0c0985e39c8453af3ed', './lib/filegals/vimeolib.php', '15.9', 0),
('26884978a95d1d5705b9d281e9475f40', './lib/freetag/freetaglib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/freetag/index.php', '15.9', 0),
('79d0adaade67b1433b0934b4e877f530', './lib/geo/geolib.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/geo/index.php', '15.9', 0),
('62ee2efc602360fc370f3026616a4700', './lib/goal/eventlib.php', '15.9', 0),
('0f02a10f41f11f9b1117c4135685a4ea', './lib/goal/goallib.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/goal/index.php', '15.9', 0),
('fccbf98822b1d95dd756b3a52941b3ad', './lib/goal/rewardlib.php', '15.9', 0),
('dbca2f1e32cc9dfce702815a5ef95981', './lib/graph-engine/abstract.gridbased.php', '15.9', 0),
('9a7b6e0684c7ac54b10c6213d7f93cba', './lib/graph-engine/core.php', '15.9', 0),
('5034a72fdd9c9bd7b23ea8fa702a5250', './lib/graph-engine/gd.php', '15.9', 0),
('1b0da2cdcadcf4119a78aafcf5f7b92c', './lib/graph-engine/graph.bar.php', '15.9', 0),
('e749f067b34c4b0ee57e6d6ce7acac9c', './lib/graph-engine/graph.multiline.php', '15.9', 0),
('b5cb45b4a71fa1399a436ca29813b457', './lib/graph-engine/graph.pie.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/graph-engine/index.php', '15.9', 0),
('71805793747439f25bbcc730c4a38019', './lib/graph-engine/pdflib.php', '15.9', 0),
('bc8c0e603de8936e72f1b1e25fd3b38e', './lib/graph-engine/ps.php', '15.9', 0),
('fad296df474be31d20637428fd3b7210', './lib/groupalert/groupalertlib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/groupalert/index.php', '15.9', 0),
('2698d290f90aa9f01b491bf98761ba96', './lib/headerlib.php', '15.9', 0),
('316d0b0da834b74535c97b867c90fc9d', './lib/hotwords/hotwordlib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/hotwords/index.php', '15.9', 0),
('d82b84d1a155b88635ab4266f5ff890c', './lib/htmlpages/htmlpageslib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/htmlpages/index.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/htmlparser/index.php', '15.9', 0),
('4d16b6d17a8e165663b003ba917e9deb', './lib/htmlparser/rebuildgrammar.php', '15.9', 0),
('8139336a71409d76a7a1b4d79f350bf9', './lib/htmlpurifier_tiki/HTMLPurifier.tiki.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/htmlpurifier_tiki/index.php', '15.9', 0),
('0286e538ebd642793cf3489400b7dc3c', './lib/ical/File.php', '15.9', 0),
('c92fb6fc121018c1ea4c2ae361592a12', './lib/ical/iCal.php', '15.9', 0),
('59d547833f170a95bc7d8a571a4dc9c0', './lib/ical/iCal/Alarm.php', '15.9', 0),
('523545ac0a87829fc490d02fd42bd3ee', './lib/ical/iCal/Attendee.php', '15.9', 0),
('edcdfe3019ce1a84b61192b58e07b4f7', './lib/ical/iCal/BaseComponent.php', '15.9', 0),
('8799f9590504176afc40518b9d05e521', './lib/ical/iCal/Component.php', '15.9', 0),
('917ba74b83cb902993b4b178c1b86cec', './lib/ical/iCal/ContentLine.php', '15.9', 0),
('f7ef1a1badab10d08050418888747afe', './lib/ical/iCal/Event.php', '15.9', 0),
('430b322227b59156ec47f04c313fd3a9', './lib/ical/iCal/ExceptionRule.php', '15.9', 0),
('f3caedd97ae3252a28c56a4b6259abca', './lib/ical/iCal/FreeBusy.php', '15.9', 0),
('3dcf6827f0ffa5184190a8958425250f', './lib/ical/iCal/Parameter.php', '15.9', 0),
('1cdef9ed1c3732b2d3ad07c6e9a08c7e', './lib/ical/iCal/Parser/iCalendar.php', '15.9', 0),
('f11bb5cf20adb1eb1811bbcec5ec0c6d', './lib/ical/iCal/Parser/index.php', '15.9', 0),
('1f7bd6dbecd2de068460185c27c2e3ea', './lib/ical/iCal/Property.php', '15.9', 0),
('f0824cd2730d3c02094a8b49d7c518d7', './lib/ical/iCal/Recurrence.php', '15.9', 0),
('91aa1a2592999cbc1a1a438a7d0fd416', './lib/ical/iCal/TimeZone.php', '15.9', 0),
('242b1039ddd1e7c449e1399d27926508', './lib/ical/iCal/ToDo.php', '15.9', 0),
('dbd19c84c7a5c076cf806d823cc3debe', './lib/ical/iCal/ValueDataType.php', '15.9', 0),
('4da7ed041aae67a7f065a1237c663c96', './lib/ical/iCal/iCalendar.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/ical/iCal/index.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/ical/index.php', '15.9', 0),
('39c47be955086e55ef8ae547eefdade4', './lib/iepngfix/DD_belatedPNG-min.js', '15.9', 0),
('d59460ceb31f32c45c6267e008952e5a', './lib/iepngfix/DD_belatedPNG.js', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/iepngfix/index.php', '15.9', 0),
('248de17038f51b211ef6c7243747b0ed', './lib/imagegals/imagegallib.js', '15.9', 0),
('ed1d5e410b436fcd3f72ee9e07786f6f', './lib/imagegals/imagegallib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/imagegals/index.php', '15.9', 0),
('9e6315f14f532179efdd1a8119a6b3e8', './lib/images/abstract.php', '15.9', 0),
('8a582033b6cee8e53c9b06466dacc902', './lib/images/gd.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/images/icons/index.php', '15.9', 0),
('ebf16cd6228ff924004634aea3066ef1', './lib/images/images.php', '15.9', 0),
('e422cbd54c2e572c379406fcac714750', './lib/images/imagick_new.php', '15.9', 0),
('7297ba140df9853481226b964bc24817', './lib/images/imagick_old.php', '15.9', 0),
('a78ccc6846f9a24de191e384be67d84e', './lib/images/img_plugin_default_and_mandatory.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/images/index.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/importer/index.php', '15.9', 0),
('13a3ae186ff5152f0259c5c5f6835eb1', './lib/importer/tikiimporter.php', '15.9', 0),
('59913d0fc117bb945e5aeb25f2de306e', './lib/importer/tikiimporter_blog.php', '15.9', 0),
('cb753cc97bc007db06b76366b0ced505', './lib/importer/tikiimporter_blog_wordpress.php', '15.9', 0),
('454b10cbddd95661faa24dbe38b00768', './lib/importer/tikiimporter_wiki.php', '15.9', 0),
('85c38d9e57e33e94a3b2cb9bf3e20579', './lib/importer/tikiimporter_wiki_mediawiki.php', '15.9', 0),
('ec99b4b864c7d083dedfc06d97d3c500', './lib/importerlib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/index.php', '15.9', 0),
('570e093002f15b1ee6ea4b64b0bf4116', './lib/init/index.php', '15.9', 0),
('5272e45c8311c8c84e5309e45c895068', './lib/init/initlib.php', '15.9', 0),
('9810aa7f0a2fd961277ae22b0119d67b', './lib/init/smarty.php', '15.9', 0),
('81494b02a66194e212ce561c5ddf9bf3', './lib/init/tra.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/integrator/index.php', '15.9', 0),
('811e0d6b86301a8063d8d9d807ccef2b', './lib/integrator/integrator.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/jcapture_tiki/index.php', '15.9', 0),
('0014ceb5ce434cc78c2927aa75e4971a', './lib/jcapture_tiki/tiki-jcapture.js', '15.9', 0),
('83b0d4f1335ba11ef43fb7102b5c71e4', './lib/jquery_tiki/autoToc.js', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/jquery_tiki/colorpicker/index.php', '15.9', 0),
('8aec5ff6c319184f465ecbb712426ac0', './lib/jquery_tiki/colorpicker/layout.css', '15.9', 0),
('89b42f3f707bcfb6794b2159a6f7d2c7', './lib/jquery_tiki/customsearch.js', '15.9', 0),
('d3f02f12ed024049db6524cf211cd7ed', './lib/jquery_tiki/elfinder/elFinderVolumeTikiFiles.class.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/jquery_tiki/elfinder/index.php', '15.9', 0),
('b7cf4c2088d6e2a49bdb543fbcd0973b', './lib/jquery_tiki/elfinder/tiki-elfinder.js', '15.9', 0),
('0511af23ec1629541d1b649860833146', './lib/jquery_tiki/elfinder/tikiElFinder.php', '15.9', 0),
('36310c6ea5029f2758f9e9aabf8490d7', './lib/jquery_tiki/files.js', '15.9', 0),
('c2400eeb44fa723c1f8f7d526a17a523', './lib/jquery_tiki/galleriffic/css/basic.css', '15.9', 0),
('448c786e4dd02fa5ccb8f7a10ff0a526', './lib/jquery_tiki/galleriffic/css/black.css', '15.9', 0),
('f7d3487e981d11c6f816bb9400b37da4', './lib/jquery_tiki/galleriffic/css/galleriffic-1.css', '15.9', 0),
('a25198953b79b95868274e0822b45894', './lib/jquery_tiki/galleriffic/css/galleriffic-2.css', '15.9', 0),
('a25198953b79b95868274e0822b45894', './lib/jquery_tiki/galleriffic/css/galleriffic-3.css', '15.9', 0),
('693fdf182b0ddf892a7f6ac98c179690', './lib/jquery_tiki/galleriffic/css/galleriffic-4.css', '15.9', 0),
('a2347c810359f2ffbaec127b69318ce1', './lib/jquery_tiki/galleriffic/css/galleriffic-5.css', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/jquery_tiki/galleriffic/css/index.php', '15.9', 0),
('0d29807795134da58479ab775a478e3c', './lib/jquery_tiki/galleriffic/css/jush.css', '15.9', 0),
('3856175923eafa1d3720fc78dd28c87b', './lib/jquery_tiki/galleriffic/css/white.css', '15.9', 0),
('9d3f42934d2facc7d14921c1e310e944', './lib/jquery_tiki/iconsets.js', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/jquery_tiki/index.php', '15.9', 0),
('9067d2449db289fa887a3b8b7869e9ba', './lib/jquery_tiki/inline_edit.js', '15.9', 0),
('8bbe766d331728f0370eb9bb10e11f7e', './lib/jquery_tiki/multilike.js', '15.9', 0),
('58fca149b898faa8b6717581810b9d18', './lib/jquery_tiki/mustread.js', '15.9', 0),
('cc6af86118c6e6e52688f76588dc3ca7', './lib/jquery_tiki/social.js', '15.9', 0),
('fded2a27a06a97d650883cc238f98949', './lib/jquery_tiki/tiki-admin.js', '15.9', 0),
('b2173ac49b89ea076edc1c99bff4612e', './lib/jquery_tiki/tiki-ajax_services.js', '15.9', 0),
('45fc771a1aa58aaee764f43fbc73370e', './lib/jquery_tiki/tiki-bootstrapmodalfix.js', '15.9', 0),
('0c7e293a874f3d618a83b6a5a6d069a1', './lib/jquery_tiki/tiki-connect.js', '15.9', 0),
('3589745f61aa2163aca115d9f56b14cf', './lib/jquery_tiki/tiki-jquery.js', '15.9', 0),
('4339599018563ac6e93345ac414af1bd', './lib/jquery_tiki/tiki-jquery_upload.js', '15.9', 0),
('0d448d2afa2f8f45a580eba8b648dfa7', './lib/jquery_tiki/tiki-maps-ol3.js', '15.9', 0),
('727b003b98a1c7f331b03fd38cf3ac74', './lib/jquery_tiki/tiki-maps.js', '15.9', 0),
('57b95c7b11389f22bcb6576584ffd2c4', './lib/jquery_tiki/tiki-toolbars.js', '15.9', 0),
('cca6087888af69e3f2fc8ff8491588f7', './lib/jquery_tiki/tiki-trackers.js', '15.9', 0),
('cb95e581e255cfaa5011e85cfb827cb0', './lib/jquery_tiki/tiki-workspace-ui.js', '15.9', 0),
('5968b814518a7b58b3b3cfa4c0bae3ad', './lib/jquery_tiki/wikiplugin-annotation.js', '15.9', 0),
('14b18e50550a09fb28f582563a92444f', './lib/language/CollectFiles.php', '15.9', 0),
('86553fcfc573b7b65a0bb557da99210a', './lib/language/Exception.php', '15.9', 0),
('8d5f6b5c05ca7d13e64a5032676bd3c9', './lib/language/File.php', '15.9', 0),
('e63aa8157775e7ef25726603ba7b8897', './lib/language/FileType.php', '15.9', 0),
('b8cbb41befe34a23e29c2bfa2b79d865', './lib/language/FileType/Php.php', '15.9', 0),
('1d6ea1f5493b16557957d5b461afcaab', './lib/language/FileType/Tpl.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/language/FileType/index.php', '15.9', 0),
('df67f0dc017a391c8fc1355e594b081b', './lib/language/GetStrings.php', '15.9', 0),
('eef7cca77474a9b7001828f33e15a714', './lib/language/Language.php', '15.9', 0),
('0b54fef5dcadaca5eea21609dba0738a', './lib/language/LanguageTranslations.php', '15.9', 0),
('bae00c62b5fdbfe3ed07d24871d34420', './lib/language/MergeFiles.php', '15.9', 0),
('88aa7f23d2706fb87a17b2ff12502648', './lib/language/WriteFile.php', '15.9', 0),
('0e5f475d17de21d5af43835d29a9f684', './lib/language/WriteFile/Factory.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/language/WriteFile/index.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/language/index.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/language/js/index.php', '15.9', 0),
('86489157023013875759dac6f162c474', './lib/language/js/interactive_translation.js', '15.9', 0),
('52225525d4f19112e837fbf16682f44f', './lib/language/js/tiki-edit_languages.js', '15.9', 0),
('c543b09b96e0e5ed02b898aa2e730d8e', './lib/ldap/filter.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/ldap/index.php', '15.9', 0),
('64db82ce6e869d9c95eb26e1804dc6b3', './lib/ldap/ldaplib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/live_support/index.php', '15.9', 0),
('1b5c1cf3bfc72c94f403be05ffb762d4', './lib/live_support/live-support.js', '15.9', 0),
('749eaa3e3499965f7f37b09aa0269d1e', './lib/live_support/lsadminlib.php', '15.9', 0),
('a33b3d2726f30cf7f53b9020ca5b2639', './lib/live_support/lslib.php', '15.9', 0),
('37d9363bbe596135f0eb57d99b447fcd', './lib/loginlib.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/logs/index.php', '15.9', 0),
('3f302996df94242683413084933c9677', './lib/logs/logslib.php', '15.9', 0),
('be50597fec78fc94e7911c5fd42f5713', './lib/logs/logsquerylib.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/mail/index.php', '15.9', 0),
('99ba6bf9c37ee67344ece758cad8b0fd', './lib/mail/maillib.php', '15.9', 0),
('e3c5902d05cadb596cb06b06f4c87966', './lib/mail/mimelib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/mailin/index.php', '15.9', 0),
('ec755d780b1896e12789b5cb40232ebc', './lib/mailin/mailinlib.php', '15.9', 0),
('d022a2171a6ee9bcb3eb6d672e8d0049', './lib/mailin/usermailinlib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/menubuilder/index.php', '15.9', 0),
('ba87554806a71966dd6046019b47eb1e', './lib/menubuilder/menu.js', '15.9', 0),
('1655f9c4b500d14fe8adb1d0c519a0a7', './lib/menubuilder/menulib.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/messu/index.php', '15.9', 0),
('f68fd2b1f4712afcfa3fde2480ef5ae4', './lib/messu/messulib.php', '15.9', 0),
('6c0431bc5105678e76372c43e88b1c7a', './lib/metadata/datatypes/basicinfo.php', '15.9', 0),
('8451e9677705e5de8686a28623dbe563', './lib/metadata/datatypes/exif.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/metadata/datatypes/index.php', '15.9', 0),
('4af42fdc1ee697c402f6e55c3f9f3b58', './lib/metadata/datatypes/iptc.php', '15.9', 0),
('c49e485d0bdb66a3f3a9790652c41662', './lib/metadata/datatypes/xmp.php', '15.9', 0),
('246fe1dd481d38a76ffbbc332f106351', './lib/metadata/filetypes/imagefile.php', '15.9', 0),
('6706581c4b9c7bfdab8fa9ef705ca2fb', './lib/metadata/filetypes/index.php', '15.9', 0),
('b230c4993b45a92f465739c2a707fb38', './lib/metadata/filetypes/jpeg.php', '15.9', 0),
('b4823c46cf75cb27cd68e8005d1f8d00', './lib/metadata/index.php', '15.9', 0),
('1c9498d1205592d5a153cfbc90d3c021', './lib/metadata/metadatalib.php', '15.9', 0),
('2b8e7fc60317e12b4b66856f14336b02', './lib/metadata/reconcile.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/mime/index.php', '15.9', 0),
('31b1bf409920e5482775992ce8da2aca', './lib/mime/mimelib.php', '15.9', 0),
('11545cdb41f04511119ea87a9233820d', './lib/mime/mimetypes.php', '15.9', 0),
('c33ba0fdead74ee64fe9294265dd219d', './lib/minical/index.php', '15.9', 0),
('8e0d9a112f78f98951e987fa0d910ae4', './lib/minical/minicallib.php', '15.9', 0),
('fb980778f519bdaf0ce71bff534c22a1', './lib/minify/JSMin.php', '15.9', 0),
('ef643ddcc5cbb9e1b403a338bc907eaa', './lib/minify/index.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/mods/index.php', '15.9', 0),
('a4432554c5dddb095b80b377d41f2bca', './lib/mods/modslib.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/modules/index.php', '15.9', 0),
('06eef2eaaf7640fd3005101b593038e3', './lib/modules/modlib.php', '15.9', 0),
('7a7a3675bd451358ff99cbe690631417', './lib/modules/tiki-admin_modules.js', '15.9', 0),
('ef643ddcc5cbb9e1b403a338bc907eaa', './lib/multilingual/index.php', '15.9', 0),
('9c4e577a32c5aaf353814a57ea287c85', './lib/multilingual/multilinguallib.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/newsletters/index.php', '15.9', 0),
('da041cce2a1ecd79c77f84d06e7e3152', './lib/newsletters/nllib.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/notepad/index.php', '15.9', 0),
('f2488a00045725c9d6b259cbf6f50531', './lib/notepad/notepadlib.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/notifications/index.php', '15.9', 0),
('586a2b828355f4d6f43b6358350a38d9', './lib/notifications/notificationemaillib.php', '15.9', 0),
('4cd063f08de779175ae07fa8dd8c6ecb', './lib/notifications/notificationlib.php', '15.9', 0),
('a7e9353e9c8c5278cb79dc224615b0a9', './lib/oauthlib.php', '15.9', 0),
('055f9b0f01770028a534d454aa5d2833', './lib/objectlib.php', '15.9', 0),
('668e30c2d888c9c6cd35a29b968e4625', './lib/ointegratelib.php', '15.9', 0),
('042f08d40c373df729174f2f43ce8ee3', './lib/openlayers/OpenLayers.js', '15.9', 0),
('bc6ec4a829998bb09aeb9ee49f72406c', './lib/openlayers/OpenLayers.light.js', '15.9', 0),
('b624d36aec327baad809a9c326faac31', './lib/openlayers/OpenLayers.mobile.js', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/openlayers/art/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/openlayers/img/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/openlayers/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/openlayers/licenses/index.php', '15.9', 0),
('41cf2d4df4b94dd247b711af3c3583b0', './lib/openlayers/theme/dark/index.php', '15.9', 0),
('a6bcea2af384a1f59ceaf6d99a737b72', './lib/openlayers/theme/default/google.css', '15.9', 0),
('ae75483aedfcd7d1ea3bb11f6148cf2f', './lib/openlayers/theme/default/google.tidy.css', '15.9', 0),
('97e9508128e3d02599b15c947b8490a1', './lib/openlayers/theme/default/ie6-style.css', '15.9', 0),
('256c553a4738811397517c82f0119101', './lib/openlayers/theme/default/ie6-style.tidy.css', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/openlayers/theme/default/img/index.php', '15.9', 0),
('d7e4ed1a6b03b93c4452db55dc262927', './lib/openlayers/theme/default/style.css', '15.9', 0),
('340578162d772d9c74c7f0785b4754e8', './lib/openlayers/theme/default/style.mobile.css', '15.9', 0),
('9132583981f7f7ef6f3c00a387bdca6f', './lib/openlayers/theme/default/style.mobile.tidy.css', '15.9', 0),
('9521ac61157d73a252cdebe6df5e019d', './lib/openlayers/theme/default/style.tidy.css', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/openlayers/theme/index.php', '15.9', 0),
('ee398ab0e673cc718649a0e7dac11a04', './lib/openpgp/OpenPGP_Zend_Mail_Transport_Sendmail.php', '15.9', 0),
('acb0849311ec7843269def7d03be037a', './lib/openpgp/OpenPGP_Zend_Mail_Transport_Smtp.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/openpgp/index.php', '15.9', 0),
('61db37f1e0e3bdfb0854367c5a857245', './lib/openpgp/openpgplib.php', '15.9', 0),
('ef643ddcc5cbb9e1b403a338bc907eaa', './lib/parser/index.php', '15.9', 0),
('cefd5bbadfc236344909bc72235c6a12', './lib/parser/parserlib.php', '15.9', 0),
('263e7153b1ca7052149604ca544896fb', './lib/payment/behavior/cancel_cart_order.php', '15.9', 0),
('a056f11296c3f98cf3c03aa5c19799dc', './lib/payment/behavior/cancel_membership_extension.php', '15.9', 0),
('b50d5b968e1d46ff547a983704077c3c', './lib/payment/behavior/cart_exchange_product.php', '15.9', 0),
('7d1c54a2f1d81212a19ead8f05216ca8', './lib/payment/behavior/cart_gift_certificate_purchase.php', '15.9', 0),
('aabf6933b27353c5569c394713724a79', './lib/payment/behavior/cart_gift_certificate_refund.php', '15.9', 0),
('465d66edee181603531f4a59b95c5651', './lib/payment/behavior/cart_send_confirm_email.php', '15.9', 0),
('2076a8c47bef82e211831523f7462d91', './lib/payment/behavior/execute_datachannel.php', '15.9', 0),
('1c3be03ca7e0bd13742c90596d93b240', './lib/payment/behavior/extend_membership.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/payment/behavior/index.php', '15.9', 0),
('ffd247dc572c9a19b115f58e4b0e3628', './lib/payment/behavior/perform_trade.php', '15.9', 0),
('608f99e0806c163116187a941fab92db', './lib/payment/behavior/record_cart_order.php', '15.9', 0),
('e01d77643a4eed11b0792e27826d3bc6', './lib/payment/behavior/replace_inventory.php', '15.9', 0),
('0d66348a78f2e7f3feacd8e8dcfd62b1', './lib/payment/behavior/sample.php', '15.9', 0),
('47fa5c19dbbd4a8960a7c0dd3620bcf3', './lib/payment/cartlib.js', '15.9', 0),
('ea4d2cbc8e4aea3b0eb5c8c2bf18d33e', './lib/payment/cartlib.php', '15.9', 0),
('e3b6842cd1aaf90162705ef8a83941fd', './lib/payment/cclitelib.php', '15.9', 0),
('de21ad2ed337dc163069d242deb752f7', './lib/payment/creditspaylib.php', '15.9', 0),
('0652fe6b35dc203d2a8f3d3da3ff4a30', './lib/payment/discountlib.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/payment/index.php', '15.9', 0),
('681372b7af9dc624d552c010dd9f99cb', './lib/payment/israelpostlib.php', '15.9', 0),
('38703b7c60b4ef75fc0d0ad2089ea65b', './lib/payment/paymentlib.php', '15.9', 0),
('7a96e9e8c6536cd566e815507d857193', './lib/payment/paypallib.php', '15.9', 0),
('0ce4582c470c62f1d59f7e7fc9472cdd', './lib/pdflib.php', '15.9', 0),
('695acbb81fbd3cae43b826cc6526aa0d', './lib/perspective/binderlib.php', '15.9', 0),
('48c20c50eea661a957c2e1bd479a1980', './lib/perspective/index.php', '15.9', 0),
('1f04a9353882499569a722bf3cc4b200', './lib/perspectivelib.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/phpsec/index.php', '15.9', 0),
('213cd0f49a637dc1a4fd3dd0ba172389', './lib/phpsec/phpsec.class.php', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('bb93ce67cf435310f729422b8a213bdd', './lib/phpsec/phpsec/index.php', '15.9', 0),
('bfe4f1c0e8e5290fb52beee233c947ff', './lib/phpsec/phpsec/phpsec.cache.php', '15.9', 0),
('f53e516ec23fb109818fdf25de18adfd', './lib/phpsec/phpsec/phpsec.crypt.php', '15.9', 0),
('20bba52a50f917ea881760f760c0d682', './lib/phpsec/phpsec/phpsec.filter.php', '15.9', 0),
('8ff5818149f255075f36511815546dd4', './lib/phpsec/phpsec/phpsec.hash.php', '15.9', 0),
('e19285e1f9cc7e100745bcce7e5b9107', './lib/phpsec/phpsec/phpsec.otp.php', '15.9', 0),
('c3bc6b1a8810daa22b4a1584fef1956f', './lib/phpsec/phpsec/phpsec.otpcard.php', '15.9', 0),
('e341d35be743b6c3e4152ad7bb0036b2', './lib/phpsec/phpsec/phpsec.pw.php', '15.9', 0),
('0df8ef2d0434faf913c4d8d32a9b60c0', './lib/phpsec/phpsec/phpsec.rand.php', '15.9', 0),
('3c8140273b6e9821b42c275d3fe1af07', './lib/phpsec/phpsec/phpsec.session.php', '15.9', 0),
('52cea914eec0e3369d8ca95787373179', './lib/phpsec/phpsec/phpsec.store.filesystem.php', '15.9', 0),
('e7fa2c497a7874d12da842b869c45743', './lib/phpsec/phpsec/phpsec.store.pdo.php', '15.9', 0),
('eec39a265d4a4fb97006c97ec563e30d', './lib/phpsec/phpsec/phpsec.store.php', '15.9', 0),
('4dd296cff3f92bf0bffac6e83b7451f7', './lib/phpsec/phpsec/phpsec.token.php', '15.9', 0),
('eb3e1c338f2289602bd7fce429ad35af', './lib/phpsec/phpsec/phpsec.yubikey.php', '15.9', 0),
('ef643ddcc5cbb9e1b403a338bc907eaa', './lib/phpseclib_tiki/index.php', '15.9', 0),
('9136e026b99789c8b6c9027c141ea2eb', './lib/phpseclib_tiki/tikisecure.php', '15.9', 0),
('5ac474d51778b0f850f6bbcab173d9c1', './lib/polls/index.php', '15.9', 0),
('e26d9f5a2e33483c800bb2fe830db4b5', './lib/polls/polllib.php', '15.9', 0),
('b76d1c916fad4c3adb3a0931185f3abd', './lib/polls/polllib_shared.php', '15.9', 0),
('b98ac9b56b24e0a15320079e9b8ea200', './lib/prefs/access.php', '15.9', 0),
('cad0cb79fb31cf803fbd27f09d39f07f', './lib/prefs/activity.php', '15.9', 0),
('4eced383521ea0436885c988f71f7c74', './lib/prefs/ajax.php', '15.9', 0),
('5802bf43b2ddd3e0a7fd4fada7eef51a', './lib/prefs/allocate.php', '15.9', 0),
('95b23beea5cc7348cdbdda91bcdc9bca', './lib/prefs/allowmsg.php', '15.9', 0),
('f20730e0768b89eef6fc8992509a395e', './lib/prefs/areas.php', '15.9', 0),
('7974dee62c21d93ccb410f4b0118a1ad', './lib/prefs/art.php', '15.9', 0),
('7a861a071f94ebb029e8fb37635f10dc', './lib/prefs/article.php', '15.9', 0),
('4e0c2a474baff3839f322b4107b72716', './lib/prefs/auth.php', '15.9', 0),
('0292b0e671a310e0e293cd16260dce72', './lib/prefs/available.php', '15.9', 0),
('0259fd95907212907c2de8d191db36d2', './lib/prefs/bigbluebutton.php', '15.9', 0),
('da946341fcb30a84b83bc77973f7890b', './lib/prefs/blog.php', '15.9', 0),
('e22e16315bcf39f6399efa970bc62adc', './lib/prefs/box.php', '15.9', 0),
('743d1e4eabd3d36dc6293c4d0f2b6c78', './lib/prefs/calendar.php', '15.9', 0),
('f488b8298de66f6d3a872ccc840bac57', './lib/prefs/captcha.php', '15.9', 0),
('688f760d3fe1b1ec2c36437d1ec19cdb', './lib/prefs/cas.php', '15.9', 0),
('7369835bfe4d514a82ea59347efceacf', './lib/prefs/categories.php', '15.9', 0),
('2492dfc6f446b346e0c96be7f877cfe1', './lib/prefs/category.php', '15.9', 0),
('1d29e0c3bba0196e5f1c33e4e5790922', './lib/prefs/categorypath.php', '15.9', 0),
('c2da8e3338b9b468449f9340dba9d646', './lib/prefs/center.php', '15.9', 0),
('4e7f48bc76caa342fe09c0d6f320ef10', './lib/prefs/change.php', '15.9', 0),
('880207cf2752ddea855fbe2210d8d7ee', './lib/prefs/comments.php', '15.9', 0),
('e2c50bbc3fcd46d554d3a27e43929fbe', './lib/prefs/conditions.php', '15.9', 0),
('47deebc3422203586bca4cdb7d914f5a', './lib/prefs/connect.php', '15.9', 0),
('d7c10296213d117c7d4242fdbd433984', './lib/prefs/contact.php', '15.9', 0),
('d1bf2e810463fe7fc109a1027870ef49', './lib/prefs/cookie.php', '15.9', 0),
('f4a3b0d100d63ed65bfe771a6c4dcf99', './lib/prefs/count.php', '15.9', 0),
('aba09c9d561d66494d707372f728e3b0', './lib/prefs/dailyreports.php', '15.9', 0),
('d0ca45a18162d149997e2e8215f421b8', './lib/prefs/default.php', '15.9', 0),
('3398d2267c9b04f6b3cef6c83b87b27d', './lib/prefs/desactive.php', '15.9', 0),
('1836f1babe2dd7eaa0fe8ce6532c96a5', './lib/prefs/direct.php', '15.9', 0),
('d451774f4f5fe30dba32f755445a4959', './lib/prefs/directory.php', '15.9', 0),
('3de37e4e5a85dfabcf8c079d72724d8c', './lib/prefs/display.php', '15.9', 0),
('f3f197484978e24c8f2fbed939f1a1c6', './lib/prefs/email.php', '15.9', 0),
('fab91e0b41c51614f9a8afc118ad74b2', './lib/prefs/error.php', '15.9', 0),
('bf7c57e8cd8794e905f274ae3c01c39e', './lib/prefs/faq.php', '15.9', 0),
('f570519cb21d7f777a156ab6ab2162fa', './lib/prefs/feature.php', '15.9', 0),
('d88d59457299de27de6707da309e7a5e', './lib/prefs/federated.php', '15.9', 0),
('393658b4d658645c6f6a6bdc283b1d55', './lib/prefs/feed.php', '15.9', 0),
('b0d7e53a82c34d6ccd34d5a37a2e9f22', './lib/prefs/fgal.php', '15.9', 0),
('32d6f41ba9b8524cc34493e49f85fec4', './lib/prefs/file.php', '15.9', 0),
('48184c4d8ec49c45308572a06fd264a3', './lib/prefs/flaggedrev.php', '15.9', 0),
('fccd1bd69a81161b169ec5c9879bf629', './lib/prefs/footer.php', '15.9', 0),
('3e7de06139f7f9bd26bb2eb5c88a3ad1', './lib/prefs/forum.php', '15.9', 0),
('54ec31b3656777f30825d50318a2a86a', './lib/prefs/forums.php', '15.9', 0),
('b353f5e1d098bf23d80ba0281323b612', './lib/prefs/freetags.php', '15.9', 0),
('1da14f43a75a3f7aae4ce107bcaee736', './lib/prefs/generate.php', '15.9', 0),
('604764b2e0fce49a60e988b2aa23814b', './lib/prefs/geo.php', '15.9', 0),
('3ec66cb0493684a34725dc2e9e257027', './lib/prefs/global.php', '15.9', 0),
('cebd25bb06370715e6a8bd01f088b526', './lib/prefs/gmap.php', '15.9', 0),
('07bd8209950029b3f6fcbb4fb5cf73ac', './lib/prefs/goal.php', '15.9', 0),
('bf722eace4a1e9829fe91e3ae3ae606f', './lib/prefs/header.php', '15.9', 0),
('ff2e065b3880d5aae9eda116b7c7e57f', './lib/prefs/highlight.php', '15.9', 0),
('67d5128454f2e12676700d98d47f2c0c', './lib/prefs/home.php', '15.9', 0),
('4cd0bd24502ef5e6566cb3f7949446d2', './lib/prefs/http.php', '15.9', 0),
('30f74356b3e315fc101716369181e418', './lib/prefs/https.php', '15.9', 0),
('caf2528900458741de5d29ae9f543efc', './lib/prefs/ids.php', '15.9', 0),
('224a79b93f27024310c79eae27317b24', './lib/prefs/iepngfix.php', '15.9', 0),
('547180913e3225405b15c62dc20ebef3', './lib/prefs/image.php', '15.9', 0),
('ef643ddcc5cbb9e1b403a338bc907eaa', './lib/prefs/index.php', '15.9', 0),
('bc78416a7abe187ab43797585a3dffd0', './lib/prefs/ip.php', '15.9', 0),
('c70c1415a750c5b4f8e3decd60914d05', './lib/prefs/javascript.php', '15.9', 0),
('62468550d1fc112faf4568176d830d8e', './lib/prefs/jquery.php', '15.9', 0),
('a1b4c78bbcd63c87a628ee44b0d1cfdd', './lib/prefs/kaltura.php', '15.9', 0),
('3148f452109185820773650f25555d75', './lib/prefs/keep.php', '15.9', 0),
('7c90ff10125aee608b8bda02757f346e', './lib/prefs/lang.php', '15.9', 0),
('e349a70850bda85ce632f802ce3cca84', './lib/prefs/language.php', '15.9', 0),
('c71ab7a695c901cf627a154a95c2d87e', './lib/prefs/layout.php', '15.9', 0),
('055bc73ceee08b5fbf9fbdd36797c955', './lib/prefs/ldap.php', '15.9', 0),
('cd534ef5b9da448fe5c6d9b479ba2ecf', './lib/prefs/load.php', '15.9', 0),
('073b41af64af7bc87a827394ac734f7b', './lib/prefs/lock.php', '15.9', 0),
('d6a361f9aaf8e3cde7f0768ad2bccc77', './lib/prefs/log.php', '15.9', 0),
('817b332d1b4bf82d493b190af4136a5c', './lib/prefs/login.php', '15.9', 0),
('647c40ab3909e5b3b4dd92c8f5e60eb0', './lib/prefs/long.php', '15.9', 0),
('6ade667a4ae87be0b0144e953f229358', './lib/prefs/lowercase.php', '15.9', 0),
('ed7e9977cc4c6527aa1d99e0a6b263e0', './lib/prefs/mail.php', '15.9', 0),
('6583f1d509fb3b27dcbc1b3c0cd2f31a', './lib/prefs/main.php', '15.9', 0),
('0e45c6f0e37e7b7b01be3efdb22b7d0a', './lib/prefs/max.php', '15.9', 0),
('8da6a52abda8ef8c561adc2ca6f95427', './lib/prefs/memcache.php', '15.9', 0),
('044bb1e6391777f12c0b8064615bdce4', './lib/prefs/menus.php', '15.9', 0),
('8674bb02b6ae2d3d649e3b419e2fb52b', './lib/prefs/messu.php', '15.9', 0),
('c5552bffa530f8b92fbb631bb64b84c7', './lib/prefs/metatag.php', '15.9', 0),
('741baf19e5e4a76482d9b6a7e3e1f037', './lib/prefs/middle.php', '15.9', 0),
('41936ddf14b98b0e11b9896423c912bb', './lib/prefs/min.php', '15.9', 0),
('f23fa69c94631522e36d761c0a53db07', './lib/prefs/mobile.php', '15.9', 0),
('9fb821ef2aed1581479f9d880f86dba2', './lib/prefs/module.php', '15.9', 0),
('63e0760267122719011648f5c18007b9', './lib/prefs/monitor.php', '15.9', 0),
('e246ce63df4785f3bf766528dde7feee', './lib/prefs/morelikethis.php', '15.9', 0),
('305c6c9370a9b033463557bcf86e4d98', './lib/prefs/multidomain.php', '15.9', 0),
('64d07d6c9f4588bb701ca271dd1512fb', './lib/prefs/mustread.php', '15.9', 0),
('139aa7b4659a534676c8a03e61eda001', './lib/prefs/namespace.php', '15.9', 0),
('9a9a2a4a470e295fcff1b29273883b4f', './lib/prefs/newsletter.php', '15.9', 0),
('7e3d23beff69053b6974139e4d80fca7', './lib/prefs/nextprev.php', '15.9', 0),
('d11fd19984faff99fd9d7a80e310f665', './lib/prefs/openpgp.php', '15.9', 0),
('74f01a1f64af1d9c8fab16e0bf702aa7', './lib/prefs/page.php', '15.9', 0),
('397e9735749a3d85fc77094b059fcae5', './lib/prefs/pagination.php', '15.9', 0),
('b051a2f6c3dc9f17420796b08a628fe5', './lib/prefs/pam.php', '15.9', 0),
('5125c72beaf08ec9fd216ab0d9d31e61', './lib/prefs/pass.php', '15.9', 0),
('69d244ae0c009771ee0d31dee9a2ba10', './lib/prefs/payment.php', '15.9', 0),
('6de1d3f991569fca204e72843913c237', './lib/prefs/permission.php', '15.9', 0),
('5755b043f7d374c2eb16fa5ba6e6cfef', './lib/prefs/php.php', '15.9', 0),
('74a053b21b144bbd106d01101997f0eb', './lib/prefs/poll.php', '15.9', 0),
('501aa690adfe3f0954c4e637f2907600', './lib/prefs/print.php', '15.9', 0),
('06c4812c45339c32c25cf43f495a6fa8', './lib/prefs/profile.php', '15.9', 0),
('96bb313f99aac667cb09bc1cbf65d933', './lib/prefs/proxy.php', '15.9', 0),
('b194ae1050e3903c76c9d6594707b839', './lib/prefs/quantify.php', '15.9', 0),
('bc7539712a17d9b7c1d250a9e7a6d849', './lib/prefs/rating.php', '15.9', 0),
('00a299ef9647573f0cc8f3a9fe3b9391', './lib/prefs/recaptcha.php', '15.9', 0),
('4221cdf01272e30b24dd819de693e431', './lib/prefs/record.php', '15.9', 0),
('4fc226675c497c4bbdf9475ab86e4826', './lib/prefs/restrict.php', '15.9', 0),
('e5755169002bac21ef7c6217aa4d857e', './lib/prefs/scorm.php', '15.9', 0),
('10a907d4703e624c732a8daacff2bbef', './lib/prefs/search.php', '15.9', 0),
('f460e4a40ea08aeee1d48975575081fc', './lib/prefs/section.php', '15.9', 0),
('f37f9c67363c1bdafd3654465d874f18', './lib/prefs/sender.php', '15.9', 0),
('bd111026b0d65f7b9722d5ab7a5d0d4d', './lib/prefs/server.php', '15.9', 0),
('6fadbfdea4b8e639872daa72978616db', './lib/prefs/session.php', '15.9', 0),
('b17938557c79a4173ae3650dd4a8fe1c', './lib/prefs/share.php', '15.9', 0),
('3c154524d1d4e3cfa716ad372266dbf1', './lib/prefs/shib.php', '15.9', 0),
('25a34716222bdfbbfb20f58f028b708e', './lib/prefs/shipping.php', '15.9', 0),
('8639ed72582a2d6fd327e78ff9eedcb6', './lib/prefs/short.php', '15.9', 0),
('2995ce5063a1c6f1f107b5dddd3909e9', './lib/prefs/show.php', '15.9', 0),
('bdbfee5264b78946f99317985dbc1972', './lib/prefs/site.php', '15.9', 0),
('91fd3b233fc37db4b2f1e566c12c5812', './lib/prefs/sitead.php', '15.9', 0),
('7175dbe8ec2d4c1b734f31113c0851a7', './lib/prefs/sitelogo.php', '15.9', 0),
('a4ca7fc622660dd279438daf569bc7b7', './lib/prefs/slide.php', '15.9', 0),
('b22a5cfb7b4a22b868bf6e518826a925', './lib/prefs/smarty.php', '15.9', 0),
('c05737711eecde54f9ec228b1b69beb4', './lib/prefs/social.php', '15.9', 0),
('37dcc65ffa78687cef4ff9fe4573a5d7', './lib/prefs/socialnetworks.php', '15.9', 0),
('6face18c0e034c783e2f6355a6224895', './lib/prefs/storedsearch.php', '15.9', 0),
('e25e13105a221adf067aba1bf316149a', './lib/prefs/suite.php', '15.9', 0),
('327288a2873776ff95eaad2984e4a174', './lib/prefs/theme.php', '15.9', 0),
('4ebfb917d85d2dc4afb8c1e4632eebb3', './lib/prefs/tiki.php', '15.9', 0),
('ab27d9391fbf25778b7f37e20f2fde5f', './lib/prefs/tracker.php', '15.9', 0),
('0720e1c076c921084109290799ea3642', './lib/prefs/trackerfield.php', '15.9', 0),
('f7722913b9a5480352c0ff5e392dde79', './lib/prefs/unified.php', '15.9', 0),
('2d75f6c3d6583fa690fe79f18b0e8907', './lib/prefs/unsuccessful.php', '15.9', 0),
('d1407c488e4ff264044916c641c374f6', './lib/prefs/url.php', '15.9', 0),
('8f98164871b5c1b3bee3518e5055e88e', './lib/prefs/use.php', '15.9', 0),
('4f044b18a8e7790cdd6d58d35c865ce5', './lib/prefs/user.php', '15.9', 0),
('6aa400a5b31876d79cc6894bb7355b96', './lib/prefs/userfiles.php', '15.9', 0),
('065c0139f303dbf2e7002ce9178de5de', './lib/prefs/username.php', '15.9', 0),
('f41e1bc6c01de17f4efad490b4b0cde6', './lib/prefs/users.php', '15.9', 0),
('5c2c44f113a16f0ea4cbe645d9a807a5', './lib/prefs/validator.php', '15.9', 0),
('029dea692f573e45235a65caefeb4895', './lib/prefs/vimeo.php', '15.9', 0),
('cba3be819a9d575780b41283e89b59f1', './lib/prefs/w.php', '15.9', 0),
('de5877ffc5ca89f41df2a3ec079d34a7', './lib/prefs/warn.php', '15.9', 0),
('ce6879b54b5d115a0cb1f12138da0dc7', './lib/prefs/webmail.php', '15.9', 0),
('1995bfd26e5d1a8cec86fdda218f62bf', './lib/prefs/wiki.php', '15.9', 0),
('dc9ee5d66ad6b568e58fe17e18fcbad6', './lib/prefs/wikiapproval.php', '15.9', 0),
('1fdd41cac827c51269fd431214ea0b52', './lib/prefs/wikiplugin.php', '15.9', 0),
('be51b03ff2fb42d6f99acd74ffe0e269', './lib/prefs/wikiplugininline.php', '15.9', 0),
('6a3684aed6fb59b2297a618a0a5f70a7', './lib/prefs/wikipluginprefs.php', '15.9', 0),
('3cd5aa8273822540d20560ff828aa72d', './lib/prefs/wizard.php', '15.9', 0),
('fdcd5f9c606e79e441b5414de22fa072', './lib/prefs/workspace.php', '15.9', 0),
('7389b15521f534d5ae71aa7e7a22c098', './lib/prefs/wysiwyg.php', '15.9', 0),
('a734331483d4c56b6ed6405b71d738f8', './lib/prefs/zend.php', '15.9', 0),
('23ad0a074c6b444700cc4f80ebb03452', './lib/prefs/zotero.php', '15.9', 0),
('a09aff405a1e86fdb4b0c094dbfad5a5', './lib/prefslib.php', '15.9', 0),
('d29cfb5d4f3d3762c76c6fee673110a7', './lib/profilelib/index.php', '15.9', 0),
('7658293bbf812ff106201aac3dc981e8', './lib/profilelib/shell.php', '15.9', 0),
('7fd61af01febb0d2d655002dc0b411cd', './lib/queuelib.php', '15.9', 0),
('ca5819a113b446c544f474ffd487d095', './lib/quizzes/index.php', '15.9', 0),
('6dfac34a33b966b94f66ba425ad928a0', './lib/quizzes/quizlib.php', '15.9', 0),
('d29cfb5d4f3d3762c76c6fee673110a7', './lib/rangy_tiki/index.php', '15.9', 0),
('8ba14c961b254142083975948acad297', './lib/rangy_tiki/rangy-phraser.js', '15.9', 0),
('ca5819a113b446c544f474ffd487d095', './lib/rankings/index.php', '15.9', 0),
('7c10af30b32b21049b84e2a93a34177e', './lib/rankings/ranklib.php', '15.9', 0),
('e2451627e89615887106191d7d2f7d85', './lib/rating/configlib.php', '15.9', 0),
('acb3f0231395f3e77fff711593510cf1', './lib/rating/formula/ArticleInfo.php', '15.9', 0),
('99c8982996cc89497347192a38ab7993', './lib/rating/formula/Attribute.php', '15.9', 0),
('1477a7c6c1326ed67334dae92c51e14d', './lib/rating/formula/CategoryPresent.php', '15.9', 0),
('2866ce66b528bbe25e56a78623ac2ca8', './lib/rating/formula/RatingAverage.php', '15.9', 0),
('579f5b259184f2821d3f9689af157263', './lib/rating/formula/RatingSum.php', '15.9', 0),
('1fecf762c4487686bfb9516e922dd629', './lib/rating/formula/RelationPresent.php', '15.9', 0),
('74776be1bca7620dda5f2cb1e1565b2c', './lib/rating/formula/ResultCount.php', '15.9', 0),
('8c45e49a5be143382172f48ec6b9dc84', './lib/rating/formula/TrackerField.php', '15.9', 0),
('09fc1e4bb7a082639fd26e2600e4c0f2', './lib/rating/formula/index.php', '15.9', 0),
('d29cfb5d4f3d3762c76c6fee673110a7', './lib/rating/index.php', '15.9', 0),
('48cdfd0aebd1ef700a7eabe639ccd6c9', './lib/rating/ratinglib.php', '15.9', 0),
('4c8565187b90284d785a9fdc2c535dbb', './lib/references/index.php', '15.9', 0),
('06267fb6f148f62e0b77dde8d392987b', './lib/references/referenceslib.php', '15.9', 0),
('ca5819a113b446c544f474ffd487d095', './lib/refererstats/index.php', '15.9', 0),
('3472faff59aca4603989778036f1752b', './lib/refererstats/refererlib.php', '15.9', 0),
('ca5819a113b446c544f474ffd487d095', './lib/registration/index.php', '15.9', 0),
('ea3a47b1962c204697988880ba2b3424', './lib/registration/registrationlib.php', '15.9', 0),
('ca5819a113b446c544f474ffd487d095', './lib/rss/index.php', '15.9', 0),
('a74ec53df497d27606e9f969f9dda1db', './lib/rss/pagecontentlib.php', '15.9', 0),
('102df5aef115cc271bda5369c014f03e', './lib/rss/rsslib.php', '15.9', 0),
('daef50d387eda735a4fb917d882ac08d', './lib/score/events.php', '15.9', 0),
('ca5819a113b446c544f474ffd487d095', './lib/score/index.php', '15.9', 0),
('47dffae681bf4b59ee8738d539fe2862', './lib/score/scorelib.php', '15.9', 0),
('6e4a8513af9a9097fff499c0bd47d801', './lib/search/federatedsearchlib.php', '15.9', 0),
('ca5819a113b446c544f474ffd487d095', './lib/search/index.php', '15.9', 0),
('9aef6ae0cc38d2d6e34a00c38ffc59fa', './lib/search/refresh-functions.php', '15.9', 0),
('37c4e6a44bd84648d069f9d21d1967cb', './lib/search/refresh.php', '15.9', 0),
('e8f9e63fdec61d979b2bd1b67e92b2b8', './lib/search/searchlib-mysql.php', '15.9', 0),
('56511200bc2bff0b57bd4893cdc9e955', './lib/search/searchlib-unified.php', '15.9', 0),
('964feed5cf9b03f835fcc8eb1d213204', './lib/search/searchstatslib.php', '15.9', 0),
('78c00beeeaa053fd1023b3135069997a', './lib/search/shell.php', '15.9', 0),
('9c772a5fb38311a32d0446a031ce3ddb', './lib/search/storedsearchlib.php', '15.9', 0),
('0faa62129ee679e250cc77b07c3ebef0', './lib/serializedlist.php', '15.9', 0),
('5a68aa95692c6f503b385decdfa053ee', './lib/servicelib.php', '15.9', 0),
('d04230c43be7e8a8400d65f4d5981eee', './lib/setup/absolute_urls.php', '15.9', 0),
('fba5e7017917f97f92338b4d21e9783e', './lib/setup/categories.php', '15.9', 0),
('920aa6ce09e01157bc90e14cf01aa054', './lib/setup/challenge.php', '15.9', 0),
('af8b3aecbbc1e15d603180099b86aac2', './lib/setup/comments_zone.php', '15.9', 0),
('caf3681b021f09f78b404e9aaee89567', './lib/setup/cookies.php', '15.9', 0),
('1a1e9076417547e262a60754747994db', './lib/setup/credits.php', '15.9', 0),
('9bfcdfa2a68116a6615e1bc1ab6cc920', './lib/setup/default_homepage.php', '15.9', 0),
('bc1e2392d489f031e0491aa22f77a269', './lib/setup/dynamic_variables.php', '15.9', 0),
('4dc605b2b6234b51b45fb3dcbcee73ff', './lib/setup/editmode.php', '15.9', 0),
('05418e124cae14b6794350e8ed03d7ee', './lib/setup/error_reporting.php', '15.9', 0),
('2ce439b44f0f130a222becb890931aba', './lib/setup/events.php', '15.9', 0),
('6a9fef468d75b582dcf645fff1025d6c', './lib/setup/freetags.php', '15.9', 0),
('7d7873090387d149cfcc4b04d3cd7ca6', './lib/setup/fullscreen.php', '15.9', 0),
('4a2ca4687e1710a24f3fcc0bda48efbf', './lib/setup/index.php', '15.9', 0),
('29b9c1222e6c8958b5a3b5f5fb361aa0', './lib/setup/integrator.php', '15.9', 0),
('f64f065b956e1cb48644fc7c874c0fc0', './lib/setup/javascript.php', '15.9', 0),
('a22f8213f3d26ede91b18ad5d69261f2', './lib/setup/language.php', '15.9', 0),
('da63f394ab0947bf54ca476b052cd6f0', './lib/setup/last_update.php', '15.9', 0),
('da9e1db61e5e2d7b02114cefbf350e33', './lib/setup/live_support.php', '15.9', 0),
('bec926db197996b6653b6be94eb16fc1', './lib/setup/load_threshold.php', '15.9', 0),
('c2b4afe31e564c5e402bf174a786c4d1', './lib/setup/mailin.php', '15.9', 0),
('5365a4c220652a80b5c42d692f48265b', './lib/setup/mobile.php', '15.9', 0),
('ef385686d6a6cf4c7b115afc5c5ce1fc', './lib/setup/openid.php', '15.9', 0),
('66522055891da256e98839ae67492d05', './lib/setup/output_compression.php', '15.9', 0),
('75535b448e01dd63b89d2c92fb054fb8', './lib/setup/perms.php', '15.9', 0),
('30961b89e7061ec22495577246dd14fa', './lib/setup/plugins_actions.php', '15.9', 0),
('e0179ff434e8ddde9b7d81e685ba9385', './lib/setup/polls.php', '15.9', 0),
('8a670283c8d8948365eb84e2d2741370', './lib/setup/prefs.php', '15.9', 0),
('27dc3b49c6f24ada17194193414ba296', './lib/setup/sections.php', '15.9', 0),
('032dcdbb92d98cf3431f29e6802b5302', './lib/setup/site_closed.php', '15.9', 0),
('5eb214591ead068b17b15ba8d9bbc6a5', './lib/setup/stats.php', '15.9', 0),
('ecf81d4432712268f4eb0605f59df776', './lib/setup/theme.php', '15.9', 0),
('114f64d4b9aaf676c64d68768a81836a', './lib/setup/third_party.php', '15.9', 0),
('1d134de44fd12539f32dfb9eb38a0d8e', './lib/setup/tikiIndex.php', '15.9', 0),
('294647aa5ea8431207aa70593f822389', './lib/setup/tikisetup.class.php', '15.9', 0),
('cebea1172c9a1d2e77eea0c7c909c1dd', './lib/setup/timer.class.php', '15.9', 0),
('c5b95f50d9919e956d36d9e8c5eee8ce', './lib/setup/twversion.class.php', '15.9', 0),
('bcc7ad197d9d45033f4a7384c73ab5f2', './lib/setup/user_prefs.php', '15.9', 0),
('b0a397e96f68715987a8c7cf0ae62086', './lib/setup/userlevels.php', '15.9', 0),
('fa75b57436e313711963378e8daf20b3', './lib/setup/usermenu.php', '15.9', 0),
('8bffafeb378098cbd5d2fd089ba50624', './lib/setup/wiki.php', '15.9', 0),
('ae3a103ee147370e2f2a0453ce2ff86c', './lib/sharelib.php', '15.9', 0),
('a5307940f95b663ab0df477198554bc5', './lib/sheet/conf/config.inc.php', '15.9', 0),
('09fc1e4bb7a082639fd26e2600e4c0f2', './lib/sheet/conf/index.php', '15.9', 0),
('dfd72400f47c8235c51aea5890a845f5', './lib/sheet/excel/index.php', '15.9', 0),
('70aa4f9e9dc0e57fd3c09f8e864bac9e', './lib/sheet/excel/reader.php', '15.9', 0),
('1ac9cc2c65d86d7f9af18dacb24ed917', './lib/sheet/excel/reader_ole.php', '15.9', 0),
('74cb1b95daa8554eaec7f3b0d9ad11b4', './lib/sheet/excel/writer.php', '15.9', 0),
('e994568d4069f4b3b94fcb74cb16b1f8', './lib/sheet/excel/writer/biffwriter.php', '15.9', 0),
('b6a52362850347819b0b699174e43d24', './lib/sheet/excel/writer/format.php', '15.9', 0),
('dfd72400f47c8235c51aea5890a845f5', './lib/sheet/excel/writer/index.php', '15.9', 0),
('773f04af29738732a8a9299f87839a3c', './lib/sheet/excel/writer/parser.php', '15.9', 0),
('a989f1109c974c3b1b7501ca443150f9', './lib/sheet/excel/writer/validator.php', '15.9', 0),
('2312980c14ae64cec1ceb934769e8a83', './lib/sheet/excel/writer/workbook.php', '15.9', 0),
('a7112d2a4fc77fe42423244cfacfda80', './lib/sheet/excel/writer/worksheet.php', '15.9', 0),
('d63b7b65f09f0fa8d4d92eaa96d049cf', './lib/sheet/grid.js', '15.9', 0),
('8bda48a5678be5f2f2f982cdf599fe18', './lib/sheet/grid.php', '15.9', 0),
('66afbab32be503737fda8d56794f4af8', './lib/sheet/include/core/APIC.php', '15.9', 0),
('733c7c21af11d25944d63b6736a47237', './lib/sheet/include/core/APIClass.php', '15.9', 0),
('c2ce793d82c664e46778a78e7ae3b823', './lib/sheet/include/core/APIClassRegistry.php', '15.9', 0),
('d2894659a5ff55f191231206eb1e74e9', './lib/sheet/include/core/ErrorManager.php', '15.9', 0),
('5b28bd9aa3975398d179ac93db5f9c09', './lib/sheet/include/core/Object.php', '15.9', 0),
('28996d56ac5326af82aa1c761a215588', './lib/sheet/include/core/index.php', '15.9', 0),
('09fc1e4bb7a082639fd26e2600e4c0f2', './lib/sheet/include/index.php', '15.9', 0),
('7105f08499cc0e9de74e0014db284f82', './lib/sheet/include/org/apicnet/index.php', '15.9', 0),
('98e22e19e04ade0bcbdb7a255fd52188', './lib/sheet/include/org/apicnet/io/File.php', '15.9', 0),
('4a365791195a2e17db46a58647a63a54', './lib/sheet/include/org/apicnet/io/OOo/OOoCalc.php', '15.9', 0),
('d7cbcb36a919cea1ab909e13644ed3d1', './lib/sheet/include/org/apicnet/io/OOo/OOoDoc.php', '15.9', 0),
('93206126e8fb24e3e524c197361066a0', './lib/sheet/include/org/apicnet/io/OOo/OOoManifest.php', '15.9', 0),
('0937be522ba15101f4c44df2cdf2276a', './lib/sheet/include/org/apicnet/io/OOo/OOoMeta.php', '15.9', 0),
('f5d3d09935eb028036b9374431eaca93', './lib/sheet/include/org/apicnet/io/OOo/OOoMime.php', '15.9', 0),
('6f1752619c794c78c04613cc42b9a44f', './lib/sheet/include/org/apicnet/io/OOo/OOoStyle.php', '15.9', 0),
('0fccaee96c5dfbb6d3ae9cb25b52a94b', './lib/sheet/include/org/apicnet/io/OOo/OOoUtil.php', '15.9', 0),
('68e55f23fdce620a4b88134b61068922', './lib/sheet/include/org/apicnet/io/OOo/OOoWriter.php', '15.9', 0),
('fca922b9ec3709825ad91862428ad897', './lib/sheet/include/org/apicnet/io/OOo/absOOo.php', '15.9', 0),
('5f42b8bf46be6079c587d6f0976bb207', './lib/sheet/include/org/apicnet/io/OOo/index.php', '15.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoCadre.php', '15.9', 0),
('00f4c80495ceeae2c57d8933f0abb515', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoImg.php', '15.9', 0),
('3b94931d75d80672d48650f2130f18e7', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoTable.php', '15.9', 0),
('490953a69ce5d0c1cc66714805084073', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoText.php', '15.9', 0),
('5f42b8bf46be6079c587d6f0976bb207', './lib/sheet/include/org/apicnet/io/OOo/objOOo/index.php', '15.9', 0),
('bb722eb17963f5bf6b37e9cbb47506b3', './lib/sheet/include/org/apicnet/io/archive/CZip.php', '15.9', 0),
('aeaf97baff2bd58dac009440f5d4f2e5', './lib/sheet/include/org/apicnet/io/archive/index.php', '15.9', 0),
('d335fd07eb0d18c230572830e689acbf', './lib/sheet/include/org/apicnet/io/cdir.php', '15.9', 0),
('53e4b8b9291849078d7396d321c893c1', './lib/sheet/include/org/apicnet/io/index.php', '15.9', 0),
('0e9c8a79e0bd3936082c44bcde2eac39', './lib/sheet/include/org/apicnet/util/HTTPHeader.php', '15.9', 0),
('9c02c8c048b430f598ba88b094d7e34a', './lib/sheet/include/org/apicnet/util/StringBuffer.php', '15.9', 0),
('53e4b8b9291849078d7396d321c893c1', './lib/sheet/include/org/apicnet/util/index.php', '15.9', 0),
('28996d56ac5326af82aa1c761a215588', './lib/sheet/include/org/index.php', '15.9', 0),
('dfd72400f47c8235c51aea5890a845f5', './lib/sheet/index.php', '15.9', 0),
('8f6c95eda998c957cd0b0a2424471a16', './lib/sheet/ole.php', '15.9', 0),
('dfd72400f47c8235c51aea5890a845f5', './lib/sheet/ole/index.php', '15.9', 0),
('67c73c695c14238d4e4bfb0075cf58ae', './lib/sheet/ole/pps.php', '15.9', 0),
('3d0b5c3ae7426eb0e682a12ae56d839f', './lib/sheet/ole/pps/file.php', '15.9', 0),
('dfd72400f47c8235c51aea5890a845f5', './lib/sheet/ole/pps/index.php', '15.9', 0),
('8eec7c610389e3c179cd230516ba07c1', './lib/sheet/ole/pps/root.php', '15.9', 0),
('2f949e39b1d1debe55fb7630a9938634', './lib/sheet/sheetlib.php', '15.9', 0),
('d542170ac028cc3fb010467e3e0e42d7', './lib/shipping/custom/example.php', '15.9', 0),
('09fc1e4bb7a082639fd26e2600e4c0f2', './lib/shipping/custom/index.php', '15.9', 0),
('d29cfb5d4f3d3762c76c6fee673110a7', './lib/shipping/index.php', '15.9', 0),
('9e6a9e547c05ae46eff46cbbf4cc5e85', './lib/shipping/provider_fedex.php', '15.9', 0),
('2f9cc39d17d3a5ae0d5cc5ce9e1c6774', './lib/shipping/provider_ups.php', '15.9', 0),
('c10e58a6c9f2d2b4d76eab3f85838018', './lib/shipping/shippinglib.php', '15.9', 0),
('09fc1e4bb7a082639fd26e2600e4c0f2', './lib/shipping/ups-wsdl/index.php', '15.9', 0),
('ca5819a113b446c544f474ffd487d095', './lib/shoutbox/index.php', '15.9', 0),
('4322ce083b7a71d70b94895b60e4ad17', './lib/shoutbox/shoutboxlib.php', '15.9', 0),
('d29cfb5d4f3d3762c76c6fee673110a7', './lib/simile_tiki/index.php', '15.9', 0),
('f57f519d236c4b1280f08fd48d35c5d7', './lib/simile_tiki/tiki-timeline.js', '15.9', 0),
('b9f2fbf3963a775f9b3a1fec00673e90', './lib/smarty_tiki/block.accordion.php', '15.9', 0),
('fa7711e73de4e9472b3bc83a4fe335c3', './lib/smarty_tiki/block.accordion_group.php', '15.9', 0),
('5556119ee973fa8c52775c0fcd604e1e', './lib/smarty_tiki/block.activityframe.php', '15.9', 0),
('e397eb561f59f189272976e97671c7a1', './lib/smarty_tiki/block.ajax_href.php', '15.9', 0),
('82363cb33126df11180299ec8e76f7de', './lib/smarty_tiki/block.compact.php', '15.9', 0),
('dd7243f7e9269081bae3bb8f24f3237c', './lib/smarty_tiki/block.display.php', '15.9', 0),
('424ba3ba69094d5f81b84ad832a3c9ef', './lib/smarty_tiki/block.filter.php', '15.9', 0),
('a0210b5e16a9fcb7cc97a1a0bd8ebcc3', './lib/smarty_tiki/block.ifsearchexists.php', '15.9', 0),
('4377cda25a732e6f71eef5c441fd87b6', './lib/smarty_tiki/block.ifsearchnotexists.php', '15.9', 0),
('478e6cfdc36a84c73a5cd6169802bcff', './lib/smarty_tiki/block.itemfield.php', '15.9', 0),
('e8e679e9de6d553256dd42e5d3128c40', './lib/smarty_tiki/block.jq.php', '15.9', 0),
('1999e5261b1b99bf86acb0519f706565', './lib/smarty_tiki/block.modules_list.php', '15.9', 0),
('b44badd3112dfa20fc548b9341136f62', './lib/smarty_tiki/block.pagination_links.php', '15.9', 0),
('f72a41d5780b40b14c642b6eb1fbaa18', './lib/smarty_tiki/block.permission.php', '15.9', 0),
('36169b61059154a4b9da81bb1f4ee472', './lib/smarty_tiki/block.popup_link.php', '15.9', 0),
('2d1686e47d49be2a9c628640b5b3fe0d', './lib/smarty_tiki/block.remarksbox.php', '15.9', 0),
('c42ae2724490f618f24b90a424463f76', './lib/smarty_tiki/block.repeat.php', '15.9', 0),
('00c86dedb87faea4d7d3b06c962b0005', './lib/smarty_tiki/block.self_link.php', '15.9', 0),
('ead455bfb6bf636e5104309712b53730', './lib/smarty_tiki/block.sortlinks.php', '15.9', 0),
('602682d06f1ed1ab9e1044896f122bc0', './lib/smarty_tiki/block.tab.php', '15.9', 0),
('fbeeeed16e1f55f525f94ebcafed6c41', './lib/smarty_tiki/block.tabset.php', '15.9', 0),
('884489073e8abd0743199adada51291e', './lib/smarty_tiki/block.textarea.php', '15.9', 0),
('0bd02a0ccb24c34198a40f9dc2ad9188', './lib/smarty_tiki/block.tikimodule.php', '15.9', 0),
('a1add1c1112d2e3e3d0e59c91cd260a3', './lib/smarty_tiki/block.title.php', '15.9', 0),
('fdc99fca15854109006f9c35647863da', './lib/smarty_tiki/block.tr.php', '15.9', 0),
('5800b6f5b24696f8e275c4eb304f080a', './lib/smarty_tiki/block.trackeritemcheck.php', '15.9', 0),
('5bccf90790af70a26fd6b27af9af6af9', './lib/smarty_tiki/block.translation.php', '15.9', 0),
('caa803cd0b5e184e14191de74965b93c', './lib/smarty_tiki/block.wiki.php', '15.9', 0),
('33508f9db6496e4bb6276830881e5b8e', './lib/smarty_tiki/block.wikiplugin.php', '15.9', 0),
('da376f90a998d15dfee32bba53b5ff24', './lib/smarty_tiki/compiler.assign.php', '15.9', 0),
('08f7a1b5811850298555d8e05c08e623', './lib/smarty_tiki/compiler.assign_content.php', '15.9', 0),
('f4689083bab8179e5fc74e1e68fdefa7', './lib/smarty_tiki/function.activity.php', '15.9', 0),
('4eda15e28580bcd610f3e2e1f1dcb1b2', './lib/smarty_tiki/function.addonobjectid.php', '15.9', 0),
('a15f75aada21f46f26d3a24d177f04eb', './lib/smarty_tiki/function.article.php', '15.9', 0),
('646b308ec068e24f5753862ca4b10761', './lib/smarty_tiki/function.attachments.php', '15.9', 0),
('12e515a8f5c828892838b84feef952a4', './lib/smarty_tiki/function.autocomplete.php', '15.9', 0),
('e47ca95fe76be9c7fa594e37a5f9c9c8', './lib/smarty_tiki/function.banner.php', '15.9', 0),
('759919fa2b3a92181aed903c4a0189e9', './lib/smarty_tiki/function.bootstrap_modal.php', '15.9', 0),
('03d7d71644007e2578e4bd162e732483', './lib/smarty_tiki/function.breadcrumbs.php', '15.9', 0),
('46812008d68166d96296b1e85cb7dd14', './lib/smarty_tiki/function.button.php', '15.9', 0),
('00836bde83bfa3d55ca875b84278319f', './lib/smarty_tiki/function.categoryName.php', '15.9', 0),
('39e461db1874860e6865ffb6b69d5c5b', './lib/smarty_tiki/function.categoryselector.php', '15.9', 0),
('6a0ae89b03ba5f3966a7734d371cc244', './lib/smarty_tiki/function.content.php', '15.9', 0),
('15c1eff06c40c95e830cf7bc2ca1e82f', './lib/smarty_tiki/function.cookie.php', '15.9', 0),
('50dd2b5760052ad5343d950d16e7bf76', './lib/smarty_tiki/function.cookie_jar.php', '15.9', 0),
('66e5b553ded2106c1305b70a3ad8869d', './lib/smarty_tiki/function.count.php', '15.9', 0),
('2294af1dcd0dcf8838a8b17aa153bbb9', './lib/smarty_tiki/function.custom_template.php', '15.9', 0),
('a7824a5d7aed8ffa21bafd111a250f36', './lib/smarty_tiki/function.datetime_range.php', '15.9', 0),
('591375e3607e9e3874468b67bb4af034', './lib/smarty_tiki/function.debugger.php', '15.9', 0),
('58b1bd27b4ca58c6df1dc180bdfe40f8', './lib/smarty_tiki/function.defaultmapcenter.php', '15.9', 0),
('b663619e0746ce6386e5e89ceac601f6', './lib/smarty_tiki/function.ed.php', '15.9', 0),
('2e77c8fce972acfe519fcdc69bba922f', './lib/smarty_tiki/function.elapsed.php', '15.9', 0),
('7b58130c0084c860f7520e03b666f0d6', './lib/smarty_tiki/function.error_report.php', '15.9', 0),
('797c3051b66a0450066b9927013069e3', './lib/smarty_tiki/function.favorite.php', '15.9', 0),
('f8ba73be3109341ca9408ce350e8f696', './lib/smarty_tiki/function.fgal_browse.php', '15.9', 0),
('9bece826b7d1616af5f642030789838a', './lib/smarty_tiki/function.file_selector.php', '15.9', 0),
('4c3023daca1a3548f53223a3d654954a', './lib/smarty_tiki/function.filegal_manager_url.php', '15.9', 0),
('dc60bedb11e9544a582e629d96b155af', './lib/smarty_tiki/function.filegal_uploader.php', '15.9', 0),
('ce436f8aa51b812e42b692661ad6e446', './lib/smarty_tiki/function.fileinfo.php', '15.9', 0),
('b2822c9b7a6e8b0688689639597283b9', './lib/smarty_tiki/function.formitem.php', '15.9', 0),
('2b0efbffd7275f842514b4beabbfe9e5', './lib/smarty_tiki/function.gallery.php', '15.9', 0),
('a38e62b80ad6b576fab6fdc0f59fe4e8', './lib/smarty_tiki/function.help.php', '15.9', 0),
('89f31d5f8c53ae4060ec0d9cab743168', './lib/smarty_tiki/function.html_body_attributes.php', '15.9', 0),
('8f7ca1c164951e68607c59ae3d31dc22', './lib/smarty_tiki/function.html_select_date.php', '15.9', 0),
('562b99662eaf3e12c8f8fbf1f240843f', './lib/smarty_tiki/function.html_select_duration.php', '15.9', 0),
('0a250655a5f444eff456fcbb8b2db882', './lib/smarty_tiki/function.html_select_time.php', '15.9', 0),
('b59e50a879b6f25e2536a693ab20131a', './lib/smarty_tiki/function.icon.php', '15.9', 0),
('e8a3effcf12581c5e9e40c5249088f27', './lib/smarty_tiki/function.initials_filter_links.php', '15.9', 0),
('449a8b48ac28bf5c998bf69053e8a133', './lib/smarty_tiki/function.interactivetranslation.php', '15.9', 0),
('91fc7ba657f2d8b8277bed5043be7c80', './lib/smarty_tiki/function.js_insert_icon.php', '15.9', 0),
('365a839b4a2363c0d0aa3f93e0f76115', './lib/smarty_tiki/function.js_maxlength.php', '15.9', 0),
('50b01c0faf24a739df2db448f89aefc1', './lib/smarty_tiki/function.jscalendar.php', '15.9', 0),
('3642a67656991797536b5dfc3cb4c5ac', './lib/smarty_tiki/function.jspopup.php', '15.9', 0),
('c7c7783cca4ec6201bcb1cd451e66630', './lib/smarty_tiki/function.like.php', '15.9', 0),
('40788a05f2ebcf0dc2f6d59e9400181d', './lib/smarty_tiki/function.listfilter.php', '15.9', 0),
('1672a940b8930a88c0515e949ed8f24c', './lib/smarty_tiki/function.lock.php', '15.9', 0),
('eb440f32b88f90dabe7448cd22b43c75', './lib/smarty_tiki/function.memusage.php', '15.9', 0),
('366569010eb31db1d992d3ae0e40635a', './lib/smarty_tiki/function.menu.php', '15.9', 0),
('3f42e7f7e786134aead42b472ee65133', './lib/smarty_tiki/function.module.php', '15.9', 0),
('1d30fe1f5ecf47b552e795c4ec5fca25', './lib/smarty_tiki/function.modulelist.php', '15.9', 0),
('2dd4d87bc2c2426996f51f082d480c59', './lib/smarty_tiki/function.monitor_link.php', '15.9', 0),
('6abee438080c9805e0aecbd3b51a1ad3', './lib/smarty_tiki/function.multilike.php', '15.9', 0),
('0464a003f09cb69102edd9863f903323', './lib/smarty_tiki/function.norecords.php', '15.9', 0),
('a28ccd7bcb7552c3f2cf6b1144cc799c', './lib/smarty_tiki/function.notification_link.php', '15.9', 0),
('d24b67ef5fcd2b02eb532e16fc195efa', './lib/smarty_tiki/function.obj_in_cat.php', '15.9', 0),
('da4538212337f8b4f8179bdf3accfdbc', './lib/smarty_tiki/function.object_link.php', '15.9', 0),
('966e592a0e00228f519f296c91d86d5e', './lib/smarty_tiki/function.object_selector.php', '15.9', 0),
('9037527fcfee6a967aa270de53768d3a', './lib/smarty_tiki/function.object_selector_multi.php', '15.9', 0),
('e4dc9dd45fb2868c82b9a32b9047d518', './lib/smarty_tiki/function.object_title.php', '15.9', 0),
('384dce7c449f4ff698227c68ae814450', './lib/smarty_tiki/function.page_alias.php', '15.9', 0),
('c338276cffa664a02e69b580f7293654', './lib/smarty_tiki/function.page_in_structure.php', '15.9', 0),
('4bdd2720d58f7500bdd875984ec3a50c', './lib/smarty_tiki/function.payment.php', '15.9', 0),
('ef7847179a8521d4c3bcc646db048024', './lib/smarty_tiki/function.permission_link.php', '15.9', 0),
('dd056565443ff3c9e3ee82d8d2561975', './lib/smarty_tiki/function.poll.php', '15.9', 0),
('a4956a3b7ba5e02b512586fe5d16ac3a', './lib/smarty_tiki/function.popup.php', '15.9', 0),
('f67e84bf952bdf0b56d8abab9c714186', './lib/smarty_tiki/function.preference.php', '15.9', 0),
('8bd16a73d9ec9e5310dd7b7f8ebb9b69', './lib/smarty_tiki/function.query.php', '15.9', 0),
('5dc5a4ed903c080cdba3702c64d00cce', './lib/smarty_tiki/function.quotabar.php', '15.9', 0),
('60a297bc27126961ede4667dd22ab53a', './lib/smarty_tiki/function.rating.php', '15.9', 0),
('2a9f492405159370d6666be195c47e6a', './lib/smarty_tiki/function.rating_choice.php', '15.9', 0),
('0d72d58a4521d666f41e546e103a7957', './lib/smarty_tiki/function.rating_override_menu.php', '15.9', 0),
('eb32573936b1896dfbe694b9be96f18d', './lib/smarty_tiki/function.rating_result.php', '15.9', 0),
('465b6e0f94a8b776f430bdbf21ab9da1', './lib/smarty_tiki/function.rating_result_avg.php', '15.9', 0),
('db20bc4b56a69ae0d7f91fa3ed7a9bb3', './lib/smarty_tiki/function.rcontent.php', '15.9', 0),
('54ba87cdf95a7922b8c4287b5861589c', './lib/smarty_tiki/function.redirect.php', '15.9', 0),
('3b51c1bbad432535b93d7f7448783845', './lib/smarty_tiki/function.reindex_file_pixel.php', '15.9', 0),
('ded66533347f51c353a7864831e374e3', './lib/smarty_tiki/function.rss.php', '15.9', 0),
('dc756877f12ae920bf1a5eda27d37e55', './lib/smarty_tiki/function.sameurl.php', '15.9', 0),
('ee2e09a1b544ca4f761b5a24e649c842', './lib/smarty_tiki/function.sefurl.php', '15.9', 0),
('cbe69917f9f965e9ed7fc199a9ef94fe', './lib/smarty_tiki/function.select_all.php', '15.9', 0),
('2d9a8f183946d3af5b4c20bc65272943', './lib/smarty_tiki/function.service.php', '15.9', 0),
('ab34f4a980235177aec76ca3fe0a57cd', './lib/smarty_tiki/function.service_inline.php', '15.9', 0),
('1b96ab78b38fb0c5235194961d2aaea8', './lib/smarty_tiki/function.set.php', '15.9', 0),
('8df70416e82f24fe9135a9693cca8715', './lib/smarty_tiki/function.show_sort.php', '15.9', 0),
('3fc0134b449299ef75365dc77868708b', './lib/smarty_tiki/function.thumb.php', '15.9', 0),
('1a76a5c9d76e4ce814043efa629714b4', './lib/smarty_tiki/function.ticket.php', '15.9', 0),
('035916f37c5f5ba3204d2cbd30f7191d', './lib/smarty_tiki/function.toolbars.php', '15.9', 0),
('1c97737cc24bf1f94c33506a446675dd', './lib/smarty_tiki/function.trackerfields.php', '15.9', 0),
('9835aadbed35a1c0da5f441980e602e9', './lib/smarty_tiki/function.trackerheader.php', '15.9', 0),
('812c9f0fae9b1583855849c672491878', './lib/smarty_tiki/function.trackerinput.php', '15.9', 0),
('0efd812825e2263ad1126f6e3ce691fb', './lib/smarty_tiki/function.trackeroutput.php', '15.9', 0),
('c0243854b9c9d3e9a702c7b2dbdb7882', './lib/smarty_tiki/function.treetable.php', '15.9', 0),
('acf6651dedf99bff2917c8f38c0fef1d', './lib/smarty_tiki/function.user_registration.php', '15.9', 0),
('265a45ffe5fb5b66efb86f76c6a111e9', './lib/smarty_tiki/function.user_selector.php', '15.9', 0),
('ca0e44435164dd24c45d104a1b2c22ed', './lib/smarty_tiki/function.var_dump.php', '15.9', 0),
('2684892f69c73ddef780084bff40a8f7', './lib/smarty_tiki/function.wikidiff.php', '15.9', 0),
('cb49a8deb43e310d32496cdcf024b74e', './lib/smarty_tiki/function.wikistructure.php', '15.9', 0),
('8863751c8d3c0cfea7de57121e6b210d', './lib/smarty_tiki/index.php', '15.9', 0),
('7ff3e6f63b6a39d8337e3a58f4ef1e4c', './lib/smarty_tiki/modifier.a_or_an.php', '15.9', 0),
('346d91012213a34724768673264fb48b', './lib/smarty_tiki/modifier.addongroupname.php', '15.9', 0),
('b2c6874b9e371870b1625d5205fc4d40', './lib/smarty_tiki/modifier.addonitemid.php', '15.9', 0),
('58e5569eeed4a45bd8d5955c3d9264c6', './lib/smarty_tiki/modifier.addonnavbar.php', '15.9', 0),
('5b967c10408e8f7390b51ad4fb936126', './lib/smarty_tiki/modifier.adjust.php', '15.9', 0),
('25ec515d4c23c6dfc5b36dc90ac0afe7', './lib/smarty_tiki/modifier.avatarize.php', '15.9', 0),
('ffa4e540d53e93a810d755427329d62b', './lib/smarty_tiki/modifier.breakline.php', '15.9', 0),
('edae9e28b9f7f626a6361dfe624104b1', './lib/smarty_tiki/modifier.compactisodate.php', '15.9', 0),
('01b358e106e2a3ab9165210f7d7e00c8', './lib/smarty_tiki/modifier.countryflag.php', '15.9', 0),
('fa10f3997f8ab86fb7aac1ad4af5037e', './lib/smarty_tiki/modifier.dbg.php', '15.9', 0),
('c13e86d117ea88b9d233dc052cb282ca', './lib/smarty_tiki/modifier.div.php', '15.9', 0),
('7e107bccba10c0c9a2d418c3aa799036', './lib/smarty_tiki/modifier.duration.php', '15.9', 0),
('4e46d0cd5aed5adadd919afc0093cb7e', './lib/smarty_tiki/modifier.duration_short.php', '15.9', 0),
('c3944fe509e08db297562423f0f2bc59', './lib/smarty_tiki/modifier.escape.php', '15.9', 0),
('ff3e284162dd8b9f1da3faabc26f3362', './lib/smarty_tiki/modifier.forumname.php', '15.9', 0),
('428a370bf6a4d1c5f26b8780d28bc3f3', './lib/smarty_tiki/modifier.forumtopiccount.php', '15.9', 0),
('e4f9ea5fb62edfa38636d1f0bd6d7123', './lib/smarty_tiki/modifier.groupmembercount.php', '15.9', 0),
('59e7cc74b1ddcb07467230e23abe5453', './lib/smarty_tiki/modifier.how_many_user_inscriptions.php', '15.9', 0),
('65210169329ab645fbf9738b81d4acbe', './lib/smarty_tiki/modifier.htmldecode.php', '15.9', 0),
('dbd33e1de2428d033785cf875901a23e', './lib/smarty_tiki/modifier.iconify.php', '15.9', 0),
('236ae66428d742e1957948eb9dc2ee2f', './lib/smarty_tiki/modifier.in_group.php', '15.9', 0),
('7aaee4079aa37cb0a4b96160feadb9c2', './lib/smarty_tiki/modifier.isodate.php', '15.9', 0),
('e21034fb51cd766ce797378d10f9a373', './lib/smarty_tiki/modifier.kbsize.php', '15.9', 0),
('410b7b835483d41994739d6242d150e4', './lib/smarty_tiki/modifier.langname.php', '15.9', 0),
('f27c278a722052d0c1419a0e362054f4', './lib/smarty_tiki/modifier.lcfirst.php', '15.9', 0),
('ac8ebe001c15b548a1d5bf433ebb16a9', './lib/smarty_tiki/modifier.max_user_inscriptions.php', '15.9', 0),
('4797f004a72627c3012ec3435fd33b46', './lib/smarty_tiki/modifier.money_format.php', '15.9', 0),
('7f516b1e0649caf67d1e9a754e799899', './lib/smarty_tiki/modifier.namespace.php', '15.9', 0),
('69e55d86fcc96fc5979d659bd6e89868', './lib/smarty_tiki/modifier.nonamespace.php', '15.9', 0),
('cd1b9aa49cefcb2cde15f4728cd7de40', './lib/smarty_tiki/modifier.nonp.php', '15.9', 0),
('b05e618859b35e686e1cfaba78d59c47', './lib/smarty_tiki/modifier.number_format.php', '15.9', 0),
('29ddece1930355b6d86ed31c599f4004', './lib/smarty_tiki/modifier.output.php', '15.9', 0),
('8ca186954a8317d524932eb1408dd3e8', './lib/smarty_tiki/modifier.pagename.php', '15.9', 0),
('55b4a3554f83fc4ee12e8b102e70d888', './lib/smarty_tiki/modifier.percent.php', '15.9', 0),
('7312f183b6447304f4ecf67bd3fd0413', './lib/smarty_tiki/modifier.quoted.php', '15.9', 0),
('07147e95c42bfd514c0d73c57ea8eeb4', './lib/smarty_tiki/modifier.replacei.php', '15.9', 0),
('9be98efc49b4ffbced57c48212e21249', './lib/smarty_tiki/modifier.reverse_array.php', '15.9', 0),
('974b3767f5c0ce4be72904b3f5000ce4', './lib/smarty_tiki/modifier.sefurl.php', '15.9', 0),
('56e5f217d2584e25dadd819f89c4adc7', './lib/smarty_tiki/modifier.simplewiki.php', '15.9', 0),
('72b366a9fe10cc78bdb0af1a4c47dce3', './lib/smarty_tiki/modifier.star.php', '15.9', 0),
('3766ff1b8e21150707d74c042a09f5cc', './lib/smarty_tiki/modifier.stringfix.php', '15.9', 0),
('ae3d34c4906864aa0d3e4ebb3f727c4c', './lib/smarty_tiki/modifier.substring.php', '15.9', 0),
('330e03ca8a9f5f5aa85771bf5007b396', './lib/smarty_tiki/modifier.tasklink.php', '15.9', 0),
('4bed20578474b5a11dd20c9d774e71a5', './lib/smarty_tiki/modifier.template.php', '15.9', 0),
('f44512faba307edafa598148a8c8d914', './lib/smarty_tiki/modifier.tiki_date_format.php', '15.9', 0),
('06880b1a7367a4c4f034e80d738c1ed4', './lib/smarty_tiki/modifier.tiki_long_date.php', '15.9', 0),
('d6599f44486d276c50dc0d8d6bbda4e7', './lib/smarty_tiki/modifier.tiki_long_datetime.php', '15.9', 0),
('fd857b13e385eba20bcffe9d26a6e4c1', './lib/smarty_tiki/modifier.tiki_long_time.php', '15.9', 0),
('b4dff30ab11aca502ca2e21ee3235797', './lib/smarty_tiki/modifier.tiki_remaining_days_from_now.php', '15.9', 0),
('1f9f8771342fe3e8cc9b7112ccdd5371', './lib/smarty_tiki/modifier.tiki_short_date.php', '15.9', 0),
('d8b05eda3f31f89e4d50e34a848a0814', './lib/smarty_tiki/modifier.tiki_short_datetime.php', '15.9', 0),
('49deb97cbc808a31ae0293b3046e9ae0', './lib/smarty_tiki/modifier.tiki_short_time.php', '15.9', 0),
('2e7d6793ce97f690897a87edcabf030a', './lib/smarty_tiki/modifier.times.php', '15.9', 0),
('bf0b739e79ef28cc0540e1eac4f53f23', './lib/smarty_tiki/modifier.tr_if.php', '15.9', 0),
('d18371fd0e9c809732753ce17462e5a9', './lib/smarty_tiki/modifier.truex.php', '15.9', 0),
('c7c6b56110061ab45a8aa286a195f622', './lib/smarty_tiki/modifier.truncate.php', '15.9', 0),
('bf35988f053c786bc1b574a47a4b1ad9', './lib/smarty_tiki/modifier.userlink.php', '15.9', 0),
('2a67d68183a47d5eb3b4467d90b5dc64', './lib/smarty_tiki/modifier.username.php', '15.9', 0),
('c37c537ba2e1b81a147dc7a36f9dcc0f', './lib/smarty_tiki/modifier.utf8unicode.php', '15.9', 0),
('d7c070710834d1205bf638da9d39ad24', './lib/smarty_tiki/modifier.virtual_path.php', '15.9', 0),
('28f65e8661199ddb828bf2b9f88a4bb8', './lib/smarty_tiki/modifier.yesno.php', '15.9', 0),
('da3c2b2fdbd3aed6e6ab21e56c07a21d', './lib/smarty_tiki/outputfilter.highlight.php', '15.9', 0),
('623c814dbac670219f7af20487fa8fd2', './lib/smarty_tiki/outputfilter.ticket.php', '15.9', 0),
('ca56f45e1bc274f8a449e60be2afa7e8', './lib/smarty_tiki/prefilter.jq.php', '15.9', 0),
('e295be255f7d7c2359bc4d6b4c7d1bba', './lib/smarty_tiki/prefilter.log_tpl.php', '15.9', 0),
('a293f1fbbbd646c7caa87bfb91c6dd6b', './lib/smarty_tiki/prefilter.tr.php', '15.9', 0),
('ee81c74d688da69f7e39c949761fb0c5', './lib/smarty_tiki/resource.tplwiki.php', '15.9', 0),
('8efd5e36ecc63cfac616555d5d0b50c2', './lib/smarty_tiki/resource.wiki.php', '15.9', 0),
('4c577dbd8340fd0235d6701ad338005a', './lib/soap/index.php', '15.9', 0),
('c18a815c60d80185da05358266c9e793', './lib/soap/nusoap/index.php', '15.9', 0),
('6d1bde510858a21283835ce868c8ef81', './lib/soap/nusoap/nusoap.php', '15.9', 0),
('8eed4fbcbb96f723881abb2593ee6088', './lib/soap/soaplib.php', '15.9', 0),
('cf48ac42d1f76cbeb5f813e9df33af42', './lib/soap/tiki-admin_webservices.js', '15.9', 0),
('092ad9d4bc99a06559a645b8355024f2', './lib/soap/wsdllib.php', '15.9', 0),
('c2a388063cc9ab61699cc11041e8520e', './lib/socialnetworkslib.php', '15.9', 0),
('53367cfbe0a6c94efe0c53738d2d89a6', './lib/stats/index.php', '15.9', 0),
('171edcbe1283ff2bfa412f1a92928e0a', './lib/stats/statslib.php', '15.9', 0),
('53367cfbe0a6c94efe0c53738d2d89a6', './lib/structures/index.php', '15.9', 0),
('cee36c1cbbfe85239101f3f351b7cb95', './lib/structures/structlib.php', '15.9', 0),
('47f15456acb718b9c8fc3c14f7eb14ce', './lib/structures/tiki-edit_structure.js', '15.9', 0),
('53367cfbe0a6c94efe0c53738d2d89a6', './lib/surveys/index.php', '15.9', 0),
('bf0c3e37b24a9c35a6e4f59da917b2c0', './lib/surveys/surveylib.php', '15.9', 0),
('f04f0df5d90c9014142853756de46a97', './lib/surveys/tiki-admin_survey_questions.js', '15.9', 0),
('0e4c3417e83c51768060b087347c344f', './lib/svg-edit_tiki/draw.css', '15.9', 0),
('5d35e41cbd8240fdfad8477332677631', './lib/svg-edit_tiki/draw.js', '15.9', 0),
('4c577dbd8340fd0235d6701ad338005a', './lib/svg-edit_tiki/index.php', '15.9', 0),
('4c577dbd8340fd0235d6701ad338005a', './lib/swfobject/index.php', '15.9', 0),
('c18a815c60d80185da05358266c9e793', './lib/swfobject/src/index.php', '15.9', 0),
('8c2ec4bc2c9a39bc3f4ff92223077cf6', './lib/swfobject/src/swfobject.js', '15.9', 0),
('892a543f3abb54e8ec1ada55be3b0649', './lib/swfobject/swfobject.js', '15.9', 0),
('53367cfbe0a6c94efe0c53738d2d89a6', './lib/taglines/index.php', '15.9', 0),
('adb7a7283fd60eb47b189fade0006353', './lib/taglines/taglinelib.php', '15.9', 0),
('2d555e191391b815d470ef6e2fd50217', './lib/tail/index.php', '15.9', 0),
('232baac8701c8a3824a8fa39a3139e99', './lib/tar.class.php', '15.9', 0),
('53367cfbe0a6c94efe0c53738d2d89a6', './lib/tasks/index.php', '15.9', 0),
('80ff6ecc35ff9c749f9e8d8c1d0e8470', './lib/tasks/tasklib.php', '15.9', 0),
('53367cfbe0a6c94efe0c53738d2d89a6', './lib/templates/index.php', '15.9', 0),
('be37ae909aff92c0dccc2f261f58b759', './lib/templates/templateslib.php', '15.9', 0),
('be89e2b3a3e3415375e9ed896a740cfa', './lib/test/AcceptanceTests/AllTests.php', '15.9', 0),
('072d8b7a22e31c0bead6620bfeb17094', './lib/test/AcceptanceTests/CollaborativeMultilingualTerminologyTest.php', '15.9', 0),
('e1582718adb498630089dad5c7be14ab', './lib/test/AcceptanceTests/ListPagesTest.php', '15.9', 0),
('4280d7ac908750799c8bb8ca43707fa5', './lib/test/AcceptanceTests/MultilingualTest.php', '15.9', 0),
('e5117fdd67d28ddae4a6daf1d3160e92', './lib/test/AcceptanceTests/MultilinguallibTest.php', '15.9', 0),
('de1a50ec0e4aaf1b698ce7806db2ec57', './lib/test/AcceptanceTests/SearchTest.php', '15.9', 0),
('c0c9d835a950b97f13fdff7a60ef0fd8', './lib/test/AcceptanceTests/TikiLibrariesAccessTest.php', '15.9', 0),
('c18a815c60d80185da05358266c9e793', './lib/test/AcceptanceTests/index.php', '15.9', 0),
('2dec0fc106c9da6d1c89079d5479c0ab', './lib/test/AcceptanceTests/utils/create_dump_db_file.php', '15.9', 0),
('028b4d76a9d390b714059d22fa54c069', './lib/test/AcceptanceTests/utils/index.php', '15.9', 0),
('7ecc78c21b1cc0f8e1f65f12e5bf081b', './lib/test/AcceptanceTests/utils/restore_db_dump.php', '15.9', 0),
('7fe67bdad317878c996349788371e70a', './lib/test/AcceptanceTests/utils/upgrade_test_database_dump_file.php', '15.9', 0),
('85d46abf99e167a9d0786c943b5bc4a4', './lib/test/AllTestsAcceptance.php', '15.9', 0),
('f109f01cfefa989e4229f87d182ba1cd', './lib/test/Calendar/DateTest.php', '15.9', 0),
('ab7be6d1f7a3e1ff49abe1ca592271a7', './lib/test/Calendar/index.php', '15.9', 0),
('fbb6887a0fb4a4303d4abd0489e4f4fa', './lib/test/ContinuousIntegationTesting.php', '15.9', 0),
('c18a815c60d80185da05358266c9e793', './lib/test/IntegrationTests/index.php', '15.9', 0),
('d122b8fcc6693a26b6847845c9b03b10', './lib/test/MultilingualLibTest.php', '15.9', 0),
('20d8954f27c88da10870c492de58efb3', './lib/test/TestHelpers.php', '15.9', 0),
('c24937492b7a0d2356a776aa2bd7e4df', './lib/test/TestRunnerWithBaseline.php', '15.9', 0),
('d5a32b80802608868d82e30f603ef1de', './lib/test/TestRunnerWithBaselineTest.php', '15.9', 0),
('5c76c98f9aa3679a70e97ef43abf51fe', './lib/test/TestableTikiLib.php', '15.9', 0),
('6993dd17498e36b7b6316928307cd867', './lib/test/TikiAcceptanceTestDBRestorer.php', '15.9', 0),
('3a3a5f18d22a359e1e7de743455d3f7f', './lib/test/TikiDatabaseTestCase.php', '15.9', 0),
('19a1b007935a0368af8a858346218a54', './lib/test/TikiLib/LibTest.php', '15.9', 0),
('dd9cfb881cee391b7b4751ac8f55d626', './lib/test/TikiLib/MultiExplodeTest.php', '15.9', 0),
('4833043308e4c32ad20247adba5df9d7', './lib/test/TikiLib/TestableTikiLibTest.php', '15.9', 0),
('9668d1cd74b254659c91da5dfba2b64a', './lib/test/TikiLib/TikiLibTest.php', '15.9', 0),
('6866dd1ad9140b9288ab6060e244372d', './lib/test/TikiLib/UriMergeTest.php', '15.9', 0),
('213c3c607af4f53257a7c655dd89ddf7', './lib/test/TikiLib/UrlEncodeAccentTest.php', '15.9', 0),
('40c44eeb410e52104bf2f5fa7cf92488', './lib/test/TikiLib/WikiParserTest.php', '15.9', 0),
('c18a815c60d80185da05358266c9e793', './lib/test/TikiLib/index.php', '15.9', 0),
('692259c103d649c79f2a3bb05232060d', './lib/test/TikiSeleniumTestCase.php', '15.9', 0),
('8ef73b688d235e9052e81defdaa12faa', './lib/test/TikiTestCase.php', '15.9', 0),
('bc634c5e088f1c5c9e8cba28800bf9d8', './lib/test/TikiVersionTest.php', '15.9', 0),
('ec14e3f3ff014ef92ea123319c3ae8a4', './lib/test/attributes/AttributeTest.php', '15.9', 0),
('1117bf7d41e0b98de4753a4d5027f7c1', './lib/test/attributes/RelationTest.php', '15.9', 0),
('c18a815c60d80185da05358266c9e793', './lib/test/attributes/index.php', '15.9', 0),
('aa06be09223e9f9cb1055436beaa2781', './lib/test/auth/AuthTokensTest.php', '15.9', 0),
('2053ef5297e08167debbdb5f1f8a6477', './lib/test/auth/MembershipTest.php', '15.9', 0),
('1dc0bfea00f8d8ff8102d5b58c6af727', './lib/test/auth/PasswordTest.php', '15.9', 0),
('028b4d76a9d390b714059d22fa54c069', './lib/test/auth/fixtures/index.php', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('c18a815c60d80185da05358266c9e793', './lib/test/auth/index.php', '15.9', 0),
('e2c0781f07e66e059a64e03bdb61e50b', './lib/test/bigbluebutton/DynamicConfigurationTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/bigbluebutton/index.php', '15.9', 0),
('0813968751b691db551fa8de9792e7bd', './lib/test/bootstrap.php', '15.9', 0),
('b3af9988c5f85139025987c8ad1da309', './lib/test/comments/CommentsTest.php', '15.9', 0),
('4c577dbd8340fd0235d6701ad338005a', './lib/test/comments/index.php', '15.9', 0),
('2a58410a053bbfd45476cb7a486fa269', './lib/test/core/Category/ManipulatorTest.php', '15.9', 0),
('028b4d76a9d390b714059d22fa54c069', './lib/test/core/Category/index.php', '15.9', 0),
('b433a11b4ccf2b1abc9f918d62e6c4cd', './lib/test/core/Connect/ClientTest.php', '15.9', 0),
('028b4d76a9d390b714059d22fa54c069', './lib/test/core/Connect/index.php', '15.9', 0),
('70413e4ee66617d65726be06b92b7199', './lib/test/core/DeclFilter/BaseTest.php', '15.9', 0),
('800975d5bbbaf4a4bfdb53b6b9eea933', './lib/test/core/DeclFilter/CatchAllFilterTest.php', '15.9', 0),
('bea3f6476252ae461938293284b0d09e', './lib/test/core/DeclFilter/CatchAllUnsetTest.php', '15.9', 0),
('147b09f1a49f9cecb2148f9777ed11df', './lib/test/core/DeclFilter/ConfigureTest.php', '15.9', 0),
('53828fd99be5bd29b3e4b5855e5a010e', './lib/test/core/DeclFilter/KeyPatternFilterTest.php', '15.9', 0),
('1f96c9238db4df1063332f1640869e2d', './lib/test/core/DeclFilter/KeyPatternUnsetTest.php', '15.9', 0),
('35672479be1e32a17e1517903fed7d48', './lib/test/core/DeclFilter/StaticKeyFilterTest.php', '15.9', 0),
('a1341d73022b381f415c0efc55a99c22', './lib/test/core/DeclFilter/StaticKeyUnsetTest.php', '15.9', 0),
('028b4d76a9d390b714059d22fa54c069', './lib/test/core/DeclFilter/index.php', '15.9', 0),
('149d7b7033725569f3dddbe152eb83b6', './lib/test/core/Event/CustomizerTest.php', '15.9', 0),
('d40ac1df18d53e1b00c01deeb53363ed', './lib/test/core/Event/ManagerTest.php', '15.9', 0),
('028b4d76a9d390b714059d22fa54c069', './lib/test/core/Event/index.php', '15.9', 0),
('bc460851d8b5d2654a44fa1f23bb4c65', './lib/test/core/JitFilter/AccessTest.php', '15.9', 0),
('722b3aabf4ab838e23a260792855d646', './lib/test/core/JitFilter/FilterTest.php', '15.9', 0),
('e1bd210c5a0c3077eaf8057565d1a8d3', './lib/test/core/JitFilter/IteratorTest.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/JitFilter/index.php', '15.9', 0),
('20c96be6ed3c32cef9fe2e155e99f6c8', './lib/test/core/Math/Formula/DummyFunction/FortyTwo.php', '15.9', 0),
('1790e764838b52b89ce7d5307c317e8f', './lib/test/core/Math/Formula/DummyFunction/Testop.php', '15.9', 0),
('f2f05ec8b4b9ac585bbcb41aee1d4d0a', './lib/test/core/Math/Formula/DummyFunction/index.php', '15.9', 0),
('08b8b641797b454f9abc76a05ab4768a', './lib/test/core/Math/Formula/ElementTest.php', '15.9', 0),
('d081eb3eb108d9193e0d6f179df7945b', './lib/test/core/Math/Formula/ParserTest.php', '15.9', 0),
('9f4ba7b830e5800eaf9dbe2e24948694', './lib/test/core/Math/Formula/RunnerTest.php', '15.9', 0),
('af35bd2332ad53b6e6e5faa3f802bf65', './lib/test/core/Math/Formula/TokenizerTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Math/Formula/index.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/Math/index.php', '15.9', 0),
('03e25eb0621e42dfc7a6a5379fa4d873', './lib/test/core/Multilingual/Aligner/BilingualAlignerTest.php', '15.9', 0),
('6d6a6e1b14de3229e7c864942210d7f4', './lib/test/core/Multilingual/Aligner/SentenceAlignmentsTest.php', '15.9', 0),
('52c92309d0a3ecddf4b3b7248485998c', './lib/test/core/Multilingual/Aligner/SentenceSegmentorTest.php', '15.9', 0),
('d5c1c7658b50a97e18569eb387432e6c', './lib/test/core/Multilingual/Aligner/ShortestPathFinderTest.php', '15.9', 0),
('3b0adc6d486e9b06f1a8725f9f97d5f1', './lib/test/core/Multilingual/Aligner/UpdatePagesTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Multilingual/Aligner/index.php', '15.9', 0),
('3679e641f04199e1602c74a4595840e4', './lib/test/core/Multilingual/MachineTranslation/GoogleTranslateWrapperTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Multilingual/MachineTranslation/index.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/Multilingual/index.php', '15.9', 0),
('54567e11230dcee7a543398773f64b26', './lib/test/core/ObjectSelector/ObjectSelectorTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/core/ObjectSelector/index.php', '15.9', 0),
('d5ec49d32ca2f823596d75f62b694c43', './lib/test/core/Perms/AccessorTest.php', '15.9', 0),
('e113aa533a71c57e34118422b889431f', './lib/test/core/Perms/ApplierTest.php', '15.9', 0),
('1bae62da6029c922446120b0f41df008', './lib/test/core/Perms/BaseTest.php', '15.9', 0),
('520830365a13293303aef26d18c30716', './lib/test/core/Perms/BuilderTest.php', '15.9', 0),
('87cd67c9508d300817892dc2e10fb376', './lib/test/core/Perms/Check/AlternateTest.php', '15.9', 0),
('72dff7c96ba23504bf44f57ccb295e7e', './lib/test/core/Perms/Check/CreatorTest.php', '15.9', 0),
('e47cff88fa210dcfd679059a9328e334', './lib/test/core/Perms/Check/DirectTest.php', '15.9', 0),
('a2a0f414ac85fa242ee3b73d3955d3a6', './lib/test/core/Perms/Check/IndirectTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Perms/Check/index.php', '15.9', 0),
('ecf9a6d88278ce725beda4704a408fca', './lib/test/core/Perms/CheckSequenceTest.php', '15.9', 0),
('872f6962632365c24dfb9836f756d7b0', './lib/test/core/Perms/MixedTest.php', '15.9', 0),
('451be7cd4c06f52b4e219ecc874be63e', './lib/test/core/Perms/Reflection/FactoryTest.php', '15.9', 0),
('9b8911477b8d9dfa05c7514e05eb1354', './lib/test/core/Perms/Reflection/PermissionComparatorTest.php', '15.9', 0),
('40eb8af2c3ab7d32b6f161bd7191cbc8', './lib/test/core/Perms/Reflection/PermissionSetTest.php', '15.9', 0),
('eb128953eaf23b289fb4366511e0a787', './lib/test/core/Perms/Reflection/QuickTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Perms/Reflection/index.php', '15.9', 0),
('8eb81ed984b751d2008f642a3175ec70', './lib/test/core/Perms/Resolver/DefaultTest.php', '15.9', 0),
('d93f95d51c2e24d7022cc71ee34e7fcc', './lib/test/core/Perms/Resolver/StaticTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Perms/Resolver/index.php', '15.9', 0),
('64b36a3597f1f6e1fec7b2e86f1d132e', './lib/test/core/Perms/ResolverFactory/CategoryFactoryTest.php', '15.9', 0),
('0400db7bd765ddec957ad04fccc1d7c9', './lib/test/core/Perms/ResolverFactory/GlobalFactoryTest.php', '15.9', 0),
('516721d32e1c085ee350ba8eb532f678', './lib/test/core/Perms/ResolverFactory/ObjectFactoryTest.php', '15.9', 0),
('911d77b73a92f92b51c0eb2a861e8586', './lib/test/core/Perms/ResolverFactory/TestFactoryTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Perms/ResolverFactory/index.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/Perms/index.php', '15.9', 0),
('fda69dfe1180f4502ce736e2d1c683d9', './lib/test/core/Recommendation/BatchTest.php', '15.9', 0),
('4efe6997fcf0ccb9ee4c359b0b183f64', './lib/test/core/Recommendation/ComparatorTest.php', '15.9', 0),
('3574648daa0f2257e61022dac0c61d04', './lib/test/core/Recommendation/EngineSetTest.php', '15.9', 0),
('abfb82c210f8a39c42943643266b1db7', './lib/test/core/Recommendation/RecommendationSetTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/core/Recommendation/index.php', '15.9', 0),
('439aa238a54dbda221ff41202bf16d97', './lib/test/core/Reports/CacheTest.php', '15.9', 0),
('6fb5e709be489faebfdbfec3ccf685e0', './lib/test/core/Reports/FactoryTest.php', '15.9', 0),
('564cca31c41be8056552938777d8cd9a', './lib/test/core/Reports/ManagerTest.php', '15.9', 0),
('0c4e64e21aa450fae16f1b692cd49df8', './lib/test/core/Reports/ReportsEndToEndTest.php', '15.9', 0),
('3e671a69e426a2a96c40b2e4f530fe52', './lib/test/core/Reports/Send/EmailBuilderTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Reports/Send/index.php', '15.9', 0),
('18c343e8851a3d18685809dbfdcc0c83', './lib/test/core/Reports/SendTest.php', '15.9', 0),
('a6fc7276245e60ebb541dd2ccb7c33f9', './lib/test/core/Reports/UsersTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Reports/fixtures/index.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/Reports/index.php', '15.9', 0),
('c2d972473ec37379a6ffd8014344940c', './lib/test/core/Request/RequestTest.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/Request/index.php', '15.9', 0),
('b8967b3ac51c4baf0e8c5884ebc078df', './lib/test/core/Search/ActionStepTest.php', '15.9', 0),
('655dc7cedb21607487ca4b59fc6e2a72', './lib/test/core/Search/Elastic/BaseTest.php', '15.9', 0),
('4b75494f877111926cdd5a08a2875c66', './lib/test/core/Search/Elastic/BulkIncrementalUpdateTest.php', '15.9', 0),
('1aaee8dff1d2ea7d59421e1ec08a5255', './lib/test/core/Search/Elastic/BulkIndexingTest.php', '15.9', 0),
('8acc0c8334c16a323e6d90ad4583262b', './lib/test/core/Search/Elastic/CamelCaseTest.php', '15.9', 0),
('1745af868109b4761b1c25479d34e5da', './lib/test/core/Search/Elastic/FacetBuilderTest.php', '15.9', 0),
('495e17e3c580e69470737e9b3a263bef', './lib/test/core/Search/Elastic/FacetReaderTest.php', '15.9', 0),
('5b43a59de07895b80fd3d09afb93800f', './lib/test/core/Search/Elastic/FacetTest.php', '15.9', 0),
('492171150f67fde3318cd4a4e230a379', './lib/test/core/Search/Elastic/FederatedQueryTest.php', '15.9', 0),
('28460d29cdc833e3bb25ba920bbe99ca', './lib/test/core/Search/Elastic/IncrementalUpdateTest.php', '15.9', 0),
('5e6c62d7ce6b80926d69e8b79c251f35', './lib/test/core/Search/Elastic/MoreLikeThisTest.php', '15.9', 0),
('f57c8ee73123d9a21e8c68d206c9a05f', './lib/test/core/Search/Elastic/NumericTest.php', '15.9', 0),
('70811e165af3ee81fb3e600b91eab3bf', './lib/test/core/Search/Elastic/PaginationTest.php', '15.9', 0),
('bdc7da26f0ef1dd7ebb5c388d5539764', './lib/test/core/Search/Elastic/ProtocolTest.php', '15.9', 0),
('48ff0535ebfc7836cf311aae9a925885', './lib/test/core/Search/Elastic/QueryBuilderTest.php', '15.9', 0),
('950178fd8dfec7037a502dec21a86197', './lib/test/core/Search/Elastic/QueryRepositoryTest.php', '15.9', 0),
('ed2637910931b172cb9f03532ebe5ebd', './lib/test/core/Search/Elastic/RescoreQueryBuilderTest.php', '15.9', 0),
('26a8fe414129d21aaddc7f6a1aced72a', './lib/test/core/Search/Elastic/SortTest.php', '15.9', 0),
('8c53645ceb5db2b8800df66d9f4168dd', './lib/test/core/Search/Elastic/StemmingTest.php', '15.9', 0),
('b06eca2c84e3de675fa9b7c1c3d04eba', './lib/test/core/Search/Elastic/TypeAnalyzerTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/core/Search/Elastic/index.php', '15.9', 0),
('0d5a5f07ccc442574e90985482286b88', './lib/test/core/Search/Expr/ParserTest.php', '15.9', 0),
('2fb70f310159b32770da706947a8a972', './lib/test/core/Search/Expr/TokenizerTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Search/Expr/index.php', '15.9', 0),
('bcc8eb4e2d42cfb242f57cbd95832192', './lib/test/core/Search/Formatter/ArrayBuilderTest.php', '15.9', 0),
('2c5f251c3a68b4f1b545726f771668a4', './lib/test/core/Search/Formatter/DataSourceTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Search/Formatter/index.php', '15.9', 0),
('69b2f99d0a168e303773a9ed9f8e11b4', './lib/test/core/Search/FormatterTest.php', '15.9', 0),
('10a1ceaf5b49b859e6280ed9c9ccce23', './lib/test/core/Search/GlobalSource/PermissionSourceTest.php', '15.9', 0),
('fdb8f6f39f9282ba5056e02b6ed5153c', './lib/test/core/Search/GlobalSource/TitleInitialTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Search/GlobalSource/index.php', '15.9', 0),
('cd472ac3a0899a5ea8ddc6feb0a8110c', './lib/test/core/Search/Index/BaseTest.php', '15.9', 0),
('cf7648dcce8ba14788d9ffcdf94278ef', './lib/test/core/Search/Index/IncrementalUpdateTest.php', '15.9', 0),
('d1434f3f383382f205b07520eddd873c', './lib/test/core/Search/Index/NumericTest.php', '15.9', 0),
('104ee908440f941d81389db292cc8d67', './lib/test/core/Search/Index/PaginationTest.php', '15.9', 0),
('06106d53ae12d97603c807f0fe6d4ec9', './lib/test/core/Search/Index/SortTest.php', '15.9', 0),
('fb76613f5dd5cb20e124e719c380a484', './lib/test/core/Search/Index/StemmingTest.php', '15.9', 0),
('39cce76e6fe49134108119cba48753dd', './lib/test/core/Search/Index/TypeAnalyzerTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Search/Index/index.php', '15.9', 0),
('60300f2cf5d56a36628b897ad35e2a6c', './lib/test/core/Search/IndexerTest.php', '15.9', 0),
('95f8649719725a6a8df031eec38d06b2', './lib/test/core/Search/Lucene/BaseTest.php', '15.9', 0),
('7d141f9bfdef3f2855ce7b26861b285f', './lib/test/core/Search/Lucene/IncrementalUpdateTest.php', '15.9', 0),
('478f65bd44fc63221057db6b2059f69e', './lib/test/core/Search/Lucene/NumericTest.php', '15.9', 0),
('531111428bd077c36cb6ada7b68fddbb', './lib/test/core/Search/Lucene/PaginationTest.php', '15.9', 0),
('9d1a5822e82894b84af244e04117b954', './lib/test/core/Search/Lucene/SortTest.php', '15.9', 0),
('dbe87a3455a3dd9508b27dc2a6a64795', './lib/test/core/Search/Lucene/StemmingTest.php', '15.9', 0),
('9b42d46b0f1b81d5ef703dbf5dbb6207', './lib/test/core/Search/Lucene/TypeAnalyzerTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/core/Search/Lucene/index.php', '15.9', 0),
('6a9b7c490a062b366e56d3f457d167e2', './lib/test/core/Search/MySql/BaseTest.php', '15.9', 0),
('d319292e549a3f0043d328a440cce554', './lib/test/core/Search/MySql/IncrementalUpdateTest.php', '15.9', 0),
('cd248884d04c8e42369b9deac2d125b8', './lib/test/core/Search/MySql/LargeDatasetTest.php', '15.9', 0),
('79d168fe21ba85f782ef7abd315c0655', './lib/test/core/Search/MySql/PaginationTest.php', '15.9', 0),
('c5c349f7b50a71e0af0736523e2dec43', './lib/test/core/Search/MySql/QueryBuilderTest.php', '15.9', 0),
('4506e24fc5f1490b1850ccb055d84327', './lib/test/core/Search/MySql/SortTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/core/Search/MySql/index.php', '15.9', 0),
('9f2c93129eee8eadf7a645195baea00d', './lib/test/core/Search/Query/OrderTest.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/Search/Query/index.php', '15.9', 0),
('a1d0c8d6040c3dd905f6a6a1c2c72a28', './lib/test/core/Search/QueryTest.php', '15.9', 0),
('9c4bb44de736b728826beb787f7bc61b', './lib/test/core/Search/TypeAnalyzerTest.php', '15.9', 0),
('c941c510b12c53588a965d7aac36b776', './lib/test/core/Search/basic.tpl', '15.9', 0),
('d3d08628083ff518b77e144ddb387125', './lib/test/core/Search/embedded.tpl', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/Search/index.php', '15.9', 0),
('4643e2b5bd7b21488701169bbc7f5b64', './lib/test/core/Search/paginate.tpl', '15.9', 0),
('858162c48caf3ff940f2256275572d42', './lib/test/core/Services/ResultLoaderTest.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/Services/index.php', '15.9', 0),
('70834f7c06db07b40283681032f3c50f', './lib/test/core/TikiDb/TableTest.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/TikiDb/index.php', '15.9', 0),
('79c6c1b95d986eeeea1fe72b86a30ac1', './lib/test/core/TikiFilter/CallbackTest.php', '15.9', 0),
('eadd199c38bc3751d62107a0e1fea184', './lib/test/core/TikiFilter/MapTest.php', '15.9', 0),
('e00a79a1e3854259e11cb9cd9f75f39d', './lib/test/core/TikiFilter/PrepareInputTest.php', '15.9', 0),
('def67943553c7553f2fb80ac09358546', './lib/test/core/TikiFilter/WordTest.php', '15.9', 0),
('b3c7ceee8de88442128f53a06f6e163a', './lib/test/core/TikiFilter/XssTest.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/TikiFilter/index.php', '15.9', 0),
('90828a497343da56214d6a8d42d1fe74', './lib/test/core/TikiSecurityTest.php', '15.9', 0),
('dde651b846216f589ca94d6f0d60e522', './lib/test/core/Tracker/OptionsTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/core/Tracker/index.php', '15.9', 0),
('8efc7d684b455e3507839bfb01357c8e', './lib/test/core/Transition/AtLeastTest.php', '15.9', 0),
('601690e7dac3f3f5108137269f62e354', './lib/test/core/Transition/AtMostTest.php', '15.9', 0),
('5d6a26c87f76bd4f701b1660dbd7c6e0', './lib/test/core/Transition/BasicTest.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/Transition/index.php', '15.9', 0),
('1a3429626b43b3125bb6f39e8bd101d4', './lib/test/core/Wiki/SlugManagerTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/core/Wiki/index.php', '15.9', 0),
('f96a856047dfae09f6f45fabb35e0d2e', './lib/test/core/WikiParser/OutputLinkTest.php', '15.9', 0),
('2ef482412f24666c21f8111855c28779', './lib/test/core/WikiParser/PluginArgumentParserTest.php', '15.9', 0),
('9f26c2a01bed7cb7eaf71fb1dcb10b3a', './lib/test/core/WikiParser/PluginMatcherTest.php', '15.9', 0),
('a63d1d299c94e193ec9440c5805a87e0', './lib/test/core/WikiParser/PluginOutputTest.php', '15.9', 0),
('20dbeaf26e69eaf409b2f60592722ece', './lib/test/core/WikiParser/PluginParserTest.php', '15.9', 0),
('903ba5ddc1d436ed9f2d3447f65f7e9f', './lib/test/core/WikiParser/PluginRepositoryTest.php', '15.9', 0),
('2e7ded3b8a7164a01e16c5f5fe0d605d', './lib/test/core/WikiParser/StressTest.php', '15.9', 0),
('fcb915a2beb7c4c4f1503bbdd39a15db', './lib/test/core/WikiParser/index.php', '15.9', 0),
('8ecf72ea9487e6b9ef293a7d8bcc3097', './lib/test/core/WikiParser/wikiplugin_foo.php', '15.9', 0),
('f00382ecb50df8c84fbb77dad8f7fc77', './lib/test/core/Workspace/AnalyserTest.php', '15.9', 0),
('79990cc96d1293bc586832ebaae9a827', './lib/test/core/Workspace/BuilderTest.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/test/core/Workspace/index.php', '15.9', 0),
('6ffd5fc8b381dfc9225e2cc05f02f1a6', './lib/test/core/Yaml/DirectivesTest.php', '15.9', 0),
('993cd875a1a297b3950c2c518497adb8', './lib/test/core/bootstrap.php', '15.9', 0),
('4034abc24438d0262028d43df01c39ad', './lib/test/core/include_non_autoload_compatible_classes.php', '15.9', 0),
('fcb915a2beb7c4c4f1503bbdd39a15db', './lib/test/core/index.php', '15.9', 0),
('f759d8fb83a30d3aa064ca8483492230', './lib/test/core/temp/cache/index.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/core/temp/index.php', '15.9', 0),
('81466c0a2d2e7a07728a5be52035b29f', './lib/test/editlib/EditLibTest.php', '15.9', 0),
('32e1053212041d10998334b5386db7c8', './lib/test/editlib/ParseToWiki_CharacterTest.php', '15.9', 0),
('744871482d159ae572479b8d6b8e8917', './lib/test/editlib/ParseToWiki_LinkTest.php', '15.9', 0),
('1c758d58265dba649b4ecfd706b501e4', './lib/test/editlib/ParseToWiki_ListTest.php', '15.9', 0),
('3d9697068fb94b30632d152b2ee74c7d', './lib/test/editlib/ParseToWiki_TextTest.php', '15.9', 0),
('439b45f2cfb83ca6f95ae285544d4461', './lib/test/editlib/ParseToWysiwyg_CharacterTest.php', '15.9', 0),
('c9d18fd00bcca1aa6690da1fcfc06bd6', './lib/test/editlib/ParseToWysiwyg_LinkTest.php', '15.9', 0),
('bfe8ddfabbb163c71cbd6e4160867b8f', './lib/test/editlib/ParseToWysiwyg_ListTest.php', '15.9', 0),
('7eb86c6e075226015e575d4f10bccd4d', './lib/test/editlib/ParseToWysiwyg_TextTest.php', '15.9', 0),
('51972f80c1b7cd0e1f77f6734a5ec54d', './lib/test/editlib/index.php', '15.9', 0),
('6964cd4041d8951623e1b5a4bb06a887', './lib/test/filegals/FilegalsTest.php', '15.9', 0),
('5c4299c3e84efac852934f747708e8d2', './lib/test/freetag/FreetagTest.php', '15.9', 0),
('51972f80c1b7cd0e1f77f6734a5ec54d', './lib/test/freetag/index.php', '15.9', 0),
('7f83ed0b9ddf170f7a664d2754e496fd', './lib/test/importer/TikiImporterBlogTest.php', '15.9', 0),
('ae732269428af6c11212921d2c73737a', './lib/test/importer/TikiImporterBlogWordpressTest.php', '15.9', 0),
('986e01db34d3334cdab63cd091da6256', './lib/test/importer/TikiImporterTest.php', '15.9', 0),
('bfc9ac65cb81b05ccdf9bc777a7072c1', './lib/test/importer/TikiImporterWikiMediawikiTest.php', '15.9', 0),
('2f5a0fa9dbce039f280db9ddf6409530', './lib/test/importer/TikiImporterWikiTest.php', '15.9', 0),
('cd8975731260739d0ad343509bffe88d', './lib/test/importer/fixtures/index.php', '15.9', 0),
('3f8d9636e6961ad08be834502db9835b', './lib/test/importer/fixtures/mediawiki_page_as_array.php', '15.9', 0),
('c4b0f388851bd15644372dea39786a5c', './lib/test/importer/index.php', '15.9', 0),
('93969915f6e023b61c8e7e66e43bb36c', './lib/test/importer/tikiimporter_testcase.php', '15.9', 0),
('51972f80c1b7cd0e1f77f6734a5ec54d', './lib/test/index.php', '15.9', 0),
('90f4f3a1f8acce6cf170c217a0446b7b', './lib/test/language/CollectFilesTest.php', '15.9', 0),
('a232fea890fcd71d0884cb4d3516dcaf', './lib/test/language/FileType/PhpTest.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/language/FileType/index.php', '15.9', 0),
('417c9bad00086f70dfb1f86d9ac2c7c0', './lib/test/language/GetStringsEndToEndTest.php', '15.9', 0),
('f0ab5dc4fcd70d7cf7e11c7d6e4a8f9b', './lib/test/language/GetStringsTest.php', '15.9', 0),
('4dcd115ec9a93e0c5d8192e8f0c16d9b', './lib/test/language/LanguageTest.php', '15.9', 0),
('0170948628efc2648828933c8dfc4042', './lib/test/language/LanguageTranslationsTest.php', '15.9', 0),
('3eb773c515cfe974c4451f913b4fa464', './lib/test/language/MergeFilesTest.php', '15.9', 0),
('ec580787ab419e82f6d9047dea751fa0', './lib/test/language/ParseFileTest.php', '15.9', 0),
('f6ef6ab58cb50f37998327bb482ae50e', './lib/test/language/WriteFile/FactoryTest.php', '15.9', 0),
('c61ec583d3ce8ca9230dbc0e22217d08', './lib/test/language/WriteFile/index.php', '15.9', 0),
('b617daa591feea81a66a83dd9204adee', './lib/test/language/WriteFileTest.php', '15.9', 0),
('3da0c605b3b4b5fa91c41412072a7a1c', './lib/test/language/fixtures/custom.php', '15.9', 0),
('51972f80c1b7cd0e1f77f6734a5ec54d', './lib/test/language/fixtures/index.php', '15.9', 0),
('24e04040b5acde3b58348eb9632c5a72', './lib/test/language/fixtures/language_end_to_end_test_modified.php', '15.9', 0),
('a24cf5e0c8b549684d4497ed270a8f1b', './lib/test/language/fixtures/language_end_to_end_test_original.php', '15.9', 0),
('3a06659ae53a502aee2499e5471eed16', './lib/test/language/fixtures/language_escape_special_characters.php', '15.9', 0),
('0fecf9f4631a29e858601213b84bc138', './lib/test/language/fixtures/language_fa_modified.php', '15.9', 0),
('92317f87f09ea73b53d394ab6e5f9008', './lib/test/language/fixtures/language_fa_original.php', '15.9', 0),
('57b8761733b8b33ea997c14a18693ec2', './lib/test/language/fixtures/language_invalid.php', '15.9', 0),
('7339a1b4dd799fb24138d53fb2b2f9f3', './lib/test/language/fixtures/language_merge_files_original.php', '15.9', 0),
('651ddb1b776a46b90f0f5478a4d91bfc', './lib/test/language/fixtures/language_merge_files_result.php', '15.9', 0),
('a3df170b156cfb4d6ade314bb642ad63', './lib/test/language/fixtures/language_modif.php', '15.9', 0),
('7ac64e0f9edc7118f3c1e4c22ce56ee1', './lib/test/language/fixtures/language_orig.php', '15.9', 0),
('2410c0080d813ba1db09f1626fa01165', './lib/test/language/fixtures/language_punctuations.php', '15.9', 0),
('c1553d09e986331d720e78fd6d8a391f', './lib/test/language/fixtures/language_ru_modified.php', '15.9', 0),
('a901ce9eb779dc53a7e89d6783dc3190', './lib/test/language/fixtures/language_ru_original.php', '15.9', 0),
('ae12b74389f0674a07695127449f71de', './lib/test/language/fixtures/language_simple.php', '15.9', 0),
('5af7b8ae9550b04c96ba3d5e7bbb6bd8', './lib/test/language/fixtures/language_to_parse_file.php', '15.9', 0),
('c7b4d94bad9608fbfc9070c5a3fc8cf7', './lib/test/language/fixtures/language_untranslated.php', '15.9', 0),
('bf8f117c3d7aaa52b33313f10d713116', './lib/test/language/fixtures/language_with_translations.php', '15.9', 0),
('435dcafd20fc85749a7241a2f6956a61', './lib/test/language/fixtures/language_with_translations_and_file_paths.php', '15.9', 0),
('71713743cd942d7097eb2380518d732a', './lib/test/language/fixtures/language_writestringstofile_first_call.php', '15.9', 0),
('f08c31284f134b68e67705c1ce296cce', './lib/test/language/fixtures/language_writestringstofile_second_call.php', '15.9', 0),
('f16355bf96fa6f6c8241cd71428490c9', './lib/test/language/fixtures/test_collecting_strings.php', '15.9', 0),
('8a8cd91d224a0e6b0d42a30369e9f40f', './lib/test/language/fixtures/test_collecting_strings.tpl', '15.9', 0),
('2358322c0ba9bedf2847fc018a1a6c7a', './lib/test/language/index.php', '15.9', 0),
('9aac5ea1dc4ef731e03f220bc2622704', './lib/test/payment/CartTest.php', '15.9', 0),
('2b633fe15e6f1508751146f1b0d249e4', './lib/test/payment/index.php', '15.9', 0),
('ba8b5b8f96353a74d023fc1cd70308e2', './lib/test/phpunit.php', '15.9', 0),
('c1e84920bcbc4f30a82db094e12c98a6', './lib/test/phpunit_with_baseline.php', '15.9', 0),
('9449a78700e0c20497bb8077849f7f69', './lib/test/rating/AggregationTest.php', '15.9', 0),
('2929f2c59cb37109a0663a1a6dd95c8a', './lib/test/rating/RegisterVoteTest.php', '15.9', 0),
('2b633fe15e6f1508751146f1b0d249e4', './lib/test/rating/index.php', '15.9', 0),
('6991ef799aa04f55df1b9fe991f8bfe1', './lib/test/shipping/ShippingTest.php', '15.9', 0),
('2b633fe15e6f1508751146f1b0d249e4', './lib/test/shipping/index.php', '15.9', 0),
('34738e146f4ea5d9f4984dc070b3047f', './lib/test/smarty_tiki/ModifierDurationTest.php', '15.9', 0),
('2358322c0ba9bedf2847fc018a1a6c7a', './lib/test/smarty_tiki/index.php', '15.9', 0),
('0c12d785cedcc8126ca11e01104c8e60', './lib/test/wiki-plugins/CodeTest.php', '15.9', 0),
('b152808b8ed2929a1b2b2cb19214f155', './lib/test/wiki-plugins/TranslationOfTest.php', '15.9', 0),
('eebd1efdb9432b766562300d87e28da8', './lib/test/wiki-plugins/YoutubeTest.php', '15.9', 0),
('2b633fe15e6f1508751146f1b0d249e4', './lib/test/wiki-plugins/index.php', '15.9', 0),
('40f67f7d8ace0b8a270aba3fe8fa1672', './lib/theme/iconsetlib.php', '15.9', 0),
('e6c357c40a698a87c6eeb47a91d43516', './lib/theme/index.php', '15.9', 0),
('c2c4df0ebbc0da760ca1bf9200af63e4', './lib/theme/themecontrollib.php', '15.9', 0),
('f07695a71aa307ab669aab6a33754187', './lib/theme/themelib.php', '15.9', 0),
('9a6bb11bafae72a0b3086f055912beb0', './lib/tiki-dynamic-js.php', '15.9', 0),
('e54e076a29b636a60e639d233446b59b', './lib/tiki-js.js', '15.9', 0),
('7c1b5aced86baea74bf71dfe9b173e74', './lib/tikiaccesslib.php', '15.9', 0),
('d0bbf343e6b2595bea79c68534875707', './lib/tikidate.php', '15.9', 0),
('84075a1d6369fd134c2fb3c28207bb32', './lib/tikihelp/css/index.php', '15.9', 0),
('af025548322a0f5d058fec14351d62aa', './lib/tikihelp/css/menu.css', '15.9', 0),
('aa2ff0c00b57e7ece68ac9de6f21bbb4', './lib/tikihelp/css/toolbar.css', '15.9', 0),
('84075a1d6369fd134c2fb3c28207bb32', './lib/tikihelp/icons/index.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/tikihelp/index.php', '15.9', 0),
('96ed9bd0969f3f89e2c76be975f7c6ab', './lib/tikihelp/js/global.js', '15.9', 0),
('a847a1df13971d9bde8214a27dcf578b', './lib/tikihelp/js/highlight.js', '15.9', 0),
('84075a1d6369fd134c2fb3c28207bb32', './lib/tikihelp/js/index.php', '15.9', 0),
('286cd63e0a5b497d54d275bba06c698a', './lib/tikihelp/js/toolbar.js', '15.9', 0),
('e4ec01cf2271bc54a8c14fc86bd04fb3', './lib/tikihelp/menu/ftiens4.js', '15.9', 0),
('84075a1d6369fd134c2fb3c28207bb32', './lib/tikihelp/menu/index.php', '15.9', 0),
('3a58a2fe95f389c6b620dbf8357bb3f5', './lib/tikihelp/menu/menuNodes.js', '15.9', 0),
('11eb5f2d2ffdbc019cc4e7ec0e818e18', './lib/tikihelp/menu/ua.js', '15.9', 0),
('102ae43a17d9e4cf53732a22e22e4196', './lib/tikihelplib.php', '15.9', 0),
('d24d2b7f11becc00ec5b1e52da7dd2b3', './lib/tikilib.php', '15.9', 0),
('9130c8d9b9d37f08b18f2176a3525b36', './lib/tikisession-adodb.php', '15.9', 0),
('7d83beca5b320f69e2740a9a27a6606d', './lib/tikisession-memcache.php', '15.9', 0),
('9954054fa59eeefd8a51810886149490', './lib/tikisession-pdo.php', '15.9', 0),
('b3fd4a5a955cb028f1a9a65a39389511', './lib/tikiticketlib.php', '15.9', 0),
('a25a43ca16459749c339ac8c956c7f80', './lib/todolib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/toolbars/index.php', '15.9', 0),
('e1a9a3dddf9e574ba0c99708947a35cc', './lib/toolbars/tiki-admin_toolbars.js', '15.9', 0),
('0d4fc660a436eed0d984f1265aeea111', './lib/toolbars/toolbarslib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/trackers/index.php', '15.9', 0),
('aeae24e441c0403b280c9282a075b8cf', './lib/trackers/trackerlib.php', '15.9', 0),
('c35978c0b270d835136e449780ac74bd', './lib/transitionlib.php', '15.9', 0),
('c629fcbbab8da82529d426edb7904685', './lib/tree/BrowseTreeMaker.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/tree/index.php', '15.9', 0),
('991579a89c86e149531fb6b186dfa864', './lib/tree/tree.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/user/index.php', '15.9', 0),
('71a21a2c61ecffc211a2f327ad33a7d5', './lib/user/monitorlib.php', '15.9', 0),
('35aed5a913f0131d6b9226d0d3726c02', './lib/user/monitormaillib.php', '15.9', 0),
('c42a66ff967fe3a2cc230897b9dc62d9', './lib/user/sociallib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/userfiles/index.php', '15.9', 0),
('8377e039cd40527650b93bd04e3a0c75', './lib/userfiles/userfileslib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/usermenu/index.php', '15.9', 0),
('91ef7a3dec6d084fccc135240945fc0c', './lib/usermenu/usermenulib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/usermodules/index.php', '15.9', 0),
('b180f31a1f3e0ed3b3675319542f72de', './lib/usermodules/usermoduleslib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/userprefs/index.php', '15.9', 0),
('ea43acc2e4bd2a306995b38667a9b867', './lib/userprefs/userprefslib.php', '15.9', 0),
('818b96e4e8c90189dc16e57fb2a7dbcd', './lib/userslib.php', '15.9', 0),
('03f1b268892f6c8f76061bde0cd4770c', './lib/validators/index.php', '15.9', 0),
('9f3ac25cdf1690984250bea8975c9677', './lib/validators/validator_captcha.php', '15.9', 0),
('5aa460c1a28ee9794485cad960940fd4', './lib/validators/validator_distinct.php', '15.9', 0),
('9b700cac2d90db03815ab9f47f24a15c', './lib/validators/validator_pagename.php', '15.9', 0),
('7cc5d849c016984899b18c68f59f3a01', './lib/validators/validator_passcode.php', '15.9', 0),
('3d04f3a32fa6a39dcb821c7d7f19dfee', './lib/validators/validator_password.php', '15.9', 0),
('950fedbbfb93068fd433513526cc689c', './lib/validators/validator_regex.php', '15.9', 0),
('50f17612b3e1e151eb4cc47379a44bd2', './lib/validators/validator_tiki.js', '15.9', 0),
('9237701afb4c5f27d8e8fbdfbd78454e', './lib/validators/validator_uniqueemail.php', '15.9', 0),
('680b436ae016d48202f9e6e3377c4287', './lib/validators/validator_username.php', '15.9', 0),
('e010dbcda68082668e81e284ea0360d9', './lib/validatorslib.php', '15.9', 0),
('03f1b268892f6c8f76061bde0cd4770c', './lib/videogals/index.php', '15.9', 0),
('a770e31217bac0d85f114c48c51c12d3', './lib/videogals/kalturalib.php', '15.9', 0),
('954d30b3d5fb066aa1b50b98a8a72926', './lib/webmail/contactlib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/webmail/index.php', '15.9', 0),
('52ab44847dbe72ca09afb903faec4ae5', './lib/webmail/mimeDecode.php', '15.9', 0),
('d9a64e0f0817d8a11dbcdcacd16fdc8b', './lib/webmail/net_pop3.php', '15.9', 0),
('87185373fb38fa1bbce3deaa8abecc2e', './lib/webmail/tikimaillib.php', '15.9', 0),
('507b110c878c674c4a35589c6fa10e5c', './lib/webmail/webmaillib.php', '15.9', 0),
('d8a1744dff7de5be3efaa90cbd54630e', './lib/webservicelib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/wiki-plugins/index.php', '15.9', 0),
('48cba86c0e15ed22a31bb150b117bc5b', './lib/wiki-plugins/wikiplugin_activitystream.php', '15.9', 0),
('cfcbdea191249e5e1deec363e3f03283', './lib/wiki-plugins/wikiplugin_addfreetag.php', '15.9', 0),
('d38b33cabce65a7dc4ee58e66385d4bb', './lib/wiki-plugins/wikiplugin_addon.php', '15.9', 0),
('bf2c86beee9f8ecae373f1fca4649dd3', './lib/wiki-plugins/wikiplugin_addreference.php', '15.9', 0),
('6c635f616713f80558ab533435633e10', './lib/wiki-plugins/wikiplugin_addrelation.php', '15.9', 0),
('6e825badddd6dcba3d47481876b3cd8b', './lib/wiki-plugins/wikiplugin_addtocart.php', '15.9', 0),
('92e1a0038aa726583c9e923472460075', './lib/wiki-plugins/wikiplugin_addtogooglecal.php', '15.9', 0),
('ab6be9ccd6ca23426242b6b30a211c6b', './lib/wiki-plugins/wikiplugin_adjustinventory.php', '15.9', 0),
('b358c424201992e49b11b530ba61caab', './lib/wiki-plugins/wikiplugin_agentinfo.php', '15.9', 0),
('90677532cfa8bdfeb254451e937631c6', './lib/wiki-plugins/wikiplugin_ajaxload.php', '15.9', 0),
('84fde195d0f708c487f9928d19fd6b86', './lib/wiki-plugins/wikiplugin_alink.php', '15.9', 0),
('11749387d8a89f7dbb5cfcb933c95b86', './lib/wiki-plugins/wikiplugin_aname.php', '15.9', 0),
('d3b8e779efc68ef647088d4c421616f7', './lib/wiki-plugins/wikiplugin_annotation.php', '15.9', 0),
('f79a49de604da5693ba935e21fa220fe', './lib/wiki-plugins/wikiplugin_appframe.php', '15.9', 0),
('3ee184a91a2ce95eac5ac978246e1d83', './lib/wiki-plugins/wikiplugin_archivebuilder.php', '15.9', 0),
('3d0e365209680a166d80d957575ace6b', './lib/wiki-plugins/wikiplugin_article.php', '15.9', 0),
('55833c32d68f59ac71045069904aacc7', './lib/wiki-plugins/wikiplugin_articles.php', '15.9', 0),
('56a225c92c3d491d43f60e07cec6ed83', './lib/wiki-plugins/wikiplugin_attach.php', '15.9', 0),
('1d2f55cb9636dd010b1601fa5d4bf018', './lib/wiki-plugins/wikiplugin_attributes.php', '15.9', 0),
('fafc26908fb5f87587bb19b1e0654b01', './lib/wiki-plugins/wikiplugin_author.php', '15.9', 0),
('38e3fa5e6c35f36af3da72602315c22d', './lib/wiki-plugins/wikiplugin_autoqueryargs.php', '15.9', 0),
('6b807eb00c4efe639b51f2ab02fc2a6f', './lib/wiki-plugins/wikiplugin_avatar.php', '15.9', 0),
('2faa0061fc5d4d7ba83a038476d34368', './lib/wiki-plugins/wikiplugin_back.php', '15.9', 0),
('d6cb96e651f82f895156067a49eef3e3', './lib/wiki-plugins/wikiplugin_backlinks.php', '15.9', 0),
('a694d01cf6c202a70d906b1432ffe596', './lib/wiki-plugins/wikiplugin_banner.php', '15.9', 0),
('a7bb748efc57b54d7138cf66b4c3c56d', './lib/wiki-plugins/wikiplugin_bigbluebutton.php', '15.9', 0),
('c1999a1c8e3c214351c0af5499d22f77', './lib/wiki-plugins/wikiplugin_bloglist.php', '15.9', 0),
('e8d53e3c76a1edde27a5dbb8efb3d9ce', './lib/wiki-plugins/wikiplugin_box.php', '15.9', 0),
('c147935cb347c66457d123b4ecee493d', './lib/wiki-plugins/wikiplugin_button.php', '15.9', 0),
('b45e39c2f5131d67fcb76cc035778512', './lib/wiki-plugins/wikiplugin_calendar.php', '15.9', 0),
('f9f49df65b89e9e9fabef0d32bcdde0c', './lib/wiki-plugins/wikiplugin_carousel.php', '15.9', 0),
('6caf83ceb940f3f2e2273540b3b3bcc6', './lib/wiki-plugins/wikiplugin_cartmissinguserinfo.php', '15.9', 0),
('f81caaf342bbe7ad4736cde00e6ce049', './lib/wiki-plugins/wikiplugin_category.php', '15.9', 0),
('e3efa8340a8baac6654e98dd6b0ca627', './lib/wiki-plugins/wikiplugin_categorytransition.php', '15.9', 0),
('d39b0022a1856da82f1b77d4bcc60399', './lib/wiki-plugins/wikiplugin_catorphans.php', '15.9', 0),
('3e054aa76a8a06e7a3370ede943f9a67', './lib/wiki-plugins/wikiplugin_catpath.php', '15.9', 0),
('4f319a11c6660f117d92eeac07935dfe', './lib/wiki-plugins/wikiplugin_cclite.php', '15.9', 0),
('d56039a09ec27d9eae2261dec51814bd', './lib/wiki-plugins/wikiplugin_center.php', '15.9', 0),
('a46b941a6a51d36d7583f707f06bf1b9', './lib/wiki-plugins/wikiplugin_chart.php', '15.9', 0),
('2150014e5c2894ebf0533f89230c6d72', './lib/wiki-plugins/wikiplugin_checkreferer.php', '15.9', 0),
('4489a72f7eaba8232aaa2c966b43666f', './lib/wiki-plugins/wikiplugin_code.php', '15.9', 0),
('5fe08b1e90285923228de828f334876f', './lib/wiki-plugins/wikiplugin_colorbox.php', '15.9', 0),
('6f849feec49f76b5b09d3ce476e9d3cd', './lib/wiki-plugins/wikiplugin_comment.php', '15.9', 0),
('0aff3cdfae1721b12745c09287c31998', './lib/wiki-plugins/wikiplugin_content.php', '15.9', 0),
('80536e5fac8a3bb3fee57ff18444f7f5', './lib/wiki-plugins/wikiplugin_contributionsdashboard.php', '15.9', 0),
('1b248dff565f0bb5e28173b79acf4865', './lib/wiki-plugins/wikiplugin_convene.php', '15.9', 0),
('19c9e231eff6769d1f7a3249b7069a84', './lib/wiki-plugins/wikiplugin_cookie.php', '15.9', 0),
('57ed8c09f7d18e4e8ae79cd57871df21', './lib/wiki-plugins/wikiplugin_cookieconsent.php', '15.9', 0),
('56cbbe3816fffbd09bf3edab5f7bdbc1', './lib/wiki-plugins/wikiplugin_copyright.php', '15.9', 0),
('a4e97e0ba45fd03bbbe3b47c6f567534', './lib/wiki-plugins/wikiplugin_countdown.php', '15.9', 0),
('4c06acd37512f8c5d963bced769f256d', './lib/wiki-plugins/wikiplugin_customsearch.php', '15.9', 0),
('8c39205cea67447534ed6757f7d2f45f', './lib/wiki-plugins/wikiplugin_datachannel.php', '15.9', 0),
('d0453aa715a9e9634ec06ac23591edd8', './lib/wiki-plugins/wikiplugin_dbreport.php', '15.9', 0),
('0969d8422930234394fe3ec0848119b8', './lib/wiki-plugins/wikiplugin_dialog.php', '15.9', 0),
('d11e21b4bfb32f84cdb723dc9bbd87d7', './lib/wiki-plugins/wikiplugin_div.php', '15.9', 0),
('5999198ada5c8458c7619526ee9cd4bf', './lib/wiki-plugins/wikiplugin_dl.php', '15.9', 0),
('8608fff5e1bd203cf42151589e54757c', './lib/wiki-plugins/wikiplugin_draw.php', '15.9', 0),
('1a1bfa8bed31288d2e32120369e07013', './lib/wiki-plugins/wikiplugin_dynamicvariables.php', '15.9', 0),
('dfb6196c72c830b36b40498a6436b402', './lib/wiki-plugins/wikiplugin_equation.php', '15.9', 0),
('cfcffc84edb564ac8e8f7ae524e72d94', './lib/wiki-plugins/wikiplugin_events.php', '15.9', 0),
('4e35e473541392b74bb41946571b948f', './lib/wiki-plugins/wikiplugin_exercise.php', '15.9', 0),
('b6c0a0cad1c5feb6fc1f2a90c91ddfaf', './lib/wiki-plugins/wikiplugin_extendcarthold.php', '15.9', 0),
('7ef46c8f2fee21cddfa7102b5e06d98f', './lib/wiki-plugins/wikiplugin_fade.php', '15.9', 0),
('f5454add730644de184da64685a88669', './lib/wiki-plugins/wikiplugin_fancylist.php', '15.9', 0),
('cb2f85772f59853f590c58b56d5d5399', './lib/wiki-plugins/wikiplugin_fancytable.php', '15.9', 0),
('e82a1354c8fe748d7893d70a161d3578', './lib/wiki-plugins/wikiplugin_favorite.php', '15.9', 0),
('bd31a6c53d3b3d908cf1b05127bf6aed', './lib/wiki-plugins/wikiplugin_file.php', '15.9', 0),
('4dbaecf33c5c849cb92cac95b6d7a8e2', './lib/wiki-plugins/wikiplugin_files.php', '15.9', 0),
('1eb83143ab0bebc9cd8af172b2c1096b', './lib/wiki-plugins/wikiplugin_fitnesse.php', '15.9', 0),
('1af3d11ef47a7729bd8af35528ec059a', './lib/wiki-plugins/wikiplugin_flash.php', '15.9', 0),
('767f1c29f6496ab352e411eed545bde6', './lib/wiki-plugins/wikiplugin_font.php', '15.9', 0),
('06beea2705618ca7abdd07033eb2c430', './lib/wiki-plugins/wikiplugin_footnote.php', '15.9', 0),
('61743f07759d95ba21a7c37d7b757430', './lib/wiki-plugins/wikiplugin_footnotearea.php', '15.9', 0),
('a69f48f8076bbee2ad208bc29c93eba0', './lib/wiki-plugins/wikiplugin_freetagged.php', '15.9', 0),
('8e531c4207df0f699796ca676079bfb8', './lib/wiki-plugins/wikiplugin_friend.php', '15.9', 0),
('d36507d38175d1dfac10e07c0eef327f', './lib/wiki-plugins/wikiplugin_ftp.php', '15.9', 0),
('d607914930f09033e3e8512d0572bc6a', './lib/wiki-plugins/wikiplugin_fullwidthtitle.php', '15.9', 0),
('66f6ff612e56d2bb3ceeb86b539b3c33', './lib/wiki-plugins/wikiplugin_galleriffic.php', '15.9', 0),
('4bdffbc7ce8ba4802e15554ad9cd72c2', './lib/wiki-plugins/wikiplugin_gauge.php', '15.9', 0),
('ea6ef2da9cb39af4d121aa4dc252daf9', './lib/wiki-plugins/wikiplugin_gdgraph.php', '15.9', 0),
('d892442285d95425b6de145462e952e5', './lib/wiki-plugins/wikiplugin_getaccesstoken.php', '15.9', 0),
('12b3c8919a64e375601048ce51937468', './lib/wiki-plugins/wikiplugin_googleanalytics.php', '15.9', 0),
('5462edad687f410fcee63e1dc883d634', './lib/wiki-plugins/wikiplugin_googlechart.php', '15.9', 0),
('fe1341c1abd5aa0e1d0212788b192af5', './lib/wiki-plugins/wikiplugin_googledoc.php', '15.9', 0),
('3f07d3c2c89a368ceef8e05c18929020', './lib/wiki-plugins/wikiplugin_group.php', '15.9', 0),
('b24881578fffb5a3702dabdda5f0e6b6', './lib/wiki-plugins/wikiplugin_groupexpiry.php', '15.9', 0),
('b2bb35b2ed964aec55ea3dc87f8ebc97', './lib/wiki-plugins/wikiplugin_grouplist.php', '15.9', 0),
('7b401487c3dcaf39424be786c3ebd859', './lib/wiki-plugins/wikiplugin_groupmailcore.php', '15.9', 0),
('d8b296119e6840489e8b21345a746627', './lib/wiki-plugins/wikiplugin_groupstat.php', '15.9', 0),
('c092640acc518f97046ea9e9f6ba3f6d', './lib/wiki-plugins/wikiplugin_hasbought.php', '15.9', 0),
('7ad5bce9e46bbe85a3264c774337b686', './lib/wiki-plugins/wikiplugin_html.php', '15.9', 0),
('d9d71f473977538c4c3a443a58a9133b', './lib/wiki-plugins/wikiplugin_htmlfeed.php', '15.9', 0),
('151e6db088d38f9fb642645d0c7f551c', './lib/wiki-plugins/wikiplugin_htmlfeedlink.php', '15.9', 0),
('6e4745857b4b8450308c8701a278ab17', './lib/wiki-plugins/wikiplugin_icon.php', '15.9', 0),
('073c0a7c064b2fc3c7d4e01ab936e429', './lib/wiki-plugins/wikiplugin_iframe.php', '15.9', 0),
('4909e574356c138e151ac9697b8e629a', './lib/wiki-plugins/wikiplugin_img.php', '15.9', 0),
('573eeb763acb1ceac466e0a65c3a0e94', './lib/wiki-plugins/wikiplugin_include.php', '15.9', 0),
('1004014394c509767ed7f7ca88c59faa', './lib/wiki-plugins/wikiplugin_includetpl.php', '15.9', 0),
('96ea38a5f49b6196608c81f953449378', './lib/wiki-plugins/wikiplugin_includeurl.php', '15.9', 0),
('8982cf4c55607b5a522a723b14485209', './lib/wiki-plugins/wikiplugin_insert.php', '15.9', 0),
('4706f56e49e4674761b18f084cc3c493', './lib/wiki-plugins/wikiplugin_invite.php', '15.9', 0),
('1e0c709038e51c9b733640ca940731b8', './lib/wiki-plugins/wikiplugin_jabber.php', '15.9', 0),
('e806c19f790b5795f3b688b4cc4931c6', './lib/wiki-plugins/wikiplugin_jq.php', '15.9', 0),
('e077beed0e3da027e1e7ea3f815335a5', './lib/wiki-plugins/wikiplugin_js.php', '15.9', 0),
('a9fe9624dbd2c74e8db413aee8a1ba5c', './lib/wiki-plugins/wikiplugin_kaltura.php', '15.9', 0),
('0e1d965b17f1e4e81e9cb7ec229517e4', './lib/wiki-plugins/wikiplugin_lang.php', '15.9', 0),
('7055e2020a73b298124d858dcb7219f1', './lib/wiki-plugins/wikiplugin_lastmod.php', '15.9', 0),
('9aeb43900824d3496f0820ff162ec2cd', './lib/wiki-plugins/wikiplugin_like.php', '15.9', 0),
('b55f6b946d428c4146c55547deb2cfeb', './lib/wiki-plugins/wikiplugin_list.php', '15.9', 0),
('702f1b3d46578f081c9b817c5f6bf4db', './lib/wiki-plugins/wikiplugin_listexecute.php', '15.9', 0),
('d93ce0550c80017b8a581907f764b517', './lib/wiki-plugins/wikiplugin_listpages.php', '15.9', 0),
('7690469360e6c9730ee711fb2959c6e7', './lib/wiki-plugins/wikiplugin_localfiles.php', '15.9', 0),
('f6959049adb17b4bc96ee17daa8a34d6', './lib/wiki-plugins/wikiplugin_lsdir.php', '15.9', 0),
('350ff807f43b806d16157f530904a421', './lib/wiki-plugins/wikiplugin_mail.php', '15.9', 0),
('3b91c38a8f02288e4ec4da301b90ae11', './lib/wiki-plugins/wikiplugin_map.php', '15.9', 0),
('2e70f195a6426e7befaa642cbedb417a', './lib/wiki-plugins/wikiplugin_mcalendar.php', '15.9', 0),
('91a3daabfe0a723a5a9e3750b752bc00', './lib/wiki-plugins/wikiplugin_mediaplayer.php', '15.9', 0),
('a1ea26dea1d52418170193637c01879f', './lib/wiki-plugins/wikiplugin_memberlist.php', '15.9', 0),
('b6c83a5ffdfb6434341fdd83b4d9ed50', './lib/wiki-plugins/wikiplugin_memberpayment.php', '15.9', 0),
('fbd2f04f9e365e2e59fe4dbe833a167c', './lib/wiki-plugins/wikiplugin_miniquiz.php', '15.9', 0),
('de3fdd2f264f4d421804078c8c036ef6', './lib/wiki-plugins/wikiplugin_module.php', '15.9', 0),
('cd545b678c3b9a0873ca5e73665a5d55', './lib/wiki-plugins/wikiplugin_modulelist.php', '15.9', 0),
('203fdfec5facd2c7d6d6215da5a07923', './lib/wiki-plugins/wikiplugin_mono.php', '15.9', 0),
('237daf16539f7dd53d37846f1450db94', './lib/wiki-plugins/wikiplugin_mouseover.php', '15.9', 0),
('0e215d8d50cf42bb885f44d54976d8e8', './lib/wiki-plugins/wikiplugin_mwtable.php', '15.9', 0),
('1071463e6502eccd156a9b7c04d7f481', './lib/wiki-plugins/wikiplugin_myspace.php', '15.9', 0),
('b9c16ccacc67b0378d2bcaec761ef8c4', './lib/wiki-plugins/wikiplugin_networkcondition.php', '15.9', 0),
('c3d7bc1b3c70bd5a4f305c0bf47a9d2f', './lib/wiki-plugins/wikiplugin_now.php', '15.9', 0),
('4984494cf524a863f565f720ea97611e', './lib/wiki-plugins/wikiplugin_objecthits.php', '15.9', 0),
('829d5ca2b1c433f031688e2ed26e582f', './lib/wiki-plugins/wikiplugin_objectlink.php', '15.9', 0),
('79f6c3d5433398a30a75dff5d3ed277e', './lib/wiki-plugins/wikiplugin_pagetabs.php', '15.9', 0),
('e91650e20eb2e27f8e5a1ae79b2b2bf7', './lib/wiki-plugins/wikiplugin_param.php', '15.9', 0),
('a8667725af087025221efc865f9d65d4', './lib/wiki-plugins/wikiplugin_pastlink.php', '15.9', 0),
('c83ec23b403febb8f59c89b5fae960cb', './lib/wiki-plugins/wikiplugin_payment.php', '15.9', 0),
('700d4cd5b23844becdc094ca865fc8ab', './lib/wiki-plugins/wikiplugin_paypal.php', '15.9', 0),
('b11fa2e56e6986f6a5169523f5dda966', './lib/wiki-plugins/wikiplugin_perm.php', '15.9', 0),
('8d4906553f469ffbb4d240b5c992159d', './lib/wiki-plugins/wikiplugin_perspective.php', '15.9', 0),
('8a1ceaa050ccacb72f600b25a202ca61', './lib/wiki-plugins/wikiplugin_piwik.php', '15.9', 0),
('1f6cc0c169c23a58c44042a6b7f8f3de', './lib/wiki-plugins/wikiplugin_playscorm.php', '15.9', 0),
('8fc522e5bb1743e80d06f9fa72f1f398', './lib/wiki-plugins/wikiplugin_pluginmanager.php', '15.9', 0),
('8a7d8b995be0d662491e4ad557871aae', './lib/wiki-plugins/wikiplugin_poll.php', '15.9', 0),
('71e5b89c5db4965a9ef7a0d570977c0a', './lib/wiki-plugins/wikiplugin_pref.php', '15.9', 0),
('ead8d440d9baf98f7137efa4867716ff', './lib/wiki-plugins/wikiplugin_prettytrackerviews.php', '15.9', 0),
('e4e4c8efdfb3cea904e5442d5e0e6082', './lib/wiki-plugins/wikiplugin_profile.php', '15.9', 0),
('d52f79314c94feb7d5ffbe38bb66eb01', './lib/wiki-plugins/wikiplugin_proposal.php', '15.9', 0),
('79c81c66df1c899ebf3c1c39c004d538', './lib/wiki-plugins/wikiplugin_quote.php', '15.9', 0),
('038bf2d29c6dd4babcfc5650bd8b545e', './lib/wiki-plugins/wikiplugin_randominclude.php', '15.9', 0),
('eab1af6353e0083de74e3de279a1facd', './lib/wiki-plugins/wikiplugin_rcontent.php', '15.9', 0),
('8042e857a569c811e990eff5c446f8ee', './lib/wiki-plugins/wikiplugin_realnamelist.php', '15.9', 0),
('f4deb3f5e1be690a6d22516497aec5dc', './lib/wiki-plugins/wikiplugin_redirect.php', '15.9', 0),
('2b3a86a0fab1f8483b551a57c9695094', './lib/wiki-plugins/wikiplugin_regex.php', '15.9', 0),
('3992c1ace814fb896b0582d7407cb0f5', './lib/wiki-plugins/wikiplugin_registermemberpayment.php', '15.9', 0),
('41281f720cdc1860bd1a9f38bd79e09a', './lib/wiki-plugins/wikiplugin_relations.php', '15.9', 0),
('c09053cda342331c15763fdb4f04c041', './lib/wiki-plugins/wikiplugin_remarksbox.php', '15.9', 0),
('0d9e9caae7b626601ad50f477b645bd6', './lib/wiki-plugins/wikiplugin_report.php', '15.9', 0),
('2f1cade5adc081e805c2c720950e354e', './lib/wiki-plugins/wikiplugin_rss.php', '15.9', 0),
('c7ec8a7c66a61d2e8dd2b801d49c9a2a', './lib/wiki-plugins/wikiplugin_scroll.php', '15.9', 0),
('a84d305e082e9572d5eac9708a675229', './lib/wiki-plugins/wikiplugin_sf.php', '15.9', 0),
('f79d7ac3f26ccbe88eab9bedf98a44fe', './lib/wiki-plugins/wikiplugin_sharethis.php', '15.9', 0),
('54e653d9c957354f4c97761a4144f66f', './lib/wiki-plugins/wikiplugin_sheet.php', '15.9', 0),
('5ac1a1b71665481b187d3372b42f1ddb', './lib/wiki-plugins/wikiplugin_shopperinfo.php', '15.9', 0),
('29509f6b0089abde0fe3d249e13e7490', './lib/wiki-plugins/wikiplugin_showpages.php', '15.9', 0),
('7147cd2b820d5719f9ed248730cde2fe', './lib/wiki-plugins/wikiplugin_showpref.php', '15.9', 0),
('bd1906d43f7ef237c5d5b5730a911f63', './lib/wiki-plugins/wikiplugin_showreference.php', '15.9', 0),
('ee6d2133890dd22b0682dfd144e5ff88', './lib/wiki-plugins/wikiplugin_sign.php', '15.9', 0),
('73d160e89d1a12620499d73cab9826e1', './lib/wiki-plugins/wikiplugin_skype.php', '15.9', 0),
('72a64f1aeaebdb78f70dc7f96cde3f44', './lib/wiki-plugins/wikiplugin_slider.php', '15.9', 0),
('85ad120aaac918e185c07c921d3dda97', './lib/wiki-plugins/wikiplugin_slideshow.php', '15.9', 0),
('fe8e86c0ccdb66a9d7adb8efb80a4bdf', './lib/wiki-plugins/wikiplugin_smarty.php', '15.9', 0),
('1a99cb3a6e67f8795a9f76cb3fb2973d', './lib/wiki-plugins/wikiplugin_snarf.php', '15.9', 0),
('38d6e92c2e834b5c9a5acf30dd7cf12c', './lib/wiki-plugins/wikiplugin_sort.php', '15.9', 0),
('17f1643245d5ab3e736e560b5eda40a0', './lib/wiki-plugins/wikiplugin_split.php', '15.9', 0),
('4af727787adc6df51b97f3a779f643d9', './lib/wiki-plugins/wikiplugin_sql.php', '15.9', 0),
('1398278ebf67364fd2a0d8f8a7e0bf99', './lib/wiki-plugins/wikiplugin_stat.php', '15.9', 0),
('1abcddb144244ec5a8e50893ad62aaf8', './lib/wiki-plugins/wikiplugin_sub.php', '15.9', 0),
('1ccd4aaf29fc0f80a4bc75b15a4b59b2', './lib/wiki-plugins/wikiplugin_subscribegroup.php', '15.9', 0),
('6fd4d0c1a82854d16208e9dcc56a6faf', './lib/wiki-plugins/wikiplugin_subscribegroups.php', '15.9', 0),
('aa8702abb51e7211705a07f627b768ae', './lib/wiki-plugins/wikiplugin_subscribenewsletter.php', '15.9', 0),
('d785d714676693284ca7c0cee605054a', './lib/wiki-plugins/wikiplugin_sup.php', '15.9', 0),
('a091d11038f8e357c44ed4c0ae5f968a', './lib/wiki-plugins/wikiplugin_survey.php', '15.9', 0),
('a96b9735c2e1faf3a39987253ecbebc7', './lib/wiki-plugins/wikiplugin_tabs.php', '15.9', 0),
('06993fbd498d1eeee9ecad90013d11c7', './lib/wiki-plugins/wikiplugin_tag.php', '15.9', 0),
('68afc8c336c83d1bb0fff5bd5a6ffef6', './lib/wiki-plugins/wikiplugin_timeline.php', '15.9', 0),
('66d9dcb6183f3d71111e38532d70465d', './lib/wiki-plugins/wikiplugin_timesheet.php', '15.9', 0),
('df3de5a4ff34ef376d91dac3b7bea1fe', './lib/wiki-plugins/wikiplugin_titlesearch.php', '15.9', 0),
('384964fa5e00b868725d3f9a07f5fe62', './lib/wiki-plugins/wikiplugin_toc.php', '15.9', 0),
('59350790eb8a1d5b34403570c8444c7f', './lib/wiki-plugins/wikiplugin_together.php', '15.9', 0),
('deb6ccfe8544dc70d2dfa4f14f94c8ca', './lib/wiki-plugins/wikiplugin_topfriends.php', '15.9', 0),
('d49a7909b10309182f1de7b12dd4a0fc', './lib/wiki-plugins/wikiplugin_tour.php', '15.9', 0),
('1c0a0e9d9ae9577e1e1b7f78f2fa8f75', './lib/wiki-plugins/wikiplugin_tr.php', '15.9', 0),
('2a380231cce566345fee5f57466d7be7', './lib/wiki-plugins/wikiplugin_tracker.php', '15.9', 0),
('4ad7ffd624801fdafadfac317e59546e', './lib/wiki-plugins/wikiplugin_trackercalendar.php', '15.9', 0),
('9348ab85e8c19a18feb3ba8d66959baa', './lib/wiki-plugins/wikiplugin_trackercomments.php', '15.9', 0),
('7d5956a670cbf1eca8f708aeb37bb38d', './lib/wiki-plugins/wikiplugin_trackerfilter.php', '15.9', 0),
('062dad02d88c22768f0956fc20d99c72', './lib/wiki-plugins/wikiplugin_trackerif.php', '15.9', 0),
('050bdf3ba8712033cbde23b21514e32d', './lib/wiki-plugins/wikiplugin_trackeritemcopy.php', '15.9', 0),
('18f663c660fe7c96a473bcdd47f56d69', './lib/wiki-plugins/wikiplugin_trackeritemfield.php', '15.9', 0),
('094ea629a393420c634a15a96c952cce', './lib/wiki-plugins/wikiplugin_trackerlist.php', '15.9', 0),
('2ad49777f132b38f5ec751cabfa69c0e', './lib/wiki-plugins/wikiplugin_trackerpasscode.php', '15.9', 0),
('fed875284ae9bb88533b45f7ca57f137', './lib/wiki-plugins/wikiplugin_trackerprefill.php', '15.9', 0),
('d4d6df961756a1b1f5f86023e05da40d', './lib/wiki-plugins/wikiplugin_trackerquerytemplate.php', '15.9', 0),
('55188df554834643a2b7f37a226648a3', './lib/wiki-plugins/wikiplugin_trackerstat.php', '15.9', 0),
('6cb0afced92e50b1b8bbbff0ebb206d5', './lib/wiki-plugins/wikiplugin_trackertimeline.php', '15.9', 0),
('8e644b76deccef5472b1141fdd5eed25', './lib/wiki-plugins/wikiplugin_trackertoggle.php', '15.9', 0),
('7577e2b4b72f2502a1af747ba6cb2338', './lib/wiki-plugins/wikiplugin_trade.php', '15.9', 0),
('225189a4433c3810b204558e5d546e49', './lib/wiki-plugins/wikiplugin_transclude.php', '15.9', 0),
('8d08bd199910ea77edb7d26ac366db01', './lib/wiki-plugins/wikiplugin_translated.php', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('2993e3d97e088333f71eaab6866beaf2', './lib/wiki-plugins/wikiplugin_translationof.php', '15.9', 0),
('53627f44b8600425a5771257a05ec83e', './lib/wiki-plugins/wikiplugin_twitter.php', '15.9', 0),
('bb7f82c7185a1bed725abb9796aca34f', './lib/wiki-plugins/wikiplugin_usercount.php', '15.9', 0),
('619a90a9ecf329e1e3776d2860b5dcca', './lib/wiki-plugins/wikiplugin_useringroup.php', '15.9', 0),
('e9bbf1eeb2e0fc7fcee2e1089e51f93a', './lib/wiki-plugins/wikiplugin_userlastlogged.php', '15.9', 0),
('b60ec9f6f771c009eb49bd164a4c49fe', './lib/wiki-plugins/wikiplugin_userlink.php', '15.9', 0),
('a70de38ce93bf335839a4b1796346d65', './lib/wiki-plugins/wikiplugin_userlist.php', '15.9', 0),
('1eb1764d95854cd5e26f6b04d6e37bdc', './lib/wiki-plugins/wikiplugin_userpref.php', '15.9', 0),
('0019df3823d47758eeade121cd9ac9fd', './lib/wiki-plugins/wikiplugin_versions.php', '15.9', 0),
('1ff18c6a534ecee9fbb32a92a7ac421c', './lib/wiki-plugins/wikiplugin_vimeo.php', '15.9', 0),
('7e19158dff0bd27eda91f34a4532e6ce', './lib/wiki-plugins/wikiplugin_vote.php', '15.9', 0),
('12e1f34c73f2555bce57d5b5890b96ee', './lib/wiki-plugins/wikiplugin_votings.php', '15.9', 0),
('a857b1c3096de1d1104b49bb85648869', './lib/wiki-plugins/wikiplugin_wantedpages.php', '15.9', 0),
('6beb8e9a7e71ee73ee5f297b0a32a6ce', './lib/wiki-plugins/wikiplugin_webdocviewer.php', '15.9', 0),
('6ae166ba8fa17e5134ad2be0d1a06747', './lib/wiki-plugins/wikiplugin_webservice.php', '15.9', 0),
('5bf38dcccc73aacd82818d5b3a959bcf', './lib/wiki-plugins/wikiplugin_wikidiff.php', '15.9', 0),
('5603d17d466630586107e2ea1b702ab9', './lib/wiki-plugins/wikiplugin_wysiwyg.php', '15.9', 0),
('341a685432a6cf3b6135440bc95f696d', './lib/wiki-plugins/wikiplugin_xmlupdate.php', '15.9', 0),
('392d044cb40e50e3bd5e5446d3f0fa14', './lib/wiki-plugins/wikiplugin_youtube.php', '15.9', 0),
('56ed57ac165431dd2ff10bc6e7812fd2', './lib/wiki-plugins/wikiplugin_zotero.php', '15.9', 0),
('e31997be437fd4a06f7957ca11f9fa41', './lib/wiki-plugins/wikiplugin_zoterolist.php', '15.9', 0),
('4d0d8764ba956b5c9bd2dc497fd70d40', './lib/wiki/editlib.php', '15.9', 0),
('05a1efaf177cc13c8b1501912e8a315c', './lib/wiki/exportlib.php', '15.9', 0),
('5c3450e20ff96a261dd0711507076158', './lib/wiki/flaggedrevisionlib.php', '15.9', 0),
('82b47e9cc1712b3098618aa13d59bb51', './lib/wiki/histlib.php', '15.9', 0),
('ec5e7dc6a7fd23c290c4f06439114bee', './lib/wiki/index.php', '15.9', 0),
('37ca1c81b8f0a2c2c3e1b5cc538bf924', './lib/wiki/pluginslib.php', '15.9', 0),
('8c442560dd1532aa3b959f2d1348e0ea', './lib/wiki/quantifylib.php', '15.9', 0),
('d5d0240dfe970fff13bef5b4c34b5263', './lib/wiki/renderlib.php', '15.9', 0),
('c1629103779b4f7c02b6dfa740bae471', './lib/wiki/semanticlib.php', '15.9', 0),
('008f4b12f441319e64d0231a593f2677', './lib/wiki/wikilib.php', '15.9', 0),
('86b0cbc5127d969c46346b724f70ac5c', './lib/wiki/xmllib.php', '15.9', 0),
('d901545ae0af606f752585b852f55629', './lib/wikiLingo_tiki/WikiEvents.php', '15.9', 0),
('cf14ffa5373700ae0a2685f6aa621357', './lib/wikiLingo_tiki/WikiLingoEvents.php', '15.9', 0),
('8183672fed605de67207aa732e0f9198', './lib/wikiLingo_tiki/WikiLingoTikiEvents.php', '15.9', 0),
('ed7103752396641cefa981c815be2549', './lib/wikiLingo_tiki/WikiLingoWYSIWYGEvents.php', '15.9', 0),
('6299974a373e2cad0f0fcd043f25bebe', './lib/wikiLingo_tiki/WikiMetadataLookup.php', '15.9', 0),
('8a2d427518554efaa49579d064e79d0d', './lib/wikiLingo_tiki/WikiPluginBridge.php', '15.9', 0),
('4484bbcf16e486f6053ca2f95378ff89', './lib/wikiLingo_tiki/WikiPluginStub.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/wikiLingo_tiki/index.php', '15.9', 0),
('94f7a47d5966895b9c2c6564fdcb4650', './lib/wikiLingo_tiki/tiki_flp.Link.js', '15.9', 0),
('57ac8d97cb2195ca2d708bfac4c612c3', './lib/wikiLingo_tiki/tiki_wikiLingo_edit.js', '15.9', 0),
('ada65dd7e90809c46db1495eaea4ea1e', './lib/wikiLingo_tiki/tiki_wikiLingo_flp_view.js', '15.9', 0),
('6c3ed87a084b86fbe6ca9142d7e3859f', './lib/wizard/index.php', '15.9', 0),
('216c3a89728d91f45f68ab8d6e368cad', './lib/wizard/pages/admin_advanced.php', '15.9', 0),
('dfc0d617de7e157eac7eb9504453fdc4', './lib/wizard/pages/admin_auto_toc.php', '15.9', 0),
('a1d8cb0d2482706cea244c8dd0bca698', './lib/wizard/pages/admin_category.php', '15.9', 0),
('8492d893bf8a6903aaec4a1480d7dd48', './lib/wizard/pages/admin_community.php', '15.9', 0),
('211cf5a941191a39630368bdec9ccd20', './lib/wizard/pages/admin_date_time.php', '15.9', 0),
('25d0c46b628de51ab5abbcf33b90f57a', './lib/wizard/pages/admin_editor_type.php', '15.9', 0),
('df601fc01879c3a76b3581cb84f766fa', './lib/wizard/pages/admin_features.php', '15.9', 0),
('6bf43590f7eb0cdbb4fbe2bd4e3a1567', './lib/wizard/pages/admin_files.php', '15.9', 0),
('bb6c590f4b597961c77030d2fd331a30', './lib/wizard/pages/admin_files_storage.php', '15.9', 0),
('c9cffb3a5bd4748e0f398dfaf3744736', './lib/wizard/pages/admin_jcapture.php', '15.9', 0),
('59993a1a1616d888a5a616ae84cf6471', './lib/wizard/pages/admin_language.php', '15.9', 0),
('c294216066f3c2efdc17852cba5bfded', './lib/wizard/pages/admin_login.php', '15.9', 0),
('07d4087229fce425882c7745a8101dc6', './lib/wizard/pages/admin_look_and_feel.php', '15.9', 0),
('c246292715fdf36463c937438b62d995', './lib/wizard/pages/admin_namespace.php', '15.9', 0),
('85585c67aca8b20d8b4c8c2ee4723b44', './lib/wizard/pages/admin_search.php', '15.9', 0),
('e4731ff755b0cf0fb9c40bf733657298', './lib/wizard/pages/admin_structures.php', '15.9', 0),
('bfd39c7935d606979a0c100d3c5d7bf4', './lib/wizard/pages/admin_text_area.php', '15.9', 0),
('a344630c3923199592e262d975793c7f', './lib/wizard/pages/admin_wiki.php', '15.9', 0),
('05e853e142345a909d5ca6b488a5827b', './lib/wizard/pages/admin_wizard.php', '15.9', 0),
('70c43c50d4d8f985243dcf4e5c95a03d', './lib/wizard/pages/admin_wizard_completed.php', '15.9', 0),
('4bbba611fffc132125f9e95fdd176e37', './lib/wizard/pages/admin_wysiwyg.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './lib/wizard/pages/index.php', '15.9', 0),
('6701a4616d352d45e2c37c35526004ca', './lib/wizard/pages/profiles_completed.php', '15.9', 0),
('10b7611af5857168ae71026b82463ccb', './lib/wizard/pages/profiles_demo_common_confs.php', '15.9', 0),
('fa73b7e067ec661b9aa12973828ffc22', './lib/wizard/pages/profiles_demo_highly_specialized_confs.php', '15.9', 0),
('d848ee5909f4e03faa05507c9c18f8c2', './lib/wizard/pages/profiles_demo_interesting_use_cases.php', '15.9', 0),
('7ec756460cc169eca9386c572659c6ad', './lib/wizard/pages/profiles_demo_more_advanced_confs.php', '15.9', 0),
('2925f91e916a1b8b769dcdec12c1022d', './lib/wizard/pages/profiles_demo_other_interesting_use_cases.php', '15.9', 0),
('9d31355f77e9b106729261eeeb89efa2', './lib/wizard/pages/profiles_featured_site_confs.php', '15.9', 0),
('63078a09ddf3199ced521135e969bb13', './lib/wizard/pages/profiles_useful_admin_confs.php', '15.9', 0),
('2ce9241aa2cca60b341ce7046a19a259', './lib/wizard/pages/profiles_useful_changes_in_display.php', '15.9', 0),
('e363e4fc56edbfdf6a96a8ff945551b7', './lib/wizard/pages/profiles_useful_micro_confs.php', '15.9', 0),
('6c3542d1d9f7d3b731dddabfd1e01e18', './lib/wizard/pages/profiles_useful_new_tech_confs.php', '15.9', 0),
('d27701b7a8d8820a7176a4d76c6e2002', './lib/wizard/pages/upgrade_doc_page_iframe.php', '15.9', 0),
('19e4667296865653a1a90c8d6783ebb1', './lib/wizard/pages/upgrade_new_in_13.php', '15.9', 0),
('15edeaeeac9c9a4c5896637939dc3437', './lib/wizard/pages/upgrade_new_in_14.php', '15.9', 0),
('c27f9e6598518acafba2b1af6c5f0f4a', './lib/wizard/pages/upgrade_new_in_15.php', '15.9', 0),
('06bbd108117bdbc33224a9978468ee8b', './lib/wizard/pages/upgrade_novice_admin_assistance.php', '15.9', 0),
('de6e4abfd0aa3ace3039a65c42a4f7b9', './lib/wizard/pages/upgrade_others.php', '15.9', 0),
('7ff10dd805289396695d7d3d53b6cea3', './lib/wizard/pages/upgrade_permissions_and_logs.php', '15.9', 0),
('ca874ddece82f5423c6254199d6179d1', './lib/wizard/pages/upgrade_send_feedback.php', '15.9', 0),
('af3919483a061dff18b61da3e194217b', './lib/wizard/pages/upgrade_trackers.php', '15.9', 0),
('7e8755d822cc9d62c2d27fb759569936', './lib/wizard/pages/upgrade_ui.php', '15.9', 0),
('8cd81559590d3c63d51b3cb8591b52e1', './lib/wizard/pages/upgrade_wizard_completed.php', '15.9', 0),
('347a3dc61646e5c4610d479c55b7e007', './lib/wizard/pages/user_dummy1.php', '15.9', 0),
('694f8a6e16aeee8b93133b10c2ba4eea', './lib/wizard/pages/user_dummy2.php', '15.9', 0),
('df91db96a1b25a2a00d732cd67df8d6a', './lib/wizard/pages/user_dummy3.php', '15.9', 0),
('f689eaf58d306890b3fb0298f24d8133', './lib/wizard/pages/user_preferences_info.php', '15.9', 0),
('02fbc8c5b4163399bbec72fc8e38de1f', './lib/wizard/pages/user_preferences_notifications.php', '15.9', 0),
('51fa72aba781c3387362a5935efcf95e', './lib/wizard/pages/user_preferences_params.php', '15.9', 0),
('6ed3ffa1059344802bb6d430632e2dc5', './lib/wizard/pages/user_preferences_reports.php', '15.9', 0),
('81cef165d031b63a555cc091e16d0fa1', './lib/wizard/pages/user_tracker.php', '15.9', 0),
('cef5095e1aa823f4f15e44e9028ca5bc', './lib/wizard/pages/user_wizard.php', '15.9', 0),
('8e68f20e2d2b8f0aa33e612cc02b64d9', './lib/wizard/pages/user_wizard_completed.php', '15.9', 0),
('7d678e3ab215befba654e877598d81c3', './lib/wizard/wizard.php', '15.9', 0),
('1b90ff74d9d1109e8a7bc08e110110ad', './lib/wizard/wizardlib.php', '15.9', 0),
('513b65702367a5882ca1f76efa88f3fd', './lib/ziplib.php', '15.9', 0),
('0d7308b868387bac1e83a0724d343938', './lib/zoterolib.php', '15.9', 0),
('fa5f6efdb0b714c0c90dc3098d1af314', './list-file_backlinks_ajax.php', '15.9', 0),
('99c30080fcffe1d2cbb8a55d628a03f5', './list-tracker_field_values_ajax.php', '15.9', 0),
('54ffcc77da72892eb0952ad50f97dfae', './lists/articles.php', '15.9', 0),
('84bc899c8325934414a6bc4c8a838f2f', './messu-archive.php', '15.9', 0),
('37c20750ef1dd105aac84acade2f7840', './messu-broadcast.php', '15.9', 0),
('b46d7d7735c2a8a44df9863f64801a95', './messu-compose.php', '15.9', 0),
('a732612abfaa1f7e6e28a7317f6ffc78', './messu-mailbox.php', '15.9', 0),
('61da58fb645e2da992ed28b0caba700c', './messu-read.php', '15.9', 0),
('9937c35e2e53a2513c80eec7638b6310', './messu-read_archive.php', '15.9', 0),
('4dc20ced3f239b879ce850cb18db66fe', './messu-read_sent.php', '15.9', 0),
('0c387b6f7c6f48001a3cd47ba11d0061', './messu-sent.php', '15.9', 0),
('6b319d19146694eabc6ba7a75fb25dab', './modsadm.php', '15.9', 0),
('cb0531ca723b43c1a8799c2ba534ada8', './modules/cache/index.php', '15.9', 0),
('989655c1ff68279c8af94a132de049af', './modules/index.php', '15.9', 0),
('1a3de21c60b8a07b2e821706c33c811e', './modules/mod-func-action_calendar.php', '15.9', 0),
('d10f040becff4c0c23132d2d7eb463bf', './modules/mod-func-action_similarcontent.php', '15.9', 0),
('11946da94522b3ea348ba2ebd8900ae8', './modules/mod-func-addon.php', '15.9', 0),
('7bf5e396142243b6b9c09dade0ab409c', './modules/mod-func-adsense.php', '15.9', 0),
('0b9793fcec194011f89cf235e0c4f27c', './modules/mod-func-article_archives.php', '15.9', 0),
('129461060438646ced4f583d6b3229f9', './modules/mod-func-article_topics.php', '15.9', 0),
('d9b50464118a6f8d2fe01432eff84fef', './modules/mod-func-articles.php', '15.9', 0),
('e404a88ef0a0bbc64478402c5f73aa4b', './modules/mod-func-assistant.php', '15.9', 0),
('bd9f0724adbe1da9c12cb5bfdf222d9d', './modules/mod-func-blog_last_comments.php', '15.9', 0),
('7720b27500a40917ab089522848ea1f2', './modules/mod-func-breadcrumb.php', '15.9', 0),
('7f3364f29c1b3a7ec5111fe0bf8a73a2', './modules/mod-func-breadcrumbs.php', '15.9', 0),
('73f96d503c04a7cd5c27a076ab0322bc', './modules/mod-func-calendar_new.php', '15.9', 0),
('dfc405e7b3e2f594c7e105421012b878', './modules/mod-func-cart.php', '15.9', 0),
('66cafb8d4c60085ffb1008e029b24750', './modules/mod-func-categories.php', '15.9', 0),
('f7a1a150d7f7694d8b43f5090c595ab6', './modules/mod-func-category_transition.php', '15.9', 0),
('bfb870fe927b95fc0e54070e97e295c8', './modules/mod-func-change_category.php', '15.9', 0),
('aed72ddb2af1847cf6a3122f190f81e7', './modules/mod-func-collapse.php', '15.9', 0),
('cf163f8a004026cb79eedc618010e4f1', './modules/mod-func-comm_received_objects.php', '15.9', 0),
('b2367b219e1a0eaaac8e79ffe291cc55', './modules/mod-func-contributors.php', '15.9', 0),
('cd3d71b06c1578f7582cd1c8f3b88148', './modules/mod-func-credits.php', '15.9', 0),
('b2f435ce2893b9c086eb8d8bd34c8c98', './modules/mod-func-directory_last_sites.php', '15.9', 0),
('231e390b3bd15f943b97272f4cfc2ff4', './modules/mod-func-directory_stats.php', '15.9', 0),
('0a15392940b8da4bca77697397845d64', './modules/mod-func-directory_top_sites.php', '15.9', 0),
('414206400188b907b22af3e0b8f4c19f', './modules/mod-func-domain_password.php', '15.9', 0),
('0e100c5d0c6da2dd12febeed22a6eff8', './modules/mod-func-facebook.php', '15.9', 0),
('91696f5acde24c2988b0054c3bf8a758', './modules/mod-func-featured_links.php', '15.9', 0),
('e4ec1f7cb35f133bbfa287fc1f895b55', './modules/mod-func-file_galleries.php', '15.9', 0),
('f471061719b9dc6fd2b7cecb9240d0fd', './modules/mod-func-forums_best_voted_topics.php', '15.9', 0),
('7fc6503b547a59697c131937df2f0d37', './modules/mod-func-forums_last_posts.php', '15.9', 0),
('1d32737e8200e730477bb25f7eb6df01', './modules/mod-func-forums_most_commented_forums.php', '15.9', 0),
('eb4acfbb50183d4bcea40022e9715c15', './modules/mod-func-forums_most_read_topics.php', '15.9', 0),
('70f75a9145ead49fc0f947f2f3586e39', './modules/mod-func-forums_most_visited_forums.php', '15.9', 0),
('9c9bc539ba1318757336ce3a419d4b27', './modules/mod-func-freetag.php', '15.9', 0),
('072de338e8f4efb39ee143da1021d6f9', './modules/mod-func-freetags_current.php', '15.9', 0),
('12409986b22dcd141de734a56c7b58ce', './modules/mod-func-freetags_morelikethis.php', '15.9', 0),
('f718d427d0ef8ecc6e79d371461ec50e', './modules/mod-func-freetags_most_popular.php', '15.9', 0),
('e6d14f0d7e4d810e092144f746067ad6', './modules/mod-func-freetags_prefered.php', '15.9', 0),
('40a93a15848791bed02803840b02ef96', './modules/mod-func-friend_list.php', '15.9', 0),
('43d5ba75cf5c80dec6b3c2aa9d3b7c73', './modules/mod-func-google.php', '15.9', 0),
('88ef49aa0a278944ab0583d4dea75872', './modules/mod-func-groups_emulation.php', '15.9', 0),
('0a5514925a8155693c01dc81e04d959e', './modules/mod-func-last_actions.php', '15.9', 0),
('76d46bab0c5b9eeccebf7e5b0e530fb3', './modules/mod-func-last_blog_posts.php', '15.9', 0),
('b791b2a8fdaad153138aef33253bf85b', './modules/mod-func-last_category_objects.php', '15.9', 0),
('d8a9239cfff94acd47f0519af1d4ab95', './modules/mod-func-last_created_blogs.php', '15.9', 0),
('bb6d27161c59e5576c8b6a01ff43d850', './modules/mod-func-last_created_faqs.php', '15.9', 0),
('102095437c34d98856088fa88e24ad9d', './modules/mod-func-last_created_quizzes.php', '15.9', 0),
('78e07fc11bfac88e9facd10badf89f31', './modules/mod-func-last_file_galleries.php', '15.9', 0),
('04df89238e5c2c7323dfde05aca94c53', './modules/mod-func-last_files.php', '15.9', 0),
('dc033882431ad157873276f342d6e943', './modules/mod-func-last_image_galleries.php', '15.9', 0),
('e5e02749afcf22c6145c0b2faf730d11', './modules/mod-func-last_images.php', '15.9', 0),
('38359501abe8c472a848bbad05aa66c8', './modules/mod-func-last_modif_events.php', '15.9', 0),
('3810ce800d03d57067d74f6c1622d19d', './modules/mod-func-last_modif_pages.php', '15.9', 0),
('69ebb6506a223b5eb7c024039162a570', './modules/mod-func-last_modified_blogs.php', '15.9', 0),
('76ed9a9342c610fe1b7dfc3359c88ae3', './modules/mod-func-last_podcasts.php', '15.9', 0),
('1bb12c7f8be4b5ff08f747a627346cc9', './modules/mod-func-last_submissions.php', '15.9', 0),
('70051420781b8e5f686f62180d082336', './modules/mod-func-last_tracker_comments.php', '15.9', 0),
('06cbe5b9e86eb6be9eb3cb904553197b', './modules/mod-func-last_tracker_items.php', '15.9', 0),
('c6a752063d7943c87ab29902990ca456', './modules/mod-func-last_validated_faq_questions.php', '15.9', 0),
('e45210e777e49be454565ac05de89dc3', './modules/mod-func-last_visitors.php', '15.9', 0),
('0c63783fa178a840286d24c85f6e9735', './modules/mod-func-last_youtube_playlist_videos.php', '15.9', 0),
('0c865186c2b6296d946684f90619c710', './modules/mod-func-live_support.php', '15.9', 0),
('5fc901ddaf9b99390e53178f32ae58da', './modules/mod-func-loadstats.php', '15.9', 0),
('195a7acb0633be45e61b49137ad9e2f4', './modules/mod-func-locator.php', '15.9', 0),
('3a7d8bce2cc0fedb03b2388ae349ce31', './modules/mod-func-login_box.php', '15.9', 0),
('e7de9253c747bf04f9092f5433635ecc', './modules/mod-func-logo.php', '15.9', 0),
('2d9d541399e1dcbb4530f416562f1675', './modules/mod-func-map_edit_features.php', '15.9', 0),
('0c62897c62971cce09b455aeddb79826', './modules/mod-func-map_layer_selector.php', '15.9', 0),
('0e4dfe29679c8ca68161f8feee2411d6', './modules/mod-func-map_mode_selector.php', '15.9', 0),
('6191c41a1f9b9023b29df27959eade05', './modules/mod-func-map_search_location.php', '15.9', 0),
('2ab395769128afd330f5bff6b0d4b09f', './modules/mod-func-menu.php', '15.9', 0),
('a15001487f228fee4764ae0185fe8a34', './modules/mod-func-menupage.php', '15.9', 0),
('a4c1ad803977a1702d97bcfbe3060d6c', './modules/mod-func-menustructure.php', '15.9', 0),
('ab5442a8ff53ff67137727f1d0585dff', './modules/mod-func-messages_unread_messages.php', '15.9', 0),
('bfabcbbcfe11ca70310f95e026a1378f', './modules/mod-func-minichat.php', '15.9', 0),
('7ed4d9b6def75a427a73f3c6bc1edf02', './modules/mod-func-mobile.php', '15.9', 0),
('fd68f2dfea7f06e3599b27ff54eeb2cd', './modules/mod-func-months_links.php', '15.9', 0),
('05e76004a1acfbaec80d85ad3bc6812a', './modules/mod-func-most_commented.php', '15.9', 0),
('2023ad2196684246fe06153ee7f09804', './modules/mod-func-mustread.php', '15.9', 0),
('eca40ee0ba8bba3b7bebf2242c337afc', './modules/mod-func-notificationlink.php', '15.9', 0),
('dacb0f618c5d10dee9e720cca3eea824', './modules/mod-func-num_submissions.php', '15.9', 0),
('b7a803e5ff990e2487653b97581bf105', './modules/mod-func-old_articles.php', '15.9', 0),
('f0e386dbc98d1ef4f37989204cf3362b', './modules/mod-func-payment_outstanding.php', '15.9', 0),
('7f2d8c831a4fca6d154d682ce4611e9d', './modules/mod-func-perspective.php', '15.9', 0),
('3077fb6ff29ce4abbc8138b43710d633', './modules/mod-func-poweredby.php', '15.9', 0),
('083970aa7d0bad5df9b9a1a34247524d', './modules/mod-func-quick_edit.php', '15.9', 0),
('8e94ce3ac75b9d7b1a8c0dc8b4910a96', './modules/mod-func-quick_search.php', '15.9', 0),
('28e4715e8a34c8b97cdf46cad4fad29e', './modules/mod-func-quickadmin.php', '15.9', 0),
('049f32abca126604c28b40acc45e6266', './modules/mod-func-random_images.php', '15.9', 0),
('ed630733edd38b2eb8d348d1a792e39a', './modules/mod-func-random_pages.php', '15.9', 0),
('51163d37eb77deba6795bfd795022e76', './modules/mod-func-register.php', '15.9', 0),
('59b39954cce150a51e4ad90ac77e75ee', './modules/mod-func-rsslist.php', '15.9', 0),
('3b2be83fb4e2d1ed9021ae08b7182dd4', './modules/mod-func-search.php', '15.9', 0),
('8ffc6ce32340df1b2b95cfcf06699b18', './modules/mod-func-search_morelikethis.php', '15.9', 0),
('8e6fb16fd3aa6ce250b084dc0c71ab22', './modules/mod-func-search_wiki_page.php', '15.9', 0),
('16d2b744561f400e34bec06f22808810', './modules/mod-func-semantic_links.php', '15.9', 0),
('0d75cc45cb5a3df5ad378371dc6968b7', './modules/mod-func-share.php', '15.9', 0),
('223fd71924ecb18d1b3a7bcd0b02b3f2', './modules/mod-func-shoutbox.php', '15.9', 0),
('b176feb9e13e753175716bb5f72f4dae', './modules/mod-func-since_last_visit.php', '15.9', 0),
('9c7959c1a740bb0c5e77d1d2abb52fd7', './modules/mod-func-since_last_visit_new.php', '15.9', 0),
('c86179e5f6832dba57bd4ad2f6c68bbd', './modules/mod-func-svnup.php', '15.9', 0),
('505dc888bf1848696936cad55617294f', './modules/mod-func-switch_lang.php', '15.9', 0),
('d5b0a2e3bcdd31d85dd287fb53adbd6f', './modules/mod-func-switch_theme.php', '15.9', 0),
('6224fdbdd7b9e32c23667d44a311b8ad', './modules/mod-func-terminology.php', '15.9', 0),
('c06ab4feedd2c99a4ad5254f0a7a003c', './modules/mod-func-tikitests.php', '15.9', 0),
('9904d32b5080403ffd3a65decb9a7f8c', './modules/mod-func-top_active_blogs.php', '15.9', 0),
('0f27513c33ee82d5b1fb6229a7f9a8fb', './modules/mod-func-top_articles.php', '15.9', 0),
('26f47c74b5cd36de0a248cdd5dcb5f6a', './modules/mod-func-top_blog_posters.php', '15.9', 0),
('ce63d4a9a5da9536254215ff8770191f', './modules/mod-func-top_file_galleries.php', '15.9', 0),
('2973b88491574aeb5967d39eccc69def', './modules/mod-func-top_files.php', '15.9', 0),
('5b6bb258a433137afad60ec6d3b1e10c', './modules/mod-func-top_forum_posters.php', '15.9', 0),
('d818521638e58b5cf34b9404dcc98baa', './modules/mod-func-top_image_galleries.php', '15.9', 0),
('3edb04b9daf55533bfa44b50fc8cee70', './modules/mod-func-top_images.php', '15.9', 0),
('f1927e7a292d2e38ce38fc6062e9cdee', './modules/mod-func-top_objects.php', '15.9', 0),
('d19ec43cf22bc617e0f9788f255932b7', './modules/mod-func-top_pages.php', '15.9', 0),
('04225f50c73d103047546e5349505b84', './modules/mod-func-top_quizzes.php', '15.9', 0),
('377592ceddc1f1ee3624e8949bb4a269', './modules/mod-func-top_visited_blogs.php', '15.9', 0),
('7948ba69399f25d20c4ddfd2aa57b6c1', './modules/mod-func-top_visited_faqs.php', '15.9', 0),
('1753e012d2d0d07214639385d1a4b072', './modules/mod-func-tracker_input.php', '15.9', 0),
('845518f2694f302d1ca3fd0c5a35197b', './modules/mod-func-trackerhelp.php', '15.9', 0),
('4069c79aa35a3aaa50c1d5e4e1d32460', './modules/mod-func-translation.php', '15.9', 0),
('651e6673bdf225e187aca04ae0e7a836', './modules/mod-func-twitter.php', '15.9', 0),
('64618d4558ae5bbd957d18de851d365e', './modules/mod-func-upcoming_events.php', '15.9', 0),
('430310ecc7e4399da87cdd16df17a5a8', './modules/mod-func-user_blogs.php', '15.9', 0),
('69e46c283880f10b0e858eaabd353f8c', './modules/mod-func-user_bookmarks.php', '15.9', 0),
('b62069bb317e9aa91f679957af16eaf2', './modules/mod-func-user_image_galleries.php', '15.9', 0),
('0d1beafc892248352a1e45385433bab3', './modules/mod-func-user_pages.php', '15.9', 0),
('295cdd4adba756e383e3b9e91399000f', './modules/mod-func-user_tasks.php', '15.9', 0),
('55bb334bd9051cdcf4f363d1f4569c4a', './modules/mod-func-user_tasks_public.php', '15.9', 0),
('eb6c4821e985719264cd97609a6cc36e', './modules/mod-func-usergroup_tracker.php', '15.9', 0),
('d41c7041bf9948a09bf97d4f0ea431ad', './modules/mod-func-users_list.php', '15.9', 0),
('bac75e86c7a6f61fc665d6807df06899', './modules/mod-func-users_own_rank.php', '15.9', 0),
('9b0d5c84fa5346aafeb83f9c4db5ef61', './modules/mod-func-users_rank.php', '15.9', 0),
('3e900ca10794b302c6c0b8432e6d258f', './modules/mod-func-webmail_inbox.php', '15.9', 0),
('9fb863a09ba4963fe7e856cdbf83e50e', './modules/mod-func-whats_related.php', '15.9', 0),
('3568f1697d1287ef2b3caf528577b3c7', './modules/mod-func-who_is_there.php', '15.9', 0),
('d8e6843d3621a5dba41dadb71cab4a25', './modules/mod-func-wiki_last_comments.php', '15.9', 0),
('375ece92d3442387f0972a0c9c559d79', './modules/mod-func-youtube.php', '15.9', 0),
('5aa873a99ec2c89e69847b045a2cfccc', './modules/mod-func-zone.php', '15.9', 0),
('eff4ea8896a762b07e9943971e3e2eb8', './modules/mod-func-zotero.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/check.php', '15.9', 0),
('b07035e093c510b26c58b800199cea9d', './permissioncheck/create_new_htaccess.php', '15.9', 0),
('639532762b8d1c3e79da83cd0027a304', './permissioncheck/functions.inc.php', '15.9', 0),
('a5d6071502855eba9c98a7e9556cd2ac', './permissioncheck/index.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/insane/check.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/mixed/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/mixed/index.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/morepain/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/morepain/index.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/moreworry/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/moreworry/index.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/pain/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/pain/index.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/paranoia-suphp/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/paranoia-suphp/index.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/paranoia/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/paranoia/index.php', '15.9', 0),
('264fa3c41879701050c33eec2cc2ea3f', './permissioncheck/permission_granted.inc.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/risky/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/risky/index.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/sbox/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/sbox/index.php', '15.9', 0),
('c2225cdbe3412af2d954287e5f587dc3', './permissioncheck/usecases.inc.php', '15.9', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/worry/check.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './permissioncheck/worry/index.php', '15.9', 0),
('f631a4a9ac2de5058bf45b7809a3cc10', './plugins_help.php', '15.9', 0),
('0119a00718cdc9a696d373a40cd0a537', './poll_categorize.php', '15.9', 0),
('cdd4660a3575df8e842d42c51e444cff', './received_article_image.php', '15.9', 0),
('29dbdc128e992625d0b1de98aa1c4e95', './references.php', '15.9', 0),
('e75b9d67fd48c23e431128ff52fd4021', './reindex_file.php', '15.9', 0),
('ff1665668147a9ec251a55e4212d02fd', './remote.php', '15.9', 0),
('da55a6e42e2d2d83182d0f42c8acd6ba', './route.php', '15.9', 0),
('1e462c82bca57ecc9cd0cd871267ab24', './select_banner.php', '15.9', 0),
('1f67d2d44202c7ad3e170ea80ec6a1f5', './show_image.php', '15.9', 0),
('c583530610302d0990d6244581024bcb', './snarf_ajax.php', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './temp/cache/index.php', '15.9', 0),
('5d724414d8e70e97907119f4d2f7976d', './temp/index.php', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './temp/mail_attachs/index.php', '15.9', 0),
('80b22f1cdc1770c325a9cf777d4be4ac', './temp/public/index.php', '15.9', 0),
('5aac5352d44f391c9e14537aed4887d9', './templates/access/confirm.tpl', '15.9', 0),
('ed46d4a4cbba8ce76c0d32bfb1d7925f', './templates/access/confirm_select.tpl', '15.9', 0),
('07dbdf8a247870e931dbc99b3dabe80d', './templates/access/include_footer.tpl', '15.9', 0),
('d83d22d5993e24053a9d0df8074f0b66', './templates/access/include_hidden.tpl', '15.9', 0),
('66ba823cc3148ce4a8837124cfa6ea03', './templates/access/include_items.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/access/index.php', '15.9', 0),
('17788f7351ff233950a1529fe6301622', './templates/activity/activityframe.tpl', '15.9', 0),
('eaf01d947993333fc4d4ddf30c836d81', './templates/activity/activitystream.tpl', '15.9', 0),
('137c3f826cb234690847f0efac30f44e', './templates/activity/default_event.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/activity/index.php', '15.9', 0),
('b471295b0970a9822543581c113cd7c3', './templates/activity/tiki.comment.post.tpl', '15.9', 0),
('b471295b0970a9822543581c113cd7c3', './templates/activity/tiki.comment.reply.tpl', '15.9', 0),
('af665cc297ae64c3d4be2e7550344e07', './templates/activity/tiki.forumpost.create.tpl', '15.9', 0),
('e61bcebc92da695ca5f066657c996d80', './templates/activity/tiki.forumpost.reply.tpl', '15.9', 0),
('70b09a747021a1336e072ada35bef454', './templates/activity/tiki.forumpost.update.tpl', '15.9', 0),
('f8d29662f9fc323b38c443b3da96c8e9', './templates/activity/tiki.mustread.required.tpl', '15.9', 0),
('e174b8a16842c1133db03b4b53f4364f', './templates/activity/tiki.query.critical.tpl', '15.9', 0),
('cc6affee88486b5f450957bb4f77da09', './templates/activity/tiki.query.high.tpl', '15.9', 0),
('100da4e5fcc4c4416fd109d1cc268408', './templates/activity/tiki.query.low.tpl', '15.9', 0),
('8cade1f8006cca0017bd93e43c983433', './templates/activity/tiki.recommendation.incoming.tpl', '15.9', 0),
('748258db71c382f78aa535eb7d136c87', './templates/activity/tiki.tracker.create.tpl', '15.9', 0),
('86c8ba04daf8bd992903530af8a01f53', './templates/activity/tiki.trackeritem.create.tpl', '15.9', 0),
('0b57a2638d8cc3066ec1c3f59d289f3a', './templates/activity/tiki.trackeritem.update.tpl', '15.9', 0),
('0e665e0873c88b2fd9504c46e97ad82c', './templates/activity/tiki.user.follow.add.tpl', '15.9', 0),
('77490102a3675d9fed0a518d981c7d5c', './templates/activity/tiki.user.follow.incoming.tpl', '15.9', 0),
('30c00cbe62e47516be0590006d60f610', './templates/activity/tiki.user.friend.add.tpl', '15.9', 0),
('9bea8d48c0a54f873a8524a018cca99f', './templates/activity/tiki.wiki.create.tpl', '15.9', 0),
('49f53589a30efc5480271769350ba92f', './templates/activity/tiki.wiki.update.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/activitystream/index.php', '15.9', 0),
('1aa2262eda5821e694be8885708689b0', './templates/activitystream/render.tpl', '15.9', 0),
('51e3711a01930e83f6ef72f82042efc3', './templates/addreference.tpl', '15.9', 0),
('174ab3a97db9fc908066963c66551308', './templates/admin/admin_navbar.tpl', '15.9', 0),
('7b1d541c92b674f24ad9c8e7a50e5410', './templates/admin/admin_navbar_menu.tpl', '15.9', 0),
('408723f5d586ae0838fe2f4010b9f946', './templates/admin/include_ads.tpl', '15.9', 0),
('8a22dbe6abd3f9cc9a11df1e34882892', './templates/admin/include_anchors.tpl', '15.9', 0),
('38cd2d265898ddc8de501039929a5277', './templates/admin/include_articles.tpl', '15.9', 0),
('808ed03fed0800933bf2f2d5e99b81b3', './templates/admin/include_blogs.tpl', '15.9', 0),
('db61bbe3b0cbfbd56b7bf04e8a966d63', './templates/admin/include_calendar.tpl', '15.9', 0),
('2382a4a8c80782c11c19fde9aeb61b0d', './templates/admin/include_category.tpl', '15.9', 0),
('6648fde925c38fe7cfd16d2ae34b2c3a', './templates/admin/include_comments.tpl', '15.9', 0),
('0d191d65adc5b5b29358713935b7bcbc', './templates/admin/include_community.tpl', '15.9', 0),
('c29d902914c91b20cba4a34266a1a288', './templates/admin/include_connect.tpl', '15.9', 0),
('28a5d7723004b6f363c7e9dd50a612db', './templates/admin/include_copyright.tpl', '15.9', 0),
('78f5c9f7f66706e129aa161a9fc0be96', './templates/admin/include_directory.tpl', '15.9', 0),
('bee25b9ecf9a5469cfd47b6d76089f04', './templates/admin/include_faqs.tpl', '15.9', 0),
('a65af49c0683d85601122783d9cf0e25', './templates/admin/include_features.tpl', '15.9', 0),
('7a31470a6817e4e8b32943321d20d841', './templates/admin/include_fgal.tpl', '15.9', 0),
('612a28c2e2a922bd8ca23fca7d5b6287', './templates/admin/include_forums.tpl', '15.9', 0),
('b7a667221474098741beb7ee6036ee07', './templates/admin/include_freetags.tpl', '15.9', 0),
('cc945b042579b713fc28e84832d631c9', './templates/admin/include_gal.tpl', '15.9', 0),
('1cd032f5f01576cb28afe17930f89c56', './templates/admin/include_general.tpl', '15.9', 0),
('552f3025bad2bf040f9a85fe868b6971', './templates/admin/include_i18n.tpl', '15.9', 0),
('4ca99a3799ea8c3e25b6d253e863f836', './templates/admin/include_intertiki.tpl', '15.9', 0),
('ecd1fc6c742bd937344aa76a9172b305', './templates/admin/include_list_sections.tpl', '15.9', 0),
('980501de2f8bec275833e2b5bb1edecb', './templates/admin/include_login.tpl', '15.9', 0),
('79b5708fa365de9009884e99548509b6', './templates/admin/include_look.tpl', '15.9', 0),
('5138d163df611a6714868a887c082394', './templates/admin/include_maps.tpl', '15.9', 0),
('d71b01d749fdd0d1524da89e82e0b7de', './templates/admin/include_messages.tpl', '15.9', 0),
('f276cefcb8a786836dcf793db31925ba', './templates/admin/include_metatags.tpl', '15.9', 0),
('0f1a902960cb9d840b9f7ec40b47791a', './templates/admin/include_module.tpl', '15.9', 0),
('46bf871288c0dfa370daceb17ef89c7c', './templates/admin/include_payment.tpl', '15.9', 0),
('82783442218f3b0615a26f7d77743939', './templates/admin/include_performance.tpl', '15.9', 0),
('0ffcbddfcb6e5846bea4812d025b4b97', './templates/admin/include_polls.tpl', '15.9', 0),
('a6063b5195d674747f07e4179fe009bc', './templates/admin/include_profiles.tpl', '15.9', 0),
('9ebffd7339a7a8fcbff38791acd3296d', './templates/admin/include_rating.tpl', '15.9', 0),
('e2e681dba5232b5ab2c17e091f2e5cde', './templates/admin/include_rss.tpl', '15.9', 0),
('4536f4ae44161dffb4cb14c741a0e194', './templates/admin/include_score.tpl', '15.9', 0),
('435f12e126c630879a4839cf1b7d382b', './templates/admin/include_search.tpl', '15.9', 0),
('5977b93e8d72b2ad74391c177e8842ff', './templates/admin/include_security.tpl', '15.9', 0),
('3dd4a699d0cbae546b8699d2ee1cb111', './templates/admin/include_sefurl.tpl', '15.9', 0),
('7282c4b78c9dfb278110337ec775d0d4', './templates/admin/include_semantic.tpl', '15.9', 0),
('6491f90c0025ede37c29d78619f24eee', './templates/admin/include_share.tpl', '15.9', 0),
('534409ce21691b44913a0b6c024de8f8', './templates/admin/include_socialnetworks.tpl', '15.9', 0),
('9a695df024d617871ecbc5954e8e2f83', './templates/admin/include_stats.tpl', '15.9', 0),
('d5e05159c2cd0488700069e426e3cc40', './templates/admin/include_textarea.tpl', '15.9', 0),
('dbecba55aa2cacc8b51f9fd7e3fe5256', './templates/admin/include_trackers.tpl', '15.9', 0),
('5c973cfd2c0b302464235cccbc209bf0', './templates/admin/include_userfiles.tpl', '15.9', 0),
('b9b5781cf2da8d7067d3b1f97896ed85', './templates/admin/include_video.tpl', '15.9', 0),
('edaa3e0a52173658c44a6d74b5fd8c04', './templates/admin/include_webmail.tpl', '15.9', 0),
('b8e801d7a60bb51dfe62ad4d845e09a2', './templates/admin/include_webservices.tpl', '15.9', 0),
('313053040e9a6c20022de8ea56d14b87', './templates/admin/include_wiki.tpl', '15.9', 0),
('f22ac16bb6540d1b34edc0bc73d07a08', './templates/admin/include_wikiatt.tpl', '15.9', 0),
('22178c25036ddcafa9a5d1ca206e0431', './templates/admin/include_workspace.tpl', '15.9', 0),
('b75d4d7089eb3435862b2cc2d33d890e', './templates/admin/include_wysiwyg.tpl', '15.9', 0),
('80b22f1cdc1770c325a9cf777d4be4ac', './templates/admin/index.php', '15.9', 0),
('4897f6b2c0cf07288808559120d6d6b5', './templates/admin_modules_form.tpl', '15.9', 0),
('1dc835968c74b1bc27a52c6c8a1e2865', './templates/antibot.tpl', '15.9', 0),
('ad040e7ced6eb5286be4a2fc3c85f632', './templates/article-teaser.tpl', '15.9', 0),
('b3c7d719310188177d42a378bc320c92', './templates/article.tpl', '15.9', 0),
('f4ed516e008f1600ea424ad8fc6e295d', './templates/article/create_from_url.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/article/index.php', '15.9', 0),
('0c563895107f0703f27b0234abec7458', './templates/article_trailer.tpl', '15.9', 0),
('54dfd1877d9bbf107b0bdeae61748964', './templates/attachments.tpl', '15.9', 0),
('711520b35cb83401c99369773e80ae34', './templates/attachments_tracker.tpl', '15.9', 0),
('5bd10467f55034236ad34ac39ead6032', './templates/blog_actions.tpl', '15.9', 0),
('d85e80541ff6be073e8c103609f626dd', './templates/blog_heading.tpl', '15.9', 0),
('5d1d99b4731a9e4c9d0cb92accba4f38', './templates/blog_post_actions.tpl', '15.9', 0),
('759e58707b6e22cc56631da90a8089f0', './templates/blog_post_author_info.tpl', '15.9', 0),
('83bd4887da4a44a2f7b3e5a26a59fb2a', './templates/blog_post_heading.tpl', '15.9', 0),
('062c39e8aeea9eb6ddfeb521f9b6172e', './templates/blog_post_navigation.tpl', '15.9', 0),
('4023ed23d22d8d58b6048df3446397f8', './templates/blog_post_postbody_content.tpl', '15.9', 0),
('2c238daf75ea1edc29b1f2d3a04dbac7', './templates/blog_post_postbody_title.tpl', '15.9', 0),
('e99aebc4a6ec8bde4e079a7422719b11', './templates/blog_post_related_content.tpl', '15.9', 0),
('70346099ee2e19b16ff891a45edf2cc2', './templates/blog_post_status.tpl', '15.9', 0),
('e53ffcf2833f85611420b12aa26351d2', './templates/blog_wrapper.tpl', '15.9', 0),
('e233e89b10a250d8797cc809b405a98e', './templates/bootstrap_menu.tpl', '15.9', 0),
('c3405bb4d217386aae5fce15af94e1ee', './templates/bootstrap_menu_navbar.tpl', '15.9', 0),
('e9294cbce30de287f8651fa8f966aa84', './templates/browse_file_gallery.tpl', '15.9', 0),
('3517f3ad069aa56cf54649907f186aa6', './templates/browsedcategory.tpl', '15.9', 0),
('69a2656bc51def67de26fb575ba026aa', './templates/calendar.tpl', '15.9', 0),
('89295aeb4ebc7ef2d3e3a045c13603fa', './templates/canonical.tpl', '15.9', 0),
('c2993a01ae6b5328f7f0399aae6203e4', './templates/categobjects.tpl', '15.9', 0),
('6a70b34d941f9d219e4d15d3e8c0c463', './templates/categobjects_title.tpl', '15.9', 0),
('3dae1ebedfa5d67e2cf35e10768871e6', './templates/categorize.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/category/index.php', '15.9', 0),
('9c1c640b10412583aedacbf3d703ecef', './templates/category/select.tpl', '15.9', 0),
('b6c2ca45cf2dfe75d2206237834c089c', './templates/category_related_objects.tpl', '15.9', 0),
('1a382ef4ecbdbd9d3a5c4d945a6d49b5', './templates/category_tree_entry.tpl', '15.9', 0),
('0ea45b926f348c5663b959a6bda9ddde', './templates/categpath.tpl', '15.9', 0),
('98275a3681995cd38e9998c92a3ddefe', './templates/comment-body.tpl', '15.9', 0),
('a8caa1ace826c0c9b8ab2b84544c8181', './templates/comment-footer.tpl', '15.9', 0),
('37bff4098ac2cc0f3098fda46e070593', './templates/comment-header.tpl', '15.9', 0),
('58d80ff9d1458f85a0a91316db576b1e', './templates/comment.tpl', '15.9', 0),
('2974492da348696adfeb4ba0613cf61e', './templates/comment/archive.tpl', '15.9', 0),
('01f6da3b5983b90524d5b4accd11f643', './templates/comment/deliberation_item.tpl', '15.9', 0),
('54f4ee43db8dc872b0be192e933e1c1c', './templates/comment/edit.tpl', '15.9', 0),
('80b22f1cdc1770c325a9cf777d4be4ac', './templates/comment/index.php', '15.9', 0),
('ed48c9224b743acc1db87fbc6ae3c54a', './templates/comment/list.tpl', '15.9', 0),
('304d16177c6068779f0c60e1b12b17ff', './templates/comment/list_inner.tpl', '15.9', 0),
('9c0f1ae6c0286746df58765f06a394eb', './templates/comment/lock.tpl', '15.9', 0),
('a2aeee16f232421dfdfd759eeb5a9916', './templates/comment/moderate.tpl', '15.9', 0),
('61806ecdd9b51b5fe685f23f352d3b2e', './templates/comment/post.tpl', '15.9', 0),
('3f634a10c725a670e35ea501d741ee35', './templates/comment/remove.tpl', '15.9', 0),
('ce3ade7c41576d05abb8b51f510efc0f', './templates/comment/unlock.tpl', '15.9', 0),
('9fff8f196184ab09d7b574f46bb7ddd3', './templates/comments.tpl', '15.9', 0),
('2567a9ae8ec2c83776599aa102aaaade', './templates/comments_button.tpl', '15.9', 0),
('98f217cd0c9b3307cdbe726636b30e7d', './templates/confirm.tpl', '15.9', 0),
('bef708249a00ef05cf3a276964cbce2b', './templates/contribution.tpl', '15.9', 0),
('1397a1340c345b9809b1246e6ae15ab0', './templates/cookie_consent.tpl', '15.9', 0),
('768fa1004df7ab3218c8e5e0c4296113', './templates/copyrights.tpl', '15.9', 0),
('01d9ae9feccdb83bcd89557209b1be66', './templates/credits.tpl', '15.9', 0),
('536208aa49dd567c5e2cddc0cce2a454', './templates/database-connection-error.tpl', '15.9', 0),
('788d7a82c6ffc2523bc43ef913a39582', './templates/debug/function.debugger.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/debug/index.php', '15.9', 0),
('d190ed7eff43ccfcb1858ba69cfaa4a3', './templates/debug/tiki-debug_console_help.tpl', '15.9', 0),
('f7f27f7a13a5dd2414d65d8d51d24912', './templates/debug/tiki-debug_console_tab.tpl', '15.9', 0),
('9e7b0dffba1e63527506e47f874e9db5', './templates/debug/tiki-debug_dmsg_tab.tpl', '15.9', 0),
('57cfad32d4933c4ff7117eb4640a2d07', './templates/debug/tiki-debug_features.tpl', '15.9', 0),
('918e4a2b9693b31ef7f9943a2f6000bf', './templates/debug/tiki-debug_permissions.tpl', '15.9', 0),
('2b8f92d5dac6ef268d31b8d18095c808', './templates/debug/tiki-debug_tikitables.tpl', '15.9', 0),
('c3ca76dda883b552de443a6a5bbaea59', './templates/debug/tiki-debug_watch_tab.tpl', '15.9', 0),
('b99c4cb1b4bab785233f35985aa82d93', './templates/discussinforum.tpl', '15.9', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/draw/edit.tpl', '15.9', 0),
('80b22f1cdc1770c325a9cf777d4be4ac', './templates/draw/index.php', '15.9', 0),
('3e5b8faa383467560348d7829f94ee16', './templates/duplicate_file_gallery.tpl', '15.9', 0),
('78b5dfb4673dc47e7f3b8aeeeae04653', './templates/edit/help.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/edit/index.php', '15.9', 0),
('f18d61532ac42e33c5f4d509e2d126aa', './templates/edit/inline_dialog.tpl', '15.9', 0),
('0cb34a9c701cf012b604071bb13fa4a0', './templates/edit/preview.tpl', '15.9', 0),
('e8ffdb7fcbf8ca780b712ffb68e4a7e7', './templates/edit_file_gallery.tpl', '15.9', 0),
('e2e2eac02523daf4ae52dd9d03ed186a', './templates/error-ajax.tpl', '15.9', 0),
('a108563c47d0e81ead47db820e9acb92', './templates/error.tpl', '15.9', 0),
('6b89c898bb7a12b2ee1569985d41e29f', './templates/error_raw.tpl', '15.9', 0),
('9200575eadcef8e415e664524bfeea76', './templates/error_simple.tpl', '15.9', 0),
('6748781529b8f111c8ec6449c35ce4d1', './templates/error_ticket.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/examples/index.php', '15.9', 0),
('11262767bc39106197f582a99029fdfd', './templates/examples/shop/add_to_cart.tpl', '15.9', 0),
('476908f101e91fec2c4c0fbc10567f2e', './templates/examples/shop/custom_search_form.tpl', '15.9', 0),
('5d724414d8e70e97907119f4d2f7976d', './templates/examples/shop/index.php', '15.9', 0),
('5ade29ec5b7c45d531379d23031bf847', './templates/examples/shop/product_ajax.tpl', '15.9', 0),
('b65aa5f03d9b30d5983972c524e39464', './templates/examples/shop/product_item.tpl', '15.9', 0),
('3cea5f4a3a65ff14803d605b7255024d', './templates/examples/shop/product_list.tpl', '15.9', 0),
('10dd5e875973462cbdd10872b682b50a', './templates/examples/shop/product_list_inner.tpl', '15.9', 0),
('3ba890fac44d5157774545b40a36d539', './templates/fgal_attachments.tpl', '15.9', 0),
('31689e01b53ffc52b2309aa2b54ece13', './templates/fgal_context_menu.tpl', '15.9', 0),
('69f4aba65154334db83994b38ccbc405', './templates/fgal_listing_conf.tpl', '15.9', 0),
('6681a3970582ec4f91585cd2272efa54', './templates/file/browse.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/file/index.php', '15.9', 0),
('6ae27e61df7a0fd66756499a9b4a236d', './templates/file/jquery_upload.tpl', '15.9', 0),
('6c86cb931d3f7755c9481d58504c53e3', './templates/file/list_gallery.tpl', '15.9', 0),
('89f637b46a67a971a990230fdfe9e5f9', './templates/file/remote.tpl', '15.9', 0),
('9702a0adb6a257721f3c2e5eb35593b1', './templates/file/thumbnail_gallery.tpl', '15.9', 0),
('5b40a0a10a7d5c57981f5ac682c02346', './templates/file/upload.tpl', '15.9', 0),
('eb06df21ac89e8cff62c88c62e52aecc', './templates/file/uploader.tpl', '15.9', 0),
('77b4d9e5ed0e9f3e9837d21bdf3c2e4d', './templates/file_backlinks.tpl', '15.9', 0),
('2bf05f4ef86a38c3d89a0055500a3cb8', './templates/file_gallery_slideshow.tpl', '15.9', 0),
('e085cd36608814c52902e1714b08f1af', './templates/file_selector.tpl', '15.9', 0),
('82652cb2f5edeb5c847596fe87f688a5', './templates/filter.tpl', '15.9', 0),
('0501a5b7dc88fb329bf721b0ccb6ad89', './templates/filter_control/date_range.tpl', '15.9', 0),
('6765128101b2d445830b1403831d00d2', './templates/filter_control/drop_down.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/filter_control/index.php', '15.9', 0),
('bf80d8e4ce3985575ce165a0e03278c8', './templates/filter_control/inline_checkboxes.tpl', '15.9', 0),
('a4a0ac9404a3b6f1fcb174aec8dc3bfe', './templates/filter_control/multi_select.tpl', '15.9', 0),
('57fa26807cfee5f38171acf843b24620', './templates/filter_control/text_field.tpl', '15.9', 0),
('9809e4282ce45543a264d26f5f024cf0', './templates/find.tpl', '15.9', 0),
('472699ba9c040d350740afd8db255b44', './templates/footer.tpl', '15.9', 0),
('407d68e8c9f141d7bf1b42724a212e71', './templates/freetag.tpl', '15.9', 0),
('fe9eeb161c02b603c32945682f939468', './templates/freetag_list.tpl', '15.9', 0),
('bcc2e9185743a6fdb2842472795bf730', './templates/goal/admin.tpl', '15.9', 0),
('071a534416a1c54ca39a4658047f0bea', './templates/goal/create.tpl', '15.9', 0),
('02a5cca262e2162054fd8546ed1a6a0d', './templates/goal/delete.tpl', '15.9', 0),
('99da39e2faaab5872b03cfacd98dc610', './templates/goal/edit.tpl', '15.9', 0),
('707173932ef488a6d404be80306be208', './templates/goal/edit_condition.tpl', '15.9', 0),
('fcbc6c543cf87566082b07b328dc3a09', './templates/goal/edit_eligible.tpl', '15.9', 0),
('0360b531f8c3e9df482036adb54a2995', './templates/goal/edit_reward.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/goal/index.php', '15.9', 0),
('add972a81be9c53a328410e06508a12b', './templates/goal/render_conditions.tpl', '15.9', 0),
('42d5f2001a36f78a4c10c76f9edd915c', './templates/goal/render_rewards.tpl', '15.9', 0),
('f488bb35657db81d7a1061e6d78799d1', './templates/goal/show.tpl', '15.9', 0),
('3433b7eb285eafc427d3c032f79de373', './templates/goal/show_list.tpl', '15.9', 0),
('394d348ce40a81c9a66c4eaada2a9395', './templates/header.tpl', '15.9', 0),
('5d724414d8e70e97907119f4d2f7976d', './templates/index.php', '15.9', 0),
('b10dad33f46c0e59e56c2723d8fee07f', './templates/interactive_translation_box.tpl', '15.9', 0),
('19a3311c7d9b1e475def5167a7f51205', './templates/jcapture/capture.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/jcapture/index.php', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/kaltura/index.php', '15.9', 0),
('b891e2c5325bf17288bd0019122ffbc5', './templates/kaltura/list.tpl', '15.9', 0),
('5911f108e16875cb10a060c4a35f6723', './templates/kaltura/upload.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/language/index.php', '15.9', 0),
('d85f6538ed90ca60e7cbd88110152d6f', './templates/language/manage_custom_php_translations.tpl', '15.9', 0),
('88617f9e9a9fbdf60b69f7b68abc1013', './templates/language/select_language.tpl', '15.9', 0),
('d65a5257494d5648e598448898f20b0b', './templates/language/upload.tpl', '15.9', 0),
('103bd00d61260eb12e24bf0982ab39e7', './templates/language/write_to_language_php.tpl', '15.9', 0),
('84195582005a8a3c65998db904da82fa', './templates/layout_fullscreen_check.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/layouts/basic/index.php', '15.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/basic/layout_edit.tpl', '15.9', 0),
('e50c97bdcd1afb8a1285f0b184e078fa', './templates/layouts/basic/layout_view.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/layouts/classic/index.php', '15.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/classic/layout_edit.tpl', '15.9', 0),
('89b087670161d596fe6b11c1f8aacdb8', './templates/layouts/classic/layout_view.tpl', '15.9', 0),
('7439ddea8343fd9bdcc57c808501db93', './templates/layouts/classic/module.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/layouts/fixed_top_modules/index.php', '15.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/fixed_top_modules/layout_edit.tpl', '15.9', 0),
('be0ffbeb306877c16a7d507b05aeb9ae', './templates/layouts/fixed_top_modules/layout_view.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/layouts/header_middle_footer_containers_3-6-3/index.php', '15.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/header_middle_footer_containers_3-6-3/layout_edit.tpl', '15.9', 0),
('33deb3b9ee3cad270565db9256066953', './templates/layouts/header_middle_footer_containers_3-6-3/layout_view.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/layouts/index.php', '15.9', 0),
('8e9f7c0874fe71f493a259d1f1fa5e8a', './templates/layouts/internal/ajax.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/layouts/internal/index.php', '15.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/internal/layout_edit.tpl', '15.9', 0),
('7a420c58dacd8c14f0e4c5b7937dde3c', './templates/layouts/internal/layout_view.tpl', '15.9', 0),
('7e3591cff7cee25128e27f06ac970f02', './templates/layouts/internal/modal.tpl', '15.9', 0),
('b4f822db7ffdd18bfb247e7351dd7b9e', './templates/layouts/layout_plain.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/layouts/social/index.php', '15.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/social/layout_edit.tpl', '15.9', 0),
('71cf1436dcd11682f8c4b44186670948', './templates/layouts/social/layout_view.tpl', '15.9', 0),
('e0cf1776f33ca56f054a92e8b6c8ef5a', './templates/like.tpl', '15.9', 0),
('292b95ab2f2aee3109bfad9e63e943b4', './templates/list_file_gallery.tpl', '15.9', 0),
('387b8dc99867489518c9f0f6e11c3c7d', './templates/list_file_gallery_content.tpl', '15.9', 0),
('270f3ec9e8bb0dc2a2d5891e6320e8dc', './templates/lists/article-search.tpl', '15.9', 0),
('660283d28af7f4414f55bf223929101a', './templates/lists/articles.tpl', '15.9', 0),
('8b6028e5c91ff235343aa7d53880d271', './templates/mail/admin_add_user_joins_group_notification.tpl', '15.9', 0),
('505505cef146cb4947babf625447a59e', './templates/mail/admin_add_user_joins_group_notification_subject.tpl', '15.9', 0),
('61ddf8a018bef6790362b72663f07347', './templates/mail/admin_approval_user_joins_group_notification.tpl', '15.9', 0),
('525e85198fa566eb9247191dbd3203d0', './templates/mail/admin_approval_user_joins_group_notification_subject.tpl', '15.9', 0),
('2161075685e22732b4344644c9c854f8', './templates/mail/admin_rejection_user_group_notification.tpl', '15.9', 0),
('cb538440bcb632b020e157f7a66c4287', './templates/mail/admin_rejection_user_group_notification_subject.tpl', '15.9', 0),
('6c9a27be9c5c54019c4ed705d3264afe', './templates/mail/admin_remove_user_group_notification.tpl', '15.9', 0),
('4b0112ab1c2b4bfbf369777b210f9db5', './templates/mail/admin_remove_user_group_notification_subject.tpl', '15.9', 0),
('4b68269098aca2c93adb17a2adf5db7d', './templates/mail/blogs_send_link.tpl', '15.9', 0),
('e718393ab561898f4429ecf1a200e75b', './templates/mail/cart_gift_cert.tpl', '15.9', 0),
('e198805eb37e894e999cdb5ef648f539', './templates/mail/cart_gift_cert_subject.tpl', '15.9', 0),
('94bcf03bebec09cfaf31f012db28f625', './templates/mail/cart_order_received_anon.tpl', '15.9', 0),
('2ca9137a8f0014e7aefaaebaa868d6d7', './templates/mail/cart_order_received_anon_subject.tpl', '15.9', 0),
('811f08e98a17d840eb99e47b803c11c7', './templates/mail/cart_order_received_reg.tpl', '15.9', 0),
('923db1b975a962ece0ce61b0d214bb79', './templates/mail/cart_order_received_reg_subject.tpl', '15.9', 0),
('d21ba8af4fc81197d17baecc414552e3', './templates/mail/confirm_newsletter_subscription.tpl', '15.9', 0),
('b7ea941dd53e4602978ecc0e9433690a', './templates/mail/confirm_user_email.tpl', '15.9', 0),
('1162fa30826d786f7ff71f3d297ff2a0', './templates/mail/confirm_user_email_after_approval.tpl', '15.9', 0),
('d511d698795e012e11a2a276be21cb3a', './templates/mail/confirm_user_email_after_approval_subject.tpl', '15.9', 0),
('232cc5a0b579ff26a4fe01440709cdd1', './templates/mail/confirm_user_email_subject.tpl', '15.9', 0),
('5535e75f3459d1e48f9ffc645c274243', './templates/mail/fgal_old_file_deleted.tpl', '15.9', 0),
('2291928cf2d16c79e25d722e845ab550', './templates/mail/fgal_quota_exceeded.tpl', '15.9', 0),
('d539d599f2745b4eec74f0ac668fce89', './templates/mail/forum_outbound.tpl', '15.9', 0),
('42c7d49eeb975c646ff6b5d19c8b9736', './templates/mail/forum_post_notification.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/mail/index.php', '15.9', 0),
('f7265822802cab7cfd18a8d77def039e', './templates/mail/invite_tempuser.tpl', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('38f029db22b43d145d7eae800343c65a', './templates/mail/invite_tempuser_subject.tpl', '15.9', 0),
('8d16d55a2d60e1a3c8e310b6a6cde7c9', './templates/mail/mail_invite.tpl', '15.9', 0),
('749c670dd90182d92ccd4593c3b23ad0', './templates/mail/mail_invite_subject.tpl', '15.9', 0),
('6010fee21ba9a73fbec63b42339d09c6', './templates/mail/mailin_reply_subject.tpl', '15.9', 0),
('dfb0b86639fde0cc83d5eb9bddddd369', './templates/mail/messu_message_notification.tpl', '15.9', 0),
('49a85c2ecf56a814ea36d2323cbe888b', './templates/mail/messu_message_notification_subject.tpl', '15.9', 0),
('2a6aeb155486dfee1536672cc2388f5e', './templates/mail/moderate_activation_mail.tpl', '15.9', 0),
('8faeb5c5137392647a39b225e29068ab', './templates/mail/moderate_activation_mail_subject.tpl', '15.9', 0),
('ced2805a7e0d3d490862773b0c1b8cac', './templates/mail/moderate_validation_mail.tpl', '15.9', 0),
('3797a9b218dd4b670974b987625c1b3c', './templates/mail/moderate_validation_mail_subject.tpl', '15.9', 0),
('bdb747059d66299c537181be09959f2e', './templates/mail/new_friend_invitation.tpl', '15.9', 0),
('73e38d95d4f3335119d9341921f7c462', './templates/mail/new_friend_invitation_subject.tpl', '15.9', 0),
('e43951b70035d874ee9995ac7f364266', './templates/mail/new_user_notification.tpl', '15.9', 0),
('ea46a79b68cb297607aca7abb4191a0a', './templates/mail/new_user_notification_subject.tpl', '15.9', 0),
('874815b500a7bf268442d3b740199317', './templates/mail/newsletter_articleclip.tpl', '15.9', 0),
('e9a7638982cafe0994142117f1af9b43', './templates/mail/newsletter_byebye.tpl', '15.9', 0),
('943e66254b7171b9429febae4d9562f1', './templates/mail/newsletter_byebye_subject.tpl', '15.9', 0),
('5b7f275907d103c4ce5ba75b1cab326a', './templates/mail/newsletter_unsubscribe.tpl', '15.9', 0),
('5ab7f765116c38744b1170ebaacabc8f', './templates/mail/newsletter_welcome.tpl', '15.9', 0),
('78633f842690ba76e4418c4b3a33e80a', './templates/mail/newsletter_welcome_subject.tpl', '15.9', 0),
('f99f021c0158f83b702c2447cb2b0402', './templates/mail/notification_subject.tpl', '15.9', 0),
('a534cc77f492624b54a100be4f9d47b9', './templates/mail/password_reminder.tpl', '15.9', 0),
('d5d0a88faa4fcb7f90974475fb8be20d', './templates/mail/password_reminder_subject.tpl', '15.9', 0),
('7fdfc9aaabaeace9b770f101984d1a4d', './templates/mail/plugin_pending_notification.tpl', '15.9', 0),
('822f3c367ad54a5ebb568f0818b323c8', './templates/mail/report.tpl', '15.9', 0),
('cf6d3dd5675aa04b0acf9123fb14d6df', './templates/mail/rss_new_source_category.tpl', '15.9', 0),
('bd753b8fc6e836ca2e5b3d3dd0f2c248', './templates/mail/rss_new_source_category_subject.tpl', '15.9', 0),
('12135709028d7cf4e468f1bdd7b282cd', './templates/mail/share.tpl', '15.9', 0),
('b9b700d5c77ce37097202bbc21c0d811', './templates/mail/share_subject.tpl', '15.9', 0),
('4b2c8d5de4d90862252980e7b4b6913c', './templates/mail/submission_notification.tpl', '15.9', 0),
('1c2e9389a8d6486a70e224703286d0cb', './templates/mail/submission_notification_subject.tpl', '15.9', 0),
('984b2420d4a81e5bf65d6bdb25ee200e', './templates/mail/tellAFriend.tpl', '15.9', 0),
('60716e88c25726944fd13de5ae593db6', './templates/mail/tellAFriend_subject.tpl', '15.9', 0),
('647983118dcd1819938c96404982bc6f', './templates/mail/tracker_changed_notification.tpl', '15.9', 0),
('422e2e50be8e05c7772ff58f3e8da44a', './templates/mail/tracker_changed_notification_subject.tpl', '15.9', 0),
('62502b077e17b3b382716c5cff478f33', './templates/mail/unsuccessful_logins.tpl', '15.9', 0),
('51c0ce2b3393dedfc134c137784d1469', './templates/mail/unsuccessful_logins_subject.tpl', '15.9', 0),
('6ea080f3f955406fe87cd9e4a86c198f', './templates/mail/unsuccessful_logins_suspend.tpl', '15.9', 0),
('e9a9222ef5fa02d8cbaefa6d0576bd07', './templates/mail/unsuccessful_logins_suspend_subject.tpl', '15.9', 0),
('d32c777318eee0b7655df106678b254c', './templates/mail/user_creation_validation_mail.tpl', '15.9', 0),
('5180087ae83025958ca260e98e75c134', './templates/mail/user_creation_validation_mail_subject.tpl', '15.9', 0),
('937771c31edd16c9b01a4b89a39c3acb', './templates/mail/user_joins_group_notification.tpl', '15.9', 0),
('7ade3101f67723c92dc48508aa30a957', './templates/mail/user_joins_group_notification_subject.tpl', '15.9', 0),
('181725cfee4dbe5d369621dfbacccbc9', './templates/mail/user_joins_group_notification_to_leads.tpl', '15.9', 0),
('0065f7af5318a010e9287e7bae7b1e44', './templates/mail/user_joins_group_notification_to_leads_need_app.tpl', '15.9', 0),
('eccf0eeb7e97667f831fc2747b363e4e', './templates/mail/user_joins_group_notification_to_leads_subject.tpl', '15.9', 0),
('6f96ee70e65787f786412e37ccc09793', './templates/mail/user_left_group_notification_to_leads.tpl', '15.9', 0),
('0ab1f0e86f2de32f2446d31835539166', './templates/mail/user_left_group_notification_to_leads_subject.tpl', '15.9', 0),
('4e1751a581650fe982afb37124cea2a8', './templates/mail/user_validation_mail.tpl', '15.9', 0),
('a702fd00e744c0b3c7eff94f0a7b104b', './templates/mail/user_validation_mail_subject.tpl', '15.9', 0),
('eaab8bb947ab04c4599bb17c549b66b9', './templates/mail/user_validation_msg.tpl', '15.9', 0),
('8e90f01e651163d041a51697131ef136', './templates/mail/user_validation_waiting_msg.tpl', '15.9', 0),
('6bd269d8e624c450692f485b8171f69d', './templates/mail/user_watch_article_post.tpl', '15.9', 0),
('7384a37f4eee4fa8ba9838d0fa3dd7a9', './templates/mail/user_watch_article_post_subject.tpl', '15.9', 0),
('4960883337ff4b11c2cb35e8d9295384', './templates/mail/user_watch_blog_post.tpl', '15.9', 0),
('46b17ee32e251a31d5d8bf6dbc8f4b0d', './templates/mail/user_watch_blog_post_subject.tpl', '15.9', 0),
('0a3bc971d8c5ef27e4abe09077409b62', './templates/mail/user_watch_calendar.tpl', '15.9', 0),
('ae44d682709678d380b5c978aaf80d68', './templates/mail/user_watch_calendar_subject.tpl', '15.9', 0),
('a9681c257345ca9f61bfcbe5647144c0', './templates/mail/user_watch_category_changed_subject.tpl', '15.9', 0),
('0a4fe97126826f8800d68fcc092bf2ac', './templates/mail/user_watch_category_created.tpl', '15.9', 0),
('b9a00482202a7b45e37e1d4367e9f72a', './templates/mail/user_watch_category_created_subject.tpl', '15.9', 0),
('984710722fa9df3f2bbe17ccdcaf48ec', './templates/mail/user_watch_category_removed.tpl', '15.9', 0),
('ca156ddcd94c5c00be7426fb842df352', './templates/mail/user_watch_category_removed_subject.tpl', '15.9', 0),
('deb4d3f71c6f72fae655fa663503cb04', './templates/mail/user_watch_category_updated.tpl', '15.9', 0),
('38a2d1b18057df8bb08172fa7579d1f6', './templates/mail/user_watch_category_updated_subject.tpl', '15.9', 0),
('72048b9b8d11c30ecf6f171a107d3897', './templates/mail/user_watch_comment.tpl', '15.9', 0),
('3d8c5a6b0d228234e7e61fd71e9c181a', './templates/mail/user_watch_comment_subject.tpl', '15.9', 0),
('a5260fdc7a00cdcfe1202803cc645ca9', './templates/mail/user_watch_file_gallery_changed_subject.tpl', '15.9', 0),
('80eac8ef50fb11070786ca38ac282cdb', './templates/mail/user_watch_file_gallery_remove_file.tpl', '15.9', 0),
('61f061c87f6bdc3c9ab25ca48fdd5c02', './templates/mail/user_watch_file_gallery_upload.tpl', '15.9', 0),
('1c415f35d68d8609bacbf8a34a30db1a', './templates/mail/user_watch_forum_subject.tpl', '15.9', 0),
('2463c3f744faaad17d6a19ff049248e6', './templates/mail/user_watch_image_gallery_changed_subject.tpl', '15.9', 0),
('5a8ea2715e005fe1ec2e7bd231598e75', './templates/mail/user_watch_image_gallery_upload.tpl', '15.9', 0),
('77cc069f779306f9eff8f4e36f6f0079', './templates/mail/user_watch_map_changed.tpl', '15.9', 0),
('6b2d02d74eff35117c45ab719ca0ed41', './templates/mail/user_watch_object_entered_category.tpl', '15.9', 0),
('a1c2a273d98fdb10d268e52b51310e27', './templates/mail/user_watch_object_entered_category_subject.tpl', '15.9', 0),
('3fa8ff0679a90108de25c37c8eab31cc', './templates/mail/user_watch_object_leaved_category.tpl', '15.9', 0),
('b2de5c14650ed226442437589a5e6a84', './templates/mail/user_watch_object_leaved_category_subject.tpl', '15.9', 0),
('e3ec4523169023f1fd89b070bb4ed5ca', './templates/mail/user_watch_structure.tpl', '15.9', 0),
('ebde54477204e515af89d2b6bc5d1e8e', './templates/mail/user_watch_structure_subject.tpl', '15.9', 0),
('2f86beff868f722219ec96fca958988e', './templates/mail/user_watch_token.tpl', '15.9', 0),
('d309e928e90676c9c4bd6c8ef905ef6a', './templates/mail/user_watch_wiki_new_attach.tpl', '15.9', 0),
('f6c96b0895fbde2a4db97c4f44fc49aa', './templates/mail/user_watch_wiki_new_attach_subject.tpl', '15.9', 0),
('3c9a46c2c59107254f2032da88c7aedb', './templates/mail/user_watch_wiki_page_changed.tpl', '15.9', 0),
('380d339847e68fed3ae9e69c671c6bc8', './templates/mail/user_watch_wiki_page_changed_subject.tpl', '15.9', 0),
('92d500a2be13f37ba7dac2c629325997', './templates/mail/user_watch_wiki_page_renamed.tpl', '15.9', 0),
('29f04392b72d4ea07963ecc6a773f1d5', './templates/mail/user_watch_wiki_page_renamed_subject.tpl', '15.9', 0),
('9620b319f37cdf724891b7118f138077', './templates/mail/user_welcome_msg.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/mailin/index.php', '15.9', 0),
('58f10c3bc5d1cccba21452336fd98230', './templates/mailin/remove_account.tpl', '15.9', 0),
('9ec33cdcc2be2fda22a153a93ed26fe5', './templates/mailin/replace_account.tpl', '15.9', 0),
('ff3580e8a1fb84342a234c62c4ed1715', './templates/managestream/advanced.tpl', '15.9', 0),
('f5b41f1c0b993a6dabf14b0cbce64150', './templates/managestream/change_rule_status.tpl', '15.9', 0),
('67a0254a412e9177697856855995ffbd', './templates/managestream/change_rule_type.tpl', '15.9', 0),
('2a95a8f2e7b8afe6101a2f497b2441fb', './templates/managestream/delete.tpl', '15.9', 0),
('96175af3ed5904709cc1e12c9d2ffeba', './templates/managestream/deleteactivity.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/managestream/index.php', '15.9', 0),
('69fcc6cc010a9285a4202a068032308a', './templates/managestream/list.tpl', '15.9', 0),
('386ba98c66334133cd9d14e8b3bcf17e', './templates/managestream/record.tpl', '15.9', 0),
('91832c6dfa13b54c569d4d95912670da', './templates/managestream/sample.tpl', '15.9', 0),
('8877e8247c5949b1e1ca578233c4af1d', './templates/managestream/tracker_filter.tpl', '15.9', 0),
('ee58794828f3d6d489166456fe4a847f', './templates/menu/clone_menu.tpl', '15.9', 0),
('d13d6e08f2498dcb2e4d4337bbac2b51', './templates/menu/export_menu_options.tpl', '15.9', 0),
('073e02993bebec5ea9c1c9b6700b4224', './templates/menu/import_menu_options.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/menu/index.php', '15.9', 0),
('ac2d26d6a3bc33c4e481d0b4688b2917', './templates/menu/manage_menu.tpl', '15.9', 0),
('1fa5c90cdeaa9caa2670b1648bf1a0b7', './templates/messu-archive.tpl', '15.9', 0),
('7782dd6aee545baf401f0c3d625005cc', './templates/messu-broadcast.tpl', '15.9', 0),
('fa3cfc325f8945692ecbd38a3810c81f', './templates/messu-compose.tpl', '15.9', 0),
('c6846b0c8e4ebf7c88c4e4bb5ee67914', './templates/messu-download.tpl', '15.9', 0),
('266eb64def44e5da9e752f88e5fec950', './templates/messu-mailbox.tpl', '15.9', 0),
('48bda1be438fcdcb953cad2886c6a845', './templates/messu-nav.tpl', '15.9', 0),
('7c3bed11eef7b5cfb82f01c70a477853', './templates/messu-read.tpl', '15.9', 0),
('e312121780e62c8cf7229e7b958e9dc9', './templates/messu-read_archive.tpl', '15.9', 0),
('dd54e3fab23beed490004bac5dea5f32', './templates/messu-read_sent.tpl', '15.9', 0),
('313f27cc3fe288863011b6b5b1d1a9d6', './templates/messu-sent.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/metadata/index.php', '15.9', 0),
('8b117391164b42b91ea881010015c8a7', './templates/metadata/meta_view_dialog.tpl', '15.9', 0),
('7b489d3f0ea5ecb0366b34fe8232f05e', './templates/metadata/meta_view_tabs.tpl', '15.9', 0),
('fbad680e204e86168eea1778eb8422af', './templates/module.tpl', '15.9', 0),
('cf2a585b380575feeb10aafe003e3bc5', './templates/module/execute.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/module/index.php', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/modules/index.php', '15.9', 0),
('79075c2fb9c6fee700fa49d975c7382c', './templates/modules/mod-action_calendar.tpl', '15.9', 0),
('6c2aff25f579aeb9a608e667b9502833', './templates/modules/mod-action_similarcontent.tpl', '15.9', 0),
('759c57ee1c692ede22317934b15efbd1', './templates/modules/mod-addon.tpl', '15.9', 0),
('4f611a82b7edce39948e2bd8ad8f66bb', './templates/modules/mod-adsense.tpl', '15.9', 0),
('c97cd702e5a88e8a771f2c502fac67f2', './templates/modules/mod-article_archives.tpl', '15.9', 0),
('5a9fc19627c0ee11e688be0f7c1a826a', './templates/modules/mod-article_topics.tpl', '15.9', 0),
('374fb83b3d23c098a8586239d0d6fe82', './templates/modules/mod-articles.tpl', '15.9', 0),
('10ec7c7e7bfe2c73fe29826849c802b4', './templates/modules/mod-assistant.tpl', '15.9', 0),
('cf8b005690d15048282a2324b09dc2e9', './templates/modules/mod-blog_last_comments.tpl', '15.9', 0),
('6230bc0ddb847ea746d3ed54d19cdeb9', './templates/modules/mod-breadcrumb.tpl', '15.9', 0),
('e92ce1c54b19dbf3de64a2a8424fa649', './templates/modules/mod-breadcrumbs.tpl', '15.9', 0),
('7779562ab308c5d40160d3a667cbb436', './templates/modules/mod-calendar_new.tpl', '15.9', 0),
('9c41a13ec972f58ec04f132c802bf3f1', './templates/modules/mod-cart.tpl', '15.9', 0),
('86c5321466cdbbcc667f0721e094b302', './templates/modules/mod-categories.tpl', '15.9', 0),
('db062b8c593cfe73b804a44cdaa49175', './templates/modules/mod-category_transition.tpl', '15.9', 0),
('28ad87d139927c884c4275a5ac00ee12', './templates/modules/mod-change_category.tpl', '15.9', 0),
('cdefec0caf8c909b0038219436abe3cc', './templates/modules/mod-collapse.tpl', '15.9', 0),
('ff0d9331e4b5bc44e9cb31a66a29f616', './templates/modules/mod-comm_received_objects.tpl', '15.9', 0),
('a76b48718f0ba624e4598ccb126e68a8', './templates/modules/mod-contributors.tpl', '15.9', 0),
('b0a44c4443704b5d15b5f3a1a439b1b5', './templates/modules/mod-credits.tpl', '15.9', 0),
('5f142867ecb5663937a84bab7f7abe25', './templates/modules/mod-directory_last_sites.tpl', '15.9', 0),
('6b49a4492e411f197335d018e545b886', './templates/modules/mod-directory_stats.tpl', '15.9', 0),
('c045b4c399e99b04f069ddb875b7296c', './templates/modules/mod-directory_top_sites.tpl', '15.9', 0),
('76e45ae6d740b7c57f99c1c732a6dbb6', './templates/modules/mod-domain_password.tpl', '15.9', 0),
('56ecf293b1065d0a3c22833b6c00a077', './templates/modules/mod-facebook.tpl', '15.9', 0),
('2e6e0a67a326791b5ba16cc022ae8249', './templates/modules/mod-featured_links.tpl', '15.9', 0),
('f5726bdd798783b2b7a872870eb104ec', './templates/modules/mod-file_galleries.tpl', '15.9', 0),
('375f6206c78478d7eb3f7c31d71b6729', './templates/modules/mod-forums_best_voted_topics.tpl', '15.9', 0),
('b5380393355022b3bc12305a94e0361c', './templates/modules/mod-forums_last_posts.tpl', '15.9', 0),
('9a42677d612d395e52e1c3b030561562', './templates/modules/mod-forums_most_commented_forums.tpl', '15.9', 0),
('df6328a7f806bee89f13a1dd1c7e5342', './templates/modules/mod-forums_most_read_topics.tpl', '15.9', 0),
('cf2c23c1ed86f689c6b75a9f02708271', './templates/modules/mod-forums_most_visited_forums.tpl', '15.9', 0),
('be3e1f4419c74a3a441dff0b3359f29a', './templates/modules/mod-freetag.tpl', '15.9', 0),
('1c587767df71a5f2896764ab5b75899e', './templates/modules/mod-freetags_current.tpl', '15.9', 0),
('75e2bb6fdd472b7ce950cc0014f991cb', './templates/modules/mod-freetags_morelikethis.tpl', '15.9', 0),
('fbf93242c2d9c6e87ab5bd2e52f8e83f', './templates/modules/mod-freetags_most_popular.tpl', '15.9', 0),
('3ff4735a208bd915acb216a9c2061c47', './templates/modules/mod-freetags_prefered.tpl', '15.9', 0),
('86109f8810603804557d867876df3e30', './templates/modules/mod-friend_list.tpl', '15.9', 0),
('d1f3248678d7620cf4094e1004c0ac55', './templates/modules/mod-google.tpl', '15.9', 0),
('56dd364ff006c8ef1294b2b4306f35d4', './templates/modules/mod-groups_emulation.tpl', '15.9', 0),
('286a8c919b64b1f8af5ec4e93f6ca2c0', './templates/modules/mod-last_actions.tpl', '15.9', 0),
('dacffb8573c2731af85a217c94aa2e36', './templates/modules/mod-last_blog_posts.tpl', '15.9', 0),
('32846474e1b1039956dd3c84bfed7684', './templates/modules/mod-last_category_objects.tpl', '15.9', 0),
('0a3f8c264101582f566ea2cb590b8ad3', './templates/modules/mod-last_created_blogs.tpl', '15.9', 0),
('8f444d936827277330a9d07d93fa68df', './templates/modules/mod-last_created_faqs.tpl', '15.9', 0),
('4a0b0e67e3b1d3a0432a4b6872ab70e2', './templates/modules/mod-last_created_quizzes.tpl', '15.9', 0),
('774ee849b27db999345e070fa16ac056', './templates/modules/mod-last_file_galleries.tpl', '15.9', 0),
('9741788298c20ebf0e6761077abe2c6e', './templates/modules/mod-last_files.tpl', '15.9', 0),
('a9423dbc8932c391c523a446106fda93', './templates/modules/mod-last_image_galleries.tpl', '15.9', 0),
('9ad78b4ffb1634cdcda64cc0b1190551', './templates/modules/mod-last_images.tpl', '15.9', 0),
('bace4fd859a7ef6ba731bb892a3c93be', './templates/modules/mod-last_modif_events.tpl', '15.9', 0),
('6f5180942d421fa5b931ae1293703500', './templates/modules/mod-last_modif_pages.tpl', '15.9', 0),
('474946e9e6ea01379debfc25c111e05a', './templates/modules/mod-last_modified_blogs.tpl', '15.9', 0),
('21528403bd56a09e6027f6672e199dd8', './templates/modules/mod-last_podcasts.tpl', '15.9', 0),
('fc253a54ec93f9eb1ceba02633c85a44', './templates/modules/mod-last_submissions.tpl', '15.9', 0),
('77c6e2b10402b62dfa48d65ae1ad1423', './templates/modules/mod-last_tracker_comments.tpl', '15.9', 0),
('46efc1f1c195d5075076ea24bc6e290c', './templates/modules/mod-last_tracker_items.tpl', '15.9', 0),
('a8cfec68000afe25bbc7619146c53689', './templates/modules/mod-last_validated_faq_questions.tpl', '15.9', 0),
('85ff3679f3fcc6038fc9ea879d1435af', './templates/modules/mod-last_visitors.tpl', '15.9', 0),
('6305274603e7901ddd9dba26f024f8e1', './templates/modules/mod-last_youtube_playlist_videos.tpl', '15.9', 0),
('82e14d331f51f276ce64c8dc3ae97000', './templates/modules/mod-live_support.tpl', '15.9', 0),
('6ea5b491f643b78f6d7598ee8490adb3', './templates/modules/mod-loadstats.tpl', '15.9', 0),
('fb1b00ea94bdf1595b790f3bf565414e', './templates/modules/mod-locator.tpl', '15.9', 0),
('e018e5123f7ed053c45c978225229056', './templates/modules/mod-login_box.tpl', '15.9', 0),
('ac2de86d59391791f9579a25482fb87c', './templates/modules/mod-logo.tpl', '15.9', 0),
('6425df7ae9b8dfb3efd563540c3508fb', './templates/modules/mod-map_edit_features.tpl', '15.9', 0),
('c04019473082d2fa35408bf122e58754', './templates/modules/mod-map_layer_selector.tpl', '15.9', 0),
('3097d27806f3c4ab2b834b3a979a7e3f', './templates/modules/mod-map_mode_selector.tpl', '15.9', 0),
('683c4e62d0e93ccd257fe38137955459', './templates/modules/mod-map_search_location.tpl', '15.9', 0),
('d1b780e6484c9bf81162f616f0a07f76', './templates/modules/mod-menu.tpl', '15.9', 0),
('0575f61c0c5ce357f5ebc95dc047e20d', './templates/modules/mod-menupage.tpl', '15.9', 0),
('1bfc51bf6bc3fc85a0d5a6f8208b7708', './templates/modules/mod-menustructure.tpl', '15.9', 0),
('d24564fae6a4c5bd640626d5be083eb9', './templates/modules/mod-messages_unread_messages.tpl', '15.9', 0),
('3a991af3f26acd21fe28451bda3fa433', './templates/modules/mod-minichat.tpl', '15.9', 0),
('1982c865b4511bef3da1cd162f78d99f', './templates/modules/mod-mobile.tpl', '15.9', 0),
('2fc5e705ba3105bc48c035dd91642e69', './templates/modules/mod-months_links.tpl', '15.9', 0),
('b7b1433cfcc404365405361eca23270c', './templates/modules/mod-most_commented.tpl', '15.9', 0),
('33a42367e4f060580cdc71e10058a81a', './templates/modules/mod-mustread.tpl', '15.9', 0),
('96a15131b75f79520e885339de5792c8', './templates/modules/mod-notificationlink.tpl', '15.9', 0),
('bf740950b3d6f2aa0489ecd9fa9cd23e', './templates/modules/mod-num_submissions.tpl', '15.9', 0),
('45951ff2135c8cacb9897f5662adb770', './templates/modules/mod-old_articles.tpl', '15.9', 0),
('b8787c0919054ce45cbd601cc24480d1', './templates/modules/mod-payment_outstanding.tpl', '15.9', 0),
('8dda4aa8a4c5d625c9908fa2adf141c0', './templates/modules/mod-perspective.tpl', '15.9', 0),
('d4fa502f5690f89f129fbbcdc1fef7d5', './templates/modules/mod-poweredby.tpl', '15.9', 0),
('2796e107a2f190d33afd4debd19b0d1d', './templates/modules/mod-quick_edit.tpl', '15.9', 0),
('be363d8d7b98d72aca9de0787ed1dd2a', './templates/modules/mod-quick_search.tpl', '15.9', 0),
('abb9fe344f244e588cf7a77f690037e9', './templates/modules/mod-quickadmin.tpl', '15.9', 0),
('986a4eb271dc1be3af923de2237add7f', './templates/modules/mod-random_images.tpl', '15.9', 0),
('152d01bc440cc8fad83e8a8ba59f5887', './templates/modules/mod-random_pages.tpl', '15.9', 0),
('487eefbef9c4da59289ee9d4ecdd5b5c', './templates/modules/mod-register.tpl', '15.9', 0),
('e69174323fd96e9f4ce2b6e1592b2f6c', './templates/modules/mod-rsslist.tpl', '15.9', 0),
('76d24f2857dd8c62634535a580b90f7a', './templates/modules/mod-search.tpl', '15.9', 0),
('2d0c39adc421647eb839887ac5bd6201', './templates/modules/mod-search_morelikethis.tpl', '15.9', 0),
('1a01d6d6300217a03fea17f581d105bc', './templates/modules/mod-search_wiki_page.tpl', '15.9', 0),
('636fc3b3776162c78c6cb8271dd49cea', './templates/modules/mod-semantic_links.tpl', '15.9', 0),
('66cc7d2bc7f181e72e2c8df102f266d1', './templates/modules/mod-share.tpl', '15.9', 0),
('9969d637f6ce124088d9c4badac4827a', './templates/modules/mod-shoutbox.tpl', '15.9', 0),
('bae3fa2fa21fc4881f234c92c8df4d98', './templates/modules/mod-since_last_visit.tpl', '15.9', 0),
('ab67f65b50fcd58067f3421d70a678fe', './templates/modules/mod-since_last_visit_new.tpl', '15.9', 0),
('8fab9d56f03679e40401df1c7f9fd7f5', './templates/modules/mod-svnup.tpl', '15.9', 0),
('c4fb993179889608009f80f3dc544a57', './templates/modules/mod-switch_lang.tpl', '15.9', 0),
('87d5274613a2abf6e44643306c921e96', './templates/modules/mod-switch_theme.tpl', '15.9', 0),
('541f7e17485a7cbe017e887de59c4a8a', './templates/modules/mod-terminology.tpl', '15.9', 0),
('634977603be1f4bdc13e2030d8c834a5', './templates/modules/mod-tikitests.tpl', '15.9', 0),
('37b1635e9683461314af4ef3427369d9', './templates/modules/mod-top_active_blogs.tpl', '15.9', 0),
('f0f2b9b35725e2de1c272c9e74640707', './templates/modules/mod-top_articles.tpl', '15.9', 0),
('5644da68a259e1071eefd20c99f7e260', './templates/modules/mod-top_blog_posters.tpl', '15.9', 0),
('d5e90b6282be9015161ad8ac0500a50f', './templates/modules/mod-top_file_galleries.tpl', '15.9', 0),
('0d5886220370a3175a0abda64336c21b', './templates/modules/mod-top_files.tpl', '15.9', 0),
('820107c6edf90a1063372650f6d5035e', './templates/modules/mod-top_forum_posters.tpl', '15.9', 0),
('10bb44cb16988a6af1132a4cb10c1644', './templates/modules/mod-top_image_galleries.tpl', '15.9', 0),
('61366f94ac58fa413e51d6fcb122cc9e', './templates/modules/mod-top_images.tpl', '15.9', 0),
('4a03400baf904454907898bd4977b16e', './templates/modules/mod-top_objects.tpl', '15.9', 0),
('4d30e4a96602989a3f7c35eb7b7e04a5', './templates/modules/mod-top_pages.tpl', '15.9', 0),
('bc7178c9ac7d457e8fc78789ac1bb6bd', './templates/modules/mod-top_quizzes.tpl', '15.9', 0),
('07fb07ff4ac998e7404553469bb64c40', './templates/modules/mod-top_visited_blogs.tpl', '15.9', 0),
('04562c0e6c6b8641e5ad2f8a7867664c', './templates/modules/mod-top_visited_faqs.tpl', '15.9', 0),
('7a82592f8b673a8133a5210a1ab21b2d', './templates/modules/mod-tracker_input.tpl', '15.9', 0),
('6e6e1104f4f1489210be4758f37367ad', './templates/modules/mod-trackerhelp.tpl', '15.9', 0),
('5cd53151804b1a577aec7fc5efbe0b41', './templates/modules/mod-translation.tpl', '15.9', 0),
('8f022c232f19b25b85eef2b0fbbbc540', './templates/modules/mod-twitter.tpl', '15.9', 0),
('3b2cedcca720b168fb98a305cdeb7506', './templates/modules/mod-upcoming_events.tpl', '15.9', 0),
('5053474dff52d0fa383c221b4837b8b2', './templates/modules/mod-user_blogs.tpl', '15.9', 0),
('635dd60882919d57b1d830f7b66309ec', './templates/modules/mod-user_bookmarks.tpl', '15.9', 0),
('f1cbc686d37898b499e31ca0cac2cece', './templates/modules/mod-user_image_galleries.tpl', '15.9', 0),
('057beec8cba60bedab000048381fb72b', './templates/modules/mod-user_pages.tpl', '15.9', 0),
('b97a5aaffcc348a52fa694569c140082', './templates/modules/mod-user_tasks.tpl', '15.9', 0),
('96ec72bad21ab110b841775371159549', './templates/modules/mod-user_tasks_public.tpl', '15.9', 0),
('489a179c3dcaf5e16e749a46de56e726', './templates/modules/mod-usergroup_tracker.tpl', '15.9', 0),
('17862bb34c2d68f31dddd527519a9715', './templates/modules/mod-users_list.tpl', '15.9', 0),
('bb90d4940e4e2801d790dace7e0d7cc6', './templates/modules/mod-users_own_rank.tpl', '15.9', 0),
('03c6ff75d5dc0f1e3d8165f0d4556a87', './templates/modules/mod-users_rank.tpl', '15.9', 0),
('bcd0104e97f5bde0950604ca658e318f', './templates/modules/mod-webmail_inbox.tpl', '15.9', 0),
('00125e3961ebde099ac36058b6fc2b77', './templates/modules/mod-whats_related.tpl', '15.9', 0),
('55000c91f2eecfa7b5291715092b94ec', './templates/modules/mod-who_is_there.tpl', '15.9', 0),
('9ef5e309963f53c9aff51bb66a437fb8', './templates/modules/mod-wiki_last_comments.tpl', '15.9', 0),
('ed5f5ea014f9022e0b698f252358c1bf', './templates/modules/mod-youtube.tpl', '15.9', 0),
('75962cbb93a714545604956ea894df6b', './templates/modules/mod-zone.tpl', '15.9', 0),
('43b97633b4fbf0e816b9266905aeabcf', './templates/modules/mod-zotero.tpl', '15.9', 0),
('65a5878fecc05961949062b249df29e9', './templates/modules/user_module.tpl', '15.9', 0),
('8c52a8cfc247050c636c33125198ba3e', './templates/monitor/clearall.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/monitor/index.php', '15.9', 0),
('7ff5016f20a6940a4600701eaf530c8c', './templates/monitor/link.tpl', '15.9', 0),
('16e7a25ed5f40d92a52840d21994cd6c', './templates/monitor/notification_email_body.tpl', '15.9', 0),
('1958b2959babd5c4da4d985369bb6634', './templates/monitor/notification_link.tpl', '15.9', 0),
('75794e2310873e84c2083d77b7425a3c', './templates/monitor/object.tpl', '15.9', 0),
('c5217c982f13b00402d9331ee88da379', './templates/monitor/stream.tpl', '15.9', 0),
('74fcf04d3b519d39d4ce945023898192', './templates/monitor/unread.tpl', '15.9', 0),
('9dbae289460d4d9113378cba09fadb86', './templates/multilike.tpl', '15.9', 0),
('4b680a193d1ca44a95a24ab77095b8ea', './templates/mustread/circulate.tpl', '15.9', 0),
('19c4129a5e47552b4a30ec57b95a3639', './templates/mustread/detail.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/mustread/index.php', '15.9', 0),
('209008a47387106df30c49b0da21dbad', './templates/mustread/list.tpl', '15.9', 0),
('577f90fddcc5865ab1ae52016ea2975d', './templates/mustread/object.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/object/index.php', '15.9', 0),
('c20a4bddff4d316871d8a83357fd7fa2', './templates/object/infobox.tpl', '15.9', 0),
('617521824e10ae03bb10ab40d8fb3e93', './templates/object/infobox/activity.tpl', '15.9', 0),
('4865ae7eac17752ab63c71bb68d554ec', './templates/object/infobox/index.php', '15.9', 0),
('c5fa6a97a76e29c91953ea218c146b89', './templates/object/infobox/trackeritem.tpl', '15.9', 0),
('bc88112e10dd30cc7a60236631e5cdaa', './templates/object/lock.tpl', '15.9', 0),
('d31a7a8511eb6ca8521c09aa2201e65f', './templates/object_perms_summary.tpl', '15.9', 0),
('b53b8fe7e26726da07d1776504ca70bc', './templates/object_selector.tpl', '15.9', 0),
('c1df3fa4b61e1ddb40c6860f057522ab', './templates/object_selector_multi.tpl', '15.9', 0),
('dc5de1bad9785614f48f511b4eee7b5a', './templates/pagehistory.tpl', '15.9', 0),
('0509213d1f80d211a719ade059f72254', './templates/password_help.tpl', '15.9', 0),
('2b38314a3fc72d71a13f3affebadcde5', './templates/password_jq.tpl', '15.9', 0),
('d3983a55a20f243404a3cd7b40aa25b1', './templates/permission_link.tpl', '15.9', 0),
('80b22f1cdc1770c325a9cf777d4be4ac', './templates/plugins/index.php', '15.9', 0),
('4f68c752677dd6aeefefc588ad5e9a74', './templates/plugins/plugin-topfriends.tpl', '15.9', 0),
('695045fd196891b65e07de36d237658a', './templates/poll.tpl', '15.9', 0),
('6e677e741979d52611639efaba144fe6', './templates/prefs/flag.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/prefs/index.php', '15.9', 0),
('0f697b570b4702cd5f085018b4c92b73', './templates/prefs/list.tpl', '15.9', 0),
('1784883778691b3857c563397574427d', './templates/prefs/multicheckbox.tpl', '15.9', 0),
('c4b4974321822982041b7ba39b39f4c4', './templates/prefs/multilist.tpl', '15.9', 0),
('a6f6c2b74cc1eaf4055079be4859f7ae', './templates/prefs/multiselector.tpl', '15.9', 0),
('395d0f7e0bde577b7f6944cac21545b4', './templates/prefs/password.tpl', '15.9', 0),
('b84733118adc0aa8dbcd776e3e8471a1', './templates/prefs/radio.tpl', '15.9', 0),
('f6909d62a4df3030c46aa57b6dd80bcd', './templates/prefs/selector.tpl', '15.9', 0),
('1307517c42a5dd1041f8817fa1ac241c', './templates/prefs/shared-dependencies.tpl', '15.9', 0),
('8e87b90d02f0fad1ef4487c1eb85ba2c', './templates/prefs/shared-flags.tpl', '15.9', 0),
('bc7d49ac7988f9e4a584e39500219064', './templates/prefs/text.tpl', '15.9', 0),
('130cd28f5c1b0c765e695209aa6e8d2e', './templates/prefs/textarea.tpl', '15.9', 0),
('89ec1dda673523dd81b40fecae6ae946', './templates/print/index.php', '15.9', 0),
('aa6fb8f60fe4ef7d03413ffa2fd9fc7d', './templates/print/print-decorator_indexed.tpl', '15.9', 0),
('f96135f90458667a45bde6ddca40786f', './templates/print/print-decorator_indexrow.tpl', '15.9', 0),
('2b56eda271aadc0e2b5e9014bf72c75a', './templates/print/print-index_footer.tpl', '15.9', 0),
('ed2496911a79d957b9a02fea39c265fc', './templates/print/print-index_header.tpl', '15.9', 0),
('cb70a1f10f9e35726cd535fd039fa6dd', './templates/print/print-object_trackeritem.tpl', '15.9', 0),
('c82dcc4c0360affb661b91758d38e055', './templates/print/print-object_wiki.tpl', '15.9', 0),
('4c6782087f638d5dbd30512c09ffd179', './templates/print/print-page_footer.tpl', '15.9', 0),
('f3f93978f8a2d52a21f6b6602d75a24c', './templates/print/print-page_header.tpl', '15.9', 0),
('0a293bd9cc815c34970820b55930e8dd', './templates/print/print-title_trackeritem.tpl', '15.9', 0),
('8035a67a17997d1f1d32bd3161ef068f', './templates/print/print-title_wiki.tpl', '15.9', 0),
('0447bd4842ce44197eece56b4e2d4b8e', './templates/rating.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/rating/index.php', '15.9', 0),
('2af45106725037f9f1a11e6a2ea55475', './templates/rating/vote.tpl', '15.9', 0),
('860a35602f379d2a0fc38aceee3b8426', './templates/rating_choice.tpl', '15.9', 0),
('5bd1e7074df76cc9537cac0650bbfbc4', './templates/recommendation_dev/compare.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/recommendation_dev/index.php', '15.9', 0),
('7953ad716d60c3bc31709cd689363080', './templates/register-email.tpl', '15.9', 0),
('c74fa6863b2e122f38d8280596553fc5', './templates/register-form.tpl', '15.9', 0),
('2e7a91fcbdb1e3da1be5e74fde913f36', './templates/register-groupchoice.tpl', '15.9', 0),
('08bda6e92c69c3c603fe48460bcdf181', './templates/register-login.tpl', '15.9', 0),
('25fc75cd5e816a2e93591ea37d0921f6', './templates/register-pass.tpl', '15.9', 0),
('e1959c7e50113b662fd3c5cd94b395cf', './templates/register-pass2.tpl', '15.9', 0),
('d2b9b4b0bf6641250eceeecfeae6aff7', './templates/register-passcode.tpl', '15.9', 0),
('448434f875e18e999e79e97a8b798690', './templates/remarksbox.tpl', '15.9', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/edit.tpl', '15.9', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/exportcsv.tpl', '15.9', 0),
('80b22f1cdc1770c325a9cf777d4be4ac', './templates/report/index.php', '15.9', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/load.tpl', '15.9', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/preview.tpl', '15.9', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/wikidata.tpl', '15.9', 0),
('f1547a8c565ba2dc35d1d9fa0c186c2e', './templates/score/create_score_event.tpl', '15.9', 0),
('3b1029ed9a869ec44f2a1d5eaa61182a', './templates/search/help.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/search/index.php', '15.9', 0),
('af3db169728ad12af349642889b63762', './templates/search/list/carousel.tpl', '15.9', 0),
('299910931a7988757f81bd04bbab13e0', './templates/search/list/count.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/search/list/index.php', '15.9', 0),
('8f5db486d9713dae9a120eacb45cbb9e', './templates/search/list/medialist.tpl', '15.9', 0),
('fdb5e53d5cfa237089f48db5554c1b1f', './templates/search/list/table.tpl', '15.9', 0),
('9b9a3b8a47016cf4a1f5f1f7dcf8c9ae', './templates/search/process_queue.tpl', '15.9', 0),
('0f1b8f10409236ccac47ce917ac7901d', './templates/search/rebuild.tpl', '15.9', 0),
('ad310e2785835582f8c9554cdbe3cad0', './templates/search_customsearch/customsearch.tpl', '15.9', 0),
('80b22f1cdc1770c325a9cf777d4be4ac', './templates/search_customsearch/index.php', '15.9', 0),
('8a3e13e0613e91182e0eee875f392fbb', './templates/search_manifold/check.tpl', '15.9', 0),
('49a6132e9ad639aa4684970098e104bf', './templates/search_manifold/create_index.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/search_manifold/index.php', '15.9', 0),
('d81b1b46a012d28f4b81157439bcf38f', './templates/search_stored/delete.tpl', '15.9', 0),
('926dda180601db6a749cd8fd064f234e', './templates/search_stored/edit.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/search_stored/index.php', '15.9', 0),
('39698c76c3323691fc4d99ae681a3399', './templates/search_stored/list.tpl', '15.9', 0),
('59ad0ff8dce010bad13b6277e2365038', './templates/search_stored/select.tpl', '15.9', 0),
('c259f6ad48333d8e42fc9e8585d8e0a1', './templates/searchresults-plain.tpl', '15.9', 0),
('9b9ccfd904c0eca714b36455766e57d4', './templates/send_newsletter_footer.tpl', '15.9', 0),
('dc68895de01ca39d3859a786c801f64a', './templates/send_newsletter_header.tpl', '15.9', 0),
('0c618e08d6d5348699c6fb23bd1e34ce', './templates/sent_newsletters.tpl', '15.9', 0),
('2d5c35013627ea02eab6bca5b412eb63', './templates/show_copyright.tpl', '15.9', 0),
('8cbc6151049a4b1c19090c185ad49656', './templates/social/add_friend.tpl', '15.9', 0),
('6c02e119ca97466fb9e71cd5ad4e5fbc', './templates/social/approve_friend.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/social/index.php', '15.9', 0),
('2036eeae9b563ed3709852ecc685a5ac', './templates/social/list_friends.tpl', '15.9', 0),
('e1600419e075c10a0d3e48bc61440fbf', './templates/social/remove_friend.tpl', '15.9', 0),
('5afcaa0825f45059b6756d5b70175e85', './templates/structures_toc-endul.tpl', '15.9', 0),
('a6abc833f7071efcac574c67bab8ae11', './templates/structures_toc-leaf.tpl', '15.9', 0),
('2fb0aab7b96cff8a030f7115ddd50dbc', './templates/structures_toc-startul.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/suite/index.php', '15.9', 0),
('28a505eeb785edcbac9c00a421a91d67', './templates/suite/jitsi.tpl', '15.9', 0),
('4fb86cb1bdd55a18a5247eb650021ddc', './templates/tablesorter/index.php', '15.9', 0),
('3497b8e790c760f6cbd27ee6fa0bca7c', './templates/tablesorter/totals.tpl', '15.9', 0),
('edb1b31ddfe9c7d30ae984933bcfddcd', './templates/tabular/create.tpl', '15.9', 0),
('f77c65a13c6943cbc6e9de4484a40ebd', './templates/tabular/delete.tpl', '15.9', 0),
('723d64c969587beb70b833211b1cd017', './templates/tabular/edit.tpl', '15.9', 0),
('f0f9b1d1ad491270c6a12818573576e0', './templates/tabular/export_search_csv.tpl', '15.9', 0),
('643bd9ccdc19eaf821045cf2779e7e6b', './templates/tabular/filter.tpl', '15.9', 0),
('f8739612c54a13bfd587f1736b4ae784', './templates/tabular/import_csv.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/tabular/index.php', '15.9', 0),
('9c1ee94edfcedccdfdbd591860afe201', './templates/tabular/item_actions.tpl', '15.9', 0),
('4beb0e9b09bd5c07b2f58e5ee767ed95', './templates/tabular/list.tpl', '15.9', 0),
('131040b57814ad9db20ea3802a26f3a7', './templates/tabular/manage.tpl', '15.9', 0),
('763d264ff1496468a5237d5f7541782c', './templates/tabular/select.tpl', '15.9', 0),
('74ac4b7a867beb7c844b574a3b4a2642', './templates/tabular/select_filter.tpl', '15.9', 0),
('9f9f03e0bf25dedbd6648d653b290778', './templates/tiki-accounting.tpl', '15.9', 0),
('619eef8872d558868974f7c709953e37', './templates/tiki-accounting_account_deleted.tpl', '15.9', 0),
('5598c8d8f95113ff27686bc4daee9bc6', './templates/tiki-accounting_account_form.tpl', '15.9', 0),
('a436624101a8a80480c6596d53ad3af0', './templates/tiki-accounting_account_list.tpl', '15.9', 0),
('5fe5b7f569d6b8c06c422770fd077b42', './templates/tiki-accounting_account_view.tpl', '15.9', 0),
('285fcfda7c625452dcb493e9978a38bb', './templates/tiki-accounting_accounts_csv.tpl', '15.9', 0),
('121c25891f1c9c7cbc9cd0ceeaab9c21', './templates/tiki-accounting_books.tpl', '15.9', 0),
('eb516f2e52773940cf7dd56822863380', './templates/tiki-accounting_cancel.tpl', '15.9', 0),
('ebbcde067d23ff1a671b86b3606cf833', './templates/tiki-accounting_entry.tpl', '15.9', 0),
('98cb50ed8a022c219e215e81e4be4a2c', './templates/tiki-accounting_export.tpl', '15.9', 0),
('7c54377bc1320e8de1cbce3196e8b784', './templates/tiki-accounting_journal.tpl', '15.9', 0),
('a45b9d8be11bce4fd86c1fdaadd30227', './templates/tiki-accounting_journal_csv.tpl', '15.9', 0),
('6d4ebad0e590ae09492b565cc753fea3', './templates/tiki-accounting_stack.tpl', '15.9', 0),
('69f2fc283795f3305d4e8d490063dd66', './templates/tiki-accounting_stacklist.tpl', '15.9', 0),
('33423980d724270cc45358cfd60498ba', './templates/tiki-action_calendar.tpl', '15.9', 0),
('c00da57fa73d64b46f483b8a9d37c75a', './templates/tiki-admin.tpl', '15.9', 0),
('0fba1f0f119e0f1a4a4446c9699b6334', './templates/tiki-admin_actionlog.tpl', '15.9', 0),
('f09814ffd066d33a61b3bd324861a3d8', './templates/tiki-admin_banning.tpl', '15.9', 0),
('2970d51ffe7e4c8d586502c2139ddc0f', './templates/tiki-admin_calendars.tpl', '15.9', 0),
('88e492f152ab939f86a3a45e9ed19d78', './templates/tiki-admin_categories.tpl', '15.9', 0),
('17b6b1335e10cb4a37ad130a2c96e270', './templates/tiki-admin_content_templates.tpl', '15.9', 0),
('562852e2f75f9dfa6c723a44dbe1d3d5', './templates/tiki-admin_contribution.tpl', '15.9', 0),
('0c4421a5e1fd0abae0af8e9af617c313', './templates/tiki-admin_cookies.tpl', '15.9', 0),
('612727215331dbfcdb0d1658cdcaa31e', './templates/tiki-admin_credits.tpl', '15.9', 0),
('308f1ce6af450be73cc7d22c7c0c69e1', './templates/tiki-admin_dsn.tpl', '15.9', 0),
('bcfd3e8bfce54f6723222602d9c4b394', './templates/tiki-admin_external_wikis.tpl', '15.9', 0),
('05b8bd441aa90a03b361a78c3bdbfafb', './templates/tiki-admin_forums.tpl', '15.9', 0),
('b23fcf7b2fd568f5144859cb890b6794', './templates/tiki-admin_hotwords.tpl', '15.9', 0),
('d79c8209511aa3a040d331e6da4c2a4e', './templates/tiki-admin_html_page_content.tpl', '15.9', 0),
('b7f46fd2b773f7c1ce941319566cccb0', './templates/tiki-admin_html_pages.tpl', '15.9', 0),
('423b422318dba4bd857068209c2be5a9', './templates/tiki-admin_integrator.tpl', '15.9', 0),
('00ed86b63583fa5de6692ff2622ad5d2', './templates/tiki-admin_integrator_rules.tpl', '15.9', 0),
('552b892fc0b14abfda93f603ac226c23', './templates/tiki-admin_invoices.tpl', '15.9', 0),
('76e7e3f2de2a97ed3e22831b43b9439f', './templates/tiki-admin_keywords.tpl', '15.9', 0),
('f9276fd7e5b5d6c85a590eb0023b0bd8', './templates/tiki-admin_links.tpl', '15.9', 0),
('d6a33bc3e35d30ee77643603e927367d', './templates/tiki-admin_mailin.tpl', '15.9', 0),
('a7ad447a5d719aa5f2478109e5c52f33', './templates/tiki-admin_mailin_routes.tpl', '15.9', 0),
('9c1554f53b099923ac2c1800facfd745', './templates/tiki-admin_menu_options.tpl', '15.9', 0),
('b3e20393719ca9781660533b9b1efe24', './templates/tiki-admin_menus.tpl', '15.9', 0),
('596ab24b50e9deb12a7411a756d46bb5', './templates/tiki-admin_modules.tpl', '15.9', 0),
('7a78ff30e6c8b38bc8acac1e8d270543', './templates/tiki-admin_newsletter_subscriptions.tpl', '15.9', 0),
('3e7da50fadeb916e06f2e5d027ca972c', './templates/tiki-admin_newsletters.tpl', '15.9', 0),
('428fd5dbe42390948d8d917796248fc6', './templates/tiki-admin_notifications.tpl', '15.9', 0),
('620bae2bcd1f75f070936d8af062f6cd', './templates/tiki-admin_poll_options.tpl', '15.9', 0),
('878e801ba852f05b04dd5b445a641baf', './templates/tiki-admin_polls.tpl', '15.9', 0),
('fcb30996a3dd6a0080f8540995d1b105', './templates/tiki-admin_rssmodules.tpl', '15.9', 0),
('253df946d78793385715177446a86a2f', './templates/tiki-admin_security.tpl', '15.9', 0),
('3d1984931da0565c5ef4e6c5e70e5e64', './templates/tiki-admin_shoutbox_words.tpl', '15.9', 0),
('d1571ccddea0811104959972849b013c', './templates/tiki-admin_structures.tpl', '15.9', 0),
('c9d75d87d23552744eabfc04d510eaa1', './templates/tiki-admin_survey_questions.tpl', '15.9', 0),
('717a52120582c784424a3c64f2e2b20c', './templates/tiki-admin_surveys.tpl', '15.9', 0),
('8930a246e1633ae7632052872116bfb5', './templates/tiki-admin_system.tpl', '15.9', 0),
('21ccb8036c28a636b05648d614d6c6b7', './templates/tiki-admin_tokens.tpl', '15.9', 0),
('0a65900203843e89b71fe79168053bfb', './templates/tiki-admin_toolbars.tpl', '15.9', 0),
('7bbe57e6624d611cb64d973cf9a8b6fa', './templates/tiki-admin_topics.tpl', '15.9', 0),
('2704371ad0314d62b92296723e5a0aa8', './templates/tiki-admin_tracker_fields.tpl', '15.9', 0),
('818cf4a66dbb0e8feead2268d27f5cfc', './templates/tiki-admin_transitions.tpl', '15.9', 0),
('31a7f456371f41c42f80cf98706c62e7', './templates/tiki-admingroups.tpl', '15.9', 0),
('9e746a1c68ad34a193ac0c4124bae8dd', './templates/tiki-adminusers.tpl', '15.9', 0),
('0eef1d9182943cc371c6486284bbae1a', './templates/tiki-ajax_header.tpl', '15.9', 0),
('26695252a625a6a56f03326753762a81', './templates/tiki-all_languages.tpl', '15.9', 0),
('34ed9fc60edad263a878acd2f3c98b93', './templates/tiki-article_types.tpl', '15.9', 0),
('de09e78affca5d31ee6b05ce389d6f3a', './templates/tiki-articles-js.tpl', '15.9', 0),
('31c7f5894cf46be53de5d857ae7e152f', './templates/tiki-assignuser.tpl', '15.9', 0),
('93bd47a922d2e8438aaab85018824b2b', './templates/tiki-backlinks.tpl', '15.9', 0),
('0725640990c65689c66f2c3aee593205', './templates/tiki-batch_upload.tpl', '15.9', 0),
('8f4d7da98a57c052fa61e91d84b412cc', './templates/tiki-batch_upload_files.tpl', '15.9', 0),
('7a0990e9e239d69fbc1365ab833c7c64', './templates/tiki-blog_post.tpl', '15.9', 0),
('c3719fb4c3e6e747a60711ebfb64f3ad', './templates/tiki-browse_categories.tpl', '15.9', 0),
('709c85c95876dc9b201ec420e6b31732', './templates/tiki-browse_freetags.tpl', '15.9', 0),
('7d542af90fcd253a1d52eac5d5700fa2', './templates/tiki-browse_gallery.tpl', '15.9', 0),
('56ebbff2e79034fa867e5c6c0a572480', './templates/tiki-browse_image.tpl', '15.9', 0),
('039a452ef40d04798aba8a1b04ba5b05', './templates/tiki-calendar.tpl', '15.9', 0),
('99b4bebc8804f215a13ffb5ce50e0e49', './templates/tiki-calendar_box.tpl', '15.9', 0),
('d8b8a5a5761bf64e60052bed2f863b52', './templates/tiki-calendar_box_multiple.tpl', '15.9', 0),
('9c4705895741e0349631f2da6066fd09', './templates/tiki-calendar_calmode.tpl', '15.9', 0),
('cf9b6a34433b98eeef61c300bfe71476', './templates/tiki-calendar_daymode.tpl', '15.9', 0),
('61958ff69cd4fb8b37df16b5fe581408', './templates/tiki-calendar_edit_item.tpl', '15.9', 0),
('0da88f2253fe47cdbfe54e324faed888', './templates/tiki-calendar_import.tpl', '15.9', 0),
('ebfb614caf6c5fc7b46cdc2963884d8f', './templates/tiki-calendar_listmode.tpl', '15.9', 0),
('199f6d0184e7c39e92b5fbd11253d6cf', './templates/tiki-calendar_nav.tpl', '15.9', 0),
('ab3536e6adc7d495cab6fa3c19a541ab', './templates/tiki-calendar_params_ical.tpl', '15.9', 0),
('b09816970046ba018b8f4f54d7a7fc0f', './templates/tiki-calendar_weekmode.tpl', '15.9', 0),
('4f283ccfa5ba38b617e0d28e90673c3f', './templates/tiki-change_password.tpl', '15.9', 0),
('0eb5d82c95dcf7f41b21df5c137371f7', './templates/tiki-check.tpl', '15.9', 0),
('fb0063d9bc202dfef1a312cb48a4aaf9', './templates/tiki-choose_page_language.tpl', '15.9', 0),
('23046a4406070f5bbb3089e14930b7af', './templates/tiki-contact.tpl', '15.9', 0),
('f9bc54fed0f0fadf2f2c50bf7ce4eb8f', './templates/tiki-contacts.tpl', '15.9', 0),
('8e6fb55d4b476ff8884c905f260b5c28', './templates/tiki-copypage.tpl', '15.9', 0),
('df472c2c5d3372d1eb6bdf7083813b58', './templates/tiki-create_multilang_pages.tpl', '15.9', 0),
('d395c3e12e026dd4fa4118c3b87324ea', './templates/tiki-create_webhelp.tpl', '15.9', 0),
('272cd49492067b847c85235a9f049779', './templates/tiki-directory_add_site.tpl', '15.9', 0),
('ea3f70113ecc106e51e74b565170d56b', './templates/tiki-directory_admin.tpl', '15.9', 0),
('5ece0bf7ff0d5fe5e38784c98be1f80a', './templates/tiki-directory_admin_bar.tpl', '15.9', 0),
('76e871e57d8ba80095030c832ac83c80', './templates/tiki-directory_admin_categories.tpl', '15.9', 0),
('4e60f332e6d78ec3156fde8bba18f27f', './templates/tiki-directory_admin_related.tpl', '15.9', 0),
('a62bfe4a68cc4154b9b2cc5df7c6536d', './templates/tiki-directory_admin_sites.tpl', '15.9', 0),
('a3eeea06eb4abf91890c9a711393b116', './templates/tiki-directory_bar.tpl', '15.9', 0),
('3119a46ce3080f0a3b06f5aa282804d5', './templates/tiki-directory_browse.tpl', '15.9', 0),
('a4244188e81e6df7e03eafe97ead4d9e', './templates/tiki-directory_footer.tpl', '15.9', 0),
('73c07950f16a1b1de89cdf2a43958cee', './templates/tiki-directory_ranking.tpl', '15.9', 0),
('92162088ef2d3782122bb60aa65a658d', './templates/tiki-directory_search.tpl', '15.9', 0),
('92b30e0d9abb7e6a111a234450fc27ed', './templates/tiki-directory_validate_sites.tpl', '15.9', 0),
('1d9e73ac46c2b74bde48ee9a287366da', './templates/tiki-discount.tpl', '15.9', 0),
('6c5fbbf31d364085140fda0f3cdd5b22', './templates/tiki-edit-page-include-prompt_for_edit_or_translate.tpl', '15.9', 0),
('9103a58c977cf759e6a98de53a82d24e', './templates/tiki-edit_article.tpl', '15.9', 0),
('6cef03db6b54c1d39069572866570f98', './templates/tiki-edit_banner.tpl', '15.9', 0),
('c03a77a327d6b84fbc817ad02a85d71c', './templates/tiki-edit_blog.tpl', '15.9', 0),
('d825e282ccc766ea3ce10197ef13ea56', './templates/tiki-edit_categories.tpl', '15.9', 0),
('0149459c3817f521c4e30ed7d5fb0309', './templates/tiki-edit_css.tpl', '15.9', 0),
('417d7233d658a37260a78d1dd4b16b16', './templates/tiki-edit_docs.tpl', '15.9', 0),
('28b710b9bff543f01a52cf71666a5174', './templates/tiki-edit_draw.tpl', '15.9', 0),
('966ecb0dc569e96f5166484ba59058c3', './templates/tiki-edit_help.tpl', '15.9', 0),
('f3376494dc4ce3287f685099cda80efe', './templates/tiki-edit_help_plugins.tpl', '15.9', 0),
('01cb4cff5e39fbb70bf8bfd7640d5379', './templates/tiki-edit_help_sheet.tpl', '15.9', 0),
('3c284ccc861ed122ebc211a9de118d2f', './templates/tiki-edit_help_wysiwyg.tpl', '15.9', 0),
('b48cadd5f9a6079782a8c595f197c61f', './templates/tiki-edit_image.tpl', '15.9', 0),
('4c5d6a7de9f93f1245b43cec1333e640', './templates/tiki-edit_invoice.tpl', '15.9', 0),
('82ca9576cf7e1916411181f97ffaa17f', './templates/tiki-edit_languages.tpl', '15.9', 0),
('f3d4c0e04a6f9fb6537ce6dd17748a6a', './templates/tiki-edit_perspective.tpl', '15.9', 0),
('fd5122cf247452df6b449bf75517f88b', './templates/tiki-edit_programmed_content.tpl', '15.9', 0),
('ef8d541e78901ffc0f920d3a0a816232', './templates/tiki-edit_question_options.tpl', '15.9', 0),
('07f697d945c46ad39142c41aa4e13ab6', './templates/tiki-edit_quiz.tpl', '15.9', 0),
('e4d0f1c8e817819c7e0ad4e1732a67c1', './templates/tiki-edit_quiz_questions.tpl', '15.9', 0),
('790669f4f46df808ca60c3da9f67f0af', './templates/tiki-edit_quiz_results.tpl', '15.9', 0),
('09d4b3b4be4c077eaf0a0fcebe1e8baf', './templates/tiki-edit_report.tpl', '15.9', 0),
('540ada01ded819040e7e8a8db64c057a', './templates/tiki-edit_structure.tpl', '15.9', 0),
('8945cb9ecd7fd0b1f6901f8f63332cf4', './templates/tiki-edit_submission.tpl', '15.9', 0),
('f6f55ddf1f18fd54858e2a88cd43ae37', './templates/tiki-edit_templates.tpl', '15.9', 0),
('05077d832784e0dd9e6a7e3ff2e3fb5d', './templates/tiki-edit_topic.tpl', '15.9', 0),
('5184305688d6cb9b6b674618a13da36a', './templates/tiki-edit_translation.tpl', '15.9', 0),
('4a1b3f576d334fea9385fe32ab428ef8', './templates/tiki-editpage.tpl', '15.9', 0),
('09d5a6c0fb51e3db3f0781d1de7e6c42', './templates/tiki-export-sheets.tpl', '15.9', 0),
('8209cd972522108d644712be2acc314c', './templates/tiki-export_comment_xml.tpl', '15.9', 0),
('531de4d1f555d1f1cccf7bcce60c1218', './templates/tiki-export_page_xml.tpl', '15.9', 0),
('8c2992dc7d0c2a276e2435cea8fcd2ca', './templates/tiki-export_tracker_item.tpl', '15.9', 0),
('6db458fb8d349ff72c41eb0afa478e2f', './templates/tiki-export_users.tpl', '15.9', 0),
('a8ee7a44f02d31ef7bac75ca1dfeaa6a', './templates/tiki-faq_questions.tpl', '15.9', 0),
('1cfa722f6c63c0da6f0afceddfe408e2', './templates/tiki-featured_link.tpl', '15.9', 0),
('ca97454a409cdf2cc2ab15486753dbe9', './templates/tiki-file_archives.tpl', '15.9', 0),
('de00e7b8a9de1e2cac554c62a9249ff5', './templates/tiki-file_galleries.tpl', '15.9', 0),
('c4847338a84a2c2dfddb81fdf834434f', './templates/tiki-file_info_box.tpl', '15.9', 0),
('b2d835e3e2ffdb153fb59c8e334f694b', './templates/tiki-flaggedrev_approval_header.tpl', '15.9', 0),
('e07460af191c36903e59b1d404eb014f', './templates/tiki-forum_import.tpl', '15.9', 0),
('8268623b2f24d5f776936bdbd190db56', './templates/tiki-forum_queue.tpl', '15.9', 0),
('b668541d0516fb014d8ebc9bb058c883', './templates/tiki-forums.tpl', '15.9', 0),
('c54ff82647e64f7c59eb55d2684a3947', './templates/tiki-forums_reported.tpl', '15.9', 0),
('5fa50d57017db6dc984fcdba77a63943', './templates/tiki-freetag-translate.tpl', '15.9', 0),
('85e2758f96a67137773bb610af4ec33c', './templates/tiki-friends.tpl', '15.9', 0),
('d95e0868765f89982e5551bf21ef5f17', './templates/tiki-galleries.tpl', '15.9', 0),
('217c7091d6436c64819a788ee874ba04', './templates/tiki-graph-sheets.tpl', '15.9', 0),
('2c89a34c27c1f57551d349afdd6ad0bb', './templates/tiki-history_sheets.tpl', '15.9', 0),
('26db31cb0c25285369d9723336f50c61', './templates/tiki-import-sheets.tpl', '15.9', 0),
('b3b6ff6da3c027414890330a2ec5341f', './templates/tiki-import_structuredtext.tpl', '15.9', 0),
('a0459a7b979f1c9167503f83196bc113', './templates/tiki-import_xml_zip.tpl', '15.9', 0),
('31206b6940550c2a9b20ca2d8c8fc417', './templates/tiki-importer.tpl', '15.9', 0),
('9122cf7115c18a3153072817d88baa3d', './templates/tiki-index_p.tpl', '15.9', 0),
('9800c548f34e5aa74cdb1b8a9b9e19c6', './templates/tiki-information.tpl', '15.9', 0),
('b6914ed276670ba53f63ac89f7f4f856', './templates/tiki-install.tpl', '15.9', 0),
('38255fbc2ce8824e491593e7c4974531', './templates/tiki-install_screens.tpl', '15.9', 0),
('f8f96d5668f5b3eff7fe6a9b4fb2e77e', './templates/tiki-integrator.tpl', '15.9', 0),
('b2b35cf0e21d79c29c605e585b0f62a3', './templates/tiki-invite.tpl', '15.9', 0),
('2344a206f899c01f3f84fc6d8cd6ba14', './templates/tiki-invited.tpl', '15.9', 0),
('af522682a7445f508ad138cbb5a55138', './templates/tiki-invoice_menu.tpl', '15.9', 0),
('7cae3d5da42b28424f043058aea739a8', './templates/tiki-invoice_reports.tpl', '15.9', 0),
('01781547bd91f0d537355347bd7c2631', './templates/tiki-kaltura_upload.tpl', '15.9', 0),
('68c5e4356193b45163a6bce51f55176e', './templates/tiki-kaltura_video.tpl', '15.9', 0),
('4d5ce56e47842dc615ba3a2b674cfb3a', './templates/tiki-lastchanges.tpl', '15.9', 0),
('0386dc039d876dc46fe92990bf789c8d', './templates/tiki-likepages.tpl', '15.9', 0),
('723edf3e853b759118585973320319e2', './templates/tiki-list_articles.tpl', '15.9', 0),
('e26db47dddcebc9dd187abf7d3313fed', './templates/tiki-list_banners.tpl', '15.9', 0),
('f643bdeadd8f9be9b2ee567148012e95', './templates/tiki-list_blogs.tpl', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('45aa32a304d0fd5182f1cc47a21abb4d', './templates/tiki-list_cache.tpl', '15.9', 0),
('afac8766b41e2d400dadefbf557d3c33', './templates/tiki-list_comments.tpl', '15.9', 0),
('8f776123a328643f68cc40e6eac2efb5', './templates/tiki-list_contents.tpl', '15.9', 0),
('6009eb7776f84d7a3e1080627c423938', './templates/tiki-list_faqs.tpl', '15.9', 0),
('cc3be7191a6c1c19c606849efe9019ab', './templates/tiki-list_file_gallery.tpl', '15.9', 0),
('30e6b64ed42ac2fcd2cdafe16d5d8611', './templates/tiki-list_gallery.tpl', '15.9', 0),
('baf804c961907a3ff674f5f41730a869', './templates/tiki-list_integrator_repositories.tpl', '15.9', 0),
('425b366aa30e9d3442e8d65f2b863ce3', './templates/tiki-list_invite.tpl', '15.9', 0),
('a729b2bf303de6c1c81ccda565e8fd74', './templates/tiki-list_invoice_clients.tpl', '15.9', 0),
('a4cb3210abd88b39e5bc6ded20d47410', './templates/tiki-list_invoices.tpl', '15.9', 0),
('9c1ccb4b80ec7cd4a83cd6584dbfa527', './templates/tiki-list_kaltura_browse_entries.tpl', '15.9', 0),
('91c764a45e125d1583f743fab0a31b01', './templates/tiki-list_kaltura_entries.tpl', '15.9', 0),
('c5425135bbc113f760015a1d0be19167', './templates/tiki-list_kaltura_entries_actions.tpl', '15.9', 0),
('2d714e244e4dafdbaeb5873b6dd558b3', './templates/tiki-list_kaltura_entries_add_info.tpl', '15.9', 0),
('e12a01f8f78c70eab409026e8b69711d', './templates/tiki-list_kaltura_media_entries.tpl', '15.9', 0),
('b9b08f8e44790c45b484bcfc75eea4ca', './templates/tiki-list_kaltura_mix_entries.tpl', '15.9', 0),
('50082b291d763452763f3f472deef006', './templates/tiki-list_object_permissions.tpl', '15.9', 0),
('5a17eb459b03e86ce65a5c000b4e131b', './templates/tiki-list_posts.tpl', '15.9', 0),
('a7a62a990b422225cb4279c8f9039d89', './templates/tiki-list_quizzes.tpl', '15.9', 0),
('251f1442b0de85babd5186c0de46e9c4', './templates/tiki-list_submissions.tpl', '15.9', 0),
('1a77886ea9710425a6e87fafcf79fc34', './templates/tiki-list_surveys.tpl', '15.9', 0),
('32fd81703dc9c89dcc2fe5429b5cc440', './templates/tiki-list_trackers.tpl', '15.9', 0),
('8886442a7f7eb29ee553ea766c0c061d', './templates/tiki-list_users.tpl', '15.9', 0),
('4bb5723ee0f9eb6317377a0af4137c30', './templates/tiki-listpages.tpl', '15.9', 0),
('6127ee9f6335142a8bce54cd8060880d', './templates/tiki-listpages_content.tpl', '15.9', 0),
('a0f0a7635b655d0262e2e42c44a2b343', './templates/tiki-live_support_admin.tpl', '15.9', 0),
('2024e15b49c5853b03fa4d5742163eb2', './templates/tiki-live_support_chat_window.tpl', '15.9', 0),
('ba4c812e15faeeb7beac7028c65dbd3d', './templates/tiki-live_support_client.tpl', '15.9', 0),
('812574afb2c169eb840ba03b5d61a3b8', './templates/tiki-live_support_console.tpl', '15.9', 0),
('43efc9723b2973bb3aab36def93cba27', './templates/tiki-live_support_transcripts.tpl', '15.9', 0),
('835016f4b887dc57d145e97eeab9693c', './templates/tiki-login.tpl', '15.9', 0),
('991706f8c921e6aa5cc51ebb20921086', './templates/tiki-login_confirm_email.tpl', '15.9', 0),
('40fc79481f2b813921b840c80e7dbf8c', './templates/tiki-mailin.tpl', '15.9', 0),
('dbee42edacc25ac26bfa0fb41d2e3ab1', './templates/tiki-mindmap.tpl', '15.9', 0),
('cf56d2bb1954a5538f4dc4484ab95144', './templates/tiki-minical.tpl', '15.9', 0),
('aaba185904a44fa9949939835c006886', './templates/tiki-minical_prefs.tpl', '15.9', 0),
('a049bef40d4aeabb432b2153d73db8f1', './templates/tiki-mods.tpl', '15.9', 0),
('77ebef5af281ddd30c1ca6a446ef6ea6', './templates/tiki-mods_admin.tpl', '15.9', 0),
('c0219e52d5301e7a726e39dcd4ba7408', './templates/tiki-mods_config.tpl', '15.9', 0),
('264af9c57a94ed5e6f6e55efbcab1589', './templates/tiki-my_tiki.tpl', '15.9', 0),
('4813046b26a9581069ffeb1d4dc05baa', './templates/tiki-mytiki_bar.tpl', '15.9', 0),
('bf8233dc265bb28d1435321971f0b0f5', './templates/tiki-newsletter_archives.tpl', '15.9', 0),
('d44fc108f36f8ab56811312ca16fce80', './templates/tiki-newsletters.tpl', '15.9', 0),
('01170875c8d965cf3d192ef718494b40', './templates/tiki-notepad_list.tpl', '15.9', 0),
('8205395530076aa2b76794eee9f5ee78', './templates/tiki-notepad_read.tpl', '15.9', 0),
('f9a515bacaeaedb77e3099daf22ad90e', './templates/tiki-notepad_write.tpl', '15.9', 0),
('f4d60a5f8aa37d7da0343746931d81f6', './templates/tiki-object_watches.tpl', '15.9', 0),
('da3051181b79751ad60a47bbae209dd6', './templates/tiki-objectpermissions.tpl', '15.9', 0),
('2d3f416ac2ad2e0785c3241fb559e066', './templates/tiki-old_polls.tpl', '15.9', 0),
('ad2290cb39d29ff4f6b64bdf05725b82', './templates/tiki-openid_select.tpl', '15.9', 0),
('8cc99a1d3df4ded7b536aff4b57e1f2b', './templates/tiki-orphan_pages.tpl', '15.9', 0),
('ddd4f2df35a8a43c254e81946fa0360b', './templates/tiki-page.tpl', '15.9', 0),
('a3133cc246225b45dc81b47a03b38e55', './templates/tiki-page_bar.tpl', '15.9', 0),
('36a50c0f6575493d7fa2b4247099493b', './templates/tiki-page_contribution.tpl', '15.9', 0),
('ade07afb7ab03fd89f68d537b723be8e', './templates/tiki-page_contribution_form.tpl', '15.9', 0),
('fe50cacb315f919c5520d4a66d15bccd', './templates/tiki-pagehistory.tpl', '15.9', 0),
('551442b57b691ed75efa58ca06f43130', './templates/tiki-payment-cclite.tpl', '15.9', 0),
('b4907aaa70c612bc1a9023054494d783', './templates/tiki-payment-israelpost.tpl', '15.9', 0),
('17d8f302ae3af2028764391c9c595a70', './templates/tiki-payment-list-past.tpl', '15.9', 0),
('ae0c8913d6971835edf278d1b284019f', './templates/tiki-payment-list.tpl', '15.9', 0),
('b64fbecccefdfe72f6c65ab972f9cb5a', './templates/tiki-payment-paypal.tpl', '15.9', 0),
('ea62626b270f4c20aee6df50855b9267', './templates/tiki-payment-single.tpl', '15.9', 0),
('be2775c9c79a1debade17dbb47d10960', './templates/tiki-payment-tikicredits.tpl', '15.9', 0),
('c83c2d7169f0be6f7b04962939981257', './templates/tiki-payment-user.tpl', '15.9', 0),
('6c1089c913d93cfc891962989bf12685', './templates/tiki-payment.tpl', '15.9', 0),
('bd83298f5084b8f538016f98438f84f2', './templates/tiki-pick_avatar.tpl', '15.9', 0),
('3442b5d9cf98e7efd13ba3cef87ee107', './templates/tiki-plugin_blocked.tpl', '15.9', 0),
('0f8f80c8cb1131922e7ae33248644b01', './templates/tiki-plugin_help.tpl', '15.9', 0),
('c6647f3362368d66a6fb3dd96cedbd52', './templates/tiki-plugin_poll.tpl', '15.9', 0),
('f272668084d8554877a23474ec6c8805', './templates/tiki-plugin_sql.tpl', '15.9', 0),
('f749e041ebd96c7880334becc0f55a3d', './templates/tiki-plugins.tpl', '15.9', 0),
('5dbc29fccc09c19c5fd64e9a32dbc123', './templates/tiki-poll.tpl', '15.9', 0),
('c0dece51d6ea1766ef5f4972b92d3851', './templates/tiki-poll_form.tpl', '15.9', 0),
('4cb46e032ed2ca1282692dc390c7d0fe', './templates/tiki-poll_results.tpl', '15.9', 0),
('540a866d1b63df14966cbc8fc22ee39a', './templates/tiki-poll_results_bar.tpl', '15.9', 0),
('302866248b7326ed2d0c87732794dd54', './templates/tiki-preview.tpl', '15.9', 0),
('b0aaea735b18d89ae4e5195785686ed9', './templates/tiki-print.tpl', '15.9', 0),
('7594fd872912d24d83b8bbceab793d1f', './templates/tiki-print_article.tpl', '15.9', 0),
('49f86bce4953e23eba0ba1a84163567f', './templates/tiki-print_blog_post.tpl', '15.9', 0),
('2aa24d4a3666500f29a5ad9fa54d18ec', './templates/tiki-print_forum_thread.tpl', '15.9', 0),
('a3c28c650d09596c80162ac8f0d8cdc0', './templates/tiki-print_multi_pages.tpl', '15.9', 0),
('0f60ebe01d19d9a443806a457c95271e', './templates/tiki-print_pages.tpl', '15.9', 0),
('9f6ec9ed5649b5d37801f9768ed12442', './templates/tiki-quiz_edit.tpl', '15.9', 0),
('8385c428e9c4660292affb5816040040', './templates/tiki-quiz_result_stats.tpl', '15.9', 0),
('538de57a3bae5c2ea0947339a5c557d8', './templates/tiki-quiz_stats.tpl', '15.9', 0),
('968296ec05b6e2431a30d76ac06b75a1', './templates/tiki-quiz_stats_quiz.tpl', '15.9', 0),
('c2a05919f3d149ea54b502824004bf52', './templates/tiki-ranking.tpl', '15.9', 0),
('f173140cc9b64d0d0df349da1e35e908', './templates/tiki-read_article.tpl', '15.9', 0),
('cfe90a0118d0926b1d90e0265a28b178', './templates/tiki-received_articles.tpl', '15.9', 0),
('1364e71491460f743500ebba3abfd5dc', './templates/tiki-received_pages.tpl', '15.9', 0),
('0d439bdd8a698c9c76ef370abecc4b5e', './templates/tiki-references.tpl', '15.9', 0),
('2ab5b320c154887ae7cabb11a2a81155', './templates/tiki-referer_stats.tpl', '15.9', 0),
('64758064df07d451f55da6a9c5c68691', './templates/tiki-register.tpl', '15.9', 0),
('0947f6de570b6fc600e53b79db4e6c65', './templates/tiki-register_site.tpl', '15.9', 0),
('23060c4cd092fd1c9c501e7a11937fa0', './templates/tiki-remind_password.tpl', '15.9', 0),
('07d4e98523a6a7c176d2f862a9980105', './templates/tiki-removepage.tpl', '15.9', 0),
('8f5663b2ea1c5ed284444fabd3a78ce5', './templates/tiki-rename_page.tpl', '15.9', 0),
('f270606bcaf8369dbdb1fff21fd3db70', './templates/tiki-report_direct_object_perms.tpl', '15.9', 0),
('d2faf80efad099a157d6ad5532185d8a', './templates/tiki-report_string_in_db.tpl', '15.9', 0),
('4b0f29df75cde6e4d9934b68dd1a08ea', './templates/tiki-rollback.tpl', '15.9', 0),
('40c819d8c9c8f40b4d265a524f1f1d04', './templates/tiki-search_count.tpl', '15.9', 0),
('d133da1e358c752d5dabd4d05b69622c', './templates/tiki-search_replace.tpl', '15.9', 0),
('954802777d39baacdf932bffd7859160', './templates/tiki-search_stats.tpl', '15.9', 0),
('165738cf76bdf23c5cacb54c660ba001', './templates/tiki-searchfacets.tpl', '15.9', 0),
('20ccffc5b6b12dc2ec6329872c80dba1', './templates/tiki-searchindex.tpl', '15.9', 0),
('848cfa879f44bfdee65a2fc6480d6c0d', './templates/tiki-searchindex_form.tpl', '15.9', 0),
('34d5d6420b304d132a7850d11691c250', './templates/tiki-searchresults.tpl', '15.9', 0),
('55bbc02b4e0426cacd7ad54e11b7980a', './templates/tiki-send_newsletters.tpl', '15.9', 0),
('90ceed4199c5775f941c2970ae71b43c', './templates/tiki-send_objects.tpl', '15.9', 0),
('98f226a559f7a2b8546085857156760f', './templates/tiki-share.tpl', '15.9', 0),
('23a225f1b1881473d4839854a259856f', './templates/tiki-sheets.tpl', '15.9', 0),
('75b5a52f73b7b739fa639f594d1e5536', './templates/tiki-sheets_listing.tpl', '15.9', 0),
('89b0f4244aebb895997b8996475b8abd', './templates/tiki-shoutbox.tpl', '15.9', 0),
('80c24e7a398ca2c98a6288ec086ef8a7', './templates/tiki-show_page.tpl', '15.9', 0),
('1be3873edd9a7e325e0691c7b2c248a6', './templates/tiki-show_page_raw.tpl', '15.9', 0),
('103bd70184d2e19faa83f16373619bce', './templates/tiki-socialnetworks.tpl', '15.9', 0),
('69130f06658e0ccd71ce5bbbd87d0b75', './templates/tiki-socialnetworks_firstlogin.tpl', '15.9', 0),
('a3bc42d0112ac8454f7eac162fcb0ff6', './templates/tiki-socialnetworks_firstlogin_launcher.tpl', '15.9', 0),
('86dfab0bf817c498fa1d5f4596cb2015', './templates/tiki-sqllog.tpl', '15.9', 0),
('0904b85a8d9e923b868f6e971d137744', './templates/tiki-stats.tpl', '15.9', 0),
('8e75c9df557485333c6dda74fd71b400', './templates/tiki-survey_stats.tpl', '15.9', 0),
('8a90c9eb726e64632841959f59bdfcfe', './templates/tiki-survey_stats_survey.tpl', '15.9', 0),
('f05c44d60bfe8acff3e3944344cb60e2', './templates/tiki-syslog.tpl', '15.9', 0),
('d98d29bbfbe985a6905bfad3c2c9ef39', './templates/tiki-take_quiz.tpl', '15.9', 0),
('0b2b2886b9e21efe7c17b806c1452f63', './templates/tiki-take_survey.tpl', '15.9', 0),
('c74d1a6e59362559a24bf91ecca23458', './templates/tiki-tell_a_friend.tpl', '15.9', 0),
('f50c84ebd1485c861d8d8440981c198d', './templates/tiki-tests_edit.tpl', '15.9', 0),
('780c9d20d7660cc02947664a763b964e', './templates/tiki-tests_list.tpl', '15.9', 0),
('200ee71c0ef3fbae83e96b523934af71', './templates/tiki-tests_menubar.tpl', '15.9', 0),
('44cad97cbf4b22e3e59c05e8615f8b4a', './templates/tiki-tests_record.tpl', '15.9', 0),
('ce7df9d29e755b48129c3470fbba738d', './templates/tiki-tests_replay.tpl', '15.9', 0),
('95246b3f3dde419344d5a49cc1239d6c', './templates/tiki-tests_topbar.tpl', '15.9', 0),
('bd1fb2626d4c82c6bc8af27571abecfd', './templates/tiki-theme_control.tpl', '15.9', 0),
('59b9a2a469bcef21d7e11c5d0cad95e9', './templates/tiki-theme_control_objects.tpl', '15.9', 0),
('2ffefdfd6d186ad621805d7f3b2dce5c', './templates/tiki-theme_control_sections.tpl', '15.9', 0),
('a99f283935c3d34f280693f635e70000', './templates/tiki-timesheet.tpl', '15.9', 0),
('ae8bfaf87411254cf18c325fe6caab67', './templates/tiki-tracker_reports.tpl', '15.9', 0),
('9753359541e87e4d7869820978a17410', './templates/tiki-tracker_view_history.tpl', '15.9', 0),
('f1352e7a3cd6a77fbd5df1fe3fbb865c', './templates/tiki-upload_file.tpl', '15.9', 0),
('dd295f24549fc96de69975d589e59e6f', './templates/tiki-upload_file_progress.tpl', '15.9', 0),
('7d97c16c9de88eeb5340cd9e4d32f7e2', './templates/tiki-upload_image.tpl', '15.9', 0),
('3447c3c3d97c31542994e25947114fdb', './templates/tiki-user_assigned_modules.tpl', '15.9', 0),
('0e774e9e63b62dea4a7fb739aa15e202', './templates/tiki-user_bookmarks.tpl', '15.9', 0),
('c32551339a05c738c64413508d009f07', './templates/tiki-user_contacts_prefs.tpl', '15.9', 0),
('093b2239db31cfe7921786a66906f1a0', './templates/tiki-user_cssmenu.tpl', '15.9', 0),
('96f727f105d84f21a039d8e5ecc65d8a', './templates/tiki-user_information.tpl', '15.9', 0),
('5304cee69e45ebeb0203d5f9967c52aa', './templates/tiki-user_mailin.tpl', '15.9', 0),
('340eead5093dd028a26cefc68d834ba6', './templates/tiki-user_menu.tpl', '15.9', 0),
('a33dc7fbcdeba73e92a327551b9c4357', './templates/tiki-user_preferences.tpl', '15.9', 0),
('37daef80bdb84c815a12c4b694713b43', './templates/tiki-user_tasks.tpl', '15.9', 0),
('726d3c8883dc4fd3fc10bfdd4e0c1845', './templates/tiki-user_tasks_edit.tpl', '15.9', 0),
('02c1fe3a5486fd7f5ce868c91c264b31', './templates/tiki-user_tasks_list.tpl', '15.9', 0),
('bfa5d2d0c3264f3da262b8248681e951', './templates/tiki-user_tasks_view.tpl', '15.9', 0),
('6ec7a94c832246dfce3c9aabc2102204', './templates/tiki-user_unified_details.tpl', '15.9', 0),
('b9cd7b81799b73c53da837b261fc5cb5', './templates/tiki-user_watches.tpl', '15.9', 0),
('0dee1f196b8b1df8c40b8a5f726a6eb3', './templates/tiki-userfiles.tpl', '15.9', 0),
('20579b2fe8558974a9f02f159f8590aa', './templates/tiki-usermenu.tpl', '15.9', 0),
('be6834a6175e3bd9bad93e2ef8093cfb', './templates/tiki-userversions.tpl', '15.9', 0),
('541fccea8c61f5aa4ebe3c4dfd0956b7', './templates/tiki-view_articles-titleonly.tpl', '15.9', 0),
('2042e32d09483769272eba570570ef3a', './templates/tiki-view_articles.tpl', '15.9', 0),
('7fc1d97f8d81fc84393a439af554ed87', './templates/tiki-view_banner.tpl', '15.9', 0),
('32d6dfcb380674b295faf34e65c661be', './templates/tiki-view_blog.tpl', '15.9', 0),
('1420ee2d7f430f833e152e064326e742', './templates/tiki-view_blog_post.tpl', '15.9', 0),
('0202745dcdb061cd5a1859cf1298bc02', './templates/tiki-view_cache.tpl', '15.9', 0),
('23b12e5a82294aec735ff9eedccc6cea', './templates/tiki-view_faq.tpl', '15.9', 0),
('2bd9b1b91a155f4c3fbc65aa8c0472a4', './templates/tiki-view_forum.tpl', '15.9', 0),
('556068ffbd2a7821d0402f179bd36b1b', './templates/tiki-view_forum_thread.tpl', '15.9', 0),
('0a7abe30ce1190d6b417bb4d65879df6', './templates/tiki-view_invoice.tpl', '15.9', 0),
('c5afbe97ada064f27a7c6dda14ebf886', './templates/tiki-view_sheets.tpl', '15.9', 0),
('c5d54afbd143a6e7bb2b8ddede085cc0', './templates/tiki-view_sheets_menu.tpl', '15.9', 0),
('c73168fdaa7623c5ca7df95ececa6100', './templates/tiki-view_tracker.tpl', '15.9', 0),
('1371540630ee63751bcd356e28eac0d5', './templates/tiki-view_tracker_item.tpl', '15.9', 0),
('eb14dada771e1633207c0655a9e98d96', './templates/tiki-view_tracker_more_info.tpl', '15.9', 0),
('db394b034f63a9478fd9cc3b43840455', './templates/tiki-webdav-wiki.tpl', '15.9', 0),
('930680c6da83fa5a82721f0ca03362ca', './templates/tiki-webdav.tpl', '15.9', 0),
('f920631659f3782966c1a75d53adce16', './templates/tiki-webmail.tpl', '15.9', 0),
('8281025a46003a6f917d326a71c71741', './templates/tiki-webmail_contacts.tpl', '15.9', 0),
('41e25120c414dcc416b96b729f35c6b8', './templates/tiki-wiki_structure_bar.tpl', '15.9', 0),
('f527eb6432106548d3f8d7206554fa43', './templates/tiki-wiki_topline.tpl', '15.9', 0),
('96d37c0fa92faca9f1ef2260243d962a', './templates/tiki-wizard_admin.tpl', '15.9', 0),
('99f1b0d3db2973d9ed21e038a8dcdbd5', './templates/tiki-wizard_user.tpl', '15.9', 0),
('b5741e5badbb51782d76e904d34d48e4', './templates/tiki.tpl', '15.9', 0),
('c2ef12f94e2875050e753649b1113ad6', './templates/tiki_full.tpl', '15.9', 0),
('70a29b0a602c01f9e8cf38b9796e9684', './templates/tracker/add_field.tpl', '15.9', 0),
('6214f0e3bdd5c58b4835450d6285047b', './templates/tracker/clear.tpl', '15.9', 0),
('017999e9c36602f69788c5cdb3e27a65', './templates/tracker/clone_item.tpl', '15.9', 0),
('126b05eaa80e066189737748e7e7508d', './templates/tracker/duplicate.tpl', '15.9', 0),
('7e690d3089a256bd6bdaa4e9c7ea57d7', './templates/tracker/edit_field.tpl', '15.9', 0),
('384fe89a66be4b1437db1856aef0750a', './templates/tracker/export.tpl', '15.9', 0),
('ac32c029dfc5955df861ac5bad371d2a', './templates/tracker/export_fields.tpl', '15.9', 0),
('669cce25d28a9de0ad49d37f4222bbf0', './templates/tracker/export_profile.tpl', '15.9', 0),
('5bee298d074c6fd6f26b5074230dd653', './templates/tracker/fetch_item_field.tpl', '15.9', 0),
('029c12ff670a67930c4278ac261b14b9', './templates/tracker/import.tpl', '15.9', 0),
('b7ab3066c3d9069f937a51ef033b877f', './templates/tracker/import_fields.tpl', '15.9', 0),
('dc91525c47760d6dcedea0ca96c3d3dd', './templates/tracker/import_items.tpl', '15.9', 0),
('8052a8460074c8f3e96036e66bf68876', './templates/tracker/import_profile.tpl', '15.9', 0),
('16c5e703fcb53f59fb2194aaed3fb969', './templates/tracker/index.php', '15.9', 0),
('679d7d3681a7cf79c5a8c5fb8103c5c1', './templates/tracker/insert_item.tpl', '15.9', 0),
('6bc6b12481f4cb22979677df94c75676', './templates/tracker/remove.tpl', '15.9', 0),
('32cf39d436001f2e1e7a2f650c5079cd', './templates/tracker/remove_fields.tpl', '15.9', 0),
('5ad10fdb5d149318dff1a54aa730e428', './templates/tracker/remove_item.tpl', '15.9', 0),
('82d8b77924270a8f28515caaf327c1f9', './templates/tracker/replace.tpl', '15.9', 0),
('0364cf0027f19c9ac62d195d019bd4c5', './templates/tracker/search_help.tpl', '15.9', 0),
('4e3df7999b652d15fb6127f04c5970ee', './templates/tracker/select_tracker.tpl', '15.9', 0),
('005aa8dd332fe9d56b507b63b35676cf', './templates/tracker/update_item.tpl', '15.9', 0),
('c9842d065d0d1574a70d3753a8b6fac4', './templates/tracker/update_item_status.tpl', '15.9', 0),
('8deff7f774fa1bf64a9d2946b7249b4c', './templates/tracker/view.tpl', '15.9', 0),
('36d4830b976feead476b7acade12bf07', './templates/tracker_actions.tpl', '15.9', 0),
('768ada1b1837a1bad599c69fe3bb0426', './templates/tracker_calendar_over.tpl', '15.9', 0),
('4e87b8ce94977d9bfc12db4b17f166cb', './templates/tracker_error.tpl', '15.9', 0),
('f40f64063e7267c52b643351c107dcc2', './templates/tracker_filter.tpl', '15.9', 0),
('9e514ea9ca283d55194fc4ecb05fcdb5', './templates/tracker_input_field.tpl', '15.9', 0),
('368b23de2d7bd74ab852c3402890fc2b', './templates/tracker_pretty_item.tpl', '15.9', 0),
('719b6456693fc174ad3f301dc862d689', './templates/tracker_sort_input.tpl', '15.9', 0),
('f6bb4b0f860c38b7906d3258a1c0088c', './templates/tracker_status_input.tpl', '15.9', 0),
('be5380a2df6f267deab312365d7d7646', './templates/tracker_sync/clone_remote.tpl', '15.9', 0),
('16c5e703fcb53f59fb2194aaed3fb969', './templates/tracker_sync/index.php', '15.9', 0),
('16c5e703fcb53f59fb2194aaed3fb969', './templates/tracker_todo/index.php', '15.9', 0),
('b0a4886b5009d9e795fe1981ad9e27f6', './templates/tracker_todo/view.tpl', '15.9', 0),
('a86cd11cbb477e159404473e2c3c0a4e', './templates/tracker_validator.tpl', '15.9', 0),
('34b22c1db9834b1fd640a08d4ad04122', './templates/trackerinput/articles.tpl', '15.9', 0),
('72cc67de041e555b176a8e769055ce43', './templates/trackerinput/autoincrement.tpl', '15.9', 0),
('a10b6a6121dda6aab875c3abf1899773', './templates/trackerinput/category.tpl', '15.9', 0),
('739faf658ead1b50af096829aeb07d2b', './templates/trackerinput/checkbox.tpl', '15.9', 0),
('38498f9c61cd5a1bcfee0d82ea7bfde0', './templates/trackerinput/countryselector.tpl', '15.9', 0),
('30f8057570fea523cbc2dfd65e27892b', './templates/trackerinput/datetime.tpl', '15.9', 0),
('5715d8662959159acc6edf08c829b740', './templates/trackerinput/dropdown.tpl', '15.9', 0),
('10ec7b9c3f11d7e5f60daa7642188ef9', './templates/trackerinput/email.tpl', '15.9', 0),
('d7e9bec12f607f0636a96a10c5441e7e', './templates/trackerinput/file.tpl', '15.9', 0),
('9a51ec268c707502ad7c6a50da6c37d4', './templates/trackerinput/files.tpl', '15.9', 0),
('150649b92d1c63ea08ab7c4d43530d81', './templates/trackerinput/freetags.tpl', '15.9', 0),
('9b6e1847215fa801d6650bead1f7a608', './templates/trackerinput/groupselector.tpl', '15.9', 0),
('b329e3f2bb2f8d623951ca8f978caba1', './templates/trackerinput/icon.tpl', '15.9', 0),
('eedcee6dfa242ef8bf641d24d6f8fc84', './templates/trackerinput/image.tpl', '15.9', 0),
('16c5e703fcb53f59fb2194aaed3fb969', './templates/trackerinput/index.php', '15.9', 0),
('a7c5fc2c155249e6ab97219e6e5f7e29', './templates/trackerinput/ip.tpl', '15.9', 0),
('63095dcbc1748af915012114830b8788', './templates/trackerinput/itemlink.tpl', '15.9', 0),
('c4952b667d51b47643610fcecdff4150', './templates/trackerinput/itemlink_selector.tpl', '15.9', 0),
('a017bb715058b0ba93203a49c5544731', './templates/trackerinput/kaltura.tpl', '15.9', 0),
('bb44c01153f9f0697834a898241e3109', './templates/trackerinput/language.tpl', '15.9', 0),
('fce9466cfdd2f1940bb3154549520eb5', './templates/trackerinput/layout_flat.tpl', '15.9', 0),
('5bcae163ecdc8c08ddf897f5110bb257', './templates/trackerinput/layout_tab.tpl', '15.9', 0),
('522d0dd4a22ae21b6e8ceecfd5b79173', './templates/trackerinput/location.tpl', '15.9', 0),
('7361afd0572b29228b9236b6bae74e9a', './templates/trackerinput/numeric.tpl', '15.9', 0),
('fcad9902e3c44991dae6765e795af0d3', './templates/trackerinput/pageselector.tpl', '15.9', 0),
('d74b78121c00c0b6fe240356c2b8a23b', './templates/trackerinput/rating.tpl', '15.9', 0),
('7fa44b41a0652205084eee4f4634eb92', './templates/trackerinput/relation.tpl', '15.9', 0),
('042f99b0643a188d197b20e0790c085d', './templates/trackerinput/showtikiorg.tpl', '15.9', 0),
('f78f93e64bb2ee00c44b4603f27cdc74', './templates/trackerinput/statictext.tpl', '15.9', 0),
('f681ac0144b7b0df53e2f78508bcf320', './templates/trackerinput/status.tpl', '15.9', 0),
('4537a53caf71e6db3a80cfeeae01bd5e', './templates/trackerinput/text.tpl', '15.9', 0),
('9a45ceb06facb76d60b60dce8f3699ec', './templates/trackerinput/textarea.tpl', '15.9', 0),
('99652e7359cd5c1c7d6067fabbc1b7e6', './templates/trackerinput/url.tpl', '15.9', 0),
('510a2dc87a9bb921de960a9e6b3edcd3', './templates/trackerinput/userpreference.tpl', '15.9', 0),
('163422318ab613d775c91f6873d6e15b', './templates/trackerinput/usersubscription.tpl', '15.9', 0),
('0ff9a55102b4fbcf1d2a7096fcefac26', './templates/trackerinput/wiki.tpl', '15.9', 0),
('86465ec8986c59128e96e0b3feaa5e42', './templates/trackeroutput/articles.tpl', '15.9', 0),
('a5ee80e36752bed8842bef5be16990b5', './templates/trackeroutput/computed.tpl', '15.9', 0),
('ded7e271da6f6cf6899785a79244e597', './templates/trackeroutput/currency.tpl', '15.9', 0),
('013bb12adb2d542aa7bcf1c314f0c66c', './templates/trackeroutput/files_googleviewer.tpl', '15.9', 0),
('d5c2eb66bb625ee678934da0ddbcc84a', './templates/trackeroutput/freetags.tpl', '15.9', 0),
('b8780c0ad38bc031adcdfc34c212ce07', './templates/trackeroutput/icon.tpl', '15.9', 0),
('16c5e703fcb53f59fb2194aaed3fb969', './templates/trackeroutput/index.php', '15.9', 0),
('3f2b0702564343a2de3e15737a1a3411', './templates/trackeroutput/itemslist.tpl', '15.9', 0),
('8d6d1c152eb8182c427dd46328cd0d4d', './templates/trackeroutput/language.tpl', '15.9', 0),
('28e3c9c95bf3493ed26bf107e70771c2', './templates/trackeroutput/layout_flat.tpl', '15.9', 0),
('270a4c77575cffb1fcb1858b167696b3', './templates/trackeroutput/layout_tab.tpl', '15.9', 0),
('5eb4a3f2847c76a0dd9c2ca398c6cfad', './templates/trackeroutput/location.tpl', '15.9', 0),
('00ba09eaf8d09a6771a3e6604d05139f', './templates/trackeroutput/numeric.tpl', '15.9', 0),
('b462782c3d6c9e4c4276fa71ac4b20d3', './templates/trackeroutput/popup.tpl', '15.9', 0),
('d40e707e3e2511872c8ddc98c5039a00', './templates/trackeroutput/rating.tpl', '15.9', 0),
('05a04b65d75f582106f8a1224fd529f4', './templates/trackeroutput/relation.tpl', '15.9', 0),
('42189d5d9ff21720f400724faa4d7db1', './templates/trackeroutput/text_history.tpl', '15.9', 0),
('87157b4a4f32966b8785f521885c17b3', './templates/trackeroutput/usergroups.tpl', '15.9', 0),
('8aa914f81dcc80981bc325b07e73cc83', './templates/trackeroutput/usersubscription.tpl', '15.9', 0),
('716b922440bec7556c3f1cdc4be2f147', './templates/translated-lang.tpl', '15.9', 0),
('afbf905ce239b5dc97c8264d080dba2e', './templates/translation/detach.tpl', '15.9', 0),
('16c5e703fcb53f59fb2194aaed3fb969', './templates/translation/index.php', '15.9', 0),
('29f2729db698615a017f55b6b8f14477', './templates/translation/manage.tpl', '15.9', 0),
('5045698209fd006d6748b951f168fe37', './templates/user/email_wikipage.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/user/index.php', '15.9', 0),
('24e440f353252b1da18f6f77a6b32912', './templates/user/info.tpl', '15.9', 0),
('c64431fd22eb4dbb279f7eefbd1f7ea5', './templates/user/manage_groups.tpl', '15.9', 0),
('225298738b7a1a9c079b1d045a97596e', './templates/user/register.tpl', '15.9', 0),
('818c92fe7a3977a432d3467769f32812', './templates/user/remove_users.tpl', '15.9', 0),
('ad40c0545876df1b375cbd16be84d2ad', './templates/user/send_message.tpl', '15.9', 0),
('fdb780941119a3b9f98f5a15ca4a748b', './templates/user_conditions/age_validation.tpl', '15.9', 0),
('3f632cd9216a9c9dfb0b1ce4c2044d0e', './templates/user_conditions/approval.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/user_conditions/index.php', '15.9', 0),
('6ee19f57c4085bcf0f5d1b92e0e1ca9f', './templates/user_registration.tpl', '15.9', 0),
('fc84f30a40c1492a027e3a1535dae62d', './templates/utilities/alert.tpl', '15.9', 0),
('e6c2ea5ee4b1e84d74e1c92cfa022313', './templates/utilities/alert_button.tpl', '15.9', 0),
('3175a37ed201a93ff642c40175ba5ba6', './templates/utilities/feedback.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/utilities/index.php', '15.9', 0),
('38c3655a891e7e9a8f27c05f2350bb6c', './templates/utilities/modal_alert.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/vimeo/index.php', '15.9', 0),
('49d933826696dbc7cb519ae7104717bb', './templates/vimeo/upload.tpl', '15.9', 0),
('194abcc2e9b99a5d78a48267d89e61db', './templates/vimeo/view.tpl', '15.9', 0),
('554c06f6d097d9cefd8f428317001e89', './templates/wiki-discussion.tpl', '15.9', 0),
('577a118e7d5d7fc6ba24bafd1fd62aef', './templates/wiki-plugins/error_tracker.tpl', '15.9', 0),
('16c5e703fcb53f59fb2194aaed3fb969', './templates/wiki-plugins/index.php', '15.9', 0),
('515733fcbef26ecb6f3bf485c44bd223', './templates/wiki-plugins/trackercalendar.tpl', '15.9', 0),
('0e4aa84fc6466db96bda5e272652cf55', './templates/wiki-plugins/wikiplugin_addfreetag.tpl', '15.9', 0),
('8a3920d972cf3e5e7d0d6ea27e479961', './templates/wiki-plugins/wikiplugin_addreference.tpl', '15.9', 0),
('0f5d9d4d1236fb6df2bedc5ad9f50e2f', './templates/wiki-plugins/wikiplugin_addrelation.tpl', '15.9', 0),
('79d8f32b0c586e3dcd92b40b36ae85ea', './templates/wiki-plugins/wikiplugin_addtocart.tpl', '15.9', 0),
('fdbdb5a247070360a279fec3fac8420c', './templates/wiki-plugins/wikiplugin_adjustinventory.tpl', '15.9', 0),
('9f53715ad201949a55e8ef242d197caf', './templates/wiki-plugins/wikiplugin_appframe_mapcontrol.tpl', '15.9', 0),
('e9c9d051b97c919b5dcfac1bb1b2c6b7', './templates/wiki-plugins/wikiplugin_bigbluebutton.tpl', '15.9', 0),
('2c97f0cb94df7652a6a5160fe0431cff', './templates/wiki-plugins/wikiplugin_bigbluebutton_create.tpl', '15.9', 0),
('190c701364fe95d8dd0de189eecc3b01', './templates/wiki-plugins/wikiplugin_bigbluebutton_view_recordings.tpl', '15.9', 0),
('54911fea7356dda6abd604072ac544a0', './templates/wiki-plugins/wikiplugin_bloglist.tpl', '15.9', 0),
('e67b6e3eda1c7c44956bcba3655725ea', './templates/wiki-plugins/wikiplugin_categorytransition.tpl', '15.9', 0),
('2773555fdbc7c4bc722177e98c9f1e91', './templates/wiki-plugins/wikiplugin_catorphans.tpl', '15.9', 0),
('fa9be2c234e1dbd5e1cd47476ca3bd20', './templates/wiki-plugins/wikiplugin_cclite.tpl', '15.9', 0),
('91f477e182a187c9ec164ac148bbd431', './templates/wiki-plugins/wikiplugin_colobox.tpl', '15.9', 0),
('3a7210a82d692eb58620c24c156d1a1f', './templates/wiki-plugins/wikiplugin_comment.tpl', '15.9', 0),
('a7eedd84c67b6ab8800831513429e1ef', './templates/wiki-plugins/wikiplugin_datachannel.tpl', '15.9', 0),
('24facea5f8606cd4786a3f7c1cf03b8b', './templates/wiki-plugins/wikiplugin_events.tpl', '15.9', 0),
('74d245470b4077830daec722c51e5b4d', './templates/wiki-plugins/wikiplugin_favorite.tpl', '15.9', 0),
('74cfa067e81e6598cd791fb32c9155eb', './templates/wiki-plugins/wikiplugin_files.tpl', '15.9', 0),
('6cd6e6b88ad99f83889e93442a2859b9', './templates/wiki-plugins/wikiplugin_freetagged.tpl', '15.9', 0),
('47445f3a64adde8eb10f9c0eb36fafa4', './templates/wiki-plugins/wikiplugin_friend.tpl', '15.9', 0),
('c0cfecf953b1eaf8ded2f6f502f8e050', './templates/wiki-plugins/wikiplugin_ftp.tpl', '15.9', 0),
('04f016d8eb2cf9191bc0272fa81626d6', './templates/wiki-plugins/wikiplugin_fullwidthtitle.tpl', '15.9', 0),
('1ad40b2a2c048db54251cc1b577a9184', './templates/wiki-plugins/wikiplugin_galleriffic.tpl', '15.9', 0),
('df3914373aae9f073deb084a91d3f595', './templates/wiki-plugins/wikiplugin_grouplist.tpl', '15.9', 0),
('5ece03a9b78c2aa37679326346068733', './templates/wiki-plugins/wikiplugin_groupstat.tpl', '15.9', 0),
('a6a07828f8dd6b5f7a05429765bebfdd', './templates/wiki-plugins/wikiplugin_invite.tpl', '15.9', 0),
('5723922e0187a2692db0822b5f3af925', './templates/wiki-plugins/wikiplugin_kaltura.tpl', '15.9', 0),
('97d0255286dd0bf00452ca0b1b0a83c5', './templates/wiki-plugins/wikiplugin_like.tpl', '15.9', 0),
('d804a7b3c5a3f7adb4bce436ae51cc5e', './templates/wiki-plugins/wikiplugin_listexecute.tpl', '15.9', 0),
('2fc3b033e81d1bc8cbe8f135284f52e0', './templates/wiki-plugins/wikiplugin_listpagenames.tpl', '15.9', 0),
('b9072b408b2653f10d6a2a7c5312b7af', './templates/wiki-plugins/wikiplugin_localfiles.tpl', '15.9', 0),
('4a6383365a70867c4058c4a04684cebe', './templates/wiki-plugins/wikiplugin_mail.tpl', '15.9', 0),
('1e87af3ee32476ea86ac7dbb88eac981', './templates/wiki-plugins/wikiplugin_memberlist.tpl', '15.9', 0),
('ec424c565b824dcb82ee51d2e622c586', './templates/wiki-plugins/wikiplugin_memberpayment.tpl', '15.9', 0),
('bfc2532eb30eb3df416ed2769c5ea576', './templates/wiki-plugins/wikiplugin_paypal.tpl', '15.9', 0),
('214c0b8b8335673b748b411411ea676f', './templates/wiki-plugins/wikiplugin_playscorm.tpl', '15.9', 0),
('e38b99a7c48ee2871c4a491467615f93', './templates/wiki-plugins/wikiplugin_profile.tpl', '15.9', 0),
('b166eb062524d48f53d253d2b3ba5222', './templates/wiki-plugins/wikiplugin_proposal.tpl', '15.9', 0),
('7b6306f39261460076c20756d5f0a56b', './templates/wiki-plugins/wikiplugin_relations.tpl', '15.9', 0),
('a49e9305c7ea0ae027307d58d36287ad', './templates/wiki-plugins/wikiplugin_rss.tpl', '15.9', 0),
('c5fc49432bcf3fa4ca93d8366984f7ad', './templates/wiki-plugins/wikiplugin_shopperinfo.tpl', '15.9', 0),
('4ade3a5bdd8687bb2294c8940cd2d8b6', './templates/wiki-plugins/wikiplugin_sign.tpl', '15.9', 0),
('2c888d0ae064492428ddd59f048b7e92', './templates/wiki-plugins/wikiplugin_snarf.tpl', '15.9', 0),
('0b35a2fa19cae89b2e015bce1eb66675', './templates/wiki-plugins/wikiplugin_stat.tpl', '15.9', 0),
('f0ecf62461481118f406a36f8c7f1cfb', './templates/wiki-plugins/wikiplugin_subscribegroup.tpl', '15.9', 0),
('b058241f30a7d5a713afd550a3b12015', './templates/wiki-plugins/wikiplugin_subscribegroups.tpl', '15.9', 0),
('a6301d72aaa1c0cf71e187f9662fc498', './templates/wiki-plugins/wikiplugin_subscribenewsletter.tpl', '15.9', 0),
('91c18495e24a8358feb82e790d72d5bd', './templates/wiki-plugins/wikiplugin_tabs.tpl', '15.9', 0),
('959e14c8bad5a2ae0347d9bdfcb6a8f3', './templates/wiki-plugins/wikiplugin_timesheet.tpl', '15.9', 0),
('1c459df3e97a52bd9ac3355154dda8e5', './templates/wiki-plugins/wikiplugin_trackerfilter.tpl', '15.9', 0),
('94782c805a8941561f5c219b864f6d10', './templates/wiki-plugins/wikiplugin_trackerlist.tpl', '15.9', 0),
('21e13c1207a86aa188859c413e309f6b', './templates/wiki-plugins/wikiplugin_trackerprefill.tpl', '15.9', 0),
('fbbd5a88aa3404bbbcc76dab3bde3ca6', './templates/wiki-plugins/wikiplugin_trackerstat.tpl', '15.9', 0),
('c96a06bd7f1a557015a3b694ae0f047b', './templates/wiki-plugins/wikiplugin_trackertimeline.tpl', '15.9', 0),
('b6b99d70df2a6f87dab1cea6a29abcd5', './templates/wiki-plugins/wikiplugin_trade.tpl', '15.9', 0),
('52f0e0928674160ec5f7a3824de2fe5c', './templates/wiki-plugins/wikiplugin_vote.tpl', '15.9', 0),
('fa592fe925a35b538d8e37819e910957', './templates/wiki-plugins/wikiplugin_xmlupdate.tpl', '15.9', 0),
('a346511262936022deb75e566baadb8f', './templates/wiki/get_page.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/wiki/index.php', '15.9', 0),
('a803fafdcd6bce70d67ba32cda7998e3', './templates/wiki/regenerate_slugs.tpl', '15.9', 0),
('23896a02051160594f2c3ac0fdfaeb01', './templates/wiki_authors.tpl', '15.9', 0),
('b81d98a7d53d82bcec5eee9f9bd69893', './templates/wiki_edit.tpl', '15.9', 0),
('b0f8d82b7ae35dfc3ca3bcdc9a335e2d', './templates/wiki_edit_actions.tpl', '15.9', 0),
('42c7d0096b716ae5d84c96755c4c4cb7', './templates/wizard/admin_advanced.tpl', '15.9', 0),
('9174badf46809b9571dc2c5febf247e8', './templates/wizard/admin_auto_toc.tpl', '15.9', 0),
('44915dd17685f962d48ed8f5050cc92a', './templates/wizard/admin_category.tpl', '15.9', 0),
('9435590c86768757375eff7a3535f791', './templates/wizard/admin_community.tpl', '15.9', 0),
('81d672a9cdbe12c71c4d3cd6be44ce12', './templates/wizard/admin_date_time.tpl', '15.9', 0),
('219eadba73a17079512f95ab4fae5037', './templates/wizard/admin_editor_type.tpl', '15.9', 0),
('f9f710b88122c65c0c4b726fbf374360', './templates/wizard/admin_features.tpl', '15.9', 0),
('7d290ffbcf40ddaeeeeeb8d162906cea', './templates/wizard/admin_files.tpl', '15.9', 0),
('d2c5a76ffffcc3267f96ddc9cce7da33', './templates/wizard/admin_files_storage.tpl', '15.9', 0),
('20509c907638d405920f19a468bed74a', './templates/wizard/admin_jcapture.tpl', '15.9', 0),
('c78a219150a405d0dc24a3eb9f86d805', './templates/wizard/admin_language.tpl', '15.9', 0),
('a6ad3bc756c3790da5ee03794ad6a9e8', './templates/wizard/admin_login.tpl', '15.9', 0),
('9a573abc3d06830967d837a36b2f5ddf', './templates/wizard/admin_look_and_feel.tpl', '15.9', 0),
('8bdf019847443b55f91a1218f1cb718d', './templates/wizard/admin_namespace.tpl', '15.9', 0),
('26c8dcd8b6a1e6ed5ceb901fc66d5db2', './templates/wizard/admin_search.tpl', '15.9', 0),
('13310808ef8522ae8728f7a53d0f028d', './templates/wizard/admin_structures.tpl', '15.9', 0),
('9779a35b484a33755726331e8092d7a5', './templates/wizard/admin_text_area.tpl', '15.9', 0),
('6b9527c18c264396f1bedc4c1c54d761', './templates/wizard/admin_wiki.tpl', '15.9', 0),
('c145016e3a9d2070810ac0e4c6a4cc18', './templates/wizard/admin_wizard.tpl', '15.9', 0),
('979aafcd3c655fdeda06870bee1ef883', './templates/wizard/admin_wizard_completed.tpl', '15.9', 0),
('82996b7e14302cdbd7dda090a48cd7e2', './templates/wizard/admin_wysiwyg.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/wizard/index.php', '15.9', 0),
('34f0b3b1c7cb256158a70651dbf7c64c', './templates/wizard/profiles_completed.tpl', '15.9', 0),
('07a170edc9edea6da01ce60590f83b57', './templates/wizard/profiles_demo_common_confs.tpl', '15.9', 0),
('6d0a3596ee2597fd7c7b3751613da109', './templates/wizard/profiles_demo_highly_specialized_confs.tpl', '15.9', 0),
('0c942f65c4d3d61cf531ce1717a30066', './templates/wizard/profiles_demo_interesting_use_cases.tpl', '15.9', 0),
('fee6171cd2836ab7d0a2ebdd56b67b5e', './templates/wizard/profiles_demo_more_advanced_confs.tpl', '15.9', 0),
('41799ce3c6c4de37fc6d9001ff8853f4', './templates/wizard/profiles_demo_other_interesting_use_cases.tpl', '15.9', 0),
('4014e551de2b351dbe2db9bf152b4aa0', './templates/wizard/profiles_featured_site_confs.tpl', '15.9', 0),
('b0c328f00cd4e3567f6bd79fedd4c3f7', './templates/wizard/profiles_useful_admin_confs.tpl', '15.9', 0),
('0cc27bbb4e96ec666454c75839924b2b', './templates/wizard/profiles_useful_changes_in_display.tpl', '15.9', 0),
('85e54ce1b79835b978adcb0c533c2d96', './templates/wizard/profiles_useful_micro_confs.tpl', '15.9', 0),
('adbf85533321800381f690661a8f905e', './templates/wizard/profiles_useful_new_tech_confs.tpl', '15.9', 0),
('9865cab6995e14ea477d3fc2c804d0dc', './templates/wizard/upgrade_doc_page_iframe.tpl', '15.9', 0),
('0896e2a99d55b2e27f3b35584edaf452', './templates/wizard/upgrade_new_in_13.tpl', '15.9', 0),
('3038abe290a5371c86dde230e9b5a0b9', './templates/wizard/upgrade_new_in_14.tpl', '15.9', 0),
('4d52453574b1ce5eb9574118f0cc0219', './templates/wizard/upgrade_new_in_15.tpl', '15.9', 0),
('6f3ae27a5a0705e999ee1ecbaaafc101', './templates/wizard/upgrade_novice_admin_assistance.tpl', '15.9', 0),
('3febf3af8de9db84541cd2d49e5ff362', './templates/wizard/upgrade_others.tpl', '15.9', 0),
('72c32a25ceb01a39c3568258aaaa62c5', './templates/wizard/upgrade_permissions_and_logs.tpl', '15.9', 0),
('d9e5156d8b07632d1ae86fe550dbf3f4', './templates/wizard/upgrade_send_feedback.tpl', '15.9', 0),
('764c9d2dc86a4f02af24e497882ab27d', './templates/wizard/upgrade_trackers.tpl', '15.9', 0),
('a17ba02fcd3195aa7cb5900d590c810f', './templates/wizard/upgrade_ui.tpl', '15.9', 0),
('b2934b1675ef68651b5ba208b0af088c', './templates/wizard/upgrade_wizard_completed.tpl', '15.9', 0),
('42716a708ccc5d15ba15e51a32684974', './templates/wizard/user_dummy1.tpl', '15.9', 0),
('37a3ea4a1a6e6f84d370465b61ef19bc', './templates/wizard/user_dummy2.tpl', '15.9', 0),
('25b4bc0e071013f48b90437a6e3ea83d', './templates/wizard/user_dummy3.tpl', '15.9', 0),
('3312cdcdd61c6ce527726aaac928488d', './templates/wizard/user_preferences_info.tpl', '15.9', 0),
('7537ed65da925a442de301a3359e5d6e', './templates/wizard/user_preferences_notifications.tpl', '15.9', 0),
('10ee956b93f864881c9891a595a2c7b5', './templates/wizard/user_preferences_params.tpl', '15.9', 0),
('792a89088b1cf3980ff80cf18d355ca3', './templates/wizard/user_preferences_reports.tpl', '15.9', 0),
('07c28a02efb8baf4fde971a793c25050', './templates/wizard/user_tracker.tpl', '15.9', 0),
('47e0aac438dde66ed44c1a34b2a0133c', './templates/wizard/user_wizard.tpl', '15.9', 0),
('4635898316d86df136bfc0a9b1392cdf', './templates/wizard/user_wizard_completed.tpl', '15.9', 0),
('2a97487a595c367a9911f9485808250f', './templates/wizard/wizard_bar_admin.tpl', '15.9', 0),
('626f68cba39f9d7923bd906f406e6f84', './templates/wizard/wizard_bar_user.tpl', '15.9', 0),
('5309dce703f8ebe39de53a1675cb75ed', './templates/workspace/add_template.tpl', '15.9', 0),
('ee4daf0ef2bbb7592d59d2833d87b9b4', './templates/workspace/advanced_edit.tpl', '15.9', 0),
('4fbad9f96c453185bd5e8a3ea1348d9b', './templates/workspace/create.tpl', '15.9', 0),
('06444e3cd70366cca36ca916969bba6c', './templates/workspace/edit_content.tpl', '15.9', 0),
('1710b4f64a6c40c98d7bd3635025c6d7', './templates/workspace/edit_template.tpl', '15.9', 0),
('bb93ce67cf435310f729422b8a213bdd', './templates/workspace/index.php', '15.9', 0),
('e7c4d4d9f7283938e8590a027ef89b25', './templates/workspace/list_templates.tpl', '15.9', 0),
('259bb2ff50586c5abff8c1a25cf2ee3e', './templates/workspace/select_permissions.tpl', '15.9', 0),
('0312a6c0375e2bef5ee31a06d1f117b7', './templates_c/index.php', '15.9', 0),
('4ea49c6fc47341c6579f1fb70df5a804', './tests/index.php', '15.9', 0),
('891c1a52e8035c119c4587a1d678dc2f', './themes/amelia/css/amelia.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/amelia/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/amelia/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/amelia/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/amelia/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/amelia/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/amelia/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/amelia/templates/index.php', '15.9', 0),
('0dc7521b60e55a841407b718a3f7a309', './themes/base_files/css/tiki_base.css', '15.9', 0),
('4549d38002fc22c4f385cb71c7967164', './themes/base_files/feature_css/admin.css', '15.9', 0),
('2eeaf2e33677e6b78e1a581e4fdb53f8', './themes/base_files/feature_css/calendar-print.css', '15.9', 0),
('d6b3e68142f1016ab864ed210dad2eb4', './themes/base_files/feature_css/calendar.css', '15.9', 0),
('c7b292ffcad8a112bc8314bddf41da6e', './themes/base_files/feature_css/ie8.css', '15.9', 0),
('7d8c523e935746ab989bf2aa3bb62bc0', './themes/base_files/feature_css/ie9.css', '15.9', 0),
('7162a7352b95374a97b610106be2afc4', './themes/base_files/feature_css/index.php', '15.9', 0),
('0fd2e3a718ce5dee58a213187bc85744', './themes/base_files/feature_css/jscalendar.css', '15.9', 0),
('459359635c4fb2b0cf1a4451c511f0d4', './themes/base_files/feature_css/wizards.css', '15.9', 0),
('0a4eb99c93a3644e8b8ef24669bf2830', './themes/base_files/iconsets/default.php', '15.9', 0),
('9e8842aa7eebb5ae908e5c8e91815602', './themes/base_files/iconsets/glyphicons.php', '15.9', 0),
('6aae5c76dfe513272b538cfdbc8c8fb5', './themes/base_files/iconsets/index.php', '15.9', 0),
('8dd24afa9369065d12682abc0fa737ae', './themes/base_files/iconsets/legacy.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/base_files/index.php', '15.9', 0),
('f81581cae537fb5956cae44f7330f59b', './themes/base_files/other/BiDi/BiDi.css', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/base_files/other/BiDi/index.php', '15.9', 0),
('6aae5c76dfe513272b538cfdbc8c8fb5', './themes/base_files/other/index.php', '15.9', 0),
('15d29f164403179d0f64b54c768f15a9', './themes/base_files/other/integrator/default.css', '15.9', 0),
('0770cb3d2ec07ddb9fc1cc48b3719459', './themes/base_files/other/integrator/doxygen.css', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/base_files/other/integrator/index.php', '15.9', 0),
('4134a83fd7db45c1b171b90d85abee56', './themes/business/css/business.css', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/business/css/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/business/fonts/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/business/icons/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/business/images/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/business/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/business/templates/index.php', '15.9', 0),
('658c73a3e4d8cf8a160cccb59487c6c6', './themes/cerulean/css/cerulean.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cerulean/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cerulean/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cerulean/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cerulean/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/cerulean/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cerulean/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cerulean/templates/index.php', '15.9', 0),
('31f14224190d421189388cc82100e5b4', './themes/cosmo/css/cosmo.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cosmo/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cosmo/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cosmo/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cosmo/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/cosmo/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cosmo/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cosmo/templates/index.php', '15.9', 0),
('8b81b73a2a5c7feed18d9837e633092c', './themes/cupid/css/cupid.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cupid/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cupid/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cupid/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cupid/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/cupid/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cupid/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cupid/templates/index.php', '15.9', 0),
('7a6cbf942530fa2512b1b7fc53b1c7fd', './themes/cyborg/css/cyborg.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cyborg/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cyborg/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cyborg/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cyborg/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/cyborg/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cyborg/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/cyborg/templates/index.php', '15.9', 0),
('39be76ec179ae2c8ce1ee07d7e20a7be', './themes/darkly/css/darkly.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkly/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkly/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkly/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkly/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/darkly/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkly/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkly/templates/index.php', '15.9', 0),
('22be29e2cfa626bc8d193e00533e3d21', './themes/darkroom/css/darkroom.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkroom/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkroom/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkroom/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkroom/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/darkroom/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkroom/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/darkroom/templates/index.php', '15.9', 0),
('8eae03c097ae1c0c5d930f53284af479', './themes/darkshine/css/darkshine.css', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/darkshine/css/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/darkshine/fonts/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/darkshine/icons/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/darkshine/images/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/darkshine/less/index.php', '15.9', 0),
('6c38de855c64edd109036cbf58c7fffc', './themes/default/css/default.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/default/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/default/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/default/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/default/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/default/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/default/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/default/options/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/default/templates/index.php', '15.9', 0),
('64789c2de79b985a0d6d3664ae13b15b', './themes/didiem/css/didiem.css', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/didiem/css/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/didiem/fonts/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/didiem/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/didiem/images/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/didiem/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/didiem/less/index.php', '15.9', 0),
('6e040ef3f5faf348d08307d96504ae9a', './themes/feb12/css/feb12.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/feb12/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/feb12/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/feb12/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/feb12/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/feb12/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/feb12/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/feb12/templates/index.php', '15.9', 0),
('f6d86e094189583727f43f498463b089', './themes/fivealive-lite/css/fivealive-lite.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive-lite/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive-lite/fonts/index.php', '15.9', 0),
('8fbe9970b6ff13b1ee61154371c0b455', './themes/fivealive-lite/icons/custom.php', '15.9', 0),
('18938452ee271d588f5857b3087e7358', './themes/fivealive-lite/icons/fivealive_lite.php', '15.9', 0),
('46177746437f6d6b501ed041ade5f6ec', './themes/fivealive-lite/icons/fivealive_lite_custom.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive-lite/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive-lite/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/fivealive-lite/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive-lite/less/index.php', '15.9', 0),
('6248479441614d6b548e21744aeee298', './themes/fivealive-lite/options/akebi/css/akebi.css', '15.9', 0),
('9030de3418d2d076e8bfb35044135c8b', './themes/fivealive-lite/options/akebi/icons/akebi_custom.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive-lite/options/akebi/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/akebi/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/blueberry/images/index.php', '15.9', 0),
('e667b9edd4ba240c8cfbcd2867c70c77', './themes/fivealive-lite/options/grape/css/grape.css', '15.9', 0),
('9bb0454e2f5c386417ec33950310a208', './themes/fivealive-lite/options/grape/css/newsletter.css', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/grape/images/index.php', '15.9', 0),
('4051bd1a8799281fa4698b5415e0dedd', './themes/fivealive-lite/options/kiwi/css/kiwi.css', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/kiwi/images/index.php', '15.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './themes/fivealive-lite/options/kiwi/less/bootstrap-variables.css', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('4451d307b54931597cbc971a924551ad', './themes/fivealive-lite/options/lemon/css/lemon.css', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/lemon/images/index.php', '15.9', 0),
('df29a928062d90e2773527e1d0f55eba', './themes/fivealive-lite/options/orange/css/orange.css', '15.9', 0),
('408cb7a817e7085f531dbeaf6c55e174', './themes/fivealive-lite/options/orange/icons/orange.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/orange/images/index.php', '15.9', 0),
('e93e35a1b07c862c1b5a3b12cea66dcf', './themes/fivealive-lite/options/plum/css/plum.css', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/plum/images/index.php', '15.9', 0),
('94807ce5aa9f5ade67101fe11a561d87', './themes/fivealive-lite/options/raspberry/css/raspberry.css', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/raspberry/images/index.php', '15.9', 0),
('b5f6cfd051c8c798d6c71d64830ef7ea', './themes/fivealive-lite/options/watermelon/css/watermelon.css', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive-lite/options/watermelon/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive-lite/templates/index.php', '15.9', 0),
('ed3dc2a0d35e944420336c55a9712fc9', './themes/fivealive/css/fivealive.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/css/index.php', '15.9', 0),
('ca46295a762c0152292254f8f35369b7', './themes/fivealive/css/newsletter.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/fivealive/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/jquery-ui/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/jquery-ui/index.php', '15.9', 0),
('51b912dde9699bc8c60cba7f5c9be3f7', './themes/fivealive/jquery-ui/jquery-ui.css', '15.9', 0),
('23a9a71ae4960074949d989296330fef', './themes/fivealive/jquery-ui/jquery-ui.min.css', '15.9', 0),
('79d7bbd652a8de5bc0899db8b3e6dc86', './themes/fivealive/jquery-ui/options/akebi/jquery-ui.css', '15.9', 0),
('d325a336d5a759ea5a678ecdca05d94c', './themes/fivealive/jquery-ui/options/akebi/jquery-ui.min.css', '15.9', 0),
('83879405fb3be2b68bada0f85d16ec17', './themes/fivealive/jquery-ui/options/grape/jquery-ui.css', '15.9', 0),
('b9539e433d657c042752d8e8dd036551', './themes/fivealive/jquery-ui/options/grape/jquery-ui.min.css', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/jquery-ui/options/index.php', '15.9', 0),
('1ee71b0465ad8299c44c41aae5ffedc1', './themes/fivealive/jquery-ui/options/kiwi/jquery-ui.css', '15.9', 0),
('71f9c51a22122d38019e3b87debda26e', './themes/fivealive/jquery-ui/options/kiwi/jquery-ui.min.css', '15.9', 0),
('4dd94e830a2ee4ac42189a0db114b5a1', './themes/fivealive/jquery-ui/options/lemon/jquery-ui.css', '15.9', 0),
('b0c547b7713f5e556ee805d9ec661f18', './themes/fivealive/jquery-ui/options/lemon/jquery-ui.min.css', '15.9', 0),
('89b65a41920fd43d437ec0a2166ecb85', './themes/fivealive/jquery-ui/options/orange/jquery-ui.css', '15.9', 0),
('ab864aad1dacd379c94fee3420a9e7f3', './themes/fivealive/jquery-ui/options/orange/jquery-ui.min.css', '15.9', 0),
('f6353f909a9df79873fa0d25ba43c300', './themes/fivealive/jquery-ui/options/plum/jquery-ui.css', '15.9', 0),
('63053fe4d153e9c90c1e1702734fd036', './themes/fivealive/jquery-ui/options/plum/jquery-ui.min.css', '15.9', 0),
('f1e1e434005a429c9fd2002205a7553c', './themes/fivealive/jquery-ui/options/raspberry/jquery-ui.css', '15.9', 0),
('9c1cc8af67e2857e37ecd08321c5170e', './themes/fivealive/jquery-ui/options/raspberry/jquery-ui.min.css', '15.9', 0),
('486eb69a3fdb04771358a83b907f34c6', './themes/fivealive/jquery-ui/options/watermelon/jquery-ui.css', '15.9', 0),
('6d394abbf41c976943a63991af1683d0', './themes/fivealive/jquery-ui/options/watermelon/jquery-ui.min.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/less/index.php', '15.9', 0),
('24ce3b7d80009ab6813f346547bc6e61', './themes/fivealive/options/akebi/css/akebi.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/akebi/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/akebi/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/akebi/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/akebi/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/akebi/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/blueberry/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/blueberry/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/options/blueberry/images/index.php', '15.9', 0),
('a63983dccfa47bea4a6a1af47d2ec087', './themes/fivealive/options/grape/css/grape.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/grape/css/index.php', '15.9', 0),
('9bb0454e2f5c386417ec33950310a208', './themes/fivealive/options/grape/css/newsletter.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/grape/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/grape/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/options/grape/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/grape/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/grape/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/kiwi/css/index.php', '15.9', 0),
('d97c3087650f2a9cadfa011708a130dc', './themes/fivealive/options/kiwi/css/kiwi.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/kiwi/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/kiwi/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/options/kiwi/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/kiwi/index.php', '15.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './themes/fivealive/options/kiwi/less/bootstrap-variables.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/kiwi/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/lemon/css/index.php', '15.9', 0),
('837fd1097b13f7a7d14e84622d408c35', './themes/fivealive/options/lemon/css/lemon.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/lemon/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/lemon/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/options/lemon/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/lemon/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/lemon/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/orange/css/index.php', '15.9', 0),
('8367c9c2381d62235804560a73628e97', './themes/fivealive/options/orange/css/orange.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/orange/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/orange/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/options/orange/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/orange/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/orange/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/plum/css/index.php', '15.9', 0),
('d0165a30e6930ba3029cfaf2969a94c6', './themes/fivealive/options/plum/css/plum.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/plum/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/plum/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/options/plum/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/plum/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/plum/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/raspberry/css/index.php', '15.9', 0),
('a88d08d58be70562440d81b8c1d2996f', './themes/fivealive/options/raspberry/css/raspberry.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/raspberry/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/raspberry/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/options/raspberry/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/raspberry/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/raspberry/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/watermelon/css/index.php', '15.9', 0),
('391d6d62217f6fad7e2b80d4181570cd', './themes/fivealive/options/watermelon/css/watermelon.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/watermelon/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/watermelon/icons/index.php', '15.9', 0),
('51036effbc7b0791ffc6d6b843e1297b', './themes/fivealive/options/watermelon/images/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/watermelon/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/options/watermelon/less/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/fivealive/templates/index.php', '15.9', 0),
('39765b769041cb99f040df925e42a4fa', './themes/flatly/css/flatly.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/flatly/css/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/flatly/fonts/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/flatly/icons/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/flatly/images/index.php', '15.9', 0),
('e0f0f6bd1af608c5ea3e1eb950044caf', './themes/flatly/index.php', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/flatly/less/index.php', '15.9', 0),
('f833cb0ed7afe315c0676f44fdde1225', './themes/flatly/options/blue/css/blue.css', '15.9', 0),
('421575cd4a81e2bdb37f613c6d55dfc5', './themes/flatly/templates/index.php', '15.9', 0),
('392e1b0e49801a2b84a9fce7196f8b32', './themes/greenvalley/css/greenvalley.css', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/greenvalley/css/index.php', '15.9', 0),
('7365a9f8022ac3d4c4cbb2cce8718d11', './themes/greenvalley/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/greenvalley/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/greenvalley/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/greenvalley/less/index.php', '15.9', 0),
('38c9ad5c66a89b9a8d006167a2669101', './themes/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/journal/css/index.php', '15.9', 0),
('d196698e579f5e847fa280d4395304cf', './themes/journal/css/journal.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/journal/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/journal/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/journal/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/journal/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/journal/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/journal/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/jqui/css/index.php', '15.9', 0),
('75bbaf02b3ed3c2f9c199039626fff88', './themes/jqui/css/jqui.css', '15.9', 0),
('ad71bcc3b22241d831e5207053767926', './themes/jqui/css/newsletter.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/jqui/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/jqui/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/jqui/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/jqui/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/jqui/less/index.php', '15.9', 0),
('584d8fc1946fbf568e1e7908697ae805', './themes/jqui/options/element/css/element.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/element/css/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/element/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/element/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/element/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/element/less/index.php', '15.9', 0),
('de8c1d4b84a5c861dd95e2a6dfe9cd67', './themes/jqui/options/excitebike/css/excitebike.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/excitebike/css/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/excitebike/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/excitebike/icons/index.php', '15.9', 0),
('6f5d17056478096d963ee8e1e6d6ed8f', './themes/jqui/options/excitebike/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/excitebike/less/index.php', '15.9', 0),
('e14a8b733fc77fe95ab397cd7aab05e0', './themes/jqui/options/flat/css/flat.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/flat/css/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/flat/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/flat/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/flat/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/flat/less/index.php', '15.9', 0),
('79f1a75357b7788be131ce1b210e69b7', './themes/jqui/options/good/css/good.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/good/css/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/good/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/good/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/good/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/good/less/index.php', '15.9', 0),
('01f0046eb7f03661d764d9024b6b8445', './themes/jqui/options/haus/css/haus.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/haus/css/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/haus/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/haus/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/haus/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/haus/less/index.php', '15.9', 0),
('bfc61c9d81075d962aec177c13cbee21', './themes/jqui/options/horizons/css/horizons.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/horizons/css/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/horizons/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/horizons/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/horizons/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/horizons/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/jqui/options/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/rising/css/index.php', '15.9', 0),
('72e44d7d901d07d8026e288be67caad1', './themes/jqui/options/rising/css/rising.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/rising/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/rising/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/rising/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/rising/less/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/trontastic/css/index.php', '15.9', 0),
('61437ea782e3834ae69c9762ebd40fd4', './themes/jqui/options/trontastic/css/trontastic.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/trontastic/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/trontastic/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/trontastic/images/index.php', '15.9', 0),
('6f5d17056478096d963ee8e1e6d6ed8f', './themes/jqui/options/trontastic/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/trontastic/less/index.php', '15.9', 0),
('ac341bb7caa31af277d0c8f720dbb11c', './themes/jqui/options/trontastic/pics/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/jqui/options/trontastic/pics/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/jqui/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/lumen/css/index.php', '15.9', 0),
('50eaae118b2a9ce11d977fb54230ff58', './themes/lumen/css/lumen.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/lumen/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/lumen/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/lumen/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/lumen/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/lumen/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/lumen/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/ohia/css/index.php', '15.9', 0),
('70b56c91914ebc5310cb9e9beca89d35', './themes/ohia/css/ohia.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/ohia/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/ohia/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/ohia/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/ohia/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/ohia/less/index.php', '15.9', 0),
('6d960d3ea2b4be1e02589757b304ecea', './themes/ohia/need-fix-or-merge-tiki.css', '15.9', 0),
('79b439a8a973d55b0ad65e31962de9d8', './themes/ohia/templates/credits.tpl', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/ohia/templates/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/paper/css/index.php', '15.9', 0),
('b8884ec93d7e97cf337ff00f86a61a4e', './themes/paper/css/paper.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/paper/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/paper/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/paper/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/paper/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/readable/css/index.php', '15.9', 0),
('18dab6b29369d6ec61019e96027a7f65', './themes/readable/css/readable.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/readable/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/readable/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/readable/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/readable/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/readable/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/readable/templates/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/sandstone/css/index.php', '15.9', 0),
('69c2f41f65c1227bce28606a5afbfb12', './themes/sandstone/css/sandstone.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/sandstone/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/sandstone/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/sandstone/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/sandstone/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/shamrock/css/index.php', '15.9', 0),
('7c6619a315a8ba6dc604c7b3a75f7f8f', './themes/shamrock/css/shamrock.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/shamrock/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/shamrock/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/shamrock/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/shamrock/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/shamrock/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/shamrock/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/simplex/css/index.php', '15.9', 0),
('4325d4cac3a6963d4acf3dca67285e10', './themes/simplex/css/simplex.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/simplex/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/simplex/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/simplex/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/simplex/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/simplex/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/simplex/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/slate/css/index.php', '15.9', 0),
('7ea8d647a4333fa6c739c1ba99c8445b', './themes/slate/css/slate.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/slate/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/slate/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/slate/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/slate/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/slate/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/slate/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/snow/css/index.php', '15.9', 0),
('128cac479dd9b5439da0d5c9a43145fe', './themes/snow/css/snow.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/snow/flash/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/snow/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/snow/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/snow/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/snow/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/snow/less/index.php', '15.9', 0),
('8028fea186bf3c3cf77a5407dd703795', './themes/snow/options/nineties/css/nineties.css', '15.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './themes/snow/options/nineties/css/tiki-selectors.css', '15.9', 0),
('379591f6a7c01b9360179c9652151695', './themes/snow/templates/credits.tpl', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/snow/templates/index.php', '15.9', 0),
('4be6b7b68e31140fad4f3fb95f201668', './themes/snow/templates/module.tpl', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/spacelab/css/index.php', '15.9', 0),
('2c465226dbe3c681a068b2bc4d8283ff', './themes/spacelab/css/spacelab.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/spacelab/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/spacelab/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/spacelab/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/spacelab/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/spacelab/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/spacelab/templates/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/strasa/css/index.php', '15.9', 0),
('d0017234f61478b8ce33400828cb4443', './themes/strasa/css/strasa.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/strasa/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/strasa/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/strasa/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/strasa/less/index.php', '15.9', 0),
('48d607fca73d4afed28ef2f9d9fa4003', './themes/strasa/options/cool/css/cool.css', '15.9', 0),
('233eb06a477e22601a08b5476b75e4c5', './themes/strasa/options/cool/css/index.php', '15.9', 0),
('15b3c9f915e727feecb2b4c06d11e99a', './themes/strasa/options/cool/index.php', '15.9', 0),
('40944a80d33df1b12cafefa1b9dfaa4c', './themes/strasa/options/index.php', '15.9', 0),
('233eb06a477e22601a08b5476b75e4c5', './themes/strasa/options/mono/css/index.php', '15.9', 0),
('38fd2d879ca1cc9faf57fb37e1bccd67', './themes/strasa/options/mono/css/mono.css', '15.9', 0),
('233eb06a477e22601a08b5476b75e4c5', './themes/strasa/options/mono/images/index.php', '15.9', 0),
('15b3c9f915e727feecb2b4c06d11e99a', './themes/strasa/options/mono/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/superhero/css/index.php', '15.9', 0),
('02b2675e44d075badf98c3ef6fb985ae', './themes/superhero/css/superhero.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/superhero/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/superhero/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/superhero/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/superhero/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/superhero/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/superhero/templates/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/thenews/css/index.php', '15.9', 0),
('ff48403da68c22d94aea9de0634422c4', './themes/thenews/css/thenews.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/thenews/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/thenews/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/thenews/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/thenews/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/thenews/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/thenews/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/tikinewt/css/index.php', '15.9', 0),
('8bdeb85b61072abe5c85cf52cda3963c', './themes/tikinewt/css/tikinewt.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/tikinewt/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/tikinewt/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/tikinewt/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/tikinewt/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/tikinewt/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/tikinewt/options/index.php', '15.9', 0),
('8524fd3261e428d22eeb067e988742ef', './themes/tikinewt/options/shadows/css/shadows.css', '15.9', 0),
('6f5d17056478096d963ee8e1e6d6ed8f', './themes/tikinewt/options/shadows/images/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/tikinewt/templates/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/united/css/index.php', '15.9', 0),
('457381c37a870c5d0e4946ff7a07e454', './themes/united/css/united.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/united/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/united/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/united/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/united/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/united/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/united/templates/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/utopias/css/index.php', '15.9', 0),
('549d940ca99e3aeba011e1416622c155', './themes/utopias/css/utopias.css', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/utopias/fonts/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/utopias/icons/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/utopias/images/index.php', '15.9', 0),
('fca2b54b539d7871532c64df7676d7e5', './themes/utopias/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/yeti/css/index.php', '15.9', 0),
('df1ddaf6bebb3b6b2165c7b3102d452c', './themes/yeti/css/yeti.css', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/yeti/fonts/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/yeti/icons/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/yeti/images/index.php', '15.9', 0),
('143dfd374777995d44d7cc8e24c942aa', './themes/yeti/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/yeti/less/index.php', '15.9', 0),
('66414cfba981cbce7ea4e6b801d91cd0', './themes/yeti/templates/index.php', '15.9', 0),
('654a0f87387dd46461a5284f35c4c497', './tiki-accounting.php', '15.9', 0),
('1879af09018315a0021d7fefc0477006', './tiki-accounting_account.php', '15.9', 0),
('beb9d8fe1246455926d09a9b122ec807', './tiki-accounting_books.php', '15.9', 0),
('3a8f220ec68d19bdb909f30de82b5b6a', './tiki-accounting_cancel.php', '15.9', 0),
('f16a4586fbf63ef76b29c30a5a4fb3fd', './tiki-accounting_entry.php', '15.9', 0),
('888d69101cca01e22639e97fe427f08c', './tiki-accounting_export.php', '15.9', 0),
('b7b05441f92231b4d94dfd6b62bbb8ec', './tiki-accounting_stack.php', '15.9', 0),
('0c7742d28893b1ccd8b6f40a79b2b000', './tiki-action_calendar.php', '15.9', 0),
('52cd5e841ac8892ba98c6e026d665245', './tiki-admin.php', '15.9', 0),
('7cef9f4607c53337ffe55320031a0232', './tiki-admin_actionlog.php', '15.9', 0),
('dab05886daf6d658d7de233a819f9278', './tiki-admin_banners.php', '15.9', 0),
('f0c402cf267132c7324f2deff1047863', './tiki-admin_banning.php', '15.9', 0),
('ea58c4c66f6ec29bc972cd5a9451c06b', './tiki-admin_calendars.php', '15.9', 0),
('cba478c4a0e23e8c67d0c1e24ffe6195', './tiki-admin_categories.php', '15.9', 0),
('a72a5bf924c23915d28c5f54463fbadf', './tiki-admin_content_templates.php', '15.9', 0),
('258a8a17501f247480b38014ab5085e4', './tiki-admin_contribution.php', '15.9', 0),
('1a3ae0f13c3746bf95d5272a842c03e7', './tiki-admin_cookies.php', '15.9', 0),
('de6043707640de4d782bd82c94ac0afa', './tiki-admin_credits.php', '15.9', 0),
('16599819f9b69274f94ecc734eeb8873', './tiki-admin_dsn.php', '15.9', 0),
('bea2b178ce6969c4c55c1fa2654b1c60', './tiki-admin_external_wikis.php', '15.9', 0),
('f3c1559171d540acf968b4db3469307c', './tiki-admin_forums.php', '15.9', 0),
('af7e465b509cc72b7cfced9fb28d0d9d', './tiki-admin_hotwords.php', '15.9', 0),
('61017a6dbc269fe05623dafc49ac50ff', './tiki-admin_html_page_content.php', '15.9', 0),
('d76e552d3eca50bf27c0e8feb26a20a9', './tiki-admin_html_pages.php', '15.9', 0),
('9b6f6ba9e1172a9fe8e28811d923f819', './tiki-admin_integrator.php', '15.9', 0),
('c241d74d54dafe65766df9c22216ac8a', './tiki-admin_integrator_rules.php', '15.9', 0),
('e27db7680f515a565bd1b48e1516b17f', './tiki-admin_invoices.php', '15.9', 0),
('c8af660786e757e28e84a4db1a9f8ca0', './tiki-admin_keywords.php', '15.9', 0),
('570a9c1fa17ec5c072c69c1f2dddab9f', './tiki-admin_links.php', '15.9', 0),
('55e46b8a4db5100c633cf0d8af0db31b', './tiki-admin_mailin.php', '15.9', 0),
('27ea045def1a09a01e858bd7fb3bb696', './tiki-admin_mailin_routes.php', '15.9', 0),
('f6c5a5b4e397c45f9bf9966680d1e9df', './tiki-admin_menu_options.php', '15.9', 0),
('c7fa91d73fc853f0fded5cd57a8134ff', './tiki-admin_menus.php', '15.9', 0),
('969560356729c7c1e618772d52ed7af1', './tiki-admin_modules.php', '15.9', 0),
('19792af461845132cf487a4d8c36ca85', './tiki-admin_newsletter_subscriptions.php', '15.9', 0),
('4f39ebb08d79570b007055de140ea7be', './tiki-admin_newsletters.php', '15.9', 0),
('4176f68b9b802a426637d26f114cdc45', './tiki-admin_notifications.php', '15.9', 0),
('8d3215d41a6fb102bbbf2972549c08e6', './tiki-admin_poll_options.php', '15.9', 0),
('af540596fd0d7cc4d18fdcf1142ca0d9', './tiki-admin_polls.php', '15.9', 0),
('2737093e0999354c407d6667d51d3151', './tiki-admin_rssmodules.php', '15.9', 0),
('e96b95d409a032930206345c141f1354', './tiki-admin_security.php', '15.9', 0),
('898b9e9f4127eb3a1690b2ed2dbaabc5', './tiki-admin_shoutbox_words.php', '15.9', 0),
('f843da3186d9cbe9df1bdf35696c5880', './tiki-admin_structures.php', '15.9', 0),
('2ea295d6ad0bbb6d6efd17dfd9c43189', './tiki-admin_survey_questions.php', '15.9', 0),
('1e67531b7e3bffaaf6c33a524b02985a', './tiki-admin_surveys.php', '15.9', 0),
('c1abb99195b9af191a89fb32c5e8a9f9', './tiki-admin_system.php', '15.9', 0),
('c1781b2d8ed0b8033f858141840e4177', './tiki-admin_tokens.php', '15.9', 0),
('f13ca6a98b038138019f6d588c8fc981', './tiki-admin_toolbars.php', '15.9', 0),
('bdd705508d55d9872ae0c141875f7b27', './tiki-admin_topics.php', '15.9', 0),
('eb709163d8758bdb28891b159a57e8c6', './tiki-admin_tracker_fields.php', '15.9', 0),
('71f7544120f877521605173cf710244c', './tiki-admin_trackers.php', '15.9', 0),
('72c87685d27fc5b3ad4319de03f3cbcd', './tiki-admin_transitions.php', '15.9', 0),
('dbe888018a6a9ad64080d161b241252a', './tiki-admingroups.php', '15.9', 0),
('ec7f0f167b8672bf5ba8efecf9da96a3', './tiki-adminusers.php', '15.9', 0),
('9e2d772dd54f528943488a7ff802a2f2', './tiki-ajax_services.php', '15.9', 0),
('16edbfbdbd8bfacc780b3063a65cbfae', './tiki-all_languages.php', '15.9', 0),
('121c86267fa42edc97adeb164bd1dd0b', './tiki-article_types.php', '15.9', 0),
('98e458020133f1d583f249fdfa3cfd59', './tiki-articles_rss.php', '15.9', 0),
('312a8ee5bd42186a59d07b4369ebe384', './tiki-assignuser.php', '15.9', 0),
('f899c5739fa4abec4cb6d776b8240eaa', './tiki-autologin.php', '15.9', 0),
('f2f1d36d17ade3c4662c1e4bacf82f2f', './tiki-backlinks.php', '15.9', 0),
('a4964f65875421101aef3f58ead43838', './tiki-batch_send_newsletter.php', '15.9', 0),
('600aa31fd5ba2e426574c5e1aeb68bd0', './tiki-batch_todo.php', '15.9', 0),
('5e0adac2c71f20768423c152680e0ac8', './tiki-batch_upload.php', '15.9', 0),
('35e65041948e5404b098a208c1c9d3e3', './tiki-batch_upload_files.php', '15.9', 0),
('9eb70a86dc1b08f6ff3d6c120daa2786', './tiki-blog_post.php', '15.9', 0),
('746c7a504d1f719c83bed35baad4d911', './tiki-blog_rankings.php', '15.9', 0),
('26c24b8a6b929bcb58ed67e75f7885c9', './tiki-blog_rss.php', '15.9', 0),
('977ee431a954610c9ee2ecd6ba4f8e18', './tiki-blogs_rss.php', '15.9', 0),
('8cfd5303d2ebf1bc78a79f2dd252d0b7', './tiki-browse_categories.php', '15.9', 0),
('c28729a8519b6535339cb7f1be3c00e8', './tiki-browse_freetags.php', '15.9', 0),
('b1a905c03d036250774765f9b8d49fa3', './tiki-browse_gallery.php', '15.9', 0),
('439ac6208e4e9db6ed14511507eb4960', './tiki-browse_image.php', '15.9', 0),
('8b470d3555a9dbd48f9332bcfb1d72c3', './tiki-calendar.php', '15.9', 0),
('ccfaf4bbae269fc80ef95ddc613ff0c9', './tiki-calendar_edit_item.php', '15.9', 0),
('a0372f87155eae76b97967080fc71f7c', './tiki-calendar_export_ical.php', '15.9', 0),
('0354281491e9635b6d5a70141f438392', './tiki-calendar_import.php', '15.9', 0),
('f175cdcd9f5d0dd4270448d56c8c088c', './tiki-calendar_json.php', '15.9', 0),
('45ce0fe6cb5e849d652f9fd1f7d4449f', './tiki-calendar_params_ical.php', '15.9', 0),
('e753e624d1c0b89febda517c87efdf25', './tiki-calendar_setup.php', '15.9', 0),
('01b29ea0bf4c6e4415b75f88d70a90c6', './tiki-calendars_rss.php', '15.9', 0),
('043463ae19e77c2a4403e1914e851152', './tiki-change_password.php', '15.9', 0),
('2311c1d7591838ece2c98b52ae5bc352', './tiki-channel.php', '15.9', 0),
('4ce5df0cb1a1375120a9b1590fb32020', './tiki-check.php', '15.9', 0),
('cb89f488dab8be9d638dd37a3f38c630', './tiki-cms_rankings.php', '15.9', 0),
('a7f8066edb81ea87783dbfd44cb0af5e', './tiki-confirm_user_email.php', '15.9', 0),
('ae5a34afa5414ae70aaac5df5a8aeb77', './tiki-contact.php', '15.9', 0),
('78bfbc04be032e3aed3a03581c0f587e', './tiki-contacts.php', '15.9', 0),
('d7389d1620ac06ffbe3c424a8785b927', './tiki-cookie-jar.php', '15.9', 0),
('541a6747df9d16f5716ef0c18a7e97fe', './tiki-copypage.php', '15.9', 0),
('779d24030d1a322bd407fa8a6dd3af5b', './tiki-create_multilang_pages.php', '15.9', 0),
('0fd433348f15da3db717b830f76b8a44', './tiki-create_webhelp.php', '15.9', 0),
('aeddf15c923f6e092e665d741bf2060e', './tiki-directories_rss.php', '15.9', 0),
('4b02812fcf11ca55758e115f67612b13', './tiki-directory_add_site.php', '15.9', 0),
('f8c2f499245986f186c33cf59828bec7', './tiki-directory_add_tiki_site.php', '15.9', 0),
('2364179c4afd44226c29cc133f4dc321', './tiki-directory_admin.php', '15.9', 0),
('cf9024fa3629ee55239bfbd7ddeb428f', './tiki-directory_admin_categories.php', '15.9', 0),
('6bb8a26cc2cc272a12143e5ff87bc7d5', './tiki-directory_admin_related.php', '15.9', 0),
('1afcc68fdfe50df241795460c2a0a898', './tiki-directory_admin_sites.php', '15.9', 0),
('daad607f35ba21f9d6750b92dd8498f8', './tiki-directory_browse.php', '15.9', 0),
('c7fd8811785d4ffaea5727e10af5eb4b', './tiki-directory_ranking.php', '15.9', 0),
('6eb5cc6a3442d1f6990f4bd5835be68b', './tiki-directory_redirect.php', '15.9', 0),
('6bb87d827c33c6060e6fa8992c6d8fec', './tiki-directory_rss.php', '15.9', 0),
('d165cbc53371d3dda2f44a763170424b', './tiki-directory_search.php', '15.9', 0),
('c0d0bb0138c239406346b920ed7f13e7', './tiki-directory_validate_sites.php', '15.9', 0),
('b8fc773c425a01daba27d27baaa5cef7', './tiki-discount.php', '15.9', 0),
('53f6f1990bd0759f3acab5e001db1da4', './tiki-download_file.php', '15.9', 0),
('66337c3c081555786c5573149852a38f', './tiki-download_forum_attachment.php', '15.9', 0),
('12c8cc1903577b989e98e722ac4db9de', './tiki-download_item_attachment.php', '15.9', 0),
('f7c57a18f31007a7420ccda6cf6f292e', './tiki-download_userfile.php', '15.9', 0),
('747588022a3406d68212a0441d5c9e1f', './tiki-download_wiki_attachment.php', '15.9', 0),
('1c347ab496b57400760db2859560c6f5', './tiki-edit_article.php', '15.9', 0),
('1ae80740a4d1befd37ff0a2e0a87ee99', './tiki-edit_banner.php', '15.9', 0),
('6c9ed838665332e6b839a830dc62917b', './tiki-edit_blog.php', '15.9', 0),
('e07a3a3f63413c013ab4336ff442e952', './tiki-edit_categories.php', '15.9', 0),
('d40013786e154501be3b42e1ab5b86e4', './tiki-edit_css.php', '15.9', 0),
('8dc09b1bc5db9ee43bc0ffb0cf82ac39', './tiki-edit_docs.php', '15.9', 0),
('ac77081e6239bf2c67ac9584351228d0', './tiki-edit_draw.php', '15.9', 0),
('76e4c423c8780ade73e7b4183d4d5cb1', './tiki-edit_image.php', '15.9', 0),
('95c5c5af7d543e2525389cb448e38da4', './tiki-edit_invoice.php', '15.9', 0),
('f636e083450f4e0d29a91fb58cc9b6b5', './tiki-edit_languages.php', '15.9', 0),
('f8ee1eea7b372e3f23efa152e9aed3fe', './tiki-edit_perspective.php', '15.9', 0),
('ab78c029b3e2a90be9059537e1c872c0', './tiki-edit_programmed_content.php', '15.9', 0),
('996ede3d18959935181d24ee44eecfd2', './tiki-edit_question_options.php', '15.9', 0),
('cc2fc5acf28cfba33272d0f5693cc863', './tiki-edit_quiz.php', '15.9', 0),
('39868ca77d635506306868ba5128cb74', './tiki-edit_quiz_questions.php', '15.9', 0),
('777914d7d71d4bebeddfa400cd427340', './tiki-edit_quiz_results.php', '15.9', 0),
('4051ae1cae31fda0b4cde25a6d85e125', './tiki-edit_report.php', '15.9', 0),
('1d2eafe0896b382d31174caa92cc3d21', './tiki-edit_structure.php', '15.9', 0),
('b69f24154eff1dd362900740e7899a73', './tiki-edit_submission.php', '15.9', 0),
('a7cfd39102121b9329c3881aff8ea594', './tiki-edit_templates.php', '15.9', 0),
('f107b19e101d743f92bbd90077a2f677', './tiki-edit_topic.php', '15.9', 0),
('feafdb8a8c68369aa8798226ea2337dd', './tiki-edit_translation.php', '15.9', 0),
('1125a87b61d47cef2cd49ef0429be836', './tiki-editpage.php', '15.9', 0),
('5a3ba5a0cc6d5646ca091871aa4956fa', './tiki-emulate_groups_switch.php', '15.9', 0),
('2cec70618d1052d19b449dde08e19497', './tiki-error_simple.php', '15.9', 0),
('a32157e78f1b6fc1d76e0fbd0f508800', './tiki-export_sheet.php', '15.9', 0),
('48ca0af2cdb2a0f3a0915673cd50736c', './tiki-export_tracker.php', '15.9', 0),
('8d8ee5150af683e74c80021539f64b50', './tiki-export_tracker_monitor.php', '15.9', 0),
('606720887f21626002aaddb2968b0abc', './tiki-export_wiki_pages.php', '15.9', 0),
('cb07e2883e6f197c1a6d5ca4e28e9e44', './tiki-faq_questions.php', '15.9', 0),
('c3bf73fbbca08090a2474b87dbfd9b4f', './tiki-featured_link.php', '15.9', 0),
('9323f16911e8f74a70ca3f48872eb19a', './tiki-feed.php', '15.9', 0),
('24efccb2db84bc4a53116ef98eaee687', './tiki-file_archives.php', '15.9', 0),
('08da3b76c1f5ddc19f4c80084868dd38', './tiki-file_galleries_rankings.php', '15.9', 0),
('d64f9de17a39fd00642feb0fe1e9f185', './tiki-file_galleries_rss.php', '15.9', 0),
('1cc2b9b2ac93d6e7678c153cfcc754f0', './tiki-file_gallery_rss.php', '15.9', 0),
('eecfa231e792b95e68fb7e32f563d5c0', './tiki-filter-base.php', '15.9', 0),
('cf8583e3b2903b6882f63c5d5d04d587', './tiki-forum_import.php', '15.9', 0),
('6a5d036e4c45304d189267f9f73b95bd', './tiki-forum_queue.php', '15.9', 0),
('47d8b8ece7b5bf0672eaaa0074d9d6bb', './tiki-forum_rankings.php', '15.9', 0),
('899a912523bd525506c63c0afaaa300d', './tiki-forum_rss.php', '15.9', 0),
('6db7561fd7acfec40ffde65006798cef', './tiki-forums.php', '15.9', 0),
('63b55d718cb8be7181c0b3bbd918777d', './tiki-forums_reported.php', '15.9', 0),
('5da455bb3fdcee6e352d8bf242a9cd6e', './tiki-forums_rss.php', '15.9', 0),
('a64db2f0148462851e20dc8ad22716e9', './tiki-freetag_translate.php', '15.9', 0),
('c113c27134822c247a745b2508af16be', './tiki-friends.php', '15.9', 0),
('7e3930664efc76865a13726d7ae05648', './tiki-galleries.php', '15.9', 0),
('faa3f249b8dd28064f58232b34675f2a', './tiki-galleries_rankings.php', '15.9', 0),
('4146da49e87cad4bb8c6783631ead5dc', './tiki-gdgraph.php', '15.9', 0),
('6f3528765308417f783d743781c5bf3d', './tiki-graph_formula.php', '15.9', 0),
('85057d9b35f1d90911ed9ea0922a5903', './tiki-graph_sheet.php', '15.9', 0),
('47a06d01d676a7f43b60b8101e985eee', './tiki-history_sheets.php', '15.9', 0),
('8473b332a6a6c1819fea568aa9b1d321', './tiki-image_galleries_rss.php', '15.9', 0),
('13ef4086b853cdc812110c7142b73a12', './tiki-image_gallery_rss.php', '15.9', 0),
('1ffd08f3c7e8dc64fd76a623c7b7c30c', './tiki-import_sheet.php', '15.9', 0),
('41cce07250935495ece1147a17dbe2e0', './tiki-import_structuredtext.php', '15.9', 0),
('14336e0478604ccc0cf4c837693f1a00', './tiki-import_xml_zip.php', '15.9', 0),
('d5d92d6725f8390505a12aabfbc21557', './tiki-importer.php', '15.9', 0),
('9d1a0aec663fa3ad0e3ed21a9ffc1ab4', './tiki-index.php', '15.9', 0),
('83c1c22d86879de681e966de454d9446', './tiki-index_p.php', '15.9', 0),
('c81e763f05ed9ed0a36ffef9066b7a08', './tiki-index_raw.php', '15.9', 0),
('1fe390fb3b480f3abc342aea8447115b', './tiki-information.php', '15.9', 0),
('32baaa826d99e24e98cee893939611b2', './tiki-install.php', '15.9', 0),
('5ea2703a0275c794f86188be8586d123', './tiki-integrator.php', '15.9', 0),
('183b3b7590ac3eadaacbe859670690cb', './tiki-interactive_trans.php', '15.9', 0),
('f13c66835e9c44c89b8b1a8b6ff1ddf6', './tiki-invite.php', '15.9', 0),
('00fd11ff77723824227c8f7a1011cd0f', './tiki-invited.php', '15.9', 0),
('3469c4c7e7fd6c51bca366ee21c6935b', './tiki-invoice_reports.php', '15.9', 0),
('81d894d719697439f6b4aba47ff7c49e', './tiki-jsmodule.php', '15.9', 0),
('af1d4365702b730995975c2652a2de57', './tiki-jsplugin.php', '15.9', 0),
('b303035b604a7d944bed75fcd1a00882', './tiki-kaltura_upload.php', '15.9', 0),
('1e4f04679a44dcf95cbec0ff535a58c3', './tiki-kaltura_video.php', '15.9', 0),
('5e798d831749ec3fec96e136e309c021', './tiki-lastchanges.php', '15.9', 0),
('f18d85805cc45670c1c71259858a6bd6', './tiki-layout_options.php', '15.9', 0),
('995e667d07765948a49aab51081c57bb', './tiki-likepages.php', '15.9', 0),
('a5137a74c7dae80c0a65fef28b978afa', './tiki-list_articles.php', '15.9', 0),
('b444e2fb604ab0a072867983bf5506ab', './tiki-list_banners.php', '15.9', 0),
('bbd6f58e6755f2cc944bf03a3f17a84c', './tiki-list_blogs.php', '15.9', 0),
('536c9191154fa0dd0e8d60322c2c8d41', './tiki-list_cache.php', '15.9', 0),
('7219de73101acf798abf90453f112bfa', './tiki-list_comments.php', '15.9', 0),
('796c24421071a4fa799165e7b479ca94', './tiki-list_contents.php', '15.9', 0),
('1591da4c2ac137d6e298a0b90fe452bd', './tiki-list_faqs.php', '15.9', 0),
('e998851a23a5db71bee79922745243bc', './tiki-list_file_gallery.php', '15.9', 0),
('13f7521dfc39d90c7bed9da448c4cff2', './tiki-list_gallery.php', '15.9', 0),
('1cdfed30b32a3b11ce67f7f8d52a1105', './tiki-list_integrator_repositories.php', '15.9', 0),
('48bb3f21b55fb208f393ee40792e9100', './tiki-list_invite.php', '15.9', 0),
('e3b235e1df50412742591f912145a81c', './tiki-list_invoice_clients.php', '15.9', 0),
('adc3286b61c728ecb98ab1b765a2c37e', './tiki-list_invoices.php', '15.9', 0),
('88dc2607e1b8a704c01edb70577fb36b', './tiki-list_kaltura_entries.php', '15.9', 0),
('236a8756a566bb0b04c2facad9a412d5', './tiki-list_object_permissions.php', '15.9', 0),
('9359d2aea4ad3929fd2ae0053b754731', './tiki-list_posts.php', '15.9', 0),
('2af5283267ceae3930a0d91d53348293', './tiki-list_quizzes.php', '15.9', 0),
('96fbbcab70eb4147fb23ff494b053a1f', './tiki-list_submissions.php', '15.9', 0),
('8ac8f015449a83808f7c491016ac158d', './tiki-list_surveys.php', '15.9', 0),
('d0ba0d0b78b612b3f738f6e8a3bc344f', './tiki-list_trackers.php', '15.9', 0),
('eb8b75d26d93d2922eecf9660224e50c', './tiki-list_users.php', '15.9', 0),
('e0fd40635e16123232c613f4564c2300', './tiki-listpages.php', '15.9', 0),
('03d85bac37addb37f23b62d4bb416a3c', './tiki-live_support_admin.php', '15.9', 0),
('977663286be19a2e6cadff454bc87755', './tiki-live_support_chat_frame.php', '15.9', 0),
('c0005380f212b54e8eb5ae6949d45318', './tiki-live_support_chat_window.php', '15.9', 0),
('7c1984319f9eeb1e828e95ca9e351967', './tiki-live_support_client.php', '15.9', 0),
('d40dee123de95be3a9ca5cb6c20a2de3', './tiki-live_support_console.php', '15.9', 0),
('d7f24a7716c073712d2a631bd1bdefa9', './tiki-live_support_message.php', '15.9', 0),
('1067793d9dfc83345513ec35c0626486', './tiki-live_support_server.php', '15.9', 0),
('8d103b49a1c5c219b32ffe4aa9d642c8', './tiki-live_support_transcripts.php', '15.9', 0),
('e8bb0bb828eeb59c43e96d8e623fa47e', './tiki-log_bigbluebutton_leave.php', '15.9', 0),
('be92fec36997f64136493a98c6e3e935', './tiki-login.php', '15.9', 0),
('c16d669d158f27558aeebdce941f835c', './tiki-login_openid.php', '15.9', 0),
('0a6869038c08145e55909d874a9d9c89', './tiki-login_scr.php', '15.9', 0),
('4a91644d4249abec807d15ba6fe1c891', './tiki-login_validate.php', '15.9', 0),
('a9b6d625dfbb56f21f171083288cff3d', './tiki-logout.php', '15.9', 0),
('89365bfc8120b682f60ef0ca28760bf8', './tiki-mailin-code.php', '15.9', 0),
('554795b21282e130e8b44cc33085daa9', './tiki-mailin.php', '15.9', 0),
('344eb0630f6a00db94066db787c18528', './tiki-mindmap.php', '15.9', 0),
('d914828b535b59602927c945f0ed73b1', './tiki-minical.php', '15.9', 0),
('4380053ae676af9bda192f2b1506a98f', './tiki-minical_export.php', '15.9', 0),
('78778564d0de4d2946198f0a51ed1b7f', './tiki-minical_prefs.php', '15.9', 0),
('8f5795215d152220439bf0a423f25f62', './tiki-minical_reminders.php', '15.9', 0),
('c0ad3f4da7103d7a1500a20eb7d481cc', './tiki-minichat_ajax.php', '15.9', 0),
('eaaaa241599a4ef0070717cb3b1b98c0', './tiki-mods.php', '15.9', 0),
('b0368cd71048fe7429d72013a1bbf0e2', './tiki-mods_admin.php', '15.9', 0),
('1f20b1d715e86b9a608ae96726661ce8', './tiki-module_controls.php', '15.9', 0),
('fad759fd388f8c34bcacdd697110664d', './tiki-modules.php', '15.9', 0),
('4a78afe58255e9fea3ae8bfd710937e7', './tiki-monitor.php', '15.9', 0),
('745696fc96b8de55f3104905d554177b', './tiki-my_tiki.php', '15.9', 0),
('e0cc9ad05902876b83b2374e69a334f4', './tiki-mytiki_shared.php', '15.9', 0),
('4b760558aa1ad12fc562c9a3aa62b372', './tiki-newsletter_archives.php', '15.9', 0),
('3f71a01199d3207be8d9d9c4e0c8775d', './tiki-newsletters.php', '15.9', 0),
('22f6bf7319d16f7a5fc0c37b681939a7', './tiki-notepad_get.php', '15.9', 0),
('c5241a86465764aa5ddebd376112a18d', './tiki-notepad_list.php', '15.9', 0),
('29b033da6f3795d109b635c03872a42f', './tiki-notepad_read.php', '15.9', 0),
('a206aa0be5e659257016b68c3650b290', './tiki-notepad_write.php', '15.9', 0),
('f0a3e1cc46d097a90441af282dc8cd8a', './tiki-object_watches.php', '15.9', 0),
('a2eeda001da30daebfb8b05fce812626', './tiki-objectpermissions.php', '15.9', 0),
('1cd96e247ceca9d7ac2431477ecc6436', './tiki-old_polls.php', '15.9', 0),
('5cd01b4c0539b0ce12a11936b5ca24f0', './tiki-orphan_pages.php', '15.9', 0),
('5772a5fd594c4e8ee534d8c86550ad99', './tiki-page.php', '15.9', 0),
('31930d15ecb5da2477f8cd3e514c7bde', './tiki-page_contribution.php', '15.9', 0),
('8037793d976c63b10b96874c37526116', './tiki-page_loader.php', '15.9', 0),
('8de281ec93d98d6e3d82fa2dd07151f7', './tiki-pagehistory.php', '15.9', 0),
('73f37cef7e4421e66f36954e8738df9c', './tiki-payment.php', '15.9', 0),
('8e5188b8e95f7083adb07b4ad5110721', './tiki-phpinfo.php', '15.9', 0),
('1530e6f5fb7f655cf47971eb6b4e5ed3', './tiki-pick_avatar.php', '15.9', 0),
('f234af66b234e8bdf3b82f5670be919c', './tiki-plugins.php', '15.9', 0),
('9a4990f50cf01825abaaf32953ca384a', './tiki-poll_form.php', '15.9', 0),
('e1aa3715268a933d60626f87c99b25fe', './tiki-poll_results.php', '15.9', 0),
('0bc219641b435a9bcbd643eae8114a5a', './tiki-print.php', '15.9', 0),
('68fab34551e1c0673f737d2c64ab3d12', './tiki-print_article.php', '15.9', 0),
('cd2e95a1002bde60d30b541e0ba1d7cc', './tiki-print_blog_post.php', '15.9', 0),
('b38c959f0066e323eed57855d0ee4946', './tiki-print_indexed.php', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('e31081ef478f297778f288265e128641', './tiki-print_multi_pages.php', '15.9', 0),
('650108933d3307e6e44e1e130d365705', './tiki-print_pages.php', '15.9', 0),
('dd42d96c1555ed5431662d30ef4d19fd', './tiki-pv_chart.php', '15.9', 0),
('eb7ef8515dba98107e801355b1793017', './tiki-quiz_download_answer.php', '15.9', 0),
('2caa22363bde23ff224730b1353634a7', './tiki-quiz_edit.php', '15.9', 0),
('fc620f49d1c44088131ebc82865b133e', './tiki-quiz_result_stats.php', '15.9', 0),
('108c44a68a1c1f66ffac230f7139e5f1', './tiki-quiz_stats.php', '15.9', 0),
('4b732f08b3a8ae1a9db0c2e973fc6bab', './tiki-quiz_stats_quiz.php', '15.9', 0),
('96723bef908318bf019194293a0782bd', './tiki-read_article.php', '15.9', 0),
('1b6335bca5c2aa87a77341ac7c982368', './tiki-received_articles.php', '15.9', 0),
('6a3ed2322aa15994266db33ceda4be75', './tiki-received_pages.php', '15.9', 0),
('6d69085014db4cfbe54a48dec6ceceba', './tiki-references.php', '15.9', 0),
('cd2a7d917c1c46a27b66915dc689210f', './tiki-referer_stats.php', '15.9', 0),
('17180b2e0a9e7cd84c8ff262e6ffc382', './tiki-register.php', '15.9', 0),
('b1e6be76fb16614c760ec0081aee1fed', './tiki-register_site.php', '15.9', 0),
('e4494a9ea5058ad6bd1669534151df87', './tiki-remind_password.php', '15.9', 0),
('5fd530282f25b8b81e5ee39777d9926d', './tiki-removepage.php', '15.9', 0),
('d0231d4becd83846a99a69cc86f67a84', './tiki-rename_page.php', '15.9', 0),
('8bbddb16f3a0dfdb479d754f513649e9', './tiki-report_direct_object_perms.php', '15.9', 0),
('88c51a9480cda5f3cb79d312c17813d1', './tiki-report_string_in_db.php', '15.9', 0),
('35d5305d7a81552ba3d1aaf3684d132f', './tiki-rollback.php', '15.9', 0),
('e73530ecb58e9bafd92a815b1788db13', './tiki-rss_error.php', '15.9', 0),
('bfadd3dcf2b3ae2153cd935a180c93d3', './tiki-search_replace.php', '15.9', 0),
('f4018d6fc99a98553ea557bee043f55d', './tiki-search_stats.php', '15.9', 0),
('b84483d5698649a8fa3db1ab7a9f4a5f', './tiki-searchindex.php', '15.9', 0),
('10407bd1d1bcfae66bef7b3e720928d1', './tiki-searchresults.php', '15.9', 0),
('b2b061b68e50d0239e943525340f549d', './tiki-section_options.php', '15.9', 0),
('e7481e2c305b356a18b6b52da4d45d00', './tiki-sefurl.php', '15.9', 0),
('e882534fc12dda9ed50249a82bec2efc', './tiki-send_mail.php', '15.9', 0),
('cd33351ca515e4844fdb4bdec80a488f', './tiki-send_newsletters.php', '15.9', 0),
('15696005429dd0b478b0e1cc8e465a96', './tiki-send_objects.php', '15.9', 0),
('496235ccb7d82b0bd1ff846159cea2e3', './tiki-setup.php', '15.9', 0),
('0db97a6b6d06db0c0a3caf14a49fd32c', './tiki-setup_base.php', '15.9', 0),
('3c0a381f5e7fc21023fa32d2e7b19584', './tiki-share.php', '15.9', 0),
('d776b432f0a40aa879ed92b9836885fc', './tiki-sheets.php', '15.9', 0),
('1d16dd6ff0a1732beec7a0d123e45bc5', './tiki-shoutbox.php', '15.9', 0),
('f355bd4ba098e58205043a0841c7fc86', './tiki-shoutbox_rss.php', '15.9', 0),
('2551b45960e5f1660b224555b4b6be0e', './tiki-show_all_images.php', '15.9', 0),
('0f332c2fa4b109e9598475905f28f89b', './tiki-show_user_avatar.php', '15.9', 0),
('e9cf1e532d9a67c36c8a9915a1fd6b2d', './tiki-slideshow.php', '15.9', 0),
('0c1b8dea7ed76b938a45342d60420094', './tiki-socialnetworks.php', '15.9', 0),
('912052273d94fae191decbe520387944', './tiki-socialnetworks_firstlogin.php', '15.9', 0),
('3eff76d6243f1a2f26c3e2d67638f5d4', './tiki-socialnetworks_linkedin.php', '15.9', 0),
('3c671bf545cda29de67f07ddb0946f2c', './tiki-sqllog.php', '15.9', 0),
('774c414940d1437672986826a3fb0374', './tiki-stats.php', '15.9', 0),
('367b4a7ba546338dd4364fc95b7f1b1b', './tiki-survey_stats.php', '15.9', 0),
('821ae26da6471cc1fe9e1f16b6ba090e', './tiki-survey_stats_survey.php', '15.9', 0),
('ba52fc6e29c26043cea945f8622aed6a', './tiki-switch_lang.php', '15.9', 0),
('5a54525441e86594dd7ef678daeadf61', './tiki-switch_perspective.php', '15.9', 0),
('2110c024a1ef537358aaefa76a761afd', './tiki-switch_theme.php', '15.9', 0),
('a2a3f067e3abc1b10ca069f240541c76', './tiki-syslog.php', '15.9', 0),
('d97965788775b602135e72a2a9ba8f51', './tiki-take_quiz.php', '15.9', 0),
('cdc4568867a305cec392c7aeecbaa123', './tiki-take_survey.php', '15.9', 0),
('966dd2eddf700d43bf8e7fd996ff1e5f', './tiki-tc.php', '15.9', 0),
('9a38057071c4c69864f8b41eb5d7758e', './tiki-tell_a_friend.php', '15.9', 0),
('8620b8a037fa28a5a15643fc45c0469c', './tiki-testGD.php', '15.9', 0),
('d5e0286ef7c44af6b1d932040cf929e1', './tiki-theme_control.php', '15.9', 0),
('c232a41992ac0790eecfeaf9616b11ef', './tiki-theme_control_objects.php', '15.9', 0),
('edcc0386894cf1bf8696090ba375c61b', './tiki-theme_control_sections.php', '15.9', 0),
('115b5cbbbb060bd76a29a2e57412399d', './tiki-timesheet.php', '15.9', 0),
('d4479c7f15fce2f661c5bad86f7ee86b', './tiki-timestamp.php', '15.9', 0),
('f57cec68ba62d71baa6ab04795819b95', './tiki-tracker_export_join.php', '15.9', 0),
('503d48a61a44dd3df4abf9f2273e2bec', './tiki-tracker_http_request.php', '15.9', 0),
('e562fe08475c98f42dd338e2b999a06d', './tiki-tracker_reports.php', '15.9', 0),
('38ecc2cf4c7dfd6ba563b779360faea6', './tiki-tracker_rss.php', '15.9', 0),
('8f50eb6aea36906ea29b554892972b58', './tiki-tracker_view_history.php', '15.9', 0),
('c38963b0c215b88dae1995de34589453', './tiki-upload_file.php', '15.9', 0),
('7e4d5d1df9b633b5db2fadf98b779413', './tiki-upload_image.php', '15.9', 0),
('16933ef1dfeb94303942664f80a6bb23', './tiki-usage_chart.php', '15.9', 0),
('1638cac34c28cb6d94789f8ba965172f', './tiki-user_assigned_modules.php', '15.9', 0),
('a66b0bf6795e0f8dfd8c50acc13b8881', './tiki-user_bookmarks.php', '15.9', 0),
('3e33f0ef5c7ee1aa52f1301ce0181056', './tiki-user_cached_bookmark.php', '15.9', 0),
('23f288ba483149deab53aab921a97dd1', './tiki-user_contacts_prefs.php', '15.9', 0),
('3e1aad578915801a3860bbddc522148b', './tiki-user_information.php', '15.9', 0),
('cc9a8267061d565be0b1764b9b32b336', './tiki-user_mailin.php', '15.9', 0),
('f0321712926163f641e2b4cdad5a2e04', './tiki-user_notifications.php', '15.9', 0),
('b4546e246618b7ffa2aeb0128925936b', './tiki-user_preferences.php', '15.9', 0),
('7ac204fd06ac79f93da8841df910d8ea', './tiki-user_reports.php', '15.9', 0),
('47a5bac1fc2b0894f78aef23566ffd0d', './tiki-user_reports_send.php', '15.9', 0),
('f854f8f50b29daf942704f32ef828f47', './tiki-user_tasks.php', '15.9', 0),
('39167a70df930e15473def7cec5fcf78', './tiki-user_unified_details.php', '15.9', 0),
('b9e189a748c1b0e1fcd677b73ab36a54', './tiki-user_watches.php', '15.9', 0),
('c5197ccf76d2590882845107adbbbcf9', './tiki-userfiles.php', '15.9', 0),
('e766e704e4658789672f7745daadbd21', './tiki-usermenu.php', '15.9', 0),
('bb737c3fd5d2f3574887acb11011c562', './tiki-userupload.php', '15.9', 0),
('2aa103518937b104129f34de0cfe3933', './tiki-userversions.php', '15.9', 0),
('d70b613bf2ee98a351823bb404c19b44', './tiki-view_articles.php', '15.9', 0),
('0b4cb644e459105894ecf09b62efca87', './tiki-view_banner.php', '15.9', 0),
('67021300f8aafc5aeb219869e285e72f', './tiki-view_blog.php', '15.9', 0),
('52a1b14a9896c0be143aaf6e93f1e4af', './tiki-view_blog_post.php', '15.9', 0),
('a91b02f9234dec2ac4796a5bbbb79692', './tiki-view_blog_post_image.php', '15.9', 0),
('bdff151e6bd36a293dd5836035b50c55', './tiki-view_cache.php', '15.9', 0),
('72b7caf435d558b3c041dc1f479b6108', './tiki-view_faq.php', '15.9', 0),
('0830c824a732142c9ba380cf3c3b50c8', './tiki-view_forum.php', '15.9', 0),
('52009c843d7d618eafaf919330f82fc0', './tiki-view_forum_thread.php', '15.9', 0),
('02077184a091574f2536ffabf8926e92', './tiki-view_invoice.php', '15.9', 0),
('2d219e5b87a28f16a395815df6837491', './tiki-view_minical_topic.php', '15.9', 0),
('42276d2156f7a07efd2eadba48f527da', './tiki-view_sheets.php', '15.9', 0),
('9ba282399f6987e0dd650fdcbafbb8a0', './tiki-view_tracker.php', '15.9', 0),
('863c3971098114e9b6b4ba5890a17bb6', './tiki-view_tracker_item.php', '15.9', 0),
('220718d661063c7d22862b003435258f', './tiki-view_tracker_more_info.php', '15.9', 0),
('c4488b7a75749a675f6908f3b664e2e9', './tiki-webdav.php', '15.9', 0),
('77c857f6a1ec662dc997a93a7255afc5', './tiki-webmail.php', '15.9', 0),
('980ba848c10e979a53a6145d9f88645a', './tiki-webmail_ajax.php', '15.9', 0),
('c4be9e97724c7db3fbc96214cf296f87', './tiki-webmail_contacts.php', '15.9', 0),
('129cb0b1a002bb127ed62d42be982f38', './tiki-webmail_download_attachment.php', '15.9', 0),
('79d7e8d26ace99bc34b03fc30aecd6c9', './tiki-webservices.php', '15.9', 0),
('542ef1a0a8252605d4a13cf10e1572eb', './tiki-wiki_rankings.php', '15.9', 0),
('1b8d06b187c3ce33d045e51b15b44a56', './tiki-wiki_rss.php', '15.9', 0),
('52ea696f8d0585c2d2fb356f89780a69', './tiki-wiki_rss_no_diff.php', '15.9', 0),
('9c71d0136592abfa0d42672741ebce8c', './tiki-wikiplugin_edit.php', '15.9', 0),
('4f462a14a34d0aae42c890389ca1daab', './tiki-wizard_admin.php', '15.9', 0),
('786288ffc48a249b6e610c2a99fdd275', './tiki-wizard_user.php', '15.9', 0),
('5a452ec094064bf97a1dbbceb3360693', './tiki-xmlrpc_services.php', '15.9', 0),
('3e49102a22910a3d0dd7da6afdcbc2bb', './tiki_tests/index.php', '15.9', 0),
('f922227ee66bda6d7e06086f2209d078', './tiki_tests/tests/index.php', '15.9', 0),
('9cc07a73337698e8423395144d8a4e3c', './tiki_tests/tiki-tests_edit.php', '15.9', 0),
('bfc8c490d0fbbaa851af4065c6ba5623', './tiki_tests/tiki-tests_list.php', '15.9', 0),
('2966c53790461c684faac42916598012', './tiki_tests/tiki-tests_record.php', '15.9', 0),
('512c08a392a0192442a65bf1db85ac9b', './tiki_tests/tiki-tests_replay.php', '15.9', 0),
('82ac64dde3a1b1187bdd9ec1b022b993', './tiki_tests/tiki-tests_show_xpath.php', '15.9', 0),
('9ab8623a7b3cf25f7c85aa4671fcac12', './tiki_tests/tikitestslib.php', '15.9', 0),
('025e8f1b9605e643f52bda3fa7be4827', './validate-ajax.php', '15.9', 0),
('35d8ed92ba790757ca3d9cf86e0ee65c', './vendor/Sam152/Javascript-Equal-Height-Responsive-Rows/grids.js', '15.9', 0),
('86f1b17113e54b95ec9f604e319f9ffc', './vendor/Sam152/Javascript-Equal-Height-Responsive-Rows/grids.min.js', '15.9', 0),
('f0f3dacc454f724e79c0d46259ef6d53', './vendor/adodb/adodb/adodb-active-record.inc.php', '15.9', 0),
('8a240c723f42bdc506621fefce9f4ca0', './vendor/adodb/adodb/adodb-csvlib.inc.php', '15.9', 0),
('d613e338a6d5945ed9c6667b56ee2e77', './vendor/adodb/adodb/adodb-datadict.inc.php', '15.9', 0),
('1751ee60aafb5c2df89ac3ce90c3e1c8', './vendor/adodb/adodb/adodb-error.inc.php', '15.9', 0),
('45e60dd4d706079e154a51da05e89e9a', './vendor/adodb/adodb/adodb-errorhandler.inc.php', '15.9', 0),
('037835cc219cc844c9a4d0ae225f6ed4', './vendor/adodb/adodb/adodb-errorpear.inc.php', '15.9', 0),
('5a76ffcc00d01f9bdcd2dd86a08ab321', './vendor/adodb/adodb/adodb-exceptions.inc.php', '15.9', 0),
('bab10df21b36a4cfe91184c79376fc5a', './vendor/adodb/adodb/adodb-iterator.inc.php', '15.9', 0),
('2c363ae0eb02df0fb185728744312e9f', './vendor/adodb/adodb/adodb-lib.inc.php', '15.9', 0),
('f61b314b537b64ae8718e82f7591d203', './vendor/adodb/adodb/adodb-memcache.lib.inc.php', '15.9', 0),
('04fdf90e0aa329c465dd2e7ac1404c94', './vendor/adodb/adodb/adodb-pager.inc.php', '15.9', 0),
('55922a6512d4d656b19be1fc53b27e54', './vendor/adodb/adodb/adodb-pear.inc.php', '15.9', 0),
('a0479ec8862e08d0716da923f4751a19', './vendor/adodb/adodb/adodb-perf.inc.php', '15.9', 0),
('0008e61a33e790745f09551cd22b73bd', './vendor/adodb/adodb/adodb-php4.inc.php', '15.9', 0),
('49128d0a7d00069fa61412dca2df8929', './vendor/adodb/adodb/adodb-time.inc.php', '15.9', 0),
('d2563ca7be8620796e3474d8211a5b06', './vendor/adodb/adodb/adodb-xmlschema.inc.php', '15.9', 0),
('5f7b7c1259f06250c783b47ca489b8a8', './vendor/adodb/adodb/adodb-xmlschema03.inc.php', '15.9', 0),
('942ab99cd514aea7d34294964a3d4f00', './vendor/adodb/adodb/adodb.inc.php', '15.9', 0),
('8a022e02714ce3186f310cc65d936ad5', './vendor/adodb/adodb/contrib/toxmlrpc.inc.php', '15.9', 0),
('a97355f86f308f90ec3eb8bf01508ef0', './vendor/adodb/adodb/datadict/datadict-access.inc.php', '15.9', 0),
('8a3247e22bfe3b16301270f898016698', './vendor/adodb/adodb/datadict/datadict-db2.inc.php', '15.9', 0),
('30c168a4500c53f5cf28c6784eff3919', './vendor/adodb/adodb/datadict/datadict-firebird.inc.php', '15.9', 0),
('885a045af3675101144e1c647e74e135', './vendor/adodb/adodb/datadict/datadict-generic.inc.php', '15.9', 0),
('027151797927847ff2e8c67ce129f0eb', './vendor/adodb/adodb/datadict/datadict-ibase.inc.php', '15.9', 0),
('739ea57d5b39f94d499e96b5c3e46377', './vendor/adodb/adodb/datadict/datadict-mssql.inc.php', '15.9', 0),
('886d152d73aaa6eeae75f8dda99e2926', './vendor/adodb/adodb/datadict/datadict-mssqlnative.inc.php', '15.9', 0),
('6ad81d40d6dd589660eb8f2636776b33', './vendor/adodb/adodb/datadict/datadict-mysql.inc.php', '15.9', 0),
('33bf6255357a37ece9e8f81852e1ba55', './vendor/adodb/adodb/datadict/datadict-oci8.inc.php', '15.9', 0),
('e321d619e8667c042d399e8235588720', './vendor/adodb/adodb/datadict/datadict-postgres.inc.php', '15.9', 0),
('3829c85bd4751506a6cadf0399a7488b', './vendor/adodb/adodb/datadict/datadict-sapdb.inc.php', '15.9', 0),
('5bb0c497adf011b21dba1bccfcaa021d', './vendor/adodb/adodb/datadict/datadict-sqlite.inc.php', '15.9', 0),
('959f04bbbb7ce71637a4910baf6d3e48', './vendor/adodb/adodb/datadict/datadict-sybase.inc.php', '15.9', 0),
('ffedb9f66c86631e52c451af529f6cd2', './vendor/adodb/adodb/drivers/adodb-access.inc.php', '15.9', 0),
('c8c888044a4ae31b5c315eeb3b6ea164', './vendor/adodb/adodb/drivers/adodb-ado.inc.php', '15.9', 0),
('a8e481462b02ffdd5e04e9074291d76c', './vendor/adodb/adodb/drivers/adodb-ado5.inc.php', '15.9', 0),
('1c9dd9f4fdc3fd69a39cf7ab2cd78539', './vendor/adodb/adodb/drivers/adodb-ado_access.inc.php', '15.9', 0),
('a5e0f5d2440ec5fd36a9ecd1cb7c6768', './vendor/adodb/adodb/drivers/adodb-ado_mssql.inc.php', '15.9', 0),
('c7c7bdbe70ba9a4e541a032080c0a118', './vendor/adodb/adodb/drivers/adodb-ads.inc.php', '15.9', 0),
('5f9d3b080fed75787db91f818743c3c7', './vendor/adodb/adodb/drivers/adodb-borland_ibase.inc.php', '15.9', 0),
('1a4008ee6054bcb029bdcaba0e76cf88', './vendor/adodb/adodb/drivers/adodb-csv.inc.php', '15.9', 0),
('cef33364f846a2e355a4d94a14346819', './vendor/adodb/adodb/drivers/adodb-db2.inc.php', '15.9', 0),
('ba5ef3b8afcb89bc73e4d74912e8b554', './vendor/adodb/adodb/drivers/adodb-db2oci.inc.php', '15.9', 0),
('b205dba5f2f533b0656b9d0a0800a1ad', './vendor/adodb/adodb/drivers/adodb-db2ora.inc.php', '15.9', 0),
('40a449ababedcc475dc09e856ab4a8c9', './vendor/adodb/adodb/drivers/adodb-fbsql.inc.php', '15.9', 0),
('ea78df0fc398fbb7ac596a77a744cd31', './vendor/adodb/adodb/drivers/adodb-firebird.inc.php', '15.9', 0),
('f4b40be50c37c13dd39e0207b1e85dbe', './vendor/adodb/adodb/drivers/adodb-ibase.inc.php', '15.9', 0),
('3cd1b21d018820628a3c4b86ef5004e4', './vendor/adodb/adodb/drivers/adodb-informix72.inc.php', '15.9', 0),
('a6be4089d2cfbdcfcab844b214c79f39', './vendor/adodb/adodb/drivers/adodb-ldap.inc.php', '15.9', 0),
('c9f912b4e931156afbea202568675b4e', './vendor/adodb/adodb/drivers/adodb-mssql.inc.php', '15.9', 0),
('0e613909810f94d18839d3d463025658', './vendor/adodb/adodb/drivers/adodb-mssql_n.inc.php', '15.9', 0),
('4a6fc2ba0714942205df43e1a850e17d', './vendor/adodb/adodb/drivers/adodb-mssqlnative.inc.php', '15.9', 0),
('df27aa84efe3657b1632d1cc98cddee2', './vendor/adodb/adodb/drivers/adodb-mssqlpo.inc.php', '15.9', 0),
('fcbd61efda2c6182959c171acd7c0cfc', './vendor/adodb/adodb/drivers/adodb-mysql.inc.php', '15.9', 0),
('b5aa97d6867d2b4e67a9b2629fc5fe42', './vendor/adodb/adodb/drivers/adodb-mysqli.inc.php', '15.9', 0),
('dd49b5df1b109e3309a8ec1393778b85', './vendor/adodb/adodb/drivers/adodb-mysqlpo.inc.php', '15.9', 0),
('fe6fa2044bf1eee6daae0e9b3078f5c3', './vendor/adodb/adodb/drivers/adodb-mysqlt.inc.php', '15.9', 0),
('d7454ed19ff2373221af270da6c4860e', './vendor/adodb/adodb/drivers/adodb-netezza.inc.php', '15.9', 0),
('a643cd3a0e4e83f187941b977d42895a', './vendor/adodb/adodb/drivers/adodb-oci8.inc.php', '15.9', 0),
('d52ab883f1bfb7774e4e722adc3082d4', './vendor/adodb/adodb/drivers/adodb-oci805.inc.php', '15.9', 0),
('334b4c41f6378ad91301cf066b7bf6fc', './vendor/adodb/adodb/drivers/adodb-oci8po.inc.php', '15.9', 0),
('cfb0ac245f211624a12f05241e96a924', './vendor/adodb/adodb/drivers/adodb-odbc.inc.php', '15.9', 0),
('8b919470bd0000212a97b5f2753dd418', './vendor/adodb/adodb/drivers/adodb-odbc_db2.inc.php', '15.9', 0),
('ac9c412800b9dd4d6707b82d616d1490', './vendor/adodb/adodb/drivers/adodb-odbc_mssql.inc.php', '15.9', 0),
('28119baf4b79017a8ebd4659fab396d7', './vendor/adodb/adodb/drivers/adodb-odbc_oracle.inc.php', '15.9', 0),
('bfd7d47cc37f158ff269766de88ab470', './vendor/adodb/adodb/drivers/adodb-odbtp.inc.php', '15.9', 0),
('2ac1f14b6abbe35229804544014c527b', './vendor/adodb/adodb/drivers/adodb-odbtp_unicode.inc.php', '15.9', 0),
('7812cfc841cb1c1d29462063ea3c3f08', './vendor/adodb/adodb/drivers/adodb-oracle.inc.php', '15.9', 0),
('0c5f89972b77100d5d3d328e7c9852d4', './vendor/adodb/adodb/drivers/adodb-pdo.inc.php', '15.9', 0),
('39a95a1663abfdbde8f589b7aff4c375', './vendor/adodb/adodb/drivers/adodb-pdo_mssql.inc.php', '15.9', 0),
('85ec2ee828a6ea147b5860477cb1ed71', './vendor/adodb/adodb/drivers/adodb-pdo_mysql.inc.php', '15.9', 0),
('6e227c4d3fe7237cf5be39fb3fe156c7', './vendor/adodb/adodb/drivers/adodb-pdo_oci.inc.php', '15.9', 0),
('bd83e3eb542ab235f52e490ab988022b', './vendor/adodb/adodb/drivers/adodb-pdo_pgsql.inc.php', '15.9', 0),
('471125d5a4214a78b381f33d420318de', './vendor/adodb/adodb/drivers/adodb-pdo_sqlite.inc.php', '15.9', 0),
('8d928fa0e88364f6efe44b1d861cc9bf', './vendor/adodb/adodb/drivers/adodb-postgres.inc.php', '15.9', 0),
('f9e958ab205a974bb8d0ac17035a99d8', './vendor/adodb/adodb/drivers/adodb-postgres64.inc.php', '15.9', 0),
('c15e42f07a1da5a57db0474b08b40d8c', './vendor/adodb/adodb/drivers/adodb-postgres7.inc.php', '15.9', 0),
('f01cc58c6723dd806756d728b5e72c4d', './vendor/adodb/adodb/drivers/adodb-postgres8.inc.php', '15.9', 0),
('f87779a83f516f17937e544dc05cbdf5', './vendor/adodb/adodb/drivers/adodb-postgres9.inc.php', '15.9', 0),
('8e39ea32b92517c654a6f945dbd4faa4', './vendor/adodb/adodb/drivers/adodb-proxy.inc.php', '15.9', 0),
('f76706e4e01592e74171404ebe3934c1', './vendor/adodb/adodb/drivers/adodb-sapdb.inc.php', '15.9', 0),
('4c0d2172a3dd2e809c5fa1a79845ba39', './vendor/adodb/adodb/drivers/adodb-sqlanywhere.inc.php', '15.9', 0),
('d99d4947cef966e57da723807c307f6c', './vendor/adodb/adodb/drivers/adodb-sqlite.inc.php', '15.9', 0),
('191e5fdaaae2bc9c2ea0e797424de3c0', './vendor/adodb/adodb/drivers/adodb-sqlite3.inc.php', '15.9', 0),
('3acd3b364aaee62b62e5047f717f3875', './vendor/adodb/adodb/drivers/adodb-sqlitepo.inc.php', '15.9', 0),
('baa3793724ddf3e99de7ed92177af60d', './vendor/adodb/adodb/drivers/adodb-sybase.inc.php', '15.9', 0),
('40574cbf911581cddfd28e41e7029fe3', './vendor/adodb/adodb/drivers/adodb-sybase_ase.inc.php', '15.9', 0),
('159ed417ea7dc44ebf5bf33bb3252cc7', './vendor/adodb/adodb/drivers/adodb-vfp.inc.php', '15.9', 0),
('56602de7a184aa22984f46954b22934b', './vendor/adodb/adodb/lang/adodb-ar.inc.php', '15.9', 0),
('37b0880076545e8d8e3809002c8b1960', './vendor/adodb/adodb/lang/adodb-bg.inc.php', '15.9', 0),
('ed08fdc9f392628cf2bf5eb9c814eb6a', './vendor/adodb/adodb/lang/adodb-bgutf8.inc.php', '15.9', 0),
('b9030fa70d9d0f2ba408ac61c31958c3', './vendor/adodb/adodb/lang/adodb-ca.inc.php', '15.9', 0),
('155efb4dceeced3de044f660a9528265', './vendor/adodb/adodb/lang/adodb-cn.inc.php', '15.9', 0),
('6964322c13c74d4435a42c3d14ab7d6a', './vendor/adodb/adodb/lang/adodb-cz.inc.php', '15.9', 0),
('2ea23878b1027f3d07c8a9b8bbe4e3a3', './vendor/adodb/adodb/lang/adodb-da.inc.php', '15.9', 0),
('26c57777b17e3ff924b83d3ac36a6e1c', './vendor/adodb/adodb/lang/adodb-de.inc.php', '15.9', 0),
('30661f84245fb56b327564c63bdc8695', './vendor/adodb/adodb/lang/adodb-en.inc.php', '15.9', 0),
('de0722a45173d1e076216f41090232d1', './vendor/adodb/adodb/lang/adodb-es.inc.php', '15.9', 0),
('32b94a998cb1a8b1ee14089af407d585', './vendor/adodb/adodb/lang/adodb-esperanto.inc.php', '15.9', 0),
('32dd4402ea6055f588cc4c999f1dd21f', './vendor/adodb/adodb/lang/adodb-fa.inc.php', '15.9', 0),
('dd47dbd2afc066b15e4944297da957b2', './vendor/adodb/adodb/lang/adodb-fr.inc.php', '15.9', 0),
('f308d107e1335ec36f71f101bc5324cf', './vendor/adodb/adodb/lang/adodb-hu.inc.php', '15.9', 0),
('15e2c634116779844db3c9e8f1c4ceb0', './vendor/adodb/adodb/lang/adodb-it.inc.php', '15.9', 0),
('ed3d417b04f361e178f1a258d193b929', './vendor/adodb/adodb/lang/adodb-nl.inc.php', '15.9', 0),
('8a53c82baf19cf137ef125d7e410c647', './vendor/adodb/adodb/lang/adodb-pl.inc.php', '15.9', 0),
('14cc56d6565900543e3b26130aace1b7', './vendor/adodb/adodb/lang/adodb-pt-br.inc.php', '15.9', 0),
('71052ad0e1622d8514b5a41622d2ce33', './vendor/adodb/adodb/lang/adodb-ro.inc.php', '15.9', 0),
('e828ddb6371ea135bfff0d6b59229eb3', './vendor/adodb/adodb/lang/adodb-ru1251.inc.php', '15.9', 0),
('81fac3276333ca136f83c1f3c35f5f3f', './vendor/adodb/adodb/lang/adodb-sv.inc.php', '15.9', 0),
('822a0c4c44527e99acdb3bc2f50ff6f1', './vendor/adodb/adodb/lang/adodb-uk1251.inc.php', '15.9', 0),
('201d8ae7eda2a23f6b71c9d88ac77ded', './vendor/adodb/adodb/lang/adodb_th.inc.php', '15.9', 0),
('c64fefadae2c0e8196a3b07a7002c9cb', './vendor/adodb/adodb/pear/Auth/Container/ADOdb.php', '15.9', 0),
('390a3294582574ef329adbebe058fcdd', './vendor/adodb/adodb/perf/perf-db2.inc.php', '15.9', 0),
('4a4a111b7d10931dcafa519878a515a1', './vendor/adodb/adodb/perf/perf-mssql.inc.php', '15.9', 0),
('0e56bb6a8c0b5475eeef619c4eaee541', './vendor/adodb/adodb/perf/perf-mssqlnative.inc.php', '15.9', 0),
('f3a056b57ae33213733fca95c36e427c', './vendor/adodb/adodb/perf/perf-mysql.inc.php', '15.9', 0),
('9d50d8cad47791913f5cec0121abbceb', './vendor/adodb/adodb/perf/perf-oci8.inc.php', '15.9', 0),
('6cb1a272a8108bf1828c128789cff20a', './vendor/adodb/adodb/perf/perf-postgres.inc.php', '15.9', 0),
('ad985790585aebae4c7551c26339b7cb', './vendor/adodb/adodb/pivottable.inc.php', '15.9', 0),
('d3953bbbdbdf1d984c67542792effe04', './vendor/adodb/adodb/rsfilter.inc.php', '15.9', 0),
('912e0742f3912355637f689b77edb499', './vendor/adodb/adodb/server.php', '15.9', 0),
('c62c3af371559188f0083d7244878d76', './vendor/adodb/adodb/session/adodb-compress-bzip2.php', '15.9', 0),
('1eb51b8b2e87281c5e6bc9263106456b', './vendor/adodb/adodb/session/adodb-compress-gzip.php', '15.9', 0),
('45effa5ed5331f049286d773f9c33f9f', './vendor/adodb/adodb/session/adodb-cryptsession.php', '15.9', 0),
('e44e79112c7d0d83014f564ae04dc855', './vendor/adodb/adodb/session/adodb-cryptsession2.php', '15.9', 0),
('e2c16e0682a7d890273b11e7a910c0a4', './vendor/adodb/adodb/session/adodb-encrypt-mcrypt.php', '15.9', 0),
('f19017a012983be1ef9c8022eb5bccb4', './vendor/adodb/adodb/session/adodb-encrypt-md5.php', '15.9', 0),
('055143eb9310342f3d59b0a730030efe', './vendor/adodb/adodb/session/adodb-encrypt-secret.php', '15.9', 0),
('33ec3cadbdee21ddf3199458d6b94db6', './vendor/adodb/adodb/session/adodb-encrypt-sha1.php', '15.9', 0),
('cf414af44f8ce5b1d63bfa998f40b73e', './vendor/adodb/adodb/session/adodb-session-clob.php', '15.9', 0),
('5e76c9d13026e6bee50642049b8af084', './vendor/adodb/adodb/session/adodb-session-clob2.php', '15.9', 0),
('8100e3ca20cf10cb797533db4b2f47fb', './vendor/adodb/adodb/session/adodb-session.php', '15.9', 0),
('1672166df7932ae984bf85e4dafce1c0', './vendor/adodb/adodb/session/adodb-session2.php', '15.9', 0),
('42fef0886af1f6da31a06de273876b71', './vendor/adodb/adodb/session/adodb-sessions.mysql.sql', '15.9', 0),
('3c64f822ee1b493b319c6e8196cc06b8', './vendor/adodb/adodb/session/adodb-sessions.oracle.clob.sql', '15.9', 0),
('08d0fc1f5fbf8b79a4dca43cbd30e3a1', './vendor/adodb/adodb/session/adodb-sessions.oracle.sql', '15.9', 0),
('0559f2a3b133c693815b715cbf4ae4d2', './vendor/adodb/adodb/session/crypt.inc.php', '15.9', 0),
('69772548cbb2f67c841346f4fc2268b1', './vendor/adodb/adodb/session/old/adodb-cryptsession.php', '15.9', 0),
('3689ef93ec2f6da88bb163a8d2d6030c', './vendor/adodb/adodb/session/old/adodb-session-clob.php', '15.9', 0),
('51d40f77cdf993f188f5971dc45dc977', './vendor/adodb/adodb/session/old/adodb-session.php', '15.9', 0),
('5a4e4fde0da690423376a99610929101', './vendor/adodb/adodb/session/old/crypt.inc.php', '15.9', 0),
('ae8895a9a9739065aa3740ae79c8b9a1', './vendor/adodb/adodb/toexport.inc.php', '15.9', 0),
('675fb42aabbf6b5a204584e6a2db6498', './vendor/adodb/adodb/tohtml.inc.php', '15.9', 0),
('87ab03595191d555da6261d11d2b2e32', './vendor/afarkas/html5shiv/dist/html5shiv-printshiv.js', '15.9', 0),
('9f03100ab5ce18e0049c25c6c4916802', './vendor/afarkas/html5shiv/dist/html5shiv-printshiv.min.js', '15.9', 0),
('f4d9dea8e0ae8455500862bbb874d63c', './vendor/afarkas/html5shiv/dist/html5shiv.js', '15.9', 0),
('40bd440d29b3a9371b0c63fec41ee64f', './vendor/afarkas/html5shiv/dist/html5shiv.min.js', '15.9', 0),
('87ab03595191d555da6261d11d2b2e32', './vendor/afarkas/html5shiv/src/html5shiv-printshiv.js', '15.9', 0),
('f4d9dea8e0ae8455500862bbb874d63c', './vendor/afarkas/html5shiv/src/html5shiv.js', '15.9', 0),
('16533bca0366b75f98a8ead23f5419f2', './vendor/autoload.php', '15.9', 0),
('a70069524ee1dd519021a2b159401e1d', './vendor/blueimp/javascript-canvas-to-blob/js/canvas-to-blob.js', '15.9', 0),
('0a9803b5bfea6dd99654bd436362797c', './vendor/blueimp/javascript-canvas-to-blob/js/canvas-to-blob.min.js', '15.9', 0),
('27feaff9ae8ea800d55290a12062665e', './vendor/blueimp/javascript-load-image/js/load-image-exif-map.js', '15.9', 0),
('961da0c9e3aa48d7b48908ca99103b8d', './vendor/blueimp/javascript-load-image/js/load-image-exif.js', '15.9', 0),
('3f88488a106aaf28bf27973884896f52', './vendor/blueimp/javascript-load-image/js/load-image-ios.js', '15.9', 0),
('e8b5e8c3f4b9c32438ce86809e2cf373', './vendor/blueimp/javascript-load-image/js/load-image-meta.js', '15.9', 0),
('9d0ac19cea5c45bd6476f23bc377f84d', './vendor/blueimp/javascript-load-image/js/load-image-orientation.js', '15.9', 0),
('33e833453a5b981526ca98dac536bb60', './vendor/blueimp/javascript-load-image/js/load-image.all.min.js', '15.9', 0),
('f3c29d76c6453053165bdbdc8ad267c9', './vendor/blueimp/javascript-load-image/js/load-image.js', '15.9', 0),
('24196312ab7e70eaeb6014ba46f8d0f0', './vendor/blueimp/jquery-file-upload/css/jquery.fileupload-noscript.css', '15.9', 0),
('0c769317554eae79220fc46f461949c8', './vendor/blueimp/jquery-file-upload/css/jquery.fileupload-ui-noscript.css', '15.9', 0),
('41aef3334d38845a83c43f2dff2105eb', './vendor/blueimp/jquery-file-upload/css/jquery.fileupload-ui.css', '15.9', 0),
('440d20a8d68a135fa8b192972fcf6414', './vendor/blueimp/jquery-file-upload/css/jquery.fileupload.css', '15.9', 0),
('6c330f006778e0be2ec24d7fe0bdf705', './vendor/blueimp/jquery-file-upload/css/style.css', '15.9', 0),
('c2e5d1c3ad3e0b20d3d540438a9289a8', './vendor/blueimp/jquery-file-upload/js/app.js', '15.9', 0),
('977639337765b4529968ed7a4f099689', './vendor/blueimp/jquery-file-upload/js/cors/jquery.postmessage-transport.js', '15.9', 0),
('28fc4fd7c572174d46112660863ade69', './vendor/blueimp/jquery-file-upload/js/cors/jquery.xdr-transport.js', '15.9', 0),
('6ef535d54706e0f78d29e74c040e991b', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload-angular.js', '15.9', 0),
('983761db94104bd78f0a0f5952c782ea', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload-audio.js', '15.9', 0),
('38cd7eef56a02f60b005d4a4c3efe4d6', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload-image.js', '15.9', 0),
('a1e379cedec5e4ac3ee673571a13c718', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload-jquery-ui.js', '15.9', 0),
('f3aec169667b3e0ee9b8984b703bd945', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload-process.js', '15.9', 0),
('28ef2578603ababff60edd871009ceca', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload-ui.js', '15.9', 0),
('e92b4a33e4a2ba315222c2a8cb9969c5', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload-validate.js', '15.9', 0),
('64826c09d7aef426d5425490a79958e3', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload-video.js', '15.9', 0),
('5b5d9cf8a7dcee5f09e50475a53ea084', './vendor/blueimp/jquery-file-upload/js/jquery.fileupload.js', '15.9', 0),
('75d1d0238d2dfe2c37647ac5a5ccf685', './vendor/blueimp/jquery-file-upload/js/jquery.iframe-transport.js', '15.9', 0),
('14b856ac87d452b353cd5ad1a012dca6', './vendor/blueimp/jquery-file-upload/js/main.js', '15.9', 0),
('d8a4872f8ff612f7cbd566d319f10ced', './vendor/ckeditor/ckeditor/adapters/jquery.js', '15.9', 0),
('ed1a7669a528b5ecf3fb80bf48bd37d7', './vendor/ckeditor/ckeditor/ckeditor.js', '15.9', 0),
('d56f7d8d075d6fa9b878aa7afb3e6b23', './vendor/ckeditor/ckeditor/config.js', '15.9', 0),
('b16b7140e24e38fbf62337ae3d3ae29a', './vendor/ckeditor/ckeditor/contents.css', '15.9', 0),
('36a43d8035e084da362898ee45a0e84e', './vendor/ckeditor/ckeditor/lang/af.js', '15.9', 0),
('7c3a5fb989f5efc79b7c12d4a9cd9124', './vendor/ckeditor/ckeditor/lang/ar.js', '15.9', 0),
('36031684bf07c88ab258f9b6a30b92e8', './vendor/ckeditor/ckeditor/lang/bg.js', '15.9', 0),
('2b8b0019d00b80d4061cf224bd8b92de', './vendor/ckeditor/ckeditor/lang/bn.js', '15.9', 0),
('9269392b395b29eb083f95e1af86fac0', './vendor/ckeditor/ckeditor/lang/bs.js', '15.9', 0),
('bf3a7cf6ecec434dc37ce5d82b8b5289', './vendor/ckeditor/ckeditor/lang/ca.js', '15.9', 0),
('459445f80331b4c02c1ab29d6d896da8', './vendor/ckeditor/ckeditor/lang/cs.js', '15.9', 0),
('7c2e0a6edcf272f5d522a27af4d5537e', './vendor/ckeditor/ckeditor/lang/cy.js', '15.9', 0),
('f65f375b00da76b409110150cab04a8e', './vendor/ckeditor/ckeditor/lang/da.js', '15.9', 0),
('8189796d0ce791f55574827612727ca3', './vendor/ckeditor/ckeditor/lang/de.js', '15.9', 0),
('47a268691ed09f0dab8b6fe5b79ecd5e', './vendor/ckeditor/ckeditor/lang/el.js', '15.9', 0),
('e54fa205fdaa63efa91203a77e02280d', './vendor/ckeditor/ckeditor/lang/en-au.js', '15.9', 0),
('b38fcd6dfd7a293fa70e5051b30a068c', './vendor/ckeditor/ckeditor/lang/en-ca.js', '15.9', 0),
('f5c72f4e0065b54e4b280ab44d9b28fc', './vendor/ckeditor/ckeditor/lang/en-gb.js', '15.9', 0),
('adb8e0132280e1fd60229aedefb00d75', './vendor/ckeditor/ckeditor/lang/en.js', '15.9', 0),
('7b72472056804e52297b1e530c7e2463', './vendor/ckeditor/ckeditor/lang/eo.js', '15.9', 0),
('647e3a40cd1f439b6c752e853c973e32', './vendor/ckeditor/ckeditor/lang/es.js', '15.9', 0),
('2e0b944ce73e3c98a2e28adc6bd35c31', './vendor/ckeditor/ckeditor/lang/et.js', '15.9', 0),
('48ee8878a47f5403a7f5c352019ec34b', './vendor/ckeditor/ckeditor/lang/eu.js', '15.9', 0),
('c110eab7363a509680d9b3d2d9ab8de6', './vendor/ckeditor/ckeditor/lang/fa.js', '15.9', 0),
('191c9d45b91cb3a330dd57ec4ef93f6d', './vendor/ckeditor/ckeditor/lang/fi.js', '15.9', 0),
('1361c26370029130f799b0d22ab43d90', './vendor/ckeditor/ckeditor/lang/fo.js', '15.9', 0),
('da08012f890819bc967fef6babbb294c', './vendor/ckeditor/ckeditor/lang/fr-ca.js', '15.9', 0),
('abad7931e572f00b2c0b45954ec43354', './vendor/ckeditor/ckeditor/lang/fr.js', '15.9', 0),
('ea2887af9fd6e86fb1278c9826962a1d', './vendor/ckeditor/ckeditor/lang/gl.js', '15.9', 0),
('ba793814928e99daf456a47fa4ade68b', './vendor/ckeditor/ckeditor/lang/gu.js', '15.9', 0),
('5fbe6778981552ae625c7fe22dcae6a1', './vendor/ckeditor/ckeditor/lang/he.js', '15.9', 0),
('387f016a68aa112f431d76dbcc0f09fd', './vendor/ckeditor/ckeditor/lang/hi.js', '15.9', 0),
('001f999266053082f6a6ffd08e2e6ad4', './vendor/ckeditor/ckeditor/lang/hr.js', '15.9', 0),
('f6595846e95f278092952127cb11d6e5', './vendor/ckeditor/ckeditor/lang/hu.js', '15.9', 0),
('91a1071f9fb32fa401e4e28c445c8667', './vendor/ckeditor/ckeditor/lang/id.js', '15.9', 0),
('b53e31f46a45077d4460453f6b9ce79b', './vendor/ckeditor/ckeditor/lang/is.js', '15.9', 0),
('8abadb20f437fad96f7ae7fb09ba7dcb', './vendor/ckeditor/ckeditor/lang/it.js', '15.9', 0),
('580f01828285e484fbdeddcef22c050a', './vendor/ckeditor/ckeditor/lang/ja.js', '15.9', 0),
('2d93d0dd4aca4463838e0c60db9f0d9b', './vendor/ckeditor/ckeditor/lang/ka.js', '15.9', 0),
('c9c35e20afaefa7cec010e02a1ee499d', './vendor/ckeditor/ckeditor/lang/km.js', '15.9', 0),
('3a31e18f139dc75fbba345bcba499058', './vendor/ckeditor/ckeditor/lang/ko.js', '15.9', 0),
('5502fc423d05de9b241ffe3e39c45aea', './vendor/ckeditor/ckeditor/lang/ku.js', '15.9', 0),
('b692981591bad59da0300d93ce809be7', './vendor/ckeditor/ckeditor/lang/lt.js', '15.9', 0),
('b12ac5bf294dff6b24367f8facbaf3b0', './vendor/ckeditor/ckeditor/lang/lv.js', '15.9', 0),
('3268a2a8563d1d8175699840f924a55c', './vendor/ckeditor/ckeditor/lang/mk.js', '15.9', 0),
('56eba93610ae388a2ece2ee3d4d4306b', './vendor/ckeditor/ckeditor/lang/mn.js', '15.9', 0),
('90ee0323905b002c4e9e2215252abfbf', './vendor/ckeditor/ckeditor/lang/ms.js', '15.9', 0),
('83f8b6c8c75ec8b56a19b6fcf02f1d11', './vendor/ckeditor/ckeditor/lang/nb.js', '15.9', 0),
('d27cd4cbfa1a4ba095295ee3d7c2d7b0', './vendor/ckeditor/ckeditor/lang/nl.js', '15.9', 0),
('4918554e17a596bd0f6357519ac271a5', './vendor/ckeditor/ckeditor/lang/no.js', '15.9', 0),
('67a4163a83121ef600771b80a93bfbf2', './vendor/ckeditor/ckeditor/lang/pl.js', '15.9', 0),
('7e987f44945599810dd5b694f1990bfa', './vendor/ckeditor/ckeditor/lang/pt-br.js', '15.9', 0),
('31a7554c8a2c73bed66676d94cfb8843', './vendor/ckeditor/ckeditor/lang/pt.js', '15.9', 0),
('2c1a5eb317cfe01f56c7ab59ebd8c4d5', './vendor/ckeditor/ckeditor/lang/ro.js', '15.9', 0),
('dcb666b9ac2926f01085ec53e8179ef9', './vendor/ckeditor/ckeditor/lang/ru.js', '15.9', 0),
('0d0debe3a4a10ff7e91c77e08e874b5b', './vendor/ckeditor/ckeditor/lang/si.js', '15.9', 0),
('988c9955c5a1ebc4419e5f0ba119647b', './vendor/ckeditor/ckeditor/lang/sk.js', '15.9', 0),
('1fdeeb8af506f96189a7bc351055be76', './vendor/ckeditor/ckeditor/lang/sl.js', '15.9', 0),
('b6a891d10bc17e24b212dcab0258e5db', './vendor/ckeditor/ckeditor/lang/sq.js', '15.9', 0),
('12c7e5580e134d33e88626e4bf6ddf96', './vendor/ckeditor/ckeditor/lang/sr-latn.js', '15.9', 0),
('2b58969a1db351ad22cc2de27fb49499', './vendor/ckeditor/ckeditor/lang/sr.js', '15.9', 0),
('65cd8988aa32655db13d4b482f1ab7a7', './vendor/ckeditor/ckeditor/lang/sv.js', '15.9', 0),
('bfed9fb84ec3d0aedbf60691887a6035', './vendor/ckeditor/ckeditor/lang/th.js', '15.9', 0),
('f36cd03d09b537a0d5feeece28d6d219', './vendor/ckeditor/ckeditor/lang/tr.js', '15.9', 0),
('db254bb95689f7a66a5cd0716344ea4a', './vendor/ckeditor/ckeditor/lang/tt.js', '15.9', 0),
('67479bc49aecbddb445c0d02ed4419b5', './vendor/ckeditor/ckeditor/lang/ug.js', '15.9', 0),
('c12fce661c1b504f7d96458ca3d1b371', './vendor/ckeditor/ckeditor/lang/uk.js', '15.9', 0),
('7991e96753388c571edb727942042a55', './vendor/ckeditor/ckeditor/lang/vi.js', '15.9', 0),
('74f8e0a705af6fa0643462f262dd670f', './vendor/ckeditor/ckeditor/lang/zh-cn.js', '15.9', 0),
('4539db9c4633f851ab60a6ba0f3f3b58', './vendor/ckeditor/ckeditor/lang/zh.js', '15.9', 0),
('873260f4e2620fba122e609657c3064b', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/a11yhelp.js', '15.9', 0),
('315690ec9bd58550c5045aef05fda8e2', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/af.js', '15.9', 0),
('0cf8c988c718992f56194a0819fcae70', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/ar.js', '15.9', 0),
('50f7756bb78c503c371a52ab8ef836e2', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/bg.js', '15.9', 0),
('4579da371336e0b1103a84bab3c41208', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/ca.js', '15.9', 0),
('338a71f718b15c68f5ab582585042fdc', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/cs.js', '15.9', 0),
('8239134df24bb95cf2a49ba34c8375ab', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/cy.js', '15.9', 0),
('d34d0ba13de302418a9d6077ced86f3c', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/da.js', '15.9', 0),
('4b37acc54850a53bc2afd32f10cde43e', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/de.js', '15.9', 0),
('ad2c1f10cfda1cb1f6236ed7409e5046', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/el.js', '15.9', 0),
('267320240630e5ee0499053acb4d672c', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/en-gb.js', '15.9', 0),
('cb6514fe469cef278284bc86ae4a0be9', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/en.js', '15.9', 0),
('a8e0b39748051eb74f4cc10f4f4a4c9a', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/eo.js', '15.9', 0),
('f6a8e565f6925ab081f82a7cc1ac5d56', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/es.js', '15.9', 0),
('25029cdae96c466f52885792cc8e7bc9', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/et.js', '15.9', 0),
('6a2d35c0f7a81100fd944ce49e9b487d', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/eu.js', '15.9', 0),
('07bff8b4e8d77421d355b70052bb5fd2', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/fa.js', '15.9', 0),
('4d0c01c4bad4e5f304630a3551cc7fae', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/fi.js', '15.9', 0),
('2f6ec820903a1f31045d9e013faf46c9', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/fo.js', '15.9', 0),
('540412130cdf9243528f3c4f4399c80f', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/fr-ca.js', '15.9', 0),
('a17dc922ded6ad2bcb5bc27404fda957', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/fr.js', '15.9', 0),
('ea8ebbcf18a0e492a1064df9f6b63bef', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/gl.js', '15.9', 0),
('fad77455556fba8821db1cc4a33623fb', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/gu.js', '15.9', 0),
('d158094b32c8264830dfa583978a9bca', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/he.js', '15.9', 0),
('c602621533988c2ee4dfe37565bef7de', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/hi.js', '15.9', 0),
('8c0aab4f219556fe75b23a97fa80fd70', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/hr.js', '15.9', 0),
('86fe1dc0f85f7847646790cfff231d49', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/hu.js', '15.9', 0),
('446fc7d8c86beb769e46c612f1f0d341', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/id.js', '15.9', 0),
('3ec65bed1493212805fa544fc534cf5f', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/it.js', '15.9', 0),
('932c133e3134069dd105b84928bd383a', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/ja.js', '15.9', 0),
('832d1c962aad053e4def8d967c4c5ba0', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/km.js', '15.9', 0),
('40f1d161dc272adc2b1171896795cfa3', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/ko.js', '15.9', 0),
('5d70a6cfbbdc94bc09715a3fcc29d533', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/ku.js', '15.9', 0),
('97a9ef235f69a5b1674e402950d996c4', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/lt.js', '15.9', 0),
('3055f543f322e63a33ea30eeca584f27', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/lv.js', '15.9', 0),
('004c0b972a15ee82b18e80b9a36864a0', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/mk.js', '15.9', 0),
('6ca6e9238fe80b77f74237c5ccf6e7d9', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/mn.js', '15.9', 0),
('e8cb9232e0cb7e50858cd3b3c2e0e7bd', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/nb.js', '15.9', 0),
('ab0f899ffd46871efded70f69177b394', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/nl.js', '15.9', 0),
('ccf931437a2c652a8d634bfe58310992', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/no.js', '15.9', 0),
('a23104fd6b3b07d4cc19caa5b19ff19a', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/pl.js', '15.9', 0),
('c11cb83727fcd7c7921132b347766790', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/pt-br.js', '15.9', 0),
('a6eb686e9d8bb00a2bd38d6c8adcbd9e', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/pt.js', '15.9', 0),
('d13a4d738921caa6fb518e67c74c60d5', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/ro.js', '15.9', 0),
('4cd5e195d5070c05ac0aad5c2f93d941', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/ru.js', '15.9', 0),
('a37e630ce79cb2215d99a1122663564a', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/si.js', '15.9', 0),
('7e091d89ded53d29651f68270f634e6f', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/sk.js', '15.9', 0),
('b59d7e4d4557bb3ed3cda7284192deff', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/sl.js', '15.9', 0),
('fec39d1a91757b07319876f811741eaf', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/sq.js', '15.9', 0),
('0bd86e3165cb9eccc8d55ab353767415', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/sr-latn.js', '15.9', 0),
('6ea013eae945b4e889fe2c8537df566b', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/sr.js', '15.9', 0),
('ab0a3caa7342634598b10bc72c0f2676', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/sv.js', '15.9', 0),
('ecbe9170c643c30289f2b422a5016e6a', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/th.js', '15.9', 0),
('ec7a521e181db4c29f8f3b8191dd4e2b', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/tr.js', '15.9', 0),
('9d9765a4e17ca632057528c3555f4dec', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/tt.js', '15.9', 0),
('c04c092cac1d883f681c1ffea4fcf958', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/ug.js', '15.9', 0),
('8e21d4d2fffdeb64d741ead2f91757bf', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/uk.js', '15.9', 0),
('7d364c95e796fa581c1e7511e37e584c', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/vi.js', '15.9', 0),
('ae16426bbb40fff15a7835db4d2c5f00', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/zh-cn.js', '15.9', 0),
('e2f6c5ca1afd392d5fb4e7644e92a807', './vendor/ckeditor/ckeditor/plugins/a11yhelp/dialogs/lang/zh.js', '15.9', 0),
('d2bc176f6de78f61c5728cb311ca3a2d', './vendor/ckeditor/ckeditor/plugins/about/dialogs/about.js', '15.9', 0),
('b8cccc4d20881208b5154c746e105f2a', './vendor/ckeditor/ckeditor/plugins/adobeair/plugin.js', '15.9', 0),
('db8a839a07a249abb3ffcffdcf228964', './vendor/ckeditor/ckeditor/plugins/ajax/plugin.js', '15.9', 0),
('bc02b6685bbf3f8fec1f609697d8534e', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/cs.js', '15.9', 0),
('c87ecec951ff375e6e0a4dabbeb2f104', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/de.js', '15.9', 0),
('5d1bb6bd7045f4c7aa1257a0f1d35265', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/en.js', '15.9', 0),
('b530c6ac9d240c228afdbbcaea6ebfcb', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/eo.js', '15.9', 0),
('da5a6cb0ef7e0d02393a50fba9ccbfd8', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/eu.js', '15.9', 0),
('1f0b0c6f19fd29766471efed2f3db554', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/fr.js', '15.9', 0),
('4167f7852539879abf4ff4bb2e7ae3b9', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/it.js', '15.9', 0),
('34c04abadd31f052e25878dbf1a9b6e6', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/ko.js', '15.9', 0),
('8e9324fb73d06a8c91434b81554e42e0', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/ku.js', '15.9', 0),
('3e6b9bf199aee7586333657fe998a76a', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/nb.js', '15.9', 0),
('8367a7babebd3c33ad303130fe013844', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/pl.js', '15.9', 0),
('955ac6fb6ad1282c8adea503aaa6cb93', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/pt-br.js', '15.9', 0),
('696115a04303e22fd026c59068c74da4', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/ru.js', '15.9', 0),
('d6596f67e1b2070aeff26e81d49ef75e', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/tr.js', '15.9', 0),
('f77c1f10c19902c855412fe6c96cbbeb', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/ug.js', '15.9', 0),
('3b4c500e1b60c9f8a51870901a4164c5', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/uk.js', '15.9', 0),
('b67ebfb138a3431d113a273191bc38a4', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/zh-cn.js', '15.9', 0),
('38f9db959a2ef433bf7fae1c28038830', './vendor/ckeditor/ckeditor/plugins/autoembed/lang/zh.js', '15.9', 0),
('fe6d2879fba6e5c89bf6bdfeecf7f8be', './vendor/ckeditor/ckeditor/plugins/autoembed/plugin.js', '15.9', 0),
('c6253c36a03ec694b14b05f8020a981b', './vendor/ckeditor/ckeditor/plugins/autogrow/plugin.js', '15.9', 0),
('10fb2ac16d0f4baf6d0f8be17b2d74a1', './vendor/ckeditor/ckeditor/plugins/autolink/plugin.js', '15.9', 0),
('d0fd32e3fa5fbf1972f0f7b08a63bec0', './vendor/ckeditor/ckeditor/plugins/bbcode/plugin.js', '15.9', 0),
('815b66f58c4dda70dd2e5a6e5409e3fc', './vendor/ckeditor/ckeditor/plugins/bidi/lang/af.js', '15.9', 0),
('c94dc83d55d1d5eb92d4a5fb3c2d21e3', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ar.js', '15.9', 0),
('ad831b60c0fab59c14182c1569943262', './vendor/ckeditor/ckeditor/plugins/bidi/lang/bg.js', '15.9', 0),
('b96c00bdf4ec39e86a1c5652b1aa6f59', './vendor/ckeditor/ckeditor/plugins/bidi/lang/bn.js', '15.9', 0),
('c10f7999ecf27150bdf18ed5496fc20e', './vendor/ckeditor/ckeditor/plugins/bidi/lang/bs.js', '15.9', 0),
('2dae1869c4ad415e297a2cc4598f2247', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ca.js', '15.9', 0),
('405901e98f457ef8302d5164584eceee', './vendor/ckeditor/ckeditor/plugins/bidi/lang/cs.js', '15.9', 0),
('3cdda43bee867cdf74463449c890b00a', './vendor/ckeditor/ckeditor/plugins/bidi/lang/cy.js', '15.9', 0),
('9b5c0a2c43bc5ebbd01e0345cfa83d04', './vendor/ckeditor/ckeditor/plugins/bidi/lang/da.js', '15.9', 0),
('db11057e7c3f5bbaa77dfc55db23524d', './vendor/ckeditor/ckeditor/plugins/bidi/lang/de.js', '15.9', 0),
('b5bd5f11110fcdf2bd6cbd988da651ad', './vendor/ckeditor/ckeditor/plugins/bidi/lang/el.js', '15.9', 0),
('31c58594ab16e00abe57172e3c3e0db3', './vendor/ckeditor/ckeditor/plugins/bidi/lang/en-au.js', '15.9', 0),
('8551eed40e54f905439cc61565149ba5', './vendor/ckeditor/ckeditor/plugins/bidi/lang/en-ca.js', '15.9', 0),
('6919f52ca2a87e86ce9b90743d83822a', './vendor/ckeditor/ckeditor/plugins/bidi/lang/en-gb.js', '15.9', 0),
('3e4302af947fcece6918d7a01086fe38', './vendor/ckeditor/ckeditor/plugins/bidi/lang/en.js', '15.9', 0),
('1a2120ec224e978f55e062cdcc675efa', './vendor/ckeditor/ckeditor/plugins/bidi/lang/eo.js', '15.9', 0),
('6c03fb6a3bde28ba69dcbb9514163a6c', './vendor/ckeditor/ckeditor/plugins/bidi/lang/es.js', '15.9', 0),
('cbc20ab2385b98b7ebb06bd192456ab5', './vendor/ckeditor/ckeditor/plugins/bidi/lang/et.js', '15.9', 0),
('c77d837002908112b2cd02fe0d69c574', './vendor/ckeditor/ckeditor/plugins/bidi/lang/eu.js', '15.9', 0),
('f7b17edc83c9267aee5f19292aee0bb4', './vendor/ckeditor/ckeditor/plugins/bidi/lang/fa.js', '15.9', 0),
('cf2389be99e46916d608aa7c3bba4558', './vendor/ckeditor/ckeditor/plugins/bidi/lang/fi.js', '15.9', 0),
('a3606421bb2367c42d1e009f2661e132', './vendor/ckeditor/ckeditor/plugins/bidi/lang/fo.js', '15.9', 0),
('d28b5ae650d2996be4dc9bd1932ce051', './vendor/ckeditor/ckeditor/plugins/bidi/lang/fr-ca.js', '15.9', 0),
('56c51bb5f12f9edf9b65a9d2dd370e21', './vendor/ckeditor/ckeditor/plugins/bidi/lang/fr.js', '15.9', 0),
('b122f283dcb131208f81287231d056d1', './vendor/ckeditor/ckeditor/plugins/bidi/lang/gl.js', '15.9', 0),
('7bf72dcb6dce5eb0d8ac3f5282df1919', './vendor/ckeditor/ckeditor/plugins/bidi/lang/gu.js', '15.9', 0),
('6577e3db9b0f9072ea938d8cb14fd7c5', './vendor/ckeditor/ckeditor/plugins/bidi/lang/he.js', '15.9', 0),
('18e658ecbfd978fd4dd09e29e133dc57', './vendor/ckeditor/ckeditor/plugins/bidi/lang/hi.js', '15.9', 0),
('7498900f98f822344e1d368af85cb2e2', './vendor/ckeditor/ckeditor/plugins/bidi/lang/hr.js', '15.9', 0),
('d11a72e00c3d22246b5538b5ac62bcfa', './vendor/ckeditor/ckeditor/plugins/bidi/lang/hu.js', '15.9', 0),
('f12c1b8417ce640c77bf3109878b03f4', './vendor/ckeditor/ckeditor/plugins/bidi/lang/id.js', '15.9', 0),
('7757e2cf559dbf5faad7527a351fd594', './vendor/ckeditor/ckeditor/plugins/bidi/lang/is.js', '15.9', 0),
('178beac46e5d1c346af6a7061b27dada', './vendor/ckeditor/ckeditor/plugins/bidi/lang/it.js', '15.9', 0),
('43442fb160f066da3ea4d61af776073b', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ja.js', '15.9', 0),
('47d0481d1916c965e6a8db06cb92d521', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ka.js', '15.9', 0),
('09bfcfbd30af62d8189f0182707602e3', './vendor/ckeditor/ckeditor/plugins/bidi/lang/km.js', '15.9', 0),
('299a704d4a629b660f3c2d5f29049018', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ko.js', '15.9', 0),
('76f045108c4a5175f83564b213f13f38', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ku.js', '15.9', 0),
('4d0e5d2e2d8e0c33d14e8cf9cbc7f6c3', './vendor/ckeditor/ckeditor/plugins/bidi/lang/lt.js', '15.9', 0),
('b7b37e02f171ef4710236ea75fbe8a56', './vendor/ckeditor/ckeditor/plugins/bidi/lang/lv.js', '15.9', 0),
('de234cdcadb8bf2bd51844a428cffff8', './vendor/ckeditor/ckeditor/plugins/bidi/lang/mk.js', '15.9', 0),
('797e469d5e8e824b7f5b640089fe5d22', './vendor/ckeditor/ckeditor/plugins/bidi/lang/mn.js', '15.9', 0),
('e4968470bdd27d07a9378c09fa6eddb5', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ms.js', '15.9', 0),
('18405381652496858c4092522ae4fdac', './vendor/ckeditor/ckeditor/plugins/bidi/lang/nb.js', '15.9', 0),
('87b9cd9a177b5269e98896731d902e6e', './vendor/ckeditor/ckeditor/plugins/bidi/lang/nl.js', '15.9', 0),
('1982dc708e310ab35d92f04e40224ffa', './vendor/ckeditor/ckeditor/plugins/bidi/lang/no.js', '15.9', 0),
('ba2b8d0152809f1af7b50ec391fede98', './vendor/ckeditor/ckeditor/plugins/bidi/lang/pl.js', '15.9', 0),
('f4a7fb7f89ec319d1ea52b176605d9ab', './vendor/ckeditor/ckeditor/plugins/bidi/lang/pt-br.js', '15.9', 0),
('45f4fcbfd11d09cd46d175c1cccedeac', './vendor/ckeditor/ckeditor/plugins/bidi/lang/pt.js', '15.9', 0),
('fff7997441f685aeb01d5e1d78ba9d7a', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ro.js', '15.9', 0),
('d0f7c8fdff151bcdc822fce2c01be2fd', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ru.js', '15.9', 0),
('c9b731eb4535c16b32fed95a5f026f0b', './vendor/ckeditor/ckeditor/plugins/bidi/lang/si.js', '15.9', 0),
('bef5069b73fe43416dce9e64f7f7b788', './vendor/ckeditor/ckeditor/plugins/bidi/lang/sk.js', '15.9', 0),
('ae63d56d12328ea3bf207456623c0f25', './vendor/ckeditor/ckeditor/plugins/bidi/lang/sl.js', '15.9', 0),
('5eec01156695ef2dfe4ef9594fbf805a', './vendor/ckeditor/ckeditor/plugins/bidi/lang/sq.js', '15.9', 0),
('47c6024a114ee1c87b0397bb9be8bb46', './vendor/ckeditor/ckeditor/plugins/bidi/lang/sr-latn.js', '15.9', 0),
('f48900dfd79cd7185961c4ec952a1ca9', './vendor/ckeditor/ckeditor/plugins/bidi/lang/sr.js', '15.9', 0),
('4e11eba15d114d2fd596c20286bd2b3c', './vendor/ckeditor/ckeditor/plugins/bidi/lang/sv.js', '15.9', 0),
('f9e1046ec1d5ba37ac5a5c3023aee60c', './vendor/ckeditor/ckeditor/plugins/bidi/lang/th.js', '15.9', 0),
('457356cf1ee7140c3da564931373f77e', './vendor/ckeditor/ckeditor/plugins/bidi/lang/tr.js', '15.9', 0),
('80138f59ef4e847dd62042936f86f0da', './vendor/ckeditor/ckeditor/plugins/bidi/lang/tt.js', '15.9', 0),
('dc3207713a37fccb53294e47c24b96bb', './vendor/ckeditor/ckeditor/plugins/bidi/lang/ug.js', '15.9', 0),
('d719fec2b2084578af6e921c5877cf87', './vendor/ckeditor/ckeditor/plugins/bidi/lang/uk.js', '15.9', 0),
('2e65f27219777fae5c3834d0bbe99c00', './vendor/ckeditor/ckeditor/plugins/bidi/lang/vi.js', '15.9', 0),
('82ac825837471d1237f319e02d87d055', './vendor/ckeditor/ckeditor/plugins/bidi/lang/zh-cn.js', '15.9', 0),
('e15252973ecce3f933fe1043559e7e92', './vendor/ckeditor/ckeditor/plugins/bidi/lang/zh.js', '15.9', 0),
('a88533cc52d4dfeae93ffbba0259e372', './vendor/ckeditor/ckeditor/plugins/bidi/plugin.js', '15.9', 0),
('9341b02cb3e12782b41bd4e8c5951814', './vendor/ckeditor/ckeditor/plugins/clipboard/dialogs/paste.js', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('2dc554f6e916f91c4d23c55af72ea284', './vendor/ckeditor/ckeditor/plugins/codesnippet/dialogs/codesnippet.js', '15.9', 0),
('f7878ab09020771f8e5c6ab7bb8a9b0f', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/ar.js', '15.9', 0),
('15815516a03cfc21fe98c562b947b748', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/bg.js', '15.9', 0),
('824d2c14fe0b379a5fc75fb2ac80789b', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/ca.js', '15.9', 0),
('516b1727a4a617e81e763dee879c54b3', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/cs.js', '15.9', 0),
('b4db7af4b0390fdb13fba181d9d9f649', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/da.js', '15.9', 0),
('4206732455e07b1cab5800fbf8723d49', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/de.js', '15.9', 0),
('a0e90fa866be75875c977dd5d646c734', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/el.js', '15.9', 0),
('658851eb7fc5e5780931c6d818a1792b', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/en-gb.js', '15.9', 0),
('4905b5ddc8aa32fc24f4be117ae0eb18', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/en.js', '15.9', 0),
('15fbf74762b71f9bf88c465b82254960', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/eo.js', '15.9', 0),
('4eed111888e129a07f5db9b616248425', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/es.js', '15.9', 0),
('36c120b64d4c66581fd21e20ac43797b', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/et.js', '15.9', 0),
('8e204084822eb635d4dd4d4f5f7ad41d', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/eu.js', '15.9', 0),
('0114ff0ad278b8e107a2b48b3130b32c', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/fa.js', '15.9', 0),
('530ab5d4c902a9ad6a8eea4206946c4e', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/fi.js', '15.9', 0),
('2ab837215d23c77e7556a54b699638de', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/fr-ca.js', '15.9', 0),
('ea66e524eac5feb0e68f0dbcf4f9693e', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/fr.js', '15.9', 0),
('14a51406fe32b0ea38c3470cae68ebf5', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/gl.js', '15.9', 0),
('60cfddbef4e3378cf5fdae758933a046', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/he.js', '15.9', 0),
('d2e4faf16403b2951c6b98b6184e8af3', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/hr.js', '15.9', 0),
('f688757d45924f4a1577e86f181e39fc', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/hu.js', '15.9', 0),
('f5e00c24c13111f53d8a9d7cddccca7a', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/id.js', '15.9', 0),
('97934d75d57d415e50f5297194c28e23', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/it.js', '15.9', 0),
('a24b3a745785c4370f0ee4eff96a1906', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/ja.js', '15.9', 0),
('761d92b8cb1e7262fd544b2ee8b3eb25', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/km.js', '15.9', 0),
('a7c77d5234588f8add5b323d34ed2d95', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/ko.js', '15.9', 0),
('3b02eb9b795a87426bd55d4400ba968c', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/ku.js', '15.9', 0),
('3755ea77f5de4c3f0b33e423a7875df6', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/lt.js', '15.9', 0),
('5c7969b773eea23472d9e5202996af98', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/lv.js', '15.9', 0),
('8e33426437f5677e315cc4cb763c90e7', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/nb.js', '15.9', 0),
('96206821c6e5bd1a42b90ec3eee43a9d', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/nl.js', '15.9', 0),
('0182967db7f8faa2b26f37affda89004', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/no.js', '15.9', 0),
('b4f565f3d1d033bda59c371704eb1450', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/pl.js', '15.9', 0),
('9595480a2c568533790167de4f25e5e1', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/pt-br.js', '15.9', 0),
('2ec31123bb86ef326bc72ca22e11b8c3', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/pt.js', '15.9', 0),
('9d0491185876df30232599a8a81a4b9f', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/ro.js', '15.9', 0),
('9b66c12e74aed7f16cc338ddccf81468', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/ru.js', '15.9', 0),
('b68a63ee5e91f0a0988fee1e8c4cd15e', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/sk.js', '15.9', 0),
('c9a4919eaef0372c719ac0f145271473', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/sl.js', '15.9', 0),
('fae342de75213a699c549841b272819b', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/sq.js', '15.9', 0),
('d8b8c0bd40985b4e4cf2ed8508d196eb', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/sv.js', '15.9', 0),
('10fc20d55ed86b32c0789b05a036ac00', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/th.js', '15.9', 0),
('8a4d022f9097153c7eb2a92465d3be5e', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/tr.js', '15.9', 0),
('1bfdbe289cf6c46627e1ac74d4ff3480', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/tt.js', '15.9', 0),
('a416bc2364051ba131b2b9ff8e3705df', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/ug.js', '15.9', 0),
('2aa714b2b213f8f5faeaf9741085fed2', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/uk.js', '15.9', 0),
('9e7a8b48946a85cae346333956bafbed', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/vi.js', '15.9', 0),
('05644d9b06f42008fee37d8c57f267aa', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/zh-cn.js', '15.9', 0),
('ce416f4c428642beabc6a3708270703b', './vendor/ckeditor/ckeditor/plugins/codesnippet/lang/zh.js', '15.9', 0),
('977b8eecd330f2ea445782a4c9c997fa', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/highlight.pack.js', '15.9', 0),
('3ed8f5aa52ca1d0e7abf6f8e2f782ff5', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/arta.css', '15.9', 0),
('ff175d85cfe2d44dcacea0e65cbd240b', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/ascetic.css', '15.9', 0),
('c344ccef9841cac532e473dc5d1d711b', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-dune.dark.css', '15.9', 0),
('9dfadfcd93893fd15fc5e4f341b10611', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-dune.light.css', '15.9', 0),
('1ddd45d148a5fcff0c87b048e70b70f3', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-forest.dark.css', '15.9', 0),
('cd6b2158c74ae03600776f1a76ddaa4d', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-forest.light.css', '15.9', 0),
('17049077d062cb49b0e4f41e3785d100', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-heath.dark.css', '15.9', 0),
('f8f3c95f59638c361f0448123fa201fa', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-heath.light.css', '15.9', 0),
('3a41797094557f4de11dc3e3fb742dc2', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-lakeside.dark.css', '15.9', 0),
('ce57d9e033deb51708854c7eb8280b5c', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-lakeside.light.css', '15.9', 0),
('2e94eb8c21c6c5fc174a688c34ae1b2f', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-seaside.dark.css', '15.9', 0),
('629ee1040c30abd5f5747ee8e509d112', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/atelier-seaside.light.css', '15.9', 0),
('fd5b557021be9457f00c3b953f78c874', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/brown_paper.css', '15.9', 0),
('7fa1a0e8b54711640d7f0e2d9f3365d6', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/dark.css', '15.9', 0),
('2d08366db2f2adbd71d8f751e81817a5', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/default.css', '15.9', 0),
('c86e4371c527667427a099230ed759fb', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/docco.css', '15.9', 0),
('66054bb65c7bdb2ba999159732b85ce3', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/far.css', '15.9', 0),
('ac41588b8fbf2cf21561ee985ed6f4da', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/foundation.css', '15.9', 0),
('3e8074094f1b59899f3a7ab495d1635e', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/github.css', '15.9', 0),
('06ce7f740cd70418bb24b082d316b4de', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/googlecode.css', '15.9', 0),
('b3a5fde1fbb8952391682d3fb4912695', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/idea.css', '15.9', 0),
('24edbc14391d3386a3c9e8b92e67c9f1', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/ir_black.css', '15.9', 0),
('c4056b290d5a8a1e420a5894a07cc4ab', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/magula.css', '15.9', 0),
('3c937c255a586f2025fa25bddab17055', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/mono-blue.css', '15.9', 0),
('85a7b5140c15178730b769a229bee98f', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/monokai.css', '15.9', 0),
('35229da634f5b5e1d8bf1f2ec08fa1f5', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/monokai_sublime.css', '15.9', 0),
('aa4e387fa53790cb5c6b16656f56ac28', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/obsidian.css', '15.9', 0),
('e3a01348e160a10a6d93cdf53cc6f364', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/paraiso.dark.css', '15.9', 0),
('681473dd23887ebbd60ec6cea5562cd9', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/paraiso.light.css', '15.9', 0),
('58791ab8c931cff71e799f2d7c959508', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/pojoaque.css', '15.9', 0),
('4ddf6274ae9f9aeb41798b7bec42e730', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/railscasts.css', '15.9', 0),
('d9c944697741651953e500aafd4110cb', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/rainbow.css', '15.9', 0),
('10856a3d7749e2dc8173fde6d5989b4a', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/school_book.css', '15.9', 0),
('eeb3acd8b77ad458d8688941e7aba820', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/solarized_dark.css', '15.9', 0),
('d42f399f1ab5cffa595737d80330ddcb', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/solarized_light.css', '15.9', 0),
('5b131187a661e31ff8449c52da97decc', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/sunburst.css', '15.9', 0),
('89be6fa92e905424942f5c2056fd38d8', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/tomorrow-night-blue.css', '15.9', 0),
('6a3ef38ee4b36b97bb8b9897fa72ce46', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/tomorrow-night-bright.css', '15.9', 0),
('a3f5af91481262e8ef166fca7574a85b', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/tomorrow-night-eighties.css', '15.9', 0),
('72871f1c584649616628fc304b789990', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/tomorrow-night.css', '15.9', 0),
('b7e261c486c52b92e797dab6a7322996', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/tomorrow.css', '15.9', 0),
('ea297056fd03c63a6da87df5c3e2567f', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/vs.css', '15.9', 0),
('4dd2fdfcb895a63e4a76b7b6f7b0adda', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/xcode.css', '15.9', 0),
('174e48ce66b4cc3b853c6230d4911ee7', './vendor/ckeditor/ckeditor/plugins/codesnippet/lib/highlight/styles/zenburn.css', '15.9', 0),
('c7894e1dcfd5d5a807f9e6010d95c06d', './vendor/ckeditor/ckeditor/plugins/codesnippet/plugin.js', '15.9', 0),
('3425acb29de3dfa244756436d7f58d32', './vendor/ckeditor/ckeditor/plugins/codesnippetgeshi/plugin.js', '15.9', 0),
('7aa46ddde276c235f009eaba3fe2a39c', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/af.js', '15.9', 0),
('0b0e5fd1eb33984d1d9a1b620a65961a', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ar.js', '15.9', 0),
('a4d6940734318e32969a6ac76b8b78de', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/bg.js', '15.9', 0),
('eea38e20f5fab5824b8b5746c0f15c9c', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/bn.js', '15.9', 0),
('fca5b44431b360d66a71527b7a1f73e5', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/bs.js', '15.9', 0),
('bedc9c393ad5bc9d0ca415c6dbc27118', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ca.js', '15.9', 0),
('eeeefe91ad834fa082136a0fe09570b8', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/cs.js', '15.9', 0),
('0267fa8c3d8c89bd54c66212af0ddd6e', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/cy.js', '15.9', 0),
('b9c2abf8c1b702d0ce1d609d91be17cc', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/da.js', '15.9', 0),
('9ab1a2316f460cf6ddba2b4e060f32d9', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/de.js', '15.9', 0),
('f41314c80420f1d288b8f9877fc34e36', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/el.js', '15.9', 0),
('71b1bdbf78f77d638883d70d4cc60968', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/en-au.js', '15.9', 0),
('6e305f8a7d1527f9197522f7a6576502', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/en-ca.js', '15.9', 0),
('d56a0041161232626c4df4d47c651c32', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/en-gb.js', '15.9', 0),
('2eb289578dad90c38ff96c9f50e09170', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/en.js', '15.9', 0),
('124070e389b2701fcabbafc001fc3727', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/eo.js', '15.9', 0),
('f0dcb164d10df0400a1d8e47ed59089f', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/es.js', '15.9', 0),
('c7f4b6af2c8c9a84176b88ed8b3cde40', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/et.js', '15.9', 0),
('53b203593f44982b92124433dc267590', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/eu.js', '15.9', 0),
('27faff4dacbae0be36769ee78a304932', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/fa.js', '15.9', 0),
('46475b40ced832cd66feff98b74fb9de', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/fi.js', '15.9', 0),
('00e2a7bda4167f88b5e915a13ea21c7a', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/fo.js', '15.9', 0),
('e3e1b172a0d62929064da0a2f78945b4', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/fr-ca.js', '15.9', 0),
('090d605cedc732ff564f2ed01569bfdf', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/fr.js', '15.9', 0),
('7166bfd18581bee0dbbb299d9ca67b88', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/gl.js', '15.9', 0),
('28efb7a884648a9983722c34e16bc4da', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/gu.js', '15.9', 0),
('138782e11e143086d586b56144e498bb', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/he.js', '15.9', 0),
('6de826d20b3cea635d938f2b5b84de35', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/hi.js', '15.9', 0),
('4aadc8c93160d2f27b46fa022e19e93c', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/hr.js', '15.9', 0),
('6a705ec9c0f96fcd69d8a4b6e239ca73', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/hu.js', '15.9', 0),
('61d50e3d69a015d1a99db906f5b1b80e', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/id.js', '15.9', 0),
('ef7c02d5df7c549895f1da6171b1a79b', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/is.js', '15.9', 0),
('f9d9e8367c299e985e63f9bcdd40927b', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/it.js', '15.9', 0),
('7a60896ec97a93e5607069ed9e8b0f16', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ja.js', '15.9', 0),
('73727ac8e2577f67133ae56d84d96e48', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ka.js', '15.9', 0),
('d7da24f04a802f22277fc46799dd8d3a', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/km.js', '15.9', 0),
('fb3e7a6716546687e715d12ecb6283ec', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ko.js', '15.9', 0),
('d009aa0ec6dcd8e81f8bb3b25e2b117f', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ku.js', '15.9', 0),
('466536ff1ce891f6701d475b4486547b', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/lt.js', '15.9', 0),
('5230b0ee20927768fa576192306f704b', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/lv.js', '15.9', 0),
('bf32f58f8d787ead7e4903bcb810fff4', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/mk.js', '15.9', 0),
('20b9f0ff9ed4c22fe8049d1dfb6d9681', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/mn.js', '15.9', 0),
('9ab7fd6d58c51c687194267c7211c5aa', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ms.js', '15.9', 0),
('46107d03020286d472b8baacc7c587d5', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/nb.js', '15.9', 0),
('836fbd836273833bacac716513c2b6f6', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/nl.js', '15.9', 0),
('b6a6e2de612e673b53fb975424fbd4f0', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/no.js', '15.9', 0),
('833a0bb7c67a0916fe89e4c83322f7d9', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/pl.js', '15.9', 0),
('2d1d42e32a4f7a2b68dc4a8b31dd74d4', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/pt-br.js', '15.9', 0),
('97e87fda0446a0720a761af1bec11614', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/pt.js', '15.9', 0),
('ccac7ed9185b2a6fb7cb8512989a252b', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ro.js', '15.9', 0),
('66d332d5b83320de181d3cb27f50f375', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ru.js', '15.9', 0),
('45f018551d5f59961f9ff815db8610d6', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/si.js', '15.9', 0),
('0264fad6bb337948ff5108d62ff9b6b3', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/sk.js', '15.9', 0),
('c66d2424756d2703f57b8a9d844f7d55', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/sl.js', '15.9', 0),
('a9460cd944ddfc02950fda978d8d436b', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/sq.js', '15.9', 0),
('bbfc57c0096daa819071af555ddd2e07', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/sr-latn.js', '15.9', 0),
('0b43133ced3b2b7cf4e3710006ce4af6', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/sr.js', '15.9', 0),
('b554e1bfb00b3e2e110d5f80961d90a2', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/sv.js', '15.9', 0),
('3920e7256cf102c4615d40031edee828', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/th.js', '15.9', 0),
('4e0fbf172387aa0e0ccdbf85abf89e5b', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/tr.js', '15.9', 0),
('d8f9e59beb1c54a30155b14b523361ae', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/tt.js', '15.9', 0),
('e568a096e2675e86c0ec58afeeba0ae8', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/ug.js', '15.9', 0),
('0d48532528bfb2b187c97b20cb8d4f02', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/uk.js', '15.9', 0),
('844a3c2e9bf6dc3557d44ecc17cff594', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/vi.js', '15.9', 0),
('6e2e5571554b5c44fd1637a72e787365', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/zh-cn.js', '15.9', 0),
('6b2115f06dd93e367cc393139fcf94b2', './vendor/ckeditor/ckeditor/plugins/colorbutton/lang/zh.js', '15.9', 0),
('e8bf8b686161ac6eadb893bcdd48bcaa', './vendor/ckeditor/ckeditor/plugins/colorbutton/plugin.js', '15.9', 0),
('fafb4faddaac3f69ffb81830659e8396', './vendor/ckeditor/ckeditor/plugins/colordialog/dialogs/colordialog.js', '15.9', 0),
('73121e93d9b3642961aa17b6d4c397ac', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/af.js', '15.9', 0),
('093e220d01448f4e8888f8d0331703c7', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ar.js', '15.9', 0),
('2ab17b99558a34d91d76c553e710e279', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/bg.js', '15.9', 0),
('2e24d8d8e4440731e4ffd419400c05b2', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/bn.js', '15.9', 0),
('2f78705d68b47befb9ffc5489cc4c84f', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/bs.js', '15.9', 0),
('2884f554eaf7221e12cc43e0dea23c81', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ca.js', '15.9', 0),
('cc0614c681e09c9881e50e71ee377dba', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/cs.js', '15.9', 0),
('6c6e159933d204fc29d6b6e85d3465ab', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/cy.js', '15.9', 0),
('c7a51ecc7974a0ec15cba7d44b018d12', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/da.js', '15.9', 0),
('9d31193cdff4a56630cd8308fb789d62', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/de.js', '15.9', 0),
('c54fc5540022e0d5ad3546ec0790eb78', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/el.js', '15.9', 0),
('278b4aba83ac5014d264483fdf40a467', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/en-au.js', '15.9', 0),
('75a22bf9c016b5ac3df0fd84091538fe', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/en-ca.js', '15.9', 0),
('6a66584e2131bfa8454689e5d2cec859', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/en-gb.js', '15.9', 0),
('d6391927de6ee299617978c071571884', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/en.js', '15.9', 0),
('d73e23276e83fad4c9943764d9527b4a', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/eo.js', '15.9', 0),
('80878ee27941c094d269a04eca6f5bb1', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/es.js', '15.9', 0),
('605b3399c8fd0fe0a5c6f882374dcf95', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/et.js', '15.9', 0),
('6cfa047788b579f1329273067509b6e0', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/eu.js', '15.9', 0),
('e305524f9978bbb14ae8c7e4c1762e23', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/fa.js', '15.9', 0),
('f67e56edaa95d9de3e6122c6476916b1', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/fi.js', '15.9', 0),
('8056ae37e4727728328e20789a46089e', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/fo.js', '15.9', 0),
('5e7a42de2ebcbca9b389d48b235776ee', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/fr-ca.js', '15.9', 0),
('f494b8a9c6457beed20bcca67461b417', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/fr.js', '15.9', 0),
('1cf965fc7e00299954a6e17f9955fe0b', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/gl.js', '15.9', 0),
('e85d5611e3db276e50ba580955035e1d', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/gu.js', '15.9', 0),
('ad1da5ec7353fabbd63731c1d4a78580', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/he.js', '15.9', 0),
('387d749deaeb746aa4c67490568493bc', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/hi.js', '15.9', 0),
('e929240aa86d85f4dc06e8dc2241a6f3', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/hr.js', '15.9', 0),
('702348ac0404806bbf49f192edd9c169', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/hu.js', '15.9', 0),
('8075e05c4fa4ebabc9190212c7d41b1d', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/id.js', '15.9', 0),
('72276ac9002ef9595843117bb0582e75', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/is.js', '15.9', 0),
('8c3f61ec57125c9aa8d9cebdf67bfefc', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/it.js', '15.9', 0),
('716a83f540ecf7ddb558b9e5215c59da', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ja.js', '15.9', 0),
('2017240864cf41aa84a53f48dc634b3e', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ka.js', '15.9', 0),
('af273e93cc6624f6b8e5caae3e8bb7bb', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/km.js', '15.9', 0),
('2ccad05788e9def9a3289897d74616f4', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ko.js', '15.9', 0),
('35d00a278526377e0ad68bd26ebf3a1a', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ku.js', '15.9', 0),
('182d7b7b8b7a07abe6f5065bd22d85f7', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/lt.js', '15.9', 0),
('7d09bac12ce0d0a70d58e100242b9171', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/lv.js', '15.9', 0),
('4087fc0f9401c73cbe354ec7d4e95d4f', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/mk.js', '15.9', 0),
('cb5d01815e9dbf0e35efc6efdee4599a', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/mn.js', '15.9', 0),
('b6296472d85a0f5f282d917da6d244f1', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ms.js', '15.9', 0),
('99ad91d25ad79f905782d9bd5f6cefd3', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/nb.js', '15.9', 0),
('c846c7f34858b696ccf8206d2ae3f5bf', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/nl.js', '15.9', 0),
('af469b30c79b970730a6bb49707ef582', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/no.js', '15.9', 0),
('a4558e1224657401d0c5d3153fbda8f6', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/pl.js', '15.9', 0),
('9293ad29e92d2a5b783398839439a6a9', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/pt-br.js', '15.9', 0),
('b963b950432a79968c7a57098bcc58aa', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/pt.js', '15.9', 0),
('a520b04d09c81c9122418a0ba7c40fa4', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ro.js', '15.9', 0),
('533303c99aeed4e6890329f5d1ccc1eb', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ru.js', '15.9', 0),
('46d9933fb06bfe7498f3280deec446ad', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/si.js', '15.9', 0),
('3f659f07b20857a0f5a35ff1bca145b3', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/sk.js', '15.9', 0),
('bb84f60eb6f959c16e93c6a8942187d6', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/sl.js', '15.9', 0),
('9bc8b8c4367da01d81f5e87f093fa947', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/sq.js', '15.9', 0),
('5d2e8aedf132d23ecac8739f47d35f07', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/sr-latn.js', '15.9', 0),
('b78203e246dfbff333721a9eac493a18', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/sr.js', '15.9', 0),
('4016145626363166b57390c4593dd5da', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/sv.js', '15.9', 0),
('19695caa126f8b2982bb7c25a3352898', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/th.js', '15.9', 0),
('1ae012fa914779d012369ac310b3ce84', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/tr.js', '15.9', 0),
('303790fc1d552eff12d57956582c3183', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/tt.js', '15.9', 0),
('7d562e98b769b3f73e6a9ba013aaeefa', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/ug.js', '15.9', 0),
('17f332003f6c146fe6b9bad40d2f1e94', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/uk.js', '15.9', 0),
('1bc6395a4e10e2e242d8c7fa1603f8b7', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/vi.js', '15.9', 0),
('189ebb382ac2107a842f4c3083933c8a', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/zh-cn.js', '15.9', 0),
('23f6e533c30d70f88a2458d85e502b86', './vendor/ckeditor/ckeditor/plugins/colordialog/lang/zh.js', '15.9', 0),
('98c7274b6ec8ac6cd1876beb467c2fab', './vendor/ckeditor/ckeditor/plugins/colordialog/plugin.js', '15.9', 0),
('492fe4698aaa3757c7ab06d942a472c3', './vendor/ckeditor/ckeditor/plugins/devtools/lang/ar.js', '15.9', 0),
('06bf861d987072de1686c8c8e064ec1b', './vendor/ckeditor/ckeditor/plugins/devtools/lang/bg.js', '15.9', 0),
('42e3c2e8d35f25edc989245cf81138c4', './vendor/ckeditor/ckeditor/plugins/devtools/lang/ca.js', '15.9', 0),
('a7705ae2c11b66db32040f77cc1e2826', './vendor/ckeditor/ckeditor/plugins/devtools/lang/cs.js', '15.9', 0),
('c20f6c1294bbc4465f7585c627c924c2', './vendor/ckeditor/ckeditor/plugins/devtools/lang/cy.js', '15.9', 0),
('d4c68fbb3b808e0583553cbe6c5e0275', './vendor/ckeditor/ckeditor/plugins/devtools/lang/da.js', '15.9', 0),
('e20c3457229152b01b43aa80e0a604d5', './vendor/ckeditor/ckeditor/plugins/devtools/lang/de.js', '15.9', 0),
('00017a414aefa3d452d3731582fbe0cf', './vendor/ckeditor/ckeditor/plugins/devtools/lang/el.js', '15.9', 0),
('83dfdef2657205c13f8ea4705561e4a9', './vendor/ckeditor/ckeditor/plugins/devtools/lang/en-gb.js', '15.9', 0),
('be2da7b6184a9643b9c9d66416f06ccd', './vendor/ckeditor/ckeditor/plugins/devtools/lang/en.js', '15.9', 0),
('f88b419206c5165315465677aef6c285', './vendor/ckeditor/ckeditor/plugins/devtools/lang/eo.js', '15.9', 0),
('76294802028423151396775933ec70a3', './vendor/ckeditor/ckeditor/plugins/devtools/lang/es.js', '15.9', 0),
('d61948096f3f3e3564f555d1004c65f9', './vendor/ckeditor/ckeditor/plugins/devtools/lang/et.js', '15.9', 0),
('de1df1c1703957c294b34113d0e9dd4a', './vendor/ckeditor/ckeditor/plugins/devtools/lang/eu.js', '15.9', 0),
('83d899bad88da04d187494012d4377df', './vendor/ckeditor/ckeditor/plugins/devtools/lang/fa.js', '15.9', 0),
('714b5526725e73cd6b8f868bc0ebbac4', './vendor/ckeditor/ckeditor/plugins/devtools/lang/fi.js', '15.9', 0),
('f5cd0f743d5d56659e43141d664b80b7', './vendor/ckeditor/ckeditor/plugins/devtools/lang/fr-ca.js', '15.9', 0),
('8430617b2d94c5c2c302e076f2935752', './vendor/ckeditor/ckeditor/plugins/devtools/lang/fr.js', '15.9', 0),
('4d189d9000a212b1e6e51caed41a14cb', './vendor/ckeditor/ckeditor/plugins/devtools/lang/gl.js', '15.9', 0),
('5184eafd9b2602a9d9b17cf9daccb710', './vendor/ckeditor/ckeditor/plugins/devtools/lang/gu.js', '15.9', 0),
('afbb3e9cd5213b331026888f89af47d3', './vendor/ckeditor/ckeditor/plugins/devtools/lang/he.js', '15.9', 0),
('fcad065ac0dd90b4766a908327a2a4b9', './vendor/ckeditor/ckeditor/plugins/devtools/lang/hr.js', '15.9', 0),
('3a000d11b954b5a47c4f915a0d155824', './vendor/ckeditor/ckeditor/plugins/devtools/lang/hu.js', '15.9', 0),
('5d37b23c1965f43c99067729952e5f15', './vendor/ckeditor/ckeditor/plugins/devtools/lang/id.js', '15.9', 0),
('fea101c31280c14a6c8694e89a9396fe', './vendor/ckeditor/ckeditor/plugins/devtools/lang/it.js', '15.9', 0),
('4ddafb891240d4f127edf93397d02f06', './vendor/ckeditor/ckeditor/plugins/devtools/lang/ja.js', '15.9', 0),
('277dd5678b65ba259bd8a76b58abdd1a', './vendor/ckeditor/ckeditor/plugins/devtools/lang/km.js', '15.9', 0),
('bc03965dfeda2b955f5ed43534e5d4ac', './vendor/ckeditor/ckeditor/plugins/devtools/lang/ko.js', '15.9', 0),
('4cac5e608e781aa75e1d12f4c3227b02', './vendor/ckeditor/ckeditor/plugins/devtools/lang/ku.js', '15.9', 0),
('a70c7b8d3d36b5eb0591975b3aea0984', './vendor/ckeditor/ckeditor/plugins/devtools/lang/lt.js', '15.9', 0),
('5e91ce485524c901c4a802cd3b730319', './vendor/ckeditor/ckeditor/plugins/devtools/lang/lv.js', '15.9', 0),
('e737974d7e9082ca47bf4ec641ca8fa5', './vendor/ckeditor/ckeditor/plugins/devtools/lang/nb.js', '15.9', 0),
('8c0da60b8a69d66821e675a598a873f3', './vendor/ckeditor/ckeditor/plugins/devtools/lang/nl.js', '15.9', 0),
('f1a480977ca5c32f876b56280667f54c', './vendor/ckeditor/ckeditor/plugins/devtools/lang/no.js', '15.9', 0),
('3aab5199dc2deefe52e2edbc417e3dbe', './vendor/ckeditor/ckeditor/plugins/devtools/lang/pl.js', '15.9', 0),
('a788d23d9b64a438ca8e956f168316f5', './vendor/ckeditor/ckeditor/plugins/devtools/lang/pt-br.js', '15.9', 0),
('2e78129eaf8675cfa73df6884b42a8f8', './vendor/ckeditor/ckeditor/plugins/devtools/lang/pt.js', '15.9', 0),
('6160e20fc698abae8ab191cdd11bebf3', './vendor/ckeditor/ckeditor/plugins/devtools/lang/ro.js', '15.9', 0),
('929f877c244a8dd92d017d7146172b51', './vendor/ckeditor/ckeditor/plugins/devtools/lang/ru.js', '15.9', 0),
('5ddd3c30372213b58c9644a74ce2b949', './vendor/ckeditor/ckeditor/plugins/devtools/lang/si.js', '15.9', 0),
('6fc6cbb9cb018a2d4b37c95b99a0125b', './vendor/ckeditor/ckeditor/plugins/devtools/lang/sk.js', '15.9', 0),
('5026ad64092718b847e146c6494d80c0', './vendor/ckeditor/ckeditor/plugins/devtools/lang/sl.js', '15.9', 0),
('9bd061781784e8fdce9ec75f694f79a2', './vendor/ckeditor/ckeditor/plugins/devtools/lang/sq.js', '15.9', 0),
('05c668dcfd64c5ec5e83e69d11642fb3', './vendor/ckeditor/ckeditor/plugins/devtools/lang/sv.js', '15.9', 0),
('15381ffe0063c0e74467ee664690130c', './vendor/ckeditor/ckeditor/plugins/devtools/lang/tr.js', '15.9', 0),
('aa1919c052f45641e120f893b3ffe229', './vendor/ckeditor/ckeditor/plugins/devtools/lang/tt.js', '15.9', 0),
('fb42da25516a7fd3d40e1caefb6f9306', './vendor/ckeditor/ckeditor/plugins/devtools/lang/ug.js', '15.9', 0),
('b17cb51be9f42b14a3b29540ac5f8d0b', './vendor/ckeditor/ckeditor/plugins/devtools/lang/uk.js', '15.9', 0),
('7cdb02264ebf2b40676090ba24ecf5dc', './vendor/ckeditor/ckeditor/plugins/devtools/lang/vi.js', '15.9', 0),
('5812c319fee21927c42f0c046fa572d8', './vendor/ckeditor/ckeditor/plugins/devtools/lang/zh-cn.js', '15.9', 0),
('30648b84cbdf3af2a95cce6e35584dbb', './vendor/ckeditor/ckeditor/plugins/devtools/lang/zh.js', '15.9', 0),
('e7f5248fc986594ec81f3cb51a555d91', './vendor/ckeditor/ckeditor/plugins/devtools/plugin.js', '15.9', 0),
('fabff1607126990e64667a151c3cd390', './vendor/ckeditor/ckeditor/plugins/dialog/dialogDefinition.js', '15.9', 0),
('a96b9be690f8ebe9ff44f9364d62bff0', './vendor/ckeditor/ckeditor/plugins/dialogadvtab/plugin.js', '15.9', 0),
('574ec1e97ae1e74720ae4f746a6af29a', './vendor/ckeditor/ckeditor/plugins/div/dialogs/div.js', '15.9', 0),
('4d91a4759e7d9c91713e84f1a74f0468', './vendor/ckeditor/ckeditor/plugins/div/lang/af.js', '15.9', 0),
('11f961ab00bd46a7a25b025c206b5e28', './vendor/ckeditor/ckeditor/plugins/div/lang/ar.js', '15.9', 0),
('84bd13c7841317fb0a80a662ef56f666', './vendor/ckeditor/ckeditor/plugins/div/lang/bg.js', '15.9', 0),
('6a573c4902de381ed21291123861213f', './vendor/ckeditor/ckeditor/plugins/div/lang/bn.js', '15.9', 0),
('21fa8a74e0a3c34e78753719ac9c3d2a', './vendor/ckeditor/ckeditor/plugins/div/lang/bs.js', '15.9', 0),
('7ac865c094e96dbd4c27e55c125ee793', './vendor/ckeditor/ckeditor/plugins/div/lang/ca.js', '15.9', 0),
('d61f5c5760a4d2069f7bbecf9e2ead2e', './vendor/ckeditor/ckeditor/plugins/div/lang/cs.js', '15.9', 0),
('f8d6d4bbe242d288f8128c261ad9238f', './vendor/ckeditor/ckeditor/plugins/div/lang/cy.js', '15.9', 0),
('eff95b07f50294ecae59e1641402e96e', './vendor/ckeditor/ckeditor/plugins/div/lang/da.js', '15.9', 0),
('99e9d194b4961e39a47f7621ff177554', './vendor/ckeditor/ckeditor/plugins/div/lang/de.js', '15.9', 0),
('f1efcfce30e34de1cb8d65dc780b723b', './vendor/ckeditor/ckeditor/plugins/div/lang/el.js', '15.9', 0),
('3c7c9a48739343f7f2b812743558c759', './vendor/ckeditor/ckeditor/plugins/div/lang/en-au.js', '15.9', 0),
('94ad758b115779e0c4d4ce1cdbb6ef54', './vendor/ckeditor/ckeditor/plugins/div/lang/en-ca.js', '15.9', 0),
('97100e5d653af20a9cd066b4af1e073a', './vendor/ckeditor/ckeditor/plugins/div/lang/en-gb.js', '15.9', 0),
('b31e7b7b93c2bc73effb784a309e42c4', './vendor/ckeditor/ckeditor/plugins/div/lang/en.js', '15.9', 0),
('6524cbf16b33fab96c66d07d1dc32696', './vendor/ckeditor/ckeditor/plugins/div/lang/eo.js', '15.9', 0),
('d26535ed5ef3bb3a383bba75edcc8352', './vendor/ckeditor/ckeditor/plugins/div/lang/es.js', '15.9', 0),
('9a9e4f3281db625c3377a0a03275fba6', './vendor/ckeditor/ckeditor/plugins/div/lang/et.js', '15.9', 0),
('d5900e857c059c46151edf423edf2623', './vendor/ckeditor/ckeditor/plugins/div/lang/eu.js', '15.9', 0),
('5a89a3329fca621cad057128c6d808bb', './vendor/ckeditor/ckeditor/plugins/div/lang/fa.js', '15.9', 0),
('46e4118604263eda9ea97afdb6a23820', './vendor/ckeditor/ckeditor/plugins/div/lang/fi.js', '15.9', 0),
('0ca50184f37f50acdc61c6dcc42e56f2', './vendor/ckeditor/ckeditor/plugins/div/lang/fo.js', '15.9', 0),
('0d8e9d5c64e4f38d8e48400517f449ec', './vendor/ckeditor/ckeditor/plugins/div/lang/fr-ca.js', '15.9', 0),
('87df5ba8ed43e2744cf259171a67e61f', './vendor/ckeditor/ckeditor/plugins/div/lang/fr.js', '15.9', 0),
('b269cf4710b7aff2a9112f9dcbeed309', './vendor/ckeditor/ckeditor/plugins/div/lang/gl.js', '15.9', 0),
('e863cfe09cf5a2df0bad98f7af3fb5ea', './vendor/ckeditor/ckeditor/plugins/div/lang/gu.js', '15.9', 0),
('ea824b213d273da92d5fda5c5bc215da', './vendor/ckeditor/ckeditor/plugins/div/lang/he.js', '15.9', 0),
('5df9ff384745cac546454ddfd0168e13', './vendor/ckeditor/ckeditor/plugins/div/lang/hi.js', '15.9', 0),
('e2177f3822d25c331d9a9d29b50fb60c', './vendor/ckeditor/ckeditor/plugins/div/lang/hr.js', '15.9', 0),
('2f7b1f98563e914ea7462a00d015b465', './vendor/ckeditor/ckeditor/plugins/div/lang/hu.js', '15.9', 0),
('9881747a174eb4c0103e9b1b1a31f671', './vendor/ckeditor/ckeditor/plugins/div/lang/id.js', '15.9', 0),
('1141855ee93b61c5e2101d4db25999b5', './vendor/ckeditor/ckeditor/plugins/div/lang/is.js', '15.9', 0),
('70aa0271d729916bc265c0b4379e8b80', './vendor/ckeditor/ckeditor/plugins/div/lang/it.js', '15.9', 0),
('23eccc7184c40062221e55c004a8e549', './vendor/ckeditor/ckeditor/plugins/div/lang/ja.js', '15.9', 0),
('bf367fb1f915a2a879ef8f5981d9c2bd', './vendor/ckeditor/ckeditor/plugins/div/lang/ka.js', '15.9', 0),
('2ae9c6505366ed4954d9055ecc702f51', './vendor/ckeditor/ckeditor/plugins/div/lang/km.js', '15.9', 0),
('478a1d91368665db7b366802a7864c12', './vendor/ckeditor/ckeditor/plugins/div/lang/ko.js', '15.9', 0),
('d41387f90bd4ac008f40c8d3a8a0f744', './vendor/ckeditor/ckeditor/plugins/div/lang/ku.js', '15.9', 0),
('b556d05cf41d087d7125d3778d96ddb4', './vendor/ckeditor/ckeditor/plugins/div/lang/lt.js', '15.9', 0),
('1786b9663acfdd049c059966f7f1b87c', './vendor/ckeditor/ckeditor/plugins/div/lang/lv.js', '15.9', 0),
('57399003b88affb02d26edf392b3c952', './vendor/ckeditor/ckeditor/plugins/div/lang/mk.js', '15.9', 0),
('ec326a02d380c074ec980dde9121e84c', './vendor/ckeditor/ckeditor/plugins/div/lang/mn.js', '15.9', 0),
('4265653889a5cc13326f431c037e5ffa', './vendor/ckeditor/ckeditor/plugins/div/lang/ms.js', '15.9', 0),
('eda6488f070189a3812ea661d6f5ddf8', './vendor/ckeditor/ckeditor/plugins/div/lang/nb.js', '15.9', 0),
('edc53c4ad8b08e6dcdded6eb0d2f7ea8', './vendor/ckeditor/ckeditor/plugins/div/lang/nl.js', '15.9', 0),
('dfe458e5c2f1551d3d8f7619882b9f59', './vendor/ckeditor/ckeditor/plugins/div/lang/no.js', '15.9', 0),
('8059730158bcdfd1099fa43614f76c73', './vendor/ckeditor/ckeditor/plugins/div/lang/pl.js', '15.9', 0),
('4e30cc9890d372f7fd8958822fc196a2', './vendor/ckeditor/ckeditor/plugins/div/lang/pt-br.js', '15.9', 0),
('933c45562047a170c640beba877d2f78', './vendor/ckeditor/ckeditor/plugins/div/lang/pt.js', '15.9', 0),
('0f78604b6afa56bd9c1cdfa01efb478f', './vendor/ckeditor/ckeditor/plugins/div/lang/ro.js', '15.9', 0),
('8c2e194e6ee731e7003f7990d30d5f1f', './vendor/ckeditor/ckeditor/plugins/div/lang/ru.js', '15.9', 0),
('4c2e99634015d0cf7a762f871b6fbbc3', './vendor/ckeditor/ckeditor/plugins/div/lang/si.js', '15.9', 0),
('96e4a8873bdfbf87b5e374380d786029', './vendor/ckeditor/ckeditor/plugins/div/lang/sk.js', '15.9', 0),
('cb862f616c64464d9f6985349dad4633', './vendor/ckeditor/ckeditor/plugins/div/lang/sl.js', '15.9', 0),
('23f99883588a5cca7b07f5cda9daf0f6', './vendor/ckeditor/ckeditor/plugins/div/lang/sq.js', '15.9', 0),
('07d40cf7593b6eeec67feaf7923bc9f8', './vendor/ckeditor/ckeditor/plugins/div/lang/sr-latn.js', '15.9', 0),
('8f481230f27d8665025075475e8760e7', './vendor/ckeditor/ckeditor/plugins/div/lang/sr.js', '15.9', 0),
('7ed92d6d6894c9186d5ef97475def266', './vendor/ckeditor/ckeditor/plugins/div/lang/sv.js', '15.9', 0),
('bfe097f4b8cd6bd19b9cdd51f16c7b6c', './vendor/ckeditor/ckeditor/plugins/div/lang/th.js', '15.9', 0),
('1d838033d442223f08f7dcbde4fe12af', './vendor/ckeditor/ckeditor/plugins/div/lang/tr.js', '15.9', 0),
('67bbf088210d34bffbbb476b40be187d', './vendor/ckeditor/ckeditor/plugins/div/lang/tt.js', '15.9', 0),
('2c6b91dc0ed12519429ebdcbeb48cf1c', './vendor/ckeditor/ckeditor/plugins/div/lang/ug.js', '15.9', 0),
('956e0ac3c1e0ab94a1aa865b61eeb100', './vendor/ckeditor/ckeditor/plugins/div/lang/uk.js', '15.9', 0),
('91995daab5235d0f0048a4965075b050', './vendor/ckeditor/ckeditor/plugins/div/lang/vi.js', '15.9', 0),
('8851276c0112c60ebae01fa0558593e4', './vendor/ckeditor/ckeditor/plugins/div/lang/zh-cn.js', '15.9', 0),
('2670ba6bd3870b86e8a0839fea6c519a', './vendor/ckeditor/ckeditor/plugins/div/lang/zh.js', '15.9', 0),
('4cd52afe7a7a1367f86512b56763613e', './vendor/ckeditor/ckeditor/plugins/div/plugin.js', '15.9', 0),
('3f1760603d8242413dadd4965d3d8fb4', './vendor/ckeditor/ckeditor/plugins/divarea/plugin.js', '15.9', 0),
('2c1afb24bdb63697fdb2808f060d7369', './vendor/ckeditor/ckeditor/plugins/docprops/dialogs/docprops.js', '15.9', 0),
('66075a32f31ffebe1e03e395d31f41a7', './vendor/ckeditor/ckeditor/plugins/docprops/lang/af.js', '15.9', 0),
('b80793dafc6c503480c5683ef8a6b5cb', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ar.js', '15.9', 0),
('5919bd52e4975c62c90bde2a5e80f2a5', './vendor/ckeditor/ckeditor/plugins/docprops/lang/bg.js', '15.9', 0),
('eca0cece51e64a51f38e05a34e8ca284', './vendor/ckeditor/ckeditor/plugins/docprops/lang/bn.js', '15.9', 0),
('57d5633ddd38e8551f0ebb4f463d4cec', './vendor/ckeditor/ckeditor/plugins/docprops/lang/bs.js', '15.9', 0),
('cd9eb1f5deaea30a5c73aac31608cd25', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ca.js', '15.9', 0),
('2303e86f0573745c80713db3d2264b50', './vendor/ckeditor/ckeditor/plugins/docprops/lang/cs.js', '15.9', 0),
('6553be1696348a457d115c6c9dbf54e2', './vendor/ckeditor/ckeditor/plugins/docprops/lang/cy.js', '15.9', 0),
('6ce9046844acd2debd37ac85ef24c981', './vendor/ckeditor/ckeditor/plugins/docprops/lang/da.js', '15.9', 0),
('57ebfd3d718d3af56f937f3cd7ec4834', './vendor/ckeditor/ckeditor/plugins/docprops/lang/de.js', '15.9', 0),
('54a4b73e3c021e306962fe5f6ec8a4dd', './vendor/ckeditor/ckeditor/plugins/docprops/lang/el.js', '15.9', 0),
('b4e709c31c1522c92a6ec60b1171fec2', './vendor/ckeditor/ckeditor/plugins/docprops/lang/en-au.js', '15.9', 0),
('b5a6d8b2cb86441ad3ae7f0addf59a03', './vendor/ckeditor/ckeditor/plugins/docprops/lang/en-ca.js', '15.9', 0),
('81826a1976441a5338d601a6c349ce36', './vendor/ckeditor/ckeditor/plugins/docprops/lang/en-gb.js', '15.9', 0),
('26528519aca4c03b08631eed28bb8239', './vendor/ckeditor/ckeditor/plugins/docprops/lang/en.js', '15.9', 0),
('dde5be2719bfa9f6607a8a9869e7f1ae', './vendor/ckeditor/ckeditor/plugins/docprops/lang/eo.js', '15.9', 0),
('47e5c1d10f8a73f1b77f27be48b0ddda', './vendor/ckeditor/ckeditor/plugins/docprops/lang/es.js', '15.9', 0),
('3f546edbc65c403a4ab42af6bfe0441e', './vendor/ckeditor/ckeditor/plugins/docprops/lang/et.js', '15.9', 0),
('07b4dfb70972ebc621a2ee9afd0e67cc', './vendor/ckeditor/ckeditor/plugins/docprops/lang/eu.js', '15.9', 0),
('da48334a6022f4c905b733e8021e64ca', './vendor/ckeditor/ckeditor/plugins/docprops/lang/fa.js', '15.9', 0),
('29df1275cab9a8efde0aefe422c6f972', './vendor/ckeditor/ckeditor/plugins/docprops/lang/fi.js', '15.9', 0),
('b77b55ecd3bf1a02495d54bd9b44a173', './vendor/ckeditor/ckeditor/plugins/docprops/lang/fo.js', '15.9', 0),
('3135a5606ea16a83969521ffd76ec0c2', './vendor/ckeditor/ckeditor/plugins/docprops/lang/fr-ca.js', '15.9', 0),
('7f1514a3a311341413f4e112f0976174', './vendor/ckeditor/ckeditor/plugins/docprops/lang/fr.js', '15.9', 0),
('4266b0bedb90c7e66b4e8b5214de9db3', './vendor/ckeditor/ckeditor/plugins/docprops/lang/gl.js', '15.9', 0),
('1f4a9133a9f2961054830ee7250a8c39', './vendor/ckeditor/ckeditor/plugins/docprops/lang/gu.js', '15.9', 0),
('c9ae8b6ae7dcd957d350b9110afa1852', './vendor/ckeditor/ckeditor/plugins/docprops/lang/he.js', '15.9', 0),
('300c3ae69a7744000614ef60de5f0caf', './vendor/ckeditor/ckeditor/plugins/docprops/lang/hi.js', '15.9', 0),
('8b166e36b0cbf898ca670fbc9fc8daa0', './vendor/ckeditor/ckeditor/plugins/docprops/lang/hr.js', '15.9', 0),
('4d8b35009e11711570e917349841cb2f', './vendor/ckeditor/ckeditor/plugins/docprops/lang/hu.js', '15.9', 0),
('98a4789c3db314f057b3d4f5039cbd60', './vendor/ckeditor/ckeditor/plugins/docprops/lang/id.js', '15.9', 0),
('f5ba781340b09f0c10a9126bb02e9aa6', './vendor/ckeditor/ckeditor/plugins/docprops/lang/is.js', '15.9', 0),
('34a4a23788a09fb2fd49663844bfce59', './vendor/ckeditor/ckeditor/plugins/docprops/lang/it.js', '15.9', 0),
('55f17f13f049bfb77051663b4744297c', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ja.js', '15.9', 0),
('ca91e305f6bc41709ca5a92b261d08b3', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ka.js', '15.9', 0),
('fcfdd304a27cdb3ad39b8c688f90dbc0', './vendor/ckeditor/ckeditor/plugins/docprops/lang/km.js', '15.9', 0),
('b996e2e9f1925f2739f57abd707b614e', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ko.js', '15.9', 0),
('2977e8dea30d9a0c59b45239ea574c0f', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ku.js', '15.9', 0),
('f13f38ad8d7510b0887ff01027684aae', './vendor/ckeditor/ckeditor/plugins/docprops/lang/lt.js', '15.9', 0),
('74b5221f4a9680a1683111519f614d0f', './vendor/ckeditor/ckeditor/plugins/docprops/lang/lv.js', '15.9', 0),
('c3868dfcb5958484c4bab5a1ad2a2a10', './vendor/ckeditor/ckeditor/plugins/docprops/lang/mk.js', '15.9', 0),
('035e5f452d3b7158010b7508ed8cabda', './vendor/ckeditor/ckeditor/plugins/docprops/lang/mn.js', '15.9', 0),
('1b2db07f584cf0808348edf2ecf40295', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ms.js', '15.9', 0),
('f1bccfe1f654c13d14d7531bb520f6dd', './vendor/ckeditor/ckeditor/plugins/docprops/lang/nb.js', '15.9', 0),
('abdbe3b991583e2d76f8282b175a7103', './vendor/ckeditor/ckeditor/plugins/docprops/lang/nl.js', '15.9', 0),
('bd7111d5618cf9fe6e61bf329377c291', './vendor/ckeditor/ckeditor/plugins/docprops/lang/no.js', '15.9', 0),
('79e5bb5fb90bb0d907d26be7d5338cf7', './vendor/ckeditor/ckeditor/plugins/docprops/lang/pl.js', '15.9', 0),
('029cc191119d53ce9c134bb72b7c2c70', './vendor/ckeditor/ckeditor/plugins/docprops/lang/pt-br.js', '15.9', 0),
('8788835c51654d11d9e8ec21ca2c85fe', './vendor/ckeditor/ckeditor/plugins/docprops/lang/pt.js', '15.9', 0),
('f0a0523ff9b080c2365783abe2d58edc', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ro.js', '15.9', 0),
('5ba201ec26703548dadbed2ac53d4c0a', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ru.js', '15.9', 0),
('101f364f21ee40d97d7f45605edd3849', './vendor/ckeditor/ckeditor/plugins/docprops/lang/si.js', '15.9', 0),
('f40c5793c37e095a4461be5a972313cf', './vendor/ckeditor/ckeditor/plugins/docprops/lang/sk.js', '15.9', 0),
('156e592f10a7030990dcbda7905ca28c', './vendor/ckeditor/ckeditor/plugins/docprops/lang/sl.js', '15.9', 0),
('0bf14f1648e7bb32a9bbe9aef34b334e', './vendor/ckeditor/ckeditor/plugins/docprops/lang/sq.js', '15.9', 0),
('abbc342bdaf336cc0f4336e3d02d2094', './vendor/ckeditor/ckeditor/plugins/docprops/lang/sr-latn.js', '15.9', 0),
('63e82828813d1dba2f390f6060488c46', './vendor/ckeditor/ckeditor/plugins/docprops/lang/sr.js', '15.9', 0),
('d9b7444fd20dc5976f3fe638547623f7', './vendor/ckeditor/ckeditor/plugins/docprops/lang/sv.js', '15.9', 0),
('efbfd4a37aff273c47d4a68dab518436', './vendor/ckeditor/ckeditor/plugins/docprops/lang/th.js', '15.9', 0),
('a22bbfcc863247685743d4a0a1b156db', './vendor/ckeditor/ckeditor/plugins/docprops/lang/tr.js', '15.9', 0),
('f60ca235ccef13fb2ee3e56dd5540a11', './vendor/ckeditor/ckeditor/plugins/docprops/lang/tt.js', '15.9', 0),
('dcf6876f8eaa723d1a003e89df4da28c', './vendor/ckeditor/ckeditor/plugins/docprops/lang/ug.js', '15.9', 0),
('80b01512a2a6f4e6164b872aba809c5d', './vendor/ckeditor/ckeditor/plugins/docprops/lang/uk.js', '15.9', 0),
('5e2a4d94d26ea366359b00175b56ec4e', './vendor/ckeditor/ckeditor/plugins/docprops/lang/vi.js', '15.9', 0),
('cf102e5b0c60908544a641d4270593a2', './vendor/ckeditor/ckeditor/plugins/docprops/lang/zh-cn.js', '15.9', 0),
('913f47bccc18d784311a0c3ffbef9575', './vendor/ckeditor/ckeditor/plugins/docprops/lang/zh.js', '15.9', 0),
('d2afa1d109fd7832df839da8e1db1a11', './vendor/ckeditor/ckeditor/plugins/docprops/plugin.js', '15.9', 0),
('d921a7d0d3d648bde410962cdd584882', './vendor/ckeditor/ckeditor/plugins/embed/plugin.js', '15.9', 0),
('b06c483d1800ceae8cbea232d6ab50a2', './vendor/ckeditor/ckeditor/plugins/embedbase/dialogs/embedbase.js', '15.9', 0),
('d6116c9374222ae4090ffdc6c84f002f', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/cs.js', '15.9', 0),
('8a8910f4e19b1e97ad2d5d60dc2a3f8c', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/da.js', '15.9', 0),
('fd68ba1812bebafe7df2525a13b5bcf1', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/de.js', '15.9', 0),
('c49c66238c41217d95e67b2690e93749', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/en.js', '15.9', 0),
('206105a2afca3bbc24558a087db57f49', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/eo.js', '15.9', 0),
('b921229deb479fcacb7d13e55c2ed29c', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/eu.js', '15.9', 0),
('fe7ac82f6094d1997a0363eacbbbff8f', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/fr.js', '15.9', 0),
('36aa24161c455b2b83af2e7cd00263e2', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/gl.js', '15.9', 0),
('4194ff7d9e6a595a26b5ee266caeaa78', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/id.js', '15.9', 0),
('c4a6ae114f8f08f81f939803130c8d21', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/it.js', '15.9', 0),
('01923bab6181a6f2b6482fb34d53ea2f', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/ko.js', '15.9', 0),
('e82b141724878d3344956cf93888529c', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/ku.js', '15.9', 0),
('c9c385ea855de5825b5bd31ac8533cf4', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/nb.js', '15.9', 0),
('da88dd3b0fec6e0ad850a3a3752dbd7e', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/nl.js', '15.9', 0),
('d411696e84f651b6eb133c7a6bb033da', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/pl.js', '15.9', 0),
('803f5beff5538dd3b9ac415ff369c26e', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/pt-br.js', '15.9', 0),
('9ad6bde1054e68de2fe757ce9f4655e6', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/ru.js', '15.9', 0),
('7c9542c91cec87a2db6147be115d2834', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/sv.js', '15.9', 0),
('500341174a058eee611f48b8258604e0', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/tr.js', '15.9', 0),
('3cb1ba6ad06ed95a6634637f175fdca8', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/ug.js', '15.9', 0),
('3e228fb6d5a956bc8b96a4e62bdad3f1', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/uk.js', '15.9', 0),
('ba489c9e4ee0a8bfac35a1bb490789cf', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/zh-cn.js', '15.9', 0),
('af4f96e769577b29a1b06ef8b4ce7158', './vendor/ckeditor/ckeditor/plugins/embedbase/lang/zh.js', '15.9', 0),
('c573161c8a0b6e33d858a860f99b8c44', './vendor/ckeditor/ckeditor/plugins/embedbase/plugin.js', '15.9', 0),
('f790a1dc03675a05752e3935e8af3d6b', './vendor/ckeditor/ckeditor/plugins/embedsemantic/plugin.js', '15.9', 0),
('cca8b9490d374663bfc268d2745048d3', './vendor/ckeditor/ckeditor/plugins/filetools/lang/cs.js', '15.9', 0),
('c7fc5765bc6e9063c6dcbd0d42eb5007', './vendor/ckeditor/ckeditor/plugins/filetools/lang/da.js', '15.9', 0),
('1a28593250e6a157f8a99e0bb691edd2', './vendor/ckeditor/ckeditor/plugins/filetools/lang/de.js', '15.9', 0),
('0db56bca81ade86df80b99910c4f2ebc', './vendor/ckeditor/ckeditor/plugins/filetools/lang/en.js', '15.9', 0),
('80e10ce95867dc7d9c20761d27189872', './vendor/ckeditor/ckeditor/plugins/filetools/lang/eo.js', '15.9', 0),
('09369b4155ed48f6f09496bf673f9d8e', './vendor/ckeditor/ckeditor/plugins/filetools/lang/eu.js', '15.9', 0),
('25cbe913ef9455f9195afd56bf3e1514', './vendor/ckeditor/ckeditor/plugins/filetools/lang/fr.js', '15.9', 0),
('6bf466b784bf22390f05c1c280297186', './vendor/ckeditor/ckeditor/plugins/filetools/lang/gl.js', '15.9', 0),
('34601f2c225969cf257efa7775b92fb6', './vendor/ckeditor/ckeditor/plugins/filetools/lang/id.js', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('3acce8b7b5cb952aa127624dbe6c3621', './vendor/ckeditor/ckeditor/plugins/filetools/lang/it.js', '15.9', 0),
('bbaf4537da00e4dc3971a62cccce4828', './vendor/ckeditor/ckeditor/plugins/filetools/lang/ko.js', '15.9', 0),
('378e1013e321096ade4e81e1537c1299', './vendor/ckeditor/ckeditor/plugins/filetools/lang/ku.js', '15.9', 0),
('63298b369de0a69f4236627bf76b9a70', './vendor/ckeditor/ckeditor/plugins/filetools/lang/nb.js', '15.9', 0),
('67cd3c3b1e550a69aef1a71e7a0599c2', './vendor/ckeditor/ckeditor/plugins/filetools/lang/nl.js', '15.9', 0),
('5abe693c7b3cc6380d71acb2a2ee90a2', './vendor/ckeditor/ckeditor/plugins/filetools/lang/pl.js', '15.9', 0),
('394c5fcaa3dc593b2b8c4f8c5cac4ec0', './vendor/ckeditor/ckeditor/plugins/filetools/lang/pt-br.js', '15.9', 0),
('6b37f0cd8b5abcd1a6afe506c1c4d956', './vendor/ckeditor/ckeditor/plugins/filetools/lang/ru.js', '15.9', 0),
('51e4df2fdb750c4fd7816a30f3201a95', './vendor/ckeditor/ckeditor/plugins/filetools/lang/sv.js', '15.9', 0),
('1db08dff422f12ce3f7561050cb46667', './vendor/ckeditor/ckeditor/plugins/filetools/lang/tr.js', '15.9', 0),
('ee8e77483e11500e5b15057dd047f189', './vendor/ckeditor/ckeditor/plugins/filetools/lang/ug.js', '15.9', 0),
('4b2d13f214b5485365dc7ab4e5ce95d7', './vendor/ckeditor/ckeditor/plugins/filetools/lang/uk.js', '15.9', 0),
('4f2b0338e7d86ea67c65e80dcef4f6a4', './vendor/ckeditor/ckeditor/plugins/filetools/lang/zh-cn.js', '15.9', 0),
('e55384222c3f593550ca7931454bfdf5', './vendor/ckeditor/ckeditor/plugins/filetools/lang/zh.js', '15.9', 0),
('02f1d5ddbc4c8a831807f508d549ec4f', './vendor/ckeditor/ckeditor/plugins/filetools/plugin.js', '15.9', 0),
('ef2aeab0043fb328fb3888ea79e4ee26', './vendor/ckeditor/ckeditor/plugins/find/dialogs/find.js', '15.9', 0),
('3653786700c43febeda2032a83cad8e9', './vendor/ckeditor/ckeditor/plugins/find/lang/af.js', '15.9', 0),
('8e136d3809d432be531f3b8b2efcb378', './vendor/ckeditor/ckeditor/plugins/find/lang/ar.js', '15.9', 0),
('904c3fffad2e29542a656242f57e0514', './vendor/ckeditor/ckeditor/plugins/find/lang/bg.js', '15.9', 0),
('a5e87cbcc78b8cb99629cad968449339', './vendor/ckeditor/ckeditor/plugins/find/lang/bn.js', '15.9', 0),
('f54f86f600eb1fd23f1a3e0d6a2bdec0', './vendor/ckeditor/ckeditor/plugins/find/lang/bs.js', '15.9', 0),
('9a9922099de3cba7f1f988e639525f0c', './vendor/ckeditor/ckeditor/plugins/find/lang/ca.js', '15.9', 0),
('de4bfb4f6d21f3a27edab27b0c197711', './vendor/ckeditor/ckeditor/plugins/find/lang/cs.js', '15.9', 0),
('7a14ddc914bc5867b769c14a52e02ddc', './vendor/ckeditor/ckeditor/plugins/find/lang/cy.js', '15.9', 0),
('6137f7d625db93eaccda00fdb274f8db', './vendor/ckeditor/ckeditor/plugins/find/lang/da.js', '15.9', 0),
('36ce6ab8baff35a504545df483d9dfed', './vendor/ckeditor/ckeditor/plugins/find/lang/de.js', '15.9', 0),
('7ee2dc6210e0fead799933262a07cae7', './vendor/ckeditor/ckeditor/plugins/find/lang/el.js', '15.9', 0),
('0971637abe487a1245578d0d9f0e78b7', './vendor/ckeditor/ckeditor/plugins/find/lang/en-au.js', '15.9', 0),
('b5ac5ee242f3218b7db39f585f19bd97', './vendor/ckeditor/ckeditor/plugins/find/lang/en-ca.js', '15.9', 0),
('0795806ab647f34708d769a5988cfd6b', './vendor/ckeditor/ckeditor/plugins/find/lang/en-gb.js', '15.9', 0),
('ea853e9d38f5e2a9ede98237834d7962', './vendor/ckeditor/ckeditor/plugins/find/lang/en.js', '15.9', 0),
('5b0364d5c01d1b42c5407a67750355c1', './vendor/ckeditor/ckeditor/plugins/find/lang/eo.js', '15.9', 0),
('3c2f7551c90ac40a01ccc3f3d6899ea5', './vendor/ckeditor/ckeditor/plugins/find/lang/es.js', '15.9', 0),
('84719d356ebfbfd536e2438794edc080', './vendor/ckeditor/ckeditor/plugins/find/lang/et.js', '15.9', 0),
('8021261bb3ff024f9d850c087c4924c7', './vendor/ckeditor/ckeditor/plugins/find/lang/eu.js', '15.9', 0),
('3d865bd782335c1839674cdbbea99acd', './vendor/ckeditor/ckeditor/plugins/find/lang/fa.js', '15.9', 0),
('7708a76ea4d26949445ef9168c9922b8', './vendor/ckeditor/ckeditor/plugins/find/lang/fi.js', '15.9', 0),
('c1ff48b75fa7aae400831077dbae18a8', './vendor/ckeditor/ckeditor/plugins/find/lang/fo.js', '15.9', 0),
('e9962c510da8c4e74093094f1b596a3f', './vendor/ckeditor/ckeditor/plugins/find/lang/fr-ca.js', '15.9', 0),
('3059d8b5e9ceec4cc1cf395b27aa205c', './vendor/ckeditor/ckeditor/plugins/find/lang/fr.js', '15.9', 0),
('5256cf816784e8e99cd6258369f9bb6e', './vendor/ckeditor/ckeditor/plugins/find/lang/gl.js', '15.9', 0),
('394e56d6d250f6e28956cf3e719f9892', './vendor/ckeditor/ckeditor/plugins/find/lang/gu.js', '15.9', 0),
('45c6b068d39dcdbbeca83fb64773c0bb', './vendor/ckeditor/ckeditor/plugins/find/lang/he.js', '15.9', 0),
('6a7f9a505f04c786fb1ab9873e232720', './vendor/ckeditor/ckeditor/plugins/find/lang/hi.js', '15.9', 0),
('bcca9393a7eb42d1e6e5aff85736b769', './vendor/ckeditor/ckeditor/plugins/find/lang/hr.js', '15.9', 0),
('636fc05868a40d3fd09489696eb621ba', './vendor/ckeditor/ckeditor/plugins/find/lang/hu.js', '15.9', 0),
('d7b09858b28ba9ce96141f570d1d432c', './vendor/ckeditor/ckeditor/plugins/find/lang/id.js', '15.9', 0),
('2b72b6826587b44cd94fef7e29299f97', './vendor/ckeditor/ckeditor/plugins/find/lang/is.js', '15.9', 0),
('c5cd5d6409f741c6a352e9eeed381acb', './vendor/ckeditor/ckeditor/plugins/find/lang/it.js', '15.9', 0),
('fb9ffdf7db3e03bad1dd87ea73cd1081', './vendor/ckeditor/ckeditor/plugins/find/lang/ja.js', '15.9', 0),
('e6bb994e00a9b29b3294575e04bb948b', './vendor/ckeditor/ckeditor/plugins/find/lang/ka.js', '15.9', 0),
('9703ac92e94ddc1c9b988c4d70b74cf5', './vendor/ckeditor/ckeditor/plugins/find/lang/km.js', '15.9', 0),
('5ca0cd7e24c43f21357b5679d398146a', './vendor/ckeditor/ckeditor/plugins/find/lang/ko.js', '15.9', 0),
('eaa03c44c665929b77aae6a9e94320ec', './vendor/ckeditor/ckeditor/plugins/find/lang/ku.js', '15.9', 0),
('d84d93e3a42163a9294a0e71f8a8c149', './vendor/ckeditor/ckeditor/plugins/find/lang/lt.js', '15.9', 0),
('aad10a91176822d362bcb3b39641ccc2', './vendor/ckeditor/ckeditor/plugins/find/lang/lv.js', '15.9', 0),
('f98c1ad40625a300f88529207ff5633e', './vendor/ckeditor/ckeditor/plugins/find/lang/mk.js', '15.9', 0),
('8a0994f97614b61c13a613a7dd058bbe', './vendor/ckeditor/ckeditor/plugins/find/lang/mn.js', '15.9', 0),
('450849bd8a09f4509bbc0a1aa71f5538', './vendor/ckeditor/ckeditor/plugins/find/lang/ms.js', '15.9', 0),
('83d777ae5b865255e5e32ef4e7d954a5', './vendor/ckeditor/ckeditor/plugins/find/lang/nb.js', '15.9', 0),
('c4e049929ca58685969e6d7a8e65f105', './vendor/ckeditor/ckeditor/plugins/find/lang/nl.js', '15.9', 0),
('a10f9aef7efc4dff7d868544eac8254b', './vendor/ckeditor/ckeditor/plugins/find/lang/no.js', '15.9', 0),
('6b6415b257f2f1c72540bd15d7027483', './vendor/ckeditor/ckeditor/plugins/find/lang/pl.js', '15.9', 0),
('c830850f9b68c432d86f93850326d5d3', './vendor/ckeditor/ckeditor/plugins/find/lang/pt-br.js', '15.9', 0),
('0f3ffa973c084c5595ef5d44dd88305e', './vendor/ckeditor/ckeditor/plugins/find/lang/pt.js', '15.9', 0),
('19b9100df85e929a0102a962ada20731', './vendor/ckeditor/ckeditor/plugins/find/lang/ro.js', '15.9', 0),
('315b92cf08f3377135d9d2afb01d4a68', './vendor/ckeditor/ckeditor/plugins/find/lang/ru.js', '15.9', 0),
('41f23c07c4be679e472870550c8c5a64', './vendor/ckeditor/ckeditor/plugins/find/lang/si.js', '15.9', 0),
('158e7c6e785ce36daab9348b79582486', './vendor/ckeditor/ckeditor/plugins/find/lang/sk.js', '15.9', 0),
('7a7352c3be49a508ddc51c578d05497c', './vendor/ckeditor/ckeditor/plugins/find/lang/sl.js', '15.9', 0),
('b0b98329c1dd19cdf2f036e6817840de', './vendor/ckeditor/ckeditor/plugins/find/lang/sq.js', '15.9', 0),
('b17b9dad1d7ff7625e3cfdbfbbdebddf', './vendor/ckeditor/ckeditor/plugins/find/lang/sr-latn.js', '15.9', 0),
('885a501bd4456ef1f5afd5b7fdb07c80', './vendor/ckeditor/ckeditor/plugins/find/lang/sr.js', '15.9', 0),
('a1c93f8677787777ad391ea0d3554c9f', './vendor/ckeditor/ckeditor/plugins/find/lang/sv.js', '15.9', 0),
('82e0e8bccb0e680c9734f7e4e1fe7954', './vendor/ckeditor/ckeditor/plugins/find/lang/th.js', '15.9', 0),
('5adb282b2b5fff370f36f8a17b8a84d0', './vendor/ckeditor/ckeditor/plugins/find/lang/tr.js', '15.9', 0),
('5e63576b4105be37ee41eb141431d102', './vendor/ckeditor/ckeditor/plugins/find/lang/tt.js', '15.9', 0),
('aa8b0f5a65aa29213fba690bd7dfefa9', './vendor/ckeditor/ckeditor/plugins/find/lang/ug.js', '15.9', 0),
('200d7e87e84fa1ba853aa80f81607cb4', './vendor/ckeditor/ckeditor/plugins/find/lang/uk.js', '15.9', 0),
('7ec8b39d9c7b921696bc6d4328b1ce13', './vendor/ckeditor/ckeditor/plugins/find/lang/vi.js', '15.9', 0),
('f3260446aaaced20dde2ccfbf78cb06d', './vendor/ckeditor/ckeditor/plugins/find/lang/zh-cn.js', '15.9', 0),
('55eabeb382089e1447cea2ad5da08e4b', './vendor/ckeditor/ckeditor/plugins/find/lang/zh.js', '15.9', 0),
('4ac0cbf9fe5c13b662c3d25feb3b3cb2', './vendor/ckeditor/ckeditor/plugins/find/plugin.js', '15.9', 0),
('95e75f7d89b8563110f5516bdc84340c', './vendor/ckeditor/ckeditor/plugins/flash/dialogs/flash.js', '15.9', 0),
('9ef0a88a5580f5da4560d24fe8a7683b', './vendor/ckeditor/ckeditor/plugins/flash/lang/af.js', '15.9', 0),
('608185cbe9f62a4560d9c5fd1ba53500', './vendor/ckeditor/ckeditor/plugins/flash/lang/ar.js', '15.9', 0),
('598403f4d396cdc32a4b36b59c3f4162', './vendor/ckeditor/ckeditor/plugins/flash/lang/bg.js', '15.9', 0),
('3ec7193cd66d9db2ac4cb5779acb2921', './vendor/ckeditor/ckeditor/plugins/flash/lang/bn.js', '15.9', 0),
('2a2dbae75a81a1cf66b5d42cd86c5e87', './vendor/ckeditor/ckeditor/plugins/flash/lang/bs.js', '15.9', 0),
('9757b906466ca583a506f3f2b14fbd9c', './vendor/ckeditor/ckeditor/plugins/flash/lang/ca.js', '15.9', 0),
('3a76440b50f18fe941892b3f8ef2a2cb', './vendor/ckeditor/ckeditor/plugins/flash/lang/cs.js', '15.9', 0),
('5881a40eb4285541416d0d59aa5f8d52', './vendor/ckeditor/ckeditor/plugins/flash/lang/cy.js', '15.9', 0),
('14ac7603539aebe331320904a2b19c95', './vendor/ckeditor/ckeditor/plugins/flash/lang/da.js', '15.9', 0),
('89ff3502bf16408c6afcd68c4b681934', './vendor/ckeditor/ckeditor/plugins/flash/lang/de.js', '15.9', 0),
('9bad974799697fcb4e3a2101430cdae3', './vendor/ckeditor/ckeditor/plugins/flash/lang/el.js', '15.9', 0),
('20b3979a88ceb9501b5b13686abc4b24', './vendor/ckeditor/ckeditor/plugins/flash/lang/en-au.js', '15.9', 0),
('7bdc4008c95f5aa186956d12f60fd95a', './vendor/ckeditor/ckeditor/plugins/flash/lang/en-ca.js', '15.9', 0),
('1ca887007f7f8fd06a5ccce1e659531d', './vendor/ckeditor/ckeditor/plugins/flash/lang/en-gb.js', '15.9', 0),
('476d9cb6023d4e4812de03936c2f9564', './vendor/ckeditor/ckeditor/plugins/flash/lang/en.js', '15.9', 0),
('42a77404218ababeda7d57c7b2347485', './vendor/ckeditor/ckeditor/plugins/flash/lang/eo.js', '15.9', 0),
('b9760cc5f843d2b9c94a593c177f6169', './vendor/ckeditor/ckeditor/plugins/flash/lang/es.js', '15.9', 0),
('d699d91bb566fbbe8461b0db7aa733df', './vendor/ckeditor/ckeditor/plugins/flash/lang/et.js', '15.9', 0),
('e4469329b9b4a00b5bf3ce4057d3aa6b', './vendor/ckeditor/ckeditor/plugins/flash/lang/eu.js', '15.9', 0),
('0669b158c923c20453025fb1025b4ef9', './vendor/ckeditor/ckeditor/plugins/flash/lang/fa.js', '15.9', 0),
('2871b0dbf39df66602489b61c49325ae', './vendor/ckeditor/ckeditor/plugins/flash/lang/fi.js', '15.9', 0),
('d6ebf3ac7763454287982fa3779a74e9', './vendor/ckeditor/ckeditor/plugins/flash/lang/fo.js', '15.9', 0),
('af52a075790728f3908f03f11ca15738', './vendor/ckeditor/ckeditor/plugins/flash/lang/fr-ca.js', '15.9', 0),
('10e1d5ce45ee921ea5e2bb278d953042', './vendor/ckeditor/ckeditor/plugins/flash/lang/fr.js', '15.9', 0),
('3cc8287cedc55f5d7eb93ee9082dc3d2', './vendor/ckeditor/ckeditor/plugins/flash/lang/gl.js', '15.9', 0),
('d345978243a44097f01a713c49c5ba65', './vendor/ckeditor/ckeditor/plugins/flash/lang/gu.js', '15.9', 0),
('839792c44a305fd60e989e8d62f59a42', './vendor/ckeditor/ckeditor/plugins/flash/lang/he.js', '15.9', 0),
('196754726c31b3cacca5efdaeef74ac4', './vendor/ckeditor/ckeditor/plugins/flash/lang/hi.js', '15.9', 0),
('d1199d55f73eb1e13a7fe98d1dbdb3af', './vendor/ckeditor/ckeditor/plugins/flash/lang/hr.js', '15.9', 0),
('d4db9324288aa881df3dd2bfa592d4f1', './vendor/ckeditor/ckeditor/plugins/flash/lang/hu.js', '15.9', 0),
('7b3a1b6a14321cf566a4078527226f8b', './vendor/ckeditor/ckeditor/plugins/flash/lang/id.js', '15.9', 0),
('c861ae8fe528bb98d48790f11ba40469', './vendor/ckeditor/ckeditor/plugins/flash/lang/is.js', '15.9', 0),
('17ff8b59bfa0ccf5aa3cb1d0d0648a78', './vendor/ckeditor/ckeditor/plugins/flash/lang/it.js', '15.9', 0),
('abf4eefd30f7dd5685c49c2365ed3715', './vendor/ckeditor/ckeditor/plugins/flash/lang/ja.js', '15.9', 0),
('9940199e766048f8d12c20a39c4e10ed', './vendor/ckeditor/ckeditor/plugins/flash/lang/ka.js', '15.9', 0),
('c4aea4060b376c4c4dec90a8fe9772d3', './vendor/ckeditor/ckeditor/plugins/flash/lang/km.js', '15.9', 0),
('fec2a052ed232277b1ab075793bf1300', './vendor/ckeditor/ckeditor/plugins/flash/lang/ko.js', '15.9', 0),
('b9a4361e6745239709c8785cefdcaea5', './vendor/ckeditor/ckeditor/plugins/flash/lang/ku.js', '15.9', 0),
('d39fc450097848b742f9241bdc4434fa', './vendor/ckeditor/ckeditor/plugins/flash/lang/lt.js', '15.9', 0),
('6c0f57f66bdbe7dad13e7ec6ff66a836', './vendor/ckeditor/ckeditor/plugins/flash/lang/lv.js', '15.9', 0),
('d8ab86e70c31441b8b70441d45175fb8', './vendor/ckeditor/ckeditor/plugins/flash/lang/mk.js', '15.9', 0),
('3c084dde3fad15f22238ca662fde08a4', './vendor/ckeditor/ckeditor/plugins/flash/lang/mn.js', '15.9', 0),
('ad5a3f6a0cd14560aec1e626ac5e9858', './vendor/ckeditor/ckeditor/plugins/flash/lang/ms.js', '15.9', 0),
('0405e7ad20429583dc3229202cb6cda2', './vendor/ckeditor/ckeditor/plugins/flash/lang/nb.js', '15.9', 0),
('ea49817e3e86a4275a9313a000d70ffd', './vendor/ckeditor/ckeditor/plugins/flash/lang/nl.js', '15.9', 0),
('516e44dbd29a8c965b6330fbf0bd93b9', './vendor/ckeditor/ckeditor/plugins/flash/lang/no.js', '15.9', 0),
('0519f20c58be0720153c75cd81157407', './vendor/ckeditor/ckeditor/plugins/flash/lang/pl.js', '15.9', 0),
('25bb5d47928608d5a7622031b566559b', './vendor/ckeditor/ckeditor/plugins/flash/lang/pt-br.js', '15.9', 0),
('80290353f6dc5b57a33cbe90c4e9134c', './vendor/ckeditor/ckeditor/plugins/flash/lang/pt.js', '15.9', 0),
('916e209e69392455cc14324a76760bba', './vendor/ckeditor/ckeditor/plugins/flash/lang/ro.js', '15.9', 0),
('819829052aad62c8cc71158779910e75', './vendor/ckeditor/ckeditor/plugins/flash/lang/ru.js', '15.9', 0),
('8d792c54e7cdca6e732fdf8bf5c8ca5d', './vendor/ckeditor/ckeditor/plugins/flash/lang/si.js', '15.9', 0),
('340913041d21d1b733584eaa10df4ba1', './vendor/ckeditor/ckeditor/plugins/flash/lang/sk.js', '15.9', 0),
('993db44e56ae9a5d38d84a23fa93bdb1', './vendor/ckeditor/ckeditor/plugins/flash/lang/sl.js', '15.9', 0),
('cd021b3f65619bc4d2ac3efabccc059c', './vendor/ckeditor/ckeditor/plugins/flash/lang/sq.js', '15.9', 0),
('286b2a7bc91872ef75730f8218ad7b77', './vendor/ckeditor/ckeditor/plugins/flash/lang/sr-latn.js', '15.9', 0),
('0d01c1808551245282917ff5f450c616', './vendor/ckeditor/ckeditor/plugins/flash/lang/sr.js', '15.9', 0),
('90676140c981462f4d198a6465e2cb05', './vendor/ckeditor/ckeditor/plugins/flash/lang/sv.js', '15.9', 0),
('8b3e2017fd8467dc406428b6060196e5', './vendor/ckeditor/ckeditor/plugins/flash/lang/th.js', '15.9', 0),
('4aec4e1a0bf34d6cd6093f407132f4f9', './vendor/ckeditor/ckeditor/plugins/flash/lang/tr.js', '15.9', 0),
('fb0d05444e4ede30ba151755cdc33685', './vendor/ckeditor/ckeditor/plugins/flash/lang/tt.js', '15.9', 0),
('0ff6d373240ff097b304ef1fb1119054', './vendor/ckeditor/ckeditor/plugins/flash/lang/ug.js', '15.9', 0),
('d25da2aa8570460a37a2bfeae9223bcc', './vendor/ckeditor/ckeditor/plugins/flash/lang/uk.js', '15.9', 0),
('f298c681632bf4a8d3fbbda43b0627f7', './vendor/ckeditor/ckeditor/plugins/flash/lang/vi.js', '15.9', 0),
('7dd804be9aa0e508db9b0120d96df5a9', './vendor/ckeditor/ckeditor/plugins/flash/lang/zh-cn.js', '15.9', 0),
('e1d8a995f9e7d169b34cf36a0375e386', './vendor/ckeditor/ckeditor/plugins/flash/lang/zh.js', '15.9', 0),
('fc638d7ca66a71a784088f4bed81dccc', './vendor/ckeditor/ckeditor/plugins/flash/plugin.js', '15.9', 0),
('83b7c25a46f7261ae50bbf831f00047b', './vendor/ckeditor/ckeditor/plugins/font/lang/af.js', '15.9', 0),
('abcabd6c8033426112668b27d02bbe55', './vendor/ckeditor/ckeditor/plugins/font/lang/ar.js', '15.9', 0),
('113f6416768bd356edfc92d7f6f93905', './vendor/ckeditor/ckeditor/plugins/font/lang/bg.js', '15.9', 0),
('bd411599607ed3ff04ec5f20d547f3c5', './vendor/ckeditor/ckeditor/plugins/font/lang/bn.js', '15.9', 0),
('67b9b44e96bec0d621dcbaa3d96a4df2', './vendor/ckeditor/ckeditor/plugins/font/lang/bs.js', '15.9', 0),
('42d78e197ed3bb6089c391c13e5a85de', './vendor/ckeditor/ckeditor/plugins/font/lang/ca.js', '15.9', 0),
('5cffd49a88d7a720c8483e9815bdb36d', './vendor/ckeditor/ckeditor/plugins/font/lang/cs.js', '15.9', 0),
('b6556f442be2ff2c3fd290073b912aee', './vendor/ckeditor/ckeditor/plugins/font/lang/cy.js', '15.9', 0),
('c8d042a9fc41d5102a2c926f72475f2c', './vendor/ckeditor/ckeditor/plugins/font/lang/da.js', '15.9', 0),
('a8782c440a3c7ff670c05b011ea4c405', './vendor/ckeditor/ckeditor/plugins/font/lang/de.js', '15.9', 0),
('e50d2e07efd05d6cc4634c5a98285db8', './vendor/ckeditor/ckeditor/plugins/font/lang/el.js', '15.9', 0),
('c7a34e40e3fd16891992e0be91926199', './vendor/ckeditor/ckeditor/plugins/font/lang/en-au.js', '15.9', 0),
('2ffdc80f43c4857d7e383080398c6fd1', './vendor/ckeditor/ckeditor/plugins/font/lang/en-ca.js', '15.9', 0),
('532ff090a1b9a3d7fbe96e60cfa575ed', './vendor/ckeditor/ckeditor/plugins/font/lang/en-gb.js', '15.9', 0),
('e3f7df1b990c4530e480ae74d8f8f666', './vendor/ckeditor/ckeditor/plugins/font/lang/en.js', '15.9', 0),
('f73ad6441bb2ff7eee5b0b2719feebf5', './vendor/ckeditor/ckeditor/plugins/font/lang/eo.js', '15.9', 0),
('a7655a95774062d5f0c5d7cebf466654', './vendor/ckeditor/ckeditor/plugins/font/lang/es.js', '15.9', 0),
('ce1d75044cf3b3d3e19b7ba6c22d66b4', './vendor/ckeditor/ckeditor/plugins/font/lang/et.js', '15.9', 0),
('72c8f43753bd3bbace4f5d6ed35a67a9', './vendor/ckeditor/ckeditor/plugins/font/lang/eu.js', '15.9', 0),
('3f55c81630a8a54cdb9174aba64cbd03', './vendor/ckeditor/ckeditor/plugins/font/lang/fa.js', '15.9', 0),
('fa6f632252765b63d6454f6b51154325', './vendor/ckeditor/ckeditor/plugins/font/lang/fi.js', '15.9', 0),
('bb82a1663ad46395adc88962c38980e5', './vendor/ckeditor/ckeditor/plugins/font/lang/fo.js', '15.9', 0),
('96c1a89dc6655d3861be9023696c817d', './vendor/ckeditor/ckeditor/plugins/font/lang/fr-ca.js', '15.9', 0),
('4371d20c3e559fd2d64190c4e1681d78', './vendor/ckeditor/ckeditor/plugins/font/lang/fr.js', '15.9', 0),
('2b83081d1be5dcf256c3144aabc5db6b', './vendor/ckeditor/ckeditor/plugins/font/lang/gl.js', '15.9', 0),
('f5510d61374d1a37e04bb7243d95560e', './vendor/ckeditor/ckeditor/plugins/font/lang/gu.js', '15.9', 0),
('90e28deefa29ae4aaeb46a9ec7960b6e', './vendor/ckeditor/ckeditor/plugins/font/lang/he.js', '15.9', 0),
('bec1dace53466b9a297a694fc8590cd4', './vendor/ckeditor/ckeditor/plugins/font/lang/hi.js', '15.9', 0),
('159360f35b99ad7dfca91876e95a5d6f', './vendor/ckeditor/ckeditor/plugins/font/lang/hr.js', '15.9', 0),
('966e577c7632e61d0c478adf676e5813', './vendor/ckeditor/ckeditor/plugins/font/lang/hu.js', '15.9', 0),
('ffa9274a95fca4900875a15f198e00e4', './vendor/ckeditor/ckeditor/plugins/font/lang/id.js', '15.9', 0),
('665c2751414e7f1bccfa4229bcaf1caf', './vendor/ckeditor/ckeditor/plugins/font/lang/is.js', '15.9', 0),
('48aa9ecd2f4156a27245096b4c26f62d', './vendor/ckeditor/ckeditor/plugins/font/lang/it.js', '15.9', 0),
('40e084d2a45b997e914387e1d931550f', './vendor/ckeditor/ckeditor/plugins/font/lang/ja.js', '15.9', 0),
('d7a0a50dcc70d3b7a6a5d7d6439cdf4e', './vendor/ckeditor/ckeditor/plugins/font/lang/ka.js', '15.9', 0),
('e0a9fb248deb28f35427a45005c5e0d1', './vendor/ckeditor/ckeditor/plugins/font/lang/km.js', '15.9', 0),
('f4fe6f38cd6eeab3ac8fc8d3bb2f40ab', './vendor/ckeditor/ckeditor/plugins/font/lang/ko.js', '15.9', 0),
('5bd4c6cf0c29785967ebe3c464a38bdd', './vendor/ckeditor/ckeditor/plugins/font/lang/ku.js', '15.9', 0),
('e932145a2f08ab23a4d7c3a22dfed342', './vendor/ckeditor/ckeditor/plugins/font/lang/lt.js', '15.9', 0),
('2e861965c44dbc3c0fdc6ecaef7e2c2f', './vendor/ckeditor/ckeditor/plugins/font/lang/lv.js', '15.9', 0),
('7d08ca6f7c1cc5a4751cd4b6cdf5c38a', './vendor/ckeditor/ckeditor/plugins/font/lang/mk.js', '15.9', 0),
('2a88883a4b3871890033ccf0c7d4e138', './vendor/ckeditor/ckeditor/plugins/font/lang/mn.js', '15.9', 0),
('e193fbb73a0c8856d64e68366b96899d', './vendor/ckeditor/ckeditor/plugins/font/lang/ms.js', '15.9', 0),
('765e1ed6640940e9a8d63e82af02dbb0', './vendor/ckeditor/ckeditor/plugins/font/lang/nb.js', '15.9', 0),
('ad3ef03bc1031ae076c519dcb423aac0', './vendor/ckeditor/ckeditor/plugins/font/lang/nl.js', '15.9', 0),
('64ac4bc434b5bcabb4a88c9a558d73bb', './vendor/ckeditor/ckeditor/plugins/font/lang/no.js', '15.9', 0),
('f5a6821fceca511b0977dd6b7f151698', './vendor/ckeditor/ckeditor/plugins/font/lang/pl.js', '15.9', 0),
('441b01f29651480d86158e2c6d2e38f2', './vendor/ckeditor/ckeditor/plugins/font/lang/pt-br.js', '15.9', 0),
('036b9900b02eb9f7040970d1aa7873c5', './vendor/ckeditor/ckeditor/plugins/font/lang/pt.js', '15.9', 0),
('5ba25a7a2386c711e75d4eb69c19483d', './vendor/ckeditor/ckeditor/plugins/font/lang/ro.js', '15.9', 0),
('6ae6f048622a3a0a4a48f2aec652db46', './vendor/ckeditor/ckeditor/plugins/font/lang/ru.js', '15.9', 0),
('8c5941c5890a402e145a09385928ddfc', './vendor/ckeditor/ckeditor/plugins/font/lang/si.js', '15.9', 0),
('c4f3e33e250b1b912c851b05ae0a80b1', './vendor/ckeditor/ckeditor/plugins/font/lang/sk.js', '15.9', 0),
('09fc69558be4f8f14d481d60a97da37b', './vendor/ckeditor/ckeditor/plugins/font/lang/sl.js', '15.9', 0),
('5b657b1b3c7a9ee82d15385dd416b1aa', './vendor/ckeditor/ckeditor/plugins/font/lang/sq.js', '15.9', 0),
('d341a51cd04eb5ff0d85f08cadbc6b00', './vendor/ckeditor/ckeditor/plugins/font/lang/sr-latn.js', '15.9', 0),
('9ab158ccdd0b1a1b545e85b04b1b43ca', './vendor/ckeditor/ckeditor/plugins/font/lang/sr.js', '15.9', 0),
('e2fc08f8fedc948f4b70a2daa70492ac', './vendor/ckeditor/ckeditor/plugins/font/lang/sv.js', '15.9', 0),
('c4b1dfa6331ee2aa7c6678f9a34d99be', './vendor/ckeditor/ckeditor/plugins/font/lang/th.js', '15.9', 0),
('326dad609efc3fc02376c0876d275260', './vendor/ckeditor/ckeditor/plugins/font/lang/tr.js', '15.9', 0),
('4ef63780caa4d0f5b9dbc97da2b8518d', './vendor/ckeditor/ckeditor/plugins/font/lang/tt.js', '15.9', 0),
('1736041dcc335dbde52e01574d1e5967', './vendor/ckeditor/ckeditor/plugins/font/lang/ug.js', '15.9', 0),
('9d6578c48c68da1558ddaeaca9c60077', './vendor/ckeditor/ckeditor/plugins/font/lang/uk.js', '15.9', 0),
('5f009feb852d91317c6315edc5d3ad10', './vendor/ckeditor/ckeditor/plugins/font/lang/vi.js', '15.9', 0),
('7ab018416d90aa35b5b60d55a7fa7bd1', './vendor/ckeditor/ckeditor/plugins/font/lang/zh-cn.js', '15.9', 0),
('a98f45c35386728d4c97658db67e390f', './vendor/ckeditor/ckeditor/plugins/font/lang/zh.js', '15.9', 0),
('87965a5f67668690139fe00b72586a3d', './vendor/ckeditor/ckeditor/plugins/font/plugin.js', '15.9', 0),
('adf39823f2699c57347be2b89608fcb6', './vendor/ckeditor/ckeditor/plugins/forms/dialogs/button.js', '15.9', 0),
('9c7c15d1811416aa61873fdb5ddb2006', './vendor/ckeditor/ckeditor/plugins/forms/dialogs/checkbox.js', '15.9', 0),
('26c52c4e2f868943b81c3b74aec52276', './vendor/ckeditor/ckeditor/plugins/forms/dialogs/form.js', '15.9', 0),
('356c0df8da4086534437a054eebe3996', './vendor/ckeditor/ckeditor/plugins/forms/dialogs/hiddenfield.js', '15.9', 0),
('efb417c29ce06c72735323c3ca4600e3', './vendor/ckeditor/ckeditor/plugins/forms/dialogs/radio.js', '15.9', 0),
('7e92e849064db65b488699aa53b54f4d', './vendor/ckeditor/ckeditor/plugins/forms/dialogs/select.js', '15.9', 0),
('535d5a70ca03fca0e24084b9bcac2198', './vendor/ckeditor/ckeditor/plugins/forms/dialogs/textarea.js', '15.9', 0),
('dd91f912c5b4950592ef863945d3ecfb', './vendor/ckeditor/ckeditor/plugins/forms/dialogs/textfield.js', '15.9', 0),
('e8979f5584539a20855838d85dd5d003', './vendor/ckeditor/ckeditor/plugins/forms/lang/af.js', '15.9', 0),
('9b4264a51a263dd60a9d992e116ac4b5', './vendor/ckeditor/ckeditor/plugins/forms/lang/ar.js', '15.9', 0),
('80e1d158a97876dde597dada6425b7de', './vendor/ckeditor/ckeditor/plugins/forms/lang/bg.js', '15.9', 0),
('7d6a8d501ed4e2177da97605055b0fd7', './vendor/ckeditor/ckeditor/plugins/forms/lang/bn.js', '15.9', 0),
('85bd5477e5f29d5b3c1ed282a5948b9c', './vendor/ckeditor/ckeditor/plugins/forms/lang/bs.js', '15.9', 0),
('d3bc3b795f85a650b57620435e350dd8', './vendor/ckeditor/ckeditor/plugins/forms/lang/ca.js', '15.9', 0),
('b6e9e97b2d92cb8d26892062fbf10c80', './vendor/ckeditor/ckeditor/plugins/forms/lang/cs.js', '15.9', 0),
('46d1e42576c6c96b8b87090a75ef1f0c', './vendor/ckeditor/ckeditor/plugins/forms/lang/cy.js', '15.9', 0),
('7681cefee34a2ccd069848ec086419f3', './vendor/ckeditor/ckeditor/plugins/forms/lang/da.js', '15.9', 0),
('c159a9db49addb38dd5476bfeef11be8', './vendor/ckeditor/ckeditor/plugins/forms/lang/de.js', '15.9', 0),
('9f0f773ff09cb58f1dc995db66cff420', './vendor/ckeditor/ckeditor/plugins/forms/lang/el.js', '15.9', 0),
('456af978ab7d3bd00afec6fb5111c241', './vendor/ckeditor/ckeditor/plugins/forms/lang/en-au.js', '15.9', 0),
('3aaac7667f3205d5b7e07cc385317cd0', './vendor/ckeditor/ckeditor/plugins/forms/lang/en-ca.js', '15.9', 0),
('31b99dbdf172d8ff73fe5cc13bfa056c', './vendor/ckeditor/ckeditor/plugins/forms/lang/en-gb.js', '15.9', 0),
('5dd4251630444445bf4b200f5073c35a', './vendor/ckeditor/ckeditor/plugins/forms/lang/en.js', '15.9', 0),
('a878bf779b926dde7f7248790572d5ee', './vendor/ckeditor/ckeditor/plugins/forms/lang/eo.js', '15.9', 0),
('e4f5c66f71d0a80749b9a64e026cb890', './vendor/ckeditor/ckeditor/plugins/forms/lang/es.js', '15.9', 0),
('1c6e3558f7ce16e2e93f3e6a2bec55b2', './vendor/ckeditor/ckeditor/plugins/forms/lang/et.js', '15.9', 0),
('84ed7de85e8050050204eca9e2814ee8', './vendor/ckeditor/ckeditor/plugins/forms/lang/eu.js', '15.9', 0),
('564f6cebdeea2a051d8a5d0f8b59a465', './vendor/ckeditor/ckeditor/plugins/forms/lang/fa.js', '15.9', 0),
('9e2d91e4d4544ee85d6ab95ebdbe6378', './vendor/ckeditor/ckeditor/plugins/forms/lang/fi.js', '15.9', 0),
('2b983e120ffc4b47bec51865bc56c9d3', './vendor/ckeditor/ckeditor/plugins/forms/lang/fo.js', '15.9', 0),
('9c1df446342285e378cedc0ef4a67efe', './vendor/ckeditor/ckeditor/plugins/forms/lang/fr-ca.js', '15.9', 0),
('5223892f94bfe6dc600c3f343a4f909e', './vendor/ckeditor/ckeditor/plugins/forms/lang/fr.js', '15.9', 0),
('fc1bb58f5dfb643ce0dec050af85d9d2', './vendor/ckeditor/ckeditor/plugins/forms/lang/gl.js', '15.9', 0),
('0d6a57c6a9b06821f790b7f65ef471f5', './vendor/ckeditor/ckeditor/plugins/forms/lang/gu.js', '15.9', 0),
('cca65faec55d50dc2909d38b3e52e5b9', './vendor/ckeditor/ckeditor/plugins/forms/lang/he.js', '15.9', 0),
('e22b8a55b137b8d4b4b721e5347e7c34', './vendor/ckeditor/ckeditor/plugins/forms/lang/hi.js', '15.9', 0),
('de4fc087280c528a48b2d45e9dd5aa1f', './vendor/ckeditor/ckeditor/plugins/forms/lang/hr.js', '15.9', 0),
('006a8e68781acd2b2e273fdd1eb5aee5', './vendor/ckeditor/ckeditor/plugins/forms/lang/hu.js', '15.9', 0),
('9059d04541910844b7b1babea14d3624', './vendor/ckeditor/ckeditor/plugins/forms/lang/id.js', '15.9', 0),
('a84431abd3575e93160f9e6060289b73', './vendor/ckeditor/ckeditor/plugins/forms/lang/is.js', '15.9', 0),
('11bba8ef678cb7be7f3b201e0fbd8721', './vendor/ckeditor/ckeditor/plugins/forms/lang/it.js', '15.9', 0),
('0fe634a8b689914deb4902ab0397b0bc', './vendor/ckeditor/ckeditor/plugins/forms/lang/ja.js', '15.9', 0),
('4e39d579f51de4e2416972a44a9db22b', './vendor/ckeditor/ckeditor/plugins/forms/lang/ka.js', '15.9', 0),
('bbd6dc39bfc1acb4186c248e3de45430', './vendor/ckeditor/ckeditor/plugins/forms/lang/km.js', '15.9', 0),
('c8e6a3be10954209839fa86db1322d9c', './vendor/ckeditor/ckeditor/plugins/forms/lang/ko.js', '15.9', 0),
('d1d7d6e8c5321c1c95df3ce47d9b9bb7', './vendor/ckeditor/ckeditor/plugins/forms/lang/ku.js', '15.9', 0),
('506fbfd7da254f9a78bd5f80c8c2b58b', './vendor/ckeditor/ckeditor/plugins/forms/lang/lt.js', '15.9', 0),
('59ffc4d571c34c5d4f6376e192b436cc', './vendor/ckeditor/ckeditor/plugins/forms/lang/lv.js', '15.9', 0),
('e5548058e7510e2a14584663f0ee863f', './vendor/ckeditor/ckeditor/plugins/forms/lang/mk.js', '15.9', 0),
('3812ea49b51d2402dc01a66cc62305af', './vendor/ckeditor/ckeditor/plugins/forms/lang/mn.js', '15.9', 0),
('8b87216cac424a97fe925628f2ac26d1', './vendor/ckeditor/ckeditor/plugins/forms/lang/ms.js', '15.9', 0),
('1806fbc33d546789494523fca61d8d20', './vendor/ckeditor/ckeditor/plugins/forms/lang/nb.js', '15.9', 0),
('74621accab817e0b09708175aaa4c7e6', './vendor/ckeditor/ckeditor/plugins/forms/lang/nl.js', '15.9', 0),
('a8289f60f5afe1982421ea7f39f4a428', './vendor/ckeditor/ckeditor/plugins/forms/lang/no.js', '15.9', 0),
('d5e8abaa39e425b5cae7173717a002ee', './vendor/ckeditor/ckeditor/plugins/forms/lang/pl.js', '15.9', 0),
('133215182a7b8ff64ebdc8e335c18448', './vendor/ckeditor/ckeditor/plugins/forms/lang/pt-br.js', '15.9', 0),
('2d6c8ec4423aa4c66526bb5473346b80', './vendor/ckeditor/ckeditor/plugins/forms/lang/pt.js', '15.9', 0),
('fe34da3586457a0b034015a064afe015', './vendor/ckeditor/ckeditor/plugins/forms/lang/ro.js', '15.9', 0),
('50b8bd72a61d4fdb83412a34477cd2e8', './vendor/ckeditor/ckeditor/plugins/forms/lang/ru.js', '15.9', 0),
('afe72ba7da3852392477df53fac92f3f', './vendor/ckeditor/ckeditor/plugins/forms/lang/si.js', '15.9', 0),
('6841c89623022dfe99d7024d9d64b92d', './vendor/ckeditor/ckeditor/plugins/forms/lang/sk.js', '15.9', 0),
('ec4ae2b579259bb19f9a3697ae322f36', './vendor/ckeditor/ckeditor/plugins/forms/lang/sl.js', '15.9', 0),
('6b43a450a7ee0d22530e9adf8fd8ed00', './vendor/ckeditor/ckeditor/plugins/forms/lang/sq.js', '15.9', 0),
('5cae0b83f20d5e3b3ade8d3db27846ac', './vendor/ckeditor/ckeditor/plugins/forms/lang/sr-latn.js', '15.9', 0),
('482089c9e4f88b59192e8692bb9b8d13', './vendor/ckeditor/ckeditor/plugins/forms/lang/sr.js', '15.9', 0),
('02700a7adb6a5f4fbfd32493d55bd129', './vendor/ckeditor/ckeditor/plugins/forms/lang/sv.js', '15.9', 0),
('5d0b28cf0fece640bdfaf687bbd19574', './vendor/ckeditor/ckeditor/plugins/forms/lang/th.js', '15.9', 0),
('31084a08c0c46b30c8d8724161fc78e9', './vendor/ckeditor/ckeditor/plugins/forms/lang/tr.js', '15.9', 0),
('0b2d66487d61e73dcf5af057b2e34acb', './vendor/ckeditor/ckeditor/plugins/forms/lang/tt.js', '15.9', 0),
('329fdf38c1d0fce04f9431a3cd7c7d0b', './vendor/ckeditor/ckeditor/plugins/forms/lang/ug.js', '15.9', 0),
('e454868fc993dd51e7ff890ef70f5c73', './vendor/ckeditor/ckeditor/plugins/forms/lang/uk.js', '15.9', 0),
('a59812c642b7af842cb153f481261f92', './vendor/ckeditor/ckeditor/plugins/forms/lang/vi.js', '15.9', 0),
('4b0ca994368a2db38a51bb4b7694024d', './vendor/ckeditor/ckeditor/plugins/forms/lang/zh-cn.js', '15.9', 0),
('c3b6282f3f16efb364db84ec386c38ec', './vendor/ckeditor/ckeditor/plugins/forms/lang/zh.js', '15.9', 0),
('42c4ad15e80a411829d1e2246a12cb39', './vendor/ckeditor/ckeditor/plugins/forms/plugin.js', '15.9', 0),
('f11adc164a5ca412bec1f318bb561b5c', './vendor/ckeditor/ckeditor/plugins/iframe/dialogs/iframe.js', '15.9', 0),
('da564d3151c1c978e83d0872ef0c1c4f', './vendor/ckeditor/ckeditor/plugins/iframe/lang/af.js', '15.9', 0),
('10b2fa098c0283651705bfc95179303c', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ar.js', '15.9', 0),
('e6547e787e53ef73f8d2129238cca124', './vendor/ckeditor/ckeditor/plugins/iframe/lang/bg.js', '15.9', 0),
('bfbaf4851b4fa7d8f6152a9221490a58', './vendor/ckeditor/ckeditor/plugins/iframe/lang/bn.js', '15.9', 0),
('df1ab6c3aec5ebaf210c437091feb46d', './vendor/ckeditor/ckeditor/plugins/iframe/lang/bs.js', '15.9', 0),
('983d480756c867646dc3f67edf9c29c5', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ca.js', '15.9', 0),
('df7a9c3437c192d9aa48c65a0b1197a0', './vendor/ckeditor/ckeditor/plugins/iframe/lang/cs.js', '15.9', 0),
('f5642e130b580085c905b943553b5cda', './vendor/ckeditor/ckeditor/plugins/iframe/lang/cy.js', '15.9', 0),
('6917e26bb633ea91f6df06d0f4c3b515', './vendor/ckeditor/ckeditor/plugins/iframe/lang/da.js', '15.9', 0),
('4eb7ba3b79a2625d82f4e8de1356b24f', './vendor/ckeditor/ckeditor/plugins/iframe/lang/de.js', '15.9', 0),
('38c0f1367afe27bf9614887742402180', './vendor/ckeditor/ckeditor/plugins/iframe/lang/el.js', '15.9', 0),
('71a334f7dc6d32aa6c8997aca8d8a485', './vendor/ckeditor/ckeditor/plugins/iframe/lang/en-au.js', '15.9', 0),
('eb399405999014b9c58c5bb84b6b69c7', './vendor/ckeditor/ckeditor/plugins/iframe/lang/en-ca.js', '15.9', 0),
('6faafd1432b50732d4af3bc32cdcd4b4', './vendor/ckeditor/ckeditor/plugins/iframe/lang/en-gb.js', '15.9', 0),
('4dd11550affc598199e0f12a5a26c248', './vendor/ckeditor/ckeditor/plugins/iframe/lang/en.js', '15.9', 0),
('05d817a6ddf1e3d06b314e79cc31a2c9', './vendor/ckeditor/ckeditor/plugins/iframe/lang/eo.js', '15.9', 0),
('f4c18277eaf301f1798db1dc0eda3f50', './vendor/ckeditor/ckeditor/plugins/iframe/lang/es.js', '15.9', 0),
('0f21e21f70d19f1c19ad02db46f485fe', './vendor/ckeditor/ckeditor/plugins/iframe/lang/et.js', '15.9', 0),
('54a8b34e3a5f9725635a376a27fd6a97', './vendor/ckeditor/ckeditor/plugins/iframe/lang/eu.js', '15.9', 0),
('cbc03b78d3f3b63be6203069d4af9832', './vendor/ckeditor/ckeditor/plugins/iframe/lang/fa.js', '15.9', 0),
('8817efed7a930edde93be29d967702a4', './vendor/ckeditor/ckeditor/plugins/iframe/lang/fi.js', '15.9', 0),
('a20d3f78c94f103615e6658b82c83b54', './vendor/ckeditor/ckeditor/plugins/iframe/lang/fo.js', '15.9', 0),
('80f25bd4b90d6630d8f887cf634b9a4b', './vendor/ckeditor/ckeditor/plugins/iframe/lang/fr-ca.js', '15.9', 0),
('25d61cb5e574bd0291ad4aa428a237ec', './vendor/ckeditor/ckeditor/plugins/iframe/lang/fr.js', '15.9', 0),
('a2ca38260a7ce42980662e7a53bfd1ce', './vendor/ckeditor/ckeditor/plugins/iframe/lang/gl.js', '15.9', 0),
('e6d69d312a96eea96edad6fdfccb0b1f', './vendor/ckeditor/ckeditor/plugins/iframe/lang/gu.js', '15.9', 0),
('26491c48b63748a9744789810cf88ec4', './vendor/ckeditor/ckeditor/plugins/iframe/lang/he.js', '15.9', 0),
('1dea7edc29534898bbd7c15d293e10ce', './vendor/ckeditor/ckeditor/plugins/iframe/lang/hi.js', '15.9', 0),
('b062cb50aef65e178596dfeafdc029bd', './vendor/ckeditor/ckeditor/plugins/iframe/lang/hr.js', '15.9', 0),
('65e6290c846b910d58d475711c840f0d', './vendor/ckeditor/ckeditor/plugins/iframe/lang/hu.js', '15.9', 0),
('6dc91f821a96c5c316e23437ec1fa9f8', './vendor/ckeditor/ckeditor/plugins/iframe/lang/id.js', '15.9', 0),
('d08c2eef4d8b57cc1d6b4eec838f84d7', './vendor/ckeditor/ckeditor/plugins/iframe/lang/is.js', '15.9', 0),
('2221bc692a8f4379da94c15ee89a1ecd', './vendor/ckeditor/ckeditor/plugins/iframe/lang/it.js', '15.9', 0),
('b492b51a5fc320eecd08deeb55d2a919', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ja.js', '15.9', 0),
('592379f6795ad95f02f20f8e04e8a2bf', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ka.js', '15.9', 0),
('64418480740c2c5e87ad8e03266577a0', './vendor/ckeditor/ckeditor/plugins/iframe/lang/km.js', '15.9', 0),
('93d431109beb8c298dd40721d716a9c6', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ko.js', '15.9', 0),
('24a9a1d2ca3da98718647428736873c2', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ku.js', '15.9', 0),
('a1f061218f2057f745e6a4782ec383c5', './vendor/ckeditor/ckeditor/plugins/iframe/lang/lt.js', '15.9', 0),
('5898103daede720ce157c890709fd56b', './vendor/ckeditor/ckeditor/plugins/iframe/lang/lv.js', '15.9', 0),
('b62537f679974ee029d90352f42c157a', './vendor/ckeditor/ckeditor/plugins/iframe/lang/mk.js', '15.9', 0),
('e3a9935c8573c77e504cc279b7114186', './vendor/ckeditor/ckeditor/plugins/iframe/lang/mn.js', '15.9', 0),
('4debc13ccc701b1d507d87e67778061c', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ms.js', '15.9', 0),
('de9ff96ffdf23f6d1a35d822d57bc00a', './vendor/ckeditor/ckeditor/plugins/iframe/lang/nb.js', '15.9', 0),
('b75356c3e263c0fc35bddc7956dc4852', './vendor/ckeditor/ckeditor/plugins/iframe/lang/nl.js', '15.9', 0),
('313cb9c5f7d2821e4e95834b586bb8e4', './vendor/ckeditor/ckeditor/plugins/iframe/lang/no.js', '15.9', 0),
('15f61cf765c2359b78e9d2029f544c62', './vendor/ckeditor/ckeditor/plugins/iframe/lang/pl.js', '15.9', 0),
('fc2932bc7cc0a4ae39fb257e7d7bd32b', './vendor/ckeditor/ckeditor/plugins/iframe/lang/pt-br.js', '15.9', 0),
('ef73ffca7deb79294b4c78550d9bc53d', './vendor/ckeditor/ckeditor/plugins/iframe/lang/pt.js', '15.9', 0),
('927ee57125db8415f2fde340f1029851', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ro.js', '15.9', 0),
('8ff63e83a881ed5654833445c0dae730', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ru.js', '15.9', 0),
('b046a02e1a183eba257a9f5be575c7e4', './vendor/ckeditor/ckeditor/plugins/iframe/lang/si.js', '15.9', 0),
('29f70f98cee3c2613b8fa9827a42ddba', './vendor/ckeditor/ckeditor/plugins/iframe/lang/sk.js', '15.9', 0),
('69f9ec667095af76fcb111467696f64d', './vendor/ckeditor/ckeditor/plugins/iframe/lang/sl.js', '15.9', 0),
('f8a7dcfcf76c842e161dbe3d9b597ae7', './vendor/ckeditor/ckeditor/plugins/iframe/lang/sq.js', '15.9', 0),
('0a44c89fdbee5aa507c84e92c91ab0d8', './vendor/ckeditor/ckeditor/plugins/iframe/lang/sr-latn.js', '15.9', 0),
('91722d3fc5a8b9c37b901c6aba265cf6', './vendor/ckeditor/ckeditor/plugins/iframe/lang/sr.js', '15.9', 0),
('4abfe7cd2f4f3674a64efd7d8060b624', './vendor/ckeditor/ckeditor/plugins/iframe/lang/sv.js', '15.9', 0),
('26f5043bd01c33cadee4a9ae6e52f6a0', './vendor/ckeditor/ckeditor/plugins/iframe/lang/th.js', '15.9', 0),
('9ecf97ad61b468ab82c2abd1bbbe8494', './vendor/ckeditor/ckeditor/plugins/iframe/lang/tr.js', '15.9', 0),
('fb4df978d1e7e33dcae06197376ce2fa', './vendor/ckeditor/ckeditor/plugins/iframe/lang/tt.js', '15.9', 0),
('c1c39a9107cd377802c4fc28c96800d9', './vendor/ckeditor/ckeditor/plugins/iframe/lang/ug.js', '15.9', 0),
('0ebb1ecb282e56a49150c728fe34a221', './vendor/ckeditor/ckeditor/plugins/iframe/lang/uk.js', '15.9', 0),
('7a0e61cc800fec1b6fceec7f5efe1f13', './vendor/ckeditor/ckeditor/plugins/iframe/lang/vi.js', '15.9', 0),
('e82a8616b037ac516a4a9a61d4e3bc3d', './vendor/ckeditor/ckeditor/plugins/iframe/lang/zh-cn.js', '15.9', 0),
('9e7317656c3e6e65d9ffddd463ecbbf0', './vendor/ckeditor/ckeditor/plugins/iframe/lang/zh.js', '15.9', 0),
('791bcf7d092d1482ee3f02c1670ffc59', './vendor/ckeditor/ckeditor/plugins/iframe/plugin.js', '15.9', 0),
('bb818f465d3a0a537a32fc2102356eb3', './vendor/ckeditor/ckeditor/plugins/iframedialog/plugin.js', '15.9', 0),
('2d086c2d8cb937a58ddd24d2215f76ae', './vendor/ckeditor/ckeditor/plugins/image/dialogs/image.js', '15.9', 0),
('499dbcb8ad27262d0719f46f7a94f93a', './vendor/ckeditor/ckeditor/plugins/image2/dialogs/image2.js', '15.9', 0),
('380748549076da06e77ece7040e78c47', './vendor/ckeditor/ckeditor/plugins/image2/lang/af.js', '15.9', 0),
('1d4de7cf8f2f828c692176f25a121b23', './vendor/ckeditor/ckeditor/plugins/image2/lang/ar.js', '15.9', 0),
('e62f726e9cab9a11e4aff17cac9b2161', './vendor/ckeditor/ckeditor/plugins/image2/lang/bg.js', '15.9', 0),
('c437250a2ebca7506ffc3d756aa6c362', './vendor/ckeditor/ckeditor/plugins/image2/lang/bn.js', '15.9', 0),
('297f3080ca2111d37e0f9c9d6e6a8164', './vendor/ckeditor/ckeditor/plugins/image2/lang/bs.js', '15.9', 0),
('f15ca425350568df6503aafb846ba767', './vendor/ckeditor/ckeditor/plugins/image2/lang/ca.js', '15.9', 0),
('eea223acacb20c6835f00ccece04edc6', './vendor/ckeditor/ckeditor/plugins/image2/lang/cs.js', '15.9', 0),
('27f1e5e85a326564fe79c65cfc9d450d', './vendor/ckeditor/ckeditor/plugins/image2/lang/cy.js', '15.9', 0),
('67a282c0c47efa148323740be58c7bdd', './vendor/ckeditor/ckeditor/plugins/image2/lang/da.js', '15.9', 0),
('be7aa76522929bdaa6f339b07b73f32a', './vendor/ckeditor/ckeditor/plugins/image2/lang/de.js', '15.9', 0),
('316e6ba258beafe57186e9ac71ecd6b0', './vendor/ckeditor/ckeditor/plugins/image2/lang/el.js', '15.9', 0),
('1de322df6a2bb8376785d39d7ba568d0', './vendor/ckeditor/ckeditor/plugins/image2/lang/en-au.js', '15.9', 0),
('77baca0674ddf59c27eb27daac240f63', './vendor/ckeditor/ckeditor/plugins/image2/lang/en-ca.js', '15.9', 0),
('106a4c9012d3eecfa499a5eda9168b35', './vendor/ckeditor/ckeditor/plugins/image2/lang/en-gb.js', '15.9', 0),
('c0d2ab073651c5fa9d942cbbbc1da48c', './vendor/ckeditor/ckeditor/plugins/image2/lang/en.js', '15.9', 0),
('fe63bb5128866839dfb61b2ad02952ae', './vendor/ckeditor/ckeditor/plugins/image2/lang/eo.js', '15.9', 0),
('d9a347f67a8db92e8b1e18cb6e963aaa', './vendor/ckeditor/ckeditor/plugins/image2/lang/es.js', '15.9', 0),
('20fd09a7e7021bbc78dbbcfff8476a5b', './vendor/ckeditor/ckeditor/plugins/image2/lang/et.js', '15.9', 0),
('65ff1e095a81c223a148d53876c75468', './vendor/ckeditor/ckeditor/plugins/image2/lang/eu.js', '15.9', 0),
('95f31773d155ae1d7c1f26edd5b3f77e', './vendor/ckeditor/ckeditor/plugins/image2/lang/fa.js', '15.9', 0),
('f6e5bb167b7c5e4196206d1a7812114c', './vendor/ckeditor/ckeditor/plugins/image2/lang/fi.js', '15.9', 0),
('9958d528db7d38e383b766ed0b8992c4', './vendor/ckeditor/ckeditor/plugins/image2/lang/fo.js', '15.9', 0),
('31a334809cdd80aa2fde3d7f10236563', './vendor/ckeditor/ckeditor/plugins/image2/lang/fr-ca.js', '15.9', 0),
('9da8d7f05718e8c44e8f4912f64e9f7b', './vendor/ckeditor/ckeditor/plugins/image2/lang/fr.js', '15.9', 0),
('e09ba8b5777353aa7d53b03f628d6217', './vendor/ckeditor/ckeditor/plugins/image2/lang/gl.js', '15.9', 0),
('97d8905bc579074a9c79eee3def88bfa', './vendor/ckeditor/ckeditor/plugins/image2/lang/gu.js', '15.9', 0),
('68bba57bb3f0af6202a249559186ec09', './vendor/ckeditor/ckeditor/plugins/image2/lang/he.js', '15.9', 0),
('38456098f17369da6a0a60f645180dc0', './vendor/ckeditor/ckeditor/plugins/image2/lang/hi.js', '15.9', 0),
('0d37b2dc618ff5ab2a6db822df052cb9', './vendor/ckeditor/ckeditor/plugins/image2/lang/hr.js', '15.9', 0),
('a02e4a2445e79e591cb5bbd0d04ea541', './vendor/ckeditor/ckeditor/plugins/image2/lang/hu.js', '15.9', 0),
('ac82f352dfcaf2830c20d32deeeb1f93', './vendor/ckeditor/ckeditor/plugins/image2/lang/id.js', '15.9', 0),
('c672e97852ebca07b7529b3b65df9f4b', './vendor/ckeditor/ckeditor/plugins/image2/lang/is.js', '15.9', 0),
('f4e9643912d99767bf1da631d12b5d60', './vendor/ckeditor/ckeditor/plugins/image2/lang/it.js', '15.9', 0),
('7ff85fd6cdeb4134d963ae1c8afd3dc7', './vendor/ckeditor/ckeditor/plugins/image2/lang/ja.js', '15.9', 0),
('c435f800dc6a45aca8b6406b358399e4', './vendor/ckeditor/ckeditor/plugins/image2/lang/ka.js', '15.9', 0),
('1f5af5d6760f3820c30e7acd3b897c2c', './vendor/ckeditor/ckeditor/plugins/image2/lang/km.js', '15.9', 0),
('ce4dd9229afc5b77f9dab4116068b852', './vendor/ckeditor/ckeditor/plugins/image2/lang/ko.js', '15.9', 0),
('ee7a8eb00063bc9cf89172767a462e68', './vendor/ckeditor/ckeditor/plugins/image2/lang/ku.js', '15.9', 0),
('4e16f3b3b358fe55881dad7e87bcda9b', './vendor/ckeditor/ckeditor/plugins/image2/lang/lt.js', '15.9', 0),
('5d7e689e691cc6fb1a00dbd930a419a3', './vendor/ckeditor/ckeditor/plugins/image2/lang/lv.js', '15.9', 0),
('c50f8da81d63355bf7c80ece8bea213d', './vendor/ckeditor/ckeditor/plugins/image2/lang/mk.js', '15.9', 0),
('6926f6c546d465c1b2925fbc3f4a91ae', './vendor/ckeditor/ckeditor/plugins/image2/lang/mn.js', '15.9', 0),
('c849d8cf3a4959239074b95c5150a2aa', './vendor/ckeditor/ckeditor/plugins/image2/lang/ms.js', '15.9', 0),
('8062665e230052c3e8e1c1a69a685a2a', './vendor/ckeditor/ckeditor/plugins/image2/lang/nb.js', '15.9', 0),
('d34c14f1e23b256f669ea1e10da08be3', './vendor/ckeditor/ckeditor/plugins/image2/lang/nl.js', '15.9', 0),
('0ae32fc172a3cae39d0421deb80431f4', './vendor/ckeditor/ckeditor/plugins/image2/lang/no.js', '15.9', 0),
('d9bf42d77f69f0ced1680067430b4f3f', './vendor/ckeditor/ckeditor/plugins/image2/lang/pl.js', '15.9', 0),
('f6d4fa1256218b0faeca6ad5f5e4e396', './vendor/ckeditor/ckeditor/plugins/image2/lang/pt-br.js', '15.9', 0),
('98c5d0fc8cb15033964789dc26c58f89', './vendor/ckeditor/ckeditor/plugins/image2/lang/pt.js', '15.9', 0),
('52eb4b395c905b7f28d33cf496be61f6', './vendor/ckeditor/ckeditor/plugins/image2/lang/ro.js', '15.9', 0),
('3c14a9a0dd77bdfe78eb8e6b8a15b692', './vendor/ckeditor/ckeditor/plugins/image2/lang/ru.js', '15.9', 0),
('83480dd8a9ed9d660df6b289338ecb8e', './vendor/ckeditor/ckeditor/plugins/image2/lang/si.js', '15.9', 0),
('cdf2e1ca485274e68007ca0ec14605f9', './vendor/ckeditor/ckeditor/plugins/image2/lang/sk.js', '15.9', 0),
('73348da49adcacbeb15ad13292078b29', './vendor/ckeditor/ckeditor/plugins/image2/lang/sl.js', '15.9', 0),
('d522d1076b4b9f383bccb799f9e1ac33', './vendor/ckeditor/ckeditor/plugins/image2/lang/sq.js', '15.9', 0),
('3b9adc0510e2f03641582b3c9115f297', './vendor/ckeditor/ckeditor/plugins/image2/lang/sr-latn.js', '15.9', 0),
('e4489aa88abd029cf95c574f225ff578', './vendor/ckeditor/ckeditor/plugins/image2/lang/sr.js', '15.9', 0),
('cd6dd1e6635924222c5689deca519d54', './vendor/ckeditor/ckeditor/plugins/image2/lang/sv.js', '15.9', 0),
('f8a3911c25759b1c272fd95d1cadd8b3', './vendor/ckeditor/ckeditor/plugins/image2/lang/th.js', '15.9', 0),
('f712dea590079deb5f1d01a192269b2d', './vendor/ckeditor/ckeditor/plugins/image2/lang/tr.js', '15.9', 0),
('c6a3cc6a61478bf05e8592127bf01cdd', './vendor/ckeditor/ckeditor/plugins/image2/lang/tt.js', '15.9', 0),
('9996bc3d3a44f9ddb5b1ddc3ce1d0305', './vendor/ckeditor/ckeditor/plugins/image2/lang/ug.js', '15.9', 0),
('69b91a025cd86fb003aaeea37fafa2e6', './vendor/ckeditor/ckeditor/plugins/image2/lang/uk.js', '15.9', 0),
('6c79e9b81fa8b61b28f9fffba978ae38', './vendor/ckeditor/ckeditor/plugins/image2/lang/vi.js', '15.9', 0),
('8d0148ce3d423f28acb2f235ee9ea5fd', './vendor/ckeditor/ckeditor/plugins/image2/lang/zh-cn.js', '15.9', 0),
('352d773815cc23cbea28066aa24799c1', './vendor/ckeditor/ckeditor/plugins/image2/lang/zh.js', '15.9', 0),
('bed7b722a22a0a78eadf65fc9ca3858c', './vendor/ckeditor/ckeditor/plugins/image2/plugin.js', '15.9', 0),
('73e5f228da93b67324f45cb4f1cc2a94', './vendor/ckeditor/ckeditor/plugins/indentblock/plugin.js', '15.9', 0),
('11879a12cf412e39170605964f3e81b5', './vendor/ckeditor/ckeditor/plugins/justify/lang/af.js', '15.9', 0),
('4461022a383e11ac573f79148d2231c4', './vendor/ckeditor/ckeditor/plugins/justify/lang/ar.js', '15.9', 0),
('c668bd66146c78557a14ed70c6512167', './vendor/ckeditor/ckeditor/plugins/justify/lang/bg.js', '15.9', 0),
('e92b9c40b3472289ea2acdaf76532c78', './vendor/ckeditor/ckeditor/plugins/justify/lang/bn.js', '15.9', 0),
('8ea3752a232fd45729ddcb9e7d22a496', './vendor/ckeditor/ckeditor/plugins/justify/lang/bs.js', '15.9', 0),
('e40e44d5cb03372f3c003bab397b87a4', './vendor/ckeditor/ckeditor/plugins/justify/lang/ca.js', '15.9', 0),
('8e36d27a8ffdd858cf01296e0a0d2fa2', './vendor/ckeditor/ckeditor/plugins/justify/lang/cs.js', '15.9', 0),
('680031e3e921f32ce7d9263fcfb7530d', './vendor/ckeditor/ckeditor/plugins/justify/lang/cy.js', '15.9', 0),
('495359e1bc8d2654f586d1e23f4fe9a2', './vendor/ckeditor/ckeditor/plugins/justify/lang/da.js', '15.9', 0),
('6d219da13a13d0404d6a25c7c165c4b3', './vendor/ckeditor/ckeditor/plugins/justify/lang/de.js', '15.9', 0),
('54a82c4f5a7d72e105b6e73db013e6c5', './vendor/ckeditor/ckeditor/plugins/justify/lang/el.js', '15.9', 0),
('88c25fb062649b289fb8bff6b3d8e503', './vendor/ckeditor/ckeditor/plugins/justify/lang/en-au.js', '15.9', 0),
('762f2b2a1c03274176824e03c1642f50', './vendor/ckeditor/ckeditor/plugins/justify/lang/en-ca.js', '15.9', 0),
('eddbc026219243a0d359c6aa32391ff5', './vendor/ckeditor/ckeditor/plugins/justify/lang/en-gb.js', '15.9', 0),
('94115ff74544cd6320f07693d67e48ae', './vendor/ckeditor/ckeditor/plugins/justify/lang/en.js', '15.9', 0),
('021a3a318b381fa7e6c6aca62942f253', './vendor/ckeditor/ckeditor/plugins/justify/lang/eo.js', '15.9', 0),
('eca80f538c4f8dd10ffaeb10f2f64181', './vendor/ckeditor/ckeditor/plugins/justify/lang/es.js', '15.9', 0),
('d92456aa4d9af7bb233ef8854b1838f2', './vendor/ckeditor/ckeditor/plugins/justify/lang/et.js', '15.9', 0),
('476c35cce1a822b478a3ee49ab13fbc5', './vendor/ckeditor/ckeditor/plugins/justify/lang/eu.js', '15.9', 0),
('a1c7fa3aca7819ec708790d2b74ca26f', './vendor/ckeditor/ckeditor/plugins/justify/lang/fa.js', '15.9', 0),
('3b6fa9bb46d07824617dd941c7df90ee', './vendor/ckeditor/ckeditor/plugins/justify/lang/fi.js', '15.9', 0),
('6315042cb5ec606a120dba79b1a1d9b2', './vendor/ckeditor/ckeditor/plugins/justify/lang/fo.js', '15.9', 0),
('62982b95eb8dcce7da0234ef3e572273', './vendor/ckeditor/ckeditor/plugins/justify/lang/fr-ca.js', '15.9', 0),
('096cefb04e4d169b6c2b4df767cdc7fe', './vendor/ckeditor/ckeditor/plugins/justify/lang/fr.js', '15.9', 0),
('44ed5803664be9c8be9bf6f8b8e973d9', './vendor/ckeditor/ckeditor/plugins/justify/lang/gl.js', '15.9', 0),
('2a600a09654b6f790a6786df2eb44507', './vendor/ckeditor/ckeditor/plugins/justify/lang/gu.js', '15.9', 0),
('53cbac53492e14a2a22ad76f7934e747', './vendor/ckeditor/ckeditor/plugins/justify/lang/he.js', '15.9', 0),
('c942e5c730b633ef25f0ec1c81b300c0', './vendor/ckeditor/ckeditor/plugins/justify/lang/hi.js', '15.9', 0),
('43bda492ccf27edad2d5b3b8914c936a', './vendor/ckeditor/ckeditor/plugins/justify/lang/hr.js', '15.9', 0),
('25af8d948b5f17a2f9ae579d004c9c50', './vendor/ckeditor/ckeditor/plugins/justify/lang/hu.js', '15.9', 0),
('2860946a65af7d0339a2bc6f2fa5bd67', './vendor/ckeditor/ckeditor/plugins/justify/lang/id.js', '15.9', 0),
('b2b2fe5da0b8bddd89df0869660928e0', './vendor/ckeditor/ckeditor/plugins/justify/lang/is.js', '15.9', 0),
('48fca05c8fea13b96c78e552b98a4f22', './vendor/ckeditor/ckeditor/plugins/justify/lang/it.js', '15.9', 0),
('35512288993725a4480d2bd97c3482d1', './vendor/ckeditor/ckeditor/plugins/justify/lang/ja.js', '15.9', 0),
('8668e69186b1cddbb1b7fd90bb8efb3f', './vendor/ckeditor/ckeditor/plugins/justify/lang/ka.js', '15.9', 0),
('d3438418d55ca2e4fa947f4c39a10d06', './vendor/ckeditor/ckeditor/plugins/justify/lang/km.js', '15.9', 0),
('e9236a693f14fea57410fc9b7eff5c8f', './vendor/ckeditor/ckeditor/plugins/justify/lang/ko.js', '15.9', 0),
('2dee9082d70b11899a1a0636e34e9972', './vendor/ckeditor/ckeditor/plugins/justify/lang/ku.js', '15.9', 0),
('476136bd356cde4f0e5f1a7e9581c857', './vendor/ckeditor/ckeditor/plugins/justify/lang/lt.js', '15.9', 0),
('6995a70b5877ae771bba43b29fe5a639', './vendor/ckeditor/ckeditor/plugins/justify/lang/lv.js', '15.9', 0),
('6943baba6e0550985755c966ae1347a7', './vendor/ckeditor/ckeditor/plugins/justify/lang/mk.js', '15.9', 0),
('1151f70cf7b5b263f47789ec300d2bf1', './vendor/ckeditor/ckeditor/plugins/justify/lang/mn.js', '15.9', 0),
('570623f70156c4c81795abcddbe7611f', './vendor/ckeditor/ckeditor/plugins/justify/lang/ms.js', '15.9', 0),
('ac81bd0a4b32b46b5e832f07530a32ed', './vendor/ckeditor/ckeditor/plugins/justify/lang/nb.js', '15.9', 0),
('e15e01a300b52b987ac9567a4c79f96a', './vendor/ckeditor/ckeditor/plugins/justify/lang/nl.js', '15.9', 0),
('28be5d56d761117a907237c04378a3c4', './vendor/ckeditor/ckeditor/plugins/justify/lang/no.js', '15.9', 0),
('d3a34754925f7fa2176ce6401ab91b13', './vendor/ckeditor/ckeditor/plugins/justify/lang/pl.js', '15.9', 0),
('e2e07f4500fc4949153ab4e69cbbf8d4', './vendor/ckeditor/ckeditor/plugins/justify/lang/pt-br.js', '15.9', 0),
('9b16293cb24887b8607139380871eff2', './vendor/ckeditor/ckeditor/plugins/justify/lang/pt.js', '15.9', 0),
('0aa675ab0050dc73fbe6d98abb2c2011', './vendor/ckeditor/ckeditor/plugins/justify/lang/ro.js', '15.9', 0),
('627a446647e873112116859adbc34214', './vendor/ckeditor/ckeditor/plugins/justify/lang/ru.js', '15.9', 0),
('c36323fa5c5d9b786013cc98ea6d9ec7', './vendor/ckeditor/ckeditor/plugins/justify/lang/si.js', '15.9', 0),
('4b50f020d2d9167b9ec6103e549b8da9', './vendor/ckeditor/ckeditor/plugins/justify/lang/sk.js', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('9407ea357f36261778eb9876d7570b49', './vendor/ckeditor/ckeditor/plugins/justify/lang/sl.js', '15.9', 0),
('ad114ded453e3944f8c842dae287a0ae', './vendor/ckeditor/ckeditor/plugins/justify/lang/sq.js', '15.9', 0),
('8760bd3c945940d1eeb52cb6e5c44245', './vendor/ckeditor/ckeditor/plugins/justify/lang/sr-latn.js', '15.9', 0),
('e5360027abcf7b74e157d3351b766c37', './vendor/ckeditor/ckeditor/plugins/justify/lang/sr.js', '15.9', 0),
('b6808b5ed2b52d2f2ac5b66fb67e971f', './vendor/ckeditor/ckeditor/plugins/justify/lang/sv.js', '15.9', 0),
('661b567b2f59e6d1adf24fa887786901', './vendor/ckeditor/ckeditor/plugins/justify/lang/th.js', '15.9', 0),
('0d3d3a2ab7bc72d24a4020b260a937d5', './vendor/ckeditor/ckeditor/plugins/justify/lang/tr.js', '15.9', 0),
('5180dbb25176ee731f87d31e384bfae3', './vendor/ckeditor/ckeditor/plugins/justify/lang/tt.js', '15.9', 0),
('c929e28933ab73518e03db7225eb4444', './vendor/ckeditor/ckeditor/plugins/justify/lang/ug.js', '15.9', 0),
('0a62d39ab8370f708fdf3d166350def4', './vendor/ckeditor/ckeditor/plugins/justify/lang/uk.js', '15.9', 0),
('6d0169561df0464beffeab34a1f4bd3f', './vendor/ckeditor/ckeditor/plugins/justify/lang/vi.js', '15.9', 0),
('d1115c163dbb8c32d00f84a513d60636', './vendor/ckeditor/ckeditor/plugins/justify/lang/zh-cn.js', '15.9', 0),
('d0902c2119736c77978c07927a0111ab', './vendor/ckeditor/ckeditor/plugins/justify/lang/zh.js', '15.9', 0),
('873e36f9a6138f4e15ed8ebf1eac8bb1', './vendor/ckeditor/ckeditor/plugins/justify/plugin.js', '15.9', 0),
('c7c60b7bab7c16d1daad1a465c45b54e', './vendor/ckeditor/ckeditor/plugins/language/lang/ar.js', '15.9', 0),
('9829d497017dfac0a4f1309c22549b93', './vendor/ckeditor/ckeditor/plugins/language/lang/bg.js', '15.9', 0),
('eaef893b6355853d82c3f847206a3286', './vendor/ckeditor/ckeditor/plugins/language/lang/ca.js', '15.9', 0),
('a0877f1bcfa615142bda348e90a48c82', './vendor/ckeditor/ckeditor/plugins/language/lang/cs.js', '15.9', 0),
('00aed651ec9832b69098cd5c9a8d2333', './vendor/ckeditor/ckeditor/plugins/language/lang/cy.js', '15.9', 0),
('f383215ddaeba0ce8cb978793fbabfb3', './vendor/ckeditor/ckeditor/plugins/language/lang/da.js', '15.9', 0),
('e8e906f6da91a27bea1a33c34b2b1840', './vendor/ckeditor/ckeditor/plugins/language/lang/de.js', '15.9', 0),
('cfe5dc5182435ab9da92019e880c80b0', './vendor/ckeditor/ckeditor/plugins/language/lang/el.js', '15.9', 0),
('50130f397016be2808d2e02b74138554', './vendor/ckeditor/ckeditor/plugins/language/lang/en-gb.js', '15.9', 0),
('c5eda8159f9a9a66e1c1aed021aa21ca', './vendor/ckeditor/ckeditor/plugins/language/lang/en.js', '15.9', 0),
('1699ff26361bd261f60a02cfd40a772c', './vendor/ckeditor/ckeditor/plugins/language/lang/eo.js', '15.9', 0),
('81c9ad9c466f674fe772930e5902189a', './vendor/ckeditor/ckeditor/plugins/language/lang/es.js', '15.9', 0),
('9ae80a58f00f69690e27f718e42f1f92', './vendor/ckeditor/ckeditor/plugins/language/lang/eu.js', '15.9', 0),
('862e2794dd5005d8ef861a4bb587694f', './vendor/ckeditor/ckeditor/plugins/language/lang/fa.js', '15.9', 0),
('c1e6e322631dca41a22f7ecdf0521abd', './vendor/ckeditor/ckeditor/plugins/language/lang/fi.js', '15.9', 0),
('32693407598b30a1acb598ab026d957f', './vendor/ckeditor/ckeditor/plugins/language/lang/fo.js', '15.9', 0),
('5d4a68cea49f0d9beb674fbde5c4324d', './vendor/ckeditor/ckeditor/plugins/language/lang/fr.js', '15.9', 0),
('81bc23f743041518ec3ad555e32ac247', './vendor/ckeditor/ckeditor/plugins/language/lang/gl.js', '15.9', 0),
('216226ff3172ae1b2cfadc1539c4c77d', './vendor/ckeditor/ckeditor/plugins/language/lang/he.js', '15.9', 0),
('fa7d53032ca7ba059c3b31f5a08eecd4', './vendor/ckeditor/ckeditor/plugins/language/lang/hr.js', '15.9', 0),
('fd93be5de2a81dd1c94e92755a258913', './vendor/ckeditor/ckeditor/plugins/language/lang/hu.js', '15.9', 0),
('0927716acdc8576ce07062996e4dbee9', './vendor/ckeditor/ckeditor/plugins/language/lang/id.js', '15.9', 0),
('c2e9d32edc49cf80e861aed894dc7f8a', './vendor/ckeditor/ckeditor/plugins/language/lang/it.js', '15.9', 0),
('9220a793e292a48697eae0f35d2c4529', './vendor/ckeditor/ckeditor/plugins/language/lang/ja.js', '15.9', 0),
('08d368bde4c1292eab79bfb97254c87d', './vendor/ckeditor/ckeditor/plugins/language/lang/km.js', '15.9', 0),
('60e1a2edccc8d36f9962b925cafde915', './vendor/ckeditor/ckeditor/plugins/language/lang/ko.js', '15.9', 0),
('359e2f89693599fb938fdf11b96d0455', './vendor/ckeditor/ckeditor/plugins/language/lang/ku.js', '15.9', 0),
('913a6ab09964403297aa34b34e0ccffc', './vendor/ckeditor/ckeditor/plugins/language/lang/nb.js', '15.9', 0),
('f6cc0f78c1e39273612f993d7ca9006b', './vendor/ckeditor/ckeditor/plugins/language/lang/nl.js', '15.9', 0),
('01060bc5ceff694f17138c5d15961e79', './vendor/ckeditor/ckeditor/plugins/language/lang/no.js', '15.9', 0),
('8cf43cf9220fd91eb8d1a340efa4d6af', './vendor/ckeditor/ckeditor/plugins/language/lang/pl.js', '15.9', 0),
('82d9225518dd5495c6f480c0e4ebfeed', './vendor/ckeditor/ckeditor/plugins/language/lang/pt-br.js', '15.9', 0),
('6b8c80fc2f7044aa956bdf03be35a92b', './vendor/ckeditor/ckeditor/plugins/language/lang/pt.js', '15.9', 0),
('6db1dd723f8d1a3f87f13571a461352f', './vendor/ckeditor/ckeditor/plugins/language/lang/ru.js', '15.9', 0),
('3daa5aaf1a22bf7d4430c5b42cca7a57', './vendor/ckeditor/ckeditor/plugins/language/lang/sk.js', '15.9', 0),
('80caa38d72a3f1b466138d6918582cfc', './vendor/ckeditor/ckeditor/plugins/language/lang/sl.js', '15.9', 0),
('c316bff0952ea54274c121310e147900', './vendor/ckeditor/ckeditor/plugins/language/lang/sq.js', '15.9', 0),
('bde34194da10ba24dbcb76b0873fd2bf', './vendor/ckeditor/ckeditor/plugins/language/lang/sv.js', '15.9', 0),
('12a472049d54476ffff1c910ecac2f8c', './vendor/ckeditor/ckeditor/plugins/language/lang/tr.js', '15.9', 0),
('ff974826748a626b2c2c182340b10456', './vendor/ckeditor/ckeditor/plugins/language/lang/tt.js', '15.9', 0),
('18cc88b76f57796be42db26d71309f78', './vendor/ckeditor/ckeditor/plugins/language/lang/ug.js', '15.9', 0),
('0cd870c583a0d435364f0eb9f03ac2c8', './vendor/ckeditor/ckeditor/plugins/language/lang/uk.js', '15.9', 0),
('80cf59fe0a848bfdb1ad336559a1e6c7', './vendor/ckeditor/ckeditor/plugins/language/lang/vi.js', '15.9', 0),
('c2549b7af5bbc03d537ae77e92634a16', './vendor/ckeditor/ckeditor/plugins/language/lang/zh-cn.js', '15.9', 0),
('0c4880303bbf85adcf6b45f7a442387a', './vendor/ckeditor/ckeditor/plugins/language/lang/zh.js', '15.9', 0),
('34a19b6419d26dd5483eff415068ef70', './vendor/ckeditor/ckeditor/plugins/language/plugin.js', '15.9', 0),
('56c276958fe53e32fa3cf65b4f311792', './vendor/ckeditor/ckeditor/plugins/lineutils/plugin.js', '15.9', 0),
('6ab0d4428a720487fe6fc96dedf23978', './vendor/ckeditor/ckeditor/plugins/link/dialogs/anchor.js', '15.9', 0),
('e95551bd36f38800e68bd3e4125794fd', './vendor/ckeditor/ckeditor/plugins/link/dialogs/link.js', '15.9', 0),
('2cc22eac3e22bcc5c2a3afdbb1832de8', './vendor/ckeditor/ckeditor/plugins/liststyle/dialogs/liststyle.js', '15.9', 0),
('1a25a5ee0d4f777d2531fa5187ef5cc1', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/af.js', '15.9', 0),
('8b511f322aedfa35b51b8e445b4fcd24', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ar.js', '15.9', 0),
('b0be2d05c0a84e49df070e112b17fa82', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/bg.js', '15.9', 0),
('3ad3ee5dc0c95e26cdd8cd0ace87e260', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/bn.js', '15.9', 0),
('584bf1d194087aad9d4f996d66a7fda7', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/bs.js', '15.9', 0),
('7b8c4d2d77cbe9a95e8ba983e8e2e697', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ca.js', '15.9', 0),
('22b8f3a32db9f6544e489d3f9ba74b2f', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/cs.js', '15.9', 0),
('5bb5ac758ff7ddf96cc481b0c51b60d2', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/cy.js', '15.9', 0),
('4ad5a98fd38904ace3e5d6cae0a84a56', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/da.js', '15.9', 0),
('7c0b5f012c77493377370b2b2c58aec9', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/de.js', '15.9', 0),
('778c29edc649765b207427f483bce213', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/el.js', '15.9', 0),
('4bd3b6d0a4c0323dad5fc6c34d5a716a', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/en-au.js', '15.9', 0),
('fb4ca7c85ad7efd294915d0f101bb5af', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/en-ca.js', '15.9', 0),
('eb818768423b1a41de582ff85ff4e549', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/en-gb.js', '15.9', 0),
('8942069be000f6ce06b98110ba5b344a', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/en.js', '15.9', 0),
('a4fa60b412cf423a05809d49377d4577', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/eo.js', '15.9', 0),
('a67bc6c2a6d470faef300c2b36c3bf2c', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/es.js', '15.9', 0),
('1c3255ec5ea6a3c29ee27bd744137fef', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/et.js', '15.9', 0),
('3ab288ecf58d8b1529ea8788bbebdd45', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/eu.js', '15.9', 0),
('4c0f6f7397a798713a2e158588ac6728', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/fa.js', '15.9', 0),
('a0258b90d96c5b485552de07981cf3a8', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/fi.js', '15.9', 0),
('c349b8d89b030a8c1d7809840730b0aa', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/fo.js', '15.9', 0),
('8b62346cc0eb44a87ab565a05a5ad7ec', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/fr-ca.js', '15.9', 0),
('a2577d70794c06ac1350023ff650d6a7', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/fr.js', '15.9', 0),
('658c0a258c9e0ebf2ffc18bf215dbc57', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/gl.js', '15.9', 0),
('e12a45d2985d404737ee73d4c5c0b5c8', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/gu.js', '15.9', 0),
('296c1392fdfb24fa8277555cc2baa6d5', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/he.js', '15.9', 0),
('e38d0ef1e5759ffad49ba3cd530ec372', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/hi.js', '15.9', 0),
('7b4dfc52a4078966c26ec3016828af9a', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/hr.js', '15.9', 0),
('72526e0bc1fa7a4ff942922635eaa34c', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/hu.js', '15.9', 0),
('d1c2b03e03b487874adf7f4e0f2bb545', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/id.js', '15.9', 0),
('655454b596cf99464708e82476892947', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/is.js', '15.9', 0),
('ac0d8df897daa1161827ead2c950d4fc', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/it.js', '15.9', 0),
('f763ad4f9b1de4647cfb34509a663c03', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ja.js', '15.9', 0),
('5d963a890db2f41a62508ab89708ec81', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ka.js', '15.9', 0),
('f9e8c3c773c58099cd892d0eb4a27723', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/km.js', '15.9', 0),
('e3109954b0c9e50547933aaf552fdb03', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ko.js', '15.9', 0),
('2d239177a108f19110c60335c7594147', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ku.js', '15.9', 0),
('34e880a06a7f63113c0ce2b5f908c7d4', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/lt.js', '15.9', 0),
('9dff6748bca0bb6792ed87aa3b1135d6', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/lv.js', '15.9', 0),
('26c41265fb9bddf812b1bdb982ed637a', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/mk.js', '15.9', 0),
('514fcf7c934eeb3e824d37e8e77fda96', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/mn.js', '15.9', 0),
('fba39ae8ec3c353fbb5867d633eefa04', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ms.js', '15.9', 0),
('18e72c1c11ef7e973fff62bf228cedc6', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/nb.js', '15.9', 0),
('3500a7d53f446dea6e33c1b20a2bed52', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/nl.js', '15.9', 0),
('ad0f1f1c47ee0ea444dafb88c68d8bd9', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/no.js', '15.9', 0),
('2ffe0eb6f330d978caa7adb12b71b1d5', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/pl.js', '15.9', 0),
('e7091959cd6302cdb3c18681724b1ec0', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/pt-br.js', '15.9', 0),
('a5c0a9bbb4af05e02a9a6d260946e5e0', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/pt.js', '15.9', 0),
('a86780bacbd15f3bf8d0acd4c5feae28', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ro.js', '15.9', 0),
('9f942aacb37ac533fffdbe0e189ae37b', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ru.js', '15.9', 0),
('7b081fc22822e6454095ac01e90213ff', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/si.js', '15.9', 0),
('a0d89247755549bf230a6f6650d2aea0', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/sk.js', '15.9', 0),
('5bba82731e070d958f8e01f37891ae96', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/sl.js', '15.9', 0),
('4f7197f962528f3440b765301ec2c821', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/sq.js', '15.9', 0),
('db1ffcffc71f65f06c376c5995937027', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/sr-latn.js', '15.9', 0),
('e97c9b9b30e5a0a50ba75349879d4b69', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/sr.js', '15.9', 0),
('49623c9765bbd889f3b16d69ae575662', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/sv.js', '15.9', 0),
('85c9f4db0516a42300a276d57b4d40cb', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/th.js', '15.9', 0),
('212d71944097a11533eb7d6a70280a95', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/tr.js', '15.9', 0),
('c81d5c3439157551bd1466c6c86efffe', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/tt.js', '15.9', 0),
('9384fda3332f484a180bf69e463f7f01', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/ug.js', '15.9', 0),
('dc318e64f501603c6eee0e9e24505678', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/uk.js', '15.9', 0),
('bfa1269c9dfe1ba40e69e2b2f681c10b', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/vi.js', '15.9', 0),
('14f806b43acfe44359058cff764167c0', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/zh-cn.js', '15.9', 0),
('add532fa937e05443c6ca449bd22f7f2', './vendor/ckeditor/ckeditor/plugins/liststyle/lang/zh.js', '15.9', 0),
('e979dc858aacf23cf3ce6440d178c334', './vendor/ckeditor/ckeditor/plugins/liststyle/plugin.js', '15.9', 0),
('be1d5095d01b9d6a955d8c72e465d65f', './vendor/ckeditor/ckeditor/plugins/mathjax/dialogs/mathjax.js', '15.9', 0),
('0f5fce7dcf587d6ccbf52f053f504365', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/af.js', '15.9', 0),
('6f9683a9f066914e41a9a6aeab5ca834', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/ar.js', '15.9', 0),
('273aab36e8b096c69346003684e078fa', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/bg.js', '15.9', 0),
('f458e7e342a4032ea0049b5072783a1c', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/ca.js', '15.9', 0),
('2ac64b1c1c8292ec7835d066f0333341', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/cs.js', '15.9', 0),
('2dbc25b7d235aaf125dffffac4517fe3', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/cy.js', '15.9', 0),
('54d53ec6587616532ceb27939f486181', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/da.js', '15.9', 0),
('a2a2c46e57864135c8e64850790dc999', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/de.js', '15.9', 0),
('fcf22afa3b63505049e1c04ef93af868', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/el.js', '15.9', 0),
('2fe3b7c772b41ec6041912df25ce145f', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/en-gb.js', '15.9', 0),
('72b8b524102475b746831be66969b3d3', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/en.js', '15.9', 0),
('81caa9edcd6587cd4b03c5a1ae3d5765', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/eo.js', '15.9', 0),
('f187739d61d6979b49ae78140314d577', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/es.js', '15.9', 0),
('a4acbef54d305461c1d8620e2a6ef684', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/eu.js', '15.9', 0),
('0abce8b75e5e65e6cd9d46344c0b1453', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/fa.js', '15.9', 0),
('8b11a0b0f52be8a46c276a401675d8dc', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/fi.js', '15.9', 0),
('35bf27ca0b362c6c1685ad827d23abca', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/fr.js', '15.9', 0),
('ea57b620917627e632fda3f6e6b8f9fb', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/gl.js', '15.9', 0),
('f04acbe1227749f5b8e69d0ba1f7c537', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/he.js', '15.9', 0),
('066ead45372e7726758bf765ada1d6d4', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/hr.js', '15.9', 0),
('902d7eb9154b4456dfe5c30b5c283677', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/hu.js', '15.9', 0),
('51405a19151c8f009aaa47877ac5eca6', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/id.js', '15.9', 0),
('0c8c42075bd79f320178ed010910de80', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/it.js', '15.9', 0),
('d22535a78b45590799db0a7a35d1d8d7', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/ja.js', '15.9', 0),
('7538b27daeed5471161094ec5c66ff8b', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/km.js', '15.9', 0),
('919ffb93b1e82c2c732e77b9add1c7af', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/ko.js', '15.9', 0),
('b03b7eed8982ec2a9158280a5e1c3a1e', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/ku.js', '15.9', 0),
('96147fd467307890334fc787dcd68835', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/lt.js', '15.9', 0),
('3e4ba3d1f1e768fa69c5d8c9c9f0056a', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/nb.js', '15.9', 0),
('c02d1974c69722f2e3411dfb8ea081d8', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/nl.js', '15.9', 0),
('d89da59dfd283930d3bf677bdf792441', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/no.js', '15.9', 0),
('37871d88b67f3c546e61bf5abe9f5ab1', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/pl.js', '15.9', 0),
('686c6040fe059840ae091506d7099d5b', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/pt-br.js', '15.9', 0),
('31941edc992b2dcca310e439302144c4', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/pt.js', '15.9', 0),
('8cf7c47f107b1d1e2d6a2effa3d04e09', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/ro.js', '15.9', 0),
('c51f03d4d6d0fc986d8f749bb7997140', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/ru.js', '15.9', 0),
('f561819bcfd09c9a73a124a130f9215b', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/sk.js', '15.9', 0),
('d983fe9256ea95a5f2110e4e939305e8', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/sl.js', '15.9', 0),
('31c153575b8333fb219cf036c39af4a4', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/sq.js', '15.9', 0),
('ac200264a192f4831ea2aade5af67fdc', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/sv.js', '15.9', 0),
('075321e17f7ba2b897640c2854cbcf58', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/tr.js', '15.9', 0),
('158f9354460effabda2ccbd991a0948e', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/tt.js', '15.9', 0),
('fc308a4bace05dbd69f72939f1255ce2', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/ug.js', '15.9', 0),
('2ba718aa0a6a15e2f714a7fd741da9b5', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/uk.js', '15.9', 0),
('a3673036924f6403ba3e6edc99797fa8', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/vi.js', '15.9', 0),
('79f478a149c7d09dee965f6fa2328628', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/zh-cn.js', '15.9', 0),
('b2776a6871fa79a91402d98689ee5323', './vendor/ckeditor/ckeditor/plugins/mathjax/lang/zh.js', '15.9', 0),
('b12c6659474e1a9c3847f9ece48d6a60', './vendor/ckeditor/ckeditor/plugins/mathjax/plugin.js', '15.9', 0),
('b325ddc80d92ce3d95305995a55878a4', './vendor/ckeditor/ckeditor/plugins/newpage/lang/af.js', '15.9', 0),
('f63db273cb5f6419f0de3a5b8d768cf9', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ar.js', '15.9', 0),
('e15e559605d1a97cc87d256ee44ef202', './vendor/ckeditor/ckeditor/plugins/newpage/lang/bg.js', '15.9', 0),
('addb65339f5a0c97c3bd71afa877952e', './vendor/ckeditor/ckeditor/plugins/newpage/lang/bn.js', '15.9', 0),
('148e2020d5a1687692082a8339ab45d0', './vendor/ckeditor/ckeditor/plugins/newpage/lang/bs.js', '15.9', 0),
('8acc74fa08f4472e92fa78f97b664b2e', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ca.js', '15.9', 0),
('c9d8fbc546c08ea7e6d0a34a3d4dc43f', './vendor/ckeditor/ckeditor/plugins/newpage/lang/cs.js', '15.9', 0),
('d5e41e89247c1c6a3650f903ef9a164f', './vendor/ckeditor/ckeditor/plugins/newpage/lang/cy.js', '15.9', 0),
('33ea06ed5db58822439d95278646791b', './vendor/ckeditor/ckeditor/plugins/newpage/lang/da.js', '15.9', 0),
('fadf1e11e186f68eb984e5ad5454bb2c', './vendor/ckeditor/ckeditor/plugins/newpage/lang/de.js', '15.9', 0),
('eb2901635dc536d6e7fd3e1b822d91fe', './vendor/ckeditor/ckeditor/plugins/newpage/lang/el.js', '15.9', 0),
('1cd69e1754fdbb1a4ab2e6901e94feb0', './vendor/ckeditor/ckeditor/plugins/newpage/lang/en-au.js', '15.9', 0),
('7e5fbde9fb0797a872d8c95620d17f08', './vendor/ckeditor/ckeditor/plugins/newpage/lang/en-ca.js', '15.9', 0),
('a3640043c246a811fe2eedaf61bda501', './vendor/ckeditor/ckeditor/plugins/newpage/lang/en-gb.js', '15.9', 0),
('8fc8033f40197430bd9c6cadeb3bc0f7', './vendor/ckeditor/ckeditor/plugins/newpage/lang/en.js', '15.9', 0),
('8305569b11914890b85d416d03edd8cd', './vendor/ckeditor/ckeditor/plugins/newpage/lang/eo.js', '15.9', 0),
('cd8c8c886e3f7905cd108ad3d36d05b8', './vendor/ckeditor/ckeditor/plugins/newpage/lang/es.js', '15.9', 0),
('377ca1d0e0ee2878991d87b2aa17a53d', './vendor/ckeditor/ckeditor/plugins/newpage/lang/et.js', '15.9', 0),
('5de6c064869e5f6c844523474e2694ae', './vendor/ckeditor/ckeditor/plugins/newpage/lang/eu.js', '15.9', 0),
('7b954a074b18654de948f170d973b606', './vendor/ckeditor/ckeditor/plugins/newpage/lang/fa.js', '15.9', 0),
('bf2fd7189abc3ee6971337e40b4d08f4', './vendor/ckeditor/ckeditor/plugins/newpage/lang/fi.js', '15.9', 0),
('41c19892d0bbfb6d31870268711c24ce', './vendor/ckeditor/ckeditor/plugins/newpage/lang/fo.js', '15.9', 0),
('b018a143c71773afb12d37b4958e57d8', './vendor/ckeditor/ckeditor/plugins/newpage/lang/fr-ca.js', '15.9', 0),
('767e1fe7b3a03a4bae7c69a1c0938d6a', './vendor/ckeditor/ckeditor/plugins/newpage/lang/fr.js', '15.9', 0),
('2c702d72f991636fe7e9fd959b831e5f', './vendor/ckeditor/ckeditor/plugins/newpage/lang/gl.js', '15.9', 0),
('e467241da8ab0e92a4f82294b19622ec', './vendor/ckeditor/ckeditor/plugins/newpage/lang/gu.js', '15.9', 0),
('75bd8f1eade03a1e311a9e8826371137', './vendor/ckeditor/ckeditor/plugins/newpage/lang/he.js', '15.9', 0),
('59509e9f08cc9eb2f811ddc9a4c90834', './vendor/ckeditor/ckeditor/plugins/newpage/lang/hi.js', '15.9', 0),
('c11b2b47960c11963801293cab151913', './vendor/ckeditor/ckeditor/plugins/newpage/lang/hr.js', '15.9', 0),
('b1c629c4682d4201b6825f3a9849dc73', './vendor/ckeditor/ckeditor/plugins/newpage/lang/hu.js', '15.9', 0),
('f0728569e4ef668d5e39e279f4674b3f', './vendor/ckeditor/ckeditor/plugins/newpage/lang/id.js', '15.9', 0),
('4be5d5235369c88ae4f48f453f6dfdc0', './vendor/ckeditor/ckeditor/plugins/newpage/lang/is.js', '15.9', 0),
('114f97dbcd175942b16d041381506864', './vendor/ckeditor/ckeditor/plugins/newpage/lang/it.js', '15.9', 0),
('ad7697d70b2aca4a7faedda35623cd5b', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ja.js', '15.9', 0),
('fceed0d6f6cfddae01ce034f9306b6dd', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ka.js', '15.9', 0),
('0f4ef40d19d8ea20af498c38b9365bc2', './vendor/ckeditor/ckeditor/plugins/newpage/lang/km.js', '15.9', 0),
('a03881f8d0082cd38d68fd8d1bf0759b', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ko.js', '15.9', 0),
('bf7ccda22fc329437983cdf9b894fe37', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ku.js', '15.9', 0),
('750294016ee9df81fa4292f7717834a3', './vendor/ckeditor/ckeditor/plugins/newpage/lang/lt.js', '15.9', 0),
('8ac92b232f4d318439a09c1550bb4f93', './vendor/ckeditor/ckeditor/plugins/newpage/lang/lv.js', '15.9', 0),
('69e18d5cda4519fc0ebedd5c97ac9db4', './vendor/ckeditor/ckeditor/plugins/newpage/lang/mk.js', '15.9', 0),
('76abb355a4cb2ad001a332f634915611', './vendor/ckeditor/ckeditor/plugins/newpage/lang/mn.js', '15.9', 0),
('a9eb81545d5fef0434907ca15d285df5', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ms.js', '15.9', 0),
('a310369aa2ebacdfcdd499ee1606c2e5', './vendor/ckeditor/ckeditor/plugins/newpage/lang/nb.js', '15.9', 0),
('cc09e3cbaf404573f9a5d35fc82b72a4', './vendor/ckeditor/ckeditor/plugins/newpage/lang/nl.js', '15.9', 0),
('9b978e46867888415bb078ea7e4d9191', './vendor/ckeditor/ckeditor/plugins/newpage/lang/no.js', '15.9', 0),
('a4b6d05df23dee324aaa8cfc939f1dc3', './vendor/ckeditor/ckeditor/plugins/newpage/lang/pl.js', '15.9', 0),
('13be1c6e182d33889ffd480e2b3f2aee', './vendor/ckeditor/ckeditor/plugins/newpage/lang/pt-br.js', '15.9', 0),
('a5967390671c8f6bc096f10586796a41', './vendor/ckeditor/ckeditor/plugins/newpage/lang/pt.js', '15.9', 0),
('b8116206e23c8ea47000ccc0c00f5633', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ro.js', '15.9', 0),
('7731ed1f778b485ecd38e9d663d4fe9f', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ru.js', '15.9', 0),
('a52b8d73edc588e37ceca57da846c541', './vendor/ckeditor/ckeditor/plugins/newpage/lang/si.js', '15.9', 0),
('887baa974a882b008263c479d70a2b56', './vendor/ckeditor/ckeditor/plugins/newpage/lang/sk.js', '15.9', 0),
('0652773104ef0f7b4221d106ac50543d', './vendor/ckeditor/ckeditor/plugins/newpage/lang/sl.js', '15.9', 0),
('df59677dfb2d61a8264f70e414677091', './vendor/ckeditor/ckeditor/plugins/newpage/lang/sq.js', '15.9', 0),
('13d3d190e49dc6eb28a559d9a0678524', './vendor/ckeditor/ckeditor/plugins/newpage/lang/sr-latn.js', '15.9', 0),
('f9031e0e76db704da2e7b7c0b0468e67', './vendor/ckeditor/ckeditor/plugins/newpage/lang/sr.js', '15.9', 0),
('c99e2a157aedbb8f6c064e2471ae0d71', './vendor/ckeditor/ckeditor/plugins/newpage/lang/sv.js', '15.9', 0),
('3c85bb53f6c6a9deb267b5254a57294a', './vendor/ckeditor/ckeditor/plugins/newpage/lang/th.js', '15.9', 0),
('cc75a463492aaa24798f087a6dffd0de', './vendor/ckeditor/ckeditor/plugins/newpage/lang/tr.js', '15.9', 0),
('a14ed023033e70acf68439ebe724e61f', './vendor/ckeditor/ckeditor/plugins/newpage/lang/tt.js', '15.9', 0),
('853f89b334c18f7da27a7bf74711a0d3', './vendor/ckeditor/ckeditor/plugins/newpage/lang/ug.js', '15.9', 0),
('50802284b7127321c25f09f58ee19aeb', './vendor/ckeditor/ckeditor/plugins/newpage/lang/uk.js', '15.9', 0),
('66542ed30c6303f26b8cf4cf4513959a', './vendor/ckeditor/ckeditor/plugins/newpage/lang/vi.js', '15.9', 0),
('6f9247d652b1e786385d539def29cdcf', './vendor/ckeditor/ckeditor/plugins/newpage/lang/zh-cn.js', '15.9', 0),
('4d59946b994a6d38e751d4083dcca69c', './vendor/ckeditor/ckeditor/plugins/newpage/lang/zh.js', '15.9', 0),
('e36c45ffcb6dc0ccb564b9bf870a191c', './vendor/ckeditor/ckeditor/plugins/newpage/plugin.js', '15.9', 0),
('435c8102ea94e77bc796ff0513452d9d', './vendor/ckeditor/ckeditor/plugins/notification/lang/cs.js', '15.9', 0),
('0d254bac37e7b3a41d67a951a6cd72ca', './vendor/ckeditor/ckeditor/plugins/notification/lang/da.js', '15.9', 0),
('9eef8a04723d239ef2b1a48ec9339093', './vendor/ckeditor/ckeditor/plugins/notification/lang/de.js', '15.9', 0),
('55106db12047481864ddebe108b27f00', './vendor/ckeditor/ckeditor/plugins/notification/lang/en.js', '15.9', 0),
('fe03b5e1b8fb12cecc6cfc7489f3d450', './vendor/ckeditor/ckeditor/plugins/notification/lang/eo.js', '15.9', 0),
('a43cafd7f98c22774dc100e78c729a52', './vendor/ckeditor/ckeditor/plugins/notification/lang/eu.js', '15.9', 0),
('82458e0922e37b27cfee6302b3200219', './vendor/ckeditor/ckeditor/plugins/notification/lang/fr.js', '15.9', 0),
('38416793d5484f325e4dbab59c797c80', './vendor/ckeditor/ckeditor/plugins/notification/lang/gl.js', '15.9', 0),
('44cec1e9aa66471d28fa07e01cd85790', './vendor/ckeditor/ckeditor/plugins/notification/lang/id.js', '15.9', 0),
('426d969d18928aaa4b32de7f20860e77', './vendor/ckeditor/ckeditor/plugins/notification/lang/it.js', '15.9', 0),
('5c2d383f04dc5f01f78637493679e1de', './vendor/ckeditor/ckeditor/plugins/notification/lang/ko.js', '15.9', 0),
('e8d7c70498a65d712051e6aaae0fa198', './vendor/ckeditor/ckeditor/plugins/notification/lang/ku.js', '15.9', 0),
('2a5af533e64ed163a857237d9ff480d2', './vendor/ckeditor/ckeditor/plugins/notification/lang/nb.js', '15.9', 0),
('019b582118b366fe9ae672911a69f9d2', './vendor/ckeditor/ckeditor/plugins/notification/lang/nl.js', '15.9', 0),
('ce042f925b48b96ea5b7ce6688dfdc3d', './vendor/ckeditor/ckeditor/plugins/notification/lang/pl.js', '15.9', 0),
('b3e6daaed1b54b26802bdd0b41fd22a5', './vendor/ckeditor/ckeditor/plugins/notification/lang/pt-br.js', '15.9', 0),
('723d76fe5be0d0e35a6934092142bfff', './vendor/ckeditor/ckeditor/plugins/notification/lang/ru.js', '15.9', 0),
('c0ac24b41b145a2a47e10964fece3270', './vendor/ckeditor/ckeditor/plugins/notification/lang/sv.js', '15.9', 0),
('d56d4749c339f463198f46ae7cb5f9b1', './vendor/ckeditor/ckeditor/plugins/notification/lang/tr.js', '15.9', 0),
('0fc494cd3bc49b583d8dd0a193fcecba', './vendor/ckeditor/ckeditor/plugins/notification/lang/ug.js', '15.9', 0),
('54890697aa775f22c9fe6ff97b927ec5', './vendor/ckeditor/ckeditor/plugins/notification/lang/uk.js', '15.9', 0),
('de028cfab856a390b067000b786d1d61', './vendor/ckeditor/ckeditor/plugins/notification/lang/zh-cn.js', '15.9', 0),
('709971ad09096ed62cd22af98dbd226c', './vendor/ckeditor/ckeditor/plugins/notification/lang/zh.js', '15.9', 0),
('dbf9104134e6c7271bea62aba5b90e06', './vendor/ckeditor/ckeditor/plugins/notification/plugin.js', '15.9', 0),
('cf756f5d335aecea44915716800568c0', './vendor/ckeditor/ckeditor/plugins/notificationaggregator/plugin.js', '15.9', 0),
('59e90efb9b67c68167681cc735b82038', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/af.js', '15.9', 0),
('2c83b31114ee8b60cf8fd35545f11cab', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ar.js', '15.9', 0),
('1a9af8a01f5e5cbc6240b53d526ea967', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/bg.js', '15.9', 0),
('fe164f1338229d4b27d5711b3af2baa2', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/bn.js', '15.9', 0),
('b903cd35df92bf9d7d0b970e10830c4f', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/bs.js', '15.9', 0),
('c79b0f9102ab823e7c7e0fe1a19f0aaa', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ca.js', '15.9', 0),
('75aac1f9ebaccaf53186b97c2794e318', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/cs.js', '15.9', 0),
('e5b18169e743141eea10e38f24e237de', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/cy.js', '15.9', 0),
('3317d8f0bf108fedfc7b1d99d97a8d70', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/da.js', '15.9', 0),
('6ed234dd09a2113fa39b96d14bd27948', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/de.js', '15.9', 0),
('7dfff31a570aa6377dd656e0b1f4baf4', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/el.js', '15.9', 0),
('0d2cc45cf7660482f6c58f7c57fa550d', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/en-au.js', '15.9', 0),
('74eb31cb7156156879ace5e4a2e8f241', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/en-ca.js', '15.9', 0),
('d5f868cf3b46ac04c647f9ca9af9f2c0', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/en-gb.js', '15.9', 0),
('4c6ae35de281e6a3b18efc10c24fe6da', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/en.js', '15.9', 0),
('3e508600cab96c2cc11d7ebc38f31d03', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/eo.js', '15.9', 0),
('1a2637fe6a06b84a4245332f7102d6c1', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/es.js', '15.9', 0),
('2ad9ba66cb3b5975eeb5c452490a1689', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/et.js', '15.9', 0),
('eb7cc87240a73dd724df821bb007759e', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/eu.js', '15.9', 0),
('3526c7692dca7b8e92dabab996bad022', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/fa.js', '15.9', 0),
('4ce7ed3353a78fca414d442e57b266c9', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/fi.js', '15.9', 0),
('082cfbfd27cf9d360e86182b73365749', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/fo.js', '15.9', 0),
('cdb34883c16e328b095fef0a16b4dd72', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/fr-ca.js', '15.9', 0),
('2c1c3c3d61a12b8414ee4165cd7f8a81', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/fr.js', '15.9', 0),
('f1380148bef5b9740bc1a43334e075b2', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/gl.js', '15.9', 0),
('3884e654f59b721d60895dcd2814a47f', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/gu.js', '15.9', 0),
('fe19c324f82865c289095273c9ed5589', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/he.js', '15.9', 0),
('0d5e03ec61f0906f5fe2564841eb8db1', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/hi.js', '15.9', 0),
('9d0b2c4f6fb056fa3a0f92862a0ec360', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/hr.js', '15.9', 0),
('e7831ca8ed897f631d6bbbcbe43973b4', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/hu.js', '15.9', 0),
('597992cb722f2756d0774e03f388f619', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/id.js', '15.9', 0),
('946683c4b4648a94a0d970a17b593352', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/is.js', '15.9', 0),
('37f2d85d9e27a046f499863933751fe9', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/it.js', '15.9', 0),
('ca1c31b40d6133b76dab7f27896919d5', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ja.js', '15.9', 0),
('8f576cc6a0ad986029f48e519fede809', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ka.js', '15.9', 0),
('7a03b3575728935c31026c8d77637135', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/km.js', '15.9', 0),
('13f85b14832a4389f4d390dcd43ef4b1', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ko.js', '15.9', 0),
('815f09d46efd5385310b12cde1422f76', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ku.js', '15.9', 0),
('1b3898c901f6900d13cfd3e1dca6b91c', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/lt.js', '15.9', 0),
('40266d454d5644ded00dd37aeeed9bce', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/lv.js', '15.9', 0),
('4abc1826b0a8c0539c414f292d3826c0', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/mk.js', '15.9', 0),
('a063768b73132a47f5acc07f1d31bd12', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/mn.js', '15.9', 0),
('dcf2b402c1ac38e5de6a0acab37bdc57', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ms.js', '15.9', 0),
('6e893b25933922795fcd9bdb784ef0ec', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/nb.js', '15.9', 0),
('ffc38cdf67eb6117652d192b013c49a6', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/nl.js', '15.9', 0),
('1997653e6e2c1683ca8e37788c1d5305', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/no.js', '15.9', 0),
('87abc292e13b97a65b6c89871db1f227', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/pl.js', '15.9', 0),
('60c0cac9e6873edd9a6bdaba7952e271', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/pt-br.js', '15.9', 0),
('087f23aaf8e252206a87ac1813f704a2', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/pt.js', '15.9', 0),
('b5761ac36eaa491c9b5c79d94be72459', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ro.js', '15.9', 0),
('c25f315cc2195e1960d3bd4365f37c84', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ru.js', '15.9', 0),
('15bad6b848a36fd274cd141862b21af1', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/si.js', '15.9', 0),
('44b594bb50cafa05a6f9a74ff8127f18', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/sk.js', '15.9', 0),
('3812cb466005af4172168e42bfbf605d', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/sl.js', '15.9', 0),
('b9673f6e473972951b09dc570abae29c', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/sq.js', '15.9', 0),
('39fadbab50c3c0d85ee07495ee3fee3a', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/sr-latn.js', '15.9', 0),
('ac2e3e51f68121b2a7452020c8217ac8', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/sr.js', '15.9', 0),
('eb48ffb219f7f2e5fe91ce2ed725856a', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/sv.js', '15.9', 0),
('b5302637030514130a3a5be44c0c0245', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/th.js', '15.9', 0),
('3b91894e597621c9efaf5abc21af18a3', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/tr.js', '15.9', 0),
('6200cd96ed7a19a86bc957eb1e30aa79', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/tt.js', '15.9', 0),
('68568bc1030e4d147e8d3d7a4bf662c6', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/ug.js', '15.9', 0),
('8df093a3a1ee91f1ddefc23461b30fe0', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/uk.js', '15.9', 0),
('628c919312d9444e696e68a7fd1e44c8', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/vi.js', '15.9', 0),
('d449a623f8a98aa9a5acb1d0fa6b5ece', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/zh-cn.js', '15.9', 0),
('c448896ea9f2cdc7e7d4abe2e917fb80', './vendor/ckeditor/ckeditor/plugins/pagebreak/lang/zh.js', '15.9', 0),
('5608c96a067f0e74ab70bbb5e903466f', './vendor/ckeditor/ckeditor/plugins/pagebreak/plugin.js', '15.9', 0),
('d4eb03014f1253f66fccfefe93e10adb', './vendor/ckeditor/ckeditor/plugins/panelbutton/plugin.js', '15.9', 0),
('a871601dc03fa134ac2df8467549f9de', './vendor/ckeditor/ckeditor/plugins/pastefromword/filter/default.js', '15.9', 0),
('c08c5870d967d5fe46bee3ee85b6a2b8', './vendor/ckeditor/ckeditor/plugins/placeholder/dialogs/placeholder.js', '15.9', 0),
('c931ef37c4296f03d86a394cbf827972', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/af.js', '15.9', 0),
('9eacb7605252774a631cb7befe3d79d0', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/ar.js', '15.9', 0),
('2da70eaa1fd35309e6834c2aed02dbeb', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/bg.js', '15.9', 0),
('8028e76977cdb23e8f51dcae0897f213', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/ca.js', '15.9', 0),
('8a2b80e134dea40b4e7bbdf6fee1f009', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/cs.js', '15.9', 0),
('e338eb3e3e928adba75e220ddb0c6dde', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/cy.js', '15.9', 0),
('2180f42eeff4259b8faf4dc601e742e5', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/da.js', '15.9', 0),
('4842e39bc493afd10e239206776e76fc', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/de.js', '15.9', 0),
('8df865cb0f319d2dbaefa9dfef6200be', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/el.js', '15.9', 0),
('e95cf23d81aa6101746302155b2e786e', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/en-gb.js', '15.9', 0),
('7c6899ef37fdfd8e117c2e60e946101d', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/en.js', '15.9', 0),
('83cbef1c55ede4ea6182770e9676e88d', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/eo.js', '15.9', 0),
('d6646ebe7f4a8a317229a5016ab8b47f', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/es.js', '15.9', 0),
('17d7a8bd25c957c9a93d2c72c6dcdadb', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/et.js', '15.9', 0),
('2c0c4efbe967dc2a91e196cb8bbbe1c9', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/eu.js', '15.9', 0),
('8f070bdf50a817ba4dd28dcbcbaee5c8', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/fa.js', '15.9', 0),
('c27fa3e4023818060610c28169a24dbd', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/fi.js', '15.9', 0),
('e1f9703848dfdc1d2ee6d7ac6e9febd5', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/fr-ca.js', '15.9', 0),
('10d671a42a517e2b1f2c04f5c6ac75e8', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/fr.js', '15.9', 0),
('498c45c55cee5f45acf09fb5387e3498', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/gl.js', '15.9', 0),
('12be52d35c94092ba37921e27d4d2ca6', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/he.js', '15.9', 0),
('b178ea6153df3e6791f572a5cf38c3a9', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/hr.js', '15.9', 0),
('ae6303698b80f7d71194910a78c9f8cd', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/hu.js', '15.9', 0),
('3389a75c5a74f575a43daae1951d6e70', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/id.js', '15.9', 0),
('172c808c16b6bcfdd6338f6b304a7e1d', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/it.js', '15.9', 0),
('1aafc58b637d9bd2d3c49b3de4fbc0f8', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/ja.js', '15.9', 0),
('f1be574c13459f90ffb78734d33e8665', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/km.js', '15.9', 0),
('66b146a9464cb5cf2a81aeae501ef62c', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/ko.js', '15.9', 0),
('aa45a196c137f66f21c4959315a6a135', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/ku.js', '15.9', 0),
('27de5993f90e8e8d43ac42db550e2caf', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/lv.js', '15.9', 0),
('cf7308d16b5fde111c89051543be568e', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/nb.js', '15.9', 0),
('edff6110bc6fa94b51b43b12ff5bea8f', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/nl.js', '15.9', 0),
('0d6e0509c79f28d3d052a0f7dff4ea23', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/no.js', '15.9', 0),
('8ffbc2a9de0720ae52dbafda5d298287', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/pl.js', '15.9', 0),
('c5cb258bffd2d51049b280db98021680', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/pt-br.js', '15.9', 0),
('e8996dae7f73df062bba52da1740771c', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/pt.js', '15.9', 0),
('c6bccdd11c1faec6c5dbfab23cce1f0b', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/ru.js', '15.9', 0),
('7e7d0be6652ba5754ddf4da676a0c55e', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/si.js', '15.9', 0),
('3495a6f8680911b4473e8476f8d61b6a', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/sk.js', '15.9', 0),
('cc52917d60a4db8eee55b7e67d40f08f', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/sl.js', '15.9', 0),
('940d3faf55e94b3b68cb4ebc98e12f3e', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/sq.js', '15.9', 0),
('c8e4fd6c30f48451a691ee3d2b048a93', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/sv.js', '15.9', 0),
('81243bbc03782ea6a4c342f67fe4ce33', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/th.js', '15.9', 0),
('08d48a7e93b2f678456f125e55ea2634', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/tr.js', '15.9', 0),
('6fc49363b388dc0bf3f2f8b57ffbc3a8', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/tt.js', '15.9', 0),
('bcc558a8ef7bdba22b4956894d0a5e8c', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/ug.js', '15.9', 0),
('6bf1b2185c1ad5c88676c2dbe286549f', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/uk.js', '15.9', 0),
('8659bf9da373611bf83248644b2c906b', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/vi.js', '15.9', 0),
('b53236e3b522ceeb2540870a36f6c870', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/zh-cn.js', '15.9', 0),
('505fc0881467934ea4535993a90fef1a', './vendor/ckeditor/ckeditor/plugins/placeholder/lang/zh.js', '15.9', 0),
('41a3c5cb68402f7d5cf21839235dbd4e', './vendor/ckeditor/ckeditor/plugins/placeholder/plugin.js', '15.9', 0),
('ae469ae4fc3d0fdf5ab71b44a881755c', './vendor/ckeditor/ckeditor/plugins/preview/lang/af.js', '15.9', 0),
('48b54e3e329e37c2eb0758f8285ba0f6', './vendor/ckeditor/ckeditor/plugins/preview/lang/ar.js', '15.9', 0),
('c367431d5bfc64072e2f7c0953d31c33', './vendor/ckeditor/ckeditor/plugins/preview/lang/bg.js', '15.9', 0),
('42db1a4216ae7978e02529fa11733499', './vendor/ckeditor/ckeditor/plugins/preview/lang/bn.js', '15.9', 0),
('c0406e321a6923f1c589b56692881d46', './vendor/ckeditor/ckeditor/plugins/preview/lang/bs.js', '15.9', 0),
('169ee3f52f7a07587ae6afc1a183d86d', './vendor/ckeditor/ckeditor/plugins/preview/lang/ca.js', '15.9', 0),
('c25c30a3ae8abbfc96d20f263df12d99', './vendor/ckeditor/ckeditor/plugins/preview/lang/cs.js', '15.9', 0),
('90507818169a50103e132f04f5e75ed8', './vendor/ckeditor/ckeditor/plugins/preview/lang/cy.js', '15.9', 0),
('67913dd3addb84c70348ccde23260835', './vendor/ckeditor/ckeditor/plugins/preview/lang/da.js', '15.9', 0),
('87076268ca13e461ed3300016a4f9c8c', './vendor/ckeditor/ckeditor/plugins/preview/lang/de.js', '15.9', 0),
('10609d0cb0729a8b4f4c52f4bf090340', './vendor/ckeditor/ckeditor/plugins/preview/lang/el.js', '15.9', 0),
('d32aae36eec6995254657c1197c43ff4', './vendor/ckeditor/ckeditor/plugins/preview/lang/en-au.js', '15.9', 0),
('8b31f39d6aa94012c77f42bab7610d17', './vendor/ckeditor/ckeditor/plugins/preview/lang/en-ca.js', '15.9', 0),
('940d0515966ad9be8e80626bb437621e', './vendor/ckeditor/ckeditor/plugins/preview/lang/en-gb.js', '15.9', 0),
('1462b5bd0814d64ef4d47117143b06f9', './vendor/ckeditor/ckeditor/plugins/preview/lang/en.js', '15.9', 0),
('1f930b35a400bbc239e42d1d154a04db', './vendor/ckeditor/ckeditor/plugins/preview/lang/eo.js', '15.9', 0),
('041d19c8620b05f7834ba4eaab4bc100', './vendor/ckeditor/ckeditor/plugins/preview/lang/es.js', '15.9', 0),
('83257207260be87b93605cfe6fd3fec6', './vendor/ckeditor/ckeditor/plugins/preview/lang/et.js', '15.9', 0),
('64746d34f7ad98f5a19dd6cdda46e4d6', './vendor/ckeditor/ckeditor/plugins/preview/lang/eu.js', '15.9', 0),
('e529a92b43600a48fbdf98474dd3fb36', './vendor/ckeditor/ckeditor/plugins/preview/lang/fa.js', '15.9', 0),
('aa0603fb000642af701fed7980f4505e', './vendor/ckeditor/ckeditor/plugins/preview/lang/fi.js', '15.9', 0),
('130bfc8c8cbd2587acef5a85f060d4c7', './vendor/ckeditor/ckeditor/plugins/preview/lang/fo.js', '15.9', 0),
('09ce1e058409572c8865fcd9dd8880a7', './vendor/ckeditor/ckeditor/plugins/preview/lang/fr-ca.js', '15.9', 0),
('8a27fd4752f98106c796f46c3f66f732', './vendor/ckeditor/ckeditor/plugins/preview/lang/fr.js', '15.9', 0),
('11788dea39feb8e22b6e14e35c81f2bd', './vendor/ckeditor/ckeditor/plugins/preview/lang/gl.js', '15.9', 0),
('7ce382afa286095b5784ed0d6c2cbb88', './vendor/ckeditor/ckeditor/plugins/preview/lang/gu.js', '15.9', 0),
('53215ef75fda59a6f34cfae2a096a79e', './vendor/ckeditor/ckeditor/plugins/preview/lang/he.js', '15.9', 0),
('31dd46eca6cabb9eefc0c21b4e6be7ab', './vendor/ckeditor/ckeditor/plugins/preview/lang/hi.js', '15.9', 0),
('7cf1b04b1fed4d1ea9d43240bdbef742', './vendor/ckeditor/ckeditor/plugins/preview/lang/hr.js', '15.9', 0),
('c2190695d3e37c42b0b1429c5b90811b', './vendor/ckeditor/ckeditor/plugins/preview/lang/hu.js', '15.9', 0),
('4d10fa307e808cf62cc51410fc7b9dc6', './vendor/ckeditor/ckeditor/plugins/preview/lang/id.js', '15.9', 0),
('578b66d1225e01a54c7fb67e7ce7fa98', './vendor/ckeditor/ckeditor/plugins/preview/lang/is.js', '15.9', 0),
('ee4ae33774100c077e4915468c072115', './vendor/ckeditor/ckeditor/plugins/preview/lang/it.js', '15.9', 0),
('4553a634dc5fda85b920f0b9d43d6b6f', './vendor/ckeditor/ckeditor/plugins/preview/lang/ja.js', '15.9', 0),
('5d19b32d3b7c65525771b4ff43e50d0d', './vendor/ckeditor/ckeditor/plugins/preview/lang/ka.js', '15.9', 0),
('3ac70544de9bc40f9fcd33df0c6f90a7', './vendor/ckeditor/ckeditor/plugins/preview/lang/km.js', '15.9', 0),
('005ec592481c47110d24ee2ceaa9a733', './vendor/ckeditor/ckeditor/plugins/preview/lang/ko.js', '15.9', 0),
('6b0c7d7a0d56eb282078d4add47972df', './vendor/ckeditor/ckeditor/plugins/preview/lang/ku.js', '15.9', 0),
('ca481f682ebb3ab51529567a849393e2', './vendor/ckeditor/ckeditor/plugins/preview/lang/lt.js', '15.9', 0),
('e4931ea411c2b2fa9f0a183b133155a6', './vendor/ckeditor/ckeditor/plugins/preview/lang/lv.js', '15.9', 0),
('ee14aaa6db1ed36aa269691cfd74966c', './vendor/ckeditor/ckeditor/plugins/preview/lang/mk.js', '15.9', 0),
('47a98dd92399d668f22025f8f5868ed0', './vendor/ckeditor/ckeditor/plugins/preview/lang/mn.js', '15.9', 0),
('6487c0db6f7db649adeb3b70a59dab46', './vendor/ckeditor/ckeditor/plugins/preview/lang/ms.js', '15.9', 0),
('c27ab0c16b5ebfd66a6f7639d894d0a9', './vendor/ckeditor/ckeditor/plugins/preview/lang/nb.js', '15.9', 0),
('cfcdb85c4429a91849a6cb4ae9942121', './vendor/ckeditor/ckeditor/plugins/preview/lang/nl.js', '15.9', 0),
('9c7becb51a9955a56b74a2fa7779071e', './vendor/ckeditor/ckeditor/plugins/preview/lang/no.js', '15.9', 0),
('26adbdba77320d9ba130f7b64705b536', './vendor/ckeditor/ckeditor/plugins/preview/lang/pl.js', '15.9', 0),
('983b78ff63efaf2807a221acfd83a0ba', './vendor/ckeditor/ckeditor/plugins/preview/lang/pt-br.js', '15.9', 0),
('940ef876e848ca99fc1dbb2fa7231d8b', './vendor/ckeditor/ckeditor/plugins/preview/lang/pt.js', '15.9', 0),
('8ad08e8bb47640f6766dcb1fdbbec847', './vendor/ckeditor/ckeditor/plugins/preview/lang/ro.js', '15.9', 0),
('d551f987396d3b48cb669eea7f210b17', './vendor/ckeditor/ckeditor/plugins/preview/lang/ru.js', '15.9', 0),
('dd5da1f6d536490cf11738680bc5e198', './vendor/ckeditor/ckeditor/plugins/preview/lang/si.js', '15.9', 0),
('b79e18b532a92e6c651459cb872c56b3', './vendor/ckeditor/ckeditor/plugins/preview/lang/sk.js', '15.9', 0),
('89786caea2c673d9c81737eb72948afb', './vendor/ckeditor/ckeditor/plugins/preview/lang/sl.js', '15.9', 0),
('4726de52682953019334e18debf7b9e0', './vendor/ckeditor/ckeditor/plugins/preview/lang/sq.js', '15.9', 0),
('b6a2d3a2bd025036513017eb8c59a57a', './vendor/ckeditor/ckeditor/plugins/preview/lang/sr-latn.js', '15.9', 0),
('20417211bddf7ad3139dacc1327ce9bb', './vendor/ckeditor/ckeditor/plugins/preview/lang/sr.js', '15.9', 0),
('176ba77d93b3d3f3d643f09fd34d3100', './vendor/ckeditor/ckeditor/plugins/preview/lang/sv.js', '15.9', 0),
('45bda6e95bf9738e4ad1f123dc9ce0b2', './vendor/ckeditor/ckeditor/plugins/preview/lang/th.js', '15.9', 0),
('f892edec0cd78782e89efa4ecb4d51d8', './vendor/ckeditor/ckeditor/plugins/preview/lang/tr.js', '15.9', 0),
('ab930c089e15353dcb773b10e036de42', './vendor/ckeditor/ckeditor/plugins/preview/lang/tt.js', '15.9', 0),
('cdb165a152b085c1e08e2bc94051c014', './vendor/ckeditor/ckeditor/plugins/preview/lang/ug.js', '15.9', 0),
('f439e5673d516892ba9c1c2fb283881e', './vendor/ckeditor/ckeditor/plugins/preview/lang/uk.js', '15.9', 0),
('ea4679d1df944c527bf8c09c49188088', './vendor/ckeditor/ckeditor/plugins/preview/lang/vi.js', '15.9', 0),
('55835e8ab4ee038eccbbadeefa807f23', './vendor/ckeditor/ckeditor/plugins/preview/lang/zh-cn.js', '15.9', 0),
('6b9a9d600a2cbff6235ffda2500e3374', './vendor/ckeditor/ckeditor/plugins/preview/lang/zh.js', '15.9', 0),
('64a8a1a3ab8096e25af155d07cf9de5c', './vendor/ckeditor/ckeditor/plugins/preview/plugin.js', '15.9', 0),
('2c9d6ca66850c75db022acb61761d4dd', './vendor/ckeditor/ckeditor/plugins/print/lang/af.js', '15.9', 0),
('1ac0ebdb2c3fd744f54b2ca7e198ed73', './vendor/ckeditor/ckeditor/plugins/print/lang/ar.js', '15.9', 0),
('68837631f982cd335d7fc93a3b038ee0', './vendor/ckeditor/ckeditor/plugins/print/lang/bg.js', '15.9', 0),
('f244a21ef9f286e9abcdfeaf17b7b734', './vendor/ckeditor/ckeditor/plugins/print/lang/bn.js', '15.9', 0),
('f479edc02b87ad06ac88a8482e41902d', './vendor/ckeditor/ckeditor/plugins/print/lang/bs.js', '15.9', 0),
('30cc162b6515df81c0fc1895433f3bc3', './vendor/ckeditor/ckeditor/plugins/print/lang/ca.js', '15.9', 0),
('d524726cf71829d1a6f00c42c247a8a7', './vendor/ckeditor/ckeditor/plugins/print/lang/cs.js', '15.9', 0),
('eb0632cfda0f0467e49121c730b4826e', './vendor/ckeditor/ckeditor/plugins/print/lang/cy.js', '15.9', 0),
('b312458b2be47311283120de23bb84f6', './vendor/ckeditor/ckeditor/plugins/print/lang/da.js', '15.9', 0),
('7eb5e544389dd59e9ff7d1fb5c72087b', './vendor/ckeditor/ckeditor/plugins/print/lang/de.js', '15.9', 0),
('102f5ba97e7441d0feb4d6893c5b9bb7', './vendor/ckeditor/ckeditor/plugins/print/lang/el.js', '15.9', 0),
('6d532700eb32a7f2f97501f77d0a7f41', './vendor/ckeditor/ckeditor/plugins/print/lang/en-au.js', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('7823d4544de6f68ac54486f6a0899c37', './vendor/ckeditor/ckeditor/plugins/print/lang/en-ca.js', '15.9', 0),
('6bbed2869f19cb788bbf403f0f5288c7', './vendor/ckeditor/ckeditor/plugins/print/lang/en-gb.js', '15.9', 0),
('7ad560090ae8e7b073c72fc82b2fdf36', './vendor/ckeditor/ckeditor/plugins/print/lang/en.js', '15.9', 0),
('b95ac2ff3ea8fd05302a0505b599b6b6', './vendor/ckeditor/ckeditor/plugins/print/lang/eo.js', '15.9', 0),
('5bdabf2e8f5d3ac0bd27f745dfd7108d', './vendor/ckeditor/ckeditor/plugins/print/lang/es.js', '15.9', 0),
('215817f9d7d02a1e028180f0d7824c10', './vendor/ckeditor/ckeditor/plugins/print/lang/et.js', '15.9', 0),
('99ab40a6d261658d3e7afb4db69440a5', './vendor/ckeditor/ckeditor/plugins/print/lang/eu.js', '15.9', 0),
('d996f8a4fc9b6a9e29b6df2168fe557c', './vendor/ckeditor/ckeditor/plugins/print/lang/fa.js', '15.9', 0),
('4573bdff2aaf2365d6628b8d73cee8cf', './vendor/ckeditor/ckeditor/plugins/print/lang/fi.js', '15.9', 0),
('0ae66e3230e0d7932f2f79e9df4c8a7f', './vendor/ckeditor/ckeditor/plugins/print/lang/fo.js', '15.9', 0),
('8defa0fb8f8ce508d981bec4c5e6e4ee', './vendor/ckeditor/ckeditor/plugins/print/lang/fr-ca.js', '15.9', 0),
('b1d6b716a237efa79d6294fbffe100bc', './vendor/ckeditor/ckeditor/plugins/print/lang/fr.js', '15.9', 0),
('82c20b810d08197dcd15b464f34157ad', './vendor/ckeditor/ckeditor/plugins/print/lang/gl.js', '15.9', 0),
('7e1acad96d1cb34d6a29048a12cc53f5', './vendor/ckeditor/ckeditor/plugins/print/lang/gu.js', '15.9', 0),
('dbb1ff5b285b622f1ed3098f81a7c223', './vendor/ckeditor/ckeditor/plugins/print/lang/he.js', '15.9', 0),
('4a2f3977381565d755772683d1011d9a', './vendor/ckeditor/ckeditor/plugins/print/lang/hi.js', '15.9', 0),
('0aa4c19f3922920d938802fc4ad06cc7', './vendor/ckeditor/ckeditor/plugins/print/lang/hr.js', '15.9', 0),
('5d236719e7c7a15f5eeb445ab213a1ff', './vendor/ckeditor/ckeditor/plugins/print/lang/hu.js', '15.9', 0),
('80caf1b093c355287397f4fb1cada44d', './vendor/ckeditor/ckeditor/plugins/print/lang/id.js', '15.9', 0),
('cf5350c9b6cb62f93cb384b5f89e8037', './vendor/ckeditor/ckeditor/plugins/print/lang/is.js', '15.9', 0),
('9b0db63197d69a63b01006ea3c39a6a2', './vendor/ckeditor/ckeditor/plugins/print/lang/it.js', '15.9', 0),
('51b07e95e16aec9f432364d34e0ec533', './vendor/ckeditor/ckeditor/plugins/print/lang/ja.js', '15.9', 0),
('963382d26ce2687a463486ab0247e662', './vendor/ckeditor/ckeditor/plugins/print/lang/ka.js', '15.9', 0),
('dfcd0db911a46c3dbc1668fec8cd9dc1', './vendor/ckeditor/ckeditor/plugins/print/lang/km.js', '15.9', 0),
('e944717682198ca0b179ffbbe6344a3c', './vendor/ckeditor/ckeditor/plugins/print/lang/ko.js', '15.9', 0),
('3d3ce729e7c01b4d7a56089a03a1e473', './vendor/ckeditor/ckeditor/plugins/print/lang/ku.js', '15.9', 0),
('6219bfa27681127265bd9fd2fa7af4c9', './vendor/ckeditor/ckeditor/plugins/print/lang/lt.js', '15.9', 0),
('ffee11995f144a27f101e43a5bc993cf', './vendor/ckeditor/ckeditor/plugins/print/lang/lv.js', '15.9', 0),
('641a23277dfdcc49f68f2b87ae101227', './vendor/ckeditor/ckeditor/plugins/print/lang/mk.js', '15.9', 0),
('e591af836c560a76692fe3911b61b88f', './vendor/ckeditor/ckeditor/plugins/print/lang/mn.js', '15.9', 0),
('09401029779258ce03e96d8b8c17fa31', './vendor/ckeditor/ckeditor/plugins/print/lang/ms.js', '15.9', 0),
('156c3644cfa0dddd1dc2ee076dcbf11a', './vendor/ckeditor/ckeditor/plugins/print/lang/nb.js', '15.9', 0),
('c56261e6e5c6f56290e0c0e9551caa65', './vendor/ckeditor/ckeditor/plugins/print/lang/nl.js', '15.9', 0),
('7b34641110f1bdc6c18c5c82196c176a', './vendor/ckeditor/ckeditor/plugins/print/lang/no.js', '15.9', 0),
('4533301fb63d1019dafb5201acaf904d', './vendor/ckeditor/ckeditor/plugins/print/lang/pl.js', '15.9', 0),
('39255a38a6eb341bd3410df2644a4551', './vendor/ckeditor/ckeditor/plugins/print/lang/pt-br.js', '15.9', 0),
('3a5ba7aaae62b00d68ca21d5af9211a4', './vendor/ckeditor/ckeditor/plugins/print/lang/pt.js', '15.9', 0),
('c1ef4f8f8a15df00eabf10f88aef0f8b', './vendor/ckeditor/ckeditor/plugins/print/lang/ro.js', '15.9', 0),
('5e777a80974d2ea825fa86ae0b3020cc', './vendor/ckeditor/ckeditor/plugins/print/lang/ru.js', '15.9', 0),
('4ebe494c0bed5260ef82d37fd7495f7e', './vendor/ckeditor/ckeditor/plugins/print/lang/si.js', '15.9', 0),
('3f36fc6e1a40004503789b4ec9115993', './vendor/ckeditor/ckeditor/plugins/print/lang/sk.js', '15.9', 0),
('abde19452f2861f5794b99a4ead94da9', './vendor/ckeditor/ckeditor/plugins/print/lang/sl.js', '15.9', 0),
('b89bfafca51fe1d6182764f6c0c6754d', './vendor/ckeditor/ckeditor/plugins/print/lang/sq.js', '15.9', 0),
('c9c107858eeeb71be3a095124f6d05f1', './vendor/ckeditor/ckeditor/plugins/print/lang/sr-latn.js', '15.9', 0),
('472d6530eecb7b82ca5ab3318522aa42', './vendor/ckeditor/ckeditor/plugins/print/lang/sr.js', '15.9', 0),
('715cdcdb70fba4daec357c1ac89fe127', './vendor/ckeditor/ckeditor/plugins/print/lang/sv.js', '15.9', 0),
('45de6ecef5c36f7cd84ed7d3c9d13733', './vendor/ckeditor/ckeditor/plugins/print/lang/th.js', '15.9', 0),
('f52735a4524a6637b6e7d2026db1b5f2', './vendor/ckeditor/ckeditor/plugins/print/lang/tr.js', '15.9', 0),
('20a8bade3ddb661db4c5e4f392ce3142', './vendor/ckeditor/ckeditor/plugins/print/lang/tt.js', '15.9', 0),
('fd6865dca7b97081858b96238928442b', './vendor/ckeditor/ckeditor/plugins/print/lang/ug.js', '15.9', 0),
('fb8920ec40b0b20650ab22fb3b0ae592', './vendor/ckeditor/ckeditor/plugins/print/lang/uk.js', '15.9', 0),
('c308cfeae9b85e54bd0f1ccbe8da0a14', './vendor/ckeditor/ckeditor/plugins/print/lang/vi.js', '15.9', 0),
('2bd2bf576894bd2b70cbff1e99f6a35c', './vendor/ckeditor/ckeditor/plugins/print/lang/zh-cn.js', '15.9', 0),
('5c0739380359cd3051f4a45e5d649b79', './vendor/ckeditor/ckeditor/plugins/print/lang/zh.js', '15.9', 0),
('42d2ccc5d5337c56a2c257866151cd10', './vendor/ckeditor/ckeditor/plugins/print/plugin.js', '15.9', 0),
('df6140d6f371026ec07ee00093c819f0', './vendor/ckeditor/ckeditor/plugins/save/lang/af.js', '15.9', 0),
('057652b2ffdd8f5e69c68c6014771b61', './vendor/ckeditor/ckeditor/plugins/save/lang/ar.js', '15.9', 0),
('1a519a19c9addb4ebcddf0f75f5d9161', './vendor/ckeditor/ckeditor/plugins/save/lang/bg.js', '15.9', 0),
('54f0eaffdeba5acc9d24aff8fc3006f4', './vendor/ckeditor/ckeditor/plugins/save/lang/bn.js', '15.9', 0),
('d78c35f446c7ca2fc9f8dde1bfad4b52', './vendor/ckeditor/ckeditor/plugins/save/lang/bs.js', '15.9', 0),
('d86175a8705354ee8be7f148ff5ab486', './vendor/ckeditor/ckeditor/plugins/save/lang/ca.js', '15.9', 0),
('d2982e28cae181dcf807d82b3c2f3b9e', './vendor/ckeditor/ckeditor/plugins/save/lang/cs.js', '15.9', 0),
('3d7c9fcad15d4276d0c6e0415a727aac', './vendor/ckeditor/ckeditor/plugins/save/lang/cy.js', '15.9', 0),
('913845c191dc4bb1abaf295389ade078', './vendor/ckeditor/ckeditor/plugins/save/lang/da.js', '15.9', 0),
('c2c601cd73ad45463bc44a4897473397', './vendor/ckeditor/ckeditor/plugins/save/lang/de.js', '15.9', 0),
('3e8ed30a766233f1d25901483a04c620', './vendor/ckeditor/ckeditor/plugins/save/lang/el.js', '15.9', 0),
('1a79e32c1bf8a3a17119463a8f50d03e', './vendor/ckeditor/ckeditor/plugins/save/lang/en-au.js', '15.9', 0),
('8de14df2110e004f7fc5d61532a2c017', './vendor/ckeditor/ckeditor/plugins/save/lang/en-ca.js', '15.9', 0),
('ef65e9479899a1c0b97a0441136bd556', './vendor/ckeditor/ckeditor/plugins/save/lang/en-gb.js', '15.9', 0),
('da2d7f5b92d896774d15a51d834ceb79', './vendor/ckeditor/ckeditor/plugins/save/lang/en.js', '15.9', 0),
('ee0bd452ac2d90ec1bfe90a852eb6742', './vendor/ckeditor/ckeditor/plugins/save/lang/eo.js', '15.9', 0),
('95b0208116a381f1946577c16fdebd56', './vendor/ckeditor/ckeditor/plugins/save/lang/es.js', '15.9', 0),
('685c7407be3071266e50a7c9b4e80621', './vendor/ckeditor/ckeditor/plugins/save/lang/et.js', '15.9', 0),
('c1faff110ee8f0a5083a5f39c5200692', './vendor/ckeditor/ckeditor/plugins/save/lang/eu.js', '15.9', 0),
('bb6cabfaec271ee68d90b2868b7d3615', './vendor/ckeditor/ckeditor/plugins/save/lang/fa.js', '15.9', 0),
('ca4cac48aa52c1723626b195b71b4118', './vendor/ckeditor/ckeditor/plugins/save/lang/fi.js', '15.9', 0),
('34e452f7a6483cf9ae956a0f98ebd620', './vendor/ckeditor/ckeditor/plugins/save/lang/fo.js', '15.9', 0),
('234ab75509c9d28989540f237edf86b0', './vendor/ckeditor/ckeditor/plugins/save/lang/fr-ca.js', '15.9', 0),
('0c69fe163f989deb756b7303ef5e4165', './vendor/ckeditor/ckeditor/plugins/save/lang/fr.js', '15.9', 0),
('90649c919ded017bd1c3a175f1ac6fe1', './vendor/ckeditor/ckeditor/plugins/save/lang/gl.js', '15.9', 0),
('6f5626a035c0f02ae8946aa95e9f46d7', './vendor/ckeditor/ckeditor/plugins/save/lang/gu.js', '15.9', 0),
('0f4f7632d07dea65edf5987a484f31e1', './vendor/ckeditor/ckeditor/plugins/save/lang/he.js', '15.9', 0),
('1a7dc323c23a88dd4247ef96a24a279c', './vendor/ckeditor/ckeditor/plugins/save/lang/hi.js', '15.9', 0),
('8349e8f0714a862d9ac98dc4cecd3be3', './vendor/ckeditor/ckeditor/plugins/save/lang/hr.js', '15.9', 0),
('448fa77032f2347f7f67304e369633e4', './vendor/ckeditor/ckeditor/plugins/save/lang/hu.js', '15.9', 0),
('ec855ca51f81065c5feb0c61e91ee0fb', './vendor/ckeditor/ckeditor/plugins/save/lang/id.js', '15.9', 0),
('0ceb4901cd14ccf6d0ec529dc87c68e2', './vendor/ckeditor/ckeditor/plugins/save/lang/is.js', '15.9', 0),
('75b193bd49e3bdbf484e2ad764d24dfc', './vendor/ckeditor/ckeditor/plugins/save/lang/it.js', '15.9', 0),
('266c6b46720a4b8a261c3059558a9da7', './vendor/ckeditor/ckeditor/plugins/save/lang/ja.js', '15.9', 0),
('5f99b5cd95045ca8328f1c99914eec33', './vendor/ckeditor/ckeditor/plugins/save/lang/ka.js', '15.9', 0),
('8ea95236c46ce2a316447255a5721a55', './vendor/ckeditor/ckeditor/plugins/save/lang/km.js', '15.9', 0),
('0f08714e9094447add0ec23ebcc9c3e3', './vendor/ckeditor/ckeditor/plugins/save/lang/ko.js', '15.9', 0),
('14cc5c171e7fdd8c725e26b06122fa64', './vendor/ckeditor/ckeditor/plugins/save/lang/ku.js', '15.9', 0),
('a22b9c70b3323ee08b583ee6148c5372', './vendor/ckeditor/ckeditor/plugins/save/lang/lt.js', '15.9', 0),
('ddc82d109075a9569700b34d10b864c9', './vendor/ckeditor/ckeditor/plugins/save/lang/lv.js', '15.9', 0),
('e0126633b68203a47f8f0be360c2b919', './vendor/ckeditor/ckeditor/plugins/save/lang/mk.js', '15.9', 0),
('1a7b2ad5d30cc8fb468f7c778f9779ed', './vendor/ckeditor/ckeditor/plugins/save/lang/mn.js', '15.9', 0),
('9913a497834643749181b10ff95b5a54', './vendor/ckeditor/ckeditor/plugins/save/lang/ms.js', '15.9', 0),
('2f1681035da75a2d20df0980aaf4df01', './vendor/ckeditor/ckeditor/plugins/save/lang/nb.js', '15.9', 0),
('1d79aadd0c73ddcc83484db188fd0c42', './vendor/ckeditor/ckeditor/plugins/save/lang/nl.js', '15.9', 0),
('d0a279ecec378225e5041ec2b83bf692', './vendor/ckeditor/ckeditor/plugins/save/lang/no.js', '15.9', 0),
('26e9f129e393468aeefa4f304977553f', './vendor/ckeditor/ckeditor/plugins/save/lang/pl.js', '15.9', 0),
('baf47a4174f7769f40a21fae66113e7d', './vendor/ckeditor/ckeditor/plugins/save/lang/pt-br.js', '15.9', 0),
('3292ae65b06e853f288f659b4f603fc5', './vendor/ckeditor/ckeditor/plugins/save/lang/pt.js', '15.9', 0),
('695265d92d4605466f7c579c0222d214', './vendor/ckeditor/ckeditor/plugins/save/lang/ro.js', '15.9', 0),
('4790efd672ecdf6b8adf568f1d02d8a6', './vendor/ckeditor/ckeditor/plugins/save/lang/ru.js', '15.9', 0),
('de70da997b03eaae4dc2281c72ef9f6e', './vendor/ckeditor/ckeditor/plugins/save/lang/si.js', '15.9', 0),
('f57c5dca17f1a571ba0f37c3236e2493', './vendor/ckeditor/ckeditor/plugins/save/lang/sk.js', '15.9', 0),
('f24ba658b16baf86e49b6ee73123bf2c', './vendor/ckeditor/ckeditor/plugins/save/lang/sl.js', '15.9', 0),
('6e8e1f6b3c7bf321c872ca625931a103', './vendor/ckeditor/ckeditor/plugins/save/lang/sq.js', '15.9', 0),
('c856202c45cbf915574c16346595b2c8', './vendor/ckeditor/ckeditor/plugins/save/lang/sr-latn.js', '15.9', 0),
('6416710c205a6c16893a44f1cde34303', './vendor/ckeditor/ckeditor/plugins/save/lang/sr.js', '15.9', 0),
('0b84d0c73d80d8664d6f4f1bfea855b2', './vendor/ckeditor/ckeditor/plugins/save/lang/sv.js', '15.9', 0),
('a868fd178029814ec568a90f76791945', './vendor/ckeditor/ckeditor/plugins/save/lang/th.js', '15.9', 0),
('df71ef19350914de8dc4ee94556ea065', './vendor/ckeditor/ckeditor/plugins/save/lang/tr.js', '15.9', 0),
('628c40ff225794a71e8b0b5250008afa', './vendor/ckeditor/ckeditor/plugins/save/lang/tt.js', '15.9', 0),
('eb6dec9e50318369f15fb73a207d3017', './vendor/ckeditor/ckeditor/plugins/save/lang/ug.js', '15.9', 0),
('e9a2b1e65580d9fd23df5f59f9c70819', './vendor/ckeditor/ckeditor/plugins/save/lang/uk.js', '15.9', 0),
('2b3005f29cd2f8d3b96d9135f96dd3cd', './vendor/ckeditor/ckeditor/plugins/save/lang/vi.js', '15.9', 0),
('9e189dca8f9f1c41ac0d1f6b60f3b3f3', './vendor/ckeditor/ckeditor/plugins/save/lang/zh-cn.js', '15.9', 0),
('a06d151618540e61dbd0d5196a5d7d30', './vendor/ckeditor/ckeditor/plugins/save/lang/zh.js', '15.9', 0),
('752e3f8f18af27c1c12ad2e38c0b86f7', './vendor/ckeditor/ckeditor/plugins/save/plugin.js', '15.9', 0),
('a56ca25171107cbb0b71f73c93636769', './vendor/ckeditor/ckeditor/plugins/scayt/dialogs/options.js', '15.9', 0),
('abb7173bc76c982641101d81cc544ab0', './vendor/ckeditor/ckeditor/plugins/scayt/dialogs/toolbar.css', '15.9', 0),
('724325f00a737f2f228559cc2b68390d', './vendor/ckeditor/ckeditor/plugins/selectall/lang/af.js', '15.9', 0),
('a8ed8708eb8f59f8d9495de8b0962017', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ar.js', '15.9', 0),
('36558fb061fd248948ec798c1186ccc8', './vendor/ckeditor/ckeditor/plugins/selectall/lang/bg.js', '15.9', 0),
('58a883ca998c8ce669dd7b4dedec8abd', './vendor/ckeditor/ckeditor/plugins/selectall/lang/bn.js', '15.9', 0),
('4703a8c2ed871cd86e7ddc9f7b3217db', './vendor/ckeditor/ckeditor/plugins/selectall/lang/bs.js', '15.9', 0),
('85b4443eaf8c8a30158420bda8d6a806', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ca.js', '15.9', 0),
('f394fcadf392295b8b404afab2ba1fce', './vendor/ckeditor/ckeditor/plugins/selectall/lang/cs.js', '15.9', 0),
('4fb23e5960408765bc7de665244df0de', './vendor/ckeditor/ckeditor/plugins/selectall/lang/cy.js', '15.9', 0),
('89ba49b54a61e8d358a22db8ba8a7021', './vendor/ckeditor/ckeditor/plugins/selectall/lang/da.js', '15.9', 0),
('736421bba3e7fc8fcb962aa58abdcb0c', './vendor/ckeditor/ckeditor/plugins/selectall/lang/de.js', '15.9', 0),
('f1875273b7228c1ad3aff29596f5aa28', './vendor/ckeditor/ckeditor/plugins/selectall/lang/el.js', '15.9', 0),
('4475e06e3e45a50b749f778ebd5561f1', './vendor/ckeditor/ckeditor/plugins/selectall/lang/en-au.js', '15.9', 0),
('87ee70bdcd531c0bdab161b1201737ee', './vendor/ckeditor/ckeditor/plugins/selectall/lang/en-ca.js', '15.9', 0),
('6239d9be1b3d970ba6f935b25d0084d6', './vendor/ckeditor/ckeditor/plugins/selectall/lang/en-gb.js', '15.9', 0),
('fc3592753e9ccc9a6948fbec78fa273f', './vendor/ckeditor/ckeditor/plugins/selectall/lang/en.js', '15.9', 0),
('d146dc44800a14c8f49db85cfcb6f663', './vendor/ckeditor/ckeditor/plugins/selectall/lang/eo.js', '15.9', 0),
('51ee544bed0034fc5cf72597854d659b', './vendor/ckeditor/ckeditor/plugins/selectall/lang/es.js', '15.9', 0),
('c6dac391cf8b285eb3237e2e183b680b', './vendor/ckeditor/ckeditor/plugins/selectall/lang/et.js', '15.9', 0),
('0ca7df0d4e09b9f14434fc71bffc50db', './vendor/ckeditor/ckeditor/plugins/selectall/lang/eu.js', '15.9', 0),
('6205267fef9a5630715677ce0aa23ac1', './vendor/ckeditor/ckeditor/plugins/selectall/lang/fa.js', '15.9', 0),
('6334dec1f896cddcc392339df08e22ea', './vendor/ckeditor/ckeditor/plugins/selectall/lang/fi.js', '15.9', 0),
('060f3ae070656fe39dc6e4874ea50655', './vendor/ckeditor/ckeditor/plugins/selectall/lang/fo.js', '15.9', 0),
('30984322e5e2a6de069d10b4e53ecb6d', './vendor/ckeditor/ckeditor/plugins/selectall/lang/fr-ca.js', '15.9', 0),
('7f4fbb8831d68d01c19d8b8508f96a0f', './vendor/ckeditor/ckeditor/plugins/selectall/lang/fr.js', '15.9', 0),
('39594304f9ff52deb5a74e1634b33020', './vendor/ckeditor/ckeditor/plugins/selectall/lang/gl.js', '15.9', 0),
('f1c8d831c0875d61c2f5b16a6fd45432', './vendor/ckeditor/ckeditor/plugins/selectall/lang/gu.js', '15.9', 0),
('459742f0d9520d50c3f6a2e316bd40f1', './vendor/ckeditor/ckeditor/plugins/selectall/lang/he.js', '15.9', 0),
('3c4f6f8056eabdf219139884e95fd8a4', './vendor/ckeditor/ckeditor/plugins/selectall/lang/hi.js', '15.9', 0),
('6074cd0d794720cd089c3f23ad2ca127', './vendor/ckeditor/ckeditor/plugins/selectall/lang/hr.js', '15.9', 0),
('e3432f473809b36725056d1d2f3df8e3', './vendor/ckeditor/ckeditor/plugins/selectall/lang/hu.js', '15.9', 0),
('20186f1bb6d76bed8603a0ff6a5da789', './vendor/ckeditor/ckeditor/plugins/selectall/lang/id.js', '15.9', 0),
('643b47c4b0210dd79fdd61462338d152', './vendor/ckeditor/ckeditor/plugins/selectall/lang/is.js', '15.9', 0),
('9964de82d4585c1f3cde179450c0948e', './vendor/ckeditor/ckeditor/plugins/selectall/lang/it.js', '15.9', 0),
('475836440a698b80f8ab417f64f5d5e6', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ja.js', '15.9', 0),
('3bb94cddf188211b6f77fde3597d2467', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ka.js', '15.9', 0),
('58f03d3ffe05559a19c8feed5ba28b48', './vendor/ckeditor/ckeditor/plugins/selectall/lang/km.js', '15.9', 0),
('9834418862263ce96e6bff47b034e28f', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ko.js', '15.9', 0),
('109123874d165d6425abeaadbff2865d', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ku.js', '15.9', 0),
('ba49b6ae22d140301cd641a9bec02116', './vendor/ckeditor/ckeditor/plugins/selectall/lang/lt.js', '15.9', 0),
('112a961397289f2b0c3c01204f9b5b9c', './vendor/ckeditor/ckeditor/plugins/selectall/lang/lv.js', '15.9', 0),
('ff37276ef3d1ad85526cf812a8b13da7', './vendor/ckeditor/ckeditor/plugins/selectall/lang/mk.js', '15.9', 0),
('54d7c14d2ea8511839fe0222a722ec02', './vendor/ckeditor/ckeditor/plugins/selectall/lang/mn.js', '15.9', 0),
('81d3533210fa4fbd3a21a24f388e7f82', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ms.js', '15.9', 0),
('7d8b779164f8224ea775901da6da5c37', './vendor/ckeditor/ckeditor/plugins/selectall/lang/nb.js', '15.9', 0),
('c1d427f61f2e68a13f954fcb6dca744c', './vendor/ckeditor/ckeditor/plugins/selectall/lang/nl.js', '15.9', 0),
('3ff0cde5986bb673211843d4162d90bf', './vendor/ckeditor/ckeditor/plugins/selectall/lang/no.js', '15.9', 0),
('d2067d1ac5c5fd06d42561a2a82fae12', './vendor/ckeditor/ckeditor/plugins/selectall/lang/pl.js', '15.9', 0),
('61058e1b34dda3deb7f19b9c062234a3', './vendor/ckeditor/ckeditor/plugins/selectall/lang/pt-br.js', '15.9', 0),
('f9e7334212114f356e1fdd6bad325ff2', './vendor/ckeditor/ckeditor/plugins/selectall/lang/pt.js', '15.9', 0),
('7fb1f312cccd875fa64b9fef72f1a360', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ro.js', '15.9', 0),
('988a265733cd3ec4a9b82e069990364c', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ru.js', '15.9', 0),
('7dc91e43c7bacb23de8ae89ddc4897ce', './vendor/ckeditor/ckeditor/plugins/selectall/lang/si.js', '15.9', 0),
('87c05ad812477cabaaeaa9bed425c54b', './vendor/ckeditor/ckeditor/plugins/selectall/lang/sk.js', '15.9', 0),
('7788c0b70c49ed441b9d32a1261cc370', './vendor/ckeditor/ckeditor/plugins/selectall/lang/sl.js', '15.9', 0),
('7fdc892f253462c4c5bec79d8c4b85ee', './vendor/ckeditor/ckeditor/plugins/selectall/lang/sq.js', '15.9', 0),
('f4faee6a8ba321d168a427abaaa747b0', './vendor/ckeditor/ckeditor/plugins/selectall/lang/sr-latn.js', '15.9', 0),
('ef689cd84870e22a02873a182812f721', './vendor/ckeditor/ckeditor/plugins/selectall/lang/sr.js', '15.9', 0),
('d4f46e06c711172fdf48988aed97cc5f', './vendor/ckeditor/ckeditor/plugins/selectall/lang/sv.js', '15.9', 0),
('487c21f89b7ace9cd60705b105c50791', './vendor/ckeditor/ckeditor/plugins/selectall/lang/th.js', '15.9', 0),
('5b5859c44075be91fcb402952f3a8638', './vendor/ckeditor/ckeditor/plugins/selectall/lang/tr.js', '15.9', 0),
('b36759cb2dc02b5ecbec6a329022fe76', './vendor/ckeditor/ckeditor/plugins/selectall/lang/tt.js', '15.9', 0),
('9730a4dc076a99179f4ff9f8d55a226c', './vendor/ckeditor/ckeditor/plugins/selectall/lang/ug.js', '15.9', 0),
('58bb178e8da578ab1aa976d6ebb58081', './vendor/ckeditor/ckeditor/plugins/selectall/lang/uk.js', '15.9', 0),
('9a4e229f9d54533a8d453dba5314cb25', './vendor/ckeditor/ckeditor/plugins/selectall/lang/vi.js', '15.9', 0),
('ad00b9b2cb7f246c475d3efa6bbbb628', './vendor/ckeditor/ckeditor/plugins/selectall/lang/zh-cn.js', '15.9', 0),
('cd49c4d3f3dbf2f7f1153c8d9700db57', './vendor/ckeditor/ckeditor/plugins/selectall/lang/zh.js', '15.9', 0),
('5923d767066c9b82bed0f38bab714f8f', './vendor/ckeditor/ckeditor/plugins/selectall/plugin.js', '15.9', 0),
('16dabb52f622bf937eaed9b425051247', './vendor/ckeditor/ckeditor/plugins/sharedspace/plugin.js', '15.9', 0),
('365ebe289894d3e11f5f512d77f58065', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/af.js', '15.9', 0),
('6b307024de5165e5212eba78a7f73686', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ar.js', '15.9', 0),
('54b804c0de766da3a726fa3678e45673', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/bg.js', '15.9', 0),
('81ec087e95434313dc06c20df8ae0f81', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/bn.js', '15.9', 0),
('435e8b6ef98917b39cc36ba70080c2f3', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/bs.js', '15.9', 0),
('98d5c729efd6f951f5a08370dd9fc45f', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ca.js', '15.9', 0),
('6ae1df4040d873a82e5c79936781e650', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/cs.js', '15.9', 0),
('48d36612f999aa20167629d6139c5d27', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/cy.js', '15.9', 0),
('586c33d34f42c747ec2ce8b621fd4d8e', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/da.js', '15.9', 0),
('90f6c65a9a361dc02b7b51802d8a65c7', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/de.js', '15.9', 0),
('1bb163a202a10e3e717b34c28828dbc6', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/el.js', '15.9', 0),
('224133807193e77dba0c9d4d3b7aea26', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/en-au.js', '15.9', 0),
('798ba7ac5368e84283edaa41f6ef834e', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/en-ca.js', '15.9', 0),
('bf60d366dd5cf7c8d06321665fc417dc', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/en-gb.js', '15.9', 0),
('c897a4d947d8db99a706295cc62e8584', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/en.js', '15.9', 0),
('ff266d113a232df97552e3ea64610d9e', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/eo.js', '15.9', 0),
('c39e898033f7622fee0c20522f828258', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/es.js', '15.9', 0),
('e1089703243b6861310c3c976a6679f9', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/et.js', '15.9', 0),
('9442c44be5ec4aa52d4dbeb39c0dc89d', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/eu.js', '15.9', 0),
('298a76e83387615a528793cb71de4927', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/fa.js', '15.9', 0),
('60db5da742703842faad559d58dbc9d4', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/fi.js', '15.9', 0),
('44571783a0dffc7d165bc9d2bd574fb9', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/fo.js', '15.9', 0),
('22932d256b8974ba7bb2d734cca9f264', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/fr-ca.js', '15.9', 0),
('3df5db7f00580eed91ff193bcd38d772', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/fr.js', '15.9', 0),
('835996f9a652ef4f7d6848eee0401432', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/gl.js', '15.9', 0),
('33c85685098eb1e5d0d0c51498c3aa00', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/gu.js', '15.9', 0),
('4fe59d3b2fcfeed747879ec212c7e423', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/he.js', '15.9', 0),
('b7742494f65d7ec67e8efceeff1d03cd', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/hi.js', '15.9', 0),
('2cbdb1f65ad891339463a05cf8c7e2c7', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/hr.js', '15.9', 0),
('ac02d9b606721d85f2b2867cfbc48af7', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/hu.js', '15.9', 0),
('15363fcef60d02c690a9dc1e039fc7d9', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/id.js', '15.9', 0),
('1d55ddfea67a8a0bfa3852e1ddf8e3eb', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/is.js', '15.9', 0),
('835664b5eb8988719710316c5e190712', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/it.js', '15.9', 0),
('81b7346b706e4ffd1f8a85e60bb9796e', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ja.js', '15.9', 0),
('3ad935b249ebfe7b43fcdcc3795945f8', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ka.js', '15.9', 0),
('75dd8a49e7e0ccf2b133262b737e3d92', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/km.js', '15.9', 0),
('c87fe5c851ebdc86bf2c126216e7aaf8', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ko.js', '15.9', 0),
('e22f288c8a8ef80104570f6163fe8928', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ku.js', '15.9', 0),
('6030d03ac0bb21b1a435e46a17ed8d0e', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/lt.js', '15.9', 0),
('239ff427954d4b7de5cf2bef41d5bb7d', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/lv.js', '15.9', 0),
('22404f27d769138188d7e15dbd2483d7', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/mk.js', '15.9', 0),
('7aa0e87943f74aabb3af24b95441cb99', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/mn.js', '15.9', 0),
('5e3522e34ceba423c669a81e59f76afe', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ms.js', '15.9', 0),
('f3adffdbbc2fbc5ce55643689f92b65d', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/nb.js', '15.9', 0),
('70908f289b0fbe4d615611fec83189fa', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/nl.js', '15.9', 0),
('aa4116d58142c5942e089db050244015', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/no.js', '15.9', 0),
('6912f3f36441f7bab49dadc81d7ef79f', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/pl.js', '15.9', 0),
('217837613f7155e36346bdd26fe6cab1', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/pt-br.js', '15.9', 0),
('58fe207f4a43be7ce959e9274986ff4f', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/pt.js', '15.9', 0),
('ba3c04b1fe293173558be619fd125860', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ro.js', '15.9', 0),
('913919b07d38838bebdfd2be8d232a68', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ru.js', '15.9', 0),
('aeab5d76926e1848aa41b29c5575b45e', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/si.js', '15.9', 0),
('fe5a56e5ad0050de61fde25def82a722', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/sk.js', '15.9', 0),
('6feb71a9033e93856f9e86b64200f773', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/sl.js', '15.9', 0),
('9668cfbfbb63715fb6764105134d07a2', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/sq.js', '15.9', 0),
('a2bf2e5eab761498bc4d4900358f342f', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/sr-latn.js', '15.9', 0),
('96de322334b7d0db05d43ff5760acabe', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/sr.js', '15.9', 0),
('9d3b5838ae951ee2c4c1b567211d05c7', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/sv.js', '15.9', 0),
('30c6652baf18f81affe8b081879d8909', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/th.js', '15.9', 0),
('5e6cf9456fa4dd4234f54f9c3cdb11dd', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/tr.js', '15.9', 0),
('f895b6f31b8bb4677ec0fb0a21ab2c33', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/tt.js', '15.9', 0),
('069ef52ad726aa29981d26789bfddac7', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/ug.js', '15.9', 0),
('17e000b3176436ccb39be0bc30552554', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/uk.js', '15.9', 0),
('65bc1943fd54fbffbed93ec24cb64a3d', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/vi.js', '15.9', 0),
('5850ebab116bf7c13f202efc6eee50d6', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/zh-cn.js', '15.9', 0),
('c611493e6a01a9f2c8f1d2dd275cadf2', './vendor/ckeditor/ckeditor/plugins/showblocks/lang/zh.js', '15.9', 0),
('ff0865d34000d713966c65258516d8d1', './vendor/ckeditor/ckeditor/plugins/showblocks/plugin.js', '15.9', 0),
('64923ff728cd634f1d71babcbd0bb3f8', './vendor/ckeditor/ckeditor/plugins/smiley/dialogs/smiley.js', '15.9', 0),
('ad9a172e8c0928413754a01bf756171f', './vendor/ckeditor/ckeditor/plugins/smiley/lang/af.js', '15.9', 0),
('dfce36a7f50c86a3be2142460c388e13', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ar.js', '15.9', 0),
('2dc4604c29bd0a3c2acdf7b80c5bfec6', './vendor/ckeditor/ckeditor/plugins/smiley/lang/bg.js', '15.9', 0),
('33537347001557648cddf459eb5b06f2', './vendor/ckeditor/ckeditor/plugins/smiley/lang/bn.js', '15.9', 0),
('652a9fc7907a0f704371235022fd1035', './vendor/ckeditor/ckeditor/plugins/smiley/lang/bs.js', '15.9', 0),
('303ded43f0b8d08d539aea9bfa87d512', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ca.js', '15.9', 0),
('429c5bf85b8f8ae287a709ca3851780a', './vendor/ckeditor/ckeditor/plugins/smiley/lang/cs.js', '15.9', 0),
('cf56aa3c6eee95d36cf037fabb7123a7', './vendor/ckeditor/ckeditor/plugins/smiley/lang/cy.js', '15.9', 0),
('cd85e6cf7480d7ba1522b308af31ebc6', './vendor/ckeditor/ckeditor/plugins/smiley/lang/da.js', '15.9', 0),
('0916f59256710b869d2c8c2e36ab83c7', './vendor/ckeditor/ckeditor/plugins/smiley/lang/de.js', '15.9', 0),
('cb1c3929b6ccdec67e380814523ff18b', './vendor/ckeditor/ckeditor/plugins/smiley/lang/el.js', '15.9', 0),
('2b9a57c04069c0f96eca37012f3811b3', './vendor/ckeditor/ckeditor/plugins/smiley/lang/en-au.js', '15.9', 0),
('fbd51f368f6a25e868f9248650a45a38', './vendor/ckeditor/ckeditor/plugins/smiley/lang/en-ca.js', '15.9', 0),
('0b940a6d8c63ad4827e9a0972744b89a', './vendor/ckeditor/ckeditor/plugins/smiley/lang/en-gb.js', '15.9', 0),
('ce0ab3ddc82644e2f6b5d5da673c8fa3', './vendor/ckeditor/ckeditor/plugins/smiley/lang/en.js', '15.9', 0),
('e79cab87b1c4f0c087d21e785301d253', './vendor/ckeditor/ckeditor/plugins/smiley/lang/eo.js', '15.9', 0),
('912936777830e5a890b85e486081f022', './vendor/ckeditor/ckeditor/plugins/smiley/lang/es.js', '15.9', 0),
('9d84bc5b4a88774475375b9f5f84d511', './vendor/ckeditor/ckeditor/plugins/smiley/lang/et.js', '15.9', 0),
('d94365ed3b3f5f02fbc4fcb1756e6ee9', './vendor/ckeditor/ckeditor/plugins/smiley/lang/eu.js', '15.9', 0),
('e28f6f0b54d382e16d343e97452784f3', './vendor/ckeditor/ckeditor/plugins/smiley/lang/fa.js', '15.9', 0),
('c4233d0a148ff60cfbdcbd4214cbc12f', './vendor/ckeditor/ckeditor/plugins/smiley/lang/fi.js', '15.9', 0),
('4feee6756643d7d5f352d70ac9720af9', './vendor/ckeditor/ckeditor/plugins/smiley/lang/fo.js', '15.9', 0),
('6adff0362fdf08e78d5869c80f62ba19', './vendor/ckeditor/ckeditor/plugins/smiley/lang/fr-ca.js', '15.9', 0),
('0d2bdfac110c7868b4d6af9808168234', './vendor/ckeditor/ckeditor/plugins/smiley/lang/fr.js', '15.9', 0),
('e70070ea8fa1a7a447dd6f4be9bead91', './vendor/ckeditor/ckeditor/plugins/smiley/lang/gl.js', '15.9', 0),
('fbee9a91c2dc6e69399998bc5fbeed94', './vendor/ckeditor/ckeditor/plugins/smiley/lang/gu.js', '15.9', 0),
('6495515fd7bf91b93fbcf91cbe541857', './vendor/ckeditor/ckeditor/plugins/smiley/lang/he.js', '15.9', 0),
('4b36ea0b07197cd52753bfecb4926645', './vendor/ckeditor/ckeditor/plugins/smiley/lang/hi.js', '15.9', 0),
('32a96d5b1597fa2ca2731c51ede66261', './vendor/ckeditor/ckeditor/plugins/smiley/lang/hr.js', '15.9', 0),
('a810fdb70afdfc7359b200c1d47f70bd', './vendor/ckeditor/ckeditor/plugins/smiley/lang/hu.js', '15.9', 0),
('6a3050c14b810a23d05fb92f6e32738b', './vendor/ckeditor/ckeditor/plugins/smiley/lang/id.js', '15.9', 0),
('ad4471598d459686f16a5fb92f4f6bb5', './vendor/ckeditor/ckeditor/plugins/smiley/lang/is.js', '15.9', 0),
('1e0a0b4badf12bd20f425ce40fd4b157', './vendor/ckeditor/ckeditor/plugins/smiley/lang/it.js', '15.9', 0),
('668077e9e96e403bc214f601e6016b35', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ja.js', '15.9', 0),
('6f11b26c95f20e4b50780b83d3b12690', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ka.js', '15.9', 0),
('29b14d646e7f1548dfdd61b40600c5d5', './vendor/ckeditor/ckeditor/plugins/smiley/lang/km.js', '15.9', 0),
('85f4177bec430b5617191c066ddded85', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ko.js', '15.9', 0),
('3c9327a03b6c0f65c6c33af3f14592f0', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ku.js', '15.9', 0),
('0e12dd24ee9549c514c51112d793325d', './vendor/ckeditor/ckeditor/plugins/smiley/lang/lt.js', '15.9', 0),
('8ca40c2bd6a5c71c4c0450e17985609c', './vendor/ckeditor/ckeditor/plugins/smiley/lang/lv.js', '15.9', 0),
('46604c01f49f6b895567384215c2b71f', './vendor/ckeditor/ckeditor/plugins/smiley/lang/mk.js', '15.9', 0),
('bd6a299edfb57d833049bcf6b684fee6', './vendor/ckeditor/ckeditor/plugins/smiley/lang/mn.js', '15.9', 0),
('0edb8557ebdb4b91de8a622ff496329d', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ms.js', '15.9', 0),
('137359cc2e4fbac2ac5d05b5d422045c', './vendor/ckeditor/ckeditor/plugins/smiley/lang/nb.js', '15.9', 0),
('9a24c2cb6ffe8ea17f1514dab9e64a94', './vendor/ckeditor/ckeditor/plugins/smiley/lang/nl.js', '15.9', 0),
('8f0fc54955a6cc6591e720258c0ec389', './vendor/ckeditor/ckeditor/plugins/smiley/lang/no.js', '15.9', 0),
('2e975e4ba6369e72d05235f8b29a8bd7', './vendor/ckeditor/ckeditor/plugins/smiley/lang/pl.js', '15.9', 0),
('71d9d3e1b3be5e20971f32142665c028', './vendor/ckeditor/ckeditor/plugins/smiley/lang/pt-br.js', '15.9', 0),
('c72846ba6936bc3921616134f4434ae8', './vendor/ckeditor/ckeditor/plugins/smiley/lang/pt.js', '15.9', 0),
('5822bdc275ad5520eb23648f667f58d3', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ro.js', '15.9', 0),
('407a6bffe107afb575e08f119e491c6c', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ru.js', '15.9', 0),
('92d2403f39c4a6be379861dbd22b3d59', './vendor/ckeditor/ckeditor/plugins/smiley/lang/si.js', '15.9', 0),
('b8ee309641061143fb2448916c950e9e', './vendor/ckeditor/ckeditor/plugins/smiley/lang/sk.js', '15.9', 0),
('020c18486ffa3fa4f49c3f4fd927ae1b', './vendor/ckeditor/ckeditor/plugins/smiley/lang/sl.js', '15.9', 0),
('94b5dfee4756e8b566f650666c01007b', './vendor/ckeditor/ckeditor/plugins/smiley/lang/sq.js', '15.9', 0),
('08eb5775d72e70c7a6ad59887365c8b5', './vendor/ckeditor/ckeditor/plugins/smiley/lang/sr-latn.js', '15.9', 0),
('dcfeb6779a9ad53928f88ef63384e008', './vendor/ckeditor/ckeditor/plugins/smiley/lang/sr.js', '15.9', 0),
('86518fd7646085b2083ca09852c61605', './vendor/ckeditor/ckeditor/plugins/smiley/lang/sv.js', '15.9', 0),
('063579124f9aed81c4a1540bca48f139', './vendor/ckeditor/ckeditor/plugins/smiley/lang/th.js', '15.9', 0),
('a62e9ded5971adfff9216834ef7f5a47', './vendor/ckeditor/ckeditor/plugins/smiley/lang/tr.js', '15.9', 0),
('b4f63e5e144e9bd9c9524ae4b1b9ce4e', './vendor/ckeditor/ckeditor/plugins/smiley/lang/tt.js', '15.9', 0),
('99f71162a2f0dd42e0219aa99e85ddd1', './vendor/ckeditor/ckeditor/plugins/smiley/lang/ug.js', '15.9', 0),
('2e6c3f7bbb67855d9f574c6371e2da35', './vendor/ckeditor/ckeditor/plugins/smiley/lang/uk.js', '15.9', 0),
('3ac6cdf79abfcc73c8840d49de4da4a2', './vendor/ckeditor/ckeditor/plugins/smiley/lang/vi.js', '15.9', 0),
('7f0335ad0c3d3e0a84ae11dc98fd958d', './vendor/ckeditor/ckeditor/plugins/smiley/lang/zh-cn.js', '15.9', 0),
('5a5757ebb1d48f3ebcfedc030db3aadf', './vendor/ckeditor/ckeditor/plugins/smiley/lang/zh.js', '15.9', 0),
('afb8c48c339e0118c24a7deab372b4b0', './vendor/ckeditor/ckeditor/plugins/smiley/plugin.js', '15.9', 0),
('4784e576b8b5cc5bb7f604aad34b7c46', './vendor/ckeditor/ckeditor/plugins/sourcedialog/dialogs/sourcedialog.js', '15.9', 0),
('d6670ce493e569b0acbb66fb6da7513a', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/af.js', '15.9', 0),
('b3b80f98b19e5d27554b9e4365cbee1e', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ar.js', '15.9', 0),
('b5ab2fb6cd69ac030e8c73d8e662ffd7', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/bg.js', '15.9', 0),
('6d61c2d18d350341191eeea90f81e444', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/bn.js', '15.9', 0),
('65f8c1b26476a4010c76b48b16405a07', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/bs.js', '15.9', 0),
('be7c97380c24fd5d45f3481bfa53b52b', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ca.js', '15.9', 0),
('6c1988cb9d5555a1db586baf102cd510', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/cs.js', '15.9', 0),
('798d1bd12e45a0dafab0b744c5eeb996', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/cy.js', '15.9', 0),
('67779fc3055fa30f722eee1f64227c8e', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/da.js', '15.9', 0),
('7f3d398f685e2354992cecabcbd77fa4', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/de.js', '15.9', 0),
('cdbe79fcf08bc30d0ba26faebeb70a35', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/el.js', '15.9', 0),
('f2d798a4b6fd40018426ab52dfd01dfa', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/en-au.js', '15.9', 0),
('f9ba2cc3d025fc3b928460cbc0e8b714', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/en-ca.js', '15.9', 0),
('a95275a414255abc2cd6379b8be98398', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/en-gb.js', '15.9', 0),
('8e9ae4fe67748f02bcee908be73764e4', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/en.js', '15.9', 0),
('6986287cba81269df61a4aff4b85287c', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/eo.js', '15.9', 0),
('ca2c2114882d5b16ce520298b944762b', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/es.js', '15.9', 0),
('e86c6b5097e8d58e68a3eab2aa73616e', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/et.js', '15.9', 0),
('100e1ef9a47416ab442793ed10f2b0e3', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/eu.js', '15.9', 0),
('8f187cb16ff39546e65921193ada0289', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/fa.js', '15.9', 0),
('562982728fc9da0d34f444c95aa3e9b5', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/fi.js', '15.9', 0),
('4dc4e82ea29a1783bdb51a4687874f86', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/fo.js', '15.9', 0),
('b7f01b8ef90ebd8aa8d112c204893ab2', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/fr-ca.js', '15.9', 0),
('1bced1f4a4e3ff1afb433bbac256854c', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/fr.js', '15.9', 0),
('61f50eba4cefe463b512ded2ece61c3f', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/gl.js', '15.9', 0),
('05a25799c8f4008faab90baded803687', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/gu.js', '15.9', 0),
('9bb41ae33b070061939343f2e05f0911', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/he.js', '15.9', 0),
('594fff9d00865189e96583572b7fc1f7', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/hi.js', '15.9', 0),
('02a995aa8d2ca0df8e6304b84cb23e5f', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/hr.js', '15.9', 0),
('500cb99121f5a95fb5bac898064b2379', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/hu.js', '15.9', 0),
('8b6736f22dfd99af18445fb726ce8af3', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/id.js', '15.9', 0),
('50856e5df4f6cb5518441c86a77c950a', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/is.js', '15.9', 0),
('858991682271eb4654844c0108bbcc89', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/it.js', '15.9', 0),
('f21f228464d61b9352eab2f4edf2ee57', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ja.js', '15.9', 0),
('0e6908469caac982f73f84e879fd6eff', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ka.js', '15.9', 0),
('f0b6b965dbd217ff896c252945a8c11b', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/km.js', '15.9', 0),
('084c04423ede4b4a9dfba2b133c95a7b', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ko.js', '15.9', 0),
('4e50352c4106219cdbef0984aed5c11b', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ku.js', '15.9', 0),
('380e15f0a8522f8236e045e257cde9ea', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/lt.js', '15.9', 0),
('7b07ed834fd8d1d6d23601d831c8aacf', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/lv.js', '15.9', 0),
('2d5b4699c44f9fd538e8a1cbc0aa2ead', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/mn.js', '15.9', 0),
('ef54b653b8c36dabbfb402b53c749ac1', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ms.js', '15.9', 0),
('1c3c2481d0720621d17b6ca40965ee29', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/nb.js', '15.9', 0),
('00ed6234726a1b25e867c32f026bf195', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/nl.js', '15.9', 0),
('bb91c42ae7db516c1a6071901c1246a5', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/no.js', '15.9', 0),
('d50c4ce542c612525b4c328ec765b6a6', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/pl.js', '15.9', 0),
('ae9a4e979623e5d79a7b75996e2d41f4', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/pt-br.js', '15.9', 0),
('f25368a169a568f7c6065f4dae163c19', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/pt.js', '15.9', 0),
('89e13b426002c07cb2c0aa578cb4661b', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ro.js', '15.9', 0),
('41c44d60194eda5734ef5fcf5d44006c', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ru.js', '15.9', 0),
('212d03c8c05cfe303633804841c590b3', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/si.js', '15.9', 0),
('a56f5c9eb5111f4d1a802b4fea8dd2cf', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/sk.js', '15.9', 0),
('669e0a6261166907ed0ed4835f7101b0', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/sl.js', '15.9', 0),
('7b942a5825eaa65d78034952834cc86b', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/sq.js', '15.9', 0),
('3874fcba666c836bcb42f749a002ea56', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/sr-latn.js', '15.9', 0),
('95d930ecbeb0df0fbece70527d6144de', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/sr.js', '15.9', 0),
('282a0bea9e6dbf96a6a37ae2e3dbf491', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/sv.js', '15.9', 0),
('54942dceb8b5eb0c689984502553694c', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/th.js', '15.9', 0),
('b9219a25f8978120e5edaa59f230e92d', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/tr.js', '15.9', 0),
('0242d902f4faa27fe495da3c29fefbdf', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/tt.js', '15.9', 0),
('8d2fe258c454fb0b12065d6494628a24', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/ug.js', '15.9', 0),
('b6551f4293d049bee294b0790d310274', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/uk.js', '15.9', 0),
('3e52cc191707bce7582789ce3e3a62ea', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/vi.js', '15.9', 0),
('632d8cf800ce1ebb5ea0532466d2d44d', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/zh-cn.js', '15.9', 0),
('3dffd7e01551a3afd69edc733e1ea4c6', './vendor/ckeditor/ckeditor/plugins/sourcedialog/lang/zh.js', '15.9', 0),
('6eb26f116c8ac501912ce54188aba7c3', './vendor/ckeditor/ckeditor/plugins/sourcedialog/plugin.js', '15.9', 0),
('24ec5222d3ab01788f5a30ccd46ef0be', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/af.js', '15.9', 0),
('52a99c7cef077b0fa66b1eede6aa7c14', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/ar.js', '15.9', 0),
('82592765faeefa173ad58361444f03f7', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/bg.js', '15.9', 0),
('45a5aec2414cf0787a1d5c698234a8dc', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/ca.js', '15.9', 0),
('82bc04b6ec1613b90ffb519bddbced72', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/cs.js', '15.9', 0),
('71a8b0f0ba2e511c5c652c899ffc7fcf', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/cy.js', '15.9', 0),
('2b40691c8e25814b33f3f07ef53d3f4f', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/da.js', '15.9', 0),
('2045c36a1918fa21a03eeb4e0e70a493', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/de.js', '15.9', 0),
('8479ae81d006cee0456ebd98ccd47a9d', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/el.js', '15.9', 0),
('4b961339161af10ce5238430e418b45a', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/en-gb.js', '15.9', 0),
('97abd9819022ddd7aeee216055f8a338', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/en.js', '15.9', 0),
('1f21789957bd4bb3ea94531aa75cf2bf', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/eo.js', '15.9', 0),
('d81c0bdd6d06dd746dafd7af0c070758', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/es.js', '15.9', 0),
('9f564ac24e149835ab118d03a8bd8893', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/et.js', '15.9', 0),
('cace451fcc3729c0b2429face8219b28', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/eu.js', '15.9', 0),
('651e760c404623e498cfed999a569447', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/fa.js', '15.9', 0),
('081a2a13b0be27370a2dc44d31c234dc', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/fi.js', '15.9', 0),
('37b9f2771c764937f92c6386ecf6770d', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/fr-ca.js', '15.9', 0),
('2817e1e9cf53b4a9d8f35efa008068f4', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/fr.js', '15.9', 0),
('9681350c72560ec3df73369951d1be83', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/gl.js', '15.9', 0),
('92cfe83824d5c908bcb03d9556903f2d', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/he.js', '15.9', 0),
('7ac5625adc7073821486c78dd43374e9', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/hr.js', '15.9', 0),
('4d155b9ac953edbda48a984b3132b682', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/hu.js', '15.9', 0),
('d45207e0b2aaba515cc0eb1bac28f2fa', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/id.js', '15.9', 0),
('a43afedb535b1724c05649c01863e893', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/it.js', '15.9', 0),
('ff62ba13363eb7ad2b8a6fce0f9be9ff', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/ja.js', '15.9', 0),
('6f478aeb273dc46ffb69110d1d129d2f', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/km.js', '15.9', 0),
('4d61ba7f7c7780f96552f4ef8ccb0cb1', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/ko.js', '15.9', 0),
('c2b909d2f23baa4a2117911176d167fd', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/ku.js', '15.9', 0),
('8e91086769bcdf1e9b89020e29de83e1', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/lt.js', '15.9', 0),
('54cd39c2f1ef38716001f026f815fc09', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/lv.js', '15.9', 0),
('330cf8b7028f94f664967c40e58404e1', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/nb.js', '15.9', 0),
('b44365b537ac45b8087aa08dfd2b1f79', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/nl.js', '15.9', 0),
('d9625184508242a1214f2415648c16e6', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/no.js', '15.9', 0),
('391e32b7255f929363d0f723730fbcba', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/pl.js', '15.9', 0),
('e169d60315d4d6b6431223b4a63743dd', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/pt-br.js', '15.9', 0),
('9ab7a0bef4833f00eb4f4309652f2577', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/pt.js', '15.9', 0),
('b02611ae72789b2102d26c1c9b9322c0', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/ru.js', '15.9', 0),
('ba61049fbdafb2fa5780a115b2556329', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/si.js', '15.9', 0),
('a4e614ef3bad0f2081fcc4415f414cbf', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/sk.js', '15.9', 0),
('47aaa1d21f24af375bbb6f18d05e273a', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/sl.js', '15.9', 0),
('60fc7cc7093b9405b35c7d15b2e4734f', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/sq.js', '15.9', 0),
('f109b9adc2bff763dbd3979e19390d53', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/sv.js', '15.9', 0),
('5013da09cfbeb179a26f598686790cca', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/th.js', '15.9', 0),
('e04c84d4360fe037468486b1aa1ba312', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/tr.js', '15.9', 0),
('514e32a43f0b3c46f697bd3f20d9510c', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/tt.js', '15.9', 0),
('025ca0878c7cc01ec27cae03a76eba32', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/ug.js', '15.9', 0),
('b3cd538c4c71bd660c85fcf82ee404ca', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/uk.js', '15.9', 0),
('cec744018b6e858ce3da6da941912213', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/vi.js', '15.9', 0),
('338af7351fe1f73bef102a2835a88bad', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/zh-cn.js', '15.9', 0),
('dc58d7b76fbc2f1399501ac4e78c222a', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/lang/zh.js', '15.9', 0),
('4c388ab58a321a3f15c8e95c96159cf5', './vendor/ckeditor/ckeditor/plugins/specialchar/dialogs/specialchar.js', '15.9', 0),
('e25f68485e7829c9fa8ae3cdaa5b4234', './vendor/ckeditor/ckeditor/plugins/stylesheetparser/plugin.js', '15.9', 0),
('be57c03179a58303af74f5a0cc2732ff', './vendor/ckeditor/ckeditor/plugins/table/dialogs/table.js', '15.9', 0),
('d17d59adf2fb57a9d090320f533649ee', './vendor/ckeditor/ckeditor/plugins/tableresize/plugin.js', '15.9', 0),
('e5b309fbc0c4564944d850a5e968a71b', './vendor/ckeditor/ckeditor/plugins/tabletools/dialogs/tableCell.js', '15.9', 0),
('9c6bf763561eba4ea77e50a09011d953', './vendor/ckeditor/ckeditor/plugins/templates/dialogs/templates.css', '15.9', 0),
('47c14c84da3922a1e751aef47e7fc90f', './vendor/ckeditor/ckeditor/plugins/templates/dialogs/templates.js', '15.9', 0),
('33058026c90d0cc31e0fab2b8b7abd24', './vendor/ckeditor/ckeditor/plugins/templates/lang/af.js', '15.9', 0),
('f439f58650f07567677fef1c49a692d9', './vendor/ckeditor/ckeditor/plugins/templates/lang/ar.js', '15.9', 0),
('62ffb9cb9f9a3365e35486dff926acb9', './vendor/ckeditor/ckeditor/plugins/templates/lang/bg.js', '15.9', 0),
('6f495bfd99e4691e28985261a100402a', './vendor/ckeditor/ckeditor/plugins/templates/lang/bn.js', '15.9', 0),
('058b8b3e09ef7f5fc0779b2a16318de3', './vendor/ckeditor/ckeditor/plugins/templates/lang/bs.js', '15.9', 0),
('23a40f2db817a5621aef376713808f1a', './vendor/ckeditor/ckeditor/plugins/templates/lang/ca.js', '15.9', 0),
('532055689920a0b56f5d81ad9548ce93', './vendor/ckeditor/ckeditor/plugins/templates/lang/cs.js', '15.9', 0),
('d226378c1e760b7a09e358b3d1d5793a', './vendor/ckeditor/ckeditor/plugins/templates/lang/cy.js', '15.9', 0),
('84759cc4e0599934492ef7adee15c667', './vendor/ckeditor/ckeditor/plugins/templates/lang/da.js', '15.9', 0),
('5fe435c0ec8d0ab9e8bc0192d4797255', './vendor/ckeditor/ckeditor/plugins/templates/lang/de.js', '15.9', 0),
('a66c28cdeee52b11526d4f2c348e5913', './vendor/ckeditor/ckeditor/plugins/templates/lang/el.js', '15.9', 0),
('02142f38e5f03dd4161f5bb27a8de7ca', './vendor/ckeditor/ckeditor/plugins/templates/lang/en-au.js', '15.9', 0),
('35cec27f618a3b75c572a4854e043a5e', './vendor/ckeditor/ckeditor/plugins/templates/lang/en-ca.js', '15.9', 0),
('0cdbc7821e3c921ac6fd97c817fab49f', './vendor/ckeditor/ckeditor/plugins/templates/lang/en-gb.js', '15.9', 0),
('05f82b3bcf63a19f5db65826d4b4b717', './vendor/ckeditor/ckeditor/plugins/templates/lang/en.js', '15.9', 0),
('6a8682e2560c0b3a2df51e87c19b4bcf', './vendor/ckeditor/ckeditor/plugins/templates/lang/eo.js', '15.9', 0),
('1161fd89393901a1afadc2bba55790c0', './vendor/ckeditor/ckeditor/plugins/templates/lang/es.js', '15.9', 0);
INSERT INTO `tiki_secdb` VALUES
('9c2bef5ffbb05e769517f07606f0530f', './vendor/ckeditor/ckeditor/plugins/templates/lang/et.js', '15.9', 0),
('4f65b3505b9941ae80626728d4ec8b61', './vendor/ckeditor/ckeditor/plugins/templates/lang/eu.js', '15.9', 0),
('680221916a90afeeb452d94d1c3ad9e5', './vendor/ckeditor/ckeditor/plugins/templates/lang/fa.js', '15.9', 0),
('736c4332db6d2be128d6e34c3011b2a8', './vendor/ckeditor/ckeditor/plugins/templates/lang/fi.js', '15.9', 0),
('1d725690e1348f3f0e530007612292a7', './vendor/ckeditor/ckeditor/plugins/templates/lang/fo.js', '15.9', 0),
('217386d35a912abe3ddd5f01cef046d9', './vendor/ckeditor/ckeditor/plugins/templates/lang/fr-ca.js', '15.9', 0),
('7e1a6a4ecd4c2a9d0a6cada80c4cf21d', './vendor/ckeditor/ckeditor/plugins/templates/lang/fr.js', '15.9', 0),
('9768a0fad7611afc96385b7acc251209', './vendor/ckeditor/ckeditor/plugins/templates/lang/gl.js', '15.9', 0),
('6b1ac021740ce913572bfe08c9624af3', './vendor/ckeditor/ckeditor/plugins/templates/lang/gu.js', '15.9', 0),
('3d4af7656cfa184526ce23f065650b81', './vendor/ckeditor/ckeditor/plugins/templates/lang/he.js', '15.9', 0),
('33ef59b87b8322e3e08708d05fa9b557', './vendor/ckeditor/ckeditor/plugins/templates/lang/hi.js', '15.9', 0),
('bf05a4b95a3fa50b4ef77622ee05c67d', './vendor/ckeditor/ckeditor/plugins/templates/lang/hr.js', '15.9', 0),
('41539b718cb01d145365f68e41e72e7c', './vendor/ckeditor/ckeditor/plugins/templates/lang/hu.js', '15.9', 0),
('8a823d0d015ae2e871334a0b6b97911d', './vendor/ckeditor/ckeditor/plugins/templates/lang/id.js', '15.9', 0),
('9eec943234ac88930d28acce789097d5', './vendor/ckeditor/ckeditor/plugins/templates/lang/is.js', '15.9', 0),
('ac4af7f70193728b614314477706df89', './vendor/ckeditor/ckeditor/plugins/templates/lang/it.js', '15.9', 0),
('9ac03412e78ce6d181e15e7e60ad66d9', './vendor/ckeditor/ckeditor/plugins/templates/lang/ja.js', '15.9', 0),
('ae9090754aff29459e835c83057a0622', './vendor/ckeditor/ckeditor/plugins/templates/lang/ka.js', '15.9', 0),
('96b7c756246a51b382437be6b07f8d13', './vendor/ckeditor/ckeditor/plugins/templates/lang/km.js', '15.9', 0),
('6c35e3757de2a97f2cee14ebb6f84668', './vendor/ckeditor/ckeditor/plugins/templates/lang/ko.js', '15.9', 0),
('7fdf2b628b3336d51d10d75df068b90d', './vendor/ckeditor/ckeditor/plugins/templates/lang/ku.js', '15.9', 0),
('a935ce9674ee5db6df6fe08bf8668d13', './vendor/ckeditor/ckeditor/plugins/templates/lang/lt.js', '15.9', 0),
('3eea9672b67ebb4fde4b887168acf66b', './vendor/ckeditor/ckeditor/plugins/templates/lang/lv.js', '15.9', 0),
('cf3ae3ac52eede1d5a69aab194e02b2a', './vendor/ckeditor/ckeditor/plugins/templates/lang/mk.js', '15.9', 0),
('3b91bc27452ab3ad75fe3345e3e630c2', './vendor/ckeditor/ckeditor/plugins/templates/lang/mn.js', '15.9', 0),
('da0d189cce2d8e2d777fc2aac707f154', './vendor/ckeditor/ckeditor/plugins/templates/lang/ms.js', '15.9', 0),
('cce85ccb772a01e628992bfe4bd4ed6d', './vendor/ckeditor/ckeditor/plugins/templates/lang/nb.js', '15.9', 0),
('d75f9a752d72413ccac23925dc5851f0', './vendor/ckeditor/ckeditor/plugins/templates/lang/nl.js', '15.9', 0),
('3d9aa4a8604dc74b68ef24041c2def15', './vendor/ckeditor/ckeditor/plugins/templates/lang/no.js', '15.9', 0),
('316f0f5081bc38fe1a1a7c7b8601cbde', './vendor/ckeditor/ckeditor/plugins/templates/lang/pl.js', '15.9', 0),
('0dfef0a1dd39e1e0d6c0ea8cc894655e', './vendor/ckeditor/ckeditor/plugins/templates/lang/pt-br.js', '15.9', 0),
('9563ff53f1fa61d63d77db3246cb1b1c', './vendor/ckeditor/ckeditor/plugins/templates/lang/pt.js', '15.9', 0),
('44161e8022947f80661f804c4a9b0f7e', './vendor/ckeditor/ckeditor/plugins/templates/lang/ro.js', '15.9', 0),
('3a7065cfcbb9001cb2689f1ed0faca30', './vendor/ckeditor/ckeditor/plugins/templates/lang/ru.js', '15.9', 0),
('323d2b134b126f8b06b5495b1f443541', './vendor/ckeditor/ckeditor/plugins/templates/lang/si.js', '15.9', 0),
('e9ecd92a0e60eb5cfff8faa361f2f4e5', './vendor/ckeditor/ckeditor/plugins/templates/lang/sk.js', '15.9', 0),
('44a1096e0483b9f57e8c7370d0731da3', './vendor/ckeditor/ckeditor/plugins/templates/lang/sl.js', '15.9', 0),
('ffc8e7edbe65d666de10b00de36367ee', './vendor/ckeditor/ckeditor/plugins/templates/lang/sq.js', '15.9', 0),
('e3fb7bd5a70a61fa7bea467c97b56fd5', './vendor/ckeditor/ckeditor/plugins/templates/lang/sr-latn.js', '15.9', 0),
('ec80552e897c6aff2e291fb9b2884a17', './vendor/ckeditor/ckeditor/plugins/templates/lang/sr.js', '15.9', 0),
('6347cb0f5baede30bac5fc44f23f0789', './vendor/ckeditor/ckeditor/plugins/templates/lang/sv.js', '15.9', 0),
('79eebd3f610001ce68ff3429e0eb2e1c', './vendor/ckeditor/ckeditor/plugins/templates/lang/th.js', '15.9', 0),
('59052dab6bdf8442b2b816222491b18c', './vendor/ckeditor/ckeditor/plugins/templates/lang/tr.js', '15.9', 0),
('b2062e0fe0000dc31e92d86927b91182', './vendor/ckeditor/ckeditor/plugins/templates/lang/tt.js', '15.9', 0),
('7a0ad64e2c066a9ff7f214cdbbe3e8a9', './vendor/ckeditor/ckeditor/plugins/templates/lang/ug.js', '15.9', 0),
('35324280e57f881cb5537b48eab62941', './vendor/ckeditor/ckeditor/plugins/templates/lang/uk.js', '15.9', 0),
('89b64bd06cd54e8869441d1b44ee5eb4', './vendor/ckeditor/ckeditor/plugins/templates/lang/vi.js', '15.9', 0),
('666f1b91468c742dc271d5f12485f043', './vendor/ckeditor/ckeditor/plugins/templates/lang/zh-cn.js', '15.9', 0),
('33e0815942b1af7c29403f96e4f18bae', './vendor/ckeditor/ckeditor/plugins/templates/lang/zh.js', '15.9', 0),
('1de240ad4c565d6ee279fa086fc69001', './vendor/ckeditor/ckeditor/plugins/templates/plugin.js', '15.9', 0),
('3aff711362b45e0cc26cf753ab7e3039', './vendor/ckeditor/ckeditor/plugins/templates/templates/default.js', '15.9', 0),
('e8548ec90be3bd9365c36a44c53beadb', './vendor/ckeditor/ckeditor/plugins/uicolor/dialogs/uicolor.js', '15.9', 0),
('f9497a68d8e14a20c84c27ccf75efc74', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/af.js', '15.9', 0),
('cb29c4d6b74ab30c376799e2b3f63c92', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/ar.js', '15.9', 0),
('038dc523303ee7abfa954570ac595b10', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/bg.js', '15.9', 0),
('204589de061085239c3fb5cce3f32c3a', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/ca.js', '15.9', 0),
('ecde947c6562a78ec5c67b5231be10c8', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/cs.js', '15.9', 0),
('67538e1a071f37248ddd9a416e0f227f', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/cy.js', '15.9', 0),
('6319de513e953f0bdfd1eadb44e27bc9', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/da.js', '15.9', 0),
('0083cc1a0875d7f444fabafd2bbf1b77', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/de.js', '15.9', 0),
('b099db4c045e815a340693d3a4131393', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/el.js', '15.9', 0),
('e6041e9a1463dcede2ef761ed9d3c1e0', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/en-gb.js', '15.9', 0),
('c95ec38eca9bdd6ad567a3948ae6f947', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/en.js', '15.9', 0),
('60ffb96f306f575e9b7b40d1ef114baa', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/eo.js', '15.9', 0),
('0203c61e16b459f6388c9035ea479cc5', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/es.js', '15.9', 0),
('c480a3d18a7a13dd296ddcbd6da93dbf', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/et.js', '15.9', 0),
('a92b43d700254345a1c3047633f5620b', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/eu.js', '15.9', 0),
('a9b7a3a41f50b1c9841f4c1712e3b058', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/fa.js', '15.9', 0),
('4c7ae071e8b1a0f4fd6d654d6dd0b4c3', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/fi.js', '15.9', 0),
('bac212c00778edfdc129fd0a435a1897', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/fr-ca.js', '15.9', 0),
('da9db449a9188869470864f98e5a123f', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/fr.js', '15.9', 0),
('29564fbfcaa540c4e298b819fed59b98', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/gl.js', '15.9', 0),
('cd56537dd1665c6618e94746664ae1f7', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/he.js', '15.9', 0),
('6c2b76240a4309bcc47818ed29a283ab', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/hr.js', '15.9', 0),
('4494e1fc5fc73d67c710a26721b58a79', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/hu.js', '15.9', 0),
('2690a7fd66b7cfb6ee76b38e164317a7', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/id.js', '15.9', 0),
('33567ebd5b6fe763b6b6defbf9f0d722', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/it.js', '15.9', 0),
('fdca54bde6539ca7b857f8e661fa0ca4', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/ja.js', '15.9', 0),
('042945fe6cd46c5bc702d8f8a112da39', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/km.js', '15.9', 0),
('60a7371d4d8e9a3ec28625afdf1f223a', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/ko.js', '15.9', 0),
('e09aecb9378b1c34294eea122812e850', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/ku.js', '15.9', 0),
('bc2a6c80392b71abd8dc184f6da6148f', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/lv.js', '15.9', 0),
('41e4c0bd41f47c9eb47a66c1b128f68a', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/mk.js', '15.9', 0),
('2df2904f4cb61411f6fdaec73f03c4a6', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/nb.js', '15.9', 0),
('b9e37ca8aae18955a2621f60c0542c55', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/nl.js', '15.9', 0),
('ebf1f43f2fa1d5690c937c10f11a9c99', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/no.js', '15.9', 0),
('1f060dd908716fe5160d6c1496337056', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/pl.js', '15.9', 0),
('718dae07bf1876402b38fec2f9143766', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/pt-br.js', '15.9', 0),
('d5abfbeffadc5e9fe80cae9aed06e847', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/pt.js', '15.9', 0),
('78311a6c32566a73d580cc5808650925', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/ru.js', '15.9', 0),
('291d4f21801c2c7f8a8ee890a55605ae', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/si.js', '15.9', 0),
('f6699b78c4f57f65cbfba42c69bd9df7', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/sk.js', '15.9', 0),
('2a10ab200c1e981d2136386d116e685b', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/sl.js', '15.9', 0),
('8db59737c42538fcda69b397a7257e9d', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/sq.js', '15.9', 0),
('64aa382888076089f11aa0e30d714fa3', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/sv.js', '15.9', 0),
('6329f195700b3320013a9f89c8fa9c00', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/tr.js', '15.9', 0),
('f16c996fa47a5958f1f9cc701c9c5cb5', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/tt.js', '15.9', 0),
('a764505b6bc5962b80b510b1268f0b77', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/ug.js', '15.9', 0),
('14fb7762ee3c2931f53519df4cfeed15', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/uk.js', '15.9', 0),
('3813162489a8c763b1150e3dd6ff6440', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/vi.js', '15.9', 0),
('69bbaab7d313f5f38309e0d63cd8c226', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/zh-cn.js', '15.9', 0),
('7f81ad94a7443ecdafc4b31de263c7b8', './vendor/ckeditor/ckeditor/plugins/uicolor/lang/zh.js', '15.9', 0),
('462bbca25ed6c709df3c4c3ffe04d966', './vendor/ckeditor/ckeditor/plugins/uicolor/plugin.js', '15.9', 0),
('32a767dd24943d11d4c2b9647480e167', './vendor/ckeditor/ckeditor/plugins/uicolor/yui/assets/yui.css', '15.9', 0),
('2ea42aff6d01e1b5dbabbe02f59b8867', './vendor/ckeditor/ckeditor/plugins/uicolor/yui/yui.js', '15.9', 0),
('7cee2100c0e3e297a7a5813b683102cb', './vendor/ckeditor/ckeditor/plugins/uploadimage/plugin.js', '15.9', 0),
('4b44cc650a93d63a5854634aa838e33d', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/cs.js', '15.9', 0),
('1821286902edef9d9c873408aa431f0c', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/da.js', '15.9', 0),
('6087b0ffe4ec22fd6fa0d0481423741e', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/de.js', '15.9', 0),
('58bd7719906548b0857ce94184461992', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/en.js', '15.9', 0),
('20e7a9679b30867f948da898e4c973c2', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/eo.js', '15.9', 0),
('e4a38aa687ab603d2985b675b74ce61f', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/eu.js', '15.9', 0),
('871148c6fd2c323a21d91e6a82ecc92c', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/fr.js', '15.9', 0),
('32a14bdf08ebd36df2010897d063d7f7', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/gl.js', '15.9', 0),
('220e5b1413730a2a23c9c7698f76c570', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/hu.js', '15.9', 0),
('8df0292fe3ef22d8d7ca20ac49ed7b7d', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/id.js', '15.9', 0),
('1d56ecc51b1b70401b473a5190146330', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/it.js', '15.9', 0),
('b888c9a9476a2aac02c1d3846ee67888', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/ko.js', '15.9', 0),
('507c2a9cfd3454fef6a5ce8557507898', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/ku.js', '15.9', 0),
('d06f9710ed2fc153c9bcd0afe1eceb7d', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/nb.js', '15.9', 0),
('c739cfabfe287d6b7fcd80f2a78c8f62', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/nl.js', '15.9', 0),
('69025b01a99575550ab4e56438c2ce31', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/pl.js', '15.9', 0),
('00de19e85be6b7a0f469ef691d20bb1c', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/pt-br.js', '15.9', 0),
('331b2c17a03d3db28c03242e462c96b9', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/ru.js', '15.9', 0),
('2cc9695835f0e2602c137b43eb66c7b2', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/sv.js', '15.9', 0),
('7fde1463aa9a6791215b2b2b405f56da', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/tr.js', '15.9', 0),
('9c6aa4ca7c7123719622771895cec3ca', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/ug.js', '15.9', 0),
('7bc9bb59016152e61962afacce3de4bc', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/uk.js', '15.9', 0),
('90c0bf93d47705b7eb18b6d104711593', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/zh-cn.js', '15.9', 0),
('cc55ec55055feaf48b69a63aa0ca07d8', './vendor/ckeditor/ckeditor/plugins/uploadwidget/lang/zh.js', '15.9', 0),
('012bb4a7c81cd26cbbc97bb05fabbcd0', './vendor/ckeditor/ckeditor/plugins/uploadwidget/plugin.js', '15.9', 0),
('7f7d1bfc216570583c38535951f716f4', './vendor/ckeditor/ckeditor/plugins/widget/lang/af.js', '15.9', 0),
('1ea28d4cbac5e54c9f0a8a337aa2ee90', './vendor/ckeditor/ckeditor/plugins/widget/lang/ar.js', '15.9', 0),
('125459880df584e63abcac44169e303e', './vendor/ckeditor/ckeditor/plugins/widget/lang/bg.js', '15.9', 0),
('937550d3bde96e39ce485200e46defeb', './vendor/ckeditor/ckeditor/plugins/widget/lang/ca.js', '15.9', 0),
('9503cbc543b659583dc4fb7fe510abcc', './vendor/ckeditor/ckeditor/plugins/widget/lang/cs.js', '15.9', 0),
('b5cc35d4712c6a394babc8216f46f348', './vendor/ckeditor/ckeditor/plugins/widget/lang/cy.js', '15.9', 0),
('8d133607b50b17a8ae5a5f28330f9dbf', './vendor/ckeditor/ckeditor/plugins/widget/lang/da.js', '15.9', 0),
('c169d87a7618bd624cd6835b91664dca', './vendor/ckeditor/ckeditor/plugins/widget/lang/de.js', '15.9', 0),
('9ab95df664c7e21a212c88ab352c92c0', './vendor/ckeditor/ckeditor/plugins/widget/lang/el.js', '15.9', 0),
('21d7df854c3a065b2678404393a5552c', './vendor/ckeditor/ckeditor/plugins/widget/lang/en-gb.js', '15.9', 0),
('86206758c41ccc2ca18090d4c7825982', './vendor/ckeditor/ckeditor/plugins/widget/lang/en.js', '15.9', 0),
('93ad6b16c9babc10410b94e4e5d797ae', './vendor/ckeditor/ckeditor/plugins/widget/lang/eo.js', '15.9', 0),
('00114bd5c60c3fb88be2f3aefe09fa1b', './vendor/ckeditor/ckeditor/plugins/widget/lang/es.js', '15.9', 0),
('8216055e80499de95b2f021589246b40', './vendor/ckeditor/ckeditor/plugins/widget/lang/eu.js', '15.9', 0),
('ada02fcae5ddeb2bbf768448c0b41adf', './vendor/ckeditor/ckeditor/plugins/widget/lang/fa.js', '15.9', 0),
('aef6dbc78645498e0f1991dddfd6381e', './vendor/ckeditor/ckeditor/plugins/widget/lang/fi.js', '15.9', 0),
('fc034f86de2f3353ef9a6ae77398e48f', './vendor/ckeditor/ckeditor/plugins/widget/lang/fr.js', '15.9', 0),
('afade6dc9d695f375685a978ee618e26', './vendor/ckeditor/ckeditor/plugins/widget/lang/gl.js', '15.9', 0),
('95c5757af27db797b3cf6f2b7c9c6e7e', './vendor/ckeditor/ckeditor/plugins/widget/lang/he.js', '15.9', 0),
('eccb22809057cb3e63bdabe6e66f9554', './vendor/ckeditor/ckeditor/plugins/widget/lang/hr.js', '15.9', 0),
('e63c4ead1971990a90ab640fb79cfb2f', './vendor/ckeditor/ckeditor/plugins/widget/lang/hu.js', '15.9', 0),
('f8fde52f8ba9109b4a61c51888935e5b', './vendor/ckeditor/ckeditor/plugins/widget/lang/id.js', '15.9', 0),
('962c194dbbb15c4923ce1d9491276fe9', './vendor/ckeditor/ckeditor/plugins/widget/lang/it.js', '15.9', 0),
('11b744d9fcfdba755972676a5e2300c6', './vendor/ckeditor/ckeditor/plugins/widget/lang/ja.js', '15.9', 0),
('28547a30734013198d48f8c5a3221a06', './vendor/ckeditor/ckeditor/plugins/widget/lang/km.js', '15.9', 0),
('da142fa954328165527e8d2c221c5b97', './vendor/ckeditor/ckeditor/plugins/widget/lang/ko.js', '15.9', 0),
('378a725f807af165b87aabb682fab632', './vendor/ckeditor/ckeditor/plugins/widget/lang/ku.js', '15.9', 0),
('1868a1923780547a9a083d9ae15bcd83', './vendor/ckeditor/ckeditor/plugins/widget/lang/lv.js', '15.9', 0),
('0e8b1e37eb3e15ee58d71bb779a0f456', './vendor/ckeditor/ckeditor/plugins/widget/lang/nb.js', '15.9', 0),
('5f4ea3d19b7ae39b257a904cf6f84aae', './vendor/ckeditor/ckeditor/plugins/widget/lang/nl.js', '15.9', 0),
('e9c77b77551d8ac8c3aee3034f608316', './vendor/ckeditor/ckeditor/plugins/widget/lang/no.js', '15.9', 0),
('f679db70b80ef7fa49cd4dc26363a952', './vendor/ckeditor/ckeditor/plugins/widget/lang/pl.js', '15.9', 0),
('acecaf52249c24b7d19c43db72860b82', './vendor/ckeditor/ckeditor/plugins/widget/lang/pt-br.js', '15.9', 0),
('cf1e209eafa1c5bb658cf4a7672760a9', './vendor/ckeditor/ckeditor/plugins/widget/lang/pt.js', '15.9', 0),
('3e30dabbf4c1b9a4ec3e3b926909abc4', './vendor/ckeditor/ckeditor/plugins/widget/lang/ru.js', '15.9', 0),
('3d34e2ce3090f09fa78f4220d07733de', './vendor/ckeditor/ckeditor/plugins/widget/lang/sk.js', '15.9', 0),
('302e10243cd8742c774e658b2d28801d', './vendor/ckeditor/ckeditor/plugins/widget/lang/sl.js', '15.9', 0),
('3dd38b396099cbfb7346631e7d9f4721', './vendor/ckeditor/ckeditor/plugins/widget/lang/sq.js', '15.9', 0),
('2b1e0ecabfb17ed5fb09dd931a935c80', './vendor/ckeditor/ckeditor/plugins/widget/lang/sv.js', '15.9', 0),
('0028257307610087b66a6c47a9067b4a', './vendor/ckeditor/ckeditor/plugins/widget/lang/tr.js', '15.9', 0),
('7843af307a8d7087f3b2cf8dd922c2fc', './vendor/ckeditor/ckeditor/plugins/widget/lang/tt.js', '15.9', 0),
('1b65d9b4198124ffbb552a19daf1cdac', './vendor/ckeditor/ckeditor/plugins/widget/lang/ug.js', '15.9', 0),
('ad7793468affb4e82c7d074e9326f2db', './vendor/ckeditor/ckeditor/plugins/widget/lang/uk.js', '15.9', 0),
('8ec214074c245598145722d10ea66515', './vendor/ckeditor/ckeditor/plugins/widget/lang/vi.js', '15.9', 0),
('de3c80c493dabea3c93ec7855443d9b7', './vendor/ckeditor/ckeditor/plugins/widget/lang/zh-cn.js', '15.9', 0),
('e8bed2e4778f999f314d39940d702f8c', './vendor/ckeditor/ckeditor/plugins/widget/lang/zh.js', '15.9', 0),
('83d5a696c0b04aee047ca3ee71b90030', './vendor/ckeditor/ckeditor/plugins/widget/plugin.js', '15.9', 0),
('9f63e9dd90b207fdf884bb6e8b5dfbaf', './vendor/ckeditor/ckeditor/plugins/wsc/dialogs/wsc.css', '15.9', 0),
('a326fbeed01112e6a2a905f5f5c33792', './vendor/ckeditor/ckeditor/plugins/wsc/dialogs/wsc.js', '15.9', 0),
('47e6654b545a57f00589137476a68fdc', './vendor/ckeditor/ckeditor/plugins/wsc/dialogs/wsc_ie.js', '15.9', 0),
('14c6a2d461ea929babf559760e01c6fa', './vendor/ckeditor/ckeditor/plugins/xml/plugin.js', '15.9', 0),
('71b81b4b223d7a817a74c86cb3f6c7ac', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/dialog.css', '15.9', 0),
('932f2e21d505f09121432761e1b16c94', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/dialog_ie.css', '15.9', 0),
('f73be24fe31ebc5042bbd3f5c274b5d3', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/dialog_ie7.css', '15.9', 0),
('7a76a8e477505d3281a27c6dee558f12', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/dialog_ie8.css', '15.9', 0),
('4c44a9fc0688ba737494584c71f85805', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/dialog_iequirks.css', '15.9', 0),
('98d8923f909a39ce7df8dcf8384c1948', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/dialog_opera.css', '15.9', 0),
('498025b5f0916ab3fd07d97eaa6007f7', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/editor.css', '15.9', 0),
('1a472c9a97e949e2a98f0b94fa70bb24', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/editor_gecko.css', '15.9', 0),
('a1ba868e69d7ea6de315a572c68bf0ac', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/editor_ie.css', '15.9', 0),
('39b49617208ff13c9685aa4c2c170f03', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/editor_ie7.css', '15.9', 0),
('e954aa0349c25b9711ec76c5d30172a6', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/editor_ie8.css', '15.9', 0),
('915f4e34cc6b1a21cdd59e5e410fd467', './vendor/ckeditor/ckeditor/skins/bootstrapck/.temp/css/editor_iequirks.css', '15.9', 0),
('404bf30f738043f0a61a4d07fdd452c9', './vendor/ckeditor/ckeditor/skins/bootstrapck/dialog.css', '15.9', 0),
('e3f9b2c483bb2e99eb5c6db965c8657c', './vendor/ckeditor/ckeditor/skins/bootstrapck/dialog_ie.css', '15.9', 0),
('4bf542e5b3bd636ea44a2c4a7bbe3807', './vendor/ckeditor/ckeditor/skins/bootstrapck/dialog_ie7.css', '15.9', 0),
('f05884756774e2dc9d5da52a1934e5bf', './vendor/ckeditor/ckeditor/skins/bootstrapck/dialog_ie8.css', '15.9', 0),
('69de025de98a1f7bda601b81c4f31312', './vendor/ckeditor/ckeditor/skins/bootstrapck/dialog_iequirks.css', '15.9', 0),
('1a27b7fcb15aaa7eff69b8a82c89645c', './vendor/ckeditor/ckeditor/skins/bootstrapck/dialog_opera.css', '15.9', 0),
('fd27c2ffb4ecedd21786f32b7147b9d0', './vendor/ckeditor/ckeditor/skins/bootstrapck/editor.css', '15.9', 0),
('5f0298f413c62ee7c23a897542099f90', './vendor/ckeditor/ckeditor/skins/bootstrapck/editor_gecko.css', '15.9', 0),
('5e1efd42c262a6b68095e90431784ea4', './vendor/ckeditor/ckeditor/skins/bootstrapck/editor_ie.css', '15.9', 0),
('5f01eb85ccdbbdfeb36e0a07fe846710', './vendor/ckeditor/ckeditor/skins/bootstrapck/editor_ie7.css', '15.9', 0),
('e44fe33d708b09f8e6a867d65ba4c00e', './vendor/ckeditor/ckeditor/skins/bootstrapck/editor_ie8.css', '15.9', 0),
('eea24a6bedb4747c8d664d6555cc921d', './vendor/ckeditor/ckeditor/skins/bootstrapck/editor_iequirks.css', '15.9', 0),
('0e2558927976b39b437363f7ec4456d5', './vendor/ckeditor/ckeditor/skins/bootstrapck/sample/css/bootstrapck-sample.css', '15.9', 0),
('ff52978f618aedaae5a074a2b2b102f2', './vendor/ckeditor/ckeditor/skins/bootstrapck/sample/js/analytics.js', '15.9', 0),
('9cc81e3177c23e00b5b3834436f2737e', './vendor/ckeditor/ckeditor/skins/bootstrapck/sample/js/jquery-1.11.0.min.js', '15.9', 0),
('931302bf2fad737e9aaf403befe2d2cf', './vendor/ckeditor/ckeditor/skins/bootstrapck/skin.js', '15.9', 0),
('c22cc262275e45c9421fd447067ea7f9', './vendor/ckeditor/ckeditor/skins/kama/dialog.css', '15.9', 0),
('a2fea1e51dfc610f22efb018a30713b3', './vendor/ckeditor/ckeditor/skins/kama/dialog_ie.css', '15.9', 0),
('4b6c06f5251d55da60e2ba37651294a8', './vendor/ckeditor/ckeditor/skins/kama/dialog_ie7.css', '15.9', 0),
('5e62891c6f916624d7c0adc44e37d02d', './vendor/ckeditor/ckeditor/skins/kama/dialog_ie8.css', '15.9', 0),
('2834b2378bcadc11550439b344f840f2', './vendor/ckeditor/ckeditor/skins/kama/dialog_iequirks.css', '15.9', 0),
('5620878dcb5601cfcbc1c61afccb47f2', './vendor/ckeditor/ckeditor/skins/kama/editor.css', '15.9', 0),
('b0f7e7c50f867ccab23f2b56bddeade6', './vendor/ckeditor/ckeditor/skins/kama/editor_ie.css', '15.9', 0),
('7504030543bf5730e0c573e0d2ebedea', './vendor/ckeditor/ckeditor/skins/kama/editor_ie7.css', '15.9', 0),
('9d8c56d2461b28693b76f3eef7f4e723', './vendor/ckeditor/ckeditor/skins/kama/editor_ie8.css', '15.9', 0),
('b6123fa66a51a2fe9d9eeee409b81cad', './vendor/ckeditor/ckeditor/skins/kama/editor_iequirks.css', '15.9', 0),
('ba5484f30b6d90bda1e50efaa5a65903', './vendor/ckeditor/ckeditor/skins/kama/skin.js', '15.9', 0),
('7648cf2eca0748626291ea50b71d66df', './vendor/ckeditor/ckeditor/skins/minimalist/dialog.css', '15.9', 0),
('d29e726a09116afba6eca6caadb41d15', './vendor/ckeditor/ckeditor/skins/minimalist/dialog_ie.css', '15.9', 0),
('e43d8be5021bcb453282ae583db58293', './vendor/ckeditor/ckeditor/skins/minimalist/dialog_ie7.css', '15.9', 0),
('c3659277d52c820a236fe80ccfe7f326', './vendor/ckeditor/ckeditor/skins/minimalist/dialog_ie8.css', '15.9', 0),
('d32d57ebaf380b4f4ab000843015d532', './vendor/ckeditor/ckeditor/skins/minimalist/dialog_iequirks.css', '15.9', 0),
('aa21055c5bb892537cd835719ed5907a', './vendor/ckeditor/ckeditor/skins/minimalist/editor.css', '15.9', 0),
('1ed9d6e3da2007a359f4b351dc87198a', './vendor/ckeditor/ckeditor/skins/minimalist/editor_gecko.css', '15.9', 0),
('08ff3e81a56ce7d52b935463e9c4d6cd', './vendor/ckeditor/ckeditor/skins/minimalist/editor_ie.css', '15.9', 0),
('1be0957587f0e2f8df1da883001e4742', './vendor/ckeditor/ckeditor/skins/minimalist/editor_ie7.css', '15.9', 0),
('782ee4fa273346d410d5f5f127bcf6b0', './vendor/ckeditor/ckeditor/skins/minimalist/editor_ie8.css', '15.9', 0),
('529884ab9772609a234b69de87f22c25', './vendor/ckeditor/ckeditor/skins/minimalist/editor_iequirks.css', '15.9', 0),
('3e9fdc5cbd7c0a5d0d9e2e3d4e9cbbb0', './vendor/ckeditor/ckeditor/skins/minimalist/skin.js', '15.9', 0),
('a37dc0b89135979688162a6b18a4994c', './vendor/ckeditor/ckeditor/skins/moono/dialog.css', '15.9', 0),
('d0ece397a5b9d7d5c6040209a6063a6f', './vendor/ckeditor/ckeditor/skins/moono/dialog_ie.css', '15.9', 0),
('275192a538f57d585ba20ee7b8df83fd', './vendor/ckeditor/ckeditor/skins/moono/dialog_ie7.css', '15.9', 0),
('565c1666aabbd78a8c84f5d8475ffe8c', './vendor/ckeditor/ckeditor/skins/moono/dialog_ie8.css', '15.9', 0),
('7ff6fb32543d2228443b0da5c58c2a0f', './vendor/ckeditor/ckeditor/skins/moono/dialog_iequirks.css', '15.9', 0),
('9f63ae0e5bb9f26a9b8320f7e66039f1', './vendor/ckeditor/ckeditor/skins/moono/editor.css', '15.9', 0),
('0d6a1e1aaf27c4b13255896f8c7c38af', './vendor/ckeditor/ckeditor/skins/moono/editor_gecko.css', '15.9', 0),
('a28cc586a20e2d866f083e279134a5fa', './vendor/ckeditor/ckeditor/skins/moono/editor_ie.css', '15.9', 0),
('a285faa580ddc46ce617a68b09ec4ddf', './vendor/ckeditor/ckeditor/skins/moono/editor_ie7.css', '15.9', 0),
('ba2741b3916e7abfbd7211611be90f51', './vendor/ckeditor/ckeditor/skins/moono/editor_ie8.css', '15.9', 0),
('96f4cfb51d96fe4a454ce5751b7d1f05', './vendor/ckeditor/ckeditor/skins/moono/editor_iequirks.css', '15.9', 0),
('755295f40a5a3fa0040c3b81874419a3', './vendor/ckeditor/ckeditor/skins/office2013/dialog.css', '15.9', 0),
('07bca4e708f97c4130bc7d631dfbe043', './vendor/ckeditor/ckeditor/skins/office2013/editor.css', '15.9', 0),
('63455b041f2480d40a4561728d3b8fee', './vendor/ckeditor/ckeditor/skins/office2013/skin.js', '15.9', 0),
('b46e216e345799df805ac898af3910b9', './vendor/ckeditor/ckeditor/styles.js', '15.9', 0),
('e1233ff2b2428c5078ecfafbea23b7a0', './vendor/codemirror/codemirror/addon/comment/comment.js', '15.9', 0),
('2bad52d5a0b57d8f43e0e5b90bb25725', './vendor/codemirror/codemirror/addon/comment/continuecomment.js', '15.9', 0),
('910c1893a275073be1f80f32b77cd5a4', './vendor/codemirror/codemirror/addon/dialog/dialog.css', '15.9', 0),
('5e20ba47d5cad32bd1fc902f95b16193', './vendor/codemirror/codemirror/addon/dialog/dialog.js', '15.9', 0),
('1a278e72b51528270f8ce9ec991929a1', './vendor/codemirror/codemirror/addon/display/fullscreen.css', '15.9', 0),
('fb86184c4fb36398188f2199fd28f167', './vendor/codemirror/codemirror/addon/display/fullscreen.js', '15.9', 0),
('e2b9405b9f9de54ccc4e6ebb243ee38f', './vendor/codemirror/codemirror/addon/display/panel.js', '15.9', 0),
('a406cc1590d2683a0114de4784f5421d', './vendor/codemirror/codemirror/addon/display/placeholder.js', '15.9', 0),
('cd03669d62d1ea32c1d862d947b8b30c', './vendor/codemirror/codemirror/addon/display/rulers.js', '15.9', 0),
('c6116163eabbd75c187ec40b1bebf010', './vendor/codemirror/codemirror/addon/edit/closebrackets.js', '15.9', 0),
('c0f0c08ddf491538d263aff119573dbd', './vendor/codemirror/codemirror/addon/edit/closetag.js', '15.9', 0),
('353e8a411baea91c24edee06128b9698', './vendor/codemirror/codemirror/addon/edit/continuelist.js', '15.9', 0),
('7c67d671b0ae64ebabf263783f29d92e', './vendor/codemirror/codemirror/addon/edit/matchbrackets.js', '15.9', 0),
('545127ffedea5d77c0f68c809c75c5b6', './vendor/codemirror/codemirror/addon/edit/matchtags.js', '15.9', 0),
('650f095b187881451b0166d16ffd4091', './vendor/codemirror/codemirror/addon/edit/trailingspace.js', '15.9', 0),
('13f986f14247d953551bdfe93b27699e', './vendor/codemirror/codemirror/addon/fold/brace-fold.js', '15.9', 0),
('5e5bdebcd4acb30c3aed47164e2af6b3', './vendor/codemirror/codemirror/addon/fold/comment-fold.js', '15.9', 0),
('76c21fd4c3f14d1a61765324ec82266b', './vendor/codemirror/codemirror/addon/fold/foldcode.js', '15.9', 0),
('38bb68770b6f7ebaa7adea770a68e0b1', './vendor/codemirror/codemirror/addon/fold/foldgutter.css', '15.9', 0),
('b5f720aafd5e5f68ea8993823b71f5ad', './vendor/codemirror/codemirror/addon/fold/foldgutter.js', '15.9', 0),
('b17f35bdd388f737113271b9e9070ea3', './vendor/codemirror/codemirror/addon/fold/indent-fold.js', '15.9', 0),
('c8783b56c820030045a57f291660ea20', './vendor/codemirror/codemirror/addon/fold/markdown-fold.js', '15.9', 0),
('f173dec3ccb5d6df5f37b9a99ecc438a', './vendor/codemirror/codemirror/addon/fold/xml-fold.js', '15.9', 0),
('00b7028e5978a14b543f99e04739fd10', './vendor/codemirror/codemirror/addon/hint/anyword-hint.js', '15.9', 0),
('e62b03d88462a74f5a85580393653e2b', './vendor/codemirror/codemirror/addon/hint/css-hint.js', '15.9', 0),
('6b398a6ef3473b9f889092495fcc1545', './vendor/codemirror/codemirror/addon/hint/html-hint.js', '15.9', 0),
('8febf4d6664e133fac9da1da672564cd', './vendor/codemirror/codemirror/addon/hint/javascript-hint.js', '15.9', 0),
('630e320a614e7732f6ce1bf37147f27f', './vendor/codemirror/codemirror/addon/hint/show-hint.css', '15.9', 0),
('b5135a90f073ef544ddb8cb882748599', './vendor/codemirror/codemirror/addon/hint/show-hint.js', '15.9', 0),
('a02c7ebc653a2687a5d2693b96a600bc', './vendor/codemirror/codemirror/addon/hint/sql-hint.js', '15.9', 0),
('21d019d58516804262957d8879576908', './vendor/codemirror/codemirror/addon/hint/xml-hint.js', '15.9', 0),
('a867c61ab04b4309206ba371bdde9fb7', './vendor/codemirror/codemirror/addon/lint/coffeescript-lint.js', '15.9', 0),
('fd09f81d97cf3eb681cc5742d76ec47f', './vendor/codemirror/codemirror/addon/lint/css-lint.js', '15.9', 0),
('434609db212319c5cdfa6844d88c30f8', './vendor/codemirror/codemirror/addon/lint/javascript-lint.js', '15.9', 0),
('49afe4d1a791c115de21553c28f1a6cf', './vendor/codemirror/codemirror/addon/lint/json-lint.js', '15.9', 0),
('5f5d243947ec3ae1b8f37d85f0fa2a2d', './vendor/codemirror/codemirror/addon/lint/lint.css', '15.9', 0),
('1c72ac37f3f7966645b781e67ef39ec9', './vendor/codemirror/codemirror/addon/lint/lint.js', '15.9', 0),
('117815f724aa2c3d671801ccedaa86ac', './vendor/codemirror/codemirror/addon/lint/yaml-lint.js', '15.9', 0),
('842786722589d900ffaf32652e89dac9', './vendor/codemirror/codemirror/addon/merge/merge.css', '15.9', 0),
('9b743717900e5e6ba8c23b8759c74272', './vendor/codemirror/codemirror/addon/merge/merge.js', '15.9', 0),
('bc3c29fecceff0785b086b6e1c6f6b7c', './vendor/codemirror/codemirror/addon/mode/loadmode.js', '15.9', 0),
('b5c73e94185050bef0170420d0f53fd7', './vendor/codemirror/codemirror/addon/mode/multiplex.js', '15.9', 0),
('6e9c20d5c89c34f9245e1e346edc027b', './vendor/codemirror/codemirror/addon/mode/multiplex_test.js', '15.9', 0),
('7abff7c501c40008fc541414e803d954', './vendor/codemirror/codemirror/addon/mode/overlay.js', '15.9', 0),
('b3f550bd7554a29d6929e20aba3456ac', './vendor/codemirror/codemirror/addon/mode/simple.js', '15.9', 0),
('b0d93d54ee9bf76b246ea7cae39d6e75', './vendor/codemirror/codemirror/addon/runmode/colorize.js', '15.9', 0),
('54b1bc5448bbdfb53fdb3cbdc6740ef7', './vendor/codemirror/codemirror/addon/runmode/runmode-standalone.js', '15.9', 0),
('3266201540178df80d191c73bbd88152', './vendor/codemirror/codemirror/addon/runmode/runmode.js', '15.9', 0),
('dcc7299595da64717ea04e48366a8777', './vendor/codemirror/codemirror/addon/runmode/runmode.node.js', '15.9', 0),
('3a3061ab5b333cfa6511771142258553', './vendor/codemirror/codemirror/addon/scroll/annotatescrollbar.js', '15.9', 0),
('68e06dd3d77a87661790bbb7ebe2f080', './vendor/codemirror/codemirror/addon/scroll/scrollpastend.js', '15.9', 0),
('0352ba51fd6a422fe6cc44925e33ad88', './vendor/codemirror/codemirror/addon/scroll/simplescrollbars.css', '15.9', 0),
('aea96df34053a015d0cee582c9853dfb', './vendor/codemirror/codemirror/addon/scroll/simplescrollbars.js', '15.9', 0),
('b59268b1e4b6872df69110776d7f7934', './vendor/codemirror/codemirror/addon/search/match-highlighter.js', '15.9', 0),
('00ea2770c568a848190bcf52e4241276', './vendor/codemirror/codemirror/addon/search/matchesonscrollbar.css', '15.9', 0),
('2c9b8a244fb2892cde854901d73766fa', './vendor/codemirror/codemirror/addon/search/matchesonscrollbar.js', '15.9', 0),
('4db460ce020efb966a33c275ca90ccf2', './vendor/codemirror/codemirror/addon/search/search.js', '15.9', 0),
('fc5574a779ef286d12d8d97f33ec48b6', './vendor/codemirror/codemirror/addon/search/searchcursor.js', '15.9', 0),
('c7c0cb21951ca1ba74837a74bbcd4b47', './vendor/codemirror/codemirror/addon/selection/active-line.js', '15.9', 0),
('49df440e41a6f54264bce4f7ed7d7d05', './vendor/codemirror/codemirror/addon/selection/mark-selection.js', '15.9', 0),
('8ceb628a00ad564ec6c3bffe99b03ced', './vendor/codemirror/codemirror/addon/selection/selection-pointer.js', '15.9', 0),
('8f36b875b840601834dfed2b69de0078', './vendor/codemirror/codemirror/addon/tern/tern.css', '15.9', 0),
('3e17b2683c0234f39be41504fb10a1fb', './vendor/codemirror/codemirror/addon/tern/tern.js', '15.9', 0),
('6f48d3844db9cac6b959584d65e53afd', './vendor/codemirror/codemirror/addon/tern/worker.js', '15.9', 0),
('0c70cedbc3ecc9474b11a24e23fe7b16', './vendor/codemirror/codemirror/addon/wrap/hardwrap.js', '15.9', 0),
('9f95a4ebee67bc15739d34c6ebf5f2cc', './vendor/codemirror/codemirror/keymap/emacs.js', '15.9', 0),
('5a4d6677f212f6a64d363f13d2fb5671', './vendor/codemirror/codemirror/keymap/sublime.js', '15.9', 0),
('539d3780db796d0978b42566d780d954', './vendor/codemirror/codemirror/keymap/vim.js', '15.9', 0),
('1c26f7d1f30cbcc58982178f588906d5', './vendor/codemirror/codemirror/lib/codemirror.css', '15.9', 0),
('576ce88c76eb31fcf1475939c1ae161d', './vendor/codemirror/codemirror/lib/codemirror.js', '15.9', 0),
('d8439d00c2ae45de39a77f7d4cb93247', './vendor/codemirror/codemirror/mode/apl/apl.js', '15.9', 0),
('fca3456f0cc0bcabcfae4dd2c47fc0cf', './vendor/codemirror/codemirror/mode/asterisk/asterisk.js', '15.9', 0),
('47e7901eaa5438b8e1bb113431a560a9', './vendor/codemirror/codemirror/mode/clike/clike.js', '15.9', 0),
('1fa0e99d570cd92e5c8ef7bbd46a9eb6', './vendor/codemirror/codemirror/mode/clojure/clojure.js', '15.9', 0),
('b00a014eb678fa5a97309732c9d8e410', './vendor/codemirror/codemirror/mode/cobol/cobol.js', '15.9', 0),
('0e5610e38633c1b9932d6b72949d7510', './vendor/codemirror/codemirror/mode/coffeescript/coffeescript.js', '15.9', 0),
('5fde34368a97b348386c16b6bd55f3c4', './vendor/codemirror/codemirror/mode/commonlisp/commonlisp.js', '15.9', 0),
('4b673a302cf2e3e0be87d7f8bea24b32', './vendor/codemirror/codemirror/mode/css/css.js', '15.9', 0),
('a06869e83247f2a85153902498e9e198', './vendor/codemirror/codemirror/mode/css/less_test.js', '15.9', 0),
('c2adc306cbf77581fba085dc2d9a1b29', './vendor/codemirror/codemirror/mode/css/scss_test.js', '15.9', 0),
('7e2547c7c0c79006fd48130164f8bd32', './vendor/codemirror/codemirror/mode/css/test.js', '15.9', 0),
('4b1db2ca4b97632156e0e043c1abc1c9', './vendor/codemirror/codemirror/mode/cypher/cypher.js', '15.9', 0),
('fdcb6c7db0ec104135247533a7e0827a', './vendor/codemirror/codemirror/mode/d/d.js', '15.9', 0),
('995ed740ec37d27ff8ac7268a8905420', './vendor/codemirror/codemirror/mode/dart/dart.js', '15.9', 0),
('438ffb056eb84f0d18d3c7c60ac9f6bb', './vendor/codemirror/codemirror/mode/diff/diff.js', '15.9', 0),
('72c04bf04a886db18ed5530b39b0956f', './vendor/codemirror/codemirror/mode/django/django.js', '15.9', 0),
('e50a59c3edb1edb1effb6ad55b6d362a', './vendor/codemirror/codemirror/mode/dockerfile/dockerfile.js', '15.9', 0),
('5f9ab8edf9dc8d38f9326297ad7fb7c5', './vendor/codemirror/codemirror/mode/dtd/dtd.js', '15.9', 0),
('66adf11bcd8b5e3bf74145cc94040dcb', './vendor/codemirror/codemirror/mode/dylan/dylan.js', '15.9', 0),
('0eacd8e18beb9d0d94a73f1b99bd79ae', './vendor/codemirror/codemirror/mode/ebnf/ebnf.js', '15.9', 0),
('4e2394ef77c2d84158454b1b952a6e9f', './vendor/codemirror/codemirror/mode/ecl/ecl.js', '15.9', 0),
('acf73e549cc3cac3eda19a638a0be5fe', './vendor/codemirror/codemirror/mode/eiffel/eiffel.js', '15.9', 0),
('217b87e4e1007f51c303e07bfcaad185', './vendor/codemirror/codemirror/mode/erlang/erlang.js', '15.9', 0),
('fc0c8f22c7e51dc0e4da9d1f009be593', './vendor/codemirror/codemirror/mode/fortran/fortran.js', '15.9', 0),
('27904185929367cf717759697be42ef7', './vendor/codemirror/codemirror/mode/gas/gas.js', '15.9', 0),
('3e1d34de10ca7dba77d6843f893435bb', './vendor/codemirror/codemirror/mode/gfm/gfm.js', '15.9', 0),
('b8975f6cee8bb72da42fedf9df0b0828', './vendor/codemirror/codemirror/mode/gfm/test.js', '15.9', 0),
('082e6fef99e9bdafa36c15d0d8b31a24', './vendor/codemirror/codemirror/mode/gherkin/gherkin.js', '15.9', 0),
('9e7e5480ab20b9768e43e80424246252', './vendor/codemirror/codemirror/mode/go/go.js', '15.9', 0),
('4f97d9e79258b2a380fcda2daf85afd6', './vendor/codemirror/codemirror/mode/groovy/groovy.js', '15.9', 0),
('c0c0c8e0a3ace47a372d91beb3fe2ead', './vendor/codemirror/codemirror/mode/haml/haml.js', '15.9', 0),
('b4d49d07713e67c94e9cced6f5577595', './vendor/codemirror/codemirror/mode/haml/test.js', '15.9', 0),
('2a4d3a16ed5b1c9880d22cb1e3f7334a', './vendor/codemirror/codemirror/mode/haskell/haskell.js', '15.9', 0),
('566276b12c15076e75010c1489806392', './vendor/codemirror/codemirror/mode/haxe/haxe.js', '15.9', 0),
('5aa5d89f3ca53a988a8be20d608e6234', './vendor/codemirror/codemirror/mode/htmlembedded/htmlembedded.js', '15.9', 0),
('b8f2528cde883f78ede34ce9487c616e', './vendor/codemirror/codemirror/mode