<?php
/**
 * File containing the ezcWebdavPropFindResponse class.
 *
 * @package Webdav
 * @version //autogentag//
 * @copyright Copyright (C) 2005-2009 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 */
/**
 * Class generated by the backend to respond to MKCOL requests.
 *
 * If a {@link ezcWebdavBackend} receives an instance of {@link
 * ezcWebdavPropFindRequest} it might react with an instance of {@link
 * ezcWebdavPropFindResponse} or with producing an error.
 *
 * @property ezcWebdavResource|ezcWebdavCollection $node
 *           Contains the resource affected by the response.
 * @property array(ezcWebdavPropStatResponse)      $responses
 *           Contains a list of propstat responses for the node.
 *
 * @version //autogentag//
 * @package Webdav
 */
class ezcWebdavPropFindResponse extends ezcWebdavResponse
{
    /**
     * Creates a new response object.
     *
     * The response is constructed from either a {@link ezcWebdavCollection} or
     * a {@link ezcWebdavResource} as the first parameter and a finite amount
     * of {@link ezcWebdavPropStatResponse}s as additional parameters.
     * 
     * @param ezcWebdavResource|ezcWebdavCollection $node
     * @return void
     */
    public function __construct( $node )
    {
        parent::__construct( ezcWebdavResponse::STATUS_200 );
        $this->node = $node;

        // Add all ezcWebdavPropStatResponse
        $params = func_get_args();
        $responses = array();

        foreach ( $params as $nr => $param )
        {
            // Flatten array structure, if given
            if ( is_array( $param ) )
            {
                foreach ( $param as $value )
                {
                    if ( $value instanceof ezcWebdavPropStatResponse )
                    {
                        $responses[] = $value;
                    }
                }

                continue;
            }

            // Also add plain params
            if ( $param instanceof ezcWebdavPropStatResponse )
            {
                $responses[] = $param;
            }
        }

        // If it actually consists of multiple sub responses be of type 207.
        if ( count( $responses ) > 0 )
        {
            $this->status = ezcWebdavResponse::STATUS_207;
        }

        $this->responses = $responses;
    }

    /**
     * Sets a property.
     *
     * This method is called when an property is to be set.
     * 
     * @param string $propertyName The name of the property to set.
     * @param mixed $propertyValue The property value.
     * @return void
     * @ignore
     *
     * @throws ezcBasePropertyNotFoundException
     *         if the given property does not exist.
     * @throws ezcBaseValueException
     *         if the value to be assigned to a property is invalid.
     * @throws ezcBasePropertyPermissionException
     *         if the property to be set is a read-only property.
     */
    public function __set( $propertyName, $propertyValue )
    {
        switch ( $propertyName )
        {
            case 'node':
                if ( ( ! $propertyValue instanceof ezcWebdavResource ) &&
                     ( ! $propertyValue instanceof ezcWebdavCollection ) )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'ezcWebdavResource or ezcWebdavCollection' );
                }

                $this->properties[$propertyName] = $propertyValue;
                break;

            case 'responses':
                if ( !is_array( $propertyValue ) )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'array(ezcWebdavPropStatResponse)' );
                }

                $this->properties[$propertyName] = $propertyValue;
                break;

            default:
                parent::__set( $propertyName, $propertyValue );
        }
    }
}

?>
