<?php
// (c) Copyright 2002-2016 by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: RecommendationSetTest.php 57944 2016-03-17 19:26:53Z jyhem $

namespace Tiki\Recommendation;

class RecommendationSetTest extends \PHPUnit_Framework_TestCase
{
	function testAddFiltersRecommendations()
	{
		$set = new RecommendationSet('X');
		$set->add(new Debug\SourceDocument('forum post', 1));
		$set->add(new Recommendation('forum post', 42));

		$expect = new RecommendationSet('X');
		$expect->addDebug(new Debug\SourceDocument('forum post', 1));
		$expect->add(new Recommendation('forum post', 42));

		$this->assertEquals($expect, $set);
	}

	function testDebugInformationExcludedFromIteration()
	{
		$set = new RecommendationSet('X');
		$set->addDebug(new Debug\SourceDocument('forum post', 1));
		$set->add($rec = new Recommendation('forum post', 42));

		$out = [];
		foreach ($set as $r) {
			$out[] = $r;
		}

		$this->assertSame($out, [$rec]);
	}
}
