<?php

/**
 * Preformatted rule end renderer for Tiki
 *
 * PHP versions 4 and 5
 *
 * @category   Text
 * @package    Text_Wiki
 * @author     Paul M. Jones <pmjones@php.net>
 * @license    http://www.gnu.org/copyleft/lesser.html  LGPL License 2.1
 * @version    CVS: $Id: Preformatted.php 282098 2009-06-14 02:41:18Z rodrigosprimo $
 * @link       http://pear.php.net/package/Text_Wiki
 */

/**
 * This class renders preformated text in Tiki syntax.
 *
 * @category   Text
 * @package    Text_Wiki
 * @author     Paul M. Jones <pmjones@php.net>
 * @license    http://www.gnu.org/copyleft/lesser.html  LGPL License 2.1
 * @version    Release: @package_version@
 * @link       http://pear.php.net/package/Text_Wiki
 */
class Text_Wiki_Render_Tiki_Preformatted extends Text_Wiki_Render
{

	/**
	*
	* Renders a token into text matching the requested format.
	*
	* @access public
	*
	* @param array $options The "options" portion of the token (second
	* element).
	*
	* @return string The text rendered from the token options.
	*
	*/

	function token($options)
	{
		return '~pp~'.$options['text'].'~/pp~';
	}
}