<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platfroms allow them to do with
// text.
//
// Copyright (C) 2006-2016  Kaltura Inc.
//
// This file has been included in the Tiki distribution with special permission 
// from Kaltura Inc. for the convenience of Tiki users. It is not LGPL licensed. 
// Please obtain your own copy from http://kaltura.org if you need it for any other purpose.
//
// @ignore
// ===================================================================================================

/**
 * @package Kaltura
 * @subpackage Client
 */
require_once(dirname(__FILE__) . "/../KalturaClientBase.php");
require_once(dirname(__FILE__) . "/../KalturaEnums.php");
require_once(dirname(__FILE__) . "/../KalturaTypes.php");

/**
 * @package Kaltura
 * @subpackage Client
 */
class KalturaFileSyncStatus extends KalturaEnumBase
{
	const ERROR = -1;
	const PENDING = 1;
	const READY = 2;
	const DELETED = 3;
	const PURGED = 4;
}

/**
 * @package Kaltura
 * @subpackage Client
 */
class KalturaFileSyncType extends KalturaEnumBase
{
	const FILE = 1;
	const LINK = 2;
	const URL = 3;
}

/**
 * @package Kaltura
 * @subpackage Client
 */
class KalturaFileSyncOrderBy extends KalturaEnumBase
{
	const CREATED_AT_ASC = "+createdAt";
	const FILE_SIZE_ASC = "+fileSize";
	const READY_AT_ASC = "+readyAt";
	const SYNC_TIME_ASC = "+syncTime";
	const UPDATED_AT_ASC = "+updatedAt";
	const VERSION_ASC = "+version";
	const CREATED_AT_DESC = "-createdAt";
	const FILE_SIZE_DESC = "-fileSize";
	const READY_AT_DESC = "-readyAt";
	const SYNC_TIME_DESC = "-syncTime";
	const UPDATED_AT_DESC = "-updatedAt";
	const VERSION_DESC = "-version";
}

/**
 * @package Kaltura
 * @subpackage Client
 */
class KalturaFileSync extends KalturaObjectBase
{
	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $id = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $partnerId = null;

	/**
	 * 
	 *
	 * @var KalturaFileSyncObjectType
	 * @readonly
	 */
	public $fileObjectType = null;

	/**
	 * 
	 *
	 * @var string
	 * @readonly
	 */
	public $objectId = null;

	/**
	 * 
	 *
	 * @var string
	 * @readonly
	 */
	public $version = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $objectSubType = null;

	/**
	 * 
	 *
	 * @var string
	 * @readonly
	 */
	public $dc = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $original = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $createdAt = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $updatedAt = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $readyAt = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $syncTime = null;

	/**
	 * 
	 *
	 * @var KalturaFileSyncStatus
	 */
	public $status = null;

	/**
	 * 
	 *
	 * @var KalturaFileSyncType
	 * @readonly
	 */
	public $fileType = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $linkedId = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $linkCount = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $fileRoot = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $filePath = null;

	/**
	 * 
	 *
	 * @var float
	 * @readonly
	 */
	public $fileSize = null;

	/**
	 * 
	 *
	 * @var string
	 * @readonly
	 */
	public $fileUrl = null;

	/**
	 * 
	 *
	 * @var string
	 * @readonly
	 */
	public $fileContent = null;

	/**
	 * 
	 *
	 * @var float
	 * @readonly
	 */
	public $fileDiscSize = null;

	/**
	 * 
	 *
	 * @var bool
	 * @readonly
	 */
	public $isCurrentDc = null;

	/**
	 * 
	 *
	 * @var bool
	 * @readonly
	 */
	public $isDir = null;

	/**
	 * 
	 *
	 * @var int
	 * @readonly
	 */
	public $originalId = null;


}

/**
 * @package Kaltura
 * @subpackage Client
 */
abstract class KalturaFileSyncBaseFilter extends KalturaFilter
{
	/**
	 * 
	 *
	 * @var int
	 */
	public $partnerIdEqual = null;

	/**
	 * 
	 *
	 * @var KalturaFileSyncObjectType
	 */
	public $fileObjectTypeEqual = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $fileObjectTypeIn = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $objectIdEqual = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $objectIdIn = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $versionEqual = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $versionIn = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $objectSubTypeEqual = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $objectSubTypeIn = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $dcEqual = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $dcIn = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $originalEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $createdAtGreaterThanOrEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $createdAtLessThanOrEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $updatedAtGreaterThanOrEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $updatedAtLessThanOrEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $readyAtGreaterThanOrEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $readyAtLessThanOrEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $syncTimeGreaterThanOrEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $syncTimeLessThanOrEqual = null;

	/**
	 * 
	 *
	 * @var KalturaFileSyncStatus
	 */
	public $statusEqual = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $statusIn = null;

	/**
	 * 
	 *
	 * @var KalturaFileSyncType
	 */
	public $fileTypeEqual = null;

	/**
	 * 
	 *
	 * @var string
	 */
	public $fileTypeIn = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $linkedIdEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $linkCountGreaterThanOrEqual = null;

	/**
	 * 
	 *
	 * @var int
	 */
	public $linkCountLessThanOrEqual = null;

	/**
	 * 
	 *
	 * @var float
	 */
	public $fileSizeGreaterThanOrEqual = null;

	/**
	 * 
	 *
	 * @var float
	 */
	public $fileSizeLessThanOrEqual = null;


}

/**
 * @package Kaltura
 * @subpackage Client
 */
class KalturaFileSyncListResponse extends KalturaListResponse
{
	/**
	 * 
	 *
	 * @var array of KalturaFileSync
	 * @readonly
	 */
	public $objects;


}

/**
 * @package Kaltura
 * @subpackage Client
 */
class KalturaFileSyncFilter extends KalturaFileSyncBaseFilter
{
	/**
	 * 
	 *
	 * @var KalturaNullableBoolean
	 */
	public $currentDc = null;


}

/**
 * @package Kaltura
 * @subpackage Client
 */
class KalturaFileSyncClientPlugin extends KalturaClientPlugin
{
	protected function __construct(KalturaClient $client)
	{
		parent::__construct($client);
	}

	/**
	 * @return KalturaFileSyncClientPlugin
	 */
	public static function get(KalturaClient $client)
	{
		return new KalturaFileSyncClientPlugin($client);
	}

	/**
	 * @return array<KalturaServiceBase>
	 */
	public function getServices()
	{
		$services = array(
		);
		return $services;
	}

	/**
	 * @return string
	 */
	public function getName()
	{
		return 'fileSync';
	}
}

