<?php
// (c) Copyright 2002-2016 by authors of the Tiki Wiki CMS Groupware Project
// 
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: fgal.php 65386 2018-01-30 12:29:12Z robertokir $

function prefs_fgal_list()
{
	return array(
		'fgal_podcast_dir' => array(
			'name' => tra('Podcast directory'),
            'description' => tra(''),
			'type' => 'text',
			'help' => 'File+Gallery+Config',
			'size' => 50,
			'hint' => tra('The server must be able to read/write the directory.').' '.tra('Required for podcasts.'),
			'perspective' => false,
			'default' => 'files/',
		),
		'fgal_batch_dir' => array(
			'name' => tra('Path'),
            'description' => tra(''),
			'type' => 'text',
			'help' => 'File+Gallery+config',
			'size' => 50,
			'hint' => tra('To enable and use directory batch loading, set up a web-readable directory (preferably outside the web space). Then upload files to that directory, such as with SCP, FTP, etc').' '.tra('The server must be able to read the directory.').' '. tra('The directory can be outside the web space.'),
			'perspective' => false,
			'default' => '',
		),
		'fgal_prevent_negative_score' => array(
			'name' => tra('Prevent download if score becomes negative'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'File+Gallery+config',
			'default' => 'n',
			'dependencies' => array('feature_score'),			
		),
		'fgal_limit_hits_per_file' => array(
			'name' => tra('Allow download limit per file'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'File+Gallery+config',
			'default' => 'n',
		),
		'fgal_allow_duplicates' => array(
			'name' => tra('Allow the same file to be uploaded more than once'),
            'description' => tra(''),
			'type' => 'list',
			'help' => 'File+Gallery+config',
			'perspective' => false,
			'options' => array(
							  'n' => tra('Never'),
							  'y' => tra('Yes, even in the same gallery'),
							  'different_galleries' => tra('Only in different galleries')
			),
			'default' => 'y',
		),
		'fgal_display_zip_option' => array(
			'name' => tra('Display the .zip option in gallery'),
            'description' => tra('Display in the gallery the zip option (in upload and gallery file)'),
			'type' => 'flag',
			'help' => 'File+Gallery+config',
			'default' => 'n',
		),
		'fgal_match_regex' => array(
			'name' => tra('Must match'),
            'description' => tra(''),
			'type' => 'text',
			'size' => 50,
			'default' => '',
		),
		'fgal_nmatch_regex' => array(
			'name' => tra('Cannot match'),
            'description' => tra(''),
			'type' => 'text',
			'size' => 50,
			'default' => '',
		),
		'fgal_quota' => array (
			'name' => tra('Quota for all the files and archives'),
            'description' => tra(''),
			'shorthint' => tra('Mb').' '.tra('(0 for unlimited)'),
			'type' => 'text',
			'size' => 7,
			'default' => 0,
		),
		'fgal_quota_per_fgal' => array (
			'name' => tra('Quota can be defined for each file gallery'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'fgal_quota_default' => array (
			'name' => tra('Default quota for each new gallery'),
            'description' => tra(''),
			'shorthint' => tra('Mb').' '.tra('(0 for unlimited)'),
			'type' => 'text',
			'size' => 7,
			'default' => 0,
		),
		'fgal_quota_show' => array (
			'name' => tra('Show quota bar in the list page'),
            'description' => tra(''),
			'type' => 'list',
			'options' => array(
							  'n' 				=> tra('Never'),
							  'bar_and_text' 	=> tra('Yes, display bar and detail text'),
							  'y' 				=> tra('Yes, display only bar'),
							  'text_only'		=> tra('Yes, display only text')
			),
			'default' => 'y',
		),
		'fgal_use_db' => array(
			'name' => tra('Storage'),
            'description' => tra(''),
			'type' => 'list',
			'perspective' => false,
			'options' => array(
				'y' => tra('Store in database'),
				'n' => tra('Store in directory'),
			),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'fgal_use_dir' => array(
			'name' => tra('Path to the directory to store file gallery files'),
			'description' => tra("Specify a directory on your server, for example: /var/www/  It's recommended that this directory not be web accessible. PHP must be able to read/write to the directory."),
            'type' => 'text',
            'size' => 50,
            'perspective' => false,
            'default' => '',
            'tags' => array('basic'),
		),
		'fgal_search_in_content' => array(
			'name' => tra('File Gallery - Searchable content'),
            'description' => tra('Include the search form on the current gallery page just after "Find"'),
			'type' => 'flag',
			'default' => 'n',
		),
		'fgal_search' => array(
			'name' => tra('Include a search form in file galleries'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'fgal_list_ratio_hits' => array(
			'name' => tra('Display hits with a ratio of hits to maximum hits'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'fgal_display_properties' => array(
			'name' => tra('Display properties in the context menu'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'fgal_display_replace' => array(
			'name' => tra('Display "Replace" in the context menu'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'fgal_delete_after' => array(
			'name' => tra('Automatic deletion of old files'),
			'description' => tra('The user will have an option when uploading a file to specify the time after which the file is deleted'),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'default' => 'n',
		),
		'fgal_checked' => array(
			'name' => tra('Allow action on multiple files or galleries'),
			'description' => tra('Include "Remove" as an option for the checkbox action in file galleries'),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'default' => 'y',
		),
		'fgal_delete_after_email' => array(
			'name' => tra('Deletion emails notification'),
			'description' => tra('Email addresses (comma-separated) to receive a copy of each deleted file'),
			'type' => 'text',
			'default' => '',
		),
		'fgal_keep_fileId' => array(
			'name' => tra('Keep the same fileId for the latest version of a file'),
			'description' => tra('If the checkbox is checked, the file ID of the latest version of a file stays the same. A link to the file will always link to the latest version. If not checked, each version of the file is assigned its own file ID, so a link to the file will be to a specific version of the file'),
			'type' => 'flag',
			'default' => 'y',
		),
		'fgal_show_thumbactions' => array(
			'name' => tra('Show thumbnail actions'),
			'description' => tra('Show the checkbox and wrench icon for file actions menu when not displaying details'),
			'type' => 'flag',
			'default' => 'y',
		),
		'fgal_thumb_max_size' => array (
			'name' => tra('Maximum thumbnail size'),
			'description' => tra('Maximum width or height for image thumbnails'),
			'shorthint' => tra('In pixels'),
			'type' => 'text',
			'size' => 5,
			'default' => 120,
		),
		'fgal_enable_auto_indexing' => array(
			'name' => tra('Automatic indexing of file content'),
			'description' => tra('Uses command line tools to extract the information from the files based on their MIME types.'),
			'default' => 'n',
			'type' => 'flag',
		),
		'fgal_upload_from_source' => array(
			'name' =>  tra('Upload files from remote source'),
			'description' => tra('Enable copying files to file galleries from a URL that will be polled for new revisions.'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('advanced'),
			'dependencies' => array('fgal_keep_fileId'),
		),
		'fgal_source_refresh_frequency' => array(
			'name' => tra('Remote source refresh frequency limit'),
			'description' => tra('Minimum number of seconds to elapse between remote source checks to prevent flooding the server with requests.'),
			'type' => 'text',
			'filter' => 'int',
			'size' => 5,
			'default' => 3600,
			'shorthint' => tra('seconds'),
		),
		'fgal_source_show_refresh' => array(
			'name' => tra('Display controls to attempt a file refresh'),
			'description' => tra('Let users trigger a refresh attempt from the remote host.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'fgal_tracker_existing_search' => array(
			'name' => tra('Allow searching for existing files in the tracker files field'),
			'description' => tra('Search files using the search index.'),
			'type' => 'flag',
			'default' => 'y',
			'dependencies' => array('feature_search'),
		),
		'fgal_fix_mime_type' => array(
			'name' => tra('Set MIME type based on file suffix'),
			'description' => tra('Sets the MIME type of an image file according to the file suffix when it is incorrectly detected as application/octet-stream'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'help' => 'File+Gallery+config',
		),
		'fgal_allow_svg' => array(
			'name' => tra('Allow SVG file upload'),
			'description' => tra('SVG files may contain malicious code and compromise system security. Users will require SVG uploading permission to be able to upload SVG files.'),
			'type' => 'flag',
			'default' => 'n',
			'help' => 'File+Gallery+config',
			'keywords' => 'svg upload',
			'permission' => array(
				'textFilter' => 'upload_svg',
			),
		),
		'fgal_browse_name_max_length' => array(
			'name' => tra('Maximum name length'),
			'description' => tra('Length to which to truncate file names in browse view.'),
			'type' => 'text',
			'filter' => 'int',
			'size' => 5,
			'default' => 40,
		),
		'fgal_image_max_size_x' => array(
			'name' => tra('Maximum width of images'),
			'description' => tra('Default maximum width of images in galleries.') . ' ' . tra('(Default: 0=unlimited)'),
			'type' => 'text',
			'filter' => 'int',
			'size' => 5,
			'default' => 0,
		),
		'fgal_image_max_size_y' => array(
			'name' => tra('Maximum height of images'),
			'description' => tra('Default maximum height of images in galleries.') . ' ' . tra('(Default: 0=unlimited)'),
			'type' => 'text',
			'filter' => 'int',
			'size' => 5,
			'default' => 0,
		),
		'fgal_for_jcapture' => array(
			'name' => tra('File Gallery for jCapture'),
			'description' => tra('Id of gallery to store files captured by jCapture. Default:0 uses the default "root" gallery.'),
			'type' => 'text',
			'filter' => 'int',
			'size' => 5,
			'default' => 0,
			'dependencies' => 'feature_jcapture',
			'tags' => array('experimental'),
		),
		'fgal_elfinder_feature' => array(
			'name' => tra('Use elFinder UI'),
			'description' => tra('Alternative file manager with drag and drop capability'),
			'type' => 'flag',
			'filter' => 'alpha',
			'default' => 'n',
			'help' => 'elFinder',
			'dependencies' => array('feature_jquery_ui'),
		),
		'fgal_viewerjs_feature' => array(
			'name' => tra('Use Viewer JS'),
			'description' => tra('Uses ViewerJS from http://viewerjs.org if available (needs a separate install due to licensing restrictions), and allows displaying ODF files (odt, ods, odp) as well as pdf in web pages'),
			'type' => 'flag',
			'filter' => 'alpha',
			'default' => 'n',
			'help' => 'ViewerJS',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),
		),
		'fgal_viewerjs_uri' => array(
			'name' => tra('Viewer JS URI'),
			'description' => tra('Where ViewerJS is installed'),
			'type' => 'text',
			'filter' => 'url',
			'default' => 'files/viewerjs/ViewerJS/index.html',
			'help' => 'ViewerJS',
			'tags' => array('experimental'),
			'dependencies' => array('fgal_viewerjs_feature'),
		),
	);
}
