<?php
// (c) Copyright 2002-2016 by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: feature.php 75854 2020-03-10 13:10:16Z robertokir $

function prefs_feature_list($partial = false)
{

	global $prefs;

	$catree = $catlist = array('-1' => tra('None'));

	if (! $partial && isset($prefs['feature_categories']) && $prefs['feature_categories'] == 'y') {
		$categlib = TikiLib::lib('categ');
		$all_categs = $categlib->getCategories(NULL, true, false);

		$catree['0'] = tra('All');

		foreach ($all_categs as $categ) {
			$catlist[$categ['categId']] = $categ['name'] . " (" .$categ['categId'] . ")";
			$catree[$categ['categId']] = $categ['categpath'];
		}
	}

	return array(
		'feature_blog_mandatory_category' => array(
			'name' =>  tra('Blog:').' '.tra('Limit categorization to within the subtree of'),
			'description' => tra('If you get an error message indicating a mandatory category is required when editing a blog post, this is the option to blame. Set it to None.'),
			'type' => 'list',
			'options' => $catree,
			'dependencies' => array(
				'feature_categories',
				'feature_blogs',
			),
			'default' => '-1',
			'profile_reference' => 'category',
		),
		'feature_areas' => array(
			'name' => tra('Areas'),
			'warning' => tra('Experimental'),
			'description' => tra('Binding categories and perspectives to each other'),
			'type' => 'flag',
			'help' => 'Areas',
			'default' => 'n',
			'admin' => 'workspace',
			'tags' => array('experimental'),
			'dependencies' => array(
				'feature_categories',
				'feature_perspective',
				'categories_used_in_tpl',
			),
		),
		'feature_wiki' => array(
			'name' => tra('Wiki'),
			'description' => tra('Collaboratively authored documents with edit history.'),
			'type' => 'flag',
			'help' => 'Wiki',
			'default' => 'y',
			'tags' => array('basic'),
			'admin' => 'wiki',
			'view' => 'tiki-listpages.php',
			'module' => 'wiki',
			'permission' => array(
				'permType' => 'wiki',
			),
		),
		'feature_blogs' => array(
			'name' => tra('Blog'),
			'description' => tra('Online diaries or journals.'),
			'type' => 'flag',
			'help' => 'Blogs',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'blogs',
			'view' => 'tiki-list_blogs.php',
			'module' => 'blog',
			'permission' => array(
				'permType' => 'blogs',
			),
		),
		'feature_galleries' => array(
			'name' => tra('Image Gallery'),
			'description' => tra('Collections of images for viewing or downloading (photo albums)'),
			'warning' => tra('File galleries can be used instead.'),
			'type' => 'flag',
			'help' => 'Image+Gallery',
			'default' => 'n',
			'admin' => 'gal',
			'view' => 'tiki-galleries.php',
			'tags' => array('experimental'),
		),
		'feature_machine_translation' => array(
			'name' => tra('Machine Translation'),
			'description' => tra('Uses machine translation to translate the content of the site to other languages. Note that this feature relies on external services thay may not be free. Google Translate is a paid service.'),
			'help' => 'Machine+Translation',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_trackers' => array(
			'name' => tra('Trackers'),
			'description' => tra('Database and form generator'),
			'help' => 'Trackers',
			'type' => 'flag',
			'keywords' => 'CRUD',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'trackers',
			'view' => 'tiki-list_trackers.php',
			'module' => 'tracker',
			'permission' => array(
				'permType' => 'trackers',
			),
		),
		'feature_reports' => array(
			'name' => tra('Reports'),
			'description' => tra('Reports generator is based on data from Tiki Trackers or from the Tiki Action Log. The design of the report is controlled through a simple user interface that is generated from a set of definitions'),
			'help' => 'Reports',
			'type' => 'flag',
			'keywords' => 'report trackers logs builder',
			'default' => 'n',
			'view' => 'tiki-edit_report.php',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),
		),
		'feature_forums' => array(
			'name' => tra('Forums'),
			'description' => tra('Threaded or flat discussions.'),
			'help' => 'Forums',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'forums',
			'view' => 'tiki-forums.php',
			'module' => 'forum',
			'permission' => array(
				'permType' => 'forums',
			),
		),
		'feature_file_galleries' => array(
			'name' => tra('File Gallery'),
			'description' => tra('Storage of files of various formats to display or download, etc. With check-in and check-out (lock) capability'),
			'help' => 'File+Gallery',
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
			'admin' => 'fgal',
			'module' => 'file',
			'view' => 'tiki-list_file_gallery.php',
			'permission' => array(
				'permType' => 'file galleries',
			),
		),
		'feature_file_galleries_save_draft' => array(
			'name' => tra('Save files as drafts'),
            'description' => tra('allow saving of files as drafts'),
			'dependencies' => array(
				'feature_file_galleries',
			),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_file_galleries_templates' => array(
			'name' => tra('File gallery configuration templates'),
            'description' => tra(''),
			'type' => 'flag',
			'keywords' => tra('template'),
			'dependencies' => array(
				'feature_file_galleries',
			),
			'default' => 'n',
		),
		'feature_articles' => array(
			'name' => tra('Articles'),
			'description' => tra('Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming "live."'),
			'help' => 'Articles',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'articles',
			'module' => 'article',
			'view' => 'tiki-list_articles.php',
			'permission' => array(
				'textFilter' => 'article',
			),
		),
		'feature_polls' => array(
			'name' => tra('Polls'),
			'description' => tra('Presentation of a set of votable options, typically displayed in a module'),
			'help' => 'Poll',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'tiki-admin_polls.php',
			'module' => '',
			'view' => '',
			'permission' => array(
				'textFilter' => 'poll',
			),
		),
		'feature_newsletters' => array(
			'name' => tra('Newsletters'),
			'description' => tra('Content mailed to registered users or other subscribers.'),
			'help' => 'Newsletters',
			'type' => 'flag',
			'default' => 'n',
			'module' => 'newsletter',
			'tags' => array('basic'),
			'view' => 'tiki-newsletters.php',
			'permission' => array(
				'textFilter' => 'newsletter',
			),
		),
		'feature_calendar' => array(
			'name' => tra('Calendar'),
			'description' => tra('Events calendar with public, private and group channels.'),
			'help' => 'Calendar',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'calendar',
			'module' => 'calendar',
			'view' => 'tiki-calendar.php?viewlist=list',
			'permission' => array(
				'textFilter' => 'calendar',
			),
		),
		'feature_banners' => array(
			'name' => tra('Banners'),
			'description' => tra('Insert, track, and manage advertising banners.'),
			'help' => 'Banners',
			'keywords' => 'banner publicity',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-list_banners.php',
			'admin' => 'ads',
			'module' => 'banner',
			'permission' => array(
				'textFilter' => 'banner',
			),
		),
		'feature_categories' => array(
			'name' => tra('Category'),
			'description' => tra('Site-wide content category system. Items of different types (wiki pages, articles, tracker items, etc.) can be categorized. Categories can have permissions to control content access'),
			'help' => 'Category',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'category',
			'module' => 'categ', // intentional use of categ so it catches category and categories
			'view' => 'tiki-browse_categories.php',
			'permission' => array(
				'textFilter' => 'categ', // intentional use of categ so it catches category and categories
			),
		),
		'feature_unified_user_details' => array(
			'name' => tra('Use Unified User Details '),
			'description' => tra('Use User Details Page using the Unified Index.'),
			'help' => 'User+Preferences',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_score' => array(
			'name' => tra('Score'),
			'description' => tra('Score is a game to motivate participants to increase their contribution by comparing to other users.'),
			'help' => 'Score',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'score',
			'module' => 'score',
		),
		'feature_score_expday' => array(
		  'name' => tra('Cause scores older than a certain number of days to expire'),
		  'description' => tra(''),
		  'help' => 'Score',
		  'type' => 'text',
		  'admin' => 'score',
		  'module' => 'score',
		),
		'feature_search' => array(
			'name' => tra('Unified Search Index'),
			'description' => tra('Enables searching for content at the site using a Tiki-managed index.'),
			'help' => 'Search',
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
			'admin' => 'search',
			'warning' => tra("Unified Search requires server processing resources and that you properly set the server permissions. It's recommended to set a cron job to periodically rebuild the search index."),
			'module' => 'search',
			'view' => 'tiki-searchindex.php',
			'permission' => array(
				'textFilter' => 'search',
			),
		),
		'feature_freetags' => array(
			'name' => tra('Tags'),
			'description' => tra('Enables tags to be set on pages and other items for freeform categorization.'),
			'help' => 'Tags',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'freetags',
			'module' => 'tag',
			'view' => 'tiki-browse_freetags.php',
			'permission' => array(
				'permType' => 'freetags',
			),
		),
		'feature_actionlog' => array(
			'name' => tra('Action Log'),
			'description' => tra('Provides the ability to track the actions of users and produce reports on a per-user or per-category basis.'),
			'help' => 'Action+Log',
			'type' => 'flag',
			'view' => 'tiki-admin_actionlog.php',
			'default' => 'y',
		),
		'feature_contribution' => array(
			'name' => tra('Contribution'),
			'description' => tra('Enables users to specify the type of contribution they are making while editing items at the site. The contributions are then displayed color-coded in history and other reports.'),
			'help' => 'Contribution',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_multilingual' => array(
			'name' => tra('Multilingual'),
			'description' => tra('Enables internationalization features and multilingual support at the site.'),
			'help' => 'Internationalization',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_faqs' => array(
			'name' => tra('FAQs'),
			'description' => tra('Frequently asked questions and answers'),
			'warning' => tra('There has been discussion about this feature being retired, so keep in mind that normal wiki pages can be used to create and display FAQs.'),
			'help' => 'FAQ',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'admin' => 'faqs',
			'view' => 'tiki-list_faqs.php',
			'module' => 'faq',
			'permission' => array(
				'textFilter' => 'faq',
			),
		),
		'feature_surveys' => array(
			'name' => tra('Surveys'),
			'description' => tra('Create questionnaires with multiple-choice or open-ended questions'),
			'help' => 'Surveys',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-list_surveys.php',
		),
		'feature_directory' => array(
			'name' => tra('Directory'),
			'description' => tra('User-submitted Web links'),
			'help' => 'Directory',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-directory_browse.php',
		),
		'feature_quizzes' => array(
			'name' => tra('Quizzes'),
			'description' => tra('Timed questionnaire with recorded scores.'),
			'help' => 'Quizzes',
			'type' => 'flag',
			'default' => 'n',
			'keywords' => 'quiz questionnaire e-learning LMS',
			'tags' => array('experimental'),
			'view' => 'tiki-list_quizzes.php',
		),
		'feature_featuredLinks' => array(
			'name' => tra('Featured Links'),
			'description' => tra('A simple menu system to display external web pages in a new browser tab or an iframe within the site, etc.'),
			'help' => 'Featured+links',
			'view' => 'tiki-admin_links.php',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_copyright' => array(
			'name' => tra('Copyright'),
			'description' => tra('Use the Copyright Management System (or ©MS) to display the license of your content'),
			'help' => 'Copyright',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_references' => array(
			'name' => tra('Wiki references'),
			'description' => tra('Permits using references and the reference library.'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_wiki',
				),
			'default' => 'n',
		),
		'feature_shoutbox' => array(
			'name' => tra('Shoutbox'),
			'description' => tra('Quick comment (graffiti) box. Like a group chat, but not in real time.'),
			'help' => 'Shoutbox',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-shoutbox.php',
			'module' => 'shoutbox',
		),
		'feature_live_support' => array(
			'name' => tra('Live support system'),
			'description' => tra('One-on-one chatting with customer'),
			'help' => 'Live+Support',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'view' => 'tiki-live_support_admin.php',
		),
		'feature_tell_a_friend' => array(
			'name' => tra('Tell a Friend'),
			'description' => tra('Add to each page an "Email this page" link'),
			'warning' => tra('The Share feature has better spam protection and will replace tell a friend in an upcoming version of Tiki.'),
			'help' => 'Tell+a+Friend',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_share' => array(
			'name' => tra('Share'),
			'description' => tra('Add a "Share" link in all pages to send it via email, Twitter, Facebook, message or forums'),
			'warning' => tra('Be careful when allowing anonymous users to activate the antibot feature.'),
			'help' => 'Share',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'share',
		),
		'feature_html_pages' => array(
			'name' => tra('HTML pages'),
			'description' => tra('Static and dynamic HTML content'),
			'help' => 'HTML+Pages',
			'warning' => tra('HTML can be used in wiki pages. This is a separate feature.'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'view' => 'tiki-admin_html_pages.php',
		),
		'feature_contact' => array(
			'name' => tra('Contact Us'),
			'description' => tra('A basic contact form a visitor can use to contact the site admin'),
			'help' => 'Contact+us',
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_messages',
				'sender_email',
			),
			'tags' => array('basic'),
			'admin' => 'general',
			'view' => 'tiki-contact.php',
		),
		'feature_minichat' => array(
			'name' => tra('Minichat'),
			'description' => tra('Real-time group text chatting'),
			'help' => 'Minichat',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'module' => 'chat',
		),
		'feature_comments_moderation' => array(
			'name' => tra('Comments Moderation'),
			'description' => tra('Enables the admin or other authorized group member to validate comments before they are visible'),
			'help' => 'Comments',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_comments_locking' => array(
			'name' => tra('Comments Locking'),
			'description' => tra('Comments can be closed (no comments, or no new comments)'),
			'help' => 'Comments',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_comments_post_as_anonymous' => array(
			'name' => tra('Allow logged-in users to post commments anonymously'),
			'description' => tra('This can be used to encourage honest feedback without self-censorship, such as in a forum for brainstorming or feedback for improvement.'),
			'help' => 'Comments',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_description' => array(
			'name' => tra('Display page description'),
			'description' => tra('Display the wiki page description between the page title and the page content.'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_page_title' => array(
			'name' => tra('Display page name as page title'),
			'description' => tra('Display the page name at the top of each page as page title. If not enabled, the page content should contain an h1 heading to function as the page title, or the page description can be used as the title.'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_pageid' => array(
			'name' => tra('Display page ID'),
			'description' => tra('Each wiki page has a numeric ID and this can be displayed.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_icache' => array(
			'name' => tra('Individual wiki cache'),
			'description' => tra('Allow users to change the duration of the cache on a per-page basis.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_jscalendar' => array(
			'name' => tra('Date picker for date selection'),
			'description' => tra('JavaScript popup date selector (uses jQuery UI DatePicker).'),
			'help' => 'JS+Calendar',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_htmlpurifier_output' => array(
			'name' => tra('Output should be HTML Purified'),
			'description' => tra('This activates HTML Purifier on wiki content and other outputs, to filter out potential security problems like XSS code. Keep in mind that HTML Purifier is not HTML5 compatible and may rewrite HTML5 syntax, producing unwanted results.'),
			'help' => 'Purifier',
			'warning' => tra('Experimental.'),
			'tags' => array('experimental'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),
		'feature_fullscreen' => array(
			'name' => tra('Full screen'),
			'description' => tra('Allow users to activate full-screen mode.'),
			'help' => 'Fullscreen',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_cssmenus' => array(
			'name' => tra('CSS Menus'),
			'description' => tra('CSS (Superfish) Menus.'),
			'help' => 'Menus',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_shadowbox' => array(
			'name' => tra('Shadowbox / ColorBox'),
			'description' => tra('Display images in a modal popup box'),
			'help' => 'Shadowbox',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_quick_object_perms' => array(
			'name' => tra('Quick Permission Assignment'),
			'description' => tra('Quickperms are an interface in addition to the normal edit-permissions page, for quick assignment of permissions for a page or other object.'),
			'help' => 'Quickperms',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_user_encryption' => array(
			'name' => tra('User Encryption'),
			'description' => tra('Tiki user encryption enables a personal, secure storage of sensitive data, e.g. password. Only the user can see the data. No decryption passwords are stored.'),
			'hint' => tra('Enable personal, secure storage of sensitive data such as passwords'),
			'help' => 'User Encryption',
			'warning' => tra('This is an experimental feature. Using it may cause loss of the encrypted data.'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_password_domains' => array(
			'name' => tra('Password Domains'),
			'description' => tra('Securely store extra user passwords and other user specific data for other "domains", or just for yourself'),
			'type' => 'text',
			'default' => 'userkey',
			'dependencies' => array(
				'feature_user_encryption',
			),
			'tags' => array('experimental'),
		),
		'feature_purifier' => array(
			'name' => tra('HTML Purifier'),
			'description' => tra("HTML Purifier is a standards-compliant HTML filter library written in PHP and integrated in Tiki. HTML Purifier will not only remove all malicious code (better known as XSS) with a thoroughly audited, secure yet permissive whitelist, it will also ensure that your documents are standards-compliant. Keep in mind that HTML Purifier is not HTML5 compatible and may rewrite HTML5 syntax and produce unwanted results."),
			'hint' => tra('If you use HTML in your wiki page and it gets stripped out or rewritten, make sure your HTML is valid, or de-activate this feature.  Keep in mind that HTML Purifier is not HTML5 compatible and may rewrite HTML5 syntax and produce unwanted results.'),
			'help' => 'Purifier',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'y',
		),
		'feature_ajax' => array(
			'name' => tra('Ajax'),
			'description' => tra('Allows for efficient retrieval and display of information from the server, thus improving the user experience. This feature is required for the interface for many features to work.'),
			'help' => 'Ajax',
			'warning' => tra('This feature is required for the interface for many features to work properly.'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_webmail' => array(
			'name' => tra('Webmail'),
			'description' => tra('Webmail'),
			'help' => 'Webmail',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'admin' => 'webmail',
			'view' => 'tiki-webmail.php',
		),
		'feature_intertiki' => array(
			'name' => tra('Intertiki'),
			'description' => tra('Allows several Tiki sites (slaves) to get authentication from a master Tiki site'),
			'help' => 'Intertiki',
			'perspective' => false,
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'intertiki',
		),
		'feature_mailin' => array(
			'name' => tra('Mail-in'),
			'description' => tra('Create and publish wiki pages and articles via email'),
			'help' => 'Mail-in',
			'keywords' => 'inbound email',
			'dependencies' => array(
				'feature_wiki',
				),
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-admin_mailin.php',
		),
		'feature_wiki_mindmap' => array(
			'name' => tra('Mindmap'),
			'description' => tra('Mindmap'),
			'help' => 'MindMap',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_print_indexed' => array(
			'name' => tra('Print indexed'),
			'description' => tra('Print indexed'),
			'help' => 'Print+Indexed',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_sheet' => array(
			'name' => tra('Spreadsheet'),
			'description' => tra('Spreadsheets with calculations and charts'),
			'help' => 'Spreadsheet',
			'type' => 'flag',
			'keywords' => 'sheet calculation calculations stats stat graph graphs',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-sheets.php',
			'permission' => array(
				'textFilter' => 'sheet',
			),
		),
		'feature_slideshow' => array(
			'name' => tra('Slideshow (jQuery.s5)'),
			'description' => tra('Wiki-page-based slideshow'),
			'help' => 'Slideshow',
			'type' => 'flag',
			'keywords' => 'slide slides presentation',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_slideshow_pdfexport' => array(
			'name' => tra('Slideshow (jQuery.s5) PDF Export'),
			'description' => tra('Wiki-page-based slideshow to pdf export'),
			'help' => 'Slideshow',
			'type' => 'flag',
			'keywords' => 'slide slides presentation pdf',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_invoice' => array(
			'name' => tra('Invoice'),
			'description' => tra('Invoice system'),
			'help' => 'Invoice',
			'type' => 'flag',
			'keywords' => 'invoice contractor invoicing',
			'default' => 'n',
			'view' => 'tiki-list_invoices.php',
			'tags' => array('experimental'),
		),
		'feature_wysiwyg' => array(
			'name' => tra('Full WYSIWYG editor'),
			'description' => tra('WYSIWYG is an acronym for "What You See Is What You Get". CKEditor is used to provide a word-processor-like editing experience.'),
			'help' => 'Wysiwyg',
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_ajax',
				'ajax_autosave',
				'feature_wiki_paragraph_formatting',
				'feature_wiki_paragraph_formatting_add_br',
				'wysiwyg_wiki_parsed',
			),
			'tags' => array('basic'),
		),
		'feature_kaltura' => array(
			'name' => tra('Kaltura Video Management'),
			'description' => tra('Integration with the Kaltura video management platform'),
			'help' => 'Kaltura',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'video',
			'view' => 'tiki-list_kaltura_entries.php?list=media',
		),
		'feature_friends' => array(
			'name' => tra('Friendship Network'),
			'description' => tra('Users can identify other users as their friends'),
			'dependencies' => array(
				'feature_search',
				'user_in_search_result',
			),
			'help' => 'Friendship+Network',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_banning' => array(
			'name' => tra('Banning system'),
			'description' => tra('Deny access to specific users based on username, IP, and date/time range.'),
			'help' => 'Banning',
			'type' => 'flag',
			'keywords' => 'ban kick exclude deny',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-admin_banning.php',
		),
		'feature_stats' => array(
			'name' => tra('Stats'),
			'description' => tra('Record basic statistics about major Tiki features (number of wiki pages, size of file galleries, etc.)'),
			'help' => 'Stats',
			'keywords' => 'stat analytics',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-stats.php',
		),
		'feature_action_calendar' => array(
			'name' => tra('Action Calendar'),
			'description' => tra('Action Calendar'),
			'help' => 'Action+Calendar',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_referer_stats' => array(
			'name' => tra('Referer stats'),
			'description' => tra('Record domain name of sites that send visitors to this Tiki.'),
			'help' => 'Stats',
			'keywords' => 'stat analytics referrer refferer refferrer',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-referer_stats.php',
		),
		'feature_redirect_on_error' => array(
			'name' => tra('Redirect on error'),
			'description' => tra('On an error, refresh to the homepage as specified on the Admin General page.'),
			'help' => 'Redirect+On+Error',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_comm' => array(
			'name' => tra('Communications (send/receive objects)'),
			'description' => tra('Send/receive wiki pages and articles between Tiki-powered sites'),
			'help' => 'Communication+Center',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_mytiki' => array(
			'name' => tra('Display "My Account" in the application menu'),
			'description' => tra('Display "My Account" in the application menu'),
			'help' => 'My Account',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_minical' => array(
			'name' => tra('Mini Calendar'),
			'description' => tra('Mini Calendar'),
			'help' => 'Calendar',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_userPreferences' => array(
			'name' => tra('User Preferences Screen'),
			'description' => tra('User Preferences Screen'),
			'help' => 'User+Preferences',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_notepad' => array(
			'name' => tra('User Notepad'),
			'description' => tra('User Notepad'),
			'help' => 'Notepad',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_user_bookmarks' => array(
			'name' => tra('My Bookmarks'),
			'description' => tra('My Bookmarks'),
			'help' => 'Bookmarks',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_contacts' => array(
			'name' => tra('User Contacts'),
			'description' => tra('User Contacts'),
			'help' => 'Contacts',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_user_watches' => array(
			'name' => tra('User Watches'),
			'description' => tra('Receive email notification of changes. Each user can choose to be notified of changes to specific items'),
			'help' => 'User+Watches',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-admin_notifications.php',
		),
		'feature_group_watches' => array(
			'name' => tra('Group Watches'),
			'description' => tra('All users in a group selected by an admin will receive email notification of changes to specific items. Users cannot choose to stop receiving those notifications while they are members of that group'),
			'help' => 'Group+Watches',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_daily_report_watches' => array(
			'name' => tra('Daily Reports for User Watches'),
			'description' => tra('Daily Reports for User Watches'),
			'help' => 'Daily+Reports',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_user_watches_translations' => array(
			'name' => tra('User Watches Translations'),
			'description' => tra('User Watches Translations'),
			'help' => 'User+Watches',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_user_watches_languages' => array(
			'name' => tra('User Watches Languages'),
			'description' => tra('Watch language-specific changes within a category.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_usermenu' => array(
			'name' => tra('User Menu'),
			'description' => tra('User Menu'),
			'help' => 'User+Menu',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_tasks' => array(
			'name' => tra('User Tasks'),
			'description' => tra('User Tasks'),
			'help' => 'Task',
			'type' => 'flag',
			'default' => 'n',
			'module' => 'task',
			'view' => 'tiki-user_tasks.php',
			'permission' => array(
				'textFilter' => 'task',
			),
		),
		'feature_messages' => array(
			'name' => tra('User Messages'),
			'description' => tra('User Messages'),
			'help' => 'Inter-user+Messages',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'messages',
			'module' => 'message',
			'view' => 'messu-mailbox.php',
			'permission' => array(
				'textFilter' => 'message',
			),
		),
		'feature_userfiles' => array(
			'name' => tra('User Files'),
			'description' => tra('User Files'),
			'help' => 'User+Files',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_userlevels' => array(
			'name' => tra('Menu user levels'),
			'description' => tra('Enables control of the per-group visibility of menu options'),
			'help' => 'User+Levels',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_groupalert' => array(
			'name' => tra('Group Alert'),
			'description' => tra('Group Alert'),
			'help' => 'Group+Alert',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_integrator' => array(
			'name' => tra('Integrator'),
			'description' => tra('Integrator'),
			'help' => 'Integrator',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'view' => 'tiki-list_integrator_repositories.php',
		),
		'feature_xmlrpc' => array(
			'name' => tra('XMLRPC API'),
			'description' => tra('XMLRPC API'),
			'help' => 'Xmlrpc',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_debug_console' => array(
			'name' => tra('Debugger console'),
			'description' => tra('Debugger console'),
			'help' => 'Debugger+Console',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
			'warning' => tr('Not suitable for production use.'),
		),
		'feature_tikitests' => array(
			'name' => tra('TikiTests'),
			'description' => tra('Permits recording and playback of functional tests'),
			'help' => 'TikiTests',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_version_checks' => array(
			'name' => tra('Check for updates automatically'),
			'description' => tra('Tiki will check for updates when the main Administration page is accessed'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_ticketlib' => array(
			'name' => tra('Require confirmation of an action if a possible CSRF is detected'),
			'description' => tra('Require confirmation of an action if a possible CSRF is detected'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),
		'feature_ticketlib2' => array(
			'name' => tra('Protect against CSRF with a ticket'),
			'description' => tra('Protect against CSRF with a ticket'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'y',
		),
		'feature_detect_language' => array(
			'name' => tra('Detect browser language'),
			'description' => tra('Look up the user\'s preferred language through browser preferences.'),
			'dependencies' => array('change_language'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_best_language' => array(
			'name' => tra('Show pages in user\'s preferred language'),
			'description' => tra('When accessing a page which has an equivalent in the user\'s preferred language, favor the translated page.'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_userPreferences',
			),
			'default' => 'n',
		),
		'feature_sync_language' => array(
			'name' => tra('Synchronize page and site language'),
            'description' => tra('Changing the page language also changes the site language'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_translation' => array(
			'name' => tra('Translation assistant'),
			'description' => tra('Track translation operations between pages.'),
			'help' => 'Translating+Tiki+content',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_urgent_translation' => array(
			'name' => tra('Urgent translation notifications'),
			'description' => tra('Allow flagging changes as urgent, so translations are marked with a notice visible to all users.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_translation_incomplete_notice' => array(
			'name' => tra('Incomplete translation notice'),
			'description' => tra('When a page is translated to a new language, a notice will automatically be inserted into the page to indicate that the translation is not yet complete.'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_multilingual_structures' => array(
			'name' => tra('Multilingual structures'),
			'description' => tra('Structures search for equivalent pages in other languages. May cause performance problems with larger structures.'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_wiki_structure',
				'feature_multilingual',
			),
			'default' => 'n',
		),
		'feature_multilingual_one_page' => array(
			'name' => tra('Display all languages in a single page'),
			'description' => tra('List all languages as options in the page-language dropdown list, to see them all at once.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_obzip' => array(
			'name' => tra('GZip output'),
			'description' => tra('Compress your pages on-the-fly, if the requesting browser supports this'),
			'help' => 'Compression',
			'type' => 'flag',
			'tags' => array('basic'),
			'perspective' => false,
			'default' => 'n',
		),
		'feature_help' => array(
			'name' => tra('Help System'),
			'description' => tra('Activates links to Tiki documentation'),
			'help' => 'Documentation',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_display_my_to_others' => array(
			'name' => tra("Show user's contribution on the user information page"),
			'description' => tra("view user's contribution on the user information page"),
			'help' => 'User+Preferences',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_smileys' => array(
			'name' => tra('Smileys'),
			'description' => tra('Also known as emoticons'),
			'help' => 'Smileys',
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_draw' => array(
			'name' => tra('Draw (SVG Edit)'),
			'description' => tra('Draw enables creating and editing SVG images in all wiki text areas'),
			'help' => 'Draw',
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_file_galleries',
			),
		),
		'feature_draw_hide_buttons' => array(
			'name' => tra('Draw (SVG Edit) hide buttons'),
			'description' => tra('Hide buttons in Draw, HTML id, comma-separated. Example: "tool_select,tool_fhpath,tools_line_show,tools_rect_show,tools_ellipse_show,tool_path,tools_shapelib_show,tool_text,tool_image,tool_zoom,tool_eyedropper"'),
			'help' => 'Draw',
			'dependencies' => array(
				'feature_draw',
				'feature_file_galleries',
			),
			'tags' => array('experimental'),
			'type' => 'textarea',
			'default' => '',
		),
		'feature_draw_separate_base_image' => array(
			'name' => tra('Separate base image'),
			'description' => tra('Leaves the initially edited image as a separate file and stores the drawing separately'),
			'help' => 'Draw',
			'dependencies' => array(
				'feature_draw',
				'feature_file_galleries',
			),
			'tags' => array('experimental'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_draw_in_userfiles' => array(
			'name' => tra('Draw in user file gallery'),
			'description' => tra("Users' drawings are stored in their user files gallery"),
			'help' => 'Draw',
			'dependencies' => array(
				'feature_draw',
				'feature_file_galleries',
				'feature_userfiles',
				'feature_use_fgal_for_user_files',
				'feature_draw_separate_base_image',
			),
			'tags' => array('experimental'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_docs' => array(
			'name' => tra('Docs (WebODF)'),
			'description' => tra('Docs enables viewing and editing Open Document Format files'),
			'help' => 'Docs',
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_file_galleries',
			),
			'tags' => array('experimental'),
		),
		'feature_dynamic_content' => array(
			'name' => tra('Dynamic Content System'),
			'description' => tra('Bloc of content which can be reused and programmed (timed)'),
			'help' => 'Dynamic+Content',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-list_contents.php',
		),
		'feature_filegals_manager' => array(
			'name' => tra('Use File Galleries to store images'),
			'type' => 'flag',
			'description' => tra('If not enabled, images will be stored in the file system, in the /img/wiki_up directory, instead.'),
			'default' => 'y',
		),
		'feature_wiki_ext_icon' => array(
			'name' => tra('External link icon'),
			'type' => 'flag',
			'description' => tra('External links will be identified with an icon. To customize the icon change the "link-external" icon in the icon set.'),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_ext_rel_nofollow' => array(
			'name' => tra('Add "rel=nofollow" on external links'),
			'description' => tra("nofollow is used to instruct some search engines that the link should not influence the ranking of the link's target in the search engine's index"),
			'type' => 'flag',
			'keywords' => 'no follow spam',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_semantic' => array(
			'name' => tra('Semantic links'),
			'description' => tra('Going beyond Backlinks functionality, this allows some semantic relationships to be defined between wiki pages'),
			'help' => 'Semantic',
			'type' => 'flag',
			'dependencies' => array(
				'feature_backlinks',
			),
			'default' => 'n',
		),
		'feature_webservices' => array(
			'name' => tra('Web Services'),
			'description' => tra('Can receive web services via JSON or YAML'),
			'help' => 'WebServices',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_menusfolderstyle' => array(
			'name' => tra('Use folder icons for menu section (parent) items'),
            'description' => tra('When a menu isn\'t set as a Bootstrap or CSS menu, use folder icons for menu section items (rather than plus/minus signs); defaults to "y"'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_breadcrumbs' => array(
			'name' => tra('Breadcrumbs'),
			'description' => tra('Indicates the navigation path through parent pages to the current page'),
			'help' => 'Breadcrumbs',
			'warning' => tra('Unmaintained feature'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_antibot' => array(
			'name' => tra('Anonymous editors must enter anti-bot code (CAPTCHA)'),
            'description' => tra('Use CAPTCHA to ensure that anonymous input is from a person'),
			'help' => 'Spam+protection',
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_protect_email' => array(
			'name' => tra('Protect email against spam'),
            'description' => tra('protect email against spam submissions'),
			'help' => 'Spam+protection',
			'warning' => tra('Protect email against spam currently does not operate in pages edited in WYSIWYG mode (Tiki 6.1)'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_sitead' => array(
			'name' => tra('Activate'),
            'description' => tra('enable advertising'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_poll_anonymous' => array(
			'name' => tra('Anonymous voting'),
            'description' => tra('Allow anonymous users to participate in voting'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_poll_revote' => array(
			'name' => tra('Allow re-voting'),
            'description' => tra('permit multiple votes'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_poll_comments' => array(
			'name' => tra('Comments for polls'),
            'description' => tra('Permit commenting on polls'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_polls',
			),
			'default' => 'n',
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',
		),
		'feature_faq_comments' => array(
			'name' => tra('Comments for FAQs'),
            'description' => tra('Permit commenting on FAQs'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_faqs',
			),
			'default' => 'y',
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',
		),
		'feature_sefurl' => array(
			'name' => tra('Search engine friendly URL'),
			'description' => tra('If the site is using Apache, you can rename _htaccess as .htaccess to use short URLs. On IIS, rename web_config as web.config'),
			'help' => 'Clean+URLs',
			'perspective' => false,
			'type' => 'flag',
			'keywords' => 'sefurl sefurls seo rewrite rules short urls',
			'dependencies' => array(
				'wiki_badchar_prevent',
			),
			'default' => 'n',
			'admin' => 'sefurl',
		),
		'feature_sefurl_filter' => array(
			'name' => tra('Search engine friendly URL Postfilter'),
            'description' => tra(''),
			'help' => 'Rewrite+Rules',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),
		'feature_sefurl_title_article' => array(
			'name' => tra('Display article title in the search engine friendly URL'),
            'description' => tra(''),
			'type' => 'flag',
			'perspective' => false,
			'dependencies' => array('feature_sefurl'),
			'default' =>'y',
		),
		'feature_sefurl_title_blog' => array(
			'name' => tra('Display blog title in the search engine friendly URL'),
            'description' => tra(''),
			'type' => 'flag',
			'perspective' => false,
			'dependencies' => array('feature_sefurl'),
			'default' =>'y',
		),
		'feature_sefurl_tracker_prefixalias' => array(
			'name' => tra('Rewrite tiki-view_tracker.php?itemId=yyy to Prefixyyy page'),
			'description' => tra('This redirection uses the wiki prefix alias feature'),
			'help' => 'Page+Alias',
			'perspective' => false,
			'type' => 'flag',
			'dependencies' => array('feature_sefurl', 'wiki_prefixalias_tokens'),
			'default' =>'n',
		),
		'feature_canonical_url' => array(
			'name' => tra('Canonical URL tag'),
			'description' => tra('Indicates to search engines which URL to use, to prevent duplicate listings'),
			'type' => 'flag',
			'perspective' => false,
			'default' =>'y',
		),
		'feature_canonical_domain' => array(
			'name' => tra('Canonical URL domain'),
			'description' => tra("If this is a testing site with duplicate content, you may want to put the real site domain here so search engines don't index the testing site. In complex perspective setups using multiple domains, you may want more control on which canonical domain is advertised."),
			'type' => 'text',
			'dependencies' => array('feature_canonical_url'),
			'default' =>'',
		),
		'feature_modulecontrols' => array(
			'name' => tra('Show module controls'),
            'description' => tra('Enable controls in modules'),
			'help' => 'Module',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_perspective' => array(
			'name' => tra('Perspectives'),
			'description' => tra('Permits overriding of preferences.'),
			'help' => 'Perspectives',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
			'module' => 'perspective',
			'plugin' => 'perspective',
			'permission' => array(
				'textFilter' => 'perspective',
			),
			'view' => 'tiki-edit_perspective.php',
		),
		'feature_wiki_replace' => array(
			'name' => tra('Search and replace'),
			'description' => tra('Enables finding and replacing of content in the edit box'),
			'help' => 'Regex+search+and+replace',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_submissions' => array(
			'name' => tra('Submissions'),
			'description' => tra('Submissions are submitted but need to be approved before they are published'),
			'help' => 'Articles',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-list_submissions.php',
			'module' => 'submission',
			'permission' => array(
				'textFilter' => 'submission',
			),
		),
		'feature_cms_rankings' => array(
			'name' => tra('Rankings'),
            'description' => tra('Enable ranking of items'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_article_comments' => array(
			'name' => tra('Comments on articles'),
            'description' => tra('Enable comments on articles'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_articles',
			),
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',
		),
		'feature_cms_templates' => array(
			'name' => tra('Article content templates'),
            'description' => tra('Predefined content for an article'),
			'type' => 'flag',
			'help' => 'Content+Template',
			'keywords' => tra('template article news'),
			'view' => 'tiki-admin_content_templates.php',
			'default' => 'n',
		),
		'feature_cms_print' => array(
			'name' => tra('Print'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_cms_emails' => array(
			'name' => tra('Specify notification emails when creating articles'),
            'description' => tra('Should a notification email be sent when creating an article? Remember that you can also predefine notification emails for article topics when you re-edit the topic after its creation'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_cms_sharethis' => array(
			'name' => tra('ShareThis buttons'),
			'description' => tra('Enable sharing site content via ShareThis'),
			'type' => 'flag',
			'hint' => tra('Insert a ShareThis button from www.sharethis.com.'),
			'default' => 'n',
		),
		'feature_categorypath' => array(
			'name' => tra('Category Path'),
			'description' => tra('Show the category tree above the wiki page'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_categoryobjects' => array(
			'name' => tra('Show category objects'),
			'description' => tra('Show, at the bottom of the wiki page, objects in the same category'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_search_show_forbidden_cat' => array(
			'name' => tra('Ignore category viewing restrictions'),
            'description' => tra('allow showing forbidden (restricted) items in search result'),
			'hint' => tra('Will improve performance, but may show forbidden results'),
			'type' => 'flag',
			'help' => 'Search',
			'default' => 'n',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_listPages' => array(
			'name' => tra('List pages'),
            'description' => tra('Allow viewing the wiki page list'),
			'type' => 'flag',
			'view' => 'tiki-listpages.php',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_lastChanges' => array(
			'name' => tra('Latest Changes'),
            'description' => tra('Show the list of last-changed items'),
			'type' => 'flag',
			'view' => 'tiki-lastchanges.php',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_listorphanPages' => array(
			'name' => tra('Orphan pages'),
            'description' => tra('Allow listing of \"orphan pages\" (pages not linked to from another page)'),
			'type' => 'flag',
			'view' => 'tiki-orphan_pages.php',
			'default' => 'n',
		),
		'feature_search_fulltext' => array(
			'name' => tra('MySQL full-text search'),
			'description' => tra("Also known as 'Basic Search'. This search uses the MySQL full-text search feature. The indexation is continuously updated."),
			'warning' => tra("Deprecated: This feature is unmaintained and may not be reliable. InnoDB doesn't support Full-Text Search earlier than version 5.6."),
			'type' => 'flag',
			'help' => 'Search',
			'default' => 'n',
			'dbfeatures' => array('mysql_fulltext'),
			'admin' => 'search',
			'view' => 'tiki-searchresults.php',
			'module' => 'search',
			'permission' => array(
				'textFilter' => 'search',
			),
		),
		'feature_referer_highlight' => array(
			'name' => tra('Referer search highlighting'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Referer+Search+Highlighting',
			'default' => 'y',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_search_stats' => array(
			'name' => tra('Search statistics'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Search+Stats',
			'default' => 'n',
			'keywords' => 'stat analytics',
			'view' => 'tiki-search_stats.php',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_search_show_forbidden_obj' => array(
			'name' => tra('Ignore individual object permissions'),
            'description' => tra('allow forbidden items in search result'),
			'hint' => tra('Will improve performance, but may show forbidden results'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_search_show_object_filter' => array(
			'name' => tra('Object filter'),
            'description' => tra('allow filtering of objects'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_search_show_search_box' => array(
			'name' => tra('Search box'),
            'description' => tra('make the search box visible'),
			'type' => 'flag',
			'default' => 'y',
			'dependencies' => array(
				'feature_search_fulltext',
			),
		),
		'feature_search_show_visit_count' => array(
			'name' => tra('Visits'),
            'description' => tra('show number of visits'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_search_show_pertinence' => array(
			'name' => tra('Relevance'),
            'description' => tra('enable searching by relevance'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_search_show_object_type' => array(
			'name' => tra('Object type'),
            'description' => tra('search for a specific object type'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_search_show_last_modification' => array(
			'name' => tra('Last-modified date'),
            'description' => tra('Show the last-modified date'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_blog_rankings' => array(
			'name' => tra('Rankings'),
            'description' => tra('Enable ranking of blog posts'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_blog_heading' => array(
			'name' => tra('Custom blog headings'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
			'warning' => tr('Using custom blog headings will use significantly more server resources. Unless you need per-blog templates, you should customize the template file instead.'),
		),
		'feature_blog_edit_publish_date' => array(
			'name' => tra('Publish dates can be modified'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_blogposts_comments' => array(
			'name' => tra('Comments on blog posts'),
            'description' => tra(''),
			'type' => 'flag',
			'dependencies' => array(
				'feature_blogs',
			),
			'default' => 'y',
			'tags' => array('basic'),
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',
		),
		'feature_blog_sharethis' => array(
			'name' => tra('ShareThis buttons'),
			'description' => tra('Enable sharing site content via ShareThis'),
			'type' => 'flag',
			'hint' => tra('Insert a ShareThis button from [http://www.sharethis.com].'),
			'default' => 'n',
		),
		'feature_file_galleries_rankings' =>array(
			'name' => tra('Rankings'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'default' => 'n',
		),
		'feature_file_galleries_comments' =>array(
			'name' => tra('File Gallery Comments'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Comments',
			'default' => 'n',
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',
		),
		'feature_use_fgal_for_user_files' =>array(
			'name' => tra('Use file galleries for user files'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'dependencies' => array(
				'feature_file_galleries','feature_userfiles'
			),
			'default' => 'n',
			'tags' => array('experimental'),
			'warning' => tra('experimental'),
			'keywords' => tra('userfiles'),
		),
		'feature_use_fgal_for_wiki_attachments' =>array(
			'name' => tra('Use file galleries for wiki attachments'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'dependencies' => array(
				'feature_file_galleries','feature_wiki_attachments'
			),
			'default' => 'n',
			'tags' => array('experimental'),
			'warning' => tra('experimental'),
		),
		'feature_file_galleries_author' => array(
			'name' => tra("Require file creator's name for anonymous uploads"),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'default' => 'n',
		),
		'feature_file_galleries_batch' => array(
			'name' => tra('Batch uploading'),
			'description' => tra('Direct import of local files into a file gallery. This method can handle large files. The user can upload files via FTP to the target folder'),
			'hint' => tra('Use batch uploading to transfer large files to file galleries'),
			'type' => 'flag',
			'help' => 'Batch+Upload',
			'default' => 'n',
		),
		'feature_forum_rankings' => array(
			'name' => tra('Rankings'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_forum_parse' => array(
			'name' => tra('Accept wiki syntax'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Wiki+Syntax',
			'default' => 'n',
		),
		'feature_forum_topics_archiving' => array(
			'name' => tra('Topic archiving'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_forum_quickjump' => array(
			'name' => tra('Quick jumps'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_forum_replyempty' => array(
			'name' => tra('Replies are empty'),
            'description' => tra(''),
			'type' => 'flag',
			'hint' => tra('If disabled, replies will quote the original post'),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_forum_allow_flat_forum_quotes' => array(
			'name' => tra('Allows quoting in flat forums'),
			'description' => tra('Allows users to reply/'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_forums_allow_thread_titles' => array(
			'name' => tra('First post of a thread can have an empty body'),
            'description' => tra(''),
			'type' => 'flag',
			'hint' => tra('Will be a thread title'),
			'default' => 'n',
		),
		'feature_forums_name_search' => array(
			'name' => tra('Forum name search'),
            'description' => tra(''),
			'type' => 'flag',
			'hint' => tra('When listing forums'),
			'default' => 'n',
		),
		'feature_forums_search' => array(
			'name' => tra('Forum content search'),
            'description' => tra(''),
			'type' => 'flag',
			'hint' => tra('When listing forums'),
			'default' => 'y',
		),
		'feature_forum_content_search' => array(
			'name' => tra('Topic content search'),
            'description' => tra(''),
			'type' => 'flag',
			'dependencies' => array(
				'feature_search',
			),
			'default' => 'y',
		),
		'feature_forum_local_tiki_search' => array(
			'name' => tra('Tiki-indexed search.'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_search',
			),
		),
		'feature_forum_local_search' => array(
			'name' => tra('Use database (full-text) search.'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_search_fulltext',
			),
		),
		'feature_forum_post_index' => array(
			'name' => tra('Index posts on forum section change.'),
			'description' => tra('Re-indexes forum posts to match the parent section when the section is changed'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_clear_passwords' => array(
			'name' => tra('Store password as plain text'),
            'description' => tra(''),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),

		'feature_crypt_passwords' => array(
			'name' => tra('Encryption method'),
            'description' => tra(''),
			'type' => 'list',
			'options' => array(
				'crypt-md5' => 'crypt-md5',
				'crypt-des' => 'crypt-des',
				'tikihash' => tra('tikihash (old)'),
			),
			'perspective' => false,
			'default' => (CRYPT_MD5 == 1)? 'crypt-md5': 'tikihash',
		),
		'feature_editcss' => array(
			'name' => tra('Edit CSS'),
			'description' => tra('Edit CSS files directly in the browser.'),
			'type' => 'flag',
			'help' => 'Edit+CSS',
			'perspective' => false,
			'default' => 'n',
			'view' => 'tiki-edit_css.php',
		),
		'feature_theme_control' => array(
			'name' => tra('Theme Control'),
			'description' => tra('Assign different themes to different sections, categories, and objects'),
			'keywords' => tra('design themes'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_categories',
			),
			'default' => 'n',
			'view' => 'tiki-theme_control.php',
		),
		'feature_view_tpl' => array(
			'name' => tra('Tiki Template Viewing'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'View+Templates',
			'keywords' => tra('template'),
			'perspective' => false,
			'default' => 'n',
		),
		'feature_edit_templates' => array(
			'name' => tra('Edit Templates'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Edit+Templates',
			'keywords' => tra('template'),
			'perspective' => false,
			'dependencies' => array(
				'feature_view_tpl',
			),
			'default' => 'n',
			'view' => 'tiki-edit_templates.php',
			'tags' => array('experimental'),
		),
		'feature_custom_html_head_content' => array(
			'name' => tra('Custom HTML <head> Content'),
			'description' => tra('Use to include custom &lt;meta&gt; or &lt;link&gt; tags.'),
            'hint' => tra('Example:') . " {if \$page eq 'Slideshow'}{literal}<style type=\"text/css\">.slideshow { height: 232px; width: 232px; }</style>{/literal}{/if}",
            'type' => 'textarea',
			'size' => '6',
			'filter' => 'rawhtml_unsafe',
			'default' => '',
		),
		'feature_html_head_base_tag' => array(
			'name' => tra('Add <base> tag in the page <head>'),
            'description' => tra('The &lt;base&gt; tag specifies a default address for all links on a page.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_sitelogo' => array(
			'name' => tra('Site logo and title'),
            'description' => tra('Display a site logo image and/or title'),
			'type' => 'flag',
			'warning' => tra('This setting is expected to be moved from here to the admin-modules page .'),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_left_column' => array(
			'name' => tra('Left column'),
            'description' => tra(''),
			'type' => 'list',
			'help' => 'Users+Flip+Columns',
			'hint' => tra('Controls visibility of the left column of modules'),
			'keywords' => tra('sidebar'),
			'options' => array(
				'y' => tra('Only if one or more modules are assigned'),
				'fixed' => tra('Always'),
				'user' => tra('User decides'),
				'n' => tra('Never'),
			),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_right_column' => array(
			'name' => tra('Right column'),
            'description' => tra(''),
			'type' => 'list',
			'help' => 'Users+Flip+Columns',
			'hint' => tra('Controls visibility of the right column of modules'),
			'keywords' => tra('sidebar'),
			'options' => array(
				'y' => tra('Only if one or more modules are assigned'),
				'fixed' => tra('Always'),
				'user' => tra('User decides'),
				'n' => tra('Never'),
			),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_siteloclabel' => array(
			'name' => tra('Prefix breadcrumbs with "Location : "'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_siteloc' => array(
			'name' => tra('Site location bar'),
            'description' => tra(''),
			'type' => 'list',
			'options' => array(
				'y' => tra('Use breadcrumbs module'),
				'page' => tra('Top of center column'),
				'n' => tra('None'),
			),
			'default' => 'y',
		),
		'feature_sitetitle' => array(
			'name' => tra('Larger font for'),
            'description' => tra(''),
			'type' => 'list',
			'options' => array(
				'y' => tra('Entire location'),
				'title' => tra('Page name'),
				'n' => tra('None'),
			),
			'default' => 'y',
		),
		'feature_sitedesc' => array(
			'name' => tra('Use page description'),
            'description' => tra(''),
			'type' => 'list',
			'options' => array(
				'y' => tra('Extreme top of page, above the site logo, etc'),
				'page' => tra('Top of center column'),
				'n' => tra('None'),
			),
			'dependencies' => array(
				'feature_wiki_description',
			),
			'default' => 'n',
		),
		'feature_endbody_code' => array(
			'name' => tra('Custom code just before the closing </body> tag'),
            'description' => tra(''),
			'type' => 'textarea',
			'size' => '6',
			'filter' => 'rawhtml_unsafe',
			'default' => '',
		),
		'feature_site_report' => array(
			'name' => tra('Webmaster report'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_site_report_email' => array(
			'name' => tra('Webmaster email'),
            'description' => tra(''),
			'hint' => tra('Leave blank to use the default sender email'),
			'type' => 'text',
			'size' => '20',
			'dependencies' => array(
				'sender_email',
			),
			'default' => '',
		),
		'feature_site_send_link' => array(
			'name' => tra('Email this page'),
			'description' => tra('Add a link at the bottom if set, otherwise add a link at the top'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_tell_a_friend',
			),
			'default' => 'n',
		),
		'feature_layoutshadows' => array(
			'name' => tra('Shadow layer'),
            'description' => tra(''),
			'hint' => tra('Additional div elements for shadows, radiused corners or other decorative styling'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_jquery_tooltips' => array(
			'name' => tra('Tooltips'),
            'description' => tra('Make tooltips such as this appear in a custom style. Use CSS to change their appearance.'),
			'type' => 'flag',
			'help' => 'JQuery#Tooltips',
			'default' => 'y',		// use JQuery tooltips and override Overlib
		),
		'feature_jquery_autocomplete' => array(
			'name' => tra('Autocomplete'),
			'description' => tra('Provides various dropdown menus on many text input boxes for page names, user names, groups, tags, etc.'),
			'type' => 'flag',
            'help' => 'JQuery#Autocomplete',
            'dependencies' => array(
				'feature_jquery_ui',
			),
			'default' => 'y',	// autocomplete on pages in QuickEdit (more coming soon)
		),
		'feature_jquery_superfish' => array(
			'name' => tra('Superfish'),
            'description' => tra('Adds animation effects to CSS "Suckerfish" menus.'),
			'type' => 'flag',
			'help' => 'JQuery#Superfish',
			'default' => 'y',		// Effects on CSS (Suckerfish) menus
		),
		'feature_jquery_reflection' => array(
			'name' => tra('Reflection'),
            'description' => tra('Creates a reflection under an image. Used in Plugin Img with the parameter "class=reflect"'),
			'type' => 'flag',
			'help' => 'JQuery#Reflection',
			'default' => 'n',		// reflection effects on images
		),
		'feature_jquery_ui' => array(
			'name' => tra('JQuery UI'),
            'description' => tra('Include jQuery UI library. Enables a number of interface features.'),
			'type' => 'flag',
			'help' => 'JQuery#UI',
			'default' => 'y',				// include UI lib for more effects
		),
		'feature_jquery_ui_theme' => array(
			'name' => tra('jQuery UI theme'),
            'description' => tra('jQuery UI theme. Used in some modal popups and in the TikiSheet feature, etc.'),
			'help' => 'JQuery#UI',
			'type' => 'list',
			'options' => array(
				'none' => tra('None'),
				'black-tie' => 'black-tie',
				'blitzer' => 'blitzer',
				'cupertino' => 'cupertino',
				'dark-hive' => 'dark-hive',
				'dot-luv' => 'dot-luv',
				'eggplant' => 'eggplant',
				'excite-bike' => 'excite-bike',
				'flick' => 'flick',
				'hot-sneaks' => 'hot-sneaks',
				'humanity' => 'humanity',
				'le-frog' => 'le-frog',
				'mint-choc' => 'mint-choc',
				'overcast' => 'overcast',
				'pepper-grinder' => 'pepper-grinder',
				'redmond' => 'redmond',
				'smoothness' => 'smoothness',
				'south-street' => 'south-street',
				'start' => 'start',
				'sunny' => 'sunny',
				'swanky-purse' => 'swanky-purse',
				'trontastic' => 'trontastic',
				'ui-darkness' => 'ui-darkness',
				'ui-lightness' => 'ui-lightness',
				'vader' => 'vader',
			),
			'default' => 'flick',	// theme for UI lib (see http://jqueryui.com/themeroller/ for list & demos - previously ui-darkness)
		),
		'feature_jquery_validation' => array(
			'name' => tra('Validation'),
            'description' => tra('Provides various validation possibilities such as for trackers.'),
			'type' => 'flag',
			'help' => 'JQuery#Validation',
			'default' => 'y',		// validation on Trackers etc
		),
		'feature_jquery_carousel' => array(
			'name' => tra('jQuery Infinite Carousel'),
            'description' => tra('Creates a slideshow (like an image carousel) for file galleries. Used in Plugin Carousel'),
			'type' => 'flag',
			'help' => 'PluginCarousel',
			'default' => 'n',		// slideshow/carousel for file gals etc
		),
		'feature_jquery_tablesorter' => array(
			'name' => tra('jQuery Sortable Tables'),
			'description' => tra('Provides an interactive way to sort and filter data in tables produced with Plugin FancyTable and Plugin TrackerList, as well as administrative tables.'),
			'type' => 'flag',
			'help' => 'JQuery#TableSorter',
			'warning' => tra('This feature can cause problems with JS minify on some systems.'),
			'default' => 'n',	// sortable tables ([will] override existing)
		),
		'feature_jquery_media' => array(
			'name' => tra('jQuery Media'),
            'description' => tra('Provides a media player via Plugin MediaPlayer that can be used in wiki pages or other wiki text area to play media files including .flv, .mp3, .mp4, .swf, .avi, .wmv, .ram, .mov, .mpeg, and .pdf. A Flash-based open source media player is used.'),
			'type' => 'flag',
			'help' => 'PluginMediaPlayer',
			'default' => 'n',
		),
		'feature_jquery_tagcanvas' => array(
			'name' => tra('TagCanvas'),
            'description' => tra('TagCanvas is a Javascript class which will draw and animate a HTML5 canvas based tag cloud'),
			'type' => 'flag',
			'help' => 'TagCanvas',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_jquery_zoom' => array(
			'name' => tra('jQuery Zoom'),
            'description' => tra('Enables zoom in images on mouseover or click. Used in Plugin Img with the parameter \"thumb=zoombox\"'),
			'type' => 'flag',
			'help' => 'PluginImg#Zoombox',
			'default' => 'n',
		),
		'feature_tabs' => array(
			'name' => tra('Use Tabs'),
			'description' => tra('Separates page content into tabbed panels'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_iepngfix' => array(
			'name' => tra('IE Image Fix'),
            'description' => tra('Correct PNG images alpha transparency in IE6 (experimental)'),
			'tags' => array('experimental'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_1like_redirection' => array(
			'name' => tra("Redirect to similar wiki page"),
            'description' => tra("If a requested page doesn't exist, redirect to a similarly named page"),
			'type' => 'flag',
			'help' => 'Redirect+to+similar+wiki+page',
			'default' => 'n',
		),
		'feature_wiki_pagealias' => array(
			'name' => tra("Redirect to page alias, if any"),
            'description' => tra("If a requested page doesn't exist, redirect to an alias page, if specified using an alias semantic link"),
            'type' => 'flag',
			'help' => 'Page+Alias',
			'dependencies' => array(
				'feature_wiki_1like_redirection',
				'feature_semantic', // this is needed at point of creation of semantic link otherwise link will not register
			),
			'default' => 'y',
		),
		'feature_wiki_templates' => array(
			'name' => tra('Wiki content templates'),
            'description' => tra('Prewritten content (probably partial content) for a wiki page'),
			'type' => 'flag',
			'keywords' => tra('template'),
			'help' => 'Content+Template',
			'default' => 'n',
			'view' => 'tiki-admin_content_templates.php',
		),
		'feature_warn_on_edit' => array(
			'name' => tra('Warn on edit conflict'),
			'description' => tra('Provide a warning to a user who attempts to edit a page that it is currently being edited by another user.'),
            'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_undo' => array(
			'name' => tra('Undo'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_footnotes' => array(
			'name' => tra('Footnotes'),
            'description' => tra('Enable creating private notes for a page that are visible only to the author.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_allowhtml' => array(
			'name' => tra('Allow HTML'),
            'description' => tra('Per-page option: HTML tags are used to create elements of the wiki page, instead of being displayed as code.'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_actionlog_bytes' => array(
			'name' => tra('Log bytes changes (+/-) in action logs'),
            'description' => tra(''),
			'type' => 'flag',
			'hint' => tra('May impact performance'),
			'default' => 'n',
		),
		'feature_sandbox' => array(
			'name' => tra('Sandbox'),
            'description' => tra('A special wiki page for testing that can edited but not permanently saved.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_comments' => array(
			'name' => tra('Comments below wiki pages'),
            'description' => tra('Allow users (with permission) to post threaded comments to a page.'),
			'type' => 'flag',
			'help' => 'Comments',
			'dependencies' => array(
				'feature_wiki',
			),
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',
		),
		'feature_wiki_pictures' => array(
			'name' => tra('Images'),
            'description' => tra('Allow users to upload images to a page.'),
			'type' => 'flag',
			'help' => 'Wiki-Syntax+Images',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_export' => array(
			'name' => tra('Export'),
            'description' => tra('permit exporting wiki pages'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wikiwords' => array(
			'name' => tra('WikiWords'),
            'description' => tra('Automatically convert \"CamelCase\" words into wiki links.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_plurals' => array(
			'name' => tra('Link plural WikiWords to their singular forms'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_wikiwords_usedash' => array(
			'name' => tra('Accept dashes and underscores in WikiWords'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_history' => array(
			'name' => tra('History'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'History',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_history_ip' => array(
			'name' => tra('Display IP address'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_history_full' => array(
			'name' => tra('Wiki full history'),
            'description' => tra('Record all versions, rather than only when page content or description changes or when an edit comment is given'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_page_contribution' => array(
			'name' => tra('View page contributions by author'),
            'description' => tra('Visualize the contributions that different authors have made to a wiki page'),
			'type' => 'flag',
			'dependencies' => array (
				'feature_history'
			),
			'default' => 'n',
		),
		'feature_wiki_discuss' => array(
			'name' => tra('Discuss pages on forums'),
            'description' => tra('Include a link on each page to a forum topic.'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_forums'
			),
			'default' => 'n',
		),
		'feature_source' => array(
			'name' => tra('View source'),
            'description' => tra('Enable viewing the source of wiki pages'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_ratings' => array(
			'name' => tra('Rating'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Rating',
			'dependencies' => array(
				'feature_polls'
			),
			'default' => 'n',
		),
		'feature_backlinks' => array(
			'name' => tra('Backlinks'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Backlinks',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_likePages' => array(
			'name' => tra('Similar pages'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_rankings' => array(
			'name' => tra('Rankings'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_structure' => array(
			'name' => tra('Structures'),
            'description' => tra('Structures allow grouping any number of wiki pages in a hierarchy, with a common navigation bar and the option to print them all together as a single HTML document'),
			'type' => 'flag',
			'help' => 'Structure',
			'default' => 'n',
		),
		'feature_wiki_structure_drilldownmenu' => array(
			'name' => tra('Structures drill down menu'),
            'description' => tra('Ajax-style menu in which the user moves through the page hierarchy by clicking to reveal the next level down'),
			'type' => 'flag',
			'help' => 'Structure',
			'keywords' => 'wiki ajax structure',
			'default' => 'n',
			'dependencies' => array(
				'feature_cssmenus'
			),
		),
		'feature_wiki_open_as_structure' => array(
			'name' => tra('Open page as structure'),
            'description' => tra('Open a page within its structure (with structure navigation, etc.), even if no structure parameter is given in the URL'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_make_structure' => array(
			'name' => tra('Make structure from page'),
            'description' => tra('Show a button below each wiki page to allow converting it from a simple wiki page into the root page of a new structure'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_categorize_structure' => array(
			'name' => tra('Categorize structure pages together'),
            'description' => tra('Place new pages of a structure in the same category as the structure\'s root page'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_no_inherit_perms_structure' => array(
			'name' => tra('Disable inherited direct object permissions'),
            'description' => tra('Normally pages will inherit object permissions from their parent page. However, object permissions override category permissions. So, if you are relying on category permissions in structures, you may want to consider this setting, in order to disable inheritance of direct object permissions when adding pages from a structure'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_create_webhelp' => array(
			'name' => tra('Create webhelp from structure'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_import_html' => array(
			'name' => tra('Import HTML'),
            'description' => tra('allow import of HTML pages'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_use_date' => array(
			'name' => tra('Use date parameter'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_use_date_links' => array(
			'name' => tra('Report it in wiki links'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_import_page' => array(
			'name' => tra('Import pages'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_userpage' => array(
			'name' => tra("User's information page"),
			'description' => tra('A personal page for the user to manage.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_userpage_prefix' => array(
			'name' => tra('Userpage prefix'),
			'description' => tra('All userpages share a common prefix. The page name will be a concatenation of the prefix and the username. A prefix is required.'),
			'type' => 'text',
			'size' => '40',
			'default' => 'User:',
		),
		'feature_wiki_usrlock' => array(
			'name' => tra('Users can lock pages'),
            'description' => tra('Enable users to lock pages and so prevent others from editing them'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_multiprint' => array(
			'name' => tra('MultiPrint'),
            'description' => tra('Enable printing of multiple wiki pages as well as an entire structure of wiki pages as a book in a single HTML document'),
			'type' => 'flag',
			'default' => 'n',
		),

		'feature_wiki_print' => array(
			'name' => tra('Print'),
            'description' => tra('Provide a print icon and layout of the wiki page formatted for printing'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_listorphanStructure' => array(
			'name' => tra('Pages not in structure'),
            'description' => tra('List pages not in structure'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_attachments' => array(
			'name' => tra('Attachments'),
            'description' => tra('Allow users to upload (attach) files to a page.'),
			'type' => 'flag',
			'help' => 'Attachments',
			'default' => 'n',
			'admin' => 'wikiatt',
			'permission' => array(
				'textFilter' => 'attach wiki',
			),
		),
		'feature_wiki_sharethis' => array(
			'name' => tra('ShareThis buttons'),
			'description' => tra('Enable sharing site content via ShareThis'),
			'type' => 'flag',
			'hint' => tra('Insert a ShareThis button from www.sharethis.com.'),
			'default' => 'n',
		),
		'feature_dump' => array(
			'name' => tra('Dumps'),
            'description' => tra('Enable exporting the site as a downloadable archive'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_mandatory_category' => array(
			'name' =>  tra('Wiki:').' '.tra('Limit categorization to within the subtree of'),
			'description' => tra('If an error message indicates a mandatory category is required when editing a wiki page, set this option to "None".'),
			'type' => 'list',
			'options' => $catree,
			'dependencies' => array(
				'feature_categories',
				'feature_wiki',
			),
			'default' => -1,
		),
		'feature_image_gallery_mandatory_category' => array(
			'name' =>  tra('Image Gallery:').' '.tra('Limit categorization to within the subtree of'),
			'description' => tra('If an error message indicates a mandatory category is required when editing an image (in an image gallery), set this option to "None".'),
			'type' => 'list',
			'options' => $catree,
			'dependencies' => array(
				'feature_categories',
				'feature_galleries',
			),
			'default' => -1,
		),
		'feature_wiki_show_hide_before' => array(
			'name' => tra('Show/hide icon before headings'),
            'description' => tra('Display before headings an icon to show or hide the content that follows the headings'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_argvariable' => array(
			'name' => tra('Wiki argument variables'),
			'description' => tra('Allow writing request variables in wiki content using {{paramname}} or {{paramname|default}} - special case {{page}} {{user}}'),
			'type' => 'flag',
			'help' => 'Advanced+Wiki+Syntax+usage+examples',
			'default' => 'n',
		),
		'feature_challenge' => array(
			'name' => tra('Use challenge/response authentication'),
            'description' => tra(''),
			'type' => 'flag',
			'hint' => tra('Confirm that the Admin account has a valid email address or you will not be able to log in'),
			'default' => 'n',
			'warning' => tr('Deprecated: This feature is unmaintained and may not be reliable'),
		),
		'feature_show_stay_in_ssl_mode' => array(
			'name' => tra('Users can choose to stay in SSL mode after an HTTPS login'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_switch_ssl_mode' => array(
			'name' => tra('Users can switch between secured or standard mode at login'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_paragraph_formatting' => array(
			'name' => tra('Wiki paragraph formatting'),
			'description' => tra('Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines.').' '.tra('Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line.'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_wiki_paragraph_formatting_add_br' => array(
			'name' => tra('...but still create line breaks within paragraphs'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_wiki_monosp' => array(
			'name' => tra('Automonospaced text'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_tables' => array(
			'name' => tra('Tables syntax'),
            'description' => tra(''),
			'type' => 'list',
			'options' => array(
				'old' => tra('|| for rows'),
				'new' => tra('<return> for rows'),
			),
			'default' => 'new',
		),
		'feature_autolinks' => array(
			'name' => tra('AutoLinks'),
            'description' => tra('Web (http://) and email addresses will automatically be converted to links.'),
			'type' => 'flag',
			'help' => 'AutoLinks',
			'default' => 'y',
		),
		'feature_hotwords' => array(
			'name' => tra('Hotwords'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Hotwords',
			'default' => 'n',
			'view' => 'tiki-admin_hotwords.php',
		),
		'feature_hotwords_nw' => array(
			'name' => tra('Open hotwords in new window'),
            'description' => tra(''),
			'type' => 'flag',
			'dependencies' => array(
				'feature_hotwords',
			),
			'default' => 'n',
		),
		'feature_hotwords_sep' => array(
			'name' => tra('Characters that limit a hotword'),
            'description' => tra(''),
			'type' => 'text',
			'dependencies' => array(
				'feature_hotwords',
			),
			'default' => ' \n\t\r\,\;\(\)\.\:\[\]\{\}\!\?\"',
		),
		'feature_use_quoteplugin' => array(
			'name' => tra('Use Quote plugin rather than ">" for quoting'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'PluginQuote',
			'dependencies' => array(
				'wikiplugin_quote',
			),
			'default' => 'n',
		),
		'feature_use_three_colon_centertag' => array(
			'name' => tra('Center text using ::: instead of ::'),
			'description' => tr('Useful to avoid conflicts with C++ scope operators or default namespace separator.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_simplebox_delim' => array(
			'name' => tra('String to use to delimit simplebox'),
            'description' => tra(''),
			'type' => 'text',
			'default' => '^',
		),
		'feature_community_gender' => array(
			'name' => tra('Users can choose to show their gender'),
            'description' => tra("Display a user's gender if they permit it"),
			'type' => 'flag',
			'help' => 'User+Preferences',
			'dependencies' => array(
				'feature_userPreferences',
			),
			'default' => 'n',
		),
		'feature_community_mouseover' => array(
			'name' => tra("Allow showing user's information on mouseover"),
			'description' => tra("Site feature to allow showing user's information on mouseover"),
			'type' => 'flag',
			'help' => 'User+Preferences',
			'hint' => tra("Requires user's information to be public"),
			'default' => 'n',
		),
		'feature_community_mouseover_name' => array(
			'name' => tra('Real name'),
            'description' => tra("Show the user's real name"),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_gender' => array(
			'name' => tra('Gender'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_picture' => array(
			'name' => tra('Profile picture (avatar)'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_score' => array(
			'name' => tra('Score'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Score',
			'default' => 'y',
		),
		'feature_community_mouseover_country' => array(
			'name' => tra('Country'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_email' => array(
			'name' => tra('Email'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_lastlogin' => array(
			'name' => tra('Last login'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_distance' => array(
			'name' => tra('Distance'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_list_name' => array(
			'name' => tra('Name'),
            'description' => tra(''),
			'type' => 'flag',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_community_list_score' => array(
			'name' => tra('Score'),
            'description' => tra(''),
			'type' => 'flag',
			'help' => 'Score',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_community_list_country' => array(
			'name' => tra('Country'),
            'description' => tra(''),
			'type' => 'flag',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_community_list_distance' => array(
			'name' => tra('Distance'),
            'description' => tra(''),
			'type' => 'flag',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_cal_manual_time' => array(
			'name' => tra('Manual selection of time/date'),
            'description' => tra(''),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_webdav' => array(
			'name' => tra('WebDAV access to Tiki'),
			'description' => tra('Allow file gallery access with WebDAV'),
			'hint' => tra('use tiki-webdav.php as the URI of the WebDAV repository'),
			'help' => 'WebDAV',
			'type' => 'flag',
			'tags' => array('experimental'),
			'dependencies' => array(
				'feature_file_galleries',
			),
			'extensions' => array(
				'libxml',
			),
			'default' => 'n',
		),
		'feature_fixed_width' => array(
			'name' => tra('Fixed width'),
            'description' => tra('Sets the width of the site contents display.'),
			'type' => 'flag',
			'tags' => array('basic'),
			'default' => 'y',
		),
		'feature_socialnetworks' => array(
			'name' => tra('Social networks'),
			'description' => tra('Integration with social applications and networks like Twitter and Facebook'),
			'help' => 'Social+Networks',
			'type' => 'flag',
			'keywords' => 'social networks',
			'default' => 'n',
		),
		'feature_group_transition' => array(
			'name' => tra('Group Transition'),
			'description' => tra('Enables transitions for users between different groups. Transitions will create a user approval workflow.'),
			'type' => 'flag',
			'help' => 'Group+Transitions',
			'default' => 'n',
			'view' => 'tiki-admin_transitions.php',
			'permission' => array(
				'permType' => 'transition',
			),
		),
		'feature_category_transition' => array(
			'name' => tra('Category Transition'),
			'description' => tra('Enables transitions for objects between different categories. Transitions will create a document workflow.'),
			'type' => 'flag',
			'help' => 'Category+Transitions',
			'default' => 'n',
			'view' => 'tiki-admin_transitions.php',
			'permission' => array(
				'permType' => 'transition',
			),
		),
		'feature_credits' => array(
			'name' => tra('Tiki User Credits'),
			'description' => tra('Tiki User Credits'),
			'type' => 'flag',
			'help' => 'Tiki+User+Credits',
			'default' => 'n',
			'view' => 'tiki-admin_credits.php',
		),
		'feature_invite' => array(
			'name' => tra('Invite users'),
			'description' => tra('Allow users to invite new users by mail to register at this site'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_alternate_registration_page' => array(
			'name' => tra('Alternate registration page'),
			'description' => tra('Redirects requests for tiki-register.php to an alternate registration page.'),
			'type' => 'text',
			'default' => 'tiki-register.php',
		),
		'feature_loadbalancer' => array(
			'name' => tra('Load balancer'),
				'description' => tra('Activate this only if the server is behind a load balancer (or reverse proxy). This enables logging the IP of the user rather than the IP of the proxy server'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_port_rewriting' => array(
			'name' => tra('Tiki is behind a frontend-proxy/load-balancer that rewrites ports'),
				'description' => tra('Activate this only if the server is behind a frontend-proxy/load-balancer (or reverse proxy) that rewrites ports. This enables Tiki to use the HTTP_X_FORWARDED_PROTO parameter set by the proxy, to provide correct links.'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_accounting' => array(
			'name' => tra('Accounting'),
			'description' => tra('Double-entry accounting system'),
			'help' => 'Accounting',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-accounting_books.php',
			'tags' => array('experimental'),
		),
		'feature_syntax_highlighter' => array(
			'name' => tra('Syntax highlighter (CodeMirror)'),
            'description' => tra('Enables syntax highlighting provided by CodeMirror'),
			'type' => 'flag',
			'help' => 'Syntax+Highlighter',
			'keywords' => 'Code Mirror Syntax Highlighter',
			'default' => 'n',
			'tags' => array('experimental'),			
		),
		'feature_syntax_highlighter_theme' => array(
			'name' => tra('Syntax highlighter (CodeMirror) Theme'),
            'description' => tra('CodeMirror themes (clear cache after changing)'),
			'help' => 'Syntax+Highlighter',
			'type' => 'list',
			'tags' => array('experimental'),
			'dependencies' => array(
				'feature_syntax_highlighter',
			),
			'options' => array(
				'default' => tra('default'),
				'off' => tra('Off (but switchable)'),
                "3024-day" => "3024-day",
                "3024-night" => "3024-night",
                "ambiance" => "ambiance",
                "ambiance-mobile" => "ambiance-mobile",
                "base16-dark" => "base16-dark",
                "base16-light" => "base16-light",
                "blackboard" => "blackboard",
                "cobalt" => "cobalt",
                "eclipse" => "eclipse",
                "elegant" => "elegant",
                "erlang-dark" => "erlang-dark",
                "lesser-dark" => "lesser-dark",
                "mbo" => "mbo",
                "midnight" => "midnight",
                "monokai" => "monokai",
                "neat" => "neat",
                "night" => "night",
                "paraiso-dark" => "paraiso-dark",
                "paraiso-light" => "paraiso-light",
                "rubyblue" => "rubyblue",
                "solarized" => "solarized",
                "the-matrix" => "the-matrix",
                "tomorrow-night-eighties" => "tomorrow-night-eighties",
                "twilight" => "twilight",
                "vibrant-ink" => "vibrant-ink",
                "xq-dark" => "xq-dark",
                "xq-light" => "xq-light",
			),
			'default' => 'off',
		),
        'feature_wikilingo' => array(
            'name' => tra('wikiLingo'),
            'description' => tra('A wiki content platform'),
            'type' => 'flag',
            'help' => 'wikiLingo',
            'keywords' => 'parser',
            'default' => 'n',
            'warning' => tra('Experimental'),
            'tags' => array('experimental'),
        ),
		'feature_dummy' => array(
			'name' => tra('Dummy preference'),
            'description' => tra('This is useful for developers to learn how to create a new preference.'),
			'type' => 'text',
			'size' => '15',
			'help' => 'Preferences',
			'helpurl' => 'PreferencesURLtest', // 2011-08-28 ML: what does this do?
			'keywords' => 'test bogus bogusorama',
			'default' => 'This is the default value of this preference.',
			'detail' => tra('This is the detail.'),
			'warning' => tra('This is the warning.'),
			'hint' => tra('This is the hint.'),
			'shorthint' => tra('This is the shorthint.'),
			'tags' => array(
				'experimental',
				),
			'view' => 'tiki-listpages.php',
			'plugin' => 'blog',
			'dependencies' => array(
				'feature_wiki',
			),
			'extensions' => array(
				'zlib',
			),
			'module' => 'blog',
			'permission' => array(
				'permType' => 'blog',
			),
			'admin' => 'blogs',
			'perspective' => false,
		),
		'feature_time_sheet' => array(
			'name' => tra('Time Sheet'),
            'description' => tra('A project time manager'),
			'type' => 'flag',
			'help' => 'TimeSheet',
			'keywords' => 'timesheet time sheet project',
			'default' => 'n',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),
		),
		'feature_htmlfeed' => array(
			'name' => tra('HTML Feed'),
            'description' => tra('A way to transfer HTML content from one Tiki site to another'),
			'type' => 'flag',
			'help' => 'HtmlFeed',
			'keywords' => 'html feed ads ad share',
			'default' => 'n',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),
		),
		'feature_futurelinkprotocol' => array(
			'name' => tra('FutureLink-Protocol'),
            'description' => tra('A Dynamic Compendia'),
			'type' => 'flag',
			'help' => 'FutureLinkProtocol',
			'keywords' => 'future link futurelink share feed',
			'default' => 'n',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),
		),
		'feature_jcapture' => array(
			'name' => tra('jCapture Screencast'),
            'description' => tra('Use jCapture applet to create screencasts and capture screenshots, store them in a file gallery, and show them directly in a wiki page'),
			'type' => 'flag',
			'help' => 'jCapture',
			'default' => 'n',				// include UI lib for more effects
			'dependencies' => array(
				'auth_token_access',
				'feature_file_galleries',
			),
		),
		'feature_community_send_mail_join' => array(
			'name' => tra('Send an email notification to group leaders when a user joins'),
			'type' => 'flag',
			'help' => 'User+Preferences',
			'default' => 'n',
		),
		'feature_community_send_mail_leave' => array(
			'name' => tra('Send an email notification to group leaders when a user leaves'),
			'type' => 'flag',
			'help' => 'User+Preferences',
			'default' => 'n',
		),
		'feature_inline_comments' => array(
			'name' => tra('Inline Comments'),
			'description' => tra('Enable/disable inline comments.'),
			'dependencies' => array(
				'feature_wiki_comments',
				'feature_wiki_paragraph_formatting',
			),
			'type' => 'flag',
			'default' => 'n',
			'help' => 'Inline+comments',
		),
		'feature_hidden_links' => array(
			'name' => tra('Display hidden anchor on mouseover of headings'),
			'description' => tra('This is useful for sharing the URL to an exact location on a page.'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('advanced'),
		),
		'feature_equal_height_rows_js' => array(
			'name' => tra('Enable JavaScript Plugin for Equal-Height Rows'),
			'description' => tra('This allows responsive rows to be set so that each contained element has the same height '),
			'type' => 'flag',
			'default' => 'n',
			'help' => "https://github.com/Sam152/Javascript-Equal-Height-Responsive-Rows",
			'tags' => array('advanced'),
		),
		'feature_theme_control_savesession' => array(
			'name' => tra('Store session variable for current theme'),
			'description' => tra('Store a session variable for current theme so that it can  be used for auto-selecting a category when categorizing'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_theme_control_parentcategory' => array(
			'name' => tra('Parent category of theme control categories'),
			'description' => tra('Choose the parent category of categories used for theme control'),
			'type' => 'list',
			'options' => $catlist,
			'dependencies' => array(
				'feature_categories',
			),
			'default' => 'n',
		),
		'feature_theme_control_autocategorize' => array(
			'name' => tra('Automatically select the theme-control category of the current theme when categorizing'),
			'description' => tra('When creating or editing an object, automatically select the category that matches the theme-control category of the current theme'),
			'type' => 'flag',
			'dependencies' => array('feature_theme_control_savesession', 'feature_theme_control_parentcategory'),
			'default' => 'n',
		),
		'feature_lang_nonswitchingpages' => array(
			'name' => tra('List of names of pages that always redirect to the homepage when the language is switched'),
			'description' => tra('List of names of pages that always redirect to the homepage when the language is switched'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_lang_nonswitchingpages_names' => array(
			'name' => tra('Multiple page names may be entered, separated by commas'),
			'description' => tra('List of names of pages that always redirect to the homepage when the language is switched'),
			'type' => 'textarea',
			'default' => 'n',
		),
		'feature_wizard_user' => array(
			'name' => tra('User Wizard'),
			'description' => tra('Wizard to help users set up their basic settings and account details'),
			'help' => 'User+Wizard',
			'type' => 'flag',
			'default' => 'n',
		),		
		'feature_userWizardDifferentUsersFieldIds' => array(
			'name' => tra('Present different input fields in the User Wizard than are in the Registration form'),
			'description' => tra('Ask a different set of fields for the User Details section in the User Wizard than the ones shown in the Registration form'),
			'help' => 'User+Wizard',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_userWizardUsersFieldIds' => array(
			'name' => tra('Tracker fields presented in the User Wizard as User Details'),
			'description' => tra('User\'s information tracker fields presented in the User Wizard as User Details (separate fieldIds with colons)'),
			'help' => 'User+Wizard',
			'type' => 'text',
			'size' => '50',
			'dependencies' => array(
				'userTracker',
				'feature_wizard_user',
			),
			'default' => '',
		),						
	);
}
